/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity.ssh;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import io.xpipe.app.issue.ErrorAction;
import io.xpipe.app.issue.ErrorEvent;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandControl;
import io.xpipe.app.process.CommandSupport;
import io.xpipe.app.process.LocalShell;
import io.xpipe.app.process.ProcessOutputException;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public class SshIdentityStateManager {
    private static RunningAgent runningAgent;

    private static boolean checkNamedPipeExists(Path path) {
        Memory p = new Memory((long)WinBase.WIN32_FIND_DATA.sizeOf());
        WinNT.HANDLE r = Kernel32.INSTANCE.FindFirstFile(path.toString(), (Pointer)p);
        if (!WinBase.INVALID_HANDLE_VALUE.equals((Object)r)) {
            Kernel32.INSTANCE.FindClose(r);
            return true;
        }
        return false;
    }

    private static void stopWindowsAgents(boolean openssh, boolean gpg, boolean external) throws Exception {
        Path pipePath = Path.of("\\\\.\\pipe\\openssh-ssh-agent", new String[0]);
        if (!SshIdentityStateManager.checkNamedPipeExists(pipePath)) {
            return;
        }
        try (ShellControl sc = LocalShell.getShell().start();){
            String gpgList = sc.executeSimpleStringCommand("TASKLIST /FI \"IMAGENAME eq gpg-agent.exe\"");
            boolean gpgRunning = gpgList.contains("gpg-agent.exe");
            String opensshList = sc.executeSimpleStringCommand("TASKLIST /FI \"IMAGENAME eq ssh-agent.exe\"");
            boolean opensshRunning = opensshList.contains("ssh-agent.exe");
            if (external && !gpgRunning && !opensshRunning) {
                throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("An external password manager agent is running, but XPipe requested to use another SSH agent. You have to disable the password manager agent first."));
            }
            if (gpg && gpgRunning) {
                sc.executeSimpleCommand(CommandBuilder.of().add(new String[]{"gpg-connect-agent", "killagent", "/bye"}));
            }
            if (openssh && opensshRunning) {
                String msg = "The Windows OpenSSH agent is running. This will cause it to interfere with other agents. You have to manually stop the running ssh-agent service to allow other agents to work";
                final AtomicBoolean r = new AtomicBoolean();
                ErrorEvent.ErrorEventBuilder event = ErrorEventFactory.fromMessage((String)msg).expected();
                ErrorAction shutdown = new ErrorAction(){

                    public String getName() {
                        return "Shut down ssh-agent service";
                    }

                    public String getDescription() {
                        return "Stop the agent service as an administrator";
                    }

                    public boolean handle(ErrorEvent event) {
                        r.set(true);
                        return true;
                    }
                };
                event.customAction(shutdown).handle();
                if (r.get()) {
                    if (sc.getShellDialect() == ShellDialects.CMD) {
                        sc.command("powershell -Command \"Start-Process cmd -Wait -ArgumentList /c, sc, stop, ssh-agent -Verb runAs\"").executeAndCheck();
                    } else {
                        sc.command("powershell -Command \"Start-Process cmd -Wait -ArgumentList /c, sc, stop, ssh-agent -Verb runAs\"").executeAndCheck();
                    }
                }
            }
        }
    }

    private static void checkLocalAgentIdentities(String socketEvn) throws Exception {
        try (ShellControl sc = LocalShell.getShell().start();){
            SshIdentityStateManager.checkAgentIdentities(sc, socketEvn);
        }
    }

    public static synchronized void checkAgentIdentities(ShellControl sc, String authSock) throws Exception {
        Optional found = sc.view().findProgram("ssh-add");
        if (found.isEmpty()) {
            throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("SSH agent tool ssh-add not found in PATH. Is the SSH agent correctly installed?"));
        }
        try (CommandControl c = sc.command(CommandBuilder.of().add(new String[]{"ssh-add", "-l"}).fixedEnvironment("SSH_AUTH_SOCK", authSock)).start();){
            String[] r = c.readStdoutAndStderr();
            if (c.getExitCode() != 0L) {
                String posixMessage = sc.getOsType() != OsType.WINDOWS ? (authSock != null ? " and the socket " + authSock : " and the SSH agent socket in the settings menu") : "";
                IllegalStateException ex = new IllegalStateException("Unable to list agent identities via command ssh-add -l:\n" + r[0] + "\n" + r[1] + "\nPlease check your SSH agent configuration%s.".formatted(posixMessage));
                ErrorEvent.ErrorEventBuilder eventBuilder = ErrorEventFactory.fromThrowable((Throwable)ex).expected();
                ErrorEventFactory.preconfigure((ErrorEvent.ErrorEventBuilder)eventBuilder);
                throw ex;
            }
        }
        catch (ProcessOutputException ex) {
            if (sc.getOsType() == OsType.WINDOWS && ex.getOutput().contains("No such file or directory")) {
                throw ProcessOutputException.withPrefix((String)"Failed to connect to the OpenSSH agent service. Is the Windows OpenSSH feature enabled and the OpenSSH Authentication Agent service running?", (ProcessOutputException)ex);
            }
            throw ex;
        }
    }

    public static synchronized void prepareLocalExternalAgent() throws Exception {
        if (runningAgent == RunningAgent.EXTERNAL_AGENT) {
            return;
        }
        if (OsType.ofLocal() == OsType.WINDOWS) {
            SshIdentityStateManager.stopWindowsAgents(true, true, false);
            Path pipePath = Path.of("\\\\.\\pipe\\openssh-ssh-agent", new String[0]);
            boolean pipeExists = SshIdentityStateManager.checkNamedPipeExists(pipePath);
            if (!pipeExists) {
                throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("An external password manager agent is set for this connection, but no external SSH agent is running. Make sure that the agent is started in your password manager"));
            }
        }
        SshIdentityStateManager.checkLocalAgentIdentities(null);
        runningAgent = RunningAgent.EXTERNAL_AGENT;
    }

    public static synchronized void prepareLocalGpgAgent() throws Exception {
        if (runningAgent == RunningAgent.GPG_AGENT) {
            return;
        }
        try (ShellControl sc = LocalShell.getShell().start();){
            Object content;
            FilePath dir;
            CommandSupport.isInPathOrThrow((ShellControl)sc, (String)"gpg-connect-agent", (String)"GPG connect agent executable", null);
            if (sc.getOsType() == OsType.WINDOWS) {
                FilePath appdata;
                SshIdentityStateManager.stopWindowsAgents(true, false, true);
                dir = appdata = FilePath.of((String)sc.view().getEnvironmentVariableOrThrow("APPDATA")).join(new String[]{"gnupg"});
            } else {
                dir = sc.view().userHome().join(new String[]{".gnupg"});
            }
            sc.view().mkdir(dir);
            FilePath confFile = dir.join(new String[]{"gpg-agent.conf"});
            Object object = content = sc.view().fileExists(confFile) ? sc.view().readTextFile(confFile) : "";
            if (sc.getOsType() == OsType.WINDOWS) {
                if (!((String)content).contains("enable-win32-openssh-support")) {
                    content = (String)content + "\nenable-win32-openssh-support\n";
                    sc.view().writeTextFile(confFile, (String)content);
                }
                SshIdentityStateManager.stopWindowsAgents(true, true, false);
                sc.command(CommandBuilder.of().add(new String[]{"gpg-connect-agent", "/bye"})).execute();
                SshIdentityStateManager.checkLocalAgentIdentities(null);
            } else {
                if (!((String)content).contains("enable-ssh-support")) {
                    content = (String)content + "\nenable-ssh-support\n";
                    sc.view().writeTextFile(confFile, (String)content);
                    sc.executeSimpleCommand(CommandBuilder.of().add(new String[]{"gpg-connect-agent", "reloadagent", "/bye"}));
                } else {
                    sc.executeSimpleCommand(CommandBuilder.of().add(new String[]{"gpg-connect-agent", "/bye"}));
                }
                String socketEnv = sc.command("gpgconf --list-dirs agent-ssh-socket").readStdoutOrThrow();
                SshIdentityStateManager.checkLocalAgentIdentities(socketEnv);
            }
        }
        runningAgent = RunningAgent.GPG_AGENT;
    }

    public static synchronized void prepareLocalOpenSshAgent(ShellControl sc, FilePath socket) throws Exception {
        if (runningAgent == RunningAgent.SSH_AGENT) {
            return;
        }
        if (sc.getOsType() == OsType.WINDOWS) {
            CommandSupport.isInPathOrThrow((ShellControl)sc, (String)"ssh-agent", (String)"SSH Agent", null);
            SshIdentityStateManager.stopWindowsAgents(false, true, true);
            sc.executeSimpleBooleanCommand("ssh-agent start");
            SshIdentityStateManager.checkLocalAgentIdentities(null);
        } else {
            SshIdentityStateManager.checkLocalAgentIdentities(socket != null ? socket.resolveTildeHome(sc.view().userHome()).toString() : null);
        }
        runningAgent = RunningAgent.SSH_AGENT;
    }

    public static synchronized void prepareLocalCustomAgent(ShellControl sc, FilePath socket) throws Exception {
        if (runningAgent == RunningAgent.CUSTOM_AGENT) {
            return;
        }
        if (sc.getOsType() == OsType.WINDOWS) {
            CommandSupport.isInPathOrThrow((ShellControl)sc, (String)"ssh-agent", (String)"SSH Agent", null);
            SshIdentityStateManager.stopWindowsAgents(false, true, true);
            sc.executeSimpleBooleanCommand("ssh-agent start");
            SshIdentityStateManager.checkLocalAgentIdentities(null);
        } else {
            SshIdentityStateManager.checkLocalAgentIdentities(socket != null ? socket.resolveTildeHome(sc.view().userHome()).toString() : null);
        }
        runningAgent = RunningAgent.CUSTOM_AGENT;
    }

    private static enum RunningAgent {
        SSH_AGENT,
        CUSTOM_AGENT,
        GPG_AGENT,
        EXTERNAL_AGENT;

    }
}

