/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.comp.Comp;
import io.xpipe.app.comp.base.ButtonComp;
import io.xpipe.app.comp.base.HorizontalComp;
import io.xpipe.app.comp.base.TextFieldComp;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.platform.BindingsHelper;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.platform.Validator;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.core.FilePath;
import io.xpipe.core.KeyValue;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.identity.ssh.SshIdentityStateManager;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategyChoiceConfig;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import lombok.Generated;
import org.kordamp.ikonli.javafx.FontIcon;

@JsonTypeName(value="customAgent")
@JsonDeserialize(builder=CustomAgentStrategyBuilder.class)
public final class CustomAgentStrategy
implements SshIdentityStrategy {
    private final boolean forwardAgent;
    private final String publicKey;

    public static OptionsBuilder createOptions(Property<CustomAgentStrategy> p, SshIdentityStrategyChoiceConfig config) {
        SimpleBooleanProperty forward = new SimpleBooleanProperty(p.getValue() != null && ((CustomAgentStrategy)p.getValue()).isForwardAgent());
        SimpleStringProperty publicKey = new SimpleStringProperty(p.getValue() != null ? ((CustomAgentStrategy)p.getValue()).getPublicKey() : null);
        ObservableValue socket = AppPrefs.get().sshAgentSocket();
        ObservableValue socketBinding = BindingsHelper.map((ObservableValue)socket, s -> s != null ? s.toString() : AppI18n.get((String)"agentSocketNotConfigured", (Object[])new Object[0]));
        SimpleStringProperty socketProp = new SimpleStringProperty();
        socketProp.bind(socketBinding);
        Comp socketDisplay = new HorizontalComp(List.of(new TextFieldComp((Property)socketProp).apply(struc -> ((TextField)struc.get()).setEditable(false)).hgrow(), new ButtonComp(null, (Node)new FontIcon("mdomz-settings"), () -> AppPrefs.get().selectCategory("ssh")).padding(new Insets(7.0)).grow(false, true))).spacing(9.0);
        return new OptionsBuilder().nameAndDescription("agentSocket").addComp(socketDisplay).check(val -> Validator.create((Validator)val, (ObservableValue)AppI18n.observable((String)"agentSocketNotConfigured", (Object[])new Object[0]), (ObservableValue)AppPrefs.get().sshAgentSocket(), i -> i != null)).nameAndDescription("forwardAgent").addToggle((Property)forward).nonNull().hide(!config.isAllowAgentForward()).nameAndDescription("publicKey").addComp(new TextFieldComp((Property)publicKey).apply(struc -> ((TextField)struc.get()).setPromptText("ssh-rsa AAAAB3NzaC1yc2EAAAABJQAAAIBmhLUTJiP...== Your Comment")), (Property)publicKey).bind(() -> new CustomAgentStrategy(forward.get(), publicKey.get()), new Property[]{p});
    }

    @Override
    public void prepareParent(ShellControl parent) throws Exception {
        if (parent.isLocal()) {
            SshIdentityStateManager.prepareLocalCustomAgent(parent, (FilePath)AppPrefs.get().sshAgentSocket().getValue());
        }
    }

    @Override
    public void buildCommand(CommandBuilder builder) {
        builder.environment("SSH_AUTH_SOCK", sc -> {
            FilePath socket;
            if (sc.getOsType() == OsType.WINDOWS) {
                return null;
            }
            if (AppPrefs.get() != null && (socket = (FilePath)AppPrefs.get().sshAgentSocket().getValue()) != null) {
                return socket.resolveTildeHome(sc.view().userHome()).toString();
            }
            return null;
        });
    }

    @Override
    public List<KeyValue> configOptions() {
        Optional<FilePath> file = SshIdentityStrategy.getPublicKeyPath(this.publicKey);
        return List.of(new KeyValue("IdentitiesOnly", file.isPresent() ? "yes" : "no"), new KeyValue("ForwardAgent", this.forwardAgent ? "yes" : "no"), new KeyValue("IdentityFile", file.isPresent() ? file.get().toString() : "none"), new KeyValue("PKCS11Provider", "none"));
    }

    @Generated
    CustomAgentStrategy(boolean forwardAgent, String publicKey) {
        this.forwardAgent = forwardAgent;
        this.publicKey = publicKey;
    }

    @Generated
    public static CustomAgentStrategyBuilder builder() {
        return new CustomAgentStrategyBuilder();
    }

    @Generated
    public boolean isForwardAgent() {
        return this.forwardAgent;
    }

    @Generated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomAgentStrategy)) {
            return false;
        }
        CustomAgentStrategy other = (CustomAgentStrategy)o;
        if (this.isForwardAgent() != other.isForwardAgent()) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        return !(this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForwardAgent() ? 79 : 97);
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CustomAgentStrategy(forwardAgent=" + this.isForwardAgent() + ", publicKey=" + this.getPublicKey() + ")";
    }

    @JsonTypeName(value="customAgent")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class CustomAgentStrategyBuilder {
        @Generated
        private boolean forwardAgent;
        @Generated
        private String publicKey;

        @Generated
        CustomAgentStrategyBuilder() {
        }

        @Generated
        public CustomAgentStrategyBuilder forwardAgent(boolean forwardAgent) {
            this.forwardAgent = forwardAgent;
            return this;
        }

        @Generated
        public CustomAgentStrategyBuilder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Generated
        public CustomAgentStrategy build() {
            return new CustomAgentStrategy(this.forwardAgent, this.publicKey);
        }

        @Generated
        public String toString() {
            return "CustomAgentStrategy.CustomAgentStrategyBuilder(forwardAgent=" + this.forwardAgent + ", publicKey=" + this.publicKey + ")";
        }
    }
}

