/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.host;

import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.hub.action.HubBranchProvider;
import io.xpipe.app.hub.action.HubLeafProvider;
import io.xpipe.app.hub.action.HubMenuItemProvider;
import io.xpipe.app.hub.action.StoreActionCategory;
import io.xpipe.app.platform.LabelGraphic;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.ext.base.host.HostAddressSwitchStore;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;

public class HostAddressSwitchBranchProvider
implements HubBranchProvider<HostAddressSwitchStore> {
    public List<HubMenuItemProvider<?>> getChildren(DataStoreEntryRef<HostAddressSwitchStore> store) {
        return ((HostAddressSwitchStore)store.getStore()).getHostAddress().getAvailable().stream().map(s -> new HostAddressProvider(s.equals(((HostAddressSwitchStore)store.getStore()).getHostAddress().get()), (String)s)).collect(Collectors.toList());
    }

    public StoreActionCategory getCategory() {
        return StoreActionCategory.CONFIGURATION;
    }

    public boolean isApplicable(DataStoreEntryRef<HostAddressSwitchStore> o) {
        return ((HostAddressSwitchStore)o.getStore()).getHostAddress() != null && !((HostAddressSwitchStore)o.getStore()).getHostAddress().isSingle();
    }

    public ObservableValue<String> getName(DataStoreEntryRef<HostAddressSwitchStore> store) {
        return AppI18n.observable((String)"switchHostAddress", (Object[])new Object[0]);
    }

    public LabelGraphic getIcon(DataStoreEntryRef<HostAddressSwitchStore> store) {
        return new LabelGraphic.IconGraphic("mdi2f-format-list-group");
    }

    public Class<HostAddressSwitchStore> getApplicableClass() {
        return HostAddressSwitchStore.class;
    }

    private static class HostAddressProvider
    implements HubLeafProvider<HostAddressSwitchStore> {
        private final boolean active;
        private final String address;

        private HostAddressProvider(boolean active, String address) {
            this.active = active;
            this.address = address;
        }

        public void execute(DataStoreEntryRef<HostAddressSwitchStore> ref) {
            Optional<HostAddressSwitchStore> newStore = ((HostAddressSwitchStore)ref.getStore()).withAddress(this.address);
            if (newStore.isPresent()) {
                DataStorage.get().updateEntryStore(ref.get(), (DataStore)newStore.get());
            }
        }

        public ObservableValue<String> getName(DataStoreEntryRef<HostAddressSwitchStore> store) {
            return new ReadOnlyStringWrapper(this.address);
        }

        public LabelGraphic getIcon(DataStoreEntryRef<HostAddressSwitchStore> store) {
            return this.active ? new LabelGraphic.IconGraphic("mdi2a-arrow-right") : LabelGraphic.none();
        }

        public Class<HostAddressSwitchStore> getApplicableClass() {
            return HostAddressSwitchStore.class;
        }
    }
}

