/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.desktop;

import io.xpipe.app.browser.BrowserFullSessionModel;
import io.xpipe.app.comp.Comp;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreCreationCategory;
import io.xpipe.app.ext.DataStoreProvider;
import io.xpipe.app.ext.DataStoreUsageCategory;
import io.xpipe.app.ext.GuiDialog;
import io.xpipe.app.hub.comp.StoreChoiceComp;
import io.xpipe.app.hub.comp.StoreEntryWrapper;
import io.xpipe.app.hub.comp.StoreViewState;
import io.xpipe.app.hub.comp.SystemStateComp;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.core.FailableRunnable;
import io.xpipe.ext.base.desktop.DesktopApplicationStore;
import io.xpipe.ext.base.desktop.DesktopBaseStore;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;

public class DesktopApplicationStoreProvider
implements DataStoreProvider {
    public DocumentationLink getHelpLink() {
        return DocumentationLink.DESKTOP_APPLICATIONS;
    }

    public FailableRunnable<Exception> launch(DataStoreEntry store) {
        return () -> {
            DesktopApplicationStore s = (DesktopApplicationStore)store.getStore().asNeeded();
            DataStoreEntry baseEntry = s.getDesktop().get();
            FailableRunnable baseActivate = baseEntry.getProvider().activateAction(baseEntry);
            if (baseActivate != null) {
                baseActivate.run();
            }
            ((DesktopBaseStore)s.getDesktop().getStore()).runDesktopApplication(store.getName(), s);
        };
    }

    public FailableRunnable<Exception> launchBrowser(BrowserFullSessionModel sessionModel, DataStoreEntry store, BooleanProperty busy) {
        return this.launch(store);
    }

    public DataStoreCreationCategory getCreationCategory() {
        return DataStoreCreationCategory.DESKTOP;
    }

    public DataStoreUsageCategory getUsageCategory() {
        return DataStoreUsageCategory.DESKTOP;
    }

    public DataStoreEntry getDisplayParent(DataStoreEntry store) {
        DesktopApplicationStore s = (DesktopApplicationStore)store.getStore().asNeeded();
        return s.getDesktop().get();
    }

    public GuiDialog guiDialog(DataStoreEntry entry, Property<DataStore> store) {
        DesktopApplicationStore st = (DesktopApplicationStore)store.getValue();
        SimpleObjectProperty host = new SimpleObjectProperty(st.getDesktop());
        SimpleStringProperty path = new SimpleStringProperty(st.getPath());
        SimpleStringProperty args = new SimpleStringProperty(st.getArguments() != null ? st.getArguments() : null);
        return new OptionsBuilder().nameAndDescription("desktopBase").addComp((Comp)new StoreChoiceComp(StoreChoiceComp.Mode.HOST, entry, (Property)host, DesktopBaseStore.class, desktopStoreDataStoreEntryRef -> ((DesktopBaseStore)desktopStoreDataStoreEntryRef.getStore()).supportsDesktopAccess(), StoreViewState.get().getAllConnectionsCategory()), (Property)host).nonNull().nameAndDescription("desktopApplicationPath").addString((Property)path).nonNull().nameAndDescription("desktopApplicationArguments").addString((Property)args).bind(() -> ((DesktopApplicationStore.DesktopApplicationStoreBuilder)((DesktopApplicationStore.DesktopApplicationStoreBuilder)((DesktopApplicationStore.DesktopApplicationStoreBuilder)DesktopApplicationStore.builder().desktop((DataStoreEntryRef<DesktopBaseStore>)((DataStoreEntryRef)host.get()))).path(path.get())).arguments(args.get())).build(), new Property[]{store}).buildDialog();
    }

    public String getDisplayIconFileName(DataStore store) {
        return "base:desktopApplication_icon.svg";
    }

    public DataStore defaultStore(DataStoreCategory category) {
        return DesktopApplicationStore.builder().build();
    }

    public String getId() {
        return "desktopApplication";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(DesktopApplicationStore.class);
    }

    public Comp<?> stateDisplay(StoreEntryWrapper w) {
        return new SystemStateComp(SystemStateComp.State.SUCCESS);
    }

    public String summaryString(StoreEntryWrapper wrapper) {
        DesktopApplicationStore st = (DesktopApplicationStore)wrapper.getEntry().getStore();
        return st.getPath() + (String)(st.getArguments() != null ? " " + st.getArguments() : "");
    }
}

