/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.desktop;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.base.desktop.DesktopBaseStore;
import lombok.Generated;

@JsonTypeName(value="desktopApplication")
@JsonDeserialize(builder=DesktopApplicationStoreBuilderImpl.class)
public final class DesktopApplicationStore
implements DataStore {
    private final DataStoreEntryRef<DesktopBaseStore> desktop;
    private final String path;
    private final String arguments;

    public void checkComplete() throws Throwable {
        Validators.nonNull(this.desktop);
        Validators.isType(this.desktop, DesktopBaseStore.class);
        this.desktop.checkComplete();
        Validators.nonNull((Object)this.path);
    }

    public CommandBuilder getFullCommand() {
        CommandBuilder builder = CommandBuilder.of().addFile(this.path).add(new String[]{this.arguments != null ? " " + this.arguments : ""});
        builder = ((DesktopBaseStore)this.desktop.getStore()).getUsedDesktopDialect().launchAsnyc(builder);
        return builder;
    }

    @Generated
    protected DesktopApplicationStore(DesktopApplicationStoreBuilder<?, ?> b) {
        this.desktop = b.desktop;
        this.path = b.path;
        this.arguments = b.arguments;
    }

    @Generated
    public static DesktopApplicationStoreBuilder<?, ?> builder() {
        return new DesktopApplicationStoreBuilderImpl();
    }

    @Generated
    public DataStoreEntryRef<DesktopBaseStore> getDesktop() {
        return this.desktop;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getArguments() {
        return this.arguments;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DesktopApplicationStore)) {
            return false;
        }
        DesktopApplicationStore other = (DesktopApplicationStore)o;
        DataStoreEntryRef<DesktopBaseStore> this$desktop = this.getDesktop();
        DataStoreEntryRef<DesktopBaseStore> other$desktop = other.getDesktop();
        if (this$desktop == null ? other$desktop != null : !this$desktop.equals(other$desktop)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$arguments = this.getArguments();
        String other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !this$arguments.equals(other$arguments));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataStoreEntryRef<DesktopBaseStore> $desktop = this.getDesktop();
        result = result * 59 + ($desktop == null ? 43 : $desktop.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : $arguments.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DesktopApplicationStore(desktop=" + String.valueOf(this.getDesktop()) + ", path=" + this.getPath() + ", arguments=" + this.getArguments() + ")";
    }

    @Generated
    public static abstract class DesktopApplicationStoreBuilder<C extends DesktopApplicationStore, B extends DesktopApplicationStoreBuilder<C, B>> {
        @Generated
        private DataStoreEntryRef<DesktopBaseStore> desktop;
        @Generated
        private String path;
        @Generated
        private String arguments;

        @Generated
        public B desktop(DataStoreEntryRef<DesktopBaseStore> desktop) {
            this.desktop = desktop;
            return this.self();
        }

        @Generated
        public B path(String path) {
            this.path = path;
            return this.self();
        }

        @Generated
        public B arguments(String arguments) {
            this.arguments = arguments;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DesktopApplicationStore.DesktopApplicationStoreBuilder(desktop=" + String.valueOf(this.desktop) + ", path=" + this.path + ", arguments=" + this.arguments + ")";
        }
    }

    @JsonTypeName(value="desktopApplication")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class DesktopApplicationStoreBuilderImpl
    extends DesktopApplicationStoreBuilder<DesktopApplicationStore, DesktopApplicationStoreBuilderImpl> {
        @Generated
        private DesktopApplicationStoreBuilderImpl() {
        }

        @Override
        @Generated
        protected DesktopApplicationStoreBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DesktopApplicationStore build() {
            return new DesktopApplicationStore(this);
        }
    }
}

