/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.vnc;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.browser.BrowserFullSessionModel;
import io.xpipe.app.browser.BrowserStoreSessionTab;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.NetworkTunnelSession;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.SingletonSessionStore;
import io.xpipe.app.ext.UserScopeStore;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.HostHelper;
import io.xpipe.app.util.Validators;
import io.xpipe.app.vnc.VncBaseStore;
import io.xpipe.ext.base.host.AbstractHostStore;
import io.xpipe.ext.base.host.AbstractHostTransformStore;
import io.xpipe.ext.base.host.HostAddressGatewayStore;
import io.xpipe.ext.base.identity.IdentityStore;
import io.xpipe.ext.base.identity.IdentityValue;
import java.util.List;
import lombok.Generated;

@JsonTypeName(value="vncDirect")
@JsonDeserialize(builder=b.class)
public final class a
implements DataStore,
SelfReferentialStore,
SingletonSessionStore<NetworkTunnelSession>,
UserScopeStore,
VncBaseStore,
AbstractHostTransformStore {
    private final DataStoreEntryRef<HostAddressGatewayStore> associatedHost;
    private final DataStoreEntryRef<NetworkTunnelStore> gateway;
    private final String host;
    private final Integer port;
    private final IdentityValue identity;

    public final NetworkTunnelSession newSession() {
        DataStoreEntryRef<NetworkTunnelStore> dataStoreEntryRef = this.getGateway();
        if (dataStoreEntryRef == null) {
            return null;
        }
        int n2 = HostHelper.findRandomOpenPortOnAllLocalInterfaces();
        return ((NetworkTunnelStore)dataStoreEntryRef.getStore()).createTunnelSession(n2, this.port.intValue(), this.host);
    }

    public final Class<?> getSessionClass() {
        return NetworkTunnelSession.class;
    }

    public final void stopSessionIfNeeded() {
        BrowserFullSessionModel browserFullSessionModel = BrowserFullSessionModel.DEFAULT;
        List list = browserFullSessionModel.getSessionEntriesSnapshot();
        list.stream().filter(browserSessionTab -> browserSessionTab instanceof BrowserStoreSessionTab && (browserSessionTab = (BrowserStoreSessionTab)browserSessionTab).getEntry().get() == this.getSelfEntry()).forEach(browserSessionTab -> browserFullSessionModel.closeSync(browserSessionTab));
        super.stopSessionIfNeeded();
    }

    public final String getEffectiveHost() {
        NetworkTunnelSession networkTunnelSession = (NetworkTunnelSession)this.getSession();
        if (networkTunnelSession != null) {
            return "localhost";
        }
        if (this.associatedHost != null) {
            return ((HostAddressGatewayStore)this.associatedHost.getStore()).getHostAddress().get();
        }
        return this.host;
    }

    public final int getEffectivePort() {
        NetworkTunnelSession networkTunnelSession = (NetworkTunnelSession)this.getSession();
        if (networkTunnelSession != null) {
            return networkTunnelSession.getLocalPort();
        }
        return this.port;
    }

    public final boolean isPerUser() {
        return this.identity != null && this.identity.isPerUser();
    }

    public final DataStoreEntryRef<NetworkTunnelStore> getGateway() {
        if (this.associatedHost != null && ((HostAddressGatewayStore)this.associatedHost.getStore()).getGateway() != null) {
            return ((HostAddressGatewayStore)this.associatedHost.getStore()).getGateway();
        }
        return this.gateway;
    }

    public final void checkComplete() {
        if (this.associatedHost != null) {
            this.associatedHost.checkComplete();
        } else {
            Validators.nonNull((Object)this.host);
        }
        Validators.nonNull((Object)this.port);
        Validators.nonNull((Object)this.identity);
        this.identity.checkComplete();
        this.identity.checkCompletePassword();
    }

    public final String retrieveUser() {
        if (this.identity == null) {
            return null;
        }
        IdentityStore identityStore = this.identity.unwrap();
        boolean bl = identityStore.getUsername().hasUser();
        if (!bl) {
            return null;
        }
        return identityStore.getUsername().retrieveUsername();
    }

    public final SecretRetrievalStrategy getPassword() {
        if (this.identity == null) {
            return null;
        }
        IdentityStore identityStore = this.identity.unwrap();
        return identityStore.getPassword();
    }

    public final boolean canConvertToAbstractHost() {
        return this.associatedHost == null;
    }

    public final AbstractHostStore createAbstractHostStore() {
        return AbstractHostStore.builder().host(this.host).gateway(this.gateway).build();
    }

    public final AbstractHostTransformStore withNewParent(DataStoreEntryRef<AbstractHostStore> dataStoreEntryRef) {
        return ((a)((a)((a)this.toBuilder().host(null)).gateway(null)).associatedHost((DataStoreEntryRef<HostAddressGatewayStore>)dataStoreEntryRef.asNeeded())).build();
    }

    @Generated
    protected a(a<?, ?> a2) {
        this.associatedHost = a2.associatedHost;
        this.gateway = a2.gateway;
        this.host = a2.host;
        this.port = a2.port;
        this.identity = a2.identity;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Generated
    public final DataStoreEntryRef<HostAddressGatewayStore> getAssociatedHost() {
        return this.associatedHost;
    }

    @Generated
    public final String getHost() {
        return this.host;
    }

    @Generated
    public final Integer getPort() {
        return this.port;
    }

    @Generated
    public final IdentityValue getIdentity() {
        return this.identity;
    }

    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof a)) {
            return false;
        }
        object = (a)object;
        Object object2 = this.getPort();
        Object object3 = ((a)object).getPort();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getAssociatedHost();
        object3 = ((a)object).getAssociatedHost();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getGateway();
        object3 = ((a)object).getGateway();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getHost();
        object3 = ((a)object).getHost();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getIdentity();
        object = ((a)object).getIdentity();
        return !(object2 == null ? object != null : !object2.equals(object));
    }

    @Generated
    public final int hashCode() {
        Integer n2 = this.getPort();
        int n3 = 59 + (n2 == null ? 43 : ((Object)n2).hashCode());
        Object object = this.getAssociatedHost();
        n3 = n3 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getGateway();
        n3 = n3 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getHost();
        n3 = n3 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getIdentity();
        n3 = n3 * 59 + (object == null ? 43 : object.hashCode());
        return n3;
    }

    @Generated
    public final String toString() {
        return "VncDirectStore(associatedHost=" + String.valueOf(this.getAssociatedHost()) + ", gateway=" + String.valueOf(this.getGateway()) + ", host=" + this.getHost() + ", port=" + this.getPort() + ", identity=" + String.valueOf(this.getIdentity()) + ")";
    }

    @Generated
    public static abstract class a<C extends a, B extends a<C, B>> {
        @Generated
        private DataStoreEntryRef<HostAddressGatewayStore> associatedHost;
        @Generated
        private DataStoreEntryRef<NetworkTunnelStore> gateway;
        @Generated
        private String host;
        @Generated
        private Integer port;
        @Generated
        private IdentityValue identity;

        @Generated
        protected B $fillValuesFrom(C c2) {
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(a a2, a<?, ?> a3) {
            a3.associatedHost(a2.associatedHost);
            a3.gateway(a2.gateway);
            a3.host(a2.host);
            a3.port(a2.port);
            a3.identity(a2.identity);
        }

        @Generated
        public B associatedHost(DataStoreEntryRef<HostAddressGatewayStore> dataStoreEntryRef) {
            this.associatedHost = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B gateway(DataStoreEntryRef<NetworkTunnelStore> dataStoreEntryRef) {
            this.gateway = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B host(String string) {
            this.host = string;
            return this.self();
        }

        @Generated
        public B port(Integer n2) {
            this.port = n2;
            return this.self();
        }

        @Generated
        public B identity(IdentityValue identityValue) {
            this.identity = identityValue;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "VncDirectStore.VncDirectStoreBuilder(associatedHost=" + String.valueOf(this.associatedHost) + ", gateway=" + String.valueOf(this.gateway) + ", host=" + this.host + ", port=" + this.port + ", identity=" + String.valueOf(this.identity) + ")";
        }
    }

    @JsonTypeName(value="vncDirect")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<a, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final a build() {
            return new a(this);
        }
    }
}

