/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.vmware;

import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.util.WindowsRegistry;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;

public enum d {
    PLAYER{

        @Override
        public final String T(ShellControl shellControl) {
            return "VMware Player";
        }

        @Override
        public final String queryVersion(ShellControl shellControl) {
            return "vmrun v1.17.0";
        }

        @Override
        public final FilePath U(ShellControl shellControl) {
            FilePath filePath = shellControl.view().userHome();
            if (shellControl.getOsType() == OsType.WINDOWS) {
                return filePath.join(new String[]{"Documents", "Virtual Machines"});
            }
            return filePath.join(new String[]{"vmware"});
        }

        @Override
        public final FilePath h(ShellControl shellControl, String string) {
            return FilePath.of((String)string).join(new String[]{"vmrun"});
        }

        @Override
        public final String getName() {
            return "VMware Player";
        }

        @Override
        public final String es() {
            return "proc:vmware_player_icon.png";
        }

        @Override
        public final Optional<String> V(ShellControl shellControl) {
            OsType.Any any = shellControl.getOsType();
            Objects.requireNonNull(any);
            OsType.Any any2 = any;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OsType.Windows.class}, (OsType.Any)any, 0)) {
                case 0: {
                    OsType.Windows cfr_ignored_0 = (OsType.Windows)any2;
                    return WindowsRegistry.ofShell((ShellControl)shellControl).readStringValueIfPresent(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\vmplayer.exe", "Path");
                }
            }
            return Optional.empty();
        }
    }
    ,
    WORKSTATION{

        @Override
        public final String T(ShellControl shellControl) {
            return "VMware Workstation";
        }

        @Override
        public final String queryVersion(ShellControl shellControl) {
            return "vmrun v1.17.0";
        }

        @Override
        public final FilePath U(ShellControl shellControl) {
            FilePath filePath = shellControl.view().userHome();
            if (shellControl.getOsType() == OsType.WINDOWS) {
                return filePath.join(new String[]{"Documents", "Virtual Machines"});
            }
            return filePath.join(new String[]{"vmware"});
        }

        @Override
        public final FilePath h(ShellControl shellControl, String string) {
            if (shellControl.getOsType() == OsType.WINDOWS) {
                return FilePath.of((String)string).join(new String[]{"vmrun"});
            }
            return FilePath.of((String)"vmrun");
        }

        @Override
        public final String getName() {
            return "VMware Workstation";
        }

        @Override
        public final String es() {
            return "proc:vmware_workstation_icon.svg";
        }

        @Override
        public final Optional<String> V(ShellControl shellControl) {
            OsType.Any any = shellControl.getOsType();
            Objects.requireNonNull(any);
            OsType.Any any2 = any;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OsType.Linux.class, OsType.Windows.class}, (OsType.Any)any, 0)) {
                case 0: {
                    OsType.Linux cfr_ignored_0 = (OsType.Linux)any2;
                    boolean bl = shellControl.view().isInPath("vmrun", false);
                    if (bl) {
                        return Optional.of("/usr/lib/vmware");
                    }
                    return Optional.empty();
                }
                case 1: {
                    OsType.Windows cfr_ignored_1 = (OsType.Windows)any2;
                    return WindowsRegistry.ofShell((ShellControl)shellControl).readStringValueIfPresent(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\vmware.exe", "Path");
                }
            }
            return Optional.empty();
        }
    }
    ,
    FUSION{

        @Override
        public final String T(ShellControl shellControl) {
            return shellControl.command(CommandBuilder.of().add(new String[]{"defaults", "read"}).addFile("/Applications/VMware Fusion.app/Contents/Info.plist").add(new String[]{"CFBundleName"})).readStdoutOrThrow();
        }

        @Override
        public final String queryVersion(ShellControl shellControl) {
            return "vmrun v" + shellControl.command(CommandBuilder.of().add(new String[]{"defaults", "read"}).addFile("/Applications/VMware Fusion.app/Contents/Info.plist").add(new String[]{"CFBundleShortVersionString"})).readStdoutOrThrow();
        }

        @Override
        public final FilePath U(ShellControl shellControl) {
            return shellControl.view().userHome().join(new String[]{"Virtual Machines.localized"});
        }

        @Override
        public final FilePath h(ShellControl shellControl, String string) {
            return FilePath.of((String)string).join(new String[]{"Contents", "Public", "vmrun"});
        }

        @Override
        public final String getName() {
            return "VMware Fusion";
        }

        @Override
        public final String es() {
            return "proc:vmware_fusion_icon.png";
        }

        @Override
        public final Optional<String> V(ShellControl shellControl) {
            OsType.Any any = shellControl.getOsType();
            Objects.requireNonNull(any);
            OsType.Any any2 = any;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OsType.MacOs.class}, (OsType.Any)any, 0)) {
                case 0: {
                    OsType.MacOs cfr_ignored_0 = (OsType.MacOs)any2;
                    if (shellControl.getShellDialect().directoryExists(shellControl, "/Applications/VMware Fusion.app").executeAndCheck()) {
                        return Optional.of("/Applications/VMware Fusion.app");
                    }
                    return Optional.empty();
                }
            }
            return Optional.empty();
        }
    };


    public abstract String T(ShellControl var1);

    public abstract String queryVersion(ShellControl var1);

    public abstract FilePath U(ShellControl var1);

    public abstract FilePath h(ShellControl var1, String var2);

    public abstract String getName();

    public abstract String es();

    public abstract Optional<String> V(ShellControl var1);
}

