/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.user;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.xpipe.app.comp.Comp;
import io.xpipe.app.core.AppCache;
import io.xpipe.app.core.AppRestart;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.secret.EncryptionToken;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStorageUserHandler;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.core.InPlaceSecretValue;
import io.xpipe.core.JacksonMapper;
import io.xpipe.ext.proc.user.a;
import io.xpipe.ext.proc.user.c;
import io.xpipe.ext.proc.user.f;
import io.xpipe.ext.proc.user.h;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.crypto.SecretKey;
import lombok.Generated;

public final class e
implements DataStorageUserHandler {
    private Path cl;
    private a fc;
    private List<a> fd;
    private boolean fe;

    public static e dw() {
        return (e)DataStorageUserHandler.getInstance();
    }

    public final int getUserCount() {
        if (this.fc != null) {
            return this.fd.size();
        }
        return 0;
    }

    public final void init() {
        this.cl = DataStorage.getStorageDirectory();
        Path path = this.cl.resolve("users.json");
        boolean bl = Files.exists(path, new LinkOption[0]);
        Object object2 = AppPrefs.get().getLockCrypt();
        if (object2.get() != null && !((String)object2.get()).isBlank()) {
            EncryptionToken encryptionToken = EncryptionToken.builder().token((String)object2.get()).build();
            this.fd = new ArrayList<a>();
            this.fd.add(new a("legacy", c.a.builder().encryptedToken(encryptionToken).build()));
            f.dB().g(false);
            return;
        }
        if (!bl) {
            this.fd = new ArrayList<a>();
            f.dB().g(false);
            return;
        }
        try {
            Object object3 = JacksonMapper.getDefault();
            object2 = new TypeReference<ArrayList<a>>(this){
                {
                    Objects.requireNonNull(e2);
                }
            };
            object3 = (ArrayList)object3.readValue(path.toFile(), (TypeReference)object2);
            if (object3 == null) {
                throw new IOException("Unable to read users file json");
            }
            this.fd = new ArrayList<a>((Collection<a>)object3);
            if (this.fd.stream().anyMatch(a2 -> a2 == null)) {
                throw new IOException("User list contains null entry");
            }
            if (this.fd.stream().anyMatch(object -> ((a)object).getAuthMethod() == null || (object = ((a)object).getAuthMethod()) instanceof c.a && ((c.a)(object = (c.a)object)).getEncryptedToken() == null)) {
                throw new IOException("User list contains invalid authentication data");
            }
        }
        catch (IOException iOException) {
            throw new IOException("Unable to read vault users file " + String.valueOf(path) + ". Is it corrupted?", iOException);
        }
        f.dB().g(false);
    }

    public final void save() {
        if (!this.fe) {
            return;
        }
        Object object = this.cl.resolve("users.json");
        if (this.fd.size() == 0 && !Files.exists((Path)object, new LinkOption[0])) {
            return;
        }
        ObjectMapper objectMapper = JacksonMapper.getDefault();
        try {
            Files.createDirectories(object.getParent(), new FileAttribute[0]);
            objectMapper.writeValue(object.toFile(), this.fd);
            this.fe = false;
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            ErrorEventFactory.fromThrowable((Throwable)iOException).handle();
            return;
        }
    }

    public final void login() {
        if (this.fd.size() == 0) {
            return;
        }
        if (this.fd.size() > 1 && !LicenseProvider.get().getFeature("team").isSupported()) {
            return;
        }
        String string = this.fd.size() == 1 ? this.fd.getFirst().getName() : (String)AppCache.getNonNull((String)"lastUser", String.class, () -> null);
        h.e(string, this.fd.size() > 1);
    }

    public final SecretKey getEncryptionKey() {
        if (this.fd.size() == 0) {
            return null;
        }
        if (this.fc == null) {
            return null;
        }
        SecretKey secretKey = this.fc.getAuthMethod().getEncryptionKey();
        return secretKey;
    }

    public final Comp<?> createOverview() {
        Comp<?> comp = f.dB().dC();
        return comp;
    }

    public final String getActiveUser() {
        if (this.fc != null) {
            return this.fc.getName();
        }
        return null;
    }

    public final void a(a a2) {
        this.fd.remove(a2);
        this.fe = true;
        this.fc = null;
        if (a2.getName().equals("legacy")) {
            AppPrefs.get().getLockCrypt().set(null);
        }
        DataStorage.get().forceRewrite();
        AppRestart.restart();
    }

    public final boolean dx() {
        return this.fd.size() == 1 && this.fd.getFirst().getName().equals("legacy");
    }

    public final boolean a(String string, InPlaceSecretValue inPlaceSecretValue) {
        c c2;
        Optional<a> optional = this.fd.stream().filter(a2 -> a2.getName().equals(string)).findFirst();
        if (optional.isEmpty()) {
            return false;
        }
        if (inPlaceSecretValue == null) {
            return false;
        }
        boolean bl = string.equals("legacy");
        if (bl && (c2 = optional.get().getAuthMethod()) instanceof c.a && ((c.a)(c2 = (c.a)c2)).unlockLegacy(inPlaceSecretValue)) {
            this.fc = optional.get();
            AppCache.update((String)"lastUser", (Object)this.fc.getName());
            return true;
        }
        c c3 = optional.get().getAuthMethod();
        if (c3 instanceof c.a && ((c.a)(c3 = (c.a)c3)).unlock(inPlaceSecretValue)) {
            this.fc = optional.get();
            AppCache.update((String)"lastUser", (Object)this.fc.getName());
            return true;
        }
        return false;
    }

    public final void b(String string, InPlaceSecretValue object) {
        if (string == null || string.isBlank() || object == null || object.getSecret().length == 0) {
            return;
        }
        if (this.fd.stream().anyMatch(a2 -> a2.getName().equalsIgnoreCase(string))) {
            return;
        }
        object = new a(string, c.a.ofPassword(object));
        this.fd.add((a)object);
        this.fe = true;
        if (this.fc == null) {
            this.fc = object;
        }
        f.dB().g(true);
        AppCache.update((String)"lastUser", (Object)string);
        this.save();
        if (this.fd.size() == 1 && AppPrefs.get().encryptAllVaultData().get()) {
            DataStorage.get().forceRewrite();
        }
        if (this.fd.size() == 2 && AppPrefs.get().encryptAllVaultData().get()) {
            DataStorage.get().forceRewrite();
        }
    }

    public final void a(InPlaceSecretValue object) {
        if (this.fc == null) {
            return;
        }
        if (object == null) {
            return;
        }
        object = c.a.ofPassword(object);
        this.fc.setAuthMethod((c)object);
        this.fe = true;
        EncryptionToken.invalidateUserToken();
        if (DataStorage.get() != null) {
            DataStorage.get().forceRewrite();
        }
    }

    @Generated
    public final a dy() {
        return this.fc;
    }

    @Generated
    public final List<a> dz() {
        return this.fd;
    }
}

