/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.tailscale;

import com.fasterxml.jackson.databind.JsonNode;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.ext.LocalStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandControl;
import io.xpipe.app.process.CommandView;
import io.xpipe.app.process.CommandViewBase;
import io.xpipe.app.process.ElevationFunction;
import io.xpipe.app.process.LocalShell;
import io.xpipe.app.process.ProcessControl;
import io.xpipe.app.process.ProcessOutputException;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.terminal.TerminalLaunch;
import io.xpipe.app.update.AppDistributionType;
import io.xpipe.app.util.DataStoreFormatter;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.ThreadHelper;
import io.xpipe.core.JacksonMapper;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.proc.tailscale.b;
import io.xpipe.ext.proc.tailscale.d;
import io.xpipe.ext.proc.tailscale.h;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class a
extends CommandViewBase {
    private static boolean dt;

    public a(ShellControl shellControl) {
        super(shellControl);
    }

    private static String e(String string) {
        return string;
    }

    private static Throwable b(Throwable throwable) {
        if (throwable instanceof ProcessOutputException) {
            if ((throwable = (ProcessOutputException)throwable).getOutput().contains("Logged out")) {
                return throwable;
            }
            String string = "Failed to communicate with the tailscale daemon. Is it running? Original error";
            return ProcessOutputException.withPrefix((String)"Failed to communicate with the tailscale daemon. Is it running? Original error", (ProcessOutputException)throwable);
        }
        return throwable;
    }

    private static CommandBuilder bN() {
        CommandBuilder commandBuilder = CommandBuilder.of().add(shellControl -> {
            if (shellControl.getOsType() == OsType.MACOS) {
                return "/Applications/Tailscale.app/Contents/MacOS/Tailscale";
            }
            return "tailscale";
        });
        return commandBuilder;
    }

    protected CommandControl build(Consumer<CommandBuilder> consumer) {
        if (!dt && AppDistributionType.get() == AppDistributionType.WEBTOP) {
            boolean bl = LocalShell.getShell().command(CommandBuilder.of().add(new String[]{"test", "-e"}).addFile("/dev/net/tun")).executeAndCheck();
            if (!bl) {
                DocumentationLink.WEBTOP_TUN.open();
            } else {
                ShellControl shellControl = LocalShell.getShell().command(CommandBuilder.of().add(new String[]{"tailscale", "status"})).readStdoutAndStderr();
                if (shellControl[1].contains("failed to connect to local tailscaled")) {
                    shellControl = new LocalStore().shellFunction().control().subShell(ShellDialects.SH);
                    shellControl.elevated(ElevationFunction.elevated((String)"tailscale"));
                    shellControl = shellControl.start();
                    try {
                        CommandBuilder commandBuilder = shellControl.getShellDialect().launchAsnyc(CommandBuilder.of().add(new String[]{"tailscaled", "--state=tailscaled.state"}));
                        shellControl.command(commandBuilder).execute();
                        ThreadHelper.sleep((long)1000L);
                    }
                    finally {
                        if (shellControl != null) {
                            shellControl.close();
                        }
                    }
                }
            }
            dt = true;
        }
        CommandBuilder commandBuilder = a.bN();
        consumer.accept(commandBuilder);
        return this.shellControl.command(commandBuilder).withErrorFormatter(a::e).withExceptionConverter(a::b).elevated(ElevationFunction.ifNotRoot((ElevationFunction)ElevationFunction.elevated((String)"tailscale")));
    }

    public a dm() {
        this.shellControl.start();
        return this;
    }

    public boolean N() {
        return this.shellControl.command(a.bN().add(new String[]{"--help"})).withErrorFormatter(a::e).withExceptionConverter(a::b).executeAndCheck();
    }

    public String X() {
        String string = this.shellControl.command(a.bN().add(new String[]{"version"})).withErrorFormatter(a::e).withExceptionConverter(a::b).readStdoutOrThrow();
        string = string.lines().findFirst().orElse("?");
        return "tailscale v" + string;
    }

    public boolean bP() {
        String[] stringArray = this.build(commandBuilder -> commandBuilder.add(new String[]{"status"})).readStdoutAndStderr();
        return stringArray[0].contains("Logged out");
    }

    public List<DataStoreEntryRef<h>> q(DataStoreEntryRef<d> commandControl) {
        Iterator iterator = this.build(commandBuilder -> commandBuilder.add(new String[]{"switch", "--list"})).readStdoutOrThrow();
        iterator = ((String)((Object)iterator)).lines().skip(1L).toList();
        ArrayList<DataStoreEntryRef<h>> arrayList = new ArrayList<DataStoreEntryRef<h>>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            DataStoreEntry dataStoreEntry = (String[])iterator.next();
            dataStoreEntry = dataStoreEntry.strip();
            if (((String[])(dataStoreEntry = dataStoreEntry.split("\\s+", 3))).length != 3) continue;
            String string = dataStoreEntry[1];
            dataStoreEntry = dataStoreEntry[2];
            boolean bl = false;
            if (dataStoreEntry.endsWith("*")) {
                dataStoreEntry = dataStoreEntry.substring(0, dataStoreEntry.length() - 1).strip();
                bl = true;
            }
            dataStoreEntry = ((h.b)((h.b)((h.b)h.builder().install((DataStoreEntryRef<d>)commandControl)).tailnet(string)).account((String)dataStoreEntry)).build();
            dataStoreEntry = DataStoreEntry.createNew((String)string, (DataStore)dataStoreEntry);
            dataStoreEntry.setStorePersistentState(((h.a.a)((Object)h.a.builder().active(bl))).build());
            arrayList.add((DataStoreEntryRef<h>)dataStoreEntry.ref());
        }
        if (arrayList.isEmpty() && AppDistributionType.get() == AppDistributionType.WEBTOP) {
            commandControl = this;
            commandControl = commandControl.build(commandBuilder -> commandBuilder.add(new String[]{"login"})).elevated(ElevationFunction.elevated((String)"tailscale"));
            TerminalLaunch.builder().command((ProcessControl)commandControl).logIfEnabled(false).preferTabs(false).title("Tailscale login").launch();
        }
        return arrayList;
    }

    public boolean aR(String string) {
        Iterator<String> iterator = this.build(commandBuilder -> commandBuilder.add(new String[]{"switch", "--list"})).readStdoutOrThrow();
        iterator = ((String)((Object)iterator)).lines().skip(1L).toList();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            object = ((String)object).strip();
            if (((String[])(object = ((String)object).split("\\s+", 3))).length != 3) continue;
            object = object[2];
            boolean bl = false;
            if (((String)object).contains("*")) {
                bl = true;
                object = ((String)object).substring(0, ((String)object).length() - 1).strip();
            }
            if (string.equals(object) && bl) {
                return true;
            }
            if (!string.equals(object)) continue;
            this.build(commandBuilder -> commandBuilder.add(new String[]{"switch"}).addQuoted(string)).execute();
            return true;
        }
        this.build(commandBuilder -> commandBuilder.add(new String[]{"status"})).execute();
        TerminalLaunch.builder().title("Tailscale login").command((ProcessControl)this.build(commandBuilder -> commandBuilder.add(new String[]{"login"}))).launch();
        return false;
    }

    public List<DataStoreEntryRef<b>> r(DataStoreEntryRef<h> object) {
        Object object2 = this.build(commandBuilder -> commandBuilder.add(new String[]{"status", "--json"})).readStdoutOrThrow();
        object2 = JacksonMapper.getDefault().readTree((String)object2);
        JsonNode jsonNode2 = object2.required("Peer");
        if (jsonNode2.isNull()) {
            object = (object2 = object2.get("Health")) != null && object2.isArray() ? "\n\n" + StreamSupport.stream(object2.spliterator(), false).map(jsonNode -> jsonNode.asText()).collect(Collectors.joining(" ")) : "";
            throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Failed to communicate with tailscale daemon. Is it running?" + object));
        }
        object2 = new ArrayList();
        jsonNode2.iterator().forEachRemaining(arg_0 -> a.a(object, (ArrayList)object2, arg_0));
        return object2;
    }

    public Optional<b.a> a(b b2) {
        Object object = this.build(commandBuilder -> commandBuilder.add(new String[]{"status", "--json"})).readStdoutOrThrow();
        object = JacksonMapper.getDefault().readTree((String)object);
        object = object.required("Peer");
        object = object.iterator();
        while (object.hasNext()) {
            JsonNode jsonNode = (JsonNode)object.next();
            String string = jsonNode.required("ID").asText();
            if (!b2.getId().equals(string)) continue;
            boolean bl = jsonNode.get("sshHostKeys") != null;
            boolean bl2 = jsonNode.required("ExitNode").asBoolean() || jsonNode.required("ExitNodeOption").asBoolean();
            boolean bl3 = jsonNode.required("Online").asBoolean();
            return Optional.ofNullable(((b.a.a)((Object)((b.a.a)((Object)((b.a.a)((Object)b.a.builder().ssh(bl))).online(bl3))).exitNode(bl2))).build());
        }
        return Optional.empty();
    }

    public /* synthetic */ CommandView start() {
        return this.dm();
    }

    private static /* synthetic */ void a(DataStoreEntryRef dataStoreEntryRef, ArrayList arrayList, JsonNode jsonNode) {
        Object object;
        Object object2 = jsonNode.get("Tags");
        if (object2 != null && object2.isArray()) {
            object2 = object2.iterator();
            while (object2.hasNext()) {
                object = (JsonNode)object2.next();
                if (!object.asText().equals("tag:mullvad-exit-node")) continue;
                return;
            }
        }
        object2 = jsonNode.required("ID").asText();
        object = jsonNode.required("DNSName").asText();
        Serializable serializable = Pattern.compile("^(.+?)\\..+$");
        object = serializable.matcher((CharSequence)object);
        object = ((Matcher)object).matches() ? ((Matcher)object).group(1) : jsonNode.required("HostName").asText();
        serializable = new ArrayList<Object>();
        ((ArrayList)serializable).add(object);
        boolean bl = jsonNode.get("sshHostKeys") != null;
        boolean bl2 = jsonNode.required("ExitNode").asBoolean() || jsonNode.required("ExitNodeOption").asBoolean();
        boolean bl3 = jsonNode.required("Online").asBoolean();
        String string = DataStoreFormatter.formatHostName((String)object, (int)Integer.MAX_VALUE);
        dataStoreEntryRef = DataStoreEntry.createNew((String)string, ((b.b)((b.b)((b.b)((b.b)b.builder().tailnet((DataStoreEntryRef<h>)dataStoreEntryRef)).id((String)object2)).hostName(HostAddress.of((String)object, (List)((Object)serializable)))).identity(IdentityValue.ofBreakout((DataStoreEntry)dataStoreEntryRef.get()))).build());
        dataStoreEntryRef.setStorePersistentState((DataStoreState)((b.a.a)((Object)((b.a.a)((Object)((b.a.a)((Object)b.a.builder().ssh(bl))).online(bl3))).exitNode(bl2))).build());
        arrayList.add(dataStoreEntryRef.ref());
    }
}

