/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.ssh;

import io.xpipe.app.core.AppI18n;
import io.xpipe.app.core.AppInstallation;
import io.xpipe.app.core.AppNames;
import io.xpipe.app.core.AppSystemInfo;
import io.xpipe.app.core.window.AppDialog;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.issue.ErrorEvent;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.issue.TrackEvent;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandSupport;
import io.xpipe.app.process.CountDown;
import io.xpipe.app.process.LocalShell;
import io.xpipe.app.process.ScriptHelper;
import io.xpipe.app.process.SecretReference;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.secret.SecretManager;
import io.xpipe.app.secret.SecretNoneStrategy;
import io.xpipe.app.secret.SecretQuery;
import io.xpipe.app.secret.SecretQueryFilter;
import io.xpipe.app.secret.SecretQueryFormatter;
import io.xpipe.app.secret.SecretQueryProgress;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.util.HostHelper;
import io.xpipe.core.FailableBiFunction;
import io.xpipe.core.FilePath;
import io.xpipe.core.InPlaceSecretValue;
import io.xpipe.core.KeyValue;
import io.xpipe.core.OsType;
import io.xpipe.core.SecretValue;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.proc.ssh.I;
import io.xpipe.ext.proc.ssh.e;
import io.xpipe.ext.proc.ssh.g;
import io.xpipe.ext.proc.ssh.r;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.value.ObservableValue;
import lombok.Generated;

public final class w {
    private final String baseExecutable;
    private final FailableBiFunction<String, Boolean, CommandBuilder, Exception> baseCommand;
    private final String displayHostName;
    private final SecretRetrievalStrategy password;
    private final SshIdentityStrategy identity;
    private final boolean checkLocalhostKey;
    private final boolean forwardX11;
    private final boolean noInteraction;
    private final g additionalOptions;
    private final Supplier<UUID> secretId;
    private final DataStore ey;
    private final String tunnelArguments;
    private final boolean isForwardedToLocalhost;
    private final g additionalConfig;
    private final List<e<?>> jumpServers;

    private List<e<?>> cH() {
        if (this.jumpServers != null) {
            return this.jumpServers;
        }
        return List.of();
    }

    private static FilePath E(ShellControl shellControl) {
        ShellControl shellControl2;
        block10: {
            block11: {
                Optional optional;
                block8: {
                    block9: {
                        if (!shellControl.getLocalSystemAccess().supportsExecutables()) {
                            return null;
                        }
                        shellControl2 = LocalShell.getShell().start();
                        try {
                            optional = shellControl2.view().findProgram("ssh-sk-helper");
                            if (!optional.isEmpty()) break block8;
                            if (shellControl2 == null) break block9;
                        }
                        catch (Throwable throwable) {
                            if (shellControl2 != null) {
                                try {
                                    shellControl2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        shellControl2.close();
                    }
                    return null;
                }
                shellControl = shellControl.getLocalSystemAccess().translateFromLocalSystemPath((FilePath)optional.get());
                if (!shellControl.equals(optional.get())) break block10;
                if (shellControl2 == null) break block11;
                shellControl2.close();
            }
            return null;
        }
        if (shellControl2 != null) {
            shellControl2.close();
        }
        return shellControl;
    }

    private List<KeyValue> a(SecretRetrievalStrategy secretRetrievalStrategy, SshIdentityStrategy sshIdentityStrategy, boolean bl, boolean bl2, ShellControl shellControl) {
        ArrayList<KeyValue> arrayList = new ArrayList<KeyValue>();
        if (secretRetrievalStrategy instanceof SecretNoneStrategy) {
            arrayList.add(new KeyValue("PasswordAuthentication", "no"));
        }
        arrayList.add(new KeyValue("ControlMaster", "no"));
        if (AppPrefs.get() != null && AppPrefs.get().sshVerboseOutput().get()) {
            arrayList.add(new KeyValue("LogLevel", "DEBUG1"));
        }
        if (this.displayHostName != null && HostHelper.isLocalNetworkAddress((String)this.displayHostName)) {
            arrayList.add(new KeyValue("StrictHostKeyChecking", "no"));
        } else if (AppPrefs.get() == null || !AppPrefs.get().dontAcceptNewHostKeys().get()) {
            arrayList.add(new KeyValue("StrictHostKeyChecking", "accept-new"));
        } else {
            arrayList.add(new KeyValue("StrictHostKeyChecking", "ask"));
        }
        if (bl) {
            arrayList.add(new KeyValue("ForwardX11", "yes"));
            if (shellControl.getOsType() != OsType.LINUX) {
                arrayList.add(new KeyValue("ForwardX11Trusted", "yes"));
            }
        }
        if (!bl2) {
            arrayList.add(new KeyValue("NoHostAuthenticationForLocalhost", "yes"));
        }
        arrayList.addAll(sshIdentityStrategy.configOptions());
        return arrayList;
    }

    final 1 cI() {
        return new SecretQueryFilter(this){
            {
                Objects.requireNonNull(w2);
            }

            public final Optional<SecretValue> filter(SecretQueryProgress object, String string) {
                if (string.contains("Please type 'yes', 'no' or the fingerprint")) {
                    return Optional.of(InPlaceSecretValue.of((String)"yes"));
                }
                if (string.contains("authenticity of host") || string.contains("please type 'yes', 'no' or the fingerprint")) {
                    if (AppPrefs.get() != null && !AppPrefs.get().dontAcceptNewHostKeys().get()) {
                        return Optional.of(InPlaceSecretValue.of((String)"yes"));
                    }
                    object = string.replace(" (yes/no/[fingerprint])", "").replace("[ssh] ", "");
                    boolean bl = AppDialog.confirm((String)"sshTrustKeyTitle", (ObservableValue)AppI18n.observable((String)"sshTrustKeyContent", (Object[])new Object[]{object}));
                    return Optional.of(InPlaceSecretValue.of((String)(bl ? "yes" : "no")));
                }
                return r.aN(string);
            }
        };
    }

    final 2 cJ() {
        return new SecretQueryFormatter(this){
            private /* synthetic */ w ez;
            {
                w w3 = w2;
                Objects.requireNonNull(w3);
                this.ez = w3;
            }

            public final Optional<String> format(String string) {
                if (this.ez.isForwardedToLocalhost && this.ez.displayHostName != null && string.contains("@localhost")) {
                    return Optional.of(string.replace("@localhost", "@" + this.ez.displayHostName));
                }
                return Optional.empty();
            }
        };
    }

    private String cK() {
        Optional optional = DataStorage.get().getStoreEntryIfPresent(this.cX(), true).or(() -> DataStorage.get().getStoreEntryInProgressIfPresent(this.cX()));
        if (optional.isEmpty()) {
            return "[ssh]";
        }
        return "[" + ((DataStoreEntry)optional.get()).getName() + "] [ssh]";
    }

    final CommandBuilder d(String string, boolean bl) {
        boolean bl2;
        Pattern pattern;
        Matcher matcher;
        Object object3 = string;
        string = object3 == null ? null : ((matcher = (pattern = Pattern.compile("\".+?\\\\Users\\\\([^\\\\]+)\\\\(.+)\"")).matcher((CharSequence)object3)).find() && matcher.group(1).contains(" ") ? matcher.replaceFirst("\"$2\"") : object3);
        w w2 = this;
        boolean bl3 = string == null;
        boolean bl4 = bl;
        CommandBuilder object42 = (CommandBuilder)w2.baseCommand.apply((Object)string, (Object)bl);
        object3 = w2;
        CommandBuilder commandBuilder = CommandBuilder.of().add(object -> {
            if (object != null && object.getOsType() == OsType.WINDOWS) {
                try {
                    CommandSupport.isInLocalPathOrThrow((String)"OpenSSH client", (String)this.baseExecutable);
                }
                catch (Exception exception) {
                    object = exception;
                    ErrorEventFactory.preconfigure((ErrorEvent.ErrorEventBuilder)ErrorEventFactory.fromThrowable((Throwable)exception).link("https://learn.microsoft.com/en-us/windows-server/administration/openssh/openssh-overview"));
                    throw object;
                }
            }
            return this.baseExecutable;
        });
        commandBuilder.add(new String[]{"-oIgnoreUnknown=\"PKCS11Provider,RemoteCommand,WarnWeakCrypto\""});
        commandBuilder.setup(object -> {
            w w2 = this;
            object = w2.a(w2.password, this.identity, this.forwardX11, this.checkLocalhostKey, (ShellControl)object);
            commandBuilder.add(2, g.a((List<KeyValue>)object));
        });
        if (!bl4 || !bl3) {
            commandBuilder.add(new String[]{"-oRemoteCommand=none"});
        }
        commandBuilder.add(new String[]{"-oWarnWeakCrypto=no"});
        commandBuilder.add(new String[]{"-oServerAliveInterval=15"});
        commandBuilder.add(new String[]{"-oServerAliveCountMax=2"});
        if (((w)object3).baseExecutable.equals("ssh")) {
            if (bl4) {
                commandBuilder.add(new String[]{"-tt"});
            } else {
                bl4 = AppPrefs.get() != null && (Boolean)AppPrefs.get().developerMode().getValue() != false && AppPrefs.get().developerForceSshTty().get();
                commandBuilder.add(new String[]{bl4 ? "-tt" : "-T"});
            }
        }
        commandBuilder.environment("SSH_SK_HELPER", shellControl -> {
            if ((shellControl = w.E(shellControl)) != null) {
                return shellControl.toString();
            }
            return null;
        });
        CommandBuilder commandBuilder2 = new HashMap();
        Iterator<e<?>> iterator = ((w)object3).cH().iterator();
        while (iterator.hasNext()) {
            e<?> e2;
            e<?> e3 = e2 = iterator.next();
            commandBuilder2.put(e3, e3.toConfigHost());
        }
        if (((w)object3).additionalConfig != null || commandBuilder2.size() > 0) {
            commandBuilder.add(shellControl -> {
                ArrayList<KeyValue> arrayList;
                void var2_6;
                if (var2_6 == null) {
                    return "<file>";
                }
                FilePath filePath = new ArrayList<KeyValue>();
                filePath.add(new KeyValue("Include", "\"" + String.valueOf(g.C((ShellControl)var2_6)) + "\""));
                filePath.add(new KeyValue("Include", "\"" + String.valueOf(g.D((ShellControl)var2_6)) + "\""));
                ArrayList<g.a> arrayList2 = new ArrayList<g.a>();
                if (this.additionalConfig != null) {
                    arrayList2.addAll(this.additionalConfig.cs().cv());
                    if (this.additionalConfig.aI("*").isPresent()) {
                        arrayList2.remove(this.additionalConfig.cu());
                        arrayList = new ArrayList<KeyValue>(this.additionalConfig.cu().cE());
                        arrayList.addAll(0, (Collection<KeyValue>)filePath);
                        arrayList2.addFirst(new g.a("*", arrayList));
                    } else {
                        arrayList2.addFirst(new g.a("*", (List<KeyValue>)filePath));
                    }
                } else {
                    arrayList2.addFirst(new g.a("*", (List<KeyValue>)filePath));
                }
                for (Map.Entry entry : commandBuilder2.entrySet()) {
                    filePath = ((g)entry.getValue()).cs().cv();
                    filePath.getFirst().cE().addAll(this.a(((e)entry.getKey()).getPassword(), ((e)entry.getKey()).getIdentityStrategy(), ((e)entry.getKey()).hasX11Forward(), this.checkLocalhostKey, (ShellControl)var2_6));
                    ArrayList<g.a> arrayList3 = new ArrayList<g.a>((Collection<g.a>)filePath);
                    arrayList3.removeIf(a2 -> a2.cD().equals("*"));
                    arrayList2.addAll(arrayList3);
                }
                arrayList = new g(arrayList2, List.of());
                String string = ((g)((Object)arrayList)).cr();
                filePath = var2_6.view().writeTextFileDeterministic(var2_6.getSystemTemporaryDirectory().join(new String[]{"xpipe-config"}), string);
                if (var2_6.getOsType() != OsType.WINDOWS) {
                    var2_6.command(CommandBuilder.of().add(new String[]{"chmod", "600"}).addFile(filePath)).executeAndCheck();
                }
                TrackEvent.withInfo((String)"Writing SSH config").tag("file", (Object)filePath).tag("content", (Object)string).handle();
                return g.a((ShellControl)var2_6, filePath).buildFull((ShellControl)var2_6);
            });
        }
        if (!(bl2 = commandBuilder2.size() == 0 && (((w)object3).additionalConfig == null || ((w)object3).additionalConfig.ct().isEmpty()))) {
            List<String> list = commandBuilder2.values().stream().map(g2 -> g2.cv().getFirst().cD()).toList();
            if (!list.isEmpty()) {
                commandBuilder.add(new String[]{"-oProxyJump=\"" + String.join((CharSequence)",", list) + "\""});
            }
        } else {
            boolean bl5 = ((w)object3).additionalConfig != null && ((w)object3).additionalConfig.cv().stream().anyMatch(a2 -> a2.cE().stream().anyMatch(keyValue -> keyValue.getKey().equals("ProxyCommand")));
            if (!bl5) {
                commandBuilder.add(new String[]{"-oProxyJump=none"});
            }
        }
        commandBuilder.add(shellControl -> {
            if (((String)(object42 = object42.buildBase(shellControl))).toLowerCase().contains("homeassistant") || ((String)object42).toLowerCase().contains("hassio") || ((String)object42).toLowerCase().contains("haos")) {
                object42 = CommandBuilder.of().add(new String[]{"-m"}).addQuoted("hmac-sha2-256-etm@openssh.com").add(new String[]{object42});
                return object42.buildFull(shellControl);
            }
            return object42;
        });
        commandBuilder2 = commandBuilder;
        commandBuilder2.setCountDown(CountDown.of());
        ArrayList<SecretQuery> arrayList = new ArrayList<SecretQuery>();
        for (e<?> e4 : this.cH()) {
            if (e4.getIdentityStrategy().getAskpassStrategy().expectsQuery()) {
                arrayList.add(e4.getIdentityStrategy().getAskpassStrategy().query());
            }
            if (!e4.getPassword().expectsQuery()) continue;
            arrayList.add(e4.getPassword().query());
        }
        if (this.identity.getAskpassStrategy().expectsQuery()) {
            arrayList.add(this.identity.getAskpassStrategy().query());
        }
        if (this.cQ().expectsQuery()) {
            arrayList.add(this.cQ().query());
        }
        commandBuilder2.setup(shellControl -> {
            for (e<?> e2 : this.cH()) {
                e2.getIdentityStrategy().prepareParent(shellControl);
            }
            this.identity.prepareParent(shellControl);
        });
        if (this.cV() != null) {
            commandBuilder2.add(2, g.a(this.cV().cv().getFirst().cE()));
        }
        if (this.tunnelArguments != null) {
            commandBuilder2.add(new String[]{this.tunnelArguments});
        }
        this.identity.buildCommand(commandBuilder2);
        CommandBuilder commandBuilder3 = commandBuilder2;
        object3 = this;
        commandBuilder3.environment("DISPLAY", object -> {
            String string = "localhost:0.0";
            if (!this.forwardX11) {
                return string;
            }
            if (((Optional)(object = object.view().getEnvironmentVariable("DISPLAY"))).isEmpty()) {
                return string;
            }
            return (String)((Optional)object).get();
        });
        if (this.forwardX11) {
            I.dh();
        }
        commandBuilder2.setup(object2 -> {
            boolean bl2 = object2.getLocalSystemAccess().supportsExecutables();
            if (bl2) {
                SecretManager.expectAskpass((UUID)commandBuilder2.getUuid(), (UUID)this.secretId.get(), (List)arrayList, (SecretQuery)SecretQuery.prompt((boolean)false), List.of(this.cI()), List.of(this.cJ()), (CountDown)commandBuilder2.getCountDown(), (boolean)object2.isInteractive());
                ShellControl shellControl2 = object2;
                CommandBuilder commandBuilder = commandBuilder2;
                UUID uUID = this.secretId.get();
                object2 = commandBuilder.getUuid();
                CommandBuilder commandBuilder2 = commandBuilder;
                arrayList = shellControl2;
                commandBuilder2 = this;
                commandBuilder2.fixedEnvironment("SSH_ASKPASS_REQUIRE", "force");
                commandBuilder2.add(2, new String[]{"-oNumberOfPasswordPrompts=3"});
                if (arrayList.getLocalSystemAccess().supportsExecutableEnvironment()) {
                    io.xpipe.ext.proc.util.a.a(commandBuilder2, ((w)commandBuilder2).cK(), (UUID)object2, uUID, "SSH_ASKPASS");
                } else {
                    commandBuilder2.environment("SSH_ASKPASS", arg_0 -> ((w)commandBuilder2).a((UUID)object2, uUID, arg_0));
                }
                CommandBuilder.Element element = (CommandBuilder.Element)commandBuilder2.getEnvironmentVariables().get("SSH_ASKPASS");
                commandBuilder2.environment("SSH_ASKPASS", shellControl -> this.c(shellControl, FilePath.of((String)element.evaluate(shellControl))).toString());
                return;
            }
            if (bl) {
                Object object3 = object2;
                object2 = SecretManager.get((SecretReference)new SecretReference(this.secretId.get(), 0)).orElse(null);
                SecretValue secretValue = SecretManager.get((SecretReference)new SecretReference(this.secretId.get(), this.identity.getAskpassStrategy().expectsQuery() ? 1 : 0)).orElse(null);
                arrayList = commandBuilder2;
                commandBuilder2 = this;
                if (!(AppPrefs.get().disableTerminalRemotePasswordPreparation().get() || secretValue == null && object2 == null)) {
                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                    if (object2 != null) {
                        arrayList2.add(object2);
                    }
                    if (secretValue != null) {
                        arrayList2.add(secretValue);
                    }
                    secretValue = ScriptHelper.createTerminalPreparedAskpassScript(arrayList2, (ShellControl)object3, (boolean)true);
                    ((w)commandBuilder2).a((ShellControl)object3, (CommandBuilder)arrayList, (FilePath)secretValue);
                }
                return;
            }
            SecretManager.expectAskpass((UUID)commandBuilder2.getUuid(), (UUID)this.secretId.get(), (List)arrayList, (SecretQuery)SecretQuery.prompt((boolean)false), List.of(this.cI()), List.of(this.cJ()), (CountDown)commandBuilder2.getCountDown(), (boolean)object2.isInteractive());
            arrayList = io.xpipe.ext.proc.util.a.a(object2, commandBuilder2.getUuid(), this.cK());
            this.a((ShellControl)object2, commandBuilder2, (FilePath)arrayList);
        });
        if (string != null) {
            commandBuilder2.add(new String[]{string});
        }
        object3 = CommandBuilder.of().add(shellControl -> {
            commandBuilder2 = commandBuilder2.buildFull(shellControl);
            if (this.baseExecutable.equals("sftp")) {
                commandBuilder2 = ((String)commandBuilder2).replaceAll("-p ", "-P ");
            }
            return commandBuilder2;
        });
        object3.setCountDown(commandBuilder2.getCountDown());
        return object3;
    }

    private FilePath c(ShellControl object, FilePath filePath) {
        Object object2;
        if (object.getOsType() != OsType.WINDOWS) {
            return filePath;
        }
        boolean bl = w.f(filePath);
        if (!bl) {
            return filePath;
        }
        FilePath filePath2 = object.view().userHome();
        if (filePath.startsWith(filePath2) && !w.f((FilePath)(object2 = filePath.relativize(filePath2)))) {
            object.view().cd(filePath2);
            return object2;
        }
        try {
            object2 = AppSystemInfo.ofWindows().getLocalAppData().resolve(AppNames.ofCurrent().getName()).resolve("bin").resolve("xpipe.exe");
            Files.createDirectories(object2.getParent(), new FileAttribute[0]);
            Files.copy(AppInstallation.ofCurrent().getCliExecutablePath(), (Path)object2, StandardCopyOption.REPLACE_EXISTING);
            object.view().cd(filePath2);
            object = AppSystemInfo.ofCurrent().getUserHome();
            return FilePath.of((Path)object.relativize((Path)object2));
        }
        catch (Exception exception) {
            object2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).omit().expected().handle();
            return filePath;
        }
    }

    private static boolean f(FilePath object) {
        char[] cArray = object.toString().toCharArray();
        object = cArray;
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            FilePath filePath = object[i2];
            if (filePath <= 127) continue;
            return true;
        }
        return false;
    }

    private void a(ShellControl object, CommandBuilder commandBuilder, FilePath filePath) {
        object = Map.of("SSH_ASKPASS", this.c((ShellControl)object, filePath).toString(), "SSH_ASKPASS_REQUIRE", "force");
        commandBuilder.fixedEnvironment((Map)object);
        commandBuilder.add(2, new String[]{"-oNumberOfPasswordPrompts=3"});
    }

    @Generated
    w(String string, FailableBiFunction<String, Boolean, CommandBuilder, Exception> failableBiFunction, String string2, SecretRetrievalStrategy secretRetrievalStrategy, SshIdentityStrategy sshIdentityStrategy, boolean bl, boolean bl2, boolean bl3, g g2, Supplier<UUID> supplier, DataStore dataStore, String string3, boolean bl4, g g3, List<e<?>> list) {
        this.baseExecutable = string;
        this.baseCommand = failableBiFunction;
        this.displayHostName = string2;
        this.password = secretRetrievalStrategy;
        this.identity = sshIdentityStrategy;
        this.checkLocalhostKey = bl;
        this.forwardX11 = bl2;
        this.noInteraction = bl3;
        this.additionalOptions = g2;
        this.secretId = supplier;
        this.ey = dataStore;
        this.tunnelArguments = string3;
        this.isForwardedToLocalhost = bl4;
        this.additionalConfig = g3;
        this.jumpServers = list;
    }

    @Generated
    public static a cL() {
        return new a();
    }

    @Generated
    public final a cM() {
        return new a().baseExecutable(this.baseExecutable).baseCommand(this.baseCommand).displayHostName(this.displayHostName).password(this.password).identity(this.identity).checkLocalhostKey(this.checkLocalhostKey).forwardX11(this.forwardX11).noInteraction(this.noInteraction).additionalOptions(this.additionalOptions).secretId(this.secretId).sourceStore(this.ey).tunnelArguments(this.tunnelArguments).isForwardedToLocalhost(this.isForwardedToLocalhost).additionalConfig(this.additionalConfig).jumpServers(this.jumpServers);
    }

    @Generated
    public final String cN() {
        return this.baseExecutable;
    }

    @Generated
    public final FailableBiFunction<String, Boolean, CommandBuilder, Exception> cO() {
        return this.baseCommand;
    }

    @Generated
    public final String cP() {
        return this.displayHostName;
    }

    @Generated
    public final SecretRetrievalStrategy cQ() {
        return this.password;
    }

    @Generated
    public final SshIdentityStrategy cR() {
        return this.identity;
    }

    @Generated
    public final boolean cS() {
        return this.checkLocalhostKey;
    }

    @Generated
    public final boolean cT() {
        return this.forwardX11;
    }

    @Generated
    public final boolean cU() {
        return this.noInteraction;
    }

    @Generated
    public final g cV() {
        return this.additionalOptions;
    }

    @Generated
    public final Supplier<UUID> cW() {
        return this.secretId;
    }

    @Generated
    public final DataStore cX() {
        return this.ey;
    }

    @Generated
    public final String cY() {
        return this.tunnelArguments;
    }

    @Generated
    public final boolean cZ() {
        return this.isForwardedToLocalhost;
    }

    @Generated
    public final g da() {
        return this.additionalConfig;
    }

    @Generated
    public final List<e<?>> db() {
        return this.jumpServers;
    }

    @Generated
    public final boolean equals(Object list) {
        if (list == this) {
            return true;
        }
        if (!(list instanceof w)) {
            return false;
        }
        list = (w)((Object)list);
        if (this.cS() != ((w)((Object)list)).cS()) {
            return false;
        }
        if (this.cT() != ((w)((Object)list)).cT()) {
            return false;
        }
        if (this.cU() != ((w)((Object)list)).cU()) {
            return false;
        }
        if (this.cZ() != ((w)((Object)list)).cZ()) {
            return false;
        }
        Object object = this.cN();
        Object object2 = ((w)((Object)list)).cN();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.cO();
        object2 = ((w)((Object)list)).cO();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.cP();
        object2 = ((w)((Object)list)).cP();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.cQ();
        object2 = ((w)((Object)list)).cQ();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.cR();
        object2 = ((w)((Object)list)).cR();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.cV();
        object2 = ((w)((Object)list)).cV();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.cW();
        object2 = ((w)((Object)list)).cW();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.cX();
        object2 = ((w)((Object)list)).cX();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.cY();
        object2 = ((w)((Object)list)).cY();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.da();
        object2 = ((w)((Object)list)).da();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.db();
        list = ((w)((Object)list)).db();
        return !(object == null ? list != null : !object.equals(list));
    }

    @Generated
    public final int hashCode() {
        int n2 = 59 + (this.cS() ? 79 : 97);
        n2 = n2 * 59 + (this.cT() ? 79 : 97);
        n2 = n2 * 59 + (this.cU() ? 79 : 97);
        n2 = n2 * 59 + (this.cZ() ? 79 : 97);
        Object object = this.cN();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.cO();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.cP();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.cQ();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.cR();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.cV();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.cW();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.cX();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.cY();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.da();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.db();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Generated
    public final String toString() {
        return "SshShellControlConfig(baseExecutable=" + this.cN() + ", baseCommand=" + String.valueOf(this.cO()) + ", displayHostName=" + this.cP() + ", password=" + String.valueOf(this.cQ()) + ", identity=" + String.valueOf(this.cR()) + ", checkLocalhostKey=" + this.cS() + ", forwardX11=" + this.cT() + ", noInteraction=" + this.cU() + ", additionalOptions=" + String.valueOf(this.cV()) + ", secretId=" + String.valueOf(this.cW()) + ", sourceStore=" + String.valueOf(this.cX()) + ", tunnelArguments=" + this.cY() + ", isForwardedToLocalhost=" + this.cZ() + ", additionalConfig=" + String.valueOf(this.da()) + ", jumpServers=" + String.valueOf(this.db()) + ")";
    }

    private /* synthetic */ String a(UUID uUID, UUID uUID2, ShellControl shellControl) {
        uUID = io.xpipe.ext.proc.util.a.a(shellControl, uUID, uUID2, this.cK());
        return this.c(shellControl, (FilePath)uUID).toString();
    }

    @Generated
    public static class a {
        @Generated
        private String baseExecutable;
        @Generated
        private FailableBiFunction<String, Boolean, CommandBuilder, Exception> baseCommand;
        @Generated
        private String displayHostName;
        @Generated
        private SecretRetrievalStrategy password;
        @Generated
        private SshIdentityStrategy identity;
        @Generated
        private boolean checkLocalhostKey;
        @Generated
        private boolean forwardX11;
        @Generated
        private boolean noInteraction;
        @Generated
        private g additionalOptions;
        @Generated
        private Supplier<UUID> secretId;
        @Generated
        private DataStore sourceStore;
        @Generated
        private String tunnelArguments;
        @Generated
        private boolean isForwardedToLocalhost;
        @Generated
        private g additionalConfig;
        @Generated
        private List<e<?>> jumpServers;

        @Generated
        a() {
        }

        @Generated
        public a baseExecutable(String string) {
            this.baseExecutable = string;
            return this;
        }

        @Generated
        public a baseCommand(FailableBiFunction<String, Boolean, CommandBuilder, Exception> failableBiFunction) {
            this.baseCommand = failableBiFunction;
            return this;
        }

        @Generated
        public a displayHostName(String string) {
            this.displayHostName = string;
            return this;
        }

        @Generated
        public a password(SecretRetrievalStrategy secretRetrievalStrategy) {
            this.password = secretRetrievalStrategy;
            return this;
        }

        @Generated
        public a identity(SshIdentityStrategy sshIdentityStrategy) {
            this.identity = sshIdentityStrategy;
            return this;
        }

        @Generated
        public a checkLocalhostKey(boolean bl) {
            this.checkLocalhostKey = bl;
            return this;
        }

        @Generated
        public a forwardX11(boolean bl) {
            this.forwardX11 = bl;
            return this;
        }

        @Generated
        public a noInteraction(boolean bl) {
            this.noInteraction = bl;
            return this;
        }

        @Generated
        public a additionalOptions(g g2) {
            this.additionalOptions = g2;
            return this;
        }

        @Generated
        public a secretId(Supplier<UUID> supplier) {
            this.secretId = supplier;
            return this;
        }

        @Generated
        public a sourceStore(DataStore dataStore) {
            this.sourceStore = dataStore;
            return this;
        }

        @Generated
        public a tunnelArguments(String string) {
            this.tunnelArguments = string;
            return this;
        }

        @Generated
        public a isForwardedToLocalhost(boolean bl) {
            this.isForwardedToLocalhost = bl;
            return this;
        }

        @Generated
        public a additionalConfig(g g2) {
            this.additionalConfig = g2;
            return this;
        }

        @Generated
        public a jumpServers(List<e<?>> list) {
            this.jumpServers = list;
            return this;
        }

        @Generated
        public w build() {
            return new w(this.baseExecutable, this.baseCommand, this.displayHostName, this.password, this.identity, this.checkLocalhostKey, this.forwardX11, this.noInteraction, this.additionalOptions, this.secretId, this.sourceStore, this.tunnelArguments, this.isForwardedToLocalhost, this.additionalConfig, this.jumpServers);
        }

        @Generated
        public String toString() {
            return "SshShellControlConfig.SshShellControlConfigBuilder(baseExecutable=" + this.baseExecutable + ", baseCommand=" + String.valueOf(this.baseCommand) + ", displayHostName=" + this.displayHostName + ", password=" + String.valueOf(this.password) + ", identity=" + String.valueOf(this.identity) + ", checkLocalhostKey=" + this.checkLocalhostKey + ", forwardX11=" + this.forwardX11 + ", noInteraction=" + this.noInteraction + ", additionalOptions=" + String.valueOf(this.additionalOptions) + ", secretId=" + String.valueOf(this.secretId) + ", sourceStore=" + String.valueOf(this.sourceStore) + ", tunnelArguments=" + this.tunnelArguments + ", isForwardedToLocalhost=" + this.isForwardedToLocalhost + ", additionalConfig=" + String.valueOf(this.additionalConfig) + ", jumpServers=" + String.valueOf(this.jumpServers) + ")";
        }
    }
}

