/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.ssh;

import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.FileSystem;
import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.ext.NetworkTunnelSession;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.ext.ProcessControlProvider;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellControlFunction;
import io.xpipe.app.ext.ShellSession;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.SingletonSessionStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.ext.UserScopeStore;
import io.xpipe.app.ext.ValidationException;
import io.xpipe.app.issue.ErrorEvent;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialect;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.process.ShellStoreState;
import io.xpipe.app.process.ShellTtyState;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.DataStoreFormatter;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.core.FailableBiFunction;
import io.xpipe.core.FailableSupplier;
import io.xpipe.ext.base.desktop.DesktopApplicationStore;
import io.xpipe.ext.base.desktop.DesktopBaseStore;
import io.xpipe.ext.base.host.HostAddressIdentityStore;
import io.xpipe.ext.base.host.HostAddressTunnelStore;
import io.xpipe.ext.base.identity.UsernameStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.proc.d;
import io.xpipe.ext.proc.dialect.k;
import io.xpipe.ext.proc.ssh.b;
import io.xpipe.ext.proc.ssh.g;
import io.xpipe.ext.proc.ssh.v;
import io.xpipe.ext.proc.ssh.w;
import io.xpipe.ext.proc.tunnel.c;
import io.xpipe.ext.proc.tunnel.i;
import io.xpipe.ext.proc.tunnel.j;
import io.xpipe.ext.proc.tunnel.l;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public abstract class e<T extends ShellStoreState>
implements NetworkTunnelStore,
SelfReferentialStore,
ShellStore,
SingletonSessionStore<ShellSession>,
StatefulDataStore<T>,
UserScopeStore,
DesktopBaseStore,
HostAddressIdentityStore,
HostAddressTunnelStore,
d,
i,
io.xpipe.ext.proc.vm.a {
    @Override
    public String getSftpUser() {
        return this.getUser().getFixedUsername().orElse(null);
    }

    @Override
    public String getSftpHostAddress() {
        return this.getHostAddress().get();
    }

    @Override
    public int getSftpPort() {
        return this.getPort();
    }

    protected String distinctConfigHostName() {
        Object object = this.getSelfEntry();
        object = DataStorage.get().getStoreEntries().contains(object) ? object.getName().replaceAll("\\W", "_") : "config";
        return (String)object + "_xpipe";
    }

    public abstract g toConfigHost();

    public DataStoreEntryRef<?> getNetworkParent() {
        if (this.getGateway() != null) {
            return this.getGateway().asNeeded();
        }
        return null;
    }

    @Override
    public String getTunnelHostName() {
        return this.getHostAddress().get();
    }

    public boolean isLocallyTunnelable() {
        boolean bl = this.dontInteractWithSystem();
        return !bl;
    }

    public NetworkTunnelSession createTunnelSession(int n2, int n3, String string) {
        j j2 = ((c.a)((c.a)((c.a)c.builder().originPort(n2)).remotePort(n3)).remoteAddress(string)).build();
        return this.createTunnelSession(j2);
    }

    private List<e<?>> getGatewayChain() {
        ArrayList arrayList = new ArrayList();
        e e2 = this;
        while (e2.getGateway() != null && e2.getGateway() != null && (e2 = e2.getGateway().getStore()) instanceof e) {
            arrayList.addFirst(e2);
        }
        return arrayList;
    }

    public List<e<?>> getJumpServerChain() {
        e<?> e2;
        List<e<?>> list = this.getGatewayChain();
        ArrayList arrayList = new ArrayList();
        for (int i2 = list.size() - 1; i2 >= 0 && (e2 = list.get(i2)).isJumpServer(); --i2) {
            arrayList.addFirst(e2);
        }
        return arrayList;
    }

    protected void checkValidGatewayChain() {
        Object object = this.getGatewayChain();
        boolean bl = false;
        object = object.iterator();
        while (object.hasNext()) {
            e e2 = (e)object.next();
            if (e2.isJumpServer()) {
                if (!bl) continue;
                object = new ValidationException(AppI18n.get((String)"invalidSshGatewayChain", (Object[])new Object[0]));
                ErrorEventFactory.preconfigure((ErrorEvent.ErrorEventBuilder)ErrorEventFactory.fromThrowable((Throwable)object).documentationLink(DocumentationLink.SSH_GATEWAYS));
                throw object;
            }
            bl = true;
        }
    }

    private boolean useGatewayAsJumpServer() {
        if (this.getGateway() == null) {
            return false;
        }
        return this.getJumpServerChain().contains(this.getGateway().getStore());
    }

    @Override
    public l createTunnelSession(j j2) {
        FailableSupplier failableSupplier = () -> {
            this.startGatewayTunnelIfNeeded();
            w w2 = this.buildShellControlConfig("ssh");
            j2 = w2.cM().tunnelArguments(((j)j2).toTunnelArguments()).build();
            if (this.requiresLocalGatewayTunnel() && this.shouldTunnelToGatewayHost() && !this.canTunnelToGatewayHost()) {
                throw new UnsupportedOperationException("Intermediate system " + this.getGateway().get().getName() + " does not support tunneling");
            }
            return v.a(ProcessControlProvider.get().createLocalProcessControl(true), (w)((Object)j2));
        };
        return l.a(j2, (FailableSupplier<ShellControl>)failableSupplier);
    }

    private w buildShellControlConfig(String object) {
        object = w.cL().baseExecutable((String)object).baseCommand((FailableBiFunction<String, Boolean, CommandBuilder, Exception>)((FailableBiFunction)(string, bl) -> this.buildBaseCommand())).additionalConfig(this.buildBaseConfig().orElse(null)).displayHostName(this.getHostAddress().get()).password(this.getPassword()).identity(this.getIdentityStrategy()).checkLocalhostKey(false).forwardX11(this.hasX11Forward()).noInteraction(this.dontInteractWithSystem()).additionalOptions(this.getAdditionalOptions()).secretId(() -> this.getSelfEntry().getUuid()).sourceStore(this).isForwardedToLocalhost(this.usesGatewayTunnelSession()).jumpServers(this.getJumpServerChain()).build();
        return object;
    }

    public boolean supportsDesktopAccess() {
        return this.hasX11Forward();
    }

    public void runDesktopApplication(String string, DesktopApplicationStore desktopApplicationStore) {
        this.startSessionIfNeeded();
        string = ((ShellSession)this.getSession()).getShellControl();
        string.command(desktopApplicationStore.getFullCommand()).execute();
    }

    public ShellDialect getUsedDesktopDialect() {
        if (((ShellStoreState)this.getState()).getShellDialect() != null) {
            return ((ShellStoreState)this.getState()).getShellDialect();
        }
        return ShellDialects.BASH;
    }

    protected abstract boolean dontInteractWithSystem();

    protected abstract boolean hasX11Forward();

    public abstract SecretRetrievalStrategy getPassword();

    @Override
    public abstract DataStoreEntryRef<NetworkTunnelStore> getGateway();

    @Override
    public String getGatewayTunnelTargetIp() {
        return this.getHostAddress().get();
    }

    @Override
    public int getGatewayTunnelTargetPort() {
        return this.getPort();
    }

    @Override
    public boolean shouldTunnelToGatewayHost() {
        return (Boolean)AppPrefs.get().developerDisableSshTunnelGateways().getValue() == false && !this.useGatewayAsJumpServer();
    }

    public abstract HostAddress getHostAddress();

    public abstract UsernameStrategy getUser();

    public abstract int getPort();

    protected abstract CommandBuilder buildBaseCommand();

    public abstract boolean isJumpServer();

    protected Optional<g> buildBaseConfig() {
        return Optional.empty();
    }

    protected abstract SshIdentityStrategy getIdentityStrategy();

    public String toSummary() {
        return this.getUser().getFixedUsername().map(string -> string + "@").orElse("") + (this.getHostAddress() != null ? DataStoreFormatter.formatHostName((String)this.getHostAddress().get(), (int)Integer.MAX_VALUE) : "?") + ":" + this.getPort();
    }

    protected String getEffectiveHostName() {
        if (!this.usesGatewayTunnelSession()) {
            return this.getHostAddress().get();
        }
        return "localhost";
    }

    protected int getEffectivePort() {
        if (!this.usesGatewayTunnelSession()) {
            return this.getPort();
        }
        return this.getLocalGatewayTunnelPort();
    }

    protected abstract boolean hasTunnels();

    protected g getAdditionalOptions() {
        return null;
    }

    public ShellControlFunction shellFunction() {
        return new ShellControlFunction(this){
            private /* synthetic */ e ej;
            {
                e e3 = e2;
                Objects.requireNonNull(e3);
                this.ej = e3;
            }

            public final ShellControl control() {
                this.ej.startGatewayTunnelIfNeeded();
                ShellDialect shellDialect = ((ShellStoreState)this.ej.getState()).getShellDialect();
                boolean bl = shellDialect instanceof k.j && !this.ej.dontInteractWithSystem();
                Object object = this.ej.buildShellControlConfig(bl ? "sftp" : "ssh");
                object = v.a(ProcessControlProvider.get().createLocalProcessControl(true), (w)object);
                return object;
            }
        };
    }

    public FileSystem createFileSystem() {
        ShellDialect shellDialect = ((ShellStoreState)this.getState()).getShellDialect();
        boolean bl = shellDialect instanceof k.j || this.dontInteractWithSystem() || ((ShellStoreState)this.getState()).getTtyState() != null && ((ShellStoreState)this.getState()).getTtyState() != ShellTtyState.NONE;
        if (bl) {
            return this.createSftpFileSystem();
        }
        return super.createFileSystem();
    }

    @Override
    public FileSystem createSftpFileSystem() {
        this.startGatewayTunnelIfNeeded();
        Object object = this.buildShellControlConfig("sftp");
        object = v.a(ProcessControlProvider.get().createLocalProcessControl(true), (w)object);
        return new b((ShellControl)object);
    }

    @Generated
    protected e(a<T, ?, ?> a2) {
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof e)) {
            return false;
        }
        return ((e)(object = (e)object)).canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof e;
    }

    @Generated
    public int hashCode() {
        return 1;
    }

    @Generated
    public String toString() {
        return "SshBaseStore()";
    }

    @Generated
    public static abstract class a<T extends ShellStoreState, C extends e<T>, B extends a<T, C, B>> {
        @Generated
        protected B $fillValuesFrom(C c2) {
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return this.self();
        }

        @Generated
        private static <T extends ShellStoreState> void $fillValuesFromInstanceIntoBuilder(e<T> e2, a<T, ?, ?> a2) {
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SshBaseStore.SshBaseStoreBuilder()";
        }
    }
}

