/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.docker;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.ContainerImageStore;
import io.xpipe.app.ext.ContainerStoreState;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.InternalCacheDataStore;
import io.xpipe.app.ext.NameableStore;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellControlFunction;
import io.xpipe.app.ext.ShellControlParentStoreFunction;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.LicenseRequiredException;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.base.service.AbstractServiceStore;
import io.xpipe.ext.base.service.FixedServiceCreatorStore;
import io.xpipe.ext.base.service.MappedServiceStore;
import io.xpipe.ext.base.store.PauseableStore;
import io.xpipe.ext.base.store.StartableStore;
import io.xpipe.ext.base.store.StoppableStore;
import io.xpipe.ext.proc.docker.c;
import io.xpipe.ext.proc.docker.h;
import io.xpipe.ext.proc.docker.s;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

@JsonTypeName(value="docker")
@JsonDeserialize(builder=b.class)
public final class o
implements ContainerImageStore,
FixedChildStore,
InternalCacheDataStore,
NameableStore,
SelfReferentialStore,
ShellStore,
StatefulDataStore<ContainerStoreState>,
FixedServiceCreatorStore,
PauseableStore,
StartableStore,
StoppableStore {
    private final DataStoreEntryRef<s> context;
    private final DataStoreEntryRef<h> composeProject;
    private final String containerName;

    public o(DataStoreEntryRef<s> dataStoreEntryRef, DataStoreEntryRef<h> dataStoreEntryRef2, String string) {
        this.context = dataStoreEntryRef;
        this.composeProject = dataStoreEntryRef2;
        this.containerName = string;
    }

    public final String getName() {
        return this.containerName;
    }

    public final Class<ContainerStoreState> getStateClass() {
        return ContainerStoreState.class;
    }

    public final c.c commandView(ShellControl shellControl) {
        return new c(shellControl).z(((s)this.getContext().getStore()).getName());
    }

    public final void start() {
        ShellControl shellControl = ((ShellStore)((io.xpipe.ext.proc.docker.a)((s)this.getContext().getStore()).getCmd().getStore()).getHost().getStore()).getOrStartSession();
        c.c c2 = this.commandView(shellControl);
        String string = c2.B(this.containerName);
        if (string.contains("(Paused)")) {
            c2.I(this.containerName);
        } else {
            c2.f(this.containerName);
        }
        this.refreshContainerState(shellControl);
    }

    public final void stop() {
        ShellControl shellControl = ((ShellStore)((io.xpipe.ext.proc.docker.a)((s)this.getContext().getStore()).getCmd().getStore()).getHost().getStore()).getOrStartSession();
        c.c c2 = this.commandView(shellControl);
        c2.g(this.containerName);
        this.refreshContainerState(shellControl);
    }

    public final void checkComplete() {
        Validators.nonNull(this.context);
        Validators.isType(this.context, s.class);
        this.context.checkComplete();
        Validators.nonNull((Object)this.containerName);
    }

    public final ShellControlFunction shellFunction() {
        return new ShellControlParentStoreFunction(this){
            private /* synthetic */ o bB;
            {
                o o3 = o2;
                Objects.requireNonNull(o3);
                this.bB = o3;
            }

            public final ShellControl control(ShellControl shellControl) {
                this.bB.refreshContainerState(((ShellStore)((io.xpipe.ext.proc.docker.a)((s)this.bB.getContext().getStore()).getCmd().getStore()).getHost().getStore()).getOrStartSession());
                return new c(shellControl).z(((s)this.bB.getContext().getStore()).getName()).F(this.bB.containerName).withSourceStore((DataStore)this.bB).withShellStateInit((StatefulDataStore)this.bB).onStartupFail(throwable -> {
                    if (throwable instanceof LicenseRequiredException) {
                        return;
                    }
                    boolean bl = throwable.getMessage() == null || !throwable.getMessage().contains("OCI runtime exec failed");
                    if (!bl) {
                        ContainerStoreState.ContainerStoreStateBuilder containerStoreStateBuilder = ((ContainerStoreState)this.bB.getState()).toBuilder();
                        containerStoreStateBuilder.shellMissing(Boolean.TRUE);
                        this.bB.setState((DataStoreState)containerStoreStateBuilder.build());
                    }
                });
            }

            public final ShellStore getParentStore() {
                return (ShellStore)((io.xpipe.ext.proc.docker.a)((s)this.bB.getContext().getStore()).getCmd().getStore()).getHost().getStore();
            }
        };
    }

    public final OptionalInt getFixedId() {
        return OptionalInt.of(Objects.hash(this.containerName));
    }

    public final List<? extends DataStoreEntryRef<? extends AbstractServiceStore>> createFixedServices() {
        return this.findServices().stream().map(mappedServiceStore -> DataStoreEntry.createNew((String)"Service", (DataStore)mappedServiceStore).ref()).toList();
    }

    private List<MappedServiceStore> findServices() {
        DataStoreEntry dataStoreEntry = this.getSelfEntry();
        Object object2 = ((ShellStore)((io.xpipe.ext.proc.docker.a)((s)this.getContext().getStore()).getCmd().getStore()).getHost().getStore()).getOrStartSession();
        object2 = this.commandView((ShellControl)object2);
        object2 = object2.K(this.containerName);
        return object2.lines().map(object -> {
            object = Pattern.compile("(\\d+)/\\w+\\s*->\\s*[^:]+?:(\\d+)").matcher((CharSequence)object);
            if (!((Matcher)object).matches()) {
                return null;
            }
            int n2 = Integer.parseInt(((Matcher)object).group(1));
            int n3 = Integer.parseInt(((Matcher)object).group(2));
            return ((MappedServiceStore.MappedServiceStoreBuilder)((MappedServiceStore.MappedServiceStoreBuilder)((MappedServiceStore.MappedServiceStoreBuilder)MappedServiceStore.builder().host(((io.xpipe.ext.proc.docker.a)((s)this.getContext().getStore()).getCmd().getStore()).getHost().get().ref())).displayParent(dataStoreEntry.ref())).containerPort(n2).remotePort(Integer.valueOf(n3))).build();
        }).filter(mappedServiceStore -> mappedServiceStore != null).toList();
    }

    public final String getImageName() {
        return ((ContainerStoreState)this.getState()).getImageName();
    }

    public final void pause() {
        ShellControl shellControl = ((ShellStore)((io.xpipe.ext.proc.docker.a)((s)this.getContext().getStore()).getCmd().getStore()).getHost().getStore()).getOrStartSession();
        c.c c2 = this.commandView(shellControl);
        c2.H(this.containerName);
        this.refreshContainerState(shellControl);
    }

    private void refreshContainerState(ShellControl shellControl) {
        ContainerStoreState containerStoreState = (ContainerStoreState)this.getState();
        Object object = new c(shellControl).z(((s)this.getContext().getStore()).getName());
        object = object.B(this.containerName);
        boolean bl = ((String)object).startsWith("Up");
        containerStoreState = ((ContainerStoreState.ContainerStoreStateBuilder)containerStoreState.toBuilder().containerState((String)object).running(Boolean.valueOf(bl))).build();
        this.setState((DataStoreState)containerStoreState);
        if (this.composeProject != null) {
            ((h)this.composeProject.getStore()).refreshProjectState(shellControl);
        }
    }

    @Generated
    protected o(a<?, ?> a2) {
        this.context = a2.context;
        this.composeProject = a2.composeProject;
        this.containerName = a2.containerName;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final DataStoreEntryRef<s> getContext() {
        return this.context;
    }

    @Generated
    public final DataStoreEntryRef<h> getComposeProject() {
        return this.composeProject;
    }

    @Generated
    public final String getContainerName() {
        return this.containerName;
    }

    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof o)) {
            return false;
        }
        object = (o)object;
        Object object2 = this.getContext();
        Object object3 = ((o)object).getContext();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getComposeProject();
        object3 = ((o)object).getComposeProject();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        object2 = this.getContainerName();
        object = ((o)object).getContainerName();
        return !(object2 == null ? object != null : !object2.equals(object));
    }

    @Generated
    public final int hashCode() {
        DataStoreEntryRef<s> dataStoreEntryRef = this.getContext();
        int n2 = 59 + (dataStoreEntryRef == null ? 43 : dataStoreEntryRef.hashCode());
        Object object = this.getComposeProject();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getContainerName();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Generated
    public final String toString() {
        return "DockerContainerStore(context=" + String.valueOf(this.getContext()) + ", composeProject=" + String.valueOf(this.getComposeProject()) + ", containerName=" + this.getContainerName() + ")";
    }

    @Generated
    public static abstract class a<C extends o, B extends a<C, B>> {
        @Generated
        private DataStoreEntryRef<s> context;
        @Generated
        private DataStoreEntryRef<h> composeProject;
        @Generated
        private String containerName;

        @Generated
        public B context(DataStoreEntryRef<s> dataStoreEntryRef) {
            this.context = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B composeProject(DataStoreEntryRef<h> dataStoreEntryRef) {
            this.composeProject = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        public B containerName(String string) {
            this.containerName = string;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DockerContainerStore.DockerContainerStoreBuilder(context=" + String.valueOf(this.context) + ", composeProject=" + String.valueOf(this.composeProject) + ", containerName=" + this.containerName + ")";
        }
    }

    @JsonTypeName(value="docker")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<o, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final o build() {
            return new o(this);
        }
    }
}

