"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// node_modules/isexe/dist/cjs/posix.js
var require_posix = __commonJS({
  "node_modules/isexe/dist/cjs/posix.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.sync = exports2.isexe = void 0;
    var fs_1 = require("fs");
    var promises_1 = require("fs/promises");
    var isexe = async (path13, options = {}) => {
      const { ignoreErrors = false } = options;
      try {
        return checkStat(await (0, promises_1.stat)(path13), options);
      } catch (e) {
        const er = e;
        if (ignoreErrors || er.code === "EACCES")
          return false;
        throw er;
      }
    };
    exports2.isexe = isexe;
    var sync = (path13, options = {}) => {
      const { ignoreErrors = false } = options;
      try {
        return checkStat((0, fs_1.statSync)(path13), options);
      } catch (e) {
        const er = e;
        if (ignoreErrors || er.code === "EACCES")
          return false;
        throw er;
      }
    };
    exports2.sync = sync;
    var checkStat = (stat, options) => stat.isFile() && checkMode(stat, options);
    var checkMode = (stat, options) => {
      var _a, _b, _c;
      const myUid = options.uid ?? ((_a = process.getuid) == null ? void 0 : _a.call(process));
      const myGroups = options.groups ?? ((_b = process.getgroups) == null ? void 0 : _b.call(process)) ?? [];
      const myGid = options.gid ?? ((_c = process.getgid) == null ? void 0 : _c.call(process)) ?? myGroups[0];
      if (myUid === void 0 || myGid === void 0) {
        throw new Error("cannot get uid or gid");
      }
      const groups = /* @__PURE__ */ new Set([myGid, ...myGroups]);
      const mod = stat.mode;
      const uid = stat.uid;
      const gid = stat.gid;
      const u = parseInt("100", 8);
      const g = parseInt("010", 8);
      const o = parseInt("001", 8);
      const ug = u | g;
      return !!(mod & o || mod & g && groups.has(gid) || mod & u && uid === myUid || mod & ug && myUid === 0);
    };
  }
});

// node_modules/isexe/dist/cjs/win32.js
var require_win32 = __commonJS({
  "node_modules/isexe/dist/cjs/win32.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.sync = exports2.isexe = void 0;
    var fs_1 = require("fs");
    var promises_1 = require("fs/promises");
    var isexe = async (path13, options = {}) => {
      const { ignoreErrors = false } = options;
      try {
        return checkStat(await (0, promises_1.stat)(path13), path13, options);
      } catch (e) {
        const er = e;
        if (ignoreErrors || er.code === "EACCES")
          return false;
        throw er;
      }
    };
    exports2.isexe = isexe;
    var sync = (path13, options = {}) => {
      const { ignoreErrors = false } = options;
      try {
        return checkStat((0, fs_1.statSync)(path13), path13, options);
      } catch (e) {
        const er = e;
        if (ignoreErrors || er.code === "EACCES")
          return false;
        throw er;
      }
    };
    exports2.sync = sync;
    var checkPathExt = (path13, options) => {
      const { pathExt = process.env.PATHEXT || "" } = options;
      const peSplit = pathExt.split(";");
      if (peSplit.indexOf("") !== -1) {
        return true;
      }
      for (let i = 0; i < peSplit.length; i++) {
        const p = peSplit[i].toLowerCase();
        const ext2 = path13.substring(path13.length - p.length).toLowerCase();
        if (p && ext2 === p) {
          return true;
        }
      }
      return false;
    };
    var checkStat = (stat, path13, options) => stat.isFile() && checkPathExt(path13, options);
  }
});

// node_modules/isexe/dist/cjs/options.js
var require_options = __commonJS({
  "node_modules/isexe/dist/cjs/options.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// node_modules/isexe/dist/cjs/index.js
var require_cjs = __commonJS({
  "node_modules/isexe/dist/cjs/index.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p)) __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.sync = exports2.isexe = exports2.posix = exports2.win32 = void 0;
    var posix = __importStar(require_posix());
    exports2.posix = posix;
    var win32 = __importStar(require_win32());
    exports2.win32 = win32;
    __exportStar(require_options(), exports2);
    var platform = process.env._ISEXE_TEST_PLATFORM_ || process.platform;
    var impl = platform === "win32" ? win32 : posix;
    exports2.isexe = impl.isexe;
    exports2.sync = impl.sync;
  }
});

// node_modules/which/lib/index.js
var require_lib = __commonJS({
  "node_modules/which/lib/index.js"(exports2, module2) {
    var { isexe, sync: isexeSync } = require_cjs();
    var { join: join4, delimiter, sep: sep2, posix } = require("path");
    var isWindows = process.platform === "win32";
    var rSlash = new RegExp(`[${posix.sep}${sep2 === posix.sep ? "" : sep2}]`.replace(/(\\)/g, "\\$1"));
    var rRel = new RegExp(`^\\.${rSlash.source}`);
    var getNotFoundError = (cmd) => Object.assign(new Error(`not found: ${cmd}`), { code: "ENOENT" });
    var getPathInfo = (cmd, {
      path: optPath = process.env.PATH,
      pathExt: optPathExt = process.env.PATHEXT,
      delimiter: optDelimiter = delimiter
    }) => {
      const pathEnv = cmd.match(rSlash) ? [""] : [
        // windows always checks the cwd first
        ...isWindows ? [process.cwd()] : [],
        ...(optPath || /* istanbul ignore next: very unusual */
        "").split(optDelimiter)
      ];
      if (isWindows) {
        const pathExtExe = optPathExt || [".EXE", ".CMD", ".BAT", ".COM"].join(optDelimiter);
        const pathExt = pathExtExe.split(optDelimiter).flatMap((item) => [item, item.toLowerCase()]);
        if (cmd.includes(".") && pathExt[0] !== "") {
          pathExt.unshift("");
        }
        return { pathEnv, pathExt, pathExtExe };
      }
      return { pathEnv, pathExt: [""] };
    };
    var getPathPart = (raw, cmd) => {
      const pathPart = /^".*"$/.test(raw) ? raw.slice(1, -1) : raw;
      const prefix = !pathPart && rRel.test(cmd) ? cmd.slice(0, 2) : "";
      return prefix + join4(pathPart, cmd);
    };
    var which6 = async (cmd, opt = {}) => {
      const { pathEnv, pathExt, pathExtExe } = getPathInfo(cmd, opt);
      const found = [];
      for (const envPart of pathEnv) {
        const p = getPathPart(envPart, cmd);
        for (const ext2 of pathExt) {
          const withExt = p + ext2;
          const is = await isexe(withExt, { pathExt: pathExtExe, ignoreErrors: true });
          if (is) {
            if (!opt.all) {
              return withExt;
            }
            found.push(withExt);
          }
        }
      }
      if (opt.all && found.length) {
        return found;
      }
      if (opt.nothrow) {
        return null;
      }
      throw getNotFoundError(cmd);
    };
    var whichSync = (cmd, opt = {}) => {
      const { pathEnv, pathExt, pathExtExe } = getPathInfo(cmd, opt);
      const found = [];
      for (const pathEnvPart of pathEnv) {
        const p = getPathPart(pathEnvPart, cmd);
        for (const ext2 of pathExt) {
          const withExt = p + ext2;
          const is = isexeSync(withExt, { pathExt: pathExtExe, ignoreErrors: true });
          if (is) {
            if (!opt.all) {
              return withExt;
            }
            found.push(withExt);
          }
        }
      }
      if (opt.all && found.length) {
        return found;
      }
      if (opt.nothrow) {
        return null;
      }
      throw getNotFoundError(cmd);
    };
    module2.exports = which6;
    which6.sync = whichSync;
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/core.js
var require_core = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/core.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Disposable = exports2.Comparison = void 0;
    exports2.returnFalse = returnFalse;
    exports2.returnTrue = returnTrue;
    exports2.returnUndefined = returnUndefined;
    exports2.identity = identity;
    exports2.toLowerCase = toLowerCase;
    exports2.equateValues = equateValues;
    exports2.compareComparableValues = compareComparableValues;
    exports2.compareValues = compareValues;
    exports2.isArray = isArray2;
    exports2.isString = isString2;
    exports2.isNumber = isNumber;
    exports2.isBoolean = isBoolean;
    exports2.hasProperty = hasProperty;
    exports2.toBoolean = toBoolean;
    exports2.test_setDebugMode = test_setDebugMode;
    exports2.isDebugMode = isDebugMode;
    exports2.isThenable = isThenable;
    exports2.isDefined = isDefined;
    exports2.getEnumNames = getEnumNames;
    exports2.containsOnlyWhitespace = containsOnlyWhitespace;
    exports2.cloneStr = cloneStr;
    var Comparison;
    (function(Comparison2) {
      Comparison2[Comparison2["LessThan"] = -1] = "LessThan";
      Comparison2[Comparison2["EqualTo"] = 0] = "EqualTo";
      Comparison2[Comparison2["GreaterThan"] = 1] = "GreaterThan";
    })(Comparison || (exports2.Comparison = Comparison = {}));
    function returnFalse() {
      return false;
    }
    function returnTrue() {
      return true;
    }
    function returnUndefined() {
      return void 0;
    }
    function identity(x) {
      return x;
    }
    function toLowerCase(x) {
      return x.toLowerCase();
    }
    function equateValues(a, b) {
      return a === b;
    }
    function compareComparableValues(a, b) {
      return a === b ? 0 : a === void 0 ? -1 : b === void 0 ? 1 : a < b ? -1 : 1;
    }
    function compareValues(a, b) {
      return compareComparableValues(a, b);
    }
    function isArray2(value) {
      return Array.isArray ? Array.isArray(value) : value instanceof Array;
    }
    function isString2(text) {
      return typeof text === "string";
    }
    function isNumber(x) {
      return typeof x === "number";
    }
    function isBoolean(x) {
      return typeof x === "boolean";
    }
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    function hasProperty(map, key) {
      return hasOwnProperty.call(map, key);
    }
    function toBoolean(trueOrFalse) {
      const normalized = trueOrFalse == null ? void 0 : trueOrFalse.trim().toUpperCase();
      if (normalized === "TRUE") {
        return true;
      }
      return false;
    }
    var _debugMode = void 0;
    function test_setDebugMode(debugMode) {
      const oldValue = _debugMode;
      _debugMode = debugMode;
      return oldValue;
    }
    function isDebugMode() {
      if (_debugMode === void 0) {
        const argv = process.execArgv.join();
        _debugMode = argv.includes("inspect") || argv.includes("debug");
      }
      return _debugMode;
    }
    function isThenable(v) {
      return typeof (v == null ? void 0 : v.then) === "function";
    }
    function isDefined(element) {
      return element !== void 0;
    }
    function getEnumNames(enumType) {
      const result = [];
      for (const value in enumType) {
        if (isNaN(Number(value))) {
          result.push(value);
        }
      }
      return result;
    }
    function containsOnlyWhitespace(text, start, end) {
      if (start !== void 0) {
        text = text.substring(start, end);
      }
      return /^\s*$/.test(text);
    }
    function cloneStr(str) {
      return Buffer.from(str, "utf8").toString("utf8");
    }
    var Disposable;
    (function(Disposable2) {
      function is(value) {
        return value && typeof value.dispose === "function";
      }
      Disposable2.is = is;
    })(Disposable || (exports2.Disposable = Disposable = {}));
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/collectionUtils.js
var require_collectionUtils = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/collectionUtils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.emptyArray = void 0;
    exports2.contains = contains;
    exports2.append = append;
    exports2.appendArray = appendArray;
    exports2.partition = partition;
    exports2.find = find;
    exports2.addRange = addRange;
    exports2.insertAt = insertAt;
    exports2.cloneAndSort = cloneAndSort;
    exports2.stableSort = stableSort;
    exports2.map = map;
    exports2.some = some;
    exports2.every = every;
    exports2.binarySearch = binarySearch;
    exports2.binarySearchKey = binarySearchKey;
    exports2.flatten = flatten;
    exports2.getNestedProperty = getNestedProperty;
    exports2.getOrAdd = getOrAdd;
    exports2.removeArrayElements = removeArrayElements;
    exports2.createMapFromItems = createMapFromItems;
    exports2.addIfUnique = addIfUnique;
    exports2.getMapValues = getMapValues;
    exports2.addIfNotNull = addIfNotNull;
    exports2.arrayEquals = arrayEquals;
    var core_1 = require_core();
    exports2.emptyArray = [];
    function contains(array, value, equalityComparer = core_1.equateValues) {
      if (array) {
        for (const v of array) {
          if (equalityComparer(v, value)) {
            return true;
          }
        }
      }
      return false;
    }
    function append(to, value) {
      if (value === void 0) {
        return to;
      }
      if (to === void 0) {
        return [value];
      }
      to.push(value);
      return to;
    }
    function appendArray(to, elementsToPush) {
      if (elementsToPush.length < 256) {
        to.push(...elementsToPush);
        return;
      }
      for (const elem of elementsToPush) {
        to.push(elem);
      }
    }
    function partition(array, cb) {
      const trueItems = [];
      const falseItems = [];
      for (const item of array) {
        if (cb(item)) {
          trueItems.push(item);
        } else {
          falseItems.push(item);
        }
      }
      return [trueItems, falseItems];
    }
    function find(array, predicate) {
      for (let i = 0; i < array.length; i++) {
        const value = array[i];
        if (predicate(value, i)) {
          return value;
        }
      }
      return void 0;
    }
    function toOffset(array, offset) {
      return offset < 0 ? array.length + offset : offset;
    }
    function addRange(to, from, start, end) {
      if (from === void 0 || from.length === 0) {
        return to;
      }
      if (to === void 0) {
        return from.slice(start, end);
      }
      start = start === void 0 ? 0 : toOffset(from, start);
      end = end === void 0 ? from.length : toOffset(from, end);
      for (let i = start; i < end && i < from.length; i++) {
        if (from[i] !== void 0) {
          to.push(from[i]);
        }
      }
      return to;
    }
    function insertAt(array, index, value) {
      if (index === 0) {
        array.unshift(value);
      } else if (index === array.length) {
        array.push(value);
      } else {
        for (let i = array.length; i > index; i--) {
          array[i] = array[i - 1];
        }
        array[index] = value;
      }
      return array;
    }
    function cloneAndSort(array, comparer) {
      return array.length === 0 ? array : array.slice().sort(comparer);
    }
    function selectIndex(_, i) {
      return i;
    }
    function indicesOf(array) {
      return array.map(selectIndex);
    }
    function stableSort(array, comparer) {
      const indices = indicesOf(array);
      stableSortIndices(array, indices, comparer);
      return indices.map((i) => array[i]);
    }
    function stableSortIndices(array, indices, comparer) {
      indices.sort((x, y) => comparer(array[x], array[y]) || (0, core_1.compareValues)(x, y));
    }
    function map(array, f) {
      if (array) {
        return array.map(f);
      }
      return void 0;
    }
    function some(array, predicate) {
      if (array) {
        if (predicate) {
          return array.some(predicate);
        } else {
          return array.length > 0;
        }
      }
      return false;
    }
    function every(array, callback) {
      if (array) {
        return array.every(callback);
      }
      return true;
    }
    function binarySearch(array, value, keySelector, keyComparer, offset) {
      return binarySearchKey(array, keySelector(value), keySelector, keyComparer, offset);
    }
    function binarySearchKey(array, key, keySelector, keyComparer, offset) {
      if (!some(array)) {
        return -1;
      }
      let low = offset || 0;
      let high = array.length - 1;
      while (low <= high) {
        const middle = low + (high - low >> 1);
        const midKey = keySelector(array[middle]);
        switch (keyComparer(midKey, key)) {
          case -1:
            low = middle + 1;
            break;
          case 0:
            return middle;
          case 1:
            high = middle - 1;
            break;
        }
      }
      return ~low;
    }
    function flatten(array) {
      const result = [];
      for (const v of array) {
        if (v) {
          if ((0, core_1.isArray)(v)) {
            addRange(result, v);
          } else {
            result.push(v);
          }
        }
      }
      return result;
    }
    function getNestedProperty(object, property) {
      const value = property.split(".").reduce((obj, prop) => {
        return obj && obj[prop];
      }, object);
      return value;
    }
    function getOrAdd(map2, key, newValueFactory) {
      const value = map2.get(key);
      if (value !== void 0) {
        return value;
      }
      const newValue = newValueFactory();
      map2.set(key, newValue);
      return newValue;
    }
    function removeArrayElements(array, predicate) {
      for (let i = 0; i < array.length; i++) {
        if (predicate(array[i])) {
          array.splice(i, 1);
          i--;
        }
      }
      return array;
    }
    function createMapFromItems(items, keyGetter) {
      return items.map((t) => keyGetter(t)).reduce((map2, key, i) => {
        map2.set(key, (map2.get(key) || []).concat(items[i]));
        return map2;
      }, /* @__PURE__ */ new Map());
    }
    function addIfUnique(arr, t, equalityComparer = core_1.equateValues) {
      if (contains(arr, t, equalityComparer)) {
        return arr;
      }
      arr.push(t);
      return arr;
    }
    function getMapValues(m, predicate) {
      const values = [];
      m.forEach((v, k) => {
        if (predicate(k, v)) {
          values.push(v);
        }
      });
      return values;
    }
    function addIfNotNull(arr, t) {
      if (t === void 0) {
        return arr;
      }
      arr.push(t);
      return arr;
    }
    function arrayEquals(c1, c2, predicate) {
      if (c1.length !== c2.length) {
        return false;
      }
      return c1.every((v, i) => predicate(v, c2[i]));
    }
  }
});

// node_modules/vscode-uri/lib/umd/index.js
var require_umd = __commonJS({
  "node_modules/vscode-uri/lib/umd/index.js"(exports2, module2) {
    !(function(t, e) {
      if ("object" == typeof exports2 && "object" == typeof module2) module2.exports = e();
      else if ("function" == typeof define && define.amd) define([], e);
      else {
        var r = e();
        for (var n in r) ("object" == typeof exports2 ? exports2 : t)[n] = r[n];
      }
    })(exports2, (() => (() => {
      "use strict";
      var t = { 975: (t2) => {
        function e2(t3) {
          if ("string" != typeof t3) throw new TypeError("Path must be a string. Received " + JSON.stringify(t3));
        }
        function r2(t3, e3) {
          for (var r3, n3 = "", i = 0, o = -1, s = 0, a = 0; a <= t3.length; ++a) {
            if (a < t3.length) r3 = t3.charCodeAt(a);
            else {
              if (47 === r3) break;
              r3 = 47;
            }
            if (47 === r3) {
              if (o === a - 1 || 1 === s) ;
              else if (o !== a - 1 && 2 === s) {
                if (n3.length < 2 || 2 !== i || 46 !== n3.charCodeAt(n3.length - 1) || 46 !== n3.charCodeAt(n3.length - 2)) {
                  if (n3.length > 2) {
                    var h = n3.lastIndexOf("/");
                    if (h !== n3.length - 1) {
                      -1 === h ? (n3 = "", i = 0) : i = (n3 = n3.slice(0, h)).length - 1 - n3.lastIndexOf("/"), o = a, s = 0;
                      continue;
                    }
                  } else if (2 === n3.length || 1 === n3.length) {
                    n3 = "", i = 0, o = a, s = 0;
                    continue;
                  }
                }
                e3 && (n3.length > 0 ? n3 += "/.." : n3 = "..", i = 2);
              } else n3.length > 0 ? n3 += "/" + t3.slice(o + 1, a) : n3 = t3.slice(o + 1, a), i = a - o - 1;
              o = a, s = 0;
            } else 46 === r3 && -1 !== s ? ++s : s = -1;
          }
          return n3;
        }
        var n2 = { resolve: function() {
          for (var t3, n3 = "", i = false, o = arguments.length - 1; o >= -1 && !i; o--) {
            var s;
            o >= 0 ? s = arguments[o] : (void 0 === t3 && (t3 = process.cwd()), s = t3), e2(s), 0 !== s.length && (n3 = s + "/" + n3, i = 47 === s.charCodeAt(0));
          }
          return n3 = r2(n3, !i), i ? n3.length > 0 ? "/" + n3 : "/" : n3.length > 0 ? n3 : ".";
        }, normalize: function(t3) {
          if (e2(t3), 0 === t3.length) return ".";
          var n3 = 47 === t3.charCodeAt(0), i = 47 === t3.charCodeAt(t3.length - 1);
          return 0 !== (t3 = r2(t3, !n3)).length || n3 || (t3 = "."), t3.length > 0 && i && (t3 += "/"), n3 ? "/" + t3 : t3;
        }, isAbsolute: function(t3) {
          return e2(t3), t3.length > 0 && 47 === t3.charCodeAt(0);
        }, join: function() {
          if (0 === arguments.length) return ".";
          for (var t3, r3 = 0; r3 < arguments.length; ++r3) {
            var i = arguments[r3];
            e2(i), i.length > 0 && (void 0 === t3 ? t3 = i : t3 += "/" + i);
          }
          return void 0 === t3 ? "." : n2.normalize(t3);
        }, relative: function(t3, r3) {
          if (e2(t3), e2(r3), t3 === r3) return "";
          if ((t3 = n2.resolve(t3)) === (r3 = n2.resolve(r3))) return "";
          for (var i = 1; i < t3.length && 47 === t3.charCodeAt(i); ++i) ;
          for (var o = t3.length, s = o - i, a = 1; a < r3.length && 47 === r3.charCodeAt(a); ++a) ;
          for (var h = r3.length - a, c = s < h ? s : h, f = -1, u = 0; u <= c; ++u) {
            if (u === c) {
              if (h > c) {
                if (47 === r3.charCodeAt(a + u)) return r3.slice(a + u + 1);
                if (0 === u) return r3.slice(a + u);
              } else s > c && (47 === t3.charCodeAt(i + u) ? f = u : 0 === u && (f = 0));
              break;
            }
            var l = t3.charCodeAt(i + u);
            if (l !== r3.charCodeAt(a + u)) break;
            47 === l && (f = u);
          }
          var d = "";
          for (u = i + f + 1; u <= o; ++u) u !== o && 47 !== t3.charCodeAt(u) || (0 === d.length ? d += ".." : d += "/..");
          return d.length > 0 ? d + r3.slice(a + f) : (a += f, 47 === r3.charCodeAt(a) && ++a, r3.slice(a));
        }, _makeLong: function(t3) {
          return t3;
        }, dirname: function(t3) {
          if (e2(t3), 0 === t3.length) return ".";
          for (var r3 = t3.charCodeAt(0), n3 = 47 === r3, i = -1, o = true, s = t3.length - 1; s >= 1; --s) if (47 === (r3 = t3.charCodeAt(s))) {
            if (!o) {
              i = s;
              break;
            }
          } else o = false;
          return -1 === i ? n3 ? "/" : "." : n3 && 1 === i ? "//" : t3.slice(0, i);
        }, basename: function(t3, r3) {
          if (void 0 !== r3 && "string" != typeof r3) throw new TypeError('"ext" argument must be a string');
          e2(t3);
          var n3, i = 0, o = -1, s = true;
          if (void 0 !== r3 && r3.length > 0 && r3.length <= t3.length) {
            if (r3.length === t3.length && r3 === t3) return "";
            var a = r3.length - 1, h = -1;
            for (n3 = t3.length - 1; n3 >= 0; --n3) {
              var c = t3.charCodeAt(n3);
              if (47 === c) {
                if (!s) {
                  i = n3 + 1;
                  break;
                }
              } else -1 === h && (s = false, h = n3 + 1), a >= 0 && (c === r3.charCodeAt(a) ? -1 == --a && (o = n3) : (a = -1, o = h));
            }
            return i === o ? o = h : -1 === o && (o = t3.length), t3.slice(i, o);
          }
          for (n3 = t3.length - 1; n3 >= 0; --n3) if (47 === t3.charCodeAt(n3)) {
            if (!s) {
              i = n3 + 1;
              break;
            }
          } else -1 === o && (s = false, o = n3 + 1);
          return -1 === o ? "" : t3.slice(i, o);
        }, extname: function(t3) {
          e2(t3);
          for (var r3 = -1, n3 = 0, i = -1, o = true, s = 0, a = t3.length - 1; a >= 0; --a) {
            var h = t3.charCodeAt(a);
            if (47 !== h) -1 === i && (o = false, i = a + 1), 46 === h ? -1 === r3 ? r3 = a : 1 !== s && (s = 1) : -1 !== r3 && (s = -1);
            else if (!o) {
              n3 = a + 1;
              break;
            }
          }
          return -1 === r3 || -1 === i || 0 === s || 1 === s && r3 === i - 1 && r3 === n3 + 1 ? "" : t3.slice(r3, i);
        }, format: function(t3) {
          if (null === t3 || "object" != typeof t3) throw new TypeError('The "pathObject" argument must be of type Object. Received type ' + typeof t3);
          return (function(t4, e3) {
            var r3 = e3.dir || e3.root, n3 = e3.base || (e3.name || "") + (e3.ext || "");
            return r3 ? r3 === e3.root ? r3 + n3 : r3 + "/" + n3 : n3;
          })(0, t3);
        }, parse: function(t3) {
          e2(t3);
          var r3 = { root: "", dir: "", base: "", ext: "", name: "" };
          if (0 === t3.length) return r3;
          var n3, i = t3.charCodeAt(0), o = 47 === i;
          o ? (r3.root = "/", n3 = 1) : n3 = 0;
          for (var s = -1, a = 0, h = -1, c = true, f = t3.length - 1, u = 0; f >= n3; --f) if (47 !== (i = t3.charCodeAt(f))) -1 === h && (c = false, h = f + 1), 46 === i ? -1 === s ? s = f : 1 !== u && (u = 1) : -1 !== s && (u = -1);
          else if (!c) {
            a = f + 1;
            break;
          }
          return -1 === s || -1 === h || 0 === u || 1 === u && s === h - 1 && s === a + 1 ? -1 !== h && (r3.base = r3.name = 0 === a && o ? t3.slice(1, h) : t3.slice(a, h)) : (0 === a && o ? (r3.name = t3.slice(1, s), r3.base = t3.slice(1, h)) : (r3.name = t3.slice(a, s), r3.base = t3.slice(a, h)), r3.ext = t3.slice(s, h)), a > 0 ? r3.dir = t3.slice(0, a - 1) : o && (r3.dir = "/"), r3;
        }, sep: "/", delimiter: ":", win32: null, posix: null };
        n2.posix = n2, t2.exports = n2;
      }, 70: (t2, e2) => {
        if (Object.defineProperty(e2, "__esModule", { value: true }), e2.isWindows = void 0, "object" == typeof process) e2.isWindows = "win32" === process.platform;
        else if ("object" == typeof navigator) {
          let t3 = navigator.userAgent;
          e2.isWindows = t3.indexOf("Windows") >= 0;
        }
      }, 231: (t2, e2, r2) => {
        Object.defineProperty(e2, "__esModule", { value: true }), e2.uriToFsPath = e2.URI = void 0;
        const n2 = r2(70), i = /^\w[\w\d+.-]*$/, o = /^\//, s = /^\/\//;
        function a(t3, e3) {
          if (!t3.scheme && e3) throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${t3.authority}", path: "${t3.path}", query: "${t3.query}", fragment: "${t3.fragment}"}`);
          if (t3.scheme && !i.test(t3.scheme)) throw new Error("[UriError]: Scheme contains illegal characters.");
          if (t3.path) {
            if (t3.authority) {
              if (!o.test(t3.path)) throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character');
            } else if (s.test(t3.path)) throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")');
          }
        }
        const h = "", c = "/", f = /^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;
        class u {
          static isUri(t3) {
            return t3 instanceof u || !!t3 && "string" == typeof t3.authority && "string" == typeof t3.fragment && "string" == typeof t3.path && "string" == typeof t3.query && "string" == typeof t3.scheme && "string" == typeof t3.fsPath && "function" == typeof t3.with && "function" == typeof t3.toString;
          }
          scheme;
          authority;
          path;
          query;
          fragment;
          constructor(t3, e3, r3, n3, i2, o2 = false) {
            "object" == typeof t3 ? (this.scheme = t3.scheme || h, this.authority = t3.authority || h, this.path = t3.path || h, this.query = t3.query || h, this.fragment = t3.fragment || h) : (this.scheme = /* @__PURE__ */ (function(t4, e4) {
              return t4 || e4 ? t4 : "file";
            })(t3, o2), this.authority = e3 || h, this.path = (function(t4, e4) {
              switch (t4) {
                case "https":
                case "http":
                case "file":
                  e4 ? e4[0] !== c && (e4 = c + e4) : e4 = c;
              }
              return e4;
            })(this.scheme, r3 || h), this.query = n3 || h, this.fragment = i2 || h, a(this, o2));
          }
          get fsPath() {
            return v(this, false);
          }
          with(t3) {
            if (!t3) return this;
            let { scheme: e3, authority: r3, path: n3, query: i2, fragment: o2 } = t3;
            return void 0 === e3 ? e3 = this.scheme : null === e3 && (e3 = h), void 0 === r3 ? r3 = this.authority : null === r3 && (r3 = h), void 0 === n3 ? n3 = this.path : null === n3 && (n3 = h), void 0 === i2 ? i2 = this.query : null === i2 && (i2 = h), void 0 === o2 ? o2 = this.fragment : null === o2 && (o2 = h), e3 === this.scheme && r3 === this.authority && n3 === this.path && i2 === this.query && o2 === this.fragment ? this : new d(e3, r3, n3, i2, o2);
          }
          static parse(t3, e3 = false) {
            const r3 = f.exec(t3);
            return r3 ? new d(r3[2] || h, w(r3[4] || h), w(r3[5] || h), w(r3[7] || h), w(r3[9] || h), e3) : new d(h, h, h, h, h);
          }
          static file(t3) {
            let e3 = h;
            if (n2.isWindows && (t3 = t3.replace(/\\/g, c)), t3[0] === c && t3[1] === c) {
              const r3 = t3.indexOf(c, 2);
              -1 === r3 ? (e3 = t3.substring(2), t3 = c) : (e3 = t3.substring(2, r3), t3 = t3.substring(r3) || c);
            }
            return new d("file", e3, t3, h, h);
          }
          static from(t3) {
            const e3 = new d(t3.scheme, t3.authority, t3.path, t3.query, t3.fragment);
            return a(e3, true), e3;
          }
          toString(t3 = false) {
            return y(this, t3);
          }
          toJSON() {
            return this;
          }
          static revive(t3) {
            if (t3) {
              if (t3 instanceof u) return t3;
              {
                const e3 = new d(t3);
                return e3._formatted = t3.external, e3._fsPath = t3._sep === l ? t3.fsPath : null, e3;
              }
            }
            return t3;
          }
        }
        e2.URI = u;
        const l = n2.isWindows ? 1 : void 0;
        class d extends u {
          _formatted = null;
          _fsPath = null;
          get fsPath() {
            return this._fsPath || (this._fsPath = v(this, false)), this._fsPath;
          }
          toString(t3 = false) {
            return t3 ? y(this, true) : (this._formatted || (this._formatted = y(this, false)), this._formatted);
          }
          toJSON() {
            const t3 = { $mid: 1 };
            return this._fsPath && (t3.fsPath = this._fsPath, t3._sep = l), this._formatted && (t3.external = this._formatted), this.path && (t3.path = this.path), this.scheme && (t3.scheme = this.scheme), this.authority && (t3.authority = this.authority), this.query && (t3.query = this.query), this.fragment && (t3.fragment = this.fragment), t3;
          }
        }
        const p = { 58: "%3A", 47: "%2F", 63: "%3F", 35: "%23", 91: "%5B", 93: "%5D", 64: "%40", 33: "%21", 36: "%24", 38: "%26", 39: "%27", 40: "%28", 41: "%29", 42: "%2A", 43: "%2B", 44: "%2C", 59: "%3B", 61: "%3D", 32: "%20" };
        function g(t3, e3, r3) {
          let n3, i2 = -1;
          for (let o2 = 0; o2 < t3.length; o2++) {
            const s2 = t3.charCodeAt(o2);
            if (s2 >= 97 && s2 <= 122 || s2 >= 65 && s2 <= 90 || s2 >= 48 && s2 <= 57 || 45 === s2 || 46 === s2 || 95 === s2 || 126 === s2 || e3 && 47 === s2 || r3 && 91 === s2 || r3 && 93 === s2 || r3 && 58 === s2) -1 !== i2 && (n3 += encodeURIComponent(t3.substring(i2, o2)), i2 = -1), void 0 !== n3 && (n3 += t3.charAt(o2));
            else {
              void 0 === n3 && (n3 = t3.substr(0, o2));
              const e4 = p[s2];
              void 0 !== e4 ? (-1 !== i2 && (n3 += encodeURIComponent(t3.substring(i2, o2)), i2 = -1), n3 += e4) : -1 === i2 && (i2 = o2);
            }
          }
          return -1 !== i2 && (n3 += encodeURIComponent(t3.substring(i2))), void 0 !== n3 ? n3 : t3;
        }
        function m(t3) {
          let e3;
          for (let r3 = 0; r3 < t3.length; r3++) {
            const n3 = t3.charCodeAt(r3);
            35 === n3 || 63 === n3 ? (void 0 === e3 && (e3 = t3.substr(0, r3)), e3 += p[n3]) : void 0 !== e3 && (e3 += t3[r3]);
          }
          return void 0 !== e3 ? e3 : t3;
        }
        function v(t3, e3) {
          let r3;
          return r3 = t3.authority && t3.path.length > 1 && "file" === t3.scheme ? `//${t3.authority}${t3.path}` : 47 === t3.path.charCodeAt(0) && (t3.path.charCodeAt(1) >= 65 && t3.path.charCodeAt(1) <= 90 || t3.path.charCodeAt(1) >= 97 && t3.path.charCodeAt(1) <= 122) && 58 === t3.path.charCodeAt(2) ? e3 ? t3.path.substr(1) : t3.path[1].toLowerCase() + t3.path.substr(2) : t3.path, n2.isWindows && (r3 = r3.replace(/\//g, "\\")), r3;
        }
        function y(t3, e3) {
          const r3 = e3 ? m : g;
          let n3 = "", { scheme: i2, authority: o2, path: s2, query: a2, fragment: h2 } = t3;
          if (i2 && (n3 += i2, n3 += ":"), (o2 || "file" === i2) && (n3 += c, n3 += c), o2) {
            let t4 = o2.indexOf("@");
            if (-1 !== t4) {
              const e4 = o2.substr(0, t4);
              o2 = o2.substr(t4 + 1), t4 = e4.lastIndexOf(":"), -1 === t4 ? n3 += r3(e4, false, false) : (n3 += r3(e4.substr(0, t4), false, false), n3 += ":", n3 += r3(e4.substr(t4 + 1), false, true)), n3 += "@";
            }
            o2 = o2.toLowerCase(), t4 = o2.lastIndexOf(":"), -1 === t4 ? n3 += r3(o2, false, true) : (n3 += r3(o2.substr(0, t4), false, true), n3 += o2.substr(t4));
          }
          if (s2) {
            if (s2.length >= 3 && 47 === s2.charCodeAt(0) && 58 === s2.charCodeAt(2)) {
              const t4 = s2.charCodeAt(1);
              t4 >= 65 && t4 <= 90 && (s2 = `/${String.fromCharCode(t4 + 32)}:${s2.substr(3)}`);
            } else if (s2.length >= 2 && 58 === s2.charCodeAt(1)) {
              const t4 = s2.charCodeAt(0);
              t4 >= 65 && t4 <= 90 && (s2 = `${String.fromCharCode(t4 + 32)}:${s2.substr(2)}`);
            }
            n3 += r3(s2, true, false);
          }
          return a2 && (n3 += "?", n3 += r3(a2, false, false)), h2 && (n3 += "#", n3 += e3 ? h2 : g(h2, false, false)), n3;
        }
        function b(t3) {
          try {
            return decodeURIComponent(t3);
          } catch {
            return t3.length > 3 ? t3.substr(0, 3) + b(t3.substr(3)) : t3;
          }
        }
        e2.uriToFsPath = v;
        const C = /(%[0-9A-Za-z][0-9A-Za-z])+/g;
        function w(t3) {
          return t3.match(C) ? t3.replace(C, ((t4) => b(t4))) : t3;
        }
      }, 552: function(t2, e2, r2) {
        var n2 = this && this.__createBinding || (Object.create ? function(t3, e3, r3, n3) {
          void 0 === n3 && (n3 = r3);
          var i2 = Object.getOwnPropertyDescriptor(e3, r3);
          i2 && !("get" in i2 ? !e3.__esModule : i2.writable || i2.configurable) || (i2 = { enumerable: true, get: function() {
            return e3[r3];
          } }), Object.defineProperty(t3, n3, i2);
        } : function(t3, e3, r3, n3) {
          void 0 === n3 && (n3 = r3), t3[n3] = e3[r3];
        }), i = this && this.__setModuleDefault || (Object.create ? function(t3, e3) {
          Object.defineProperty(t3, "default", { enumerable: true, value: e3 });
        } : function(t3, e3) {
          t3.default = e3;
        }), o = this && this.__importStar || function(t3) {
          if (t3 && t3.__esModule) return t3;
          var e3 = {};
          if (null != t3) for (var r3 in t3) "default" !== r3 && Object.prototype.hasOwnProperty.call(t3, r3) && n2(e3, t3, r3);
          return i(e3, t3), e3;
        };
        Object.defineProperty(e2, "__esModule", { value: true }), e2.Utils = void 0;
        const s = o(r2(975)), a = s.posix || s, h = "/";
        var c;
        !(function(t3) {
          t3.joinPath = function(t4, ...e3) {
            return t4.with({ path: a.join(t4.path, ...e3) });
          }, t3.resolvePath = function(t4, ...e3) {
            let r3 = t4.path, n3 = false;
            r3[0] !== h && (r3 = h + r3, n3 = true);
            let i2 = a.resolve(r3, ...e3);
            return n3 && i2[0] === h && !t4.authority && (i2 = i2.substring(1)), t4.with({ path: i2 });
          }, t3.dirname = function(t4) {
            if (0 === t4.path.length || t4.path === h) return t4;
            let e3 = a.dirname(t4.path);
            return 1 === e3.length && 46 === e3.charCodeAt(0) && (e3 = ""), t4.with({ path: e3 });
          }, t3.basename = function(t4) {
            return a.basename(t4.path);
          }, t3.extname = function(t4) {
            return a.extname(t4.path);
          };
        })(c || (e2.Utils = c = {}));
      } }, e = {};
      function r(n2) {
        var i = e[n2];
        if (void 0 !== i) return i.exports;
        var o = e[n2] = { exports: {} };
        return t[n2].call(o.exports, o, o.exports, r), o.exports;
      }
      var n = {};
      return (() => {
        var t2 = n;
        Object.defineProperty(t2, "__esModule", { value: true }), t2.Utils = t2.URI = void 0;
        const e2 = r(231);
        Object.defineProperty(t2, "URI", { enumerable: true, get: function() {
          return e2.URI;
        } });
        const i = r(552);
        Object.defineProperty(t2, "Utils", { enumerable: true, get: function() {
          return i.Utils;
        } });
      })(), n;
    })()));
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/caseSensitivityDetector.js
var require_caseSensitivityDetector = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/caseSensitivityDetector.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CaseSensitivityDetector = void 0;
    var CaseSensitivityDetector;
    (function(CaseSensitivityDetector2) {
      function is(value) {
        return !!value.isCaseSensitive;
      }
      CaseSensitivityDetector2.is = is;
    })(CaseSensitivityDetector || (exports2.CaseSensitivityDetector = CaseSensitivityDetector = {}));
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/debug.js
var require_debug = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/debug.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.assert = assert;
    exports2.fail = fail;
    exports2.assertDefined = assertDefined;
    exports2.assertEachDefined = assertEachDefined;
    exports2.assertNever = assertNever;
    exports2.getFunctionName = getFunctionName;
    exports2.formatEnum = formatEnum;
    exports2.getErrorString = getErrorString;
    exports2.getSerializableError = getSerializableError;
    var collectionUtils_1 = require_collectionUtils();
    var core_1 = require_core();
    function assert(expression, message, verboseDebugInfo, stackCrawlMark) {
      if (!expression) {
        if (verboseDebugInfo) {
          message += "\r\nVerbose Debug Information: " + (typeof verboseDebugInfo === "string" ? verboseDebugInfo : verboseDebugInfo());
        }
        fail(message ? "False expression: " + message : "False expression.", stackCrawlMark || assert);
      }
    }
    function fail(message, stackCrawlMark) {
      const e = new Error(message ? `Debug Failure. ${message}` : "Debug Failure.");
      if (Error.captureStackTrace) {
        Error.captureStackTrace(e, stackCrawlMark || fail);
      }
      throw e;
    }
    function assertDefined(value, message, stackCrawlMark) {
      if (value === void 0 || value === null) {
        fail(message, stackCrawlMark || assertDefined);
      }
    }
    function assertEachDefined(value, message, stackCrawlMark) {
      for (const v of value) {
        assertDefined(v, message, stackCrawlMark || assertEachDefined);
      }
    }
    function assertNever(member, message = "Illegal value:", stackCrawlMark) {
      let detail = "";
      try {
        detail = JSON.stringify(member);
      } catch {
      }
      fail(`${message} ${detail}`, stackCrawlMark || assertNever);
    }
    function getFunctionName(func) {
      if (typeof func !== "function") {
        return "";
      } else if ((0, core_1.hasProperty)(func, "name")) {
        return func.name;
      } else {
        const text = Function.prototype.toString.call(func);
        const match2 = /^function\s+([\w$]+)\s*\(/.exec(text);
        return match2 ? match2[1] : "";
      }
    }
    function formatEnum(value = 0, enumObject, isFlags) {
      const members = getEnumMembers(enumObject);
      if (value === 0) {
        return members.length > 0 && members[0][0] === 0 ? members[0][1] : "0";
      }
      if (isFlags) {
        let result = "";
        let remainingFlags = value;
        for (const [enumValue, enumName] of members) {
          if (enumValue > value) {
            break;
          }
          if (enumValue !== 0 && enumValue & value) {
            result = `${result}${result ? "|" : ""}${enumName}`;
            remainingFlags &= ~enumValue;
          }
        }
        if (remainingFlags === 0) {
          return result;
        }
      } else {
        for (const [enumValue, enumName] of members) {
          if (enumValue === value) {
            return enumName;
          }
        }
      }
      return value.toString();
    }
    function getErrorString(error) {
      return (error.stack ? error.stack.toString() : void 0) || (typeof error.message === "string" ? error.message : void 0) || JSON.stringify(error);
    }
    function getSerializableError(error) {
      if (!error) {
        return void 0;
      }
      const exception = JSON.stringify(error);
      if (exception.length > 2) {
        return error;
      }
      const name = error.name ? (0, core_1.isString)(error.name) ? error.name : "noname" : "noname";
      const message = error.message ? (0, core_1.isString)(error.message) ? error.message : "nomessage" : "nomessage";
      const stack = error.stack ? (0, core_1.isString)(error.stack) ? error.stack : void 0 : void 0;
      return { name, message, stack };
    }
    function getEnumMembers(enumObject) {
      const result = [];
      for (const name of Object.keys(enumObject)) {
        const value = enumObject[name];
        if (typeof value === "number") {
          result.push([value, name]);
        }
      }
      return (0, collectionUtils_1.stableSort)(result, (x, y) => (0, core_1.compareValues)(x[0], y[0]));
    }
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/stringUtils.js
var require_stringUtils = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/stringUtils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isPatternInSymbol = isPatternInSymbol;
    exports2.hashString = hashString;
    exports2.compareStringsCaseInsensitive = compareStringsCaseInsensitive;
    exports2.compareStringsCaseSensitive = compareStringsCaseSensitive;
    exports2.getStringComparer = getStringComparer;
    exports2.equateStringsCaseInsensitive = equateStringsCaseInsensitive;
    exports2.equateStringsCaseSensitive = equateStringsCaseSensitive;
    exports2.getCharacterCount = getCharacterCount;
    exports2.getLastDottedString = getLastDottedString;
    exports2.truncate = truncate;
    exports2.escapeRegExp = escapeRegExp;
    var core_1 = require_core();
    function isPatternInSymbol(typedValue, symbolName) {
      const typedLower = typedValue.toLocaleLowerCase();
      const symbolLower = symbolName.toLocaleLowerCase();
      const typedLength = typedLower.length;
      const symbolLength = symbolLower.length;
      let typedPos = 0;
      let symbolPos = 0;
      while (typedPos < typedLength && symbolPos < symbolLength) {
        if (typedLower[typedPos] === symbolLower[symbolPos]) {
          typedPos += 1;
        }
        symbolPos += 1;
      }
      return typedPos === typedLength;
    }
    function hashString(contents) {
      let hash = 0;
      for (let i = 0; i < contents.length; i++) {
        hash = (hash << 5) - hash + contents.charCodeAt(i) | 0;
      }
      return hash;
    }
    function compareStringsCaseInsensitive(a, b) {
      return a === b ? 0 : a === void 0 ? -1 : b === void 0 ? 1 : (0, core_1.compareComparableValues)(a.toUpperCase(), b.toUpperCase());
    }
    function compareStringsCaseSensitive(a, b) {
      return (0, core_1.compareComparableValues)(a, b);
    }
    function getStringComparer(ignoreCase) {
      return ignoreCase ? compareStringsCaseInsensitive : compareStringsCaseSensitive;
    }
    function equateStringsCaseInsensitive(a, b) {
      return compareStringsCaseInsensitive(a, b) === 0;
    }
    function equateStringsCaseSensitive(a, b) {
      return compareStringsCaseSensitive(a, b) === 0;
    }
    function getCharacterCount(value, ch) {
      let result = 0;
      for (let i = 0; i < value.length; i++) {
        if (value[i] === ch) {
          result++;
        }
      }
      return result;
    }
    function getLastDottedString(text) {
      const index = text.lastIndexOf(".");
      return index > 0 ? text.substring(index + 1) : text;
    }
    function truncate(text, maxLength) {
      if (text.length > maxLength) {
        return text.substring(0, maxLength - "...".length) + "...";
      }
      return text;
    }
    function escapeRegExp(text) {
      return text.replace(/[\\^$.*+?()[\]{}|]/g, "\\$&");
    }
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/pathUtils.js
var require_pathUtils = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/pathUtils.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.FileSpec = void 0;
    exports2.getDirectoryPath = getDirectoryPath;
    exports2.getRootLength = getRootLength;
    exports2.getPathSeparator = getPathSeparator;
    exports2.getPathComponents = getPathComponents;
    exports2.reducePathComponents = reducePathComponents;
    exports2.combinePathComponents = combinePathComponents;
    exports2.getRelativePath = getRelativePath;
    exports2.normalizeSlashes = normalizeSlashes;
    exports2.resolvePaths = resolvePaths;
    exports2.combinePaths = combinePaths;
    exports2.containsPath = containsPath;
    exports2.changeAnyExtension = changeAnyExtension;
    exports2.getAnyExtensionFromPath = getAnyExtensionFromPath;
    exports2.getBaseFileName = getBaseFileName;
    exports2.getRelativePathFromDirectory = getRelativePathFromDirectory;
    exports2.getRelativePathComponentsFromDirectory = getRelativePathComponentsFromDirectory;
    exports2.ensureTrailingDirectorySeparator = ensureTrailingDirectorySeparator;
    exports2.hasTrailingDirectorySeparator = hasTrailingDirectorySeparator;
    exports2.stripTrailingDirectorySeparator = stripTrailingDirectorySeparator;
    exports2.getFileExtension = getFileExtension;
    exports2.getFileName = getFileName;
    exports2.getShortenedFileName = getShortenedFileName;
    exports2.stripFileExtension = stripFileExtension;
    exports2.normalizePath = normalizePath;
    exports2.getWildcardRegexPattern = getWildcardRegexPattern;
    exports2.isDirectoryWildcardPatternPresent = isDirectoryWildcardPatternPresent;
    exports2.getWildcardRoot = getWildcardRoot;
    exports2.hasPythonExtension = hasPythonExtension;
    exports2.getRegexEscapedSeparator = getRegexEscapedSeparator;
    exports2.isRootedDiskPath = isRootedDiskPath;
    exports2.isDiskPathRoot = isDiskPathRoot;
    var path13 = __importStar(require("path"));
    var collectionUtils_1 = require_collectionUtils();
    var core_1 = require_core();
    var debug = __importStar(require_debug());
    var stringUtils_1 = require_stringUtils();
    var _includeFileRegex = /\.pyi?$/;
    var _wildcardRootRegex = /[*?]/;
    var FileSpec;
    (function(FileSpec2) {
      function is(value) {
        const candidate = value;
        return candidate && !!candidate.wildcardRoot && !!candidate.regExp;
      }
      FileSpec2.is = is;
      function isInPath(path14, paths) {
        return !!paths.find((p) => p.regExp.test(path14));
      }
      FileSpec2.isInPath = isInPath;
      function matchesIncludeFileRegex(filePath, isFile = true) {
        return isFile ? _includeFileRegex.test(filePath) : true;
      }
      FileSpec2.matchesIncludeFileRegex = matchesIncludeFileRegex;
      function matchIncludeFileSpec(includeRegExp, exclude, filePath, isFile = true) {
        if (includeRegExp.test(filePath)) {
          if (!FileSpec2.isInPath(filePath, exclude) && FileSpec2.matchesIncludeFileRegex(filePath, isFile)) {
            return true;
          }
        }
        return false;
      }
      FileSpec2.matchIncludeFileSpec = matchIncludeFileSpec;
    })(FileSpec || (exports2.FileSpec = FileSpec = {}));
    function getDirectoryPath(pathString) {
      return pathString.substr(0, Math.max(getRootLength(pathString), pathString.lastIndexOf(path13.sep)));
    }
    function getRootLength(pathString, sep2 = path13.sep) {
      if (pathString.charAt(0) === sep2) {
        if (pathString.charAt(1) !== sep2) {
          return 1;
        }
        const p1 = pathString.indexOf(sep2, 2);
        if (p1 < 0) {
          return pathString.length;
        }
        return p1 + 1;
      }
      if (pathString.charAt(1) === ":") {
        if (pathString.charAt(2) === sep2) {
          return 3;
        }
        if (pathString.length === 2) {
          return 2;
        }
      }
      return 0;
    }
    function getPathSeparator(pathString) {
      return path13.sep;
    }
    function getPathComponents(pathString) {
      const normalizedPath = normalizeSlashes(pathString);
      const rootLength = getRootLength(normalizedPath);
      const root = normalizedPath.substring(0, rootLength);
      const sep2 = getPathSeparator(pathString);
      const rest = normalizedPath.substring(rootLength).split(sep2);
      if (rest.length > 0 && !rest[rest.length - 1]) {
        rest.pop();
      }
      return reducePathComponents([root, ...rest]);
    }
    function reducePathComponents(components) {
      if (!(0, collectionUtils_1.some)(components)) {
        return [];
      }
      const reduced = [components[0]];
      for (let i = 1; i < components.length; i++) {
        const component = components[i];
        if (!component || component === ".") {
          continue;
        }
        if (component === "..") {
          if (reduced.length > 1) {
            if (reduced[reduced.length - 1] !== "..") {
              reduced.pop();
              continue;
            }
          } else if (reduced[0]) {
            continue;
          }
        }
        reduced.push(component);
      }
      return reduced;
    }
    function combinePathComponents(components) {
      if (components.length === 0) {
        return "";
      }
      const root = components[0] && ensureTrailingDirectorySeparator(components[0]);
      const sep2 = getPathSeparator(root);
      return normalizeSlashes(root + components.slice(1).join(sep2));
    }
    function getRelativePath(dirPath, relativeTo) {
      if (!dirPath.startsWith(ensureTrailingDirectorySeparator(relativeTo))) {
        return void 0;
      }
      const pathComponents = getPathComponents(dirPath);
      const relativeToComponents = getPathComponents(relativeTo);
      const sep2 = getPathSeparator(dirPath);
      let relativePath = ".";
      for (let i = relativeToComponents.length; i < pathComponents.length; i++) {
        relativePath += sep2 + pathComponents[i];
      }
      return relativePath;
    }
    var separatorRegExp = /[\\/]/g;
    var getInvalidSeparator = (sep2) => sep2 === "/" ? "\\" : "/";
    function normalizeSlashes(pathString, sep2 = path13.sep) {
      if (pathString.includes(getInvalidSeparator(sep2))) {
        return pathString.replace(separatorRegExp, sep2);
      }
      return pathString;
    }
    function resolvePaths(path14, ...paths) {
      return normalizePath((0, collectionUtils_1.some)(paths) ? combinePaths(path14, ...paths) : normalizeSlashes(path14));
    }
    function combinePaths(pathString, ...paths) {
      if (pathString) {
        pathString = normalizeSlashes(pathString);
      }
      for (let relativePath of paths) {
        if (!relativePath) {
          continue;
        }
        relativePath = normalizeSlashes(relativePath);
        if (!pathString || getRootLength(relativePath) !== 0) {
          pathString = relativePath;
        } else {
          pathString = ensureTrailingDirectorySeparator(pathString) + relativePath;
        }
      }
      return pathString;
    }
    function containsPath(parent, child, currentDirectory, ignoreCase) {
      if (typeof currentDirectory === "string") {
        parent = combinePaths(currentDirectory, parent);
        child = combinePaths(currentDirectory, child);
      } else if (typeof currentDirectory === "boolean") {
        ignoreCase = currentDirectory;
      }
      if (parent === void 0 || child === void 0) {
        return false;
      }
      if (parent === child) {
        return true;
      }
      const parentComponents = getPathComponents(parent);
      const childComponents = getPathComponents(child);
      if (childComponents.length < parentComponents.length) {
        return false;
      }
      const componentEqualityComparer = ignoreCase ? stringUtils_1.equateStringsCaseInsensitive : stringUtils_1.equateStringsCaseSensitive;
      for (let i = 0; i < parentComponents.length; i++) {
        const equalityComparer = i === 0 ? stringUtils_1.equateStringsCaseInsensitive : componentEqualityComparer;
        if (!equalityComparer(parentComponents[i], childComponents[i])) {
          return false;
        }
      }
      return true;
    }
    function changeAnyExtension(path14, ext2, extensions2, ignoreCase) {
      const pathExt = extensions2 !== void 0 && ignoreCase !== void 0 ? getAnyExtensionFromPath(path14, extensions2, ignoreCase) : getAnyExtensionFromPath(path14);
      return pathExt ? path14.slice(0, path14.length - pathExt.length) + (ext2.startsWith(".") ? ext2 : "." + ext2) : path14;
    }
    function getAnyExtensionFromPath(path14, extensions2, ignoreCase) {
      if (extensions2) {
        return getAnyExtensionFromPathWorker(stripTrailingDirectorySeparator(path14), extensions2, ignoreCase ? stringUtils_1.equateStringsCaseInsensitive : stringUtils_1.equateStringsCaseSensitive);
      }
      const baseFileName = getBaseFileName(path14);
      const extensionIndex = baseFileName.lastIndexOf(".");
      if (extensionIndex >= 0) {
        return baseFileName.substring(extensionIndex);
      }
      return "";
    }
    function getBaseFileName(pathString, extensions2, ignoreCase) {
      pathString = normalizeSlashes(pathString);
      const rootLength = getRootLength(pathString);
      if (rootLength === pathString.length) {
        return "";
      }
      pathString = stripTrailingDirectorySeparator(pathString);
      const name = pathString.slice(Math.max(getRootLength(pathString), pathString.lastIndexOf(path13.sep) + 1));
      const extension = extensions2 !== void 0 && ignoreCase !== void 0 ? getAnyExtensionFromPath(name, extensions2, ignoreCase) : void 0;
      return extension ? name.slice(0, name.length - extension.length) : name;
    }
    function getRelativePathFromDirectory(fromDirectory, to, getCanonicalFileNameOrIgnoreCase) {
      const pathComponents = getRelativePathComponentsFromDirectory(fromDirectory, to, getCanonicalFileNameOrIgnoreCase);
      return combinePathComponents(pathComponents);
    }
    function getRelativePathComponentsFromDirectory(fromDirectory, to, getCanonicalFileNameOrIgnoreCase) {
      debug.assert(getRootLength(fromDirectory) > 0 === getRootLength(to) > 0, "Paths must either both be absolute or both be relative");
      const getCanonicalFileName = typeof getCanonicalFileNameOrIgnoreCase === "function" ? getCanonicalFileNameOrIgnoreCase : core_1.identity;
      const ignoreCase = typeof getCanonicalFileNameOrIgnoreCase === "boolean" ? getCanonicalFileNameOrIgnoreCase : false;
      const pathComponents = getPathComponentsRelativeTo(fromDirectory, to, ignoreCase ? stringUtils_1.equateStringsCaseInsensitive : stringUtils_1.equateStringsCaseSensitive, getCanonicalFileName);
      return pathComponents;
    }
    function ensureTrailingDirectorySeparator(pathString) {
      const sep2 = getPathSeparator(pathString);
      if (!hasTrailingDirectorySeparator(pathString)) {
        return pathString + sep2;
      }
      return pathString;
    }
    function hasTrailingDirectorySeparator(pathString) {
      if (pathString.length === 0) {
        return false;
      }
      const ch = pathString.charCodeAt(pathString.length - 1);
      return ch === 47 || ch === 92;
    }
    function stripTrailingDirectorySeparator(pathString) {
      if (!hasTrailingDirectorySeparator(pathString)) {
        return pathString;
      }
      return pathString.slice(0, pathString.length - 1);
    }
    function getFileExtension(fileName, multiDotExtension = false) {
      if (!multiDotExtension) {
        return path13.extname(fileName);
      }
      fileName = getFileName(fileName);
      const firstDotIndex = fileName.indexOf(".");
      return fileName.slice(firstDotIndex);
    }
    function getFileName(pathString) {
      return path13.basename(pathString);
    }
    function getShortenedFileName(pathString, maxDirLength = 15) {
      const fileName = getFileName(pathString);
      const dirName = getDirectoryPath(pathString);
      if (dirName.length > maxDirLength) {
        return `...${dirName.slice(dirName.length - maxDirLength)}${path13.sep}${fileName}`;
      }
      return pathString;
    }
    function stripFileExtension(fileName, multiDotExtension = false) {
      const ext2 = getFileExtension(fileName, multiDotExtension);
      return fileName.substr(0, fileName.length - ext2.length);
    }
    function normalizePath(pathString) {
      return normalizeSlashes(path13.normalize(pathString));
    }
    function getWildcardRegexPattern(rootPath, fileSpec) {
      let absolutePath = normalizePath(combinePaths(rootPath, fileSpec));
      if (!hasPythonExtension(absolutePath)) {
        absolutePath = ensureTrailingDirectorySeparator(absolutePath);
      }
      const pathComponents = getPathComponents(absolutePath);
      const escapedSeparator = getRegexEscapedSeparator(getPathSeparator(rootPath));
      const doubleAsteriskRegexFragment = `(${escapedSeparator}[^${escapedSeparator}][^${escapedSeparator}]*)*?`;
      const reservedCharacterPattern = new RegExp(`[^\\w\\s${escapedSeparator}]`, "g");
      if (pathComponents.length > 0) {
        pathComponents[0] = stripTrailingDirectorySeparator(pathComponents[0]);
        if (pathComponents[0].startsWith("\\\\")) {
          pathComponents[0] = "\\\\" + pathComponents[0];
        }
      }
      let regExPattern = "";
      let firstComponent = true;
      for (let component of pathComponents) {
        if (component === "**") {
          regExPattern += doubleAsteriskRegexFragment;
        } else {
          if (!firstComponent) {
            component = escapedSeparator + component;
          }
          regExPattern += component.replace(reservedCharacterPattern, (match2) => {
            if (match2 === "*") {
              return `[^${escapedSeparator}]*`;
            } else if (match2 === "?") {
              return `[^${escapedSeparator}]`;
            } else {
              return "\\" + match2;
            }
          });
          firstComponent = false;
        }
      }
      return regExPattern;
    }
    function isDirectoryWildcardPatternPresent(fileSpec) {
      const path14 = normalizePath(fileSpec);
      const pathComponents = getPathComponents(path14);
      for (const component of pathComponents) {
        if (component === "**") {
          return true;
        }
      }
      return false;
    }
    function getWildcardRoot(rootPath, fileSpec) {
      let absolutePath = normalizePath(combinePaths(rootPath, fileSpec));
      if (!hasPythonExtension(absolutePath)) {
        absolutePath = ensureTrailingDirectorySeparator(absolutePath);
      }
      const pathComponents = getPathComponents(absolutePath);
      const sep2 = getPathSeparator(absolutePath);
      if (pathComponents.length > 0) {
        pathComponents[0] = stripTrailingDirectorySeparator(pathComponents[0]);
      }
      if (pathComponents.length === 1 && !pathComponents[0]) {
        return sep2;
      }
      let wildcardRoot = "";
      let firstComponent = true;
      for (let component of pathComponents) {
        if (component === "**") {
          break;
        } else {
          if (component.match(_wildcardRootRegex)) {
            break;
          }
          if (!firstComponent) {
            component = sep2 + component;
          }
          wildcardRoot += component;
          firstComponent = false;
        }
      }
      return wildcardRoot;
    }
    function hasPythonExtension(path14) {
      return path14.endsWith(".py") || path14.endsWith(".pyi");
    }
    function getRegexEscapedSeparator(pathSep = path13.sep) {
      return pathSep === "/" ? "/" : "\\\\";
    }
    function isRootedDiskPath(path14) {
      return getRootLength(path14) > 0;
    }
    function isDiskPathRoot(path14) {
      const rootLength = getRootLength(path14);
      return rootLength > 0 && rootLength === path14.length;
    }
    function getAnyExtensionFromPathWorker(path14, extensions2, stringEqualityComparer) {
      if (typeof extensions2 === "string") {
        return tryGetExtensionFromPath(path14, extensions2, stringEqualityComparer) || "";
      }
      for (const extension of extensions2) {
        const result = tryGetExtensionFromPath(path14, extension, stringEqualityComparer);
        if (result) {
          return result;
        }
      }
      return "";
    }
    function tryGetExtensionFromPath(path14, extension, stringEqualityComparer) {
      if (!extension.startsWith(".")) {
        extension = "." + extension;
      }
      if (path14.length >= extension.length && path14.charCodeAt(path14.length - extension.length) === 46) {
        const pathExtension = path14.slice(path14.length - extension.length);
        if (stringEqualityComparer(pathExtension, extension)) {
          return pathExtension;
        }
      }
      return void 0;
    }
    function getPathComponentsRelativeTo(from, to, stringEqualityComparer, getCanonicalFileName) {
      const fromComponents = getPathComponents(from);
      const toComponents = getPathComponents(to);
      let start;
      for (start = 0; start < fromComponents.length && start < toComponents.length; start++) {
        const fromComponent = getCanonicalFileName(fromComponents[start]);
        const toComponent = getCanonicalFileName(toComponents[start]);
        const comparer = start === 0 ? stringUtils_1.equateStringsCaseInsensitive : stringEqualityComparer;
        if (!comparer(fromComponent, toComponent)) {
          break;
        }
      }
      if (start === 0) {
        return toComponents;
      }
      const components = toComponents.slice(start);
      const relative = [];
      for (; start < fromComponents.length; start++) {
        relative.push("..");
      }
      return ["", ...relative, ...components];
    }
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/serviceProvider.js
var require_serviceProvider = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/serviceProvider.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ServiceProvider = exports2.GroupServiceKey = exports2.ServiceKey = void 0;
    var collectionUtils_1 = require_collectionUtils();
    var core_1 = require_core();
    var debug = __importStar(require_debug());
    var InternalKey = class {
    };
    var ServiceKey = class extends InternalKey {
      constructor(id) {
        super();
        this.id = id;
        this.kind = "singleton";
      }
    };
    exports2.ServiceKey = ServiceKey;
    var GroupServiceKey = class extends InternalKey {
      constructor(id) {
        super();
        this.id = id;
        this.kind = "group";
      }
    };
    exports2.GroupServiceKey = GroupServiceKey;
    var ServiceProvider = class _ServiceProvider {
      constructor() {
        this._container = /* @__PURE__ */ new Map();
      }
      add(key, value) {
        if (key.kind === "group") {
          this._addGroupService(key, value);
          return;
        }
        if (key.kind === "singleton") {
          if (value !== void 0) {
            this._container.set(key.id, value);
          } else {
            this.remove(key);
          }
          return;
        }
        debug.assertNever(key, `Unknown key type ${typeof key}`);
      }
      remove(key, value) {
        if (key.kind === "group") {
          this._removeGroupService(key, value);
          return;
        }
        if (key.kind === "singleton") {
          this._container.delete(key.id);
          return;
        }
        debug.assertNever(key, `Unknown key type ${typeof key}`);
      }
      tryGet(key) {
        return this._container.get(key.id);
      }
      get(key) {
        const value = key.kind === "group" ? this.tryGet(key) : this.tryGet(key);
        if (value === void 0) {
          throw new Error(`Global service provider not initialized for ${key.toString()}`);
        }
        return value;
      }
      clone() {
        const serviceProvider = new _ServiceProvider();
        this._container.forEach((value, key) => {
          if (Array.isArray(value)) {
            serviceProvider._container.set(key, [...value ?? []]);
          } else if (value.clone !== void 0) {
            serviceProvider._container.set(key, value.clone());
          } else {
            serviceProvider._container.set(key, value);
          }
        });
        return serviceProvider;
      }
      dispose() {
        for (const service of this._container.values()) {
          if (core_1.Disposable.is(service)) {
            service.dispose();
          }
        }
      }
      _addGroupService(key, newValue) {
        const services2 = this.tryGet(key);
        if (services2 === void 0) {
          this._container.set(key.id, [newValue]);
          return;
        }
        if (newValue !== void 0) {
          (0, collectionUtils_1.addIfUnique)(services2, newValue);
        }
      }
      _removeGroupService(key, oldValue) {
        const services2 = this.tryGet(key);
        if (services2 === void 0) {
          return;
        }
        (0, collectionUtils_1.removeArrayElements)(services2, (s) => s === oldValue);
      }
    };
    exports2.ServiceProvider = ServiceProvider;
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/serviceKeys.js
var require_serviceKeys = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/serviceKeys.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ServiceKeys = void 0;
    var serviceProvider_1 = require_serviceProvider();
    var ServiceKeys;
    (function(ServiceKeys2) {
      ServiceKeys2.fs = new serviceProvider_1.ServiceKey("fs");
      ServiceKeys2.console = new serviceProvider_1.ServiceKey("ConsoleInterface");
      ServiceKeys2.sourceFileFactory = new serviceProvider_1.ServiceKey("ISourceFileFactory");
      ServiceKeys2.partialStubs = new serviceProvider_1.ServiceKey("SupportPartialStubs");
      ServiceKeys2.symbolDefinitionProvider = new serviceProvider_1.GroupServiceKey("SymbolDefinitionProvider");
      ServiceKeys2.symbolUsageProviderFactory = new serviceProvider_1.GroupServiceKey("SymbolUsageProviderFactory");
      ServiceKeys2.stateMutationListeners = new serviceProvider_1.GroupServiceKey("StatusMutationListener");
      ServiceKeys2.tempFile = new serviceProvider_1.ServiceKey("TempFile");
      ServiceKeys2.cacheManager = new serviceProvider_1.ServiceKey("CacheManager");
      ServiceKeys2.debugInfoInspector = new serviceProvider_1.ServiceKey("DebugInfoInspector");
      ServiceKeys2.caseSensitivityDetector = new serviceProvider_1.ServiceKey("CaseSensitivityDetector");
      ServiceKeys2.docStringService = new serviceProvider_1.ServiceKey("DocStringService");
      ServiceKeys2.windowService = new serviceProvider_1.ServiceKey("WindowService");
      ServiceKeys2.commandService = new serviceProvider_1.ServiceKey("CommandService");
      ServiceKeys2.cancellationProvider = new serviceProvider_1.ServiceKey("CancellationProvider");
    })(ServiceKeys || (exports2.ServiceKeys = ServiceKeys = {}));
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/uri/memoization.js
var require_memoization = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/uri/memoization.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.cacheProperty = cacheProperty;
    exports2.cacheMethodWithNoArgs = cacheMethodWithNoArgs;
    exports2.cacheStaticFunc = cacheStaticFunc;
    var staticCache = /* @__PURE__ */ new Map();
    var maxStaticCacheEntries = 256;
    function cacheProperty() {
      return function(target, functionName, descriptor) {
        const originalMethod = descriptor.get;
        descriptor.get = function(...args) {
          const result = originalMethod.apply(this, args);
          Object.defineProperty(this, functionName, {
            get() {
              return result;
            }
          });
          return result;
        };
        return descriptor;
      };
    }
    function cacheMethodWithNoArgs() {
      return function(target, functionName, descriptor) {
        const originalMethod = descriptor.value;
        descriptor.value = function(...args) {
          const result = originalMethod.apply(this, args);
          this[functionName] = () => {
            return result;
          };
          return result;
        };
        return descriptor;
      };
    }
    function cacheStaticFunc() {
      return function cacheStaticFunc_Fast(target, functionName, descriptor) {
        const originalMethod = descriptor.value;
        descriptor.value = function(...args) {
          const key = `${functionName}+${args == null ? void 0 : args.map((a) => a == null ? void 0 : a.toString()).join(",")}`;
          if (staticCache.has(key)) {
            const value = staticCache.get(key);
            staticCache.delete(key);
            staticCache.set(key, value);
            return value;
          }
          const result = originalMethod.apply(this, args);
          if (staticCache.size >= maxStaticCacheEntries) {
            const lruKey = staticCache.keys().next().value;
            if (lruKey !== void 0) {
              staticCache.delete(lruKey);
            }
          }
          staticCache.set(key, result);
          return result;
        };
        return descriptor;
      };
    }
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/uri/baseUri.js
var require_baseUri = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/uri/baseUri.js"(exports2) {
    "use strict";
    var __decorate = exports2 && exports2.__decorate || function(decorators, target, key, desc) {
      var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
      if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
      else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
      return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.BaseUri = void 0;
    var collectionUtils_1 = require_collectionUtils();
    var pathUtils_1 = require_pathUtils();
    var memoization_1 = require_memoization();
    var backslashRegEx = /\\/g;
    var BaseUri = class {
      constructor(_key) {
        this._key = _key;
      }
      // Unique key for storing in maps.
      get key() {
        return this._key;
      }
      // Returns just the fileName without any extensions
      get fileNameWithoutExtensions() {
        const fileName = this.fileName;
        const index = fileName.lastIndexOf(".");
        if (index > 0) {
          return fileName.slice(0, index);
        } else {
          return fileName;
        }
      }
      // Returns a URI where the path contains the path with .py appended.
      get packageUri() {
        return this.addExtension(".py");
      }
      // Returns a URI where the path contains the path with .pyi appended.
      get packageStubUri() {
        return this.addExtension(".pyi");
      }
      // Returns a URI where the path has __init__.py appended.
      get initPyUri() {
        return this.combinePathsUnsafe("__init__.py");
      }
      // Returns a URI where the path has __init__.pyi appended.
      get initPyiUri() {
        return this.combinePathsUnsafe("__init__.pyi");
      }
      // Returns a URI where the path has py.typed appended.
      get pytypedUri() {
        return this.combinePathsUnsafe("py.typed");
      }
      isEmpty() {
        return false;
      }
      replaceExtension(ext2) {
        const dir = this.getDirectory();
        const base = this.fileName;
        const newBase = base.slice(0, base.length - this.lastExtension.length) + ext2;
        return dir.combinePathsUnsafe(newBase);
      }
      addExtension(ext2) {
        return this.addPath(ext2);
      }
      hasExtension(ext2) {
        return this.isCaseSensitive ? this.lastExtension === ext2 : this.lastExtension.toLowerCase() === ext2.toLowerCase();
      }
      containsExtension(ext2) {
        const fileName = this.fileName;
        const extensions2 = fileName.split(/(?=\.)/g);
        return extensions2.some((e) => this.isCaseSensitive ? e === ext2 : e.toLowerCase() === ext2.toLowerCase());
      }
      getRootPathLength() {
        return this.getRootPath().length;
      }
      isUntitled() {
        return this.scheme === "untitled";
      }
      equals(other) {
        return this.key === (other == null ? void 0 : other.key);
      }
      pathStartsWith(name) {
        return this.getComparablePath().startsWith(name);
      }
      pathEndsWith(name) {
        return this.getComparablePath().endsWith(name);
      }
      pathIncludes(include) {
        return this.getComparablePath().includes(include);
      }
      getRelativePath(child) {
        if (this.scheme !== child.scheme) {
          return void 0;
        }
        if (child.isChild(this)) {
          const relativeToComponents = this.getRelativePathComponents(child);
          if (relativeToComponents.length > 0) {
            return [".", ...relativeToComponents].join("/");
          }
        }
        return void 0;
      }
      getPathComponents() {
        return Object.freeze(this.getPathComponentsImpl());
      }
      getRelativePathComponents(to) {
        const fromComponents = this.getPathComponents();
        const toComponents = to.getPathComponents();
        let start;
        for (start = 0; start < fromComponents.length && start < toComponents.length; start++) {
          const fromComponent = fromComponents[start];
          const toComponent = toComponents[start];
          const match2 = this.isCaseSensitive ? fromComponent === toComponent : fromComponent.toLowerCase() === toComponent.toLowerCase();
          if (!match2) {
            break;
          }
        }
        if (start === 0) {
          return toComponents;
        }
        const components = toComponents.slice(start);
        const relative = [];
        for (; start < fromComponents.length; start++) {
          relative.push("..");
        }
        return [...relative, ...components];
      }
      getShortenedFileName(maxDirLength = 15) {
        return (0, pathUtils_1.getShortenedFileName)(this.getPath(), maxDirLength);
      }
      normalizeSlashes(path13) {
        if (path13.includes("\\")) {
          return path13.replace(backslashRegEx, "/");
        }
        return path13;
      }
      static combinePathElements(pathString, separator, ...paths) {
        for (const relativePath of paths) {
          if (!relativePath) {
            continue;
          }
          if (!pathString || (0, pathUtils_1.getRootLength)(relativePath) !== 0) {
            pathString = relativePath;
          } else if (pathString.endsWith(separator)) {
            pathString += relativePath;
          } else {
            pathString += separator + relativePath;
          }
        }
        return pathString;
      }
      reducePathComponents(components) {
        if (!(0, collectionUtils_1.some)(components)) {
          return [];
        }
        const reduced = [components[0]];
        for (let i = 1; i < components.length; i++) {
          const component = components[i];
          if (!component || component === ".") {
            continue;
          }
          if (component === "..") {
            if (reduced.length > 1) {
              if (reduced[reduced.length - 1] !== "..") {
                reduced.pop();
                continue;
              }
            } else if (reduced[0]) {
              continue;
            }
          }
          reduced.push(component);
        }
        return reduced;
      }
    };
    exports2.BaseUri = BaseUri;
    __decorate([
      (0, memoization_1.cacheProperty)()
    ], BaseUri.prototype, "packageUri", null);
    __decorate([
      (0, memoization_1.cacheProperty)()
    ], BaseUri.prototype, "packageStubUri", null);
    __decorate([
      (0, memoization_1.cacheProperty)()
    ], BaseUri.prototype, "initPyUri", null);
    __decorate([
      (0, memoization_1.cacheProperty)()
    ], BaseUri.prototype, "initPyiUri", null);
    __decorate([
      (0, memoization_1.cacheProperty)()
    ], BaseUri.prototype, "pytypedUri", null);
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/uri/constantUri.js
var require_constantUri = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/uri/constantUri.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ConstantUri = void 0;
    var baseUri_1 = require_baseUri();
    var ConstantUri = class extends baseUri_1.BaseUri {
      constructor(name) {
        super(name);
      }
      get scheme() {
        return "";
      }
      get isCaseSensitive() {
        return true;
      }
      get fileName() {
        return "";
      }
      get lastExtension() {
        return "";
      }
      get root() {
        return this;
      }
      get fragment() {
        return "";
      }
      get query() {
        return "";
      }
      equals(other) {
        return this === other;
      }
      toJsonObj() {
        throw new Error(`constant uri can't be serialized`);
      }
      toString() {
        return this.key;
      }
      toUserVisibleString() {
        return "";
      }
      matchesRegex(regex) {
        return false;
      }
      withFragment(fragment) {
        return this;
      }
      withQuery(query) {
        return this;
      }
      addPath(extra) {
        return this;
      }
      getDirectory() {
        return this;
      }
      isRoot() {
        return false;
      }
      isChild(parent, ignoreCase) {
        return false;
      }
      isLocal() {
        return false;
      }
      startsWith(other, ignoreCase) {
        return false;
      }
      getPathLength() {
        return 0;
      }
      resolvePaths(...paths) {
        return this;
      }
      combinePaths(...paths) {
        return this;
      }
      combinePathsUnsafe(...paths) {
        return this;
      }
      getPath() {
        return "";
      }
      getFilePath() {
        return "";
      }
      stripExtension() {
        return this;
      }
      stripAllExtensions() {
        return this;
      }
      getRootPath() {
        return "";
      }
      getComparablePath() {
        return "";
      }
      getPathComponentsImpl() {
        return [];
      }
    };
    exports2.ConstantUri = ConstantUri;
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/uri/emptyUri.js
var require_emptyUri = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/uri/emptyUri.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.EmptyUri = void 0;
    var constantUri_1 = require_constantUri();
    var EmptyKey = "<empty>";
    var EmptyUri = class _EmptyUri extends constantUri_1.ConstantUri {
      constructor() {
        super(EmptyKey);
      }
      static get instance() {
        return _EmptyUri._instance;
      }
      toJsonObj() {
        return {
          _key: EmptyKey
        };
      }
      static isEmptyUri(uri) {
        return (uri == null ? void 0 : uri._key) === EmptyKey;
      }
      isEmpty() {
        return true;
      }
      toString() {
        return "";
      }
    };
    exports2.EmptyUri = EmptyUri;
    EmptyUri._instance = new EmptyUri();
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/uri/fileUri.js
var require_fileUri = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/uri/fileUri.js"(exports2) {
    "use strict";
    var __decorate = exports2 && exports2.__decorate || function(decorators, target, key, desc) {
      var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
      if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
      else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
      return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.FileUri = exports2.FileUriSchema = void 0;
    var vscode_uri_1 = require_umd();
    var core_1 = require_core();
    var pathUtils_1 = require_pathUtils();
    var baseUri_1 = require_baseUri();
    var memoization_1 = require_memoization();
    exports2.FileUriSchema = "file";
    var FileUri = class _FileUri extends baseUri_1.BaseUri {
      constructor(key, _filePath, _query, _fragment, _originalString, _isCaseSensitive) {
        super(_isCaseSensitive ? key : key.toLowerCase());
        this._filePath = _filePath;
        this._query = _query;
        this._fragment = _fragment;
        this._originalString = _originalString;
        this._isCaseSensitive = _isCaseSensitive;
      }
      get scheme() {
        return exports2.FileUriSchema;
      }
      get fragment() {
        return this._fragment;
      }
      get query() {
        return this._query;
      }
      get fileName() {
        return (0, pathUtils_1.getFileName)(this._filePath);
      }
      get lastExtension() {
        return (0, pathUtils_1.getFileExtension)(this._filePath);
      }
      get root() {
        const rootPath = this.getRootPath();
        if (rootPath !== this._filePath) {
          return _FileUri.createFileUri(rootPath, "", "", void 0, this._isCaseSensitive);
        }
        return this;
      }
      get isCaseSensitive() {
        return this._isCaseSensitive;
      }
      static createFileUri(filePath, query, fragment, originalString, isCaseSensitive) {
        filePath = (0, pathUtils_1.isDiskPathRoot)(filePath) ? (0, pathUtils_1.ensureTrailingDirectorySeparator)(filePath) : filePath;
        const key = _FileUri._createKey(filePath, query, fragment);
        return new _FileUri(key, filePath, query, fragment, originalString, isCaseSensitive);
      }
      static isFileUri(uri) {
        return (uri == null ? void 0 : uri._filePath) !== void 0 && (uri == null ? void 0 : uri._key) !== void 0;
      }
      static fromJsonObj(obj) {
        if ((0, core_1.isArray)(obj)) {
          const so = obj;
          return _FileUri.createFileUri(so[1], so[2], so[3], so[4], so[5] === 1 ? true : false);
        }
        return _FileUri.createFileUri(obj._filePath, obj._query, obj._fragment, obj._originalString, obj._isCaseSensitive);
      }
      toJsonObj() {
        const jsonObj = [
          0,
          this._filePath,
          this._query,
          this._fragment,
          this._originalString,
          this._isCaseSensitive ? 1 : 0
        ];
        return jsonObj;
      }
      matchesRegex(regex) {
        return regex.test(this._getNormalizedPath());
      }
      toString() {
        if (!this._formattedString) {
          this._formattedString = this._originalString || vscode_uri_1.URI.file(this._filePath).with({ query: this._query, fragment: this._fragment }).toString();
        }
        return this._formattedString;
      }
      toUserVisibleString() {
        return this._filePath;
      }
      addPath(extra) {
        return _FileUri.createFileUri(this._filePath + extra, "", "", void 0, this._isCaseSensitive);
      }
      isRoot() {
        return (0, pathUtils_1.isDiskPathRoot)(this._filePath);
      }
      isChild(parent) {
        if (!_FileUri.isFileUri(parent)) {
          return false;
        }
        return parent._filePath.length < this._filePath.length && this.startsWith(parent);
      }
      isLocal() {
        return true;
      }
      startsWith(other) {
        if ((other == null ? void 0 : other.scheme) !== this.scheme) {
          return false;
        }
        const otherFileUri = other;
        if (this._filePath.length >= otherFileUri._filePath.length) {
          const otherPath = this._filePath.length > otherFileUri._filePath.length && !(0, pathUtils_1.hasTrailingDirectorySeparator)(otherFileUri._filePath) ? (0, pathUtils_1.ensureTrailingDirectorySeparator)(otherFileUri._filePath) : otherFileUri._filePath;
          if (!this.isCaseSensitive) {
            return this._filePath.toLowerCase().startsWith(otherPath.toLowerCase());
          }
          return this._filePath.startsWith(otherPath);
        }
        return false;
      }
      getPathLength() {
        return this._filePath.length;
      }
      getPath() {
        return this._getNormalizedPath();
      }
      getFilePath() {
        return this._filePath;
      }
      resolvePaths(...paths) {
        let combined = (0, pathUtils_1.resolvePaths)(this._filePath, ...paths);
        if ((0, pathUtils_1.hasTrailingDirectorySeparator)(combined) && combined.length > 1) {
          combined = combined.slice(0, combined.length - 1);
        }
        if (combined !== this._filePath) {
          return _FileUri.createFileUri(combined, "", "", void 0, this._isCaseSensitive);
        }
        return this;
      }
      combinePaths(...paths) {
        if (paths.some((p) => p.includes("..") || p.includes(_FileUri._separator) || p.includes("/") || p === ".")) {
          return this.resolvePaths(...paths);
        }
        return this.combinePathsUnsafe(...paths);
      }
      combinePathsUnsafe(...paths) {
        const combined = baseUri_1.BaseUri.combinePathElements(this._filePath, _FileUri._separator, ...paths);
        if (combined !== this._filePath) {
          return _FileUri.createFileUri(combined, "", "", void 0, this._isCaseSensitive);
        }
        return this;
      }
      getDirectory() {
        const filePath = this._filePath;
        let dir = (0, pathUtils_1.getDirectoryPath)(filePath);
        if ((0, pathUtils_1.hasTrailingDirectorySeparator)(dir) && dir.length > 1) {
          dir = dir.slice(0, -1);
        }
        if (dir !== filePath) {
          return _FileUri.createFileUri(dir, "", "", void 0, this._isCaseSensitive);
        } else {
          return this;
        }
      }
      withFragment(fragment) {
        return _FileUri.createFileUri(this._filePath, this._query, fragment, void 0, this._isCaseSensitive);
      }
      withQuery(query) {
        return _FileUri.createFileUri(this._filePath, query, this._fragment, void 0, this._isCaseSensitive);
      }
      stripExtension() {
        const stripped = (0, pathUtils_1.stripFileExtension)(this._filePath);
        if (stripped !== this._filePath) {
          return _FileUri.createFileUri(stripped, this._query, this._fragment, void 0, this._isCaseSensitive);
        }
        return this;
      }
      stripAllExtensions() {
        const stripped = (0, pathUtils_1.stripFileExtension)(
          this._filePath,
          /* multiDotExtension */
          true
        );
        if (stripped !== this._filePath) {
          return _FileUri.createFileUri(stripped, this._query, this._fragment, void 0, this._isCaseSensitive);
        }
        return this;
      }
      getPathComponentsImpl() {
        const components = (0, pathUtils_1.getPathComponents)(this._filePath);
        if (components.length > 0 && components[0] === "") {
          components.shift();
        }
        return components.map((component) => this.normalizeSlashes(component));
      }
      getRootPath() {
        return this._filePath.slice(0, (0, pathUtils_1.getRootLength)(this._filePath));
      }
      getComparablePath() {
        return this._getNormalizedPath();
      }
      static _createKey(filePath, query, fragment) {
        return `${filePath}${query ? "?" + query : ""}${fragment ? "#" + fragment : ""}`;
      }
      _getNormalizedPath() {
        if (this._normalizedPath === void 0) {
          this._normalizedPath = this.normalizeSlashes(this._filePath);
        }
        return this._normalizedPath;
      }
    };
    exports2.FileUri = FileUri;
    FileUri._separator = (0, pathUtils_1.getPathSeparator)("");
    __decorate([
      (0, memoization_1.cacheProperty)()
    ], FileUri.prototype, "fileName", null);
    __decorate([
      (0, memoization_1.cacheProperty)()
    ], FileUri.prototype, "lastExtension", null);
    __decorate([
      (0, memoization_1.cacheProperty)()
    ], FileUri.prototype, "root", null);
    __decorate([
      (0, memoization_1.cacheMethodWithNoArgs)()
    ], FileUri.prototype, "getDirectory", null);
    __decorate([
      (0, memoization_1.cacheStaticFunc)()
    ], FileUri, "createFileUri", null);
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/uri/webUri.js
var require_webUri = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/uri/webUri.js"(exports2) {
    "use strict";
    var __decorate = exports2 && exports2.__decorate || function(decorators, target, key, desc) {
      var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
      if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
      else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
      return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.WebUri = void 0;
    var vscode_uri_1 = require_umd();
    var pathUtils_1 = require_pathUtils();
    var baseUri_1 = require_baseUri();
    var memoization_1 = require_memoization();
    var WebUri = class _WebUri extends baseUri_1.BaseUri {
      constructor(key, _scheme, _authority, _path, _query, _fragment, _originalString) {
        super(key);
        this._scheme = _scheme;
        this._authority = _authority;
        this._path = _path;
        this._query = _query;
        this._fragment = _fragment;
        this._originalString = _originalString;
      }
      get scheme() {
        return this._scheme;
      }
      get isCaseSensitive() {
        return true;
      }
      get fragment() {
        return this._fragment;
      }
      get query() {
        return this._query;
      }
      get root() {
        const rootPath = this.getRootPath();
        if (rootPath !== this._path) {
          return _WebUri.createWebUri(this._scheme, this._authority, rootPath, "", "", void 0);
        }
        return this;
      }
      get fileName() {
        const components = this._path.split("/");
        return components[components.length - 1];
      }
      get lastExtension() {
        const basename4 = this.fileName;
        const index = basename4.lastIndexOf(".");
        if (index >= 0) {
          return basename4.slice(index);
        }
        return "";
      }
      static createWebUri(scheme, authority, path13, query, fragment, originalString) {
        const key = _WebUri._createKey(scheme, authority, path13, query, fragment);
        return new _WebUri(key, scheme, authority, path13, query, fragment, originalString);
      }
      toString() {
        if (!this._originalString) {
          const vscodeUri = vscode_uri_1.URI.revive({
            scheme: this._scheme,
            authority: this._authority,
            path: this._path,
            query: this._query,
            fragment: this._fragment
          });
          this._originalString = vscodeUri.toString();
        }
        return this._originalString;
      }
      toUserVisibleString() {
        return this.toString();
      }
      static isWebUri(uri) {
        return (uri == null ? void 0 : uri._scheme) !== void 0 && (uri == null ? void 0 : uri._key) !== void 0;
      }
      static fromJsonObj(obj) {
        return _WebUri.createWebUri(obj._scheme, obj._authority, obj._path, obj._query, obj._fragment, obj._originalString);
      }
      toJsonObj() {
        return {
          _scheme: this._scheme,
          _authority: this._authority,
          _path: this._path,
          _query: this._query,
          _fragment: this._fragment,
          _originalString: this._originalString,
          _key: this.key
        };
      }
      matchesRegex(regex) {
        return regex.test(this._path);
      }
      addPath(extra) {
        const newPath = this._path + extra;
        return _WebUri.createWebUri(this._scheme, this._authority, newPath, this._query, this._fragment, void 0);
      }
      isRoot() {
        return this._path === this.getRootPath() && this._path.length > 0;
      }
      isChild(parent) {
        if (!_WebUri.isWebUri(parent)) {
          return false;
        }
        return parent._path.length < this._path.length && this.startsWith(parent);
      }
      isLocal() {
        return false;
      }
      startsWith(other) {
        if ((other == null ? void 0 : other.scheme) !== this.scheme) {
          return false;
        }
        const otherWebUri = other;
        if (this._path.length >= otherWebUri._path.length) {
          const otherPath = this._path.length > otherWebUri._path.length && !(0, pathUtils_1.hasTrailingDirectorySeparator)(otherWebUri._path) ? `${otherWebUri._path}/` : otherWebUri._path;
          return this._path.startsWith(otherPath);
        }
        return false;
      }
      getPathLength() {
        return this._path.length;
      }
      getPath() {
        return this._path;
      }
      getFilePath() {
        return "";
      }
      resolvePaths(...paths) {
        let combined = this.normalizeSlashes((0, pathUtils_1.resolvePaths)(this._path, ...paths));
        if ((0, pathUtils_1.hasTrailingDirectorySeparator)(combined) && combined.length > 1) {
          combined = combined.slice(0, combined.length - 1);
        }
        if (combined !== this._path) {
          return _WebUri.createWebUri(this._scheme, this._authority, combined, "", "", void 0);
        }
        return this;
      }
      combinePaths(...paths) {
        if (paths.some((p) => p.includes("..") || p.includes("/") || p === ".")) {
          return this.resolvePaths(...paths);
        }
        return this.combinePathsUnsafe(...paths);
      }
      combinePathsUnsafe(...paths) {
        const combined = baseUri_1.BaseUri.combinePathElements(this._path, "/", ...paths);
        if (combined !== this._path) {
          return _WebUri.createWebUri(this._scheme, this._authority, combined, "", "", void 0);
        }
        return this;
      }
      getDirectory() {
        if (this._path.length === 0) {
          return this;
        }
        const index = this._path.lastIndexOf("/");
        const newPath = index > 0 ? this._path.slice(0, index) : index === 0 ? "/" : "";
        return _WebUri.createWebUri(this._scheme, this._authority, newPath, this._query, this._fragment, void 0);
      }
      withFragment(fragment) {
        return _WebUri.createWebUri(this._scheme, this._authority, this._path, this._query, fragment, void 0);
      }
      withQuery(query) {
        return _WebUri.createWebUri(this._scheme, this._authority, this._path, query, this._fragment, void 0);
      }
      stripExtension() {
        const path13 = this._path;
        const index = path13.lastIndexOf(".");
        if (index > 0) {
          return _WebUri.createWebUri(this._scheme, this._authority, path13.slice(0, index), this._query, this._fragment, void 0);
        }
        return this;
      }
      stripAllExtensions() {
        const path13 = this._path;
        const sepIndex = path13.lastIndexOf("/");
        const index = path13.indexOf(".", sepIndex > 0 ? sepIndex : 0);
        if (index > 0) {
          return _WebUri.createWebUri(this._scheme, this._authority, path13.slice(0, index), this._query, this._fragment, void 0);
        }
        return this;
      }
      getPathComponentsImpl() {
        const rootPath = this.getRootPath();
        const otherPaths = this._path.slice(rootPath.length).split("/");
        return this.reducePathComponents([rootPath, ...otherPaths]).map((component) => this.normalizeSlashes(component));
      }
      getRootPath() {
        const rootLength = (0, pathUtils_1.getRootLength)(this._path, "/");
        return this._path.slice(0, rootLength);
      }
      getComparablePath() {
        return this._path;
      }
      static _createKey(scheme, authority, path13, query, fragment) {
        return `${scheme}:${authority}${path13}${query ? "?" + query : ""}${fragment ? "#" + fragment : ""}`;
      }
    };
    exports2.WebUri = WebUri;
    __decorate([
      (0, memoization_1.cacheProperty)()
    ], WebUri.prototype, "root", null);
    __decorate([
      (0, memoization_1.cacheProperty)()
    ], WebUri.prototype, "fileName", null);
    __decorate([
      (0, memoization_1.cacheProperty)()
    ], WebUri.prototype, "lastExtension", null);
    __decorate([
      (0, memoization_1.cacheMethodWithNoArgs)()
    ], WebUri.prototype, "getDirectory", null);
    __decorate([
      (0, memoization_1.cacheStaticFunc)()
    ], WebUri, "createWebUri", null);
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/uri/uri.js
var require_uri = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/uri/uri.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Uri = exports2.UriKinds = void 0;
    var vscode_uri_1 = require_umd();
    var caseSensitivityDetector_1 = require_caseSensitivityDetector();
    var core_1 = require_core();
    var pathUtils_1 = require_pathUtils();
    var serviceKeys_1 = require_serviceKeys();
    var constantUri_1 = require_constantUri();
    var emptyUri_1 = require_emptyUri();
    var fileUri_1 = require_fileUri();
    var webUri_1 = require_webUri();
    var UriKinds;
    (function(UriKinds2) {
      UriKinds2[UriKinds2["file"] = 0] = "file";
      UriKinds2[UriKinds2["web"] = 1] = "web";
      UriKinds2[UriKinds2["empty"] = 2] = "empty";
    })(UriKinds || (exports2.UriKinds = UriKinds = {}));
    var _dosPathRegex = /^\/[a-zA-Z]:\//;
    var _win32NormalizationRegex = /\//g;
    function getFilePath(uri) {
      let filePath;
      if (uri.authority && uri.path[0] === "/" && uri.path.length === 1) {
        filePath = `//${uri.authority}${uri.path}`;
      } else {
        filePath = uri.fsPath;
      }
      if (filePath.match(_dosPathRegex)) {
        filePath = filePath.slice(1);
      }
      if ((process == null ? void 0 : process.platform) === "win32") {
        filePath = filePath.replace(_win32NormalizationRegex, "\\");
      }
      return filePath;
    }
    function normalizeUri(uri) {
      const parsed = vscode_uri_1.URI.isUri(uri) ? uri : vscode_uri_1.URI.parse(uri);
      const finalURI = parsed.path.length > 0 ? vscode_uri_1.Utils.resolvePath(parsed) : parsed;
      const finalString = finalURI.toString();
      return { uri: finalURI, str: finalString };
    }
    var windowsUriRegEx = /^[a-zA-Z]:\\?/;
    var uriRegEx = /^[a-zA-Z][a-zA-Z0-9+.-]*:\/?\/?/;
    var Uri23;
    (function(Uri24) {
      function maybeUri(value) {
        return uriRegEx.test(value) && !windowsUriRegEx.test(value);
      }
      Uri24.maybeUri = maybeUri;
      function create(value, arg, checkRelative = false) {
        arg = caseSensitivityDetector_1.CaseSensitivityDetector.is(arg) ? arg : arg.get(serviceKeys_1.ServiceKeys.caseSensitivityDetector);
        if (maybeUri(value)) {
          return parse2(value, arg);
        }
        return file(value, arg, checkRelative);
      }
      Uri24.create = create;
      function file(path13, arg, checkRelative = false) {
        arg = caseSensitivityDetector_1.CaseSensitivityDetector.is(arg) ? arg : arg.get(serviceKeys_1.ServiceKeys.caseSensitivityDetector);
        path13 = checkRelative && !(0, pathUtils_1.isRootedDiskPath)(path13) ? (0, pathUtils_1.combinePaths)(process.cwd(), path13) : path13;
        const normalized = path13.startsWith("file:") ? normalizeUri(path13) : normalizeUri(vscode_uri_1.URI.file((0, pathUtils_1.normalizeSlashes)(path13)));
        return fileUri_1.FileUri.createFileUri(getFilePath(normalized.uri), normalized.uri.query, normalized.uri.fragment, normalized.str, arg.isCaseSensitive(normalized.str));
      }
      Uri24.file = file;
      function parse2(uriStr, arg) {
        if (!uriStr) {
          return Uri24.empty();
        }
        arg = caseSensitivityDetector_1.CaseSensitivityDetector.is(arg) ? arg : arg.get(serviceKeys_1.ServiceKeys.caseSensitivityDetector);
        const normalized = normalizeUri(uriStr);
        if (normalized.uri.scheme === fileUri_1.FileUriSchema) {
          return fileUri_1.FileUri.createFileUri(getFilePath(normalized.uri), normalized.uri.query, normalized.uri.fragment, normalized.str, arg.isCaseSensitive(normalized.str));
        }
        return webUri_1.WebUri.createWebUri(normalized.uri.scheme, normalized.uri.authority, normalized.uri.path, normalized.uri.query, normalized.uri.fragment, normalized.str);
      }
      Uri24.parse = parse2;
      function constant(markerName) {
        return new constantUri_1.ConstantUri(markerName);
      }
      Uri24.constant = constant;
      function empty() {
        return emptyUri_1.EmptyUri.instance;
      }
      Uri24.empty = empty;
      Uri24.DefaultWorkspaceRootComponent = "<default workspace root>";
      Uri24.DefaultWorkspaceRootPath = `/${Uri24.DefaultWorkspaceRootComponent}`;
      function defaultWorkspace(arg) {
        arg = caseSensitivityDetector_1.CaseSensitivityDetector.is(arg) ? arg : arg.get(serviceKeys_1.ServiceKeys.caseSensitivityDetector);
        return Uri24.file(Uri24.DefaultWorkspaceRootPath, arg);
      }
      Uri24.defaultWorkspace = defaultWorkspace;
      function fromJsonObj(jsonObj) {
        if ((0, core_1.isArray)(jsonObj)) {
          switch (jsonObj[0]) {
            case 0:
              return fileUri_1.FileUri.fromJsonObj(jsonObj);
          }
        }
        if (fileUri_1.FileUri.isFileUri(jsonObj)) {
          return fileUri_1.FileUri.fromJsonObj(jsonObj);
        }
        if (webUri_1.WebUri.isWebUri(jsonObj)) {
          return webUri_1.WebUri.fromJsonObj(jsonObj);
        }
        if (emptyUri_1.EmptyUri.isEmptyUri(jsonObj)) {
          return emptyUri_1.EmptyUri.instance;
        }
        return jsonObj;
      }
      Uri24.fromJsonObj = fromJsonObj;
      function is(thing) {
        return !!thing && typeof thing._key === "string";
      }
      Uri24.is = is;
      function isEmpty(uri) {
        return !uri || uri.isEmpty();
      }
      Uri24.isEmpty = isEmpty;
      function equals(a, b) {
        if (a === b) {
          return true;
        }
        return (a == null ? void 0 : a.equals(b)) ?? false;
      }
      Uri24.equals = equals;
      function isDefaultWorkspace(uri) {
        return uri.fileName.includes(Uri24.DefaultWorkspaceRootComponent);
      }
      Uri24.isDefaultWorkspace = isDefaultWorkspace;
    })(Uri23 || (exports2.Uri = Uri23 = {}));
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/diagnostic.js
var require_diagnostic = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/diagnostic.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DiagnosticAddendum = exports2.Diagnostic = exports2.DiagnosticRelatedInfo = exports2.DiagnosticCategory = exports2.TaskListPriority = exports2.defaultMaxDiagnosticLineCount = exports2.defaultMaxDiagnosticDepth = void 0;
    exports2.convertLevelToCategory = convertLevelToCategory;
    exports2.compareDiagnostics = compareDiagnostics;
    var collectionUtils_1 = require_collectionUtils();
    var uri_1 = require_uri();
    exports2.defaultMaxDiagnosticDepth = 5;
    exports2.defaultMaxDiagnosticLineCount = 8;
    var maxRecursionCount = 64;
    var TaskListPriority;
    (function(TaskListPriority2) {
      TaskListPriority2["High"] = "High";
      TaskListPriority2["Normal"] = "Normal";
      TaskListPriority2["Low"] = "Low";
    })(TaskListPriority || (exports2.TaskListPriority = TaskListPriority = {}));
    var DiagnosticCategory;
    (function(DiagnosticCategory2) {
      DiagnosticCategory2[DiagnosticCategory2["Error"] = 0] = "Error";
      DiagnosticCategory2[DiagnosticCategory2["Warning"] = 1] = "Warning";
      DiagnosticCategory2[DiagnosticCategory2["Information"] = 2] = "Information";
      DiagnosticCategory2[DiagnosticCategory2["UnusedCode"] = 3] = "UnusedCode";
      DiagnosticCategory2[DiagnosticCategory2["UnreachableCode"] = 4] = "UnreachableCode";
      DiagnosticCategory2[DiagnosticCategory2["Deprecated"] = 5] = "Deprecated";
      DiagnosticCategory2[DiagnosticCategory2["TaskItem"] = 6] = "TaskItem";
    })(DiagnosticCategory || (exports2.DiagnosticCategory = DiagnosticCategory = {}));
    function convertLevelToCategory(level) {
      switch (level) {
        case "error":
          return 0;
        case "warning":
          return 1;
        case "information":
          return 2;
        default:
          throw new Error(`${level} is not expected`);
      }
    }
    var DiagnosticRelatedInfo;
    (function(DiagnosticRelatedInfo2) {
      function toJsonObj(info) {
        return {
          message: info.message,
          uri: info.uri.toJsonObj(),
          range: info.range,
          priority: info.priority
        };
      }
      DiagnosticRelatedInfo2.toJsonObj = toJsonObj;
      function fromJsonObj(obj) {
        return {
          message: obj.message,
          uri: uri_1.Uri.fromJsonObj(obj.uri),
          range: obj.range,
          priority: obj.priority
        };
      }
      DiagnosticRelatedInfo2.fromJsonObj = fromJsonObj;
    })(DiagnosticRelatedInfo || (exports2.DiagnosticRelatedInfo = DiagnosticRelatedInfo = {}));
    var Diagnostic2 = class _Diagnostic {
      constructor(category, message, range2, priority = TaskListPriority.Normal) {
        this.category = category;
        this.message = message;
        this.range = range2;
        this.priority = priority;
        this._relatedInfo = [];
        this._data = null;
      }
      toJsonObj() {
        return {
          category: this.category,
          message: this.message,
          range: this.range,
          priority: this.priority,
          actions: this._actions,
          rule: this._rule,
          data: this._data,
          relatedInfo: this._relatedInfo.map((info) => DiagnosticRelatedInfo.toJsonObj(info))
        };
      }
      static fromJsonObj(obj) {
        const diag = new _Diagnostic(obj.category, obj.message, obj.range, obj.priority);
        diag._actions = obj.actions;
        diag._rule = obj.rule;
        diag._relatedInfo = obj.relatedInfo.map((info) => DiagnosticRelatedInfo.fromJsonObj(info));
        diag._data = obj.data;
        return diag;
      }
      addAction(action) {
        if (this._actions === void 0) {
          this._actions = [action];
        } else {
          this._actions.push(action);
        }
      }
      setData(data) {
        this._data = data;
      }
      getData() {
        return this._data;
      }
      getActions() {
        return this._actions;
      }
      setRule(rule) {
        this._rule = rule;
      }
      getRule() {
        return this._rule;
      }
      addRelatedInfo(message, fileUri, range2, priority = TaskListPriority.Normal) {
        this._relatedInfo.push({ uri: fileUri, message, range: range2, priority });
      }
      getRelatedInfo() {
        return this._relatedInfo;
      }
    };
    exports2.Diagnostic = Diagnostic2;
    function compareDiagnostics(d1, d2) {
      if (d1.range.start.line < d2.range.start.line) {
        return -1;
      } else if (d1.range.start.line > d2.range.start.line) {
        return 1;
      }
      if (d1.range.start.character < d2.range.start.character) {
        return -1;
      } else if (d1.range.start.character > d2.range.start.character) {
        return 1;
      }
      return 0;
    }
    var DiagnosticAddendum = class _DiagnosticAddendum {
      constructor() {
        this._messages = [];
        this._childAddenda = [];
      }
      addMessage(message) {
        this._messages.push(message);
      }
      addMessageMultiline(message) {
        message.split("\n").forEach((line) => {
          this._messages.push(line);
        });
      }
      addTextRange(range2) {
        this._range = range2;
      }
      // Create a new (nested) addendum to which messages can be added.
      createAddendum() {
        const newAddendum = new _DiagnosticAddendum();
        newAddendum._nestLevel = (this._nestLevel ?? 0) + 1;
        this.addAddendum(newAddendum);
        return newAddendum;
      }
      getString(maxDepth = exports2.defaultMaxDiagnosticDepth, maxLineCount = exports2.defaultMaxDiagnosticLineCount) {
        let lines = this._getLinesRecursive(maxDepth, maxLineCount);
        if (lines.length > maxLineCount) {
          lines = lines.slice(0, maxLineCount);
          lines.push("  ...");
        }
        const text = lines.join("\n");
        if (text.length > 0) {
          return "\n" + text;
        }
        return "";
      }
      isEmpty() {
        return this._getMessageCount() === 0;
      }
      addAddendum(addendum) {
        this._childAddenda.push(addendum);
      }
      getChildren() {
        return this._childAddenda;
      }
      getMessages() {
        return this._messages;
      }
      getNestLevel() {
        return this._nestLevel ?? 0;
      }
      // Returns undefined if no range is associated with this addendum
      // or its children. Returns a non-empty range if there is a single range
      // associated.
      getEffectiveTextRange() {
        const range2 = this._getTextRangeRecursive();
        if ((range2 == null ? void 0 : range2.length) === 0) {
          return void 0;
        }
        return range2;
      }
      _getTextRangeRecursive(recursionCount = 0) {
        if (recursionCount > maxRecursionCount) {
          return void 0;
        }
        recursionCount++;
        const childRanges = this._childAddenda.map((child) => child._getTextRangeRecursive(recursionCount)).filter((r) => !!r);
        if (childRanges.length > 1) {
          return { start: 0, length: 0 };
        }
        if (childRanges.length === 1) {
          return childRanges[0];
        }
        if (this._range) {
          return this._range;
        }
        return void 0;
      }
      _getMessageCount(recursionCount = 0) {
        if (recursionCount > maxRecursionCount) {
          return 0;
        }
        let messageCount = this._messages.length;
        for (const diag of this._childAddenda) {
          messageCount += diag._getMessageCount(recursionCount + 1);
        }
        return messageCount;
      }
      _getLinesRecursive(maxDepth, maxLineCount, recursionCount = 0) {
        if (maxDepth <= 0 || recursionCount > maxRecursionCount) {
          return [];
        }
        let childLines = [];
        for (const addendum of this._childAddenda) {
          const maxDepthRemaining = this._messages.length > 0 ? maxDepth - 1 : maxDepth;
          (0, collectionUtils_1.appendArray)(childLines, addendum._getLinesRecursive(maxDepthRemaining, maxLineCount, recursionCount + 1));
          if (childLines.length >= maxLineCount) {
            childLines = childLines.slice(0, maxLineCount);
            break;
          }
        }
        const extraSpace = this._messages.length > 0 ? "\xA0\xA0" : "";
        return this._messages.concat(childLines).map((line) => extraSpace + line);
      }
    };
    exports2.DiagnosticAddendum = DiagnosticAddendum;
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/textRange.js
var require_textRange = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/textRange.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Range = exports2.Position = exports2.TextRange = void 0;
    exports2.comparePositions = comparePositions;
    exports2.getEmptyPosition = getEmptyPosition;
    exports2.doRangesOverlap = doRangesOverlap;
    exports2.doRangesIntersect = doRangesIntersect;
    exports2.isPositionInRange = isPositionInRange;
    exports2.isRangeInRange = isRangeInRange;
    exports2.positionsAreEqual = positionsAreEqual;
    exports2.rangesAreEqual = rangesAreEqual;
    exports2.getEmptyRange = getEmptyRange;
    exports2.isEmptyPosition = isEmptyPosition;
    exports2.isEmptyRange = isEmptyRange;
    exports2.extendRange = extendRange;
    exports2.combineRange = combineRange;
    var debug_1 = require_debug();
    var TextRange;
    (function(TextRange2) {
      function create(start, length) {
        if (start < 0) {
          (0, debug_1.fail)("start must be non-negative");
        }
        if (length < 0) {
          (0, debug_1.fail)("length must be non-negative");
        }
        return { start, length };
      }
      TextRange2.create = create;
      function fromBounds(start, end) {
        if (start < 0) {
          (0, debug_1.fail)("start must be non-negative");
        }
        if (start > end) {
          (0, debug_1.fail)("end must be greater than or equal to start");
        }
        return create(start, end - start);
      }
      TextRange2.fromBounds = fromBounds;
      function getEnd(range2) {
        return range2.start + range2.length;
      }
      TextRange2.getEnd = getEnd;
      function contains(range2, position) {
        return position >= range2.start && position < getEnd(range2);
      }
      TextRange2.contains = contains;
      function containsRange(range2, span) {
        return span.start >= range2.start && getEnd(span) <= getEnd(range2);
      }
      TextRange2.containsRange = containsRange;
      function overlaps(range2, position) {
        return position >= range2.start && position <= getEnd(range2);
      }
      TextRange2.overlaps = overlaps;
      function overlapsRange(range2, other) {
        return overlaps(range2, other.start) || overlaps(other, range2.start);
      }
      TextRange2.overlapsRange = overlapsRange;
      function extend(range2, extension) {
        let result = range2;
        if (extension.start < result.start) {
          result = {
            start: extension.start,
            length: result.length + result.start - extension.start
          };
        }
        const extensionEnd = getEnd(extension);
        const resultEnd = getEnd(result);
        if (extensionEnd > resultEnd) {
          result = {
            start: result.start,
            length: result.length + extensionEnd - resultEnd
          };
        }
        return result;
      }
      TextRange2.extend = extend;
      function combine(ranges) {
        if (ranges.length === 0) {
          return void 0;
        }
        let combinedRange = { start: ranges[0].start, length: ranges[0].length };
        for (let i = 1; i < ranges.length; i++) {
          combinedRange = extend(combinedRange, ranges[i]);
        }
        return combinedRange;
      }
      TextRange2.combine = combine;
    })(TextRange || (exports2.TextRange = TextRange = {}));
    var Position6;
    (function(Position7) {
      function print(value) {
        return `(${value.line}:${value.character})`;
      }
      Position7.print = print;
    })(Position6 || (exports2.Position = Position6 = {}));
    var Range7;
    (function(Range8) {
      function print(value) {
        return `${Position6.print(value.start)}-${Position6.print(value.end)}`;
      }
      Range8.print = print;
    })(Range7 || (exports2.Range = Range7 = {}));
    function comparePositions(a, b) {
      if (a.line < b.line) {
        return -1;
      } else if (a.line > b.line) {
        return 1;
      } else if (a.character < b.character) {
        return -1;
      } else if (a.character > b.character) {
        return 1;
      }
      return 0;
    }
    function getEmptyPosition() {
      return {
        line: 0,
        character: 0
      };
    }
    function doRangesOverlap(a, b) {
      if (comparePositions(b.start, a.end) >= 0) {
        return false;
      } else if (comparePositions(a.start, b.end) >= 0) {
        return false;
      }
      return true;
    }
    function doRangesIntersect(a, b) {
      if (comparePositions(b.start, a.end) > 0) {
        return false;
      } else if (comparePositions(a.start, b.end) > 0) {
        return false;
      }
      return true;
    }
    function isPositionInRange(range2, position) {
      return comparePositions(range2.start, position) <= 0 && comparePositions(range2.end, position) >= 0;
    }
    function isRangeInRange(range2, containedRange) {
      return isPositionInRange(range2, containedRange.start) && isPositionInRange(range2, containedRange.end);
    }
    function positionsAreEqual(a, b) {
      return comparePositions(a, b) === 0;
    }
    function rangesAreEqual(a, b) {
      return positionsAreEqual(a.start, b.start) && positionsAreEqual(a.end, b.end);
    }
    function getEmptyRange() {
      return {
        start: getEmptyPosition(),
        end: getEmptyPosition()
      };
    }
    function isEmptyPosition(pos) {
      return pos.character === 0 && pos.line === 0;
    }
    function isEmptyRange(range2) {
      return isEmptyPosition(range2.start) && isEmptyPosition(range2.end);
    }
    function extendRange(range2, extension) {
      if (comparePositions(extension.start, range2.start) < 0) {
        range2.start = extension.start;
      }
      if (comparePositions(extension.end, range2.end) > 0) {
        range2.end = extension.end;
      }
    }
    function combineRange(ranges) {
      if (ranges.length === 0) {
        return void 0;
      }
      const combinedRange = ranges[0];
      for (let i = 1; i < ranges.length; i++) {
        extendRange(combinedRange, ranges[i]);
      }
      return combinedRange;
    }
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/positionUtils.js
var require_positionUtils = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/positionUtils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.convertOffsetToPosition = convertOffsetToPosition;
    exports2.convertOffsetsToRange = convertOffsetsToRange2;
    exports2.convertPositionToOffset = convertPositionToOffset;
    exports2.convertRangeToTextRange = convertRangeToTextRange;
    exports2.convertTextRangeToRange = convertTextRangeToRange2;
    exports2.getLineEndPosition = getLineEndPosition;
    exports2.getLineEndOffset = getLineEndOffset;
    var debug_1 = require_debug();
    var textRange_1 = require_textRange();
    function convertOffsetToPosition(offset, lines) {
      if (lines.end === 0) {
        return {
          line: 0,
          character: 0
        };
      }
      const itemIndex = offset >= lines.end ? lines.count - 1 : lines.getItemContaining(offset);
      (0, debug_1.assert)(itemIndex >= 0 && itemIndex <= lines.count);
      const lineRange = lines.getItemAt(itemIndex);
      (0, debug_1.assert)(lineRange !== void 0);
      return {
        line: itemIndex,
        character: Math.max(0, Math.min(lineRange.length, offset - lineRange.start))
      };
    }
    function convertOffsetsToRange2(startOffset, endOffset, lines) {
      const start = convertOffsetToPosition(startOffset, lines);
      const end = convertOffsetToPosition(endOffset, lines);
      return { start, end };
    }
    function convertPositionToOffset(position, lines) {
      if (position.line >= lines.count) {
        return void 0;
      }
      return lines.getItemAt(position.line).start + position.character;
    }
    function convertRangeToTextRange(range2, lines) {
      const start = convertPositionToOffset(range2.start, lines);
      if (start === void 0) {
        return void 0;
      }
      const end = convertPositionToOffset(range2.end, lines);
      if (end === void 0) {
        return void 0;
      }
      return textRange_1.TextRange.fromBounds(start, end);
    }
    function convertTextRangeToRange2(range2, lines) {
      return convertOffsetsToRange2(range2.start, textRange_1.TextRange.getEnd(range2), lines);
    }
    function getLineEndPosition(tokenizerOutput, text, line) {
      return convertOffsetToPosition(getLineEndOffset(tokenizerOutput, text, line), tokenizerOutput.lines);
    }
    function getLineEndOffset(tokenizerOutput, text, line) {
      const lineRange = tokenizerOutput.lines.getItemAt(line);
      const lineEndOffset = textRange_1.TextRange.getEnd(lineRange);
      let newLineLength = 0;
      for (let i = lineEndOffset - 1; i >= lineRange.start; i--) {
        const char = text[i];
        if (char !== "\r" && char !== "\n") {
          break;
        }
        newLineLength++;
      }
      return lineEndOffset - newLineLength;
    }
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/diagnosticSink.js
var require_diagnosticSink = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/diagnosticSink.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.TextRangeDiagnosticSink = exports2.DiagnosticSink = exports2.FileDiagnostics = void 0;
    var collectionUtils_1 = require_collectionUtils();
    var diagnostic_1 = require_diagnostic();
    var positionUtils_1 = require_positionUtils();
    var stringUtils_1 = require_stringUtils();
    var uri_1 = require_uri();
    var FileDiagnostics;
    (function(FileDiagnostics2) {
      function toJsonObj(fileDiag) {
        return {
          fileUri: fileDiag.fileUri.toJsonObj(),
          version: fileDiag.version,
          diagnostics: fileDiag.diagnostics.map((d) => d.toJsonObj())
        };
      }
      FileDiagnostics2.toJsonObj = toJsonObj;
      function fromJsonObj(fileDiagObj) {
        return {
          fileUri: uri_1.Uri.fromJsonObj(fileDiagObj.fileUri),
          version: fileDiagObj.version,
          diagnostics: fileDiagObj.diagnostics.map((d) => diagnostic_1.Diagnostic.fromJsonObj(d))
        };
      }
      FileDiagnostics2.fromJsonObj = fromJsonObj;
    })(FileDiagnostics || (exports2.FileDiagnostics = FileDiagnostics = {}));
    var DiagnosticSink2 = class {
      constructor(diagnostics) {
        this._diagnosticList = diagnostics || [];
        this._diagnosticMap = /* @__PURE__ */ new Map();
      }
      fetchAndClear() {
        const prevDiagnostics = this._diagnosticList;
        this._diagnosticList = [];
        this._diagnosticMap.clear();
        return prevDiagnostics;
      }
      addError(message, range2) {
        return this.addDiagnostic(new diagnostic_1.Diagnostic(0, message, range2));
      }
      addWarning(message, range2) {
        return this.addDiagnostic(new diagnostic_1.Diagnostic(1, message, range2));
      }
      addInformation(message, range2) {
        return this.addDiagnostic(new diagnostic_1.Diagnostic(2, message, range2));
      }
      addUnusedCode(message, range2, action) {
        const diag = new diagnostic_1.Diagnostic(3, message, range2);
        if (action) {
          diag.addAction(action);
        }
        return this.addDiagnostic(diag);
      }
      addUnreachableCode(message, range2, action) {
        const diag = new diagnostic_1.Diagnostic(4, message, range2);
        if (action) {
          diag.addAction(action);
        }
        return this.addDiagnostic(diag);
      }
      addDeprecated(message, range2, action) {
        const diag = new diagnostic_1.Diagnostic(5, message, range2);
        if (action) {
          diag.addAction(action);
        }
        return this.addDiagnostic(diag);
      }
      addDiagnostic(diag) {
        const key = `${diag.range.start.line},${diag.range.start.character}-${diag.range.end.line}-${diag.range.end.character}:${(0, stringUtils_1.hashString)(diag.message)}}`;
        if (!this._diagnosticMap.has(key)) {
          this._diagnosticList.push(diag);
          this._diagnosticMap.set(key, diag);
        }
        return diag;
      }
      addDiagnostics(diagsToAdd) {
        (0, collectionUtils_1.appendArray)(this._diagnosticList, diagsToAdd);
      }
      getErrors() {
        return this._diagnosticList.filter(
          (diag) => diag.category === 0
          /* DiagnosticCategory.Error */
        );
      }
      getWarnings() {
        return this._diagnosticList.filter(
          (diag) => diag.category === 1
          /* DiagnosticCategory.Warning */
        );
      }
      getInformation() {
        return this._diagnosticList.filter(
          (diag) => diag.category === 2
          /* DiagnosticCategory.Information */
        );
      }
      getUnusedCode() {
        return this._diagnosticList.filter(
          (diag) => diag.category === 3
          /* DiagnosticCategory.UnusedCode */
        );
      }
      getUnreachableCode() {
        return this._diagnosticList.filter(
          (diag) => diag.category === 4
          /* DiagnosticCategory.UnreachableCode */
        );
      }
      getDeprecated() {
        return this._diagnosticList.filter(
          (diag) => diag.category === 5
          /* DiagnosticCategory.Deprecated */
        );
      }
    };
    exports2.DiagnosticSink = DiagnosticSink2;
    var TextRangeDiagnosticSink = class extends DiagnosticSink2 {
      constructor(lines, diagnostics) {
        super(diagnostics);
        this._lines = lines;
      }
      addDiagnosticWithTextRange(level, message, range2) {
        const positionRange = (0, positionUtils_1.convertOffsetsToRange)(range2.start, range2.start + range2.length, this._lines);
        switch (level) {
          case "error":
            return this.addError(message, positionRange);
          case "warning":
            return this.addWarning(message, positionRange);
          case "information":
            return this.addInformation(message, positionRange);
          default:
            throw new Error(`${level} is not expected value`);
        }
      }
      addUnusedCodeWithTextRange(message, range2, action) {
        return this.addUnusedCode(message, (0, positionUtils_1.convertOffsetsToRange)(range2.start, range2.start + range2.length, this._lines), action);
      }
      addUnreachableCodeWithTextRange(message, range2, action) {
        return this.addUnreachableCode(message, (0, positionUtils_1.convertOffsetsToRange)(range2.start, range2.start + range2.length, this._lines), action);
      }
      addDeprecatedWithTextRange(message, range2, action) {
        return this.addDeprecated(message, (0, positionUtils_1.convertOffsetsToRange)(range2.start, range2.start + range2.length, this._lines), action);
      }
    };
    exports2.TextRangeDiagnosticSink = TextRangeDiagnosticSink;
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/pythonVersion.js
var require_pythonVersion = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/pythonVersion.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.latestStablePythonVersion = exports2.pythonVersion3_14 = exports2.pythonVersion3_13 = exports2.pythonVersion3_12 = exports2.pythonVersion3_11 = exports2.pythonVersion3_10 = exports2.pythonVersion3_9 = exports2.pythonVersion3_8 = exports2.pythonVersion3_7 = exports2.pythonVersion3_6 = exports2.pythonVersion3_5 = exports2.pythonVersion3_4 = exports2.pythonVersion3_3 = exports2.pythonVersion3_2 = exports2.pythonVersion3_1 = exports2.pythonVersion3_0 = exports2.PythonVersion = void 0;
    var PythonVersion;
    (function(PythonVersion2) {
      function is(value) {
        if (value && typeof value.major === "number" && typeof value.minor === "number") {
          if (value.micro !== void 0 && typeof value.micro !== "number") {
            return false;
          }
          if (value.releaseLevel !== void 0 && typeof value.releaseLevel !== "string") {
            return false;
          }
          if (value.serial !== void 0 && typeof value.serial !== "number") {
            return false;
          }
          return true;
        }
        return false;
      }
      PythonVersion2.is = is;
      function create(major, minor, micro, releaseLevel, serial) {
        return {
          major,
          minor,
          micro,
          releaseLevel,
          serial
        };
      }
      PythonVersion2.create = create;
      function isEqualTo(version, other) {
        if (version.major !== other.major || version.minor !== other.minor) {
          return false;
        }
        if (version.micro === void 0 || other.micro === void 0) {
          return true;
        } else if (version.micro !== other.micro) {
          return false;
        }
        if (version.releaseLevel === void 0 || other.releaseLevel === void 0) {
          return true;
        } else if (version.releaseLevel !== other.releaseLevel) {
          return false;
        }
        if (version.serial === void 0 || other.serial === void 0) {
          return true;
        } else if (version.serial !== other.serial) {
          return false;
        }
        return true;
      }
      PythonVersion2.isEqualTo = isEqualTo;
      function isGreaterThan(version, other) {
        if (version.major > other.major) {
          return true;
        } else if (version.major < other.major) {
          return false;
        }
        if (version.minor > other.minor) {
          return true;
        } else if (version.minor < other.minor) {
          return false;
        }
        if (version.micro === void 0 || other.micro === void 0 || version.micro < other.micro) {
          return false;
        } else if (version.micro > other.micro) {
          return true;
        }
        if (version.releaseLevel === void 0 || other.releaseLevel === void 0 || version.releaseLevel < other.releaseLevel) {
          return false;
        } else if (version.releaseLevel > other.releaseLevel) {
          return true;
        }
        if (version.serial === void 0 || other.serial === void 0 || version.serial < other.serial) {
          return false;
        } else if (version.serial > other.serial) {
          return true;
        }
        return false;
      }
      PythonVersion2.isGreaterThan = isGreaterThan;
      function isGreaterOrEqualTo(version, other) {
        return isEqualTo(version, other) || isGreaterThan(version, other);
      }
      PythonVersion2.isGreaterOrEqualTo = isGreaterOrEqualTo;
      function isLessThan(version, other) {
        return !isGreaterOrEqualTo(version, other);
      }
      PythonVersion2.isLessThan = isLessThan;
      function isLessOrEqualTo(version, other) {
        return !isGreaterThan(version, other);
      }
      PythonVersion2.isLessOrEqualTo = isLessOrEqualTo;
      function toMajorMinorString(version) {
        return `${version.major}.${version.minor}`;
      }
      PythonVersion2.toMajorMinorString = toMajorMinorString;
      function toString(version) {
        let versString = toMajorMinorString(version);
        if (version.micro === void 0) {
          return versString;
        }
        versString += `.${version.micro}`;
        if (version.releaseLevel === void 0) {
          return versString;
        }
        versString += `.${version.releaseLevel}`;
        if (version.serial === void 0) {
          return versString;
        }
        versString += `.${version.serial}`;
        return versString;
      }
      PythonVersion2.toString = toString;
      function fromString(val) {
        const split = val.split(".");
        if (split.length < 2) {
          return void 0;
        }
        const major = parseInt(split[0], 10);
        const minor = parseInt(split[1], 10);
        if (isNaN(major) || isNaN(minor)) {
          return void 0;
        }
        let micro;
        if (split.length >= 3) {
          micro = parseInt(split[2], 10);
          if (isNaN(micro)) {
            micro = void 0;
          }
        }
        let releaseLevel;
        if (split.length >= 4) {
          const releaseLevels = ["alpha", "beta", "candidate", "final"];
          if (releaseLevels.some((level) => level === split[3])) {
            releaseLevel = split[3];
          }
        }
        let serial;
        if (split.length >= 5) {
          serial = parseInt(split[4], 10);
          if (isNaN(serial)) {
            serial = void 0;
          }
        }
        return create(major, minor, micro, releaseLevel, serial);
      }
      PythonVersion2.fromString = fromString;
    })(PythonVersion || (exports2.PythonVersion = PythonVersion = {}));
    exports2.pythonVersion3_0 = PythonVersion.create(3, 0);
    exports2.pythonVersion3_1 = PythonVersion.create(3, 1);
    exports2.pythonVersion3_2 = PythonVersion.create(3, 2);
    exports2.pythonVersion3_3 = PythonVersion.create(3, 3);
    exports2.pythonVersion3_4 = PythonVersion.create(3, 4);
    exports2.pythonVersion3_5 = PythonVersion.create(3, 5);
    exports2.pythonVersion3_6 = PythonVersion.create(3, 6);
    exports2.pythonVersion3_7 = PythonVersion.create(3, 7);
    exports2.pythonVersion3_8 = PythonVersion.create(3, 8);
    exports2.pythonVersion3_9 = PythonVersion.create(3, 9);
    exports2.pythonVersion3_10 = PythonVersion.create(3, 10);
    exports2.pythonVersion3_11 = PythonVersion.create(3, 11);
    exports2.pythonVersion3_12 = PythonVersion.create(3, 12);
    exports2.pythonVersion3_13 = PythonVersion.create(3, 13);
    exports2.pythonVersion3_14 = PythonVersion.create(3, 14);
    exports2.latestStablePythonVersion = exports2.pythonVersion3_14;
  }
});

// node_modules/@zzzen/pyright-internal/dist/common/timing.js
var require_timing = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/common/timing.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.timingStats = exports2.TimingStats = exports2.TimingStat = exports2.Duration = void 0;
    var Duration = class {
      constructor() {
        this._startTime = Date.now();
      }
      getDurationInMilliseconds() {
        const curTime = Date.now();
        return curTime - this._startTime;
      }
      getDurationInSeconds() {
        return this.getDurationInMilliseconds() / 1e3;
      }
    };
    exports2.Duration = Duration;
    var TimingStat = class {
      constructor() {
        this.totalTime = 0;
        this.callCount = 0;
        this.isTiming = false;
      }
      timeOperation(callback, ...args) {
        this.callCount++;
        if (this.isTiming) {
          return callback(...args);
        } else {
          this.isTiming = true;
          const duration = new Duration();
          const result = callback(...args);
          this.totalTime += duration.getDurationInMilliseconds();
          this.isTiming = false;
          return result;
        }
      }
      subtractFromTime(callback) {
        if (this.isTiming) {
          this.isTiming = false;
          const duration = new Duration();
          callback();
          this.totalTime -= duration.getDurationInMilliseconds();
          this.isTiming = true;
        } else {
          callback();
        }
      }
      printTime() {
        const totalTimeInSec = this.totalTime / 1e3;
        const roundedTime = Math.round(totalTimeInSec * 100) / 100;
        return roundedTime.toString() + "sec";
      }
    };
    exports2.TimingStat = TimingStat;
    var TimingStats = class {
      constructor() {
        this.totalDuration = new Duration();
        this.findFilesTime = new TimingStat();
        this.readFileTime = new TimingStat();
        this.tokenizeFileTime = new TimingStat();
        this.parseFileTime = new TimingStat();
        this.resolveImportsTime = new TimingStat();
        this.cycleDetectionTime = new TimingStat();
        this.bindTime = new TimingStat();
        this.typeCheckerTime = new TimingStat();
        this.typeEvaluationTime = new TimingStat();
      }
      printSummary(console2) {
        console2.info(`Completed in ${this.totalDuration.getDurationInSeconds()}sec`);
      }
      printDetails(console2) {
        console2.info("");
        console2.info("Timing stats");
        console2.info("Find Source Files:    " + this.findFilesTime.printTime());
        console2.info("Read Source Files:    " + this.readFileTime.printTime());
        console2.info("Tokenize:             " + this.tokenizeFileTime.printTime());
        console2.info("Parse:                " + this.parseFileTime.printTime());
        console2.info("Resolve Imports:      " + this.resolveImportsTime.printTime());
        console2.info("Bind:                 " + this.bindTime.printTime());
        console2.info("Check:                " + this.typeCheckerTime.printTime());
        console2.info("Detect Cycles:        " + this.cycleDetectionTime.printTime());
      }
      getTotalDuration() {
        return this.totalDuration.getDurationInSeconds();
      }
    };
    exports2.TimingStats = TimingStats;
    exports2.timingStats = new TimingStats();
  }
});

// node_modules/@zzzen/pyright-internal/dist/localization/package.nls.cs.json
var require_package_nls_cs = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/localization/package.nls.cs.json"(exports2, module2) {
    module2.exports = {
      CodeAction: {
        createTypeStub: "Vytvo\u0159it z\xE1stupnou proceduru (Stub) typu",
        createTypeStubFor: "Vytvo\u0159it z\xE1stupnou proceduru typu (Stub) pro modul {moduleName}",
        executingCommand: "Spou\u0161t\xED se p\u0159\xEDkaz",
        filesToAnalyzeCount: "Po\u010Det soubor\u016F k anal\xFDze: {count}",
        filesToAnalyzeOne: "1 soubor k anal\xFDze",
        findingReferences: "Hledaj\xED se odkazy",
        organizeImports: "Uspo\u0159\xE1dat direktivy Import"
      },
      Completion: {
        autoImportDetail: "Automatick\xFD import",
        indexValueDetail: "Hodnota indexu"
      },
      Diagnostic: {
        abstractMethodInvocation: "Metodu \u201E{method}\u201C nelze volat, proto\u017Ee je abstraktn\xED a neimplementovan\xE1.",
        annotatedMetadataInconsistent: "Typ metadat s pozn\xE1mkami \u201E{metadataType}\u201C nen\xED kompatibiln\xED s typem \u201E{type}\u201C.",
        annotatedParamCountMismatch: "Po\u010Det pozn\xE1mek parametr\u016F se neshoduje: o\u010Dek\xE1val(o/y) se {expected}, ale p\u0159ijal(o/y) se {received}.",
        annotatedTypeArgMissing: "Byl o\u010Dek\xE1v\xE1n jeden argument typu a jedna nebo v\xEDce pozn\xE1mek pro Annotated",
        annotationBytesString: "V\xFDrazy typu nem\u016F\u017Eou pou\u017E\xEDvat \u0159et\u011Bzcov\xE9 liter\xE1ly bajt\u016F.",
        annotationFormatString: "V\xFDrazy typu nem\u016F\u017Eou pou\u017E\xEDvat form\xE1tovac\xED \u0159et\u011Bzcov\xE9 liter\xE1ly (f-strings).",
        annotationNotSupported: "Pozn\xE1mka typu nen\xED pro tento p\u0159\xEDkaz podporov\xE1na",
        annotationRawString: "V\xFDrazy typu nem\u016F\u017Eou pou\u017E\xEDvat liter\xE1ly nezpracovan\xE9ho \u0159et\u011Bzce.",
        annotationSpansStrings: "V\xFDrazy typu nem\u016F\u017Eou zahrnovat v\xEDce \u0159et\u011Bzcov\xFDch liter\xE1l\u016F.",
        annotationStringEscape: "V\xFDrazy typu nem\u016F\u017Eou obsahovat \u0159\xEDdic\xED znaky.",
        annotationTemplateString: "Type expressions cannot use template string literals (t-strings)",
        argAssignment: "Argument typu {argType} nen\xED mo\u017En\xE9 p\u0159i\u0159adit k parametru typu {paramType}",
        argAssignmentFunction: "Argument typu {argType} nen\xED mo\u017En\xE9 p\u0159i\u0159adit k parametru typu {paramType} ve funkci {functionName}",
        argAssignmentParam: "Argument typu {argType} nen\xED mo\u017En\xE9 p\u0159i\u0159adit k parametru {paramName} typu {paramType}",
        argAssignmentParamFunction: "Argument typu {argType} nen\xED mo\u017En\xE9 p\u0159i\u0159adit k parametru {paramName} typu {paramType} ve funkci {functionName}",
        argMissingForParam: "Chyb\xED argument pro parametr {name}",
        argMissingForParams: "Chyb\xED argumenty pro parametry {names}",
        argMorePositionalExpectedCount: "O\u010Dek\xE1val se tento po\u010Det dal\u0161\xEDch pozi\u010Dn\xEDch argument\u016F: {expected}",
        argMorePositionalExpectedOne: "O\u010Dek\xE1val se 1 dal\u0161\xED pozi\u010Dn\xED argument",
        argPositional: "O\u010Dek\xE1van\xFD pozi\u010Dn\xED argument",
        argPositionalExpectedCount: "O\u010Dek\xE1van\xFD po\u010Det pozi\u010Dn\xEDch argument\u016F: {expected}",
        argPositionalExpectedOne: "O\u010Dek\xE1val se 1 pozi\u010Dn\xED argument",
        argTypePartiallyUnknown: "Typ argumentu je \u010D\xE1ste\u010Dn\u011B nezn\xE1m\xFD",
        argTypeUnknown: "Typ argumentu je nezn\xE1m\xFD",
        assertAlwaysTrue: "V\xFDraz Assert se v\u017Edy vyhodnot\xED jako true",
        assertTypeArgs: "assert_type o\u010Dek\xE1v\xE1 dva pozi\u010Dn\xED argumenty",
        assertTypeTypeMismatch: "Neshoda assert_type: o\u010Dek\xE1valo se {expected}, ale p\u0159ijalo se {received}",
        assignmentExprComprehension: "C\xEDl v\xFDrazu p\u0159i\u0159azen\xED \u201E{name}\u201C nem\u016F\u017Ee pou\u017E\xEDvat stejn\xFD n\xE1zev jako porozum\u011Bn\xED c\xEDli",
        assignmentExprContext: "V\xFDraz p\u0159i\u0159azen\xED mus\xED b\xFDt uvnit\u0159 modulu, funkce nebo v\xFDrazu lambda",
        assignmentExprInSubscript: "V\xFDrazy p\u0159i\u0159azen\xED v doln\xEDm indexu se podporuj\xED jenom v Pythonu 3.10 a nov\u011Bj\u0161\xEDm",
        assignmentInProtocol: "Prom\u011Bnn\xE9 instance nebo t\u0159\xEDdy v r\xE1mci t\u0159\xEDdy Protocol mus\xED b\xFDt explicitn\u011B deklarov\xE1ny v t\u011Ble t\u0159\xEDdy",
        assignmentTargetExpr: "V\xFDraz nem\u016F\u017Ee b\xFDt c\xEDlem p\u0159i\u0159azen\xED",
        asyncNotInAsyncFunction: "Pou\u017Eit\xED \u201Easync\u201C nen\xED povolen\xE9 mimo funkci async",
        awaitIllegal: "Pou\u017Eit\xED oper\xE1toru await vy\u017Eaduje Python 3.5 nebo nov\u011Bj\u0161\xED",
        awaitNotAllowed: "V\xFDrazy typu nem\u016F\u017Eou pou\u017E\xEDvat v\xFDraz await.",
        awaitNotInAsync: "Oper\xE1tor await je povolen\xFD jenom v r\xE1mci asynchronn\xED funkce",
        backticksIllegal: "V Pythonu 3.x nejsou podporov\xE1ny v\xFDrazy obklopen\xE9 zp\u011Btn\xFDmi te\u010Dkami; m\xEDsto toho pou\u017Eijte repr",
        baseClassCircular: "T\u0159\xEDda se nem\u016F\u017Ee odvozovat od sebe sama",
        baseClassFinal: "Z\xE1kladn\xED t\u0159\xEDda {type} je ozna\u010Den\xE1 jako final a nem\u016F\u017Ee b\xFDt podt\u0159\xEDdou",
        baseClassIncompatible: "Z\xE1kladn\xED t\u0159\xEDdy typu {type} jsou vz\xE1jemn\u011B nekompatibiln\xED",
        baseClassInvalid: "Argument t\u0159\xEDdy mus\xED b\xFDt z\xE1kladn\xED t\u0159\xEDda",
        baseClassMethodTypeIncompatible: "Z\xE1kladn\xED t\u0159\xEDdy pro t\u0159\xEDdu {classType} definuj\xED metodu {name} nekompatibiln\xEDm zp\u016Fsobem",
        baseClassUnknown: "Typ z\xE1kladn\xED t\u0159\xEDdy je nezn\xE1m\xFD, co zakr\xFDv\xE1 typ odvozen\xE9 t\u0159\xEDdy",
        baseClassVariableTypeIncompatible: "Z\xE1kladn\xED t\u0159\xEDdy pro t\u0159\xEDdu {classType} definuj\xED prom\u011Bnnou {name} nekompatibiln\xEDm zp\u016Fsobem",
        binaryOperationNotAllowed: "Ve v\xFDrazu typu nen\xED povolen\xFD bin\xE1rn\xED oper\xE1tor.",
        bindParamMissing: "Nepovedlo se vytvo\u0159it vazbu metody {methodName}, proto\u017Ee chyb\xED parametr self nebo cls",
        bindTypeMismatch: "Nepovedlo se vytvo\u0159it vazbu metody \u201E{methodName}\u201C, proto\u017Ee \u201E{type}\u201C nejde p\u0159i\u0159adit k parametru \u201E{paramName}\u201C",
        breakInExceptionGroup: "V bloku except* nen\xED povolen\xE1 mo\u017Enost break.",
        breakOutsideLoop: "\u201Ebreak\u201C se d\xE1 pou\u017E\xEDt jenom ve smy\u010Dce",
        bytesUnsupportedEscape: "Nepodporovan\xE1 \u0159\xEDdic\xED sekvence v liter\xE1lu typu bytes",
        callableExtraArgs: "Pro Callable se o\u010Dek\xE1valy pouze dva argumenty typu",
        callableFirstArg: "O\u010Dek\xE1val se seznam typ\u016F parametr\u016F nebo ...",
        callableNotInstantiable: "Nen\xED mo\u017En\xE9 vytvo\u0159it instanci typu {type}",
        callableSecondArg: "O\u010Dek\xE1val se n\xE1vratov\xFD typ jako druh\xFD argument typu pro Callable",
        casePatternIsIrrefutable: "Nevyvratiteln\xFD vzorec je povolen\xFD jenom pro posledn\xED v\xFDraz velikosti p\xEDsmen",
        classAlreadySpecialized: "Typ {type} je u\u017E specializovan\xFD",
        classDecoratorTypeUnknown: "Dekorat\xE9r netypov\xE9 t\u0159\xEDdy p\u0159ekr\xFDv\xE1 typ t\u0159\xEDdy. dekorat\xE9r se ignoruje",
        classDefinitionCycle: "Definice t\u0159\xEDdy pro \u201E{name}\u201C z\xE1vis\xED sama na sob\u011B",
        classGetItemClsParam: "P\u0159eps\xE1n\xED __class_getitem__ by m\u011Blo m\xEDt parametr cls",
        classMethodClsParam: "Metody t\u0159\xEDdy by m\u011Bly m\xEDt parametr \u201Ecls\u201C",
        classNotRuntimeSubscriptable: "Doln\xED index pro t\u0159\xEDdu {name} vygeneruje v\xFDjimku modulu runtime; v\xFDraz typu uzav\u0159ete do uvozovek.",
        classPatternBuiltInArgPositional: "Vzor t\u0159\xEDdy p\u0159ij\xEDm\xE1 pouze pozi\u010Dn\xED d\xEDl\u010D\xED vzor",
        classPatternNewType: '"{type}" cannot be used in a class pattern because it is defined using NewType',
        classPatternPositionalArgCount: 'P\u0159\xEDli\u0161 mnoho pozi\u010Dn\xEDch vzor\u016F pro t\u0159\xEDdu "{type}"; o\u010Dek\xE1valo se {expected}, ale p\u0159ijalo se {received}',
        classPatternTypeAlias: "Typ \u201E{type}\u201C nelze pou\u017E\xEDt ve vzorci t\u0159\xEDdy, proto\u017Ee se jedn\xE1 o specializovan\xFD alias typu",
        classPropertyDeprecated: "Vlastnosti t\u0159\xEDdy jsou v Pythonu 3.11 zastaral\xE9 a v Pythonu 3.13 se nebudou podporovat.",
        classTypeParametersIllegal: "Syntaxe parametru typu t\u0159\xEDdy vy\u017Eaduje Python 312 nebo nov\u011Bj\u0161\xED",
        classVarFirstArgMissing: "Za ClassVar byl o\u010Dek\xE1v\xE1n argument typu",
        classVarNotAllowed: "ClassVar se v tomto kontextu nepovoluje",
        classVarOverridesInstanceVar: "Prom\u011Bnn\xE1 t\u0159\xEDdy {name} p\u0159ep\xED\u0161e prom\u011Bnnou instance se stejn\xFDm n\xE1zvem ve t\u0159\xEDd\u011B {className}",
        classVarTooManyArgs: "Za \u201EClassVar\u201C byl o\u010Dek\xE1v\xE1n pouze jeden argument typu",
        classVarWithTypeVar: "Typ ClassVar nem\u016F\u017Ee obsahovat prom\u011Bnn\xE9 typu",
        clsSelfParamTypeMismatch: "Typ parametru \u201E{name}\u201C mus\xED b\xFDt nadtyp t\u0159\xEDdy \u201E{classType}\u201C",
        codeTooComplexToAnalyze: "K\xF3d je p\u0159\xEDli\u0161 slo\u017Eit\xFD na anal\xFDzu; sni\u017Ete slo\u017Eitost refaktorizac\xED do podprogram\u016F nebo redukc\xED podm\xEDn\u011Bn\xFDch cest k\xF3du",
        collectionAliasInstantiation: "Nelze vytvo\u0159it instanci typu \u201E{type}\u201C. Pou\u017Eijte m\xEDsto toho \u201E{alias}\u201C",
        comparisonAlwaysFalse: "Podm\xEDnka se v\u017Edy vyhodnot\xED jako False, proto\u017Ee typy {leftType} a {rightType} se nep\u0159ekr\xFDvaj\xED",
        comparisonAlwaysTrue: "Podm\xEDnka se v\u017Edy vyhodnot\xED jako True, proto\u017Ee typy {leftType} a {rightType} se nep\u0159ekr\xFDvaj\xED",
        comprehensionInDict: "Porozum\u011Bn\xED nen\xED mo\u017En\xE9 pou\u017E\xEDt s jin\xFDmi polo\u017Ekami slovn\xEDku",
        comprehensionInSet: "Porozum\u011Bn\xED nelze pou\u017E\xEDt s jin\xFDmi polo\u017Ekami sady (set).",
        concatenateContext: "Mo\u017Enost \u201EConcatenate\u201C nen\xED v tomto kontextu povolen\xE1.",
        concatenateParamSpecMissing: "Posledn\xED argument typu pro \u201EConcatenate\u201C mus\xED b\xFDt \u201EParamSpec\u201C nebo \u201E...\u201C",
        concatenateTypeArgsMissing: "Mo\u017Enost \u201EConcatenate\u201C vy\u017Eaduje alespo\u0148 dva argumenty typu",
        conditionalOperandInvalid: "Neplatn\xFD podm\xEDn\u011Bn\xFD operand typu {type}",
        constantRedefinition: "\u201E{name}\u201C je konstanta (proto\u017Ee je velk\xFDmi p\xEDsmeny) a ned\xE1 se p\u0159edefinovat",
        constructorParametersMismatch: "Neshoda mezi signaturou __new__ a __init__ ve t\u0159\xEDd\u011B\u201C {classType}\u201C",
        containmentAlwaysFalse: "V\xFDraz se v\u017Edy vyhodnot\xED jako False, proto\u017Ee typy \u201E{leftType}\u201C a \u201E{rightType}\u201C se nep\u0159ekr\xFDvaj\xED",
        containmentAlwaysTrue: "V\xFDraz se v\u017Edy vyhodnot\xED jako True, proto\u017Ee typy \u201E{leftType}\u201C a \u201E{rightType}\u201C se nep\u0159ekr\xFDvaj\xED.",
        continueInExceptionGroup: "V bloku except* nen\xED povolen\xE1 mo\u017Enost continue.",
        continueOutsideLoop: "continue se d\xE1 pou\u017E\xEDt jenom ve smy\u010Dce",
        coroutineInConditionalExpression: "Podm\xEDn\u011Bn\xFD v\xFDraz odkazuje na korutinu, kter\xE1 se v\u017Edy vyhodnot\xED jako True.",
        dataClassBaseClassFrozen: "Nezablokovan\xE1 t\u0159\xEDda nem\u016F\u017Ee d\u011Bdit z zmrazen\xE9 t\u0159\xEDdy",
        dataClassBaseClassNotFrozen: "Zablokovan\xE1 t\u0159\xEDda nem\u016F\u017Ee d\u011Bdit z t\u0159\xEDdy, kter\xE1 nen\xED zablokovan\xE1",
        dataClassConverterFunction: "Argument typu {argType} nen\xED platn\xFD p\u0159evad\u011B\u010D pro pole {fieldName} typu {fieldType}",
        dataClassConverterOverloads: "\u017D\xE1dn\xE1 p\u0159et\xED\u017Een\xED {funcName} nejsou platn\xE9 p\u0159evad\u011B\u010De pro pole {fieldName} typu {fieldType}",
        dataClassFieldInheritedDefault: "{fieldName} p\u0159ep\xED\u0161e pole se stejn\xFDm n\xE1zvem, ale chyb\xED mu v\xFDchoz\xED hodnota.",
        dataClassFieldWithDefault: "Pole bez v\xFDchoz\xEDch hodnot se nem\u016F\u017Eou zobrazit po pol\xEDch s v\xFDchoz\xEDmi hodnotami",
        dataClassFieldWithPrivateName: "Pole datov\xE9 t\u0159\xEDdy nem\u016F\u017Ee pou\u017E\xEDvat priv\xE1tn\xED n\xE1zev",
        dataClassFieldWithoutAnnotation: "Pole dataclass bez pozn\xE1mky typu zp\u016Fsob\xED v\xFDjimku modulu runtime",
        dataClassPostInitParamCount: "Datov\xE1 t\u0159\xEDda __post_init__ m\xE1 nespr\xE1vn\xFD po\u010Det parametr\u016F; po\u010Det pol\xED InitVar je {expected}",
        dataClassPostInitType: "Neshoda typu parametru metody __post_init__ datov\xE9 t\u0159\xEDdy pro pole {fieldName}",
        dataClassSlotsOverwrite: "__slots__ je u\u017E ve t\u0159\xEDd\u011B definovan\xFD",
        dataClassTransformExpectedBoolLiteral: "O\u010Dek\xE1val se v\xFDraz, kter\xFD se staticky vyhodnot\xED jako True nebo False",
        dataClassTransformFieldSpecifier: "O\u010Dek\xE1vala se \u0159azen\xE1 kolekce \u010Dlen\u016F (tuple) t\u0159\xEDd nebo funkc\xED, ale byl p\u0159ijat typ \u201E{type}\u201C.",
        dataClassTransformPositionalParam: "V\u0161echny argumenty dataclass_transform mus\xED b\xFDt argumenty kl\xED\u010Dov\xFDch slov",
        dataClassTransformUnknownArgument: "Argument {name} nen\xED v dataclass_transform podporov\xE1n",
        dataProtocolInSubclassCheck: "Datov\xE9 protokoly (kter\xE9 zahrnuj\xED atributy bez metody) nejsou ve vol\xE1n\xEDch issubclass povolen\xE9.",
        declaredReturnTypePartiallyUnknown: "Deklarovan\xFD n\xE1vratov\xFD typ {returnType} je \u010D\xE1ste\u010Dn\u011B nezn\xE1m\xFD",
        declaredReturnTypeUnknown: "Deklarovan\xFD n\xE1vratov\xFD typ je nezn\xE1m\xFD",
        defaultValueContainsCall: "Vol\xE1n\xED funkc\xED a m\u011Bniteln\xE9 objekty nejsou povoleny ve v\xFDrazu v\xFDchoz\xED hodnoty parametru",
        defaultValueNotAllowed: "Parametr s * nebo ** nem\u016F\u017Ee m\xEDt v\xFDchoz\xED hodnotu",
        delTargetExpr: "V\xFDraz se ned\xE1 odstranit",
        deprecatedClass: "T\u0159\xEDda {name} je zastaral\xE1",
        deprecatedConstructor: "Konstruktor pro t\u0159\xEDdu {name} je zastaral\xFD",
        deprecatedDescriptorDeleter: "Metoda \u201E__delete__\u201C pro popisova\u010D \u201E{name}\u201C je zastaral\xE1",
        deprecatedDescriptorGetter: "Metoda \u201E__get__\u201C pro popisova\u010D \u201E{name}\u201C je zastaral\xE1",
        deprecatedDescriptorSetter: "Metoda \u201E__set__\u201C pro popisova\u010D \u201E{name}\u201C je zastaral\xE1",
        deprecatedFunction: "Funkce {name} je zastaral\xE1.",
        deprecatedMethod: "Metoda {name} ve t\u0159\xEDd\u011B {className} je zastaral\xE1.",
        deprecatedPropertyDeleter: "Metoda deleter pro property \u201E{name}\u201C je zastaral\xE1.",
        deprecatedPropertyGetter: "Metoda getter pro property \u201E{name}\u201C je zastaral\xE1.",
        deprecatedPropertySetter: "Metoda setter pro property \u201E{name}\u201C je zastaral\xE1.",
        deprecatedType: "Tento typ je zastaral\xFD jako Python {version}; m\xEDsto toho pou\u017Eijte {replacement}",
        dictExpandIllegalInComprehension: "Roz\u0161\xED\u0159en\xED slovn\xEDku nen\xED v porozum\u011Bn\xED povoleno",
        dictInAnnotation: "V\xFDraz slovn\xEDku nen\xED ve v\xFDrazu typu povolen\xFD.",
        dictKeyValuePairs: "Polo\u017Eky slovn\xEDku mus\xED obsahovat p\xE1ry kl\xED\u010D/hodnota",
        dictUnpackIsNotMapping: "O\u010Dek\xE1valo se mapov\xE1n\xED pro oper\xE1tor rozbalen\xED slovn\xEDku",
        dunderAllSymbolNotPresent: "{name} je zad\xE1no v __all__, ale v modulu se nenach\xE1z\xED",
        duplicateArgsParam: "Je povolen\xFD jenom jeden parametr *",
        duplicateBaseClass: "Duplicitn\xED z\xE1kladn\xED t\u0159\xEDda nen\xED povolena",
        duplicateCapturePatternTarget: "C\xEDl zachyt\xE1v\xE1n\xED {name} se v r\xE1mci stejn\xE9ho vzoru nem\u016F\u017Ee vyskytovat v\xEDce ne\u017E jednou",
        duplicateCatchAll: "Je povolena pouze jedna klauzule catch-all except",
        duplicateEnumMember: "\u010Clen Enum {name} je u\u017E deklarovan\xFD.",
        duplicateGenericAndProtocolBase: "Je povolena pouze jedna z\xE1kladn\xED t\u0159\xEDda Generic[...] nebo Protocol[...].",
        duplicateImport: "Import {importName} je importov\xE1n v\xEDce ne\u017E jednou",
        duplicateKeywordOnly: "Je povolen\xFD jenom jeden odd\u011Blova\u010D *",
        duplicateKwargsParam: "Je povolen\xFD jenom jeden parametr **",
        duplicateParam: "duplicitn\xED parametr {name}",
        duplicatePositionOnly: "Je povolen\xFD jenom jeden parametr \u201E/\u201C",
        duplicateStarPattern: "V sekvenci vzor\u016F je povolen\xFD jenom jeden vzor \u201E*\u201C",
        duplicateStarStarPattern: "Je povolena pouze jedna polo\u017Eka \u201E**\u201C",
        duplicateUnpack: "V seznamu (list) je povolena pouze jedna operace rozbalen\xED.",
        ellipsisAfterUnpacked: "\u201E\u2026\u201C nelze pou\u017E\xEDt s rozbalenou kolekc\xED TypeVarTuple nebo tuple.",
        ellipsisContext: "\u201E...\u201C se v tomto kontextu nepovoluje",
        ellipsisSecondArg: "\u201E...\u201C je povoleno pouze jako druh\xFD ze dvou argument\u016F",
        enumClassOverride: "T\u0159\xEDda Enum {name} je final a nem\u016F\u017Ee b\xFDt podt\u0159\xEDdou.",
        enumMemberDelete: "\u010Clen Enum {name} se ned\xE1 odstranit.",
        enumMemberSet: "\u010Clen Enum {name} se ned\xE1 p\u0159i\u0159adit.",
        enumMemberTypeAnnotation: "Pozn\xE1mky typu nejsou pro \u010Dleny enum povolen\xE9.",
        exceptGroupMismatch: "P\u0159\xEDkaz Try nem\u016F\u017Ee obsahovat jak except, tak i except*.",
        exceptGroupRequiresType: 'Syntaxe skupiny v\xFDjimek ("except*") vy\u017Eaduje typ v\xFDjimky.',
        exceptRequiresParens: "Multiple exception types must be parenthesized prior to Python 3.14",
        exceptWithAsRequiresParens: 'Multiple exception types must be parenthesized when using "as"',
        exceptionGroupIncompatible: 'Syntaxe skupiny v\xFDjimek ("except*") vy\u017Eaduje Python 3.11 nebo nov\u011Bj\u0161\xED',
        exceptionGroupTypeIncorrect: "Typ v\xFDjimky v except* se ned\xE1 odvodit z BaseGroupException.",
        exceptionTypeIncorrect: "\u201E{type}\u201C se neodvozuje od BaseException",
        exceptionTypeNotClass: "{type} nen\xED platn\xE1 t\u0159\xEDda v\xFDjimky",
        exceptionTypeNotInstantiable: "Konstruktor pro v\xFDjimku typu {type} vy\u017Eaduje jeden nebo v\xEDce argument\u016F",
        expectedAfterDecorator: "O\u010Dek\xE1van\xE1 deklarace funkce nebo t\u0159\xEDdy po dekorat\xE9ru",
        expectedArrow: "Byl o\u010Dek\xE1v\xE1n znak -> n\xE1sledovan\xFD anotac\xED n\xE1vratov\xE9ho typu",
        expectedAsAfterException: "Za typem v\xFDjimky byl o\u010Dek\xE1v\xE1n znak \u201Eas\u201C",
        expectedAssignRightHandExpr: "Byl o\u010Dek\xE1v\xE1n v\xFDraz napravo od znaku =",
        expectedBinaryRightHandExpr: "O\u010Dek\xE1val se v\xFDraz napravo od oper\xE1toru",
        expectedBoolLiteral: "O\u010Dek\xE1vala se hodnota True nebo False",
        expectedCase: "O\u010Dek\xE1val se p\u0159\xEDkaz case",
        expectedClassName: "O\u010Dek\xE1val se n\xE1zev t\u0159\xEDdy",
        expectedCloseBrace: "{ nebyla uzav\u0159ena",
        expectedCloseBracket: "[ nebyla uzav\u0159ena",
        expectedCloseParen: "( nebyla uzav\u0159ena",
        expectedColon: "O\u010Dek\xE1val se znak :",
        expectedComplexNumberLiteral: "O\u010Dek\xE1val se komplexn\xED \u010D\xEDseln\xFD liter\xE1l pro porovn\xE1v\xE1n\xED vzor\u016F",
        expectedDecoratorExpr: "Forma v\xFDrazu nen\xED podporov\xE1na pro dekor\xE1tor p\u0159ed verz\xED Python 3.9",
        expectedDecoratorName: "O\u010Dek\xE1val se n\xE1zev dekorat\xE9ru",
        expectedDecoratorNewline: "Na konci dekorat\xE9ru byl o\u010Dek\xE1v\xE1n nov\xFD \u0159\xE1dek",
        expectedDelExpr: "Za del se o\u010Dek\xE1val v\xFDraz",
        expectedElse: "O\u010Dek\xE1valo se else",
        expectedEquals: "O\u010Dek\xE1val se znak =",
        expectedExceptionClass: "Neplatn\xE1 t\u0159\xEDda nebo objekt v\xFDjimky",
        expectedExceptionObj: "Byl o\u010Dek\xE1v\xE1n objekt v\xFDjimky, t\u0159\xEDda v\xFDjimky nebo None",
        expectedExpr: "O\u010Dek\xE1van\xFD v\xFDraz",
        expectedFunctionAfterAsync: "O\u010Dek\xE1van\xE1 definice funkce po \u201Easync\u201C",
        expectedFunctionName: "Za def se o\u010Dek\xE1val n\xE1zev funkce",
        expectedIdentifier: "O\u010Dek\xE1van\xFD identifik\xE1tor",
        expectedImport: "O\u010Dek\xE1val se import",
        expectedImportAlias: "Za as byl o\u010Dek\xE1v\xE1n symbol",
        expectedImportSymbols: "Po mo\u017Enosti import se o\u010Dek\xE1val jeden nebo v\xEDce n\xE1zv\u016F symbol\u016F.",
        expectedIn: "O\u010Dek\xE1valo se in",
        expectedInExpr: "Za in byl o\u010Dek\xE1v\xE1n v\xFDraz",
        expectedIndentedBlock: "O\u010Dek\xE1val se odsazen\xFD blok",
        expectedMemberName: "Za te\u010Dkou (.) byl o\u010Dek\xE1v\xE1n n\xE1zev atributu.",
        expectedModuleName: "O\u010Dek\xE1van\xFD n\xE1zev modulu",
        expectedNameAfterAs: "Za \u201Eas\u201C se o\u010Dek\xE1val n\xE1zev symbolu",
        expectedNamedParameter: "Parametr kl\xED\u010Dov\xE9ho slova mus\xED n\xE1sledovat za znakem *",
        expectedNewline: "O\u010Dek\xE1val se nov\xFD \u0159\xE1dek",
        expectedNewlineOrSemicolon: "P\u0159\xEDkazy mus\xED b\xFDt odd\u011Blen\xE9 nov\xFDmi \u0159\xE1dky nebo st\u0159edn\xEDky",
        expectedOpenParen: "O\u010Dek\xE1val se znak \u201E(\u201C",
        expectedParamName: "O\u010Dek\xE1val se n\xE1zev parametru",
        expectedPatternExpr: "O\u010Dek\xE1van\xFD v\xFDraz vzoru",
        expectedPatternSubjectExpr: "O\u010Dek\xE1van\xFD v\xFDraz p\u0159edm\u011Btu vzoru",
        expectedPatternValue: "O\u010Dek\xE1van\xFD v\xFDraz hodnoty vzoru ve form\xE1tu a.b",
        expectedReturnExpr: "Za return se o\u010Dek\xE1val v\xFDraz",
        expectedSliceIndex: "O\u010Dek\xE1van\xFD v\xFDraz indexu nebo \u0159ezu",
        expectedTypeNotString: "O\u010Dek\xE1val se typ, ale p\u0159ijal se \u0159et\u011Bzcov\xFD liter\xE1l",
        expectedTypeParameterName: "O\u010Dek\xE1van\xFD n\xE1zev parametru typu",
        expectedYieldExpr: "O\u010Dek\xE1van\xFD v\xFDraz v p\u0159\xEDkazu yield",
        finalClassIsAbstract: "T\u0159\xEDda \u201E{type}\u201C je ozna\u010Dena jako final a mus\xED implementovat v\u0161echny abstraktn\xED symboly.",
        finalContext: "Final se v tomto kontextu nepovoluje",
        finalInLoop: "Prom\u011Bnnou Final nelze p\u0159i\u0159adit ve smy\u010Dce.",
        finalMethodOverride: "Metoda {name} nem\u016F\u017Ee p\u0159epsat metodu final definovanou ve t\u0159\xEDd\u011B {className}.",
        finalNonMethod: "Funkci \u201E{name}\u201C nelze ozna\u010Dit @final, proto\u017Ee se nejedn\xE1 o metodu.",
        finalReassigned: "\u201E{name}\u201C se deklaruje jako Final a ned\xE1 se znovu p\u0159i\u0159adit",
        finalRedeclaration: "{name} se d\u0159\xEDve deklarovalo jako Final",
        finalRedeclarationBySubclass: "{name} se ned\xE1 deklarovat znovu, proto\u017Ee nad\u0159azen\xE1 t\u0159\xEDda {className} ji deklaruje jako Final.",
        finalTooManyArgs: "Za Final byl o\u010Dek\xE1v\xE1n jeden argument typu",
        finalUnassigned: "{name} se deklaruje jako Final, ale hodnota nen\xED p\u0159i\u0159azen\xE1.",
        finallyBreak: "K ukon\u010Den\xED bloku \u201Efinally\u201C nelze pou\u017E\xEDt \u201Ebreak\u201C.",
        finallyContinue: "K ukon\u010Den\xED bloku \u201Efinally\u201C nelze pou\u017E\xEDt \u201Econtinue\u201C.",
        finallyReturn: "K ukon\u010Den\xED bloku \u201Efinally\u201C nelze pou\u017E\xEDt \u201Ereturn\u201C.",
        formatStringBrace: "Jednoduch\xE1 prav\xE1 slo\u017Een\xE1 z\xE1vorka nen\xED v liter\xE1lu f-string povolena. pou\u017Eijte dvojitou pravou slo\u017Eenou z\xE1vorku",
        formatStringBytes: "Form\xE1tovac\xED \u0159et\u011Bzcov\xE9 liter\xE1ly (f-strings) nem\u016F\u017Eou b\xFDt bin\xE1rn\xED",
        formatStringDebuggingIllegal: "Specifik\xE1tor lad\u011Bn\xED F-string \u201E=\u201C vy\u017Eaduje Python 3.8 nebo nov\u011Bj\u0161\xED",
        formatStringEscape: "\u0158\xEDdic\xED sekvence (zp\u011Btn\xE9 lom\xEDtko) nen\xED povolen\xE1 v \u010D\xE1sti v\xFDrazu f-string p\u0159ed Python 3.12",
        formatStringExpectedConversion: "V \u0159et\u011Bzci f-string byl za znakem ! o\u010Dek\xE1v\xE1n specifik\xE1tor p\u0159evodu",
        formatStringIllegal: "Form\xE1tovac\xED \u0159et\u011Bzcov\xE9 liter\xE1ly (f-string) vy\u017Eaduj\xED Python 3.6 nebo nov\u011Bj\u0161\xED",
        formatStringInPattern: "Form\xE1tovac\xED \u0159et\u011Bzec nen\xED ve vzoru povolen\xFD",
        formatStringNestedFormatSpecifier: "P\u0159\xEDli\u0161 hluboko vno\u0159en\xE9 v\xFDrazy v r\xE1mci specifik\xE1toru form\xE1tovac\xEDho \u0159et\u011Bzce",
        formatStringNestedQuote: "\u0158et\u011Bzce vno\u0159en\xE9 v \u0159et\u011Bzci f-string nem\u016F\u017Eou pou\u017E\xEDvat stejn\xFD znak uvozovek jako \u0159et\u011Bzec f-string p\u0159ed Python 3.12",
        formatStringTemplate: "Format string literals (f-strings) cannot also be template strings (t-strings)",
        formatStringUnicode: "Form\xE1tovac\xED \u0159et\u011Bzcov\xE9 liter\xE1ly (f-strings) nem\u016F\u017Eou b\xFDt unicode",
        formatStringUnterminated: "Neukon\u010Den\xFD v\xFDraz v f-string; o\u010Dek\xE1v\xE1 se \u201E}\u201C",
        functionDecoratorTypeUnknown: "Dekor\xE1tor netypov\xE9 funkce p\u0159ekr\xFDv\xE1 typ funkce; ignoruje se dekorat\xE9r",
        functionInConditionalExpression: "Podm\xEDn\u011Bn\xFD v\xFDraz odkazuje na funkci, kter\xE1 se v\u017Edy vyhodnot\xED jako True",
        functionTypeParametersIllegal: "Syntaxe parametru typu funkce vy\u017Eaduje Python 3.12 nebo nov\u011Bj\u0161\xED",
        futureImportLocationNotAllowed: "Importy z __future__ mus\xED b\xFDt na za\u010D\xE1tku souboru",
        generatorAsyncReturnType: "N\xE1vratov\xFD typ funkce asynchronn\xEDho gener\xE1toru mus\xED b\xFDt kompatibiln\xED s typem AsyncGenerator[{yieldType}, Any]",
        generatorNotParenthesized: "V\xFDrazy gener\xE1toru mus\xED b\xFDt v z\xE1vork\xE1ch, pokud nejsou jedin\xFDm argumentem",
        generatorSyncReturnType: "N\xE1vratov\xFD typ funkce gener\xE1toru mus\xED b\xFDt kompatibiln\xED s Generator[{yieldType}, Any, Any]",
        genericBaseClassNotAllowed: "Z\xE1kladn\xED t\u0159\xEDdu \u201EGeneric\u201C nejde pou\u017E\xEDt se syntax\xED parametru typu",
        genericClassAssigned: "Obecn\xFD typ t\u0159\xEDdy nen\xED mo\u017En\xE9 p\u0159i\u0159adit",
        genericClassDeleted: "Obecn\xFD typ t\u0159\xEDdy nelze odstranit",
        genericInstanceVariableAccess: "P\u0159\xEDstup k obecn\xE9 prom\u011Bnn\xE9 instance prost\u0159ednictv\xEDm t\u0159\xEDdy je nejednozna\u010Dn\xFD.",
        genericNotAllowed: "Generic nen\xED v tomto kontextu platn\xFD",
        genericTypeAliasBoundTypeVar: "Alias obecn\xE9ho typu v r\xE1mci t\u0159\xEDdy nem\u016F\u017Ee pou\u017E\xEDvat prom\u011Bnn\xE9 v\xE1zan\xE9ho typu {names}",
        genericTypeArgMissing: "Generic vy\u017Eaduje alespo\u0148 jeden argument typu",
        genericTypeArgTypeVar: "Argument typu pro Generic mus\xED b\xFDt prom\u011Bnn\xE1 typu",
        genericTypeArgUnique: "Argumenty typu pro Generic mus\xED b\xFDt jedine\u010Dn\xE9",
        globalReassignment: "{name} je p\u0159i\u0159azen p\u0159ed deklarac\xED global.",
        globalRedefinition: "N\xE1zev {name} u\u017E je deklarov\xE1n jako global.",
        implicitStringConcat: "Implicitn\xED z\u0159et\u011Bzen\xED \u0159et\u011Bzc\u016F nen\xED povolen\xE9",
        importCycleDetected: "V \u0159et\u011Bzci importu byl zji\u0161t\u011Bn cyklus",
        importDepthExceeded: "Hloubka \u0159et\u011Bzu importu p\u0159ekro\u010Dila {depth}",
        importResolveFailure: "Import {importName} se nepovedlo vy\u0159e\u0161it",
        importSourceResolveFailure: "Import {importName} se nepovedlo p\u0159elo\u017Eit ze zdroje",
        importSymbolUnknown: "{name} je nezn\xE1m\xFD symbol importu",
        incompatibleMethodOverride: "Metoda {name} p\u0159episuje t\u0159\xEDdu {className} nekompatibiln\xEDm zp\u016Fsobem",
        inconsistentIndent: "Mno\u017Estv\xED zru\u0161en\xE9ho odsazen\xED neodpov\xEDd\xE1 p\u0159edchoz\xEDmu odsazen\xED",
        inconsistentTabs: "Nekonzistentn\xED pou\u017Eit\xED tabul\xE1tor\u016F a mezer v odsazen\xED",
        initMethodSelfParamTypeVar: "Anotace typu pro parametr self metody __init__ nem\u016F\u017Ee obsahovat prom\u011Bnn\xE9 typu s oborem t\u0159\xEDdy.",
        initMustReturnNone: "N\xE1vratov\xFD typ __init__ mus\xED b\xFDt None",
        initSubclassCallFailed: "Nespr\xE1vn\xE9 argumenty kl\xED\u010Dov\xE9ho slova pro metodu __init_subclass__",
        initSubclassClsParam: "P\u0159eps\xE1n\xED __init_subclass__ by m\u011Blo m\xEDt parametr cls",
        initVarNotAllowed: "InitVar se v tomto kontextu nepovoluje.",
        instanceMethodSelfParam: "Metody instance by m\u011Bly m\xEDt parametr self",
        instanceVarOverridesClassVar: "Prom\u011Bnn\xE1 instance \u201E{name}\u201C p\u0159ep\xED\u0161e prom\u011Bnnou t\u0159\xEDdy se stejn\xFDm n\xE1zvem ve t\u0159\xEDd\u011B \u201E{className}\u201C",
        instantiateAbstract: "Nelze vytvo\u0159it instanci abstraktn\xED t\u0159\xEDdy \u201E{type}\u201C",
        instantiateProtocol: "Nelze vytvo\u0159it instanci t\u0159\xEDdy Protocol \u201E{type}\u201C.",
        internalBindError: "P\u0159i vytv\xE1\u0159en\xED vazby souboru {file} do\u0161lo k vnit\u0159n\xED chyb\u011B: {message}",
        internalParseError: "P\u0159i anal\xFDze souboru {file} do\u0161lo k vnit\u0159n\xED chyb\u011B: {message}",
        internalTypeCheckingError: "P\u0159i kontrole typu souboru {file} do\u0161lo k vnit\u0159n\xED chyb\u011B: {message}",
        invalidIdentifierChar: "Neplatn\xFD znak v identifik\xE1toru",
        invalidStubStatement: "P\u0159\xEDkaz je v souboru z\xE1stupn\xE9 procedury (stub) typu bezv\xFDznamn\xFD.",
        invalidTokenChars: "Neplatn\xFD znak \u201E{text}\u201C v tokenu",
        isInstanceInvalidType: "Druh\xFD argument pro \u201Eisinstance\u201C mus\xED b\xFDt t\u0159\xEDda nebo \u0159azen\xE1 kolekce \u010Dlen\u016F (tuple) t\u0159\xEDd.",
        isSubclassInvalidType: "Druh\xFD argument pro issubclass mus\xED b\xFDt t\u0159\xEDda nebo \u0159azen\xE1 kolekce \u010Dlen\u016F (tuple) t\u0159\xEDd.",
        keyValueInSet: "P\xE1ry kl\xED\u010D-hodnota nejsou v r\xE1mci sady (set) povoleny.",
        keywordArgInTypeArgument: "Argumenty kl\xED\u010Dov\xFDch slov nelze pou\u017E\xEDt v seznamech argument\u016F typu",
        keywordOnlyAfterArgs: "Odd\u011Blova\u010D argument\u016F jen pro kl\xED\u010Dov\xE1 slova nen\xED povolen\xFD za parametrem *",
        keywordParameterMissing: "Jeden nebo v\xEDce parametr\u016F kl\xED\u010Dov\xE9ho slova mus\xED n\xE1sledovat za parametrem \u201E*\u201C",
        keywordSubscriptIllegal: "Argumenty kl\xED\u010Dov\xFDch slov v doln\xEDch indexech nejsou podporov\xE1ny",
        lambdaReturnTypePartiallyUnknown: "N\xE1vratov\xFD typ lambda {returnType} je \u010D\xE1ste\u010Dn\u011B nezn\xE1m\xFD",
        lambdaReturnTypeUnknown: "N\xE1vratov\xFD typ v\xFDrazu lambda je nezn\xE1m\xFD",
        listAssignmentMismatch: "V\xFDraz s typem {type} se ned\xE1 p\u0159i\u0159adit k c\xEDlov\xE9mu seznamu",
        listInAnnotation: "V\xFDraz List nen\xED ve v\xFDrazu typu povolen\xFD.",
        literalEmptyArgs: "Za liter\xE1lem (Literal) se o\u010Dek\xE1val jeden nebo v\xEDce argument\u016F typu.",
        literalNamedUnicodeEscape: "Pojmenovan\xE9 \u0159\xEDdic\xED sekvence Unicode nejsou v pozn\xE1mk\xE1ch \u0159et\u011Bzc\u016F Literal podporov\xE1ny.",
        literalNotAllowed: "\u201ELiteral\u201C nejde v tomto kontextu pou\u017E\xEDt bez argumentu typu.",
        literalNotCallable: "Nen\xED mo\u017En\xE9 vytvo\u0159it instanci typu Literal.",
        literalUnsupportedType: "Argumenty typu pro Literal mus\xED b\xFDt None, hodnota liter\xE1lu (int, bool, str nebo bytes) nebo hodnota enum.",
        matchIncompatible: "P\u0159\xEDkazy match vy\u017Eaduj\xED Python 3.10 nebo nov\u011Bj\u0161\xED",
        matchIsNotExhaustive: "P\u0159\xEDpady v r\xE1mci p\u0159\xEDkazu match nezpracov\xE1vaj\xED kompletn\u011B v\u0161echny hodnoty",
        maxParseDepthExceeded: "Byla p\u0159ekro\u010Dena maxim\xE1ln\xED hloubka anal\xFDzy; rozd\u011Blte v\xFDraz na d\xEDl\u010D\xED v\xFDrazy",
        memberAccess: "Nelze z\xEDskat p\u0159\xEDstup k atributu {name} pro t\u0159\xEDdu {type}.",
        memberDelete: "Nelze odstranit atribut {name} pro t\u0159\xEDdu {type}.",
        memberSet: "Nelze p\u0159i\u0159adit k atributu {name} pro t\u0159\xEDdu {type}.",
        metaclassConflict: "Metat\u0159\xEDda odvozen\xE9 t\u0159\xEDdy mus\xED b\xFDt podt\u0159\xEDdou metat\u0159\xEDd v\u0161ech jej\xEDch z\xE1kladn\xEDch t\u0159\xEDd",
        metaclassDuplicate: "Je mo\u017En\xE9 zadat pouze jednu metat\u0159\xEDdu",
        metaclassIsGeneric: "Metat\u0159\xEDda nem\u016F\u017Ee b\xFDt obecn\xE1",
        methodNotDefined: "Metoda {name} nen\xED definov\xE1na",
        methodNotDefinedOnType: "Metoda {name} nen\xED u typu {type} definov\xE1na",
        methodOrdering: "Nen\xED mo\u017En\xE9 vytvo\u0159it konzistentn\xED \u0159azen\xED metod",
        methodOverridden: "\u201E{name}\u201C p\u0159episuje metodu se stejn\xFDm n\xE1zvem ve t\u0159\xEDd\u011B \u201E{className}\u201C s nekompatibiln\xEDm typem {type}",
        methodReturnsNonObject: "Metoda {name} nevrac\xED objekt",
        missingSuperCall: "Metoda {methodName} nevol\xE1 metodu se stejn\xFDm n\xE1zvem v nad\u0159azen\xE9 t\u0159\xEDd\u011B",
        mixingBytesAndStr: "Hodnoty bytes a str nelze z\u0159et\u011Bzit.",
        moduleAsType: "Modul nejde pou\u017E\xEDt jako typ",
        moduleNotCallable: "Modul nen\xED volateln\xFD",
        moduleUnknownMember: "{memberName} nen\xED zn\xE1m\xFD atribut modulu {moduleName}.",
        namedExceptAfterCatchAll: "Za klauzul\xED catch-all except se nem\u016F\u017Ee objevit pojmenovan\xE1 klauzule except",
        namedParamAfterParamSpecArgs: "Parametr kl\xED\u010Dov\xE9ho slova {name} se nem\u016F\u017Ee objevit v signatu\u0159e za parametrem ParamSpec args.",
        namedTupleEmptyName: "N\xE1zvy v pojmenovan\xE9 \u0159azen\xE9 kolekci \u010Dlen\u016F (tuple) nem\u016F\u017Eou b\xFDt pr\xE1zdn\xE9.",
        namedTupleEntryRedeclared: "{name} nejde p\u0159epsat, proto\u017Ee nad\u0159azen\xE1 t\u0159\xEDda {className} je pojmenovan\xE1 \u0159azen\xE1 kolekce \u010Dlen\u016F (tuple).",
        namedTupleFieldUnderscore: "N\xE1zvy pol\xED pojmenovan\xE9 \u0159azen\xE9 kolekce \u010Dlen\u016F (Named tuple) nem\u016F\u017Eou za\u010D\xEDnat podtr\u017E\xEDtkem.",
        namedTupleFirstArg: "Jako prvn\xED argument byl o\u010Dek\xE1v\xE1n n\xE1zev pojmenovan\xE9 t\u0159\xEDdy \u0159azen\xE9 kolekce \u010Dlen\u016F (tuple).",
        namedTupleMultipleInheritance: "V\xEDcen\xE1sobn\xE1 d\u011Bdi\u010Dnost s NamedTuple se nepodporuje",
        namedTupleNameKeyword: "N\xE1zvy pol\xED nem\u016F\u017Eou b\xFDt kl\xED\u010Dov\xE9 slovo.",
        namedTupleNameType: "O\u010Dek\xE1vala se \u0159azen\xE1 kolekce \u010Dlen\u016F (tuple) se dv\u011Bma polo\u017Ekami ur\u010Duj\xEDc\xED n\xE1zev a typ polo\u017Eky.",
        namedTupleNameUnique: "N\xE1zvy v pojmenovan\xE9 \u0159azen\xE9 kolekci \u010Dlen\u016F (tuple) mus\xED b\xFDt jedine\u010Dn\xE9.",
        namedTupleNoTypes: "namedtuple neposkytuje \u017E\xE1dn\xE9 typy pro polo\u017Eky tuple; m\xEDsto toho pou\u017Eijte NamedTuple",
        namedTupleSecondArg: "Jako druh\xFD argument byl o\u010Dek\xE1v\xE1n pojmenovan\xFD seznam (list) \u0159azen\xE9 kolekce \u010Dlen\u016F (tuple).",
        newClsParam: "P\u0159eps\xE1n\xED __new__ by m\u011Blo m\xEDt parametr cls",
        newTypeAnyOrUnknown: "Druh\xFD argument pro NewType mus\xED b\xFDt zn\xE1m\xE1 t\u0159\xEDda, nikoli Any nebo Unknown.",
        newTypeBadName: "Prvn\xEDm argumentem pro NewType mus\xED b\xFDt \u0159et\u011Bzcov\xFD liter\xE1l",
        newTypeLiteral: "Typ NewType nen\xED mo\u017En\xE9 pou\u017E\xEDt s typem Literal",
        newTypeNameMismatch: "Typ NewType mus\xED b\xFDt p\u0159i\u0159azen prom\u011Bnn\xE9 se stejn\xFDm n\xE1zvem.",
        newTypeNotAClass: "O\u010Dek\xE1van\xE1 t\u0159\xEDda jako druh\xFD argument pro NewType",
        newTypeParamCount: "NewType vy\u017Eaduje dva pozi\u010Dn\xED argumenty",
        newTypeProtocolClass: "NewType nelze pou\u017E\xEDt se struktur\xE1ln\xEDm typem (t\u0159\xEDda Protocol nebo TypedDict).",
        noOverload: "Zadan\xFDm argument\u016Fm neodpov\xEDdaj\xED \u017E\xE1dn\xE1 p\u0159et\xED\u017Een\xED pro {name}",
        noReturnContainsReturn: "Funkce s deklarovan\xFDm n\xE1vratov\xFDm typem return type NoReturn nem\u016F\u017Ee obsahovat p\u0159\xEDkaz return.",
        noReturnContainsYield: "Funkce s deklarovan\xFDm n\xE1vratov\xFDm typem NoReturn nem\u016F\u017Ee obsahovat p\u0159\xEDkaz yield",
        noReturnReturnsNone: "Funkce s deklarovan\xFDm n\xE1vratov\xFDm typem \u201ENoReturn\u201C nem\u016F\u017Ee vr\xE1tit \u201ENone\u201C.",
        nonDefaultAfterDefault: "Nev\xFDchoz\xED argument n\xE1sleduje za v\xFDchoz\xEDm argumentem",
        nonLocalInModule: "Deklarace Nonlocal nen\xED povolen\xE1 na \xFArovni modulu.",
        nonLocalNoBinding: "Nena\u0161la se \u017E\xE1dn\xE1 vazba pro nonlocal {name}.",
        nonLocalReassignment: "{name} je p\u0159i\u0159azeno p\u0159ed deklarac\xED nonlocal.",
        nonLocalRedefinition: "{name} ji\u017E bylo deklarov\xE1no jako nonlocal.",
        noneNotCallable: "Objekt typu \u201ENone\u201C nelze volat.",
        noneNotIterable: "Objekt typu None nen\xED mo\u017En\xE9 pou\u017E\xEDt jako iterovatelnou hodnotu",
        noneNotSubscriptable: "Objekt typu \u201CNone\u201C nelze zadat jako doln\xED index",
        noneNotUsableWith: 'Object of type "None" cannot be used with "with"',
        noneNotUsableWithAsync: "Objekt typu None nen\xED mo\u017En\xE9 pou\u017E\xEDt s typem async with.",
        noneOperator: "Oper\xE1tor {operator} se pro None nepodporuje",
        noneUnknownMember: "{name} nen\xED zn\xE1m\xFD atribut None.",
        nonlocalTypeParam: "Pro parametr typu {name} nen\xED povolen\xE1 vazba nonlocal.",
        notRequiredArgCount: "Za NotRequired byl o\u010Dek\xE1v\xE1n jeden argument typu",
        notRequiredNotInTypedDict: "NotRequired nen\xED v tomto kontextu povolen\xE9",
        objectNotCallable: "Objekt typu {type} nen\xED mo\u017En\xE9 volat",
        obscuredClassDeclaration: "Deklarace t\u0159\xEDdy {name} je zakryt\xE1 deklarac\xED stejn\xE9ho jm\xE9na",
        obscuredFunctionDeclaration: "Deklarace funkce {name} je zakryt\xE1 deklarac\xED stejn\xE9ho n\xE1zvu",
        obscuredMethodDeclaration: "Deklarace metody {name} je zakryt\xE1 deklarac\xED stejn\xE9ho n\xE1zvu",
        obscuredParameterDeclaration: "Deklarace parametru {name} je zakryt\xE1 deklarac\xED stejn\xE9ho n\xE1zvu",
        obscuredTypeAliasDeclaration: "Deklarace aliasu typu {name} je zakryt\xE1 deklarac\xED stejn\xE9ho n\xE1zvu",
        obscuredVariableDeclaration: "Deklarace {name} je zakryt\xE1 deklarac\xED stejn\xE9ho n\xE1zvu",
        operatorLessOrGreaterDeprecated: "Oper\xE1tor <> se v Pythonu 3 nepodporuje; m\xEDsto toho pou\u017Eijte !=",
        optionalExtraArgs: "Za nepovinnou hodnotou (Optional) se o\u010Dek\xE1val jeden argument typu.",
        orPatternIrrefutable: "Nevratn\xFD vzor je povolen\xFD jenom jako posledn\xED d\xEDl\u010D\xED vzorec ve vzorci \u201Eor\u201C",
        orPatternMissingName: "V\u0161echny d\xEDl\u010D\xED vzory v r\xE1mci vzoru or mus\xED c\xEDlit na stejn\xE9 n\xE1zvy",
        overlappingKeywordArgs: "Slovn\xEDk siln\xE9ho typu se p\u0159ekr\xFDv\xE1 s parametrem kl\xED\u010Dov\xE9ho slova: {names}",
        overlappingOverload: "P\u0159et\xED\u017Een\xED {obscured} pro {name} se nikdy nepou\u017Eije, proto\u017Ee jeho parametry se p\u0159ekr\xFDvaj\xED s p\u0159et\xED\u017Een\xEDm {obscuredBy}",
        overloadAbstractImplMismatch: "P\u0159et\xED\u017Een\xED mus\xED odpov\xEDdat abstraktn\xEDmu stavu implementace.",
        overloadAbstractMismatch: "Bu\u010F mus\xED b\xFDt v\u0161echna p\u0159et\xED\u017Een\xED abstraktn\xED, nebo naopak nesm\xED b\xFDt \u017E\xE1dn\xE9 z nich abstraktn\xED.",
        overloadClassMethodInconsistent: "P\u0159et\xED\u017Een\xED pro {name} pou\u017E\xEDvaj\xED @classmethod nekonzistentn\u011B.",
        overloadFinalImpl: "dekorat\xE9r @final by se m\u011Bl pou\u017E\xEDvat jenom pro implementaci.",
        overloadFinalNoImpl: "Pouze prvn\xED p\u0159et\xED\u017Een\xED by m\u011Blo b\xFDt ozna\u010Deno @final",
        overloadImplementationMismatch: "P\u0159et\xED\u017Een\xE1 implementace nen\xED konzistentn\xED se signaturou p\u0159et\xED\u017Een\xED {index}",
        overloadOverrideImpl: "dekorat\xE9r @override by se m\u011Bl pou\u017E\xEDvat jenom pro implementaci.",
        overloadOverrideNoImpl: "Pouze prvn\xED p\u0159et\xED\u017Een\xED by m\u011Blo b\xFDt ozna\u010Deno @override",
        overloadReturnTypeMismatch: "P\u0159et\xED\u017Een\xED {prevIndex} pro {name} se p\u0159ekr\xFDv\xE1 s p\u0159et\xED\u017Een\xEDm {newIndex} a vrac\xED nekompatibiln\xED typ",
        overloadStaticMethodInconsistent: "P\u0159et\xED\u017Een\xED pro {name} pou\u017E\xEDvaj\xED @staticmethod nekonzistentn\u011B.",
        overloadWithoutImplementation: "\u201E{name}\u201C je ozna\u010Den\xE9 jako p\u0159et\xED\u017Een\xED (overload), ale nen\xED zadan\xE1 \u017E\xE1dn\xE1 implementace.",
        overriddenMethodNotFound: "Metoda \u201E{name}\u201C je ozna\u010Den\xE1 jako p\u0159eps\xE1n\xED (override), ale neexistuje \u017E\xE1dn\xE1 z\xE1kladn\xED metoda se stejn\xFDm n\xE1zvem.",
        overrideDecoratorMissing: "Metoda \u201E{name}\u201C nen\xED ozna\u010Den\xE1 jako p\u0159eps\xE1n\xED (override), ale p\u0159episuje metodu ve t\u0159\xEDd\u011B \u201E{className}\u201C.",
        paramAfterKwargsParam: "Parametr nem\u016F\u017Ee n\xE1sledovat za parametrem \u201E**\u201C",
        paramAlreadyAssigned: "Parametr {name} je u\u017E p\u0159i\u0159azen\xFD",
        paramAnnotationMissing: "Chyb\xED pozn\xE1mka typu pro parametr \u201E{name}\u201C",
        paramAssignmentMismatch: "V\xFDraz typu \u201E{sourceType}\u201C nelze p\u0159i\u0159adit k parametru typu \u201E{paramType}\u201C",
        paramNameMissing: "\u017D\xE1dn\xFD parametr s n\xE1zvem {name}",
        paramSpecArgsKwargsDuplicate: "Argumenty pro ParamSpec {type} ji\u017E byly zad\xE1ny.",
        paramSpecArgsKwargsUsage: "Atributy args a kwargs ParamSpec se mus\xED vyskytovat v signatu\u0159e funkce.",
        paramSpecArgsMissing: "Chyb\xED argumenty pro parametr ParamSpec {type}",
        paramSpecArgsUsage: "Atribut args ParamSpec je platn\xFD jenom v p\u0159\xEDpad\u011B, \u017Ee se pou\u017E\xEDv\xE1 s parametrem *args.",
        paramSpecAssignedName: "Parametr ParamSpec mus\xED b\xFDt p\u0159i\u0159azen prom\u011Bnn\xE9 s n\xE1zvem {name}",
        paramSpecContext: "ParamSpec se v tomto kontextu nepovoluje",
        paramSpecDefaultNotTuple: "O\u010Dek\xE1valy se t\u0159i te\u010Dky, v\xFDraz \u0159azen\xE9 kolekce \u010Dlen\u016F (tuple) nebo ParamSpec pro v\xFDchoz\xED hodnotu ParamSpec.",
        paramSpecFirstArg: "O\u010Dek\xE1val se n\xE1zev parametru ParamSpec jako prvn\xED argument",
        paramSpecKwargsUsage: "Atribut kwargs ParamSpec je platn\xFD jenom v p\u0159\xEDpad\u011B, \u017Ee se pou\u017E\xEDv\xE1 s parametrem **kwargs.",
        paramSpecNotUsedByOuterScope: "Parametr ParamSpec {name} nem\xE1 v tomto kontextu \u017E\xE1dn\xFD v\xFDznam",
        paramSpecUnknownArg: "Parametr ParamSpec nepodporuje v\xEDce ne\u017E jeden argument",
        paramSpecUnknownMember: "{name} nen\xED zn\xE1m\xFD atribut ParamSpec.",
        paramSpecUnknownParam: "\u201E{name}\u201C je nezn\xE1m\xFD parametr parametru ParamSpec",
        paramTypeCovariant: "Prom\u011Bnnou kovariantn\xED typu nen\xED mo\u017En\xE9 pou\u017E\xEDt v typu parametru",
        paramTypePartiallyUnknown: "Typ parametru {paramName} je \u010D\xE1ste\u010Dn\u011B nezn\xE1m\xFD",
        paramTypeUnknown: "Typ parametru {paramName} je nezn\xE1m\xFD",
        parenthesizedContextManagerIllegal: 'Parentheses within "with" statement requires Python 3.9 or newer',
        patternNeverMatches: "Vzor se nikdy nebude shodovat s typem p\u0159edm\u011Btu {type}",
        positionArgAfterNamedArg: "Pozi\u010Dn\xED argument se nem\u016F\u017Ee objevit za argumenty kl\xED\u010Dov\xE9ho slova",
        positionArgAfterUnpackedDictArg: "Pozi\u010Dn\xED argument se nem\u016F\u017Ee objevit po rozbalen\xED argumentu kl\xED\u010Dov\xE9ho slova.",
        positionOnlyAfterArgs: "Odd\u011Blova\u010D parametr\u016F jen pro pozici nen\xED povolen\xFD za parametrem *.",
        positionOnlyAfterKeywordOnly: "Parametr / se mus\xED zobrazit p\u0159ed parametrem *",
        positionOnlyAfterNon: "Parametr jen pro pozici nen\xED povolen\xFD za parametrem, kter\xFD nen\xED jen pro pozici.",
        positionOnlyFirstParam: "Odd\u011Blova\u010D parametr\u016F jen pro pozici nen\xED povolen\xFD jako prvn\xED parametr.",
        positionOnlyIncompatible: "Odd\u011Blova\u010D parametr\u016F jen pro pozici vy\u017Eaduje Python 3.8 nebo nov\u011Bj\u0161\xED.",
        privateImportFromPyTypedModule: "{name} se neexportuje z modulu {module}",
        privateUsedOutsideOfClass: "{name} je priv\xE1tn\xED a pou\u017E\xEDv\xE1 se mimo t\u0159\xEDdu, ve kter\xE9 je deklarovan\xE1",
        privateUsedOutsideOfModule: "{name} je priv\xE1tn\xED a pou\u017E\xEDv\xE1 se mimo modul, ve kter\xE9m je deklarov\xE1n",
        propertyOverridden: "\u201E{name}\u201C nespr\xE1vn\u011B p\u0159ep\xED\u0161e vlastnost (property) se stejn\xFDm n\xE1zvem ve t\u0159\xEDd\u011B \u201E{className}\u201C.",
        propertyStaticMethod: "Statick\xE9 metody nejsou povoleny pro metodu getter, setter nebo deleter vlastnosti (property).",
        protectedUsedOutsideOfClass: "\u201E{name}\u201C je chr\xE1n\u011Bn(\xFD/o/\xE9) a pou\u017E\xEDv\xE1 se mimo t\u0159\xEDdu, ve kter\xE9 je deklarovan\xE1",
        protocolBaseClass: "T\u0159\xEDda Protocol {classType} se nem\u016F\u017Ee odvozovat od t\u0159\xEDdy, kter\xE1 nen\xED t\u0159\xEDdou Protocol {baseType}.",
        protocolBaseClassWithTypeArgs: "Argumenty typu nejsou u t\u0159\xEDdy Protocol povoleny p\u0159i pou\u017Eit\xED syntaxe parametru typu",
        protocolIllegal: "Pou\u017Eit\xED t\u0159\xEDdy Protocol vy\u017Eaduje Python 3.7 nebo nov\u011Bj\u0161\xED.",
        protocolNotAllowed: "\u201EProtocol\u201C nejde v tomto kontextu pou\u017E\xEDt.",
        protocolTypeArgMustBeTypeParam: "Argument typu pro \u201EProtocol\u201C mus\xED b\xFDt parametr typu.",
        protocolUnsafeOverlap: "T\u0159\xEDda se nebezpe\u010Dn\u011B p\u0159ekr\xFDv\xE1 s n\xE1zvem \u201E{name}\u201C a m\u016F\u017Ee vytvo\u0159it shodu p\u0159i spu\u0161t\u011Bn\xED.",
        protocolVarianceContravariant: "Prom\u011Bnn\xE1 typu {variable} pou\u017Eit\xE1 v obecn\xE9 t\u0159\xEDd\u011B Protocol {class} by m\u011Bla b\xFDt kontravariantn\xED.",
        protocolVarianceCovariant: "Prom\u011Bnn\xE1 typu {variable} pou\u017Eit\xE1 v obecn\xE9 t\u0159\xEDd\u011B Protocol {class} by m\u011Bla b\xFDt kovariantn\xED.",
        protocolVarianceInvariant: "Prom\u011Bnn\xE1 typu {variable} pou\u017Eit\xE1 v obecn\xE9 t\u0159\xEDd\u011B Protocol {class} by m\u011Bla b\xFDt invariantn\xED.",
        pyrightCommentInvalidDiagnosticBoolValue: "Za direktivou koment\xE1\u0159\u016F Pyright mus\xED n\xE1sledovat znak =a hodnota true nebo false",
        pyrightCommentInvalidDiagnosticSeverityValue: "Za direktivou koment\xE1\u0159\u016F Pyright mus\xED n\xE1sledovat = a hodnota true, false, error, warning, information nebo none",
        pyrightCommentMissingDirective: "Za koment\xE1\u0159em Pyright mus\xED n\xE1sledovat direktiva (basic nebo strict) nebo diagnostick\xE9 pravidlo.",
        pyrightCommentNotOnOwnLine: "Koment\xE1\u0159e Pyright pou\u017E\xEDvan\xE9 k \u0159\xEDzen\xED nastaven\xED na \xFArovni soubor\u016F se mus\xED zobrazovat na vlastn\xEDm \u0159\xE1dku",
        pyrightCommentUnknownDiagnosticRule: "{rule} je nezn\xE1m\xE9 diagnostick\xE9 pravidlo pro koment\xE1\u0159 pyright",
        pyrightCommentUnknownDiagnosticSeverityValue: "{value} je neplatn\xE1 hodnota pro koment\xE1\u0159 pyright; o\u010Dek\xE1valo se true, false, error, warning, information nebo none",
        pyrightCommentUnknownDirective: '"{directive}" is an unknown directive for pyright comment; expected "strict", "standard", or "basic"',
        readOnlyArgCount: "Za \u201EReadOnly\u201C se o\u010Dek\xE1val jeden argument typu",
        readOnlyNotInTypedDict: "ReadOnly nen\xED v tomto kontextu povolen\xE9",
        recursiveDefinition: "Typ \u201E{name}\u201C nelze ur\u010Dit, proto\u017Ee odkazuje s\xE1m na sebe",
        relativeImportNotAllowed: "Relativn\xED importy se nedaj\xED pou\u017E\xEDt s formul\xE1\u0159em \u201Eimport .a\u201C; m\xEDsto toho pou\u017Eijte \u201Efrom . import a\u201C.",
        requiredArgCount: "Za povinn\xFDm argumentem (Required) se o\u010Dek\xE1val jeden argument typu.",
        requiredNotInTypedDict: "Required nen\xED v tomto kontextu povoleno",
        returnInAsyncGenerator: "P\u0159\xEDkaz Return s hodnotou nen\xED v asynchronn\xEDm gener\xE1toru povolen\xFD",
        returnInExceptionGroup: "V bloku except* nen\xED povolen\xE1 mo\u017Enost return.",
        returnMissing: "Funkce s deklarovan\xFDm n\xE1vratov\xFDm typem \u201E{returnType}\u201C mus\xED vracet hodnotu na v\u0161ech cest\xE1ch k\xF3du",
        returnOutsideFunction: "\u201Ereturn\u201C se d\xE1 pou\u017E\xEDt jenom v r\xE1mci funkce",
        returnTypeContravariant: "Kontravariantn\xED prom\u011Bnnou typu nejde pou\u017E\xEDt v n\xE1vratov\xE9m typu",
        returnTypeMismatch: "Typ {exprType} se ned\xE1 p\u0159i\u0159adit k n\xE1vratov\xE9mu typu {returnType}.",
        returnTypePartiallyUnknown: "N\xE1vratov\xFD typ {returnType} je \u010D\xE1ste\u010Dn\u011B nezn\xE1m\xFD",
        returnTypeUnknown: "N\xE1vratov\xFD typ je nezn\xE1m\xFD",
        revealLocalsArgs: "Pro vol\xE1n\xED reveal_locals se neo\u010Dek\xE1valy \u017E\xE1dn\xE9 argumenty",
        revealLocalsNone: "V tomto oboru nejsou \u017E\xE1dn\xE9 m\xEDstn\xED hodnoty (locals).",
        revealTypeArgs: "Pro vol\xE1n\xED reveal_type byl o\u010Dek\xE1v\xE1n jeden pozi\u010Dn\xED argument",
        revealTypeExpectedTextArg: "Argument \u201Eexpected_text\u201C pro funkci \u201Ereveal_type\u201C mus\xED b\xFDt hodnota liter\xE1lu str",
        revealTypeExpectedTextMismatch: "Neshoda typu textu; o\u010Dek\xE1van\xFD po\u010Det: {expected}, po\u010Det, kter\xFD byl p\u0159ijat: {received}",
        revealTypeExpectedTypeMismatch: "Neshoda typ\u016F; O\u010Dek\xE1val(o/y) se \u201E{expected}\u201C, ale p\u0159ijal(o/y) se \u201E{received}\u201C",
        selfTypeContext: "Self nen\xED v tomto kontextu platn\xE9",
        selfTypeMetaclass: "\u201ESelf\u201C nelze pou\u017E\xEDt v r\xE1mci metat\u0159\xEDdy (podt\u0159\xEDdy \u201Etype\u201C).",
        selfTypeWithTypedSelfOrCls: "Self nen\xED mo\u017En\xE9 pou\u017E\xEDt ve funkci s parametrem self nebo cls, kter\xE1 m\xE1 jinou pozn\xE1mku typu ne\u017E Self",
        sentinelBadName: "The first argument to Sentinel must be a string literal",
        sentinelNameMismatch: "Sentinel must be assigned to a variable with the same name",
        sentinelParamCount: "Sentinel requires one positional argument",
        setterGetterTypeMismatch: "Typ hodnoty metody setter vlastnosti (property) nen\xED mo\u017En\xE9 p\u0159i\u0159adit n\xE1vratov\xE9mu typu getter.",
        singleOverload: "{name} je ozna\u010Den\xE9 jako p\u0159et\xED\u017Een\xED, ale chyb\xED dal\u0161\xED p\u0159et\xED\u017Een\xED",
        slotsAttributeError: "\u201E{name}\u201C nen\xED zadan\xFD v __slots__",
        slotsClassVarConflict: "{name} je v konfliktu s prom\u011Bnnou instance deklarovanou v __slots__",
        starPatternInAsPattern: "Vzor hv\u011Bzdy se ned\xE1 pou\u017E\xEDt s c\xEDlem as",
        starPatternInOrPattern: "Vzor hv\u011Bzdy nem\u016F\u017Ee b\xFDt ORed v jin\xFDch vzorech",
        starStarWildcardNotAllowed: "** nen\xED mo\u017En\xE9 pou\u017E\xEDt se z\xE1stupn\xFDm znakem _",
        staticClsSelfParam: "Statick\xE9 metody by nem\u011Bly p\u0159ij\xEDmat parametr self nebo cls",
        stringNonAsciiBytes: "Znak jin\xFD ne\u017E ASCII nen\xED povolen\xFD v bajtech \u0159et\u011Bzcov\xE9ho liter\xE1lu",
        stringNotSubscriptable: "\u0158et\u011Bzcov\xFD v\xFDraz nen\xED mo\u017En\xE9 ve v\xFDrazu typu zadat jako doln\xED index. Uzav\u0159ete cel\xFD v\xFDraz do uvozovek.",
        stringUnsupportedEscape: "Nepodporovan\xE1 \u0159\xEDdic\xED sekvence v \u0159et\u011Bzcov\xE9m liter\xE1lu",
        stringUnterminated: "\u0158et\u011Bzcov\xFD liter\xE1l je neukon\u010Den\xFD",
        stubFileMissing: "Soubor z\xE1stupn\xE9 procedury (stub) pro \u201E{importName}\u201C se nena\u0161el.",
        stubUsesGetAttr: "Soubor z\xE1stupn\xE9 procedury (stub) typu je ne\xFApln\xFD; __getattr__ zakr\xFDv\xE1 typov\xE9 chyby pro modul.",
        sublistParamsIncompatible: "Parametry sublist nejsou v Pythonu 3.x podporovan\xE9.",
        superCallArgCount: "Pro vol\xE1n\xED \u201Esuper\u201C se o\u010Dek\xE1valy maxim\xE1ln\u011B dva argumenty",
        superCallFirstArg: "Jako prvn\xED argument pro vol\xE1n\xED super se o\u010Dek\xE1val typ t\u0159\xEDdy, ale p\u0159ijal se {type}",
        superCallSecondArg: "Druh\xFD argument vol\xE1n\xED super mus\xED b\xFDt objekt nebo t\u0159\xEDda odvozen\xE1 z typu {type}",
        superCallZeroArgForm: "Forma nulov\xE9ho argumentu \u201Esuper\u201C vol\xE1n\xED je platn\xE1 pouze v r\xE1mci metody.",
        superCallZeroArgFormStaticMethod: "Forma nulov\xE9ho argumentu \u201Esuper\u201C vol\xE1n\xED nen\xED platn\xE1 v r\xE1mci statick\xE9 metody.",
        symbolIsPossiblyUnbound: "{name} je pravd\u011Bpodobn\u011B nev\xE1zan\xE9",
        symbolIsUnbound: "N\xE1zev {name} je nev\xE1zan\xFD",
        symbolIsUndefined: "{name} nen\xED definovan\xE9",
        symbolOverridden: "{name} p\u0159ep\xED\u0161e symbol stejn\xE9ho n\xE1zvu ve t\u0159\xEDd\u011B {className}",
        templateStringBytes: "Template string literals (t-strings) cannot be binary",
        templateStringIllegal: "Template string literals (t-strings) require Python 3.14 or newer",
        templateStringUnicode: "Template string literals (t-strings) cannot be unicode",
        ternaryNotAllowed: "V\xFDraz ternary nen\xED ve v\xFDrazu typu povolen\xFD.",
        totalOrderingMissingMethod: "T\u0159\xEDda mus\xED definovat jednu z __lt__, __le__, __gt__ nebo __ge__, aby bylo mo\u017En\xE9 pou\u017E\xEDvat total_ordering",
        trailingCommaInFromImport: "Koncov\xE1 \u010D\xE1rka nen\xED povolena bez okoln\xEDch z\xE1vorek",
        tryWithoutExcept: "P\u0159\xEDkaz Try mus\xED m\xEDt alespo\u0148 jednu klauzuli except nebo finally",
        tupleAssignmentMismatch: "V\xFDraz s typem \u201E{type}\u201C se ned\xE1 p\u0159i\u0159adit c\xEDlov\xE9 \u0159azen\xE9 kolekci \u010Dlen\u016F (tuple).",
        tupleInAnnotation: "V\xFDraz \u0159azen\xE9 kolekce \u010Dlen\u016F (tuple) nen\xED ve v\xFDrazu typu povolen\xFD.",
        tupleIndexOutOfRange: "Index {index} je pro typ {type} mimo rozsah",
        typeAliasIllegalExpressionForm: "Neplatn\xFD formul\xE1\u0159 v\xFDrazu pro definici aliasu typu",
        typeAliasIsRecursiveDirect: "Alias typu \u201E{name}\u201C nem\u016F\u017Ee ve sv\xE9 definici pou\u017E\xEDvat s\xE1m sebe",
        typeAliasNotInModuleOrClass: "Typ TypeAlias je mo\u017En\xE9 definovat pouze v r\xE1mci oboru modulu nebo t\u0159\xEDdy",
        typeAliasRedeclared: "\u201E{name}\u201C se deklaruje jako TypeAlias a d\xE1 se p\u0159i\u0159adit jenom jednou.",
        typeAliasStatementBadScope: "P\u0159\xEDkaz type se d\xE1 pou\u017E\xEDt jenom v r\xE1mci oboru modulu nebo t\u0159\xEDdy.",
        typeAliasStatementIllegal: "P\u0159\xEDkaz alias typu vy\u017Eaduje Python 3.12 nebo nov\u011Bj\u0161\xED",
        typeAliasTypeBadScope: "Alias typu se d\xE1 definovat jenom v r\xE1mci oboru modulu nebo t\u0159\xEDdy",
        typeAliasTypeBaseClass: 'Alias typu definovan\xFD v p\u0159\xEDkazu "type" nejde pou\u017E\xEDt jako z\xE1kladn\xED t\u0159\xEDdu.',
        typeAliasTypeMustBeAssigned: "Typ TypeAliasType mus\xED b\xFDt p\u0159i\u0159azen prom\u011Bnn\xE9 se stejn\xFDm n\xE1zvem jako alias typu",
        typeAliasTypeNameArg: "Prvn\xED argument TypeAliasType mus\xED b\xFDt \u0159et\u011Bzcov\xFD liter\xE1l p\u0159edstavuj\xEDc\xED n\xE1zev aliasu typu.",
        typeAliasTypeNameMismatch: "N\xE1zev aliasu typu se mus\xED shodovat s n\xE1zvem prom\u011Bnn\xE9, ke kter\xE9 je p\u0159i\u0159azen\xE1",
        typeAliasTypeParamInvalid: "Seznam parametr\u016F typu mus\xED b\xFDt \u0159azen\xE1 kolekce \u010Dlen\u016F (tuple) obsahuj\xEDc\xED pouze TypeVar, TypeVarTuple nebo ParamSpec.",
        typeAnnotationCall: "V\xFDraz vol\xE1n\xED nen\xED ve v\xFDrazu typu povolen\xFD",
        typeAnnotationVariable: "Prom\u011Bnn\xE1 nen\xED ve v\xFDrazu typu povolen\xE1",
        typeAnnotationWithCallable: "Argument typu pro \u201Etype\u201C mus\xED b\xFDt t\u0159\xEDda; volateln\xE9 objekty se nepodporuj\xED.",
        typeArgListExpected: "O\u010Dek\xE1val se parametr ParamSpec, t\u0159i te\u010Dky nebo seznam (list) typ\u016F.",
        typeArgListNotAllowed: "V\xFDraz seznamu (list) nen\xED pro tento argument typu povolen\xFD.",
        typeArgsExpectingNone: "Pro t\u0159\xEDdu {name} se neo\u010Dek\xE1valy \u017E\xE1dn\xE9 argumenty typu",
        typeArgsMismatchOne: "O\u010Dek\xE1val se jeden argument typu, ale bylo p\u0159ijato {received}",
        typeArgsMissingForAlias: "Pro alias obecn\xE9ho typu {name} se o\u010Dek\xE1valy argumenty typu",
        typeArgsMissingForClass: "O\u010Dek\xE1van\xE9 argumenty typu pro obecnou t\u0159\xEDdu \u201E{name}\u201C",
        typeArgsTooFew: "Pro {name} se zadalo p\u0159\xEDli\u0161 m\xE1lo argument\u016F typu. O\u010Dek\xE1valo se {expected}, ale p\u0159ijalo se {received}",
        typeArgsTooMany: "Pro \u201E{name}\u201C se zadalo p\u0159\xEDli\u0161 mnoho argument\u016F typu. O\u010Dek\xE1val(o/y) se {expected}, ale p\u0159ijal(o/y) se {received}",
        typeAssignmentMismatch: "Typ {sourceType} se ned\xE1 p\u0159i\u0159adit k deklarovan\xE9mu typu {destType}.",
        typeAssignmentMismatchWildcard: "Symbol importu {name} m\xE1 typ {sourceType}, kter\xFD se ned\xE1 p\u0159i\u0159adit k deklarovan\xE9mu typu {destType}.",
        typeCallNotAllowed: "Vol\xE1n\xED type() by se nem\u011Blo pou\u017E\xEDvat ve v\xFDrazu typu.",
        typeCheckOnly: "N\xE1zev {name} je ozna\u010Den\xFD jako @type_check_only a d\xE1 se pou\u017E\xEDt jenom v pozn\xE1mk\xE1ch typu",
        typeCommentDeprecated: "Pou\u017Eit\xED koment\xE1\u0159\u016F type je zastaral\xE9 m\xEDsto toho pou\u017E\xEDt anotaci type.",
        typeExpectedClass: "O\u010Dek\xE1vala se t\u0159\xEDda, ale byl p\u0159ijat typ {type}.",
        typeFormArgs: "TypeForm p\u0159ij\xEDm\xE1 jeden pozi\u010Dn\xED argument.",
        typeGuardArgCount: "Za TypeGuard nebo TypeIs byl o\u010Dek\xE1v\xE1n jeden argument typu.",
        typeGuardParamCount: "Funkce a metody ochrany typ\u016F definovan\xE9 u\u017Eivatelem mus\xED m\xEDt alespo\u0148 jeden vstupn\xED parametr",
        typeIsReturnType: "N\xE1vratov\xFD typ TypeIs ({returnType}) nen\xED konzistentn\xED s typem parametru hodnoty ({type}).",
        typeNotAwaitable: "\u201E{type}\u201C nen\xED awaitable.",
        typeNotIntantiable: "Nen\xED mo\u017En\xE9 vytvo\u0159it instanci {type}",
        typeNotIterable: "{type} nen\xED mo\u017En\xE9 iterovat",
        typeNotSpecializable: "Nepovedlo se specializovat typ \u201E{type}\u201C",
        typeNotSubscriptable: "Objekt typu {type} nen\xED mo\u017En\xE9 zadat jako doln\xED index",
        typeNotSupportBinaryOperator: "Oper\xE1tor \u201E{operator}\u201C se pro typy \u201E{leftType}\u201C a \u201E{rightType}\u201C nepodporuje",
        typeNotSupportBinaryOperatorBidirectional: "Oper\xE1tor {operator} nen\xED podporov\xE1n pro typy \u201E{leftType}\u201C a \u201E{rightType}\u201C, pokud se o\u010Dek\xE1v\xE1 typ \u201E{expectedType}\u201C",
        typeNotSupportUnaryOperator: "Oper\xE1tor {operator} se pro typ {type} nepodporuje",
        typeNotSupportUnaryOperatorBidirectional: "Oper\xE1tor {operator} nen\xED podporov\xE1n pro typ {type}, kdy\u017E o\u010Dek\xE1van\xFD typ je {expectedType}",
        typeNotUsableWith: "Objekt typu {type} nen\xED mo\u017En\xE9 pou\u017E\xEDt s typem with, proto\u017Ee neimplementuje spr\xE1vn\u011B metodu {method}.",
        typeNotUsableWithAsync: "Objekt typu {type} nen\xED mo\u017En\xE9 pou\u017E\xEDt s typem async with, proto\u017Ee neimplementuje spr\xE1vn\u011B metodu {method}.",
        typeParameterBoundNotAllowed: "Vazbu nebo omezen\xED nelze pou\u017E\xEDt s parametrem variadick\xE9ho typu ani s parametrem ParamSpec",
        typeParameterConstraintTuple: "Omezen\xED parametru typu mus\xED b\xFDt \u0159azen\xE1 kolekce \u010Dlen\u016F dvou nebo v\xEDce typ\u016F",
        typeParameterExistingTypeParameter: "Parametr typu {name} se u\u017E pou\u017E\xEDv\xE1",
        typeParameterNotDeclared: "Parametr typu {name} nen\xED zahrnut\xFD v seznamu parametr\u016F typu pro kontejner {container}",
        typeParametersMissing: "Mus\xED b\xFDt zad\xE1n alespo\u0148 jeden parametr typu",
        typePartiallyUnknown: "Typ {name} je \u010D\xE1ste\u010Dn\u011B nezn\xE1m\xFD",
        typeUnknown: "Typ {name} je nezn\xE1m\xFD",
        typeVarAssignedName: "Typ TypeVar mus\xED b\xFDt p\u0159i\u0159azen prom\u011Bnn\xE9 s n\xE1zvem {name}",
        typeVarAssignmentMismatch: "Typ \u201E{type}\u201C se ned\xE1 p\u0159i\u0159adit prom\u011Bnn\xE9 typu \u201E{name}\u201C",
        typeVarBoundAndConstrained: "TypeVar nem\u016F\u017Ee b\xFDt sou\u010Dasn\u011B v\xE1zan\xFD i omezen\xFD",
        typeVarBoundGeneric: "V\xE1zan\xFD typ TypeVar nem\u016F\u017Ee b\xFDt obecn\xFD",
        typeVarConstraintGeneric: "Typ omezen\xED TypeVar nem\u016F\u017Ee b\xFDt obecn\xFD",
        typeVarDefaultBoundMismatch: "V\xFDchoz\xED typ TypeVar mus\xED b\xFDt podtyp v\xE1zan\xE9ho typu",
        typeVarDefaultConstraintMismatch: "V\xFDchoz\xED typ TypeVar mus\xED b\xFDt jeden z omezen\xFDch typ\u016F",
        typeVarDefaultIllegal: "V\xFDchoz\xED typy prom\u011Bnn\xFDch typ\u016F vy\u017Eaduj\xED Python 3.13 nebo nov\u011Bj\u0161\xED",
        typeVarDefaultInvalidTypeVar: "Parametr typu {name} m\xE1 v\xFDchoz\xED typ, kter\xFD odkazuje na jednu nebo v\xEDce prom\u011Bnn\xFDch typu, kter\xE9 jsou mimo obor",
        typeVarFirstArg: "O\u010Dek\xE1val se n\xE1zev TypeVar jako prvn\xED argument",
        typeVarInvalidForMemberVariable: "Typ atributu nem\u016F\u017Ee pou\u017E\xEDvat prom\u011Bnnou typu {name} vymezenou na m\xEDstn\xED metodu.",
        typeVarNoMember: "TypeVar {type} nem\xE1 \u017E\xE1dn\xFD atribut {name}.",
        typeVarNotSubscriptable: "TypeVar {type} nen\xED mo\u017En\xE9 zadat jako doln\xED index",
        typeVarNotUsedByOuterScope: "Prom\u011Bnn\xE1 typu {name} nem\xE1 v tomto kontextu \u017E\xE1dn\xFD v\xFDznam",
        typeVarPossiblyUnsolvable: "Prom\u011Bnn\xE1 typu \u201E{name}\u201C m\u016F\u017Ee b\xFDt nevy\u0159e\u0161en\xE1, pokud volaj\xEDc\xED nezad\xE1 \u017E\xE1dn\xFD argument pro parametr \u201E{param}\u201C",
        typeVarSingleConstraint: "TypeVar mus\xED m\xEDt alespo\u0148 dva omezen\xE9 typy",
        typeVarTupleConstraints: "TypeVarTuple nem\u016F\u017Ee m\xEDt omezen\xED hodnoty",
        typeVarTupleContext: "TypeVarTuple se v tomto kontextu nepovoluje",
        typeVarTupleDefaultNotUnpacked: "V\xFDchoz\xED typ TypeVarTuple mus\xED b\xFDt rozbalen\xE1 \u0159azen\xE1 kolekce \u010Dlen\u016F (tuple) nebo TypeVarTuple.",
        typeVarTupleMustBeUnpacked: "Pro hodnotu TypeVarTuple se vy\u017Eaduje oper\xE1tor rozbalen\xED",
        typeVarTupleUnknownParam: "{name} je nezn\xE1m\xFD parametr pro TypeVarTuple",
        typeVarUnknownParam: "\u201E{name}\u201C je nezn\xE1m\xFD parametr pro TypeVar",
        typeVarUsedByOuterScope: "TypeVar \u201E{name}\u201C se u\u017E pou\u017E\xEDv\xE1 ve vn\u011Bj\u0161\xEDm oboru",
        typeVarUsedOnlyOnce: "TypeVar {name} se v signatu\u0159e obecn\xE9 funkce zobrazuje jenom jednou",
        typeVarVariance: "TypeVar nem\u016F\u017Ee b\xFDt kovariantn\xED i kontravariantn\xED",
        typeVarWithDefaultFollowsVariadic: "TypeVar {typeVarName} m\xE1 v\xFDchoz\xED hodnotu a nem\u016F\u017Ee n\xE1sledovat po TypeVarTuple {variadicName}.",
        typeVarWithoutDefault: "\u201E{name}\u201C se v seznamu parametr\u016F typu nem\u016F\u017Ee zobrazit za \u201E{other}\u201C , proto\u017Ee nem\xE1 \u017E\xE1dn\xFD v\xFDchoz\xED typ",
        typeVarsNotInGenericOrProtocol: "Generic[] nebo Protocol[] mus\xED obsahovat v\u0161echny prom\u011Bnn\xE9 typu",
        typedDictAccess: "Nepovedlo se z\xEDskat p\u0159\xEDstup k polo\u017Ece v TypedDict",
        typedDictAssignedName: "TypedDict se mus\xED p\u0159i\u0159adit prom\u011Bnn\xE9 s n\xE1zvem \u201E{name}\u201C.",
        typedDictBadVar: "T\u0159\xEDdy TypedDict m\u016F\u017Eou obsahovat jenom pozn\xE1mky typu",
        typedDictBaseClass: "V\u0161echny z\xE1kladn\xED t\u0159\xEDdy pro t\u0159\xEDdy TypedDict mus\xED b\xFDt tak\xE9 t\u0159\xEDdami TypedDict",
        typedDictBoolParam: "O\u010Dek\xE1valo se, \u017Ee parametr {name} bude m\xEDt hodnotu True nebo False",
        typedDictClosedExtras: 'Z\xE1kladn\xED "{name}" t\u0159\xEDdy je TypedDict, kter\xFD omezuje typ dal\u0161\xEDch polo\u017Eek na typ "{type}"',
        typedDictClosedFalseNonOpenBase: 'Base class "{name}" is not an open TypedDict; closed=False is not allowed',
        typedDictClosedNoExtras: "Z\xE1kladn\xED t\u0159\xEDda {name} je closed TypedDict; polo\u017Eky nav\xEDc nejsou povolen\xE9.",
        typedDictDelete: "Nepovedlo se odstranit polo\u017Eku v TypedDict",
        typedDictEmptyName: "N\xE1zvy v r\xE1mci TypedDict nem\u016F\u017Eou b\xFDt pr\xE1zdn\xE9",
        typedDictEntryName: "O\u010Dek\xE1val se \u0159et\u011Bzcov\xFD liter\xE1l pro n\xE1zev polo\u017Eky slovn\xEDku",
        typedDictEntryUnique: "N\xE1zvy ve slovn\xEDku mus\xED b\xFDt jedine\u010Dn\xE9",
        typedDictExtraArgs: "Nadbyte\u010Dn\xE9 argumenty TypedDict nejsou podporov\xE1ny",
        typedDictExtraItemsClosed: 'TypedDict m\u016F\u017Ee pou\u017E\xEDvat bu\u010F "closed", nebo "extra_items", ale ne oboj\xED.',
        typedDictFieldNotRequiredRedefinition: "Polo\u017Eka TypedDict {name} nejde p\u0159edefinovat jako NotRequired.",
        typedDictFieldReadOnlyRedefinition: "Polo\u017Eka TypedDict {name} nejde p\u0159edefinovat jako ReadOnly.",
        typedDictFieldRequiredRedefinition: "Polo\u017Eka TypedDict {name} nejde p\u0159edefinovat jako Required.",
        typedDictFirstArg: "Jako prvn\xED argument byl o\u010Dek\xE1v\xE1n n\xE1zev t\u0159\xEDdy TypedDict",
        typedDictInClassPattern: "T\u0159\xEDda TypedDict nen\xED ve vzoru t\u0159\xEDdy povolena.",
        typedDictInitsubclassParameter: "TypedDict nepodporuje parametr __init_subclass__ \u201E{name}\u201C.",
        typedDictNotAllowed: "\u201ETypedDict\u201C se v tomto kontextu ned\xE1 pou\u017E\xEDt.",
        typedDictSecondArgDict: "Jako druh\xFD parametr se o\u010Dek\xE1val parametr dict nebo keyword.",
        typedDictSecondArgDictEntry: "O\u010Dek\xE1van\xE1 jednoduch\xE1 polo\u017Eka slovn\xEDku",
        typedDictSet: "Nelze p\u0159i\u0159adit polo\u017Eku v TypedDict",
        unaccessedClass: "T\u0159\xEDda \u201E{name}\u201C nen\xED zp\u0159\xEDstupn\u011Bna",
        unaccessedFunction: "Funkce {name} nen\xED zp\u0159\xEDstupn\u011Bn",
        unaccessedImport: "Import {name} nen\xED zp\u0159\xEDstupn\u011Bn",
        unaccessedSymbol: "{name} nen\xED zp\u0159\xEDstupn\u011Bn",
        unaccessedVariable: "Prom\u011Bnn\xE1 {name} nen\xED zp\u0159\xEDstupn\u011Bn\xE1",
        unannotatedFunctionSkipped: "Anal\xFDza funkce \u201E{name}\u201C se p\u0159esko\u010Dila, proto\u017Ee nen\xED ozna\u010Den\xE1",
        unaryOperationNotAllowed: "Ve v\xFDrazu typu nen\xED povolen\xFD un\xE1rn\xED oper\xE1tor.",
        unexpectedAsyncToken: "O\u010Dek\xE1valo se, \u017Ee za async bude n\xE1sledovat def, with nebo for",
        unexpectedEof: "Unexpected EOF",
        unexpectedExprToken: "Neo\u010Dek\xE1van\xFD token na konci v\xFDrazu",
        unexpectedIndent: "Neo\u010Dek\xE1van\xE9 odsazen\xED",
        unexpectedUnindent: "Neo\u010Dek\xE1v\xE1 se unindent",
        unhashableDictKey: "Kl\xED\u010D slovn\xEDku mus\xED b\xFDt hashovateln\xFD",
        unhashableSetEntry: "Polo\u017Eka set mus\xED b\xFDt hashovateln\xE1.",
        uninitializedAbstractVariables: "Prom\u011Bnn\xE9 definovan\xE9 v abstraktn\xED z\xE1kladn\xED t\u0159\xEDd\u011B nejsou inicializov\xE1ny ve t\u0159\xEDd\u011B final {classType}.",
        uninitializedInstanceVariable: "Prom\u011Bnn\xE1 instance {name} nen\xED inicializov\xE1na v t\u011Ble t\u0159\xEDdy nebo v metod\u011B __init__",
        unionForwardReferenceNotAllowed: "Syntaxi Union nen\xED mo\u017En\xE9 pou\u017E\xEDt s operandem \u0159et\u011Bzce; pou\u017Eijte uvozovky kolem cel\xE9ho v\xFDrazu.",
        unionSyntaxIllegal: "Alternativn\xED syntaxe pro sjednocen\xED vy\u017Eaduje Python 3.10 nebo nov\u011Bj\u0161\xED",
        unionTypeArgCount: "Union vy\u017Eaduje dva nebo v\xEDce argument\u016F typu.",
        unionUnpackedTuple: "Union nem\u016F\u017Ee obsahovat rozbalenou \u0159azenou kolekci \u010Dlen\u016F (tuple).",
        unionUnpackedTypeVarTuple: "Union nem\u016F\u017Ee obsahovat rozbalen\xFD typ TypeVarTuple.",
        unnecessaryCast: "Nepot\u0159ebn\xE9 vol\xE1n\xED \u201Ecast\u201C; typ u\u017E je \u201E{type}\u201C.",
        unnecessaryIsInstanceAlways: "Zbyte\u010Dn\xE9 vol\xE1n\xED isinstance; {testType} je v\u017Edy instanc\xED t\u0159\xEDdy {classType}",
        unnecessaryIsInstanceNever: "Zbyte\u010Dn\xE9 vol\xE1n\xED isinstance; {testType} nen\xED nikdy instanc\xED t\u0159\xEDdy {classType}",
        unnecessaryIsSubclassAlways: "Nepot\u0159ebn\xE9 vol\xE1n\xED issubclass; \u201E{testType}\u201C je v\u017Edy podt\u0159\xEDdou t\u0159\xEDdy \u201E{classType}\u201C",
        unnecessaryIsSubclassNever: "Zbyte\u010Dn\xE9 vol\xE1n\xED issubclass; {testType} nen\xED nikdy podt\u0159\xEDdou t\u0159\xEDdy {classType}",
        unnecessaryPyrightIgnore: "Nepot\u0159ebn\xFD koment\xE1\u0159 \u201E# pyright: ignore\u201C",
        unnecessaryPyrightIgnoreRule: "Nepot\u0159ebn\xE9 pravidlo # pyright: ignore: {name}",
        unnecessaryTypeIgnore: "Nepot\u0159ebn\xFD koment\xE1\u0159 \u201E# type: ignore\u201C",
        unpackArgCount: "Po rozbalen\xED \u201EUnpack\u201C se o\u010Dek\xE1val jeden argument typu",
        unpackExpectedTypeVarTuple: "Jako argument typu pro Unpack byl o\u010Dek\xE1v\xE1n typ TypeVarTuple nebo tuple.",
        unpackExpectedTypedDict: "Byl o\u010Dek\xE1v\xE1n argument typu TypedDict pro rozbalen\xED Unpack",
        unpackIllegalInComprehension: "Operace rozbalen\xED nen\xED v porozum\u011Bn\xED povolen\xE1",
        unpackInAnnotation: "Ve v\xFDrazu typu nen\xED povolen\xFD oper\xE1tor rozbalen\xED.",
        unpackInDict: "Operace rozbalen\xED nen\xED ve slovn\xEDc\xEDch povolena",
        unpackInSet: "Oper\xE1tor rozbalen\xED nen\xED v sad\u011B (set) povolen\xFD.",
        unpackNotAllowed: "Unpack se v tomto kontextu nepovoluje.",
        unpackOperatorNotAllowed: "Operace rozbalen\xED nen\xED v tomto kontextu povolen\xE1",
        unpackTuplesIllegal: "Operace rozbalen\xED nen\xED povolen\xE1 v \u0159azen\xFDch kolekc\xEDch \u010Dlen\u016F p\u0159ed Pythonem 3.8",
        unpackedArgInTypeArgument: "V tomto kontextu nelze pou\u017E\xEDt rozbalen\xE9 argumenty.",
        unpackedArgWithVariadicParam: "Pro parametr TypeVarTuple nejde pou\u017E\xEDt rozbalen\xFD argument",
        unpackedDictArgumentNotMapping: "V\xFDraz argumentu za ** mus\xED b\xFDt mapov\xE1n\xED s typem kl\xED\u010De str",
        unpackedDictSubscriptIllegal: "Oper\xE1tor rozbalen\xED slovn\xEDku v doln\xEDm indexu nen\xED povolen\xFD",
        unpackedSubscriptIllegal: "Oper\xE1tor rozbalen\xED v doln\xEDm indexu vy\u017Eaduje Python 3.11 nebo nov\u011Bj\u0161\xED",
        unpackedTypeVarTupleExpected: "Byl o\u010Dek\xE1v\xE1n rozbalen\xFD typ TypeVarTuple; pou\u017Eijte Unpack[{name1}] nebo *{name2}",
        unpackedTypedDictArgument: "Nepovedlo se sp\xE1rovat nebalen\xFD argument TypedDict s parametry",
        unreachableCodeCondition: "Code is not analyzed because condition is statically evaluated as false",
        unreachableCodeStructure: "Code is structurally unreachable",
        unreachableCodeType: "Anal\xFDza typ\u016F indikuje, \u017Ee k\xF3d nen\xED dostupn\xFD.",
        unreachableExcept: "Klauzule Except je nedosa\u017Eiteln\xE1, proto\u017Ee v\xFDjimka je ji\u017E zpracov\xE1na",
        unsupportedDunderAllOperation: "Operace s __all__ se nepodporuje, tak\u017Ee exportovan\xFD seznam symbol\u016F nemus\xED b\xFDt spr\xE1vn\xFD",
        unusedCallResult: "V\xFDsledek v\xFDrazu vol\xE1n\xED je typu \u201E{type}\u201C a nepou\u017E\xEDv\xE1 se. p\u0159i\u0159adit prom\u011Bnn\xE9 \u201E_\u201C, pokud je to z\xE1m\u011Brn\xE9",
        unusedCoroutine: "V\xFDsledek vol\xE1n\xED asynchronn\xED funkce se nepou\u017E\xEDv\xE1; pou\u017Eijte oper\xE1tor await nebo p\u0159i\u0159a\u010Fte v\xFDsledek prom\u011Bnn\xE9",
        unusedExpression: "Hodnota v\xFDrazu se nepou\u017E\xEDv\xE1",
        varAnnotationIllegal: "Pozn\xE1mky type pro prom\u011Bnn\xE9 vy\u017Eaduj\xED Python 3.6 nebo nov\u011Bj\u0161\xED; pro kompatibilitu s p\u0159edchoz\xEDmi verzemi pou\u017Eijte koment\xE1\u0159e type.",
        variableFinalOverride: "Prom\u011Bnn\xE1 {name} je ozna\u010Den\xE1 jako Final a p\u0159ep\xED\u0161e prom\u011Bnnou non-Final se stejn\xFDm n\xE1zvem ve t\u0159\xEDd\u011B {className}.",
        variadicTypeArgsTooMany: "Seznam argument\u016F typ\u016F m\u016F\u017Ee m\xEDt maxim\xE1ln\u011B jeden rozbalen\xFD typ TypeVarTuple nebo tuple.",
        variadicTypeParamTooManyAlias: "Alias typu m\u016F\u017Ee m\xEDt maxim\xE1ln\u011B jeden parametr typu TypeVarTuple, ale p\u0159ijal n\u011Bkolik ({names})",
        variadicTypeParamTooManyClass: "Obecn\xE1 t\u0159\xEDda m\u016F\u017Ee m\xEDt maxim\xE1ln\u011B jeden parametr typu TypeVarTuple, ale p\u0159ijala v\xEDce ({names})",
        walrusIllegal: "Oper\xE1tor := vy\u017Eaduje Python 3.8 nebo nov\u011Bj\u0161\xED",
        walrusNotAllowed: "Oper\xE1tor := nen\xED v tomto kontextu povolen bez okoln\xEDch z\xE1vorek",
        wildcardInFunction: "V r\xE1mci t\u0159\xEDdy nebo funkce nen\xED povolen import se z\xE1stupn\xFDmi znaky.",
        wildcardLibraryImport: "Nen\xED povolen\xFD import se z\xE1stupn\xFDmi znaky z knihovny.",
        wildcardPatternTypePartiallyUnknown: "Typ zachycen\xFD vzorem se z\xE1stupn\xFDmi znaky je \u010D\xE1ste\u010Dn\u011B nezn\xE1m\xFD",
        wildcardPatternTypeUnknown: "Typ zachycen\xFD vzorem se z\xE1stupn\xFDmi znaky je nezn\xE1m\xFD",
        yieldFromIllegal: "Pou\u017Eit\xED p\u0159\xEDkazu yield from vy\u017Eaduje Python 3.3 nebo nov\u011Bj\u0161\xED",
        yieldFromOutsideAsync: "yield from nen\xED v asynchronn\xED funkci povoleno",
        yieldOutsideFunction: "\u201Eyield\u201C nen\xED povoleno mimo funkci nebo lambdu",
        yieldWithinComprehension: "\u201Eyield\u201C nen\xED povolen\xE9 uvnit\u0159 porozum\u011Bn\xED",
        zeroCaseStatementsFound: "V\xFDraz shody (match) obsahovat alespo\u0148 jeden v\xFDraz velikosti p\xEDsmen (case).",
        zeroLengthTupleNotAllowed: "\u0158azen\xE1 kolekce \u010Dlen\u016F (tuple) s nulovou d\xE9lkou nen\xED v tomto kontextu povolen\xE1."
      },
      DiagnosticAddendum: {
        annotatedNotAllowed: "Speci\xE1ln\xED formul\xE1\u0159 Annotated nejde pou\u017E\xEDt s kontrolami instanc\xED a t\u0159\xEDd.",
        argParam: "Argument odpov\xEDd\xE1 parametru {paramName}",
        argParamFunction: "Argument odpov\xEDd\xE1 parametru {paramName} ve funkci {functionName}",
        argsParamMissing: "Parametr \u201E*{paramName}\u201C nem\xE1 \u017E\xE1dn\xFD odpov\xEDdaj\xEDc\xED parametr",
        argsPositionOnly: "Neshoda parametr\u016F pouze s pozic\xED; O\u010Dek\xE1val(o/y) se {expected}, ale p\u0159ijal(o/y) se {received}",
        argumentType: "Typ argumentu je {type}",
        argumentTypes: "Typy argument\u016F: ({types})",
        assignToNone: "Typ se ned\xE1 p\u0159i\u0159adit k None.",
        asyncHelp: "M\u011Bli jste na mysli \u201Easync with\u201C?",
        baseClassIncompatible: "Z\xE1kladn\xED t\u0159\xEDda {baseClass} nen\xED kompatibiln\xED s typem {type}",
        baseClassIncompatibleSubclass: "Z\xE1kladn\xED t\u0159\xEDda {baseClass} je odvozen\xE1 od t\u0159\xEDdy {subclass}, kter\xE1 nen\xED kompatibiln\xED s typem {type}",
        baseClassOverriddenType: "Z\xE1kladn\xED t\u0159\xEDda {baseClass} poskytuje typ {type}, kter\xFD je p\u0159eps\xE1n",
        baseClassOverridesType: "Z\xE1kladn\xED t\u0159\xEDda \u201E{baseClass}\u201C p\u0159episuje typ \u201E{type}\u201C",
        bytesTypePromotions: "Pokud chcete povolit chov\xE1n\xED pov\xFD\u0161en\xED typu pro \u201Ebytearray\u201C a \u201Ememoryview\u201C, nastavte disableBytesTypePromotions na false",
        conditionalRequiresBool: "Metoda __bool__ pro typ {operandType} vrac\xED typ {boolReturnType} m\xEDsto bool",
        dataClassFieldLocation: "Deklarace pole",
        dataClassFrozen: "{name} je zablokovan\xE9",
        dataProtocolUnsupported: "\u201E{name}\u201C je datov\xFD protokol.",
        descriptorAccessBindingFailed: "Nepovedlo se vytvo\u0159it vazbu metody {name} pro t\u0159\xEDdu popisova\u010De {className}.",
        descriptorAccessCallFailed: "Nepovedlo se volat metodu {name} pro t\u0159\xEDdu popisova\u010De {className}.",
        finalMethod: "Metoda Final",
        functionParamDefaultMissing: "V parametru \u201E{name}\u201C chyb\xED v\xFDchoz\xED argument",
        functionParamName: "Neshoda n\xE1zvu parametru: {destName} a {srcName}",
        functionParamPositionOnly: "Neshoda parametr\u016F pouze s pozic\xED; Parametr \u201E{name}\u201C nen\xED jen pro pozici.",
        functionReturnTypeMismatch: "N\xE1vratov\xFD typ funkce \u201E{sourceType}\u201C nen\xED kompatibiln\xED s typem \u201E{destType}\u201C",
        functionTooFewParams: "Funkce p\u0159ij\xEDm\xE1 p\u0159\xEDli\u0161 m\xE1lo pozi\u010Dn\xEDch parametr\u016F; o\u010Dek\xE1van\xFD po\u010Det: {expected}, po\u010Det, kter\xFD byl p\u0159ijat: {received}",
        functionTooManyParams: "Funkce p\u0159ij\xEDm\xE1 p\u0159\xEDli\u0161 mnoho pozi\u010Dn\xEDch parametr\u016F; o\u010Dek\xE1van\xFD po\u010Det: {expected}, po\u010Det, kter\xFD byl p\u0159ijat: {received}",
        genericClassNotAllowed: "Obecn\xFD typ s argumenty obecn\xE9ho typu se pro kontroly instanc\xED nebo t\u0159\xEDd nepovoluje.",
        incompatibleDeleter: "Metoda deleter vlastnosti (property) je nekompatibiln\xED.",
        incompatibleGetter: "Metoda getter vlastnosti (property) je nekompatibiln\xED.",
        incompatibleSetter: "Metoda setter vlastnosti (property) je nekompatibiln\xED.",
        initMethodLocation: "Metoda __init__ je definov\xE1na ve t\u0159\xEDd\u011B {type}",
        initMethodSignature: "Podpis __init__ je {type}",
        initSubclassLocation: "Metoda __init_subclass__ je definov\xE1na ve t\u0159\xEDd\u011B {name}.",
        invariantSuggestionDict: "Zva\u017Ete p\u0159epnut\xED z mo\u017Enosti \u201Edict\u201C na mo\u017Enost \u201EMapping\u201C, kter\xE1 je v typu hodnoty kovariantn\xED.",
        invariantSuggestionList: "Zva\u017Ete p\u0159epnut\xED z mo\u017Enosti \u201Elist\u201C na mo\u017Enost \u201ESequence\u201C, kter\xE1 je kovariantn\xED.",
        invariantSuggestionSet: "Zva\u017Ete p\u0159epnut\xED z mo\u017Enosti \u201Eset\u201C na mo\u017Enost \u201EContainer\u201C, kter\xE1 je kovariantn\xED.",
        isinstanceClassNotSupported: "{type} se pro kontroly instanc\xED a t\u0159\xEDd nepodporuje.",
        keyNotRequired: "\u201E{name}! nen\xED v typu \u201E{type}\u201C povinn\xFD kl\xED\u010D, tak\u017Ee p\u0159\xEDstup m\u016F\u017Ee v\xE9st k v\xFDjimce modulu runtime",
        keyReadOnly: "{name} je kl\xED\u010D jen pro \u010Dten\xED v {type}",
        keyRequiredDeleted: "{name} je povinn\xFD kl\xED\u010D a ned\xE1 se odstranit",
        keyUndefined: "{name} nen\xED definovan\xFD kl\xED\u010D v typu {type}",
        kwargsParamMissing: "Parametr \u201E**{paramName}\u201C nem\xE1 \u017E\xE1dn\xFD odpov\xEDdaj\xEDc\xED parametr",
        listAssignmentMismatch: "Typ {type} nen\xED kompatibiln\xED s c\xEDlov\xFDm seznamem",
        literalAssignmentMismatch: "{sourceType} se ned\xE1 p\u0159i\u0159adit k typu {destType}.",
        literalNotAllowed: "Speci\xE1ln\xED formul\xE1\u0159 Literal nejde pou\u017E\xEDt s kontrolami instanc\xED a t\u0159\xEDd.",
        matchIsNotExhaustiveHint: "Pokud nen\xED zam\xFD\u0161leno vy\u010Derp\xE1vaj\xEDc\xED zpracov\xE1n\xED, p\u0159idejte case _: pass",
        matchIsNotExhaustiveType: "Nezpracovan\xFD typ: {type}",
        memberAssignment: "V\xFDraz typu {type} nelze p\u0159i\u0159adit k atributu {name} t\u0159\xEDdy {classType}.",
        memberIsAbstract: "\u201E{type}.{name}\u201C nen\xED implementov\xE1no.",
        memberIsAbstractMore: "a tento po\u010Det dal\u0161\xEDch: {count}...",
        memberIsClassVarInProtocol: "\u201E{name}\u201C je v protokolu definov\xE1n jako ClassVar.",
        memberIsInitVar: "{name} je pole init-only.",
        memberIsInvariant: "{name} je invariantn\xED, proto\u017Ee je prom\u011Bnliv\xE9",
        memberIsNotClassVarInClass: "\u201E{name}\u201C mus\xED b\xFDt definov\xE1no jako ClassVar, aby bylo kompatibiln\xED s protokolem.",
        memberIsNotClassVarInProtocol: "\u201E{name}\u201C nen\xED v protokolu definov\xE1n jako ClassVar.",
        memberIsNotReadOnlyInProtocol: "{name} nen\xED v protokolu jen pro \u010Dten\xED.",
        memberIsReadOnlyInProtocol: "{name} je v protokolu jen pro \u010Dten\xED.",
        memberIsWritableInProtocol: "{name} se d\xE1 zapisovat do protokolu.",
        memberSetClassVar: "Atribut {name} nelze p\u0159i\u0159adit prost\u0159ednictv\xEDm instance t\u0159\xEDdy, proto\u017Ee jde o ClassVar.",
        memberTypeMismatch: "{name} je nekompatibiln\xED typ",
        memberUnknown: "Atribut {name} je nezn\xE1m\xFD.",
        metaclassConflict: "Metat\u0159\xEDda {metaclass1} je v konfliktu s metat\u0159\xEDdou {metaclass2}.",
        missingDeleter: "Chyb\xED metoda deleter vlastnosti (property).",
        missingGetter: "Chyb\xED metoda getter vlastnosti (property).",
        missingSetter: "Chyb\xED metoda setter vlastnosti (property).",
        namedParamMissingInDest: "Dal\u0161\xED parametr \u201E{name}\u201C",
        namedParamMissingInSource: "Chyb\xED parametr kl\xED\u010Dov\xE9ho slova \u201E{name}\u201C.",
        namedParamTypeMismatch: "Parametr kl\xED\u010Dov\xE9ho slova {name} typu {sourceType} nen\xED kompatibiln\xED s typem {destType}.",
        namedTupleNotAllowed: "NamedTuple se ned\xE1 pou\u017E\xEDt pro kontroly instanc\xED nebo t\u0159\xEDd.",
        newMethodLocation: "Metoda __new__ je definov\xE1na ve t\u0159\xEDd\u011B {type}",
        newMethodSignature: "Podpis __new__ je {type}",
        newTypeClassNotAllowed: "Type created with NewType cannot be used with instance and class checks",
        noOverloadAssignable: "Typ {type} neodpov\xEDd\xE1 \u017E\xE1dn\xE9 p\u0159et\xED\u017Een\xE9 funkci",
        noneNotAllowed: "Mo\u017Enost None se ned\xE1 pou\u017E\xEDt pro kontroly instanc\xED nebo t\u0159\xEDd.",
        orPatternMissingName: "Chyb\u011Bj\xEDc\xED n\xE1zvy: {name}",
        overloadIndex: "P\u0159et\xED\u017Een\xED {index} je nejbli\u017E\u0161\xED shoda.",
        overloadNotAssignable: "Nejm\xE9n\u011B jedno p\u0159et\xED\u017Een\xED {name} nen\xED mo\u017En\xE9 p\u0159i\u0159adit",
        overloadSignature: "Tady je definov\xE1n podpis p\u0159et\xED\u017Een\xED",
        overriddenMethod: "P\u0159epsan\xE1 metoda",
        overriddenSymbol: "P\u0159epsan\xFD symbol",
        overrideInvariantMismatch: "Typ p\u0159eps\xE1n\xED \u201E{overrideType}\u201Cnen\xED stejn\xFD jako z\xE1kladn\xED typ \u201E{baseType}\u201C",
        overrideIsInvariant: "Prom\u011Bnn\xE1 je prom\u011Bnliv\xE1, tak\u017Ee jej\xED typ je invariantn\xED",
        overrideNoOverloadMatches: "Signatura p\u0159et\xED\u017Een\xED v p\u0159eps\xE1n\xED nen\xED kompatibiln\xED se z\xE1kladn\xED metodou",
        overrideNotClassMethod: "Z\xE1kladn\xED metoda je deklarov\xE1na jako metoda classmethod, ale p\u0159eps\xE1n\xED nen\xED",
        overrideNotInstanceMethod: "Z\xE1kladn\xED metoda je deklarov\xE1na jako instan\u010Dn\xED metoda, ale p\u0159eps\xE1n\xED nen\xED",
        overrideNotStaticMethod: "Z\xE1kladn\xED metoda je deklarov\xE1na jako staticmethod, ale p\u0159eps\xE1n\xED nen\xED",
        overrideOverloadNoMatch: "P\u0159eps\xE1n\xED nezahrnuje v\u0161echna p\u0159et\xED\u017Een\xED metody z\xE1kladn\xED t\u0159\xEDdy",
        overrideOverloadOrder: "P\u0159et\xED\u017Een\xED p\u0159episovan\xE9 metody mus\xED b\xFDt ve stejn\xE9m po\u0159ad\xED jako z\xE1kladn\xED metoda",
        overrideParamKeywordNoDefault: "Neshoda parametru kl\xED\u010Dov\xE9ho slova \u201E{name}\u201C: z\xE1kladn\xED parametr m\xE1 v\xFDchoz\xED hodnotu argumentu, parametr pro p\u0159eps\xE1n\xED ne",
        overrideParamKeywordType: "Neshoda typu parametru kl\xED\u010Dov\xE9ho slova \u201E{name}\u201C: z\xE1kladn\xED parametr je typu \u201E{baseType}\u201C, parametr p\u0159eps\xE1n\xED je typu \u201E{overrideType}\u201C",
        overrideParamName: "Neshoda n\xE1zvu parametru {index}: z\xE1kladn\xED parametr m\xE1 n\xE1zev \u201E{baseName}\u201C, parametr p\u0159eps\xE1n\xED m\xE1 n\xE1zev \u201E{overrideName}\u201C",
        overrideParamNameExtra: "V z\xE1kladu chyb\xED parametr {name}",
        overrideParamNameMissing: "V p\u0159eps\xE1n\xED chyb\xED parametr \u201E{name}\u201C",
        overrideParamNamePositionOnly: "Neshoda parametru {index}: z\xE1kladn\xED parametr {baseName} je parametr kl\xED\u010Dov\xE9ho slova, p\u0159episuj\xEDc\xED parametr je pouze pozice",
        overrideParamNoDefault: "Neshoda parametru {index}: Z\xE1kladn\xED parametr m\xE1 v\xFDchoz\xED hodnotu argumentu, parametr p\u0159eps\xE1n\xED se neshoduje.",
        overrideParamType: "Neshoda typu parametru {index}: Z\xE1kladn\xED parametr je typu \u201E{baseType}\u201C, parametr p\u0159eps\xE1n\xED je typu \u201E{overrideType}\u201C.",
        overridePositionalParamCount: "Neshoda po\u010Dtu pozi\u010Dn\xEDch parametr\u016F; Z\xE1kladn\xED metoda m\xE1 \u201E{baseCount}\u201C, ale p\u0159eps\xE1n\xED m\xE1 {overrideCount}",
        overrideReturnType: "Neshoda n\xE1vratov\xE9ho typu: Z\xE1kladn\xED metoda vrac\xED typ {baseType}, p\u0159eps\xE1n\xED vrac\xED typ {overrideType}",
        overrideType: "Z\xE1kladn\xED t\u0159\xEDda definuje typ jako {type}",
        paramAssignment: "Parametr {index}: typ {sourceType} nen\xED kompatibiln\xED s typem {destType}.",
        paramSpecMissingInOverride: "V metod\u011B p\u0159eps\xE1n\xED chyb\xED parametry ParamSpec",
        paramType: "Typ parametru je {paramType}",
        privateImportFromPyTypedSource: "M\xEDsto toho importovat z modulu {module}",
        propertyAccessFromProtocolClass: "Vlastnost definovan\xE1 v r\xE1mci t\u0159\xEDdy protokolu nen\xED p\u0159\xEDstupn\xE1 jako prom\u011Bnn\xE1 t\u0159\xEDdy",
        propertyMethodIncompatible: "Metoda vlastnosti (property) {name} nen\xED kompatibiln\xED.",
        propertyMethodMissing: "V p\u0159eps\xE1n\xED (override) chyb\xED metoda vlastnosti (property) \u201E{name}\u201C.",
        propertyMissingDeleter: "Vlastnost (property) {name} nem\xE1 definovanou metodu deleter.",
        propertyMissingSetter: "Vlastnost (property) {name} nem\xE1 definovanou metodu setter.",
        protocolIncompatible: "{sourceType} nen\xED kompatibiln\xED s protokolem {destType}",
        protocolMemberMissing: "{name} nen\xED k dispozici",
        protocolRequiresRuntimeCheckable: "T\u0159\xEDda Protocol mus\xED b\xFDt @runtime_checkable, aby se pou\u017Eila p\u0159i kontrol\xE1ch instanc\xED a t\u0159\xEDd.",
        protocolSourceIsNotConcrete: "\u201E{sourceType}\u201C nen\xED konkr\xE9tn\xED typ t\u0159\xEDdy a ned\xE1 se p\u0159i\u0159adit k typu \u201E{destType}\u201C",
        protocolUnsafeOverlap: "Atributy \u201E{name}\u201C maj\xED stejn\xE9 n\xE1zvy jako protokol.",
        pyrightCommentIgnoreTip: "Pokud chcete potla\u010Dit diagnostiku pro jeden \u0159\xE1dek, pou\u017Eijte # pyright: ignore[<diagnostic rules>]",
        readOnlyAttribute: "Atribut {name} je jen pro \u010Dten\xED",
        seeClassDeclaration: "Viz deklarace t\u0159\xEDdy",
        seeDeclaration: "Viz deklarace",
        seeFunctionDeclaration: "Viz deklarace funkce",
        seeMethodDeclaration: "Viz deklarace metody",
        seeParameterDeclaration: "Viz deklarace parametru",
        seeTypeAliasDeclaration: "Zobrazit deklaraci aliasu typu",
        seeVariableDeclaration: "Zobrazit deklaraci prom\u011Bnn\xE9",
        tupleAssignmentMismatch: "Typ \u201E{type}\u201C nen\xED kompatibiln\xED s c\xEDlovou \u0159azenou kolekc\xED \u010Dlen\u016F (tuple).",
        tupleEntryTypeMismatch: "Polo\u017Eka \u0159azen\xE9 kolekce \u010Dlen\u016F (tuple) {entry} je nespr\xE1vn\xE9ho typu.",
        tupleSizeIndeterminateSrc: "Neshoda velikosti \u0159azen\xE9 kolekce \u010Dlen\u016F (tuple); o\u010Dek\xE1valo se {expected}, ale p\u0159ijalo se neur\u010Dit\xE9.",
        tupleSizeIndeterminateSrcDest: "Neshoda velikosti \u0159azen\xE9 kolekce \u010Dlen\u016F (tuple); o\u010Dek\xE1valo se min. {expected}, ale p\u0159ijalo se neur\u010Dit\xE9.",
        tupleSizeMismatch: "Neshoda velikosti \u0159azen\xE9 kolekce \u010Dlen\u016F (tuple); o\u010Dek\xE1valo se {expected}, ale p\u0159ijalo se {received}.",
        tupleSizeMismatchIndeterminateDest: "Neshoda velikosti \u0159azen\xE9 kolekce \u010Dlen\u016F (tuple); O\u010Dek\xE1valo se {expected}, ale p\u0159ijalo se {received}.",
        typeAliasInstanceCheck: "Alias typu vytvo\u0159en\xFD pomoc\xED p\u0159\xEDkazu \u201Etype\u201C se ned\xE1 pou\u017E\xEDt s kontrolami instanc\xED a t\u0159\xEDd.",
        typeAssignmentMismatch: "Typ {sourceType} se ned\xE1 p\u0159i\u0159adit k typu {destType}.",
        typeBound: "Typ {sourceType} se ned\xE1 p\u0159i\u0159adit k horn\xED hranici {destType} pro prom\u011Bnnou typu {name}.",
        typeConstrainedTypeVar: "Typ {type} se ned\xE1 p\u0159i\u0159adit k prom\u011Bnn\xE9 omezen\xE9ho typu {name}.",
        typeIncompatible: "{sourceType} se ned\xE1 p\u0159i\u0159adit k {destType}.",
        typeNotClass: "{type} nen\xED t\u0159\xEDda",
        typeNotStringLiteral: "\u201E{type}\u201C nen\xED \u0159et\u011Bzcov\xFD liter\xE1l",
        typeOfSymbol: "Typ \u201E{name}\u201C je \u201E{type}\u201C",
        typeParamSpec: "Typ {type} nen\xED kompatibiln\xED s parametrem ParamSpec {name}",
        typeUnsupported: "Typ {type} nen\xED podporov\xE1n",
        typeVarDefaultOutOfScope: "Prom\u011Bnn\xE1 typu {name} nen\xED v oboru",
        typeVarIsContravariant: "Parametr typu \u201E{name}\u201C je kontravariantn\xED, ale \u201E{sourceType}\u201C nen\xED nadtyp \u201E{destType}\u201C.",
        typeVarIsCovariant: "Parametr typu \u201E{name}\u201C je kovariantn\xED, ale \u201E{sourceType}\u201C nen\xED podtyp \u201E{destType}\u201C.",
        typeVarIsInvariant: "Parametr typu \u201E{name}\u201C je invariantn\xED, ale \u201E{sourceType}\u201C nen\xED stejn\xFD jako \u201E{destType}\u201C.",
        typeVarNotAllowed: "TypeVar se pro kontroly instanc\xED nebo t\u0159\xEDd nepovoluje.",
        typeVarTupleRequiresKnownLength: "Typ TypeVarTuple nem\u016F\u017Ee b\xFDt v\xE1zan\xFD na \u0159azenou kolekci \u010Dlen\u016F (tuple) nezn\xE1m\xE9 d\xE9lky.",
        typeVarUnnecessarySuggestion: "M\xEDsto toho pou\u017Eijte {type}.",
        typeVarUnsolvableRemedy: "Zadejte p\u0159et\xED\u017Een\xED, kter\xE9 ur\u010Duje n\xE1vratov\xFD typ, pokud argument nen\xED zad\xE1n",
        typeVarsMissing: "Chyb\u011Bj\xEDc\xED prom\u011Bnn\xE9 typu: {names}",
        typedDictBaseClass: "T\u0159\xEDda \u201E{type}\u201C nen\xED TypedDict.",
        typedDictClassNotAllowed: "T\u0159\xEDda TypedDict nen\xED povolen\xE1 pro kontroly instanc\xED nebo t\u0159\xEDd.",
        typedDictClosedExtraNotAllowed: "Do {name} nejde p\u0159idat polo\u017Eku.",
        typedDictClosedExtraTypeMismatch: "Nelze p\u0159idat polo\u017Eku {name} s typem {type}.",
        typedDictClosedFieldNotReadOnly: 'Cannot add item "{name}" because it must be ReadOnly',
        typedDictClosedFieldNotRequired: "Nelze p\u0159idat polo\u017Eku {name}, proto\u017Ee mus\xED b\xFDt NotRequired.",
        typedDictExtraFieldNotAllowed: "{name} nen\xED k dispozici v {type}",
        typedDictExtraFieldTypeMismatch: "Typ {name} nen\xED kompatibiln\xED s typem \u201Eextra_items\u201C v typu {type}.",
        typedDictFieldMissing: "V {type} chyb\xED {name}",
        typedDictFieldNotReadOnly: "{name} nen\xED v {type} jen pro \u010Dten\xED",
        typedDictFieldNotRequired: "{name} se v typu {type} nevy\u017Eaduje",
        typedDictFieldRequired: "{name} se vy\u017Eaduje v {type}",
        typedDictFieldTypeMismatch: "Typ {type} se ned\xE1 p\u0159i\u0159adit k polo\u017Ece {name}",
        typedDictFieldUndefined: "{name} je nedefinovan\xE1 polo\u017Eka v typu {type}",
        typedDictKeyAccess: 'Pou\u017E\xEDt ["{name}"] k odkazov\xE1n\xED na polo\u017Eku v TypedDict',
        typedDictNotAllowed: "TypedDict se ned\xE1 pou\u017E\xEDt pro kontroly instanc\xED nebo t\u0159\xEDd.",
        unhashableType: "Typ \u201E{type}\u201C nejde zat\u0159i\u010Fovat",
        uninitializedAbstractVariable: "Prom\u011Bnn\xE1 instance {name} je definovan\xE1 v abstraktn\xED z\xE1kladn\xED t\u0159\xEDd\u011B {classType}, ale neinicializovala se",
        unreachableExcept: "{exceptionType} je podt\u0159\xEDdou {parentType}",
        useDictInstead: "Ozna\u010Dte typ slovn\xEDku pomoc\xED dict[T1, T2]",
        useListInstead: "Pou\u017Eijte list[T] k ozna\u010Den\xED typu seznamu (list) nebo T1 | T2 k ozna\u010Den\xED typu sjednocen\xED (union).",
        useTupleInstead: "Pou\u017Eijte tuple[T1, ..., Tn] k ozna\u010Den\xED typu \u0159azen\xE9 kolekce \u010Dlen\u016F (tuple) nebo T1 | T2 k ozna\u010Den\xED typu sjednocen\xED (union).",
        useTypeInstead: "M\xEDsto toho pou\u017E\xEDt type[T]",
        varianceMismatchForClass: "Odchylka argumentu typu \u201E{typeVarName}\u201C nen\xED kompatibiln\xED se z\xE1kladn\xED t\u0159\xEDdou \u201E{className}\u201C",
        varianceMismatchForTypeAlias: "Rozptyl argumentu typu \u201E{typeVarName}\u201C nen\xED kompatibiln\xED s typem \u201E{typeAliasParam}\u201C"
      },
      Service: {
        longOperation: "V\xFD\u010Det zdrojov\xFDch soubor\u016F pracovn\xEDho prostoru trv\xE1 dlouho. Zva\u017Ete rad\u011Bji otev\u0159en\xED podslo\u017Eky. [Dal\u0161\xED informace](https://aka.ms/workspace-too-many-files)"
      }
    };
  }
});

// node_modules/@zzzen/pyright-internal/dist/localization/package.nls.de.json
var require_package_nls_de = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/localization/package.nls.de.json"(exports2, module2) {
    module2.exports = {
      CodeAction: {
        createTypeStub: "Type Stub erstellen",
        createTypeStubFor: 'Type Stub f\xFCr "{moduleName}" erstellen',
        executingCommand: "Der Befehl wird ausgef\xFChrt.",
        filesToAnalyzeCount: "{count} Dateien zu analysieren",
        filesToAnalyzeOne: "1 zu analysierende Datei",
        findingReferences: "Verweise werden gesucht",
        organizeImports: "Import-Direktiven organisieren"
      },
      Completion: {
        autoImportDetail: "Autoimport",
        indexValueDetail: "Indexwert"
      },
      Diagnostic: {
        abstractMethodInvocation: "Die Methode \u201E{method}\u201C kann nicht aufgerufen werden, da sie abstrakt und nicht implementiert ist.",
        annotatedMetadataInconsistent: "Der mit Anmerkungen versehene Metadatentyp \u201E{metadataType}\u201C ist nicht mit dem Typ \u201E{type}\u201C kompatibel.",
        annotatedParamCountMismatch: "Nicht \xFCbereinstimmende Parameteranmerkungsanzahl: {expected} erwartet, aber {received} empfangen",
        annotatedTypeArgMissing: 'Es wurde ein Typargument und mindestens eine Anmerkung f\xFCr "Annotated" erwartet.',
        annotationBytesString: "In Typausdr\xFCcken d\xFCrfen keine Bytes-Zeichenfolgenliterale verwendet werden",
        annotationFormatString: "Typausdr\xFCcke d\xFCrfen keine Formatzeichenfolgenliterale (f-strings) enthalten",
        annotationNotSupported: "Typanmerkung wird f\xFCr diese Anweisung nicht unterst\xFCtzt.",
        annotationRawString: "Typausdr\xFCcke d\xFCrfen keine unformatierten Zeichenfolgenliterale enthalten",
        annotationSpansStrings: "Typausdr\xFCcke d\xFCrfen nicht mehrere Zeichenfolgenliterale umfassen.",
        annotationStringEscape: "Typausdr\xFCcke d\xFCrfen keine Escapezeichen enthalten",
        annotationTemplateString: "Type expressions cannot use template string literals (t-strings)",
        argAssignment: 'Ein Argument vom Typ "{argType}" kann dem Parameter vom Typ "{paramType}" nicht zugewiesen werden.',
        argAssignmentFunction: 'Ein Argument vom Typ "{argType}" kann dem Parameter vom Typ "{paramType}" in der Funktion "{functionName}" nicht zugewiesen werden.',
        argAssignmentParam: 'Ein Argument vom Typ "{argType}" kann dem Parameter "{paramName}" vom Typ "{paramType}" nicht zugewiesen werden.',
        argAssignmentParamFunction: 'Ein Argument vom Typ "{argType}" kann dem Parameter "{paramName}" vom Typ "{paramType}" in der Funktion "{functionName}" nicht zugewiesen werden.',
        argMissingForParam: "F\xFCr Parameter {name} fehlt ein Argument.",
        argMissingForParams: "Fehlende Argumente f\xFCr die Parameter {names}",
        argMorePositionalExpectedCount: "Es wurden {expected} weitere Positionsargumente erwartet.",
        argMorePositionalExpectedOne: "Es wurde 1 weiteres Positionsargument erwartet.",
        argPositional: "Positionsargument erwartet",
        argPositionalExpectedCount: "Es wurden {expected} Positionsargumente erwartet.",
        argPositionalExpectedOne: "Es wurde 1 Positionsargument erwartet.",
        argTypePartiallyUnknown: "Der Argumenttyp ist teilweise unbekannt",
        argTypeUnknown: "Argumenttyp ist unbekannt",
        assertAlwaysTrue: "Assertausdruck wird immer als \u201Etrue\u201C ausgewertet.",
        assertTypeArgs: '"assert_type" erwartet zwei Positionsargumente.',
        assertTypeTypeMismatch: '"assert_type" Konflikt: "{expected}" erwartet, aber "{received}" empfangen',
        assignmentExprComprehension: 'Ziel des Zuweisungsausdrucks "{name}" kann nicht denselben Namen wie das Verst\xE4ndnis f\xFCr das Ziel verwenden.',
        assignmentExprContext: "Der Zuweisungsausdruck muss sich innerhalb des Moduls, der Funktion oder der Lambdafunktion befinden.",
        assignmentExprInSubscript: "Zuweisungsausdr\xFCcke innerhalb eines Tiefgestellten werden nur in Python 3.10 und h\xF6her unterst\xFCtzt.",
        assignmentInProtocol: "Instanzen- oder Klassenvariablen innerhalb einer Protocol Klasse m\xFCssen explizit innerhalb des Klassentexts deklariert werden.",
        assignmentTargetExpr: "Der Ausdruck kann kein Zuweisungsziel sein.",
        asyncNotInAsyncFunction: 'Die Verwendung von "async" ist au\xDFerhalb einer asynchronen Funktion nicht zul\xE4ssig.',
        awaitIllegal: 'Die Verwendung von "await" erfordert Python 3.5 oder h\xF6her.',
        awaitNotAllowed: "In Typausdr\xFCcken darf \u201Eawait\u201C nicht verwendet werden",
        awaitNotInAsync: '"await" ist nur innerhalb einer asynchronen Funktion zul\xE4ssig.',
        backticksIllegal: "Ausdr\xFCcke, die von Backticks umgeben sind, werden in Python 3.x nicht unterst\xFCtzt; verwenden Sie stattdessen repr",
        baseClassCircular: "Die Klasse kann nicht von sich selbst abgeleitet werden.",
        baseClassFinal: 'Die Basisklasse "{type}" ist als final gekennzeichnet und kann nicht als Unterklasse verwendet werden.',
        baseClassIncompatible: "Basisklassen von {type} sind gegenseitig inkompatibel.",
        baseClassInvalid: "Das Argument f\xFCr die Klasse muss eine Basisklasse sein.",
        baseClassMethodTypeIncompatible: 'Basisklassen f\xFCr die Klasse "{classType}" definieren die Methode "{name}" auf inkompatible Weise.',
        baseClassUnknown: "Der Basisklassentyp ist unbekannt, sodass der Typ der abgeleiteten Klasse verdeckt wird.",
        baseClassVariableTypeIncompatible: 'Basisklassen f\xFCr die Klasse "{classType}" definieren die Variable "{name}" auf inkompatible Weise.',
        binaryOperationNotAllowed: "Der bin\xE4rer Operator ist im Typausdruck nicht zul\xE4ssig",
        bindParamMissing: "Die Methode \u201E{methodName}\u201C konnte nicht gebunden werden, weil der Parameter \u201Eself\u201C oder \u201Ecls\u201C fehlt.",
        bindTypeMismatch: 'Die Methode "{methodName}" konnte nicht gebunden werden, da "{type}" dem Parameter "{paramName}" nicht zugewiesen werden kann.',
        breakInExceptionGroup: "\u201Ebreak\u201C ist in einem \u201Eexcept*\u201C Block nicht zul\xE4ssig.",
        breakOutsideLoop: '"break" kann nur innerhalb einer Schleife verwendet werden.',
        bytesUnsupportedEscape: "Nicht unterst\xFCtzte Escapesequenz in bytes-Literal",
        callableExtraArgs: 'Es wurden nur zwei Typargumente f\xFCr "Callable" erwartet.',
        callableFirstArg: 'Parametertypliste oder "..." erwartet.',
        callableNotInstantiable: 'Der Typ "{type}" kann nicht instanziiert werden.',
        callableSecondArg: 'R\xFCckgabetyp als zweites Typargument f\xFCr "Callable" erwartet',
        casePatternIsIrrefutable: "Ein unwiderlegbares Muster ist nur f\xFCr die letzte case-Anweisung zul\xE4ssig.",
        classAlreadySpecialized: 'Der Typ "{type}" ist bereits spezialisiert.',
        classDecoratorTypeUnknown: "Der nicht typisierte Klassendekorator verdeckt den Typ der Klasse; Decorator wird ignoriert.",
        classDefinitionCycle: 'Die Klassendefinition f\xFCr "{name}" h\xE4ngt von sich selbst ab.',
        classGetItemClsParam: '__class_getitem__ Au\xDFerkraftsetzung sollte einen "cls"-Parameter annehmen.',
        classMethodClsParam: 'Klassenmethoden sollten einen "cls"-Parameter verwenden.',
        classNotRuntimeSubscriptable: "Tiefgestellte Zeichen f\xFCr die Klasse \u201E{name}\u201C generieren eine Laufzeitausnahme; schlie\xDFen Sie den Typausdruck in Anf\xFChrungszeichen ein",
        classPatternBuiltInArgPositional: "Das Klassenmuster akzeptiert nur positionsbezogenes Untermuster.",
        classPatternNewType: '"{type}" cannot be used in a class pattern because it is defined using NewType',
        classPatternPositionalArgCount: 'Zu viele Positionsmuster f\xFCr Klasse "{type}". Erwartet: {expected}, empfangen: {received}.',
        classPatternTypeAlias: '"{type}" kann nicht in einem Klassenmuster verwendet werden, da es sich um einen spezialisierten Typalias handelt.',
        classPropertyDeprecated: "Klasseneigenschaften sind in Python\xA03.11 veraltet und werden in Python\xA03.13 nicht unterst\xFCtzt.",
        classTypeParametersIllegal: "Die Syntax des Klassentypparameters erfordert Python 3.12 oder h\xF6her.",
        classVarFirstArgMissing: 'Nach "ClassVar" wurde ein Typargument erwartet.',
        classVarNotAllowed: '"ClassVar" ist in diesem Kontext nicht zul\xE4ssig.',
        classVarOverridesInstanceVar: 'Die Klassenvariable "{name}" \xFCberschreibt die Instanzvariable desselben Namens in der Klasse "{className}"',
        classVarTooManyArgs: 'Nach "ClassVar" wird ein Typargument erwartet.',
        classVarWithTypeVar: 'Der Typ "ClassVar" darf keine Typvariablen enthalten.',
        clsSelfParamTypeMismatch: 'Der Typ des Parameters "{name}" muss ein Obertyp seiner Klasse "{classType}" sein',
        codeTooComplexToAnalyze: "Der Code ist zu komplex f\xFCr die Analyse; verringern Sie die Komplexit\xE4t durch Refactoring in Unterroutinen oder durch Reduzieren bedingter Codepfade",
        collectionAliasInstantiation: 'Der Typ "{type}" kann nicht instanziiert werden, verwenden Sie stattdessen "{alias}".',
        comparisonAlwaysFalse: 'Die Bedingung wird immer als False ausgewertet, da die Typen "{leftType}" und "{rightType}" keine \xDCberlappung aufweisen.',
        comparisonAlwaysTrue: 'Die Bedingung wird immer als True ausgewertet, da die Typen "{leftType}" und "{rightType}" keine \xDCberlappung aufweisen.',
        comprehensionInDict: "Verst\xE4ndnis kann nicht mit anderen W\xF6rterbucheintr\xE4gen verwendet werden.",
        comprehensionInSet: "Verst\xE4ndnis kann nicht mit anderen \u201Eset\u201C Eintr\xE4gen verwendet werden.",
        concatenateContext: "\u201EConcatenate\u201C ist in diesem Kontext nicht zul\xE4ssig.",
        concatenateParamSpecMissing: 'Das letzte Typargument f\xFCr "Concatenate" muss ein ParamSpec oder "..." sein.',
        concatenateTypeArgsMissing: "\u201EConcatenate\u201E erfordert mindestens zwei Typargumente.",
        conditionalOperandInvalid: 'Ung\xFCltiger bedingter Operand vom Typ "{type}"',
        constantRedefinition: '"{name}" ist konstant (da es sich um Gro\xDFbuchstaben handelt) und kann nicht neu definiert werden.',
        constructorParametersMismatch: 'Keine \xDCbereinstimmung zwischen der Signatur von __new__ und __init__ in der Klasse "{classType}"',
        containmentAlwaysFalse: 'Der Ausdruck wird immer als False ausgewertet, da die Typen "{leftType}" und "{rightType}" keine \xDCberlappung aufweisen.',
        containmentAlwaysTrue: 'Der Ausdruck wird immer als True ausgewertet, da die Typen "{leftType}" und "{rightType}" keine \xDCberlappung aufweisen.',
        continueInExceptionGroup: "\u201Econtinue\u201C ist in einem \u201Eexcept*\u201C Block nicht zul\xE4ssig.",
        continueOutsideLoop: '"continue" kann nur innerhalb einer Schleife verwendet werden.',
        coroutineInConditionalExpression: 'Bedingter Ausdruck verweist auf eine Coroutine, die immer zu "True" ausgewertet wird.',
        dataClassBaseClassFrozen: "Eine nicht fixierte Klasse kann nicht von einer fixierten Klasse erben.",
        dataClassBaseClassNotFrozen: "Eine fixierte Klasse kann nicht von einer nicht fixierten Klasse erben.",
        dataClassConverterFunction: 'Das Argument vom Typ "{argType}" ist kein g\xFCltiger Konverter f\xFCr das Feld "{fieldName}" vom Typ "{fieldType}"',
        dataClassConverterOverloads: 'Keine \xDCberladungen von "{funcName}" sind g\xFCltige Konverter f\xFCr das Feld "{fieldName}" vom Typ "{fieldType}"',
        dataClassFieldInheritedDefault: "\u201E{fieldName}\u201C \xFCberschreibt ein Feld mit demselben Namen, aber es fehlt ein Standardwert",
        dataClassFieldWithDefault: "Felder ohne Standardwerte d\xFCrfen nicht nach Feldern mit Standardwerten angezeigt werden.",
        dataClassFieldWithPrivateName: 'Das Feld "Dataclass" kann keinen privaten Namen verwenden.',
        dataClassFieldWithoutAnnotation: "Datenklassenfeld ohne Typanmerkung verursacht eine Laufzeitausnahme",
        dataClassPostInitParamCount: "Dataclass __post_init__ falsche Parameteranzahl; Anzahl von InitVar-Feldern ist {expected}",
        dataClassPostInitType: 'Dataclass __post_init__ Methodenparametertypkonflikt f\xFCr Feld "{fieldName}"',
        dataClassSlotsOverwrite: "__slots__ ist bereits in der Klasse definiert.",
        dataClassTransformExpectedBoolLiteral: "Es wurde ein Ausdruck erwartet, der statisch als True oder False ausgewertet wird.",
        dataClassTransformFieldSpecifier: 'Es wurde tuple von Klassen oder Funktionen erwartet, es wurde jedoch der Typ "{type}" empfangen',
        dataClassTransformPositionalParam: 'Alle Argumente f\xFCr "dataclass_transform" m\xFCssen Schl\xFCsselwortargumente sein.',
        dataClassTransformUnknownArgument: 'Argument "{name}" wird von dataclass_transform nicht unterst\xFCtzt.',
        dataProtocolInSubclassCheck: "Datenprotokolle (die Nicht-Methodenattribute enthalten) sind in \u201Eissubclass\u201C-Aufrufen nicht zul\xE4ssig.",
        declaredReturnTypePartiallyUnknown: 'Der deklarierte R\xFCckgabetyp "{returnType}" ist teilweise unbekannt.',
        declaredReturnTypeUnknown: "Unbekannter R\xFCckgabetyp deklariert",
        defaultValueContainsCall: "Funktionsaufrufe und \xE4nderbare Objekte sind innerhalb des Parameterstandardwertausdrucks nicht zul\xE4ssig.",
        defaultValueNotAllowed: 'Ein Parameter mit "*" oder "**" darf keinen Standardwert aufweisen.',
        delTargetExpr: "Der Ausdruck kann nicht gel\xF6scht werden",
        deprecatedClass: 'Die Klasse "{name}" ist veraltet.',
        deprecatedConstructor: 'Der Konstruktor f\xFCr die Klasse "{name}" ist veraltet.',
        deprecatedDescriptorDeleter: 'Die Methode "__delete__" f\xFCr den Deskriptor "{name}" ist veraltet.',
        deprecatedDescriptorGetter: 'Die Methode "__get__" f\xFCr den Deskriptor "{name}" ist veraltet.',
        deprecatedDescriptorSetter: 'Die Methode "__set__" f\xFCr den Deskriptor "{name}" ist veraltet.',
        deprecatedFunction: 'Die Funktion "{name}" ist veraltet.',
        deprecatedMethod: 'Die Methode "{name}" in der Klasse "{className}" ist veraltet.',
        deprecatedPropertyDeleter: 'Der deleter f\xFCr property "{name}" ist veraltet.',
        deprecatedPropertyGetter: 'Der getter f\xFCr property "{name}" ist veraltet.',
        deprecatedPropertySetter: 'Der setter f\xFCr property "{name}" ist veraltet.',
        deprecatedType: 'Dieser Typ ist ab python-{version} veraltet; verwenden Sie stattdessen "{replacement}"',
        dictExpandIllegalInComprehension: "W\xF6rterbucherweiterung ist im Verst\xE4ndnis nicht zul\xE4ssig.",
        dictInAnnotation: "Der W\xF6rterbuchausdruck ist im Typausdruck nicht zul\xE4ssig",
        dictKeyValuePairs: "W\xF6rterbucheintr\xE4ge m\xFCssen Schl\xFCssel-Wert-Paare enthalten.",
        dictUnpackIsNotMapping: "Es wird eine Zuordnung f\xFCr den Operator zum Entpacken des W\xF6rterbuchs erwartet.",
        dunderAllSymbolNotPresent: '"{name}" ist in __all__ angegeben, aber nicht im Modul vorhanden.',
        duplicateArgsParam: 'Es ist nur ein "*"-Parameter zul\xE4ssig.',
        duplicateBaseClass: "Doppelte Basisklasse nicht zul\xE4ssig",
        duplicateCapturePatternTarget: '"{name}" des Erfassungsziels darf nicht mehrmals innerhalb desselben Musters vorkommen.',
        duplicateCatchAll: "Es ist nur eine catch-all except-Klausel zul\xE4ssig.",
        duplicateEnumMember: 'Der Enumerationsmember "{name}" wurde bereits deklariert.',
        duplicateGenericAndProtocolBase: "Es ist nur eine Generic[...]- oder ein Protocol[...]-Basisklasse zul\xE4ssig.",
        duplicateImport: '"{importName}" wurde mehrmals importiert.',
        duplicateKeywordOnly: 'Es ist nur ein "*"-Trennzeichen zul\xE4ssig.',
        duplicateKwargsParam: 'Es ist nur ein "**"-Parameter zul\xE4ssig.',
        duplicateParam: 'Doppelter Parameter "{name}"',
        duplicatePositionOnly: 'Es ist nur ein "/"-Parameter zul\xE4ssig.',
        duplicateStarPattern: 'In einer Mustersequenz ist nur ein "*"-Muster zul\xE4ssig.',
        duplicateStarStarPattern: 'Es ist nur ein "**"-Eintrag zul\xE4ssig.',
        duplicateUnpack: "In list ist nur ein Vorgang zum Entpacken zul\xE4ssig.",
        ellipsisAfterUnpacked: "\u201E...\u201C kann nicht mit einem entpackten \u201ETypeVarTuple\u201C oder \u201Etuple\u201C verwendet werden.",
        ellipsisContext: '"..." ist in diesem Kontext nicht zul\xE4ssig.',
        ellipsisSecondArg: '"..." ist nur als zweites von zwei Argumenten zul\xE4ssig.',
        enumClassOverride: 'Die Enumerationsklasse "{name}" ist final und kann nicht in eine Unterklasse aufgenommen werden.',
        enumMemberDelete: 'Das Enumerationselement "{name}" kann nicht gel\xF6scht werden.',
        enumMemberSet: 'Das Enumerationselement "{name}" kann nicht zugewiesen werden.',
        enumMemberTypeAnnotation: "Typanmerkungen sind f\xFCr enum Member nicht zul\xE4ssig",
        exceptGroupMismatch: "Die \u201Etry\u201C-Anweisung darf nicht sowohl \u201Eexcept\u201C als auch \u201Eexcept*\u201C enthalten.",
        exceptGroupRequiresType: "Die Ausnahmegruppensyntax (\u201Eexcept*\u201C) erfordert einen Ausnahmetyp.",
        exceptRequiresParens: "Multiple exception types must be parenthesized prior to Python 3.14",
        exceptWithAsRequiresParens: 'Multiple exception types must be parenthesized when using "as"',
        exceptionGroupIncompatible: 'Die Ausnahmegruppensyntax ("except*") erfordert Python 3.11 oder h\xF6her.',
        exceptionGroupTypeIncorrect: "Der Ausnahmetyp in except* kann nicht von BaseGroupException abgeleitet werden.",
        exceptionTypeIncorrect: '"{type}" ist nicht von BaseException abgeleitet.',
        exceptionTypeNotClass: '"{type}" ist keine g\xFCltige Ausnahmeklasse.',
        exceptionTypeNotInstantiable: 'Der Konstruktor f\xFCr den Ausnahmetyp "{type}" erfordert mindestens ein Argument.',
        expectedAfterDecorator: "Es wurde eine Funktions- oder Klassendeklaration nach dem Decorator erwartet.",
        expectedArrow: '"->" gefolgt von R\xFCckgabetypanmerkung erwartet',
        expectedAsAfterException: '"as" nach Ausnahmetyp erwartet',
        expectedAssignRightHandExpr: 'Ausdruck rechts von "=" erwartet',
        expectedBinaryRightHandExpr: "Ausdruck rechts vom Operator",
        expectedBoolLiteral: '"True" oder "False" erwartet',
        expectedCase: '"case"-Anweisung erwartet',
        expectedClassName: "Klassenname erwartet",
        expectedCloseBrace: '"{" wurde nicht geschlossen.',
        expectedCloseBracket: '"[" wurde nicht geschlossen.',
        expectedCloseParen: '"(" wurde nicht geschlossen.',
        expectedColon: '":" erwartet',
        expectedComplexNumberLiteral: "F\xFCr den Musterabgleich wurde ein komplexes Zahlenliteral erwartet.",
        expectedDecoratorExpr: "Das Ausdrucksformular wird f\xFCr den Decorator vor Python 3.9 nicht unterst\xFCtzt.",
        expectedDecoratorName: "Decoratorname erwartet",
        expectedDecoratorNewline: "Am Ende des Decorators wurde eine neue Zeile erwartet.",
        expectedDelExpr: 'Ausdruck nach "del" erwartet',
        expectedElse: 'Unerwartetes "else"',
        expectedEquals: '"=" erwartet',
        expectedExceptionClass: "Ung\xFCltige Ausnahmeklasse oder ung\xFCltiges Objekt.",
        expectedExceptionObj: "Ausnahmeobjekt, Ausnahmeklasse oder None erwartet",
        expectedExpr: "Ausdruck erwartet.",
        expectedFunctionAfterAsync: 'Funktionsdefinition nach "async" erwartet',
        expectedFunctionName: 'Funktionsname nach "def" erwartet',
        expectedIdentifier: "Bezeichner erwartet",
        expectedImport: '"import" erwartet',
        expectedImportAlias: 'Symbol nach "as" erwartet',
        expectedImportSymbols: 'Nach dem "import" wurde mindestens ein Symbolname erwartet.',
        expectedIn: '"in" wurde erwartet.',
        expectedInExpr: 'Ausdruck nach "in" erwartet',
        expectedIndentedBlock: "Einger\xFCckter Block erwartet",
        expectedMemberName: "Attributname nach \u201E.\u201C erwartet",
        expectedModuleName: "Modulname erwartet",
        expectedNameAfterAs: 'Symbolname nach "as" erwartet',
        expectedNamedParameter: 'Der Schl\xFCsselwortparameter muss auf "*" folgen.',
        expectedNewline: "Zeilenumbruch erwartet",
        expectedNewlineOrSemicolon: "Anweisungen m\xFCssen durch Zeilenumbr\xFCche oder Semikolons getrennt werden.",
        expectedOpenParen: '"(" erwartet',
        expectedParamName: "Parametername erwartet",
        expectedPatternExpr: "Musterausdruck erwartet",
        expectedPatternSubjectExpr: "Musterbetreffausdruck erwartet",
        expectedPatternValue: 'Es wurde ein Musterwertausdruck im Format "a.b" erwartet.',
        expectedReturnExpr: 'Ausdruck nach "return" erwartet',
        expectedSliceIndex: "Index- oder Sliceausdruck erwartet",
        expectedTypeNotString: "Typ erwartet, aber Zeichenfolgenliteral empfangen",
        expectedTypeParameterName: "Name f\xFCr Typparameter erwartet",
        expectedYieldExpr: "Ausdruck in yield-Anweisung erwartet",
        finalClassIsAbstract: "Die Klasse \u201E{type}\u201C ist als final markiert und muss alle abstrakten Symbole implementieren.",
        finalContext: '"Final" ist in diesem Kontext nicht zul\xE4ssig.',
        finalInLoop: 'Eine "Final"-Variable kann nicht innerhalb einer Schleife zugewiesen werden.',
        finalMethodOverride: 'Die Methode "{name}" kann die in der Klasse definierte final Methode "{className}" nicht \xFCberschreiben.',
        finalNonMethod: "Die Funktion \u201E{name}\u201C kann nicht @final markiert werden, da sie keine Methode ist.",
        finalReassigned: '"{name}" ist als "Final" deklariert und kann nicht neu zugewiesen werden.',
        finalRedeclaration: '"{name}" wurde zuvor als "Final" deklariert.',
        finalRedeclarationBySubclass: '"{name}" kann nicht neu deklariert werden, da die \xFCbergeordnete Klasse "{className}" es als Final deklariert.',
        finalTooManyArgs: 'Nach "Final" wurde ein einzelnes Typargument erwartet.',
        finalUnassigned: '"{name}" ist als Final deklariert, aber der Wert ist nicht zugewiesen.',
        finallyBreak: "Ein \u201Ebreak\u201C kann nicht verwendet werden, um einen \u201Efinally\u201C-Block zu beenden.",
        finallyContinue: "Ein \u201Econtinue\u201C kann nicht verwendet werden, um einen \u201Efinally\u201C-Block zu beenden.",
        finallyReturn: "Ein \u201Ereturn\u201C kann nicht verwendet werden, um einen \u201Efinally\u201C-Block zu beenden.",
        formatStringBrace: "Eine einzelne schlie\xDFende geschweifte Klammer ist innerhalb des f-string-Literals nicht zul\xE4ssig; verwenden Sie doppelte schlie\xDFende geschweifte Klammern.",
        formatStringBytes: "Formatzeichenfolgenliterale (f-strings) d\xFCrfen nicht bin\xE4r sein.",
        formatStringDebuggingIllegal: 'Der F-String-Debugspezifizierer "=" erfordert Python 3.8 oder h\xF6her.',
        formatStringEscape: "Escapesequenz (umgekehrter Schr\xE4gstrich) ist im Ausdrucksteil der f-Zeichenfolge vor Python 3.12 nicht zul\xE4ssig.",
        formatStringExpectedConversion: 'Nach "!" in f-string wurde ein Konvertierungsspezifizierer erwartet.',
        formatStringIllegal: "Formatzeichenfolgenliterale (f-strings) erfordern Python 3.6 oder h\xF6her.",
        formatStringInPattern: "Die Formatzeichenfolge ist im Muster nicht zul\xE4ssig.",
        formatStringNestedFormatSpecifier: "Ausdr\xFCcke sind zu tief im Formatzeichenfolgenspezifizierer geschachtelt.",
        formatStringNestedQuote: "Zeichenfolgen, die in einer f-Zeichenfolge geschachtelt sind, d\xFCrfen nicht dasselbe Anf\xFChrungszeichen wie die f-Zeichenfolge vor Python 3.12 verwenden.",
        formatStringTemplate: "Format string literals (f-strings) cannot also be template strings (t-strings)",
        formatStringUnicode: "Formatzeichenfolgenliterale (f-strings) d\xFCrfen nicht Unicode sein.",
        formatStringUnterminated: 'Nicht abgeschlossener Ausdruck in f-string; "}" wird erwartet.',
        functionDecoratorTypeUnknown: "Ein nicht typisierter Funktionsdekorator verdeckt den Funktionstyp; Decorator wird ignoriert.",
        functionInConditionalExpression: 'Bedingter Ausdruck verweist auf eine Funktion, die immer zu "True" ausgewertet wird.',
        functionTypeParametersIllegal: "Die Syntax des Funktionstypparameters erfordert Python 3.12 oder h\xF6her.",
        futureImportLocationNotAllowed: "Importe von __future__ m\xFCssen am Anfang der Datei auftreten",
        generatorAsyncReturnType: 'Der R\xFCckgabetyp der asynchronen Generatorfunktion muss mit "AsyncGenerator[{yieldType}, Any]" kompatibel sein.',
        generatorNotParenthesized: "Generatorausdr\xFCcke m\xFCssen in Klammern gesetzt werden, wenn sie nicht das einzige Argument sind.",
        generatorSyncReturnType: 'Der R\xFCckgabetyp der Generatorfunktion muss mit "Generator[{yieldType}, Any, Any]" kompatibel sein.',
        genericBaseClassNotAllowed: 'Die Basisklasse "Generic" kann nicht mit der Typparametersyntax verwendet werden.',
        genericClassAssigned: "Der generische Klassentyp kann nicht zugewiesen werden.",
        genericClassDeleted: "Der generische Klassentyp kann nicht gel\xF6scht werden.",
        genericInstanceVariableAccess: "Der Zugriff auf die generische Instanzvariable \xFCber die Klasse ist mehrdeutig.",
        genericNotAllowed: '"Generic" ist in diesem Kontext nicht g\xFCltig.',
        genericTypeAliasBoundTypeVar: "Der generische Typalias innerhalb der Klasse kann keine gebundenen Typvariablen {names} verwenden.",
        genericTypeArgMissing: '"Generic" erfordert mindestens ein Typargument.',
        genericTypeArgTypeVar: 'Das Typargument f\xFCr "Generic" muss eine Typvariable sein.',
        genericTypeArgUnique: 'Typargumente f\xFCr "Generic" m\xFCssen eindeutig sein.',
        globalReassignment: '"{name}" wird vor einer globalen Deklaration zugewiesen.',
        globalRedefinition: '"{name}" wurde bereits als global deklariert.',
        implicitStringConcat: "Implizite Zeichenfolgenverkettung nicht zul\xE4ssig",
        importCycleDetected: "Zyklus in Importkette erkannt",
        importDepthExceeded: "Importkettentiefe \xFCberschritten {depth}",
        importResolveFailure: 'Import "{importName}" konnte nicht aufgel\xF6st werden.',
        importSourceResolveFailure: 'Import "{importName}" konnte aus der Quelle nicht aufgel\xF6st werden.',
        importSymbolUnknown: '"{name}" ist ein unbekanntes Importsymbol.',
        incompatibleMethodOverride: 'Die Methode "{name}" \xFCberschreibt die Klasse "{className}" auf inkompatible Weise.',
        inconsistentIndent: "Der Betrag f\xFCr Nichteinzug stimmt nicht mit dem vorherigen Einzug \xFCberein.",
        inconsistentTabs: "Inkonsistente Verwendung von Tabulatoren und Leerzeichen im Einzug.",
        initMethodSelfParamTypeVar: 'Typ-Anmerkung f\xFCr "self"-Parameter der "__init__"-Methode kann keine klassen\xFCbergreifenden Typvariablen enthalten',
        initMustReturnNone: 'Der R\xFCckgabetyp von "__init__" muss "None" sein.',
        initSubclassCallFailed: "Falsche Schl\xFCsselwortargumente f\xFCr __init_subclass__ Methode.",
        initSubclassClsParam: '__init_subclass__ Au\xDFerkraftsetzung sollte einen "cls"-Parameter annehmen.',
        initVarNotAllowed: "\u201EInitVar\u201C ist in diesem Kontext nicht zul\xE4ssig.",
        instanceMethodSelfParam: 'Instanzmethoden sollten einen "self"-Parameter verwenden.',
        instanceVarOverridesClassVar: 'Die Instanzvariable "{name}" \xFCberschreibt die Klassenvariable desselben Namens in der Klasse "{className}"',
        instantiateAbstract: 'Abstrakte Klasse "{type}" kann nicht erstellt werden.',
        instantiateProtocol: 'Die Protocol-Klasse "{type}" kann nicht instanziiert werden.',
        internalBindError: 'Interner Fehler beim Binden der Datei "{file}": {message}',
        internalParseError: 'Interner Fehler beim Parsen der Datei "{file}": {message}',
        internalTypeCheckingError: 'Interner Fehler bei der Typ\xFCberpr\xFCfung der Datei "{file}": {message}',
        invalidIdentifierChar: "Ung\xFCltiges Zeichen in Bezeichner",
        invalidStubStatement: "Die Anweisung ist innerhalb einer Typstubdatei bedeutungslos.",
        invalidTokenChars: 'Ung\xFCltiges Zeichen "{text}" im Token',
        isInstanceInvalidType: 'Das zweite Argument f\xFCr "isinstance" muss eine Klasse oder tuple von Klassen sein.',
        isSubclassInvalidType: 'Das zweite Argument f\xFCr "issubclass" muss eine Klasse oder tuple von Klassen sein.',
        keyValueInSet: "Schl\xFCssel-Wert-Paare sind innerhalb einer Menge \u201Eset\u201C nicht zul\xE4ssig.",
        keywordArgInTypeArgument: "Schl\xFCsselwortargumente k\xF6nnen nicht in Typargumentlisten verwendet werden.",
        keywordOnlyAfterArgs: 'Schl\xFCsselworttrennzeichen ist nach dem Parameter "*" nicht zul\xE4ssig.',
        keywordParameterMissing: 'Mindestens ein Schl\xFCsselwortparameter muss dem Parameter "*" folgen.',
        keywordSubscriptIllegal: "Schl\xFCsselwortargumente innerhalb von Tiefskripts werden nicht unterst\xFCtzt.",
        lambdaReturnTypePartiallyUnknown: 'Der R\xFCckgabetyp des Lambdaausdrucks "{returnType}" ist teilweise unbekannt.',
        lambdaReturnTypeUnknown: "Der R\xFCckgabetyp der Lambdafunktion ist unbekannt.",
        listAssignmentMismatch: 'Ein Ausdruck vom Typ "{type}" kann der Zielliste nicht zugewiesen werden.',
        listInAnnotation: "Der Listenausdruck ist im Typausdruck nicht zul\xE4ssig",
        literalEmptyArgs: 'Nach "Literal" wurde mindestens ein Typargument erwartet.',
        literalNamedUnicodeEscape: "Benannte Escapesequenz f\xFCr Unicodezeichen werden in Zeichenfolgenanmerkungen vom Typ \u201ELiteral\u201C nicht unterst\xFCtzt.",
        literalNotAllowed: '"Literal" kann in diesem Kontext nicht ohne Typargument verwendet werden.',
        literalNotCallable: "Der Literaltyp kann nicht instanziiert werden.",
        literalUnsupportedType: 'Typargumente f\xFCr "Literal" m\xFCssen None, ein Literalwert (int, bool, str oder bytes) oder ein enum Wert sein.',
        matchIncompatible: "Match Anweisungen erfordern Python 3.10 oder h\xF6her",
        matchIsNotExhaustive: "F\xE4lle innerhalb der match-Anweisung behandeln nicht umfassend alle Werte.",
        maxParseDepthExceeded: "Maximale Analysetiefe \xFCberschritten; brechen Sie den Ausdruck in kleinere Unterausdr\xFCcke um",
        memberAccess: "Auf das Attribut \u201E{name}\u201C f\xFCr die Klasse \u201E{type}\u201C kann nicht zugegriffen werden",
        memberDelete: "Das Attribut \u201E{name}\u201C f\xFCr die Klasse \u201E{type}\u201C kann nicht gel\xF6scht werden",
        memberSet: "Zum Attribut \u201E{name}\u201C f\xFCr die Klasse \u201E{type}\u201C kann nicht zugewiesen werden",
        metaclassConflict: "Die Metaklasse einer abgeleiteten Klasse muss eine Unterklasse der Metaklassen aller ihrer Basisklassen sein.",
        metaclassDuplicate: "Es kann nur eine Metaklasse angegeben werden.",
        metaclassIsGeneric: "Metaklasse kann nicht generisch sein.",
        methodNotDefined: '"{name}" Methode nicht definiert',
        methodNotDefinedOnType: 'Die Methode "{name}" ist f\xFCr den Typ "{type}" nicht definiert.',
        methodOrdering: "Es kann keine konsistente Methodenreihenfolge erstellt werden.",
        methodOverridden: '"{name}" \xFCberschreibt die Methode mit demselben Namen in der Klasse "{className}" mit inkompatiblem Typ "{type}"',
        methodReturnsNonObject: 'Die Methode "{name}" gibt kein Objekt zur\xFCck.',
        missingSuperCall: 'Die Methode "{methodName}" ruft nicht die Methode mit demselben Namen in der \xFCbergeordneten Klasse auf.',
        mixingBytesAndStr: "Bytes- und str-Werte k\xF6nnen nicht verkettet werden",
        moduleAsType: "Das Modul kann nicht als Typ verwendet werden.",
        moduleNotCallable: "Das Modul kann nicht aufgerufen werden.",
        moduleUnknownMember: "\u201E{memberName}\u201C ist kein bekanntes Attribut des Moduls \u201E{moduleName}\u201C",
        namedExceptAfterCatchAll: "Eine benannte except-Klausel darf nicht nach catch-all except-Klausel auftreten.",
        namedParamAfterParamSpecArgs: 'Der Schl\xFCsselwortparameter "{name}" kann nicht in der Signatur nach dem Parameter "ParamSpec args" verwendet werden.',
        namedTupleEmptyName: "Namen innerhalb benannten tuple d\xFCrfen nicht leer sein.",
        namedTupleEntryRedeclared: '"{name}" kann nicht \xFCberschrieben werden, da die \xFCbergeordnete benannte tuple Klasse "{className}" ist.',
        namedTupleFieldUnderscore: "\u201ENamed tuple\u201C-Feldnamen d\xFCrfen nicht mit einem Unterstrich beginnen.",
        namedTupleFirstArg: "Es wird ein benannter tuple Klassenname als erstes Argument erwartet.",
        namedTupleMultipleInheritance: "Mehrfachvererbung mit NamedTuple wird nicht unterst\xFCtzt.",
        namedTupleNameKeyword: "Feldnamen d\xFCrfen kein Schl\xFCsselwort sein.",
        namedTupleNameType: "Es wurde tuple mit zwei Eintr\xE4gen unter Angabe von Eintragsname und -typ erwartet.",
        namedTupleNameUnique: "Namen innerhalb benannten tuple m\xFCssen eindeutig sein.",
        namedTupleNoTypes: '"namedtuple" stellt keine Typen f\xFCr tuple bereit; verwenden Sie stattdessen "NamedTuple".',
        namedTupleSecondArg: "Benannte tuple Eintragsliste als zweites Argument erwartet",
        newClsParam: '__new__ Au\xDFerkraftsetzung sollte einen "cls"-Parameter annehmen.',
        newTypeAnyOrUnknown: "Das zweite Argument f\xFCr NewType muss eine bekannte Klasse sein, nicht \u201EAny\u201C oder \u201EUnknown\u201C.",
        newTypeBadName: "Das erste Argument f\xFCr NewType muss ein Zeichenfolgenliteral sein.",
        newTypeLiteral: '"NewType" kann nicht mit dem Literaltyp verwendet werden.',
        newTypeNameMismatch: "NewType muss einer Variablen mit demselben Namen zugewiesen werden.",
        newTypeNotAClass: "Klasse als zweites Argument f\xFCr NewType erwartet",
        newTypeParamCount: "NewType erfordert zwei Positionsargumente.",
        newTypeProtocolClass: "NewType kann nicht mit strukturellem Typ (Protocol- oder TypedDict-Klasse) verwendet werden.",
        noOverload: 'Keine \xDCberladungen f\xFCr "{name}" stimmen mit den angegebenen Argumenten \xFCberein.',
        noReturnContainsReturn: 'Eine Funktion mit dem deklarierten return Typ "NoReturn" kann keine return-Anweisung enthalten.',
        noReturnContainsYield: 'Eine Funktion mit dem deklarierten R\xFCckgabetyp "NoReturn" kann keine yield-Anweisung enthalten.',
        noReturnReturnsNone: 'Eine Funktion mit dem deklarierten R\xFCckgabetyp "NoReturn" kann nicht "None" zur\xFCckgeben.',
        nonDefaultAfterDefault: "Das nicht standardm\xE4\xDFige Argument folgt dem Standardargument.",
        nonLocalInModule: "Nonlocal Deklaration auf Modulebene nicht zul\xE4ssig",
        nonLocalNoBinding: 'Es wurde keine Bindung f\xFCr nonlocal "{name}" gefunden.',
        nonLocalReassignment: '"{name}" wird vor einer nonlocal Deklaration zugewiesen.',
        nonLocalRedefinition: '"{name}" wurde bereits als nonlocal deklariert.',
        noneNotCallable: 'Ein Objekt vom Typ "None" kann nicht aufgerufen werden.',
        noneNotIterable: 'Ein Objekt vom Typ "None" kann nicht als iterierbarer Wert verwendet werden.',
        noneNotSubscriptable: 'Das Objekt vom Typ "None" kann nicht tiefgestellt werden.',
        noneNotUsableWith: 'Object of type "None" cannot be used with "with"',
        noneNotUsableWithAsync: "Das Objekt vom Typ \u201ENone\u201C kann nicht mit \u201Easync with\u201C verwendet werden.",
        noneOperator: 'Der Operator "{operator}" wird f\xFCr den "{None}" nicht unterst\xFCtzt.',
        noneUnknownMember: "\u201E{name}\u201C ist kein bekanntes Attribut von \u201ENone\u201C",
        nonlocalTypeParam: "Die Bindung \u201ENonlocal\u201C ist f\xFCr den Typparameter \u201E{name}\u201C nicht zul\xE4ssig.",
        notRequiredArgCount: 'Nach "NotRequired" wurde ein einzelnes Typargument erwartet.',
        notRequiredNotInTypedDict: '"NotRequired" ist in diesem Kontext nicht zul\xE4ssig.',
        objectNotCallable: 'Das Objekt vom Typ "{type}" kann nicht aufgerufen werden.',
        obscuredClassDeclaration: 'Die Klassendeklaration "{name}" wird durch eine Deklaration desselben Namens verdeckt.',
        obscuredFunctionDeclaration: 'Die Funktionsdeklaration "{name}" wird durch eine Deklaration desselben Namens verdeckt.',
        obscuredMethodDeclaration: 'Die Methodendeklaration "{name}" wird durch eine Deklaration desselben Namens verdeckt.',
        obscuredParameterDeclaration: 'Die Parameterdeklaration "{name}" wird durch eine Deklaration desselben Namens verdeckt.',
        obscuredTypeAliasDeclaration: 'Die Typaliasdeklaration "{name}" wird durch eine Deklaration desselben Namens verdeckt.',
        obscuredVariableDeclaration: 'Die Deklaration "{name}" wird durch eine Deklaration desselben Namens verdeckt.',
        operatorLessOrGreaterDeprecated: 'Der Operator "<>" wird in Python 3 nicht unterst\xFCtzt; verwenden Sie stattdessen "!=".',
        optionalExtraArgs: 'Nach "Optional" wurde ein Typargument erwartet.',
        orPatternIrrefutable: 'Ein irrefutables Muster ist nur als letztes Unterpattern in einem "or"-Muster zul\xE4ssig.',
        orPatternMissingName: 'Alle Teilmuster innerhalb eines "or"-Musters m\xFCssen auf dieselben Namen zielen.',
        overlappingKeywordArgs: "Typisierte W\xF6rterbuch\xFCberlappungen mit Schl\xFCsselwortparameter: {names}",
        overlappingOverload: '\xDCberladung {obscured} f\xFCr "{name}" wird nie verwendet, da sich die Parameter \xFCberlappen, {obscuredBy}',
        overloadAbstractImplMismatch: "\xDCberladungen m\xFCssen dem abstrakten Status der Implementierung entsprechen.",
        overloadAbstractMismatch: "\xDCberladungen m\xFCssen alle abstrakt sein oder nicht.",
        overloadClassMethodInconsistent: '\xDCberladungen f\xFCr "{name}" verwenden @classmethod inkonsistent',
        overloadFinalImpl: "@final Decorator sollte nur auf die Implementierung angewendet werden.",
        overloadFinalNoImpl: "Nur die erste \xDCberladung sollte @final markiert werden.",
        overloadImplementationMismatch: "Die \xFCberladene Implementierung ist nicht konsistent mit der Signatur der \xDCberladung {index}",
        overloadOverrideImpl: "@override Decorator sollte nur auf die Implementierung angewendet werden.",
        overloadOverrideNoImpl: "Nur die erste \xDCberladung sollte @override markiert werden.",
        overloadReturnTypeMismatch: '\xDCberladung {prevIndex} f\xFCr "{name}" \xFCberlappt {newIndex} und gibt einen inkompatiblen Typ zur\xFCck.',
        overloadStaticMethodInconsistent: '\xDCberladungen f\xFCr "{name}" verwenden @staticmethod inkonsistent',
        overloadWithoutImplementation: '"{name}" ist als overload markiert, es wurde jedoch keine Implementierung bereitgestellt.',
        overriddenMethodNotFound: 'Die Methode "{name}" ist als override markiert, aber es ist keine Basismethode mit demselben Namen vorhanden.',
        overrideDecoratorMissing: 'Die Methode "{name}" ist nicht als override markiert, \xFCberschreibt jedoch eine Methode in der Klasse "{className}"',
        paramAfterKwargsParam: 'Der Parameter kann nicht auf den Parameter "**" folgen.',
        paramAlreadyAssigned: 'Der Parameter "{name}" ist bereits zugewiesen.',
        paramAnnotationMissing: 'Typanmerkung fehlt f\xFCr Parameter "{name}"',
        paramAssignmentMismatch: 'Ein Ausdruck vom Typ "{sourceType}" kann keinem Parameter vom Typ "{paramType}" zugewiesen werden.',
        paramNameMissing: 'Kein Parameter mit dem Namen "{name}"',
        paramSpecArgsKwargsDuplicate: 'Es wurden bereits Argumente f\xFCr ParamSpec "{type}" bereitgestellt',
        paramSpecArgsKwargsUsage: "Die Attribute \u201Eargs\u201C und \u201Ekwargs\u201C von ParamSpec m\xFCssen beide innerhalb einer Funktionssignatur auftreten",
        paramSpecArgsMissing: 'Argumente f\xFCr ParamSpec "{type}" fehlen.',
        paramSpecArgsUsage: "Das Attribut \u201Eargs\u201C von ParamSpec ist nur g\xFCltig, wenn es mit dem Parameter \u201E*args\u201C verwendet wird",
        paramSpecAssignedName: 'ParamSpec muss einer Variablen mit dem Namen "{name}" zugewiesen werden.',
        paramSpecContext: "ParamSpec ist in diesem Kontext nicht zul\xE4ssig.",
        paramSpecDefaultNotTuple: "Es wurde ein Auslassungszeichen, ein tuple Ausdruck oder ParamSpec f\xFCr den Standardwert von ParamSpec erwartet.",
        paramSpecFirstArg: "Der Name von ParamSpec wurde als erstes Argument erwartet.",
        paramSpecKwargsUsage: "Das Attribut \u201Ekwargs\u201C von ParamSpec ist nur g\xFCltig, wenn es mit dem Parameter \u201E**kwargs\u201C verwendet wird",
        paramSpecNotUsedByOuterScope: 'ParamSpec "{name}" hat in diesem Kontext keine Bedeutung.',
        paramSpecUnknownArg: "ParamSpec unterst\xFCtzt nur ein Argument.",
        paramSpecUnknownMember: "\u201E{name}\u201C ist kein bekanntes Attribut von ParamSpec",
        paramSpecUnknownParam: '"{name}" ist ein unbekannter Parameter f\xFCr ParamSpec.',
        paramTypeCovariant: 'Eine Variable vom Typ "Covariant" kann nicht im Parametertyp verwendet werden.',
        paramTypePartiallyUnknown: 'Der Typ des Parameters "{paramName}" ist teilweise unbekannt.',
        paramTypeUnknown: 'Der Typ des Parameters "{paramName}" ist unbekannt.',
        parenthesizedContextManagerIllegal: 'Parentheses within "with" statement requires Python 3.9 or newer',
        patternNeverMatches: 'Das Muster wird f\xFCr den Antragstellertyp "{type}" nie abgeglichen',
        positionArgAfterNamedArg: "Ein Positionsargument darf nicht nach Schl\xFCsselwortargumenten stehen.",
        positionArgAfterUnpackedDictArg: "Das positionelle Argument kann nach dem Entpacken des Schl\xFCsselwortarguments nicht mehr angezeigt werden.",
        positionOnlyAfterArgs: 'Das Parametertrennzeichen "Nur Position" ist nach dem Parameter "*" nicht zul\xE4ssig.',
        positionOnlyAfterKeywordOnly: 'Der Parameter "/" muss vor dem Parameter "*" stehen.',
        positionOnlyAfterNon: 'Der Parameter "Nur Position" ist nach einem Parameter, der nicht vom Typ "Nur Position" ist, nicht zul\xE4ssig.',
        positionOnlyFirstParam: 'Das Parametertrennzeichen "Nur Position" ist als erster Parameter nicht zul\xE4ssig.',
        positionOnlyIncompatible: 'F\xFCr das Parametertrennzeichen "Nur Position" ist Python\xA03.8 oder h\xF6her erforderlich.',
        privateImportFromPyTypedModule: '"{name}" wird nicht aus dem Modul "{module}" exportiert.',
        privateUsedOutsideOfClass: '"{name}" ist privat und wird au\xDFerhalb der Klasse verwendet, in dem es deklariert ist.',
        privateUsedOutsideOfModule: '"{name}" ist privat und wird au\xDFerhalb des Moduls verwendet, in dem es deklariert ist.',
        propertyOverridden: '"{name}" \xFCberschreibt property desselben Namens in der Klasse "{className}" nicht ordnungsgem\xE4\xDF',
        propertyStaticMethod: "Statische Methoden sind f\xFCr property getter, setter oder deleter nicht zul\xE4ssig.",
        protectedUsedOutsideOfClass: '"{name}" ist gesch\xFCtzt und wird au\xDFerhalb der Klasse verwendet, in der es deklariert ist.',
        protocolBaseClass: 'Die Protocol-Klasse "{classType}" kann nicht von einer non-Protocol-Klasse "{baseType}" abgeleitet werden',
        protocolBaseClassWithTypeArgs: "Typargumente sind mit der Protocol Klasse nicht zul\xE4ssig, wenn die Typparametersyntax verwendet wird.",
        protocolIllegal: 'Die Verwendung von "Protocol" erfordert Python 3.7 oder h\xF6her.',
        protocolNotAllowed: '"Protocol" kann in diesem Kontext nicht verwendet werden.',
        protocolTypeArgMustBeTypeParam: "Das Typargument f\xFCr \u201EProtocol\u201C muss ein Typparameter sein.",
        protocolUnsafeOverlap: "Die Klasse \xFCberlappt unsicher mit \u201E{name}\u201C und k\xF6nnte zur Laufzeit eine \xDCbereinstimmung erzeugen.",
        protocolVarianceContravariant: 'Die Typvariable "{variable}", die im generischen Protocol "{class}" verwendet wird, muss "contravariant" sein.',
        protocolVarianceCovariant: 'Die Typvariable "{variable}", die im generischen Protocol "{class}" verwendet wird, muss "covariant" sein.',
        protocolVarianceInvariant: 'Die Typvariable "{variable}", die im generischen Protocol "{class}" verwendet wird, muss "invariant" sein.',
        pyrightCommentInvalidDiagnosticBoolValue: 'Auf die Pyright-Kommentardirektive muss "=" und der Wert "true" oder "false" folgen.',
        pyrightCommentInvalidDiagnosticSeverityValue: 'Auf die Pyright-Kommentardirektive muss "=" und der Wert "true", "false", "error", "warning", "information" oder "none" folgen.',
        pyrightCommentMissingDirective: "Auf einen Pyright-Kommentar muss eine Direktive (basic oder strict) oder eine Diagnoseregel folgen.",
        pyrightCommentNotOnOwnLine: "Pyright-Kommentare, die zum Steuern von Einstellungen auf Dateiebene verwendet werden, m\xFCssen in ihrer eigenen Zeile angezeigt werden.",
        pyrightCommentUnknownDiagnosticRule: '"{rule}" ist eine unbekannte Diagnoseregel f\xFCr pyright-Kommentar.',
        pyrightCommentUnknownDiagnosticSeverityValue: '"{value}" ist ein ung\xFCltiger Wert f\xFCr den pyright-Kommentar; "true", "false", "error", "warning", "information" oder "none" erwartet.',
        pyrightCommentUnknownDirective: '"{directive}" is an unknown directive for pyright comment; expected "strict", "standard", or "basic"',
        readOnlyArgCount: 'Nach "ReadOnly" wurde ein einzelnes Typargument erwartet.',
        readOnlyNotInTypedDict: '"ReadOnly" ist in diesem Kontext nicht zul\xE4ssig.',
        recursiveDefinition: 'Der Typ von "{name}" konnte nicht bestimmt werden, da er sich auf selbst bezieht.',
        relativeImportNotAllowed: 'Relative Importe k\xF6nnen nicht mit dem Formular "import .a" verwendet werden; verwenden Sie stattdessen "from . import a"',
        requiredArgCount: 'Nach "Required" wurde ein einzelnes Typargument erwartet.',
        requiredNotInTypedDict: '"Required" ist in diesem Kontext nicht zul\xE4ssig.',
        returnInAsyncGenerator: "Eine Return-Anweisung mit einem Wert ist im asynchronen Generator nicht zul\xE4ssig.",
        returnInExceptionGroup: "\u201Ereturn\u201C ist in einem \u201Eexcept*\u201C Block nicht zul\xE4ssig.",
        returnMissing: 'Die Funktion mit dem deklarierten R\xFCckgabetyp "{returnType}" muss einen Wert f\xFCr alle Codepfade zur\xFCckgeben.',
        returnOutsideFunction: '"return" kann nur innerhalb einer Funktion verwendet werden.',
        returnTypeContravariant: 'Die Variable vom Typ "contravariant" kann nicht im R\xFCckgabetyp verwendet werden.',
        returnTypeMismatch: "Der Typ \u201E{exprType}\u201C kann dem R\xFCckgabetyp \u201E{returnType}\u201C nicht zugewiesen werden",
        returnTypePartiallyUnknown: 'Der R\xFCckgabetyp "{returnType}" ist teilweise unbekannt.',
        returnTypeUnknown: "Unbekannter R\xFCckgabetyp",
        revealLocalsArgs: 'Es wurden keine Argumente f\xFCr den Aufruf "reveal_locals" erwartet.',
        revealLocalsNone: "Keine locals Elemente in diesem Bereich",
        revealTypeArgs: 'F\xFCr den Aufruf "reveal_type" wurde ein einzelnes Positionsargument erwartet.',
        revealTypeExpectedTextArg: 'Das Argument "expected_text" f\xFCr die Funktion "reveal_type" muss ein str-Literalwert sein.',
        revealTypeExpectedTextMismatch: 'Typentextkonflikt; "{expected}" erwartet, aber "{received}" empfangen',
        revealTypeExpectedTypeMismatch: 'Typenkonflikt; "{expected}" erwartet, aber "{received}" empfangen',
        selfTypeContext: '"Self" ist in diesem Kontext ung\xFCltig.',
        selfTypeMetaclass: "\u201ESelf\u201C kann nicht innerhalb einer Metaklasse (einer Unterklasse von \u201Etype\u201C) verwendet werden.",
        selfTypeWithTypedSelfOrCls: '"Self" kann nicht in einer Funktion mit einem Parameter "self" oder "cls" verwendet werden, der eine andere Typanmerkung als "Self" aufweist.',
        sentinelBadName: "The first argument to Sentinel must be a string literal",
        sentinelNameMismatch: "Sentinel must be assigned to a variable with the same name",
        sentinelParamCount: "Sentinel requires one positional argument",
        setterGetterTypeMismatch: "Der Property setter Werttyp kann dem getter R\xFCckgabetyp nicht zugewiesen werden.",
        singleOverload: '"{name}" ist als \xDCberladung markiert, aber es fehlen weitere \xDCberladungen.',
        slotsAttributeError: '"{name}" ist in __slots__ nicht angegeben.',
        slotsClassVarConflict: '"{name}" steht in Konflikt mit Instanzvariablen, die in __slots__ deklariert sind.',
        starPatternInAsPattern: 'Das Sternmuster kann nicht mit dem Ziel "as" verwendet werden.',
        starPatternInOrPattern: "Das Sternmuster kann in anderen Mustern nicht ORed sein.",
        starStarWildcardNotAllowed: '** kann nicht zusammen mit Platzhalter "_" verwendet werden',
        staticClsSelfParam: 'Statische Methoden d\xFCrfen keinen "self"- oder "cls"-Parameter annehmen.',
        stringNonAsciiBytes: "Ein Nicht-ASCII-Zeichen ist im Zeichenfolgenliteral in Bytes nicht zul\xE4ssig.",
        stringNotSubscriptable: "Der Zeichenfolgenausdruck kann im Typausdruck nicht tiefgestellt werden; schlie\xDFen Sie den samten Ausdruck in Anf\xFChrungszeichen ein",
        stringUnsupportedEscape: "Nicht unterst\xFCtzte Escapesequenz im Zeichenfolgenliteral.",
        stringUnterminated: "Das Zeichenfolgenliteral ist nicht beendet.",
        stubFileMissing: 'Die Stubdatei wurde f\xFCr "{importName}" nicht gefunden.',
        stubUsesGetAttr: 'Die Typ-Stub-Datei ist unvollst\xE4ndig; "__getattr__" verdeckt Typfehler f\xFCr Modul',
        sublistParamsIncompatible: "Sublist Parameter werden in Python 3.x nicht unterst\xFCtzt.",
        superCallArgCount: "Es werden nicht mehr als zwei Argumente f\xFCr den \u201Esuper\u201C Aufruf erwartet.",
        superCallFirstArg: 'Klassentyp als erstes Argument f\xFCr super-Aufruf erwartet, aber "{type}" empfangen',
        superCallSecondArg: 'Das zweite Argument f\xFCr den "super"-Aufruf muss ein Objekt oder eine Klasse sein, das bzw. die von "{type}" abgeleitet wird.',
        superCallZeroArgForm: "Die Nullargumentform des \u201Esuper\u201C Aufrufs ist nur innerhalb einer Methode g\xFCltig.",
        superCallZeroArgFormStaticMethod: "Die Nullargumentform des \u201Esuper\u201C Aufrufs ist nicht innerhalb einer statischen Methode g\xFCltig.",
        symbolIsPossiblyUnbound: '"{name}" ist m\xF6glicherweise ungebunden.',
        symbolIsUnbound: '"{name}" ist ungebunden.',
        symbolIsUndefined: '"{name}" ist nicht definiert.',
        symbolOverridden: '"{name}" \xFCberschreibt das Symbol desselben Namens in der Klasse "{className}"',
        templateStringBytes: "Template string literals (t-strings) cannot be binary",
        templateStringIllegal: "Template string literals (t-strings) require Python 3.14 or newer",
        templateStringUnicode: "Template string literals (t-strings) cannot be unicode",
        ternaryNotAllowed: "Der tern\xE4re Ausdruck ist im Typausdruck nicht zul\xE4ssig",
        totalOrderingMissingMethod: 'Die Klasse muss "__lt__", "__le__", "__gt__" oder "__ge__" definieren, um total_ordering zu verwenden.',
        trailingCommaInFromImport: "Nachgestelltes Komma ist ohne umgebende Klammern nicht zul\xE4ssig.",
        tryWithoutExcept: "Die try-Anweisung muss mindestens eine except- oder finally-Klausel aufweisen.",
        tupleAssignmentMismatch: 'Ein Ausdruck vom Typ "{type}" kann dem Ziel-tuple nicht zugewiesen werden.',
        tupleInAnnotation: "Der Tuple-ausdruck ist im Typausdruck nicht zul\xE4ssig",
        tupleIndexOutOfRange: "Der Index {index} liegt f\xFCr den Typ {type} au\xDFerhalb des g\xFCltigen Bereichs.",
        typeAliasIllegalExpressionForm: "Ung\xFCltiges Ausdrucksformular f\xFCr Typaliasdefinition",
        typeAliasIsRecursiveDirect: 'Der Typalias "{name}" kann sich nicht selbst in seiner Definition verwenden.',
        typeAliasNotInModuleOrClass: "TypeAlias kann nur innerhalb eines Moduls oder Klassenbereichs definiert werden.",
        typeAliasRedeclared: '"{name}" ist als TypeAlias deklariert und kann nur einmal zugewiesen werden.',
        typeAliasStatementBadScope: "Eine type Anweisung kann nur innerhalb eines Moduls oder Klassenbereichs verwendet werden.",
        typeAliasStatementIllegal: "Die Typaliasanweisung erfordert Python 3.12 oder h\xF6her.",
        typeAliasTypeBadScope: "Ein Typalias kann nur innerhalb eines Modul- oder Klassenbereichs definiert werden.",
        typeAliasTypeBaseClass: 'Ein in einer "type"-Anweisung definierter type Alias kann nicht als Basisklasse verwendet werden.',
        typeAliasTypeMustBeAssigned: "TypeAliasType muss einer Variablen mit dem gleichen Namen wie der Typalias zugewiesen werden.",
        typeAliasTypeNameArg: "Das erste Argument f\xFCr TypeAliasType muss ein Zeichenfolgenliteral sein, das den Namen des Typalias darstellt.",
        typeAliasTypeNameMismatch: "Der Name des Typalias muss mit dem Namen der Variablen \xFCbereinstimmen, der er zugewiesen ist.",
        typeAliasTypeParamInvalid: "Die Typparameterliste muss tuple sein, das nur TypeVar, TypeVarTuple oder ParamSpec enth\xE4lt.",
        typeAnnotationCall: "Der Aufrufausdruck ist im Typausdruck nicht zul\xE4ssig",
        typeAnnotationVariable: "Variable im Typausdruck nicht zul\xE4ssig",
        typeAnnotationWithCallable: 'Das Typargument f\xFCr "type" muss eine Klasse sein. Aufrufbare Elemente werden nicht unterst\xFCtzt.',
        typeArgListExpected: "ParamSpec, Ellipse oder list der Typen erwartet",
        typeArgListNotAllowed: "Der Listenausdruck ist f\xFCr dieses Typargument nicht zul\xE4ssig.",
        typeArgsExpectingNone: 'F\xFCr die Klasse "{name}" werden keine Typargumente erwartet.',
        typeArgsMismatchOne: "Es wurde ein Typargument erwartet, es wurde jedoch {received} empfangen.",
        typeArgsMissingForAlias: 'F\xFCr den generischen Typalias "{name}" werden Typargumente erwartet.',
        typeArgsMissingForClass: 'F\xFCr die generische Klasse "{name}" werden Typargumente erwartet.',
        typeArgsTooFew: 'F\xFCr "{name}" wurden zu wenige Typargumente angegeben; {expected} erwartet, aber {received} empfangen',
        typeArgsTooMany: 'F\xFCr "{name}" wurden zu viele Typargumente angegeben; {expected} erwartet, aber {received} empfangen',
        typeAssignmentMismatch: "Der Typ \u201E{sourceType}\u201C kann dem deklarierten Typ \u201E{destType}\u201C nicht zugewiesen werden",
        typeAssignmentMismatchWildcard: "Das Importsymbol \u201E{name}\u201C weist den Typ \u201E{sourceType}\u201C auf, der dem deklarierten Typ \u201E{destType}\u201C nicht zugewiesen werden kann.",
        typeCallNotAllowed: "Der type()-Aufruf darf nicht im Typausdruck verwendet werden",
        typeCheckOnly: '"{name}" ist als @type_check_only markiert und kann nur in Typanmerkungen verwendet werden.',
        typeCommentDeprecated: "Die Verwendung von type Kommentaren ist veraltet; verwenden Sie stattdessen type Anmerkung",
        typeExpectedClass: "Die Klasse wurde erwartet, aber \u201E{type}\u201C wurde empfangen.",
        typeFormArgs: "\u201ETypeForm\u201C akzeptiert ein einzelnes positionelles Argument",
        typeGuardArgCount: 'Nach "TypeGuard" oder "TypeIs" wurde ein einzelnes Typargument erwartet.',
        typeGuardParamCount: "Benutzerdefinierte Typenschutzfunktionen und -methoden m\xFCssen mindestens einen Eingabeparameter aufweisen.",
        typeIsReturnType: 'Der R\xFCckgabetyp von TypeIs ("{returnType}") ist nicht konsistent mit dem Wertparametertyp ("{type}").',
        typeNotAwaitable: '"{type}" ist nicht awaitable.',
        typeNotIntantiable: '"{type}" kann nicht instanziiert werden.',
        typeNotIterable: '"{type}" ist nicht iterierbar.',
        typeNotSpecializable: 'Der Typ "{type}" konnte nicht spezialisiert werden',
        typeNotSubscriptable: 'Das Objekt vom Typ "{type}" kann nicht tiefgestellt werden.',
        typeNotSupportBinaryOperator: 'Der Operator "{operator}" wird f\xFCr Typen "{leftType}" und "{rightType}" nicht unterst\xFCtzt.',
        typeNotSupportBinaryOperatorBidirectional: 'Der Operator "{operator}" wird f\xFCr die Typen "{leftType}" und "{rightType}" nicht unterst\xFCtzt, wenn der erwartete Typ "{expectedType}" ist.',
        typeNotSupportUnaryOperator: 'Der Operator "{operator}" wird f\xFCr den Typ "{type}" nicht unterst\xFCtzt.',
        typeNotSupportUnaryOperatorBidirectional: 'Der Operator "{operator}" wird f\xFCr den Typ "{type}" nicht unterst\xFCtzt, wenn der erwartete Typ "{expectedType}" ist.',
        typeNotUsableWith: "Das Objekt vom Typ \u201E{type}\u201C kann nicht mit \u201Ewith\u201C verwendet werden, da es {method} nicht ordnungsgem\xE4\xDF implementiert.",
        typeNotUsableWithAsync: "Das Objekt vom Typ \u201E{type}\u201C kann nicht mit \u201Easynch with\u201C verwendet werden, da es {method} nicht ordnungsgem\xE4\xDF implementiert.",
        typeParameterBoundNotAllowed: '"Bound" oder "constraint" kann nicht mit einem variadic-Typparameter oder ParamSpec verwendet werden.',
        typeParameterConstraintTuple: "Die Typparametereinschr\xE4nkung muss ein Tupel mit mindestens zwei Typen sein.",
        typeParameterExistingTypeParameter: 'Der Typparameter "{name}" wird bereits verwendet.',
        typeParameterNotDeclared: 'Der Typparameter "{name}" ist nicht in der Typparameterliste f\xFCr "{container}" enthalten.',
        typeParametersMissing: "Es muss mindestens ein Typparameter angegeben werden.",
        typePartiallyUnknown: 'Der Typ von "{name}" ist teilweise unbekannt.',
        typeUnknown: 'Der Typ von "{name}" ist unbekannt.',
        typeVarAssignedName: 'TypeVar muss einer Variablen mit dem Namen "{name}" zugewiesen werden.',
        typeVarAssignmentMismatch: 'Der Typ "{type}" kann der Typvariablen "{name}" nicht zugewiesen werden.',
        typeVarBoundAndConstrained: "TypeVar kann nicht gleichzeitig gebunden und eingeschr\xE4nkt sein.",
        typeVarBoundGeneric: 'Der gebundene Typ "TypeVar" darf nicht generisch sein.',
        typeVarConstraintGeneric: "Der Typ der TypeVar-Einschr\xE4nkung darf nicht generisch sein.",
        typeVarDefaultBoundMismatch: 'Der Standardtyp "TypeVar" muss ein Untertyp des gebundenen Typs sein.',
        typeVarDefaultConstraintMismatch: 'Der Standardtyp "TypeVar" muss einer der eingeschr\xE4nkten Typen sein.',
        typeVarDefaultIllegal: "F\xFCr Standardtypen von Typvariablen ist Python 3.13 oder h\xF6her erforderlich.",
        typeVarDefaultInvalidTypeVar: 'Der Typparameter "{name}" weist einen Standardtyp auf, der auf eine oder mehrere Typvariablen verweist, die au\xDFerhalb des G\xFCltigkeitsbereichs liegen.',
        typeVarFirstArg: "Der Name von TypeVar wurde als erstes Argument erwartet.",
        typeVarInvalidForMemberVariable: 'Der Attributtyp kann keine Typvariable "{name}" verwenden, die auf die lokale Methode festgelegt ist.',
        typeVarNoMember: "TypeVar \u201E{type}\u201C weist kein Attribut \u201E{name}\u201C auf",
        typeVarNotSubscriptable: 'TypeVar "{type}" kann nicht tiefgestellt werden.',
        typeVarNotUsedByOuterScope: 'Die Typvariable "{name}" hat in diesem Kontext keine Bedeutung.',
        typeVarPossiblyUnsolvable: 'Die Typvariable "{name}" wird m\xF6glicherweise nicht aufgel\xF6st, wenn der Aufrufer kein Argument f\xFCr Parameter "{param}" bereitstellt',
        typeVarSingleConstraint: "TypeVar muss mindestens zwei eingeschr\xE4nkte Typen aufweisen.",
        typeVarTupleConstraints: "TypeVarTuple darf keine Werteinschr\xE4nkungen aufweisen.",
        typeVarTupleContext: "TypeVarTuple ist in diesem Kontext nicht zul\xE4ssig.",
        typeVarTupleDefaultNotUnpacked: 'Der Standardtyp "TypeVarTuple" muss entpacktes tuple oder ein TypeVarTuple sein.',
        typeVarTupleMustBeUnpacked: "Der Entpackungsoperator ist f\xFCr den TypeVarTuple-Wert erforderlich.",
        typeVarTupleUnknownParam: '"{name}" ist ein unbekannter Parameter f\xFCr TypeVarTuple.',
        typeVarUnknownParam: '"{name}" ist ein unbekannter Parameter f\xFCr TypeVar.',
        typeVarUsedByOuterScope: 'TypeVar "{name}" wird bereits von einem \xE4u\xDFeren Bereich verwendet.',
        typeVarUsedOnlyOnce: 'TypeVar "{name}" wird in der generischen Funktionssignatur nur einmal angezeigt.',
        typeVarVariance: 'TypeVar darf nicht gleichzeitig "covariant" und "contravariant" sein.',
        typeVarWithDefaultFollowsVariadic: "TypeVar \u201E{typeVarName}\u201C weist einen Standardwert auf und kann TypeVarTuple \u201E{variadicName}\u201C nicht folgen.",
        typeVarWithoutDefault: '"{name}" kann nicht nach "{other}" in der Typparameterliste angezeigt werden, da es keinen Standardtyp aufweist.',
        typeVarsNotInGenericOrProtocol: "Generic[] oder Protocol[] m\xFCssen alle Typvariablen enthalten.",
        typedDictAccess: "Auf das Element in TypedDict konnte nicht zugegriffen werden.",
        typedDictAssignedName: "TypedDict muss einer Variablen mit dem Namen \u201E{name}\u201C zugewiesen werden.",
        typedDictBadVar: "TypedDict-Klassen d\xFCrfen nur Typanmerkungen enthalten.",
        typedDictBaseClass: "Alle Basisklassen f\xFCr TypedDict-Klassen m\xFCssen auch TypedDict-Klassen sein.",
        typedDictBoolParam: 'Es wird erwartet, dass "{name}" Parameter den Wert "True" oder "False" aufweist.',
        typedDictClosedExtras: 'Die Basisklasse "{name}" ist eine TypedDict, die den Typ zus\xE4tzlicher Elemente auf den Typ "{type}" beschr\xE4nkt.',
        typedDictClosedFalseNonOpenBase: 'Base class "{name}" is not an open TypedDict; closed=False is not allowed',
        typedDictClosedNoExtras: "Die Basisklasse \u201E{name}\u201C ist ein closed TypedDict; zus\xE4tzliche Elemente sind nicht zul\xE4ssig.",
        typedDictDelete: "Das Element in TypedDict konnte nicht gel\xF6scht werden.",
        typedDictEmptyName: "Namen innerhalb eines TypedDict d\xFCrfen nicht leer sein.",
        typedDictEntryName: "F\xFCr den W\xF6rterbucheintragsnamen wurde ein Zeichenfolgenliteral erwartet.",
        typedDictEntryUnique: "Namen innerhalb eines W\xF6rterbuchs m\xFCssen eindeutig sein.",
        typedDictExtraArgs: "Zus\xE4tzliche TypedDict-Argumente werden nicht unterst\xFCtzt.",
        typedDictExtraItemsClosed: 'TypedDict k\xF6nnen entweder "closed" oder "extra_items" verwenden, aber nicht beides.',
        typedDictFieldNotRequiredRedefinition: "Das TypedDict-Element \u201E{name}\u201C kann nicht als \u201ENotRequired\u201C neu definiert werden.",
        typedDictFieldReadOnlyRedefinition: "Das TypedDict-Element \u201E{name}\u201C kann nicht als \u201EReadOnly\u201C neu definiert werden.",
        typedDictFieldRequiredRedefinition: "Das TypedDict-Element \u201E{name}\u201C kann nicht als \u201ERequired\u201C neu definiert werden.",
        typedDictFirstArg: 'Der Klassenname "TypedDict" wird als erstes Argument erwartet.',
        typedDictInClassPattern: "Die TypedDict-Klasse ist im Klassenmuster nicht zul\xE4ssig.",
        typedDictInitsubclassParameter: "TypedDict unterst\xFCtzt __init_subclass__ Parameter \u201E{name}\u201C nicht.",
        typedDictNotAllowed: '"TypedDict" kann in diesem Kontext nicht verwendet werden.',
        typedDictSecondArgDict: "Es wird ein dict- oder Schl\xFCsselwortparameter als zweiter Parameter erwartet.",
        typedDictSecondArgDictEntry: "Einfacher W\xF6rterbucheintrag erwartet",
        typedDictSet: "Element konnte in TypedDict nicht zugewiesen werden.",
        unaccessedClass: 'Auf Klasse "{name}" wird nicht zugegriffen',
        unaccessedFunction: 'Auf Funktion "{name}" wird nicht zugegriffen',
        unaccessedImport: 'Auf Import "{name}" wird nicht zugegriffen',
        unaccessedSymbol: 'Auf "{name}" wird nicht zugegriffen',
        unaccessedVariable: 'Auf Variable "{name}" wird nicht zugegriffen',
        unannotatedFunctionSkipped: 'Die Analyse der Funktion "{name}" wird \xFCbersprungen, da sie nicht kommentiert wurde.',
        unaryOperationNotAllowed: "Der un\xE4re Operator ist im Typausdruck nicht zul\xE4ssig",
        unexpectedAsyncToken: 'Es wurde erwartet, dass "def", "with" oder "for" auf "async" folgt.',
        unexpectedEof: "Unexpected EOF",
        unexpectedExprToken: "Unerwartetes Token am Ende des Ausdrucks.",
        unexpectedIndent: "Unerwarteter Einzug",
        unexpectedUnindent: '"Unindent" nicht erwartet.',
        unhashableDictKey: "Der W\xF6rterbuchschl\xFCssel muss hashbar sein.",
        unhashableSetEntry: 'Der Eintrag "Set" muss hashbar sein.',
        uninitializedAbstractVariables: 'In der abstrakten Basisklasse definierte Variablen sind in der final Klasse "{classType}" nicht initialisiert',
        uninitializedInstanceVariable: 'Die Instanzvariable "{name}" ist im Klassentext oder in der __init__ Methode nicht initialisiert.',
        unionForwardReferenceNotAllowed: "Die Unionsyntax kann nicht mit einem Zeichenfolgenoperanden verwendet werden; verwenden Sie Anf\xFChrungszeichen um den gesamten Ausdruck",
        unionSyntaxIllegal: "Alternative Syntax f\xFCr Unions erfordert Python 3.10 oder h\xF6her.",
        unionTypeArgCount: "Union erfordert mindestens zwei Typargumente.",
        unionUnpackedTuple: "Union kann kein entpacktes tuple enthalten.",
        unionUnpackedTypeVarTuple: "Die Union kann kein entpacktes TypeVarTuple enthalten.",
        unnecessaryCast: 'Nicht erforderlicher "cast"-Aufruf; der Typ ist bereits "{type}".',
        unnecessaryIsInstanceAlways: 'Nicht erforderlicher isinstance-Aufruf; "{testType}" ist immer eine Instanz von "{classType}"',
        unnecessaryIsInstanceNever: 'Nicht erforderlicher isinstance-Aufruf; "{testType}" ist nie eine Instanz von "{classType}"',
        unnecessaryIsSubclassAlways: 'Nicht erforderlicher issubclass-Aufruf; "{testType}" ist immer eine Unterklasse von "{classType}"',
        unnecessaryIsSubclassNever: 'Nicht erforderlicher issubclass-Aufruf; "{testType}" ist nie eine Unterklasse von "{classType}"',
        unnecessaryPyrightIgnore: 'Unn\xF6tiger "# pyright: ignore"-Kommentar',
        unnecessaryPyrightIgnoreRule: 'Unn\xF6tiger "# pyright: ignore"-Regel: "{name}"',
        unnecessaryTypeIgnore: 'Nicht erforderlicher "# type: ignore"-Kommentar',
        unpackArgCount: 'Nach "Unpack" wurde ein einzelnes Typargument erwartet.',
        unpackExpectedTypeVarTuple: "\u201ETypeVarTuple\u201C oder \u201Etuple\u201C als Typargument f\xFCr \u201EUnpack\u201C erwartet",
        unpackExpectedTypedDict: "TypedDict-Typargument f\xFCr Unpack erwartet",
        unpackIllegalInComprehension: "Der Entpackvorgang ist in Verst\xE4ndnis nicht zul\xE4ssig.",
        unpackInAnnotation: "Der Operator zum Entpacken ist im Typausdruck nicht zul\xE4ssig",
        unpackInDict: "Der Entpackvorgang ist in W\xF6rterb\xFCchern nicht zul\xE4ssig.",
        unpackInSet: "Der Operator zum Entpacken ist innerhalb einer Menge \u201Eset\u201C nicht zul\xE4ssig.",
        unpackNotAllowed: '"Unpack" ist in diesem Kontext nicht zul\xE4ssig.',
        unpackOperatorNotAllowed: "Der Entpackvorgang ist in diesem Kontext nicht zul\xE4ssig.",
        unpackTuplesIllegal: "Der Entpackvorgang ist in Tupeln vor Python 3.8 nicht zul\xE4ssig.",
        unpackedArgInTypeArgument: "Nicht gepackte Argumente k\xF6nnen in diesem Kontext nicht verwendet werden.",
        unpackedArgWithVariadicParam: 'Das nicht gepackte Argument kann nicht f\xFCr den Parameter "TypeVarTuple" verwendet werden.',
        unpackedDictArgumentNotMapping: 'Der Argumentausdruck nach ** muss eine Zuordnung mit dem Schl\xFCsseltyp "str" sein.',
        unpackedDictSubscriptIllegal: "Der Operator zum Entpacken des W\xF6rterbuchs in tiefgestellten Zeichen ist nicht zul\xE4ssig.",
        unpackedSubscriptIllegal: "Das Entpacken des Operators im Tiefstellungsskript erfordert Python 3.11 oder h\xF6her.",
        unpackedTypeVarTupleExpected: "Nicht gepackter TypeVarTuple erwartet; verwenden Sie Unpack[{name1}] oder *{name2}",
        unpackedTypedDictArgument: "Das entpackte TypedDict-Argument kann nicht mit Parametern abgelichen werden.",
        unreachableCodeCondition: "Code is not analyzed because condition is statically evaluated as false",
        unreachableCodeStructure: "Code is structurally unreachable",
        unreachableCodeType: "Typanalyse weist darauf hin, dass Code nicht erreichbar ist",
        unreachableExcept: "Die except-Klausel ist nicht erreichbar, weil die Ausnahme bereits behandelt wird.",
        unsupportedDunderAllOperation: 'Der Vorgang f\xFCr "__all__" wird nicht unterst\xFCtzt, daher ist die exportierte Symbolliste m\xF6glicherweise falsch.',
        unusedCallResult: 'Das Ergebnis des Aufrufausdrucks ist vom Typ "{type}" und wird nicht verwendet; der Variablen "_" zuweisen, wenn dies beabsichtigt ist',
        unusedCoroutine: 'Das Ergebnis eines asynchronen Funktionsaufrufs wird nicht verwendet; verwenden Sie "await", oder weisen Sie der Variablen ein Ergebnis zu.',
        unusedExpression: "Der Ausdruckswert wird nicht verwendet.",
        varAnnotationIllegal: "Type Anmerkungen f\xFCr Variablen erfordern Python 3.6 oder h\xF6her; verwenden Sie den type Kommentar f\xFCr Kompatibilit\xE4t mit fr\xFCheren Versionen",
        variableFinalOverride: 'Die Variable "{name}" ist als "Final" gekennzeichnet und \xFCberschreibt die Nicht-Final-Variable desselben Namens in der Klasse "{className}"',
        variadicTypeArgsTooMany: "Die Liste der Typargumente darf h\xF6chstens ein entpacktes \u201ETypeVarTuple\u201C oder \u201Etuple\u201C enthalten.",
        variadicTypeParamTooManyAlias: "Der Typalias darf h\xF6chstens einen TypeVarTuple-Typparameter aufweisen, es wurden jedoch mehrere ({names}) empfangen.",
        variadicTypeParamTooManyClass: "Die generische Klasse darf h\xF6chstens einen TypeVarTuple-Typparameter aufweisen, es wurden jedoch mehrere ({names}) empfangen.",
        walrusIllegal: 'Der Operator ":=" erfordert Python 3.8 oder h\xF6her.',
        walrusNotAllowed: 'Der Operator ":=" ist in diesem Kontext ohne umgebende Klammern nicht zul\xE4ssig.',
        wildcardInFunction: "Der Platzhalterimport ist innerhalb einer Klasse oder Funktion nicht zul\xE4ssig.",
        wildcardLibraryImport: "Der Platzhalterimport aus einer Bibliothek ist nicht zul\xE4ssig.",
        wildcardPatternTypePartiallyUnknown: "Der durch das Platzhaltermuster erfasste Typ ist teilweise unbekannt.",
        wildcardPatternTypeUnknown: "Der durch das Platzhaltermuster erfasste Typ ist unbekannt.",
        yieldFromIllegal: 'Die Verwendung von "yield from" erfordert Python 3.3 oder h\xF6her.',
        yieldFromOutsideAsync: '"yield from" ist in einer asynchronen Funktion nicht zul\xE4ssig.',
        yieldOutsideFunction: '"yield" ist au\xDFerhalb einer Funktion oder eines Lambdas nicht zul\xE4ssig.',
        yieldWithinComprehension: "\u201Eyield\u201C ist innerhalb eines Verst\xE4ndnisses nicht zul\xE4ssig",
        zeroCaseStatementsFound: "Die match-Anweisung muss mindestens eine case-Anweisung enthalten",
        zeroLengthTupleNotAllowed: "Zero-length tuple is not allowed in this context"
      },
      DiagnosticAddendum: {
        annotatedNotAllowed: "Das Sonderformular \u201EAnnotated\u201C kann nicht mit Instanz- und Klassen\xFCberpr\xFCfungen verwendet werden.",
        argParam: 'Argument entspricht Parameter "{paramName}"',
        argParamFunction: 'Argument entspricht Parameter "{paramName}" in Funktion "{functionName}"',
        argsParamMissing: 'Der Parameter "*{paramName}" weist keinen entsprechenden Parameter auf.',
        argsPositionOnly: "Nicht \xFCbereinstimmende Parameteranmerkungsanzahl: {expected} erwartet, aber {received} empfangen",
        argumentType: 'Argumenttyp ist "{type}"',
        argumentTypes: "Argumenttypen: ({types})",
        assignToNone: "Der Typ kann nicht \u201ENone\u201C zugewiesen werden.",
        asyncHelp: 'Meinten Sie "async with"?',
        baseClassIncompatible: 'Die Basisklasse "{baseClass}" ist nicht mit dem Typ "{type}" kompatibel.',
        baseClassIncompatibleSubclass: 'Die Basisklasse "{baseClass}" wird von "{subclass}" abgeleitet, die mit dem Typ "{type}" nicht kompatibel ist.',
        baseClassOverriddenType: 'Die Basisklasse "{baseClass}" stellt einen Typ "{type}" bereit, der \xFCberschrieben wird.',
        baseClassOverridesType: 'Basisklasse "{baseClass}" \xFCberschreibt mit Typ "{type}"',
        bytesTypePromotions: 'Legen Sie disableBytesTypePromotions auf false fest, um das Typerweiterungsverhalten f\xFCr "bytearray" und "memoryview" zu aktivieren.',
        conditionalRequiresBool: 'Die Methode __bool__ f\xFCr den Typ "{operandType}" gibt den Typ "{boolReturnType}" anstelle von "bool" zur\xFCck',
        dataClassFieldLocation: "Felddeklaration",
        dataClassFrozen: '"{name}" ist fixiert',
        dataProtocolUnsupported: "\u201E{name}\u201C ist ein Datenprotokoll.",
        descriptorAccessBindingFailed: "Fehler beim Binden der Methode \u201E{name}\u201C f\xFCr die Deskriptorklasse \u201E{className}\u201C",
        descriptorAccessCallFailed: "Fehler beim Aufrufen der Methode \u201E{name}\u201C f\xFCr die Deskriptorklasse \u201E{className}\u201C",
        finalMethod: "Final Methode",
        functionParamDefaultMissing: 'Standardargument f\xFCr Parameter "{name}" fehlt.',
        functionParamName: 'Parameternamen stimmen nicht \xFCberein: "{destName}" und "{srcName}"',
        functionParamPositionOnly: "Nicht \xFCbereinstimmender Parameter \u201Enur f\xFCr Position\u201C. Der Parameter \u201E{name}\u201C ist nicht \u201Enur f\xFCr Position\u201C.",
        functionReturnTypeMismatch: 'Der Funktionsr\xFCckgabetyp "{sourceType}" ist nicht mit dem Typ "{destType}" kompatibel.',
        functionTooFewParams: "Die Funktion akzeptiert zu wenige Positionsparameter; {expected} erwartet, aber {received} empfangen",
        functionTooManyParams: "Die Funktion akzeptiert zu viele Positionsparameter; {expected} erwartet, aber {received} empfangen",
        genericClassNotAllowed: "Ein generischer Typ mit Typargumenten ist f\xFCr Instanz- oder Klassenpr\xFCfungen nicht zul\xE4ssig.",
        incompatibleDeleter: "Die deleter Methode der Property ist nicht kompatibel.",
        incompatibleGetter: "Die Property getter Methode ist nicht kompatibel.",
        incompatibleSetter: "Die Property setter Methode ist nicht kompatibel.",
        initMethodLocation: 'Die __init__ Methode ist in der Klasse "{type}" definiert.',
        initMethodSignature: 'Die Signatur von __init__ ist "{type}".',
        initSubclassLocation: 'Die __init_subclass__ Methode ist in der Klasse "{name}" definiert.',
        invariantSuggestionDict: 'Erw\xE4gen Sie den Wechsel von "dict" zu "Mapping" (im Werttyp covariant).',
        invariantSuggestionList: 'Erw\xE4gen Sie den Wechsel von "list" zu "Sequence" (covariant).',
        invariantSuggestionSet: "Erw\xE4gen Sie den Wechsel von \u201Eset\u201C zu \u201EContainer\u201C, der Kovariante ist.",
        isinstanceClassNotSupported: "\u201E{type}\u201C wird f\xFCr Instanz- und Klassen\xFCberpr\xFCfungen nicht unterst\xFCtzt.",
        keyNotRequired: '"{name}" ist kein erforderlicher Schl\xFCssel in "{type}". Der Zugriff kann daher zu einer Laufzeitausnahme f\xFChren.',
        keyReadOnly: '"{name}" ist ein schreibgesch\xFCtzter Schl\xFCssel in "{type}"',
        keyRequiredDeleted: '"{name}" ist ein erforderlicher Schl\xFCssel und kann nicht gel\xF6scht werden.',
        keyUndefined: '"{name}" ist kein definierter Schl\xFCssel in "{type}"',
        kwargsParamMissing: 'Der Parameter "**{paramName}" weist keinen entsprechenden Parameter auf.',
        listAssignmentMismatch: 'Der Typ "{type}" ist nicht mit der Zielliste kompatibel.',
        literalAssignmentMismatch: "\u201E{sourceType}\u201C kann dem Typ \u201E{destType}\u201C nicht zugewiesen werden.",
        literalNotAllowed: "Das Sonderformular \u201ELiteral\u201C kann nicht mit Instanz- und Klassen\xFCberpr\xFCfungen verwendet werden.",
        matchIsNotExhaustiveHint: 'Wenn keine ausf\xFChrliche Behandlung beabsichtigt ist, f\xFCgen Sie "case _: pass" hinzu.',
        matchIsNotExhaustiveType: 'Unbehandelter Typ: "{type}"',
        memberAssignment: "Ein Ausdruck vom Typ \u201E{type}\u201C kann dem Attribut \u201E{name}\u201C der Klasse \u201E{classType}\u201C nicht zugewiesen werden",
        memberIsAbstract: "\u201E{type}. {name}\u201C ist nicht implementiert.",
        memberIsAbstractMore: "und {count} weitere...",
        memberIsClassVarInProtocol: "\u201E{name}\u201C ist als ClassVar im Protokoll definiert.",
        memberIsInitVar: "\u201E{name}\u201C ist ein init-only-Feld.",
        memberIsInvariant: '"{name}" ist invariant, da es \xE4nderbar ist.',
        memberIsNotClassVarInClass: "\u201E{name}\u201C muss als ClassVar definiert sein, um mit dem Protokoll kompatibel zu sein.",
        memberIsNotClassVarInProtocol: "\u201E{name}\u201C ist nicht als ClassVar im Protokoll definiert.",
        memberIsNotReadOnlyInProtocol: '"{name}" ist im Protokoll nicht schreibgesch\xFCtzt.',
        memberIsReadOnlyInProtocol: '"{name}" ist im Protokoll schreibgesch\xFCtzt.',
        memberIsWritableInProtocol: '"{name}" ist im Protokoll beschreibbar.',
        memberSetClassVar: "Attribut \u201E{name}\u201C kann nicht \xFCber eine Klasseninstanz zugewiesen werden, da es sich um eine ClassVar handelt",
        memberTypeMismatch: '"{name}" ist ein inkompatibler Typ.',
        memberUnknown: "Das Attribut \u201E{name}\u201C ist unbekannt",
        metaclassConflict: 'Die Metaklasse "{metaclass1}" verursacht einen Konflikt mit "{metaclass2}"',
        missingDeleter: "Die Property deleter Methode fehlt.",
        missingGetter: "Die Property getter Methode fehlt.",
        missingSetter: "Die Property setter Methode fehlt.",
        namedParamMissingInDest: 'Zus\xE4tzlicher Parameter "{name}"',
        namedParamMissingInSource: 'Fehlender Schl\xFCsselwortparameter "{name}"',
        namedParamTypeMismatch: "Der Schl\xFCsselwortparameter \u201E{name}\u201C vom Typ \u201E{sourceType}\u201C ist nicht mit dem Typ \u201E{destType}\u201C kompatibel",
        namedTupleNotAllowed: "NamedTuple kann nicht f\xFCr Instanzen- oder Klassen\xFCberpr\xFCfungen verwendet werden.",
        newMethodLocation: 'Die __new__ Methode ist in der Klasse "{type}" definiert.',
        newMethodSignature: 'Signatur von __new__ ist "{type}"',
        newTypeClassNotAllowed: "Type created with NewType cannot be used with instance and class checks",
        noOverloadAssignable: 'Keine \xFCberladene Funktion stimmt mit dem Typ "{type}" \xFCberein.',
        noneNotAllowed: '"None" kann nicht f\xFCr Instanz- oder Klassenpr\xFCfungen verwendet werden.',
        orPatternMissingName: "Fehlende Namen: {name}",
        overloadIndex: '\xDCberladung "{index}" ist die n\xE4chste \xDCbereinstimmung.',
        overloadNotAssignable: 'Mindestens eine \xDCberladung von "{name}" kann nicht zugewiesen werden.',
        overloadSignature: "Die \xDCberladungssignatur ist hier definiert.",
        overriddenMethod: "\xDCberschriebene Methode",
        overriddenSymbol: "Au\xDFer Kraft gesetztes Symbol",
        overrideInvariantMismatch: 'Der \xDCberschreibungstyp "{overrideType}" ist nicht identisch mit dem Basistyp "{baseType}".',
        overrideIsInvariant: "Die Variable ist ver\xE4nderlich, sodass ihr Typ unver\xE4nderlich ist.",
        overrideNoOverloadMatches: "Keine \xDCberladungssignatur in \xDCberschreibung ist mit der Basismethode kompatibel.",
        overrideNotClassMethod: "Die Basismethode ist als classmethod deklariert, die \xDCberschreibung jedoch nicht",
        overrideNotInstanceMethod: "Die Basismethode ist als Instanz deklariert, die \xDCberschreibung jedoch nicht",
        overrideNotStaticMethod: "Die Basismethode ist als staticmethod deklariert, die \xDCberschreibung jedoch nicht",
        overrideOverloadNoMatch: "Au\xDFerkraftsetzung behandelt nicht alle \xDCberladungen der Basismethode.",
        overrideOverloadOrder: "\xDCberladungen f\xFCr die \xDCberschreibungsmethode m\xFCssen in der gleichen Reihenfolge wie die Basismethode vorliegen.",
        overrideParamKeywordNoDefault: 'Konflikt mit Schl\xFCsselwortparameter "{name}": Der Basisparameter hat einen Standardargumentwert, der Au\xDFerkraftsetzungsparameter ist nicht identisch.',
        overrideParamKeywordType: 'Schl\xFCsselwortparameter "{name}" Typenkonflikt: Basisparameter ist Typ "{baseType}", \xDCberschreibungsparameter ist Typ "{overrideType}"',
        overrideParamName: 'Namenskonflikt mit Parameter {index}: Der Basisparameter hat den Namen "{baseName}", der Au\xDFerkraftsetzungsparameter ist "{overrideName}"',
        overrideParamNameExtra: 'Der Parameter "{name}" fehlt in der Basis.',
        overrideParamNameMissing: 'Der Parameter "{name}" fehlt in der Au\xDFerkraftsetzung.',
        overrideParamNamePositionOnly: "Parameter \u201E{index}\u201C stimmt nicht \xFCberein: Basisparameter \u201E{baseName}\u201C ist Schl\xFCsselwortparameter, Au\xDFerkraftsetzungsparameter ist \u201Eposition-only\u201C.",
        overrideParamNoDefault: "Konflikt mit Parameter {index}: Der Basisparameter hat einen Standardargumentwert, der Au\xDFerkraftsetzungsparameter ist nicht identisch.",
        overrideParamType: 'Parameter {index} Typenkonflikt: Basisparameter ist Typ "{baseType}", \xDCberschreibungsparameter ist Typ "{overrideType}"',
        overridePositionalParamCount: "Anzahl der Positionsparameter stimmt nicht \xFCberein; die Basismethode hat {baseCount}, aber die \xDCberschreibung hat {overrideCount}",
        overrideReturnType: 'R\xFCckgabetypkonflikt: Basismethode gibt Typ "{baseType}" zur\xFCck, \xDCberschreibung gibt Typ "{overrideType}" zur\xFCck',
        overrideType: 'Die Basisklasse definiert den Typ als "{type}"',
        paramAssignment: "Parameter \u201E{index}\u201C: Typ \u201E{sourceType}\u201C ist nicht mit dem Typ \u201E{destType}\u201C kompatibel",
        paramSpecMissingInOverride: 'Parameter "ParamSpec" fehlen in der \xDCberschreibungsmethode.',
        paramType: 'Parametertyp ist "{paramType}"',
        privateImportFromPyTypedSource: 'Stattdessen aus "{module}" importieren',
        propertyAccessFromProtocolClass: "Auf eine in einer Protokollklasse definierte Eigenschaft kann nicht als Klassenvariable zugegriffen werden.",
        propertyMethodIncompatible: 'Die Property-Methode "{name}" ist inkompatibel.',
        propertyMethodMissing: 'Die Property-Methode "{name}" fehlt in der \xDCberschreibung.',
        propertyMissingDeleter: 'Property "{name}" hat keinen definierten deleter.',
        propertyMissingSetter: 'Property "{name}" hat keinen definierten setter.',
        protocolIncompatible: '"{sourceType}" ist nicht mit dem Protokoll "{destType}" kompatibel.',
        protocolMemberMissing: '"{name}" ist nicht vorhanden.',
        protocolRequiresRuntimeCheckable: "Die Protocol Klasse muss @runtime_checkable sein, damit sie mit Instanz- und Klassenpr\xFCfungen verwendet werden kann.",
        protocolSourceIsNotConcrete: '"{sourceType}" ist kein konkreter Klassentyp und kann dem Typ "{destType}" nicht zugewiesen werden.',
        protocolUnsafeOverlap: "Attribute von \u201E{name}\u201C weisen die gleichen Namen wie das Protokoll auf.",
        pyrightCommentIgnoreTip: 'Verwenden Sie "# pyright: ignore[<diagnostic rules>]", um die Diagnose f\xFCr eine einzelne Zeile zu unterdr\xFCcken.',
        readOnlyAttribute: 'Das Attribut "{name}" ist schreibgesch\xFCtzt.',
        seeClassDeclaration: "Siehe Klassendeklaration",
        seeDeclaration: "Siehe Deklaration",
        seeFunctionDeclaration: "Siehe Funktionsdeklaration",
        seeMethodDeclaration: "Siehe Methodendeklaration",
        seeParameterDeclaration: "Siehe Parameterdeklaration",
        seeTypeAliasDeclaration: "Siehe Typaliasdeklaration",
        seeVariableDeclaration: "Siehe Variablendeklaration",
        tupleAssignmentMismatch: 'Der Typ "{type}" ist nicht mit dem Ziel-tuple kompatibel.',
        tupleEntryTypeMismatch: "Der Tuple-eintrag {entry} ist ein falscher Typ.",
        tupleSizeIndeterminateSrc: "Nicht \xFCbereinstimmende Tuple Gr\xF6\xDFe; {expected} erwartet, aber unbestimmt empfangen",
        tupleSizeIndeterminateSrcDest: "Nicht \xFCbereinstimmende Tuple Gr\xF6\xDFe; {expected} oder mehr erwartet, aber \u201Eunbestimmt\u201C empfangen",
        tupleSizeMismatch: "Nicht \xFCbereinstimmende Tuple Gr\xF6\xDFe; {expected} erwartet, aber {received} empfangen",
        tupleSizeMismatchIndeterminateDest: "Nicht \xFCbereinstimmende Tuple Gr\xF6\xDFe; {expected} oder mehr erwartet, aber {received} empfangen",
        typeAliasInstanceCheck: "Der mit der \u201Etype\u201C-Anweisung erstellte Typalias kann nicht mit Instanz- und Klassen\xFCberpr\xFCfungen verwendet werden.",
        typeAssignmentMismatch: "Der Typ \u201E{sourceType}\u201C kann dem Typ \u201E{destType}\u201C nicht zugewiesen werden.",
        typeBound: "Der Typ \u201E{sourceType}\u201C kann der oberen Grenze \u201E{destType}\u201C f\xFCr die Typvariable \u201E{name}\u201C nicht zugewiesen werden.",
        typeConstrainedTypeVar: "Der Typ \u201E{type}\u201C kann der eingeschr\xE4nkten Typvariablen \u201E{name}\u201C nicht zugewiesen werden",
        typeIncompatible: "\u201E{sourceType}\u201C kann \u201E{destType}\u201C nicht zugewiesen werden.",
        typeNotClass: '"{type}" ist keine Klasse.',
        typeNotStringLiteral: '"{type}" ist kein Zeichenfolgenliteral.',
        typeOfSymbol: 'Der Typ von "{name}" ist "{type}".',
        typeParamSpec: 'Typ "{type}" ist nicht mit ParamSpec "{name}" kompatibel.',
        typeUnsupported: 'Typ "{type}" wird nicht unterst\xFCtzt.',
        typeVarDefaultOutOfScope: 'Die Typvariable "{name}" befindet sich nicht im Bereich.',
        typeVarIsContravariant: 'Der Typparameter "{name}" ist kontravariant, aber "{sourceType}" ist kein Supertyp von "{destType}"',
        typeVarIsCovariant: 'Der Typparameter "{name}" ist kovariant, aber "{sourceType}" ist kein Untertyp von "{destType}"',
        typeVarIsInvariant: 'Der Typparameter "{name}" ist invariant, "{sourceType}" ist jedoch nicht identisch mit "{destType}"',
        typeVarNotAllowed: "TypeVar ist f\xFCr Instanz- oder Klassenpr\xFCfungen nicht zul\xE4ssig.",
        typeVarTupleRequiresKnownLength: "TypeVarTuple kann nicht an tuple unbekannter L\xE4nge gebunden werden.",
        typeVarUnnecessarySuggestion: "Stattdessen {type} verwenden",
        typeVarUnsolvableRemedy: "Geben Sie eine \xDCberladung an, die den R\xFCckgabetyp angibt, wenn das Argument nicht angegeben ist.",
        typeVarsMissing: "Fehlende Typvariablen: {names}",
        typedDictBaseClass: 'Die Klasse "{type}" ist kein TypedDict.',
        typedDictClassNotAllowed: "Die TypedDict-Klasse ist f\xFCr Instanz- oder Klassen\xFCberpr\xFCfungen nicht zul\xE4ssig.",
        typedDictClosedExtraNotAllowed: "Das Element \u201E{name}\u201C kann nicht hinzugef\xFCgt werden.",
        typedDictClosedExtraTypeMismatch: "Das Element \u201E{name}\u201C mit dem Typ \u201E{type}\u201C kann nicht hinzugef\xFCgt werden.",
        typedDictClosedFieldNotReadOnly: 'Cannot add item "{name}" because it must be ReadOnly',
        typedDictClosedFieldNotRequired: "Das Element \u201E{name}\u201C kann nicht hinzugef\xFCgt werden, da es \u201ENotRequired\u201C sein muss.",
        typedDictExtraFieldNotAllowed: "\u201E{name}\u201C ist in \u201E{type}\u201C nicht vorhanden.",
        typedDictExtraFieldTypeMismatch: "Der Typ von \u201E{name}\u201C ist nicht mit dem Typ \u201Eextra_items\u201C in \u201E{type}\u201C kompatibel.",
        typedDictFieldMissing: '"{name}" fehlt in "{type}"',
        typedDictFieldNotReadOnly: '"{name}" ist in "{type}" nicht schreibgesch\xFCtzt.',
        typedDictFieldNotRequired: '"{name}" ist in "{type}" nicht erforderlich.',
        typedDictFieldRequired: '"{name}" ist in "{type}" erforderlich.',
        typedDictFieldTypeMismatch: "Der Typ \u201E{type}\u201C kann dem Element \u201E{name}\u201C nicht zugewiesen werden.",
        typedDictFieldUndefined: "\u201E{name}\u201C ist ein nicht definiertes Element im Typ \u201E{type}\u201C.",
        typedDictKeyAccess: '["{name}"] verwenden, um in TypedDict auf ein Element zu verweisen',
        typedDictNotAllowed: "TypedDict kann nicht f\xFCr Instanzen- oder Klassen\xFCberpr\xFCfungen verwendet werden.",
        unhashableType: 'Der Typ "{type}" kann nicht mit einem Hash erstellt werden.',
        uninitializedAbstractVariable: 'Die Instanzvariable "{name}" ist in einer abstrakten Basisklasse "{classType}" definiert, aber nicht initialisiert.',
        unreachableExcept: '"{exceptionType}" ist eine Unterklasse von "{parentType}"',
        useDictInstead: "Verwenden Sie dict[T1, T2], um einen W\xF6rterbuchtyp anzugeben.",
        useListInstead: "Verwenden Sie list[T], um einen list-Typ anzugeben, oder T1 | T2, um einen union-Typ anzugeben.",
        useTupleInstead: "Verwenden Sie tuple[T1, ..., Tn], um einen tuple-Typ anzugeben, oder T1 | T2, um einen union-Typ anzugeben.",
        useTypeInstead: "Verwenden Sie stattdessen type[T].",
        varianceMismatchForClass: 'Die Varianz des Typarguments "{typeVarName}" ist nicht mit der Basisklasse "{className}" kompatibel',
        varianceMismatchForTypeAlias: 'Die Varianz des Typarguments "{typeVarName}" ist nicht mit "{typeAliasParam}" kompatibel'
      },
      Service: {
        longOperation: "Das Aufz\xE4hlen von Arbeitsbereichsquelldateien nimmt viel Zeit in Anspruch. Erw\xE4gen Sie stattdessen, einen Unterordner zu \xF6ffnen. [Weitere Informationen](https://aka.ms/workspace-too-many-files)"
      }
    };
  }
});

// node_modules/@zzzen/pyright-internal/dist/localization/package.nls.en-us.json
var require_package_nls_en_us = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/localization/package.nls.en-us.json"(exports2, module2) {
    module2.exports = {
      CodeAction: {
        createTypeStub: {
          message: "Create Type Stub",
          comment: "{Locked='Stub'}"
        },
        createTypeStubFor: {
          message: 'Create Type Stub For "{moduleName}"',
          comment: "{Locked='Stub'}"
        },
        executingCommand: "Executing command",
        filesToAnalyzeCount: "{count} files to analyze",
        filesToAnalyzeOne: "1 file to analyze",
        findingReferences: "Finding references",
        organizeImports: "Organize Imports"
      },
      Completion: {
        autoImportDetail: "Auto-import",
        indexValueDetail: "Index value"
      },
      Diagnostic: {
        abstractMethodInvocation: 'Method "{method}" cannot be called because it is abstract and unimplemented',
        annotatedMetadataInconsistent: 'Annotated metadata type "{metadataType}" is not compatible with type "{type}"',
        annotatedParamCountMismatch: "Parameter annotation count mismatch: expected {expected} but received {received}",
        annotatedTypeArgMissing: {
          message: 'Expected one type argument and one or more annotations for "Annotated"',
          comment: "{Locked='Annotated'}"
        },
        annotationBytesString: "Type expressions cannot use bytes string literals",
        annotationFormatString: {
          message: "Type expressions cannot use format string literals (f-strings)",
          comment: "'f-string' is the common English slang for a Python format string"
        },
        annotationNotSupported: "Type annotation not supported for this statement",
        annotationRawString: "Type expressions cannot use raw string literals",
        annotationSpansStrings: "Type expressions cannot span multiple string literals",
        annotationStringEscape: "Type expressions cannot contain escape characters",
        annotationTemplateString: {
          message: "Type expressions cannot use template string literals (t-strings)",
          comment: "'t-string' is the common English slang for a Python template string"
        },
        argAssignment: 'Argument of type "{argType}" cannot be assigned to parameter of type "{paramType}"',
        argAssignmentFunction: 'Argument of type "{argType}" cannot be assigned to parameter of type "{paramType}" in function "{functionName}"',
        argAssignmentParam: 'Argument of type "{argType}" cannot be assigned to parameter "{paramName}" of type "{paramType}"',
        argAssignmentParamFunction: 'Argument of type "{argType}" cannot be assigned to parameter "{paramName}" of type "{paramType}" in function "{functionName}"',
        argMissingForParam: "Argument missing for parameter {name}",
        argMissingForParams: "Arguments missing for parameters {names}",
        argMorePositionalExpectedCount: "Expected {expected} more positional arguments",
        argMorePositionalExpectedOne: "Expected 1 more positional argument",
        argPositional: "Expected positional argument",
        argPositionalExpectedCount: "Expected {expected} positional arguments",
        argPositionalExpectedOne: "Expected 1 positional argument",
        argTypePartiallyUnknown: "Argument type is partially unknown",
        argTypeUnknown: "Argument type is unknown",
        assertAlwaysTrue: {
          message: "Assert expression always evaluates to true",
          comment: "{Locked='true'}"
        },
        assertTypeArgs: {
          message: '"assert_type" expects two positional arguments',
          comment: "{Locked='assert_type'}"
        },
        assertTypeTypeMismatch: {
          message: '"assert_type" mismatch: expected "{expected}" but received "{received}"',
          comment: "{Locked='assert_type'}"
        },
        assignmentExprComprehension: {
          message: 'Assignment expression target "{name}" cannot use same name as comprehension for target',
          comment: "A comprehension is a 'set of looping and filtering instructions' applied to a collection to generate a new collection; the word may not be translatable"
        },
        assignmentExprContext: "Assignment expression must be within module, function or lambda",
        assignmentExprInSubscript: "Assignment expressions within a subscript are supported only in Python 3.10 and newer",
        assignmentInProtocol: {
          message: "Instance or class variables within a Protocol class must be explicitly declared within the class body",
          comment: "{Locked='Protocol'}"
        },
        assignmentTargetExpr: "Expression cannot be assignment target",
        asyncNotInAsyncFunction: {
          message: 'Use of "async" not allowed outside of async function',
          comment: "{Locked='async'}"
        },
        awaitIllegal: {
          message: 'Use of "await" requires Python 3.5 or newer',
          comment: "{Locked='await'}"
        },
        awaitNotAllowed: {
          message: 'Type expressions cannot use "await"',
          comment: "{Locked='await'}"
        },
        awaitNotInAsync: {
          message: '"await" allowed only within async function',
          comment: "{Locked='await','async'}"
        },
        backticksIllegal: {
          message: "Expressions surrounded by backticks are not supported in Python 3.x; use repr instead",
          comment: "{Locked='repr'}"
        },
        baseClassCircular: "Class cannot derive from itself",
        baseClassFinal: {
          message: 'Base class "{type}" is marked final and cannot be subclassed',
          comment: "{Locked='final'}"
        },
        baseClassIncompatible: "Base classes of {type} are mutually incompatible",
        baseClassInvalid: "Argument to class must be a base class",
        baseClassMethodTypeIncompatible: 'Base classes for class "{classType}" define method "{name}" in incompatible way',
        baseClassUnknown: "Base class type is unknown, obscuring type of derived class",
        baseClassVariableTypeIncompatible: 'Base classes for class "{classType}" define variable "{name}" in incompatible way',
        binaryOperationNotAllowed: "Binary operator not allowed in type expression",
        bindParamMissing: {
          message: 'Could not bind method "{methodName}" because it is missing a "self" or "cls" parameter',
          comment: "Binding is the process through which Pyright determines what object a name refers to"
        },
        bindTypeMismatch: {
          message: 'Could not bind method "{methodName}" because "{type}" is not assignable to parameter "{paramName}"',
          comment: "Binding is the process through which Pyright determines what object a name refers to"
        },
        breakInExceptionGroup: {
          message: '"break" is not allowed in an "except*" block',
          comment: "{Locked='break','except*'}"
        },
        breakOutsideLoop: {
          message: '"break" can be used only within a loop',
          comment: "{Locked='break'}"
        },
        bytesUnsupportedEscape: {
          message: "Unsupported escape sequence in bytes literal",
          comment: "{Locked='bytes'}"
        },
        callableExtraArgs: {
          message: 'Expected only two type arguments to "Callable"',
          comment: "{Locked='Callable'}"
        },
        callableFirstArg: 'Expected parameter type list or "..."',
        callableNotInstantiable: 'Cannot instantiate type "{type}"',
        callableSecondArg: {
          message: 'Expected return type as second type argument for "Callable"',
          comment: "{Locked='Callable'}"
        },
        casePatternIsIrrefutable: "Irrefutable pattern is allowed only for the last case statement",
        classAlreadySpecialized: 'Type "{type}" is already specialized',
        classDecoratorTypeUnknown: "Untyped class decorator obscures type of class; ignoring decorator",
        classDefinitionCycle: 'Class definition for "{name}" depends on itself',
        classGetItemClsParam: {
          message: '__class_getitem__ override should take a "cls" parameter',
          comment: "{Locked='__class_getitem__','cls'}"
        },
        classMethodClsParam: {
          message: 'Class methods should take a "cls" parameter',
          comment: "{Locked='cls'}"
        },
        classNotRuntimeSubscriptable: 'Subscript for class "{name}" will generate runtime exception; enclose type expression in quotes',
        classPatternBuiltInArgPositional: "Class pattern accepts only positional sub-pattern",
        classPatternNewType: '"{type}" cannot be used in a class pattern because it is defined using NewType',
        classPatternPositionalArgCount: 'Too many positional patterns for class "{type}"; expected {expected} but received {received}',
        classPatternTypeAlias: '"{type}" cannot be used in a class pattern because it is a specialized type alias',
        classPropertyDeprecated: "Class properties are deprecated in Python 3.11 and will not be supported in Python 3.13",
        classTypeParametersIllegal: "Class type parameter syntax requires Python 3.12 or newer",
        classVarFirstArgMissing: {
          message: 'Expected a type argument after "ClassVar"',
          comment: "{Locked='ClassVar'}"
        },
        classVarNotAllowed: {
          message: '"ClassVar" is not allowed in this context',
          comment: "{Locked='ClassVar'}"
        },
        classVarOverridesInstanceVar: 'Class variable "{name}" overrides instance variable of same name in class "{className}"',
        classVarTooManyArgs: {
          message: 'Expected only one type argument after "ClassVar"',
          comment: "{Locked='ClassVar'}"
        },
        classVarWithTypeVar: {
          message: '"ClassVar" type cannot include type variables',
          comment: "{Locked='ClassVar'}"
        },
        clsSelfParamTypeMismatch: 'Type of parameter "{name}" must be a supertype of its class "{classType}"',
        codeTooComplexToAnalyze: "Code is too complex to analyze; reduce complexity by refactoring into subroutines or reducing conditional code paths",
        collectionAliasInstantiation: 'Type "{type}" cannot be instantiated, use "{alias}" instead',
        comparisonAlwaysFalse: {
          message: 'Condition will always evaluate to False since the types "{leftType}" and "{rightType}" have no overlap',
          comment: "{Locked='False'}"
        },
        comparisonAlwaysTrue: {
          message: 'Condition will always evaluate to True since the types "{leftType}" and "{rightType}" have no overlap',
          comment: "{Locked='True'}"
        },
        comprehensionInDict: {
          message: "Comprehension cannot be used with other dictionary entries",
          comment: "A comprehension is a 'set of looping and filtering instructions' applied to a collection to generate a new collection; the word may not be translatable"
        },
        comprehensionInSet: {
          message: "Comprehension cannot be used with other set entries",
          comment: ["{Locked='set'}", "A comprehension is a 'set of looping and filtering instructions' applied to a collection to generate a new collection; the word may not be translatable"]
        },
        concatenateContext: {
          message: '"Concatenate" is not allowed in this context',
          comment: "{Locked='Concatenate'}"
        },
        concatenateParamSpecMissing: {
          message: 'Last type argument for "Concatenate" must be a ParamSpec or "..."',
          comment: "{Locked='Concatenate','ParamSpec','...'}"
        },
        concatenateTypeArgsMissing: {
          message: '"Concatenate" requires at least two type arguments',
          comment: "{Locked='Concatenate'}"
        },
        conditionalOperandInvalid: 'Invalid conditional operand of type "{type}"',
        constantRedefinition: '"{name}" is constant (because it is uppercase) and cannot be redefined',
        constructorParametersMismatch: {
          message: 'Mismatch between signature of __new__ and __init__ in class "{classType}"',
          comment: "{Locked='__new__','__init__'}"
        },
        containmentAlwaysFalse: {
          message: 'Expression will always evaluate to False since the types "{leftType}" and "{rightType}" have no overlap',
          comment: "{Locked='False'}"
        },
        containmentAlwaysTrue: {
          message: 'Expression will always evaluate to True since the types "{leftType}" and "{rightType}" have no overlap',
          comment: "{Locked='True'}"
        },
        continueInExceptionGroup: {
          message: '"continue" is not allowed in an "except*" block',
          comment: "{Locked='continue','except*'}"
        },
        continueOutsideLoop: {
          message: '"continue" can be used only within a loop',
          comment: "{Locked='continue'}"
        },
        coroutineInConditionalExpression: {
          message: "Conditional expression references coroutine which always evaluates to True",
          comment: "{Locked='True'}"
        },
        dataClassBaseClassFrozen: "A non-frozen class cannot inherit from a class that is frozen",
        dataClassBaseClassNotFrozen: "A frozen class cannot inherit from a class that is not frozen",
        dataClassConverterFunction: 'Argument of type "{argType}" is not a valid converter for field "{fieldName}" of type "{fieldType}"',
        dataClassConverterOverloads: 'No overloads of "{funcName}" are valid converters for field "{fieldName}" of type "{fieldType}"',
        dataClassFieldInheritedDefault: '"{fieldName}" overrides a field of the same name but is missing a default value',
        dataClassFieldWithDefault: "Fields without default values cannot appear after fields with default values",
        dataClassFieldWithPrivateName: "Dataclass field cannot use private name",
        dataClassFieldWithoutAnnotation: "Dataclass field without type annotation will cause runtime exception",
        dataClassPostInitParamCount: {
          message: "Dataclass __post_init__ incorrect parameter count; number of InitVar fields is {expected}",
          comment: "{Locked='__post_init__','InitVar'}"
        },
        dataClassPostInitType: {
          message: 'Dataclass __post_init__ method parameter type mismatch for field "{fieldName}"',
          comment: "{Locked='__post_init__'}"
        },
        dataClassSlotsOverwrite: {
          message: "__slots__ is already defined in class",
          comment: "{Locked='__slots__'}"
        },
        dataClassTransformExpectedBoolLiteral: {
          message: "Expected expression that statically evaluates to True or False",
          comment: "{Locked='True','False'}"
        },
        dataClassTransformFieldSpecifier: {
          message: 'Expected tuple of classes or functions but received type "{type}"',
          comment: "{Locked='tuple'}"
        },
        dataClassTransformPositionalParam: {
          message: 'All arguments to "dataclass_transform" must be keyword arguments',
          comment: "{Locked='dataclass_transform'}"
        },
        dataClassTransformUnknownArgument: {
          message: 'Argument "{name}" is not supported by dataclass_transform',
          comment: "{Locked='dataclass_transform'}"
        },
        dataProtocolInSubclassCheck: {
          message: "Data protocols (which include non-method attributes) are not allowed in issubclass calls",
          comment: "{Locked='issubclass'}"
        },
        declaredReturnTypePartiallyUnknown: 'Declared return type, "{returnType}", is partially unknown',
        declaredReturnTypeUnknown: "Declared return type is unknown",
        defaultValueContainsCall: "Function calls and mutable objects not allowed within parameter default value expression",
        defaultValueNotAllowed: 'Parameter with "*" or "**" cannot have default value',
        delTargetExpr: "Expression cannot be deleted",
        deprecatedClass: 'The class "{name}" is deprecated',
        deprecatedConstructor: 'The constructor for class "{name}" is deprecated',
        deprecatedDescriptorDeleter: 'The "__delete__" method for descriptor "{name}" is deprecated',
        deprecatedDescriptorGetter: 'The "__get__" method  for descriptor "{name}" is deprecated',
        deprecatedDescriptorSetter: 'The "__set__" method  for descriptor "{name}" is deprecated',
        deprecatedFunction: 'The function "{name}" is deprecated',
        deprecatedMethod: 'The method "{name}" in class "{className}" is deprecated',
        deprecatedPropertyDeleter: {
          message: 'The deleter for property "{name}" is deprecated',
          comment: "{Locked='deleter','property'}"
        },
        deprecatedPropertyGetter: {
          message: 'The getter for property "{name}" is deprecated',
          comment: "{Locked='getter','property'}"
        },
        deprecatedPropertySetter: {
          message: 'The setter for property "{name}" is deprecated',
          comment: "{Locked='setter','property'}"
        },
        deprecatedType: 'This type is deprecated as of Python {version}; use "{replacement}" instead',
        dictExpandIllegalInComprehension: {
          message: "Dictionary expansion not allowed in comprehension",
          comment: "A comprehension is a 'set of looping and filtering instructions' applied to a collection to generate a new collection; the word may not be translatable"
        },
        dictInAnnotation: "Dictionary expression not allowed in type expression",
        dictKeyValuePairs: "Dictionary entries must contain key/value pairs",
        dictUnpackIsNotMapping: "Expected mapping for dictionary unpack operator",
        dunderAllSymbolNotPresent: {
          message: '"{name}" is specified in __all__ but is not present in module',
          comment: "{Locked='__all__'}"
        },
        duplicateArgsParam: 'Only one "*" parameter allowed',
        duplicateBaseClass: "Duplicate base class not allowed",
        duplicateCapturePatternTarget: 'Capture target "{name}" cannot appear more than once within the same pattern',
        duplicateCatchAll: {
          message: "Only one catch-all except clause allowed",
          comment: "{Locked='except'}"
        },
        duplicateEnumMember: {
          message: 'Enum member "{name}" is already declared',
          comment: "{Locked='Enum'}"
        },
        duplicateGenericAndProtocolBase: {
          message: "Only one Generic[...] or Protocol[...] base class allowed",
          comment: "{Locked='Generic[...]','Protocol[...]'}"
        },
        duplicateImport: '"{importName}" is imported more than once',
        duplicateKeywordOnly: 'Only one "*" separator allowed',
        duplicateKwargsParam: 'Only one "**" parameter allowed',
        duplicateParam: 'Duplicate parameter "{name}"',
        duplicatePositionOnly: 'Only one "/" parameter allowed',
        duplicateStarPattern: 'Only one "*" pattern allowed in a pattern sequence',
        duplicateStarStarPattern: 'Only one "**" entry allowed',
        duplicateUnpack: {
          message: "Only one unpack operation allowed in list",
          comment: "{Locked='list'}"
        },
        ellipsisAfterUnpacked: {
          message: '"..." cannot be used with an unpacked TypeVarTuple or tuple',
          comment: "{Locked='TypeVarTuple','tuple'}"
        },
        ellipsisContext: '"..." is not allowed in this context',
        ellipsisSecondArg: '"..." is allowed only as the second of two arguments',
        enumClassOverride: {
          message: 'Enum class "{name}" is final and cannot be subclassed',
          comment: "{Locked='Enum','final'}"
        },
        enumMemberDelete: {
          message: 'Enum member "{name}" cannot be deleted',
          comment: "{Locked='Enum'}"
        },
        enumMemberSet: {
          message: 'Enum member "{name}" cannot be assigned',
          comment: "{Locked='Enum'}"
        },
        enumMemberTypeAnnotation: {
          message: "Type annotations are not allowed for enum members",
          comment: "{Locked='enum'}"
        },
        exceptionGroupIncompatible: {
          message: 'Exception group syntax ("except*") requires Python 3.11 or newer',
          comment: "{Locked='except*'}"
        },
        exceptGroupMismatch: {
          message: 'Try statement cannot include both "except" and "except*"',
          comment: "{Locked='except','except*'}"
        },
        exceptGroupRequiresType: {
          message: 'Exception group syntax ("except*") requires an exception type',
          comment: "{Locked='except*'}"
        },
        exceptionGroupTypeIncorrect: {
          message: "Exception type in except* cannot derive from BaseGroupException",
          comment: "{Locked='except*','BaseGroupException'}"
        },
        exceptionTypeIncorrect: {
          message: '"{type}" does not derive from BaseException',
          comment: "{Locked='BaseException'}"
        },
        exceptionTypeNotClass: '"{type}" is not a valid exception class',
        exceptionTypeNotInstantiable: 'Constructor for exception type "{type}" requires one or more arguments',
        exceptWithAsRequiresParens: 'Multiple exception types must be parenthesized when using "as"',
        exceptRequiresParens: "Multiple exception types must be parenthesized prior to Python 3.14",
        expectedAfterDecorator: "Expected function or class declaration after decorator",
        expectedArrow: 'Expected "->" followed by return type annotation',
        expectedAsAfterException: {
          message: 'Expected "as" after exception type',
          comment: "{Locked='as'}"
        },
        expectedAssignRightHandExpr: 'Expected expression to the right of "="',
        expectedBinaryRightHandExpr: "Expected expression to the right of operator",
        expectedBoolLiteral: {
          message: "Expected True or False",
          comment: "{Locked='True','False'}"
        },
        expectedCase: {
          message: 'Expected "case" statement',
          comment: "{Locked='case'}"
        },
        expectedClassName: "Expected class name",
        expectedCloseBrace: '"{" was not closed',
        expectedCloseBracket: '"[" was not closed',
        expectedCloseParen: '"(" was not closed',
        expectedColon: 'Expected ":"',
        expectedComplexNumberLiteral: {
          message: "Expected complex number literal for pattern matching",
          comment: "Complex numbers are a mathematical concept consisting of a real number and an imaginary number"
        },
        expectedDecoratorExpr: "Expression form not supported for decorator prior to Python 3.9",
        expectedDecoratorName: "Expected decorator name",
        expectedDecoratorNewline: "Expected new line at end of decorator",
        expectedDelExpr: {
          message: 'Expected expression after "del"',
          comment: "{Locked='del'}"
        },
        expectedElse: {
          message: 'Expected "else"',
          comment: "{Locked='else'}"
        },
        expectedEquals: 'Expected "="',
        expectedExceptionClass: "Invalid exception class or object",
        expectedExceptionObj: {
          message: "Expected exception object, exception class or None",
          comment: "{Locked='None'}"
        },
        expectedExpr: "Expected expression",
        expectedFunctionAfterAsync: {
          message: 'Expected function definition after "async"',
          comment: "{Locked='async'}"
        },
        expectedFunctionName: {
          message: 'Expected function name after "def"',
          comment: "{Locked='def'}"
        },
        expectedIdentifier: "Expected identifier",
        expectedImport: {
          message: 'Expected "import"',
          comment: "{Locked='import'}"
        },
        expectedImportAlias: {
          message: 'Expected symbol after "as"',
          comment: "{Locked='as'}"
        },
        expectedImportSymbols: {
          message: 'Expected one or more symbol names after "import"',
          comment: "{Locked='import'}"
        },
        expectedIn: {
          message: 'Expected "in"',
          comment: "{Locked='in'}"
        },
        expectedInExpr: {
          message: 'Expected expression after "in"',
          comment: "{Locked='in'}"
        },
        expectedIndentedBlock: "Expected indented block",
        expectedMemberName: 'Expected attribute name after "."',
        expectedModuleName: "Expected module name",
        expectedNameAfterAs: {
          message: 'Expected symbol name after "as"',
          comment: "{Locked='as'}"
        },
        expectedNamedParameter: 'Keyword parameter must follow "*"',
        expectedNewline: "Expected newline",
        expectedNewlineOrSemicolon: "Statements must be separated by newlines or semicolons",
        expectedOpenParen: 'Expected "("',
        expectedParamName: "Expected parameter name",
        expectedPatternExpr: "Expected pattern expression",
        expectedPatternSubjectExpr: "Expected pattern subject expression",
        expectedPatternValue: {
          message: 'Expected pattern value expression of the form "a.b"',
          comment: "{Locked='a.b'}"
        },
        expectedReturnExpr: {
          message: 'Expected expression after "return"',
          comment: "{Locked='return'}"
        },
        expectedSliceIndex: "Expected index or slice expression",
        expectedTypeNotString: "Expected type but received a string literal",
        expectedTypeParameterName: "Expected type parameter name",
        expectedYieldExpr: {
          message: "Expected expression in yield statement",
          comment: "{Locked='yield'}"
        },
        finalClassIsAbstract: {
          message: 'Class "{type}" is marked final and must implement all abstract symbols',
          comment: "{Locked='final'}"
        },
        finalContext: {
          message: '"Final" is not allowed in this context',
          comment: "{Locked='Final'}"
        },
        finalInLoop: {
          message: 'A "Final" variable cannot be assigned within a loop',
          comment: "{Locked='Final'}"
        },
        finallyBreak: {
          message: 'A "break" cannot be used to exit a "finally" block',
          comment: "{Locked='break', 'finally'}"
        },
        finallyContinue: {
          message: 'A "continue" cannot be used to exit a "finally" block',
          comment: "{Locked='continue', 'finally'}"
        },
        finallyReturn: {
          message: 'A "return" cannot be used to exit a "finally" block',
          comment: "{Locked='return', 'finally'}"
        },
        finalMethodOverride: {
          message: 'Method "{name}" cannot override final method defined in class "{className}"',
          comment: "{Locked='final'}"
        },
        finalNonMethod: {
          message: 'Function "{name}" cannot be marked @final because it is not a method',
          comment: "{Locked='@final'}"
        },
        finalReassigned: {
          message: '"{name}" is declared as Final and cannot be reassigned',
          comment: "{Locked='Final'}"
        },
        finalRedeclaration: {
          message: '"{name}" was previously declared as Final',
          comment: "{Locked='Final'}"
        },
        finalRedeclarationBySubclass: {
          message: '"{name}" cannot be redeclared because parent class "{className}" declares it as Final',
          comment: "{Locked='Final'}"
        },
        finalTooManyArgs: {
          message: 'Expected a single type argument after "Final"',
          comment: "{Locked='Final'}"
        },
        finalUnassigned: {
          message: '"{name}" is declared Final, but value is not assigned',
          comment: "{Locked='Final'}"
        },
        formatStringBrace: {
          message: "Single close brace not allowed within f-string literal; use double close brace",
          comment: "'f-string' is the common English slang for a Python format string"
        },
        formatStringBytes: {
          message: "Format string literals (f-strings) cannot be binary",
          comment: "'f-string' is the common English slang for a Python format string"
        },
        formatStringDebuggingIllegal: {
          message: 'F-string debugging specifier "=" requires Python 3.8 or newer',
          comment: "'f-string' is the common English slang for a Python format string"
        },
        formatStringEscape: {
          message: "Escape sequence (backslash) not allowed in expression portion of f-string prior to Python 3.12",
          comment: "'f-string' is the common English slang for a Python format string"
        },
        formatStringExpectedConversion: {
          message: 'Expected a conversion specifier after "!" in f-string',
          comment: "'f-string' is the common English slang for a Python format string"
        },
        formatStringIllegal: {
          message: "Format string literals (f-strings) require Python 3.6 or newer",
          comment: "'f-string' is the common English slang for a Python format string"
        },
        formatStringInPattern: "Format string not allowed in pattern",
        formatStringNestedFormatSpecifier: "Expressions nested too deeply within format string specifier",
        formatStringNestedQuote: {
          message: "Strings nested within an f-string cannot use the same quote character as the f-string prior to Python 3.12",
          comment: "'f-string' is the common English slang for a Python format string"
        },
        formatStringTemplate: {
          message: "Format string literals (f-strings) cannot also be template strings (t-strings)",
          comment: "'f-string' is the common English slang for a Python format string, 't-string' is the common English slang for a Python template string"
        },
        formatStringUnicode: {
          message: "Format string literals (f-strings) cannot be unicode",
          comment: "'f-string' is the common English slang for a Python format string"
        },
        formatStringUnterminated: {
          message: 'Unterminated expression in f-string; expecting "}"',
          comment: "'f-string' is the common English slang for a Python format string"
        },
        functionDecoratorTypeUnknown: "Untyped function decorator obscures type of function; ignoring decorator",
        functionInConditionalExpression: {
          message: "Conditional expression references function which always evaluates to True",
          comment: "{Locked='True'}"
        },
        functionTypeParametersIllegal: "Function type parameter syntax requires Python 3.12 or newer",
        futureImportLocationNotAllowed: {
          message: "Imports from __future__ must be at the beginning of the file",
          comment: "{Locked='__future__'}"
        },
        generatorAsyncReturnType: {
          message: 'Return type of async generator function must be compatible with "AsyncGenerator[{yieldType}, Any]"',
          comment: "{Locked='async','AsyncGenerator[{yieldType}, Any]'}"
        },
        generatorNotParenthesized: "Generator expressions must be parenthesized if not sole argument",
        generatorSyncReturnType: {
          message: 'Return type of generator function must be compatible with "Generator[{yieldType}, Any, Any]"',
          comment: "{Locked='Generator[{yieldType}, Any, Any]'}"
        },
        genericBaseClassNotAllowed: {
          message: '"Generic" base class cannot be used with type parameter syntax',
          comment: "{Locked='Generic'}"
        },
        genericClassAssigned: {
          message: "Generic class type cannot be assigned",
          comment: "A generic type is a parameterized type, for example a container where the generic type parameter specifies the type of elements in the container"
        },
        genericClassDeleted: {
          message: "Generic class type cannot be deleted",
          comment: "A generic type is a parameterized type, for example a container where the generic type parameter specifies the type of elements in the container"
        },
        genericInstanceVariableAccess: {
          message: "Access to generic instance variable through class is ambiguous",
          comment: "A generic type is a parameterized type, for example a container where the generic type parameter specifies the type of elements in the container"
        },
        genericNotAllowed: {
          message: '"Generic" is not valid in this context',
          comment: "{Locked='Generic'}"
        },
        genericTypeAliasBoundTypeVar: {
          message: "Generic type alias within class cannot use bound type variables {names}",
          comment: "A generic type is a parameterized type, for example a container where the generic type parameter specifies the type of elements in the container"
        },
        genericTypeArgMissing: {
          message: '"Generic" requires at least one type argument',
          comment: "{Locked='Generic'}"
        },
        genericTypeArgTypeVar: {
          message: 'Type argument for "Generic" must be a type variable',
          comment: "{Locked='Generic'}"
        },
        genericTypeArgUnique: {
          message: 'Type arguments for "Generic" must be unique',
          comment: "{Locked='Generic'}"
        },
        globalReassignment: {
          message: '"{name}" is assigned before global declaration',
          comment: "{Locked='global'}"
        },
        globalRedefinition: {
          message: '"{name}" was already declared global',
          comment: "{Locked='global'}"
        },
        implicitStringConcat: "Implicit string concatenation not allowed",
        importCycleDetected: "Cycle detected in import chain",
        importDepthExceeded: "Import chain depth exceeded {depth}",
        importResolveFailure: 'Import "{importName}" could not be resolved',
        importSourceResolveFailure: 'Import "{importName}" could not be resolved from source',
        importSymbolUnknown: '"{name}" is unknown import symbol',
        incompatibleMethodOverride: 'Method "{name}" overrides class "{className}" in an incompatible manner',
        inconsistentIndent: "Unindent amount does not match previous indent",
        inconsistentTabs: "Inconsistent use of tabs and spaces in indentation",
        initMethodSelfParamTypeVar: {
          message: 'Type annotation for "self" parameter of "__init__" method cannot contain class-scoped type variables',
          comment: "{Locked='self','__init__'}"
        },
        initMustReturnNone: {
          message: 'Return type of "__init__" must be None',
          comment: "{Locked='__init__','None'}"
        },
        initSubclassCallFailed: {
          message: "Incorrect keyword arguments for __init_subclass__ method",
          comment: "{Locked='__init_subclass__'}"
        },
        initSubclassClsParam: {
          message: '__init_subclass__ override should take a "cls" parameter',
          comment: "{Locked='__init_subclass__','cls'}"
        },
        initVarNotAllowed: {
          message: '"InitVar" is not allowed in this context',
          comment: "{Locked='InitVar'}"
        },
        instanceMethodSelfParam: {
          message: 'Instance methods should take a "self" parameter',
          comment: "{Locked='self'}"
        },
        instanceVarOverridesClassVar: 'Instance variable "{name}" overrides class variable of same name in class "{className}"',
        instantiateAbstract: 'Cannot instantiate abstract class "{type}"',
        instantiateProtocol: {
          message: 'Cannot instantiate Protocol class "{type}"',
          comment: "{Locked='Protocol'}"
        },
        internalBindError: {
          message: 'An internal error occurred while binding file "{file}": {message}',
          comment: "Binding is the process through which Pyright determines what object a name refers to"
        },
        internalParseError: 'An internal error occurred while parsing file "{file}": {message}',
        internalTypeCheckingError: 'An internal error occurred while type checking file "{file}": {message}',
        invalidIdentifierChar: "Invalid character in identifier",
        invalidStubStatement: {
          message: "Statement is meaningless within a type stub file",
          comment: "{StrContains=i'stub'}"
        },
        invalidTokenChars: 'Invalid character "{text}" in token',
        isInstanceInvalidType: {
          message: 'Second argument to "isinstance" must be a class or tuple of classes',
          comment: "{Locked='isinstance','tuple'}"
        },
        isSubclassInvalidType: {
          message: 'Second argument to "issubclass" must be a class or tuple of classes',
          comment: "{Locked='issubclass','tuple'}"
        },
        keyValueInSet: {
          message: "Key/value pairs are not allowed within a set",
          comment: "{Locked='set'}"
        },
        keywordArgInTypeArgument: "Keyword arguments cannot be used in type argument lists",
        keywordOnlyAfterArgs: 'Keyword-only argument separator not allowed after "*" parameter',
        keywordParameterMissing: 'One or more keyword parameters must follow "*" parameter',
        keywordSubscriptIllegal: "Keyword arguments within subscripts are not supported",
        lambdaReturnTypePartiallyUnknown: 'Return type of lambda, "{returnType}", is partially unknown',
        lambdaReturnTypeUnknown: "Return type of lambda is unknown",
        listAssignmentMismatch: 'Expression with type "{type}" cannot be assigned to target list',
        listInAnnotation: {
          message: "List expression not allowed in type expression",
          comment: "{Locked='List'}"
        },
        literalEmptyArgs: {
          message: 'Expected one or more type arguments after "Literal"',
          comment: "{Locked='Literal'}"
        },
        literalNamedUnicodeEscape: {
          message: 'Named unicode escape sequences are not supported in "Literal" string annotations',
          comment: "{Locked='Literal'}"
        },
        literalNotAllowed: {
          message: '"Literal" cannot be used in this context without a type argument',
          comment: "{Locked='Literal'}"
        },
        literalNotCallable: {
          message: "Literal type cannot be instantiated",
          comment: "{Locked='Literal'}"
        },
        literalUnsupportedType: {
          message: 'Type arguments for "Literal" must be None, a literal value (int, bool, str, or bytes), or an enum value',
          comment: "{Locked='Literal','None','int','bool','str','bytes','enum'}"
        },
        matchIncompatible: {
          message: "Match statements require Python 3.10 or newer",
          comment: ["{StrContains=i'match'}", "'match' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        matchIsNotExhaustive: {
          message: "Cases within match statement do not exhaustively handle all values",
          comment: ["{Locked='match'}", "Case statements are children of match statements where 'case' is a keyword. It may be best to keep 'case' in English"]
        },
        maxParseDepthExceeded: "Maximum parse depth exceeded; break expression into smaller sub-expressions",
        memberAccess: 'Cannot access attribute "{name}" for class "{type}"',
        memberDelete: 'Cannot delete attribute "{name}" for class "{type}"',
        memberSet: 'Cannot assign to attribute "{name}" for class "{type}"',
        metaclassConflict: {
          message: "The metaclass of a derived class must be a subclass of the metaclasses of all its base classes",
          comment: "Metaclasses are a complex concept and it may be best to not localize the term"
        },
        metaclassDuplicate: {
          message: "Only one metaclass can be provided",
          comment: "Metaclasses are a complex concept and it may be best to not localize the term"
        },
        metaclassIsGeneric: {
          message: "Metaclass cannot be generic",
          comment: ["Metaclasses are a complex concept and it may be best to not localize the term", "A generic type is a parameterized type, for example a container where the generic type parameter specifies the type of elements in the container"]
        },
        methodNotDefined: '"{name}" method not defined',
        methodNotDefinedOnType: '"{name}" method not defined on type "{type}"',
        methodOrdering: "Cannot create consistent method ordering",
        methodOverridden: '"{name}" overrides method of same name in class "{className}" with incompatible type "{type}"',
        methodReturnsNonObject: '"{name}" method does not return an object',
        missingSuperCall: 'Method "{methodName}" does not call the method of the same name in parent class',
        mixingBytesAndStr: {
          message: "Bytes and str values cannot be concatenated",
          comment: ["{Locked='str'}", "{StrContains=i'bytes'}", "'bytes' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        moduleAsType: "Module cannot be used as a type",
        moduleNotCallable: "Module is not callable",
        moduleUnknownMember: '"{memberName}" is not a known attribute of module "{moduleName}"',
        namedExceptAfterCatchAll: {
          message: "A named except clause cannot appear after catch-all except clause",
          comment: "{Locked='except'}"
        },
        namedParamAfterParamSpecArgs: {
          message: 'Keyword parameter "{name}" cannot appear in signature after ParamSpec args parameter',
          comment: "{Locked='ParamSpec','args'}"
        },
        namedTupleEmptyName: {
          message: "Names within a named tuple cannot be empty",
          comment: "{Locked='tuple'}"
        },
        namedTupleEntryRedeclared: {
          message: 'Cannot override "{name}" because parent class "{className}" is a named tuple',
          comment: "{Locked='tuple'}"
        },
        namedTupleFieldUnderscore: {
          message: "Named tuple field names cannot start with an underscore",
          comment: "{Locked='Named','tuple'}"
        },
        namedTupleFirstArg: {
          message: "Expected named tuple class name as first argument",
          comment: "{Locked='tuple'}"
        },
        namedTupleMultipleInheritance: {
          message: "Multiple inheritance with NamedTuple is not supported",
          comment: "{Locked='NamedTuple'}"
        },
        namedTupleNameKeyword: "Field names cannot be a keyword",
        namedTupleNameType: {
          message: "Expected two-entry tuple specifying entry name and type",
          comment: "{Locked='tuple'}"
        },
        namedTupleNameUnique: {
          message: "Names within a named tuple must be unique",
          comment: "{Locked='tuple'}"
        },
        namedTupleNoTypes: {
          message: '"namedtuple" provides no types for tuple entries; use "NamedTuple" instead',
          comment: "{Locked='namedtuple','tuple','NamedTuple'}"
        },
        namedTupleSecondArg: {
          message: "Expected named tuple entry list as second argument",
          comment: "{Locked='tuple','list'}"
        },
        newClsParam: {
          message: '__new__ override should take a "cls" parameter',
          comment: "{Locked='__new__','cls'}"
        },
        newTypeAnyOrUnknown: {
          message: "The second argument to NewType must be a known class, not Any or Unknown",
          comment: "{Locked='NewType','Any','Unknown'}"
        },
        newTypeBadName: {
          message: "The first argument to NewType must be a string literal",
          comment: "{Locked='NewType'}"
        },
        newTypeLiteral: {
          message: "NewType cannot be used with Literal type",
          comment: "{Locked='NewType','Literal'}"
        },
        newTypeNameMismatch: {
          message: "NewType must be assigned to a variable with the same name",
          comment: "{Locked='NewType'}"
        },
        newTypeNotAClass: {
          message: "Expected class as second argument to NewType",
          comment: "{Locked='NewType'}"
        },
        newTypeParamCount: {
          message: "NewType requires two positional arguments",
          comment: "{Locked='NewType'}"
        },
        newTypeProtocolClass: {
          message: "NewType cannot be used with structural type (a Protocol or TypedDict class)",
          comment: "{Locked='NewType','Protocol','TypedDict'}"
        },
        noOverload: 'No overloads for "{name}" match the provided arguments',
        noReturnContainsReturn: {
          message: 'Function with declared return type "NoReturn" cannot include a return statement',
          comment: "{Locked='NoReturn','return'}"
        },
        noReturnContainsYield: {
          message: 'Function with declared return type "NoReturn" cannot include a yield statement',
          comment: "{Locked='NoReturn','yield'}"
        },
        noReturnReturnsNone: {
          message: 'Function with declared return type "NoReturn" cannot return "None"',
          comment: "{Locked='NoReturn','None'}"
        },
        nonDefaultAfterDefault: "Non-default argument follows default argument",
        nonLocalInModule: {
          message: "Nonlocal declaration not allowed at module level",
          comment: ["{StrContains=i'nonlocal'}", "'nonlocal' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        nonLocalNoBinding: {
          message: 'No binding for nonlocal "{name}" found',
          comment: ["{Locked='nonlocal'}", "'No binding found' means that Pyright couldn't resolve the variable name to an object"]
        },
        nonLocalReassignment: {
          message: '"{name}" is assigned before nonlocal declaration',
          comment: "{Locked='nonlocal'}"
        },
        nonLocalRedefinition: {
          message: '"{name}" was already declared nonlocal',
          comment: "{Locked='nonlocal'}"
        },
        nonlocalTypeParam: {
          message: 'Nonlocal binding is not allowed for type parameter "{name}"',
          comment: ["{StrContains=i'nonlocal'}", "'nonlocal' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        noneNotCallable: {
          message: 'Object of type "None" cannot be called',
          comment: "{Locked='None'}"
        },
        noneNotIterable: {
          message: 'Object of type "None" cannot be used as iterable value',
          comment: "{Locked='None'}"
        },
        noneNotSubscriptable: {
          message: 'Object of type "None" is not subscriptable',
          comment: "{Locked='None'}"
        },
        noneNotUsableWith: {
          message: 'Object of type "None" cannot be used with "with"',
          comment: "{Locked='None','with'}"
        },
        noneNotUsableWithAsync: {
          message: 'Object of type "None" cannot be used with "async with"',
          comment: "{Locked='None','with', 'async}"
        },
        noneOperator: {
          message: 'Operator "{operator}" not supported for "None"',
          comment: "{Locked='None'}"
        },
        noneUnknownMember: {
          message: '"{name}" is not a known attribute of "None"',
          comment: "{Locked='None'}"
        },
        notRequiredArgCount: {
          message: 'Expected a single type argument after "NotRequired"',
          comment: "{Locked='NotRequired'}"
        },
        notRequiredNotInTypedDict: {
          message: '"NotRequired" is not allowed in this context',
          comment: "{Locked='NotRequired'}"
        },
        objectNotCallable: 'Object of type "{type}" is not callable',
        obscuredClassDeclaration: 'Class declaration "{name}" is obscured by a declaration of the same name',
        obscuredFunctionDeclaration: 'Function declaration "{name}" is obscured by a declaration of the same name',
        obscuredMethodDeclaration: 'Method declaration "{name}" is obscured by a declaration of the same name',
        obscuredParameterDeclaration: 'Parameter declaration "{name}" is obscured by a declaration of the same name',
        obscuredTypeAliasDeclaration: 'Type alias declaration "{name}" is obscured by a declaration of the same name',
        obscuredVariableDeclaration: 'Declaration "{name}" is obscured by a declaration of the same name',
        operatorLessOrGreaterDeprecated: 'Operator "<>" is not supported in Python 3; use "!=" instead',
        optionalExtraArgs: {
          message: 'Expected one type argument after "Optional"',
          comment: "{Locked='Optional'}"
        },
        orPatternIrrefutable: {
          message: 'Irrefutable pattern allowed only as the last subpattern in an "or" pattern',
          comment: "{Locked='or'}"
        },
        orPatternMissingName: {
          message: 'All subpatterns within an "or" pattern must target the same names',
          comment: "{Locked='or'}"
        },
        overlappingKeywordArgs: "Typed dictionary overlaps with keyword parameter: {names}",
        overlappingOverload: 'Overload {obscured} for "{name}" will never be used because its parameters overlap overload {obscuredBy}',
        overloadAbstractImplMismatch: "Overloads must match abstract status of implementation",
        overloadAbstractMismatch: "Overloads must all be abstract or not",
        overloadClassMethodInconsistent: {
          message: 'Overloads for "{name}" use @classmethod inconsistently',
          comment: "{Locked='@classmethod'}"
        },
        overloadFinalImpl: {
          message: "@final decorator should be applied only to the implementation",
          comment: "{Locked='@final'}"
        },
        overloadFinalNoImpl: {
          message: "Only the first overload should be marked @final",
          comment: "{Locked='@final'}"
        },
        overloadImplementationMismatch: "Overloaded implementation is not consistent with signature of overload {index}",
        overloadOverrideImpl: {
          message: "@override decorator should be applied only to the implementation",
          comment: "{Locked='@override'}"
        },
        overloadOverrideNoImpl: {
          message: "Only the first overload should be marked @override",
          comment: "{Locked='@override'}"
        },
        overloadReturnTypeMismatch: 'Overload {prevIndex} for "{name}" overlaps overload {newIndex} and returns an incompatible type',
        overloadStaticMethodInconsistent: {
          message: 'Overloads for "{name}" use @staticmethod inconsistently',
          comment: "{Locked='@staticmethod'}"
        },
        overloadWithoutImplementation: {
          message: '"{name}" is marked as overload, but no implementation is provided',
          comment: "{Locked='overload'}"
        },
        overriddenMethodNotFound: {
          message: 'Method "{name}" is marked as override, but no base method of same name is present',
          comment: "{Locked='override'}"
        },
        overrideDecoratorMissing: {
          message: 'Method "{name}" is not marked as override but is overriding a method in class "{className}"',
          comment: "{Locked='override'}"
        },
        paramAfterKwargsParam: 'Parameter cannot follow "**" parameter',
        paramAlreadyAssigned: 'Parameter "{name}" is already assigned',
        paramAnnotationMissing: 'Type annotation is missing for parameter "{name}"',
        paramAssignmentMismatch: 'Expression of type "{sourceType}" cannot be assigned to parameter of type "{paramType}"',
        paramNameMissing: 'No parameter named "{name}"',
        paramSpecArgsKwargsDuplicate: {
          message: 'Arguments for ParamSpec "{type}" have already been provided',
          comment: "{Locked='ParamSpec'}"
        },
        paramSpecArgsKwargsUsage: {
          message: '"args" and "kwargs" attributes of ParamSpec must both appear within a function signature',
          comment: "{Locked='args','kwargs','ParamSpec'}"
        },
        paramSpecArgsMissing: {
          message: 'Arguments for ParamSpec "{type}" are missing',
          comment: "{Locked='ParamSpec'}"
        },
        paramSpecArgsUsage: {
          message: '"args" attribute of ParamSpec is valid only when used with *args parameter',
          comment: "{Locked='args','ParamSpec','*args'}"
        },
        paramSpecAssignedName: {
          message: 'ParamSpec must be assigned to a variable named "{name}"',
          comment: "{Locked='ParamSpec'}"
        },
        paramSpecContext: {
          message: "ParamSpec is not allowed in this context",
          comment: "{Locked='ParamSpec'}"
        },
        paramSpecDefaultNotTuple: {
          message: "Expected ellipsis, a tuple expression, or ParamSpec for default value of ParamSpec",
          comment: "{Locked='tuple','ParamSpec'}"
        },
        paramSpecFirstArg: {
          message: "Expected name of ParamSpec as first argument",
          comment: "{Locked='ParamSpec'}"
        },
        paramSpecKwargsUsage: {
          message: '"kwargs" attribute of ParamSpec is valid only when used with **kwargs parameter',
          comment: "{Locked='kwargs','ParamSpec','**kwargs'}"
        },
        paramSpecNotUsedByOuterScope: {
          message: 'ParamSpec "{name}" has no meaning in this context',
          comment: "{Locked='ParamSpec'}"
        },
        paramSpecUnknownArg: {
          message: "ParamSpec does not support more than one argument",
          comment: "{Locked='ParamSpec'}"
        },
        paramSpecUnknownMember: {
          message: '"{name}" is not a known attribute of ParamSpec',
          comment: "{Locked='ParamSpec'}"
        },
        paramSpecUnknownParam: {
          message: '"{name}" is unknown parameter to ParamSpec',
          comment: "{Locked='ParamSpec'}"
        },
        paramTypeCovariant: "Covariant type variable cannot be used in parameter type",
        paramTypePartiallyUnknown: 'Type of parameter "{paramName}" is partially unknown',
        paramTypeUnknown: 'Type of parameter "{paramName}" is unknown',
        parenthesizedContextManagerIllegal: {
          message: 'Parentheses within "with" statement requires Python 3.9 or newer',
          comment: "{Locked='with'}"
        },
        patternNeverMatches: 'Pattern will never be matched for subject type "{type}"',
        positionArgAfterNamedArg: "Positional argument cannot appear after keyword arguments",
        positionArgAfterUnpackedDictArg: "Positional argument cannot appear after keyword argument unpacking",
        positionOnlyAfterArgs: 'Position-only parameter separator not allowed after "*" parameter',
        positionOnlyAfterKeywordOnly: '"/" parameter must appear before "*" parameter',
        positionOnlyAfterNon: "Position-only parameter not allowed after parameter that is not position-only",
        positionOnlyFirstParam: "Position-only parameter separator not allowed as first parameter",
        positionOnlyIncompatible: "Position-only parameter separator requires Python 3.8 or newer",
        privateImportFromPyTypedModule: '"{name}" is not exported from module "{module}"',
        privateUsedOutsideOfClass: '"{name}" is private and used outside of the class in which it is declared',
        privateUsedOutsideOfModule: '"{name}" is private and used outside of the module in which it is declared',
        propertyOverridden: {
          message: '"{name}" incorrectly overrides property of same name in class "{className}"',
          comment: "{Locked='property'}"
        },
        propertyStaticMethod: {
          message: "Static methods not allowed for property getter, setter or deleter",
          comment: "{Locked='property','getter','setter','deleter'}"
        },
        protectedUsedOutsideOfClass: '"{name}" is protected and used outside of the class in which it is declared',
        protocolBaseClass: {
          message: 'Protocol class "{classType}" cannot derive from non-Protocol class "{baseType}"',
          comment: "{Locked='Protocol'}"
        },
        protocolBaseClassWithTypeArgs: {
          message: "Type arguments are not allowed with Protocol class when using type parameter syntax",
          comment: "{Locked='Protocol'}"
        },
        protocolIllegal: {
          message: 'Use of "Protocol" requires Python 3.7 or newer',
          comment: "{Locked='Protocol'}"
        },
        protocolNotAllowed: {
          message: '"Protocol" cannot be used in this context',
          comment: "{Locked='Protocol'}"
        },
        protocolTypeArgMustBeTypeParam: {
          message: 'Type argument for "Protocol" must be a type parameter',
          comment: "{Locked='Protocol'}"
        },
        protocolUnsafeOverlap: 'Class overlaps "{name}" unsafely and could produce a match at runtime',
        protocolVarianceContravariant: {
          message: 'Type variable "{variable}" used in generic Protocol "{class}" should be contravariant',
          comment: ["{Locked='Protocol'}", "A generic type is a parameterized type, for example a container where the generic type parameter specifies the type of elements in the container"]
        },
        protocolVarianceCovariant: {
          message: 'Type variable "{variable}" used in generic Protocol "{class}" should be covariant',
          comment: ["{Locked='Protocol'}", "A generic type is a parameterized type, for example a container where the generic type parameter specifies the type of elements in the container"]
        },
        protocolVarianceInvariant: {
          message: 'Type variable "{variable}" used in generic Protocol "{class}" should be invariant',
          comment: ["{Locked='Protocol'}", "A generic type is a parameterized type, for example a container where the generic type parameter specifies the type of elements in the container"]
        },
        pyrightCommentInvalidDiagnosticBoolValue: {
          message: 'Pyright comment directive must be followed by "=" and a value of true or false',
          comment: "{Locked='Pyright','true','false'}"
        },
        pyrightCommentInvalidDiagnosticSeverityValue: {
          message: 'Pyright comment directive must be followed by "=" and a value of true, false, error, warning, information, or none',
          comment: "{Locked='Pyright','true','false','error','warning','information','none'}"
        },
        pyrightCommentMissingDirective: {
          message: "Pyright comment must be followed by a directive (basic or strict) or a diagnostic rule",
          comment: "{Locked='Pyright','basic','strict'}"
        },
        pyrightCommentNotOnOwnLine: {
          message: "Pyright comments used to control file-level settings must appear on their own line",
          comment: "{Locked='Pyright'}"
        },
        pyrightCommentUnknownDiagnosticRule: {
          message: '"{rule}" is an unknown diagnostic rule for pyright comment',
          comment: "{Locked='pyright'}"
        },
        pyrightCommentUnknownDiagnosticSeverityValue: {
          message: '"{value}" is invalid value for pyright comment; expected true, false, error, warning, information, or none',
          comment: "{Locked='pyright','true','false','error','warning','information','none'}"
        },
        pyrightCommentUnknownDirective: {
          message: '"{directive}" is an unknown directive for pyright comment; expected "strict", "standard", or "basic"',
          comment: "{Locked='pyright','strict','standard','basic'}"
        },
        readOnlyArgCount: {
          message: 'Expected a single type argument after "ReadOnly"',
          comment: "{Locked='ReadOnly'}"
        },
        readOnlyNotInTypedDict: {
          message: '"ReadOnly" is not allowed in this context',
          comment: "{Locked='ReadOnly'}"
        },
        recursiveDefinition: 'Type of "{name}" could not be determined because it refers to itself',
        relativeImportNotAllowed: {
          message: 'Relative imports cannot be used with "import .a" form; use "from . import a" instead',
          comment: "{Locked='import .a','from . import a'}"
        },
        requiredArgCount: {
          message: 'Expected a single type argument after "Required"',
          comment: "{Locked='Required'}"
        },
        requiredNotInTypedDict: {
          message: '"Required" is not allowed in this context',
          comment: "{Locked='Required'}"
        },
        returnInAsyncGenerator: {
          message: "Return statement with value is not allowed in async generator",
          comment: "{Locked='async'}"
        },
        returnMissing: 'Function with declared return type "{returnType}" must return value on all code paths',
        returnInExceptionGroup: {
          message: '"return" is not allowed in an "except*" block',
          comment: "{Locked='return','except*'}"
        },
        returnOutsideFunction: {
          message: '"return" can be used only within a function',
          comment: "{Locked='return'}"
        },
        returnTypeContravariant: "Contravariant type variable cannot be used in return type",
        returnTypeMismatch: 'Type "{exprType}" is not assignable to return type "{returnType}"',
        returnTypePartiallyUnknown: 'Return type, "{returnType}", is partially unknown',
        returnTypeUnknown: "Return type is unknown",
        revealLocalsArgs: {
          message: 'Expected no arguments for "reveal_locals" call',
          comment: "{Locked='reveal_locals'}"
        },
        revealLocalsNone: {
          message: "No locals in this scope",
          comment: "{Locked='locals'}"
        },
        revealTypeArgs: {
          message: 'Expected a single positional argument for "reveal_type" call',
          comment: "{Locked='reveal_type'}"
        },
        revealTypeExpectedTextArg: {
          message: 'The "expected_text" argument for function "reveal_type" must be a str literal value',
          comment: "{Locked='expected_text','reveal_type','str'}"
        },
        revealTypeExpectedTextMismatch: 'Type text mismatch; expected "{expected}" but received "{received}"',
        revealTypeExpectedTypeMismatch: 'Type mismatch; expected "{expected}" but received "{received}"',
        selfTypeContext: {
          message: '"Self" is not valid in this context',
          comment: "{Locked='Self'}"
        },
        selfTypeMetaclass: {
          message: '"Self" cannot be used within a metaclass (a subclass of "type")',
          comment: ["{Locked='Self'}", "Metaclasses are a complex concept and it may be best to not localize the term"]
        },
        selfTypeWithTypedSelfOrCls: {
          message: '"Self" cannot be used in a function with a `self` or `cls` parameter that has a type annotation other than "Self"',
          comment: "{Locked='Self','self','cls'}"
        },
        sentinelBadName: {
          message: "The first argument to Sentinel must be a string literal",
          comment: "{Locked='Sentinel'}"
        },
        sentinelParamCount: {
          message: "Sentinel requires one positional argument",
          comment: "{Locked='Sentinel'}"
        },
        sentinelNameMismatch: {
          message: "Sentinel must be assigned to a variable with the same name",
          comment: "{Locked='Sentinel'}"
        },
        setterGetterTypeMismatch: {
          message: "Property setter value type is not assignable to the getter return type",
          comment: ["{Locked='setter','getter'}", "{StrContains=i'property'}", "'property' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        singleOverload: '"{name}" is marked as overload, but additional overloads are missing',
        slotsAttributeError: {
          message: '"{name}" is not specified in __slots__',
          comment: "{Locked='__slots__'}"
        },
        slotsClassVarConflict: {
          message: '"{name}" conflicts with instance variable declared in __slots__',
          comment: "{Locked='__slots__'}"
        },
        starPatternInAsPattern: {
          message: 'Star pattern cannot be used with "as" target',
          comment: ["{Locked='as'}", "Star pattern refers to the use of the * (star) character to represent a variable length pattern match"]
        },
        starPatternInOrPattern: {
          message: "Star pattern cannot be ORed within other patterns",
          comment: ["Star pattern refers to the use of the * (star) character to represent a variable length pattern match", "'ORed' means joined together with a binary 'or' operation"]
        },
        starStarWildcardNotAllowed: '** cannot be used with wildcard "_"',
        staticClsSelfParam: {
          message: 'Static methods should not take a "self" or "cls" parameter',
          comment: "{Locked='self','cls'}"
        },
        stringNonAsciiBytes: {
          message: "Non-ASCII character not allowed in bytes string literal",
          comment: "{Locked='ASCII'}"
        },
        stringNotSubscriptable: "String expression cannot be subscripted in type expression; enclose entire expression in quotes",
        stringUnsupportedEscape: "Unsupported escape sequence in string literal",
        stringUnterminated: "String literal is unterminated",
        stubFileMissing: {
          message: 'Stub file not found for "{importName}"',
          comment: "{StrContains=i'stub'}"
        },
        stubUsesGetAttr: {
          message: 'Type stub file is incomplete; "__getattr__" obscures type errors for module',
          comment: ["{Locked='__getattr__'}", "{StrContains=i'stub'}"]
        },
        sublistParamsIncompatible: {
          message: "Sublist parameters are not supported in Python 3.x",
          comment: "{StrContains=i'sublist'}"
        },
        superCallArgCount: {
          message: 'Expected no more than two arguments to "super" call',
          comment: "{Locked='super'}"
        },
        superCallFirstArg: {
          message: 'Expected class type as first argument to "super" call but received "{type}"',
          comment: "{Locked='super'}"
        },
        superCallSecondArg: {
          message: 'Second argument to "super" call must be object or class that derives from "{type}"',
          comment: "{Locked='super'}"
        },
        superCallZeroArgForm: {
          message: 'Zero-argument form of "super" call is valid only within a method',
          comment: "{Locked='super'}"
        },
        superCallZeroArgFormStaticMethod: {
          message: 'Zero-argument form of "super" call is not valid within a static method',
          comment: "{Locked='super'}"
        },
        symbolIsPossiblyUnbound: '"{name}" is possibly unbound',
        symbolIsUnbound: '"{name}" is unbound',
        symbolIsUndefined: '"{name}" is not defined',
        symbolOverridden: '"{name}" overrides symbol of same name in class "{className}"',
        templateStringBytes: {
          message: "Template string literals (t-strings) cannot be binary",
          comment: "'t-string' is the common English slang for a Python template string"
        },
        templateStringIllegal: {
          message: "Template string literals (t-strings) require Python 3.14 or newer",
          comment: "'t-string' is the common English slang for a Python template string"
        },
        templateStringUnicode: {
          message: "Template string literals (t-strings) cannot be unicode",
          comment: "'t-string' is the common English slang for a Python template string"
        },
        ternaryNotAllowed: "Ternary expression not allowed in type expression",
        totalOrderingMissingMethod: {
          message: 'Class must define one of "__lt__", "__le__", "__gt__", or "__ge__" to use total_ordering',
          comment: "{Locked='__lt__','__le__','__gt__','__ge__','total_ordering'}"
        },
        trailingCommaInFromImport: "Trailing comma not allowed without surrounding parentheses",
        tryWithoutExcept: {
          message: "Try statement must have at least one except or finally clause",
          comment: ["{Locked='except','finally'}", "{StrContains=i'try'}", "'try' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        tupleAssignmentMismatch: {
          message: 'Expression with type "{type}" cannot be assigned to target tuple',
          comment: "{Locked='tuple'}"
        },
        tupleInAnnotation: {
          message: "Tuple expression not allowed in type expression",
          comment: ["{StrContains=i'tuple'}", "'tuple' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        tupleIndexOutOfRange: "Index {index} is out of range for type {type}",
        typeAliasIllegalExpressionForm: "Invalid expression form for type alias definition",
        typeAliasIsRecursiveDirect: 'Type alias "{name}" cannot use itself in its definition',
        typeAliasNotInModuleOrClass: {
          message: "A TypeAlias can be defined only within a module or class scope",
          comment: "{Locked='TypeAlias'}"
        },
        typeAliasRedeclared: {
          message: '"{name}" is declared as a TypeAlias and can be assigned only once',
          comment: "{Locked='TypeAlias'}"
        },
        typeAliasStatementBadScope: {
          message: "A type statement can be used only within a module or class scope",
          comment: "{Locked='type'}"
        },
        typeAliasStatementIllegal: "Type alias statement requires Python 3.12 or newer",
        typeAliasTypeBadScope: "A type alias can be defined only within a module or class scope",
        typeAliasTypeBaseClass: {
          message: 'A type alias defined in a "type" statement cannot be used as a base class',
          comment: `{Locked='"type"'}`
        },
        typeAliasTypeMustBeAssigned: {
          message: "TypeAliasType must be assigned to a variable with the same name as the type alias",
          comment: "{Locked='TypeAliasType'}"
        },
        typeAliasTypeNameArg: {
          message: "First argument to TypeAliasType must be a string literal representing the name of the type alias",
          comment: "{Locked='TypeAliasType'}"
        },
        typeAliasTypeNameMismatch: "Name of type alias must match the name of the variable to which it is assigned",
        typeAliasTypeParamInvalid: {
          message: "Type parameter list must be a tuple containing only TypeVar, TypeVarTuple, or ParamSpec",
          comment: "{Locked='tuple','TypeVar','TypeVarTuple','ParamSpec'}"
        },
        typeAnnotationCall: "Call expression not allowed in type expression",
        typeAnnotationVariable: "Variable not allowed in type expression",
        typeAnnotationWithCallable: {
          message: 'Type argument for "type" must be a class; callables are not supported',
          comment: ["{Locked='type'}", "'callables' are objects that can be called like a function"]
        },
        typeArgListExpected: {
          message: "Expected ParamSpec, ellipsis, or list of types",
          comment: "{Locked='ParamSpec','list'}"
        },
        typeArgListNotAllowed: {
          message: "List expression not allowed for this type argument",
          comment: ["{StrContains=i'list'}", "'list' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        typeArgsExpectingNone: 'Expected no type arguments for class "{name}"',
        typeArgsMismatchOne: "Expected one type argument but received {received}",
        typeArgsMissingForAlias: {
          message: 'Expected type arguments for generic type alias "{name}"',
          comment: "A generic type is a parameterized type, for example a container where the generic type parameter specifies the type of elements in the container"
        },
        typeArgsMissingForClass: {
          message: 'Expected type arguments for generic class "{name}"',
          comment: "A generic type is a parameterized type, for example a container where the generic type parameter specifies the type of elements in the container"
        },
        typeArgsTooFew: 'Too few type arguments provided for "{name}"; expected {expected} but received {received}',
        typeArgsTooMany: 'Too many type arguments provided for "{name}"; expected {expected} but received {received}',
        typeAssignmentMismatch: 'Type "{sourceType}" is not assignable to declared type "{destType}"',
        typeAssignmentMismatchWildcard: 'Import symbol "{name}" has type "{sourceType}", which is not assignable to declared type "{destType}"',
        typeCallNotAllowed: {
          message: "type() call should not be used in type expression",
          comment: "{Locked='type()'}"
        },
        typeCheckOnly: {
          message: '"{name}" is marked as @type_check_only and can be used only in type annotations',
          comment: "{Locked='@type_check_only'}"
        },
        typeCommentDeprecated: {
          message: "Use of type comments is deprecated; use type annotation instead",
          comment: "{Locked='type'}"
        },
        typeExpectedClass: 'Expected class but received "{type}"',
        typeFormArgs: {
          message: '"TypeForm" accepts a single positional argument',
          comment: "{Locked='TypeForm'}"
        },
        typeGuardArgCount: {
          message: 'Expected a single type argument after "TypeGuard" or "TypeIs"',
          comment: "{Locked='TypeGuard','TypeIs'}"
        },
        typeGuardParamCount: "User-defined type guard functions and methods must have at least one input parameter",
        typeIsReturnType: {
          message: 'Return type of TypeIs ("{returnType}") is not consistent with value parameter type ("{type}")',
          comment: "{Locked='TypeIs'}"
        },
        typeNotAwaitable: {
          message: '"{type}" is not awaitable',
          comment: "{Locked='awaitable'}"
        },
        typeNotIntantiable: '"{type}" cannot be instantiated',
        typeNotIterable: '"{type}" is not iterable',
        typeNotSpecializable: 'Could not specialize type "{type}"',
        typeNotSubscriptable: 'Object of type "{type}" is not subscriptable',
        typeNotSupportBinaryOperator: 'Operator "{operator}" not supported for types "{leftType}" and "{rightType}"',
        typeNotSupportBinaryOperatorBidirectional: 'Operator "{operator}" not supported for types "{leftType}" and "{rightType}" when expected type is "{expectedType}"',
        typeNotSupportUnaryOperator: 'Operator "{operator}" not supported for type "{type}"',
        typeNotSupportUnaryOperatorBidirectional: 'Operator "{operator}" not supported for type "{type}" when expected type is "{expectedType}"',
        typeNotUsableWith: 'Object of type "{type}" cannot be used with "with" because it does not correctly implement {method}',
        typeNotUsableWithAsync: {
          message: 'Object of type "{type}" cannot be used with "async with" because it does not correctly implement {method}',
          comment: ["{Locked='async','with}"]
        },
        typeParameterBoundNotAllowed: {
          message: "Bound or constraint cannot be used with a variadic type parameter or ParamSpec",
          comment: ["{Locked='ParamSpec'}", "'variadic' means that it accepts a variable number of arguments"]
        },
        typeParameterConstraintTuple: "Type parameter constraint must be a tuple of two or more types",
        typeParameterExistingTypeParameter: 'Type parameter "{name}" is already in use',
        typeParameterNotDeclared: 'Type parameter "{name}" is not included in the type parameter list for "{container}"',
        typeParametersMissing: "At least one type parameter must be specified",
        typePartiallyUnknown: 'Type of "{name}" is partially unknown',
        typeUnknown: 'Type of "{name}" is unknown',
        typeVarAssignedName: {
          message: 'TypeVar must be assigned to a variable named "{name}"',
          comment: "{Locked='TypeVar'}"
        },
        typeVarAssignmentMismatch: 'Type "{type}" cannot be assigned to type variable "{name}"',
        typeVarBoundAndConstrained: {
          message: "TypeVar cannot be both bound and constrained",
          comment: "{Locked='TypeVar'}"
        },
        typeVarBoundGeneric: {
          message: "TypeVar bound type cannot be generic",
          comment: ["{Locked='TypeVar'}", "A generic type is a parameterized type, for example a container where the generic type parameter specifies the type of elements in the container"]
        },
        typeVarConstraintGeneric: {
          message: "TypeVar constraint type cannot be generic",
          comment: ["{Locked='TypeVar'}", "A generic type is a parameterized type, for example a container where the generic type parameter specifies the type of elements in the container"]
        },
        typeVarDefaultBoundMismatch: {
          message: "TypeVar default type must be a subtype of the bound type",
          comment: "{Locked='TypeVar'}"
        },
        typeVarDefaultConstraintMismatch: {
          message: "TypeVar default type must be one of the constrained types",
          comment: "{Locked='TypeVar'}"
        },
        typeVarDefaultIllegal: "Type variable default types require Python 3.13 or newer",
        typeVarDefaultInvalidTypeVar: 'Type parameter "{name}" has a default type that refers to one or more type variables that are out of scope',
        typeVarFirstArg: {
          message: "Expected name of TypeVar as first argument",
          comment: "{Locked='TypeVar'}"
        },
        typeVarInvalidForMemberVariable: 'Attribute type cannot use type variable "{name}" scoped to local method',
        typeVarNoMember: {
          message: 'TypeVar "{type}" has no attribute "{name}"',
          comment: "{Locked='TypeVar'}"
        },
        typeVarNotSubscriptable: {
          message: 'TypeVar "{type}" is not subscriptable',
          comment: "{Locked='TypeVar'}"
        },
        typeVarNotUsedByOuterScope: 'Type variable "{name}" has no meaning in this context',
        typeVarPossiblyUnsolvable: 'Type variable "{name}" may go unsolved if caller supplies no argument for parameter "{param}"',
        typeVarSingleConstraint: {
          message: "TypeVar must have at least two constrained types",
          comment: "{Locked='TypeVar'}"
        },
        typeVarTupleConstraints: {
          message: "TypeVarTuple cannot have value constraints",
          comment: "{Locked='TypeVarTuple'}"
        },
        typeVarTupleContext: {
          message: "TypeVarTuple is not allowed in this context",
          comment: "{Locked='TypeVarTuple'}"
        },
        typeVarTupleDefaultNotUnpacked: {
          message: "TypeVarTuple default type must be an unpacked tuple or TypeVarTuple",
          comment: "{Locked='TypeVarTuple','tuple'}"
        },
        typeVarTupleMustBeUnpacked: {
          message: "Unpack operator is required for TypeVarTuple value",
          comment: "{Locked='TypeVarTuple'}"
        },
        typeVarTupleUnknownParam: {
          message: '"{name}" is unknown parameter to TypeVarTuple',
          comment: "{Locked='TypeVarTuple'}"
        },
        typeVarUnknownParam: {
          message: '"{name}" is unknown parameter to TypeVar',
          comment: "{Locked='TypeVar'}"
        },
        typeVarUsedByOuterScope: {
          message: 'TypeVar "{name}" is already in use by an outer scope',
          comment: "{Locked='TypeVar'}"
        },
        typeVarUsedOnlyOnce: {
          message: 'TypeVar "{name}" appears only once in generic function signature',
          comment: ["{Locked='TypeVar'}", "A generic type is a parameterized type, for example a container where the generic type parameter specifies the type of elements in the container"]
        },
        typeVarVariance: {
          message: "TypeVar cannot be both covariant and contravariant",
          comment: "{Locked='TypeVar'}"
        },
        typeVarWithDefaultFollowsVariadic: {
          message: 'TypeVar "{typeVarName}" has a default value and cannot follow TypeVarTuple "{variadicName}"',
          comment: "{Locked='TypeVar','TypeVarTuple'}"
        },
        typeVarWithoutDefault: '"{name}" cannot appear after "{other}" in type parameter list because it has no default type',
        typeVarsNotInGenericOrProtocol: {
          message: "Generic[] or Protocol[] must include all type variables",
          comment: "{Locked='Generic[]','Protocol[]'}"
        },
        typedDictAccess: {
          message: "Could not access item in TypedDict",
          comment: "{Locked='TypedDict'}"
        },
        typedDictAssignedName: {
          message: 'TypedDict must be assigned to a variable named "{name}"',
          comment: "{Locked='TypedDict'}"
        },
        typedDictBadVar: {
          message: "TypedDict classes can contain only type annotations",
          comment: "{Locked='TypedDict'}"
        },
        typedDictBaseClass: {
          message: "All base classes for TypedDict classes must also be TypedDict classes",
          comment: "{Locked='TypedDict'}"
        },
        typedDictBoolParam: {
          message: 'Expected "{name}" parameter to have a value of True or False',
          comment: "{Locked='True','False'}"
        },
        typedDictClosedExtras: {
          message: 'Base class "{name}" is a TypedDict that limits the type of extra items to type "{type}"',
          comment: "{Locked='closed','TypedDict'}"
        },
        typedDictClosedNoExtras: {
          message: 'Base class "{name}" is a closed TypedDict; extra items are not allowed',
          comment: "{Locked='closed','TypedDict'}"
        },
        typedDictClosedFalseNonOpenBase: {
          message: 'Base class "{name}" is not an open TypedDict; closed=False is not allowed',
          comment: "{Locked='TypedDict','closed'}"
        },
        typedDictDelete: {
          message: "Could not delete item in TypedDict",
          comment: "{Locked='TypedDict'}"
        },
        typedDictEmptyName: {
          message: "Names within a TypedDict cannot be empty",
          comment: "{Locked='TypedDict'}"
        },
        typedDictEntryName: "Expected string literal for dictionary entry name",
        typedDictEntryUnique: "Names within a dictionary must be unique",
        typedDictExtraArgs: {
          message: "Extra TypedDict arguments not supported",
          comment: "{Locked='TypedDict'}"
        },
        typedDictExtraItemsClosed: {
          message: 'TypedDict can use either "closed" or "extra_items" but not both',
          comment: "{Locked='TypedDict','closed','extra_items'}"
        },
        typedDictFieldNotRequiredRedefinition: {
          message: 'TypedDict item "{name}" cannot be redefined as NotRequired',
          comment: "{Locked='TypedDict','NotRequired'}"
        },
        typedDictFieldReadOnlyRedefinition: {
          message: 'TypedDict item "{name}" cannot be redefined as ReadOnly',
          comment: "{Locked='TypedDict','ReadOnly'}"
        },
        typedDictFieldRequiredRedefinition: {
          message: 'TypedDict item "{name}" cannot be redefined as Required',
          comment: "{Locked='TypedDict','Required'}"
        },
        typedDictFirstArg: {
          message: "Expected TypedDict class name as first argument",
          comment: "{Locked='TypedDict'}"
        },
        typedDictInClassPattern: {
          message: "TypedDict class not allowed in class pattern",
          comment: "{Locked='TypedDict'}"
        },
        typedDictInitsubclassParameter: {
          message: 'TypedDict does not support __init_subclass__ parameter "{name}"',
          comment: "{Locked='TypedDict','__init_subclass__'}"
        },
        typedDictNotAllowed: {
          message: '"TypedDict" cannot be used in this context',
          comment: "{Locked='TypedDict'}"
        },
        typedDictSecondArgDict: {
          message: "Expected dict or keyword parameter as second parameter",
          comment: "{Locked='dict'}"
        },
        typedDictSecondArgDictEntry: "Expected simple dictionary entry",
        typedDictSet: {
          message: "Could not assign item in TypedDict",
          comment: "{Locked='TypedDict'}"
        },
        unaccessedClass: 'Class "{name}" is not accessed',
        unaccessedFunction: 'Function "{name}" is not accessed',
        unaccessedImport: 'Import "{name}" is not accessed',
        unaccessedSymbol: '"{name}" is not accessed',
        unaccessedVariable: 'Variable "{name}" is not accessed',
        unannotatedFunctionSkipped: 'Analysis of function "{name}" is skipped because it is unannotated',
        unaryOperationNotAllowed: "Unary operator not allowed in type expression",
        unexpectedAsyncToken: {
          message: 'Expected "def", "with" or "for" to follow "async"',
          comment: "{Locked='def','with','for','async'}"
        },
        unexpectedEof: "Unexpected EOF",
        unexpectedExprToken: "Unexpected token at end of expression",
        unexpectedIndent: "Unexpected indentation",
        unexpectedUnindent: "Unindent not expected",
        unhashableDictKey: "Dictionary key must be hashable",
        unhashableSetEntry: {
          message: "Set entry must be hashable",
          comment: ["{StrContains=i'set'}", "'set' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        uninitializedAbstractVariables: {
          message: 'Variables defined in abstract base class are not initialized in final class "{classType}"',
          comment: "{Locked='final'}"
        },
        uninitializedInstanceVariable: {
          message: 'Instance variable "{name}" is not initialized in the class body or __init__ method',
          comment: "{Locked='__init__'}"
        },
        unionForwardReferenceNotAllowed: {
          message: "Union syntax cannot be used with string operand; use quotes around entire expression",
          comment: "{Locked='Union'}"
        },
        unionSyntaxIllegal: {
          message: "Alternative syntax for unions requires Python 3.10 or newer",
          comment: "'unions' as in the mathematical set theory term"
        },
        unionTypeArgCount: {
          message: "Union requires two or more type arguments",
          comment: "{Locked='Union'}"
        },
        unionUnpackedTuple: {
          message: "Union cannot include an unpacked tuple",
          comment: "{Locked='Union','tuple'}"
        },
        unionUnpackedTypeVarTuple: {
          message: "Union cannot include an unpacked TypeVarTuple",
          comment: "{Locked='Union','TypeVarTuple'}"
        },
        unnecessaryCast: {
          message: 'Unnecessary "cast" call; type is already "{type}"',
          comment: "{Locked='cast'}"
        },
        unnecessaryIsInstanceAlways: {
          message: 'Unnecessary isinstance call; "{testType}" is always an instance of "{classType}"',
          comment: "{Locked='isinstance'}"
        },
        unnecessaryIsSubclassAlways: {
          message: 'Unnecessary issubclass call; "{testType}" is always a subclass of "{classType}"',
          comment: "{Locked='issubclass'}"
        },
        unnecessaryIsInstanceNever: {
          message: 'Unnecessary isinstance call; "{testType}" is never an instance of "{classType}"',
          comment: "{Locked='isinstance'}"
        },
        unnecessaryIsSubclassNever: {
          message: 'Unnecessary issubclass call; "{testType}" is never a subclass of "{classType}"',
          comment: "{Locked='issubclass'}"
        },
        unnecessaryPyrightIgnore: {
          message: 'Unnecessary "# pyright: ignore" comment',
          comment: "{Locked='# pyright: ignore'}"
        },
        unnecessaryPyrightIgnoreRule: {
          message: 'Unnecessary "# pyright: ignore" rule: "{name}"',
          comment: "{Locked='# pyright: ignore'}"
        },
        unnecessaryTypeIgnore: {
          message: 'Unnecessary "# type: ignore" comment',
          comment: "{Locked='# type: ignore'}"
        },
        unpackArgCount: {
          message: 'Expected a single type argument after "Unpack"',
          comment: "{Locked='Unpack'}"
        },
        unpackExpectedTypeVarTuple: {
          message: "Expected TypeVarTuple or tuple as type argument for Unpack",
          comment: "{Locked='TypeVarTuple','tuple','Unpack'}"
        },
        unpackExpectedTypedDict: {
          message: "Expected TypedDict type argument for Unpack",
          comment: "{Locked='TypedDict','Unpack'}"
        },
        unpackIllegalInComprehension: {
          message: "Unpack operation not allowed in comprehension",
          comment: "A comprehension is a 'set of looping and filtering instructions' applied to a collection to generate a new collection; the word may not be translatable"
        },
        unpackInAnnotation: "Unpack operator not allowed in type expression",
        unpackInDict: "Unpack operation not allowed in dictionaries",
        unpackInSet: {
          message: "Unpack operator not allowed within a set",
          comment: "{Locked='set'}"
        },
        unpackNotAllowed: {
          message: "Unpack is not allowed in this context",
          comment: "{Locked='Unpack'}"
        },
        unpackOperatorNotAllowed: "Unpack operation is not allowed in this context",
        unpackTuplesIllegal: {
          message: "Unpack operation not allowed in tuples prior to Python 3.8",
          comment: "'tuple' is a keyword and should not be localized, but here it is pluralized"
        },
        unpackedArgInTypeArgument: "Unpacked arguments cannot be used in this context",
        unpackedArgWithVariadicParam: {
          message: "Unpacked argument cannot be used for TypeVarTuple parameter",
          comment: "{Locked='TypeVarTuple'}"
        },
        unpackedDictArgumentNotMapping: {
          message: 'Argument expression after ** must be a mapping with a "str" key type',
          comment: "{Locked='str'}"
        },
        unpackedDictSubscriptIllegal: "Dictionary unpack operator in subscript is not allowed",
        unpackedSubscriptIllegal: "Unpack operator in subscript requires Python 3.11 or newer",
        unpackedTypeVarTupleExpected: {
          message: "Expected unpacked TypeVarTuple; use Unpack[{name1}] or *{name2}",
          comment: "{Locked='TypeVarTuple','Unpack[{name1}]','*{name2}'}"
        },
        unpackedTypedDictArgument: {
          message: "Unable to match unpacked TypedDict argument to parameters",
          comment: "{Locked='TypedDict'}"
        },
        unreachableCodeCondition: "Code is not analyzed because condition is statically evaluated as false",
        unreachableCodeStructure: "Code is structurally unreachable",
        unreachableCodeType: "Type analysis indicates code is unreachable",
        unreachableExcept: {
          message: "Except clause is unreachable because exception is already handled",
          comment: ["{StrContains=i'except'}", "'except' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        unsupportedDunderAllOperation: {
          message: 'Operation on "__all__" is not supported, so exported symbol list may be incorrect',
          comment: "{Locked='__all__'}"
        },
        unusedCallResult: 'Result of call expression is of type "{type}" and is not used; assign to variable "_" if this is intentional',
        unusedCoroutine: {
          message: 'Result of async function call is not used; use "await" or assign result to variable',
          comment: "{Locked='async'}"
        },
        unusedExpression: "Expression value is unused",
        varAnnotationIllegal: {
          message: "Type annotations for variables requires Python 3.6 or newer; use type comment for compatibility with previous versions",
          comment: "{Locked='type'}"
        },
        variableFinalOverride: {
          message: 'Variable "{name}" is marked Final and overrides non-Final variable of same name in class "{className}"',
          comment: "{Locked='Final'}"
        },
        variadicTypeArgsTooMany: {
          message: "Type argument list can have at most one unpacked TypeVarTuple or tuple",
          comment: "{Locked='TypeVarTuple','tuple'}"
        },
        variadicTypeParamTooManyAlias: {
          message: "Type alias can have at most one TypeVarTuple type parameter but received multiple ({names})",
          comment: "{Locked='TypeVarTuple'}"
        },
        variadicTypeParamTooManyClass: {
          message: "Generic class can have at most one TypeVarTuple type parameter but received multiple ({names})",
          comment: ["{Locked='TypeVarTuple'}", "A generic type is a parameterized type, for example a container where the generic type parameter specifies the type of elements in the container"]
        },
        walrusIllegal: 'Operator ":=" requires Python 3.8 or newer',
        walrusNotAllowed: 'Operator ":=" is not allowed in this context without surrounding parentheses',
        wildcardInFunction: {
          message: "Wildcard import not allowed within a class or function",
          comment: "{Locked='import'}"
        },
        wildcardLibraryImport: {
          message: "Wildcard import from a library not allowed",
          comment: "{Locked='import'}"
        },
        wildcardPatternTypePartiallyUnknown: "Type captured by wildcard pattern is partially unknown",
        wildcardPatternTypeUnknown: "Type captured by wildcard pattern is unknown",
        yieldFromIllegal: {
          message: 'Use of "yield from" requires Python 3.3 or newer',
          comment: "{Locked='yield from'}"
        },
        yieldFromOutsideAsync: {
          message: '"yield from" not allowed in an async function',
          comment: "{Locked='yield from','async'}"
        },
        yieldOutsideFunction: {
          message: '"yield" not allowed outside of a function or lambda',
          comment: "{Locked='yield'}"
        },
        yieldWithinComprehension: {
          message: '"yield" not allowed inside a comprehension',
          comment: ["{Locked='yield'}", "A comprehension is a 'set of looping and filtering instructions' applied to a collection to generate a new collection; the word may not be translatable"]
        },
        zeroCaseStatementsFound: {
          message: "Match statement must include at least one case statement",
          comment: ["{Locked='case'}", "{StrContains=i'match'}", "'match' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        zeroLengthTupleNotAllowed: {
          message: "Zero-length tuple is not allowed in this context",
          comment: "{Locked='tuple'}"
        }
      },
      DiagnosticAddendum: {
        annotatedNotAllowed: {
          message: '"Annotated" special form cannot be used with instance and class checks',
          comment: "{Locked='Annotated'}"
        },
        argParam: 'Argument corresponds to parameter "{paramName}"',
        argParamFunction: 'Argument corresponds to parameter "{paramName}" in function "{functionName}"',
        argsParamMissing: 'Parameter "*{paramName}" has no corresponding parameter',
        argsPositionOnly: "Position-only parameter mismatch; expected {expected} but received {received}",
        argumentType: 'Argument type is "{type}"',
        argumentTypes: "Argument types: ({types})",
        assignToNone: {
          message: 'Type is not assignable to "None"',
          comment: "{Locked='None'}"
        },
        asyncHelp: {
          message: 'Did you mean "async with"?',
          comment: "{Locked='async with'}"
        },
        baseClassIncompatible: 'Base class "{baseClass}" is incompatible with type "{type}"',
        baseClassIncompatibleSubclass: 'Base class "{baseClass}" derives from "{subclass}" which is incompatible with type "{type}"',
        baseClassOverriddenType: 'Base class "{baseClass}" provides type "{type}", which is overridden',
        baseClassOverridesType: 'Base class "{baseClass}" overrides with type "{type}"',
        bytesTypePromotions: {
          message: 'Set disableBytesTypePromotions to false to enable type promotion behavior for "bytearray" and "memoryview"',
          comment: "{Locked='disableBytesTypePromotions','false','bytearray','memoryview'}"
        },
        conditionalRequiresBool: {
          message: 'Method __bool__ for type "{operandType}" returns type "{boolReturnType}" rather than "bool"',
          comment: "{Locked='__bool__'}"
        },
        dataClassFieldLocation: "Field declaration",
        dataClassFrozen: '"{name}" is frozen',
        dataProtocolUnsupported: '"{name}" is a data protocol',
        descriptorAccessBindingFailed: {
          message: 'Failed to bind method "{name}" for descriptor class "{className}"',
          comment: "Binding is the process through which Pyright determines what object a name refers to"
        },
        descriptorAccessCallFailed: 'Failed to call method "{name}" for descriptor class "{className}"',
        finalMethod: {
          message: "Final method",
          comment: "{Locked='Final'}"
        },
        functionParamDefaultMissing: 'Parameter "{name}" is missing default argument',
        functionParamName: 'Parameter name mismatch: "{destName}" versus "{srcName}"',
        functionParamPositionOnly: 'Position-only parameter mismatch; parameter "{name}" is not position-only',
        functionReturnTypeMismatch: 'Function return type "{sourceType}" is incompatible with type "{destType}"',
        functionTooFewParams: "Function accepts too few positional parameters; expected {expected} but received {received}",
        functionTooManyParams: "Function accepts too many positional parameters; expected {expected} but received {received}",
        genericClassNotAllowed: {
          message: "Generic type with type arguments not allowed for instance or class checks",
          comment: "A generic type is a parameterized type, for example a container where the generic type parameter specifies the type of elements in the container"
        },
        incompatibleDeleter: {
          message: "Property deleter method is incompatible",
          comment: ["{Locked='deleter'}", "{StrContains=i'property'}", "'property' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        incompatibleGetter: {
          message: "Property getter method is incompatible",
          comment: ["{Locked='getter'}", "{StrContains=i'property'}", "'property' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        incompatibleSetter: {
          message: "Property setter method is incompatible",
          comment: ["{Locked='setter'}", "{StrContains=i'property'}", "'property' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        initMethodLocation: {
          message: 'The __init__ method is defined in class "{type}"',
          comment: "{Locked='__init__'}"
        },
        initMethodSignature: {
          message: 'Signature of __init__ is "{type}"',
          comment: "{Locked='__init__'}"
        },
        initSubclassLocation: {
          message: 'The __init_subclass__ method is defined in class "{name}"',
          comment: "{Locked='__init_subclass__'}"
        },
        invariantSuggestionDict: {
          message: 'Consider switching from "dict" to "Mapping" which is covariant in the value type',
          comment: "{Locked='dict','Mapping'}"
        },
        invariantSuggestionList: {
          message: 'Consider switching from "list" to "Sequence" which is covariant',
          comment: "{Locked='list','Sequence'}"
        },
        invariantSuggestionSet: {
          message: 'Consider switching from "set" to "Container" which is covariant',
          comment: "{Locked='set','Container'}"
        },
        isinstanceClassNotSupported: '"{type}" is not supported for instance and class checks',
        keyNotRequired: '"{name}" is not a required key in "{type}", so access may result in runtime exception',
        keyReadOnly: '"{name}" is a read-only key in "{type}"',
        keyRequiredDeleted: '"{name}" is a required key and cannot be deleted',
        keyUndefined: '"{name}" is not a defined key in "{type}"',
        kwargsParamMissing: 'Parameter "**{paramName}" has no corresponding parameter',
        listAssignmentMismatch: 'Type "{type}" is incompatible with target list',
        literalAssignmentMismatch: '"{sourceType}" is not assignable to type "{destType}"',
        literalNotAllowed: {
          message: '"Literal" special form cannot be used with instance and class checks',
          comment: "{Locked='Literal'}"
        },
        matchIsNotExhaustiveHint: {
          message: 'If exhaustive handling is not intended, add "case _: pass"',
          comment: "{Locked='case _: pass'}"
        },
        matchIsNotExhaustiveType: 'Unhandled type: "{type}"',
        memberAssignment: 'Expression of type "{type}" cannot be assigned to attribute "{name}" of class "{classType}"',
        memberIsAbstract: '"{type}.{name}" is not implemented',
        memberIsAbstractMore: {
          message: "and {count} more...",
          comment: "{StrEnds='...'}"
        },
        memberIsClassVarInProtocol: {
          message: '"{name}" is defined as a ClassVar in protocol',
          comment: "{Locked='ClassVar'}"
        },
        memberIsInitVar: {
          message: '"{name}" is an init-only field',
          comment: "{Locked='init-only'}"
        },
        memberIsInvariant: '"{name}" is invariant because it is mutable',
        memberIsNotClassVarInClass: {
          message: '"{name}" must be defined as a ClassVar to be compatible with protocol',
          comment: "{Locked='ClassVar'}"
        },
        memberIsNotClassVarInProtocol: {
          message: '"{name}" is not defined as a ClassVar in protocol',
          comment: "{Locked='ClassVar'}"
        },
        memberIsNotReadOnlyInProtocol: '"{name}" is not read-only in protocol',
        memberIsReadOnlyInProtocol: '"{name}" is read-only in protocol',
        memberIsWritableInProtocol: '"{name}" is writable in protocol',
        memberSetClassVar: {
          message: 'Attribute "{name}" cannot be assigned through a class instance because it is a ClassVar',
          comment: "{Locked='ClassVar'}"
        },
        memberTypeMismatch: '"{name}" is an incompatible type',
        memberUnknown: 'Attribute "{name}" is unknown',
        metaclassConflict: {
          message: 'Metaclass "{metaclass1}" conflicts with "{metaclass2}"',
          comment: "Metaclasses are a complex concept and it may be best to not localize the term"
        },
        missingDeleter: {
          message: "Property deleter method is missing",
          comment: ["{Locked='deleter'}", "{StrContains=i'property'}", "'property' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        missingGetter: {
          message: "Property getter method is missing",
          comment: ["{Locked='getter'}", "{StrContains=i'property'}", "'property' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        missingSetter: {
          message: "Property setter method is missing",
          comment: ["{Locked='setter'}", "{StrContains=i'property'}", "'property' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        namedParamMissingInDest: 'Extra parameter "{name}"',
        namedParamMissingInSource: 'Missing keyword parameter "{name}"',
        namedParamTypeMismatch: 'Keyword parameter "{name}" of type "{sourceType}" is incompatible with type "{destType}"',
        namedTupleNotAllowed: {
          message: "NamedTuple cannot be used for instance or class checks",
          comment: "{Locked='NamedTuple'}"
        },
        newMethodLocation: {
          message: 'The __new__ method is defined in class "{type}"',
          comment: "{Locked='__new__'}"
        },
        newMethodSignature: {
          message: 'Signature of __new__ is "{type}"',
          comment: "{Locked='__new__'}"
        },
        newTypeClassNotAllowed: {
          message: "Type created with NewType cannot be used with instance and class checks",
          comment: "{Locked='NewType'}"
        },
        noOverloadAssignable: 'No overloaded function matches type "{type}"',
        noneNotAllowed: {
          message: "None cannot be used for instance or class checks",
          comment: "{Locked='None'}"
        },
        orPatternMissingName: "Missing names: {name}",
        overloadIndex: "Overload {index} is the closest match",
        overloadNotAssignable: 'One or more overloads of "{name}" is not assignable',
        overloadSignature: "Overload signature is defined here",
        overriddenMethod: "Overridden method",
        overriddenSymbol: "Overridden symbol",
        overrideInvariantMismatch: 'Override type "{overrideType}" is not the same as base type "{baseType}"',
        overrideIsInvariant: "Variable is mutable so its type is invariant",
        overrideNoOverloadMatches: "No overload signature in override is compatible with base method",
        overrideNotClassMethod: {
          message: "Base method is declared as a classmethod but override is not",
          comment: "{Locked='classmethod'}"
        },
        overrideNotInstanceMethod: "Base method is declared as an instance method but override is not",
        overrideNotStaticMethod: {
          message: "Base method is declared as a staticmethod but override is not",
          comment: "{Locked='staticmethod'}"
        },
        overrideOverloadNoMatch: "Override does not handle all overloads of base method",
        overrideOverloadOrder: "Overloads for override method must be in the same order as the base method",
        overrideParamKeywordNoDefault: 'Keyword parameter "{name}" mismatch: base parameter has default argument value, override parameter does not',
        overrideParamKeywordType: 'Keyword parameter "{name}" type mismatch: base parameter is type "{baseType}", override parameter is type "{overrideType}"',
        overrideParamName: 'Parameter {index} name mismatch: base parameter is named "{baseName}", override parameter is named "{overrideName}"',
        overrideParamNameExtra: 'Parameter "{name}" is missing in base',
        overrideParamNameMissing: 'Parameter "{name}" is missing in override',
        overrideParamNamePositionOnly: 'Parameter {index} mismatch: base parameter "{baseName}" is keyword parameter, override parameter is position-only',
        overrideParamNoDefault: "Parameter {index} mismatch: base parameter has default argument value, override parameter does not",
        overrideParamType: 'Parameter {index} type mismatch: base parameter is type "{baseType}", override parameter is type "{overrideType}"',
        overridePositionalParamCount: "Positional parameter count mismatch; base method has {baseCount}, but override has {overrideCount}",
        overrideReturnType: 'Return type mismatch: base method returns type "{baseType}", override returns type "{overrideType}"',
        overrideType: 'Base class defines type as "{type}"',
        paramAssignment: 'Parameter {index}: type "{sourceType}" is incompatible with type "{destType}"',
        paramSpecMissingInOverride: {
          message: "ParamSpec parameters are missing in override method",
          comment: "{Locked='ParamSpec'}"
        },
        paramType: 'Parameter type is "{paramType}"',
        privateImportFromPyTypedSource: 'Import from "{module}" instead',
        propertyAccessFromProtocolClass: "A property defined within a protocol class cannot be accessed as a class variable",
        propertyMethodIncompatible: {
          message: 'Property method "{name}" is incompatible',
          comment: ["{StrContains=i'property'}", "'property' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        propertyMethodMissing: {
          message: 'Property method "{name}" is missing in override',
          comment: ["{StrContains=i'property'}", "'property' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        propertyMissingDeleter: {
          message: 'Property "{name}" has no defined deleter',
          comment: ["{Locked='deleter'}", "{StrContains=i'property'}", "'property' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        propertyMissingSetter: {
          message: 'Property "{name}" has no defined setter',
          comment: ["{Locked='setter'}", "{StrContains=i'property'}", "'property' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        protocolIncompatible: '"{sourceType}" is incompatible with protocol "{destType}"',
        protocolMemberMissing: '"{name}" is not present',
        protocolRequiresRuntimeCheckable: {
          message: "Protocol class must be @runtime_checkable to be used with instance and class checks",
          comment: "{Locked='Protocol','@runtime_checkable'}"
        },
        protocolSourceIsNotConcrete: '"{sourceType}" is not a concrete class type and cannot be assigned to type "{destType}"',
        protocolUnsafeOverlap: 'Attributes of "{name}" have the same names as the protocol',
        pyrightCommentIgnoreTip: {
          message: 'Use "# pyright: ignore[<diagnostic rules>]" to suppress diagnostics for a single line',
          comment: "{Locked='# pyright: ignore[<diagnostic rules>]'}"
        },
        readOnlyAttribute: 'Attribute "{name}" is read-only',
        seeClassDeclaration: "See class declaration",
        seeDeclaration: "See declaration",
        seeFunctionDeclaration: "See function declaration",
        seeMethodDeclaration: "See method declaration",
        seeParameterDeclaration: "See parameter declaration",
        seeTypeAliasDeclaration: "See type alias declaration",
        seeVariableDeclaration: "See variable declaration",
        tupleAssignmentMismatch: {
          message: 'Type "{type}" is incompatible with target tuple',
          comment: "{Locked='tuple'}"
        },
        tupleEntryTypeMismatch: {
          message: "Tuple entry {entry} is incorrect type",
          comment: ["{StrContains=i'tuple'}", "'tuple' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        tupleSizeIndeterminateSrc: {
          message: "Tuple size mismatch; expected {expected} but received indeterminate",
          comment: ["{StrContains=i'tuple'}", "'tuple' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        tupleSizeIndeterminateSrcDest: {
          message: "Tuple size mismatch; expected {expected} or more but received indeterminate",
          comment: ["{StrContains=i'tuple'}", "'tuple' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        tupleSizeMismatch: {
          message: "Tuple size mismatch; expected {expected} but received {received}",
          comment: ["{StrContains=i'tuple'}", "'tuple' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        tupleSizeMismatchIndeterminateDest: {
          message: "Tuple size mismatch; expected {expected} or more but received {received}",
          comment: ["{StrContains=i'tuple'}", "'tuple' is a keyword and should not be localized. It is only capitalized here because it is the first word in the sentence"]
        },
        typeAliasInstanceCheck: {
          message: 'Type alias created with "type" statement cannot be used with instance and class checks',
          comment: "{Locked='type'}"
        },
        typeAssignmentMismatch: 'Type "{sourceType}" is not assignable to type "{destType}"',
        typeBound: 'Type "{sourceType}" is not assignable to upper bound "{destType}" for type variable "{name}"',
        typeConstrainedTypeVar: 'Type "{type}" is not assignable to constrained type variable "{name}"',
        typeIncompatible: '"{sourceType}" is not assignable to "{destType}"',
        typeNotClass: '"{type}" is not a class',
        typeNotStringLiteral: '"{type}" is not a string literal',
        typeOfSymbol: 'Type of "{name}" is "{type}"',
        typeParamSpec: {
          message: 'Type "{type}" is incompatible with ParamSpec "{name}"',
          comment: "{Locked='ParamSpec'}"
        },
        typeUnsupported: 'Type "{type}" is unsupported',
        typeVarDefaultOutOfScope: 'Type variable "{name}" is not in scope',
        typeVarIsContravariant: 'Type parameter "{name}" is contravariant, but "{sourceType}" is not a supertype of "{destType}"',
        typeVarIsCovariant: 'Type parameter "{name}" is covariant, but "{sourceType}" is not a subtype of "{destType}"',
        typeVarIsInvariant: 'Type parameter "{name}" is invariant, but "{sourceType}" is not the same as "{destType}"',
        typeVarNotAllowed: {
          message: "TypeVar not allowed for instance or class checks",
          comment: "{Locked='TypeVar'}"
        },
        typeVarTupleRequiresKnownLength: {
          message: "TypeVarTuple cannot be bound to a tuple of unknown length",
          comment: "{Locked='TypeVarTuple','tuple'}"
        },
        typeVarUnnecessarySuggestion: "Use {type} instead",
        typeVarUnsolvableRemedy: "Provide an overload that specifies the return type when the argument is not supplied",
        typeVarsMissing: "Missing type variables: {names}",
        typedDictBaseClass: {
          message: 'Class "{type}" is not a TypedDict',
          comment: "{Locked='TypedDict'}"
        },
        typedDictClassNotAllowed: {
          message: "TypedDict class not allowed for instance or class checks",
          comment: "{Locked='TypedDict'}"
        },
        typedDictClosedExtraNotAllowed: 'Cannot add item "{name}"',
        typedDictClosedExtraTypeMismatch: 'Cannot add item "{name}" with type "{type}"',
        typedDictClosedFieldNotReadOnly: {
          message: 'Cannot add item "{name}" because it must be ReadOnly',
          comment: "{Locked='ReadOnly'}"
        },
        typedDictClosedFieldNotRequired: {
          message: 'Cannot add item "{name}" because it must be NotRequired',
          comment: "{Locked='NotRequired'}"
        },
        typedDictExtraFieldNotAllowed: '"{name}" is not present in "{type}"',
        typedDictExtraFieldTypeMismatch: {
          message: 'Type of "{name}" is incompatible with type of "extra_items" in "{type}"',
          comment: "{Locked='extra_items'}"
        },
        typedDictFieldMissing: '"{name}" is missing from "{type}"',
        typedDictFieldNotReadOnly: '"{name}" is not read-only in "{type}"',
        typedDictFieldNotRequired: '"{name}" is not required in "{type}"',
        typedDictFieldRequired: '"{name}" is required in "{type}"',
        typedDictFieldTypeMismatch: 'Type "{type}" is not assignable to item "{name}"',
        typedDictFieldUndefined: '"{name}" is an undefined item in type "{type}"',
        typedDictKeyAccess: {
          message: 'Use ["{name}"] to reference item in TypedDict',
          comment: "{Locked='TypedDict'}"
        },
        typedDictNotAllowed: {
          message: "TypedDict cannot be used for instance or class checks",
          comment: "{Locked='TypedDict'}"
        },
        unhashableType: 'Type "{type}" is not hashable',
        uninitializedAbstractVariable: 'Instance variable "{name}" is defined in abstract base class "{classType}" but not initialized',
        unreachableExcept: '"{exceptionType}" is a subclass of "{parentType}"',
        useDictInstead: {
          message: "Use dict[T1, T2] to indicate a dictionary type",
          comment: "{Locked='dict[T1, T2]'}"
        },
        useListInstead: {
          message: "Use list[T] to indicate a list type or T1 | T2 to indicate a union type",
          comment: "{Locked='list[T]','list','T1 | T2','union'}"
        },
        useTupleInstead: {
          message: "Use tuple[T1, ..., Tn] to indicate a tuple type or T1 | T2 to indicate a union type",
          comment: "{Locked='tuple[T1, ..., Tn]','tuple','T1 | T2','union'}"
        },
        useTypeInstead: {
          message: "Use type[T] instead",
          comment: "{Locked='type[T]'}"
        },
        varianceMismatchForClass: 'Variance of type argument "{typeVarName}" is incompatible with base class "{className}"',
        varianceMismatchForTypeAlias: 'Variance of type argument "{typeVarName}" is incompatible with "{typeAliasParam}"'
      },
      Service: {
        longOperation: "Enumeration of workspace source files is taking a long time. Consider opening a sub-folder instead. [Learn more](https://aka.ms/workspace-too-many-files)"
      }
    };
  }
});

// node_modules/@zzzen/pyright-internal/dist/localization/package.nls.es.json
var require_package_nls_es = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/localization/package.nls.es.json"(exports2, module2) {
    module2.exports = {
      CodeAction: {
        createTypeStub: "Crear Tipo Stub",
        createTypeStubFor: 'Crear Tipo Stub Para "{moduleName}"',
        executingCommand: "Ejecutando el comando",
        filesToAnalyzeCount: "{count} archivos para analizar",
        filesToAnalyzeOne: "1 archivo para analizar",
        findingReferences: "Buscando referencias",
        organizeImports: "Organizar Importaciones"
      },
      Completion: {
        autoImportDetail: "Importaci\xF3n autom\xE1tica",
        indexValueDetail: "Valor de \xEDndice"
      },
      Diagnostic: {
        abstractMethodInvocation: 'No se puede llamar al m\xE9todo "{method}" porque es abstracto y no se ha implementado.',
        annotatedMetadataInconsistent: 'El tipo de metadatos anotados "{metadataType}" no es compatible con el tipo "{type}"',
        annotatedParamCountMismatch: "El recuento de anotaciones del par\xE1metro no coincide: se esperaba {expected}, pero se recibi\xF3 {received}",
        annotatedTypeArgMissing: 'Se espera un argumento de tipo y una o m\xE1s anotaciones para "Annotated".',
        annotationBytesString: "Las expresiones de tipo no pueden usar literales de cadena de bytes",
        annotationFormatString: "Las expresiones de tipo no pueden usar literales de cadena de formato (f-strings)",
        annotationNotSupported: "No se admite la anotaci\xF3n de tipo para esta declaraci\xF3n",
        annotationRawString: "Las expresiones de tipo no pueden usar literales de cadena sin formato",
        annotationSpansStrings: "Las expresiones de tipo no pueden abarcar varios literales de cadena",
        annotationStringEscape: "Las expresiones de tipo no pueden contener caracteres de escape",
        annotationTemplateString: "Type expressions cannot use template string literals (t-strings)",
        argAssignment: 'Argumento de tipo "{argType}" no puede ser asignado a par\xE1metro de tipo "{paramType}"',
        argAssignmentFunction: 'El argumento de tipo "{argType}" no puede ser asignado a par\xE1metro de tipo "{paramType}" en funci\xF3n "{functionName}"',
        argAssignmentParam: 'Argumento de tipo "{argType}" no puede ser asignado a par\xE1metro "{paramName}" de tipo "{paramType}"',
        argAssignmentParamFunction: 'Argumento de tipo "{argType}" no puede ser asignado a par\xE1metro "{paramName}" de tipo "{paramType}" en funci\xF3n "{functionName}"',
        argMissingForParam: "Falta el argumento para el par\xE1metro {name}",
        argMissingForParams: "Faltan argumentos para los par\xE1metros {names}",
        argMorePositionalExpectedCount: "M\xE1s argumentos posicionales {expected} esperados",
        argMorePositionalExpectedOne: "Se espera 1 argumento posicional m\xE1s",
        argPositional: "Argumento posicional esperado",
        argPositionalExpectedCount: "Argumentos posicionales esperados {expected}",
        argPositionalExpectedOne: "Se espera 1 argumento posicional",
        argTypePartiallyUnknown: "El tipo de argumento es parcialmente desconocido",
        argTypeUnknown: "Tipo de argumento desconocido",
        assertAlwaysTrue: "La expresi\xF3n Assert siempre se eval\xFAa como true",
        assertTypeArgs: '"assert_type" espera dos argumentos posicionales',
        assertTypeTypeMismatch: 'Error de coincidencia "assert_type": se esperaba "{expected}" pero se ha recibido "{received}"',
        assignmentExprComprehension: 'El destino de la expresi\xF3n de asignaci\xF3n "{name}" no puede usar el mismo nombre que la comprensi\xF3n para el destino',
        assignmentExprContext: "La expresi\xF3n de asignaci\xF3n debe estar dentro de un m\xF3dulo, funci\xF3n o lambda",
        assignmentExprInSubscript: "Las expresiones de asignaci\xF3n dentro de un sub\xEDndice solo se admiten en Python 3.10 y versiones posteriores.",
        assignmentInProtocol: "Las variables de instancia o clase dentro de una clase Protocol deben declararse expl\xEDcitamente en el cuerpo de la clase.",
        assignmentTargetExpr: "La expresi\xF3n no puede ser objetivo de asignaci\xF3n",
        asyncNotInAsyncFunction: 'No se permite el uso de "async" fuera de la funci\xF3n async',
        awaitIllegal: 'El uso de "await" requiere Python 3.5 o posterior.',
        awaitNotAllowed: 'Las expresiones de tipo no pueden usar "await"',
        awaitNotInAsync: '"await" solo se permite dentro de una funci\xF3n async',
        backticksIllegal: "En Python 3.x no se admiten expresiones rodeadas de puntos suspensivos; utilice repr en su lugar.",
        baseClassCircular: "La clase no se puede derivar de s\xED misma",
        baseClassFinal: 'La clase base "{type}" est\xE1 marcada como final y no puede ser subclasificada',
        baseClassIncompatible: "Las clases base de {type} son mutuamente incompatibles",
        baseClassInvalid: "El argumento de la clase debe ser una clase base",
        baseClassMethodTypeIncompatible: 'Las clases base para la clase "{classType}" definen el m\xE9todo "{name}" de forma incompatible',
        baseClassUnknown: "Se desconoce el tipo de la clase base, lo que oculta el tipo de la clase derivada.",
        baseClassVariableTypeIncompatible: 'Las clases base para la clase "{classType}" definen la variable "{name}" de forma incompatible',
        binaryOperationNotAllowed: "Operador binario no permitido en la expresi\xF3n de tipo",
        bindParamMissing: 'No se pudo enlazar el m\xE9todo "{methodName}" porque falta un par\xE1metro "self" o "cls"',
        bindTypeMismatch: 'No se pudo enlazar el m\xE9todo "{methodName}" porque "{type}" no se puede asignar al par\xE1metro "{paramName}"',
        breakInExceptionGroup: 'No se permite "break" en un bloque "except*"',
        breakOutsideLoop: '"break" solo se puede usar dentro de un bucle',
        bytesUnsupportedEscape: "Secuencia de escape no admitida en el literal de bytes",
        callableExtraArgs: 'Se esperaban solo dos argumentos de tipo para "Callable".',
        callableFirstArg: 'Lista de tipos de par\xE1metros esperados o "..."',
        callableNotInstantiable: 'No se puede instanciar el tipo "{type}"',
        callableSecondArg: 'Tipo de retorno esperado como segundo argumento de tipo para "Callable"',
        casePatternIsIrrefutable: "El patr\xF3n irrefutable solo se permite para la \xFAltima instrucci\xF3n case",
        classAlreadySpecialized: 'El tipo "{type}" ya est\xE1 especializado',
        classDecoratorTypeUnknown: "El decorador de clase sin tipo oculta el tipo de clase; omitiendo el elemento Decorator",
        classDefinitionCycle: 'La definici\xF3n de clase para "{name}" depende de s\xED misma.',
        classGetItemClsParam: '__class_getitem__ debe tomar un par\xE1metro "cls"',
        classMethodClsParam: 'Los m\xE9todos de clase deben tomar un par\xE1metro "cls"',
        classNotRuntimeSubscriptable: 'El sub\xEDndice para la clase "{name}" generar\xE1 una excepci\xF3n en tiempo de ejecuci\xF3n; encierre la expresi\xF3n de tipo entre comillas',
        classPatternBuiltInArgPositional: "El patr\xF3n de clase solo acepta subpatrones posicionales",
        classPatternNewType: '"{type}" cannot be used in a class pattern because it is defined using NewType',
        classPatternPositionalArgCount: 'Demasiados patrones posicionales para la clase "{type}"; esperado {expected} pero recibido {received}',
        classPatternTypeAlias: '"{type}" no se puede usar en un patr\xF3n de clase porque es un alias de tipo especializado',
        classPropertyDeprecated: "Las propiedades de clase est\xE1n en desuso en Python 3.11 y no se admitir\xE1n en Python 3.13.",
        classTypeParametersIllegal: "La sintaxis de los par\xE1metros de tipo de clase requiere Python 3.12 o posterior.",
        classVarFirstArgMissing: 'Se esperaba un argumento de tipo despu\xE9s de "ClassVar"',
        classVarNotAllowed: '"ClassVar" no est\xE1 permitido en este contexto',
        classVarOverridesInstanceVar: 'La variable de clase "{name}" anula la variable de instancia del mismo nombre en la clase "{className}"',
        classVarTooManyArgs: 'Solo se esperaba un argumento de tipo despu\xE9s de "ClassVar"',
        classVarWithTypeVar: 'El tipo "ClassVar" no puede incluir variables de tipo',
        clsSelfParamTypeMismatch: 'El tipo de par\xE1metro "{name}" debe ser un supertipo de su clase "{classType}"',
        codeTooComplexToAnalyze: "El c\xF3digo es demasiado complejo para analizarlo; reduzca la complejidad refactoriz\xE1ndolo en subrutinas o reduciendo las rutas de c\xF3digo condicional.",
        collectionAliasInstantiation: 'No se puede crear una instancia del tipo "{type}"; use "{alias}" en su lugar.',
        comparisonAlwaysFalse: 'La condici\xF3n siempre se evaluar\xE1 como False, ya que los tipos "{leftType}" y "{rightType}" no se superponen.',
        comparisonAlwaysTrue: 'La condici\xF3n siempre se evaluar\xE1 como True, ya que los tipos "{leftType}" y "{rightType}" no se superponen.',
        comprehensionInDict: "La comprensi\xF3n no puede utilizarse con otras entradas del diccionario",
        comprehensionInSet: "La comprensi\xF3n no se puede usar con otras entradas de set",
        concatenateContext: '"Concatenate" no se permite en este contexto',
        concatenateParamSpecMissing: 'El \xFAltimo argumento de tipo para "Concatenate" debe ser un ParamSpec o "..."',
        concatenateTypeArgsMissing: '"Concatenate" requiere al menos dos argumentos de tipo',
        conditionalOperandInvalid: 'Operando condicional no v\xE1lido de tipo "{type}"',
        constantRedefinition: '"{name}" es constante (porque est\xE1 en may\xFAsculas) y no se puede volver a definir',
        constructorParametersMismatch: 'Error de coincidencia entre la firma de __new__ y __init__ en la clase "{classType}"',
        containmentAlwaysFalse: 'La expresi\xF3n siempre se evaluar\xE1 como False, ya que los tipos "{leftType}" y "{rightType}" no tienen superposici\xF3n',
        containmentAlwaysTrue: 'La expresi\xF3n siempre se evaluar\xE1 como True, ya que los tipos "{leftType}" y "{rightType}" no tienen superposici\xF3n',
        continueInExceptionGroup: 'No se permite "continue" en un bloque "except*"',
        continueOutsideLoop: '"continue" solo puede utilizarse dentro de un bucle',
        coroutineInConditionalExpression: "La expresi\xF3n condicional hace referencia a una corrutina que siempre se eval\xFAa como True",
        dataClassBaseClassFrozen: "Una clase no inmovilizada no puede heredar de una clase inmovilizada",
        dataClassBaseClassNotFrozen: "Una clase congelada no puede heredar de una clase que no est\xE9 congelada",
        dataClassConverterFunction: 'Argumento de tipo "{argType}" no es un convertidor v\xE1lido para el campo "{fieldName}" de tipo "{fieldType}"',
        dataClassConverterOverloads: 'No hay sobrecargas de "{funcName}" que sean convertidores v\xE1lidos para el campo "{fieldName}" de tipo "{fieldType}"',
        dataClassFieldInheritedDefault: '"{fieldName}" invalida un campo con el mismo nombre, pero falta un valor predeterminado',
        dataClassFieldWithDefault: "Los campos sin valores predeterminados no pueden aparecer despu\xE9s de los campos con valores predeterminados",
        dataClassFieldWithPrivateName: "El campo Dataclass no puede utilizar un nombre privado",
        dataClassFieldWithoutAnnotation: "El campo Dataclass sin anotaci\xF3n de tipo provocar\xE1 una excepci\xF3n en tiempo de ejecuci\xF3n",
        dataClassPostInitParamCount: "Dataclass __post_init__ recuento de par\xE1metros incorrecto; el n\xFAmero de campos InitVar es {expected}.",
        dataClassPostInitType: 'El tipo de par\xE1metro del m\xE9todo __post_init__ de la clase de datos no coincide con el del campo "{fieldName}".',
        dataClassSlotsOverwrite: "__slots__ ya est\xE1 definido en la clase",
        dataClassTransformExpectedBoolLiteral: "Expresi\xF3n esperada que se eval\xFAa est\xE1ticamente como True o False",
        dataClassTransformFieldSpecifier: 'Se esperaba una tuple de clases o funciones, pero se recibi\xF3 el tipo "{type}"',
        dataClassTransformPositionalParam: 'Todos los argumentos de "dataclass_transform" deben ser argumentos de palabra clave',
        dataClassTransformUnknownArgument: 'El argumento "{name}" no es compatible con dataclass_transform',
        dataProtocolInSubclassCheck: "No se permiten protocolos de datos (que incluyen atributos que no son de m\xE9todo) en llamadas issubclass",
        declaredReturnTypePartiallyUnknown: 'El tipo de retorno declarado, "{returnType}", es parcialmente desconocido',
        declaredReturnTypeUnknown: "El tipo de retorno declarado es desconocido",
        defaultValueContainsCall: "No se permiten llamadas de funci\xF3n y objetos mutables dentro de la expresi\xF3n de valor predeterminado del par\xE1metro",
        defaultValueNotAllowed: 'Los par\xE1metros con "*" o "**" no pueden tener valor por defecto',
        delTargetExpr: "No se puede eliminar la expresi\xF3n",
        deprecatedClass: 'La clase "{name}" est\xE1 en desuso',
        deprecatedConstructor: 'El constructor de la clase "{name}" est\xE1 obsoleto',
        deprecatedDescriptorDeleter: 'El m\xE9todo "__delete__" para el "{name}" de descriptor est\xE1 en desuso',
        deprecatedDescriptorGetter: 'El m\xE9todo "__get__" para el "{name}" de descriptor est\xE1 en desuso',
        deprecatedDescriptorSetter: 'El m\xE9todo "__set__" para el "{name}" de descriptor est\xE1 en desuso',
        deprecatedFunction: 'La funci\xF3n "{name}" est\xE1 obsoleta',
        deprecatedMethod: 'El m\xE9todo "{name}" en la clase "{className}" est\xE1 en desuso',
        deprecatedPropertyDeleter: 'El deleter de la property "{name}" est\xE1 en desuso',
        deprecatedPropertyGetter: 'El getter de la property "{name}" est\xE1 en desuso',
        deprecatedPropertySetter: 'El setter de la property "{name}" est\xE1 en desuso',
        deprecatedType: 'Este tipo est\xE1 obsoleto a partir de la {version} de Python; utilice en su lugar "{replacement}".',
        dictExpandIllegalInComprehension: "No se permite la ampliaci\xF3n del diccionario en la comprensi\xF3n",
        dictInAnnotation: "Expresi\xF3n de diccionario no permitida en expresi\xF3n de tipo",
        dictKeyValuePairs: "Las entradas del diccionario deben contener pares clave/valor",
        dictUnpackIsNotMapping: "Asignaci\xF3n esperada para el operador de desempaquetado del diccionario",
        dunderAllSymbolNotPresent: '"{name}" se especifica en __all__ pero no est\xE1 presente en el m\xF3dulo',
        duplicateArgsParam: 'Solo se permite un par\xE1metro "*".',
        duplicateBaseClass: "Clase base duplicada no permitida",
        duplicateCapturePatternTarget: 'El destino de captura "{name}" no puede aparecer m\xE1s de una vez dentro del mismo patr\xF3n',
        duplicateCatchAll: "Solo se permite una cl\xE1usula de except",
        duplicateEnumMember: 'El miembro Enum "{name}" ya est\xE1 declarado',
        duplicateGenericAndProtocolBase: "Solo se permite una clase base Generic[...] o Protocol[...].",
        duplicateImport: '"{importName}" se importa m\xE1s de una vez',
        duplicateKeywordOnly: 'Solo se permite un separador "*".',
        duplicateKwargsParam: 'Solo se permite un par\xE1metro "**".',
        duplicateParam: 'Par\xE1metro duplicado "{name}"',
        duplicatePositionOnly: 'Solo se permite un par\xE1metro "/"',
        duplicateStarPattern: 'Solo se permite un patr\xF3n "*" en una secuencia de patrones',
        duplicateStarStarPattern: 'Solo se permite una entrada "**"',
        duplicateUnpack: "Solo se permite una operaci\xF3n de desempaquetado en la lista",
        ellipsisAfterUnpacked: '"..." no se puede usar con una TypeVarTuple o tuple sin empaquetar',
        ellipsisContext: '"..." no est\xE1 permitido en este contexto',
        ellipsisSecondArg: '"..." est\xE1 permitido s\xF3lo como el segundo de dos argumentos',
        enumClassOverride: 'La clase Enum "{name}" es final y no puede ser subclasificada',
        enumMemberDelete: 'No se puede eliminar el miembro de Enum "{name}"',
        enumMemberSet: 'No se puede asignar el miembro de Enum "{name}"',
        enumMemberTypeAnnotation: "No se permiten anotaciones de tipo para miembros de enumeraci\xF3n",
        exceptGroupMismatch: 'La instrucci\xF3n Try no puede incluir "except" y "except*"',
        exceptGroupRequiresType: 'La sintaxis del grupo de excepciones ("except*") requiere un tipo de excepci\xF3n',
        exceptRequiresParens: "Multiple exception types must be parenthesized prior to Python 3.14",
        exceptWithAsRequiresParens: 'Multiple exception types must be parenthesized when using "as"',
        exceptionGroupIncompatible: 'La sintaxis de grupo de excepciones ("except*") requiere Python 3.11 o posterior.',
        exceptionGroupTypeIncorrect: "El tipo de excepci\xF3n en except* no puede derivarse de BaseGroupException",
        exceptionTypeIncorrect: '"{type}" no se deriva de BaseException',
        exceptionTypeNotClass: '"{type}" no es una clase de excepci\xF3n v\xE1lida',
        exceptionTypeNotInstantiable: 'El constructor para el tipo de excepci\xF3n "{type}" requiere uno o m\xE1s argumentos',
        expectedAfterDecorator: "Se esperaba una declaraci\xF3n de funci\xF3n o clase despu\xE9s del decorador",
        expectedArrow: 'Se esperaba "->" seguido de una anotaci\xF3n de tipo de retorno',
        expectedAsAfterException: 'Se esperaba "as" despu\xE9s del tipo de excepci\xF3n',
        expectedAssignRightHandExpr: 'Expresi\xF3n esperada a la derecha de "="',
        expectedBinaryRightHandExpr: "Expresi\xF3n esperada a la derecha del operador",
        expectedBoolLiteral: "Se esperaba True o False",
        expectedCase: 'Declaraci\xF3n "case" esperada',
        expectedClassName: "Nombre de clase esperado",
        expectedCloseBrace: '"{" no estaba cerrado',
        expectedCloseBracket: '"[" no estaba cerrado',
        expectedCloseParen: '"(" no estaba cerrado',
        expectedColon: 'Se esperaba ":"',
        expectedComplexNumberLiteral: "N\xFAmero complejo literal esperado para la concordancia de patrones",
        expectedDecoratorExpr: "Forma de expresi\xF3n no compatible con Decorator anterior a Python 3.9",
        expectedDecoratorName: "Nombre esperado del Decorator",
        expectedDecoratorNewline: "Nueva l\xEDnea esperada al final de Decorator",
        expectedDelExpr: 'Expresi\xF3n esperada despu\xE9s de "del"',
        expectedElse: 'Se espera "else"',
        expectedEquals: 'Se esperaba "="',
        expectedExceptionClass: "Clase o objeto de excepci\xF3n no v\xE1lido",
        expectedExceptionObj: "Objeto de excepci\xF3n esperado, clase de excepci\xF3n o None",
        expectedExpr: "Se esperaba una expresi\xF3n",
        expectedFunctionAfterAsync: 'Definici\xF3n de funci\xF3n esperada despu\xE9s de "async"',
        expectedFunctionName: 'Se esperaba nombre de la funci\xF3n luego de "def"',
        expectedIdentifier: "Identificador esperado",
        expectedImport: 'Se espera "import"',
        expectedImportAlias: 'S\xEDmbolo esperado despu\xE9s de "as"',
        expectedImportSymbols: "Se esperan uno o m\xE1s nombres de s\xEDmbolos tras la importaci\xF3n",
        expectedIn: 'Se esperaba "in"',
        expectedInExpr: 'Expresi\xF3n esperada despu\xE9s de "in"',
        expectedIndentedBlock: "Bloque con sangr\xEDa previsto",
        expectedMemberName: 'Se esperaba un nombre de atributo despu\xE9s de "."',
        expectedModuleName: "Nombre de m\xF3dulo esperado",
        expectedNameAfterAs: 'Se esperaba un nombre de s\xEDmbolo despu\xE9s de "as"',
        expectedNamedParameter: 'El par\xE1metro de palabra clave debe ir despu\xE9s de "*".',
        expectedNewline: "Nueva l\xEDnea esperada",
        expectedNewlineOrSemicolon: "Las declaraciones deben ir separadas por nuevas l\xEDneas o punto y coma",
        expectedOpenParen: 'Se espera "("',
        expectedParamName: "Nombre esperado del par\xE1metro",
        expectedPatternExpr: "Expresi\xF3n del patr\xF3n esperado",
        expectedPatternSubjectExpr: "Expresi\xF3n de asunto de patr\xF3n esperada",
        expectedPatternValue: 'Expresi\xF3n de valor de patr\xF3n esperada de la forma "a.b"',
        expectedReturnExpr: 'Expresi\xF3n esperada despu\xE9s de "return"',
        expectedSliceIndex: "Expresi\xF3n de \xEDndice o segmento esperada",
        expectedTypeNotString: "Se esperaba un tipo pero se ha recibido una cadena literal",
        expectedTypeParameterName: "Nombre de par\xE1metro de tipo esperado",
        expectedYieldExpr: "Expresi\xF3n esperada en la instrucci\xF3n yield",
        finalClassIsAbstract: 'La clase "{type}" est\xE1 marcada como final y debe implementar todos los s\xEDmbolos abstractos',
        finalContext: '"Final" no est\xE1 permitido en este contexto',
        finalInLoop: 'No se puede asignar una variable "Final" dentro de un bucle',
        finalMethodOverride: 'El m\xE9todo "{name}" no puede anular el m\xE9todo final definido en la clase " {className}"',
        finalNonMethod: 'La funci\xF3n "{name}" no se puede marcar @final porque no es un m\xE9todo',
        finalReassigned: '"{name}" se declara como Final y no se puede reasignar',
        finalRedeclaration: '"{name}" se declar\xF3 anteriormente como Final',
        finalRedeclarationBySubclass: '"{name}" no puede ser redeclarado porque la clase padre "{className}" lo declara como Final',
        finalTooManyArgs: 'Se esperaba un \xFAnico argumento de tipo despu\xE9s de "Final".',
        finalUnassigned: '"{name}" se declara Final, pero no se asigna valor',
        finallyBreak: 'No se puede usar un elemento "break" para salir de un bloque "finally"',
        finallyContinue: 'No se puede usar un elemento "continue" para salir de un bloque "finally"',
        finallyReturn: 'No se puede usar un elemento "return" para salir de un bloque "finally"',
        formatStringBrace: "No se permite una llave de cierre \xFAnica dentro del literal de cadena f; usar llave de cierre doble",
        formatStringBytes: "Los literales de cadena de formato (f-strings) no pueden ser binarios",
        formatStringDebuggingIllegal: 'El especificador de depuraci\xF3n de cadena F "=" requiere Python 3.8 o posterior',
        formatStringEscape: "Secuencia de escape (barra diagonal inversa) no permitida en la parte de expresi\xF3n de f-string anterior a Python 3.12",
        formatStringExpectedConversion: 'Se esperaba un especificador de conversi\xF3n despu\xE9s de "!" en f-string',
        formatStringIllegal: "Los literales de cadena de formato (f-strings) requieren Python 3.6 o posterior",
        formatStringInPattern: "Cadena de formato no permitida en el patr\xF3n",
        formatStringNestedFormatSpecifier: "Expresiones anidadas demasiado profundamente dentro del especificador de cadena de formato",
        formatStringNestedQuote: "Las cadenas anidadas dentro de una cadena f no pueden usar el mismo car\xE1cter de comillas que la cadena f anterior a Python 3.12",
        formatStringTemplate: "Format string literals (f-strings) cannot also be template strings (t-strings)",
        formatStringUnicode: "Los literales de cadena de formato (cadenas f) no pueden ser unicode",
        formatStringUnterminated: 'Expresi\xF3n sin terminar en f-string; se esperaba "}"',
        functionDecoratorTypeUnknown: "Un decorator de funci\xF3n no tipificado oculta el tipo de funci\xF3n; ignorar el decorator",
        functionInConditionalExpression: "La expresi\xF3n condicional hace referencia a una funci\xF3n que siempre se eval\xFAa como True",
        functionTypeParametersIllegal: "La sintaxis del par\xE1metro de tipo de funci\xF3n requiere Python 3.12 o posterior",
        futureImportLocationNotAllowed: "Las importaciones desde __future__ deben estar al principio del fichero",
        generatorAsyncReturnType: 'El tipo de retorno de la funci\xF3n generadora async debe ser compatible con "AsyncGenerator[{yieldType}, Any]"',
        generatorNotParenthesized: "Las expresiones del generador deben ir entre par\xE9ntesis si no son el \xFAnico argumento",
        generatorSyncReturnType: 'El tipo de retorno de la funci\xF3n generadora debe ser compatible con "Generator[{yieldType}, Any, Any]"',
        genericBaseClassNotAllowed: 'La clase base "Generic" no se puede usar con la sintaxis de par\xE1metro de tipo',
        genericClassAssigned: "No se puede asignar un tipo de clase gen\xE9rico",
        genericClassDeleted: "No se puede eliminar el tipo de clase gen\xE9rica",
        genericInstanceVariableAccess: "El acceso a la variable de instancia gen\xE9rica a trav\xE9s de la clase es ambiguo",
        genericNotAllowed: '"Generic" no es v\xE1lido en este contexto',
        genericTypeAliasBoundTypeVar: "Los alias de tipo gen\xE9rico dentro de una clase no pueden utilizar variables de tipo vinculadas {names}.",
        genericTypeArgMissing: '"Generic" requiere al menos un argumento de tipo',
        genericTypeArgTypeVar: 'El argumento de tipo para "Generic" debe ser una variable de tipo',
        genericTypeArgUnique: 'Los argumentos de tipo para "Generic" deben ser \xFAnicos',
        globalReassignment: '"{name}" se asigna antes de la declaraci\xF3n global',
        globalRedefinition: '"{name}" ya ha sido declarado global',
        implicitStringConcat: "No se permite la concatenaci\xF3n impl\xEDcita de cadenas",
        importCycleDetected: "Ciclo detectado en la cadena de importaci\xF3n",
        importDepthExceeded: "La profundidad de la cadena de importaci\xF3n super\xF3 {depth}",
        importResolveFailure: 'No se ha podido resolver la importaci\xF3n "{importName}".',
        importSourceResolveFailure: 'La importaci\xF3n "{importName}" no se ha podido resolver desde el origen',
        importSymbolUnknown: '"{name}" es un s\xEDmbolo de importaci\xF3n desconocido',
        incompatibleMethodOverride: 'El m\xE9todo "{name}" sobrescribe la clase "{className}" de forma incompatible',
        inconsistentIndent: "La cantidad sin sangr\xEDa no coincide con la sangr\xEDa anterior",
        inconsistentTabs: "Uso incoherente de tabuladores y espacios en la sangr\xEDa",
        initMethodSelfParamTypeVar: 'La anotaci\xF3n de tipo para el par\xE1metro "self" del m\xE9todo "__init__" no puede contener variables de tipo con \xE1mbito de clase',
        initMustReturnNone: 'El tipo de retorno de "__init__" debe ser None',
        initSubclassCallFailed: "Argumentos de palabra clave incorrectos para el m\xE9todo __init_subclass__",
        initSubclassClsParam: '__init_subclass__ debe tomar un par\xE1metro "cls"',
        initVarNotAllowed: '"InitVar" no se permite en este contexto',
        instanceMethodSelfParam: 'Los m\xE9todos de instancia deben tomar un par\xE1metro "self"',
        instanceVarOverridesClassVar: 'La variable de instancia "{name}" invalida la variable de clase del mismo nombre en la clase "{className}"',
        instantiateAbstract: 'No se puede instanciar la clase abstracta "{type}"',
        instantiateProtocol: 'No se puede crear una instancia de la clase Protocol "{type}"',
        internalBindError: 'Se ha producido un error interno al vincular el archivo "{file}": {message}',
        internalParseError: 'Se ha producido un error interno al procesar el archivo "{file}": {message}',
        internalTypeCheckingError: 'Se ha producido un error interno al comprobar el tipo de archivo "{file}":{message}',
        invalidIdentifierChar: "Car\xE1cter no v\xE1lido en el identificador",
        invalidStubStatement: "La declaraci\xF3n no tiene sentido dentro de un archivo de tipo stub",
        invalidTokenChars: 'Car\xE1cter "{text}" no v\xE1lido en el token',
        isInstanceInvalidType: 'El segundo argumento de "isinstance" debe ser una clase o tuple de clases',
        isSubclassInvalidType: 'El segundo argumento de "issubclass" debe ser una clase o tuple de clases',
        keyValueInSet: "No se permiten pares de clave/valor dentro de un set",
        keywordArgInTypeArgument: "No se pueden usar argumentos de palabra clave en listas de argumentos de tipo",
        keywordOnlyAfterArgs: 'No se permite el separador de argumentos por palabra clave despu\xE9s del par\xE1metro "*".',
        keywordParameterMissing: 'Uno o varios par\xE1metros de palabra clave deben seguir el par\xE1metro "*"',
        keywordSubscriptIllegal: "No se admiten argumentos de palabra clave dentro de sub\xEDndices",
        lambdaReturnTypePartiallyUnknown: 'El tipo de retorno de la lambda "{returnType}" es parcialmente desconocido.',
        lambdaReturnTypeUnknown: "Se desconoce el tipo de retorno de la lambda",
        listAssignmentMismatch: 'La expresi\xF3n con el tipo "{type}" no puede asignarse a la lista de destino',
        listInAnnotation: "No se permite la expresi\xF3n de List en la expresi\xF3n de tipo",
        literalEmptyArgs: 'Se esperaban uno o varios argumentos de tipo despu\xE9s de "Literal"',
        literalNamedUnicodeEscape: 'No se admiten secuencias de escape Unicode con nombre en las anotaciones de cadena de "Literales".',
        literalNotAllowed: '"Literal" no se puede usar en este contexto sin un argumento de tipo',
        literalNotCallable: "El tipo Literal no puede instanciarse",
        literalUnsupportedType: 'Los argumentos de tipo para "Literal" deben ser None, un valor literal (int, bool, str, o bytes), o un valor enum',
        matchIncompatible: "Las declaraciones de Match requieren Python 3.10 o posterior",
        matchIsNotExhaustive: "Los casos dentro de la declaraci\xF3n de match no tratan exhaustivamente todos los valores",
        maxParseDepthExceeded: "Se ha superado la profundidad m\xE1xima de an\xE1lisis; divida la expresi\xF3n en subexpresiones m\xE1s peque\xF1as.",
        memberAccess: 'No se puede tener acceso al atributo "{name}" para la clase "{type}"',
        memberDelete: 'No se puede eliminar el atributo "{name}" de la clase "{type}"',
        memberSet: 'No se puede asignar al atributo "{name}" para la clase "{type}"',
        metaclassConflict: "La metaclase de una clase derivada debe ser una subclase de las metaclases de todas sus clases base",
        metaclassDuplicate: "Solo se puede proporcionar una metaclase",
        metaclassIsGeneric: "La metaclase no puede ser gen\xE9rica",
        methodNotDefined: 'M\xE9todo "{name}" no definido',
        methodNotDefinedOnType: 'M\xE9todo "{name}" no definido en el tipo "{type}"',
        methodOrdering: "No se puede crear una ordenaci\xF3n coherente de los m\xE9todos",
        methodOverridden: '"{name}" invalida el m\xE9todo del mismo nombre en la clase "{className}" con el tipo incompatible "{type}"',
        methodReturnsNonObject: 'El m\xE9todo "{name}" no devuelve un objeto',
        missingSuperCall: 'El m\xE9todo "{methodName}" no llama al m\xE9todo del mismo nombre en la clase principal.',
        mixingBytesAndStr: "No se pueden concatenar los valores de bytes y str",
        moduleAsType: "El m\xF3dulo no se puede usar como tipo.",
        moduleNotCallable: "No se puede llamar al m\xF3dulo",
        moduleUnknownMember: '"{memberName}" no es un atributo conocido del m\xF3dulo "{moduleName}"',
        namedExceptAfterCatchAll: "Una cl\xE1usula except con nombre no puede aparecer despu\xE9s de la cl\xE1usula catch-all except",
        namedParamAfterParamSpecArgs: 'El par\xE1metro de palabra clave "{name}" no puede aparecer en la firma despu\xE9s del par\xE1metro ParamSpec args',
        namedTupleEmptyName: "Los nombres de una tuple con nombre no pueden estar vac\xEDos",
        namedTupleEntryRedeclared: 'No se puede invalidar "{name}" porque la clase primaria "{className}" es una tuple con nombre',
        namedTupleFieldUnderscore: "Named de campo de tuple con nombre no pueden empezar por un car\xE1cter de subrayado",
        namedTupleFirstArg: "Nombre de clase de tuple como primer argumento",
        namedTupleMultipleInheritance: "No se admite la herencia m\xFAltiple con NamedTuple",
        namedTupleNameKeyword: "Los nombres de campo no pueden ser una palabra clave",
        namedTupleNameType: "tuple de dos entradas esperada que especifica el nombre y el tipo de entrada",
        namedTupleNameUnique: "Los nombres dentro de una tuple con nombre deben ser \xFAnicos",
        namedTupleNoTypes: '"namedtuple" no proporciona tipos para las entradas de tuple; utilice en su lugar "NamedTuple".',
        namedTupleSecondArg: "list de entradas de tuple con nombre esperada como segundo argumento",
        newClsParam: '__new__ debe tomar un par\xE1metro "cls"',
        newTypeAnyOrUnknown: "El segundo argumento de NewType debe ser una clase conocida, no Any ni Unknown",
        newTypeBadName: "El primer argumento de NewType debe ser una cadena literal",
        newTypeLiteral: "NewType no se puede usar con el tipo Literal",
        newTypeNameMismatch: "NewType debe asignarse a una variable con el mismo nombre",
        newTypeNotAClass: "Clase esperada como segundo argumento de NewType",
        newTypeParamCount: "NewType requiere dos argumentos posicionales",
        newTypeProtocolClass: "NewType no se puede usar con un tipo estructural (Protocol o clase TypedDict)",
        noOverload: 'Ninguna sobrecarga para "{name}" coincide con los argumentos proporcionados',
        noReturnContainsReturn: 'La funci\xF3n con tipo de return declarado "NoReturn" no puede incluir una sentencia return',
        noReturnContainsYield: 'La funci\xF3n con tipo de retorno declarado "NoReturn" no puede incluir una instrucci\xF3n yield',
        noReturnReturnsNone: 'La funci\xF3n con el tipo de valor devuelto declarado "NoReturn" no puede devolver "None"',
        nonDefaultAfterDefault: "El argumento no predeterminado sigue al argumento predeterminado",
        nonLocalInModule: "Declaraci\xF3n Nonlocal no permitida a nivel de m\xF3dulo",
        nonLocalNoBinding: 'No se ha encontrado ning\xFAn enlace para "{name}" nonlocal.',
        nonLocalReassignment: '"{name}" se asigna antes de la declaraci\xF3n nonlocal',
        nonLocalRedefinition: '"{name}" ya fue declarado nonlocal',
        noneNotCallable: 'No se puede llamar al objeto de tipo "None"',
        noneNotIterable: 'No se puede utilizar un objeto de tipo "None" como valor iterable',
        noneNotSubscriptable: 'El objeto de tipo "None" no se puede suscribir',
        noneNotUsableWith: 'Object of type "None" cannot be used with "with"',
        noneNotUsableWithAsync: 'El objeto de tipo "None" no se puede usar con "async with"',
        noneOperator: 'El operador "{operator}" no es compatible con "None".',
        noneUnknownMember: '"{name}" no es un atributo conocido de "None"',
        nonlocalTypeParam: 'No se permite el enlace nonlocal para el par\xE1metro de tipo "{name}"',
        notRequiredArgCount: 'Se esperaba un \xFAnico argumento de tipo despu\xE9s de "NotRequired".',
        notRequiredNotInTypedDict: '"NotRequired" no est\xE1 permitido en este contexto',
        objectNotCallable: 'El objeto de tipo "{type}" no es invocable',
        obscuredClassDeclaration: 'La declaraci\xF3n de clase "{name}" queda oculta por una declaraci\xF3n del mismo nombre',
        obscuredFunctionDeclaration: 'La declaraci\xF3n de funci\xF3n "{name}" queda oculta por una declaraci\xF3n del mismo nombre',
        obscuredMethodDeclaration: 'La declaraci\xF3n de m\xE9todo "{name}" queda oculta por una declaraci\xF3n del mismo nombre',
        obscuredParameterDeclaration: 'La declaraci\xF3n de par\xE1metro "{name}" queda oculta por una declaraci\xF3n del mismo nombre',
        obscuredTypeAliasDeclaration: 'La declaraci\xF3n de alias de tipo "{name}" queda oculta por una declaraci\xF3n del mismo nombre',
        obscuredVariableDeclaration: 'La declaraci\xF3n "{name}" est\xE1 oculta por una declaraci\xF3n del mismo nombre',
        operatorLessOrGreaterDeprecated: 'El operador "<>" no es admitido en Python 3; utilice en su lugar "!=".',
        optionalExtraArgs: 'Se esperaba un argumento de tipo despu\xE9s de "Optional"',
        orPatternIrrefutable: 'El patr\xF3n irrefutable solo se permite como el \xFAltimo subpatr\xF3n en un patr\xF3n "or".',
        orPatternMissingName: 'Todos los subpatrones de un patr\xF3n "or" deben tener los mismos nombres',
        overlappingKeywordArgs: "El diccionario escrito se superpone con el par\xE1metro de palabra clave: {names}",
        overlappingOverload: 'La sobrecarga {obscured} para "{name}" nunca se utilizar\xE1 porque sus par\xE1metros se superpone con la sobrecarga {obscuredBy}.',
        overloadAbstractImplMismatch: "Las sobrecargas deben coincidir con el estado abstracto de la implementaci\xF3n",
        overloadAbstractMismatch: "Todos los m\xE9todos sobrecargados deben ser abstractos o no",
        overloadClassMethodInconsistent: 'Las sobrecargas de "{name}" usan @classmethod de forma incoherente',
        overloadFinalImpl: "@final elemento Decorator solo se debe aplicar a la implementaci\xF3n.",
        overloadFinalNoImpl: "Solo la primera sobrecarga debe marcarse @final",
        overloadImplementationMismatch: "La implementaci\xF3n de la sobrecarga no es consistente con la firma de la sobrecarga {index}",
        overloadOverrideImpl: "@override elemento Decorator solo se debe aplicar a la implementaci\xF3n.",
        overloadOverrideNoImpl: "Solo la primera sobrecarga debe marcarse @override",
        overloadReturnTypeMismatch: 'La sobrecarga {prevIndex} para " {name}" se superpone con la sobrecarga {newIndex} y devuelve un tipo incompatible',
        overloadStaticMethodInconsistent: 'Las sobrecargas de "{name}" usan @staticmethod de forma incoherente',
        overloadWithoutImplementation: '"{name}" est\xE1 marcado como overload, pero no se proporciona ninguna implementaci\xF3n.',
        overriddenMethodNotFound: 'El m\xE9todo "{name}" est\xE1 marcado como override, pero no existe ning\xFAn m\xE9todo base con el mismo nombre',
        overrideDecoratorMissing: 'El m\xE9todo "{name}" no est\xE1 marcado como override, pero est\xE1 reemplazando un m\xE9todo de la clase "{className}"',
        paramAfterKwargsParam: 'El par\xE1metro no puede seguir el par\xE1metro "**"',
        paramAlreadyAssigned: 'El par\xE1metro "{name}" ya est\xE1 asignado',
        paramAnnotationMissing: 'Falta la anotaci\xF3n de tipo para el par\xE1metro "{name}"',
        paramAssignmentMismatch: 'La expresi\xF3n de tipo "{sourceType}" no se puede asignar al par\xE1metro de tipo "{paramType}"',
        paramNameMissing: 'Ning\xFAn par\xE1metro llamado "{name}"',
        paramSpecArgsKwargsDuplicate: 'Ya se han proporcionado los argumentos para ParamSpec "{type}".',
        paramSpecArgsKwargsUsage: 'Los atributos "args" y "kwargs" de ParamSpec deben aparecer ambos dentro de una firma de funci\xF3n',
        paramSpecArgsMissing: 'Faltan argumentos para ParamSpec "{type}".',
        paramSpecArgsUsage: 'El atributo "args" de ParamSpec solo es v\xE1lido cuando se usa con el par\xE1metro *args.',
        paramSpecAssignedName: 'ParamSpec debe asignarse a una variable llamada "{name} "',
        paramSpecContext: "ParamSpec no est\xE1 permitido en este contexto",
        paramSpecDefaultNotTuple: "Se esperaban puntos suspensivos, una expresi\xF3n de tuple o ParamSpec para el valor predeterminado de ParamSpec",
        paramSpecFirstArg: "Se esperaba el nombre de ParamSpec como primer argumento",
        paramSpecKwargsUsage: 'El miembro "kwargs" de ParamSpec solo es v\xE1lido cuando se utiliza con el par\xE1metro **kwargs',
        paramSpecNotUsedByOuterScope: 'ParamSpec "{name}" no tiene significado en este contexto',
        paramSpecUnknownArg: "ParamSpec no admite m\xE1s de un argumento",
        paramSpecUnknownMember: '"{name}" no es un atributo conocido de ParamSpec',
        paramSpecUnknownParam: '"{name}" es un par\xE1metro desconocido para ParamSpec',
        paramTypeCovariant: "La variable de tipo covariante no puede utilizarse en el tipo de par\xE1metro",
        paramTypePartiallyUnknown: 'El tipo de par\xE1metro "{paramName}" es parcialmente desconocido',
        paramTypeUnknown: 'Se desconoce el tipo del par\xE1metro "{paramName}".',
        parenthesizedContextManagerIllegal: 'Parentheses within "with" statement requires Python 3.9 or newer',
        patternNeverMatches: 'El patr\xF3n nunca coincidir\xE1 para el tipo de asunto "{type}"',
        positionArgAfterNamedArg: "El argumento posicional no puede aparecer despu\xE9s de los argumentos de palabra clave",
        positionArgAfterUnpackedDictArg: "El argumento posicional no puede aparecer despu\xE9s de desempaquetar el argumento de palabra clave",
        positionOnlyAfterArgs: 'No se permite el separador de par\xE1metros de un solo puesto despu\xE9s del par\xE1metro "*".',
        positionOnlyAfterKeywordOnly: 'El par\xE1metro "/" debe aparecer antes del par\xE1metro "*".',
        positionOnlyAfterNon: "Par\xE1metro de un solo puesto no permitido despu\xE9s del par\xE1metro que no es de solo posici\xF3n",
        positionOnlyFirstParam: "Separador par\xE1metros de solo un puesto no permitido como primer par\xE1metro",
        positionOnlyIncompatible: "El separador de par\xE1metros de un solo puesto requiere Python 3.8 o posterior",
        privateImportFromPyTypedModule: '"{name}" no se exporta desde el m\xF3dulo "{module}"',
        privateUsedOutsideOfClass: '"{name}" es privado y se utiliza fuera de la clase en la que se declara',
        privateUsedOutsideOfModule: '"{name}" es privado y se utiliza fuera del m\xF3dulo en el que se declara',
        propertyOverridden: '"{name}" invalida incorrectamente la property del mismo nombre en la clase "{className}"',
        propertyStaticMethod: "M\xE9todos est\xE1ticos no permitidos para los valores de property getter, setter o deleter",
        protectedUsedOutsideOfClass: '"{name}" est\xE1 protegido y se usa fuera de la clase en la que se declara',
        protocolBaseClass: 'La clase de Protocol "{classType}" no se puede derivar de la clase que no es Protocol "{baseType}"',
        protocolBaseClassWithTypeArgs: "No se permiten argumentos de tipo con la clase Protocol cuando se usa la sintaxis de par\xE1metro de tipo",
        protocolIllegal: 'El uso de "Protocolo" requiere Python 3.7 o posterior.',
        protocolNotAllowed: '"Protocolo" no puede utilizarse en este contexto',
        protocolTypeArgMustBeTypeParam: 'El argumento de tipo para "Protocol" debe ser un par\xE1metro de tipo',
        protocolUnsafeOverlap: 'La clase se superpone "{name}" de forma no segura y podr\xEDa producir una coincidencia en tiempo de ejecuci\xF3n',
        protocolVarianceContravariant: 'La variable de tipo "{variable}" usada en Protocol gen\xE9rico "{class}" debe ser contravariante',
        protocolVarianceCovariant: 'La variable de tipo "{variable}" usada en Protocol gen\xE9rico "{class}" debe ser covariante',
        protocolVarianceInvariant: 'La variable de tipo "{variable}" usada en Protocol gen\xE9rico "{class}" debe ser invariable',
        pyrightCommentInvalidDiagnosticBoolValue: 'La directiva de comentario Pyright debe ir seguida de "=" y un valor de true o false',
        pyrightCommentInvalidDiagnosticSeverityValue: 'La directiva de comentario Pyright debe ir seguida de "=" y un valor de true, false, error, warning, information o none.',
        pyrightCommentMissingDirective: "El comentario de Pyright debe ir seguido de una directiva (basic o estricta) o de una regla de diagn\xF3stico",
        pyrightCommentNotOnOwnLine: "Los comentarios de Pyright utilizados para controlar los ajustes a nivel de archivo deben aparecer en su propia l\xEDnea",
        pyrightCommentUnknownDiagnosticRule: '"{rule}" es una regla de diagn\xF3stico desconocida para el comentario pyright',
        pyrightCommentUnknownDiagnosticSeverityValue: '"{value}" es un valor no v\xE1lido para el comentario pyright; se espera true, false, error, warning, information o none.',
        pyrightCommentUnknownDirective: '"{directive}" is an unknown directive for pyright comment; expected "strict", "standard", or "basic"',
        readOnlyArgCount: 'Se esperaba un \xFAnico argumento de tipo despu\xE9s de "ReadOnly"',
        readOnlyNotInTypedDict: '"ReadOnly" no est\xE1 permitido en este contexto',
        recursiveDefinition: 'No se pudo determinar el tipo de "{name}" porque hace referencia a s\xED mismo.',
        relativeImportNotAllowed: 'Las importaciones relativas no pueden utilizarse con la forma "import .a"; utilice en su lugar "from . import a"',
        requiredArgCount: 'Se esperaba un \xFAnico argumento de tipo despu\xE9s de "Required"',
        requiredNotInTypedDict: '"Required" no est\xE1 permitido en este contexto',
        returnInAsyncGenerator: "No se permite la instrucci\xF3n Return con valor en el generador async",
        returnInExceptionGroup: 'No se permite "return" en un bloque "except*"',
        returnMissing: 'La funci\xF3n con el tipo de valor devuelto declarado "{returnType}" debe devolver un valor en todas las rutas de acceso del c\xF3digo.',
        returnOutsideFunction: '"return" solo se puede usar dentro de una funci\xF3n',
        returnTypeContravariant: "La variable de tipo contravariante no se puede usar en el tipo de valor devuelto",
        returnTypeMismatch: 'El tipo "{exprType}" no se puede asignar al tipo de valor devuelto "{returnType}"',
        returnTypePartiallyUnknown: 'El tipo de retorno, "{returnType}", es parcialmente desconocido',
        returnTypeUnknown: "Tipo de retorno desconocido",
        revealLocalsArgs: 'No se esperaba ning\xFAn argumento para la llamada "reveal_locals"',
        revealLocalsNone: "No hay locals en este \xE1mbito",
        revealTypeArgs: 'Se esperaba un \xFAnico argumento posicional para la llamada "reveal_type"',
        revealTypeExpectedTextArg: 'El argumento "expected_text" de la funci\xF3n "reveal_type" debe ser un valor literal str.',
        revealTypeExpectedTextMismatch: 'El tipo de texto no coincide; se esperaba "{expected}" pero se ha recibido "{received}".',
        revealTypeExpectedTypeMismatch: 'Error de coincidencia de tipos; se esperaba "{expected}", pero se recibi\xF3 "{received}"',
        selfTypeContext: '"Self" no es v\xE1lido en este contexto',
        selfTypeMetaclass: '"Self" no se puede usar dentro de una metaclase (una subclase de "type")',
        selfTypeWithTypedSelfOrCls: '"Self" no puede utilizarse en una funci\xF3n con un par\xE1metro `self` o `cls` que tenga una anotaci\xF3n de tipo distinta de "Self".',
        sentinelBadName: "The first argument to Sentinel must be a string literal",
        sentinelNameMismatch: "Sentinel must be assigned to a variable with the same name",
        sentinelParamCount: "Sentinel requires one positional argument",
        setterGetterTypeMismatch: "El tipo de valor setter de Property no se puede asignar al tipo devuelto por el valor getter",
        singleOverload: '"{name}" est\xE1 marcado como sobrecarga, pero faltan sobrecargas adicionales',
        slotsAttributeError: '"{name}" no se especific\xF3 en __slots__',
        slotsClassVarConflict: '"{name}" entra en conflicto con la variable de instancia declarada en __slots__',
        starPatternInAsPattern: 'El patr\xF3n estrella no puede utilizarse con el objetivo "as"',
        starPatternInOrPattern: "El patr\xF3n de estrella no puede unirse a otros patrones",
        starStarWildcardNotAllowed: '** no puede utilizarse con el comod\xEDn "_".',
        staticClsSelfParam: 'Los m\xE9todos est\xE1ticos no deben tomar un par\xE1metro "self" o "cls".',
        stringNonAsciiBytes: "Car\xE1cter no ASCII no permitido en el literal de cadena de bytes",
        stringNotSubscriptable: "La expresi\xF3n de cadena no puede ir entre comillas en la expresi\xF3n de tipo; encierre toda la expresi\xF3n entre comillas.",
        stringUnsupportedEscape: "Secuencia de escape no admitida en el literal de cadena",
        stringUnterminated: "La cadena literal no est\xE1 terminada",
        stubFileMissing: 'Archivo Stub no encontrado para "{importName}"',
        stubUsesGetAttr: 'El archivo stub de tipo est\xE1 incompleto; "__getattr__" oculta errores de tipo para el m\xF3dulo',
        sublistParamsIncompatible: "Los par\xE1metros de sublista no est\xE1n soportados en Python 3.x",
        superCallArgCount: 'No se esperaban m\xE1s de dos argumentos para la llamada "super"',
        superCallFirstArg: 'Se esperaba el tipo de clase como primer argumento de la llamada a "super" pero se recibi\xF3 "{type}"',
        superCallSecondArg: 'El segundo argumento de la llamada a "super" debe ser un objeto o clase que derive de "{type}"',
        superCallZeroArgForm: 'La forma sin argumentos de la llamada "super" s\xF3lo es v\xE1lida dentro de un m\xE9todo',
        superCallZeroArgFormStaticMethod: 'La forma sin argumentos de la llamada "super" no es v\xE1lida en un m\xE9todo est\xE1tico',
        symbolIsPossiblyUnbound: '"{name}" est\xE1 posiblemente desvinculado',
        symbolIsUnbound: '"{name}" est\xE1 sin consolidar',
        symbolIsUndefined: '"{name}" no est\xE1 definido',
        symbolOverridden: '"{name}" anula el s\xEDmbolo del mismo nombre en la clase "{className}"',
        templateStringBytes: "Template string literals (t-strings) cannot be binary",
        templateStringIllegal: "Template string literals (t-strings) require Python 3.14 or newer",
        templateStringUnicode: "Template string literals (t-strings) cannot be unicode",
        ternaryNotAllowed: "No se permite la expresi\xF3n de ternario en la expresi\xF3n de tipo",
        totalOrderingMissingMethod: 'La clase debe definir uno de "__lt__", "__le__", "__gt__", o "__ge__" para utilizar total_ordering',
        trailingCommaInFromImport: "No se permite la coma final sin par\xE9ntesis alrededor",
        tryWithoutExcept: "La instrucci\xF3n Try debe tener al menos una cl\xE1usula except o finally",
        tupleAssignmentMismatch: 'La expresi\xF3n con el tipo "{type}" no se puede asignar a la tuple de destino',
        tupleInAnnotation: "No se permite la expresi\xF3n de tuple en la expresi\xF3n de tipo",
        tupleIndexOutOfRange: "El \xEDndice {index} est\xE1 fuera de rango para el tipo {type}.",
        typeAliasIllegalExpressionForm: "Forma de expresi\xF3n no v\xE1lida para la definici\xF3n de alias de tipo",
        typeAliasIsRecursiveDirect: 'El alias de tipo "{name}" no puede usarse a s\xED mismo en su definici\xF3n',
        typeAliasNotInModuleOrClass: "Un TypeAlias solo puede definirse en el \xE1mbito de un m\xF3dulo o de una clase",
        typeAliasRedeclared: '"{name}" se declara como TypeAlias y solo puede asignarse una vez',
        typeAliasStatementBadScope: "Una instrucci\xF3n de type solo se puede usar en el \xE1mbito de un m\xF3dulo o de una clase",
        typeAliasStatementIllegal: "La sentencia Type alias requiere Python 3.12 o posterior",
        typeAliasTypeBadScope: "Un alias de tipo solo se puede definir dentro de un \xE1mbito de m\xF3dulo o clase",
        typeAliasTypeBaseClass: 'Un alias de tipo definido en una instrucci\xF3n "type" no se puede usar como clase base',
        typeAliasTypeMustBeAssigned: "TypeAliasType debe asignarse a una variable con el mismo nombre que el alias de tipo",
        typeAliasTypeNameArg: "El primer argumento de TypeAliasType debe ser un literal de cadena que represente el nombre del alias de tipo",
        typeAliasTypeNameMismatch: "El nombre del alias de tipo debe coincidir con el nombre de la variable a la que se asigna",
        typeAliasTypeParamInvalid: "La lista de par\xE1metros de tipo debe ser una tuple que contenga solo TypeVar, TypeVarTuple o ParamSpec.",
        typeAnnotationCall: "No se permite la expresi\xF3n de llamada en la expresi\xF3n de tipo",
        typeAnnotationVariable: "Variable no permitida en la expresi\xF3n de tipo",
        typeAnnotationWithCallable: 'El argumento de tipo para "type" debe ser una clase; no se admiten invocables',
        typeArgListExpected: "ParamSpec esperado, elipsis o lista de tipos",
        typeArgListNotAllowed: "Expresi\xF3n de lista no permitida para este argumento de tipo",
        typeArgsExpectingNone: 'No se esperaban argumentos de tipo para la clase "{name}"',
        typeArgsMismatchOne: "Se esperaba un argumento de tipo pero ha recibido {received}",
        typeArgsMissingForAlias: 'Argumentos de tipo esperados para el alias de tipo gen\xE9rico "{name}"',
        typeArgsMissingForClass: 'Se esperaban argumentos de tipo para la clase gen\xE9rica "{name}"',
        typeArgsTooFew: 'Se han proporcionado muy pocos argumentos de tipo para "{name}"; se esperaba {expected} pero se ha recibido {received}.',
        typeArgsTooMany: 'Se proporcionaron demasiados argumentos de tipo para "{name}"; se esperaba {expected}, pero se recibieron {received}',
        typeAssignmentMismatch: 'El tipo "{sourceType}" no se puede asignar al tipo declarado "{destType}"',
        typeAssignmentMismatchWildcard: 'El s\xEDmbolo de importaci\xF3n "{name}" tiene el tipo "{sourceType}", que no se puede asignar al tipo declarado "{destType}"',
        typeCallNotAllowed: "La llamada a type() no debe utilizarse en la expresi\xF3n de tipo",
        typeCheckOnly: '"{name}" est\xE1 marcado como @type_check_only y solo se puede usar en anotaciones de tipo',
        typeCommentDeprecated: "El uso de comentarios de type est\xE1 obsoleto; utilice en su lugar anotaciones de type.",
        typeExpectedClass: 'Se esperaba la clase pero se recibi\xF3 "{type}"',
        typeFormArgs: '"TypeForm" acepta un \xFAnico argumento posicional',
        typeGuardArgCount: 'Se esperaba un \xFAnico argumento de tipo despu\xE9s de "TypeGuard" o "TypeIs"',
        typeGuardParamCount: "Las funciones y m\xE9todos de protecci\xF3n de tipo definidos por el usuario deben tener al menos un par\xE1metro de entrada",
        typeIsReturnType: 'El tipo de valor devuelto de TypeIs ("{returnType}") no es coherente con el tipo de par\xE1metro de valor ("{type}")',
        typeNotAwaitable: '"{type}" no se awaitable',
        typeNotIntantiable: '"{type}" no puede crear instancias',
        typeNotIterable: '"{type}" no es iterable',
        typeNotSpecializable: 'No se pudo especializar el tipo "{type}"',
        typeNotSubscriptable: 'Objeto de tipo "{type}" no es subscriptible',
        typeNotSupportBinaryOperator: 'El operador "{operator}" no se admite para los tipos "{leftType}" y "{rightType}"',
        typeNotSupportBinaryOperatorBidirectional: 'No se admite el operador "{operator}" para los tipos "{leftType}" y "{rightType}" cuando el tipo esperado es "{expectedType}"',
        typeNotSupportUnaryOperator: 'El operador "{operator}" no se admite para el tipo "{type}"',
        typeNotSupportUnaryOperatorBidirectional: 'Operador "{operator}" no admitido para el tipo "{type}" cuando el tipo esperado es "{expectedType}"',
        typeNotUsableWith: 'El objeto de tipo "{type}" no se puede usar con "with" porque no implementa correctamente {method}',
        typeNotUsableWithAsync: 'El objeto de tipo "{type}" no se puede usar con "async with" porque no implementa correctamente {method}',
        typeParameterBoundNotAllowed: "No se pueden usar l\xEDmites o restricciones con un par\xE1metro de tipo vari\xE1dico o ParamSpec",
        typeParameterConstraintTuple: "La restricci\xF3n del par\xE1metro de tipo debe ser una tupla de dos o m\xE1s tipos",
        typeParameterExistingTypeParameter: 'El par\xE1metro de tipo "{name}" ya est\xE1 en uso',
        typeParameterNotDeclared: 'El par\xE1metro de tipo "{name}" no est\xE1 incluido en la lista de par\xE1metros de tipo para "{container}"',
        typeParametersMissing: "Debe especificarse al menos un par\xE1metro de tipo",
        typePartiallyUnknown: 'El tipo de "{name}" es parcialmente desconocido',
        typeUnknown: 'El tipo de "{name} " es desconocido',
        typeVarAssignedName: 'TypeVar debe asignarse a una variable llamada "{name}"',
        typeVarAssignmentMismatch: 'No se puede asignar el tipo "{type}" a la variable de tipo "{name}"',
        typeVarBoundAndConstrained: "TypeVar no puede estar ligado y restringido a la vez",
        typeVarBoundGeneric: "El tipo vinculado TypeVar no puede ser gen\xE9rico",
        typeVarConstraintGeneric: "El tipo de restricci\xF3n TypeVar no puede ser gen\xE9rico",
        typeVarDefaultBoundMismatch: "El tipo predeterminado TypeVar debe ser un subtipo del tipo enlazado.",
        typeVarDefaultConstraintMismatch: "El tipo predeterminado TypeVar debe ser uno de los tipos restringidos.",
        typeVarDefaultIllegal: "Los tipos predeterminados de variable de tipo requieren Python 3.13 o posterior",
        typeVarDefaultInvalidTypeVar: 'El par\xE1metro de tipo "{name}" tiene un tipo por defecto que hace referencia a una o m\xE1s variables de tipo que est\xE1n fuera de \xE1mbito.',
        typeVarFirstArg: "Nombre esperado de TypeVar como primer argumento",
        typeVarInvalidForMemberVariable: 'El tipo de atributo no puede usar una variable de tipo "{name}" con \xE1mbito de m\xE9todo local',
        typeVarNoMember: 'TypeVar "{type}" no tiene ning\xFAn atributo "{name}"',
        typeVarNotSubscriptable: 'TypeVar "{type}" no es subscribible',
        typeVarNotUsedByOuterScope: 'La variable de tipo "{name}" no tiene ning\xFAn significado en este contexto',
        typeVarPossiblyUnsolvable: 'La variable de tipo "{name}" puede quedar sin resolver si el autor de la llamada no proporciona ning\xFAn argumento para el par\xE1metro "{param}"',
        typeVarSingleConstraint: "TypeVar debe tener al menos dos tipos restringidos",
        typeVarTupleConstraints: "TypeVarTuple no puede tener restricciones de valor",
        typeVarTupleContext: "TypeVarTuple no est\xE1 permitido en este contexto",
        typeVarTupleDefaultNotUnpacked: "El tipo predeterminado TypeVarTuple debe ser una tuple desempaquetada o TypeVarTuple",
        typeVarTupleMustBeUnpacked: "Se requiere el operador Unpack para el valor TypeVarTuple.",
        typeVarTupleUnknownParam: '"{name}" es un par\xE1metro desconocido para TypeVarTuple',
        typeVarUnknownParam: '"{name}" es un par\xE1metro desconocido para TypeVar',
        typeVarUsedByOuterScope: 'TypeVar "{name}" ya est\xE1 en uso por un \xE1mbito externo',
        typeVarUsedOnlyOnce: 'TypeVar "{name}" solo aparece una vez en la firma de la funci\xF3n gen\xE9rica',
        typeVarVariance: "TypeVar no puede ser covariante y contravariante",
        typeVarWithDefaultFollowsVariadic: 'TypeVar "{typeVarName}" tiene un valor predeterminado y no puede seguir a TypeVarTuple "{variadicName}"',
        typeVarWithoutDefault: '"{name}" no puede aparecer despu\xE9s de "{other}" en la lista de par\xE1metros de tipo porque no tiene ning\xFAn tipo predeterminado',
        typeVarsNotInGenericOrProtocol: "Generic[] o Protocol[] deben incluir todas las variables de tipo",
        typedDictAccess: "No se ha podido acceder al elemento en TypedDict",
        typedDictAssignedName: 'TypedDict debe asignarse a una variable denominada "{name}"',
        typedDictBadVar: "Las clases TypedDict solo pueden contener anotaciones de tipo",
        typedDictBaseClass: "Todas las clases base de las clases TypedDict deben ser tambi\xE9n clases TypedDict",
        typedDictBoolParam: 'Se esperaba que el par\xE1metro "{name}" tuviera un valor de True o False.',
        typedDictClosedExtras: 'El "{name}" de clase base es un TypedDict que limita el tipo de elementos adicionales al tipo "{type}"',
        typedDictClosedFalseNonOpenBase: 'Base class "{name}" is not an open TypedDict; closed=False is not allowed',
        typedDictClosedNoExtras: 'La clase base "{name}" es un TypedDict closed; no se permiten elementos adicionales',
        typedDictDelete: "No se puede eliminar un elemento en TypedDict",
        typedDictEmptyName: "Los nombres de un TypedDict no pueden estar vac\xEDos",
        typedDictEntryName: "Cadena literal esperada para el nombre de la entrada del diccionario",
        typedDictEntryUnique: "Los nombres dentro de un diccionario deben ser \xFAnicos",
        typedDictExtraArgs: "No se admiten argumentos TypedDict adicionales",
        typedDictExtraItemsClosed: 'TypedDict puede usar "closed" o "extra_items", pero no ambos',
        typedDictFieldNotRequiredRedefinition: 'El elemento TypedDict "{name}" no se puede redefinir como NotRequired',
        typedDictFieldReadOnlyRedefinition: 'El elemento TypedDict "{name}" no se puede redefinir como ReadOnly',
        typedDictFieldRequiredRedefinition: 'El elemento TypedDict "{name}" no se puede redefinir como Required',
        typedDictFirstArg: "Nombre de clase TypedDict esperado como primer argumento",
        typedDictInClassPattern: "No se permite la clase TypedDict en el patr\xF3n de clase",
        typedDictInitsubclassParameter: 'TypedDict no admite __init_subclass__ par\xE1metro "{name}"',
        typedDictNotAllowed: '"TypedDict" no puede utilizarse en este contexto',
        typedDictSecondArgDict: "Par\xE1metro dict o palabra clave esperado como segundo par\xE1metro",
        typedDictSecondArgDictEntry: "Entrada de diccionario simple esperada",
        typedDictSet: "No se pudo asignar el elemento en TypedDict",
        unaccessedClass: 'No se accede a la clase "{name}"',
        unaccessedFunction: 'No se accede a la funci\xF3n "{name}',
        unaccessedImport: 'No se accede a la importaci\xF3n "{name}',
        unaccessedSymbol: 'No se accede a "{name}"',
        unaccessedVariable: 'No se accede a la variable "{name} ".',
        unannotatedFunctionSkipped: 'Se omite el an\xE1lisis de la funci\xF3n "{name}" porque no est\xE1 anotada',
        unaryOperationNotAllowed: "Operador unario no permitido en la expresi\xF3n de tipo",
        unexpectedAsyncToken: 'Se esperaba que "def", "with" o "for" siguieran a "async".',
        unexpectedEof: "Unexpected EOF",
        unexpectedExprToken: "Token inesperado al final de la expresi\xF3n",
        unexpectedIndent: "sangSangr\xEDa inesperadar\xEDa inesperada",
        unexpectedUnindent: "No se espera sangr\xEDa",
        unhashableDictKey: "La clave del diccionario debe ser hash",
        unhashableSetEntry: "La entrada del set debe ser hashable",
        uninitializedAbstractVariables: 'Las variables definidas en la clase base abstracta no se inicializan en la clase final "{classType}"',
        uninitializedInstanceVariable: 'La variable de instancia "{name}" no est\xE1 inicializada en el cuerpo de la clase o en el m\xE9todo __init__.',
        unionForwardReferenceNotAllowed: "Union syntax cannot be used with string operand; use quotes around entire expression",
        unionSyntaxIllegal: "La sintaxis alternativa para las uniones requiere Python 3.10 o posterior.",
        unionTypeArgCount: "Union requiere dos o m\xE1s argumentos de tipo",
        unionUnpackedTuple: "La Union no puede incluir una tuple desempaquetada",
        unionUnpackedTypeVarTuple: "La Union no puede incluir un TypeVarTuple desempaquetado",
        unnecessaryCast: 'Llamada "cast" innecesaria; el tipo ya es "{type}"',
        unnecessaryIsInstanceAlways: 'Llamada isinstance innecesaria; "{testType}" es siempre una instancia de "{classType}"',
        unnecessaryIsInstanceNever: 'Llamada isinstance innecesaria; "{testType}" es nunca una instancia de "{classType}"',
        unnecessaryIsSubclassAlways: 'Llamada de issubclass innecesaria; "{testType}" siempre es una subclase de "{classType}"',
        unnecessaryIsSubclassNever: 'Llamada de issubclass innecesaria; "{testType}" nunca es una subclase de "{classType}"',
        unnecessaryPyrightIgnore: 'Comentario "# pyright: ignore" innecesario',
        unnecessaryPyrightIgnoreRule: 'Regla innecesaria "# pyright: ignore": "{name}"',
        unnecessaryTypeIgnore: 'Comentario "# type: ignore" innecesario',
        unpackArgCount: 'Se esperaba un \xFAnico argumento de tipo despu\xE9s de "Unpack"',
        unpackExpectedTypeVarTuple: "Se esperaba TypeVarTuple o tuple como argumento de tipo para Unpack",
        unpackExpectedTypedDict: "Se esperaba un argumento de tipo TypedDict para Unpack",
        unpackIllegalInComprehension: "Operaci\xF3n de desempaquetado no permitida en la comprensi\xF3n",
        unpackInAnnotation: "No se permite el operador desempaquetado en la expresi\xF3n de tipo",
        unpackInDict: "Operaci\xF3n de desempaquetado no permitida en diccionarios",
        unpackInSet: "No se permite el operador Unpack dentro de un set",
        unpackNotAllowed: "Unpack no est\xE1 permitido en este contexto",
        unpackOperatorNotAllowed: "La operaci\xF3n de desempaquetado no est\xE1 permitida en este contexto",
        unpackTuplesIllegal: "Operaci\xF3n de desempaquetado no permitida en tuplas anteriores a Python 3.8",
        unpackedArgInTypeArgument: "No se pueden usar argumentos sin empaquetar en este contexto",
        unpackedArgWithVariadicParam: "No se puede usar un argumento desempaquetado para el par\xE1metro TypeVarTuple",
        unpackedDictArgumentNotMapping: 'La expresi\xF3n del argumento despu\xE9s de ** debe ser un mapeo con un tipo de clave "str".',
        unpackedDictSubscriptIllegal: "El operador de desempaquetado del diccionario en el sub\xEDndice no est\xE1 permitido",
        unpackedSubscriptIllegal: "El operador de desempaquetado en el sub\xEDndice requiere Python 3.11 o posterior.",
        unpackedTypeVarTupleExpected: "Se espera un TypeVarTuple desempaquetado; use Unpack[{name1}] o *{name2}",
        unpackedTypedDictArgument: "No se puede emparejar el argumento TypedDict desempaquetado con los par\xE1metros",
        unreachableCodeCondition: "Code is not analyzed because condition is statically evaluated as false",
        unreachableCodeStructure: "Code is structurally unreachable",
        unreachableCodeType: "El an\xE1lisis de tipos indica que no se puede acceder al c\xF3digo",
        unreachableExcept: "La cl\xE1usula Excepto es inalcanzable porque la excepci\xF3n ya est\xE1 administrada",
        unsupportedDunderAllOperation: 'No se admite la operaci\xF3n en "__all__", por lo que la lista de s\xEDmbolos exportada puede ser incorrecta.',
        unusedCallResult: 'El resultado de la expresi\xF3n de llamada es de tipo "{type}" y no se usa; asignar a la variable "_" si esto es intencionado',
        unusedCoroutine: 'El resultado de la llamada a una funci\xF3n async no se utiliza; utilice "await" o asigne el resultado a una variable.',
        unusedExpression: "El valor de expresi\xF3n no se usa",
        varAnnotationIllegal: "Las anotaciones de type para variables requieren Python 3.6 o posterior; utilice el comentario de tipo para la compatibilidad con versiones anteriores.",
        variableFinalOverride: 'La variable "{name}" est\xE1 marcada como Final y anula la variable no Final del mismo nombre en la clase "{className}".',
        variadicTypeArgsTooMany: "La lista de argumentos de tipo puede tener como m\xE1ximo una TypeVarTuple o tuple desempaquetada",
        variadicTypeParamTooManyAlias: "Los alias de tipo pueden tener como m\xE1ximo un par\xE1metro de tipo TypeVarTuple, pero reciben varios ({names})",
        variadicTypeParamTooManyClass: "La clase gen\xE9rica puede tener como m\xE1ximo un par\xE1metro de tipo TypeVarTuple pero recibi\xF3 m\xFAltiples ({names})",
        walrusIllegal: 'El operador ":=" requiere Python 3.8 o posterior',
        walrusNotAllowed: 'El operador ":=" no est\xE1 permitido en este contexto sin par\xE9ntesis alrededor',
        wildcardInFunction: "No se permite la importaci\xF3n de comodines dentro de una clase o funci\xF3n",
        wildcardLibraryImport: "No se permite la importaci\xF3n de caracteres comod\xEDn desde una biblioteca",
        wildcardPatternTypePartiallyUnknown: "El tipo capturado por el patr\xF3n comod\xEDn es parcialmente desconocido",
        wildcardPatternTypeUnknown: "Se desconoce el tipo capturado por el patr\xF3n de caracteres comod\xEDn",
        yieldFromIllegal: 'El uso de "yield from" requiere Python 3.3 o posterior.',
        yieldFromOutsideAsync: '"yield from" no permitido en una funci\xF3n async',
        yieldOutsideFunction: '"yield" no se permite fuera de una funci\xF3n o lambda',
        yieldWithinComprehension: '"yield" no est\xE1 permitido dentro de una comprensi\xF3n de lista',
        zeroCaseStatementsFound: "La instrucci\xF3n Match debe incluir al menos una instrucci\xF3n case",
        zeroLengthTupleNotAllowed: "La tuple de longitud cero no est\xE1 permitida en este contexto"
      },
      DiagnosticAddendum: {
        annotatedNotAllowed: 'El formulario especial "Annotated" no se puede usar con comprobaciones de instancia y clase',
        argParam: 'El argumento corresponde al par\xE1metro "{paramName}"',
        argParamFunction: 'El argumento corresponde al par\xE1metro "{paramName}" en la funci\xF3n "{functionName}"',
        argsParamMissing: 'El par\xE1metro "*{paramName}" no tiene ning\xFAn par\xE1metro correspondiente',
        argsPositionOnly: "Error de coincidencia del par\xE1metro de solo posici\xF3n; se esperaba {expected}, pero se recibieron {received}",
        argumentType: 'El tipo de argumento es "{type}"',
        argumentTypes: "Tipos de argumento: ({types})",
        assignToNone: 'El tipo no se puede asignar a "None"',
        asyncHelp: '\xBFQuer\xEDa decir "async with"?',
        baseClassIncompatible: 'La clase base "{baseClass}" no es compatible con el tipo "{type}"',
        baseClassIncompatibleSubclass: 'La clase base "{baseClass}" deriva de "{subclass}", que no es compatible con el tipo "{type}"',
        baseClassOverriddenType: 'La clase base "{baseClass}" proporciona el tipo "{type}", que se sobrescribe',
        baseClassOverridesType: 'Invalidaciones de clase base "{baseClass}" con el tipo "{type}"',
        bytesTypePromotions: 'Establezca disableBytesTypePromotions en false para activar el comportamiento de promoci\xF3n de tipos para "bytearray" y "memoryview".',
        conditionalRequiresBool: 'El m\xE9todo __bool__ para el tipo "{operandType}" devuelve el tipo "{boolReturnType}" en lugar de "bool"',
        dataClassFieldLocation: "en declaraci\xF3n de campo",
        dataClassFrozen: '"{name}" est\xE1 congelado',
        dataProtocolUnsupported: '"{name}" es un protocolo de datos',
        descriptorAccessBindingFailed: 'No se pudo enlazar el m\xE9todo "{name}" para la clase de descriptor "{className}"',
        descriptorAccessCallFailed: 'No se pudo llamar al m\xE9todo "{name}" para la clase de descriptor "{className}"',
        finalMethod: "Final method",
        functionParamDefaultMissing: 'Falta el argumento predeterminado en el par\xE1metro "{name}"',
        functionParamName: 'Nombre de par\xE1metro no coincidente: "{destName}" frente a "{srcName}"',
        functionParamPositionOnly: 'Error de coincidencia del par\xE1metro de solo posici\xF3n; el par\xE1metro "{name}" no es de solo posici\xF3n',
        functionReturnTypeMismatch: 'El tipo de valor devuelto de la funci\xF3n "{sourceType}" no es compatible con el tipo "{destType}"',
        functionTooFewParams: "La funci\xF3n acepta muy pocos par\xE1metros posicionales; esperado {expected} pero recibido {received}",
        functionTooManyParams: "La funci\xF3n acepta demasiados par\xE1metros posicionales; esperado {expected} pero recibido {received}",
        genericClassNotAllowed: "Tipo gen\xE9rico con argumentos de tipo no permitidos para comprobaciones de instancia o clase",
        incompatibleDeleter: "El m\xE9todo de deleter de property no es compatible",
        incompatibleGetter: "El m\xE9todo getter de property no es compatible",
        incompatibleSetter: "El m\xE9todo setter de la property no es compatible",
        initMethodLocation: 'El m\xE9todo __init__ se define en la clase "{type}"',
        initMethodSignature: 'La firma de __init__ es "{type}"',
        initSubclassLocation: 'El m\xE9todo __init_subclass__ se define en la clase "{name}"',
        invariantSuggestionDict: 'Considere cambiar de "dict" a " Mapping" que es covariante en el tipo de valor',
        invariantSuggestionList: 'Considere la posibilidad de cambiar de "lista" a "Sequence" que es covariante',
        invariantSuggestionSet: 'Considere la posibilidad de cambiar de "set" a "Container" que es covariante',
        isinstanceClassNotSupported: '"{type}" no se admite para las comprobaciones de instancia y clase',
        keyNotRequired: '"{name}" no es una clave necesaria en "{type}", por lo que el acceso puede dar lugar a una excepci\xF3n en tiempo de ejecuci\xF3n',
        keyReadOnly: '"{name}" es una clave de solo lectura en "{type}"',
        keyRequiredDeleted: '"{name}" es una clave necesaria y no se puede eliminar',
        keyUndefined: '"{name}" no es una clave definida en "{type}"',
        kwargsParamMissing: 'El par\xE1metro "**{paramName}" no tiene ning\xFAn par\xE1metro correspondiente.',
        listAssignmentMismatch: 'El tipo "{type}" es incompatible con la lista de objetivos',
        literalAssignmentMismatch: '"{sourceType}" no se puede asignar al tipo "{destType}"',
        literalNotAllowed: 'El formulario especial "Literal" no se puede usar con comprobaciones de instancia y clase',
        matchIsNotExhaustiveHint: 'Si no se pretende un tratamiento exhaustivo, agregue "case _: pass"',
        matchIsNotExhaustiveType: 'Tipo no manejado: "{type}"',
        memberAssignment: 'La expresi\xF3n de tipo "{type}" no se puede asignar al atributo "{name}" de la clase "{classType}"',
        memberIsAbstract: '"{type}. {name}" no est\xE1 implementado',
        memberIsAbstractMore: "y {count} m\xE1s...",
        memberIsClassVarInProtocol: '"{name}" se define como ClassVar en el protocolo',
        memberIsInitVar: '"{name}" es un campo init-only',
        memberIsInvariant: '"{name}" es invariable porque es mutable',
        memberIsNotClassVarInClass: '"{name}" debe definirse como ClassVar para que sea compatible con el protocolo',
        memberIsNotClassVarInProtocol: '"{name}" no est\xE1 definido como ClassVar en el protocolo',
        memberIsNotReadOnlyInProtocol: '"{name}" no es de solo lectura en el protocolo',
        memberIsReadOnlyInProtocol: '"{name}" es de solo lectura en el protocolo',
        memberIsWritableInProtocol: '"{name}" se puede escribir en el protocolo',
        memberSetClassVar: 'El atributo "{name}" no se puede asignar a trav\xE9s de una instancia de clase porque es un ClassVar.',
        memberTypeMismatch: '"{name}" es un tipo incompatible',
        memberUnknown: 'Atributo "{name}" desconocido',
        metaclassConflict: 'La metaclase "{metaclass1}" entra en conflicto con "{metaclass2}"',
        missingDeleter: "Falta el m\xE9todo de deleter de property",
        missingGetter: "Falta el m\xE9todo getter de la property",
        missingSetter: "Falta el m\xE9todo setter de property",
        namedParamMissingInDest: 'Par\xE1metro adicional "{name}"',
        namedParamMissingInSource: 'Falta el par\xE1metro de palabra clave "{name}"',
        namedParamTypeMismatch: 'El par\xE1metro de palabra clave "{name}" de tipo "{sourceType}" no es compatible con el tipo "{destType}"',
        namedTupleNotAllowed: "No se puede usar NamedTuple para comprobaciones de instancia o clase",
        newMethodLocation: 'El m\xE9todo __new__ est\xE1 definido en la clase "{type}"',
        newMethodSignature: 'La firma de __new__ es "{type}"',
        newTypeClassNotAllowed: "Type created with NewType cannot be used with instance and class checks",
        noOverloadAssignable: 'Ninguna funci\xF3n sobrecargada coincide con el tipo "{type}"',
        noneNotAllowed: "No se puede usar None para comprobaciones de instancia o clase",
        orPatternMissingName: "Nombres que faltan: {name}",
        overloadIndex: "La sobrecarga {index} es la coincidencia m\xE1s cercana",
        overloadNotAssignable: 'Una o m\xE1s sobrecargas de "{name}" no es asignable',
        overloadSignature: "Aqu\xED se define la firma de la sobrecarga",
        overriddenMethod: "M\xE9todo reemplazado",
        overriddenSymbol: "S\xEDmbolo anulado",
        overrideInvariantMismatch: "El tipo de invalidaci\xF3n \u201C{overrideType}\u201D no es el mismo que el tipo b\xE1sico \u201C{baseType}\u201D",
        overrideIsInvariant: "La variable es mutable, por lo que su tipo es invariable",
        overrideNoOverloadMatches: "Ninguna firma de sobrecarga en anulaci\xF3n es compatible con el m\xE9todo base",
        overrideNotClassMethod: "El m\xE9todo base se declara como classmethod pero el Reemplazar no",
        overrideNotInstanceMethod: "El m\xE9todo base se declara como m\xE9todo de instancia, pero la invalidaci\xF3n no",
        overrideNotStaticMethod: "El m\xE9todo base se declara como staticmethod pero el reemplazo no",
        overrideOverloadNoMatch: "La invalidaci\xF3n no controla todas las sobrecargas del m\xE9todo base",
        overrideOverloadOrder: "Las sobrecargas para el m\xE9todo de anulaci\xF3n deben estar en el mismo orden que el m\xE9todo base",
        overrideParamKeywordNoDefault: 'El par\xE1metro de palabra clave "{name}" no coincide: el par\xE1metro base tiene el valor de argumento predeterminado, el par\xE1metro de invalidaci\xF3n no',
        overrideParamKeywordType: 'El par\xE1metro de palabra clave "{name}" no coincide: el par\xE1metro base es de tipo "{baseType}", el par\xE1metro de invalidaci\xF3n es de tipo "{overrideType}"',
        overrideParamName: 'El nombre del par\xE1metro {index} no coincide: el par\xE1metro base se denomina "{baseName}", el par\xE1metro de invalidaci\xF3n se denomina "{overrideName}"',
        overrideParamNameExtra: 'Falta el par\xE1metro "{name}" en la base',
        overrideParamNameMissing: 'Falta el par\xE1metro "{name}" en la invalidaci\xF3n',
        overrideParamNamePositionOnly: 'El par\xE1metro {index} no coincide: el par\xE1metro base "{baseName}" es un par\xE1metro de palabra clave, el par\xE1metro de invalidaci\xF3n es de solo posici\xF3n',
        overrideParamNoDefault: "El par\xE1metro {index} no coincide: el par\xE1metro base tiene un valor de argumento predeterminado, el par\xE1metro de invalidaci\xF3n no",
        overrideParamType: 'El par\xE1metro {index} no coincide: el par\xE1metro base es de tipo "{baseType}", el par\xE1metro de invalidaci\xF3n es de tipo "{overrideType}"',
        overridePositionalParamCount: "El recuento de par\xE1metros posicionales no coincide; el m\xE9todo base tiene {baseCount}, pero la invalidaci\xF3n tiene {overrideCount}",
        overrideReturnType: 'Error de tipo de retorno: el m\xE9todo base devuelve el tipo "{baseType}", el reemplazo devuelve el tipo "{overrideType}".',
        overrideType: 'La clase base define el tipo como "{type}"',
        paramAssignment: 'El par\xE1metro {index}: el tipo "{sourceType}" no es compatible con el tipo "{destType}"',
        paramSpecMissingInOverride: "Faltan par\xE1metros ParamSpec en el m\xE9todo de invalidaci\xF3n",
        paramType: 'El tipo de par\xE1metro es "{paramType}"',
        privateImportFromPyTypedSource: 'Importar desde "{module}" en su lugar',
        propertyAccessFromProtocolClass: "No se puede tener acceso a una propiedad definida dentro de una clase de protocolo como variable de clase",
        propertyMethodIncompatible: 'El m\xE9todo de property "{name}" no es compatible',
        propertyMethodMissing: 'Falta el m\xE9todo de property "{name}" en la invalidaci\xF3n',
        propertyMissingDeleter: 'Property "{name}" no tiene un supresor deleter',
        propertyMissingSetter: 'Property "{name}" no tiene el valor setter definido',
        protocolIncompatible: '"{sourceType}" no es compatible con el protocolo "{destType}"',
        protocolMemberMissing: '"{name}" no est\xE1 presente.',
        protocolRequiresRuntimeCheckable: "La clase de Protocol debe ser @runtime_checkable para usarse con comprobaciones de instancia y clase",
        protocolSourceIsNotConcrete: '"{sourceType}" no es un tipo de clase concreto y no se puede asignar al tipo "{destType}"',
        protocolUnsafeOverlap: 'Los atributos de "{name}" tienen los mismos nombres que el protocolo',
        pyrightCommentIgnoreTip: 'Utilice "# pyright: ignore[<diagnostic rules>]" para suprimir el diagn\xF3stico de una sola l\xEDnea',
        readOnlyAttribute: 'El atributo "{name}" es de solo lectura',
        seeClassDeclaration: "Ver declaraci\xF3n de clase",
        seeDeclaration: "Ver declaraci\xF3n",
        seeFunctionDeclaration: "Ver declaraci\xF3n de funci\xF3n",
        seeMethodDeclaration: "Consulte la declaraci\xF3n del m\xE9todoa",
        seeParameterDeclaration: "Declaraci\xF3n de par\xE1metro",
        seeTypeAliasDeclaration: "V\xE9ase la declaraci\xF3n de alias de tipo",
        seeVariableDeclaration: "declaraci\xF3n de variable out",
        tupleAssignmentMismatch: 'El tipo "{type}" no es compatible con la tuple de destino',
        tupleEntryTypeMismatch: "La entrada {entry} de la tuple es de tipo incorrecto",
        tupleSizeIndeterminateSrc: "El tama\xF1o de la tuple no coincide; se esperaba {expected} pero se recibi\xF3 uno indeterminado",
        tupleSizeIndeterminateSrcDest: "El tama\xF1o de la tuple no coincide; se esperaba {expected} o m\xE1s, pero se recibi\xF3 uno indeterminado",
        tupleSizeMismatch: "El tama\xF1o de la tuple no coincide; se esperaba {expected} pero se recibi\xF3 {received}",
        tupleSizeMismatchIndeterminateDest: "El tama\xF1o de la tuple no coincide; se esperaba {expected} o m\xE1s, pero se recibi\xF3 {received}",
        typeAliasInstanceCheck: 'El alias de tipo creado con la instrucci\xF3n "type" no se puede usar con comprobaciones de instancia y clase',
        typeAssignmentMismatch: 'El tipo "{sourceType}" no se puede asignar al tipo "{destType}"',
        typeBound: 'El tipo "{sourceType}" no se puede asignar al l\xEDmite superior "{destType}" para la variable de tipo "{name}"',
        typeConstrainedTypeVar: 'El tipo "{type}" no se puede asignar a la variable de tipo restringido "{name}"',
        typeIncompatible: '"{sourceType}" no se puede asignar a "{destType}"',
        typeNotClass: '"{type}" no es una clase',
        typeNotStringLiteral: '"{type}" no es un literal de cadena',
        typeOfSymbol: 'El tipo de "{name}" es "{type}"',
        typeParamSpec: 'El tipo "{type}" no es compatible con ParamSpec "{name}"',
        typeUnsupported: 'El tipo "{type}" no es compatible',
        typeVarDefaultOutOfScope: 'La variable de tipo "{name} " no est\xE1 en el \xE1mbito de aplicaci\xF3n',
        typeVarIsContravariant: 'El par\xE1metro de tipo "{name}" es contravariante, pero "{sourceType}" no es un supertipo de "{destType}"',
        typeVarIsCovariant: 'El par\xE1metro de tipo "{name}" es covariante, pero "{sourceType}" no es un subtipo de "{destType}"',
        typeVarIsInvariant: 'El par\xE1metro de tipo "{name}" es invariable, pero "{sourceType}" no es el mismo que "{destType}"',
        typeVarNotAllowed: "TypeVar no se permite para comprobaciones de instancia o clase",
        typeVarTupleRequiresKnownLength: "TypeVarTuple no se puede enlazar a una tuple de longitud desconocida",
        typeVarUnnecessarySuggestion: "Usar {type} en su lugar",
        typeVarUnsolvableRemedy: "Proporciona una sobrecarga que especifica el tipo de retorno cuando no se proporciona el argumento",
        typeVarsMissing: "Faltan variables de tipo: {names}",
        typedDictBaseClass: "La clase \u201C{type}\u201D no es un TypedDict",
        typedDictClassNotAllowed: "No se permite la clase TypedDict para comprobaciones de instancia o clase",
        typedDictClosedExtraNotAllowed: 'No se puede agregar el elemento "{name}"',
        typedDictClosedExtraTypeMismatch: 'No se puede agregar el elemento "{name}" con el tipo "{type}"',
        typedDictClosedFieldNotReadOnly: 'Cannot add item "{name}" because it must be ReadOnly',
        typedDictClosedFieldNotRequired: 'No se puede agregar el elemento "{name}" porque debe ser NotRequired.',
        typedDictExtraFieldNotAllowed: '"{name}" no est\xE1 presente en "{type}"',
        typedDictExtraFieldTypeMismatch: 'El tipo de "{name}" no es compatible con el tipo de "extra_items" en "{type}"',
        typedDictFieldMissing: '"{name}" falta en "{type}"',
        typedDictFieldNotReadOnly: '"{name}" no es de solo lectura en "{type}"',
        typedDictFieldNotRequired: '"{name}" no es obligatorio en "{type}"',
        typedDictFieldRequired: '"{name}" es obligatorio en "{type}"',
        typedDictFieldTypeMismatch: 'El tipo "{type}" no se puede asignar al elemento "{name}"',
        typedDictFieldUndefined: '"{name}" es un elemento no definido en el tipo "{type}"',
        typedDictKeyAccess: 'Utilizar ["{name}"] para hacer referencia al elemento en TypedDict',
        typedDictNotAllowed: "No se puede usar TypedDict para comprobaciones de instancia o clase",
        unhashableType: 'El tipo "{type}" no admite hash',
        uninitializedAbstractVariable: 'La variable de instancia "{name}" est\xE1 definida en la clase base abstracta "{classType} " pero no inicializada.',
        unreachableExcept: '"{exceptionType}" es una subclase de "{parentType}"',
        useDictInstead: "Utilice dict[T1, T2] para indicar un tipo de diccionario",
        useListInstead: "Utilice list[T] para indicar un tipo de list o T1 | T2 para indicar un tipo de union",
        useTupleInstead: "Utilice tuple[T1, ..., Tn] para indicar un tipo de tuple o T1 | T2 para indicar un tipo de union",
        useTypeInstead: "Utilice type[T] en su lugar",
        varianceMismatchForClass: 'La varianza del argumento de tipo "{typeVarName}" no es compatible con la clase base "{className}"',
        varianceMismatchForTypeAlias: 'La varianza del argumento de tipo "{typeVarName}" no es compatible con "{typeAliasParam}"'
      },
      Service: {
        longOperation: "La enumeraci\xF3n de los archivos de origen del \xE1rea de trabajo est\xE1 tardando mucho tiempo. Considere la posibilidad de abrir una subcarpeta en su lugar. [M\xE1s informaci\xF3n](https://aka.ms/workspace-too-many-files)"
      }
    };
  }
});

// node_modules/@zzzen/pyright-internal/dist/localization/package.nls.fr.json
var require_package_nls_fr = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/localization/package.nls.fr.json"(exports2, module2) {
    module2.exports = {
      CodeAction: {
        createTypeStub: "Cr\xE9er un Stub de type",
        createTypeStubFor: "Cr\xE9er un Stub de type pour \xAB\xA0{moduleName}\xA0\xBB",
        executingCommand: "Ex\xE9cution de la commande",
        filesToAnalyzeCount: "{count}\xA0fichiers \xE0 analyser",
        filesToAnalyzeOne: "1 fichier \xE0 analyser",
        findingReferences: "Recherche de r\xE9f\xE9rences",
        organizeImports: "Organiser les importations"
      },
      Completion: {
        autoImportDetail: "Importation automatique",
        indexValueDetail: "Valeur de l'indice"
      },
      Diagnostic: {
        abstractMethodInvocation: "D\xE9sol\xE9, nous n\u2019avons pas pu appeler la m\xE9thode \xAB\xA0{method}\xA0\xBB, car elle est abstraite et non impl\xE9ment\xE9e",
        annotatedMetadataInconsistent: "Le type de m\xE9tadonn\xE9es annot\xE9 \xAB\xA0{metadataType}\xA0\xBB n\u2019est pas compatible avec le type \xAB\xA0{type}\xA0\xBB",
        annotatedParamCountMismatch: "Non-concordance du nombre d'annotations de param\xE8tre\xA0: attendu {expected} mais re\xE7u {received}",
        annotatedTypeArgMissing: "Un argument de type et une ou plusieurs annotations sont attendus pour \xAB Annotated \xBB",
        annotationBytesString: "Les expressions de type ne peuvent pas utiliser de litt\xE9raux de cha\xEEne d'octets",
        annotationFormatString: "Les expressions de type ne peuvent pas utiliser de litt\xE9raux de cha\xEEne de format (cha\xEEnes f)",
        annotationNotSupported: "Annotation de type non prise en charge pour cette instruction",
        annotationRawString: "Les expressions de type ne peuvent pas utiliser de litt\xE9raux de cha\xEEne bruts",
        annotationSpansStrings: "Les expressions de type ne peuvent pas s'\xE9tendre sur plusieurs litt\xE9raux de cha\xEEne",
        annotationStringEscape: "Les expressions de type ne peuvent pas contenir de caract\xE8res d'\xE9chappement",
        annotationTemplateString: "Type expressions cannot use template string literals (t-strings)",
        argAssignment: "Impossible d\u2019affecter l\u2019argument de type \xAB\xA0{argType}\xA0\xBB au param\xE8tre de type \xAB\xA0{paramType}\xA0\xBB",
        argAssignmentFunction: "Impossible d\u2019affecter l\u2019argument de type \xAB\xA0{argType}\xA0\xBB au param\xE8tre de type \xAB\xA0{paramType}\xA0\xBB dans la fonction \xAB\xA0{functionName}\xA0\xBB",
        argAssignmentParam: "Impossible d\u2019affecter l\u2019argument de type \xAB\xA0{argType}\xA0\xBB au param\xE8tre \xAB\xA0{paramName}\xA0\xBB de type \xAB\xA0{paramType}\xA0\xBB",
        argAssignmentParamFunction: "Impossible d\u2019affecter l\u2019argument de type \xAB\xA0{argType}\xA0\xBB au param\xE8tre \xAB\xA0{paramName}\xA0\xBB de type \xAB\xA0{paramType}\xA0\xBB dans la fonction \xAB\xA0{functionName}\xA0\xBB",
        argMissingForParam: "Argument manquant pour le param\xE8tre {name}",
        argMissingForParams: "Arguments manquants pour les param\xE8tres {names}",
        argMorePositionalExpectedCount: "{expected} arguments positionnels suppl\xE9mentaires attendus",
        argMorePositionalExpectedOne: "1 argument positionnel suppl\xE9mentaire attendu",
        argPositional: "Argument positionnel attendu",
        argPositionalExpectedCount: "Arguments positionnels {expected} attendus",
        argPositionalExpectedOne: "1 argument positionnel attendu",
        argTypePartiallyUnknown: "Le type d'argument est partiellement inconnu",
        argTypeUnknown: "Le type d\u2019argument est inconnu",
        assertAlwaysTrue: "L\u2019expression Assert prend toujours la valeur true",
        assertTypeArgs: "\xAB assert_type \xBB attend deux arguments positionnels",
        assertTypeTypeMismatch: "Non-concordance de \xAB assert_type \xBB : \xAB {expected} \xBB attendu, mais \xAB {received} \xBB",
        assignmentExprComprehension: `La cible d'expression d'affectation "{name}" ne peut pas utiliser le m\xEAme nom que la compr\xE9hension pour la cible`,
        assignmentExprContext: "L\u2019expression d\u2019assignation doit se trouver dans le module, la fonction ou l\u2019expression lambda",
        assignmentExprInSubscript: "Les expressions d\u2019assignation dans un indice sont prises en charge uniquement dans Python 3.10 et versions ult\xE9rieures",
        assignmentInProtocol: "Les variables d'instance ou de classe au sein d'une classe Protocol doivent \xEAtre explicitement d\xE9clar\xE9es dans le corps de la classe",
        assignmentTargetExpr: "L\u2019expression ne peut pas \xEAtre une cible d\u2019assignation",
        asyncNotInAsyncFunction: `L'utilisation de "async" n'est pas autoris\xE9e en dehors de la fonction async`,
        awaitIllegal: "L\u2019utilisation de \xAB await \xBB n\xE9cessite Python 3.5 ou version ult\xE9rieure",
        awaitNotAllowed: "Les expressions de type ne peuvent pas utiliser \xAB\xA0await\xA0\xBB",
        awaitNotInAsync: "\xAB await \xBB autoris\xE9 uniquement dans la fonction asynchrone",
        backticksIllegal: "Les expressions entour\xE9es de accents inverses ne sont pas prises en charge dans Python 3.x; utiliser repr \xE0 la place",
        baseClassCircular: "La classe ne peut pas d\xE9river d'elle-m\xEAme",
        baseClassFinal: "La classe de base \xAB\xA0{type}\xA0\xBB est marqu\xE9e comme finale et ne peut pas \xEAtre sous-class\xE9e",
        baseClassIncompatible: "Les classes de base de {type} sont mutuellement incompatibles",
        baseClassInvalid: "L\u2019argument pour la classe doit \xEAtre une classe de base",
        baseClassMethodTypeIncompatible: "Les classes de base de la classe \xAB\xA0{classType}\xA0\xBB d\xE9finissent la m\xE9thode \xAB\xA0{name}\xA0\xBB de mani\xE8re incompatible",
        baseClassUnknown: "Le type de classe de base est inconnu, ce qui masque le type de classe d\xE9riv\xE9e",
        baseClassVariableTypeIncompatible: "Les classes de base de la classe \xAB\xA0{classType}\xA0\xBB d\xE9finissent la variable \xAB\xA0{name}\xA0\xBB de mani\xE8re incompatible",
        binaryOperationNotAllowed: "Op\xE9rateur binaire non autoris\xE9 dans l'expression de type",
        bindParamMissing: "Impossible de lier la m\xE9thode \xAB\xA0{methodName}\xA0\xBB, car il manque un param\xE8tre \xAB\xA0self\xA0\xBB ou \xAB\xA0cls\xA0\xBB",
        bindTypeMismatch: `Impossible de lier la m\xE9thode "{methodName}" car "{type}" n'est pas attribuable au param\xE8tre "{paramName}"`,
        breakInExceptionGroup: "\xAB\xA0break\xA0\xBB n\u2019est pas autoris\xE9 dans un bloc \xAB\xA0except*\xA0\xBB",
        breakOutsideLoop: `"break" ne peut \xEAtre utilis\xE9 qu'\xE0 l'int\xE9rieur d'une boucle`,
        bytesUnsupportedEscape: "S\xE9quence d\u2019\xE9chappement non prise en charge dans le litt\xE9ral de bytes",
        callableExtraArgs: "Seuls deux arguments de type sont attendus pour \xAB\xA0Callable\xA0\xBB",
        callableFirstArg: "Liste de types de param\xE8tres attendue ou \xAB ... \xBB",
        callableNotInstantiable: "Impossible d\u2019instancier le type \xAB\xA0{type}\xA0\xBB",
        callableSecondArg: "Type de retour attendu en tant que deuxi\xE8me argument de type pour \xAB\xA0Callable\xA0\xBB",
        casePatternIsIrrefutable: "Le motif irr\xE9futable n'est autoris\xE9 que pour la derni\xE8re instruction case",
        classAlreadySpecialized: "Le type \xAB\xA0{type}\xA0\xBB est d\xE9j\xE0 sp\xE9cialis\xE9",
        classDecoratorTypeUnknown: "Le d\xE9corateur de classe non typ\xE9 masque le type de classe\xA0; d\xE9corateur ignorant",
        classDefinitionCycle: `La d\xE9finition de classe pour "{name}" d\xE9pend d'elle-m\xEAme`,
        classGetItemClsParam: "__class_getitem__ remplacement doit prendre un param\xE8tre \xAB cls \xBB",
        classMethodClsParam: 'Les m\xE9thodes de classe doivent prendre un param\xE8tre "cls"',
        classNotRuntimeSubscriptable: "L'indice pour la classe \xAB\xA0{name}\xA0\xBB g\xE9n\xE9rera une exception d'ex\xE9cution\xA0; placez l'expression de type entre guillemets",
        classPatternBuiltInArgPositional: "Le mod\xE8le de classe accepte uniquement le sous-mod\xE8le positionnel",
        classPatternNewType: '"{type}" cannot be used in a class pattern because it is defined using NewType',
        classPatternPositionalArgCount: 'Trop de mod\xE8les positionnels pour les "{type}" de classe ; {expected} attendue mais {received} re\xE7ues',
        classPatternTypeAlias: `"{type}" ne peut pas \xEAtre utilis\xE9 dans un mod\xE8le de classe car il s'agit d'un alias de type sp\xE9cialis\xE9`,
        classPropertyDeprecated: "Les propri\xE9t\xE9s de classe sont obsol\xE8tes dans Python 3.11 et ne seront pas prises en charge dans Python 3.13",
        classTypeParametersIllegal: "La syntaxe du param\xE8tre de type de classe n\xE9cessite Python 3.12 ou version ult\xE9rieure",
        classVarFirstArgMissing: 'Attendu un argument de type apr\xE8s "ClassVar"',
        classVarNotAllowed: "\xAB ClassVar \xBB n\u2019est pas autoris\xE9 dans ce contexte",
        classVarOverridesInstanceVar: "La variable de classe \xAB\xA0{name}\xA0\xBB remplace la variable d\u2019instance du m\xEAme nom dans la classe \xAB\xA0{className}\xA0\xBB",
        classVarTooManyArgs: 'Attendu un seul argument de type apr\xE8s "ClassVar"',
        classVarWithTypeVar: 'Le type "ClassVar" ne peut pas inclure de variables de type',
        clsSelfParamTypeMismatch: 'Le type de param\xE8tre "{name}" doit \xEAtre un supertype de sa classe "{classType}"',
        codeTooComplexToAnalyze: "Le code est trop complexe \xE0 analyser ; r\xE9duire la complexit\xE9 en refactorisant en sous-routines ou en r\xE9duisant les chemins de code conditionnels",
        collectionAliasInstantiation: 'Le type "{type}" ne peut pas \xEAtre instanci\xE9, utilisez "{alias}" \xE0 la place',
        comparisonAlwaysFalse: "La condition prend toujours la valeur False, car les types \xAB\xA0{leftType}\xA0\xBB et \xAB\xA0{rightType}\xA0\xBB ne se chevauchent pas",
        comparisonAlwaysTrue: "La condition prend toujours la valeur True, car les types \xAB\xA0{leftType}\xA0\xBB et \xAB\xA0{rightType}\xA0\xBB ne se chevauchent pas",
        comprehensionInDict: "La compr\xE9hension ne peut pas \xEAtre utilis\xE9e avec d\u2019autres entr\xE9es de dictionnaire",
        comprehensionInSet: "La compr\xE9hension ne peut pas \xEAtre utilis\xE9e avec d\u2019autres entr\xE9es set",
        concatenateContext: "\xAB\xA0Concatenate\xA0\xBB n\u2019est pas autoris\xE9 dans ce contexte",
        concatenateParamSpecMissing: "Le dernier argument de type pour \xAB\xA0Concatenate\xA0\xBB doit \xEAtre un ParamSpec ou bien \xAB\xA0...\xA0\xBB",
        concatenateTypeArgsMissing: "\xAB\xA0Concatenate\xA0\xBB n\xE9cessite au moins deux arguments de type",
        conditionalOperandInvalid: 'Op\xE9rande conditionnel non valide de type "{type}"',
        constantRedefinition: '"{name}" est constant (car il est en majuscule) et ne peut pas \xEAtre red\xE9fini',
        constructorParametersMismatch: 'Non-concordance entre la signature de __new__ et __init__ dans la classe "{classType}"',
        containmentAlwaysFalse: `L'expression sera toujours \xE9valu\xE9e \xE0 False car les types "{leftType}" et "{rightType}" ne se chevauchent pas`,
        containmentAlwaysTrue: `L'expression sera toujours \xE9valu\xE9e \xE0 True puisque les types "{leftType}" et "{rightType}" ne se chevauchent pas`,
        continueInExceptionGroup: "\xAB\xA0continue\xA0\xBB n\u2019est pas autoris\xE9 dans un bloc \xAB\xA0except*\xA0\xBB",
        continueOutsideLoop: "\xAB continuer \xBB ne peut \xEAtre utilis\xE9 qu\u2019au sein d\u2019une boucle",
        coroutineInConditionalExpression: "L'expression conditionnelle fait r\xE9f\xE9rence \xE0 une coroutine qui est toujours \xE9valu\xE9e \xE0 True",
        dataClassBaseClassFrozen: "Une classe non gel\xE9e ne peut pas h\xE9riter d'une classe gel\xE9e",
        dataClassBaseClassNotFrozen: "Une classe fig\xE9e ne peut pas h\xE9riter d\u2019une classe qui n\u2019est pas fig\xE9e",
        dataClassConverterFunction: "L\u2019argument de type \xAB\xA0{argType}\xA0\xBB n\u2019est pas un convertisseur valide pour le champ \xAB\xA0{fieldName}\xA0\xBB de type \xAB\xA0{fieldType}\xA0\xBB",
        dataClassConverterOverloads: "Aucune surcharge de \xAB\xA0{funcName}\xA0\xBB n\u2019est valide pour le champ \xAB\xA0{fieldName}\xA0\xBB de type \xAB\xA0{fieldType}\xA0\xBB",
        dataClassFieldInheritedDefault: "\xAB\xA0{fieldName}\xA0\xBB remplace un champ du m\xEAme nom mais n\u2019a pas de valeur par d\xE9faut",
        dataClassFieldWithDefault: "Les champs sans valeurs par d\xE9faut ne peuvent pas appara\xEEtre apr\xE8s les champs avec des valeurs par d\xE9faut",
        dataClassFieldWithPrivateName: "Le champ Dataclass ne peut pas utiliser de nom priv\xE9",
        dataClassFieldWithoutAnnotation: "Le champ Dataclass sans annotation de type provoquera une exception d'ex\xE9cution",
        dataClassPostInitParamCount: "La classe de donn\xE9es __post_init__ nombre de param\xE8tres incorrect ; le nombre de champs InitVar est {expected}",
        dataClassPostInitType: "Incompatibilit\xE9 du type de param\xE8tre de m\xE9thode __post_init__ Dataclass pour le champ \xAB {fieldName} \xBB",
        dataClassSlotsOverwrite: "__slots__ est d\xE9j\xE0 d\xE9fini dans la classe",
        dataClassTransformExpectedBoolLiteral: "Expression attendue qui prend statiquement la valeur True ou False",
        dataClassTransformFieldSpecifier: 'Expected tuple of classes or functions but received type "{type}"',
        dataClassTransformPositionalParam: "Tous les arguments de \xAB dataclass_transform \xBB doivent \xEAtre des arguments de mot cl\xE9",
        dataClassTransformUnknownArgument: "L\u2019argument \xAB {name} \xBB n\u2019est pas pris en charge par dataclass_transform",
        dataProtocolInSubclassCheck: "Les protocoles de donn\xE9es (qui incluent des attributs non m\xE9thode) ne sont pas autoris\xE9s dans les appels de issubclass",
        declaredReturnTypePartiallyUnknown: "Le type de retour d\xE9clar\xE9 \xAB {returnType} \xBB est partiellement inconnu",
        declaredReturnTypeUnknown: "Le type de retour d\xE9clar\xE9 est inconnu",
        defaultValueContainsCall: "Les appels de fonction et les objets mutables ne sont pas autoris\xE9s dans l'expression de la valeur par d\xE9faut du param\xE8tre",
        defaultValueNotAllowed: "Le param\xE8tre avec \xAB * \xBB ou \xAB ** \xBB ne peut pas avoir de valeur par d\xE9faut",
        delTargetExpr: "L'expression ne peut pas \xEAtre supprim\xE9e",
        deprecatedClass: 'La classe "{name}" est obsol\xE8te',
        deprecatedConstructor: "Le constructeur de la classe \xAB\xA0{name}\xA0\xBB est d\xE9conseill\xE9",
        deprecatedDescriptorDeleter: "La m\xE9thode \xAB\xA0__delete__\xA0\xBB du descripteur \xAB\xA0{name}\xA0\xBB est d\xE9conseill\xE9e",
        deprecatedDescriptorGetter: "La m\xE9thode \xAB\xA0__get__\xA0\xBB du descripteur \xAB\xA0{name}\xA0\xBB est d\xE9conseill\xE9e",
        deprecatedDescriptorSetter: "La m\xE9thode \xAB\xA0__set__\xA0\xBB du descripteur \xAB\xA0{name}\xA0\xBB est d\xE9conseill\xE9e",
        deprecatedFunction: 'La fonction "{name}" est obsol\xE8te',
        deprecatedMethod: 'La m\xE9thode "{name}" dans la classe "{className}" est obsol\xE8te',
        deprecatedPropertyDeleter: "Le deleter de la property \xAB\xA0{name}\xA0\xBB est d\xE9conseill\xE9",
        deprecatedPropertyGetter: "Le getter de la property \xAB\xA0{name}\xA0\xBB est d\xE9conseill\xE9",
        deprecatedPropertySetter: "Le setter de la property \xAB\xA0{name}\xA0\xBB est d\xE9conseill\xE9",
        deprecatedType: "Ce type est d\xE9conseill\xE9 \xE0 compter de Python {version}; utiliser \xAB {replacement} \xBB \xE0 la place",
        dictExpandIllegalInComprehension: "Expansion du dictionnaire non autoris\xE9e dans la compr\xE9hension",
        dictInAnnotation: "Expression de dictionnaire non autoris\xE9e dans l'expression de type",
        dictKeyValuePairs: "Les entr\xE9es de dictionnaire doivent contenir des paires cl\xE9/valeur",
        dictUnpackIsNotMapping: "Mappage attendu pour l\u2019op\xE9rateur de d\xE9compression de dictionnaire",
        dunderAllSymbolNotPresent: "\xAB\xA0{name}\xA0\xBB est sp\xE9cifi\xE9 dans __all__ mais n\u2019est pas pr\xE9sent dans le module",
        duplicateArgsParam: "Un seul param\xE8tre \xAB * \xBB est autoris\xE9",
        duplicateBaseClass: "Classe de base en double non autoris\xE9e",
        duplicateCapturePatternTarget: `La cible Capture "{name}" ne peut pas appara\xEEtre plus d'une fois dans le m\xEAme mod\xE8le`,
        duplicateCatchAll: "Une seule clause catch-all except autoris\xE9e",
        duplicateEnumMember: "Le membre Enum \xAB\xA0{name}\xA0\xBB est d\xE9j\xE0 d\xE9clar\xE9",
        duplicateGenericAndProtocolBase: "Une seule classe de base Generic[...] ou Protocol[...] autoris\xE9e",
        duplicateImport: "\xAB {importName} \xBB est import\xE9 plusieurs fois",
        duplicateKeywordOnly: "Un seul s\xE9parateur \xAB * \xBB autoris\xE9",
        duplicateKwargsParam: "Un seul param\xE8tre \xAB ** \xBB est autoris\xE9",
        duplicateParam: "Dupliquer le param\xE8tre \xAB {name} \xBB",
        duplicatePositionOnly: 'Un seul param\xE8tre "/" autoris\xE9',
        duplicateStarPattern: 'Un seul motif "*" autoris\xE9 dans une s\xE9quence de motifs',
        duplicateStarStarPattern: 'Une seule entr\xE9e "**" autoris\xE9e',
        duplicateUnpack: "Une seule op\xE9ration de d\xE9compression autoris\xE9e dans la liste",
        ellipsisAfterUnpacked: '"..." ne peut pas \xEAtre utilis\xE9 avec un TypeVarTuple ou un tuple d\xE9compress\xE9',
        ellipsisContext: "\xAB\xA0...\xA0\xBB n\u2019est pas autoris\xE9 dans ce contexte",
        ellipsisSecondArg: "\xAB\xA0...\xA0\xBB n\u2019est autoris\xE9 qu\u2019en tant que second des deux arguments",
        enumClassOverride: "La classe Enum \xAB\xA0{name}\xA0\xBB est finale et ne peut pas \xEAtre sous-class\xE9e",
        enumMemberDelete: "Le membre Enum \xAB {name} \xBB ne peut pas \xEAtre supprim\xE9",
        enumMemberSet: "Le membre Enum \xAB {name} \xBB ne peut pas \xEAtre affect\xE9",
        enumMemberTypeAnnotation: "Les annotations de type ne sont pas autoris\xE9es pour les membres enum",
        exceptGroupMismatch: "L\u2019instruction Try ne peut pas inclure \xE0 la fois \xAB\xA0except\xA0\xBB et \xAB\xA0except*\xA0\xBB",
        exceptGroupRequiresType: "La syntaxe du groupe d\u2019exceptions (\xAB\xA0except*\xA0\xBB) n\xE9cessite un type d\u2019exception",
        exceptRequiresParens: "Multiple exception types must be parenthesized prior to Python 3.14",
        exceptWithAsRequiresParens: 'Multiple exception types must be parenthesized when using "as"',
        exceptionGroupIncompatible: "La syntaxe du groupe d\u2019exceptions (\xAB except* \xBB) n\xE9cessite Python 3.11 ou version ult\xE9rieure",
        exceptionGroupTypeIncorrect: "Le type d\u2019exception dans except* ne peut pas d\xE9river de BaseGroupException",
        exceptionTypeIncorrect: '"{type}" ne d\xE9rive pas de BaseException',
        exceptionTypeNotClass: "\xAB\xA0{type}\xA0\xBB n\u2019est pas une classe d\u2019exception valide",
        exceptionTypeNotInstantiable: "Le constructeur pour le type d\u2019exception \xAB\xA0{type}\xA0\xBB requiert un ou plusieurs arguments",
        expectedAfterDecorator: "Fonction attendue ou d\xE9claration de classe apr\xE8s le d\xE9corateur",
        expectedArrow: "\xAB\xA0->\xA0\xBB attendu suivi d\u2019une annotation de type de retour",
        expectedAsAfterException: "\xAB\xA0as\xA0\xBB attendu apr\xE8s le type d\u2019exception",
        expectedAssignRightHandExpr: "Expression attendue \xE0 droite de \xAB = \xBB",
        expectedBinaryRightHandExpr: "Expression attendue \xE0 droite de l\u2019op\xE9rateur",
        expectedBoolLiteral: "Attendu True ou False",
        expectedCase: "Instruction \xAB\xA0case\xA0\xBB attendue",
        expectedClassName: "Nom de classe attendu",
        expectedCloseBrace: "\xAB\xA0{\xA0\xBB n\u2019a pas \xE9t\xE9 ferm\xE9",
        expectedCloseBracket: "\xAB [\xA0\xBB n\u2019a pas \xE9t\xE9 ferm\xE9",
        expectedCloseParen: "\xAB\xA0(\xA0\xBB n\u2019a pas \xE9t\xE9 ferm\xE9",
        expectedColon: "\xAB : \xBB attendu",
        expectedComplexNumberLiteral: "Litt\xE9ral de nombre complexe attendu pour la correspondance de mod\xE8le",
        expectedDecoratorExpr: "Formulaire d\u2019expression non pris en charge pour l\u2019\xE9l\xE9ment d\xE9coratif ant\xE9rieur \xE0 Python 3.9",
        expectedDecoratorName: "Nom de l\u2019\xE9l\xE9ment d\xE9coratif attendu",
        expectedDecoratorNewline: "Nouvelle ligne attendue \xE0 la fin de l\u2019\xE9l\xE9ment d\xE9coratif",
        expectedDelExpr: "Expression attendue apr\xE8s \xAB del \xBB",
        expectedElse: "\xAB else \xBB attendu",
        expectedEquals: "\xAB\xA0=\xA0\xBB attendu",
        expectedExceptionClass: "Classe ou objet d'exception non valide",
        expectedExceptionObj: "Objet d\u2019exception attendu, classe d\u2019exception ou None",
        expectedExpr: "Expression attendue",
        expectedFunctionAfterAsync: 'D\xE9finition de fonction attendue apr\xE8s "async"',
        expectedFunctionName: "Nom de fonction attendu apr\xE8s \xAB\xA0def\xA0\xBB",
        expectedIdentifier: "Identifiant attendu",
        expectedImport: "\xAB importation \xBB attendue",
        expectedImportAlias: "Symbole attendu apr\xE8s \xAB as \xBB",
        expectedImportSymbols: "Un ou plusieurs noms de symboles attendus apr\xE8s \xAB\xA0l\u2019importation\xA0\xBB",
        expectedIn: "\xAB in \xBB attendu",
        expectedInExpr: "Expression attendue apr\xE8s \xAB in \xBB",
        expectedIndentedBlock: "Bloc en retrait attendu",
        expectedMemberName: "Nom d\u2019attribut attendu apr\xE8s \xAB\xA0.\xA0\xBB",
        expectedModuleName: "Nom de module attendu",
        expectedNameAfterAs: 'Nom de symbole attendu apr\xE8s "as"',
        expectedNamedParameter: "Le param\xE8tre de mot cl\xE9 doit suivre \xAB * \xBB",
        expectedNewline: "Nouvelle ligne attendue",
        expectedNewlineOrSemicolon: "Les instructions doivent \xEAtre s\xE9par\xE9es par des nouvelles lignes ou des points-virgules",
        expectedOpenParen: 'Attendu "("',
        expectedParamName: "Nom du param\xE8tre attendu",
        expectedPatternExpr: "Expression de mod\xE8le attendue",
        expectedPatternSubjectExpr: "Expression du sujet du mod\xE8le attendu",
        expectedPatternValue: "Expression de valeur de mod\xE8le attendue sous la forme \xAB\xA0a.b\xA0\xBB",
        expectedReturnExpr: "Expression attendue apr\xE8s \xAB return \xBB",
        expectedSliceIndex: "Expression d'index ou de tranche attendue",
        expectedTypeNotString: "Type attendu mais r\xE9ception d\u2019un litt\xE9ral de cha\xEEne",
        expectedTypeParameterName: "Nom de param\xE8tre de type attendu",
        expectedYieldExpr: "Expression attendue dans l'instruction yield",
        finalClassIsAbstract: "La classe \xAB\xA0{type}\xA0\xBB est marqu\xE9e comme finale et doit impl\xE9menter toutes les symboles abstraits",
        finalContext: "\xAB Final \xBB n\u2019est pas autoris\xE9 dans ce contexte",
        finalInLoop: "Impossible d\u2019assigner une variable \xAB\xA0Final\xA0\xBB dans une boucle",
        finalMethodOverride: "La m\xE9thode \xAB\xA0{name}\xA0\xBB ne peut pas remplacer la m\xE9thode finale d\xE9finie dans la classe \xAB\xA0{className}\xA0\xBB",
        finalNonMethod: "La fonction \xAB\xA0{name}\xA0\xBB ne peut pas \xEAtre marqu\xE9e @final, car il ne s\u2019agit pas d\u2019une m\xE9thode",
        finalReassigned: "\xAB\xA0{name}\xA0\xBB est d\xE9clar\xE9 Final et ne peut pas \xEAtre r\xE9affect\xE9",
        finalRedeclaration: "\xAB\xA0{name}\xA0\xBB a \xE9t\xE9 d\xE9clar\xE9 comme Final",
        finalRedeclarationBySubclass: "\xAB\xA0{name}\xA0\xBB ne peut pas \xEAtre red\xE9clar\xE9, car la classe parente \xAB\xA0{className}\xA0\xBB la d\xE9clare Final",
        finalTooManyArgs: "Argument de type unique attendu apr\xE8s \xAB Final \xBB",
        finalUnassigned: "\xAB\xA0{name}\xA0\xBB est d\xE9clar\xE9 Final, mais la valeur n\u2019est pas affect\xE9e",
        finallyBreak: "Vous ne pouvez pas utiliser \xAB\xA0break\xA0\xBB pour quitter un bloc \xAB\xA0finally\xA0\xBB",
        finallyContinue: "Vous ne pouvez pas utiliser \xAB\xA0continue\xA0\xBB pour quitter un bloc \xAB\xA0finally\xA0\xBB",
        finallyReturn: "Vous ne pouvez pas utiliser \xAB\xA0return\xA0\xBB pour quitter un bloc \xAB\xA0finally\xA0\xBB",
        formatStringBrace: "Accolade fermante unique non autoris\xE9e dans le litt\xE9ral f-string\xA0; utiliser une double accolade ferm\xE9e",
        formatStringBytes: "Les litt\xE9raux de cha\xEEne de format (cha\xEEnes f) ne peuvent pas \xEAtre binaires",
        formatStringDebuggingIllegal: 'Le sp\xE9cificateur de d\xE9bogage de cha\xEEne F "=" n\xE9cessite Python 3.8 ou une version plus r\xE9cente',
        formatStringEscape: "S\xE9quence d'\xE9chappement (barre oblique inverse) non autoris\xE9e dans la partie expression de la cha\xEEne f avant Python 3.12",
        formatStringExpectedConversion: "Sp\xE9cificateur de conversion attendu apr\xE8s \xAB ! \xBB dans f-string",
        formatStringIllegal: "Les litt\xE9raux de cha\xEEne de format (cha\xEEnes f) n\xE9cessitent Python 3.6 ou une version plus r\xE9cente",
        formatStringInPattern: "Cha\xEEne de format non autoris\xE9e dans le mod\xE8le",
        formatStringNestedFormatSpecifier: "Expressions imbriqu\xE9s trop profond\xE9ment dans le sp\xE9cificateur de cha\xEEne de format",
        formatStringNestedQuote: "Les cha\xEEnes imbriqu\xE9es dans une cha\xEEne f ne peuvent pas utiliser le m\xEAme guillemet que la cha\xEEne f avant Python 3.12",
        formatStringTemplate: "Format string literals (f-strings) cannot also be template strings (t-strings)",
        formatStringUnicode: "Les litt\xE9raux de cha\xEEne de format (f-strings) ne peuvent pas \xEAtre unicode",
        formatStringUnterminated: 'Expression non termin\xE9e dans f-string\xA0; attendant "}"',
        functionDecoratorTypeUnknown: "Le d\xE9corateur de fonction non typ\xE9 masque le type de fonction ; \xE9l\xE9ment d\xE9coratif ignor\xE9",
        functionInConditionalExpression: "L\u2019expression conditionnelle fait r\xE9f\xE9rence \xE0 une fonction qui prend toujours la valeur True",
        functionTypeParametersIllegal: "La syntaxe des param\xE8tres de type de fonction n\xE9cessite Python 3.12 ou une version plus r\xE9cente",
        futureImportLocationNotAllowed: "Les importations \xE0 partir de __future__ doivent se trouver au d\xE9but du fichier",
        generatorAsyncReturnType: "Le type de retour de la fonction de g\xE9n\xE9rateur asynchrone doit \xEAtre compatible avec \xAB AsyncGenerator[{yieldType}, Any] \xBB",
        generatorNotParenthesized: "Les expressions de g\xE9n\xE9rateur doivent \xEAtre entre parenth\xE8ses si elles ne sont pas uniquement des arguments",
        generatorSyncReturnType: "Le type de retour de la fonction de g\xE9n\xE9rateur doit \xEAtre compatible avec \xAB Generator[{yieldType}, Any, Any] \xBB",
        genericBaseClassNotAllowed: "La classe de base \xAB\xA0Generic\xA0\xBB ne peut pas \xEAtre utilis\xE9e avec la syntaxe de param\xE8tre de type",
        genericClassAssigned: "Impossible d\u2019attribuer le type de classe g\xE9n\xE9rique",
        genericClassDeleted: "Le type de classe g\xE9n\xE9rique ne peut pas \xEAtre supprim\xE9",
        genericInstanceVariableAccess: "L\u2019acc\xE8s \xE0 une variable d\u2019instance g\xE9n\xE9rique via une classe est ambigu",
        genericNotAllowed: "\xAB\xA0Generic\xA0\xBB n\u2019est pas valide dans ce contexte",
        genericTypeAliasBoundTypeVar: "L\u2019alias de type g\xE9n\xE9rique dans la classe ne peut pas utiliser les variables de type li\xE9 {names}",
        genericTypeArgMissing: "\xAB\xA0Generic\xA0\xBB n\xE9cessite au moins un argument de type",
        genericTypeArgTypeVar: "L\u2019argument de type pour \xAB Generic \xBB doit \xEAtre une variable de type",
        genericTypeArgUnique: "Les arguments de type pour \xAB\xA0Generic\xA0\xBB doivent \xEAtre uniques",
        globalReassignment: "\xAB\xA0{name}\xA0\xBB est attribu\xE9 avant la d\xE9claration globale",
        globalRedefinition: "\xAB {name} \xBB a d\xE9j\xE0 \xE9t\xE9 d\xE9clar\xE9 global",
        implicitStringConcat: "Concat\xE9nation implicite de cha\xEEnes non autoris\xE9e",
        importCycleDetected: "Cycle d\xE9tect\xE9 dans la cha\xEEne d'importation",
        importDepthExceeded: "La profondeur de la cha\xEEne d'importation a d\xE9pass\xE9 {depth}",
        importResolveFailure: "Impossible de r\xE9soudre l\u2019importation \xAB\xA0{importName}\xA0\xBB",
        importSourceResolveFailure: "Impossible de r\xE9soudre l\u2019importation \xAB\xA0{importName}\xA0\xBB \xE0 partir de la source",
        importSymbolUnknown: "\xAB\xA0{name}\xA0\xBB est un symbole d\u2019importation inconnu",
        incompatibleMethodOverride: "La m\xE9thode \xAB\xA0{name}\xA0\xBB remplace la classe \xAB\xA0{className}\xA0\xBB de mani\xE8re incompatible",
        inconsistentIndent: "Le montant du retrait ne correspond pas au retrait pr\xE9c\xE9dent",
        inconsistentTabs: "Utilisation incoh\xE9rente des onglets et des espaces dans la mise en retrait",
        initMethodSelfParamTypeVar: "L\u2019annotation de type pour le param\xE8tre \xAB self \xBB de la m\xE9thode \xAB __init__ \xBB ne peut pas contenir de variables de type de port\xE9e de classe",
        initMustReturnNone: "Le type de retour de \xAB __init__ \xBB doit \xEAtre None",
        initSubclassCallFailed: "Arguments de mot cl\xE9 incorrects pour la m\xE9thode __init_subclass__",
        initSubclassClsParam: "__init_subclass__ remplacement doit prendre un param\xE8tre \xAB cls \xBB",
        initVarNotAllowed: "\xAB\xA0InitVar\xA0\xBB n\u2019est pas autoris\xE9 dans ce contexte",
        instanceMethodSelfParam: "Les m\xE9thodes d\u2019instance doivent prendre un param\xE8tre \xAB\xA0self\xA0\xBB",
        instanceVarOverridesClassVar: `La variable d'instance "{name}" remplace la variable de classe du m\xEAme nom dans la classe "{className}"`,
        instantiateAbstract: `Impossible d'instancier la classe abstraite "{type}"`,
        instantiateProtocol: 'Impossible d\u2019instancier la classe de Protocol "{type}"',
        internalBindError: "Une erreur interne s\u2019est produite lors de la liaison du fichier \xAB\xA0{file}\xA0\xBB : {message}",
        internalParseError: "Une erreur interne s\u2019est produite lors de l\u2019analyse du fichier \xAB\xA0{file}\xA0\xBB : {message}",
        internalTypeCheckingError: "Une erreur interne s\u2019est produite lors de la v\xE9rification de type du fichier \xAB\xA0{file}\xA0\xBB : {message}",
        invalidIdentifierChar: "Caract\xE8re invalide dans l'identifiant",
        invalidStubStatement: "L\u2019instruction n\u2019a aucun sens dans un fichier stub de type",
        invalidTokenChars: 'Caract\xE8re non valide "{text}" dans le jeton',
        isInstanceInvalidType: 'Le deuxi\xE8me argument de "isinstance" doit \xEAtre une classe ou un tuple de classes',
        isSubclassInvalidType: "Le deuxi\xE8me argument de \xAB issubclass \xBB doit \xEAtre une classe ou un tuple de classes",
        keyValueInSet: "Les paires cl\xE9/valeur ne sont pas autoris\xE9es dans un set",
        keywordArgInTypeArgument: "Les arguments de mot-cl\xE9 ne peuvent pas \xEAtre utilis\xE9s dans les listes d'arguments de type",
        keywordOnlyAfterArgs: "S\xE9parateur d\u2019arguments mot cl\xE9 uniquement non autoris\xE9 apr\xE8s le param\xE8tre \xAB * \xBB",
        keywordParameterMissing: 'Un ou plusieurs param\xE8tres de mot-cl\xE9 doivent suivre le param\xE8tre "*"',
        keywordSubscriptIllegal: "Les arguments de mot-cl\xE9 dans les indices ne sont pas pris en charge",
        lambdaReturnTypePartiallyUnknown: "Le type de retour de lambda, \xAB\xA0{returnType}\xA0\xBB, est partiellement inconnu",
        lambdaReturnTypeUnknown: "Le type de retour de lambda est inconnu",
        listAssignmentMismatch: "Impossible d\u2019affecter l\u2019expression de type \xAB\xA0{type}\xA0\xBB \xE0 la liste cible",
        listInAnnotation: "Expression de List non autoris\xE9e dans l\u2019expression de type",
        literalEmptyArgs: 'Attendu un ou plusieurs arguments de type apr\xE8s "Literal"',
        literalNamedUnicodeEscape: "Les s\xE9quences d\u2019\xE9chappement Unicode nomm\xE9es ne sont pas prises en charge dans les annotations de cha\xEEne \xAB\xA0Literal\xA0\xBB",
        literalNotAllowed: "\xAB\xA0Literal\xA0\xBB ne peut pas \xEAtre utilis\xE9 dans ce contexte sans argument de type",
        literalNotCallable: "Impossible d\u2019instancier le type Literal",
        literalUnsupportedType: "Les arguments de type pour \xAB\xA0Literal\xA0\xBB doivent \xEAtre None, une valeur litt\xE9rale (int, bool, str ou bytes) ou une valeur enum",
        matchIncompatible: "Les instructions de Match n\xE9cessitent Python 3.10 ou version ult\xE9rieure",
        matchIsNotExhaustive: "Les cas dans l\u2019instruction match ne g\xE8rent pas toutes les valeurs de mani\xE8re exhaustive",
        maxParseDepthExceeded: "Profondeur d\u2019analyse maximale d\xE9pass\xE9e ; scinder l\u2019expression en sous-expressions plus petites",
        memberAccess: "D\xE9sol\xE9... Nous ne pouvons pas acc\xE9der \xE0 l\u2019attribut \xAB\xA0{name}\xA0\xBB pour la classe \xAB\xA0{type}\xA0\xBB",
        memberDelete: "D\xE9sol\xE9... Nous ne pouvons pas supprimer l\u2019attribut \xAB\xA0{name}\xA0\xBB pour la classe \xAB\xA0{type}\xA0\xBB",
        memberSet: "D\xE9sol\xE9... Nous ne pouvons pas affecter l\u2019attribut \xAB\xA0{name}\xA0\xBB pour la classe \xAB\xA0{type}\xA0\xBB",
        metaclassConflict: "La m\xE9taclasse d\u2019une classe d\xE9riv\xE9e doit \xEAtre une sous-classe des m\xE9taclasses de toutes ses classes de base",
        metaclassDuplicate: "Une seule m\xE9taclasse peut \xEAtre fournie",
        metaclassIsGeneric: "La m\xE9taclasse ne peut pas \xEAtre g\xE9n\xE9rique",
        methodNotDefined: "M\xE9thode \xAB\xA0{name}\xA0\xBB non d\xE9finie",
        methodNotDefinedOnType: "M\xE9thode \xAB\xA0{name}\xA0\xBB non d\xE9finie sur le type \xAB\xA0{type}\xA0\xBB",
        methodOrdering: "Impossible de cr\xE9er un classement de m\xE9thode coh\xE9rent",
        methodOverridden: '"{name}" remplace la m\xE9thode du m\xEAme nom dans la classe "{className}" avec un type incompatible "{type}"',
        methodReturnsNonObject: "La m\xE9thode \xAB\xA0{name}\xA0\xBB ne retourne pas d\u2019objet",
        missingSuperCall: "La m\xE9thode \xAB\xA0{methodName}\xA0\xBB n\u2019appelle pas la m\xE9thode du m\xEAme nom dans la classe parente",
        mixingBytesAndStr: "Les valeurs Bytes et str ne peuvent pas \xEAtre concat\xE9n\xE9es",
        moduleAsType: "Le module ne peut pas \xEAtre utilis\xE9 comme type",
        moduleNotCallable: "Le module ne peut pas \xEAtre appel\xE9",
        moduleUnknownMember: "\xAB\xA0{memberName}\xA0\xBB n\u2019est pas un attribut connu du module \xAB\xA0{moduleName}\xA0\xBB",
        namedExceptAfterCatchAll: "Une clause except nomm\xE9e ne peut pas appara\xEEtre apr\xE8s une clause except fourre-tout",
        namedParamAfterParamSpecArgs: "Le param\xE8tre de mot cl\xE9 \xAB\xA0{name}\xA0\xBB ne peut pas appara\xEEtre dans la signature apr\xE8s le param\xE8tre ParamSpec args",
        namedTupleEmptyName: "Les noms dans un tuple nomm\xE9 ne peuvent pas \xEAtre vides",
        namedTupleEntryRedeclared: "Impossible de remplacer \xAB\xA0{name}\xA0\xBB, car la classe parente \xAB\xA0{className}\xA0\xBB est un tuple nomm\xE9",
        namedTupleFieldUnderscore: "Les noms de champs Named tuple ne peuvent pas commencer par un trait de soulignement",
        namedTupleFirstArg: "Nom de classe de tuple nomm\xE9 attendu en tant que premier argument",
        namedTupleMultipleInheritance: "L\u2019h\xE9ritage multiple avec NamedTuple n\u2019est pas pris en charge",
        namedTupleNameKeyword: "Les noms de champs ne peuvent pas \xEAtre un mot-cl\xE9",
        namedTupleNameType: "Expected two-entry tuple specifying entry name and type",
        namedTupleNameUnique: "Les noms dans un tuple nomm\xE9 doivent \xEAtre uniques",
        namedTupleNoTypes: "\xAB namedtuple \xBB ne fournit aucun type pour les entr\xE9es de tuple ; utilisez \xAB NamedTuple \xBB \xE0 la place",
        namedTupleSecondArg: "Expected named tuple entry list as second argument",
        newClsParam: "__new__ remplacement doit prendre un param\xE8tre \xAB cls \xBB",
        newTypeAnyOrUnknown: "Le deuxi\xE8me argument de NewType doit \xEAtre une classe connue, et non Any ou Unknown",
        newTypeBadName: "Le premier argument de NewType doit \xEAtre un litt\xE9ral de cha\xEEne",
        newTypeLiteral: "Impossible d\u2019utiliser NewType avec le type Literal",
        newTypeNameMismatch: "NewType doit \xEAtre affect\xE9 \xE0 une variable portant le m\xEAme nom",
        newTypeNotAClass: "Classe attendue comme deuxi\xE8me argument de NewType",
        newTypeParamCount: "NewType requiert deux arguments positionnels",
        newTypeProtocolClass: "D\xE9sol\xE9, nous n\u2019avons pas pu utiliser NewType avec un type structurelle (un Protocol ou une classe TypedDict)",
        noOverload: "Aucune surcharge pour \xAB {name} \xBB ne correspond aux arguments fournis",
        noReturnContainsReturn: "La fonction avec le type de return d\xE9clar\xE9 \xAB\xA0NoReturn\xA0\xBB ne peut pas inclure d\u2019instruction de return",
        noReturnContainsYield: "La fonction avec le type de retour d\xE9clar\xE9 \xAB\xA0NoReturn\xA0\xBB ne peut pas inclure d\u2019instruction yield",
        noReturnReturnsNone: 'La fonction avec le type de retour d\xE9clar\xE9 "NoReturn" ne peut pas renvoyer "None"',
        nonDefaultAfterDefault: "L\u2019argument autre que l\u2019argument par d\xE9faut suit l\u2019argument par d\xE9faut",
        nonLocalInModule: "D\xE9claration nonlocal non autoris\xE9e au niveau du module",
        nonLocalNoBinding: "Aucune liaison pour le \xAB\xA0{name}\xA0\xBB nonlocal trouv\xE9",
        nonLocalReassignment: "\xAB\xA0{name}\xA0\xBB est attribu\xE9 avant la d\xE9claration nonlocal",
        nonLocalRedefinition: "\xAB\xA0{name}\xA0\xBB a d\xE9j\xE0 \xE9t\xE9 d\xE9clar\xE9 nonlocal",
        noneNotCallable: "L\u2019objet de type \xAB\xA0None\xA0\xBB ne peut pas \xEAtre appel\xE9",
        noneNotIterable: "L\u2019objet de type \xAB\xA0None\xA0\xBB ne peut pas \xEAtre utilis\xE9 en tant que valeur it\xE9rable",
        noneNotSubscriptable: "L\u2019objet de type \xAB\xA0None\xA0\xBB n\u2019est pas inscriptible",
        noneNotUsableWith: 'Object of type "None" cannot be used with "with"',
        noneNotUsableWithAsync: "L\u2019objet de type \xAB\xA0None\xA0\xBB ne peut pas \xEAtre utilis\xE9 avec \xAB\xA0async with\xA0\xBB",
        noneOperator: "L\u2019op\xE9rateur \xAB\xA0{operator}\xA0\xBB n\u2019est pas pris en charge pour \xAB\xA0None\xA0\xBB",
        noneUnknownMember: "\xAB\xA0{name}\xA0\xBB n\u2019est pas un attribut connu de \xAB\xA0None\xA0\xBB",
        nonlocalTypeParam: 'La liaison nonlocale n\u2019est pas autoris\xE9e pour le param\xE8tre de type "{name}"',
        notRequiredArgCount: "Argument de type unique attendu apr\xE8s \xAB NotRequired \xBB",
        notRequiredNotInTypedDict: "\xAB NotRequired \xBB n\u2019est pas autoris\xE9 dans ce contexte",
        objectNotCallable: "L\u2019objet de type \xAB\xA0{type}\xA0\xBB n\u2019est pas appelant",
        obscuredClassDeclaration: "La d\xE9claration de classe \xAB\xA0{name}\xA0\xBB est masqu\xE9e par une d\xE9claration du m\xEAme nom",
        obscuredFunctionDeclaration: "La d\xE9claration de fonction \xAB\xA0{name}\xA0\xBB est masqu\xE9e par une d\xE9claration du m\xEAme nom",
        obscuredMethodDeclaration: "La d\xE9claration de m\xE9thode \xAB\xA0{name}\xA0\xBB est masqu\xE9e par une d\xE9claration du m\xEAme nom",
        obscuredParameterDeclaration: "La d\xE9claration de param\xE8tre \xAB\xA0{name}\xA0\xBB est masqu\xE9e par une d\xE9claration du m\xEAme nom",
        obscuredTypeAliasDeclaration: "La d\xE9claration d\u2019alias de type \xAB\xA0{name}\xA0\xBB est masqu\xE9e par une d\xE9claration du m\xEAme nom",
        obscuredVariableDeclaration: "La d\xE9claration \xAB\xA0{name}\xA0\xBB est masqu\xE9e par une d\xE9claration du m\xEAme nom",
        operatorLessOrGreaterDeprecated: "L\u2019op\xE9rateur \xAB <> \xBB n\u2019est pas pris en charge dans Python 3 ; utilisez \xAB\xA0!=\xA0\xBB \xE0 la place",
        optionalExtraArgs: "Attendu un argument de type apr\xE8s \xAB\xA0Optional\xA0\xBB",
        orPatternIrrefutable: 'Mod\xE8le irr\xE9futable autoris\xE9 uniquement en tant que dernier sous-mod\xE8le dans un mod\xE8le "ou"',
        orPatternMissingName: "Tous les sous-mod\xE8les d\u2019un mod\xE8le \xAB\xA0or\xA0\xBB doivent cibler les m\xEAmes noms",
        overlappingKeywordArgs: "Le dictionnaire tap\xE9 chevauche avec le mot cl\xE9 param\xE8tre\xA0: {names}",
        overlappingOverload: "La surcharge {obscured} pour \xAB\xA0{name}\xA0\xBB ne sera jamais utilis\xE9e, car ses param\xE8tres chevauchent la surcharge {obscuredBy}",
        overloadAbstractImplMismatch: "Les surcharges doivent correspondre \xE0 l\u2019\xE9tat abstrait de l\u2019impl\xE9mentation",
        overloadAbstractMismatch: "Les surcharges doivent toutes \xEAtre abstraites ou non",
        overloadClassMethodInconsistent: "Les surcharges pour \xAB {name} \xBB utilisent @classmethod de mani\xE8re incoh\xE9rente",
        overloadFinalImpl: "@final decorator ne doit \xEAtre appliqu\xE9 qu\u2019\xE0 l\u2019impl\xE9mentation",
        overloadFinalNoImpl: "Seule la premi\xE8re surcharge doit \xEAtre marqu\xE9e @final",
        overloadImplementationMismatch: "L\u2019impl\xE9mentation surcharg\xE9e n\u2019est pas coh\xE9rente avec la signature de la surcharge {index}",
        overloadOverrideImpl: "@override decorator ne doit \xEAtre appliqu\xE9 qu\u2019\xE0 l\u2019impl\xE9mentation",
        overloadOverrideNoImpl: "Seule la premi\xE8re surcharge doit \xEAtre marqu\xE9e @override",
        overloadReturnTypeMismatch: "La surcharge {prevIndex} pour \xAB\xA0{name}\xA0\xBB chevauche la surcharge {newIndex} et retourne un type incompatible",
        overloadStaticMethodInconsistent: "Les surcharges pour \xAB {name} \xBB utilisent @staticmethod de mani\xE8re incoh\xE9rente",
        overloadWithoutImplementation: "\xAB\xA0{name}\xA0\xBB est marqu\xE9 comme overload, mais aucune impl\xE9mentation n\u2019est fournie",
        overriddenMethodNotFound: "La m\xE9thode \xAB\xA0{name}\xA0\xBB est marqu\xE9e comme override, mais aucune m\xE9thode de base du m\xEAme nom n\u2019est pr\xE9sente",
        overrideDecoratorMissing: `La m\xE9thode "{name}" n'est pas marqu\xE9e comme override mais remplace une m\xE9thode dans la classe "{className}"`,
        paramAfterKwargsParam: 'Le param\xE8tre ne peut pas suivre le param\xE8tre "**"',
        paramAlreadyAssigned: "Le param\xE8tre \xAB\xA0{name}\xA0\xBB est d\xE9j\xE0 affect\xE9",
        paramAnnotationMissing: `L'annotation de type est manquante pour le param\xE8tre "{name}"`,
        paramAssignmentMismatch: `L'expression de type "{sourceType}" ne peut pas \xEAtre affect\xE9e au param\xE8tre de type "{paramType}"`,
        paramNameMissing: "Aucun param\xE8tre nomm\xE9 \xAB {name} \xBB",
        paramSpecArgsKwargsDuplicate: "Des arguments pour ParamSpec \xAB\xA0{type}\xA0\xBB ont d\xE9j\xE0 \xE9t\xE9 fournis",
        paramSpecArgsKwargsUsage: "Les attributs \xAB\xA0args\xA0\xBB et \xAB\xA0kwargs\xA0\xBB de ParamSpec doivent appara\xEEtre tous les deux dans une signature de fonction",
        paramSpecArgsMissing: "Les arguments pour ParamSpec \xAB\xA0{type}\xA0\xBB sont manquants",
        paramSpecArgsUsage: "L\u2019attribut \xAB\xA0args\xA0\xBB de ParamSpec n\u2019est valide que lorsqu\u2019il est utilis\xE9 avec le param\xE8tre *args",
        paramSpecAssignedName: "ParamSpec doit \xEAtre affect\xE9 \xE0 une variable nomm\xE9e \xAB {name} \xBB",
        paramSpecContext: "ParamSpec n\u2019est pas autoris\xE9 dans ce contexte",
        paramSpecDefaultNotTuple: "Points de suspension attendus, expression de tuple ou ParamSpec pour la valeur par d\xE9faut de ParamSpec",
        paramSpecFirstArg: "Nom attendu de ParamSpec comme premier argument",
        paramSpecKwargsUsage: "L\u2019attribut \xAB\xA0kwargs\xA0\xBB de ParamSpec n\u2019est valide que lorsqu\u2019il est utilis\xE9 avec le param\xE8tre **kwargs",
        paramSpecNotUsedByOuterScope: "ParamSpec \xAB\xA0{name}\xA0\xBB n\u2019a aucune signification dans ce contexte",
        paramSpecUnknownArg: "ParamSpec ne prend pas en charge plus d'un argument",
        paramSpecUnknownMember: "\xAB\xA0{name}\xA0\xBB n\u2019est pas un attribut connu de ParamSpec",
        paramSpecUnknownParam: '"{name}" est un param\xE8tre inconnu pour ParamSpec',
        paramTypeCovariant: "Impossible d\u2019utiliser la variable de type Covariant dans le type de param\xE8tre",
        paramTypePartiallyUnknown: "Le type du param\xE8tre \xAB\xA0{paramName}\xA0\xBB est partiellement inconnu",
        paramTypeUnknown: "Le type de param\xE8tre \xAB\xA0{paramName}\xA0\xBB est inconnu",
        parenthesizedContextManagerIllegal: 'Parentheses within "with" statement requires Python 3.9 or newer',
        patternNeverMatches: "Le mod\xE8le ne sera jamais mis en correspondance pour le type d\u2019objet \xAB\xA0{type}\xA0\xBB",
        positionArgAfterNamedArg: "L\u2019argument positionnel ne peut pas appara\xEEtre apr\xE8s les arguments de mot cl\xE9",
        positionArgAfterUnpackedDictArg: "L\u2019argument positionnel ne peut pas appara\xEEtre apr\xE8s la d\xE9compression d\u2019argument de mot cl\xE9",
        positionOnlyAfterArgs: "S\xE9parateur de param\xE8tres de position seule non autoris\xE9 apr\xE8s le param\xE8tre \xAB * \xBB",
        positionOnlyAfterKeywordOnly: "Le param\xE8tre \xAB / \xBB doit appara\xEEtre avant le param\xE8tre \xAB * \xBB",
        positionOnlyAfterNon: "Param\xE8tre de position seule non autoris\xE9 apr\xE8s un param\xE8tre qui n\u2019est pas en position seule",
        positionOnlyFirstParam: "S\xE9parateur de param\xE8tres de position seule non autoris\xE9 en tant que premier param\xE8tre",
        positionOnlyIncompatible: "Le s\xE9parateur de param\xE8tres de position seule requiert Python 3.8 ou version ult\xE9rieure",
        privateImportFromPyTypedModule: "\xAB\xA0{name}\xA0\xBB n\u2019est pas export\xE9 \xE0 partir du module \xAB\xA0{module}\xA0\xBB",
        privateUsedOutsideOfClass: "\xAB\xA0{name}\xA0\xBB est priv\xE9 et utilis\xE9 en dehors de la classe dans laquelle il est d\xE9clar\xE9",
        privateUsedOutsideOfModule: "\xAB {name} \xBB est priv\xE9 et utilis\xE9 en dehors du module dans lequel il est d\xE9clar\xE9",
        propertyOverridden: "\xAB\xA0{name}\xA0\xBB remplace \xE0 tort la property du m\xEAme nom dans la classe \xAB\xA0{className}\xA0\xBB",
        propertyStaticMethod: "M\xE9thodes statiques non autoris\xE9es pour la property getter, setter ou deleter",
        protectedUsedOutsideOfClass: '"{name}" est prot\xE9g\xE9 et utilis\xE9 en dehors de la classe dans laquelle il est d\xE9clar\xE9',
        protocolBaseClass: 'La classe de Protocol "{classType}" ne peut pas d\xE9river de la classe non Protocol "{baseType}"',
        protocolBaseClassWithTypeArgs: "Les arguments de type ne sont pas autoris\xE9s avec la classe Protocol lors de l'utilisation de la syntaxe des param\xE8tres de type",
        protocolIllegal: "L\u2019utilisation de \xAB Protocole \xBB n\xE9cessite Python 3.7 ou une version plus r\xE9cente",
        protocolNotAllowed: '"Protocole" ne peut pas \xEAtre utilis\xE9 dans ce contexte',
        protocolTypeArgMustBeTypeParam: "L\u2019argument de type pour \xAB\xA0Protocol\xA0\xBB doit \xEAtre un param\xE8tre de type",
        protocolUnsafeOverlap: "La classe chevauche \xAB\xA0{name}\xA0\xBB de mani\xE8re non s\xE9curis\xE9e et peut produire une correspondance au moment de l\u2019ex\xE9cution",
        protocolVarianceContravariant: 'La variable de type "{variable}" utilis\xE9e dans le Protocol g\xE9n\xE9rique "{class}" doit \xEAtre contravariante',
        protocolVarianceCovariant: 'La variable de type "{variable}" utilis\xE9e dans le Protocol g\xE9n\xE9rique "{class}" doit \xEAtre covariante',
        protocolVarianceInvariant: 'La variable de type "{variable}" utilis\xE9e dans le Protocol g\xE9n\xE9rique "{class}" doit \xEAtre invariante',
        pyrightCommentInvalidDiagnosticBoolValue: "La directive de commentaire Pyright doit \xEAtre suivie de \xAB\xA0=\xA0\xBB et d\u2019une valeur true ou false",
        pyrightCommentInvalidDiagnosticSeverityValue: "La directive de commentaire Pyright doit \xEAtre suivie de \xAB\xA0=\xA0\xBB et avoir la valeur true, false, error, warning, information ou none",
        pyrightCommentMissingDirective: "Le commentaire Pyright doit \xEAtre suivi d\u2019une directive (basic ou strict) ou d\u2019une r\xE8gle de diagnostic",
        pyrightCommentNotOnOwnLine: "Les commentaires Pyright utilis\xE9s pour contr\xF4ler les param\xE8tres au niveau du fichier doivent appara\xEEtre sur leur propre ligne",
        pyrightCommentUnknownDiagnosticRule: "\xAB\xA0{rule}\xA0\xBB est une r\xE8gle de diagnostic inconnue pour le commentaire pyright",
        pyrightCommentUnknownDiagnosticSeverityValue: "\xAB\xA0{value}\xA0\xBB n\u2019est pas valide pour le commentaire pyright ; true, false, error, warning, information ou none attendu",
        pyrightCommentUnknownDirective: '"{directive}" is an unknown directive for pyright comment; expected "strict", "standard", or "basic"',
        readOnlyArgCount: 'Attendu un seul argument de type apr\xE8s "ReadOnly"',
        readOnlyNotInTypedDict: "\xAB ReadOnly \xBB n\u2019est pas autoris\xE9 dans ce contexte",
        recursiveDefinition: `Le type de "{name}" n'a pas pu \xEAtre d\xE9termin\xE9 car il fait r\xE9f\xE9rence \xE0 lui-m\xEAme`,
        relativeImportNotAllowed: "Les importations relatives ne peuvent pas \xEAtre utilis\xE9es avec le formulaire \xAB\xA0import .a\xA0\xBB ; utiliser \xAB\xA0from . import a\xA0\xBB \xE0 la place",
        requiredArgCount: 'Attendu un argument de type unique apr\xE8s "Required"',
        requiredNotInTypedDict: "\xAB\xA0Required\xA0\xBB n\u2019est pas autoris\xE9 dans ce contexte",
        returnInAsyncGenerator: "L'instruction de retour avec valeur n'est pas autoris\xE9e dans le g\xE9n\xE9rateur asynchrone",
        returnInExceptionGroup: "\xAB\xA0return\xA0\xBB n\u2019est pas autoris\xE9 dans un bloc \xAB\xA0except*\xA0\xBB",
        returnMissing: 'La fonction avec le type de retour d\xE9clar\xE9 "{returnType}" doit renvoyer une valeur sur tous les chemins de code',
        returnOutsideFunction: '"return" ne peut \xEAtre utilis\xE9 que dans une fonction',
        returnTypeContravariant: "La variable de type contravariant ne peut pas \xEAtre utilis\xE9e dans le type de retour",
        returnTypeMismatch: "Le type \xAB\xA0{exprType}\xA0\xBB n\u2019est pas assignable au type de retour \xAB\xA0{returnType}\xA0\xBB",
        returnTypePartiallyUnknown: "Le type de retour \xAB {returnType} \xBB est partiellement inconnu",
        returnTypeUnknown: "Le type de retour est inconnu",
        revealLocalsArgs: `Aucun argument attendu pour l'appel "reveal_locals"`,
        revealLocalsNone: "Aucun \xE9l\xE9ment locals dans cette \xE9tendue",
        revealTypeArgs: "Argument positionnel unique attendu pour l\u2019appel \xAB reveal_type \xBB",
        revealTypeExpectedTextArg: `L'argument "expected_text" pour la fonction "reveal_type" doit \xEAtre une valeur litt\xE9rale str`,
        revealTypeExpectedTextMismatch: "Incompatibilit\xE9 de texte de type ; \xAB\xA0{expected}\xA0\xBB attendu, mais a re\xE7u \xAB\xA0{received}\xA0\xBB",
        revealTypeExpectedTypeMismatch: 'Incompatibilit\xE9 de type; attendu "{expected}" mais re\xE7u "{received}"',
        selfTypeContext: "\xAB Self \xBB n\u2019est pas valide dans ce contexte",
        selfTypeMetaclass: "\xAB\xA0Self\xA0\xBB ne peut pas \xEAtre utilis\xE9 dans une m\xE9taclasse (une sous-classe de \xAB\xA0type\xA0\xBB)",
        selfTypeWithTypedSelfOrCls: "\xAB Self \xBB ne peut pas \xEAtre utilis\xE9 dans une fonction avec un param\xE8tre \xAB self \xBB ou \xAB cls \xBB qui a une annotation de type autre que \xAB Self \xBB",
        sentinelBadName: "The first argument to Sentinel must be a string literal",
        sentinelNameMismatch: "Sentinel must be assigned to a variable with the same name",
        sentinelParamCount: "Sentinel requires one positional argument",
        setterGetterTypeMismatch: "Le type valeur setter de property n\u2019est pas assignable au type de retour getter",
        singleOverload: "\xAB {name} \xBB est marqu\xE9 comme surcharge, mais des surcharges suppl\xE9mentaires sont manquantes",
        slotsAttributeError: `"{name}" n'est pas sp\xE9cifi\xE9 dans __slots__`,
        slotsClassVarConflict: `"{name}" est en conflit avec la variable d'instance d\xE9clar\xE9e dans __slots__`,
        starPatternInAsPattern: "Le mod\xE8le d\u2019\xE9toile ne peut pas \xEAtre utilis\xE9 avec la cible \xAB as \xBB",
        starPatternInOrPattern: "Le mod\xE8le d\u2019\xE9toile ne peut pas \xEAtre supprim\xE9 dans d\u2019autres mod\xE8les",
        starStarWildcardNotAllowed: "** ne peut pas \xEAtre utilis\xE9 avec le caract\xE8re g\xE9n\xE9rique \xAB\xA0_\xA0\xBB",
        staticClsSelfParam: "Les m\xE9thodes statiques ne doivent pas prendre de param\xE8tre \xAB self \xBB ou \xAB cls \xBB",
        stringNonAsciiBytes: "Caract\xE8re non-ASCII non autoris\xE9 dans le litt\xE9ral de cha\xEEne d'octets",
        stringNotSubscriptable: "L'expression de cha\xEEne ne peut pas \xEAtre index\xE9e dans une expression de type\xA0; placez l'expression enti\xE8re entre guillemets",
        stringUnsupportedEscape: "S\xE9quence d'\xE9chappement non prise en charge dans le litt\xE9ral de cha\xEEne",
        stringUnterminated: "Le litt\xE9ral de cha\xEEne n\u2019est pas sp\xE9cifi\xE9",
        stubFileMissing: "Fichier stub introuvable pour \xAB {importName} \xBB",
        stubUsesGetAttr: "Le fichier stub de type est incomplet ; \xAB __getattr__ \xBB masque les erreurs de type pour le module",
        sublistParamsIncompatible: "Les param\xE8tres de Sublist ne sont pas pris en charge dans Python 3.x",
        superCallArgCount: `Pas plus de deux arguments attendus pour l'appel "super"`,
        superCallFirstArg: "Type de classe attendu en tant que premier argument de l\u2019appel \xAB super \xBB, mais \xAB {type} \xBB re\xE7u",
        superCallSecondArg: "Le deuxi\xE8me argument de l\u2019appel \xAB super \xBB doit \xEAtre un objet ou une classe d\xE9riv\xE9 de \xAB {type} \xBB",
        superCallZeroArgForm: `La forme sans argument d'appel "super" n'est valide que dans une m\xE9thode`,
        superCallZeroArgFormStaticMethod: "La forme \xE0 z\xE9ro argument de l\u2019appel \xAB\xA0super\xA0\xBB n\u2019est pas valide dans une m\xE9thode statique",
        symbolIsPossiblyUnbound: "\xAB\xA0{name}\xA0\xBB est peut-\xEAtre ind\xE9pendant",
        symbolIsUnbound: "\xAB {name} \xBB est ind\xE9pendant",
        symbolIsUndefined: "\xAB\xA0{name}\xA0\xBB n\u2019est pas d\xE9fini",
        symbolOverridden: "\xAB\xA0{name}\xA0\xBB remplace le symbole du m\xEAme nom dans la classe \xAB\xA0{className}\xA0\xBB",
        templateStringBytes: "Template string literals (t-strings) cannot be binary",
        templateStringIllegal: "Template string literals (t-strings) require Python 3.14 or newer",
        templateStringUnicode: "Template string literals (t-strings) cannot be unicode",
        ternaryNotAllowed: "Expression ternaire non autoris\xE9e dans l'expression de type",
        totalOrderingMissingMethod: "La classe doit d\xE9finir \xAB __lt__ \xBB, \xAB __le__ \xBB, \xAB __gt__ \xBB ou \xAB __ge__ \xBB pour utiliser total_ordering",
        trailingCommaInFromImport: "Virgule de fin non autoris\xE9e sans parenth\xE8ses adjacentes",
        tryWithoutExcept: "L'instruction try doit avoir au moins une clause except ou finally",
        tupleAssignmentMismatch: `L'expression avec le type "{type}" ne peut pas \xEAtre assign\xE9e au tuple cible`,
        tupleInAnnotation: "Expression de tuple non autoris\xE9e dans l'expression de type",
        tupleIndexOutOfRange: "L\u2019index {index} est hors limites pour le type {type}",
        typeAliasIllegalExpressionForm: "Formulaire d\u2019expression non valide pour la d\xE9finition d\u2019alias de type",
        typeAliasIsRecursiveDirect: `L'alias de type "{name}" ne peut pas s'utiliser lui-m\xEAme dans sa d\xE9finition`,
        typeAliasNotInModuleOrClass: "Un TypeAlias ne peut \xEAtre d\xE9fini qu\u2019au sein d\u2019un module ou d\u2019une \xE9tendue de classe",
        typeAliasRedeclared: "\xAB {name} \xBB est d\xE9clar\xE9 en tant que TypeAlias et ne peut \xEAtre attribu\xE9 qu\u2019une seule fois",
        typeAliasStatementBadScope: "Une instruction de type ne peut \xEAtre utilis\xE9e que dans une \xE9tendue de module ou de classe",
        typeAliasStatementIllegal: "L\u2019instruction d\u2019alias de type n\xE9cessite Python 3.12 ou version ult\xE9rieure",
        typeAliasTypeBadScope: "Vous ne pouvez d\xE9finir un alias de type qu\u2019au sein d\u2019un module ou d\u2019une \xE9tendue de classe",
        typeAliasTypeBaseClass: 'A type alias defined in a "type" statement cannot be used as a base class',
        typeAliasTypeMustBeAssigned: "TypeAliasType doit \xEAtre affect\xE9 \xE0 une variable portant le m\xEAme nom que l'alias de type",
        typeAliasTypeNameArg: "Le premier argument de TypeAliasType doit \xEAtre un litt\xE9ral de cha\xEEne repr\xE9sentant le nom de l'alias de type",
        typeAliasTypeNameMismatch: "Le nom de l\u2019alias de type doit correspondre au nom de la variable \xE0 laquelle il est affect\xE9",
        typeAliasTypeParamInvalid: "La liste de param\xE8tres de type doit \xEAtre un tuple contenant uniquement TypeVar, TypeVarTuple ou ParamSpec",
        typeAnnotationCall: "Expression d'appel non autoris\xE9e dans l'expression de type",
        typeAnnotationVariable: "Variable non autoris\xE9e dans l'expression de type",
        typeAnnotationWithCallable: `L'argument de type pour "type" doit \xEAtre une classe\xA0; les callables ne sont pas pris en charge`,
        typeArgListExpected: "ParamSpec, ellipse ou liste de types attendue",
        typeArgListNotAllowed: "Expression de liste non autoris\xE9e pour cet argument de type",
        typeArgsExpectingNone: "Aucun argument de type attendu pour la classe \xAB\xA0{name}\xA0\xBB",
        typeArgsMismatchOne: "Argument de type attendu mais {received} re\xE7u",
        typeArgsMissingForAlias: "Arguments de type attendus pour l\u2019alias de type g\xE9n\xE9rique \xAB\xA0{name}\xA0\xBB",
        typeArgsMissingForClass: 'Arguments de type attendus pour la classe g\xE9n\xE9rique "{name}"',
        typeArgsTooFew: "Trop peu d\u2019arguments de type fournis pour \xAB {name} \xBB ; {expected} attendu, mais {received} re\xE7u",
        typeArgsTooMany: `Trop d'arguments de type fournis pour "{name}"\xA0; attendu {expected} mais re\xE7u {received}`,
        typeAssignmentMismatch: "Le type \xAB\xA0{sourceType}\xA0\xBB n\u2019est pas assignable au type d\xE9clar\xE9 \xAB\xA0{destType}\xA0\xBB",
        typeAssignmentMismatchWildcard: "Le symbole d\u2019importation \xAB\xA0{name}\xA0\xBB a le type \xAB\xA0{sourceType}\xA0\xBB, qui n\u2019est pas assignable au type d\xE9clar\xE9 \xAB\xA0{destType}\xA0\xBB",
        typeCallNotAllowed: "l'appel type() ne doit pas \xEAtre utilis\xE9 dans une expression de type",
        typeCheckOnly: '"{name}" est marqu\xE9 comme @type_check_only et ne peut \xEAtre utilis\xE9 que dans les annotations de type',
        typeCommentDeprecated: "L\u2019utilisation de commentaires de type est d\xE9conseill\xE9e ; utiliser l\u2019annotation de type \xE0 la place",
        typeExpectedClass: "Classe attendue mais \xAB\xA0{type}\xA0\xBB re\xE7u",
        typeFormArgs: "\xAB\xA0TypeForm\xA0\xBB accepte un seul argument positionnel",
        typeGuardArgCount: "Argument de type unique attendu apr\xE8s \xAB\xA0TypeGuard\xA0\xBB ou \xAB\xA0TypeIs\xA0\xBB",
        typeGuardParamCount: "Les m\xE9thodes et fonctions de protection de type d\xE9finies par l\u2019utilisateur doivent avoir au moins un param\xE8tre d\u2019entr\xE9e",
        typeIsReturnType: "Le type de retour des TypeIs (\xAB\xA0{returnType}\xA0\xBB) n\u2019est pas coh\xE9rent avec le type de param\xE8tre de valeur (\xAB\xA0{type}\xA0\xBB)",
        typeNotAwaitable: "\xAB\xA0{type}\xA0\xBB n\u2019est pas awaitable",
        typeNotIntantiable: "\xAB\xA0{type}\xA0\xBB ne peut pas \xEAtre instanci\xE9",
        typeNotIterable: "\xAB\xA0{type}\xA0\xBB n\u2019est pas it\xE9rable",
        typeNotSpecializable: 'Impossible de sp\xE9cialiser le type "{type}"',
        typeNotSubscriptable: "L\u2019objet de type \xAB\xA0{type}\xA0\xBB n\u2019est pas sous-scriptible",
        typeNotSupportBinaryOperator: 'Op\xE9rateur "{operator}" non pris en charge pour les types "{leftType}" et "{rightType}"',
        typeNotSupportBinaryOperatorBidirectional: `L'op\xE9rateur "{operator}" n'est pas pris en charge pour les types "{leftType}" et "{rightType}" lorsque le type attendu est "{expectedType}"`,
        typeNotSupportUnaryOperator: `L'op\xE9rateur "{operator}" n'est pas pris en charge pour le type "{type}"`,
        typeNotSupportUnaryOperatorBidirectional: "L\u2019op\xE9rateur \xAB\xA0{operator}\xA0\xBB n\u2019est pas pris en charge pour le type \xAB\xA0{type}\xA0\xBB quand le type attendu est \xAB\xA0{expectedType}\xA0\xBB",
        typeNotUsableWith: "L\u2019objet de type \xAB\xA0{type}\xA0\xBB ne peut pas \xEAtre utilis\xE9 avec \xAB\xA0with\xA0\xBB, car il n\u2019impl\xE9mente pas correctement {method}",
        typeNotUsableWithAsync: "L\u2019objet de type \xAB\xA0{type}\xA0\xBB ne peut pas \xEAtre utilis\xE9 avec \xAB\xA0async with\xA0\xBB, car il n\u2019impl\xE9mente pas correctement {method}",
        typeParameterBoundNotAllowed: "La limite ou la contrainte ne peut pas \xEAtre utilis\xE9e avec un param\xE8tre de type variadique ou ParamSpec",
        typeParameterConstraintTuple: "La contrainte de param\xE8tre de type doit \xEAtre un tuple de plusieurs types",
        typeParameterExistingTypeParameter: "Le param\xE8tre de type \xAB\xA0{name}\xA0\xBB est d\xE9j\xE0 utilis\xE9",
        typeParameterNotDeclared: "Le param\xE8tre de type \xAB\xA0{name}\xA0\xBB n\u2019est pas inclus dans la liste des param\xE8tres de type pour \xAB\xA0{container}\xA0\xBB",
        typeParametersMissing: "Au moins un param\xE8tre de type doit \xEAtre sp\xE9cifi\xE9",
        typePartiallyUnknown: "Le type de \xAB {name} \xBB est partiellement inconnu",
        typeUnknown: "Le type de \xAB {name} \xBB est inconnu",
        typeVarAssignedName: "TypeVar doit \xEAtre affect\xE9 \xE0 une variable nomm\xE9e \xAB {name} \xBB",
        typeVarAssignmentMismatch: 'Le type "{type}" ne peut pas \xEAtre affect\xE9 \xE0 la variable de type "{name}"',
        typeVarBoundAndConstrained: "TypeVar ne peut pas \xEAtre \xE0 la fois li\xE9 et contraint",
        typeVarBoundGeneric: "Le type li\xE9 TypeVar ne peut pas \xEAtre g\xE9n\xE9rique",
        typeVarConstraintGeneric: "Le type de contrainte TypeVar ne peut pas \xEAtre g\xE9n\xE9rique",
        typeVarDefaultBoundMismatch: "Le type par d\xE9faut TypeVar doit \xEAtre un sous-type du type li\xE9",
        typeVarDefaultConstraintMismatch: "Le type par d\xE9faut TypeVar doit \xEAtre l'un des types contraints",
        typeVarDefaultIllegal: "Les types de variables de type par d\xE9faut n\xE9cessitent Python 3.13 ou une version plus r\xE9cente",
        typeVarDefaultInvalidTypeVar: "Le param\xE8tre de type \xAB\xA0{name}\xA0\xBB a un type par d\xE9faut qui fait r\xE9f\xE9rence \xE0 une ou plusieurs variables de type hors de port\xE9e",
        typeVarFirstArg: "Nom attendu de TypeVar comme premier argument",
        typeVarInvalidForMemberVariable: "Le type d\u2019attribut ne peut pas utiliser de variable de type \xAB\xA0{name}\xA0\xBB \xE9tendue \xE0 une m\xE9thode locale",
        typeVarNoMember: "TypeVar \xAB\xA0{type}\xA0\xBB n\u2019a aucun attribut \xAB\xA0{name}\xA0\xBB",
        typeVarNotSubscriptable: "TypeVar \xAB\xA0{type}\xA0\xBB n\u2019est pas subscriptible",
        typeVarNotUsedByOuterScope: "La variable de type \xAB\xA0{name}\xA0\xBB n\u2019a aucune signification dans ce contexte",
        typeVarPossiblyUnsolvable: `La variable de type "{name}" peut rester non r\xE9solue si l'appelant ne fournit aucun argument pour le param\xE8tre "{param}"`,
        typeVarSingleConstraint: "TypeVar doit avoir au moins deux types contraints",
        typeVarTupleConstraints: "TypeVarTuple ne peut pas avoir de contraintes de valeur",
        typeVarTupleContext: "TypeVarTuple n\u2019est pas autoris\xE9 dans ce contexte",
        typeVarTupleDefaultNotUnpacked: "Le type par d\xE9faut TypeVarTuple doit \xEAtre un tuple d\xE9compress\xE9 ou TypeVarTuple",
        typeVarTupleMustBeUnpacked: "L'op\xE9rateur Unpack est requis pour la valeur TypeVarTuple",
        typeVarTupleUnknownParam: "\xAB\xA0{name}\xA0\xBB est un param\xE8tre inconnu de TypeVarTuple",
        typeVarUnknownParam: '"{name}" est un param\xE8tre inconnu pour TypeVar',
        typeVarUsedByOuterScope: 'TypeVar "{name}" est d\xE9j\xE0 utilis\xE9 par une port\xE9e externe',
        typeVarUsedOnlyOnce: "TypeVar \xAB\xA0{name}\xA0\xBB n\u2019appara\xEEt qu\u2019une seule fois dans la signature de fonction g\xE9n\xE9rique",
        typeVarVariance: "TypeVar ne peut pas \xEAtre \xE0 la fois covariant et contravariant",
        typeVarWithDefaultFollowsVariadic: "TypeVar \xAB\xA0{typeVarName}\xA0\xBB a une valeur par d\xE9faut et ne peut pas suivre TypeVarTuple \xAB\xA0{variadicName}\xA0\xBB",
        typeVarWithoutDefault: `"{name}" ne peut pas appara\xEEtre apr\xE8s "{other}" dans la liste des param\xE8tres de type car il n'a pas de type par d\xE9faut`,
        typeVarsNotInGenericOrProtocol: "Generic[] ou Protocol[] doit inclure toutes les variables de type",
        typedDictAccess: "Impossible d\u2019acc\xE9der \xE0 l\u2019\xE9l\xE9ment dans TypedDict",
        typedDictAssignedName: "TypedDict doit \xEAtre affect\xE9 \xE0 une variable nomm\xE9e \xAB\xA0{name}\xA0\xBB",
        typedDictBadVar: "Les classes TypedDict ne peuvent contenir que des annotations de type",
        typedDictBaseClass: "Toutes les classes de base pour les classes TypedDict doivent \xE9galement \xEAtre des classes TypedDict",
        typedDictBoolParam: "Param\xE8tre \xAB\xA0{name}\xA0\xBB attendu avec la valeur True ou False",
        typedDictClosedExtras: 'Le "{name}" de classe de base est un TypedDict qui limite le type d\u2019\xE9l\xE9ments suppl\xE9mentaires au type "{type}"',
        typedDictClosedFalseNonOpenBase: 'Base class "{name}" is not an open TypedDict; closed=False is not allowed',
        typedDictClosedNoExtras: "La classe de base \xAB\xA0{name}\xA0\xBB est un TypedDict closed, les \xE9l\xE9ments suppl\xE9mentaires ne sont pas autoris\xE9s",
        typedDictDelete: "Impossible de supprimer l\u2019\xE9l\xE9ment dans TypedDict",
        typedDictEmptyName: "Les noms dans un TypedDict ne peuvent pas \xEAtre vides",
        typedDictEntryName: "Litt\xE9ral de cha\xEEne attendu pour le nom d\u2019entr\xE9e du dictionnaire",
        typedDictEntryUnique: "Les noms dans un dictionnaire doivent \xEAtre uniques",
        typedDictExtraArgs: "Arguments TypedDict suppl\xE9mentaires non pris en charge",
        typedDictExtraItemsClosed: 'TypedDict pouvez utiliser "closed" ou "extra_items", mais pas les deux',
        typedDictFieldNotRequiredRedefinition: "L\u2019\xE9l\xE9ment TypedDict \xAB\xA0{name}\xA0\xBB ne peut pas \xEAtre red\xE9fini comme \xE9tant NotRequired",
        typedDictFieldReadOnlyRedefinition: "L\u2019\xE9l\xE9ment TypedDict \xAB\xA0{name}\xA0\xBB ne peut pas \xEAtre red\xE9fini comme \xE9tat En ReadOnly",
        typedDictFieldRequiredRedefinition: "L\u2019\xE9l\xE9ment TypedDict \xAB\xA0{name}\xA0\xBB ne peut pas \xEAtre red\xE9fini comme \xE9tant Required",
        typedDictFirstArg: "Nom de classe TypedDict attendu comme premier argument",
        typedDictInClassPattern: "La classe TypedDict n'est pas autoris\xE9e dans le mod\xE8le de classe",
        typedDictInitsubclassParameter: "TypedDict ne prend pas en charge __init_subclass__ param\xE8tre \xAB\xA0{name}\xA0\xBB",
        typedDictNotAllowed: '"TypedDict" ne peut pas \xEAtre utilis\xE9 dans ce contexte',
        typedDictSecondArgDict: "Param\xE8tre de mot cl\xE9 ou de dict attendu en tant que deuxi\xE8me param\xE8tre",
        typedDictSecondArgDictEntry: "Entr\xE9e de dictionnaire simple attendue",
        typedDictSet: "Impossible d'attribuer l'\xE9l\xE9ment dans TypedDict",
        unaccessedClass: `La classe "{name}" n'a pas \xE9t\xE9 acc\xE9d\xE9e`,
        unaccessedFunction: "La fonction \xAB\xA0{name}\xA0\xBB n\u2019a pas \xE9t\xE9 acc\xE9d\xE9e",
        unaccessedImport: "L\u2019importation \xAB {name} \xBB n\u2019a pas \xE9t\xE9 acc\xE9d\xE9e",
        unaccessedSymbol: "\xAB\xA0{name}\xA0\xBB n\u2019a pas \xE9t\xE9 acc\xE9d\xE9(e)",
        unaccessedVariable: "La variable \xAB\xA0{name}\xA0\xBB n\u2019a pas \xE9t\xE9 acc\xE9d\xE9e",
        unannotatedFunctionSkipped: `L'analyse de la fonction "{name}" est ignor\xE9e car elle n'est pas annot\xE9e`,
        unaryOperationNotAllowed: "L'op\xE9rateur unaire n'est pas autoris\xE9 dans l'expression de type",
        unexpectedAsyncToken: "\xAB\xA0def\xA0\xBB, \xAB\xA0with\xA0\xBB ou \xAB\xA0for\xA0\xBB attendu pour suivre \xAB\xA0async\xA0\xBB",
        unexpectedEof: "Unexpected EOF",
        unexpectedExprToken: "Jeton inattendu \xE0 la fin de l\u2019expression",
        unexpectedIndent: "Retrait inattendu",
        unexpectedUnindent: "Unindent non attendu",
        unhashableDictKey: "La cl\xE9 du dictionnaire doit \xEAtre hachable",
        unhashableSetEntry: "L\u2019entr\xE9e set doit \xEAtre hachable",
        uninitializedAbstractVariables: "Les variables d\xE9finies dans la classe de base abstraite ne sont pas initialis\xE9es dans la classe finale \xAB\xA0{classType}\xA0\xBB",
        uninitializedInstanceVariable: "La variable d\u2019instance \xAB\xA0{name}\xA0\xBB n\u2019est pas initialis\xE9e dans le corps de la classe ou dans la m\xE9thode __init__",
        unionForwardReferenceNotAllowed: "La syntaxe Union ne peut pas \xEAtre utilis\xE9e avec l\u2019op\xE9rande de cha\xEEne ; utiliser des guillemets autour de l\u2019expression enti\xE8re",
        unionSyntaxIllegal: "Une autre syntaxe pour les unions n\xE9cessite Python 3.10 ou une version plus r\xE9cente",
        unionTypeArgCount: "L\u2019Union requiert au moins deux arguments de type",
        unionUnpackedTuple: "Union ne peut pas inclure un tuple d\xE9compress\xE9",
        unionUnpackedTypeVarTuple: "Union ne peut pas inclure un TypeVarTuple d\xE9compress\xE9",
        unnecessaryCast: 'Appel "cast" inutile\xA0; le type est d\xE9j\xE0 "{type}"',
        unnecessaryIsInstanceAlways: "Appel d\u2019isinstance inutile ; \xAB\xA0{testType}\xA0\xBB est toujours une instance de \xAB\xA0{classType}\xA0\xBB",
        unnecessaryIsInstanceNever: "Appel d\u2019isinstance inutile; \xAB\xA0{testType}\xA0\xBB n est jamais une instance de \xAB\xA0{classType}\xA0\xBB",
        unnecessaryIsSubclassAlways: 'Appel issubclass inutile\xA0; "{testType}" est toujours une sous-classe de "{classType}"',
        unnecessaryIsSubclassNever: "Appel issubclass inutile; \xAB\xA0{testType}\xA0\xBB est toujours une sous-classe de \xAB\xA0{classType}\xA0\xBB",
        unnecessaryPyrightIgnore: 'Commentaire "# pyright: ignore" inutile',
        unnecessaryPyrightIgnoreRule: "R\xE8gle inutile \xAB\xA0# pyright: ignore\xA0\xBB\xA0: \xAB\xA0{name}\xA0\xBB",
        unnecessaryTypeIgnore: 'Commentaire "# type: ignore" inutile',
        unpackArgCount: 'Attendu un seul argument de type apr\xE8s "Unpack"',
        unpackExpectedTypeVarTuple: "TypeVarTuple ou tuple attendu en tant qu\u2019argument de type pour Unpack",
        unpackExpectedTypedDict: "Argument de type TypedDict attendu pour Unpack",
        unpackIllegalInComprehension: "Op\xE9ration de d\xE9compression non autoris\xE9e dans la compr\xE9hension",
        unpackInAnnotation: "L'op\xE9rateur de d\xE9ballage n'est pas autoris\xE9 dans l'expression de type",
        unpackInDict: "Op\xE9ration de d\xE9compression non autoris\xE9e dans les dictionnaires",
        unpackInSet: "Op\xE9rateur de d\xE9ballage non autoris\xE9 dans un set",
        unpackNotAllowed: "Le Unpack n\u2019est pas autoris\xE9 dans ce contexte",
        unpackOperatorNotAllowed: "L\u2019op\xE9ration de d\xE9compression n\u2019est pas autoris\xE9e dans ce contexte",
        unpackTuplesIllegal: "Op\xE9ration de d\xE9compression non autoris\xE9e dans les tuples avant Python 3.8",
        unpackedArgInTypeArgument: "Les arguments d\xE9compress\xE9s ne peuvent pas \xEAtre utilis\xE9s dans ce contexte",
        unpackedArgWithVariadicParam: "L'argument d\xE9compress\xE9 ne peut pas \xEAtre utilis\xE9 pour le param\xE8tre TypeVarTuple",
        unpackedDictArgumentNotMapping: "L\u2019expression d\u2019argument apr\xE8s ** doit \xEAtre un mappage avec un type de cl\xE9 \xAB\xA0str\xA0\xBB",
        unpackedDictSubscriptIllegal: "L\u2019op\xE9rateur de d\xE9compression de dictionnaire dans l\u2019indice n\u2019est pas autoris\xE9",
        unpackedSubscriptIllegal: "L\u2019op\xE9rateur de d\xE9compression en indice requiert Python 3.11 ou version ult\xE9rieure",
        unpackedTypeVarTupleExpected: "TypeVarTuple d\xE9compress\xE9 attendu ; utiliser Unpack[{name1}] ou *{name2}",
        unpackedTypedDictArgument: "Impossible de faire correspondre l\u2019argument TypedDict d\xE9compress\xE9 aux param\xE8tres",
        unreachableCodeCondition: "Code is not analyzed because condition is statically evaluated as false",
        unreachableCodeStructure: "Code is structurally unreachable",
        unreachableCodeType: "L\u2019analyse de type indique que le code est inaccessible",
        unreachableExcept: "La clause Except est inaccessible, car l\u2019exception est d\xE9j\xE0 g\xE9r\xE9e",
        unsupportedDunderAllOperation: "L\u2019op\xE9ration sur \xAB __all__ \xBB n\u2019est pas prise en charge. Par cons\xE9quent, la liste de symboles export\xE9e peut \xEAtre incorrecte",
        unusedCallResult: `Le r\xE9sultat de l'expression d'appel est de type "{type}" et n'est pas utilis\xE9\xA0; affecter \xE0 la variable "_" si c'est intentionnel`,
        unusedCoroutine: "Le r\xE9sultat de l\u2019appel de fonction asynchrone n\u2019est pas utilis\xE9 ; utiliser \xAB await \xBB ou affecter le r\xE9sultat \xE0 la variable",
        unusedExpression: "La valeur de l'expression n'est pas utilis\xE9e",
        varAnnotationIllegal: "Les annotations de type pour les variables n\xE9cessitent Python 3.6 ou une version ult\xE9rieure ; utiliser le commentaire de type pour la compatibilit\xE9 avec les versions pr\xE9c\xE9dentes",
        variableFinalOverride: "La variable \xAB\xA0{name}\xA0\xBB est marqu\xE9e comme Final et remplace la variable non-Final du m\xEAme nom dans la classe \xAB\xA0{className}\xA0\xBB",
        variadicTypeArgsTooMany: "La liste d\u2019arguments de type peut avoir au plus un TypeVarTuple ou tuple d\xE9compress\xE9",
        variadicTypeParamTooManyAlias: "L\u2019alias de type peut avoir au plus un param\xE8tre de type TypeVarTuple, mais a re\xE7u plusieurs ({names})",
        variadicTypeParamTooManyClass: "La classe g\xE9n\xE9rique peut avoir au plus un param\xE8tre de type TypeVarTuple, mais en a re\xE7u plusieurs ({names})",
        walrusIllegal: "L\u2019op\xE9rateur \xAB\xA0:=\xA0\xBB n\xE9cessite Python 3.8 ou version ult\xE9rieure",
        walrusNotAllowed: "L\u2019op\xE9rateur \xAB\xA0:=\xA0\xBB n\u2019est pas autoris\xE9 dans ce contexte sans parenth\xE8ses adjacentes",
        wildcardInFunction: "import de caract\xE8res g\xE9n\xE9riques non autoris\xE9e dans une classe ou une fonction",
        wildcardLibraryImport: "import de caract\xE8res g\xE9n\xE9riques \xE0 partir d\u2019une biblioth\xE8que non autoris\xE9e",
        wildcardPatternTypePartiallyUnknown: "Le type captur\xE9 par le mod\xE8le g\xE9n\xE9rique est partiellement inconnu",
        wildcardPatternTypeUnknown: "Le type captur\xE9 par le mod\xE8le g\xE9n\xE9rique est inconnu",
        yieldFromIllegal: "L\u2019utilisation de \xAB yield from \xBB n\xE9cessite Python 3.3 ou version ult\xE9rieure",
        yieldFromOutsideAsync: "\xAB yield from \xBB non autoris\xE9 dans une fonction asynchrone",
        yieldOutsideFunction: "\xAB\xA0yield\xA0\xBB non autoris\xE9 en dehors d\u2019une fonction ou d\u2019un lambda",
        yieldWithinComprehension: "\xAB\xA0yield\xA0\xBB n\u2019est pas autoris\xE9 dans une compr\xE9hension de liste",
        zeroCaseStatementsFound: "L\u2019instruction de Match doit inclure au moins une instruction case",
        zeroLengthTupleNotAllowed: "Le tuple de longueur nulle n\u2019est pas autoris\xE9 dans ce contexte"
      },
      DiagnosticAddendum: {
        annotatedNotAllowed: "Impossible d\u2019utiliser le formulaire sp\xE9cial \xAB\xA0Annotated\xA0\xBB avec les v\xE9rifications d\u2019instance et de classe",
        argParam: "L\u2019argument correspond au param\xE8tre \xAB\xA0{paramName}\xA0\xBB",
        argParamFunction: "L\u2019argument correspond au param\xE8tre \xAB\xA0{paramName}\xA0\xBB dans la fonction \xAB\xA0{functionName}\xA0\xBB",
        argsParamMissing: `Le param\xE8tre "*{paramName}" n'a pas de param\xE8tre correspondant`,
        argsPositionOnly: "Non-concordance des param\xE8tres de position uniquement\xA0; attendu {expected} mais re\xE7u {received}",
        argumentType: "Le type d\u2019argument est \xAB\xA0{type}\xA0\xBB",
        argumentTypes: "Types d'argument\xA0: ({types})",
        assignToNone: "Le type n\u2019est pas assignable \xE0 \xAB None \xBB",
        asyncHelp: "Vouliez-vous dire \xAB\xA0async with\xA0\xBB\xA0?",
        baseClassIncompatible: "La classe de base \xAB\xA0{baseClass}\xA0\xBB n\u2019est pas compatible avec le type \xAB\xA0{type}\xA0\xBB",
        baseClassIncompatibleSubclass: "La classe de base \xAB\xA0{baseClass}\xA0\xBB d\xE9rive de \xAB\xA0{subclass}\xA0\xBB qui est incompatible avec le type \xAB\xA0{type}\xA0\xBB",
        baseClassOverriddenType: "La classe de base \xAB\xA0{baseClass}\xA0\xBB fournit le type \xAB\xA0{type}\xA0\xBB, qui est remplac\xE9",
        baseClassOverridesType: 'La classe de base "{baseClass}" remplace le type "{type}"',
        bytesTypePromotions: "D\xE9finir disableBytesTypePromotions sur false pour activer le comportement de promotion de type pour \xAB bytearray \xBB et \xAB memoryview \xBB",
        conditionalRequiresBool: "La m\xE9thode __bool__ pour le type \xAB\xA0{operandType}\xA0\xBB retourne le type \xAB\xA0{boolReturnType}\xA0\xBB plut\xF4t que \xAB\xA0bool\xA0\xBB",
        dataClassFieldLocation: "D\xE9claration de champ",
        dataClassFrozen: "\xAB\xA0{name}\xA0\xBB est fig\xE9",
        dataProtocolUnsupported: "\xAB\xA0{name}\xA0\xBB est un protocole de donn\xE9es",
        descriptorAccessBindingFailed: "\xC9chec de la liaison du \xAB\xA0{name}\xA0\xBB de m\xE9thode pour la classe de descripteur \xAB\xA0{className}\xA0\xBB",
        descriptorAccessCallFailed: "\xC9chec de l\u2019appel du \xAB\xA0{name}\xA0\xBB de m\xE9thode pour la classe de descripteur \xAB\xA0{className}\xA0\xBB",
        finalMethod: "M\xE9thode Final",
        functionParamDefaultMissing: `Le param\xE8tre "{name}" n'a pas d'argument par d\xE9faut`,
        functionParamName: "Incompatibilit\xE9 de nom de param\xE8tre : \xAB {destName} \xBB et \xAB {srcName} \xBB",
        functionParamPositionOnly: "Non-correspondance des param\xE8tres position uniquement ; le param\xE8tre \xAB\xA0{name}\xA0\xBB n\u2019est pas en position seule",
        functionReturnTypeMismatch: 'Le type de retour de fonction "{sourceType}" est incompatible avec le type "{destType}"',
        functionTooFewParams: "La fonction accepte trop peu de param\xE8tres positionnels ; {expected} attendu, mais {received} re\xE7u",
        functionTooManyParams: "La fonction accepte trop de param\xE8tres positionnels ; {expected} attendu, mais {received} re\xE7u",
        genericClassNotAllowed: "Type g\xE9n\xE9rique avec des arguments de type non autoris\xE9 pour les v\xE9rifications d\u2019instance ou de classe",
        incompatibleDeleter: "La m\xE9thode du deleter de property n\u2019est pas compatible",
        incompatibleGetter: "La m\xE9thode de getter de property est incompatible",
        incompatibleSetter: "La m\xE9thode setter de property n\u2019est pas compatible",
        initMethodLocation: "La m\xE9thode __init__ est d\xE9finie dans la classe \xAB\xA0{type}\xA0\xBB",
        initMethodSignature: "La signature de __init__ est \xAB {type} \xBB",
        initSubclassLocation: "La m\xE9thode __init_subclass__ est d\xE9finie dans la classe \xAB\xA0{name}\xA0\xBB",
        invariantSuggestionDict: "Envisagez de passer de \xAB dict \xBB \xE0 \xAB Mapping \xBB, qui est covariant dans le type valeur",
        invariantSuggestionList: "Envisagez de passer de \xAB list \xBB \xE0 \xAB Sequence \xBB qui est covariant",
        invariantSuggestionSet: 'Pensez \xE0 passer de "set" \xE0 "Container" qui est covariant',
        isinstanceClassNotSupported: "\xAB\xA0{type}\xA0\xBB n\u2019est pas pris en charge pour les v\xE9rifications d\u2019instance et de classe",
        keyNotRequired: `"{name}" n'est pas une cl\xE9 requise dans "{type}", donc l'acc\xE8s peut entra\xEEner une exception d'ex\xE9cution`,
        keyReadOnly: "\xAB\xA0{name}\xA0\xBB est une cl\xE9 en lecture seule dans \xAB\xA0{type}\xA0\xBB",
        keyRequiredDeleted: "\xAB\xA0{name}\xA0\xBB est une cl\xE9 obligatoire et ne peut pas \xEAtre supprim\xE9e",
        keyUndefined: "\xAB\xA0{name}\xA0\xBB n\u2019est pas une cl\xE9 d\xE9finie dans \xAB\xA0{type}\xA0\xBB",
        kwargsParamMissing: `Le param\xE8tre "**{paramName}" n'a pas de param\xE8tre correspondant`,
        listAssignmentMismatch: "Le type \xAB\xA0{type}\xA0\xBB n\u2019est pas compatible avec la liste cible",
        literalAssignmentMismatch: "\xAB\xA0{sourceType}\xA0\xBB n\u2019est pas assignable au type \xAB\xA0{destType}\xA0\xBB",
        literalNotAllowed: "Le formulaire sp\xE9cial \xAB\xA0Literal\xA0\xBB ne peut pas \xEAtre utilis\xE9 avec les v\xE9rifications d\u2019instances et de classes",
        matchIsNotExhaustiveHint: "Si la gestion exhaustive n\u2019est pas pr\xE9vue, ajoutez \xAB case _: pass \xBB",
        matchIsNotExhaustiveType: "Type non g\xE9r\xE9 : \xAB\xA0{type}\xA0\xBB",
        memberAssignment: "L'expression de type \xAB\xA0{type}\xA0\xBB ne peut pas \xEAtre attribu\xE9e \xE0 l\u2019attribut \xAB\xA0{name}\xA0\xBB de la classe \xAB\xA0{classType}\xA0\xBB",
        memberIsAbstract: "\xAB\xA0{type}.{name}\xA0\xBB n\u2019est pas impl\xE9ment\xE9",
        memberIsAbstractMore: "et {count} autres...",
        memberIsClassVarInProtocol: "\xAB\xA0{name}\xA0\xBB est d\xE9fini en tant que ClassVar dans le protocole",
        memberIsInitVar: "\xAB\xA0{name}\xA0\xBB est un champ init-only",
        memberIsInvariant: "\xAB {name} \xBB est invariant, car il est mutable",
        memberIsNotClassVarInClass: "\xAB\xA0{name}\xA0\xBB doit \xEAtre d\xE9fini en tant que ClassVar pour \xEAtre compatible avec le protocole",
        memberIsNotClassVarInProtocol: "\xAB\xA0{name}\xA0\xBB n\u2019est pas d\xE9fini en tant que ClassVar dans le protocole",
        memberIsNotReadOnlyInProtocol: "\xAB\xA0{name}\xA0\xBB n\u2019est pas en lecture seule dans le protocole",
        memberIsReadOnlyInProtocol: "\xAB\xA0{name}\xA0\xBB est en lecture seule dans le protocole",
        memberIsWritableInProtocol: "\xAB\xA0{name}\xA0\xBB est accessible en \xE9criture dans le protocole",
        memberSetClassVar: "L\u2019attribut \xAB\xA0{name}\xA0\xBB ne peut pas \xEAtre attribu\xE9 via une instance de classe car il s\u2019agit d\u2019une ClassVar",
        memberTypeMismatch: "\xAB {name} \xBB est un type incompatible",
        memberUnknown: "L\u2019attribut \xAB\xA0{name}\xA0\xBB est inconnu",
        metaclassConflict: "La m\xE9taclasse \xAB\xA0{metaclass1}\xA0\xBB est en conflit avec \xAB\xA0{metaclass2}\xA0\xBB",
        missingDeleter: "La m\xE9thode de deleter de property est manquante",
        missingGetter: "La m\xE9thode getter de property est manquante",
        missingSetter: "setter de d\xE9finition de property est manquante",
        namedParamMissingInDest: "Param\xE8tre suppl\xE9mentaire \xAB\xA0{name}\xA0\xBB",
        namedParamMissingInSource: "Param\xE8tre de mot cl\xE9 manquant \xAB\xA0{name}\xA0\xBB",
        namedParamTypeMismatch: "Le param\xE8tre de mot cl\xE9 \xAB\xA0{name}\xA0\xBB de type \xAB\xA0{sourceType}\xA0\xBB est incompatible avec le type \xAB\xA0{destType}\xA0\xBB",
        namedTupleNotAllowed: "NamedTuple ne peut pas \xEAtre utilis\xE9 pour les v\xE9rifications d\u2019instance ou de classe",
        newMethodLocation: "La m\xE9thode __new__ est d\xE9finie dans la classe \xAB\xA0{type}\xA0\xBB",
        newMethodSignature: "La signature de __new__ est \xAB {type} \xBB",
        newTypeClassNotAllowed: "Type created with NewType cannot be used with instance and class checks",
        noOverloadAssignable: "Aucune fonction surcharg\xE9e ne correspond au type \xAB\xA0{type}\xA0\xBB",
        noneNotAllowed: "None ne peut \xEAtre utilis\xE9 pour les v\xE9rifications de instance ou de classe",
        orPatternMissingName: "Noms manquants : {name}",
        overloadIndex: "La surcharge {index} est la correspondance la plus proche",
        overloadNotAssignable: "Une ou plusieurs surcharges de \xAB {name} \xBB ne sont pas assignables",
        overloadSignature: "La signature de surcharge est d\xE9finie ici",
        overriddenMethod: "M\xE9thode substitu\xE9e",
        overriddenSymbol: "Symbole substitu\xE9",
        overrideInvariantMismatch: `Le type de remplacement "{overrideType}" n'est pas le m\xEAme que le type de base "{baseType}"`,
        overrideIsInvariant: "La variable est mutable donc son type est invariant",
        overrideNoOverloadMatches: "Aucune signature de surcharge dans le remplacement n\u2019est compatible avec la m\xE9thode de base",
        overrideNotClassMethod: "La m\xE9thode de base est d\xE9clar\xE9e en tant que classmethod, mais la substitution n\u2019est pas",
        overrideNotInstanceMethod: "La m\xE9thode de base est d\xE9clar\xE9e en tant que m\xE9thode d'instance mais la substitution n'est pas",
        overrideNotStaticMethod: "La m\xE9thode de base est d\xE9clar\xE9e comme staticmethod, mais la substitution n\u2019est pas",
        overrideOverloadNoMatch: "Le remplacement ne g\xE8re pas toutes les surcharges de la m\xE9thode de base",
        overrideOverloadOrder: "Les surcharges pour la m\xE9thode de remplacement doivent \xEAtre dans le m\xEAme ordre que la m\xE9thode de base",
        overrideParamKeywordNoDefault: `Non-concordance du param\xE8tre de mot-cl\xE9 "{name}"\xA0: le param\xE8tre de base a une valeur d'argument par d\xE9faut, le param\xE8tre de remplacement n'en a pas`,
        overrideParamKeywordType: 'Incompatibilit\xE9 de type du param\xE8tre de mot cl\xE9 "{name}"\xA0: le param\xE8tre de base est de type "{baseType}", le param\xE8tre de remplacement est de type "{overrideType}"',
        overrideParamName: 'Incompatibilit\xE9 de nom de param\xE8tre {index}\xA0: le param\xE8tre de base est nomm\xE9 "{baseName}", le param\xE8tre de remplacement est nomm\xE9 "{overrideName}"',
        overrideParamNameExtra: "Le param\xE8tre \xAB\xA0{name}\xA0\xBB est manquant dans la base",
        overrideParamNameMissing: 'Le param\xE8tre "{name}" est manquant dans le remplacement',
        overrideParamNamePositionOnly: 'Incompatibilit\xE9 du param\xE8tre {index}\xA0: le param\xE8tre de base "{baseName}" est un param\xE8tre de mot-cl\xE9, le param\xE8tre de remplacement est uniquement de position',
        overrideParamNoDefault: "Non-concordance du param\xE8tre {index}\xA0: le param\xE8tre de base a une valeur d'argument par d\xE9faut, le param\xE8tre de remplacement n'en a pas",
        overrideParamType: 'Incompatibilit\xE9 de type de param\xE8tre {index}\xA0: le param\xE8tre de base est de type "{baseType}", le param\xE8tre de remplacement est de type "{overrideType}"',
        overridePositionalParamCount: "Non-concordance du nombre de param\xE8tres positionnels\xA0; la m\xE9thode de base a {baseCount}, mais la substitution a {overrideCount}",
        overrideReturnType: "Incompatibilit\xE9 de type de retour : la m\xE9thode de base retourne le type \xAB\xA0{baseType}\xA0\xBB, la substitution retourne le type \xAB\xA0{overrideType}\xA0\xBB",
        overrideType: "La classe de base d\xE9finit le type comme \xAB {type} \xBB",
        paramAssignment: "Param\xE8tre {index}\xA0: le type \xAB\xA0{sourceType}\xA0\xBB est incompatible avec le type \xAB\xA0{destType}\xA0\xBB",
        paramSpecMissingInOverride: "Les param\xE8tres ParamSpec sont manquants dans la m\xE9thode de remplacement",
        paramType: "Le type de param\xE8tre est \xAB {paramType} \xBB",
        privateImportFromPyTypedSource: "Importer \xE0 partir de \xAB {module} \xBB \xE0 la place",
        propertyAccessFromProtocolClass: "Une propri\xE9t\xE9 d\xE9finie dans une classe de protocole n'est pas accessible en tant que variable de classe",
        propertyMethodIncompatible: "La m\xE9thode de property \xAB\xA0{name}\xA0\xBB n\u2019est pas compatible",
        propertyMethodMissing: "La m\xE9thode de property \xAB\xA0{name}\xA0\xBB est manquante dans le remplacement",
        propertyMissingDeleter: "La property \xAB\xA0{name}\xA0\xBB n\u2019a pas de deleter d\xE9fini",
        propertyMissingSetter: "La property \xAB\xA0{name}\xA0\xBB n\u2019a pas de m\xE9thode setter d\xE9finie",
        protocolIncompatible: '"{sourceType}" est incompatible avec le protocole "{destType}"',
        protocolMemberMissing: "\xAB\xA0{name}\xA0\xBB n\u2019est pas pr\xE9sent",
        protocolRequiresRuntimeCheckable: "La classe de Protocol doit \xEAtre @runtime_checkable \xE0 utiliser avec des v\xE9rifications d\u2019instance et de classe",
        protocolSourceIsNotConcrete: `"{sourceType}" n'est pas un type de classe concret et ne peut pas \xEAtre affect\xE9 au type "{destType}"`,
        protocolUnsafeOverlap: "Les attributs de \xAB\xA0{name}\xA0\xBB ont les m\xEAmes noms que le protocole",
        pyrightCommentIgnoreTip: "Utilisez \xAB\xA0# pyright: ignore[<diagnostic rules>]\xA0\xBB pour supprimer les diagnostics pour une seule ligne",
        readOnlyAttribute: "L\u2019attribut \xAB\xA0{name}\xA0\xBB est en lecture seule",
        seeClassDeclaration: "Voir la d\xE9claration de classe",
        seeDeclaration: "Voir la d\xE9claration",
        seeFunctionDeclaration: "Voir la d\xE9claration de fonction",
        seeMethodDeclaration: "Voir la d\xE9claration de m\xE9thode",
        seeParameterDeclaration: "Voir la d\xE9claration des param\xE8tres",
        seeTypeAliasDeclaration: "Voir la d\xE9claration d\u2019alias de type",
        seeVariableDeclaration: "Voir d\xE9claration de variable",
        tupleAssignmentMismatch: 'Le type "{type}" est incompatible avec le tuple cible',
        tupleEntryTypeMismatch: "Le type de l\u2019entr\xE9e de tuple {entry} est incorrect",
        tupleSizeIndeterminateSrc: "Incompatibilit\xE9 de taille de tuple\xA0; attendu {expected} mais re\xE7u pour une dur\xE9e ind\xE9termin\xE9e",
        tupleSizeIndeterminateSrcDest: "Incompatibilit\xE9 de taille de tuple\xA0: attente de {expected} ou plus, mais r\xE9ception ind\xE9termin\xE9e",
        tupleSizeMismatch: "Incompatibilit\xE9 de taille de tuple\xA0; attendu {expected} mais re\xE7u {received}",
        tupleSizeMismatchIndeterminateDest: "Incompatibilit\xE9 de taille de tuple\xA0: attente de {expected} ou plus, mais r\xE9ception de {received}",
        typeAliasInstanceCheck: "L\u2019alias de type cr\xE9\xE9 avec l\u2019instruction \xAB\xA0type\xA0\xBB ne peut pas \xEAtre utilis\xE9 avec des v\xE9rifications d\u2019instance et de classe",
        typeAssignmentMismatch: "Le type \xAB\xA0{sourceType}\xA0\xBB n\u2019est pas assignable au type \xAB\xA0{destType}\xA0\xBB",
        typeBound: "Le type \xAB\xA0{sourceType}\xA0\xBB n\u2019est pas assignable \xE0 la limite sup\xE9rieure \xAB\xA0{destType}\xA0\xBB pour la variable de type \xAB\xA0{name}\xA0\xBB",
        typeConstrainedTypeVar: "Le type \xAB\xA0{type}\xA0\xBB n\u2019est pas assignable \xE0 la variable de type contrainte \xAB\xA0{name}\xA0\xBB",
        typeIncompatible: "\xAB\xA0{sourceType}\xA0\xBB n\u2019est pas assignable \xE0 \xAB\xA0{destType}\xA0\xBB",
        typeNotClass: "\xAB\xA0{type}\xA0\xBB n\u2019est pas une classe",
        typeNotStringLiteral: `"{type}" n'est pas un litt\xE9ral de cha\xEEne`,
        typeOfSymbol: 'Le type de "{name}" est "{type}"',
        typeParamSpec: "Le type \xAB\xA0{type}\xA0\xBB n\u2019est pas compatible avec ParamSpec \xAB\xA0{name}\xA0\xBB",
        typeUnsupported: "Le type \xAB\xA0{type}\xA0\xBB n\u2019est pas pris en charge",
        typeVarDefaultOutOfScope: "La variable de type \xAB\xA0{name}\xA0\xBB n\u2019est pas dans l\u2019\xE9tendue",
        typeVarIsContravariant: `Le param\xE8tre de type "{name}" est contravariant, mais "{sourceType}" n'est pas un supertype de "{destType}"`,
        typeVarIsCovariant: `Le param\xE8tre de type "{name}" est covariant, mais "{sourceType}" n'est pas un sous-type de "{destType}"`,
        typeVarIsInvariant: `Le param\xE8tre de type "{name}" est invariant, mais "{sourceType}" n'est pas le m\xEAme que "{destType}"`,
        typeVarNotAllowed: "TypeVar non autoris\xE9 pour les v\xE9rifications d\u2019instance ou de classe",
        typeVarTupleRequiresKnownLength: "TypeVarTuple ne peut pas \xEAtre li\xE9 \xE0 un tuple de longueur inconnue",
        typeVarUnnecessarySuggestion: "Utilisez plut\xF4t {type}",
        typeVarUnsolvableRemedy: "Fournir une surcharge qui sp\xE9cifie le type de retour lorsque l\u2019argument n\u2019est pas fourni",
        typeVarsMissing: "Variables de type manquantes : {names}",
        typedDictBaseClass: `La classe "{type}" n'est pas un TypedDict`,
        typedDictClassNotAllowed: "Classe TypedDict non autoris\xE9e pour les v\xE9rifications d\u2019instance ou de classe",
        typedDictClosedExtraNotAllowed: "Impossible d\u2019ajouter l\u2019\xE9l\xE9ment \xAB\xA0{name}\xA0\xBB",
        typedDictClosedExtraTypeMismatch: "Impossible d\u2019ajouter l\u2019\xE9l\xE9ment \xAB\xA0{name}\xA0\xBB avec le type \xAB\xA0{type}\xA0\xBB",
        typedDictClosedFieldNotReadOnly: 'Cannot add item "{name}" because it must be ReadOnly',
        typedDictClosedFieldNotRequired: "Impossible d\u2019ajouter l\u2019\xE9l\xE9ment \xAB\xA0{name}\xA0\xBB, car il doit \xEAtre NotRequired",
        typedDictExtraFieldNotAllowed: "\xAB\xA0{name}\xA0\xBB n\u2019est pas pr\xE9sent dans \xAB\xA0{type}\xA0\xBB",
        typedDictExtraFieldTypeMismatch: "Le type de \xAB\xA0{name}\xA0\xBB est incompatible avec le type \xAB\xA0extra_items\xA0\xBB dans \xAB\xA0{type}\xA0\xBB",
        typedDictFieldMissing: "\xAB\xA0{name}\xA0\xBB est manquant dans \xAB\xA0{type}\xA0\xBB",
        typedDictFieldNotReadOnly: "\xAB\xA0{name}\xA0\xBB n\u2019est pas en lecture seule dans \xAB\xA0{type}\xA0\xBB",
        typedDictFieldNotRequired: "\xAB\xA0{name}\xA0\xBB n\u2019est pas obligatoire dans \xAB\xA0{type}\xA0\xBB",
        typedDictFieldRequired: "\xAB\xA0{name}\xA0\xBB est obligatoire dans \xAB\xA0{type}\xA0\xBB",
        typedDictFieldTypeMismatch: "Le type \xAB\xA0{type}\xA0\xBB n'est pas attribuable \xE0 l\u2019\xE9l\xE9ment \xAB\xA0{name}\xA0\xBB",
        typedDictFieldUndefined: "\xAB\xA0{name}\xA0\xBB est un \xE9l\xE9ment non d\xE9fini dans le type \xAB\xA0{type}\xA0\xBB",
        typedDictKeyAccess: "Utilisez [\xAB {name} \xBB] pour r\xE9f\xE9rencer l\u2019\xE9l\xE9ment dans TypedDict",
        typedDictNotAllowed: "TypedDict ne peut pas \xEAtre utilis\xE9 pour les v\xE9rifications d\u2019instance ou de classe",
        unhashableType: `Le type "{type}" n'est pas hachable`,
        uninitializedAbstractVariable: "La variable d\u2019instance \xAB\xA0{name}\xA0\xBB est d\xE9finie dans la classe de base abstraite \xAB\xA0{classType}\xA0\xBB mais n\u2019est pas initialis\xE9e",
        unreachableExcept: "\xAB\xA0{exceptionType}\xA0\xBB est une sous-classe de \xAB\xA0{parentType}\xA0\xBB",
        useDictInstead: "Utilisez dict[T1, T2] pour indiquer un type de dictionnaire",
        useListInstead: "Utiliser list[T] pour indiquer un type de liste ou T1 | T2 pour indiquer un type d\u2019union",
        useTupleInstead: "Utiliser tuple[T1, ..., Tn] pour indiquer un type de tuple ou T1 | T2 pour indiquer un type d\u2019union",
        useTypeInstead: "Utiliser type[T] \xE0 la place",
        varianceMismatchForClass: `La variance de l'argument de type "{typeVarName}" est incompatible avec la classe de base "{className}"`,
        varianceMismatchForTypeAlias: `La variance de l'argument de type "{typeVarName}" est incompatible avec "{typeAliasParam}"`
      },
      Service: {
        longOperation: "L\u2019\xE9num\xE9ration des fichiers sources de l\u2019espace de travail prend beaucoup de temps. Envisagez plut\xF4t d\u2019ouvrir un sous-dossier. [En savoir plus](https://aka.ms/workspace-too-many-files)"
      }
    };
  }
});

// node_modules/@zzzen/pyright-internal/dist/localization/package.nls.it.json
var require_package_nls_it = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/localization/package.nls.it.json"(exports2, module2) {
    module2.exports = {
      CodeAction: {
        createTypeStub: "Crea Stub di tipo",
        createTypeStubFor: 'Crea Stub di tipo per "{moduleName}"',
        executingCommand: "Esecuzione del comando",
        filesToAnalyzeCount: "{count} file da analizzare",
        filesToAnalyzeOne: "1 file da analizzare",
        findingReferences: "Ricerca dei riferimenti in corso",
        organizeImports: "Organizza importazioni"
      },
      Completion: {
        autoImportDetail: "Importazione automatica",
        indexValueDetail: "Valore dell\u2019indice"
      },
      Diagnostic: {
        abstractMethodInvocation: 'Impossibile chiamare il metodo "{method}" perch\xE9 \xE8 astratto e non implementato',
        annotatedMetadataInconsistent: 'Il tipo di metadati annotati "{metadataType}" non \xE8 compatibile con il tipo "{type}"',
        annotatedParamCountMismatch: "Numero di annotazioni dei parametro non corrispondente: previsto {expected} ma ricevuto {received}",
        annotatedTypeArgMissing: 'Previsto un argomento di tipo e una o pi\xF9 annotazioni per "Annotated"',
        annotationBytesString: "Le espressioni di tipo non possono usare valori letterali stringa byte",
        annotationFormatString: "Le espressioni di tipo non possono usare valori letterali stringa di formato (stringhe f)",
        annotationNotSupported: "Annotazione di tipo non supportata per questa istruzione",
        annotationRawString: "Le espressioni di tipo non possono usare valori letterali stringa non elaborata",
        annotationSpansStrings: "Le espressioni di tipo non possono estendersi su pi\xF9 valori letterali stringa",
        annotationStringEscape: "Le espressioni di tipo non possono contenere caratteri di escape",
        annotationTemplateString: "Type expressions cannot use template string literals (t-strings)",
        argAssignment: `Non \xE8 possibile assegnare l'argomento di tipo "{argType}" al parametro di tipo "{paramType}"`,
        argAssignmentFunction: `Non \xE8 possibile assegnare l'argomento di tipo "{argType}" al parametro di tipo "{paramType}" nella funzione "{functionName}"`,
        argAssignmentParam: `Non \xE8 possibile assegnare l'argomento di tipo "{argType}" al parametro "{paramName}" di tipo "{paramType}"`,
        argAssignmentParamFunction: `Non \xE8 possibile assegnare l'argomento di tipo "{argType}" al parametro "{paramName}" di tipo "{paramType}" nella funzione "{functionName}"`,
        argMissingForParam: "Manca l'argomento per il parametro {name}",
        argMissingForParams: "Argomenti mancanti per i parametri {names}",
        argMorePositionalExpectedCount: "Sono previsti {expected} altri argomenti posizionali",
        argMorePositionalExpectedOne: "Previsto 1 altro argomento posizionale",
        argPositional: "Argomento posizionale previsto",
        argPositionalExpectedCount: "Sono previsti {expected} argomenti posizionali",
        argPositionalExpectedOne: "Previsto 1 argomento posizionale",
        argTypePartiallyUnknown: "Tipo di argomento parzialmente sconosciuto",
        argTypeUnknown: "Il tipo di argomento \xE8 sconosciuto",
        assertAlwaysTrue: "L'espressione assert restituisce sempre true",
        assertTypeArgs: '"assert_type" prevede due argomenti posizionali',
        assertTypeTypeMismatch: '"assert_type" non corrispondente: previsto "{expected}" ma ricevuto "{received}"',
        assignmentExprComprehension: `La destinazione dell'espressione di assegnazione "{name}" non pu\xF2 usare lo stesso nome della comprensione per la destinazione`,
        assignmentExprContext: "L'espressione di assegnazione deve essere all'interno di modulo, funzione o lambda",
        assignmentExprInSubscript: "Le espressioni di assegnazione all'interno di un pedice sono supportate solo in Python 3.10 e versioni successive",
        assignmentInProtocol: "Le variabili di istanza o di classe all'interno di una classe Protocollo devono essere dichiarate esplicitamente nel corpo della classe",
        assignmentTargetExpr: "L'espressione non pu\xF2 essere una destinazione di assegnazione",
        asyncNotInAsyncFunction: `L'uso di "async" non \xE8 consentito al di fuori della funzione async`,
        awaitIllegal: `L'uso di "await" richiede Python 3.5 o versione successiva`,
        awaitNotAllowed: 'Le espressioni di tipo non possono usare "await"',
        awaitNotInAsync: `"await" consentito solo all'interno della funzione async`,
        backticksIllegal: "Le espressioni racchiuse tra backticks non sono supportate in Python 3.x; usare repr invece",
        baseClassCircular: "La classe non pu\xF2 derivare da se stessa",
        baseClassFinal: 'La classe di base "{type}" \xE8 contrassegnata come finale e non pu\xF2 essere sottoclassata',
        baseClassIncompatible: "Le classi di base di {type} sono incompatibili tra di loro",
        baseClassInvalid: "L'argomento della classe deve essere una classe base",
        baseClassMethodTypeIncompatible: 'Le classi di base per la classe "{classType}" definiscono il metodo "{name}" in modo incompatibile',
        baseClassUnknown: "Il tipo della classe di base \xE8 sconosciuto. \xC8 in corso il tentativo di determinare il tipo della classe derivata",
        baseClassVariableTypeIncompatible: 'Le classi di base per la classe "{classType}" definiscono la variabile "{name}" in modo incompatibile',
        binaryOperationNotAllowed: "Operatore binario non consentito nell'espressione di tipo",
        bindParamMissing: 'Impossibile associare il metodo "{methodName}" dal momento che il parametro "self" o "cls" risulta mancante',
        bindTypeMismatch: 'Non \xE8 stato possibile associare il metodo "{methodName}" perch\xE9 non \xE8 possibile assegnare"{type}" al parametro "{paramName}"',
        breakInExceptionGroup: '"break" non consentito in un blocco "except*"',
        breakOutsideLoop: `"break" pu\xF2 essere usato solo all'interno di un ciclo`,
        bytesUnsupportedEscape: "Sequenza di escape non supportata nel valore letterale bytes",
        callableExtraArgs: 'Sono previsti solo due argomenti di tipo per "Callable"',
        callableFirstArg: 'Previsto elenco dei tipi di parametro o "..."',
        callableNotInstantiable: `Non \xE8 possibile creare un'istanza del tipo "{type}"`,
        callableSecondArg: '\xC8 previsto un tipo restituito come secondo argomento di tipo per "Callable"',
        casePatternIsIrrefutable: "Il criterio inconfutabile \xE8 consentito solo per l'ultima istruzione case",
        classAlreadySpecialized: 'Il tipo "{type}" \xE8 gi\xE0 specializzato',
        classDecoratorTypeUnknown: "L'elemento Decorator di classe non tipizzato nasconde il tipo di classe. l'elemento Decorator verr\xE0 ignorato",
        classDefinitionCycle: 'La definizione della classe per "{name}" dipende da se stessa',
        classGetItemClsParam: '__class_getitem__ override deve accettare un parametro "cls"',
        classMethodClsParam: 'I metodi di classe devono accettare un parametro "cls"',
        classNotRuntimeSubscriptable: `Il pedice per la classe "{name}" generer\xE0 un'eccezione di runtime; racchiudere l'espressione di tipo tra virgolette`,
        classPatternBuiltInArgPositional: "Il modello di classe accetta solo un sotto pattern posizionale",
        classPatternNewType: '"{type}" cannot be used in a class pattern because it is defined using NewType',
        classPatternPositionalArgCount: 'Troppi modelli posizionale per la classe "{type}"; previsto {expected} ma ottenuto {received}',
        classPatternTypeAlias: '"{type}" non pu\xF2 essere usato in uno schema di classe, perch\xE9 \xE8 un alias di tipo specializzato',
        classPropertyDeprecated: "Le propriet\xE0 della classe sono deprecate in Python 3.11 e non saranno supportate in Python 3.13",
        classTypeParametersIllegal: "La sintassi del parametro del tipo di classe richiede Python 3.12 o versione successiva",
        classVarFirstArgMissing: '\xC8 previsto un argomento tipo dopo "ClassVar"',
        classVarNotAllowed: '"ClassVar" non consentito in questo contesto',
        classVarOverridesInstanceVar: `La variabile di classe "{name}" esegue l'override della variabile di istanza con lo stesso nome nella classe "{className}"`,
        classVarTooManyArgs: 'Previsto un solo argomento tipo dopo "ClassVar"',
        classVarWithTypeVar: 'Il tipo "ClassVar" non pu\xF2 includere variabili di tipo',
        clsSelfParamTypeMismatch: 'Il tipo di parametro "{name}" deve essere un supertipo della relativa classe "{classType}"',
        codeTooComplexToAnalyze: "Il codice \xE8 troppo complesso per l'analisi. ridurre la complessit\xE0 eseguendo il refactoring in subroutine o riducendo i percorsi del codice condizionale",
        collectionAliasInstantiation: `Non \xE8 possibile creare un'istanza del tipo "{type}". In alternativa, usare "{alias}"`,
        comparisonAlwaysFalse: 'La condizione restituisce sempre False perch\xE9 i tipi "{leftType}" e "{rightType}" non si sovrappongono',
        comparisonAlwaysTrue: 'La condizione restituisce sempre True perch\xE9 i tipi "{leftType}" e "{rightType}" non si sovrappongono',
        comprehensionInDict: "Non \xE8 possibile usare la comprensione con altre voci del dizionario",
        comprehensionInSet: "Non \xE8 possibile usare la comprensione con altre voci del set",
        concatenateContext: "\u201CConcatenate\u201D non \xE8 consentito in questo contesto",
        concatenateParamSpecMissing: `L'ultimo argomento di tipo per "Concatenate" deve essere un ParamSpec o "..."`,
        concatenateTypeArgsMissing: '"Concatenate" richiede almeno due argomenti di tipo',
        conditionalOperandInvalid: 'Operando condizionale non valido di tipo "{type}"',
        constantRedefinition: '"{name}" \xE8 costante (perch\xE9 \xE8 in maiuscolo) e non pu\xF2 essere ridefinita',
        constructorParametersMismatch: 'Mancata corrispondenza tra firma di __new__ e __init__ nella classe "{classType}"',
        containmentAlwaysFalse: `L'espressione restituisce sempre False perch\xE9 i tipi "{leftType}" e "{rightType}" non si sovrappongono`,
        containmentAlwaysTrue: `L'espressione restituisce sempre True perch\xE9 i tipi "{leftType}" e "{rightType}" non si sovrappongono`,
        continueInExceptionGroup: '"continue" non consentito in un blocco "except*"',
        continueOutsideLoop: `"continue" pu\xF2 essere usato solo all'interno di un ciclo`,
        coroutineInConditionalExpression: "L'espressione condizionale fa riferimento a una coroutine che restituisce sempre True",
        dataClassBaseClassFrozen: "Una classe non bloccata non pu\xF2 ereditare da una classe bloccata",
        dataClassBaseClassNotFrozen: "Una classe bloccata non pu\xF2 ereditare da una classe non bloccata",
        dataClassConverterFunction: `L'argomento di tipo "{argType}" non \xE8 un convertitore valido per il campo "{fieldName}" di tipo "{fieldType}"`,
        dataClassConverterOverloads: 'Nessun overload di "{funcName}" \xE8 un convertitore valido per il campo "{fieldName}" di tipo "{fieldType}"',
        dataClassFieldInheritedDefault: `"{fieldName}" esegue l'override di un campo con lo stesso nome, ma manca un valore predefinito`,
        dataClassFieldWithDefault: "I campi senza valori predefiniti non possono essere visualizzati dopo i campi con valori predefiniti",
        dataClassFieldWithPrivateName: "Il campo dataclass non pu\xF2 usare un nome privato",
        dataClassFieldWithoutAnnotation: "Il campo dataclass senza annotazione del tipo causer\xE0 un'eccezione di runtime",
        dataClassPostInitParamCount: "Dataclass __post_init__ conteggio dei parametri non corretto; il numero di campi InitVar \xE8 {expected}",
        dataClassPostInitType: 'Dataclass __post_init__ tipo di parametro del metodo non corrispondente per il campo "{fieldName}"',
        dataClassSlotsOverwrite: "__slots__ \xE8 gi\xE0 definito nella classe",
        dataClassTransformExpectedBoolLiteral: "Espressione prevista che restituisce in modo statico True o False",
        dataClassTransformFieldSpecifier: '\xC8 prevista una tuple di classi o funzioni ma \xE8 stato ricevuto il tipo "{type}"',
        dataClassTransformPositionalParam: 'Tutti gli argomenti di "dataclass_transform" devono essere argomenti di parole chiave',
        dataClassTransformUnknownArgument: 'Argomento "{name}" non supportato da dataclass_transform',
        dataProtocolInSubclassCheck: "I protocolli dati (che includono attributi non di metodo) non sono consentiti nelle chiamate issubclass",
        declaredReturnTypePartiallyUnknown: 'Il tipo restituito dichiarato "{returnType}" \xE8 parzialmente sconosciuto',
        declaredReturnTypeUnknown: "Il tipo restituito dichiarato \xE8 sconosciuto",
        defaultValueContainsCall: "Chiamate di funzione e oggetti modificabili non consentiti all'interno dell'espressione del valore predefinito del parametro",
        defaultValueNotAllowed: 'Il parametro con "*" o "**" non pu\xF2 avere un valore predefinito',
        delTargetExpr: "Non \xE8 possibile eliminare l'espressione",
        deprecatedClass: 'La classe "{name}" \xE8 deprecata',
        deprecatedConstructor: 'Il costruttore per la classe "{name}" \xE8 deprecato',
        deprecatedDescriptorDeleter: 'Il metodo "__delete__" per il descrittore "{name}" \xE8 deprecato',
        deprecatedDescriptorGetter: 'Il metodo "__get__" per il descrittore "{name}" \xE8 deprecato',
        deprecatedDescriptorSetter: 'Il metodo "__set__" per il descrittore "{name}" \xE8 deprecato',
        deprecatedFunction: 'La funzione "{name}" \xE8 deprecata',
        deprecatedMethod: 'Il metodo "{name}" nella classe "{className}" \xE8 deprecato',
        deprecatedPropertyDeleter: 'Il deleter per la property "{name}" \xE8 deprecato',
        deprecatedPropertyGetter: 'Il getter per la property "{name}" \xE8 deprecato',
        deprecatedPropertySetter: 'Il setter per la property "{name}" \xE8 deprecato',
        deprecatedType: 'Questo tipo \xE8 deprecato a partire da Python {version}; usa "{replacement}"',
        dictExpandIllegalInComprehension: "Espansione del dizionario non consentita nella comprensione",
        dictInAnnotation: "Espressione dizionario non consentita nell'espressione di tipo",
        dictKeyValuePairs: "Le voci del dizionario devono contenere coppie chiave-valore",
        dictUnpackIsNotMapping: "Mapping previsto per l'operatore di decompressione del dizionario",
        dunderAllSymbolNotPresent: '"{name}" \xE8 specificato in __all__ ma non \xE8 presente nel modulo',
        duplicateArgsParam: '\xC8 consentito un solo parametro "*"',
        duplicateBaseClass: "Classe di base duplicata non consentita",
        duplicateCapturePatternTarget: `La destinazione di acquisizione "{name}" non pu\xF2 comparire pi\xF9 di una volta all'interno dello stesso schema`,
        duplicateCatchAll: "\xC8 consentita una sola clausola catch-all except",
        duplicateEnumMember: 'Il membro di Enum "{name}" \xE8 gi\xE0 dichiarato',
        duplicateGenericAndProtocolBase: "\xC8 consentita una sola classe di base Generic[...] o Protocol[...]",
        duplicateImport: '"{importName}" \xE8 stato importato pi\xF9 di una volta',
        duplicateKeywordOnly: '\xC8 consentito un solo separatore "*"',
        duplicateKwargsParam: '\xC8 consentito un solo parametro "**"',
        duplicateParam: '\u201C{name}" parametro duplicato',
        duplicatePositionOnly: '\xC8 consentito un solo parametro "/"',
        duplicateStarPattern: 'In una sequenza di criteri \xE8 consentito un solo criterio "*"',
        duplicateStarStarPattern: '\xC8 consentita una sola voce "**"',
        duplicateUnpack: "Nell list \xE8 consentita una sola operazione di decompressione",
        ellipsisAfterUnpacked: '"..." non pu\xF2 essere usato con un argomento TypeVarTuple non compresso o tuple',
        ellipsisContext: '"..." non \xE8 consentito in questo contesto',
        ellipsisSecondArg: '"..." \xE8 consentito solo come secondo di due argomenti',
        enumClassOverride: 'La classe di Enum "{name}" \xE8 finale e non pu\xF2 essere sottoclassificata',
        enumMemberDelete: 'Non \xE8 possibile eliminare il membro di Enum "{name}"',
        enumMemberSet: 'Non \xE8 possibile assegnare il membro di Enum "{name}"',
        enumMemberTypeAnnotation: "Le annotazioni di tipo non sono consentite per i membri di enumerazione",
        exceptGroupMismatch: `L'istruzione Try non pu\xF2 includere sia "except" che "except*"`,
        exceptGroupRequiresType: 'La sintassi del gruppo di eccezioni ("except*") richiede un tipo di eccezione',
        exceptRequiresParens: "Multiple exception types must be parenthesized prior to Python 3.14",
        exceptWithAsRequiresParens: 'Multiple exception types must be parenthesized when using "as"',
        exceptionGroupIncompatible: 'La sintassi del gruppo di eccezioni ("except*") richiede Python 3.11 o versione successiva',
        exceptionGroupTypeIncorrect: "Il tipo di eccezione in except* non pu\xF2 derivare da BaseGroupException",
        exceptionTypeIncorrect: '"{type}" non deriva da BaseException',
        exceptionTypeNotClass: '"{type}" non \xE8 una classe di eccezione valida',
        exceptionTypeNotInstantiable: 'Il costruttore per il tipo di eccezione "{type}" richiede uno o pi\xF9 argomenti',
        expectedAfterDecorator: "Dichiarazione di funzione o classe prevista dopo l\u2019elemento Decorator",
        expectedArrow: `Previsto "->" seguito da un'annotazione di tipo restituito`,
        expectedAsAfterException: 'Previsto "as" dopo il tipo di eccezione',
        expectedAssignRightHandExpr: 'Espressione prevista a destra di "="',
        expectedBinaryRightHandExpr: "Espressione prevista a destra dell'operatore",
        expectedBoolLiteral: "\xC8 previsto True o False",
        expectedCase: 'Prevista istruzione "case"',
        expectedClassName: "Nome classe previsto",
        expectedCloseBrace: '"{" non \xE8 stato chiuso',
        expectedCloseBracket: '"[" non \xE8 stato chiuso',
        expectedCloseParen: '"(" non \xE8 stato chiuso',
        expectedColon: 'Previsto ":"',
        expectedComplexNumberLiteral: "\xC8 previsto un valore letterale di numero complesso per i criteri di ricerca",
        expectedDecoratorExpr: "Il modulo dell'espressione non \xE8 supportato per l'elemento Decorator precedente a Python 3.9",
        expectedDecoratorName: "\xC8 previsto un nome di elemento Decorator",
        expectedDecoratorNewline: "Prevista nuova riga alla fine dell'elemento Decorator",
        expectedDelExpr: 'Espressione prevista dopo "del"',
        expectedElse: 'Previsto "else"',
        expectedEquals: 'Previsto "="',
        expectedExceptionClass: "Classe od oggetto di eccezione non valido",
        expectedExceptionObj: "Previsto oggetto eccezione, classe eccezione o None",
        expectedExpr: "Espressione prevista",
        expectedFunctionAfterAsync: 'Prevista definizione di funzione dopo "async"',
        expectedFunctionName: '\xC8 previsto un nome di funzione dopo "def"',
        expectedIdentifier: "Identificatore previsto",
        expectedImport: 'Previsto "import"',
        expectedImportAlias: 'Simbolo previsto dopo "as"',
        expectedImportSymbols: "Sono previsti uno o pi\xF9 nomi di simboli dopo \u201Cimport\u201D",
        expectedIn: "previsto 'in'",
        expectedInExpr: 'Espressione prevista dopo "in"',
        expectedIndentedBlock: "Previsto un blocco rientrato",
        expectedMemberName: `Nome dell'attributo previsto dopo "."`,
        expectedModuleName: "Nome del modulo previsto",
        expectedNameAfterAs: '\xC8 previsto il nome del simbolo dopo "as"',
        expectedNamedParameter: 'Il parametro della parola chiave deve seguire "*"',
        expectedNewline: "Prevista nuova riga",
        expectedNewlineOrSemicolon: "Le istruzioni devono essere separate da nuove righe o punti e virgola",
        expectedOpenParen: 'Previsto "("',
        expectedParamName: "Nome del parametro previsto",
        expectedPatternExpr: "Espressione del criterio prevista",
        expectedPatternSubjectExpr: "Prevista espressione del soggetto del criterio",
        expectedPatternValue: 'Espressione del valore del criterio prevista nel formato "a.b"',
        expectedReturnExpr: 'Espressione prevista dopo "return"',
        expectedSliceIndex: "Prevista espressione di indice o sezione",
        expectedTypeNotString: "\xC8 previsto un tipo ma \xE8 stato ricevuto un valore letterale stringa",
        expectedTypeParameterName: "Nome del parametro del tipo previsto",
        expectedYieldExpr: "Espressione prevista nell'istruzione yield",
        finalClassIsAbstract: 'La classe "{type}" \xE8 contrassegnata come finale e deve implementare tutti i simboli astratti',
        finalContext: '"Finale" non \xE8 consentito in questo contesto',
        finalInLoop: `Non \xE8 possibile assegnare una variabile "Final" all'interno di un ciclo`,
        finalMethodOverride: `Il metodo "{name}" non pu\xF2 eseguire l'override del metodo finale definito nella classe "{className}"`,
        finalNonMethod: "Impossibile contrassegnare la funzione \u201C{name}\u201D @final perch\xE9 non \xE8 un metodo",
        finalReassigned: '"{name}" \xE8 dichiarato come Finale e non pu\xF2 essere riassegnato',
        finalRedeclaration: '"{name}" \xE8 stato dichiarato in precedenza come Finale',
        finalRedeclarationBySubclass: 'Non \xE8 possibile ridichiarare "{name}" perch\xE9 la classe padre "{className}" la dichiara come Finale',
        finalTooManyArgs: 'Previsto un singolo argomento tipo dopo "Final"',
        finalUnassigned: '"{name}" \xE8 dichiarato Final, ma il valore non \xE8 assegnato',
        finallyBreak: 'Non \xE8 possibile utilizzare "break" per uscire da un blocco "finally"',
        finallyContinue: 'Non \xE8 possibile utilizzare "continue" per uscire da un blocco "finally"',
        finallyReturn: 'Non \xE8 possibile utilizzare "return" per uscire da un blocco "finally"',
        formatStringBrace: "Parentesi graffa di chiusura singola non consentita all'interno del valore letterale f-string; usa parentesi graffa chiusa doppia",
        formatStringBytes: "I valori letterali stringa di formato (f-string) non possono essere binari",
        formatStringDebuggingIllegal: 'L\u2019identificatore di debug delle stringhe F "=" richiede Python 3.8 o versione successiva',
        formatStringEscape: "Sequenza di escape (barra rovesciata) non consentita nella porzione di espressione di f-string prima di Python 3.12",
        formatStringExpectedConversion: '\xC8 previsto un identificatore di conversione dopo "!" in f-string',
        formatStringIllegal: "I valori letterali stringa di formato (f-string) richiedono Python 3.6 o versione successiva",
        formatStringInPattern: "Stringa di formato non consentita nel criterio",
        formatStringNestedFormatSpecifier: "Espressioni annidate troppo in profondit\xE0 nell'identificatore di stringa di formato",
        formatStringNestedQuote: "Le stringhe annidate all'interno di una stringa f non possono usare lo stesso carattere virgolette della stringa f prima di Python 3.12",
        formatStringTemplate: "Format string literals (f-strings) cannot also be template strings (t-strings)",
        formatStringUnicode: "I valori letterali stringa di formato (f-string) non possono essere unicode",
        formatStringUnterminated: 'Espressione senza terminazione in f-string; previsto "}".',
        functionDecoratorTypeUnknown: "L'elemento Decorator della funzione non tipizzato nasconde il tipo di funzione; l'elemento Decorator verr\xE0 ignorato",
        functionInConditionalExpression: "L'espressione condizionale fa riferimento a una funzione che restituisce sempre True",
        functionTypeParametersIllegal: "La sintassi del parametro del tipo di funzione richiede Python 3.12 o versione successiva",
        futureImportLocationNotAllowed: "Le importazioni da __future__ devono trovarsi all'inizio del file",
        generatorAsyncReturnType: 'Il tipo restituito della funzione del generatore async deve essere compatibile con "AsyncGenerator[{yieldType}, Any]"',
        generatorNotParenthesized: "Le espressioni del generatore devono essere racchiuse tra parentesi se non \xE8 l'unico argomento",
        generatorSyncReturnType: 'Il tipo restituito della funzione del generatore deve essere compatibile con "Generator[{yieldType}, Any, Any]"',
        genericBaseClassNotAllowed: 'Non \xE8 possibile usare la classe di base "Generic" con la sintassi del parametro di tipo',
        genericClassAssigned: "Non \xE8 possibile assegnare il tipo di classe generico",
        genericClassDeleted: "Non \xE8 possibile eliminare il tipo di classe generico",
        genericInstanceVariableAccess: "L'accesso alla variabile di istanza generica tramite la classe \xE8 ambiguo",
        genericNotAllowed: '"Generic" non valido in questo contesto',
        genericTypeAliasBoundTypeVar: "L'alias di tipo generico all'interno della classe non pu\xF2 usare variabili di tipo associate {names}",
        genericTypeArgMissing: '"Generico" richiede almeno un argomento di tipo',
        genericTypeArgTypeVar: `L'argomento di tipo per "Generic" deve essere una variabile di tipo`,
        genericTypeArgUnique: 'Gli argomenti di tipo per "Generic" devono essere univoci',
        globalReassignment: '"{name}" \xE8 assegnato prima della dichiarazione globale',
        globalRedefinition: '"{name}" \xE8 gi\xE0 stato dichiarato globale',
        implicitStringConcat: "Concatenazione implicita di stringhe non consentita",
        importCycleDetected: "Ciclo rilevato nella catena di importazione",
        importDepthExceeded: "La profondit\xE0 della catena di importazione ha superato {depth}",
        importResolveFailure: `Non \xE8 stato possibile risolvere l'importazione "{importName}"`,
        importSourceResolveFailure: `Non \xE8 stato possibile risolvere l'importazione "{importName}" dall\u2019origine`,
        importSymbolUnknown: '"{name}" \xE8 un simbolo di importazione sconosciuto',
        incompatibleMethodOverride: `Il metodo "{name}" esegue l'override della classe "{className}" in modo incompatibile`,
        inconsistentIndent: "Il valore dell'annullamento del rientro non corrisponde al rientro precedente",
        inconsistentTabs: "Uso incoerente di tabulazioni e spazi nel rientro",
        initMethodSelfParamTypeVar: `L'annotazione di tipo per il parametro "self" del metodo "__init__" non pu\xF2 contenere variabili di tipo con ambito classe`,
        initMustReturnNone: 'Il tipo restituito di "__init__" deve essere None',
        initSubclassCallFailed: "Argomenti di parola chiave non corretti per il metodo __init_subclass__",
        initSubclassClsParam: '__init_subclass__ override deve accettare un parametro "cls"',
        initVarNotAllowed: '"InitVar" non consentito in questo contesto',
        instanceMethodSelfParam: 'I metodi di istanza devono accettare un parametro "self"',
        instanceVarOverridesClassVar: `La variabile di istanza "{name}" esegue l'override della variabile di classe con lo stesso nome nella classe "{className}"`,
        instantiateAbstract: `Non \xE8 possibile creare un'istanza di classe astratta "{type}"`,
        instantiateProtocol: `Non \xE8 possibile creare un'istanza della classe Protocol "{type}"`,
        internalBindError: `Errore interno durante l'associazione del file "{file}": {message}`,
        internalParseError: `Si \xE8 verificato un errore interno durante l'analisi del file "{file}": {message}`,
        internalTypeCheckingError: 'Errore interno durante il controllo del tipo del file "{file}": {message}',
        invalidIdentifierChar: "Carattere non valido nell'identificatore",
        invalidStubStatement: "L'istruzione non ha significato all'interno di un file stub di tipo",
        invalidTokenChars: 'Carattere non valido "{text}" nel token',
        isInstanceInvalidType: 'Il secondo argomento di "isinstance" deve essere una classe o una tuple di classi',
        isSubclassInvalidType: 'Il secondo argomento di "issubclass" deve essere una classe o una tuple di classi',
        keyValueInSet: "Le coppie chiave-valore non sono consentite all'interno di un set",
        keywordArgInTypeArgument: "Gli argomenti delle parole chiave non possono essere usati negli elenchi di argomenti tipo",
        keywordOnlyAfterArgs: 'Separatore di argomenti solo parola chiave non consentito dopo il parametro "*"',
        keywordParameterMissing: 'Uno o pi\xF9 parametri di parole chiave devono seguire il parametro "*"',
        keywordSubscriptIllegal: "Gli argomenti delle parole chiave all'interno di pedici non sono supportati",
        lambdaReturnTypePartiallyUnknown: `Il tipo restituito dell'espressione lambda "{returnType}" \xE8 parzialmente sconosciuto`,
        lambdaReturnTypeUnknown: "Il tipo restituito di lambda \xE8 sconosciuto",
        listAssignmentMismatch: `Non \xE8 possibile assegnare l'espressione con tipo "{type}" all'elenco di destinazione`,
        listInAnnotation: "Espressione List non consentita nell'espressione type",
        literalEmptyArgs: 'Sono previsti uno o pi\xF9 argomenti di tipo dopo "Literal"',
        literalNamedUnicodeEscape: 'Le sequenze di escape Unicode denominate non sono supportate nelle annotazioni stringa "Literal"',
        literalNotAllowed: 'Non \xE8 possibile usare "Literal" in questo contesto senza un argomento tipo',
        literalNotCallable: "Non \xE8 possibile creare un'istanza del tipo Literal",
        literalUnsupportedType: 'Gli argomenti di tipo per "Literal" devono essere None, un valore letterale (int, bool, str o bytes) o un valore di enumerazione',
        matchIncompatible: "Le istruzioni match richiedono Python 3.10 o versione successiva",
        matchIsNotExhaustive: "I case all'interno dell'istruzione match non gestiscono in modo completo tutti i valori",
        maxParseDepthExceeded: "\xC8 stata superata la profondit\xE0 massima di analisi; suddividere l'espressione in sottoespressioni pi\xF9 piccole",
        memberAccess: `Non \xE8 possibile accedere all'attributo "{name}" per la classe "{type}"`,
        memberDelete: `Non \xE8 possibile eliminare l'attributo "{name}" per la classe "{type}"`,
        memberSet: `Non \xE8 possibile assegnare all'attributo "{name}" per la classe "{type}"`,
        metaclassConflict: "La metaclasse di una classe derivata deve essere una sottoclasse delle metaclassi di tutte le relative classi di base",
        metaclassDuplicate: "\xC8 possibile specificare una sola metaclasse",
        metaclassIsGeneric: "La metaclasse non pu\xF2 essere generica",
        methodNotDefined: 'Metodo "{name}" non definito',
        methodNotDefinedOnType: '"{name}" metodo non definito nel tipo "{type}"',
        methodOrdering: "Non \xE8 possibile creare un ordinamento coerente del metodo",
        methodOverridden: `"{name}" esegue l'override del metodo con lo stesso nome nella classe "{className}" con un tipo non compatibile "{type}".`,
        methodReturnsNonObject: 'Il metodo "{name}" non restituisce un oggetto',
        missingSuperCall: 'Il metodo "{methodName}" non chiama il metodo con lo stesso nome nella classe padre',
        mixingBytesAndStr: "Bytes e valori str non possono essere concatenati",
        moduleAsType: "Il modulo non pu\xF2 essere usato come tipo",
        moduleNotCallable: "Modulo non chiamabile",
        moduleUnknownMember: '"{memberName}" non \xE8 un attributo noto del modulo "{moduleName}"',
        namedExceptAfterCatchAll: "Una clausola except denominata non pu\xF2 trovarsi dopo la clausola catch-all except",
        namedParamAfterParamSpecArgs: 'Il parametro della parola chiave "{name}" non pu\xF2 essere visualizzato nella firma dopo il parametro ParamSpec args',
        namedTupleEmptyName: "I nomi all'interno di un tuple denominato non possono essere vuoti",
        namedTupleEntryRedeclared: `Non \xE8 possibile eseguire l'override di "{name}" perch\xE9 la classe padre "{className}" \xE8 un tuple denominato`,
        namedTupleFieldUnderscore: "I nomi dei campi di una \u201CNamed tuple\u201D non possono iniziare con un carattere di sottolineatura",
        namedTupleFirstArg: "\xC8 previsto il nome della classe di tuple denominata come primo argomento",
        namedTupleMultipleInheritance: "L'ereditariet\xE0 multipla con NamedTuple non \xE8 supportata",
        namedTupleNameKeyword: "I nomi dei campi non possono essere una parola chiave",
        namedTupleNameType: "\xC8 prevista una tuple a due voci che specifica il nome e il tipo della voce",
        namedTupleNameUnique: "I nomi all'interno di una tuple denominata devono essere univoci",
        namedTupleNoTypes: '"namedtuple" non fornisce tipi per le voci di tuple; usare invece "NamedTuple"',
        namedTupleSecondArg: "\xC8 previsto un list di voci di tuple denominate come secondo argomento",
        newClsParam: '__new__ override deve accettare un parametro "cls"',
        newTypeAnyOrUnknown: "Il secondo argomento di NewType deve essere una classe nota, non Any o Unknown",
        newTypeBadName: "Il primo argomento di NewType deve essere un valore letterale stringa",
        newTypeLiteral: "Non \xE8 possibile usare NewType con il tipo Literal",
        newTypeNameMismatch: "NewType deve essere assegnato a una variabile con lo stesso nome",
        newTypeNotAClass: "Classe prevista come secondo argomento di NewType",
        newTypeParamCount: "NewType richiede due argomenti posizionali",
        newTypeProtocolClass: "Non \xE8 possibile usare NewType con il tipo strutturale (una classe Protocol o TypedDict)",
        noOverload: 'Nessun overload per "{name}" corrisponde agli argomenti specificati',
        noReturnContainsReturn: `La funzione con tipo return dichiarato "NoReturn" non pu\xF2 includere un'istruzione return`,
        noReturnContainsYield: `La funzione con il tipo restituito dichiarato "NoReturn" non pu\xF2 includere un'istruzione yield`,
        noReturnReturnsNone: 'La funzione con tipo restituito dichiarato "NoReturn" non pu\xF2 restituire "None"',
        nonDefaultAfterDefault: "L'argomento non predefinito segue l'argomento predefinito",
        nonLocalInModule: "Dichiarazione nonlocale non consentita a livello di modulo",
        nonLocalNoBinding: 'Non \xE8 stata trovata alcuna associazione per "{name}" nonlocal',
        nonLocalReassignment: '"{name}" viene assegnato prima della dichiarazione nonlocal',
        nonLocalRedefinition: '"{name}" \xE8 gi\xE0 stato dichiarato nonlocal',
        noneNotCallable: `Non \xE8 possibile chiamare l'oggetto di tipo "None"`,
        noneNotIterable: `Impossibile utilizzare l'oggetto di tipo "None" come valore iterabile`,
        noneNotSubscriptable: `L'oggetto di tipo "None" non \xE8 sottoponibile a pedice`,
        noneNotUsableWith: 'Object of type "None" cannot be used with "with"',
        noneNotUsableWithAsync: `Impossibile utilizzare l'oggetto di tipo "None" con "async with"`,
        noneOperator: 'Operatore "{operator}" non supportato per "None"',
        noneUnknownMember: '"{name}" non \xE8 un attributo noto di "None"',
        nonlocalTypeParam: `Non \xE8 consentita l'associazione nonlocal per il parametro di tipo "{name}"`,
        notRequiredArgCount: 'Previsto un singolo argomento tipo dopo "NotRequired"',
        notRequiredNotInTypedDict: '"NotRequired" non \xE8 consentito in questo contesto',
        objectNotCallable: `L'oggetto di tipo "{type}" non \xE8 chiamabile`,
        obscuredClassDeclaration: 'La dichiarazione di classe "{name}" \xE8 oscurata da una dichiarazione con lo stesso nome',
        obscuredFunctionDeclaration: 'La dichiarazione della funzione "{name}" \xE8 oscurata da una dichiarazione con lo stesso nome',
        obscuredMethodDeclaration: 'La dichiarazione del metodo "{name}" \xE8 oscurata da una dichiarazione con lo stesso nome',
        obscuredParameterDeclaration: 'La dichiarazione del parametro "{name}" \xE8 oscurata da una dichiarazione con lo stesso nome',
        obscuredTypeAliasDeclaration: `La dichiarazione dell'alias di tipo "{name}" \xE8 nascosta da una dichiarazione con lo stesso nome`,
        obscuredVariableDeclaration: 'La dichiarazione "{name}" \xE8 oscurata da una dichiarazione con lo stesso nome',
        operatorLessOrGreaterDeprecated: `L'operatore "<>" non \xE8 supportato in Python 3. Usare invece "!="`,
        optionalExtraArgs: '\xC8 previsto un argomento di tipo dopo "Optional"',
        orPatternIrrefutable: 'Criterio inconfutabile consentito solo come ultimo criterio secondario in un criterio "or"',
        orPatternMissingName: `Tutti i criteri secondari all'interno di un criterio "or" devono avere come destinazione gli stessi nomi`,
        overlappingKeywordArgs: "Il dizionario tipizzato si sovrappone al parametro della parola chiave: {names}",
        overlappingOverload: `L'overload {obscured} per "{name}" non verr\xE0 mai usato perch\xE9 i parametri si sovrappongono all'overload {obscuredBy}`,
        overloadAbstractImplMismatch: "Gli overload devono corrispondere allo stato astratto dell'implementazione",
        overloadAbstractMismatch: "Gli overload devono essere tutti astratti o no",
        overloadClassMethodInconsistent: 'Gli overload per "{name}" usano @classmethod in modo incoerente',
        overloadFinalImpl: "@final'elemento Decorator deve essere applicato solo all'implementazione",
        overloadFinalNoImpl: "Solo il primo overload deve essere contrassegnato @final",
        overloadImplementationMismatch: "L'implementazione di overload non \xE8 coerente con la firma dell'overload {index}",
        overloadOverrideImpl: "@override'elemento Decorator deve essere applicato solo all'implementazione",
        overloadOverrideNoImpl: "Solo il primo overload deve essere contrassegnato @override",
        overloadReturnTypeMismatch: `L'overload {prevIndex} per "{name}" si sovrappone all'overload {newIndex} e restituisce un tipo incompatibile`,
        overloadStaticMethodInconsistent: 'Gli overload per "{name}" usano @staticmethod in modo incoerente',
        overloadWithoutImplementation: '"{name}" \xE8 contrassegnato come overload, ma non viene fornita alcuna implementazione',
        overriddenMethodNotFound: 'Il metodo "{name}" \xE8 contrassegnato come override, ma non \xE8 presente alcun metodo di base con lo stesso nome',
        overrideDecoratorMissing: `Il metodo "{name}" non \xE8 contrassegnato come override, ma esegue l'override di un metodo nella classe "{className}"`,
        paramAfterKwargsParam: 'Il parametro non pu\xF2 seguire il parametro "**"',
        paramAlreadyAssigned: 'Il parametro "{name}" \xE8 gi\xE0 assegnato',
        paramAnnotationMissing: 'Annotazione di tipo mancante per il parametro "{name}"',
        paramAssignmentMismatch: `Non \xE8 possibile assegnare l'espressione di tipo "{sourceType}" al parametro di tipo "{paramType}"`,
        paramNameMissing: 'Nessun parametro denominato "{name}"',
        paramSpecArgsKwargsDuplicate: 'Gli argomenti per ParamSpec "{type}" sono gi\xE0 stati specificati',
        paramSpecArgsKwargsUsage: `Gli attributi "args" e "kwargs" di ParamSpec devono essere entrambi visualizzati all'interno di una firma di funzione`,
        paramSpecArgsMissing: 'Gli argomenti per ParamSpec "{type}" sono mancanti',
        paramSpecArgsUsage: `L'attributo "args" di ParamSpec \xE8 valido solo se usato con il parametro *args`,
        paramSpecAssignedName: 'ParamSpec deve essere assegnato a una variabile denominata "{name}"',
        paramSpecContext: "ParamSpec non \xE8 consentito in questo contesto",
        paramSpecDefaultNotTuple: "Sono previsti puntini di sospensione, un'espressione di tuple o ParamSpec per il valore predefinito di ParamSpec",
        paramSpecFirstArg: "Nome previsto di ParamSpec come primo argomento",
        paramSpecKwargsUsage: `L'attributo "kwargs" di ParamSpec \xE8 valido solo se usato con il parametro **kwargs`,
        paramSpecNotUsedByOuterScope: 'ParamSpec "{name}" non ha significato in questo contesto',
        paramSpecUnknownArg: "ParamSpec non supporta pi\xF9 di un argomento",
        paramSpecUnknownMember: '"{name}" non \xE8 un attributo noto di ParamSpec',
        paramSpecUnknownParam: '"{name}" \xE8 un parametro sconosciuto per ParamSpec',
        paramTypeCovariant: "Non \xE8 possibile usare la variabile di tipo covariante nel tipo di parametro",
        paramTypePartiallyUnknown: 'Tipo di parametro "{paramName}" parzialmente sconosciuto',
        paramTypeUnknown: 'Tipo di parametro "{paramName}" sconosciuto',
        parenthesizedContextManagerIllegal: 'Parentheses within "with" statement requires Python 3.9 or newer',
        patternNeverMatches: 'Il criterio non verr\xE0 mai confrontato per il tipo di oggetto "{type}"',
        positionArgAfterNamedArg: "L'argomento posizionale non pu\xF2 essere visualizzato dopo gli argomenti della parola chiave",
        positionArgAfterUnpackedDictArg: "L'argomento posizionale non pu\xF2 essere visualizzato dopo la decompressione degli argomenti della parola chiave",
        positionOnlyAfterArgs: 'Separatore di parametri di sola posizione non consentito dopo il parametro "*"',
        positionOnlyAfterKeywordOnly: 'Il parametro "/" deve essere visualizzato prima del parametro "*"',
        positionOnlyAfterNon: "Il parametro di sola posizione non \xE8 consentito dopo un parametro che non \xE8 di sola posizione",
        positionOnlyFirstParam: "Separatore di argomenti di sola posizione non consentito come primo parametro",
        positionOnlyIncompatible: "Il separatore di parametri di sola posizione richiede Python 3.8 o versione successiva",
        privateImportFromPyTypedModule: '"{name}" non \xE8 esportato dal modulo "{module}"',
        privateUsedOutsideOfClass: `"{name}" \xE8 privato e utilizzato all'esterno del modulo in cui \xE8 dichiarato`,
        privateUsedOutsideOfModule: `"{name}" \xE8 privato e utilizzato all'esterno del modulo in cui \xE8 dichiarato`,
        propertyOverridden: '"{name}" esegue erroneamente l\u2019override di una property con lo stesso nome nella classe "{className}"',
        propertyStaticMethod: "Metodi statici non consentiti per getter, setter o deleter di property",
        protectedUsedOutsideOfClass: '"{name}" \xE8 protetto e usato al di fuori della classe in cui \xE8 dichiarato',
        protocolBaseClass: 'La classe Protocol "{classType}" non pu\xF2 derivare dalla classe non Protocol "{baseType}"',
        protocolBaseClassWithTypeArgs: "Gli argomenti tipo non sono consentiti con la classe Protocollo quando si usa la sintassi dei parametri tipo",
        protocolIllegal: `L'uso di "Protocol" richiede Python 3.7 o versione successiva`,
        protocolNotAllowed: '"Protocol" non pu\xF2 essere usato in questo contesto',
        protocolTypeArgMustBeTypeParam: `L'argomento di tipo per "Protocol" deve essere un parametro di tipo`,
        protocolUnsafeOverlap: 'La classe si sovrappone a "{name}" in modo non sicuro e pu\xF2 produrre una corrispondenza in fase di esecuzione',
        protocolVarianceContravariant: 'La variabile di tipo "{variable}" usata in "{class}" Protocol generico deve essere controvariante',
        protocolVarianceCovariant: 'La variabile di tipo "{variable}" usata in "{class}" Protocol generico deve essere covariante',
        protocolVarianceInvariant: 'La variabile di tipo "{variable}" usata in "{class}" Protocol generico deve essere invariante',
        pyrightCommentInvalidDiagnosticBoolValue: 'La direttiva di commento Pyright deve essere seguita da "=" e da un valore true o false',
        pyrightCommentInvalidDiagnosticSeverityValue: 'La direttiva di commento Pyright deve essere seguita da "=" e da un valore true, false, error, warning, information o none',
        pyrightCommentMissingDirective: "Il commento Pyright deve essere seguito da una direttiva (basic o strict) o da una regola di diagnostica",
        pyrightCommentNotOnOwnLine: "I commenti Pyright usati per controllare le impostazioni a livello di file devono essere visualizzati nella propria riga",
        pyrightCommentUnknownDiagnosticRule: '"{rule}" \xE8 una regola di diagnostica sconosciuta per il commento pyright',
        pyrightCommentUnknownDiagnosticSeverityValue: '"{value}" non \xE8 un valore valido per il commento pyright; previsto true, false, error, warning, information o none',
        pyrightCommentUnknownDirective: '"{directive}" is an unknown directive for pyright comment; expected "strict", "standard", or "basic"',
        readOnlyArgCount: 'Previsto un singolo argomento tipo dopo "ReadOnly"',
        readOnlyNotInTypedDict: '"ReadOnly" non consentito in questo contesto',
        recursiveDefinition: 'Non \xE8 stato possibile determinare il tipo di "{name}" perch\xE9 fa riferimento a se stesso',
        relativeImportNotAllowed: 'Le importazioni relative non possono essere usate con il modulo "import .a". Usare invece "from . import a"',
        requiredArgCount: '\xC8 previsto un singolo argomento di tipo dopo "Required"',
        requiredNotInTypedDict: '"Required" non \xE8 consentito in questo contesto',
        returnInAsyncGenerator: "L\u2019istruzione return con valore non \xE8 consentita nel generatore async",
        returnInExceptionGroup: '"return" non consentito in un blocco "except*"',
        returnMissing: 'La funzione con tipo restituito dichiarato "{returnType}" deve restituire un valore in tutti i percorsi di codice',
        returnOutsideFunction: `"return" pu\xF2 essere usata solo all'interno di una funzione.`,
        returnTypeContravariant: "Non \xE8 possibile usare la variabile di tipo controvariante nel tipo restituito",
        returnTypeMismatch: 'Il tipo "{exprType}" non \xE8 assegnabile al tipo restituito "{returnType}"',
        returnTypePartiallyUnknown: 'Il tipo restituito "{returnType}" \xE8 parzialmente sconosciuto',
        returnTypeUnknown: "Il tipo restituito \xE8 sconosciuto",
        revealLocalsArgs: 'Non \xE8 previsto alcun argomento per la chiamata "reveal_locals"',
        revealLocalsNone: "Non sono presenti variabili locals in questo ambito",
        revealTypeArgs: 'Previsto un singolo argomento posizionale per la chiamata "reveal_type"',
        revealTypeExpectedTextArg: `L'argomento "expected_text" per la funzione "reveal_type" deve essere un valore letterale str`,
        revealTypeExpectedTextMismatch: 'Testo di tipo non corrispondente; previsto "{expected}" ma ricevuto "{received}"',
        revealTypeExpectedTypeMismatch: 'Tipo non corrispondente; previsto "{expected}" ma ricevuto "{received}"',
        selfTypeContext: '"Self" non \xE8 valido in questo contesto',
        selfTypeMetaclass: "Impossibile utilizzare \u201CSelf\u201D all'interno di una metaclasse (una sottoclasse di \u201Ctype\u201D)",
        selfTypeWithTypedSelfOrCls: `Non \xE8 possibile usare "Self" in una funzione con un parametro 'self' o 'cls' con un'annotazione di tipo diversa da "Self"`,
        sentinelBadName: "The first argument to Sentinel must be a string literal",
        sentinelNameMismatch: "Sentinel must be assigned to a variable with the same name",
        sentinelParamCount: "Sentinel requires one positional argument",
        setterGetterTypeMismatch: "Il tipo di valore del setter di Property non \xE8 assegnabile al tipo restituito del getter",
        singleOverload: '"{name}" \xE8 contrassegnato come overload, ma mancano altri overload',
        slotsAttributeError: '"{name}" non \xE8 specificato in __slots__',
        slotsClassVarConflict: '"{name}" \xE8 in conflitto con la variabile di istanza dichiarata in __slots__',
        starPatternInAsPattern: 'Il modello a stella non pu\xF2 essere usato con la destinazione "as"',
        starPatternInOrPattern: "Il modello a stella non pu\xF2 essere ORed all'interno di altri modelli",
        starStarWildcardNotAllowed: '** non pu\xF2 essere usato con il carattere jolly "_"',
        staticClsSelfParam: 'I metodi statici non devono accettare un parametro "self" o "cls"',
        stringNonAsciiBytes: "Carattere non ASCII non consentito nel valore letterale stringa dei byte",
        stringNotSubscriptable: "L'espressione stringa non pu\xF2 essere in pedice nell'espressione di tipo. Racchiudere l'intera espressione tra virgolette",
        stringUnsupportedEscape: "Sequenza di escape non supportata nel valore letterale stringa",
        stringUnterminated: "Il valore letterale stringa non \xE8 terminato",
        stubFileMissing: 'File di stub non trovato per "{importName}"',
        stubUsesGetAttr: 'Il file dello stub di tipo \xE8 incompleto; "__getattr__" nasconde gli errori di tipo per il modulo',
        sublistParamsIncompatible: "I parametri di sublist non sono supportati in Python 3.x",
        superCallArgCount: 'Non sono previsti pi\xF9 di due argomenti per la chiamata "super".',
        superCallFirstArg: '\xC8 previsto un tipo di classe come primo argomento della chiamata "super", ma \xE8 stato ricevuto "{type}"',
        superCallSecondArg: 'Il secondo argomento della chiamata "super" deve essere un oggetto o una classe che deriva da "{type}"',
        superCallZeroArgForm: `Il modulo zero-argument della chiamata "super" \xE8 valido solo all'interno di un metodo`,
        superCallZeroArgFormStaticMethod: `Il modulo zero-argument della chiamata "super" non \xE8 valido all'interno di un metodo statico`,
        symbolIsPossiblyUnbound: '"{name}" potrebbe non essere associato',
        symbolIsUnbound: '"{name}" non associato',
        symbolIsUndefined: '"{name}" non \xE8 definito',
        symbolOverridden: `"{name}" esegue l'override del simbolo con lo stesso nome nella classe "{className}"`,
        templateStringBytes: "Template string literals (t-strings) cannot be binary",
        templateStringIllegal: "Template string literals (t-strings) require Python 3.14 or newer",
        templateStringUnicode: "Template string literals (t-strings) cannot be unicode",
        ternaryNotAllowed: "Espressione ternaria non consentita nell'espressione di tipo",
        totalOrderingMissingMethod: 'La classe deve definire uno dei valori di "__lt__", "__le__", "__gt__" o "__ge__" per usare total_ordering',
        trailingCommaInFromImport: "Virgola finale non consentita senza parentesi circostanti",
        tryWithoutExcept: "L'istruzione Try deve contenere almeno una clausola except or finally",
        tupleAssignmentMismatch: `Non \xE8 possibile assegnare l'espressione con tipo "{type}" al tuple di destinazione`,
        tupleInAnnotation: "Espressione di tuple non consentita nell'espressione del tipo",
        tupleIndexOutOfRange: "L'indice {index} non \xE8 compreso nell'intervallo per il tipo {type}",
        typeAliasIllegalExpressionForm: "Modulo di espressione non valido per la definizione dell'alias di tipo",
        typeAliasIsRecursiveDirect: `L'alias di tipo "{name}" non pu\xF2 usare se stesso nella relativa definizione`,
        typeAliasNotInModuleOrClass: "TypeAlias pu\xF2 essere definito solo all'interno di un modulo o di una classe",
        typeAliasRedeclared: '"{name}" \xE8 dichiarato come TypeAlias e pu\xF2 essere assegnato una sola volta',
        typeAliasStatementBadScope: "Un'istruzione type pu\xF2 essere usata solo all'interno di un modulo o di un ambito della classe",
        typeAliasStatementIllegal: "L'istruzione alias di tipo richiede Python 3.12 o versione successiva",
        typeAliasTypeBadScope: "\xC8 possibile definire un alias di tipo solo all'interno di un ambito classe o modulo",
        typeAliasTypeBaseClass: `Impossibile utilizzare come classe di base un alias di tipo definito in un'istruzione "type"`,
        typeAliasTypeMustBeAssigned: "TypeAliasType deve essere assegnato a una variabile con lo stesso nome dell'alias di tipo",
        typeAliasTypeNameArg: "Il primo argomento di TypeAliasType deve essere un valore letterale stringa che rappresenta il nome dell'alias di tipo",
        typeAliasTypeNameMismatch: "Il nome dell'alias di tipo deve corrispondere al nome della variabile a cui \xE8 assegnato",
        typeAliasTypeParamInvalid: "L'elenco dei parametri di tipo deve essere un tuple contenente solo TypeVar, TypeVarTuple o ParamSpec.",
        typeAnnotationCall: "Espressione di chiamata non consentita nell'espressione di tipo",
        typeAnnotationVariable: "Variabile non consentita nell'espressione di tipo",
        typeAnnotationWithCallable: `L'argomento di tipo per "type" deve essere una classe. I callable non sono supportati`,
        typeArgListExpected: "Sono previsti ParamSpec, puntini di sospensione o elenco di list",
        typeArgListNotAllowed: "Espressione di List non consentita per questo argomento di tipo",
        typeArgsExpectingNone: 'Non sono previsti argomenti di tipo per la classe "{name}"',
        typeArgsMismatchOne: "Previsto un argomento di tipo, ricevuto {received}",
        typeArgsMissingForAlias: `Sono previsti argomenti di tipo per l'alias di tipo generico "{name}"`,
        typeArgsMissingForClass: 'Argomenti tipo previsti per la classe generica "{name}"',
        typeArgsTooFew: 'Troppo pochi argomenti tipo forniti per "{name}"; previsto {expected} ma ricevuto {received}',
        typeArgsTooMany: 'Troppi argomenti tipo forniti per "{name}"; previsto {expected} ma ricevuto {received}',
        typeAssignmentMismatch: 'Il tipo "{sourceType}" non \xE8 assegnabile al tipo dichiarato "{destType}"',
        typeAssignmentMismatchWildcard: 'Il simbolo di importazione "{name}" ha il tipo "{sourceType}", che non \xE8 assegnabile al tipo dichiarato "{destType}"',
        typeCallNotAllowed: "la chiamata type() non deve essere usata nell'espressione di tipo",
        typeCheckOnly: '"{name}" \xE8 contrassegnato come @type_check_only e pu\xF2 essere utilizzato solo nelle annotazioni tipo',
        typeCommentDeprecated: "L'uso dei commenti di type \xE8 deprecato. Usare invece l'annotazione type",
        typeExpectedClass: 'Classe prevista ma ricevuta "{type}"',
        typeFormArgs: '"TypeForm" accetta un singolo argomento posizionale',
        typeGuardArgCount: '\xC8 previsto un singolo argomento di tipo dopo "TypeGuard" o "TypeIs"',
        typeGuardParamCount: "Le funzioni e i metodi di protezione dei tipi definiti dall'utente devono avere almeno un parametro di input",
        typeIsReturnType: 'Il tipo restituito di TypeIs ("{returnType}") non \xE8 coerente con il tipo di parametro di valore ("{type}")',
        typeNotAwaitable: '"{type}" non \xE8 awaitable',
        typeNotIntantiable: `Non \xE8 possibile creare un'istanza di "{type}"`,
        typeNotIterable: '"{type}" non \xE8 iterabile',
        typeNotSpecializable: 'Non \xE8 stato possibile specializzare il tipo "{type}"',
        typeNotSubscriptable: `L'oggetto di tipo "{type}" non \xE8 sottoponibile a script`,
        typeNotSupportBinaryOperator: `L'operatore "{operator}" non \xE8 supportato per i tipi "{leftType}" e "{rightType}".`,
        typeNotSupportBinaryOperatorBidirectional: `L'operatore "{operator}" non \xE8 supportato per i tipi "{leftType}" e "{rightType}" quando il tipo previsto \xE8 "{expectedType}"`,
        typeNotSupportUnaryOperator: 'Operatore "{operator}" non supportato per il tipo "{type}"',
        typeNotSupportUnaryOperatorBidirectional: `L'operatore "{operator}" non \xE8 supportato per il tipo "{type}" quando il tipo previsto \xE8 "{expectedType}"`,
        typeNotUsableWith: `Impossibile utilizzare l'oggetto di tipo "{type}" con "with" perch\xE9 non implementa correttamente {method}`,
        typeNotUsableWithAsync: `Impossibile utilizzare l'oggetto di tipo "{type}" con "async with" perch\xE9 non implementa {method}`,
        typeParameterBoundNotAllowed: "Il vincolo o il binding non possono essere usati con un parametro di tipo variadic o ParamSpec",
        typeParameterConstraintTuple: "Il vincolo del parametro di tipo deve essere una tupla di due o pi\xF9 tipi",
        typeParameterExistingTypeParameter: 'Il parametro di tipo "{name}" \xE8 gi\xE0 in uso',
        typeParameterNotDeclared: `Il parametro di tipo "{name}" non \xE8 incluso nell'elenco dei parametri di tipo per "{container}"`,
        typeParametersMissing: "\xC8 necessario specificare almeno un parametro di tipo",
        typePartiallyUnknown: 'Tipo di "{name}" parzialmente sconosciuto',
        typeUnknown: 'Il tipo di "{name}" \xE8 sconosciuto',
        typeVarAssignedName: 'TypeVar deve essere assegnato a una variabile denominata "{name}"',
        typeVarAssignmentMismatch: 'Non \xE8 possibile assegnare il tipo "{type}" alla variabile di tipo "{name}"',
        typeVarBoundAndConstrained: "TypeVar non pu\xF2 essere contemporaneamente associato e vincolato",
        typeVarBoundGeneric: "Il tipo associato a TypeVar non pu\xF2 essere generico",
        typeVarConstraintGeneric: "Il tipo di vincolo TypeVar non pu\xF2 essere generico",
        typeVarDefaultBoundMismatch: "Il tipo predefinito TypeVar deve essere un sottotipo del tipo associato",
        typeVarDefaultConstraintMismatch: "Il tipo predefinito TypeVar deve essere uno dei tipi vincolati",
        typeVarDefaultIllegal: "I tipi predefiniti delle variabili di tipo richiedono Python 3.13 o versione successiva",
        typeVarDefaultInvalidTypeVar: `Il parametro di tipo "{name}" ha un tipo predefinito che fa riferimento a una o pi\xF9 variabili di tipo non compreso nell'ambito`,
        typeVarFirstArg: "Nome previsto di TypeVar come primo argomento",
        typeVarInvalidForMemberVariable: 'Il tipo di attributo non pu\xF2 usare la variabile di tipo "{name}" con ambito del metodo locale',
        typeVarNoMember: 'TypeVar "{type}" non ha alcun attributo "{name}"',
        typeVarNotSubscriptable: 'TypeVar "{type}" non sottoponibile a script',
        typeVarNotUsedByOuterScope: 'La variabile di tipo "{name}" non ha significato in questo contesto',
        typeVarPossiblyUnsolvable: 'La variabile di tipo "{name}" potrebbe non essere risolta se il chiamante non fornisce alcun argomento per il parametro "{param}"',
        typeVarSingleConstraint: "TypeVar deve contenere almeno due tipi vincolati",
        typeVarTupleConstraints: "TypeVarTuple non pu\xF2 avere vincoli di valore",
        typeVarTupleContext: "TypeVarTuple non \xE8 consentito in questo contesto",
        typeVarTupleDefaultNotUnpacked: "Il tipo predefinito TypeVarTuple deve essere un tuple non compresso o TypeVarTuple",
        typeVarTupleMustBeUnpacked: "L'operatore Decomprimi \xE8 obbligatorio per il valore TypeVarTuple",
        typeVarTupleUnknownParam: '"{name}" \xE8 un parametro sconosciuto per TypeVarTuple',
        typeVarUnknownParam: '"{name}" \xE8 un parametro sconosciuto per TypeVar',
        typeVarUsedByOuterScope: 'TypeVar "{name}" gi\xE0 in uso da un ambito esterno',
        typeVarUsedOnlyOnce: 'TypeVar "{name}" viene visualizzato una sola volta nella firma della funzione generica',
        typeVarVariance: "TypeVar non pu\xF2 essere covariante e controvariante",
        typeVarWithDefaultFollowsVariadic: 'TypeVar "{typeVarName}" ha un valore predefinito e non pu\xF2 seguire TypeVarTuple "{variadicName}"',
        typeVarWithoutDefault: `"{name}" non pu\xF2 essere visualizzato dopo "{other}" nell'elenco dei parametri del tipo, perch\xE9 non ha un tipo predefinito`,
        typeVarsNotInGenericOrProtocol: "Generic[] o Protocol[] deve includere tutte le variabili di tipo",
        typedDictAccess: "Non \xE8 stato possibile accedere all'elemento in TypedDict",
        typedDictAssignedName: 'TypedDict deve essere assegnato a una variabile denominata "{name}"',
        typedDictBadVar: "Le classi TypedDict possono contenere solo annotazioni di tipo",
        typedDictBaseClass: "Anche tutte le classi di base per le classi TypedDict devono essere classi TypedDict",
        typedDictBoolParam: '\xC8 previsto che il parametro "{name}" abbia il valore True o False',
        typedDictClosedExtras: 'La classe di base "{name}" \xE8 una TypedDict che limita il tipo di elementi aggiuntivi al tipo "{type}"',
        typedDictClosedFalseNonOpenBase: 'Base class "{name}" is not an open TypedDict; closed=False is not allowed',
        typedDictClosedNoExtras: 'La classe di base "{name}" \xE8 un TypedDict closed; elementi aggiuntivi non consentiti',
        typedDictDelete: "Non \xE8 stato possibile eliminare l'elemento in TypedDict",
        typedDictEmptyName: "I nomi all'interno di un TypedDict non possono essere vuoti",
        typedDictEntryName: "Valore letterale stringa previsto per il nome della voce del dizionario",
        typedDictEntryUnique: "I nomi all'interno di un dizionario devono essere univoci",
        typedDictExtraArgs: "Argomenti TypedDict aggiuntivi non supportati",
        typedDictExtraItemsClosed: 'TypedDict possono utilizzare "closed" o "extra_items" ma non entrambi',
        typedDictFieldNotRequiredRedefinition: 'Non \xE8 possibile ridefinire il campo TypedDict "{name}" come NotRequired',
        typedDictFieldReadOnlyRedefinition: 'Non \xE8 possibile ridefinire l\u2019elemento TypedDict "{name}" come ReadOnly',
        typedDictFieldRequiredRedefinition: 'Non \xE8 possibile ridefinire il campo TypedDict "{name}" come Required',
        typedDictFirstArg: "\xC8 previsto il nome della classe TypedDict come primo argomento",
        typedDictInClassPattern: "Classe TypedDict non consentita nel modello di classe",
        typedDictInitsubclassParameter: "TypedDict non supporta __init_subclass__ parametro \u201C{name}\u201D",
        typedDictNotAllowed: '"TypedDict" non pu\xF2 essere usato in questo contesto',
        typedDictSecondArgDict: "Previsto parametro dict o keyword come secondo parametro",
        typedDictSecondArgDictEntry: "Voce di dizionario semplice prevista",
        typedDictSet: "Non \xE8 stato possibile assegnare l'elemento in TypedDict",
        unaccessedClass: `Non \xE8 stato eseguito l'accesso alla classe "{name}"`,
        unaccessedFunction: `Non \xE8 stato eseguito l'accesso alla funzione "{name}"`,
        unaccessedImport: `Non \xE8 stato eseguito l'accesso all'importazione "{name}"`,
        unaccessedSymbol: `Non \xE8 stato eseguito l'accesso a "{name}"`,
        unaccessedVariable: `Non \xE8 stato eseguito l'accesso alla variabile "{name}"`,
        unannotatedFunctionSkipped: `L'analisi della funzione "{name}" \xE8 stata ignorata perch\xE9 non \xE8 annotata`,
        unaryOperationNotAllowed: "Operatore unario non consentito nell'espressione di tipo",
        unexpectedAsyncToken: '\xC8 previsto che "def", "with" o "for" seguano "async"',
        unexpectedEof: "Unexpected EOF",
        unexpectedExprToken: "Token imprevisto alla fine dell'espressione",
        unexpectedIndent: "Rientro imprevisto",
        unexpectedUnindent: "Riduci rientro non previsto",
        unhashableDictKey: "La chiave del dizionario deve essere hashable",
        unhashableSetEntry: "La voce set deve essere hashable",
        uninitializedAbstractVariables: 'Le variabili definite nella classe di base astratta non vengono inizializzate nella classe finale "{classType}"',
        uninitializedInstanceVariable: 'La variabile di istanza "{name}" non \xE8 inizializzata nel corpo della classe o nel metodo __init__',
        unionForwardReferenceNotAllowed: "Impossibile utilizzare la sintassi di Union con l'operando stringa. Usare virgolette intorno all'intera espressione",
        unionSyntaxIllegal: "La sintassi alternativa per le unioni richiede Python 3.10 o versione successiva",
        unionTypeArgCount: "Unione richiede due o pi\xF9 argomenti di tipo",
        unionUnpackedTuple: "Union non pu\xF2 includere un tuple decompresso",
        unionUnpackedTypeVarTuple: "Union non pu\xF2 includere un TypeVarTuple non compresso",
        unnecessaryCast: 'Chiamata "cast" non necessaria; il tipo \xE8 gi\xE0 "{type}"',
        unnecessaryIsInstanceAlways: `Chiamata isinstance non necessaria; "{testType}" \xE8 sempre un'istanza di "{classType}"`,
        unnecessaryIsInstanceNever: `Chiamata isinstance non necessaria; "{testType}" non \xE8 mai un'istanza di "{classType}"`,
        unnecessaryIsSubclassAlways: 'Chiamata issubclass non necessaria; "{testType}" \xE8 sempre una sottoclasse di "{classType}"',
        unnecessaryIsSubclassNever: 'Chiamata issubclass non necessaria; "{testType}" non \xE8 mai una sottoclasse di "{classType}"',
        unnecessaryPyrightIgnore: 'Commento "# pyright: ignore" non necessario',
        unnecessaryPyrightIgnoreRule: 'Regola "# pyright: ignore" non necessaria: "{name}"',
        unnecessaryTypeIgnore: 'Commento "# type: ignore" non necessario',
        unpackArgCount: 'Previsto un singolo argomento di tipo dopo "Unpack"',
        unpackExpectedTypeVarTuple: "\xC8 previsto TypeVarTuple o tuple come argomento di tipo per Unpack",
        unpackExpectedTypedDict: "Previsto argomento di tipo TypedDict per Unpack",
        unpackIllegalInComprehension: "Operazione di decompressione non consentita nella comprensione",
        unpackInAnnotation: "Operatore di decompressione non consentito nell'espressione di tipo",
        unpackInDict: "Operazione di decompressione non consentita nei dizionari",
        unpackInSet: "Operatore di decompressione non consentito all\u2019interno di un set",
        unpackNotAllowed: "Unpack non \xE8 consentito in questo contesto",
        unpackOperatorNotAllowed: "L\u2019operazione di decompressione non \xE8 consentita in questo contesto",
        unpackTuplesIllegal: "L'operazione di decompressione non \xE8 consentita nelle tuple precedenti a Python 3.8",
        unpackedArgInTypeArgument: "Non \xE8 possibile usare argomenti decompressi in questo contesto",
        unpackedArgWithVariadicParam: "Non \xE8 possibile usare l'argomento decompresso per il parametro TypeVarTuple",
        unpackedDictArgumentNotMapping: `L'espressione dell'argomento dopo ** deve essere un mapping con un tipo di chiave "str"`,
        unpackedDictSubscriptIllegal: "L'operatore di decompressione del dizionario nel pedice non \xE8 consentito",
        unpackedSubscriptIllegal: "L'operatore di decompressione nel pedice richiede Python 3.11 o versione successiva",
        unpackedTypeVarTupleExpected: "Previsto TypeVarTuple decompresso; usa Unpack[{name1}] o *{name2}",
        unpackedTypedDictArgument: "Impossibile trovare una corrispondenza tra l'argomento TypedDict non compresso e i parametri",
        unreachableCodeCondition: "Code is not analyzed because condition is statically evaluated as false",
        unreachableCodeStructure: "Code is structurally unreachable",
        unreachableCodeType: "L\u2019analisi dei tipi indica che il codice non \xE8 raggiungibile.",
        unreachableExcept: "La clausola Except non \xE8 raggiungibile perch\xE9 l'eccezione \xE8 gi\xE0 gestita",
        unsupportedDunderAllOperation: `L'operazione su "__all__" non \xE8 supportata, di conseguenza l'elenco dei simboli esportati potrebbe non essere corretto`,
        unusedCallResult: `Il risultato dell'espressione di chiamata \xE8 di tipo "{type}" e non \xE8 usato. Assegnare alla variabile "_" se \xE8 intenzionale`,
        unusedCoroutine: 'Il risultato della chiamata alla funzione async non viene usato. Usare "await" o assegnare il risultato alla variabile',
        unusedExpression: "Il valore dell'espressione non \xE8 utilizzato",
        varAnnotationIllegal: "Le annotazioni type per le variabili richiedono Python 3.6 o versione successiva. Usare il commento di type per la compatibilit\xE0 con le versioni precedenti",
        variableFinalOverride: `La variabile "{name}" \xE8 contrassegnata come Final ed esegue l'override della variabile non Final con lo stesso nome nella classe "{className}"`,
        variadicTypeArgsTooMany: "L'elenco di argomenti del tipo pu\xF2 contenere al massimo un tuple o TypeVarTuple non compresso",
        variadicTypeParamTooManyAlias: "L'alias di tipo pu\xF2 avere al massimo un parametro di tipo TypeVarTuple, ma ne ha ricevuti pi\xF9 ({names})",
        variadicTypeParamTooManyClass: "La classe generica pu\xF2 avere al massimo un parametro di tipo TypeVarTuple, ma ne ha ricevuti pi\xF9 ({names})",
        walrusIllegal: `L'operatore ":=" richiede Python 3.8 o versione successiva`,
        walrusNotAllowed: `L'operatore ":=" non \xE8 consentito in questo contesto senza parentesi circostanti`,
        wildcardInFunction: "Wildcard import non consentito all'interno di una classe o di una funzione",
        wildcardLibraryImport: "Wildcard import da una libreria non consentito",
        wildcardPatternTypePartiallyUnknown: "Il tipo acquisito dal modello con caratteri jolly \xE8 parzialmente sconosciuto",
        wildcardPatternTypeUnknown: "Il tipo acquisito dal criterio con caratteri jolly \xE8 sconosciuto",
        yieldFromIllegal: `L'uso di "yield from" richiede Python 3.3 o versione successiva`,
        yieldFromOutsideAsync: '"yield from" non consentito in una funzione async',
        yieldOutsideFunction: `"yield" non consentito all'esterno di una funzione o di un'espressione lambda`,
        yieldWithinComprehension: `"yield" non consentito all'interno di una comprensione`,
        zeroCaseStatementsFound: "L\u2019istruzione Match deve includere almeno un\u2019istruzione case",
        zeroLengthTupleNotAllowed: "Zero-length tuple is not allowed in this context"
      },
      DiagnosticAddendum: {
        annotatedNotAllowed: 'Non \xE8 possibile usare il modulo speciale "Annotated" con controlli di istanza e classe',
        argParam: `L'argomento corrisponde al parametro "{paramName}"`,
        argParamFunction: `L'argomento corrisponde al parametro "{paramName}" nella funzione "{functionName}"`,
        argsParamMissing: 'Il parametro "*{paramName}" non ha un parametro corrispondente',
        argsPositionOnly: "Parametro di sola posizione non corrispondente; previsto {expected} ma ricevuto {received}",
        argumentType: 'Il tipo di argomento \xE8 "{type}"',
        argumentTypes: "Tipi di argomento: ({types})",
        assignToNone: 'Il tipo non \xE8 assegnabile a "None"',
        asyncHelp: 'Intendevi "async with"?',
        baseClassIncompatible: 'La classe base "{baseClass}" non \xE8 compatibile con il tipo "{type}"',
        baseClassIncompatibleSubclass: 'La classe base "{baseClass}" deriva da "{subclass}", che non \xE8 compatibile con il tipo "{type}"',
        baseClassOverriddenType: `La classe di base "{baseClass}" fornisce il tipo "{type}", di cui viene eseguito l'override`,
        baseClassOverridesType: 'Override della classe base "{baseClass}" con tipo "{type}"',
        bytesTypePromotions: 'Imposta disableBytesTypePromotions su false per abilitare il comportamento di innalzamento di livello del tipo per "bytearray" e "memoryview"',
        conditionalRequiresBool: 'Il metodo __bool__ per il tipo "{operandType}" restituisce il tipo "{boolReturnType}" anzich\xE9 "bool"',
        dataClassFieldLocation: "Dichiarazione di campo",
        dataClassFrozen: '"{name}" \xE8 bloccato',
        dataProtocolUnsupported: "\u201C{name}\u201D \xE8 un protocollo dati",
        descriptorAccessBindingFailed: 'Impossibile associare il metodo "{name}" per la classe descrittore "{className}"',
        descriptorAccessCallFailed: 'Impossibile chiamare il metodo "{name}" per la classe descrittore "{className}"',
        finalMethod: "Metodo Final",
        functionParamDefaultMissing: 'Nel parametro "{name}" manca un argomento predefinito',
        functionParamName: 'Nome del parametro non corrispondente: "{destName}" rispetto a "{srcName}"',
        functionParamPositionOnly: "Parametro di sola posizione non corrispondente; il parametro \u201C{name}\u201D non \xE8 di sola posizione",
        functionReturnTypeMismatch: 'Il tipo restituito della funzione"{sourceType}" non \xE8 compatibile con il tipo "{destType}"',
        functionTooFewParams: "La funzione accetta un numero insufficiente di parametri posizionale. Previsto {expected} ma ricevuto {received}",
        functionTooManyParams: "La funzione accetta un numero eccessivo di parametri posizionale. Previsto {expected} ma ricevuto {received}",
        genericClassNotAllowed: "Tipo generico con argomenti di tipo non consentiti per i controlli di istanza o classe",
        incompatibleDeleter: "Il metodo deleter di Property non \xE8 compatibile",
        incompatibleGetter: "Il metodo getter di Property non \xE8 compatibile",
        incompatibleSetter: "Il metodo setter di Property non \xE8 compatibile",
        initMethodLocation: 'Il metodo __init__ \xE8 definito nella classe "{type}"',
        initMethodSignature: 'Firma del __init__ "{type}"',
        initSubclassLocation: 'Il metodo __init_subclass__ \xE8 definito nella classe "{name}"',
        invariantSuggestionDict: 'Prova a passare da "dict" a "Mapping", che \xE8 covariante nel tipo di valore',
        invariantSuggestionList: 'Prova a passare da "list" a "Sequence", che \xE8 covariante',
        invariantSuggestionSet: 'Prova a passare da "set" a "Container", che \xE8 covariante',
        isinstanceClassNotSupported: '"{type}" non \xE8 supportata per i controlli delle istanze e delle classi',
        keyNotRequired: `"{name}" non \xE8 una chiave obbligatoria in "{type}", quindi l'accesso potrebbe causare un'eccezione di runtime`,
        keyReadOnly: '"{name}" \xE8 una chiave di sola lettura in "{type}"',
        keyRequiredDeleted: '"{name}" \xE8 una chiave obbligatoria e non pu\xF2 essere eliminata',
        keyUndefined: '"{name}" non \xE8 una chiave definita in "{type}"',
        kwargsParamMissing: 'Il parametro "**{paramName}" non ha un parametro corrispondente',
        listAssignmentMismatch: `Il tipo "{type}" non \xE8 compatibile con l'elenco di destinazione`,
        literalAssignmentMismatch: '"{sourceType}" non \xE8 assegnabile al tipo "{destType}"',
        literalNotAllowed: 'Non \xE8 possibile usare il modulo speciale "Literal" con controlli di istanza e classe',
        matchIsNotExhaustiveHint: 'Se la gestione completa non \xE8 prevista, aggiungere "case _: pass"',
        matchIsNotExhaustiveType: 'Tipo non gestito: "{type}"',
        memberAssignment: `L'espressione di tipo "{type}" non pu\xF2 essere assegnata all'attributo "{name}" della classe "{classType}".`,
        memberIsAbstract: '"{type}.{name}" non implementato',
        memberIsAbstractMore: "e {{count}} altro...",
        memberIsClassVarInProtocol: "\u201C{name}\u201D \xE8 definito come ClassVar nel protocollo",
        memberIsInitVar: '"{name}" \xE8 un campo di init-only',
        memberIsInvariant: '"{name}" \xE8 invariante perch\xE9 modificabile',
        memberIsNotClassVarInClass: '"{name}" deve essere definito come ClassVar per essere compatibile con il protocollo',
        memberIsNotClassVarInProtocol: "\u201C{name}\u201D non \xE8 definito come ClassVar nel protocollo",
        memberIsNotReadOnlyInProtocol: '"{name}" non \xE8 di sola lettura nel protocollo',
        memberIsReadOnlyInProtocol: '"{name}" \xE8 di sola lettura nel protocollo',
        memberIsWritableInProtocol: '"{name}" \xE8 scrivibile nel protocollo',
        memberSetClassVar: `Non \xE8 possibile assegnare l'attributo "{name}" tramite un'istanza di classe perch\xE9 \xE8 una ClassVar`,
        memberTypeMismatch: '"{name}" \xE8 un tipo non compatibile',
        memberUnknown: `L'attributo "{name}" \xE8 sconosciuto`,
        metaclassConflict: 'La metaclasse "{metaclass1}" \xE8 in conflitto con "{metaclass2}"',
        missingDeleter: "Metodo deleter di Property mancante",
        missingGetter: "Metodo getter di Property mancante",
        missingSetter: "Metodo setter di Property mancante",
        namedParamMissingInDest: "Parametro aggiuntivo \u201C{name}\u201D",
        namedParamMissingInSource: "Parametro della parola chiave \u201C{name}\u201D mancante",
        namedParamTypeMismatch: 'Il parametro "{name}" della parola chiave di tipo "{sourceType}" non \xE8 compatibile con il tipo "{destType}"',
        namedTupleNotAllowed: "Non \xE8 possibile usare NamedTuple per i controlli di istanze o classi",
        newMethodLocation: 'Il metodo __new__ \xE8 definito nella classe "{type}"',
        newMethodSignature: 'La firma del __new__ \xE8 "{type}"',
        newTypeClassNotAllowed: "Type created with NewType cannot be used with instance and class checks",
        noOverloadAssignable: 'Nessuna funzione di overload corrisponde al tipo "{type}"',
        noneNotAllowed: "Non \xE8 possibile usare None per i controlli di istanze o classi",
        orPatternMissingName: "Nomi mancanti: {name}",
        overloadIndex: "L'overload {index} \xE8 la corrispondenza pi\xF9 vicina",
        overloadNotAssignable: 'Uno o pi\xF9 overload di "{name}" non sono assegnabili',
        overloadSignature: "La firma di overload \xE8 definita qui",
        overriddenMethod: "Metodo sottoposto a override",
        overriddenSymbol: "Simbolo sottoposto a override",
        overrideInvariantMismatch: 'Il tipo di override "{overrideType}" non \xE8 uguale al tipo di base "{baseType}"',
        overrideIsInvariant: "La variabile \xE8 modificabile, quindi il relativo tipo \xE8 invariante",
        overrideNoOverloadMatches: "Nessuna firma di overload nell'override \xE8 compatibile con il metodo di base",
        overrideNotClassMethod: "Il metodo di base viene dichiarato come classmethod, ma l'override non lo \xE8",
        overrideNotInstanceMethod: "Il metodo di base \xE8 dichiarato come metodo di istanza, ma l\u2019override non lo \xE8",
        overrideNotStaticMethod: "Il metodo di base viene dichiarato come staticmethod, ma l'override non lo \xE8",
        overrideOverloadNoMatch: "La sostituzione non gestisce tutti gli overload del metodo di base",
        overrideOverloadOrder: "Gli overload per il metodo di override devono essere nello stesso ordine del metodo di base",
        overrideParamKeywordNoDefault: 'Parametro della parola chiave "{name}" non corrispondente: il parametro di base ha un valore di argomento predefinito, il parametro di override non \xE8',
        overrideParamKeywordType: 'Tipo del parametro della parola chiave "{name}" non corrispondente: il parametro di base \xE8 di tipo "{baseType}", il parametro di override \xE8 di tipo "{overrideType}"',
        overrideParamName: 'Nome del parametro {index} non corrispondente: il parametro di base \xE8 denominato "{baseName}", il parametro di override \xE8 denominato "{overrideName}"',
        overrideParamNameExtra: 'Parametro "{name}" mancante nella base',
        overrideParamNameMissing: `Parametro "{name}" mancante nell'override`,
        overrideParamNamePositionOnly: 'Mancata corrispondenza del parametro {index}: il parametro di base "{baseName}" \xE8 un parametro di parola chiave, il parametro di override \xE8 di sola posizione',
        overrideParamNoDefault: 'Parametro "{index}" non corrispondente: il parametro di base ha un valore di argomento predefinito, il parametro di override non \xE8',
        overrideParamType: 'Tipo di parametro {index} non corrispondente: il parametro di base \xE8 di tipo "{baseType}", il parametro di override \xE8 di tipo "{overrideType}"',
        overridePositionalParamCount: "Numero di parametri posizionali non corrispondente. Il metodo di base ne ha {baseCount}, ma l'override ne ha {overrideCount}",
        overrideReturnType: `Tipo restituito non corrispondente: il metodo di base restituisce il tipo "{baseType}", l'override restituisce il tipo "{overrideType}"`,
        overrideType: 'La classe di base definisce il tipo come "{type}"',
        paramAssignment: 'Parametro {index}: il tipo "{sourceType}" non \xE8 compatibile con il tipo "{destType}"',
        paramSpecMissingInOverride: "Parametri ParamSpec mancanti nel metodo di override",
        paramType: 'Tipo di parametro "{paramType}"',
        privateImportFromPyTypedSource: 'Importa da "{module}"',
        propertyAccessFromProtocolClass: "Non \xE8 possibile accedere a una propriet\xE0 definita all'interno di una classe di protocollo come variabile di classe",
        propertyMethodIncompatible: 'Il metodo di Property "{name}" non \xE8 compatibile',
        propertyMethodMissing: `Metodo di Property "{name}" mancante nell'override`,
        propertyMissingDeleter: 'Property "{name}" non dispone di un deleter definito',
        propertyMissingSetter: 'Property "{name}" non dispone di un setter definito',
        protocolIncompatible: '"{sourceType}" non \xE8 compatibile con il protocollo "{destType}"',
        protocolMemberMissing: '"{name}" non \xE8 presente',
        protocolRequiresRuntimeCheckable: "La classe di Protocol deve essere @runtime_checkable in modo che sia possibile usarla con i controlli di istanza e classe",
        protocolSourceIsNotConcrete: '"{sourceType}" non \xE8 un tipo di classe concreto e non pu\xF2 essere assegnato al tipo "{destType}"',
        protocolUnsafeOverlap: "Gli attributi di \u201C{name}\u201D hanno gli stessi nomi del protocollo",
        pyrightCommentIgnoreTip: 'Usa "# pyright: ignore[<diagnostic rules>]" per eliminare la diagnostica per una singola riga',
        readOnlyAttribute: `L'attributo "{name}" \xE8 di sola lettura`,
        seeClassDeclaration: "Vedere la dichiarazione di classe",
        seeDeclaration: "Vedere la dichiarazione",
        seeFunctionDeclaration: "Vedere la dichiarazione di funzione",
        seeMethodDeclaration: "Vedere la dichiarazione del metodo",
        seeParameterDeclaration: "Vedere la dichiarazione del parametro",
        seeTypeAliasDeclaration: "Vedere la dichiarazione di alias di tipo",
        seeVariableDeclaration: "Vedere la dichiarazione di variabile",
        tupleAssignmentMismatch: 'Il tipo "{type}" non \xE8 compatibile con il tuple di destinazione',
        tupleEntryTypeMismatch: "Il tipo della voce di Tuple {entry} non \xE8 corretto",
        tupleSizeIndeterminateSrc: "Dimensioni del tuple non corrispondenti; previsto {expected} ma ricevuto indeterminato",
        tupleSizeIndeterminateSrcDest: "Dimensioni del tuple non corrispondenti; previsto {expected} o pi\xF9, ma ricevuto indeterminato",
        tupleSizeMismatch: "Dimensioni tuple non corrispondenti; previsto {expected} ma ricevuto {received}",
        tupleSizeMismatchIndeterminateDest: "Dimensioni del tuple non corrispondenti; previsto {expected} o pi\xF9 ma ricevuto {received}",
        typeAliasInstanceCheck: `Non \xE8 possibile usare l'alias di tipo creato con l'istruzione "type" con controlli di classe e istanza`,
        typeAssignmentMismatch: 'Il tipo "{sourceType}" non \xE8 assegnabile al tipo "{destType}"',
        typeBound: 'Il tipo "{sourceType}" non \xE8 assegnabile al limite superiore "{destType}" per la variabile di tipo "{name}"',
        typeConstrainedTypeVar: 'Il tipo "{type}" non \xE8 assegnabile alla variabile di tipo vincolato "{name}"',
        typeIncompatible: '"{sourceType}" non \xE8 assegnabile a "{destType}"',
        typeNotClass: '"{type}" non \xE8 una classe',
        typeNotStringLiteral: '"{type}" non \xE8 un valore letterale stringa',
        typeOfSymbol: 'Il tipo di "{name}" \xE8 "{type}"',
        typeParamSpec: 'Il tipo "{type}" non \xE8 compatibile con il "{name}" ParamSpec',
        typeUnsupported: 'Il tipo "{type}" non \xE8 supportato',
        typeVarDefaultOutOfScope: `La variabile di tipo "{name}" non \xE8 nell'ambito`,
        typeVarIsContravariant: 'Il parametro di tipo "{name}" \xE8 controvariante, ma "{sourceType}" non \xE8 un supertipo di "{destType}"',
        typeVarIsCovariant: 'Il parametro di tipo "{name}" \xE8 covariante, ma "{sourceType}" non \xE8 un sottotipo di "{destType}"',
        typeVarIsInvariant: 'Il parametro di tipo "{name}" \xE8 invariante, ma "{sourceType}" non \xE8 uguale a "{destType}"',
        typeVarNotAllowed: "TypeVar non consentito per i controlli di istanze o classi",
        typeVarTupleRequiresKnownLength: "Non \xE8 possibile associare TypeVarTuple a un tuple di lunghezza sconosciuta",
        typeVarUnnecessarySuggestion: "Usare invece {type}",
        typeVarUnsolvableRemedy: "Specificare un overload che specifica il tipo restituito quando l'argomento non viene fornito",
        typeVarsMissing: "Variabili di tipo mancanti: {names}",
        typedDictBaseClass: 'La classe "{type}" non \xE8 un TypedDict',
        typedDictClassNotAllowed: "Classe TypedDict non consentita per i controlli di istanze o classi",
        typedDictClosedExtraNotAllowed: `Non \xE8 possibile aggiungere l'elemento "{name}"`,
        typedDictClosedExtraTypeMismatch: `Non \xE8 possibile aggiungere l'elemento "{name}" con tipo "{type}"`,
        typedDictClosedFieldNotReadOnly: 'Cannot add item "{name}" because it must be ReadOnly',
        typedDictClosedFieldNotRequired: `Non \xE8 possibile aggiungere l'elemento "{name}" perch\xE9 deve essere NotRequired`,
        typedDictExtraFieldNotAllowed: '"{name}" non \xE8 presente in "{type}"',
        typedDictExtraFieldTypeMismatch: 'Il tipo di "{name}" non \xE8 compatibile con il tipo ""extra_items" in "{type}"',
        typedDictFieldMissing: '"{name}" mancante nel "{type}"',
        typedDictFieldNotReadOnly: '"{name}" non \xE8 di sola lettura in "{type}"',
        typedDictFieldNotRequired: '"{name}" non \xE8 obbligatorio in "{type}"',
        typedDictFieldRequired: '"{name}" \xE8 obbligatorio in "{type}"',
        typedDictFieldTypeMismatch: 'Il tipo "{type}" non pu\xF2 essere assegnato all\u2019elemento "{name}"',
        typedDictFieldUndefined: '"{name}" \xE8 un elemento non definito nel tipo "{type}"',
        typedDictKeyAccess: `Usare ["{name}"] per fare riferimento all'elemento in TypedDict`,
        typedDictNotAllowed: "Non \xE8 possibile usare TypedDict per i controlli di istanze o classi",
        unhashableType: 'Il tipo "{type}" non \xE8 hashable',
        uninitializedAbstractVariable: 'La variabile di istanza "{name}" \xE8 definita nella classe di base astratta "{classType}" ma non \xE8 inizializzata',
        unreachableExcept: '"{exceptionType}" \xE8 una sottoclasse di "{parentType}"',
        useDictInstead: "Usare dict[T1, T2] per indicare un tipo di dizionario",
        useListInstead: "Usare list[T] per indicare un tipo di list o T1 | T2 per indicare un tipo di union",
        useTupleInstead: "Usare tuple[T1, ..., Tn] per indicare un tipo di tuple o T1 | T2 per indicare un tipo di unione",
        useTypeInstead: "Usare invece type[T]",
        varianceMismatchForClass: `La varianza dell'argomento tipo "{typeVarName}" non \xE8 compatibile con la classe di base "{className}"`,
        varianceMismatchForTypeAlias: `La varianza dell'argomento tipo "{typeVarName}" non \xE8 compatibile con "{typeAliasParam}"`
      },
      Service: {
        longOperation: "L\u2019enumerazione dei file di origine dell\u2019area di lavoro sta richiedendo tempo. Provare ad aprire una sottocartella. [Altre informazioni](https://aka.ms/workspace-too-many-files)"
      }
    };
  }
});

// node_modules/@zzzen/pyright-internal/dist/localization/package.nls.ja.json
var require_package_nls_ja = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/localization/package.nls.ja.json"(exports2, module2) {
    module2.exports = {
      CodeAction: {
        createTypeStub: "\u578B Stub \u3092\u4F5C\u6210\u3059\u308B",
        createTypeStubFor: '"{moduleName}" \u306E\u578B Stub \u3092\u4F5C\u6210\u3059\u308B',
        executingCommand: "\u30B3\u30DE\u30F3\u30C9\u306E\u5B9F\u884C\u4E2D",
        filesToAnalyzeCount: "\u5206\u6790\u3059\u308B {count} \u500B\u306E\u30D5\u30A1\u30A4\u30EB",
        filesToAnalyzeOne: "\u5206\u6790\u3059\u308B 1 \u3064\u306E\u30D5\u30A1\u30A4\u30EB",
        findingReferences: "\u53C2\u7167\u3092\u691C\u7D22\u3057\u3066\u3044\u307E\u3059",
        organizeImports: "\u30A4\u30F3\u30DD\u30FC\u30C8\u3092\u6574\u7406"
      },
      Completion: {
        autoImportDetail: "\u81EA\u52D5\u30A4\u30F3\u30DD\u30FC\u30C8",
        indexValueDetail: "\u30A4\u30F3\u30C7\u30C3\u30AF\u30B9\u5024"
      },
      Diagnostic: {
        abstractMethodInvocation: '\u30E1\u30BD\u30C3\u30C9 "{method}" \u306F\u62BD\u8C61\u30E1\u30BD\u30C3\u30C9\u3067\u3042\u308A\u3001\u5B9F\u88C5\u3055\u308C\u3066\u3044\u306A\u3044\u305F\u3081\u3001\u547C\u3073\u51FA\u3059\u3053\u3068\u304C\u3067\u304D\u307E\u305B\u3093',
        annotatedMetadataInconsistent: '\u6CE8\u91C8\u4ED8\u304D\u306E\u30E1\u30BF\u30C7\u30FC\u30BF\u578B "{metadataType}" \u306F\u578B "{type}" \u3068\u4E92\u63DB\u6027\u304C\u3042\u308A\u307E\u305B\u3093',
        annotatedParamCountMismatch: "\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u6CE8\u91C8\u6570\u306E\u4E0D\u4E00\u81F4: {expected} \u304C\u5FC5\u8981\u3067\u3059\u304C\u3001{received} \u3092\u53D7\u4FE1\u3057\u307E\u3057\u305F",
        annotatedTypeArgMissing: '"Annotated" \u306B\u306F 1 \u3064\u306E\u578B\u5F15\u6570\u3068 1 \u3064\u4EE5\u4E0A\u306E\u6CE8\u91C8\u304C\u5FC5\u8981\u3067\u3059',
        annotationBytesString: "\u578B\u5F0F\u3067\u306F\u3001\u30D0\u30A4\u30C8\u6587\u5B57\u5217\u30EA\u30C6\u30E9\u30EB\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        annotationFormatString: "\u578B\u5F0F\u3067\u306F\u3001\u66F8\u5F0F\u6307\u5B9A\u6587\u5B57\u5217\u30EA\u30C6\u30E9\u30EB (f \u6587\u5B57\u5217) \u3092\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        annotationNotSupported: "\u3053\u306E\u30B9\u30C6\u30FC\u30C8\u30E1\u30F3\u30C8\u3067\u306F\u578B\u6CE8\u91C8\u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        annotationRawString: "\u578B\u5F0F\u3067\u306F\u3001\u751F\u6587\u5B57\u5217\u30EA\u30C6\u30E9\u30EB\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        annotationSpansStrings: "\u578B\u5F0F\u306F\u8907\u6570\u306E\u6587\u5B57\u5217\u30EA\u30C6\u30E9\u30EB\u306B\u307E\u305F\u304C\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        annotationStringEscape: "\u578B\u5F0F\u306B\u30A8\u30B9\u30B1\u30FC\u30D7\u6587\u5B57\u3092\u542B\u3081\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        annotationTemplateString: "Type expressions cannot use template string literals (t-strings)",
        argAssignment: '\u578B "{argType}" \u306E\u5F15\u6570\u3092\u578B "{paramType}" \u306E\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306B\u5272\u308A\u5F53\u3066\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        argAssignmentFunction: '\u578B "{argType}" \u306E\u5F15\u6570\u3092\u95A2\u6570 "{functionName}" \u306E\u578B "{paramType}" \u306E\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306B\u5272\u308A\u5F53\u3066\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        argAssignmentParam: '\u578B "{argType}" \u306E\u5F15\u6570\u3092\u578B "{paramType}" \u306E\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{paramName}" \u306B\u5272\u308A\u5F53\u3066\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        argAssignmentParamFunction: '\u578B "{argType}" \u306E\u5F15\u6570\u3092\u3001\u95A2\u6570 "{functionName}" \u306E\u578B "{paramType}" \u306E\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{paramName}" \u306B\u5272\u308A\u5F53\u3066\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        argMissingForParam: "\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC {name} \u306B\u5F15\u6570\u304C\u3042\u308A\u307E\u305B\u3093",
        argMissingForParams: "\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC {names} \u306B\u5F15\u6570\u304C\u3042\u308A\u307E\u305B\u3093",
        argMorePositionalExpectedCount: "\u3055\u3089\u306B {expected} \u500B\u306E\u4F4D\u7F6E\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059",
        argMorePositionalExpectedOne: "\u3055\u3089\u306B 1 \u3064\u306E\u4F4D\u7F6E\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059",
        argPositional: "\u5FC5\u8981\u306A\u4F4D\u7F6E\u5F15\u6570",
        argPositionalExpectedCount: "{expected} \u500B\u306E\u4F4D\u7F6E\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059",
        argPositionalExpectedOne: "1 \u500B\u306E\u4F4D\u7F6E\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059",
        argTypePartiallyUnknown: "\u5F15\u6570\u306E\u578B\u304C\u90E8\u5206\u7684\u306B\u4E0D\u660E\u3067\u3059",
        argTypeUnknown: "\u5F15\u6570\u306E\u578B\u304C\u4E0D\u660E\u3067\u3059",
        assertAlwaysTrue: "Assert \u5F0F\u306F\u5E38\u306B true \u306B\u8A55\u4FA1\u3055\u308C\u307E\u3059",
        assertTypeArgs: '"assert_type" \u306B\u306F 2 \u3064\u306E\u4F4D\u7F6E\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059',
        assertTypeTypeMismatch: '"assert_type" \u306E\u4E0D\u4E00\u81F4: "{expected}" \u304C\u5FC5\u8981\u3067\u3059\u304C\u3001"{received}" \u3092\u53D7\u4FE1\u3057\u307E\u3057\u305F',
        assignmentExprComprehension: '\u4EE3\u5165\u5F0F\u306E\u30BF\u30FC\u30B2\u30C3\u30C8 "{name}" \u306F\u3001\u30BF\u30FC\u30B2\u30C3\u30C8\u306E\u7406\u89E3\u3068\u540C\u3058\u540D\u524D\u3092\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        assignmentExprContext: "\u4EE3\u5165\u5F0F\u306F\u3001\u30E2\u30B8\u30E5\u30FC\u30EB\u3001\u95A2\u6570\u3001\u307E\u305F\u306F\u30E9\u30E0\u30C0\u5185\u306B\u5B58\u5728\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        assignmentExprInSubscript: "\u4E0B\u4ED8\u304D\u6587\u5B57\u5185\u306E\u4EE3\u5165\u5F0F\u306F\u3001Python 3.10 \u4EE5\u964D\u3067\u306E\u307F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u307E\u3059",
        assignmentInProtocol: "Protocol \u30AF\u30E9\u30B9\u5185\u306E\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u5909\u6570\u307E\u305F\u306F\u30AF\u30E9\u30B9\u5909\u6570\u306F\u3001\u30AF\u30E9\u30B9\u672C\u4F53\u5185\u3067\u660E\u793A\u7684\u306B\u5BA3\u8A00\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        assignmentTargetExpr: "\u5F0F\u3092\u4EE3\u5165\u5148\u306B\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        asyncNotInAsyncFunction: 'async \u95A2\u6570\u306E\u5916\u90E8\u3067\u306F "async" \u306E\u4F7F\u7528\u306F\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        awaitIllegal: '"await" \u3092\u4F7F\u7528\u3059\u308B\u306B\u306F Python 3.5 \u4EE5\u964D\u304C\u5FC5\u8981\u3067\u3059',
        awaitNotAllowed: '\u578B\u5F0F\u3067\u306F\u3001"await" \u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        awaitNotInAsync: '"await" \u306F async \u95A2\u6570\u5185\u3067\u306E\u307F\u8A31\u53EF\u3055\u308C\u307E\u3059',
        backticksIllegal: "\u30D0\u30C3\u30AF\u30AF\u30A9\u30FC\u30C8\u3067\u56F2\u307E\u308C\u305F\u5F0F\u306F\u3001Python 3.x \u3067\u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093\u3002\u4EE3\u308F\u308A\u306B repr \u3092\u4F7F\u7528\u3057\u3066\u304F\u3060\u3055\u3044",
        baseClassCircular: "\u30AF\u30E9\u30B9\u81EA\u4F53\u304B\u3089\u6D3E\u751F\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        baseClassFinal: '\u57FA\u5E95\u30AF\u30E9\u30B9 "{type}" \u306F final \u3068\u30DE\u30FC\u30AF\u3055\u308C\u3066\u304A\u308A\u3001\u30B5\u30D6\u30AF\u30E9\u30B9\u5316\u3067\u304D\u307E\u305B\u3093',
        baseClassIncompatible: "{type} \u306E\u57FA\u5E95\u30AF\u30E9\u30B9\u306F\u76F8\u4E92\u306B\u4E92\u63DB\u6027\u304C\u3042\u308A\u307E\u305B\u3093",
        baseClassInvalid: "\u30AF\u30E9\u30B9\u3078\u306E\u5F15\u6570\u306F\u57FA\u5E95\u30AF\u30E9\u30B9\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        baseClassMethodTypeIncompatible: '"{classType}" \u306E\u57FA\u5E95\u30AF\u30E9\u30B9\u306F\u3001\u4E92\u63DB\u6027\u306E\u306A\u3044\u65B9\u6CD5\u3067\u30E1\u30BD\u30C3\u30C9 "{name}" \u3092\u5B9A\u7FA9\u3057\u307E\u3059',
        baseClassUnknown: "\u57FA\u5E95\u30AF\u30E9\u30B9\u306E\u578B\u304C\u4E0D\u660E\u3067\u3001\u6D3E\u751F\u30AF\u30E9\u30B9\u306E\u578B\u304C\u4E0D\u660E\u3067\u3059",
        baseClassVariableTypeIncompatible: '\u30AF\u30E9\u30B9 "{classType}" \u306E\u57FA\u5E95\u30AF\u30E9\u30B9\u306F\u3001\u4E92\u63DB\u6027\u306E\u306A\u3044\u65B9\u6CD5\u3067\u5909\u6570 "{name}" \u3092\u5B9A\u7FA9\u3057\u307E\u3059',
        binaryOperationNotAllowed: "2 \u9805\u6F14\u7B97\u5B50\u306F\u578B\u5F0F\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        bindParamMissing: '"self" \u307E\u305F\u306F "cls" \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u304C\u306A\u3044\u305F\u3081\u3001\u30E1\u30BD\u30C3\u30C9 "{methodName}" \u3092\u30D0\u30A4\u30F3\u30C9\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F',
        bindTypeMismatch: '"{type}" \u304C\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{paramName}" \u306B\u5272\u308A\u5F53\u3066\u3067\u304D\u306A\u3044\u305F\u3081\u3001\u30E1\u30BD\u30C3\u30C9 "{methodName}" \u3092\u30D0\u30A4\u30F3\u30C9\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F',
        breakInExceptionGroup: '"except*" \u30D6\u30ED\u30C3\u30AF\u3067\u306F "break" \u3092\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        breakOutsideLoop: '"break" \u306F\u30EB\u30FC\u30D7\u5185\u3067\u306E\u307F\u4F7F\u7528\u3067\u304D\u307E\u3059',
        bytesUnsupportedEscape: "bytes \u30EA\u30C6\u30E9\u30EB\u3067\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u306A\u3044\u30A8\u30B9\u30B1\u30FC\u30D7 \u30B7\u30FC\u30B1\u30F3\u30B9",
        callableExtraArgs: '"Callable" \u306B\u5FC5\u8981\u306A\u578B\u5F15\u6570\u306F 2 \u3064\u3060\u3051\u3067\u3059',
        callableFirstArg: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u578B\u30EA\u30B9\u30C8\u307E\u305F\u306F "..." \u304C\u5FC5\u8981\u3067\u3059\u3002',
        callableNotInstantiable: '\u578B "{type}" \u3092\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u5316\u3067\u304D\u307E\u305B\u3093',
        callableSecondArg: '"Callable" \u306E 2 \u756A\u76EE\u306E\u578B\u5F15\u6570\u3068\u3057\u3066\u623B\u308A\u5024\u306E\u578B\u304C\u5FC5\u8981\u3067\u3059',
        casePatternIsIrrefutable: "\u53C2\u7167\u4E0D\u53EF\u80FD\u306A\u30D1\u30BF\u30FC\u30F3\u306F\u3001\u6700\u5F8C\u306E case \u30B9\u30C6\u30FC\u30C8\u30E1\u30F3\u30C8\u306B\u5BFE\u3057\u3066\u306E\u307F\u8A31\u53EF\u3055\u308C\u307E\u3059",
        classAlreadySpecialized: '\u578B "{type}" \u306F\u65E2\u306B\u7279\u6B8A\u5316\u3055\u308C\u3066\u3044\u307E\u3059',
        classDecoratorTypeUnknown: "\u578B\u6307\u5B9A\u3055\u308C\u3066\u3044\u306A\u3044\u30AF\u30E9\u30B9 \u30C7\u30B3\u30EC\u30FC\u30BF\u30FC\u306F\u30AF\u30E9\u30B9\u306E\u578B\u3092\u96A0\u3057\u307E\u3059\u3002\u30C7\u30B3\u30EC\u30FC\u30BF\u30FC\u3092\u7121\u8996\u3059\u308B",
        classDefinitionCycle: '"{name}" \u306E\u30AF\u30E9\u30B9\u5B9A\u7FA9\u306F\u3001\u305D\u308C\u81EA\u4F53\u306B\u4F9D\u5B58\u3057\u307E\u3059',
        classGetItemClsParam: '__class_getitem__ override \u306F "cls" \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3092\u53D7\u3051\u53D6\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        classMethodClsParam: '\u30AF\u30E9\u30B9 \u30E1\u30BD\u30C3\u30C9\u306F "cls" \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3092\u53D7\u3051\u53D6\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        classNotRuntimeSubscriptable: '\u30AF\u30E9\u30B9 "{name}" \u306E\u6DFB\u5B57\u306F\u30E9\u30F3\u30BF\u30A4\u30E0\u4F8B\u5916\u3092\u751F\u6210\u3057\u307E\u3059\u3002\u578B\u5F0F\u3092\u5F15\u7528\u7B26\u3067\u56F2\u3093\u3067\u304F\u3060\u3055\u3044',
        classPatternBuiltInArgPositional: "\u30AF\u30E9\u30B9 \u30D1\u30BF\u30FC\u30F3\u306F\u4F4D\u7F6E\u6307\u5B9A\u30B5\u30D6\u30D1\u30BF\u30FC\u30F3\u306E\u307F\u3092\u53D7\u3051\u5165\u308C\u307E\u3059",
        classPatternNewType: '"{type}" cannot be used in a class pattern because it is defined using NewType',
        classPatternPositionalArgCount: '\u30AF\u30E9\u30B9 "{type}" \u306E\u4F4D\u7F6E\u6307\u5B9A\u30D1\u30BF\u30FC\u30F3\u304C\u591A\u3059\u304E\u307E\u3059\u3002{expected} \u304C\u5FC5\u8981\u3067\u3059\u304C\u3001{received} \u3092\u53D7\u4FE1\u3057\u307E\u3057\u305F',
        classPatternTypeAlias: '"{type}" \u306F\u7279\u6B8A\u306A\u578B\u30A8\u30A4\u30EA\u30A2\u30B9\u3067\u3042\u308B\u305F\u3081\u3001\u30AF\u30E9\u30B9 \u30D1\u30BF\u30FC\u30F3\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        classPropertyDeprecated: "\u30AF\u30E9\u30B9 \u30D7\u30ED\u30D1\u30C6\u30A3\u306F Python 3.11 \u3067\u306F\u975E\u63A8\u5968\u3067\u3042\u308A\u3001Python 3.13 \u3067\u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u306A\u304F\u306A\u308A\u307E\u3059",
        classTypeParametersIllegal: "\u30AF\u30E9\u30B9\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u69CB\u6587\u306B\u306F Python 3.12 \u4EE5\u964D\u304C\u5FC5\u8981\u3067\u3059",
        classVarFirstArgMissing: '"ClassVar" \u306E\u5F8C\u306B\u578B\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059',
        classVarNotAllowed: '"ClassVar" \u306F\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        classVarOverridesInstanceVar: '\u30AF\u30E9\u30B9\u5909\u6570 "{name}" \u306F\u3001\u30AF\u30E9\u30B9 "{className}" \u306E\u540C\u3058\u540D\u524D\u306E\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u5909\u6570\u3092\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u3057\u307E\u3059',
        classVarTooManyArgs: '"ClassVar" \u306E\u5F8C\u306B\u5FC5\u8981\u306A\u578B\u5F15\u6570\u306F 1 \u3064\u3060\u3051\u3067\u3059',
        classVarWithTypeVar: '"ClassVar" \u578B\u306B\u578B\u5909\u6570\u3092\u542B\u3081\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        clsSelfParamTypeMismatch: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u306E\u578B\u306F\u3001\u305D\u306E\u30AF\u30E9\u30B9 "{classType}" \u306E\u30B9\u30FC\u30D1\u30FC\u30BF\u30A4\u30D7\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        codeTooComplexToAnalyze: "\u30B3\u30FC\u30C9\u304C\u8907\u96D1\u3059\u304E\u308B\u305F\u3081\u3001\u5206\u6790\u3067\u304D\u307E\u305B\u3093\u3002\u30B5\u30D6\u30EB\u30FC\u30C1\u30F3\u306B\u30EA\u30D5\u30A1\u30AF\u30BF\u30EA\u30F3\u30B0\u3059\u308B\u304B\u3001\u6761\u4EF6\u4ED8\u304D\u30B3\u30FC\u30C9 \u30D1\u30B9\u3092\u6E1B\u3089\u3059\u3053\u3068\u3067\u8907\u96D1\u3055\u3092\u8EFD\u6E1B\u3057\u3066\u304F\u3060\u3055\u3044",
        collectionAliasInstantiation: '\u578B "{type}" \u306F\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u5316\u3067\u304D\u307E\u305B\u3093\u3002\u4EE3\u308F\u308A\u306B "{alias}" \u3092\u4F7F\u7528\u3057\u3066\u304F\u3060\u3055\u3044',
        comparisonAlwaysFalse: '\u578B "{leftType}" \u3068 "{rightType}" \u306B\u91CD\u8907\u304C\u306A\u3044\u305F\u3081\u3001\u6761\u4EF6\u306F\u5E38\u306B False \u306B\u8A55\u4FA1\u3055\u308C\u307E\u3059',
        comparisonAlwaysTrue: '\u578B "{leftType}" \u3068 "{rightType}" \u306B\u91CD\u8907\u304C\u306A\u3044\u305F\u3081\u3001\u6761\u4EF6\u306F\u5E38\u306B True \u306B\u8A55\u4FA1\u3055\u308C\u307E\u3059',
        comprehensionInDict: "\u4ED6\u306E\u8F9E\u66F8\u30A8\u30F3\u30C8\u30EA\u3068\u5171\u306B\u7406\u89E3\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        comprehensionInSet: "\u8AAD\u89E3\u306F\u4ED6\u306E set \u30A8\u30F3\u30C8\u30EA\u3068\u4F75\u7528\u3067\u304D\u307E\u305B\u3093\u3002",
        concatenateContext: '"Concatenate" \u306F\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        concatenateParamSpecMissing: '"Concatenate" \u306E\u6700\u5F8C\u306E\u578B\u5F15\u6570\u306F ParamSpec \u307E\u305F\u306F "..." \u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        concatenateTypeArgsMissing: '"Concatenate" \u306B\u306F\u5C11\u306A\u304F\u3068\u3082 2 \u3064\u306E\u578B\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059',
        conditionalOperandInvalid: '\u578B "{type}" \u306E\u6761\u4EF6\u30AA\u30DA\u30E9\u30F3\u30C9\u304C\u7121\u52B9\u3067\u3059',
        constantRedefinition: '"{name}" \u306F\u5B9A\u6570\u3067\u3042\u308A (\u5927\u6587\u5B57\u3067\u3042\u308B\u305F\u3081)\u3001\u518D\u5B9A\u7FA9\u3067\u304D\u307E\u305B\u3093',
        constructorParametersMismatch: '\u30AF\u30E9\u30B9 "{classType}" \u306E__new__\u3068__init__\u306E\u30B7\u30B0\u30CD\u30C1\u30E3\u306E\u4E0D\u4E00\u81F4',
        containmentAlwaysFalse: '\u578B "{leftType}" \u3068 "{rightType}" \u306B\u91CD\u8907\u304C\u306A\u3044\u305F\u3081\u3001\u5F0F\u306F\u5E38\u306B False \u306B\u8A55\u4FA1\u3055\u308C\u307E\u3059',
        containmentAlwaysTrue: '\u578B "{leftType}" \u3068 "{rightType}" \u306B\u91CD\u8907\u304C\u306A\u3044\u305F\u3081\u3001\u5F0F\u306F\u5E38\u306B True \u306B\u8A55\u4FA1\u3055\u308C\u307E\u3059',
        continueInExceptionGroup: '"except*" \u30D6\u30ED\u30C3\u30AF\u3067\u306F "continue" \u3092\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        continueOutsideLoop: '"continue" \u306F\u30EB\u30FC\u30D7\u5185\u3067\u306E\u307F\u4F7F\u7528\u3067\u304D\u307E\u3059',
        coroutineInConditionalExpression: "\u5E38\u306B True \u306B\u8A55\u4FA1\u3055\u308C\u308B\u6761\u4EF6\u5F0F\u53C2\u7167\u30B3\u30EB\u30FC\u30C1\u30F3",
        dataClassBaseClassFrozen: "\u56FA\u5B9A\u3055\u308C\u3066\u3044\u306A\u3044\u30AF\u30E9\u30B9\u306F\u3001\u56FA\u5B9A\u3055\u308C\u3066\u3044\u308B\u30AF\u30E9\u30B9\u304B\u3089\u7D99\u627F\u3067\u304D\u307E\u305B\u3093",
        dataClassBaseClassNotFrozen: "\u56FA\u5B9A\u3055\u308C\u305F\u30AF\u30E9\u30B9\u306F\u3001\u56FA\u5B9A\u3055\u308C\u3066\u3044\u306A\u3044\u30AF\u30E9\u30B9\u304B\u3089\u7D99\u627F\u3067\u304D\u307E\u305B\u3093",
        dataClassConverterFunction: '\u578B "{argType}" \u306E\u5F15\u6570\u306F\u3001\u578B "{fieldType}" \u306E\u30D5\u30A3\u30FC\u30EB\u30C9 "{fieldName}" \u306E\u6709\u52B9\u306A\u30B3\u30F3\u30D0\u30FC\u30BF\u30FC\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        dataClassConverterOverloads: '{funcName}" \u306E\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9\u306F\u3001\u578B "{fieldType}" \u306E\u30D5\u30A3\u30FC\u30EB\u30C9 "{fieldName}" \u306B\u5BFE\u3057\u3066\u6709\u52B9\u306A\u30B3\u30F3\u30D0\u30FC\u30BF\u30FC\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        dataClassFieldInheritedDefault: '"{fieldName}" \u306F\u540C\u3058\u540D\u524D\u306E\u30D5\u30A3\u30FC\u30EB\u30C9\u3092\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u3057\u307E\u3059\u304C\u3001\u65E2\u5B9A\u5024\u304C\u3042\u308A\u307E\u305B\u3093',
        dataClassFieldWithDefault: "\u65E2\u5B9A\u5024\u306E\u306A\u3044\u30D5\u30A3\u30FC\u30EB\u30C9\u306F\u3001\u65E2\u5B9A\u5024\u3092\u6301\u3064\u30D5\u30A3\u30FC\u30EB\u30C9\u306E\u5F8C\u306B\u8868\u793A\u3067\u304D\u307E\u305B\u3093",
        dataClassFieldWithPrivateName: "\u30C7\u30FC\u30BF\u30AF\u30E9\u30B9 \u30D5\u30A3\u30FC\u30EB\u30C9\u306F\u30D7\u30E9\u30A4\u30D9\u30FC\u30C8\u540D\u3092\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        dataClassFieldWithoutAnnotation: "\u578B\u6CE8\u91C8\u306E\u306A\u3044\u30C7\u30FC\u30BF\u30AF\u30E9\u30B9 \u30D5\u30A3\u30FC\u30EB\u30C9\u304C\u539F\u56E0\u3067\u30E9\u30F3\u30BF\u30A4\u30E0\u4F8B\u5916\u304C\u767A\u751F\u3059\u308B",
        dataClassPostInitParamCount: "Dataclass __post_init__ \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u6570\u304C\u6B63\u3057\u304F\u3042\u308A\u307E\u305B\u3093\u3002InitVar \u30D5\u30A3\u30FC\u30EB\u30C9\u306E\u6570\u306F {expected} \u3067\u3059",
        dataClassPostInitType: '\u30D5\u30A3\u30FC\u30EB\u30C9 "{fieldName}" \u306E Dataclass __post_init__ \u30E1\u30BD\u30C3\u30C9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u578B\u304C\u4E00\u81F4\u3057\u307E\u305B\u3093',
        dataClassSlotsOverwrite: "__slots__\u306F\u30AF\u30E9\u30B9\u3067\u65E2\u306B\u5B9A\u7FA9\u3055\u308C\u3066\u3044\u307E\u3059",
        dataClassTransformExpectedBoolLiteral: "\u9759\u7684\u306B True \u307E\u305F\u306F False \u306B\u8A55\u4FA1\u3055\u308C\u308B\u5F0F\u304C\u5FC5\u8981\u3067\u3059",
        dataClassTransformFieldSpecifier: '\u30AF\u30E9\u30B9\u307E\u305F\u306F\u95A2\u6570\u306E tuple \u304C\u5FC5\u8981\u3067\u3059\u304C\u3001\u578B "{type}" \u3092\u53D7\u3051\u53D6\u308A\u307E\u3057\u305F',
        dataClassTransformPositionalParam: '"dataclass_transform" \u306B\u5BFE\u3059\u308B\u3059\u3079\u3066\u306E\u5F15\u6570\u306F\u30AD\u30FC\u30EF\u30FC\u30C9\u5F15\u6570\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        dataClassTransformUnknownArgument: '\u5F15\u6570 "{name}" \u306Fdataclass_transform \u3067\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        dataProtocolInSubclassCheck: "\u30C7\u30FC\u30BF \u30D7\u30ED\u30C8\u30B3\u30EB (\u30E1\u30BD\u30C3\u30C9\u4EE5\u5916\u306E\u5C5E\u6027\u3092\u542B\u3080) \u306F\u3001issubclass \u547C\u3073\u51FA\u3057\u3067\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        declaredReturnTypePartiallyUnknown: '\u5BA3\u8A00\u3055\u308C\u305F\u623B\u308A\u5024\u306E\u578B "{returnType}" \u306F\u90E8\u5206\u7684\u306B\u4E0D\u660E\u3067\u3059',
        declaredReturnTypeUnknown: "\u5BA3\u8A00\u3055\u308C\u305F\u623B\u308A\u5024\u306E\u578B\u304C\u4E0D\u660E\u3067\u3059",
        defaultValueContainsCall: "\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u65E2\u5B9A\u5024\u306E\u5F0F\u5185\u3067\u306F\u3001\u95A2\u6570\u547C\u3073\u51FA\u3057\u3068\u5909\u66F4\u53EF\u80FD\u306A\u30AA\u30D6\u30B8\u30A7\u30AF\u30C8\u306F\u8A31\u53EF\u3055\u308C\u307E\u305B\u3093",
        defaultValueNotAllowed: '"*" \u307E\u305F\u306F "**" \u306E\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306B\u65E2\u5B9A\u5024\u3092\u6307\u5B9A\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        delTargetExpr: "\u5F0F\u3092\u524A\u9664\u3067\u304D\u307E\u305B\u3093",
        deprecatedClass: '\u30AF\u30E9\u30B9 "{name}" \u306F\u975E\u63A8\u5968\u3067\u3059',
        deprecatedConstructor: '\u30AF\u30E9\u30B9 "{name}" \u306E\u30B3\u30F3\u30B9\u30C8\u30E9\u30AF\u30BF\u30FC\u306F\u975E\u63A8\u5968\u3067\u3059',
        deprecatedDescriptorDeleter: '\u8A18\u8FF0\u5B50 "{name}" \u306E "__delete__" \u30E1\u30BD\u30C3\u30C9\u306F\u975E\u63A8\u5968\u3067\u3059',
        deprecatedDescriptorGetter: '\u8A18\u8FF0\u5B50 "{name}" \u306E "__get__" \u30E1\u30BD\u30C3\u30C9\u306F\u975E\u63A8\u5968\u3067\u3059',
        deprecatedDescriptorSetter: '\u8A18\u8FF0\u5B50 "{name}" \u306E "__set__" \u30E1\u30BD\u30C3\u30C9\u306F\u975E\u63A8\u5968\u3067\u3059',
        deprecatedFunction: '\u95A2\u6570 "{name}" \u306F\u975E\u63A8\u5968\u3067\u3059',
        deprecatedMethod: '\u30AF\u30E9\u30B9 "{className}" \u306E\u30E1\u30BD\u30C3\u30C9 "{name}" \u306F\u975E\u63A8\u5968\u3067\u3059',
        deprecatedPropertyDeleter: 'The deleter for property "{name}" is deprecated',
        deprecatedPropertyGetter: 'The getter for property "{name}" is deprecated',
        deprecatedPropertySetter: 'The setter for property "{name}" is deprecated',
        deprecatedType: '\u3053\u306E\u578B\u306F Python {version} \u3067\u306F\u975E\u63A8\u5968\u3067\u3059\u3002\u4EE3\u308F\u308A\u306B"{replacement}"\u3092\u4F7F\u7528\u3057\u3066\u304F\u3060\u3055\u3044',
        dictExpandIllegalInComprehension: "\u8F9E\u66F8\u306E\u5C55\u958B\u306F\u7406\u89E3\u3067\u304D\u307E\u305B\u3093",
        dictInAnnotation: "\u8F9E\u66F8\u5F0F\u306F\u578B\u5F0F\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        dictKeyValuePairs: "\u8F9E\u66F8\u30A8\u30F3\u30C8\u30EA\u306B\u306F\u30AD\u30FC/\u5024\u306E\u30DA\u30A2\u304C\u542B\u307E\u308C\u3066\u3044\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        dictUnpackIsNotMapping: "\u30C7\u30A3\u30AF\u30B7\u30E7\u30CA\u30EA \u30A2\u30F3\u30D1\u30C3\u30AF\u6F14\u7B97\u5B50\u306B\u5FC5\u8981\u306A\u30DE\u30C3\u30D4\u30F3\u30B0",
        dunderAllSymbolNotPresent: '"{name}" \u306F __all__ \u3067\u6307\u5B9A\u3055\u308C\u3066\u3044\u307E\u3059\u304C\u3001\u30E2\u30B8\u30E5\u30FC\u30EB\u306B\u306F\u5B58\u5728\u3057\u307E\u305B\u3093',
        duplicateArgsParam: '\u8A31\u53EF\u3055\u308C\u308B "*" \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306F 1 \u3064\u3060\u3051\u3067\u3059',
        duplicateBaseClass: "\u91CD\u8907\u3059\u308B\u57FA\u5E95\u30AF\u30E9\u30B9\u306F\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        duplicateCapturePatternTarget: 'Capture \u30BF\u30FC\u30B2\u30C3\u30C8 "{name}" \u3092\u540C\u3058\u30D1\u30BF\u30FC\u30F3\u5185\u306B\u8907\u6570\u56DE\u51FA\u73FE\u3055\u305B\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        duplicateCatchAll: "\u8A31\u53EF\u3055\u308C\u308B catch-all except \u53E5\u306F 1 \u3064\u3060\u3051\u3067\u3059",
        duplicateEnumMember: 'Enum \u30E1\u30F3\u30D0\u30FC "{name}" \u306F\u65E2\u306B\u5BA3\u8A00\u3055\u308C\u3066\u3044\u307E\u3059',
        duplicateGenericAndProtocolBase: "\u8A31\u53EF\u3055\u308C\u308B Generic[...] \u307E\u305F\u306F Protocol[...] \u57FA\u5E95\u30AF\u30E9\u30B9\u306F 1 \u3064\u3060\u3051\u3067\u3059",
        duplicateImport: '"{importName}" \u304C\u8907\u6570\u56DE\u30A4\u30F3\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u3059',
        duplicateKeywordOnly: '"*" \u533A\u5207\u308A\u8A18\u53F7\u3092 1 \u3064\u3060\u3051\u4F7F\u7528\u3067\u304D\u307E\u3059',
        duplicateKwargsParam: '\u8A31\u53EF\u3055\u308C\u308B "**" \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306F 1 \u3064\u3060\u3051\u3067\u3059',
        duplicateParam: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u304C\u91CD\u8907\u3057\u3066\u3044\u307E\u3059',
        duplicatePositionOnly: '\u8A31\u53EF\u3055\u308C\u308B "/" \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306F 1 \u3064\u3060\u3051\u3067\u3059',
        duplicateStarPattern: '\u30D1\u30BF\u30FC\u30F3 \u30B7\u30FC\u30B1\u30F3\u30B9\u3067\u4F7F\u7528\u3067\u304D\u308B "*" \u30D1\u30BF\u30FC\u30F3\u306F 1 \u3064\u3060\u3051\u3067\u3059',
        duplicateStarStarPattern: '\u8A31\u53EF\u3055\u308C\u3066\u3044\u308B "**" \u30A8\u30F3\u30C8\u30EA\u306F 1 \u3064\u3060\u3051\u3067\u3059',
        duplicateUnpack: "list \u5185\u3067\u8A31\u53EF\u3055\u308C\u308B\u30A2\u30F3\u30D1\u30C3\u30AF\u64CD\u4F5C\u306F 1 \u3064\u306E\u307F\u3067\u3059",
        ellipsisAfterUnpacked: '"..." \u306F\u30A2\u30F3\u30D1\u30C3\u30AF\u3055\u308C\u305F TypeVarTuple \u307E\u305F\u306F tuple \u3068\u5171\u306B\u4F7F\u7528\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        ellipsisContext: '"..." \u306F\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        ellipsisSecondArg: '"..." \u306F2 \u3064\u306E\u5F15\u6570\u306E 2 \u756A\u76EE\u306E\u5F15\u6570\u3068\u3057\u3066\u306E\u307F\u4F7F\u7528\u3067\u304D\u307E\u3059',
        enumClassOverride: 'Enum \u30AF\u30E9\u30B9 "{name}" \u306F final \u3067\u3042\u308A\u3001\u30B5\u30D6\u30AF\u30E9\u30B9\u5316\u3067\u304D\u307E\u305B\u3093',
        enumMemberDelete: 'Enum \u30E1\u30F3\u30D0\u30FC "{name}" \u3092\u524A\u9664\u3067\u304D\u307E\u305B\u3093',
        enumMemberSet: 'Enum \u30E1\u30F3\u30D0\u30FC "{name}" \u3092\u5272\u308A\u5F53\u3066\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        enumMemberTypeAnnotation: "Type annotations are not allowed for enum members",
        exceptGroupMismatch: 'Try \u30B9\u30C6\u30FC\u30C8\u30E1\u30F3\u30C8\u306B "except" \u3068 "except*" \u306E\u4E21\u65B9\u3092\u542B\u3081\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        exceptGroupRequiresType: '\u4F8B\u5916\u30B0\u30EB\u30FC\u30D7\u69CB\u6587 ("except*") \u306B\u306F\u4F8B\u5916\u306E\u7A2E\u985E\u304C\u5FC5\u8981\u3067\u3059',
        exceptRequiresParens: "Multiple exception types must be parenthesized prior to Python 3.14",
        exceptWithAsRequiresParens: 'Multiple exception types must be parenthesized when using "as"',
        exceptionGroupIncompatible: '\u4F8B\u5916\u30B0\u30EB\u30FC\u30D7\u306E\u69CB\u6587 ("except*") \u306B\u306F Python 3.11 \u4EE5\u964D\u304C\u5FC5\u8981\u3067\u3059',
        exceptionGroupTypeIncorrect: "except* \u306E\u4F8B\u5916\u578B\u306F BaseGroupException \u304B\u3089\u6D3E\u751F\u3067\u304D\u307E\u305B\u3093",
        exceptionTypeIncorrect: '"{type}" \u306F BaseException \u304B\u3089\u6D3E\u751F\u3057\u3066\u3044\u307E\u305B\u3093',
        exceptionTypeNotClass: '"{type}" \u306F\u6709\u52B9\u306A\u4F8B\u5916\u30AF\u30E9\u30B9\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        exceptionTypeNotInstantiable: '\u4F8B\u5916\u306E\u7A2E\u985E "{type}" \u306E\u30B3\u30F3\u30B9\u30C8\u30E9\u30AF\u30BF\u30FC\u306B\u306F 1 \u3064\u4EE5\u4E0A\u306E\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059',
        expectedAfterDecorator: "\u30C7\u30B3\u30EC\u30FC\u30BF\u30FC\u306E\u5F8C\u306B\u5FC5\u8981\u306A\u95A2\u6570\u307E\u305F\u306F\u30AF\u30E9\u30B9\u5BA3\u8A00",
        expectedArrow: '"->" \u306E\u5F8C\u306B\u623B\u308A\u5024\u306E\u578B\u6CE8\u91C8\u304C\u7D9A\u304F\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        expectedAsAfterException: '\u4F8B\u5916\u306E\u7A2E\u985E\u306E\u5F8C\u306B "as" \u304C\u5FC5\u8981\u3067\u3059',
        expectedAssignRightHandExpr: '"=" \u306E\u53F3\u5074\u306B\u5F0F\u304C\u5FC5\u8981\u3067\u3059',
        expectedBinaryRightHandExpr: "\u6F14\u7B97\u5B50\u306E\u53F3\u5074\u306B\u5F0F\u304C\u5FC5\u8981\u3067\u3059",
        expectedBoolLiteral: "True \u307E\u305F\u306F False \u304C\u5FC5\u8981\u3067\u3059",
        expectedCase: '"case" \u30B9\u30C6\u30FC\u30C8\u30E1\u30F3\u30C8\u304C\u5FC5\u8981\u3067\u3059',
        expectedClassName: "\u5FC5\u8981\u306A\u30AF\u30E9\u30B9\u540D",
        expectedCloseBrace: '"{" \u306F\u9589\u3058\u3089\u308C\u3066\u3044\u307E\u305B\u3093',
        expectedCloseBracket: '"[" \u306F\u9589\u3058\u3089\u308C\u3066\u3044\u307E\u305B\u3093',
        expectedCloseParen: '"(" \u304C\u9589\u3058\u3089\u308C\u307E\u305B\u3093\u3067\u3057\u305F',
        expectedColon: '":" \u304C\u5FC5\u8981\u3067\u3059',
        expectedComplexNumberLiteral: "\u30D1\u30BF\u30FC\u30F3 \u30DE\u30C3\u30C1\u30F3\u30B0\u306B\u5FC5\u8981\u306A\u8907\u7D20\u6570\u30EA\u30C6\u30E9\u30EB",
        expectedDecoratorExpr: "Python 3.9 \u3088\u308A\u524D\u306E\u30C7\u30B3\u30EC\u30FC\u30BF\u30FC\u3067\u306F\u3001\u5F0F\u30D5\u30A9\u30FC\u30E0\u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        expectedDecoratorName: "\u30C7\u30B3\u30EC\u30FC\u30BF\u30FC\u540D\u304C\u5FC5\u8981\u3067\u3059",
        expectedDecoratorNewline: "\u30C7\u30B3\u30EC\u30FC\u30BF\u30FC\u306E\u672B\u5C3E\u306B\u65B0\u3057\u3044\u884C\u304C\u5FC5\u8981\u3067\u3059",
        expectedDelExpr: '"del" \u306E\u5F8C\u306B\u5F0F\u304C\u5FC5\u8981\u3067\u3059',
        expectedElse: '"else" \u304C\u5FC5\u8981\u3067\u3059',
        expectedEquals: '"=" \u304C\u5FC5\u8981\u3067\u3059',
        expectedExceptionClass: "\u4F8B\u5916\u30AF\u30E9\u30B9\u307E\u305F\u306F\u30AA\u30D6\u30B8\u30A7\u30AF\u30C8\u304C\u7121\u52B9\u3067\u3059",
        expectedExceptionObj: "\u4F8B\u5916\u30AA\u30D6\u30B8\u30A7\u30AF\u30C8\u3001\u4F8B\u5916\u30AF\u30E9\u30B9\u3001\u307E\u305F\u306F None \u304C\u5FC5\u8981\u3067\u3059",
        expectedExpr: "\u5F0F\u304C\u5FC5\u8981\u3067\u3059",
        expectedFunctionAfterAsync: '"async" \u306E\u5F8C\u306B\u5FC5\u8981\u306A\u95A2\u6570\u5B9A\u7FA9',
        expectedFunctionName: '"def" \u306E\u5F8C\u306B\u95A2\u6570\u540D\u304C\u5FC5\u8981\u3067\u3059',
        expectedIdentifier: "\u5FC5\u8981\u306A\u8B58\u5225\u5B50",
        expectedImport: '"import" \u304C\u5FC5\u8981\u3067\u3059',
        expectedImportAlias: '"as" \u306E\u5F8C\u306B\u30B7\u30F3\u30DC\u30EB\u304C\u5FC5\u8981\u3067\u3059',
        expectedImportSymbols: '"import" \u306E\u5F8C\u306B 1 \u3064\u4EE5\u4E0A\u306E\u30B7\u30F3\u30DC\u30EB\u540D\u304C\u5FC5\u8981\u3067\u3059',
        expectedIn: "'in' \u304C\u5FC5\u8981\u3067\u3059",
        expectedInExpr: '"in" \u306E\u5F8C\u306B\u5F0F\u304C\u5FC5\u8981\u3067\u3059',
        expectedIndentedBlock: "\u30A4\u30F3\u30C7\u30F3\u30C8\u3055\u308C\u305F\u30D6\u30ED\u30C3\u30AF\u304C\u5FC5\u8981\u3067\u3059",
        expectedMemberName: '"" \u306E\u5F8C\u306B\u5C5E\u6027\u540D\u304C\u5FC5\u8981\u3067\u3059\u3002',
        expectedModuleName: "\u5FC5\u8981\u306A\u30E2\u30B8\u30E5\u30FC\u30EB\u540D",
        expectedNameAfterAs: '"as" \u306E\u5F8C\u306B\u30B7\u30F3\u30DC\u30EB\u540D\u304C\u5FC5\u8981\u3067\u3059',
        expectedNamedParameter: '\u30AD\u30FC\u30EF\u30FC\u30C9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306F "*" \u306E\u5F8C\u306B\u7D9A\u304F\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        expectedNewline: "\u6539\u884C\u304C\u5FC5\u8981\u3067\u3059",
        expectedNewlineOrSemicolon: "\u30B9\u30C6\u30FC\u30C8\u30E1\u30F3\u30C8\u306F\u6539\u884C\u307E\u305F\u306F\u30BB\u30DF\u30B3\u30ED\u30F3\u3067\u533A\u5207\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        expectedOpenParen: '"(" \u304C\u5FC5\u8981\u3067\u3059',
        expectedParamName: "\u5FC5\u8981\u306A\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u540D",
        expectedPatternExpr: "\u5FC5\u8981\u306A\u30D1\u30BF\u30FC\u30F3\u5F0F",
        expectedPatternSubjectExpr: "\u5FC5\u8981\u306A\u30D1\u30BF\u30FC\u30F3\u306E\u4EF6\u540D\u306E\u5F0F",
        expectedPatternValue: '"a.b" \u5F62\u5F0F\u306E\u30D1\u30BF\u30FC\u30F3\u5024\u5F0F\u304C\u5FC5\u8981\u3067\u3059',
        expectedReturnExpr: '"return" \u306E\u5F8C\u306B\u5F0F\u304C\u5FC5\u8981\u3067\u3059',
        expectedSliceIndex: "\u30A4\u30F3\u30C7\u30C3\u30AF\u30B9\u307E\u305F\u306F\u30B9\u30E9\u30A4\u30B9\u5F0F\u304C\u5FC5\u8981\u3067\u3059",
        expectedTypeNotString: "\u5FC5\u8981\u306A\u578B\u3067\u3059\u304C\u3001\u6587\u5B57\u5217\u30EA\u30C6\u30E9\u30EB\u3092\u53D7\u3051\u53D6\u308A\u307E\u3057\u305F",
        expectedTypeParameterName: "\u5FC5\u8981\u306A\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u540D",
        expectedYieldExpr: "yield \u30B9\u30C6\u30FC\u30C8\u30E1\u30F3\u30C8\u3067\u5FC5\u8981\u306A\u5F0F",
        finalClassIsAbstract: '\u30AF\u30E9\u30B9 "{type}" \u306F final \u3068\u30DE\u30FC\u30AF\u3055\u308C\u3066\u304A\u308A\u3001\u3059\u3079\u3066\u306E\u62BD\u8C61\u306A\u30B7\u30F3\u30DC\u30EB\u3092\u5B9F\u88C5\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        finalContext: '"Final" \u306F\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        finalInLoop: '"Final" \u5909\u6570\u3092\u30EB\u30FC\u30D7\u5185\u3067\u5272\u308A\u5F53\u3066\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        finalMethodOverride: '\u30E1\u30BD\u30C3\u30C9 "{name}" \u306F\u3001\u30AF\u30E9\u30B9 "{className}" \u3067\u5B9A\u7FA9\u3055\u308C\u3066\u3044\u308B final \u30E1\u30BD\u30C3\u30C9\u3092\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u3067\u304D\u307E\u305B\u3093',
        finalNonMethod: '\u95A2\u6570 "{name}" \u306F\u30E1\u30BD\u30C3\u30C9\u3067\u306F\u306A\u3044\u305F\u3081\u3001@final \u3068\u3057\u3066\u30DE\u30FC\u30AF\u3067\u304D\u307E\u305B\u3093',
        finalReassigned: '"{name}" \u306F Final \u3068\u3057\u3066\u5BA3\u8A00\u3055\u308C\u3066\u304A\u308A\u3001\u518D\u5272\u308A\u5F53\u3066\u3067\u304D\u307E\u305B\u3093',
        finalRedeclaration: '"{name}" \u306F\u4EE5\u524D\u306B Final \u3068\u3057\u3066\u5BA3\u8A00\u3055\u308C\u307E\u3057\u305F',
        finalRedeclarationBySubclass: '\u89AA\u30AF\u30E9\u30B9 "{className}" \u304C Final \u3068\u3057\u3066\u5BA3\u8A00\u3057\u3066\u3044\u308B\u305F\u3081\u3001"{name}" \u3092\u518D\u5BA3\u8A00\u3067\u304D\u307E\u305B\u3093',
        finalTooManyArgs: '"Final" \u306E\u5F8C\u306B 1 \u3064\u306E\u578B\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059',
        finalUnassigned: '"{name}" \u306F Final \u3068\u5BA3\u8A00\u3055\u308C\u3066\u3044\u307E\u3059\u304C\u3001\u5024\u306F\u5272\u308A\u5F53\u3066\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        finallyBreak: '"break" \u3092\u4F7F\u7528\u3057\u3066 "finally" \u30D6\u30ED\u30C3\u30AF\u3092\u7D42\u4E86\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        finallyContinue: '"continue" \u3092\u4F7F\u7528\u3057\u3066 "finally" \u30D6\u30ED\u30C3\u30AF\u3092\u7D42\u4E86\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        finallyReturn: '"return" \u3092\u4F7F\u7528\u3057\u3066 "finally" \u30D6\u30ED\u30C3\u30AF\u3092\u7D42\u4E86\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        formatStringBrace: "f-string \u30EA\u30C6\u30E9\u30EB\u5185\u3067\u306F\u30011 \u3064\u306E\u9589\u3058\u304B\u3063\u3053\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093\u3002\u4E8C\u91CD\u9589\u3058\u304B\u3063\u3053\u3092\u4F7F\u7528\u3057\u3066\u304F\u3060\u3055\u3044",
        formatStringBytes: "\u66F8\u5F0F\u6307\u5B9A\u6587\u5B57\u5217\u30EA\u30C6\u30E9\u30EB (f \u6587\u5B57\u5217) \u3092\u30D0\u30A4\u30CA\u30EA\u306B\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        formatStringDebuggingIllegal: 'F-string \u30C7\u30D0\u30C3\u30B0\u6307\u5B9A\u5B50 "=" \u306B\u306F Python 3.8 \u4EE5\u964D\u304C\u5FC5\u8981\u3067\u3059',
        formatStringEscape: "Python 3.12 \u3088\u308A\u524D\u306E f-string \u306E\u5F0F\u90E8\u5206\u3067\u306F\u30A8\u30B9\u30B1\u30FC\u30D7 \u30B7\u30FC\u30B1\u30F3\u30B9 (\u30D0\u30C3\u30AF\u30B9\u30E9\u30C3\u30B7\u30E5) \u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        formatStringExpectedConversion: 'f-string \u306E "!" \u306E\u5F8C\u306B\u5909\u63DB\u6307\u5B9A\u5B50\u304C\u5FC5\u8981\u3067\u3059',
        formatStringIllegal: "\u66F8\u5F0F\u6587\u5B57\u5217\u30EA\u30C6\u30E9\u30EB (f \u6587\u5B57\u5217) \u306B\u306F Python 3.6 \u4EE5\u964D\u304C\u5FC5\u8981\u3067\u3059",
        formatStringInPattern: "\u66F8\u5F0F\u6307\u5B9A\u6587\u5B57\u5217\u306F\u30D1\u30BF\u30FC\u30F3\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        formatStringNestedFormatSpecifier: "\u66F8\u5F0F\u6307\u5B9A\u5B50\u5185\u3067\u5165\u308C\u5B50\u306B\u306A\u3063\u305F\u5F0F\u304C\u6DF1\u3059\u304E\u307E\u3059",
        formatStringNestedQuote: "f-string \u5185\u3067\u5165\u308C\u5B50\u306B\u306A\u3063\u305F\u6587\u5B57\u5217\u306F\u3001Python 3.12 \u3088\u308A\u524D\u306E f-string \u3068\u540C\u3058\u5F15\u7528\u7B26\u6587\u5B57\u3092\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        formatStringTemplate: "Format string literals (f-strings) cannot also be template strings (t-strings)",
        formatStringUnicode: "\u66F8\u5F0F\u6307\u5B9A\u6587\u5B57\u5217\u30EA\u30C6\u30E9\u30EB (f \u6587\u5B57\u5217) \u3092 Unicode \u306B\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        formatStringUnterminated: 'f-string \u306E\u5F0F\u304C\u7D42\u4E86\u3057\u3066\u3044\u307E\u305B\u3093\u3002"}" \u304C\u5FC5\u8981\u3067\u3059',
        functionDecoratorTypeUnknown: "\u578B\u6307\u5B9A\u3055\u308C\u3066\u3044\u306A\u3044\u95A2\u6570\u30C7\u30B3\u30EC\u30FC\u30BF\u30FC\u306F\u3001\u95A2\u6570\u306E\u578B\u3092\u96A0\u3057\u307E\u3059\u3002\u30C7\u30B3\u30EC\u30FC\u30BF\u30FC\u3092\u7121\u8996\u3057\u3066\u3044\u307E\u3059",
        functionInConditionalExpression: "\u5E38\u306B True \u306B\u8A55\u4FA1\u3055\u308C\u308B\u6761\u4EF6\u5F0F\u53C2\u7167\u95A2\u6570",
        functionTypeParametersIllegal: "\u95A2\u6570\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u69CB\u6587\u306B\u306F Python 3.12 \u4EE5\u964D\u304C\u5FC5\u8981\u3067\u3059",
        futureImportLocationNotAllowed: "__future__ \u304B\u3089\u306E\u30A4\u30F3\u30DD\u30FC\u30C8\u306F\u3001\u30D5\u30A1\u30A4\u30EB\u306E\u5148\u982D\u306B\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        generatorAsyncReturnType: 'async \u30B8\u30A7\u30CD\u30EC\u30FC\u30BF\u30FC\u95A2\u6570\u306E\u623B\u308A\u5024\u306E\u578B\u306F\u3001"AsyncGenerator[{yieldType}, Any]" \u3068\u4E92\u63DB\u6027\u304C\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        generatorNotParenthesized: "\u30B8\u30A7\u30CD\u30EC\u30FC\u30BF\u30FC\u5F0F\u306F\u3001\u552F\u4E00\u306E\u5F15\u6570\u3067\u306A\u3044\u5834\u5408\u306F\u304B\u3063\u3053\u3067\u56F2\u3080\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        generatorSyncReturnType: '\u30B8\u30A7\u30CD\u30EC\u30FC\u30BF\u30FC\u95A2\u6570\u306E\u623B\u308A\u5024\u306E\u578B\u306F\u3001"Generator[{yieldType}, Any, Any]" \u3068\u4E92\u63DB\u6027\u304C\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        genericBaseClassNotAllowed: '"Generic" \u57FA\u5E95\u30AF\u30E9\u30B9\u3092\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u69CB\u6587\u3068\u5171\u306B\u4F7F\u7528\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        genericClassAssigned: "\u30B8\u30A7\u30CD\u30EA\u30C3\u30AF \u30AF\u30E9\u30B9\u578B\u3092\u5272\u308A\u5F53\u3066\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        genericClassDeleted: "\u30B8\u30A7\u30CD\u30EA\u30C3\u30AF \u30AF\u30E9\u30B9\u578B\u3092\u524A\u9664\u3067\u304D\u307E\u305B\u3093",
        genericInstanceVariableAccess: "\u30AF\u30E9\u30B9\u3092\u4ECB\u3057\u305F\u30B8\u30A7\u30CD\u30EA\u30C3\u30AF \u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u5909\u6570\u3078\u306E\u30A2\u30AF\u30BB\u30B9\u304C\u3042\u3044\u307E\u3044\u3067\u3059",
        genericNotAllowed: '"Generic" \u306F\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u7121\u52B9\u3067\u3059',
        genericTypeAliasBoundTypeVar: "\u30AF\u30E9\u30B9\u5185\u306E\u30B8\u30A7\u30CD\u30EA\u30C3\u30AF\u578B\u30A8\u30A4\u30EA\u30A2\u30B9\u306F\u30D0\u30A4\u30F3\u30C9\u3055\u308C\u305F\u578B\u5909\u6570 {names} \u3092\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        genericTypeArgMissing: '"Generic" \u306B\u306F\u5C11\u306A\u304F\u3068\u3082 1 \u3064\u306E\u578B\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059',
        genericTypeArgTypeVar: '"Generic" \u306E\u578B\u5F15\u6570\u306F\u578B\u5909\u6570\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        genericTypeArgUnique: '"Generic" \u306E\u578B\u5F15\u6570\u306F\u4E00\u610F\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        globalReassignment: '"{name}" \u306F global \u5BA3\u8A00\u306E\u524D\u306B\u5272\u308A\u5F53\u3066\u3089\u308C\u307E\u3059',
        globalRedefinition: '"{name}" \u306F\u65E2\u306B global \u3068\u3057\u3066\u5BA3\u8A00\u3055\u308C\u3066\u3044\u307E\u3059',
        implicitStringConcat: "\u6697\u9ED9\u7684\u306A\u6587\u5B57\u5217\u9023\u7D50\u306F\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        importCycleDetected: "\u30A4\u30F3\u30DD\u30FC\u30C8 \u30C1\u30A7\u30FC\u30F3\u3067\u5FAA\u74B0\u304C\u691C\u51FA\u3055\u308C\u307E\u3057\u305F",
        importDepthExceeded: "\u30A4\u30F3\u30DD\u30FC\u30C8 \u30C1\u30A7\u30FC\u30F3\u306E\u6DF1\u3055\u304C {depth} \u3092\u8D85\u3048\u307E\u3057\u305F",
        importResolveFailure: '\u30A4\u30F3\u30DD\u30FC\u30C8 "{importName}" \u3092\u89E3\u6C7A\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F',
        importSourceResolveFailure: '\u30A4\u30F3\u30DD\u30FC\u30C8 "{importName}" \u3092\u30BD\u30FC\u30B9\u304B\u3089\u89E3\u6C7A\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F',
        importSymbolUnknown: '"{name}" \u306F\u4E0D\u660E\u306A\u30A4\u30F3\u30DD\u30FC\u30C8 \u30B7\u30F3\u30DC\u30EB\u3067\u3059',
        incompatibleMethodOverride: '\u30E1\u30BD\u30C3\u30C9 "{name}" \u306F\u4E92\u63DB\u6027\u306E\u306A\u3044\u65B9\u6CD5\u3067\u30AF\u30E9\u30B9 "{className}" \u3092\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u3057\u307E\u3059',
        inconsistentIndent: "\u5143\u306E\u30B5\u30A4\u30BA\u304C\u524D\u306E\u30A4\u30F3\u30C7\u30F3\u30C8\u3068\u4E00\u81F4\u3057\u307E\u305B\u3093",
        inconsistentTabs: "\u30A4\u30F3\u30C7\u30F3\u30C8\u3067\u306E\u30BF\u30D6\u3068\u30B9\u30DA\u30FC\u30B9\u306E\u4E00\u8CAB\u6027\u306E\u306A\u3044\u4F7F\u7528",
        initMethodSelfParamTypeVar: '"__init__" \u30E1\u30BD\u30C3\u30C9\u306E "self" \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u578B\u6CE8\u91C8\u306B\u3001\u30AF\u30E9\u30B9 \u30B9\u30B3\u30FC\u30D7\u578B\u306E\u5909\u6570\u3092\u542B\u3081\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        initMustReturnNone: '"__init__" \u306E\u623B\u308A\u5024\u306E\u578B\u306F None \u3067\u306A\u3051\u308C\u3070\u306A\u308A\u307E\u305B\u3093',
        initSubclassCallFailed: "__init_subclass__ \u30E1\u30BD\u30C3\u30C9\u306E\u30AD\u30FC\u30EF\u30FC\u30C9\u5F15\u6570\u304C\u6B63\u3057\u304F\u3042\u308A\u307E\u305B\u3093",
        initSubclassClsParam: '__init_subclass__ \u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u306F "cls" \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3092\u53D7\u3051\u53D6\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        initVarNotAllowed: '"InitVar" \u306F\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        instanceMethodSelfParam: '\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9 \u30E1\u30BD\u30C3\u30C9\u306F "self" \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3092\u53D7\u3051\u53D6\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        instanceVarOverridesClassVar: '\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u5909\u6570 "{name}" \u306F\u3001\u30AF\u30E9\u30B9 "{className}" \u306E\u540C\u3058\u540D\u524D\u306E\u30AF\u30E9\u30B9\u5909\u6570\u3092\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u3057\u307E\u3059',
        instantiateAbstract: '\u62BD\u8C61\u30AF\u30E9\u30B9 "{type}" \u3092\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u5316\u3067\u304D\u307E\u305B\u3093',
        instantiateProtocol: 'Protocol \u30AF\u30E9\u30B9 "{type}" \u3092\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u5316\u3067\u304D\u307E\u305B\u3093',
        internalBindError: '\u30D5\u30A1\u30A4\u30EB "{file}" \u306E\u30D0\u30A4\u30F3\u30C9\u4E2D\u306B\u5185\u90E8\u30A8\u30E9\u30FC\u304C\u767A\u751F\u3057\u307E\u3057\u305F: {message}',
        internalParseError: '\u30D5\u30A1\u30A4\u30EB "{file}" \u306E\u89E3\u6790\u4E2D\u306B\u5185\u90E8\u30A8\u30E9\u30FC\u304C\u767A\u751F\u3057\u307E\u3057\u305F: {message}',
        internalTypeCheckingError: '\u30D5\u30A1\u30A4\u30EB "{file}" \u306E\u7A2E\u985E\u30C1\u30A7\u30C3\u30AF\u4E2D\u306B\u5185\u90E8\u30A8\u30E9\u30FC\u304C\u767A\u751F\u3057\u307E\u3057\u305F: {message}',
        invalidIdentifierChar: "\u8B58\u5225\u5B50\u306E\u7121\u52B9\u306A\u6587\u5B57",
        invalidStubStatement: "\u30B9\u30C6\u30FC\u30C8\u30E1\u30F3\u30C8\u306F\u3001\u578B stub \u30D5\u30A1\u30A4\u30EB\u5185\u3067\u306F\u610F\u5473\u304C\u3042\u308A\u307E\u305B\u3093",
        invalidTokenChars: '\u30C8\u30FC\u30AF\u30F3\u5185\u306E\u7121\u52B9\u306A\u6587\u5B57 "{text}"',
        isInstanceInvalidType: '"isinstance" \u306E 2 \u756A\u76EE\u306E\u5F15\u6570\u306F\u3001\u30AF\u30E9\u30B9\u307E\u305F\u306F\u30AF\u30E9\u30B9\u306E tuple \u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        isSubclassInvalidType: '"issubclass" \u306E 2 \u756A\u76EE\u306E\u5F15\u6570\u306F\u3001\u30AF\u30E9\u30B9\u307E\u305F\u306F\u30AF\u30E9\u30B9\u306E tuple \u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        keyValueInSet: "\u30AD\u30FC\u3068\u5024\u306E\u30DA\u30A2\u306F set \u5185\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        keywordArgInTypeArgument: "\u30AD\u30FC\u30EF\u30FC\u30C9\u5F15\u6570\u306F\u578B\u5F15\u6570\u30EA\u30B9\u30C8\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        keywordOnlyAfterArgs: '\u30AD\u30FC\u30EF\u30FC\u30C9\u306E\u307F\u306E\u5F15\u6570\u306E\u533A\u5207\u308A\u8A18\u53F7\u306F\u3001"*" \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u5F8C\u306B\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        keywordParameterMissing: '1 \u3064\u4EE5\u4E0A\u306E\u30AD\u30FC\u30EF\u30FC\u30C9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u304C "*" \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u5F8C\u306B\u7D9A\u304F\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        keywordSubscriptIllegal: "\u6DFB\u5B57\u5185\u306E\u30AD\u30FC\u30EF\u30FC\u30C9\u5F15\u6570\u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        lambdaReturnTypePartiallyUnknown: '\u30E9\u30E0\u30C0\u306E\u623B\u308A\u5024\u306E\u578B\u3001"{returnType}" \u304C\u90E8\u5206\u7684\u306B\u4E0D\u660E\u3067\u3059',
        lambdaReturnTypeUnknown: "\u30E9\u30E0\u30C0\u306E\u623B\u308A\u5024\u306E\u578B\u304C\u4E0D\u660E\u3067\u3059",
        listAssignmentMismatch: '\u578B "{type}" \u306E\u5F0F\u3092\u30BF\u30FC\u30B2\u30C3\u30C8 \u30EA\u30B9\u30C8\u306B\u5272\u308A\u5F53\u3066\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        listInAnnotation: "List \u5F0F\u306F\u578B\u5F0F\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        literalEmptyArgs: '"Literal" \u306E\u5F8C\u306B 1 \u3064\u4EE5\u4E0A\u306E\u578B\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059',
        literalNamedUnicodeEscape: '\u540D\u524D\u4ED8\u304D Unicode \u30A8\u30B9\u30B1\u30FC\u30D7 \u30B7\u30FC\u30B1\u30F3\u30B9\u306F\u3001"Literal" \u6587\u5B57\u5217\u6CE8\u91C8\u3067\u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        literalNotAllowed: '"Literal" \u306F\u3001\u578B\u5F15\u6570\u306A\u3057\u3067\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        literalNotCallable: "Literal \u578B\u306F\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u5316\u3067\u304D\u307E\u305B\u3093",
        literalUnsupportedType: '"Literal" \u306E\u578B\u5F15\u6570\u306F None\u3001literal \u5024 (int\u3001bool\u3001str\u3001\u307E\u305F\u306F bytes)\u3001\u307E\u305F\u306F enum \u5024\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        matchIncompatible: "Match \u30B9\u30C6\u30FC\u30C8\u30E1\u30F3\u30C8\u306B\u306F Python 3.10 \u4EE5\u964D\u304C\u5FC5\u8981\u3067\u3059",
        matchIsNotExhaustive: "match \u30B9\u30C6\u30FC\u30C8\u30E1\u30F3\u30C8\u5185\u306E\u30B1\u30FC\u30B9\u3067\u306F\u3001\u3059\u3079\u3066\u306E\u5024\u304C\u5B8C\u5168\u306B\u51E6\u7406\u3055\u308C\u308B\u308F\u3051\u3067\u306F\u3042\u308A\u307E\u305B\u3093",
        maxParseDepthExceeded: "\u89E3\u6790\u306E\u6700\u5927\u6DF1\u3055\u3092\u8D85\u3048\u307E\u3057\u305F\u3002\u5F0F\u3092\u5C0F\u3055\u3044\u90E8\u5206\u5F0F\u306B\u5206\u5272\u3059\u308B",
        memberAccess: '\u30AF\u30E9\u30B9 "{type}" \u306E\u5C5E\u6027 "{name}" \u306B\u30A2\u30AF\u30BB\u30B9\u3067\u304D\u307E\u305B\u3093',
        memberDelete: '\u30AF\u30E9\u30B9 "{type}" \u306E\u5C5E\u6027 "{name}" \u3092\u524A\u9664\u3067\u304D\u307E\u305B\u3093',
        memberSet: '\u30AF\u30E9\u30B9 "{type}" \u306E\u5C5E\u6027 "{name}" \u306B\u5272\u308A\u5F53\u3066\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        metaclassConflict: "\u6D3E\u751F\u30AF\u30E9\u30B9\u306E\u30E1\u30BF\u30AF\u30E9\u30B9\u306F\u3001\u305D\u306E\u3059\u3079\u3066\u306E\u57FA\u5E95\u30AF\u30E9\u30B9\u306E\u30E1\u30BF\u30AF\u30E9\u30B9\u306E\u30B5\u30D6\u30AF\u30E9\u30B9\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        metaclassDuplicate: "\u6307\u5B9A\u3067\u304D\u308B\u30E1\u30BF\u30AF\u30E9\u30B9\u306F 1 \u3064\u3060\u3051\u3067\u3059",
        metaclassIsGeneric: "\u30E1\u30BF\u30AF\u30E9\u30B9\u3092\u30B8\u30A7\u30CD\u30EA\u30C3\u30AF\u306B\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        methodNotDefined: '"{name}" \u30E1\u30BD\u30C3\u30C9\u304C\u5B9A\u7FA9\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        methodNotDefinedOnType: '\u578B "{type}" \u306B "{name}" \u30E1\u30BD\u30C3\u30C9\u304C\u5B9A\u7FA9\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        methodOrdering: "\u4E00\u8CAB\u6027\u306E\u3042\u308B\u30E1\u30BD\u30C3\u30C9\u306E\u9806\u5E8F\u3092\u4F5C\u6210\u3067\u304D\u307E\u305B\u3093",
        methodOverridden: '"{name}" \u306F\u3001\u30AF\u30E9\u30B9 "{className}" \u306E\u540C\u3058\u540D\u524D\u306E\u30E1\u30BD\u30C3\u30C9\u3092\u4E92\u63DB\u6027\u306E\u306A\u3044\u578B "{type}" \u3067\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u3057\u307E\u3059',
        methodReturnsNonObject: '"{name}" \u30E1\u30BD\u30C3\u30C9\u306F\u30AA\u30D6\u30B8\u30A7\u30AF\u30C8\u3092\u8FD4\u3057\u307E\u305B\u3093',
        missingSuperCall: '\u30E1\u30BD\u30C3\u30C9 "{methodName}" \u306F\u89AA\u30AF\u30E9\u30B9\u3067\u540C\u3058\u540D\u524D\u306E\u30E1\u30BD\u30C3\u30C9\u3092\u547C\u3073\u51FA\u3057\u307E\u305B\u3093',
        mixingBytesAndStr: "Bytes \u5024\u3068 str \u5024\u3092\u9023\u7D50\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        moduleAsType: "\u30E2\u30B8\u30E5\u30FC\u30EB\u3092\u578B\u3068\u3057\u3066\u4F7F\u7528\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        moduleNotCallable: "\u30E2\u30B8\u30E5\u30FC\u30EB\u306F\u547C\u3073\u51FA\u3057\u53EF\u80FD\u3067\u306F\u3042\u308A\u307E\u305B\u3093",
        moduleUnknownMember: '"{memberName}" \u306F\u30E2\u30B8\u30E5\u30FC\u30EB "{moduleName}" \u306E\u65E2\u77E5\u306E\u5C5E\u6027\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        namedExceptAfterCatchAll: "\u540D\u524D\u4ED8\u304D except \u53E5\u306F\u3001catch-all except \u53E5\u306E\u5F8C\u306B\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        namedParamAfterParamSpecArgs: 'ParamSpec args \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u5F8C\u306B\u30AD\u30FC\u30EF\u30FC\u30C9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u3092\u30B7\u30B0\u30CD\u30C1\u30E3\u306B\u542B\u3081\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        namedTupleEmptyName: "\u540D\u524D\u4ED8\u304D tuple \u5185\u306E\u540D\u524D\u3092\u7A7A\u306B\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        namedTupleEntryRedeclared: '\u89AA\u30AF\u30E9\u30B9 "{className}" \u304C\u540D\u524D\u4ED8\u304D tuple \u3067\u3042\u308B\u305F\u3081\u3001"{name}" \u3092\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u3067\u304D\u307E\u305B\u3093',
        namedTupleFieldUnderscore: "Named tuple \u30D5\u30A3\u30FC\u30EB\u30C9\u540D\u3092\u30A2\u30F3\u30C0\u30FC\u30B9\u30B3\u30A2\u3067\u59CB\u3081\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        namedTupleFirstArg: "\u6700\u521D\u306E\u5F15\u6570\u3068\u3057\u3066\u540D\u524D\u4ED8\u304D tuple \u30AF\u30E9\u30B9\u540D\u304C\u5FC5\u8981\u3067\u3059",
        namedTupleMultipleInheritance: "NamedTuple \u306B\u3088\u308B\u8907\u6570\u306E\u7D99\u627F\u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        namedTupleNameKeyword: "\u30D5\u30A3\u30FC\u30EB\u30C9\u540D\u3092\u30AD\u30FC\u30EF\u30FC\u30C9\u306B\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        namedTupleNameType: "\u30A8\u30F3\u30C8\u30EA\u540D\u3068\u578B\u3092\u6307\u5B9A\u3059\u308B 2 \u30A8\u30F3\u30C8\u30EA\u306E tuple \u304C\u5FC5\u8981\u3067\u3059",
        namedTupleNameUnique: "\u540D\u524D\u4ED8\u304D tuple \u5185\u306E\u540D\u524D\u306F\u4E00\u610F\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        namedTupleNoTypes: '"namedtuple" \u306F tuple \u30A8\u30F3\u30C8\u30EA\u306B\u578B\u3092\u63D0\u4F9B\u3057\u307E\u305B\u3093\u3002\u4EE3\u308F\u308A\u306B "NamedTuple" \u3092\u4F7F\u7528\u3057\u3066\u304F\u3060\u3055\u3044',
        namedTupleSecondArg: "2 \u756A\u76EE\u306E\u5F15\u6570\u3068\u3057\u3066\u540D\u524D\u4ED8\u304D tuple \u30A8\u30F3\u30C8\u30EA list \u304C\u5FC5\u8981\u3067\u3059",
        newClsParam: '__new__ override \u306F "cls" \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3092\u53D7\u3051\u53D6\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        newTypeAnyOrUnknown: "NewType \u306E 2 \u756A\u76EE\u306E\u5F15\u6570\u306F\u3001Any \u3084 Unknown \u3067\u306F\u306A\u304F\u3001\u65E2\u77E5\u306E\u30AF\u30E9\u30B9\u3067\u306A\u3051\u308C\u3070\u306A\u308A\u307E\u305B\u3093",
        newTypeBadName: "NewType \u306E\u6700\u521D\u306E\u5F15\u6570\u306F\u6587\u5B57\u5217\u30EA\u30C6\u30E9\u30EB\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        newTypeLiteral: "NewType \u306F Literal \u578B\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        newTypeNameMismatch: "NewType \u306F\u540C\u3058\u540D\u524D\u306E\u5909\u6570\u306B\u5272\u308A\u5F53\u3066\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        newTypeNotAClass: "NewType \u306E 2 \u756A\u76EE\u306E\u5F15\u6570\u3068\u3057\u3066\u30AF\u30E9\u30B9\u304C\u5FC5\u8981\u3067\u3059",
        newTypeParamCount: "NewType \u306B\u306F 2 \u3064\u306E\u4F4D\u7F6E\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059",
        newTypeProtocolClass: "NewType \u306F\u69CB\u9020\u578B (Protocol\u307E\u305F\u306F TypedDict \u30AF\u30E9\u30B9) \u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        noOverload: '\u6307\u5B9A\u3055\u308C\u305F\u5F15\u6570\u306B\u4E00\u81F4\u3059\u308B "{name}" \u306E\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9\u304C\u3042\u308A\u307E\u305B\u3093',
        noReturnContainsReturn: 'Function with declared return type "NoReturn" cannot include a return statement',
        noReturnContainsYield: '\u623B\u308A\u5024\u306E\u578B "NoReturn" \u3092\u5BA3\u8A00\u3057\u305F\u95A2\u6570\u306B yield \u30B9\u30C6\u30FC\u30C8\u30E1\u30F3\u30C8\u3092\u542B\u3081\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        noReturnReturnsNone: '\u623B\u308A\u5024\u306E\u578B\u304C "NoReturn" \u3068\u3057\u3066\u5BA3\u8A00\u3055\u308C\u3066\u3044\u308B\u95A2\u6570\u306F "None" \u3092\u8FD4\u3059\u3053\u3068\u304C\u3067\u304D\u307E\u305B\u3093',
        nonDefaultAfterDefault: "\u65E2\u5B9A\u4EE5\u5916\u306E\u5F15\u6570\u306F\u65E2\u5B9A\u306E\u5F15\u6570\u306E\u5F8C\u306B\u7D9A\u304D\u307E\u3059",
        nonLocalInModule: "\u30E2\u30B8\u30E5\u30FC\u30EB \u30EC\u30D9\u30EB\u3067\u306F nonlocal \u5BA3\u8A00\u306F\u8A31\u53EF\u3055\u308C\u307E\u305B\u3093",
        nonLocalNoBinding: 'nonlocal "{name}" \u306E\u30D0\u30A4\u30F3\u30C9\u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093',
        nonLocalReassignment: '"{name}" \u306F nonlocal \u5BA3\u8A00\u306E\u524D\u306B\u5272\u308A\u5F53\u3066\u3089\u308C\u307E\u3059',
        nonLocalRedefinition: '"{name}" \u306F\u65E2\u306B nonlocal \u3068\u3057\u3066\u5BA3\u8A00\u3055\u308C\u3066\u3044\u307E\u3059',
        noneNotCallable: '"None" \u578B\u306E\u30AA\u30D6\u30B8\u30A7\u30AF\u30C8\u3092\u547C\u3073\u51FA\u3059\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        noneNotIterable: '\u578B "None" \u306E\u30AA\u30D6\u30B8\u30A7\u30AF\u30C8\u3092\u53CD\u5FA9\u53EF\u80FD\u306A\u5024\u3068\u3057\u3066\u4F7F\u7528\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        noneNotSubscriptable: '"None" \u578B\u306E\u30AA\u30D6\u30B8\u30A7\u30AF\u30C8\u306F\u6DFB\u5B57\u53EF\u80FD\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        noneNotUsableWith: 'Object of type "None" cannot be used with "with"',
        noneNotUsableWithAsync: '\u578B "None" \u3068 "async with" \u306F\u540C\u6642\u306B\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        noneOperator: '\u6F14\u7B97\u5B50 "{operator}" \u306F "None" \u3067\u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        noneUnknownMember: '"{name}" \u306F "None" \u306E\u65E2\u77E5\u306E\u5C5E\u6027\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        nonlocalTypeParam: '\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u306B nonlocal \u30D0\u30A4\u30F3\u30C9\u306F\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        notRequiredArgCount: '"NotRequired" \u306E\u5F8C\u306B 1 \u3064\u306E\u578B\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059',
        notRequiredNotInTypedDict: '"NotRequired" \u306F\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        objectNotCallable: '\u578B "{type}" \u306E\u30AA\u30D6\u30B8\u30A7\u30AF\u30C8\u306F\u547C\u3073\u51FA\u3057\u53EF\u80FD\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        obscuredClassDeclaration: '\u30AF\u30E9\u30B9\u5BA3\u8A00 "{name}" \u306F\u3001\u540C\u3058\u540D\u524D\u306E\u5BA3\u8A00\u306B\u3088\u3063\u3066\u96A0\u3055\u308C\u3066\u3044\u307E\u3059',
        obscuredFunctionDeclaration: '\u95A2\u6570\u5BA3\u8A00 "{name}" \u306F\u3001\u540C\u3058\u540D\u524D\u306E\u5BA3\u8A00\u306B\u3088\u3063\u3066\u96A0\u3055\u308C\u3066\u3044\u307E\u3059',
        obscuredMethodDeclaration: '\u30E1\u30BD\u30C3\u30C9\u5BA3\u8A00 "{name}" \u306F\u3001\u540C\u3058\u540D\u524D\u306E\u5BA3\u8A00\u306B\u3088\u3063\u3066\u96A0\u3055\u308C\u3066\u3044\u307E\u3059',
        obscuredParameterDeclaration: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u5BA3\u8A00 "{name}" \u306F\u3001\u540C\u3058\u540D\u524D\u306E\u5BA3\u8A00\u306B\u3088\u3063\u3066\u96A0\u3055\u308C\u3066\u3044\u307E\u3059',
        obscuredTypeAliasDeclaration: '\u578B\u30A8\u30A4\u30EA\u30A2\u30B9\u5BA3\u8A00 "{name}" \u306F\u3001\u540C\u3058\u540D\u524D\u306E\u5BA3\u8A00\u306B\u3088\u3063\u3066\u96A0\u3055\u308C\u3066\u3044\u307E\u3059',
        obscuredVariableDeclaration: '\u5BA3\u8A00 "{name}" \u306F\u3001\u540C\u3058\u540D\u524D\u306E\u5BA3\u8A00\u306B\u3088\u3063\u3066\u96A0\u3055\u308C\u3066\u3044\u307E\u3059',
        operatorLessOrGreaterDeprecated: '\u6F14\u7B97\u5B50 "<>" \u306F Python 3 \u3067\u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093\u3002\u4EE3\u308F\u308A\u306B "!=" \u3092\u4F7F\u7528\u3057\u3066\u304F\u3060\u3055\u3044',
        optionalExtraArgs: '"Optional" \u306E\u5F8C\u306B 1 \u3064\u306E\u578B\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059',
        orPatternIrrefutable: '\u53C2\u7167\u4E0D\u53EF\u80FD\u306A\u30D1\u30BF\u30FC\u30F3\u306F\u3001"or" \u30D1\u30BF\u30FC\u30F3\u306E\u6700\u5F8C\u306E\u30B5\u30D6\u30D1\u30BF\u30FC\u30F3\u3068\u3057\u3066\u306E\u307F\u8A31\u53EF\u3055\u308C\u307E\u3059',
        orPatternMissingName: '"or" \u30D1\u30BF\u30FC\u30F3\u5185\u306E\u3059\u3079\u3066\u306E\u30B5\u30D6\u30D1\u30BF\u30FC\u30F3\u306F\u3001\u540C\u3058\u540D\u524D\u3092\u30BF\u30FC\u30B2\u30C3\u30C8\u306B\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        overlappingKeywordArgs: "\u5165\u529B\u3055\u308C\u305F\u8F9E\u66F8\u306F\u30AD\u30FC\u30EF\u30FC\u30C9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3068\u91CD\u8907\u3057\u3066\u3044\u307E\u3059: {names}",
        overlappingOverload: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u304C\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9 {obscuredBy} \u3068\u91CD\u8907\u3057\u3066\u3044\u308B\u305F\u3081\u3001"{name}" \u306E\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9 {obscured} \u306F\u4F7F\u7528\u3055\u308C\u307E\u305B\u3093',
        overloadAbstractImplMismatch: "\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9\u306F\u5B9F\u88C5\u306E\u62BD\u8C61\u72B6\u614B\u3068\u4E00\u81F4\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        overloadAbstractMismatch: "\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9\u306F\u3059\u3079\u3066\u62BD\u8C61\u3067\u3042\u308B\u304B\u62BD\u8C61\u3067\u306A\u3044\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        overloadClassMethodInconsistent: '"{name}" \u306E\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9\u3067\u306F\u3001@classmethod \u3092\u4E0D\u6574\u5408\u306B\u4F7F\u7528\u3057\u307E\u3059',
        overloadFinalImpl: "@final \u30C7\u30B3\u30EC\u30FC\u30BF\u30FC\u306F\u5B9F\u88C5\u306B\u306E\u307F\u9069\u7528\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        overloadFinalNoImpl: "\u6700\u521D\u306E\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9\u306E\u307F\u3092 @final \u306B\u8A2D\u5B9A\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        overloadImplementationMismatch: "\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9\u3055\u308C\u305F\u5B9F\u88C5\u304C\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9 {index} \u306E\u30B7\u30B0\u30CD\u30C1\u30E3\u3068\u4E00\u81F4\u3057\u307E\u305B\u3093",
        overloadOverrideImpl: "@override \u30C7\u30B3\u30EC\u30FC\u30BF\u30FC\u306F\u5B9F\u88C5\u306B\u306E\u307F\u9069\u7528\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        overloadOverrideNoImpl: "\u6700\u521D\u306E\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9\u306E\u307F\u3092 @override \u306B\u8A2D\u5B9A\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        overloadReturnTypeMismatch: '"{name}" \u306E\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9 {prevIndex} \u306F\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9 {newIndex} \u3068\u91CD\u8907\u3057\u3001\u4E92\u63DB\u6027\u306E\u306A\u3044\u578B\u3092\u8FD4\u3057\u307E\u3059',
        overloadStaticMethodInconsistent: '"{name}" \u306E\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9\u3067\u306F\u3001@staticmethod \u3092\u4E0D\u6574\u5408\u306B\u4F7F\u7528\u3057\u307E\u3059',
        overloadWithoutImplementation: '"{name}" \u306F overload \u3068\u3057\u3066\u30DE\u30FC\u30AF\u3055\u308C\u3066\u3044\u307E\u3059\u304C\u3001\u5B9F\u88C5\u304C\u63D0\u4F9B\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        overriddenMethodNotFound: '\u30E1\u30BD\u30C3\u30C9 "{name}" \u306F override \u3068\u3057\u3066\u30DE\u30FC\u30AF\u3055\u308C\u3066\u3044\u307E\u3059\u304C\u3001\u540C\u3058\u540D\u524D\u306E\u57FA\u672C\u30E1\u30BD\u30C3\u30C9\u304C\u5B58\u5728\u3057\u307E\u305B\u3093',
        overrideDecoratorMissing: '\u30E1\u30BD\u30C3\u30C9 "{name}" \u306F override \u3068\u3057\u3066\u30DE\u30FC\u30AF\u3055\u308C\u3066\u3044\u307E\u305B\u3093\u304C\u3001\u30AF\u30E9\u30B9 "{className}" \u306E\u30E1\u30BD\u30C3\u30C9\u3092\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u3057\u3066\u3044\u307E\u3059',
        paramAfterKwargsParam: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306F "**" \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u5F8C\u306B\u7D9A\u3051\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        paramAlreadyAssigned: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u306F\u65E2\u306B\u5272\u308A\u5F53\u3066\u6E08\u307F\u3067\u3059',
        paramAnnotationMissing: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u306B\u578B\u6CE8\u91C8\u304C\u3042\u308A\u307E\u305B\u3093',
        paramAssignmentMismatch: '\u578B "{sourceType}" \u306E\u5F0F\u3092\u578B "{paramType}" \u306E\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306B\u5272\u308A\u5F53\u3066\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        paramNameMissing: '"{name}" \u3068\u3044\u3046\u540D\u524D\u306E\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u304C\u3042\u308A\u307E\u305B\u3093',
        paramSpecArgsKwargsDuplicate: 'ParamSpec "{type}" \u306E\u5F15\u6570\u306F\u65E2\u306B\u6307\u5B9A\u3055\u308C\u3066\u3044\u307E\u3059',
        paramSpecArgsKwargsUsage: 'ParamSpec \u306E "args" \u5C5E\u6027\u3068 "kwargs" \u5C5E\u6027\u306E\u4E21\u65B9\u304C\u95A2\u6570\u30B7\u30B0\u30CD\u30C1\u30E3\u5185\u306B\u542B\u307E\u308C\u3066\u3044\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        paramSpecArgsMissing: 'ParamSpec "{type}" \u306E\u5F15\u6570\u304C\u3042\u308A\u307E\u305B\u3093',
        paramSpecArgsUsage: 'ParamSpec \u306E "args" \u5C5E\u6027\u306F\u3001*args \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3068\u5171\u306B\u4F7F\u7528\u3059\u308B\u5834\u5408\u306B\u306E\u307F\u6709\u52B9\u3067\u3059',
        paramSpecAssignedName: 'ParamSpec \u306F \u3001"{name}" \u3068\u3044\u3046\u540D\u524D\u306E\u5909\u6570\u306B\u5272\u308A\u5F53\u3066\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        paramSpecContext: "ParamSpec \u306F\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        paramSpecDefaultNotTuple: "ParamSpec \u306E\u65E2\u5B9A\u5024\u306B\u306F\u3001\u7701\u7565\u8A18\u53F7\u3001tuple \u5F0F\u3001\u307E\u305F\u306F ParamSpec \u304C\u5FC5\u8981\u3067\u3059",
        paramSpecFirstArg: "\u6700\u521D\u306E\u5F15\u6570\u3068\u3057\u3066 ParamSpec \u306E\u540D\u524D\u304C\u5FC5\u8981\u3067\u3059",
        paramSpecKwargsUsage: 'ParamSpec \u306E "kwargs" \u5C5E\u6027\u306F\u3001**kwargs \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3068\u5171\u306B\u4F7F\u7528\u3059\u308B\u5834\u5408\u306B\u306E\u307F\u6709\u52B9\u3067\u3059',
        paramSpecNotUsedByOuterScope: 'ParamSpec "{name}" \u306F\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u610F\u5473\u304C\u3042\u308A\u307E\u305B\u3093',
        paramSpecUnknownArg: "ParamSpec \u306F\u8907\u6570\u306E\u5F15\u6570\u3092\u30B5\u30DD\u30FC\u30C8\u3057\u3066\u3044\u307E\u305B\u3093",
        paramSpecUnknownMember: '"{name}" \u306F ParamSpec \u306E\u65E2\u77E5\u306E\u5C5E\u6027\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        paramSpecUnknownParam: '"{name}" \u306F ParamSpec \u306B\u5BFE\u3059\u308B\u4E0D\u660E\u306A\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3067\u3059',
        paramTypeCovariant: "\u5171\u5909\u306E\u578B\u5909\u6570\u306F\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u578B\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        paramTypePartiallyUnknown: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{paramName}" \u306E\u578B\u304C\u90E8\u5206\u7684\u306B\u4E0D\u660E\u3067\u3059',
        paramTypeUnknown: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{paramName}" \u306E\u578B\u304C\u4E0D\u660E\u3067\u3059',
        parenthesizedContextManagerIllegal: 'Parentheses within "with" statement requires Python 3.9 or newer',
        patternNeverMatches: '\u30B5\u30D6\u30B8\u30A7\u30AF\u30C8\u306E\u7A2E\u985E "{type}" \u306E\u30D1\u30BF\u30FC\u30F3\u306F\u4E00\u81F4\u3057\u307E\u305B\u3093',
        positionArgAfterNamedArg: "\u30AD\u30FC\u30EF\u30FC\u30C9\u5F15\u6570\u306E\u5F8C\u306B\u4F4D\u7F6E\u5F15\u6570\u3092\u6307\u5B9A\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        positionArgAfterUnpackedDictArg: "\u30AD\u30FC\u30EF\u30FC\u30C9\u5F15\u6570\u306E\u30A2\u30F3\u30D1\u30C3\u30AF\u306E\u5F8C\u306B\u4F4D\u7F6E\u5F15\u6570\u3092\u6307\u5B9A\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        positionOnlyAfterArgs: '"*" \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u5F8C\u306B\u4F4D\u7F6E\u306E\u307F\u306E\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u533A\u5207\u308A\u6587\u5B57\u3092\u4F7F\u7528\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        positionOnlyAfterKeywordOnly: '"/" \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306F \u3001"*" \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u524D\u306B\u6307\u5B9A\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        positionOnlyAfterNon: "\u4F4D\u7F6E\u306E\u307F\u306E\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u5F8C\u306B\u4F4D\u7F6E\u306E\u307F\u306E\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3092\u6307\u5B9A\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        positionOnlyFirstParam: "\u4F4D\u7F6E\u306E\u307F\u306E\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u533A\u5207\u308A\u8A18\u53F7\u3092\u6700\u521D\u306E\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3068\u3057\u3066\u4F7F\u7528\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        positionOnlyIncompatible: "\u4F4D\u7F6E\u306E\u307F\u306E\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u533A\u5207\u308A\u6587\u5B57\u306B\u306F Python 3.8 \u4EE5\u964D\u304C\u5FC5\u8981\u3067\u3059",
        privateImportFromPyTypedModule: '"{name}" \u306F\u30E2\u30B8\u30E5\u30FC\u30EB "{module}" \u304B\u3089\u30A8\u30AF\u30B9\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        privateUsedOutsideOfClass: '"{name}" \u306F\u30D7\u30E9\u30A4\u30D9\u30FC\u30C8\u3067\u3042\u308A\u3001\u5BA3\u8A00\u3055\u308C\u3066\u3044\u308B\u30AF\u30E9\u30B9\u306E\u5916\u90E8\u3067\u4F7F\u7528\u3055\u308C\u307E\u3059',
        privateUsedOutsideOfModule: '"{name}" \u306F\u30D7\u30E9\u30A4\u30D9\u30FC\u30C8\u3067\u3042\u308A\u3001\u305D\u308C\u304C\u5BA3\u8A00\u3055\u308C\u3066\u3044\u308B\u30E2\u30B8\u30E5\u30FC\u30EB\u306E\u5916\u90E8\u3067\u4F7F\u7528\u3055\u308C\u3066\u3044\u307E\u3059',
        propertyOverridden: '"{name}" \u306F\u3001\u30AF\u30E9\u30B9 "{className}" \u306E\u540C\u3058\u540D\u524D\u306E property \u3092\u8AA4\u3063\u3066\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u3057\u307E\u3059',
        propertyStaticMethod: "\u9759\u7684\u30E1\u30BD\u30C3\u30C9\u306F\u3001property \u306E getter\u3001setter \u307E\u305F\u306F deleter \u306B\u5BFE\u3057\u3066\u8A31\u53EF\u3055\u308C\u307E\u305B\u3093",
        protectedUsedOutsideOfClass: '"{name}" \u306F\u4FDD\u8B77\u3055\u308C\u3001\u5BA3\u8A00\u3055\u308C\u3066\u3044\u308B\u30AF\u30E9\u30B9\u306E\u5916\u90E8\u3067\u4F7F\u7528\u3055\u308C\u307E\u3059',
        protocolBaseClass: 'Protocol \u30AF\u30E9\u30B9 "{classType}" \u306F\u975E Protocol \u30AF\u30E9\u30B9 "{baseType}" \u304B\u3089\u6D3E\u751F\u3067\u304D\u307E\u305B\u3093',
        protocolBaseClassWithTypeArgs: "\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u69CB\u6587\u3092\u4F7F\u7528\u3059\u308B\u5834\u5408\u3001Protocol \u30AF\u30E9\u30B9\u3067\u306F\u578B\u5F15\u6570\u3092\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        protocolIllegal: '"Protocol" \u3092\u4F7F\u7528\u3059\u308B\u306B\u306F Python 3.7 \u4EE5\u964D\u304C\u5FC5\u8981\u3067\u3059',
        protocolNotAllowed: '"Protocol" \u306F\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        protocolTypeArgMustBeTypeParam: '"Protocol" \u306E\u578B\u5F15\u6570\u306F\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        protocolUnsafeOverlap: '\u30AF\u30E9\u30B9\u304C\u5B89\u5168\u3067\u306A\u3044\u65B9\u6CD5\u3067 "{name}" \u3068\u91CD\u8907\u3057\u3066\u304A\u308A\u3001\u5B9F\u884C\u6642\u306B\u4E00\u81F4\u3059\u308B\u53EF\u80FD\u6027\u304C\u3042\u308A\u307E\u3059',
        protocolVarianceContravariant: '\u30B8\u30A7\u30CD\u30EA\u30C3\u30AF Protocol "{class}" \u3067\u4F7F\u7528\u3055\u308C\u308B\u578B\u5909\u6570 "{variable}" \u306F\u53CD\u5909\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        protocolVarianceCovariant: '\u30B8\u30A7\u30CD\u30EA\u30C3\u30AF Protocol "{class}" \u3067\u4F7F\u7528\u3055\u308C\u308B\u578B\u5909\u6570 "{variable}" \u306F\u5171\u5909\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        protocolVarianceInvariant: '\u30B8\u30A7\u30CD\u30EA\u30C3\u30AF Protocol "{class}" \u3067\u4F7F\u7528\u3055\u308C\u308B\u578B\u5909\u6570 "{variable}" \u306F\u4E0D\u5909\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        pyrightCommentInvalidDiagnosticBoolValue: 'Pyright \u30B3\u30E1\u30F3\u30C8 \u30C7\u30A3\u30EC\u30AF\u30C6\u30A3\u30D6\u306E\u5F8C\u306B\u306F "=" \u3068\u5024 true \u307E\u305F\u306F false \u3092\u6307\u5B9A\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        pyrightCommentInvalidDiagnosticSeverityValue: 'Pyright \u30B3\u30E1\u30F3\u30C8 \u30C7\u30A3\u30EC\u30AF\u30C6\u30A3\u30D6\u306E\u5F8C\u306B "=" \u3068 true\u3001false\u3001error\u3001warning\u3001information \u307E\u305F\u306F none \u306E\u5024\u3092\u6307\u5B9A\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        pyrightCommentMissingDirective: "Pyright \u30B3\u30E1\u30F3\u30C8\u306E\u5F8C\u306B\u30C7\u30A3\u30EC\u30AF\u30C6\u30A3\u30D6 (basic \u307E\u305F\u306F strict) \u307E\u305F\u306F\u8A3A\u65AD\u898F\u5247\u3092\u6307\u5B9A\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        pyrightCommentNotOnOwnLine: "\u30D5\u30A1\u30A4\u30EB \u30EC\u30D9\u30EB\u306E\u8A2D\u5B9A\u3092\u5236\u5FA1\u3059\u308B\u305F\u3081\u306B\u4F7F\u7528\u3059\u308B Pyright \u30B3\u30E1\u30F3\u30C8\u306F\u3001\u72EC\u81EA\u306E\u884C\u306B\u8868\u793A\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        pyrightCommentUnknownDiagnosticRule: '"{rule}" \u306F pyright \u30B3\u30E1\u30F3\u30C8\u306E\u4E0D\u660E\u306A\u8A3A\u65AD\u898F\u5247\u3067\u3059',
        pyrightCommentUnknownDiagnosticSeverityValue: '"{value}" \u306F\u3001pyright \u30B3\u30E1\u30F3\u30C8\u306E\u7121\u52B9\u306A\u5024\u3067\u3059\u3002true\u3001false\u3001error\u3001warning\u3001information \u307E\u305F\u306F none \u304C\u5FC5\u8981\u3067\u3059',
        pyrightCommentUnknownDirective: '"{directive}" is an unknown directive for pyright comment; expected "strict", "standard", or "basic"',
        readOnlyArgCount: '"ReadOnly" \u306E\u5F8C\u306B 1 \u3064\u306E\u578B\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059',
        readOnlyNotInTypedDict: '"ReadOnly" \u306F\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        recursiveDefinition: '"{name}" \u306E\u578B\u306F\u3001\u305D\u308C\u81EA\u4F53\u3092\u53C2\u7167\u3057\u3066\u3044\u308B\u305F\u3081\u3001\u7279\u5B9A\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F',
        relativeImportNotAllowed: '\u76F8\u5BFE\u30A4\u30F3\u30DD\u30FC\u30C8\u306F\u3001"import .a" \u30D5\u30A9\u30FC\u30E0\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093\u3002\u4EE3\u308F\u308A\u306B "from . import a" \u3092\u4F7F\u7528\u3057\u307E\u3059\u3002',
        requiredArgCount: '"Required" \u306E\u5F8C\u306B 1 \u3064\u306E\u578B\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059',
        requiredNotInTypedDict: '\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F "Required" \u306F\u8A31\u53EF\u3055\u308C\u307E\u305B\u3093',
        returnInAsyncGenerator: "\u5024\u3092\u6301\u3064 return \u30B9\u30C6\u30FC\u30C8\u30E1\u30F3\u30C8\u306F\u3001async \u30B8\u30A7\u30CD\u30EC\u30FC\u30BF\u30FC\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        returnInExceptionGroup: '"except*" \u30D6\u30ED\u30C3\u30AF\u3067\u306F "return" \u3092\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        returnMissing: '\u623B\u308A\u5024\u306E\u578B\u304C "{returnType}" \u3068\u3057\u3066\u5BA3\u8A00\u3055\u308C\u3066\u3044\u308B\u95A2\u6570\u306F\u3001\u3059\u3079\u3066\u306E\u30B3\u30FC\u30C9 \u30D1\u30B9\u3067\u5024\u3092\u8FD4\u3059\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        returnOutsideFunction: '"return" \u306F\u95A2\u6570\u5185\u3067\u306E\u307F\u4F7F\u7528\u3067\u304D\u307E\u3059',
        returnTypeContravariant: "\u53CD\u5909\u306E\u578B\u5909\u6570\u306F\u623B\u308A\u5024\u306E\u578B\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        returnTypeMismatch: '\u578B "{exprType}" \u306F\u623B\u308A\u5024\u306E\u578B "{returnType}" \u306B\u5272\u308A\u5F53\u3066\u3067\u304D\u307E\u305B\u3093',
        returnTypePartiallyUnknown: '\u623B\u308A\u5024\u306E\u578B "{returnType}" \u306F\u90E8\u5206\u7684\u306B\u4E0D\u660E\u3067\u3059',
        returnTypeUnknown: "\u623B\u308A\u5024\u306E\u578B\u304C\u4E0D\u660E\u3067\u3059",
        revealLocalsArgs: '"reveal_locals" \u547C\u3073\u51FA\u3057\u306B\u5F15\u6570\u304C\u5FC5\u8981\u3042\u308A\u307E\u305B\u3093',
        revealLocalsNone: "\u3053\u306E\u30B9\u30B3\u30FC\u30D7\u306B\u306F locals \u304C\u3042\u308A\u307E\u305B\u3093",
        revealTypeArgs: '"reveal_type" \u547C\u3073\u51FA\u3057\u306B 1 \u3064\u306E\u4F4D\u7F6E\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059',
        revealTypeExpectedTextArg: '\u95A2\u6570 "reveal_type" \u306E "expected_text" \u5F15\u6570\u306F\u3001str \u30EA\u30C6\u30E9\u30EB\u5024\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        revealTypeExpectedTextMismatch: '\u5165\u529B\u30C6\u30AD\u30B9\u30C8\u306E\u4E0D\u4E00\u81F4;"{expected}" \u304C\u5FC5\u8981\u3067\u3059\u304C\u3001"{received}" \u3092\u53D7\u4FE1\u3057\u307E\u3057\u305F',
        revealTypeExpectedTypeMismatch: '\u578B\u304C\u4E00\u81F4\u3057\u307E\u305B\u3093\u3002"{expected}" \u304C\u5FC5\u8981\u3067\u3059\u304C\u3001"{received}" \u3092\u53D7\u4FE1\u3057\u307E\u3057\u305F',
        selfTypeContext: '"Self" \u306F\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u7121\u52B9\u3067\u3059',
        selfTypeMetaclass: '"Self" \u306F\u30E1\u30BF\u30AF\u30E9\u30B9 ("type" \u306E\u30B5\u30D6\u30AF\u30E9\u30B9) \u5185\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        selfTypeWithTypedSelfOrCls: `"Self" \u306F\u3001"Self" \u4EE5\u5916\u306E\u578B\u6CE8\u91C8\u3092\u6301\u3064 'self' \u307E\u305F\u306F 'cls' \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3092\u6301\u3064\u95A2\u6570\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093`,
        sentinelBadName: "The first argument to Sentinel must be a string literal",
        sentinelNameMismatch: "Sentinel must be assigned to a variable with the same name",
        sentinelParamCount: "Sentinel requires one positional argument",
        setterGetterTypeMismatch: "property setter \u5024\u306E\u578B\u306F\u3001getter \u306E\u623B\u308A\u5024\u306E\u578B\u306B\u5272\u308A\u5F53\u3066\u308B\u3053\u3068\u304C\u3067\u304D\u307E\u305B\u3093",
        singleOverload: '"{name}" \u306F\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9\u3068\u3057\u3066\u30DE\u30FC\u30AF\u3055\u308C\u3066\u3044\u307E\u3059\u304C\u3001\u8FFD\u52A0\u306E\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9\u304C\u3042\u308A\u307E\u305B\u3093',
        slotsAttributeError: '__slots__\u3067 "{name}" \u304C\u6307\u5B9A\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        slotsClassVarConflict: '"{name}" \u304C __slots__ \u3067\u5BA3\u8A00\u3055\u308C\u305F\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u5909\u6570\u3068\u7AF6\u5408\u3057\u3066\u3044\u307E\u3059',
        starPatternInAsPattern: '\u30B9\u30BF\u30FC \u30D1\u30BF\u30FC\u30F3\u3092 "as" \u30BF\u30FC\u30B2\u30C3\u30C8\u3068\u5171\u306B\u4F7F\u7528\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        starPatternInOrPattern: "\u30B9\u30BF\u30FC \u30D1\u30BF\u30FC\u30F3\u3092\u4ED6\u306E\u30D1\u30BF\u30FC\u30F3\u5185\u3067 OR \u5316\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        starStarWildcardNotAllowed: '** \u306F\u30EF\u30A4\u30EB\u30C9\u30AB\u30FC\u30C9 "_" \u3068\u5171\u306B\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        staticClsSelfParam: '\u9759\u7684\u30E1\u30BD\u30C3\u30C9\u306B "self" \u307E\u305F\u306F "cls" \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3092\u6307\u5B9A\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        stringNonAsciiBytes: "\u975E ASCII \u6587\u5B57\u306F\u30D0\u30A4\u30C8\u6587\u5B57\u5217\u30EA\u30C6\u30E9\u30EB\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        stringNotSubscriptable: "\u578B\u5F0F\u3067\u306F\u6587\u5B57\u5217\u5F0F\u3092\u6DFB\u5B57\u306B\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093\u3002\u5F0F\u5168\u4F53\u3092\u5F15\u7528\u7B26\u3067\u56F2\u3093\u3067\u304F\u3060\u3055\u3044",
        stringUnsupportedEscape: "\u6587\u5B57\u5217\u30EA\u30C6\u30E9\u30EB\u3067\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u306A\u3044\u30A8\u30B9\u30B1\u30FC\u30D7 \u30B7\u30FC\u30B1\u30F3\u30B9",
        stringUnterminated: "\u6587\u5B57\u5217\u30EA\u30C6\u30E9\u30EB\u304C\u672A\u7D42\u4E86\u3067\u3059",
        stubFileMissing: '"{importName}" \u306E stub \u30D5\u30A1\u30A4\u30EB\u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093',
        stubUsesGetAttr: '\u578B stub \u30D5\u30A1\u30A4\u30EB\u304C\u4E0D\u5B8C\u5168\u3067\u3059\u3002"__getattr__" \u306F\u30E2\u30B8\u30E5\u30FC\u30EB\u306E\u578B\u30A8\u30E9\u30FC\u3092\u96A0\u3057\u307E\u3059',
        sublistParamsIncompatible: "Python 3.x \u3067\u306F sublist \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        superCallArgCount: '"super" \u547C\u3073\u51FA\u3057\u306B\u306F 2 \u3064\u4EE5\u4E0B\u306E\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059',
        superCallFirstArg: '"super" \u547C\u3073\u51FA\u3057\u306E\u6700\u521D\u306E\u5F15\u6570\u3068\u3057\u3066\u30AF\u30E9\u30B9\u578B\u304C\u5FC5\u8981\u3067\u3059\u304C\u3001"{type}" \u3092\u53D7\u3051\u53D6\u308A\u307E\u3057\u305F',
        superCallSecondArg: '"super" \u547C\u3073\u51FA\u3057\u306E 2 \u756A\u76EE\u306E\u5F15\u6570\u306F\u3001"{type}" \u304B\u3089\u6D3E\u751F\u3057\u305F\u30AA\u30D6\u30B8\u30A7\u30AF\u30C8\u307E\u305F\u306F\u30AF\u30E9\u30B9\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        superCallZeroArgForm: '"super" \u547C\u3073\u51FA\u3057\u306E 0 \u5F15\u6570\u5F62\u5F0F\u306F\u3001\u30E1\u30BD\u30C3\u30C9\u5185\u3067\u306E\u307F\u6709\u52B9\u3067\u3059',
        superCallZeroArgFormStaticMethod: '"super" \u547C\u3073\u51FA\u3057\u306E 0 \u5F15\u6570\u5F62\u5F0F\u306F\u3001\u9759\u7684\u30E1\u30BD\u30C3\u30C9\u5185\u3067\u306F\u6709\u52B9\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        symbolIsPossiblyUnbound: '"{name}" \u306F\u30D0\u30A4\u30F3\u30C9\u3055\u308C\u3066\u3044\u306A\u3044\u53EF\u80FD\u6027\u304C\u3042\u308A\u307E\u3059',
        symbolIsUnbound: '"{name}" \u306F\u30D0\u30A4\u30F3\u30C9\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        symbolIsUndefined: '"{name}" \u304C\u5B9A\u7FA9\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        symbolOverridden: '"{name}" \u306F\u30AF\u30E9\u30B9 "{className}" \u306E\u540C\u3058\u540D\u524D\u306E\u30B7\u30F3\u30DC\u30EB\u3092\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u3057\u307E\u3059',
        templateStringBytes: "Template string literals (t-strings) cannot be binary",
        templateStringIllegal: "Template string literals (t-strings) require Python 3.14 or newer",
        templateStringUnicode: "Template string literals (t-strings) cannot be unicode",
        ternaryNotAllowed: "3 \u9805\u5F0F\u306F\u578B\u5F0F\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        totalOrderingMissingMethod: 'total_ordering\u3092\u4F7F\u7528\u3059\u308B\u306B\u306F\u3001\u30AF\u30E9\u30B9\u3067 "__lt__"\u3001"__le__"\u3001"__gt__"\u3001\u307E\u305F\u306F "__ge__" \u306E\u3044\u305A\u308C\u304B\u3092\u5B9A\u7FA9\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        trailingCommaInFromImport: "\u672B\u5C3E\u306E\u30B3\u30F3\u30DE\u306F\u304B\u3063\u3053\u3067\u56F2\u307E\u305A\u306B\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        tryWithoutExcept: "Try \u30B9\u30C6\u30FC\u30C8\u30E1\u30F3\u30C8\u306B\u306F\u3001\u5C11\u306A\u304F\u3068\u3082 1 \u3064\u306E except \u53E5\u307E\u305F\u306F finally \u53E5\u304C\u5FC5\u8981\u3067\u3059",
        tupleAssignmentMismatch: '\u578B "{type}" \u306E\u5F0F\u306F\u30BF\u30FC\u30B2\u30C3\u30C8 tuple \u306B\u5272\u308A\u5F53\u3066\u308B\u3053\u3068\u304C\u3067\u304D\u307E\u305B\u3093',
        tupleInAnnotation: "tuple \u5F0F\u306F\u578B\u5F0F\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        tupleIndexOutOfRange: "\u30A4\u30F3\u30C7\u30C3\u30AF\u30B9 {index} \u304C\u578B {type} \u306E\u7BC4\u56F2\u5916\u3067\u3059",
        typeAliasIllegalExpressionForm: "\u578B\u30A8\u30A4\u30EA\u30A2\u30B9\u5B9A\u7FA9\u306E\u5F0F\u30D5\u30A9\u30FC\u30E0\u304C\u7121\u52B9\u3067\u3059",
        typeAliasIsRecursiveDirect: '\u578B\u30A8\u30A4\u30EA\u30A2\u30B9 "{name}" \u306F\u3001\u305D\u306E\u5B9A\u7FA9\u3067\u305D\u308C\u81EA\u4F53\u3092\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        typeAliasNotInModuleOrClass: "TypeAlias \u306F\u3001\u30E2\u30B8\u30E5\u30FC\u30EB\u307E\u305F\u306F\u30AF\u30E9\u30B9\u30B9\u30B3\u30FC\u30D7\u5185\u3067\u306E\u307F\u5B9A\u7FA9\u3067\u304D\u307E\u3059",
        typeAliasRedeclared: '"{name}" \u306F TypeAlias \u3068\u3057\u3066\u5BA3\u8A00\u3055\u308C\u3066\u304A\u308A\u30011 \u56DE\u3060\u3051\u5272\u308A\u5F53\u3066\u308B\u3053\u3068\u304C\u3067\u304D\u307E\u3059',
        typeAliasStatementBadScope: "type \u30B9\u30C6\u30FC\u30C8\u30E1\u30F3\u30C8\u306F\u3001\u30E2\u30B8\u30E5\u30FC\u30EB\u307E\u305F\u306F\u30AF\u30E9\u30B9\u30B9\u30B3\u30FC\u30D7\u5185\u3067\u306E\u307F\u4F7F\u7528\u3067\u304D\u307E\u3059",
        typeAliasStatementIllegal: "\u578B\u30A8\u30A4\u30EA\u30A2\u30B9 \u30B9\u30C6\u30FC\u30C8\u30E1\u30F3\u30C8\u306B\u306F Python 3.12 \u4EE5\u964D\u304C\u5FC5\u8981\u3067\u3059",
        typeAliasTypeBadScope: "\u578B\u30A8\u30A4\u30EA\u30A2\u30B9\u306F\u3001\u30E2\u30B8\u30E5\u30FC\u30EB\u307E\u305F\u306F\u30AF\u30E9\u30B9 \u30B9\u30B3\u30FC\u30D7\u5185\u3067\u306E\u307F\u5B9A\u7FA9\u3067\u304D\u307E\u3059",
        typeAliasTypeBaseClass: '"type" \u30B9\u30C6\u30FC\u30C8\u30E1\u30F3\u30C8\u3067\u5B9A\u7FA9\u3055\u308C\u305F\u578B\u30A8\u30A4\u30EA\u30A2\u30B9\u3092\u57FA\u5E95\u30AF\u30E9\u30B9\u3068\u3057\u3066\u4F7F\u7528\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        typeAliasTypeMustBeAssigned: "TypeAliasType \u306F\u3001\u578B\u30A8\u30A4\u30EA\u30A2\u30B9\u3068\u540C\u3058\u540D\u524D\u306E\u5909\u6570\u306B\u5272\u308A\u5F53\u3066\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        typeAliasTypeNameArg: "TypeAliasType \u306E\u6700\u521D\u306E\u5F15\u6570\u306F\u3001\u578B\u30A8\u30A4\u30EA\u30A2\u30B9\u306E\u540D\u524D\u3092\u8868\u3059\u6587\u5B57\u5217\u30EA\u30C6\u30E9\u30EB\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        typeAliasTypeNameMismatch: "\u578B\u30A8\u30A4\u30EA\u30A2\u30B9\u306E\u540D\u524D\u306F\u3001\u305D\u308C\u304C\u5272\u308A\u5F53\u3066\u3089\u308C\u3066\u3044\u308B\u5909\u6570\u306E\u540D\u524D\u3068\u4E00\u81F4\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        typeAliasTypeParamInvalid: "\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC \u30EA\u30B9\u30C8\u306F\u3001TypeVar\u3001TypeVarTuple\u3001\u307E\u305F\u306F ParamSpec \u306E\u307F\u3092\u542B\u3080 tuple \u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        typeAnnotationCall: "\u578B\u5F0F\u3067\u306F\u547C\u3073\u51FA\u3057\u5F0F\u3092\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        typeAnnotationVariable: "\u578B\u5F0F\u3067\u306F\u5909\u6570\u3092\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        typeAnnotationWithCallable: '"type" \u306E\u578B\u5F15\u6570\u306F\u30AF\u30E9\u30B9\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059\u3002\u547C\u3073\u51FA\u3057\u53EF\u80FD\u95A2\u6570\u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        typeArgListExpected: "ParamSpec\u3001\u7701\u7565\u8A18\u53F7\u3001\u307E\u305F\u306F\u578B\u306E list \u304C\u5FC5\u8981\u3067\u3059",
        typeArgListNotAllowed: "\u3053\u306E\u578B\u5F15\u6570\u306B\u306F list \u5F0F\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        typeArgsExpectingNone: '\u30AF\u30E9\u30B9 "{name}" \u306B\u578B\u5F15\u6570\u304C\u5FC5\u8981\u3042\u308A\u307E\u305B\u3093',
        typeArgsMismatchOne: "1 \u3064\u306E\u578B\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059\u304C\u3001{received} \u3092\u53D7\u3051\u53D6\u308A\u307E\u3057\u305F",
        typeArgsMissingForAlias: '\u30B8\u30A7\u30CD\u30EA\u30C3\u30AF\u578B\u30A8\u30A4\u30EA\u30A2\u30B9 "{name}" \u306B\u5FC5\u8981\u306A\u578B\u5F15\u6570',
        typeArgsMissingForClass: '\u30B8\u30A7\u30CD\u30EA\u30C3\u30AF \u30AF\u30E9\u30B9 "{name}" \u306B\u5FC5\u8981\u306A\u578B\u5F15\u6570',
        typeArgsTooFew: '"{name}" \u306B\u6307\u5B9A\u3055\u308C\u305F\u578B\u5F15\u6570\u304C\u5C11\u306A\u3059\u304E\u307E\u3059\u3002{expected} \u304C\u5FC5\u8981\u3067\u3059\u304C\u3001{received} \u3092\u53D7\u4FE1\u3057\u307E\u3057\u305F',
        typeArgsTooMany: '"{name}" \u306B\u6307\u5B9A\u3055\u308C\u305F\u578B\u5F15\u6570\u304C\u591A\u3059\u304E\u307E\u3059\u3002{expected} \u304C\u5FC5\u8981\u3067\u3059\u304C\u3001{received} \u3092\u53D7\u4FE1\u3057\u307E\u3057\u305F',
        typeAssignmentMismatch: '\u578B "{sourceType}" \u306F\u5BA3\u8A00\u3055\u308C\u305F\u578B "{destType}" \u306B\u5272\u308A\u5F53\u3066\u3067\u304D\u307E\u305B\u3093',
        typeAssignmentMismatchWildcard: '\u30A4\u30F3\u30DD\u30FC\u30C8 \u30B7\u30F3\u30DC\u30EB "{name}" \u306B\u306F\u578B "{sourceType}" \u304C\u3042\u308A\u3001\u5BA3\u8A00\u3055\u308C\u305F\u578B "{destType}" \u306B\u306F\u5272\u308A\u5F53\u3066\u3067\u304D\u307E\u305B\u3093',
        typeCallNotAllowed: "type() \u547C\u3073\u51FA\u3057\u306F\u578B\u5F0F\u3067\u4F7F\u7528\u3057\u306A\u3044\u3067\u304F\u3060\u3055\u3044",
        typeCheckOnly: '"{name}" \u306F@type_check_only\u3068\u3057\u3066\u30DE\u30FC\u30AF\u3055\u308C\u3066\u304A\u308A\u3001\u578B\u6CE8\u91C8\u3067\u306E\u307F\u4F7F\u7528\u3067\u304D\u307E\u3059',
        typeCommentDeprecated: "type \u30B3\u30E1\u30F3\u30C8\u306E\u4F7F\u7528\u306F\u975E\u63A8\u5968\u3067\u3059\u3002\u4EE3\u308F\u308A\u306B type \u6CE8\u91C8\u3092\u4F7F\u7528\u3057\u3066\u304F\u3060\u3055\u3044",
        typeExpectedClass: '\u30AF\u30E9\u30B9\u304C\u5FC5\u8981\u3067\u3059\u304C\u3001"{type}" \u3092\u53D7\u3051\u53D6\u308A\u307E\u3057\u305F',
        typeFormArgs: '"TypeForm" \u306F 1 \u3064\u306E\u4F4D\u7F6E\u5F15\u6570\u3092\u53D7\u3051\u53D6\u308A\u307E\u3059',
        typeGuardArgCount: '"TypeGuard" \u307E\u305F\u306F "TypeIs" \u306E\u5F8C\u306B 1 \u3064\u306E\u578B\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059',
        typeGuardParamCount: "\u30E6\u30FC\u30B6\u30FC\u5B9A\u7FA9\u578B\u30AC\u30FC\u30C9\u95A2\u6570\u3068\u30E1\u30BD\u30C3\u30C9\u306B\u306F\u3001\u5C11\u306A\u304F\u3068\u3082 1 \u3064\u306E\u5165\u529B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u304C\u5FC5\u8981\u3067\u3059",
        typeIsReturnType: 'TypeIs \u306E\u623B\u308A\u5024\u306E\u578B ("{returnType}") \u3068\u5024\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u578B ("{type}") \u304C\u4E00\u81F4\u3057\u307E\u305B\u3093',
        typeNotAwaitable: '"{type}" \u306F awaitable \u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        typeNotIntantiable: '"{type}" \u3092\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u5316\u3067\u304D\u307E\u305B\u3093',
        typeNotIterable: '"{type}" \u306F\u53CD\u5FA9\u3067\u304D\u307E\u305B\u3093',
        typeNotSpecializable: '\u578B "{type}" \u3092\u7279\u6B8A\u5316\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F',
        typeNotSubscriptable: '\u578B "{type}" \u306E\u30AA\u30D6\u30B8\u30A7\u30AF\u30C8\u306F\u6DFB\u5B57\u53EF\u80FD\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        typeNotSupportBinaryOperator: '\u6F14\u7B97\u5B50 "{operator}" \u306F\u578B "{leftType}" \u3068 "{rightType}" \u3067\u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        typeNotSupportBinaryOperatorBidirectional: '\u578B "{leftType}" \u3068 "{rightType}" \u306B\u5BFE\u3057\u3066\u6F14\u7B97\u5B50 "{operator}" \u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093\u3002\u4E88\u671F\u3055\u308C\u305F\u578B\u304C "{expectedType}" \u306E\u5834\u5408',
        typeNotSupportUnaryOperator: '\u6F14\u7B97\u5B50 "{operator}" \u306F\u578B "{type}" \u3067\u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        typeNotSupportUnaryOperatorBidirectional: '\u578B "{type}" \u304C "{expectedType}" \u306E\u5834\u5408\u3001\u6F14\u7B97\u5B50 "{operator}" \u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        typeNotUsableWith: '\u578B "{type}" \u306E\u30AA\u30D6\u30B8\u30A7\u30AF\u30C8\u306F\u3001{method} \u3092\u6B63\u3057\u304F\u5B9F\u88C5\u3057\u3066\u3044\u306A\u3044\u305F\u3081\u3001"with" \u3068\u5171\u306B\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        typeNotUsableWithAsync: '\u578B "{type}" \u306E\u30AA\u30D6\u30B8\u30A7\u30AF\u30C8\u306F\u3001{method} \u3092\u6B63\u3057\u304F\u5B9F\u88C5\u3057\u3066\u3044\u306A\u3044\u305F\u3081\u3001"async with" \u3068\u5171\u306B\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        typeParameterBoundNotAllowed: "\u30D0\u30A4\u30F3\u30C9\u307E\u305F\u306F\u5236\u7D04\u3092\u53EF\u5909\u500B\u5F15\u6570\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u307E\u305F\u306F ParamSpec \u3068\u5171\u306B\u4F7F\u7528\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        typeParameterConstraintTuple: "\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u5236\u7D04\u306F\u30012 \u3064\u4EE5\u4E0A\u306E\u578B\u306E\u30BF\u30D7\u30EB\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        typeParameterExistingTypeParameter: '\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u306F\u65E2\u306B\u4F7F\u7528\u3055\u308C\u3066\u3044\u307E\u3059',
        typeParameterNotDeclared: '\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u306F\u3001"{container}" \u306E\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u30EA\u30B9\u30C8\u306B\u542B\u307E\u308C\u3066\u3044\u307E\u305B\u3093',
        typeParametersMissing: "\u5C11\u306A\u304F\u3068\u3082 1 \u3064\u306E\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3092\u6307\u5B9A\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        typePartiallyUnknown: '"{name}" \u306E\u7A2E\u985E\u304C\u90E8\u5206\u7684\u306B\u4E0D\u660E\u3067\u3059',
        typeUnknown: '"{name}" \u306E\u7A2E\u985E\u304C\u4E0D\u660E\u3067\u3059',
        typeVarAssignedName: 'TypeVar \u306F \u3001"{name}" \u3068\u3044\u3046\u540D\u524D\u306E\u5909\u6570\u306B\u5272\u308A\u5F53\u3066\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        typeVarAssignmentMismatch: '\u578B "{type}" \u3092\u578B\u5909\u6570 "{name}" \u306B\u5272\u308A\u5F53\u3066\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        typeVarBoundAndConstrained: "TypeVar \u3092\u30D0\u30A4\u30F3\u30C9\u3068\u5236\u7D04\u306E\u4E21\u65B9\u306B\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        typeVarBoundGeneric: "TypeVar \u30D0\u30A4\u30F3\u30C9\u578B\u3092\u30B8\u30A7\u30CD\u30EA\u30C3\u30AF\u306B\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        typeVarConstraintGeneric: "TypeVar \u5236\u7D04\u578B\u3092\u30B8\u30A7\u30CD\u30EA\u30C3\u30AF\u306B\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        typeVarDefaultBoundMismatch: "TypeVar \u306E\u65E2\u5B9A\u306E\u578B\u306F\u30D0\u30A4\u30F3\u30C9\u3055\u308C\u305F\u578B\u306E\u30B5\u30D6\u30BF\u30A4\u30D7\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        typeVarDefaultConstraintMismatch: "TypeVar \u306E\u65E2\u5B9A\u306E\u578B\u306F\u3001\u5236\u7D04\u4ED8\u304D\u578B\u306E\u3044\u305A\u308C\u304B\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        typeVarDefaultIllegal: "\u578B\u5909\u6570\u306E\u65E2\u5B9A\u306E\u578B\u306B\u306F Python 3.13 \u4EE5\u964D\u304C\u5FC5\u8981\u3067\u3059",
        typeVarDefaultInvalidTypeVar: '\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u306B\u306F\u3001\u30B9\u30B3\u30FC\u30D7\u5916\u306E 1 \u3064\u4EE5\u4E0A\u306E\u578B\u5909\u6570\u3092\u53C2\u7167\u3059\u308B\u65E2\u5B9A\u306E\u578B\u304C\u3042\u308A\u307E\u3059',
        typeVarFirstArg: "\u6700\u521D\u306E\u5F15\u6570\u3068\u3057\u3066 TypeVar \u306E\u540D\u524D\u304C\u5FC5\u8981\u3067\u3059",
        typeVarInvalidForMemberVariable: '\u5C5E\u6027\u578B\u306F\u3001\u30ED\u30FC\u30AB\u30EB \u30E1\u30BD\u30C3\u30C9\u306B\u30B9\u30B3\u30FC\u30D7\u6307\u5B9A\u3055\u308C\u305F\u578B\u5909\u6570 "{name}" \u3092\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        typeVarNoMember: 'TypeVar "{type}" \u306B\u306F\u5C5E\u6027 "{name}" \u304C\u3042\u308A\u307E\u305B\u3093',
        typeVarNotSubscriptable: 'TypeVar "{type}" \u306F\u6DFB\u5B57\u53EF\u80FD\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        typeVarNotUsedByOuterScope: '\u578B\u5909\u6570 "{name}" \u306F\u3001\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u610F\u5473\u304C\u3042\u308A\u307E\u305B\u3093',
        typeVarPossiblyUnsolvable: '\u547C\u3073\u51FA\u3057\u5143\u304C\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{param}" \u306B\u5F15\u6570\u3092\u6307\u5B9A\u3057\u306A\u3044\u5834\u5408\u3001\u578B\u5909\u6570 "{name}" \u306F\u89E3\u6C7A\u3055\u308C\u306A\u3044\u53EF\u80FD\u6027\u304C\u3042\u308A\u307E\u3059',
        typeVarSingleConstraint: "TypeVar \u306B\u306F\u5C11\u306A\u304F\u3068\u3082 2 \u3064\u306E\u5236\u7D04\u4ED8\u304D\u578B\u304C\u5FC5\u8981\u3067\u3059",
        typeVarTupleConstraints: "TypeVarTuple \u306B\u5024\u5236\u7D04\u3092\u6301\u305F\u305B\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        typeVarTupleContext: "TypeVarTuple \u306F\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        typeVarTupleDefaultNotUnpacked: "TypeVarTuple \u306E\u65E2\u5B9A\u306E\u578B\u306F\u3001\u30A2\u30F3\u30D1\u30C3\u30AF\u3055\u308C\u305F tuple \u307E\u305F\u306F TypeVarTuple \u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        typeVarTupleMustBeUnpacked: "TypeVarTuple \u5024\u306B\u306F\u30A2\u30F3\u30D1\u30C3\u30AF\u6F14\u7B97\u5B50\u304C\u5FC5\u8981\u3067\u3059",
        typeVarTupleUnknownParam: '"{name}" \u306F TypeVarTuple \u306B\u5BFE\u3059\u308B\u4E0D\u660E\u306A\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3067\u3059',
        typeVarUnknownParam: '"{name}" \u306F TypeVar \u306B\u5BFE\u3059\u308B\u4E0D\u660E\u306A\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3067\u3059',
        typeVarUsedByOuterScope: 'TypeVar "{name}" \u306F\u5916\u90E8\u30B9\u30B3\u30FC\u30D7\u3067\u65E2\u306B\u4F7F\u7528\u3055\u308C\u3066\u3044\u307E\u3059',
        typeVarUsedOnlyOnce: 'TypeVar "{name}" \u306F\u30B8\u30A7\u30CD\u30EA\u30C3\u30AF\u95A2\u6570\u30B7\u30B0\u30CD\u30C1\u30E3\u306B 1 \u56DE\u3060\u3051\u51FA\u73FE\u3057\u307E\u3059',
        typeVarVariance: "TypeVar \u3092\u5171\u5909\u3068\u53CD\u5909\u306E\u4E21\u65B9\u306B\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        typeVarWithDefaultFollowsVariadic: 'TypeVar "{typeVarName}" \u306B\u306F\u65E2\u5B9A\u5024\u304C\u3042\u308A\u3001TypeVarTuple "{variadicName}" \u306E\u5F8C\u306B\u7D9A\u3051\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        typeVarWithoutDefault: '"{name}" \u306F\u65E2\u5B9A\u306E\u578B\u304C\u306A\u3044\u305F\u3081\u3001\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC \u30EA\u30B9\u30C8\u306E "{other}" \u306E\u5F8C\u306B\u8868\u793A\u3067\u304D\u307E\u305B\u3093',
        typeVarsNotInGenericOrProtocol: "Generic[] \u307E\u305F\u306F Protocol[] \u306B\u306F\u3001\u3059\u3079\u3066\u306E\u578B\u5909\u6570\u3092\u542B\u3081\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        typedDictAccess: "TypedDict \u306E\u9805\u76EE\u306B\u30A2\u30AF\u30BB\u30B9\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F",
        typedDictAssignedName: 'TypedDict \u306F "{name}" \u3068\u3044\u3046\u540D\u524D\u306E\u5909\u6570\u306B\u5272\u308A\u5F53\u3066\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        typedDictBadVar: "TypedDict \u30AF\u30E9\u30B9\u306B\u306F\u578B\u6CE8\u91C8\u306E\u307F\u3092\u542B\u3081\u308B\u3053\u3068\u304C\u3067\u304D\u307E\u3059",
        typedDictBaseClass: "TypedDict \u30AF\u30E9\u30B9\u306E\u3059\u3079\u3066\u306E\u57FA\u5E95\u30AF\u30E9\u30B9\u3082 TypedDict \u30AF\u30E9\u30B9\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        typedDictBoolParam: '"{name}" \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u5024\u306F True \u307E\u305F\u306F False \u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        typedDictClosedExtras: '\u57FA\u5E95\u30AF\u30E9\u30B9 "{name}" \u306F\u3001\u4F59\u5206\u306A\u9805\u76EE\u306E\u578B\u3092\u578B "{type}" \u306B\u5236\u9650\u3059\u308B TypedDict \u3067\u3059',
        typedDictClosedFalseNonOpenBase: 'Base class "{name}" is not an open TypedDict; closed=False is not allowed',
        typedDictClosedNoExtras: '\u57FA\u5E95\u30AF\u30E9\u30B9 "{name}" \u306F closed \u3057\u305F TypedDict \u3067\u3059\u3002\u8FFD\u52A0\u306E\u9805\u76EE\u306F\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        typedDictDelete: "TypedDict \u306E\u9805\u76EE\u3092\u524A\u9664\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F",
        typedDictEmptyName: "TypedDict \u5185\u306E\u540D\u524D\u3092\u7A7A\u306B\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        typedDictEntryName: "\u8F9E\u66F8\u30A8\u30F3\u30C8\u30EA\u540D\u306B\u6587\u5B57\u5217\u30EA\u30C6\u30E9\u30EB\u304C\u5FC5\u8981\u3067\u3059",
        typedDictEntryUnique: "\u30C7\u30A3\u30AF\u30B7\u30E7\u30CA\u30EA\u5185\u306E\u540D\u524D\u306F\u4E00\u610F\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        typedDictExtraArgs: "\u8FFD\u52A0\u306E TypedDict \u5F15\u6570\u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        typedDictExtraItemsClosed: 'TypedDict \u306F "closed" \u307E\u305F\u306F "extra_items" \u3092\u4F7F\u7528\u3067\u304D\u307E\u3059\u304C\u3001\u4E21\u65B9\u3092\u4F7F\u7528\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        typedDictFieldNotRequiredRedefinition: 'TypedDict \u30A2\u30A4\u30C6\u30E0 "{name}" \u3092 NotRequired \u3068\u3057\u3066\u518D\u5B9A\u7FA9\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        typedDictFieldReadOnlyRedefinition: 'TypedDict \u30A2\u30A4\u30C6\u30E0 "{name}" \u3092 ReadOnly \u3068\u3057\u3066\u518D\u5B9A\u7FA9\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        typedDictFieldRequiredRedefinition: 'TypedDict \u30A2\u30A4\u30C6\u30E0 "{name}" \u3092 Required \u3068\u3057\u3066\u518D\u5B9A\u7FA9\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        typedDictFirstArg: "\u6700\u521D\u306E\u5F15\u6570\u3068\u3057\u3066 TypedDict \u30AF\u30E9\u30B9\u540D\u304C\u5FC5\u8981\u3067\u3059",
        typedDictInClassPattern: "TypedDict \u30AF\u30E9\u30B9\u306F\u30AF\u30E9\u30B9 \u30D1\u30BF\u30FC\u30F3\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        typedDictInitsubclassParameter: 'TypedDict \u306F __init_subclass__\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u3092\u30B5\u30DD\u30FC\u30C8\u3057\u3066\u3044\u307E\u305B\u3093',
        typedDictNotAllowed: '"TypedDict" \u306F\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        typedDictSecondArgDict: "2 \u756A\u76EE\u306E\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3068\u3057\u3066 dict \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u307E\u305F\u306F\u30AD\u30FC\u30EF\u30FC\u30C9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u304C\u5FC5\u8981\u3067\u3059",
        typedDictSecondArgDictEntry: "\u5358\u7D14\u306A\u8F9E\u66F8\u30A8\u30F3\u30C8\u30EA\u304C\u5FC5\u8981\u3067\u3059",
        typedDictSet: "TypedDict \u3067\u9805\u76EE\u3092\u5272\u308A\u5F53\u3066\u308B\u3053\u3068\u304C\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F",
        unaccessedClass: '\u30AF\u30E9\u30B9 "{name}" \u306F\u53C2\u7167\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        unaccessedFunction: '\u95A2\u6570 "{name}" \u306F\u53C2\u7167\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        unaccessedImport: '\u30A4\u30F3\u30DD\u30FC\u30C8 "{name}" \u306F\u53C2\u7167\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        unaccessedSymbol: '"{name}" \u306F\u53C2\u7167\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        unaccessedVariable: '\u5909\u6570 "{name}" \u306F\u53C2\u7167\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        unannotatedFunctionSkipped: '\u95A2\u6570 "{name}" \u306E\u5206\u6790\u306F\u3001\u8868\u793A\u3055\u308C\u306A\u3044\u305F\u3081\u30B9\u30AD\u30C3\u30D7\u3055\u308C\u307E\u3059',
        unaryOperationNotAllowed: "\u5358\u9805\u6F14\u7B97\u5B50\u306F\u578B\u5F0F\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        unexpectedAsyncToken: '"def"\u3001"with"\u3001\u307E\u305F\u306F "for" \u304C "async" \u306E\u5F8C\u306B\u7D9A\u304F\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        unexpectedEof: "Unexpected EOF",
        unexpectedExprToken: "\u5F0F\u306E\u6700\u5F8C\u306B\u4E88\u671F\u3057\u306A\u3044\u30C8\u30FC\u30AF\u30F3\u304C\u542B\u307E\u308C\u3066\u3044\u307E\u3059",
        unexpectedIndent: "\u4E88\u671F\u3057\u306A\u3044\u30A4\u30F3\u30C7\u30F3\u30C8",
        unexpectedUnindent: "\u30A4\u30F3\u30C7\u30F3\u30C8\u89E3\u9664\u306F\u4E88\u671F\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        unhashableDictKey: "\u8F9E\u66F8\u30AD\u30FC\u306F\u30CF\u30C3\u30B7\u30E5\u53EF\u80FD\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        unhashableSetEntry: "set \u30A8\u30F3\u30C8\u30EA\u306F\u30CF\u30C3\u30B7\u30E5\u53EF\u80FD\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        uninitializedAbstractVariables: '\u62BD\u8C61\u57FA\u5E95\u30AF\u30E9\u30B9\u3067\u5B9A\u7FA9\u3055\u308C\u305F\u5909\u6570\u304C\u3001final \u30AF\u30E9\u30B9 "{classType}" \u3067\u521D\u671F\u5316\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        uninitializedInstanceVariable: '\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u5909\u6570 "{name}" \u306F\u3001\u30AF\u30E9\u30B9\u672C\u4F53\u307E\u305F\u306F__init__ \u30E1\u30BD\u30C3\u30C9\u3067\u521D\u671F\u5316\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        unionForwardReferenceNotAllowed: "Union \u69CB\u6587\u306F\u6587\u5B57\u5217\u30AA\u30DA\u30E9\u30F3\u30C9\u3067\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093\u3002\u5F0F\u5168\u4F53\u3092\u5F15\u7528\u7B26\u3067\u56F2\u3093\u3067\u304F\u3060\u3055\u3044",
        unionSyntaxIllegal: "\u5171\u7528\u4F53\u306E\u4EE3\u66FF\u69CB\u6587\u306B\u306F Python 3.10 \u4EE5\u964D\u304C\u5FC5\u8981\u3067\u3059",
        unionTypeArgCount: "Union \u306B\u306F 2 \u3064\u4EE5\u4E0A\u306E\u578B\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059",
        unionUnpackedTuple: "Union cannot include an unpacked tuple",
        unionUnpackedTypeVarTuple: "Union cannot include an unpacked TypeVarTuple",
        unnecessaryCast: '\u4E0D\u8981\u306A "cast" \u547C\u3073\u51FA\u3057\u3002\u578B\u306F\u65E2\u306B "{type}" \u3067\u3059',
        unnecessaryIsInstanceAlways: '\u4E0D\u8981\u306A isinstance \u547C\u3073\u51FA\u3057\u3002"{testType}" \u306F\u5E38\u306B "{classType}" \u306E\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u3067\u3059',
        unnecessaryIsInstanceNever: '\u4E0D\u8981\u306A isinstance \u547C\u3073\u51FA\u3057; "{testType}" \u306F"{classType}" \u306E\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u3067\u3042\u3063\u305F\u3053\u3068\u306F\u3042\u308A\u307E\u305B\u3093',
        unnecessaryIsSubclassAlways: '\u4E0D\u8981\u306A issubclass \u547C\u3073\u51FA\u3057\u3002"{testType}" \u306F\u5E38\u306B "{classType}" \u306E\u30B5\u30D6\u30AF\u30E9\u30B9\u3067\u3059',
        unnecessaryIsSubclassNever: '\u4E0D\u8981\u306A issubclass \u547C\u3073\u51FA\u3057; "{testType}" \u306F "{classType}" \u306E\u30B5\u30D6\u30AF\u30E9\u30B9\u3067\u3042\u3063\u305F\u3053\u3068\u306F\u3042\u308A\u307E\u305B\u3093',
        unnecessaryPyrightIgnore: '\u4E0D\u8981\u306A "# pyright: ignore" \u30B3\u30E1\u30F3\u30C8',
        unnecessaryPyrightIgnoreRule: '\u4E0D\u8981\u306A "# pyright: ignore" \u30EB\u30FC\u30EB: "{name}"',
        unnecessaryTypeIgnore: '\u4E0D\u8981\u306A "# type: ignore" \u30B3\u30E1\u30F3\u30C8',
        unpackArgCount: '"Unpack" \u306E\u5F8C\u306B 1 \u3064\u306E\u578B\u5F15\u6570\u304C\u5FC5\u8981\u3067\u3059',
        unpackExpectedTypeVarTuple: "Unpack \u306E\u578B\u5F15\u6570\u3068\u3057\u3066 TypeVarTuple \u307E\u305F\u306F tuple \u304C\u5FC5\u8981\u3067\u3059",
        unpackExpectedTypedDict: "Unpack \u306B\u5FC5\u8981\u306A TypedDict \u578B\u5F15\u6570",
        unpackIllegalInComprehension: "\u30A2\u30F3\u30D1\u30C3\u30AF\u64CD\u4F5C\u306F\u7406\u89E3\u3067\u304D\u307E\u305B\u3093",
        unpackInAnnotation: "\u30A2\u30F3\u30D1\u30C3\u30AF\u6F14\u7B97\u5B50\u306F\u578B\u5F0F\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        unpackInDict: "\u30A2\u30F3\u30D1\u30C3\u30AF\u64CD\u4F5C\u306F\u30C7\u30A3\u30AF\u30B7\u30E7\u30CA\u30EA\u3067\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        unpackInSet: "\u30A2\u30F3\u30D1\u30C3\u30AF\u6F14\u7B97\u5B50\u306F set \u5185\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        unpackNotAllowed: "Unpack \u306F\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        unpackOperatorNotAllowed: "\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u30A2\u30F3\u30D1\u30C3\u30AF\u64CD\u4F5C\u306F\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        unpackTuplesIllegal: "Python 3.8 \u3088\u308A\u524D\u306E\u30BF\u30D7\u30EB\u3067\u306F\u30A2\u30F3\u30D1\u30C3\u30AF\u64CD\u4F5C\u306F\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        unpackedArgInTypeArgument: "\u30A2\u30F3\u30D1\u30C3\u30AF\u3055\u308C\u305F\u5F15\u6570\u306F\u3001\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        unpackedArgWithVariadicParam: "\u30A2\u30F3\u30D1\u30C3\u30AF\u3055\u308C\u305F\u5F15\u6570\u306F TypeVarTuple \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306B\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        unpackedDictArgumentNotMapping: '** \u306E\u5F8C\u306E\u5F15\u6570\u5F0F\u306F\u3001"str" \u30AD\u30FC\u578B\u306E\u30DE\u30C3\u30D4\u30F3\u30B0\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        unpackedDictSubscriptIllegal: "\u4E0B\u4ED8\u304D\u6587\u5B57\u306E\u8F9E\u66F8\u30A2\u30F3\u30D1\u30C3\u30AF\u6F14\u7B97\u5B50\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        unpackedSubscriptIllegal: "\u4E0B\u4ED8\u304D\u6587\u5B57\u306E Unpack \u6F14\u7B97\u5B50\u306B\u306F Python 3.11 \u4EE5\u964D\u304C\u5FC5\u8981\u3067\u3059",
        unpackedTypeVarTupleExpected: "\u30A2\u30F3\u30D1\u30C3\u30AF\u3055\u308C\u305F TypeVarTuple \u304C\u5FC5\u8981\u3067\u3059\u3002Unpack[{name1}] \u307E\u305F\u306F *{name2} \u3092\u4F7F\u7528\u3057\u3066\u304F\u3060\u3055\u3044",
        unpackedTypedDictArgument: "\u30A2\u30F3\u30D1\u30C3\u30AF\u3055\u308C\u305F TypedDict \u5F15\u6570\u3092\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3068\u4E00\u81F4\u3055\u305B\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        unreachableCodeCondition: "Code is not analyzed because condition is statically evaluated as false",
        unreachableCodeStructure: "Code is structurally unreachable",
        unreachableCodeType: "\u578B\u5206\u6790\u306F\u30B3\u30FC\u30C9\u306B\u5230\u9054\u4E0D\u80FD\u3067\u3042\u308B\u3053\u3068\u3092\u793A\u3057\u307E\u3059",
        unreachableExcept: "\u4F8B\u5916\u304C\u65E2\u306B\u51E6\u7406\u3055\u308C\u3066\u3044\u308B\u305F\u3081\u3001Except \u53E5\u306B\u5230\u9054\u3067\u304D\u307E\u305B\u3093",
        unsupportedDunderAllOperation: '"__all__" \u306B\u5BFE\u3059\u308B\u64CD\u4F5C\u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u306A\u3044\u305F\u3081\u3001\u30A8\u30AF\u30B9\u30DD\u30FC\u30C8\u3055\u308C\u305F\u30B7\u30F3\u30DC\u30EB \u30EA\u30B9\u30C8\u304C\u6B63\u3057\u304F\u306A\u3044\u53EF\u80FD\u6027\u304C\u3042\u308A\u307E\u3059',
        unusedCallResult: '\u547C\u3073\u51FA\u3057\u5F0F\u306E\u7D50\u679C\u306F "{type}" \u578B\u3067\u3042\u308A\u3001\u4F7F\u7528\u3055\u308C\u307E\u305B\u3093\u3002\u3053\u308C\u304C\u610F\u56F3\u7684\u306A\u5834\u5408\u306F\u5909\u6570 "_" \u306B\u4EE3\u5165\u3059\u308B',
        unusedCoroutine: 'async \u95A2\u6570\u547C\u3073\u51FA\u3057\u306E\u7D50\u679C\u304C\u4F7F\u7528\u3055\u308C\u3066\u3044\u307E\u305B\u3093\u3002"await" \u3092\u4F7F\u7528\u3059\u308B\u304B\u3001\u7D50\u679C\u3092\u5909\u6570\u306B\u4EE3\u5165\u3057\u3066\u304F\u3060\u3055\u3044\u3002',
        unusedExpression: "\u5F0F\u306E\u5024\u304C\u4F7F\u7528\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        varAnnotationIllegal: "\u5909\u6570\u306E type \u6CE8\u91C8\u306B\u306F Python 3.6 \u4EE5\u964D\u304C\u5FC5\u8981\u3067\u3059\u3002\u4EE5\u524D\u306E\u30D0\u30FC\u30B8\u30E7\u30F3\u3068\u306E\u4E92\u63DB\u6027\u3092\u4FDD\u3064\u305F\u3081\u306B type \u30B3\u30E1\u30F3\u30C8\u3092\u4F7F\u7528\u3057\u3066\u304F\u3060\u3055\u3044",
        variableFinalOverride: '\u5909\u6570 "{name}" \u306F Final \u3068\u30DE\u30FC\u30AF\u3055\u308C\u3001\u30AF\u30E9\u30B9 "{className}" \u306E\u540C\u3058\u540D\u524D\u306E Final \u4EE5\u5916\u306E\u5909\u6570\u3092\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u3057\u307E\u3059',
        variadicTypeArgsTooMany: "\u578B\u5F15\u6570\u30EA\u30B9\u30C8\u306B\u306F\u3001\u30A2\u30F3\u30D1\u30C3\u30AF\u3055\u308C\u305F TypeVarTuple \u307E\u305F\u306F tuple \u3092\u6700\u5927 1 \u3064\u542B\u3081\u308B\u3053\u3068\u304C\u3067\u304D\u307E\u3059",
        variadicTypeParamTooManyAlias: "\u578B\u30A8\u30A4\u30EA\u30A2\u30B9\u306B\u306F TypeVarTuple \u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3092\u6700\u5927 1 \u3064\u542B\u3081\u308B\u3053\u3068\u304C\u3067\u304D\u307E\u3059\u304C\u3001\u8907\u6570\u306E ({names}) \u3092\u53D7\u3051\u53D6\u308A\u307E\u3057\u305F",
        variadicTypeParamTooManyClass: "\u30B8\u30A7\u30CD\u30EA\u30C3\u30AF \u30AF\u30E9\u30B9\u306B\u306F\u6700\u5927 1 \u3064\u306E TypeVarTuple \u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3092\u6307\u5B9A\u3067\u304D\u307E\u3059\u304C\u3001\u8907\u6570\u306E ({names}) \u3092\u53D7\u3051\u53D6\u308A\u307E\u3057\u305F",
        walrusIllegal: '\u6F14\u7B97\u5B50 ":=" \u306B\u306F Python 3.8 \u4EE5\u964D\u304C\u5FC5\u8981\u3067\u3059',
        walrusNotAllowed: '\u6F14\u7B97\u5B50 ":=" \u306F\u3001\u304B\u3063\u3053\u3092\u56F2\u307E\u306A\u3044\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        wildcardInFunction: "\u30EF\u30A4\u30EB\u30C9\u30AB\u30FC\u30C9\u306E import \u306F\u3001\u30AF\u30E9\u30B9\u5185\u307E\u305F\u306F\u95A2\u6570\u5185\u3067\u306F\u8A31\u53EF\u3055\u308C\u307E\u305B\u3093",
        wildcardLibraryImport: "\u30E9\u30A4\u30D6\u30E9\u30EA\u304B\u3089\u306E\u30EF\u30A4\u30EB\u30C9\u30AB\u30FC\u30C9\u306E import \u306F\u8A31\u53EF\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        wildcardPatternTypePartiallyUnknown: "\u30EF\u30A4\u30EB\u30C9\u30AB\u30FC\u30C9 \u30D1\u30BF\u30FC\u30F3\u306B\u3088\u3063\u3066\u30AD\u30E3\u30D7\u30C1\u30E3\u3055\u308C\u305F\u578B\u306F\u90E8\u5206\u7684\u306B\u4E0D\u660E\u3067\u3059",
        wildcardPatternTypeUnknown: "\u30EF\u30A4\u30EB\u30C9\u30AB\u30FC\u30C9 \u30D1\u30BF\u30FC\u30F3\u306B\u3088\u3063\u3066\u30AD\u30E3\u30D7\u30C1\u30E3\u3055\u308C\u305F\u578B\u304C\u4E0D\u660E\u3067\u3059",
        yieldFromIllegal: '"yield from" \u3092\u4F7F\u7528\u3059\u308B\u306B\u306F Python 3.3 \u4EE5\u964D\u304C\u5FC5\u8981\u3067\u3059',
        yieldFromOutsideAsync: 'async \u95A2\u6570\u3067\u306F "yield from" \u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        yieldOutsideFunction: '\u95A2\u6570\u307E\u305F\u306F\u30E9\u30E0\u30C0\u306E\u5916\u90E8\u3067\u306F "yield" \u306F\u8A31\u53EF\u3055\u308C\u307E\u305B\u3093',
        yieldWithinComprehension: '"yield" \u306F\u5185\u5305\u8868\u8A18\u5185\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        zeroCaseStatementsFound: "Match \u30B9\u30C6\u30FC\u30C8\u30E1\u30F3\u30C8\u306B\u306F\u3001\u5C11\u306A\u304F\u3068\u3082 1 \u3064\u306E case \u30B9\u30C6\u30FC\u30C8\u30E1\u30F3\u30C8\u3092\u542B\u3081\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        zeroLengthTupleNotAllowed: "\u3053\u306E\u30B3\u30F3\u30C6\u30AD\u30B9\u30C8\u3067\u306F\u9577\u3055 0 \u306E tuple \u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093"
      },
      DiagnosticAddendum: {
        annotatedNotAllowed: '"Annotated" \u7279\u6B8A\u30D5\u30A9\u30FC\u30E0\u306F\u3001\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u304A\u3088\u3073\u30AF\u30E9\u30B9\u306E\u30C1\u30A7\u30C3\u30AF\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        argParam: '\u5F15\u6570\u306F\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{paramName}" \u306B\u5BFE\u5FDC\u3057\u307E\u3059',
        argParamFunction: '\u5F15\u6570\u306F\u95A2\u6570 "{functionName}" \u306E\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{paramName}" \u306B\u5BFE\u5FDC\u3057\u307E\u3059',
        argsParamMissing: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "*{paramName}" \u306B\u5BFE\u5FDC\u3059\u308B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u304C\u3042\u308A\u307E\u305B\u3093',
        argsPositionOnly: "\u4F4D\u7F6E\u306E\u307F\u306E\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u4E0D\u4E00\u81F4\u3002{expected} \u304C\u5FC5\u8981\u3067\u3059\u304C\u3001{received} \u3092\u53D7\u4FE1\u3057\u307E\u3057\u305F",
        argumentType: '\u5F15\u6570\u306E\u578B\u306F "{type}" \u3067\u3059',
        argumentTypes: "\u5F15\u6570\u306E\u578B: ({types})",
        assignToNone: '\u578B\u306F "None" \u306B\u5272\u308A\u5F53\u3066\u3067\u304D\u307E\u305B\u3093',
        asyncHelp: '"async with" \u3092\u610F\u5473\u3057\u307E\u3057\u305F\u304B?',
        baseClassIncompatible: '\u57FA\u5E95\u30AF\u30E9\u30B9 "{baseClass}" \u306F\u578B "{type}" \u3068\u4E92\u63DB\u6027\u304C\u3042\u308A\u307E\u305B\u3093',
        baseClassIncompatibleSubclass: '\u57FA\u5E95\u30AF\u30E9\u30B9 "{baseClass}" \u306F\u3001\u578B "{type}" \u3068\u4E92\u63DB\u6027\u306E\u306A\u3044 "{subclass}" \u304B\u3089\u6D3E\u751F\u3057\u3066\u3044\u307E\u3059',
        baseClassOverriddenType: '\u57FA\u5E95\u30AF\u30E9\u30B9 "{baseClass}" \u306F\u3001\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u3055\u308C\u308B\u578B "{type}" \u3092\u63D0\u4F9B\u3057\u307E\u3059',
        baseClassOverridesType: '\u57FA\u5E95\u30AF\u30E9\u30B9 "{baseClass}" \u306F\u578B "{type}" \u3067\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u3057\u307E\u3059',
        bytesTypePromotions: 'disableBytesTypePromotions \u3092 false \u306B\u8A2D\u5B9A\u3057\u3066\u3001"bytearray" \u3068 "memoryview" \u306E\u578B\u6607\u683C\u52D5\u4F5C\u3092\u6709\u52B9\u306B\u3057\u307E\u3059',
        conditionalRequiresBool: '\u578B "{operandType}" \u306E\u30E1\u30BD\u30C3\u30C9 __bool__\u306F\u3001"bool" \u3067\u306F\u306A\u304F\u578B "{boolReturnType}" \u3092\u8FD4\u3057\u307E\u3059',
        dataClassFieldLocation: "\u30D5\u30A3\u30FC\u30EB\u30C9\u5BA3\u8A00",
        dataClassFrozen: '"{name}" \u306F\u56FA\u5B9A\u3055\u308C\u3066\u3044\u307E\u3059',
        dataProtocolUnsupported: '"{name}" \u306F\u30C7\u30FC\u30BF \u30D7\u30ED\u30C8\u30B3\u30EB\u3067\u3059',
        descriptorAccessBindingFailed: '\u8A18\u8FF0\u5B50\u30AF\u30E9\u30B9 "{className}" \u306E\u30E1\u30BD\u30C3\u30C9 "{name}" \u3092\u30D0\u30A4\u30F3\u30C9\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F',
        descriptorAccessCallFailed: '\u8A18\u8FF0\u5B50\u30AF\u30E9\u30B9 "{className}" \u306E\u30E1\u30BD\u30C3\u30C9 "{name}" \u3092\u547C\u3073\u51FA\u305B\u307E\u305B\u3093\u3067\u3057\u305F',
        finalMethod: "Final \u30E1\u30BD\u30C3\u30C9",
        functionParamDefaultMissing: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u306B\u65E2\u5B9A\u306E\u5F15\u6570\u304C\u3042\u308A\u307E\u305B\u3093',
        functionParamName: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u540D\u306E\u4E0D\u4E00\u81F4: "{destName}" \u3068 "{srcName}"',
        functionParamPositionOnly: '\u4F4D\u7F6E\u306E\u307F\u306E\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u4E0D\u4E00\u81F4; \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u306F\u4F4D\u7F6E\u306E\u307F\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        functionReturnTypeMismatch: '\u95A2\u6570\u306E\u623B\u308A\u5024\u306E\u578B "{sourceType}" \u306F\u578B "{destType}" \u3068\u4E92\u63DB\u6027\u304C\u3042\u308A\u307E\u305B\u3093',
        functionTooFewParams: "\u95A2\u6570\u304C\u53D7\u3051\u5165\u308C\u308B\u4F4D\u7F6E\u6307\u5B9A\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u304C\u5C11\u306A\u3059\u304E\u307E\u3059\u3002{expected} \u304C\u5FC5\u8981\u3067\u3059\u304C\u3001{received} \u3092\u53D7\u4FE1\u3057\u307E\u3057\u305F",
        functionTooManyParams: "\u95A2\u6570\u304C\u53D7\u3051\u5165\u308C\u308B\u4F4D\u7F6E\u6307\u5B9A\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u304C\u591A\u3059\u304E\u307E\u3059\u3002{expected} \u304C\u5FC5\u8981\u3067\u3059\u304C\u3001{received} \u3092\u53D7\u4FE1\u3057\u307E\u3057\u305F",
        genericClassNotAllowed: "\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u307E\u305F\u306F\u30AF\u30E9\u30B9\u306E\u30C1\u30A7\u30C3\u30AF\u3067\u306F\u3001\u578B\u5F15\u6570\u3092\u542B\u3080\u30B8\u30A7\u30CD\u30EA\u30C3\u30AF\u578B\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        incompatibleDeleter: "property deleter \u30E1\u30BD\u30C3\u30C9\u306F\u4E92\u63DB\u6027\u304C\u3042\u308A\u307E\u305B\u3093",
        incompatibleGetter: "property getter \u30E1\u30BD\u30C3\u30C9\u306F\u4E92\u63DB\u6027\u304C\u3042\u308A\u307E\u305B\u3093",
        incompatibleSetter: "property setter \u30E1\u30BD\u30C3\u30C9\u306F\u4E92\u63DB\u6027\u304C\u3042\u308A\u307E\u305B\u3093",
        initMethodLocation: '__init__ \u30E1\u30BD\u30C3\u30C9\u306F\u30AF\u30E9\u30B9 "{type}" \u3067\u5B9A\u7FA9\u3055\u308C\u3066\u3044\u307E\u3059',
        initMethodSignature: '__init__\u306E\u7F72\u540D\u306F "{type}" \u3067\u3059',
        initSubclassLocation: '__init_subclass__ \u30E1\u30BD\u30C3\u30C9\u306F\u30AF\u30E9\u30B9 "{name}" \u3067\u5B9A\u7FA9\u3055\u308C\u3066\u3044\u307E\u3059',
        invariantSuggestionDict: '"dict" \u304B\u3089\u5024\u306E\u578B\u306E\u5171\u5909\u3067\u3042\u308B "Mapping" \u3078\u306E\u5207\u308A\u66FF\u3048\u3092\u691C\u8A0E\u3057\u3066\u304F\u3060\u3055\u3044',
        invariantSuggestionList: '"list" \u304B\u3089\u5171\u5909\u3067\u3042\u308B "Sequence" \u3078\u306E\u5207\u308A\u66FF\u3048\u3092\u691C\u8A0E\u3057\u3066\u304F\u3060\u3055\u3044',
        invariantSuggestionSet: '"set" \u304B\u3089\u5171\u5909\u3067\u3042\u308B "Container" \u3078\u306E\u5207\u308A\u66FF\u3048\u3092\u691C\u8A0E\u3057\u3066\u304F\u3060\u3055\u3044',
        isinstanceClassNotSupported: '\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u3068\u30AF\u30E9\u30B9\u306E\u30C1\u30A7\u30C3\u30AF\u3067\u306F\u3001"{type}" \u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        keyNotRequired: '"{name}" \u306F "{type}" \u306E\u5FC5\u9808\u30AD\u30FC\u3067\u306F\u306A\u3044\u305F\u3081\u3001\u30A2\u30AF\u30BB\u30B9\u3059\u308B\u3068\u5B9F\u884C\u6642\u4F8B\u5916\u304C\u767A\u751F\u3059\u308B\u53EF\u80FD\u6027\u304C\u3042\u308A\u307E\u3059',
        keyReadOnly: '"{name}" \u306F "{type}" \u306E\u8AAD\u307F\u53D6\u308A\u5C02\u7528\u30AD\u30FC\u3067\u3059',
        keyRequiredDeleted: '"{name}" \u306F\u5FC5\u9808\u30AD\u30FC\u3067\u3042\u308A\u3001\u524A\u9664\u3067\u304D\u307E\u305B\u3093',
        keyUndefined: '"{name}" \u306F "{type}" \u3067\u5B9A\u7FA9\u3055\u308C\u305F\u30AD\u30FC\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        kwargsParamMissing: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "**{paramName}" \u306B\u5BFE\u5FDC\u3059\u308B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u304C\u3042\u308A\u307E\u305B\u3093',
        listAssignmentMismatch: '\u578B "{type}" \u306F\u30BF\u30FC\u30B2\u30C3\u30C8 \u30EA\u30B9\u30C8\u3068\u4E92\u63DB\u6027\u304C\u3042\u308A\u307E\u305B\u3093',
        literalAssignmentMismatch: '"{sourceType}" \u306F\u578B "{destType}" \u306B\u5272\u308A\u5F53\u3066\u3067\u304D\u307E\u305B\u3093',
        literalNotAllowed: '"Literal" \u7279\u6B8A\u30D5\u30A9\u30FC\u30E0\u306F\u3001\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u304A\u3088\u3073\u30AF\u30E9\u30B9\u306E\u30C1\u30A7\u30C3\u30AF\u3068\u3068\u3082\u306B\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        matchIsNotExhaustiveHint: '\u5B8C\u5168\u306A\u51E6\u7406\u304C\u610F\u56F3\u3055\u308C\u3066\u3044\u306A\u3044\u5834\u5408\u306F\u3001"case _: pass" \u3092\u8FFD\u52A0\u3057\u307E\u3059',
        matchIsNotExhaustiveType: '\u30CF\u30F3\u30C9\u30EB\u3055\u308C\u306A\u3044\u578B: "{type}"',
        memberAssignment: '\u578B "{type}" \u306E\u5F0F\u3092\u30AF\u30E9\u30B9 "{classType}" \u306E\u5C5E\u6027 "{name}" \u306B\u5272\u308A\u5F53\u3066\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        memberIsAbstract: '"{type}.{name}" \u306F\u5B9F\u88C5\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        memberIsAbstractMore: "\u305D\u306E\u4ED6 {count} \u4EF6...",
        memberIsClassVarInProtocol: '"{name}" \u306F\u30D7\u30ED\u30C8\u30B3\u30EB\u3067 ClassVar \u3068\u3057\u3066\u5B9A\u7FA9\u3055\u308C\u3066\u3044\u307E\u3059',
        memberIsInitVar: '"{name}" \u306F init-only \u30D5\u30A3\u30FC\u30EB\u30C9\u3067\u3059',
        memberIsInvariant: '"{name}" \u306F\u5909\u66F4\u53EF\u80FD\u3067\u3042\u308B\u305F\u3081\u3001\u4E0D\u5909\u3067\u3059',
        memberIsNotClassVarInClass: '\u30D7\u30ED\u30C8\u30B3\u30EB\u3068\u4E92\u63DB\u6027\u3092\u6301\u305F\u305B\u308B\u306B\u306F\u3001"{name}" \u3092 ClassVar \u3068\u3057\u3066\u5B9A\u7FA9\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059',
        memberIsNotClassVarInProtocol: '"{name}" \u306F\u30D7\u30ED\u30C8\u30B3\u30EB\u3067 ClassVar \u3068\u3057\u3066\u5B9A\u7FA9\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        memberIsNotReadOnlyInProtocol: '"{name}" \u306F\u30D7\u30ED\u30C8\u30B3\u30EB\u3067\u8AAD\u307F\u53D6\u308A\u5C02\u7528\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        memberIsReadOnlyInProtocol: '"{name}" \u306F\u30D7\u30ED\u30C8\u30B3\u30EB\u3067\u8AAD\u307F\u53D6\u308A\u5C02\u7528\u3067\u3059',
        memberIsWritableInProtocol: '"{name}" \u306F\u30D7\u30ED\u30C8\u30B3\u30EB\u3067\u66F8\u304D\u8FBC\u307F\u53EF\u80FD\u3067\u3059',
        memberSetClassVar: '\u5C5E\u6027 "{name}" \u306F ClassVar \u3067\u3042\u308B\u305F\u3081\u3001\u30AF\u30E9\u30B9 \u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u3092\u4ECB\u3057\u3066\u5272\u308A\u5F53\u3066\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        memberTypeMismatch: '"{name}" \u306F\u4E92\u63DB\u6027\u306E\u306A\u3044\u578B\u3067\u3059',
        memberUnknown: '\u5C5E\u6027 "{name}" \u304C\u4E0D\u660E\u3067\u3059',
        metaclassConflict: '\u30E1\u30BF\u30AF\u30E9\u30B9 "{metaclass1}" \u304C "{metaclass2}" \u3068\u7AF6\u5408\u3057\u3066\u3044\u307E\u3059',
        missingDeleter: "property deleter \u30E1\u30BD\u30C3\u30C9\u304C\u3042\u308A\u307E\u305B\u3093",
        missingGetter: "property getter \u30E1\u30BD\u30C3\u30C9\u304C\u3042\u308A\u307E\u305B\u3093",
        missingSetter: "property setter \u30E1\u30BD\u30C3\u30C9\u304C\u3042\u308A\u307E\u305B\u3093",
        namedParamMissingInDest: '\u4F59\u5206\u306A\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}"',
        namedParamMissingInSource: '\u30AD\u30FC\u30EF\u30FC\u30C9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093',
        namedParamTypeMismatch: '\u578B "{sourceType}" \u306E\u30AD\u30FC\u30EF\u30FC\u30C9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u306F\u578B "{destType}" \u3068\u4E92\u63DB\u6027\u304C\u3042\u308A\u307E\u305B\u3093',
        namedTupleNotAllowed: "NamedTuple \u306F\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u307E\u305F\u306F\u30AF\u30E9\u30B9\u306E\u30C1\u30A7\u30C3\u30AF\u306B\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        newMethodLocation: '__new__ \u30E1\u30BD\u30C3\u30C9\u306F\u30AF\u30E9\u30B9 "{type}" \u3067\u5B9A\u7FA9\u3055\u308C\u3066\u3044\u307E\u3059',
        newMethodSignature: '__new__\u306E\u7F72\u540D\u306F "{type}" \u3067\u3059',
        newTypeClassNotAllowed: "Type created with NewType cannot be used with instance and class checks",
        noOverloadAssignable: '\u578B "{type}" \u306B\u4E00\u81F4\u3059\u308B\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9\u3055\u308C\u305F\u95A2\u6570\u306F\u3042\u308A\u307E\u305B\u3093',
        noneNotAllowed: "\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u307E\u305F\u306F\u30AF\u30E9\u30B9\u306E\u30C1\u30A7\u30C3\u30AF\u306B\u306F None \u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        orPatternMissingName: "\u540D\u524D\u304C\u3042\u308A\u307E\u305B\u3093: {name}",
        overloadIndex: "\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9 {index} \u304C\u6700\u3082\u8FD1\u3044\u4E00\u81F4\u3067\u3059",
        overloadNotAssignable: '"{name}" \u306E 1 \u3064\u4EE5\u4E0A\u306E\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9\u304C\u5272\u308A\u5F53\u3066\u53EF\u80FD\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        overloadSignature: "\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9\u30B7\u30B0\u30CD\u30C1\u30E3\u306F\u3053\u3053\u3067\u5B9A\u7FA9\u3055\u308C\u3066\u3044\u307E\u3059",
        overriddenMethod: "\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u3055\u308C\u305F\u30E1\u30BD\u30C3\u30C9",
        overriddenSymbol: "\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u3055\u308C\u305F\u30B7\u30F3\u30DC\u30EB",
        overrideInvariantMismatch: '\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u306E\u578B "{overrideType}" \u304C\u57FA\u672C\u30C7\u30FC\u30BF\u578B "{baseType}" \u3068\u540C\u3058\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        overrideIsInvariant: "\u5909\u6570\u306F\u5909\u66F4\u53EF\u80FD\u3067\u3042\u308B\u305F\u3081\u3001\u305D\u306E\u578B\u306F\u4E0D\u5909\u3067\u3059",
        overrideNoOverloadMatches: "\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u306E\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9 \u30B7\u30B0\u30CD\u30C1\u30E3\u304C\u57FA\u672C\u30E1\u30BD\u30C3\u30C9\u3068\u4E92\u63DB\u6027\u304C\u3042\u308A\u307E\u305B\u3093",
        overrideNotClassMethod: "\u57FA\u672C\u30E1\u30BD\u30C3\u30C9\u306F classmethod \u3068\u3057\u3066\u5BA3\u8A00\u3055\u308C\u3066\u3044\u307E\u3059\u304C\u3001\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u306F\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        overrideNotInstanceMethod: "\u57FA\u672C\u30E1\u30BD\u30C3\u30C9\u306F\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9 \u30E1\u30BD\u30C3\u30C9\u3068\u3057\u3066\u5BA3\u8A00\u3055\u308C\u3066\u3044\u307E\u3059\u304C\u3001\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u306F\u5BA3\u8A00\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        overrideNotStaticMethod: "\u57FA\u672C\u30E1\u30BD\u30C3\u30C9\u306F staticmethod \u3068\u3057\u3066\u5BA3\u8A00\u3055\u308C\u3066\u3044\u307E\u3059\u304C\u3001\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u306F\u5BA3\u8A00\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        overrideOverloadNoMatch: "\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u306F\u57FA\u672C\u30E1\u30BD\u30C3\u30C9\u306E\u3059\u3079\u3066\u306E\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9\u3092\u51E6\u7406\u3057\u307E\u305B\u3093",
        overrideOverloadOrder: "\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9 \u30E1\u30BD\u30C3\u30C9\u306E\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9\u306F\u3001\u57FA\u672C\u30E1\u30BD\u30C3\u30C9\u3068\u540C\u3058\u9806\u5E8F\u306B\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        overrideParamKeywordNoDefault: '\u30AD\u30FC\u30EF\u30FC\u30C9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u306E\u4E0D\u4E00\u81F4: \u57FA\u672C\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306B\u65E2\u5B9A\u306E\u5F15\u6570\u5024\u304C\u3042\u308A\u3001\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306B\u306F\u3042\u308A\u307E\u305B\u3093',
        overrideParamKeywordType: '\u30AD\u30FC\u30EF\u30FC\u30C9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u306E\u578B\u304C\u4E00\u81F4\u3057\u307E\u305B\u3093: \u57FA\u672C\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306F\u578B "{baseType}"\u3001\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306F\u578B "{overrideType}" \u3067\u3059',
        overrideParamName: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC {index} \u540D\u304C\u4E00\u81F4\u3057\u307E\u305B\u3093: \u30D9\u30FC\u30B9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u540D\u524D\u306F "{baseName}"\u3001\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306F "{overrideName}" \u3067\u3059',
        overrideParamNameExtra: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u304C \u30D9\u30FC\u30B9 \u306B\u898B\u3064\u304B\u308A\u307E\u305B\u3093',
        overrideParamNameMissing: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u304C\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u306B\u898B\u3064\u304B\u308A\u307E\u305B\u3093',
        overrideParamNamePositionOnly: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC {index} \u306E\u4E0D\u4E00\u81F4: \u30D9\u30FC\u30B9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{baseName}" \u306F\u30AD\u30FC\u30EF\u30FC\u30C9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u3067\u3001\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306F\u4F4D\u7F6E\u306E\u307F\u3067\u3059',
        overrideParamNoDefault: "\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC {index} \u306E\u4E0D\u4E00\u81F4: \u57FA\u672C\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306B\u65E2\u5B9A\u306E\u5F15\u6570\u5024\u304C\u3042\u308A\u3001\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u304C\u6307\u5B9A\u3055\u308C\u3066\u3044\u307E\u305B\u3093",
        overrideParamType: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC {index} \u306E\u578B\u304C\u4E00\u81F4\u3057\u307E\u305B\u3093: \u57FA\u672C\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306F\u578B "{baseType}"\u3001\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9 \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306F\u578B "{overrideType}" \u3067\u3059',
        overridePositionalParamCount: "\u4F4D\u7F6E\u6307\u5B9A\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u6570\u304C\u4E00\u81F4\u3057\u307E\u305B\u3093\u3002\u57FA\u672C\u30E1\u30BD\u30C3\u30C9\u306B\u306F {baseCount} \u304C\u3042\u308A\u307E\u3059\u304C\u3001\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u306B\u306F {overrideCount} \u304C\u3042\u308A\u307E\u3059",
        overrideReturnType: '\u623B\u308A\u5024\u306E\u578B\u306E\u4E0D\u4E00\u81F4: \u57FA\u672C\u30E1\u30BD\u30C3\u30C9\u306F\u578B "{baseType}" \u3092\u8FD4\u3057\u3001\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u306F\u578B "{overrideType}" \u3092\u8FD4\u3057\u307E\u3059',
        overrideType: '\u57FA\u5E95\u30AF\u30E9\u30B9\u306F\u578B\u3092 "{type}" \u3068\u3057\u3066\u5B9A\u7FA9\u3057\u307E\u3059',
        paramAssignment: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC {index}: \u578B "{sourceType}" \u306F\u578B "{destType}" \u3068\u4E92\u63DB\u6027\u304C\u3042\u308A\u307E\u305B\u3093',
        paramSpecMissingInOverride: "ParamSpec \u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u304C override \u30E1\u30BD\u30C3\u30C9\u306B\u898B\u3064\u304B\u308A\u307E\u305B\u3093",
        paramType: '\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u306E\u578B\u306F "{paramType}" \u3067\u3059',
        privateImportFromPyTypedSource: '\u4EE3\u308F\u308A\u306B "{module}" \u304B\u3089\u30A4\u30F3\u30DD\u30FC\u30C8\u3059\u308B',
        propertyAccessFromProtocolClass: "\u30D7\u30ED\u30C8\u30B3\u30EB \u30AF\u30E9\u30B9\u5185\u3067\u5B9A\u7FA9\u3055\u308C\u305F\u30D7\u30ED\u30D1\u30C6\u30A3\u306B\u30AF\u30E9\u30B9\u5909\u6570\u3068\u3057\u3066\u30A2\u30AF\u30BB\u30B9\u3067\u304D\u306A\u3044",
        propertyMethodIncompatible: 'property \u30E1\u30BD\u30C3\u30C9 "{name}" \u306F\u4E92\u63DB\u6027\u304C\u3042\u308A\u307E\u305B\u3093',
        propertyMethodMissing: 'property \u30E1\u30BD\u30C3\u30C9 "{name}" \u304C\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u306B\u3042\u308A\u307E\u305B\u3093',
        propertyMissingDeleter: 'property "{name}" \u306B\u5B9A\u7FA9\u3055\u308C\u305F deleter \u304C\u3042\u308A\u307E\u305B\u3093',
        propertyMissingSetter: 'property "{name}" \u306B\u5B9A\u7FA9\u3055\u308C\u305F setter \u304C\u3042\u308A\u307E\u305B\u3093',
        protocolIncompatible: '"{sourceType}" \u306F\u30D7\u30ED\u30C8\u30B3\u30EB "{destType}" \u3068\u4E92\u63DB\u6027\u304C\u3042\u308A\u307E\u305B\u3093',
        protocolMemberMissing: '"{name}" \u304C\u5B58\u5728\u3057\u307E\u305B\u3093',
        protocolRequiresRuntimeCheckable: "\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u3068\u30AF\u30E9\u30B9\u306E\u30C1\u30A7\u30C3\u30AF\u3067\u4F7F\u7528\u3059\u308B\u306B\u306F\u3001Protocol \u30AF\u30E9\u30B9\u304C @runtime_checkable \u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059",
        protocolSourceIsNotConcrete: '"{sourceType}" \u306F\u5177\u8C61\u30AF\u30E9\u30B9\u578B\u3067\u306F\u306A\u3044\u305F\u3081\u3001\u578B "{destType}" \u306B\u5272\u308A\u5F53\u3066\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093',
        protocolUnsafeOverlap: '"{name}" \u306E\u5C5E\u6027\u306E\u540D\u524D\u304C\u30D7\u30ED\u30C8\u30B3\u30EB\u306E\u540D\u524D\u3068\u540C\u3058\u3067\u3059',
        pyrightCommentIgnoreTip: '"# pyright: ignore[<diagnostic rules>] \u3092\u4F7F\u7528\u3057\u3066 1 \u884C\u306E\u8A3A\u65AD\u3092\u6291\u5236\u3057\u307E\u3059',
        readOnlyAttribute: '\u5C5E\u6027 "{name}" \u306F\u8AAD\u307F\u53D6\u308A\u5C02\u7528\u3067\u3059',
        seeClassDeclaration: "\u30AF\u30E9\u30B9\u5BA3\u8A00\u3092\u53C2\u7167\u3057\u3066\u304F\u3060\u3055\u3044",
        seeDeclaration: "\u5BA3\u8A00\u3092\u53C2\u7167\u3057\u3066\u304F\u3060\u3055\u3044",
        seeFunctionDeclaration: "\u95A2\u6570\u306E\u5BA3\u8A00\u3092\u53C2\u7167\u3057\u3066\u304F\u3060\u3055\u3044",
        seeMethodDeclaration: "\u30E1\u30BD\u30C3\u30C9\u5BA3\u8A00\u3092\u53C2\u7167\u3057\u3066\u304F\u3060\u3055\u3044",
        seeParameterDeclaration: "\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC\u5BA3\u8A00\u3092\u53C2\u7167\u3057\u3066\u304F\u3060\u3055\u3044",
        seeTypeAliasDeclaration: "\u578B\u306E\u30A8\u30A4\u30EA\u30A2\u30B9\u5BA3\u8A00\u3092\u53C2\u7167\u3057\u3066\u304F\u3060\u3055\u3044",
        seeVariableDeclaration: "\u5909\u6570\u5BA3\u8A00\u3092\u53C2\u7167\u3057\u3066\u304F\u3060\u3055\u3044",
        tupleAssignmentMismatch: '\u578B "{type}" \u306F\u30BF\u30FC\u30B2\u30C3\u30C8 tuple \u3068\u4E92\u63DB\u6027\u304C\u3042\u308A\u307E\u305B\u3093',
        tupleEntryTypeMismatch: "tuple \u30A8\u30F3\u30C8\u30EA {entry} \u306E\u578B\u304C\u6B63\u3057\u304F\u3042\u308A\u307E\u305B\u3093",
        tupleSizeIndeterminateSrc: "Tuple \u306E\u30B5\u30A4\u30BA\u304C\u4E00\u81F4\u3057\u307E\u305B\u3093\u3002{expected} \u304C\u5FC5\u8981\u3067\u3059\u304C\u3001\u53D7\u3051\u53D6\u308A\u306F\u4E0D\u78BA\u5B9A\u3067\u3059",
        tupleSizeIndeterminateSrcDest: "Tuple \u306E\u30B5\u30A4\u30BA\u304C\u4E00\u81F4\u3057\u307E\u305B\u3093\u3002{expected} \u4EE5\u4E0A\u304C\u5FC5\u8981\u3067\u3059\u304C\u3001\u53D7\u3051\u53D6\u308A\u306F\u4E0D\u78BA\u5B9A\u3067\u3059",
        tupleSizeMismatch: "tuple \u306E\u30B5\u30A4\u30BA\u304C\u4E00\u81F4\u3057\u307E\u305B\u3093\u3002{expected} \u304C\u5FC5\u8981\u3067\u3059\u304C\u3001{received} \u3092\u53D7\u4FE1\u3057\u307E\u3057\u305F",
        tupleSizeMismatchIndeterminateDest: "Tuple \u306E\u30B5\u30A4\u30BA\u304C\u4E00\u81F4\u3057\u307E\u305B\u3093\u3002{expected} \u4EE5\u4E0A\u304C\u5FC5\u8981\u3067\u3059\u304C\u3001{received} \u3092\u53D7\u4FE1\u3057\u307E\u3057\u305F",
        typeAliasInstanceCheck: '"type" \u30B9\u30C6\u30FC\u30C8\u30E1\u30F3\u30C8\u3067\u4F5C\u6210\u3055\u308C\u305F\u578B\u30A8\u30A4\u30EA\u30A2\u30B9\u306F\u3001\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u3068\u30AF\u30E9\u30B9\u306E\u30C1\u30A7\u30C3\u30AF\u3067\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093',
        typeAssignmentMismatch: '\u578B "{sourceType}" \u306F\u578B "{destType}" \u306B\u5272\u308A\u5F53\u3066\u3067\u304D\u307E\u305B\u3093',
        typeBound: '\u578B "{sourceType}" \u306F\u3001\u578B\u5909\u6570 "{name}" \u306E\u4E0A\u9650 "{destType}" \u306B\u5272\u308A\u5F53\u3066\u3067\u304D\u307E\u305B\u3093',
        typeConstrainedTypeVar: '\u578B "{type}" \u306F\u5236\u7D04\u4ED8\u304D\u578B\u5909\u6570 "{name}" \u306B\u5272\u308A\u5F53\u3066\u3067\u304D\u307E\u305B\u3093',
        typeIncompatible: '"{sourceType}" \u306F "{destType}" \u306B\u5272\u308A\u5F53\u3066\u3067\u304D\u307E\u305B\u3093',
        typeNotClass: '"{type}" \u306F\u30AF\u30E9\u30B9\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        typeNotStringLiteral: '"{type}" \u306F\u6587\u5B57\u5217\u30EA\u30C6\u30E9\u30EB\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        typeOfSymbol: '"{name}" \u306E\u578B\u306F "{type}" \u3067\u3059',
        typeParamSpec: '\u578B "{type}" \u306F ParamSpec "{name}" \u3068\u4E92\u63DB\u6027\u304C\u3042\u308A\u307E\u305B\u3093',
        typeUnsupported: '\u578B "{type}" \u306F\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        typeVarDefaultOutOfScope: '\u578B\u5909\u6570 "{name}" \u306F\u30B9\u30B3\u30FC\u30D7\u5185\u306B\u3042\u308A\u307E\u305B\u3093',
        typeVarIsContravariant: '\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u306F\u53CD\u5909\u3067\u3059\u304C\u3001"{sourceType}" \u306F "{destType}" \u306E\u30B9\u30FC\u30D1\u30FC\u30BF\u30A4\u30D7\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        typeVarIsCovariant: '\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u306F\u5171\u5909\u3067\u3059\u304C\u3001"{sourceType}" \u306F "{destType}" \u306E\u30B5\u30D6\u30BF\u30A4\u30D7\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        typeVarIsInvariant: '\u578B\u30D1\u30E9\u30E1\u30FC\u30BF\u30FC "{name}" \u306F\u4E0D\u5909\u3067\u3059\u304C\u3001"{sourceType}" \u306F "{destType}" \u3068\u540C\u3058\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        typeVarNotAllowed: "TypeVar \u306F\u3001\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u307E\u305F\u306F\u30AF\u30E9\u30B9\u306E\u30C1\u30A7\u30C3\u30AF\u306B\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        typeVarTupleRequiresKnownLength: "TypeVarTuple \u3092\u4E0D\u660E\u306A\u9577\u3055\u306E tuple \u306B\u30D0\u30A4\u30F3\u30C9\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093",
        typeVarUnnecessarySuggestion: "\u4EE3\u308F\u308A\u306B {type} \u3092\u4F7F\u7528\u3057\u3066\u304F\u3060\u3055\u3044",
        typeVarUnsolvableRemedy: "\u5F15\u6570\u304C\u6307\u5B9A\u3055\u308C\u3066\u3044\u306A\u3044\u5834\u5408\u306B\u623B\u308A\u5024\u306E\u578B\u3092\u6307\u5B9A\u3059\u308B\u30AA\u30FC\u30D0\u30FC\u30ED\u30FC\u30C9\u3092\u6307\u5B9A\u3057\u307E\u3059",
        typeVarsMissing: "\u578B\u5909\u6570\u304C\u3042\u308A\u307E\u305B\u3093: {names}",
        typedDictBaseClass: '\u30AF\u30E9\u30B9 "{type}" \u306F TypedDict \u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        typedDictClassNotAllowed: "TypedDict \u30AF\u30E9\u30B9\u306F\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u307E\u305F\u306F\u30AF\u30E9\u30B9\u306E\u30C1\u30A7\u30C3\u30AF\u306B\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        typedDictClosedExtraNotAllowed: '\u30A2\u30A4\u30C6\u30E0 "{name}" \u3092\u8FFD\u52A0\u3067\u304D\u307E\u305B\u3093',
        typedDictClosedExtraTypeMismatch: '\u578B "{type}" \u306E\u30A2\u30A4\u30C6\u30E0 "{name}" \u3092\u8FFD\u52A0\u3067\u304D\u307E\u305B\u3093',
        typedDictClosedFieldNotReadOnly: 'Cannot add item "{name}" because it must be ReadOnly',
        typedDictClosedFieldNotRequired: '\u30A2\u30A4\u30C6\u30E0 "{name}" \u3092\u8FFD\u52A0\u3067\u304D\u307E\u305B\u3093\u3002\u3053\u308C\u306F NotRequired \u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308B\u305F\u3081\u3067\u3059\u3002',
        typedDictExtraFieldNotAllowed: '"{name}" \u306F "{type}" \u306B\u5B58\u5728\u3057\u307E\u305B\u3093',
        typedDictExtraFieldTypeMismatch: '"{name}" \u306E\u578B\u306F\u3001"{type}" \u306E "extra_items" \u578B\u3068\u4E92\u63DB\u6027\u304C\u3042\u308A\u307E\u305B\u3093',
        typedDictFieldMissing: '"{name}" \u304C "{type}" \u306B\u898B\u3064\u304B\u308A\u307E\u305B\u3093',
        typedDictFieldNotReadOnly: '"{name}" \u306F "{type}" \u3067\u306F\u8AAD\u307F\u53D6\u308A\u5C02\u7528\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        typedDictFieldNotRequired: '"{name}" \u306F "{type}" \u306B\u306F\u5FC5\u8981\u3042\u308A\u307E\u305B\u3093',
        typedDictFieldRequired: '"{name}" \u306F "{type}" \u306B\u5FC5\u8981\u3067\u3059',
        typedDictFieldTypeMismatch: '\u578B "{type}" \u306F\u3001\u30A2\u30A4\u30C6\u30E0 "{name}" \u306B\u5272\u308A\u5F53\u3066\u3067\u304D\u307E\u305B\u3093',
        typedDictFieldUndefined: '"{name}" \u306F\u578B "{type}" \u306E\u672A\u5B9A\u7FA9\u306E\u30A2\u30A4\u30C6\u30E0\u3067\u3059',
        typedDictKeyAccess: '["{name}"] \u3092\u4F7F\u7528\u3057\u3066 TypedDict \u306E\u9805\u76EE\u3092\u53C2\u7167\u3059\u308B',
        typedDictNotAllowed: "TypedDict \u306F\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u307E\u305F\u306F\u30AF\u30E9\u30B9\u306E\u30C1\u30A7\u30C3\u30AF\u306B\u306F\u4F7F\u7528\u3067\u304D\u307E\u305B\u3093",
        unhashableType: '\u578B "{type}" \u306F\u30CF\u30C3\u30B7\u30E5\u53EF\u80FD\u3067\u306F\u3042\u308A\u307E\u305B\u3093',
        uninitializedAbstractVariable: '\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u5909\u6570 "{name}" \u306F\u62BD\u8C61\u57FA\u672C\u30AF\u30E9\u30B9 "{classType}" \u3067\u5B9A\u7FA9\u3055\u308C\u3066\u3044\u307E\u3059\u304C\u3001\u521D\u671F\u5316\u3055\u308C\u3066\u3044\u307E\u305B\u3093',
        unreachableExcept: '"{exceptionType}" \u306F "{parentType}" \u306E\u30B5\u30D6\u30AF\u30E9\u30B9\u3067\u3059',
        useDictInstead: "\u8F9E\u66F8\u306E\u7A2E\u985E\u3092\u793A\u3059\u306B\u306F\u3001dict[T1, T2] \u3092\u4F7F\u7528\u3057\u307E\u3059",
        useListInstead: "list[T] \u3092\u4F7F\u7528\u3057\u3066 list \u578B\u3092\u793A\u3059\u304B\u3001T1 | T2 \u3092\u4F7F\u7528\u3057\u3066 union \u578B\u3092\u793A\u3057\u307E\u3059",
        useTupleInstead: "tuple[T1, ..., Tn] \u3092\u4F7F\u7528\u3057\u3066 tuple \u578B\u3092\u793A\u3059\u304B\u3001T1 | T2 \u3092\u4F7F\u7528\u3057\u3066 union \u578B\u3092\u793A\u3057\u307E\u3059",
        useTypeInstead: "\u4EE3\u308F\u308A\u306B type[T] \u3092\u4F7F\u7528\u3059\u308B",
        varianceMismatchForClass: '\u578B\u5F15\u6570 "{typeVarName}" \u306E\u5206\u6563\u306F\u3001\u57FA\u5E95\u30AF\u30E9\u30B9 "{className}" \u3068\u4E92\u63DB\u6027\u304C\u3042\u308A\u307E\u305B\u3093',
        varianceMismatchForTypeAlias: '\u578B\u5F15\u6570 "{typeVarName}" \u306E\u5206\u6563\u306F "{typeAliasParam}" \u3068\u4E92\u63DB\u6027\u304C\u3042\u308A\u307E\u305B\u3093'
      },
      Service: {
        longOperation: "\u30EF\u30FC\u30AF\u30B9\u30DA\u30FC\u30B9 \u30BD\u30FC\u30B9 \u30D5\u30A1\u30A4\u30EB\u306E\u5217\u6319\u306B\u6642\u9593\u304C\u304B\u304B\u3063\u3066\u3044\u307E\u3059\u3002\u4EE3\u308F\u308A\u306B\u30B5\u30D6\u30D5\u30A9\u30EB\u30C0\u30FC\u3092\u958B\u304F\u65B9\u6CD5\u3092\u691C\u8A0E\u3057\u3066\u304F\u3060\u3055\u3044\u3002[\u8A73\u7D30\u60C5\u5831](https://aka.ms/workspace-too-many-files)"
      }
    };
  }
});

// node_modules/@zzzen/pyright-internal/dist/localization/package.nls.ko.json
var require_package_nls_ko = __commonJS({
  "node_modules/@zzzen/pyright-internal/dist/localization/package.nls.ko.json"(exports2, module2) {
    module2.exports = {
      CodeAction: {
        createTypeStub: "\uD615\uC2DD Stub \uB9CC\uB4E4\uAE30",
        createTypeStubFor: '"{moduleName}"\uC5D0 \uB300\uD55C \uD615\uC2DD Stub \uB9CC\uB4E4\uAE30',
        executingCommand: "\uBA85\uB839 \uC2E4\uD589",
        filesToAnalyzeCount: "\uBD84\uC11D\uD560 \uD30C\uC77C {count}\uAC1C",
        filesToAnalyzeOne: "\uBD84\uC11D\uD560 \uD30C\uC77C 1\uAC1C",
        findingReferences: "\uCC38\uC870 \uCC3E\uAE30",
        organizeImports: "\uAC00\uC838\uC624\uAE30 \uAD6C\uC131"
      },
      Completion: {
        autoImportDetail: "\uC790\uB3D9 \uAC00\uC838\uC624\uAE30",
        indexValueDetail: "\uC778\uB371\uC2A4 \uAC12"
      },
      Diagnostic: {
        abstractMethodInvocation: '\uBA54\uC11C\uB4DC "{method}"\uC740(\uB294) \uCD94\uC0C1\uC801\uC774\uACE0 \uAD6C\uD604\uB418\uC9C0 \uC54A\uC558\uC73C\uBBC0\uB85C \uD638\uCD9C\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        annotatedMetadataInconsistent: '\uC8FC\uC11D\uC774 \uCD94\uAC00\uB41C "{metadataType}" \uBA54\uD0C0\uB370\uC774\uD130 \uD615\uC2DD\uC774 "{type}" \uD615\uC2DD\uACFC \uD638\uD658\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        annotatedParamCountMismatch: "\uB9E4\uAC1C \uBCC0\uC218 \uC8FC\uC11D \uAC1C\uC218\uAC00 \uC77C\uCE58\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4. {expected}\uC774)(\uAC00) \uD544\uC694\uD558\uC9C0\uB9CC {received}\uC744(\uB97C) \uBC1B\uC558\uC2B5\uB2C8\uB2E4.",
        annotatedTypeArgMissing: '"Annotated"\uC5D0 \uB300\uD574 \uD558\uB098\uC758 \uD615\uC2DD \uC778\uC218\uC640 \uD558\uB098 \uC774\uC0C1\uC758 \uC8FC\uC11D\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.',
        annotationBytesString: "\uD615\uC2DD \uC2DD\uC740 \uBC14\uC774\uD2B8 \uBB38\uC790\uC5F4 \uB9AC\uD130\uB7F4\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        annotationFormatString: "\uD615\uC2DD \uC2DD\uC740 \uD615\uC2DD \uBB38\uC790\uC5F4 \uB9AC\uD130\uB7F4(f \uBB38\uC790\uC5F4)\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        annotationNotSupported: "\uC774 \uBB38\uC5D0\uB294 \uD615\uC2DD \uC8FC\uC11D\uC774 \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        annotationRawString: "\uD615\uC2DD \uC2DD\uC740 \uC6D0\uC2DC \uBB38\uC790\uC5F4 \uB9AC\uD130\uB7F4\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        annotationSpansStrings: "\uD615\uC2DD \uC2DD\uC740 \uC5EC\uB7EC \uBB38\uC790\uC5F4 \uB9AC\uD130\uB7F4\uC5D0 \uAC78\uCCD0 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        annotationStringEscape: "\uD615\uC2DD \uC2DD\uC5D0\uB294 \uC774\uC2A4\uCF00\uC774\uD504 \uBB38\uC790\uB97C \uD3EC\uD568\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        annotationTemplateString: "Type expressions cannot use template string literals (t-strings)",
        argAssignment: '"{argType}" \uD615\uC2DD\uC758 \uC778\uC218\uB97C "{paramType}" \uD615\uC2DD\uC758 \uB9E4\uAC1C \uBCC0\uC218\uC5D0 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        argAssignmentFunction: '"{argType}" \uD615\uC2DD\uC758 \uC778\uC218\uB97C "{functionName}" \uD568\uC218\uC758 "{paramType}" \uD615\uC2DD\uC758 \uB9E4\uAC1C \uBCC0\uC218\uC5D0 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        argAssignmentParam: '"{argType}" \uD615\uC2DD\uC758 \uC778\uC218\uB97C "{paramType}" \uD615\uC2DD\uC758 "{paramName}" \uB9E4\uAC1C \uBCC0\uC218\uC5D0 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        argAssignmentParamFunction: '"{argType}" \uD615\uC2DD\uC758 \uC778\uC218\uB97C "{functionName}" \uD568\uC218\uC5D0\uC11C "{paramType}" \uD615\uC2DD\uC758 "{paramName}" \uB9E4\uAC1C \uBCC0\uC218\uC5D0 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        argMissingForParam: "\uB9E4\uAC1C \uBCC0\uC218 {name}\uC5D0 \uB300\uD55C \uC778\uC218\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.",
        argMissingForParams: "\uB9E4\uAC1C \uBCC0\uC218 {names}\uC5D0 \uB300\uD55C \uC778\uC218\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.",
        argMorePositionalExpectedCount: "{expected}\uAC1C \uC774\uC0C1\uC758 \uC704\uCE58 \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        argMorePositionalExpectedOne: "1\uAC1C\uC758 \uC704\uCE58 \uC778\uC218\uAC00 \uB354 \uD544\uC694\uD569\uB2C8\uB2E4.",
        argPositional: "\uC704\uCE58 \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        argPositionalExpectedCount: "{expected} \uC704\uCE58 \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        argPositionalExpectedOne: "1\uAC1C\uC758 \uC704\uCE58 \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        argTypePartiallyUnknown: "\uC778\uC218 \uD615\uC2DD\uC744 \uBD80\uBD84\uC801\uC73C\uB85C \uC54C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        argTypeUnknown: "\uC778\uC218 \uD615\uC2DD\uC744 \uC54C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        assertAlwaysTrue: "\uC5B4\uC124\uC158 \uC2DD\uC740 \uD56D\uC0C1 true\uB85C \uD3C9\uAC00\uB429\uB2C8\uB2E4.",
        assertTypeArgs: '"assert_type"\uC5D0\uB294 \uB450 \uAC1C\uC758 \uC704\uCE58 \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.',
        assertTypeTypeMismatch: '"assert_type" \uBD88\uC77C\uCE58: "{expected}"\uC774(\uAC00) \uD544\uC694\uD558\uC9C0\uB9CC "{received}"\uC744(\uB97C) \uBC1B\uC558\uC2B5\uB2C8\uB2E4.',
        assignmentExprComprehension: "\u2018{name}\u2019 \uD560\uB2F9 \uC2DD \uB300\uC0C1\uC740 \uB300\uC0C1\uC5D0 \uB300\uD55C \uC774\uD574\uB825\uACFC \uAC19\uC740 \uC774\uB984\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        assignmentExprContext: "\uD560\uB2F9 \uC2DD\uC740 \uBAA8\uB4C8, \uD568\uC218 \uB610\uB294 \uB78C\uB2E4 \uB0B4\uC5D0 \uC788\uC5B4\uC57C \uD569\uB2C8\uB2E4.",
        assignmentExprInSubscript: "\uC544\uB798 \uCCA8\uC790 \uB0B4\uC758 \uD560\uB2F9 \uC2DD\uC740 Python 3.10 \uC774\uC0C1\uC5D0\uC11C\uB9CC \uC9C0\uC6D0\uB429\uB2C8\uB2E4.",
        assignmentInProtocol: "Protocol \uD074\uB798\uC2A4 \uB0B4\uC758 \uC778\uC2A4\uD134\uC2A4 \uB610\uB294 \uD074\uB798\uC2A4 \uBCC0\uC218\uB294 \uD074\uB798\uC2A4 \uBCF8\uBB38 \uB0B4\uC5D0\uC11C \uBA85\uC2DC\uC801\uC73C\uB85C \uC120\uC5B8\uD574\uC57C \uD569\uB2C8\uB2E4.",
        assignmentTargetExpr: "\uC2DD\uC740 \uD560\uB2F9 \uB300\uC0C1\uC774 \uB420 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        asyncNotInAsyncFunction: "async \uD568\uC218 \uC678\uBD80\uC5D0\uC11C\uB294 \u201Casync\u201D\uAC00 \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        awaitIllegal: '"await"\uB97C \uC0AC\uC6A9\uD558\uB824\uBA74 Python 3.5 \uC774\uC0C1\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.',
        awaitNotAllowed: '\uD615\uC2DD \uC2DD\uC740 "await"\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        awaitNotInAsync: '"await" allowed only within async function',
        backticksIllegal: "\uBC31\uD2F1\uC73C\uB85C \uBB36\uC778 \uC2DD\uC740 Python 3.x\uC5D0\uC11C \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4. \uB300\uC2E0 repr \uC0AC\uC6A9",
        baseClassCircular: "\uD074\uB798\uC2A4\uB294 \uC2A4\uC2A4\uB85C\uC5D0\uC11C \uD30C\uC0DD\uB420 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        baseClassFinal: '\uAE30\uBCF8 \uD074\uB798\uC2A4 "{type}"\uC774(\uAC00) final\uB85C \uD45C\uC2DC\uB418\uC5B4 \uC11C\uBE0C\uD074\uB798\uC2A4\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        baseClassIncompatible: "{type}\uC758 \uAE30\uBCF8 \uD074\uB798\uC2A4\uB294 \uC0C1\uD638 \uD638\uD658\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        baseClassInvalid: "\uD074\uB798\uC2A4\uC5D0 \uB300\uD55C \uC778\uC218\uB294 \uAE30\uBCF8 \uD074\uB798\uC2A4\uC5EC\uC57C \uD569\uB2C8\uB2E4.",
        baseClassMethodTypeIncompatible: '"{classType}" \uD074\uB798\uC2A4\uC758 \uAE30\uBCF8 \uD074\uB798\uC2A4\uAC00 \uD638\uD658\uB418\uC9C0 \uC54A\uB294 \uBC29\uC2DD\uC73C\uB85C "{name}" \uBA54\uC11C\uB4DC\uB97C \uC815\uC758\uD569\uB2C8\uB2E4.',
        baseClassUnknown: "\uAE30\uBCF8 \uD074\uB798\uC2A4 \uD615\uC2DD\uC744 \uC54C \uC218 \uC5C6\uC73C\uBBC0\uB85C \uD30C\uC0DD \uD074\uB798\uC2A4\uC758 \uD615\uC2DD\uC774 \uBAA8\uD638\uD569\uB2C8\uB2E4.",
        baseClassVariableTypeIncompatible: '"{classType}" \uD074\uB798\uC2A4\uC758 \uAE30\uBCF8 \uD074\uB798\uC2A4\uAC00 "{name}" \uBCC0\uC218\uB97C \uD638\uD658\uB418\uC9C0 \uC54A\uB294 \uBC29\uC2DD\uC73C\uB85C \uC815\uC758\uD569\uB2C8\uB2E4.',
        binaryOperationNotAllowed: "\uD615\uC2DD \uC2DD\uC5D0\uB294 \uC774\uD56D \uC5F0\uC0B0\uC790\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        bindParamMissing: '"self" \uB610\uB294 "cls" \uB9E4\uAC1C \uBCC0\uC218\uAC00 \uB204\uB77D\uB418\uC5C8\uAE30 \uB54C\uBB38\uC5D0 \uBA54\uC11C\uB4DC "{methodName}"\uC744(\uB97C) \uBC14\uC778\uB529\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        bindTypeMismatch: "\u2018{type}\u2019\uC744(\uB97C) \uB9E4\uAC1C \uBCC0\uC218 \u2018{paramName}\u2019\uC5D0 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC73C\uBBC0\uB85C \u2018{methodName}\u2019 \uBA54\uC11C\uB4DC\uB97C \uBC14\uC778\uB529\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        breakInExceptionGroup: '"except*" \uBE14\uB85D\uC5D0\uB294 "break"\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4',
        breakOutsideLoop: "\u2018break\u2019\uB294 \uB8E8\uD504 \uB0B4\uC5D0\uC11C\uB9CC \uC0AC\uC6A9\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4.",
        bytesUnsupportedEscape: "bytes \uB9AC\uD130\uB7F4\uC5D0 \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uB294 \uC774\uC2A4\uCF00\uC774\uD504 \uC2DC\uD000\uC2A4\uAC00 \uC788\uC2B5\uB2C8\uB2E4.",
        callableExtraArgs: '"Callable"\uC5D0 \uB450 \uAC1C\uC758 \uD615\uC2DD \uC778\uC218\uB9CC \uD544\uC694\uD569\uB2C8\uB2E4.',
        callableFirstArg: '\uB9E4\uAC1C \uBCC0\uC218 \uD615\uC2DD \uBAA9\uB85D \uB610\uB294 "..."\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.',
        callableNotInstantiable: '"{type}" \uD615\uC2DD\uC744 \uC778\uC2A4\uD134\uC2A4\uD654\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        callableSecondArg: '\uBC18\uD658 \uD615\uC2DD\uC774 "Callable"\uC5D0 \uB300\uD55C \uB450 \uBC88\uC9F8 \uD615\uC2DD \uC778\uC218\uB85C \uD544\uC694\uD569\uB2C8\uB2E4.',
        casePatternIsIrrefutable: "\uB418\uB3CC\uB9B4 \uC218 \uC5C6\uB294 \uD328\uD134\uC740 \uB9C8\uC9C0\uB9C9 case \uBB38\uC5D0\uB9CC \uC0AC\uC6A9\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4.",
        classAlreadySpecialized: '"{type}" \uD615\uC2DD\uC774 \uC774\uBBF8 \uD2B9\uC218\uD654\uB418\uC5B4 \uC788\uC2B5\uB2C8\uB2E4.',
        classDecoratorTypeUnknown: "\uD615\uC2DD\uD654\uB418\uC9C0 \uC54A\uC740 \uD074\uB798\uC2A4 \uB370\uCF54\uB808\uC774\uD130\uB294 \uD074\uB798\uC2A4 \uD615\uC2DD\uC744 \uBAA8\uD638\uD558\uAC8C \uD569\uB2C8\uB2E4. \uB370\uCF54\uB808\uC774\uD130\uB97C \uBB34\uC2DC\uD569\uB2C8\uB2E4.",
        classDefinitionCycle: "\u2018{name}\u2019\uC5D0 \uB300\uD55C \uD074\uB798\uC2A4 \uC815\uC758\uAC00 \uC2A4\uC2A4\uB85C\uC5D0 \uC885\uC18D\uB429\uB2C8\uB2E4.",
        classGetItemClsParam: '__class_getitem__ \uC7AC\uC815\uC758\uB294 "cls" \uB9E4\uAC1C \uBCC0\uC218\uB97C \uC0AC\uC6A9\uD574\uC57C \uD569\uB2C8\uB2E4.',
        classMethodClsParam: "\uD074\uB798\uC2A4 \uBA54\uC11C\uB4DC\uB294 \u2018cls\u2019 \uB9E4\uAC1C \uBCC0\uC218\uB97C \uC0AC\uC6A9\uD574\uC57C \uD569\uB2C8\uB2E4.",
        classNotRuntimeSubscriptable: '\uD074\uB798\uC2A4 "{name}"\uC5D0 \uB300\uD55C \uCCA8\uC790\uB294 \uB7F0\uD0C0\uC784 \uC608\uC678\uB97C \uC0DD\uC131\uD569\uB2C8\uB2E4. \uD615\uC2DD \uC2DD\uC744 \uB530\uC634\uD45C\uB85C \uBB36\uC2B5\uB2C8\uB2E4.',
        classPatternBuiltInArgPositional: "\uD074\uB798\uC2A4 \uD328\uD134\uC740 \uC704\uCE58 \uD558\uC704 \uD328\uD134\uB9CC \uD5C8\uC6A9\uD569\uB2C8\uB2E4.",
        classPatternNewType: '"{type}" cannot be used in a class pattern because it is defined using NewType',
        classPatternPositionalArgCount: '\uD074\uB798\uC2A4 "{type}"\uC5D0 \uB300\uD55C \uC704\uCE58 \uD328\uD134\uC774 \uB108\uBB34 \uB9CE\uC2B5\uB2C8\uB2E4. {expected}\uC774(\uAC00) \uD544\uC694\uD558\uC9C0\uB9CC {received}\uC744(\uB97C) \uBC1B\uC558\uC2B5\uB2C8\uB2E4.',
        classPatternTypeAlias: "\u2018{type}\u2019\uC740(\uB294) \uD2B9\uC218 \uD615\uC2DD \uBCC4\uCE6D\uC774\uBBC0\uB85C \uD074\uB798\uC2A4 \uD328\uD134\uC5D0\uC11C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        classPropertyDeprecated: "\uD074\uB798\uC2A4 \uC18D\uC131\uC740 Python 3.11\uC5D0\uC11C \uB354 \uC774\uC0C1 \uC0AC\uC6A9\uB418\uC9C0 \uC54A\uC73C\uBA70 Python 3.13\uC5D0\uC11C \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        classTypeParametersIllegal: "\uD074\uB798\uC2A4 \uD615\uC2DD \uB9E4\uAC1C \uBCC0\uC218 \uAD6C\uBB38\uC5D0\uB294 Python 3.12 \uC774\uC0C1\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        classVarFirstArgMissing: "\u2018ClassVar\u2019 \uB4A4\uC5D0 \uD615\uC2DD \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        classVarNotAllowed: '\uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C\uB294 "ClassVar"\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        classVarOverridesInstanceVar: '\uD074\uB798\uC2A4 \uBCC0\uC218 "{name}"\uC774(\uAC00) "{className}" \uD074\uB798\uC2A4\uC5D0\uC11C \uAC19\uC740 \uC774\uB984\uC758 \uC778\uC2A4\uD134\uC2A4 \uBCC0\uC218\uB97C \uC7AC\uC815\uC758\uD569\uB2C8\uB2E4.',
        classVarTooManyArgs: "\u2018ClassVar\u2019 \uB4A4\uC5D0\uB294 \uD615\uC2DD \uC778\uC218\uAC00 \uD558\uB098\uB9CC \uD544\uC694\uD569\uB2C8\uB2E4.",
        classVarWithTypeVar: "\u2018ClassVar\u2019 \uD615\uC2DD\uC5D0\uB294 \uD615\uC2DD \uBCC0\uC218\uB97C \uD3EC\uD568\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        clsSelfParamTypeMismatch: "\u2018{name}\u2019 \uB9E4\uAC1C \uBCC0\uC218\uC758 \uD615\uC2DD\uC740 \uD574\uB2F9 \u2018{classType}\u2019 \uD074\uB798\uC2A4\uC758 \uC0C1\uC704 \uD615\uC2DD\uC774\uC5B4\uC57C \uD569\uB2C8\uB2E4.",
        codeTooComplexToAnalyze: "\uCF54\uB4DC\uAC00 \uB108\uBB34 \uBCF5\uC7A1\uD558\uC5EC \uBD84\uC11D\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4. \uD558\uC704 \uACBD\uB85C\uB85C \uB9AC\uD329\uD130\uB9C1\uD558\uAC70\uB098 \uC870\uAC74\uBD80 \uCF54\uB4DC \uACBD\uB85C\uB97C \uC904\uC5EC \uBCF5\uC7A1\uC131 \uAC10\uC18C",
        collectionAliasInstantiation: "\u2018{type}\u2019 \uD615\uC2DD\uC744 \uC778\uC2A4\uD134\uC2A4\uD654\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4. \uB300\uC2E0 \u2018{alias}\u2019\uC744(\uB97C) \uC0AC\uC6A9\uD558\uC138\uC694.",
        comparisonAlwaysFalse: '"{leftType}" \uBC0F "{rightType}" \uD615\uC2DD\uC774 \uACB9\uCE58\uC9C0 \uC54A\uC73C\uBBC0\uB85C \uC870\uAC74\uC740 \uD56D\uC0C1 False\uB85C \uD3C9\uAC00\uB429\uB2C8\uB2E4.',
        comparisonAlwaysTrue: '"{leftType}" \uBC0F "{rightType}" \uD615\uC2DD\uC774 \uACB9\uCE58\uC9C0 \uC54A\uC73C\uBBC0\uB85C \uC870\uAC74\uC740 \uD56D\uC0C1 True\uB85C \uD3C9\uAC00\uB429\uB2C8\uB2E4.',
        comprehensionInDict: "\uC774\uD574\uB825\uC740 \uB2E4\uB978 \uC0AC\uC804 \uD56D\uBAA9\uACFC \uD568\uAED8 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        comprehensionInSet: "\uC774\uD574\uB825\uC740 \uB2E4\uB978 set \uD56D\uBAA9\uACFC \uD568\uAED8 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        concatenateContext: '\uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C\uB294 "Concatenate"\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        concatenateParamSpecMissing: '"Concatenate"\uC758 \uB9C8\uC9C0\uB9C9 \uD615\uC2DD \uC778\uC218\uB294 ParamSpec \uB610\uB294 "..."\uC774\uC5B4\uC57C \uD569\uB2C8\uB2E4.',
        concatenateTypeArgsMissing: '"Concatenate"\uC5D0\uB294 \uC801\uC5B4\uB3C4 \uB450 \uAC1C\uC758 \uD615\uC2DD \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.',
        conditionalOperandInvalid: "\u2019{type}\u2019 \uD615\uC2DD\uC758 \uC870\uAC74\uBD80 \uD53C\uC5F0\uC0B0\uC790\uC785\uB2C8\uB2E4.",
        constantRedefinition: "\u2018{name}\u2019\uC740(\uB294) \uB300\uBB38\uC790\uC774\uBBC0\uB85C \uC0C1\uC218\uC774\uACE0 \uB2E4\uC2DC \uC815\uC758\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        constructorParametersMismatch: "\u2018{classType}\u2019 \uD074\uB798\uC2A4\uC5D0\uC11C __new__ \uC11C\uBA85\uACFC __init__\uAC00 \uBD88\uC77C\uCE58\uD569\uB2C8\uB2E4.",
        containmentAlwaysFalse: "\u2018{leftType}\u2019 \uBC0F \u2018{rightType}\u2019 \uD615\uC2DD\uC774 \uACB9\uCE58\uC9C0 \uC54A\uC73C\uBBC0\uB85C \uC2DD\uC740 \uD56D\uC0C1 False\uB85C \uD3C9\uAC00\uB429\uB2C8\uB2E4.",
        containmentAlwaysTrue: "\u2018{leftType}\u2019 \uBC0F \u2018{rightType}\u2019 \uD615\uC2DD\uC774 \uACB9\uCE58\uC9C0 \uC54A\uC73C\uBBC0\uB85C \uC2DD\uC740 \uD56D\uC0C1 True\uB85C \uD3C9\uAC00\uB429\uB2C8\uB2E4.",
        continueInExceptionGroup: '"except*" \uBE14\uB85D\uC5D0\uB294 "continue"\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4',
        continueOutsideLoop: '"continue"\uB294 \uB8E8\uD504 \uB0B4\uC5D0\uC11C\uB9CC \uC0AC\uC6A9\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4.',
        coroutineInConditionalExpression: "\uC870\uAC74\uC2DD\uC740 \uD56D\uC0C1 True\uB85C \uD3C9\uAC00\uB418\uB294 \uCF54\uB8E8\uD2F4\uC744 \uCC38\uC870\uD569\uB2C8\uB2E4.",
        dataClassBaseClassFrozen: "\uACE0\uC815\uB418\uC9C0 \uC54A\uC740 \uD074\uB798\uC2A4\uB294 \uACE0\uC815\uB41C \uD074\uB798\uC2A4\uC5D0\uC11C \uC0C1\uC18D\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        dataClassBaseClassNotFrozen: "\uACE0\uC815 \uD074\uB798\uC2A4\uB294 \uACE0\uC815\uB418\uC9C0 \uC54A\uC740 \uD074\uB798\uC2A4\uC5D0\uC11C \uC0C1\uC18D\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        dataClassConverterFunction: '"{argType}" \uD615\uC2DD\uC758 \uC778\uC218\uB294 "{fieldType}" \uD615\uC2DD\uC758 "{fieldName}" \uD544\uB4DC\uC5D0 \uC720\uD6A8\uD55C \uBCC0\uD658\uAE30\uAC00 \uC544\uB2D9\uB2C8\uB2E4.',
        dataClassConverterOverloads: '"{funcName}"\uC758 \uC624\uBC84\uB85C\uB4DC\uB294 "{fieldType}" \uD615\uC2DD\uC758 "{fieldName}" \uD544\uB4DC\uC5D0 \uC720\uD6A8\uD55C \uBCC0\uD658\uAE30\uAC00 \uC544\uB2D9\uB2C8\uB2E4.',
        dataClassFieldInheritedDefault: '"{fieldName}"\uC774(\uAC00) \uAC19\uC740 \uC774\uB984\uC758 \uD544\uB4DC\uB97C \uC7AC\uC815\uC758\uD558\uC9C0\uB9CC \uAE30\uBCF8\uAC12\uC774 \uC5C6\uC74C',
        dataClassFieldWithDefault: "\uAE30\uBCF8\uAC12\uC774 \uC5C6\uB294 \uD544\uB4DC\uB294 \uAE30\uBCF8\uAC12\uC774 \uC788\uB294 \uD544\uB4DC \uB4A4\uC5D0 \uB098\uD0C0\uB0A0 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        dataClassFieldWithPrivateName: "\uB370\uC774\uD130 \uD074\uB798\uC2A4 \uD544\uB4DC\uB294 \uD504\uB77C\uC774\uBE57 \uC774\uB984\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        dataClassFieldWithoutAnnotation: "\uD615\uC2DD \uC8FC\uC11D\uC774 \uC5C6\uB294 \uB370\uC774\uD130 \uD074\uB798\uC2A4 \uD544\uB4DC\uB97C \uC0AC\uC6A9\uD558\uBA74 \uB7F0\uD0C0\uC784 \uC608\uC678\uAC00 \uBC1C\uC0DD\uD569\uB2C8\uB2E4.",
        dataClassPostInitParamCount: "\uB370\uC774\uD130 \uD074\uB798\uC2A4 __post_init__\uC758 \uC798\uBABB\uB41C \uB9E4\uAC1C \uBCC0\uC218 \uC218\uC785\uB2C8\uB2E4. InitVar \uD544\uB4DC \uC218\uAC00 {expected}\uAC1C\uC785\uB2C8\uB2E4.",
        dataClassPostInitType: '\uB370\uC774\uD130 \uD074\uB798\uC2A4 __post_init__ \uBA54\uC11C\uB4DC \uB9E4\uAC1C \uBCC0\uC218 \uD615\uC2DD\uC774 \uD544\uB4DC "{fieldName}"\uC5D0 \uB300\uD574 \uC77C\uCE58\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        dataClassSlotsOverwrite: "__slots__ \uD074\uB798\uC2A4\uC5D0 \uC774\uBBF8 \uC815\uC758\uB418\uC5B4 \uC788\uC2B5\uB2C8\uB2E4.",
        dataClassTransformExpectedBoolLiteral: "\uC815\uC801\uC73C\uB85C True \uB610\uB294 False\uB85C \uACC4\uC0B0\uB418\uB294 \uC2DD\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        dataClassTransformFieldSpecifier: "\uD074\uB798\uC2A4 \uB610\uB294 \uD568\uC218\uC758 tuple\uC774 \uD544\uC694\uD558\uC9C0\uB9CC \u201C{type}\u201D \uD615\uC2DD\uC744 \uBC1B\uC558\uC2B5\uB2C8\uB2E4.",
        dataClassTransformPositionalParam: '"dataclass_transform"\uC5D0 \uB300\uD55C \uBAA8\uB4E0 \uC778\uC218\uB294 \uD0A4\uC6CC\uB4DC \uC778\uC218\uC5EC\uC57C \uD569\uB2C8\uB2E4.',
        dataClassTransformUnknownArgument: 'dataclass_transform\uC740 "{name}" \uC778\uC218\uB97C \uC9C0\uC6D0\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        dataProtocolInSubclassCheck: "\uB370\uC774\uD130 \uD504\uB85C\uD1A0\uCF5C(\uBE44 \uBA54\uC11C\uB4DC \uD2B9\uC131 \uD3EC\uD568)\uC740 issubclass \uD638\uCD9C\uC5D0\uC11C \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        declaredReturnTypePartiallyUnknown: '\uC120\uC5B8\uB41C \uBC18\uD658 \uD615\uC2DD "{returnType}"\uC744(\uB97C) \uBD80\uBD84\uC801\uC73C\uB85C \uC54C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        declaredReturnTypeUnknown: "\uC120\uC5B8\uB41C \uBC18\uD658 \uD615\uC2DD\uC744 \uC54C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        defaultValueContainsCall: "\uB9E4\uAC1C \uBCC0\uC218 \uAE30\uBCF8\uAC12 \uC2DD \uB0B4\uC5D0\uC11C\uB294 \uD568\uC218 \uD638\uCD9C \uBC0F \uBCC0\uACBD \uAC00\uB2A5\uD55C \uAC1C\uCCB4\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        defaultValueNotAllowed: '"*" \uB610\uB294 "**"\uAC00 \uC788\uB294 \uB9E4\uAC1C \uBCC0\uC218\uB294 \uAE30\uBCF8\uAC12\uC744 \uAC00\uC9C8 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        delTargetExpr: "\uC2DD\uC744 \uC0AD\uC81C\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        deprecatedClass: "\u2018{name}\u2019 \uD074\uB798\uC2A4\uB294 \uC0AC\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        deprecatedConstructor: '\uD074\uB798\uC2A4 "{name}"\uC758 \uC0DD\uC131\uC790\uB294 \uB354 \uC774\uC0C1 \uC0AC\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        deprecatedDescriptorDeleter: '"{name}" \uC124\uBA85\uC790\uC5D0 \uB300\uD55C "____delete____" \uBA54\uC11C\uB4DC\uB294 \uC0AC\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        deprecatedDescriptorGetter: '"{name}" \uC124\uBA85\uC790\uC5D0 \uB300\uD55C "__get__" \uBA54\uC11C\uB4DC\uB294 \uC0AC\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        deprecatedDescriptorSetter: '"{name}" \uC124\uBA85\uC790\uC5D0 \uB300\uD55C "__set__" \uBA54\uC11C\uB4DC\uB294 \uC0AC\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        deprecatedFunction: '"{name}" \uD568\uC218\uB294 \uB354 \uC774\uC0C1 \uC0AC\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        deprecatedMethod: '"{className}" \uD074\uB798\uC2A4\uC758 "{name}" \uBA54\uC11C\uB4DC\uB294 \uB354 \uC774\uC0C1 \uC0AC\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        deprecatedPropertyDeleter: '"{name}" property\uC5D0 \uB300\uD55C deleter\uB294 \uC0AC\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        deprecatedPropertyGetter: '"{name}" property\uC5D0 \uB300\uD55C getter\uB294 \uC0AC\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        deprecatedPropertySetter: '"{name}" property\uC5D0 \uB300\uD55C setter\uB294 \uC0AC\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        deprecatedType: '\uC774 \uD615\uC2DD\uC740 Python {version}\uBD80\uD130 \uC0AC\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4. \uB300\uC2E0 "{replacement}"\uC744(\uB97C) \uC0AC\uC6A9\uD558\uC138\uC694.',
        dictExpandIllegalInComprehension: "\uC0AC\uC804 \uD655\uC7A5\uC740 \uC774\uD574\uC5D0 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        dictInAnnotation: "\uD615\uC2DD \uC2DD\uC5D0\uB294 \uC0AC\uC804 \uC2DD\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        dictKeyValuePairs: "\uC0AC\uC804 \uD56D\uBAA9\uC740 \uD0A4/\uAC12 \uC30D\uC744 \uD3EC\uD568\uD574\uC57C \uD569\uB2C8\uB2E4.",
        dictUnpackIsNotMapping: "\uC0AC\uC804 \uC555\uCD95 \uD480\uAE30 \uC5F0\uC0B0\uC790\uC5D0 \uB300\uD55C \uB9E4\uD551\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        dunderAllSymbolNotPresent: '"{name}"\uC774(\uAC00) __all__\uC5D0 \uC9C0\uC815\uB418\uC5C8\uC9C0\uB9CC \uBAA8\uB4C8\uC5D0 \uC5C6\uC2B5\uB2C8\uB2E4.',
        duplicateArgsParam: '"*" \uB9E4\uAC1C \uBCC0\uC218 \uD558\uB098\uB9CC \uD5C8\uC6A9\uB428',
        duplicateBaseClass: "\uC911\uBCF5 \uAE30\uBCF8 \uD074\uB798\uC2A4\uB294 \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        duplicateCapturePatternTarget: "\u2018{name}\u2019 \uCEA1\uCC98 \uB300\uC0C1\uC774 \uB3D9\uC77C\uD55C \uD328\uD134 \uB0B4\uC5D0 \uB450 \uBC88 \uC774\uC0C1 \uB098\uD0C0\uB0A0 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        duplicateCatchAll: "\uD558\uB098\uC758 catch-all except \uC808\uB9CC \uD5C8\uC6A9\uB428",
        duplicateEnumMember: 'Enum \uBA64\uBC84 "{name}"\uC774(\uAC00) \uC774\uBBF8 \uC120\uC5B8\uB418\uC5C8\uC2B5\uB2C8\uB2E4.',
        duplicateGenericAndProtocolBase: "\uD558\uB098\uC758 Generic[...] \uB610\uB294 Protocol[...] \uAE30\uBCF8 \uD074\uB798\uC2A4\uB9CC \uD5C8\uC6A9\uB429\uB2C8\uB2E4.",
        duplicateImport: '"{importName}"\uC744(\uB97C) \uB450 \uBC88 \uC774\uC0C1 \uAC00\uC838\uC654\uC2B5\uB2C8\uB2E4.',
        duplicateKeywordOnly: '"*" \uAD6C\uBD84 \uAE30\uD638\uB294 \uD558\uB098\uB9CC \uC0AC\uC6A9\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4.',
        duplicateKwargsParam: '"**" \uB9E4\uAC1C \uBCC0\uC218 \uD558\uB098\uB9CC \uD5C8\uC6A9\uB428',
        duplicateParam: '\uB9E4\uAC1C \uBCC0\uC218 "{name}"\uC774(\uAC00) \uC911\uBCF5\uB418\uC5C8\uC2B5\uB2C8\uB2E4.',
        duplicatePositionOnly: "\u2018/\u2019 \uB9E4\uAC1C \uBCC0\uC218 \uD558\uB098\uBBFC \uD5C8\uC6A9\uB429\uB2C8\uB2E4.",
        duplicateStarPattern: "\uD328\uD134 \uC2DC\uD000\uC2A4\uC5D0\uB294 \u2018*\u2019 \uD328\uD134\uC744 \uD558\uB098\uB9CC \uC0AC\uC6A9\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4.",
        duplicateStarStarPattern: "\u2018**\u2019 \uD56D\uBAA9 \uD558\uB098\uB9CC \uD5C8\uC6A9\uB429\uB2C8\uB2E4.",
        duplicateUnpack: "list\uC5D0\uC11C\uB294 \uD55C \uAC1C\uC758 \uC555\uCD95 \uD480\uAE30 \uC791\uC5C5\uB9CC \uD5C8\uC6A9\uB429\uB2C8\uB2E4.",
        ellipsisAfterUnpacked: '"..." \uC555\uCD95\uC744 \uD480\uACE0 \uC788\uB294 TypeVarTuple \uB610\uB294 tuple\uACFC \uD568\uAED8 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        ellipsisContext: '"..."\uB294 \uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C\uB294 \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        ellipsisSecondArg: '"..."\uB294 \uB450 \uC778\uC218 \uC911 \uB450 \uBC88\uC9F8 \uC778\uC218\uB85C\uB9CC \uD5C8\uC6A9\uB429\uB2C8\uB2E4.',
        enumClassOverride: 'Enum \uD074\uB798\uC2A4 "{name}"\uC740(\uB294) final \uD074\uB798\uC2A4\uC774\uBA70 \uC11C\uBE0C\uD074\uB798\uC2A4\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        enumMemberDelete: 'Enum \uBA64\uBC84 "{name}"\uC744(\uB97C) \uC0AD\uC81C\uD560 \uC218 \uC5C6\uC74C',
        enumMemberSet: 'Enum \uBA64\uBC84 "{name}"\uC744(\uB97C) \uD560\uB2F9\uD560 \uC218 \uC5C6\uC74C',
        enumMemberTypeAnnotation: "Type annotations are not allowed for enum members",
        exceptGroupMismatch: 'Try \uBB38\uC5D0\uB294 "except"\uC640 "except*"\uB97C \uB458 \uB2E4 \uD3EC\uD568\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4',
        exceptGroupRequiresType: '\uC608\uC678 \uADF8\uB8F9 \uAD6C\uBB38("except*")\uC5D0\uB294 \uC608\uC678 \uD615\uC2DD\uC774 \uD544\uC694\uD569\uB2C8\uB2E4',
        exceptRequiresParens: "Multiple exception types must be parenthesized prior to Python 3.14",
        exceptWithAsRequiresParens: 'Multiple exception types must be parenthesized when using "as"',
        exceptionGroupIncompatible: '\uC608\uC678 \uADF8\uB8F9 \uAD6C\uBB38("except*")\uC5D0\uB294 Python 3.11 \uC774\uC0C1\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.',
        exceptionGroupTypeIncorrect: "except*\uC758 \uC608\uC678 \uD615\uC2DD\uC740 BaseGroupException\uC5D0\uC11C \uD30C\uC0DD\uB420 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        exceptionTypeIncorrect: "\u2018{type}\u2019\uC740 BaseException\uC5D0\uC11C \uD30C\uC0DD\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        exceptionTypeNotClass: '"{type}"\uC740(\uB294) \uC62C\uBC14\uB978 \uC608\uC678 \uD074\uB798\uC2A4\uAC00 \uC544\uB2D9\uB2C8\uB2E4.',
        exceptionTypeNotInstantiable: '\uC608\uC678 \uD615\uC2DD "{type}"\uC5D0 \uB300\uD55C \uC0DD\uC131\uC790\uC5D0\uB294 \uD558\uB098 \uC774\uC0C1\uC758 \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.',
        expectedAfterDecorator: "\uB370\uCF54\uB808\uC774\uD130 \uB2E4\uC74C\uC5D0 \uD568\uC218 \uB610\uB294 \uD074\uB798\uC2A4 \uC120\uC5B8\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedArrow: '"->" \uB2E4\uC74C\uC5D0 \uBC18\uD658 \uD615\uC2DD \uC8FC\uC11D\uC774 \uC640\uC57C \uD569\uB2C8\uB2E4.',
        expectedAsAfterException: "\uC608\uC678 \uD615\uC2DD \uB4A4\uC5D0 \u2018as\u2019\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedAssignRightHandExpr: '"=" \uC624\uB978\uCABD\uC5D0 \uC2DD\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.',
        expectedBinaryRightHandExpr: "\uC5F0\uC0B0\uC790 \uC624\uB978\uCABD\uC5D0 \uC2DD\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedBoolLiteral: "True \uB610\uB294 False\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedCase: '"case" \uBB38\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.',
        expectedClassName: "\uD074\uB798\uC2A4 \uC774\uB984\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedCloseBrace: '"{"\uAC00 \uB2EB\uD600 \uC788\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        expectedCloseBracket: '"[{0}"\uC774(\uAC00) \uB2EB\uD600 \uC788\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        expectedCloseParen: '"("\uAC00 \uB2EB\uD600 \uC788\uC9C0 \uC54A\uC74C',
        expectedColon: "':'\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedComplexNumberLiteral: "\uD328\uD134 \uC77C\uCE58\uC5D0 \uBCF5\uC18C\uC218 \uB9AC\uD130\uB7F4\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedDecoratorExpr: "Python 3.9 \uC774\uC804\uC758 \uB370\uCF54\uB808\uC774\uD130\uC5D0\uB294 \uC2DD \uD615\uC2DD\uC774 \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        expectedDecoratorName: "\uB370\uCF54\uB808\uC774\uD130 \uC774\uB984\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedDecoratorNewline: "\uB370\uCF54\uB808\uC774\uD130 \uB05D\uC5D0 \uC0C8 \uC904\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedDelExpr: '"del" \uB4A4\uC5D0 \uC2DD\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.',
        expectedElse: '"else"\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.',
        expectedEquals: '"="\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.',
        expectedExceptionClass: "\uC798\uBABB\uB41C \uC608\uC678 \uD074\uB798\uC2A4 \uB610\uB294 \uAC1C\uCCB4",
        expectedExceptionObj: "\uD544\uC694\uD55C \uC608\uC678 \uAC1C\uCCB4, \uC608\uC678 \uD074\uB798\uC2A4 \uB610\uB294 None",
        expectedExpr: "\uC2DD\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedFunctionAfterAsync: "\u2018async\u2019 \uB2E4\uC74C\uC5D0 \uD568\uC218 \uC815\uC758\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedFunctionName: '"def" \uB4A4\uC5D0 \uD568\uC218 \uC774\uB984\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.',
        expectedIdentifier: "\uC2DD\uBCC4\uC790\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedImport: '"import"\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.',
        expectedImportAlias: '"as" \uB4A4\uC5D0 \uAE30\uD638\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.',
        expectedImportSymbols: '"import" \uB4A4\uC5D0 \uD558\uB098 \uC774\uC0C1\uC758 \uAE30\uD638 \uC774\uB984\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.',
        expectedIn: '"in"\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.',
        expectedInExpr: '"in" \uB4A4\uC5D0 \uC2DD\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.',
        expectedIndentedBlock: "\uB4E4\uC5EC\uC4F0\uAE30 \uBE14\uB85D\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedMemberName: '"." \uB4A4\uC5D0 \uD2B9\uC131 \uC774\uB984 \uD544\uC694',
        expectedModuleName: "\uD544\uC694\uD55C \uBAA8\uB4C8 \uC774\uB984",
        expectedNameAfterAs: "\u2018as\u2019 \uB4A4\uC5D0\uB294 \uAE30\uD638 \uC774\uB984\uC774 \uC640\uC57C \uD569\uB2C8\uB2E4.",
        expectedNamedParameter: '\uD0A4\uC6CC\uB4DC \uB9E4\uAC1C \uBCC0\uC218\uB294 "*"\uB97C \uB530\uB77C\uC57C \uD569\uB2C8\uB2E4.',
        expectedNewline: "\uC904 \uBC14\uAFC8\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedNewlineOrSemicolon: "\uBB38\uC740 \uC904 \uBC14\uAFC8 \uB610\uB294 \uC138\uBBF8\uCF5C\uB860\uC73C\uB85C \uAD6C\uBD84\uD574\uC57C \uD569\uB2C8\uB2E4.",
        expectedOpenParen: "\u2019(\u2018\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedParamName: "\uB9E4\uAC1C \uBCC0\uC218 \uC774\uB984\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedPatternExpr: "\uD328\uD134 \uC2DD\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedPatternSubjectExpr: "\uD328\uD134 \uC81C\uBAA9 \uC2DD\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedPatternValue: '"a.b" \uD615\uC2DD\uC758 \uD328\uD134 \uAC12 \uC2DD\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.',
        expectedReturnExpr: '"return" \uB4A4\uC5D0 \uC2DD\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.',
        expectedSliceIndex: "\uC778\uB371\uC2A4 \uB610\uB294 \uC870\uAC01 \uC2DD\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedTypeNotString: "\uD615\uC2DD\uC774 \uD544\uC694\uD558\uC9C0\uB9CC \uBB38\uC790\uC5F4 \uB9AC\uD130\uB7F4\uC744 \uBC1B\uC558\uC2B5\uB2C8\uB2E4.",
        expectedTypeParameterName: "\uD615\uC2DD \uB9E4\uAC1C \uBCC0\uC218 \uC774\uB984\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        expectedYieldExpr: "yield \uBB38\uC5D0 \uC2DD\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        finalClassIsAbstract: '"{type}" \uD074\uB798\uC2A4\uAC00 final\uB85C \uD45C\uC2DC\uB418\uC5B4 \uC788\uC73C\uBA70 \uBAA8\uB4E0 \uCD94\uC0C1 \uAE30\uD638\uB97C \uAD6C\uD604\uD574\uC57C \uD569\uB2C8\uB2E4.',
        finalContext: '"Final"\uC740 \uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        finalInLoop: '\uB8E8\uD504 \uB0B4\uC5D0\uB294 "Final" \uBCC0\uC218\uB97C \uD560\uB2F9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        finalMethodOverride: '"{name}" \uBA54\uC11C\uB4DC\uB294 "{className}" \uD074\uB798\uC2A4\uC5D0 \uC815\uC758\uB41C final \uBA54\uC11C\uB4DC\uB97C \uC7AC\uC815\uC758\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        finalNonMethod: '\uD568\uC218 "{name}"\uC740(\uB294) \uBA54\uC11C\uB4DC\uAC00 \uC544\uB2C8\uBBC0\uB85C @final\uB85C \uD45C\uC2DC\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        finalReassigned: "\u2018{name}\u2019\uC774 Final\uB85C \uC120\uC5B8\uB418\uC5C8\uC73C\uBBC0\uB85C \uB2E4\uC2DC \uD560\uB2F9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        finalRedeclaration: '"{name}"\uC774(\uAC00) \uC774\uC804\uC5D0 Final\uB85C \uC120\uC5B8\uB418\uC5C8\uC2B5\uB2C8\uB2E4.',
        finalRedeclarationBySubclass: '\uBD80\uBAA8 \uD074\uB798\uC2A4 "{className}"\uC774(\uAC00) Final\uB85C \uC120\uC5B8\uD558\uBBC0\uB85C "{name}"\uC744(\uB97C) \uB2E4\uC2DC \uC120\uC5B8\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        finalTooManyArgs: '"Final" \uB4A4\uC5D0 \uB2E8\uC77C \uD615\uC2DD \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.',
        finalUnassigned: '"{name}"\uC774(\uAC00) Final\uB85C \uC120\uC5B8\uB418\uC5C8\uC9C0\uB9CC \uAC12\uC774 \uD560\uB2F9\uB418\uC9C0 \uC54A\uC558\uC2B5\uB2C8\uB2E4.',
        finallyBreak: '"break"\uB97C \uC0AC\uC6A9\uD558\uC5EC "finally" \uBE14\uB85D\uC744 \uC885\uB8CC\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4',
        finallyContinue: '"continue"\uB97C \uC0AC\uC6A9\uD558\uC5EC "finally" \uBE14\uB85D\uC744 \uC885\uB8CC\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4',
        finallyReturn: '"return"\uC744 \uC0AC\uC6A9\uD558\uC5EC "finally" \uBE14\uB85D\uC744 \uC885\uB8CC\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4',
        formatStringBrace: "f-string \uB9AC\uD130\uB7F4 \uB0B4\uC5D0\uC11C\uB294 \uB2E8\uC77C \uB2EB\uB294 \uC911\uAD04\uD638\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4. \uC774\uC911 \uB2EB\uB294 \uC911\uAD04\uD638\uB97C \uC0AC\uC6A9\uD558\uC138\uC694.",
        formatStringBytes: "\uD615\uC2DD \uBB38\uC790\uC5F4 \uB9AC\uD130\uB7F4(f-strings)\uC740 \uC774\uC9C4\uC77C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        formatStringDebuggingIllegal: "F-string \uB514\uBC84\uAE45 \uC9C0\uC815\uC790\uC778 \u2018=\u2019\uB294 Python 3.8 \uC774\uC0C1\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        formatStringEscape: "Python 3.12 \uC774\uC804\uC758 f-string\uC758 \uC2DD \uBD80\uBD84\uC5D0 \uC774\uC2A4\uCF00\uC774\uD504 \uC2DC\uD000\uC2A4(\uBC31\uC2AC\uB798\uC2DC)\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        formatStringExpectedConversion: 'f-string\uC5D0\uC11C "!" \uB4A4\uC5D0 \uBCC0\uD658 \uC9C0\uC815\uC790\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.',
        formatStringIllegal: "\uD615\uC2DD \uBB38\uC790\uC5F4 \uB9AC\uD130\uB7F4(f-strings)\uC740 Python 3.6 \uC774\uC0C1\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        formatStringInPattern: "\uD328\uD134\uC5D0\uC11C \uD615\uC2DD \uBB38\uC790\uC5F4\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        formatStringNestedFormatSpecifier: "\uD615\uC2DD \uBB38\uC790\uC5F4 \uC9C0\uC815\uC790 \uB0B4\uC5D0 \uB108\uBB34 \uAE4A\uAC8C \uC911\uCCA9\uB41C \uC2DD",
        formatStringNestedQuote: "f-string \uB0B4\uC5D0 \uC911\uCCA9\uB41C \uBB38\uC790\uC5F4\uC740 Python 3.12 \uC774\uC804\uC758 f-string\uACFC \uAC19\uC740 \uB530\uC634\uD45C\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        formatStringTemplate: "Format string literals (f-strings) cannot also be template strings (t-strings)",
        formatStringUnicode: "\uD615\uC2DD \uBB38\uC790\uC5F4 \uB9AC\uD130\uB7F4(f-\uBB38\uC790\uC5F4)\uC740 \uC720\uB2C8\uCF54\uB4DC\uC77C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        formatStringUnterminated: "f-string\uC5D0 \uC885\uACB0\uB418\uC9C0 \uC54A\uC740 \uC2DD\uC774 \uC788\uC2B5\uB2C8\uB2E4. \u2018}\u2018\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        functionDecoratorTypeUnknown: "\uD615\uC2DD\uD654\uB418\uC9C0 \uC54A\uC740 \uD568\uC218 \uB370\uCF54\uB808\uC774\uD130\uB294 \uD568\uC218 \uD615\uC2DD\uC744 \uBAA8\uD638\uD558\uAC8C \uD569\uB2C8\uB2E4. \uB370\uCF54\uB808\uC774\uD130 \uBB34\uC2DC",
        functionInConditionalExpression: "\uC870\uAC74\uC2DD\uC740 \uD56D\uC0C1 True\uB85C \uD3C9\uAC00\uB418\uB294 \uD568\uC218\uB97C \uCC38\uC870\uD569\uB2C8\uB2E4.",
        functionTypeParametersIllegal: "\uD568\uC218 \uD615\uC2DD \uB9E4\uAC1C \uBCC0\uC218 \uAD6C\uBB38\uC5D0\uB294 Python 3.12 \uC774\uC0C1\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        futureImportLocationNotAllowed: "__future__ \uAC00\uC838\uC624\uAE30\uB294 \uD30C\uC77C\uC758 \uC2DC\uC791 \uBD80\uBD84\uC5D0 \uC788\uC5B4\uC57C \uD569\uB2C8\uB2E4.",
        generatorAsyncReturnType: 'async \uC0DD\uC131\uAE30 \uD568\uC218\uC758 \uBC18\uD658 \uD615\uC2DD\uC740 "AsyncGenerator[{yieldType}, Any]"\uC640 \uD638\uD658\uB418\uC5B4\uC57C \uD569\uB2C8\uB2E4.',
        generatorNotParenthesized: "\uC0DD\uC131\uAE30 \uC2DD\uC740 \uB2E8\uB3C5 \uC778\uC218\uAC00 \uC544\uB2CC \uACBD\uC6B0 \uAD04\uD638\uB85C \uC9C0\uC815\uD574\uC57C \uD569\uB2C8\uB2E4.",
        generatorSyncReturnType: '\uC0DD\uC131\uAE30 \uD568\uC218\uC758 \uBC18\uD658 \uD615\uC2DD\uC740 "Generator[{yieldType}, Any, Any]"\uC640 \uD638\uD658\uB418\uC5B4\uC57C \uD569\uB2C8\uB2E4.',
        genericBaseClassNotAllowed: '"Generic" \uAE30\uBCF8 \uD074\uB798\uC2A4\uB294 \uD615\uC2DD \uB9E4\uAC1C \uBCC0\uC218 \uAD6C\uBB38\uACFC \uD568\uAED8 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        genericClassAssigned: "\uC81C\uB124\uB9AD \uD074\uB798\uC2A4 \uD615\uC2DD\uC744 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        genericClassDeleted: "\uC81C\uB124\uB9AD \uD074\uB798\uC2A4 \uD615\uC2DD\uC744 \uC0AD\uC81C\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        genericInstanceVariableAccess: "\uD074\uB798\uC2A4\uB97C \uD1B5\uD55C \uC81C\uB124\uB9AD \uC778\uC2A4\uD134\uC2A4 \uBCC0\uC218\uC5D0 \uB300\uD55C \uC561\uC138\uC2A4\uAC00 \uBAA8\uD638\uD569\uB2C8\uB2E4.",
        genericNotAllowed: '\uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C "Generic"\uC774 \uC798\uBABB\uB418\uC5C8\uC2B5\uB2C8\uB2E4.',
        genericTypeAliasBoundTypeVar: "\uD074\uB798\uC2A4 \uB0B4\uC758 \uC81C\uB124\uB9AD \uD615\uC2DD \uBCC4\uCE6D\uC740 \uBC14\uC778\uB529\uB41C \uD615\uC2DD \uBCC0\uC218 {names}\uC744(\uB97C) \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        genericTypeArgMissing: '"Generic"\uC5D0\uB294 \uD558\uB098 \uC774\uC0C1\uC758 \uD615\uC2DD \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.',
        genericTypeArgTypeVar: '"Generic"\uC758 \uD615\uC2DD \uC778\uC218\uB294 \uD615\uC2DD \uBCC0\uC218\uC5EC\uC57C \uD569\uB2C8\uB2E4.',
        genericTypeArgUnique: '"Generic"\uC758 \uD615\uC2DD \uC778\uC218\uB294 \uACE0\uC720\uD574\uC57C \uD569\uB2C8\uB2E4.',
        globalReassignment: 'global \uC120\uC5B8 \uC804\uC5D0 "{name}"\uC774(\uAC00) \uD560\uB2F9\uB418\uC5C8\uC2B5\uB2C8\uB2E4.',
        globalRedefinition: '"{name}"\uC774(\uAC00) \uC774\uBBF8 global\uB85C \uC120\uC5B8\uB418\uC5C8\uC2B5\uB2C8\uB2E4.',
        implicitStringConcat: "\uC554\uC2DC\uC801 \uBB38\uC790\uC5F4 \uC5F0\uACB0\uC774 \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        importCycleDetected: "\uAC00\uC838\uC624\uAE30 \uCCB4\uC778\uC5D0\uC11C \uC21C\uD658\uC774 \uAC80\uC0C9\uB418\uC5C8\uC2B5\uB2C8\uB2E4.",
        importDepthExceeded: "\uAC00\uC838\uC624\uAE30 \uCCB4\uC778 \uAE4A\uC774\uAC00 {depth}\uC744(\uB97C) \uCD08\uACFC\uD588\uC2B5\uB2C8\uB2E4.",
        importResolveFailure: '\uAC00\uC838\uC624\uAE30 "{importName}"\uC744(\uB97C) \uD655\uC778\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        importSourceResolveFailure: '\uC6D0\uBCF8\uC5D0\uC11C \uAC00\uC838\uC624\uAE30 "{importName}"\uC744(\uB97C) \uD655\uC778\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        importSymbolUnknown: '"{name}"\uC740(\uB294) \uC54C \uC218 \uC5C6\uB294 \uAC00\uC838\uC624\uAE30 \uAE30\uD638\uC785\uB2C8\uB2E4.',
        incompatibleMethodOverride: '"{name}" \uBA54\uC11C\uB4DC\uAC00 \uD638\uD658\uB418\uC9C0 \uC54A\uB294 \uBC29\uC2DD\uC73C\uB85C "{className}" \uD074\uB798\uC2A4\uB97C \uC7AC\uC815\uC758\uD569\uB2C8\uB2E4.',
        inconsistentIndent: "\uB4E4\uC5EC\uC4F0\uAE30\uD558\uC9C0 \uC54A\uC740 \uC591\uC774 \uC774\uC804 \uB4E4\uC5EC\uC4F0\uAE30\uC640 \uC77C\uCE58\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        inconsistentTabs: "\uB4E4\uC5EC\uC4F0\uAE30\uC5D0\uC11C \uD0ED \uBC0F \uACF5\uBC31\uC758 \uC77C\uAD00\uC131 \uC5C6\uB294 \uC0AC\uC6A9",
        initMethodSelfParamTypeVar: '"__init__" \uBA54\uC11C\uB4DC\uC758 "self" \uB9E4\uAC1C \uBCC0\uC218\uC5D0 \uB300\uD55C \uD615\uC2DD \uC8FC\uC11D\uC5D0\uB294 \uD074\uB798\uC2A4 \uBC94\uC704 \uD615\uC2DD \uBCC0\uC218\uB97C \uD3EC\uD568\uD560 \uC218 \uC5C6\uC74C',
        initMustReturnNone: '"__init__"\uC758 \uBC18\uD658 \uD615\uC2DD\uC740 None\uC774\uC5B4\uC57C \uD569\uB2C8\uB2E4.',
        initSubclassCallFailed: "__init_subclass__ \uBA54\uC11C\uB4DC\uC758 \uD0A4\uC6CC\uB4DC \uC778\uC218\uAC00 \uC798\uBABB\uB428",
        initSubclassClsParam: '__init_subclass__ \uC7AC\uC815\uC758\uB294 "cls" \uB9E4\uAC1C \uBCC0\uC218\uB97C \uC0AC\uC6A9\uD574\uC57C \uD569\uB2C8\uB2E4.',
        initVarNotAllowed: '\uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C\uB294 "InitVar"\uAC00 \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        instanceMethodSelfParam: '\uC778\uC2A4\uD134\uC2A4 \uBA54\uC11C\uB4DC\uB294 "self" \uB9E4\uAC1C \uBCC0\uC218\uB97C \uC0AC\uC6A9\uD574\uC57C \uD569\uB2C8\uB2E4.',
        instanceVarOverridesClassVar: "\u2018{name}\u2019 \uC778\uC2A4\uD134\uC2A4 \uBCC0\uC218\uAC00 \u2018{className}\u2019 \uD074\uB798\uC2A4\uC5D0\uC11C \uAC19\uC740 \uC774\uB984\uC758 \uD074\uB798\uC2A4 \uBCC0\uC218\uB97C \uC7AC\uC815\uC758\uD569\uB2C8\uB2E4.",
        instantiateAbstract: "'{type}' \uCD94\uC0C1 \uD074\uB798\uC2A4\uB97C \uC778\uC2A4\uD134\uC2A4\uD654\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        instantiateProtocol: 'Protocol \uD074\uB798\uC2A4 "{type}"\uC744(\uB97C) \uC778\uC2A4\uD134\uC2A4\uD654\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        internalBindError: '\uD30C\uC77C "{file}"\uC744(\uB97C) \uBC14\uC778\uB529\uD558\uB294 \uB3D9\uC548 \uB0B4\uBD80 \uC624\uB958\uAC00 \uBC1C\uC0DD\uD588\uC2B5\uB2C8\uB2E4. {message}',
        internalParseError: '\uD30C\uC77C "{file}"\uC744(\uB97C) \uAD6C\uBB38 \uBD84\uC11D\uD558\uB294 \uB3D9\uC548 \uB0B4\uBD80 \uC624\uB958\uAC00 \uBC1C\uC0DD\uD588\uC2B5\uB2C8\uB2E4. {message}',
        internalTypeCheckingError: '\uD30C\uC77C "{file}"\uC758 \uD615\uC2DD\uC744 \uD655\uC778\uD558\uB294 \uB3D9\uC548 \uB0B4\uBD80 \uC624\uB958\uAC00 \uBC1C\uC0DD\uD588\uC2B5\uB2C8\uB2E4. {message}',
        invalidIdentifierChar: "\uC2DD\uBCC4\uC790\uC5D0 \uC798\uBABB\uB41C \uBB38\uC790\uAC00 \uC788\uC2B5\uB2C8\uB2E4.",
        invalidStubStatement: "\uD615\uC2DD stub \uD30C\uC77C \uB0B4\uC5D0\uC11C\uB294 \uBB38\uC774 \uC758\uBBF8\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.",
        invalidTokenChars: "\uD1A0\uD070\uC5D0 \uC798\uBABB\uB41C \uBB38\uC790 \u2018{text}\u2019\uC774(\uAC00) \uC788\uC2B5\uB2C8\uB2E4.",
        isInstanceInvalidType: '"isinstance"\uC5D0 \uB300\uD55C \uB450 \uBC88\uC9F8 \uC778\uC218\uB294 \uD074\uB798\uC2A4 \uB610\uB294 \uD074\uB798\uC2A4\uC758 tuple\uC774\uC5B4\uC57C \uD569\uB2C8\uB2E4.',
        isSubclassInvalidType: '"issubclass"\uC5D0 \uB300\uD55C \uB450 \uBC88\uC9F8 \uC778\uC218\uB294 \uD074\uB798\uC2A4 \uB610\uB294 \uD074\uB798\uC2A4\uC758 tuple\uC774\uC5B4\uC57C \uD569\uB2C8\uB2E4.',
        keyValueInSet: "set \uB0B4\uC5D0\uC11C \uD0A4/\uAC12 \uC30D\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        keywordArgInTypeArgument: "\uD0A4\uC6CC\uB4DC \uC778\uC218\uB294 \uD615\uC2DD \uC778\uC218 \uBAA9\uB85D\uC5D0\uC11C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        keywordOnlyAfterArgs: '\uD0A4\uC6CC\uB4DC \uC804\uC6A9 \uC778\uC218 \uAD6C\uBD84 \uAE30\uD638\uB294 "*" \uB9E4\uAC1C \uBCC0\uC218 \uB4A4\uC5D0 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        keywordParameterMissing: "\uD558\uB098 \uC774\uC0C1\uC758 \uD0A4\uC6CC\uB4DC \uB9E4\uAC1C \uBCC0\uC218\uB294 \u2019*\u2018 \uB9E4\uAC1C \uBCC0\uC218 \uB4A4\uC5D0 \uC640\uC57C \uD569\uB2C8\uB2E4.",
        keywordSubscriptIllegal: "\uC544\uB798 \uCCA8\uC790 \uB0B4\uC758 \uD0A4\uC6CC\uB4DC \uC778\uC218\uB294 \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        lambdaReturnTypePartiallyUnknown: '\uB78C\uB2E4\uC758 \uBC18\uD658 \uD615\uC2DD "{returnType}"\uC744(\uB97C) \uBD80\uBD84\uC801\uC73C\uB85C \uC54C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        lambdaReturnTypeUnknown: "\uB78C\uB2E4\uC758 \uBC18\uD658 \uD615\uC2DD\uC744 \uC54C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        listAssignmentMismatch: '\uD615\uC2DD\uC774 "{type}"\uC778 \uC2DD\uC744 \uB300\uC0C1 \uBAA9\uB85D\uC5D0 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        listInAnnotation: "\uD615\uC2DD \uC2DD\uC5D0\uB294 List \uC2DD\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        literalEmptyArgs: "\u2018Literal\u2019 \uB4A4\uC5D0 \uD558\uB098 \uC774\uC0C1\uC758 \uD615\uC2DD \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        literalNamedUnicodeEscape: '\uBA85\uBA85\uB41C \uC720\uB2C8\uCF54\uB4DC \uC774\uC2A4\uCF00\uC774\uD504 \uC2DC\uD000\uC2A4\uB294 "Literal" \uBB38\uC790\uC5F4 \uC8FC\uC11D\uC5D0\uC11C \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        literalNotAllowed: '\uD615\uC2DD \uC778\uC218\uAC00 \uC5C6\uC73C\uBA74 \uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C "Literal"\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        literalNotCallable: "Literal \uD615\uC2DD\uC740 \uC778\uC2A4\uD134\uC2A4\uD654\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        literalUnsupportedType: '"Literal"\uC758 \uD615\uC2DD \uC778\uC218\uB294 None, \uB9AC\uD130\uB7F4 \uAC12(int, bool, str \uB610\uB294 bytes) \uB610\uB294 enum \uAC12\uC774\uC5B4\uC57C \uD569\uB2C8\uB2E4.',
        matchIncompatible: "Match \uBB38\uC5D0\uB294 Python 3.10 \uC774\uC0C1\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        matchIsNotExhaustive: "match \uBB38 \uB0B4\uC758 \uC0AC\uB840\uB294 \uBAA8\uB4E0 \uAC12\uC744 \uC644\uC804\uD788 \uCC98\uB9AC\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        maxParseDepthExceeded: "\uCD5C\uB300 \uAD6C\uBB38 \uBD84\uC11D \uAE4A\uC774\uB97C \uCD08\uACFC\uD588\uC2B5\uB2C8\uB2E4. \uC2DD\uC744 \uB354 \uC791\uC740 \uD558\uC704 \uC2DD\uC73C\uB85C \uB098\uB204\uAE30",
        memberAccess: '"{type}" \uD074\uB798\uC2A4\uC758 "{name}" \uD2B9\uC131\uC5D0 \uC561\uC138\uC2A4\uD560 \uC218 \uC5C6\uC74C',
        memberDelete: '"{type}" \uD074\uB798\uC2A4\uC758 "{name}" \uD2B9\uC131\uC744 \uC0AD\uC81C\uD560 \uC218 \uC5C6\uC74C',
        memberSet: '"{type}" \uD074\uB798\uC2A4\uC758 "{name}" \uD2B9\uC131\uC5D0 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC74C',
        metaclassConflict: "\uD30C\uC0DD \uD074\uB798\uC2A4\uC758 \uBA54\uD0C0\uD074\uB798\uC2A4\uB294 \uBAA8\uB4E0 \uAE30\uBCF8 \uD074\uB798\uC2A4\uC758 \uBA54\uD0C0\uD074\uB798\uC2A4\uC758 \uC11C\uBE0C\uD074\uB798\uC2A4\uC5EC\uC57C \uD569\uB2C8\uB2E4.",
        metaclassDuplicate: "\uBA54\uD0C0\uD074\uB798\uC2A4\uB97C \uD558\uB098\uB9CC \uC81C\uACF5\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4.",
        metaclassIsGeneric: "\uBA54\uD0C0\uD074\uB798\uC2A4\uB294 \uC81C\uB124\uB9AD\uC77C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        methodNotDefined: '"{name}" \uBA54\uC11C\uB4DC\uAC00 \uC815\uC758\uB418\uC9C0 \uC54A\uC558\uC2B5\uB2C8\uB2E4.',
        methodNotDefinedOnType: '"{name}" \uBA54\uC11C\uB4DC\uAC00 "{type}" \uD615\uC2DD\uC5D0 \uC815\uC758\uB418\uC9C0 \uC54A\uC558\uC2B5\uB2C8\uB2E4.',
        methodOrdering: "\uC77C\uAD00\uB41C \uBA54\uC11C\uB4DC \uC21C\uC11C\uB97C \uB9CC\uB4E4 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        methodOverridden: "\u2018{name}\u2019\uC740(\uB294) \u2018{className}\u2019 \uD074\uB798\uC2A4\uC5D0\uC11C \uAC19\uC740 \uC774\uB984\uC758 \uBA54\uC11C\uB4DC\uB97C \uD638\uD658\uB418\uC9C0 \uC54A\uB294 \u2018{type}\u2019 \uD615\uC2DD\uC73C\uB85C \uC7AC\uC815\uC758\uD569\uB2C8\uB2E4.",
        methodReturnsNonObject: '"{name}" \uBA54\uC11C\uB4DC\uAC00 \uAC1C\uCCB4\uB97C \uBC18\uD658\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        missingSuperCall: '"{methodName}" \uBA54\uC11C\uB4DC\uAC00 \uBD80\uBAA8 \uD074\uB798\uC2A4\uC5D0\uC11C \uAC19\uC740 \uC774\uB984\uC758 \uBA54\uC11C\uB4DC\uB97C \uD638\uCD9C\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        mixingBytesAndStr: "Bytes \uBC0F str \uAC12\uC744 \uC5F0\uACB0\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        moduleAsType: "\uBAA8\uB4C8\uC740 \uD615\uC2DD\uC73C\uB85C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        moduleNotCallable: "\uBAA8\uB4C8\uC744 \uD638\uCD9C\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        moduleUnknownMember: "\u2018{memberName}\u2019\uC740(\uB294) \u2018{moduleName}\u2019 \uBAA8\uB4C8\uC758 \uC54C\uB824\uC9C4 \uD2B9\uC131\uC774 \uC544\uB2D8",
        namedExceptAfterCatchAll: "\uBA85\uBA85\uB41C except \uC808\uC740 catch-all except \uC808 \uB4A4\uC5D0 \uB098\uD0C0\uB0A0 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        namedParamAfterParamSpecArgs: 'ParamSpec args \uB9E4\uAC1C \uBCC0\uC218 \uB4A4\uC5D0 \uD0A4\uC6CC\uB4DC \uB9E4\uAC1C \uBCC0\uC218 "{name}"\uC744(\uB97C) \uC2DC\uADF8\uB2C8\uCC98\uC5D0 \uD45C\uC2DC\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        namedTupleEmptyName: "\uBA85\uBA85\uB41C tuple \uB0B4\uC758 \uC774\uB984\uC740 \uBE44\uC6CC \uB458 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        namedTupleEntryRedeclared: '\uBD80\uBAA8 \uD074\uB798\uC2A4 "{className}"\uC774(\uAC00) \uBA85\uBA85\uB41C tuple\uC774\uBBC0\uB85C "{name}"\uC744(\uB97C) \uC7AC\uC815\uC758\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        namedTupleFieldUnderscore: "Named tuple \uD544\uB4DC \uC774\uB984\uC740 \uBC11\uC904\uB85C \uC2DC\uC791\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4",
        namedTupleFirstArg: "\uBA85\uBA85\uB41C tuple \uD074\uB798\uC2A4 \uC774\uB984\uC774 \uCCAB \uBC88\uC9F8 \uC778\uC218\uB85C \uD544\uC694\uD569\uB2C8\uB2E4.",
        namedTupleMultipleInheritance: "NamedTuple\uC744 \uC0AC\uC6A9\uD55C \uC5EC\uB7EC \uC0C1\uC18D\uC740 \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        namedTupleNameKeyword: "\uD544\uB4DC \uC774\uB984\uC740 \uD0A4\uC6CC\uB4DC\uC77C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        namedTupleNameType: "\uD56D\uBAA9 \uC774\uB984 \uBC0F \uD615\uC2DD\uC744 \uC9C0\uC815\uD558\uB294 2\uAC1C \uD56D\uBAA9 tuple\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        namedTupleNameUnique: "\uBA85\uBA85\uB41C tuple \uB0B4\uC758 \uC774\uB984\uC740 \uACE0\uC720\uD574\uC57C \uD569\uB2C8\uB2E4.",
        namedTupleNoTypes: '"namedtuple"\uC740 tuple \uD56D\uBAA9\uC5D0 \uB300\uD55C \uD615\uC2DD\uC744 \uC81C\uACF5\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4. \uB300\uC2E0 "NamedTuple" \uC0AC\uC6A9',
        namedTupleSecondArg: "\uB450 \uBC88\uC9F8 \uC778\uC218\uB85C \uBA85\uBA85\uB41C tuple \uD56D\uBAA9 list\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        newClsParam: '__new__ \uC7AC\uC815\uC758\uB294 "cls" \uB9E4\uAC1C \uBCC0\uC218\uB97C \uC0AC\uC6A9\uD574\uC57C \uD569\uB2C8\uB2E4.',
        newTypeAnyOrUnknown: "NewType\uC5D0 \uB300\uD55C \uB450 \uBC88\uC9F8 \uC778\uC218\uB294 Any \uB610\uB294 Unknown\uC774 \uC544\uB2CC \uC54C\uB824\uC9C4 \uD074\uB798\uC2A4\uC5EC\uC57C \uD569\uB2C8\uB2E4.",
        newTypeBadName: "NewType\uC758 \uCCAB \uBC88\uC9F8 \uC778\uC218\uB294 \uBB38\uC790\uC5F4 \uB9AC\uD130\uB7F4\uC774\uC5B4\uC57C \uD569\uB2C8\uB2E4.",
        newTypeLiteral: "NewType\uC740 Literal \uD615\uC2DD\uACFC \uD568\uAED8 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        newTypeNameMismatch: "NewType\uC740 \uC774\uB984\uC774 \uAC19\uC740 \uBCC0\uC218\uC5D0 \uD560\uB2F9\uB418\uC5B4\uC57C \uD569\uB2C8\uB2E4.",
        newTypeNotAClass: "NewType\uC5D0 \uB300\uD55C \uB450 \uBC88\uC9F8 \uC778\uC218\uB85C \uD074\uB798\uC2A4\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        newTypeParamCount: "NewType\uC5D0\uB294 \uB450 \uAC1C\uC758 \uC704\uCE58 \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        newTypeProtocolClass: "\uAD6C\uC870 \uD615\uC2DD(Protocol \uB610\uB294 TypedDict \uD074\uB798\uC2A4)\uACFC \uD568\uAED8 NewType\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        noOverload: '\uC81C\uACF5\uB41C \uC778\uC218\uC640 \uC77C\uCE58\uD558\uB294 "{name}"\uC5D0 \uB300\uD55C \uC624\uBC84\uB85C\uB4DC\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.',
        noReturnContainsReturn: '\uC120\uC5B8\uB41C return \uD615\uC2DD\uC774 "NoReturn"\uC778 \uD568\uC218\uB294 return \uBB38\uC744 \uD3EC\uD568\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        noReturnContainsYield: '\uC120\uC5B8\uB41C \uBC18\uD658 \uD615\uC2DD\uC774 "NoReturn"\uC778 \uD568\uC218\uB294 yield \uBB38\uC744 \uD3EC\uD568\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        noReturnReturnsNone: '\uC120\uC5B8\uB41C \uBC18\uD658 \uD615\uC2DD\uC774 "NoReturn"\uC778 \uD568\uC218\uB294 "None"\uC744 \uBC18\uD658\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        nonDefaultAfterDefault: "\uAE30\uBCF8\uAC12\uC774 \uC544\uB2CC \uC778\uC218\uAC00 \uAE30\uBCF8 \uC778\uC218\uB97C \uB530\uB985\uB2C8\uB2E4.",
        nonLocalInModule: "\uBAA8\uB4C8 \uC218\uC900\uC5D0\uC11C\uB294 Nonlocal \uC120\uC5B8\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        nonLocalNoBinding: 'No binding for nonlocal "{name}" found',
        nonLocalReassignment: '"{name}" is assigned before nonlocal declaration',
        nonLocalRedefinition: '"{name}"\uC774(\uAC00) \uC774\uBBF8 nonlocal\uB85C \uC120\uC5B8\uB418\uC5C8\uC2B5\uB2C8\uB2E4.',
        noneNotCallable: "\u2018None\u2019 \uC720\uD615\uC758 \uAC1C\uCCB4\uB97C \uD638\uCD9C\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        noneNotIterable: '"None" \uD615\uC2DD\uC758 \uAC1C\uCCB4\uB294 \uBC18\uBCF5 \uAC00\uB2A5\uD55C \uAC12\uC73C\uB85C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        noneNotSubscriptable: "\u2019None\u2019 \uC720\uD615\uC758 \uAC1C\uCCB4\uB294 \uC544\uB798 \uCCA8\uC790\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        noneNotUsableWith: 'Object of type "None" cannot be used with "with"',
        noneNotUsableWithAsync: '"None" \uD615\uC2DD\uC758 \uAC1C\uCCB4\uB294 "async with"\uC640 \uD568\uAED8 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        noneOperator: '"None"\uC5D0 \uB300\uD574 \uC5F0\uC0B0\uC790 "{operator}"\uC774(\uAC00) \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        noneUnknownMember: '"{name}"\uC740(\uB294) "None"\uC758 \uC54C\uB824\uC9C4 \uD2B9\uC131\uC774 \uC544\uB2D8',
        nonlocalTypeParam: 'Nonlocal \uBC14\uC778\uB529\uC740 \uD615\uC2DD \uB9E4\uAC1C\uBCC0\uC218 "{name}"\uC5D0 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        notRequiredArgCount: '"NotRequired" \uB4A4\uC5D0 \uB2E8\uC77C \uD615\uC2DD \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.',
        notRequiredNotInTypedDict: '\uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C\uB294 "NotRequired"\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        objectNotCallable: '"{type}" \uD615\uC2DD\uC758 \uAC1C\uCCB4\uB97C \uD638\uCD9C\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        obscuredClassDeclaration: '\uD074\uB798\uC2A4 \uC120\uC5B8 "{name}"\uC774(\uAC00) \uAC19\uC740 \uC774\uB984\uC758 \uC120\uC5B8\uC73C\uB85C \uAC00\uB824\uC838 \uC788\uC2B5\uB2C8\uB2E4.',
        obscuredFunctionDeclaration: '\uD568\uC218 \uC120\uC5B8 "{name}"\uC774(\uAC00) \uB3D9\uC77C\uD55C \uC774\uB984\uC758 \uC120\uC5B8\uC73C\uB85C \uAC00\uB824\uC9D1\uB2C8\uB2E4.',
        obscuredMethodDeclaration: '\uBA54\uC11C\uB4DC \uC120\uC5B8 "{name}"\uC774(\uAC00) \uB3D9\uC77C\uD55C \uC774\uB984\uC758 \uC120\uC5B8\uC73C\uB85C \uAC00\uB824\uC9D1\uB2C8\uB2E4.',
        obscuredParameterDeclaration: '\uB9E4\uAC1C \uBCC0\uC218 \uC120\uC5B8 "{name}"\uC774(\uAC00) \uB3D9\uC77C\uD55C \uC774\uB984\uC758 \uC120\uC5B8\uC73C\uB85C \uAC00\uB824\uC9D1\uB2C8\uB2E4.',
        obscuredTypeAliasDeclaration: '\uD615\uC2DD \uBCC4\uCE6D \uC120\uC5B8 "{name}"\uC774(\uAC00) \uB3D9\uC77C\uD55C \uC774\uB984\uC758 \uC120\uC5B8\uC73C\uB85C \uAC00\uB824\uC9D1\uB2C8\uB2E4.',
        obscuredVariableDeclaration: '"{name}" \uC120\uC5B8\uC774 \uAC19\uC740 \uC774\uB984\uC758 \uC120\uC5B8\uC73C\uB85C \uAC00\uB824\uC9D1\uB2C8\uB2E4.',
        operatorLessOrGreaterDeprecated: '"<>" \uC5F0\uC0B0\uC790\uB294 Python 3\uC5D0\uC11C \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4. \uB300\uC2E0 "!="\uB97C \uC0AC\uC6A9\uD558\uC138\uC694.',
        optionalExtraArgs: '"Optional" \uB4A4\uC5D0 1\uAC1C\uC758 \uD615\uC2DD \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.',
        orPatternIrrefutable: "\uB418\uB3CC\uB9B4 \uC218 \uC5C6\uB294 \uD328\uD134\uC740 \u2018or\u2019 \uD328\uD134\uC758 \uB9C8\uC9C0\uB9C9 \uD558\uC704 \uD398\uC774\uC9C0\uB85C\uB9CC \uD5C8\uC6A9\uB429\uB2C8\uB2E4.",
        orPatternMissingName: '"or" \uD328\uD134 \uB0B4\uC758 \uBAA8\uB4E0 \uD558\uC704 \uD328\uD134\uC740 \uB3D9\uC77C\uD55C \uC774\uB984\uC744 \uB300\uC0C1\uC73C\uB85C \uD574\uC57C \uD569\uB2C8\uB2E4.',
        overlappingKeywordArgs: "\uD615\uC2DD\uD654\uB41C \uC0AC\uC804\uC774 \uD0A4\uC6CC\uB4DC \uB9E4\uAC1C \uBCC0\uC218 {names}\uACFC(\uC640) \uACB9\uCE69\uB2C8\uB2E4.",
        overlappingOverload: '\uB9E4\uAC1C \uBCC0\uC218\uAC00 \uC624\uBC84\uB85C\uB4DC {obscuredBy}\uACFC(\uC640) \uACB9\uCE58\uBBC0\uB85C "{name}"\uC5D0 \uB300\uD55C \uC624\uBC84\uB85C\uB4DC {obscured}\uC774(\uAC00) \uC0AC\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        overloadAbstractImplMismatch: "\uC624\uBC84\uB85C\uB4DC\uB294 \uAD6C\uD604\uC758 \uCD94\uC0C1 \uC0C1\uD0DC\uC640 \uC77C\uCE58\uD574\uC57C \uD569\uB2C8\uB2E4.",
        overloadAbstractMismatch: "\uC624\uBC84\uB85C\uB4DC\uB294 \uBAA8\uB450 \uCD94\uC0C1\uC774\uAC70\uB098 \uC544\uB2C8\uC5B4\uC57C \uD569\uB2C8\uB2E4",
        overloadClassMethodInconsistent: '"{name}"\uC758 \uC624\uBC84\uB85C\uB4DC\uAC00 @classmethod\uB97C \uC77C\uAD00\uB418\uC9C0 \uC54A\uAC8C \uC0AC\uC6A9\uD569\uB2C8\uB2E4.',
        overloadFinalImpl: "@final \uB370\uCF54\uB808\uC774\uD130\uB294 \uAD6C\uD604\uC5D0\uB9CC \uC801\uC6A9\uD574\uC57C \uD569\uB2C8\uB2E4.",
        overloadFinalNoImpl: "\uCCAB \uBC88\uC9F8 \uC624\uBC84\uB85C\uB4DC\uB9CC @final \uD45C\uC2DC\uD574\uC57C \uD569\uB2C8\uB2E4.",
        overloadImplementationMismatch: "\uC624\uBC84\uB85C\uB4DC\uB41C \uAD6C\uD604\uC774 \uC624\uBC84\uB85C\uB4DC {index}\uC758 \uC2DC\uADF8\uB2C8\uCC98\uC640 \uC77C\uCE58\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        overloadOverrideImpl: "@override \uB370\uCF54\uB808\uC774\uD130\uB294 \uAD6C\uD604\uC5D0\uB9CC \uC801\uC6A9\uD574\uC57C \uD569\uB2C8\uB2E4.",
        overloadOverrideNoImpl: "\uCCAB \uBC88\uC9F8 \uC624\uBC84\uB85C\uB4DC\uB9CC @override \uD45C\uC2DC\uD574\uC57C \uD569\uB2C8\uB2E4.",
        overloadReturnTypeMismatch: '"{name}"\uC5D0 \uB300\uD55C {prevIndex} \uC624\uBC84\uB85C\uB4DC\uAC00 \uC624\uBC84\uB85C\uB4DC {newIndex}\uACFC(\uC640) \uACB9\uCE58\uACE0 \uD638\uD658\uB418\uC9C0 \uC54A\uB294 \uD615\uC2DD\uC744 \uBC18\uD658\uD569\uB2C8\uB2E4.',
        overloadStaticMethodInconsistent: '"{name}"\uC758 \uC624\uBC84\uB85C\uB4DC\uAC00 @staticmethod\uB97C \uC77C\uAD00\uB418\uC9C0 \uC54A\uAC8C \uC0AC\uC6A9\uD569\uB2C8\uB2E4.',
        overloadWithoutImplementation: "\u201C{name}\u201C\uC774(\uAC00) overload\uB85C \uD45C\uC2DC\uB418\uC5B4 \uC788\uC9C0\uB9CC \uAD6C\uD604\uC774 \uC81C\uACF5\uB418\uC9C0 \uC54A\uC558\uC2B5\uB2C8\uB2E4.",
        overriddenMethodNotFound: "\u201C{name}\u201C \uBA54\uC11C\uB4DC\uAC00 override\uB85C \uD45C\uC2DC\uB418\uC5B4 \uC788\uC9C0\uB9CC \uC774\uB984\uC774 \uAC19\uC740 \uAE30\uBCF8 \uBA54\uC11C\uB4DC\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.",
        overrideDecoratorMissing: "\u201C{name}\u201C \uBA54\uC11C\uB4DC\uAC00 override\uB85C \uD45C\uC2DC\uB418\uC9C0 \uC54A\uC558\uC9C0\uB9CC \u201C{className}\u201C \uD074\uB798\uC2A4\uC5D0\uC11C \uBA54\uC11C\uB4DC\uB97C \uC7AC\uC815\uC758\uD558\uACE0 \uC788\uC2B5\uB2C8\uB2E4.",
        paramAfterKwargsParam: "\uB9E4\uAC1C \uBCC0\uC218\uB294 \u2018**\u2019 \uB9E4\uAC1C \uBCC0\uC218 \uB2E4\uC74C\uC5D0 \uC640\uC57C \uD569\uB2C8\uB2E4.",
        paramAlreadyAssigned: '\uB9E4\uAC1C \uBCC0\uC218 "{name}"\uC774(\uAC00) \uC774\uBBF8 \uD560\uB2F9\uB418\uC5C8\uC2B5\uB2C8\uB2E4.',
        paramAnnotationMissing: "\u2018{name}\u2019 \uB9E4\uAC1C \uBCC0\uC218\uC5D0 \uB300\uD55C \uD615\uC2DD \uC8FC\uC11D\uC774 \uC5C6\uC2B5\uB2C8\uB2E4.",
        paramAssignmentMismatch: "\u2018{sourceType}\u2019 \uD615\uC2DD\uC758 \uC2DD\uC744 \u2018{paramType}\u2019 \uD615\uC2DD\uC758 \uB9E4\uAC1C \uBCC0\uC218\uC5D0 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        paramNameMissing: '\uC774\uB984\uC774 "{name}"\uC778 \uB9E4\uAC1C \uBCC0\uC218\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.',
        paramSpecArgsKwargsDuplicate: 'ParamSpec "{type}" \uC778\uC218\uAC00 \uC774\uBBF8 \uC81C\uACF5\uB418\uC5C8\uC2B5\uB2C8\uB2E4.',
        paramSpecArgsKwargsUsage: 'ParamSpec\uC758 "args" \uBC0F "kwargs" \uD2B9\uC131\uC740 \uBAA8\uB450 \uD568\uC218 \uC11C\uBA85 \uB0B4\uC5D0 \uB098\uD0C0\uB098\uC57C \uD568',
        paramSpecArgsMissing: 'ParamSpec "{type}"\uC5D0 \uB300\uD55C \uC778\uC218\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.',
        paramSpecArgsUsage: 'ParamSpec\uC758 "args" \uD2B9\uC131\uC740 *args \uB9E4\uAC1C \uBCC0\uC218\uC640 \uD568\uAED8 \uC0AC\uC6A9\uD560 \uACBD\uC6B0\uC5D0\uB9CC \uC720\uD6A8\uD568',
        paramSpecAssignedName: 'ParamSpec\uC744 "{name}"\uC774\uB77C\uB294 \uBCC0\uC218\uC5D0 \uD560\uB2F9\uD574\uC57C \uD569\uB2C8\uB2E4.',
        paramSpecContext: "ParamSpec\uC740 \uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        paramSpecDefaultNotTuple: "ParamSpec\uC758 \uAE30\uBCF8\uAC12\uC5D0\uB294 \uC904\uC784\uD45C, tuple \uC2DD \uB610\uB294 ParamSpec\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        paramSpecFirstArg: "\uCCAB \uBC88\uC9F8 \uC778\uC218\uB85C ParamSpec\uC758 \uC774\uB984\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        paramSpecKwargsUsage: 'ParamSpec\uC758 "kwargs" \uD2B9\uC131\uC740 **kwargs \uB9E4\uAC1C \uBCC0\uC218\uC640 \uD568\uAED8 \uC0AC\uC6A9\uD560 \uACBD\uC6B0\uC5D0\uB9CC \uC720\uD6A8\uD568',
        paramSpecNotUsedByOuterScope: 'ParamSpec "{name}"\uC740(\uB294) \uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C \uC758\uBBF8\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.',
        paramSpecUnknownArg: "ParamSpec\uC740 \uD55C \uAC1C \uC774\uC0C1\uC758 \uC778\uC218\uB97C \uC9C0\uC6D0\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        paramSpecUnknownMember: '"{name}"\uC740(\uB294) ParamSpec\uC758 \uC54C\uB824\uC9C4 \uD2B9\uC131\uC774 \uC544\uB2D8',
        paramSpecUnknownParam: "\u2018{name}\u2019\uC740(\uB294) ParamSpec\uC5D0 \uB300\uD55C \uC54C \uC218 \uC5C6\uB294 \uB9E4\uAC1C \uBCC0\uC218\uC785\uB2C8\uB2E4.",
        paramTypeCovariant: "\uACF5\uBCC0(Covariant) \uD615\uC2DD \uBCC0\uC218\uB294 \uB9E4\uAC1C \uBCC0\uC218 \uD615\uC2DD\uC5D0 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        paramTypePartiallyUnknown: '\uB9E4\uAC1C \uBCC0\uC218 "{paramName}"\uC758 \uD615\uC2DD\uC744 \uBD80\uBD84\uC801\uC73C\uB85C \uC54C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        paramTypeUnknown: '\uB9E4\uAC1C \uBCC0\uC218 "{paramName}"\uC758 \uD615\uC2DD\uC744 \uC54C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        parenthesizedContextManagerIllegal: 'Parentheses within "with" statement requires Python 3.9 or newer',
        patternNeverMatches: '\uC81C\uBAA9 \uD615\uC2DD "{type}"\uC5D0 \uB300\uD574 \uD328\uD134\uC774 \uC77C\uCE58\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        positionArgAfterNamedArg: "\uC704\uCE58 \uC778\uC218\uB294 \uD0A4\uC6CC\uB4DC \uC778\uC218 \uB4A4\uC5D0 \uB098\uD0C0\uB0A0 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        positionArgAfterUnpackedDictArg: "\uC704\uCE58 \uC778\uC218\uB294 \uD0A4\uC6CC\uB4DC \uC778\uC218 \uC555\uCD95 \uD574\uC81C \uD6C4\uC5D0 \uB098\uD0C0\uB0A0 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        positionOnlyAfterArgs: '\uC704\uCE58 \uC804\uC6A9 \uB9E4\uAC1C \uBCC0\uC218 \uAD6C\uBD84 \uAE30\uD638\uB294 "*" \uB9E4\uAC1C \uBCC0\uC218 \uB4A4\uC5D0 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        positionOnlyAfterKeywordOnly: '"/" \uB9E4\uAC1C \uBCC0\uC218\uB294 "*" \uB9E4\uAC1C \uBCC0\uC218 \uC55E\uC5D0 \uB098\uD0C0\uB098\uC57C \uD569\uB2C8\uB2E4.',
        positionOnlyAfterNon: "\uC704\uCE58 \uC804\uC6A9\uC774 \uC544\uB2CC \uB9E4\uAC1C \uBCC0\uC218 \uB2E4\uC74C\uC5D0\uB294 \uC704\uCE58 \uC804\uC6A9 \uB9E4\uAC1C \uBCC0\uC218\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        positionOnlyFirstParam: "\uC704\uCE58 \uC804\uC6A9 \uB9E4\uAC1C \uBCC0\uC218 \uAD6C\uBD84 \uAE30\uD638\uB294 \uCCAB \uBC88\uC9F8 \uB9E4\uAC1C \uBCC0\uC218\uB85C \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        positionOnlyIncompatible: "\uC704\uCE58 \uC804\uC6A9 \uB9E4\uAC1C \uBCC0\uC218 \uAD6C\uBD84 \uAE30\uD638\uC5D0\uB294 Python 3.8 \uC774\uC0C1\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        privateImportFromPyTypedModule: '"{name}"\uC740(\uB294) "{module}" \uBAA8\uB4C8\uC5D0\uC11C \uB0B4\uBCF4\uB0B4\uC9C0\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        privateUsedOutsideOfClass: '"{name}"\uC740(\uB294) \uD504\uB77C\uC774\uBE57\uC774\uBA70 \uC120\uC5B8\uB41C \uD074\uB798\uC2A4 \uC678\uBD80\uC5D0\uC11C \uC0AC\uC6A9\uB429\uB2C8\uB2E4.',
        privateUsedOutsideOfModule: '"{name}"\uC740(\uB294) \uD504\uB77C\uC774\uBE57\uC774\uBA70 \uC120\uC5B8\uB41C \uBAA8\uB4C8 \uC678\uBD80\uC5D0\uC11C \uC0AC\uC6A9\uB429\uB2C8\uB2E4.',
        propertyOverridden: "\u201C{name}\u201C\uC740(\uB294) \u201C{className}\u201C \uD074\uB798\uC2A4\uC5D0\uC11C \uAC19\uC740 \uC774\uB984\uC758 property\uB97C \uC798\uBABB \uC7AC\uC815\uC758\uD569\uB2C8\uB2E4.",
        propertyStaticMethod: "Static methods not allowed for property getter, setter or deleter",
        protectedUsedOutsideOfClass: "\u2018{name}\u2019\uC740(\uB294) \uC120\uC5B8\uB41C \uD074\uB798\uC2A4 \uC678\uBD80\uC5D0\uC11C \uBCF4\uD638\uB418\uACE0 \uC0AC\uC6A9\uB429\uB2C8\uB2E4.",
        protocolBaseClass: 'Protocol \uD074\uB798\uC2A4 "{classType}"\uC740(\uB294) Protocol \uC544\uB2CC \uD074\uB798\uC2A4 "{baseType}"\uC5D0\uC11C \uD30C\uC0DD\uB420 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        protocolBaseClassWithTypeArgs: "\uD615\uC2DD \uB9E4\uAC1C \uBCC0\uC218 \uAD6C\uBB38\uC744 \uC0AC\uC6A9\uD560 \uB54C\uB294 Protocol \uD074\uB798\uC2A4\uC5D0 \uD615\uC2DD \uC778\uC218\uAC00 \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        protocolIllegal: '"Protocol"\uC744 \uC0AC\uC6A9\uD558\uB824\uBA74 Python 3.7 \uC774\uC0C1\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.',
        protocolNotAllowed: '\uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C\uB294 "Protocol"\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        protocolTypeArgMustBeTypeParam: '"Protocol"\uC758 \uD615\uC2DD \uC778\uC218\uB294 \uD615\uC2DD \uB9E4\uAC1C \uBCC0\uC218\uC5EC\uC57C \uD569\uB2C8\uB2E4.',
        protocolUnsafeOverlap: '\uD074\uB798\uC2A4\uAC00 "{name}"\uACFC(\uC640) \uC548\uC804\uD558\uC9C0 \uC54A\uAC8C \uACB9\uCE58\uBA70 \uB7F0\uD0C0\uC784\uC5D0 \uC77C\uCE58 \uD56D\uBAA9\uC744 \uC0DD\uC131\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4.',
        protocolVarianceContravariant: '\uC81C\uB124\uB9AD Protocol "{class}"\uC5D0 \uC0AC\uC6A9\uB418\uB294 \uD615\uC2DD \uBCC0\uC218 "{variable}"\uC740(\uB294) \uBC18\uACF5\uBCC0\uC774\uC5B4\uC57C \uD569\uB2C8\uB2E4.',
        protocolVarianceCovariant: '\uC81C\uB124\uB9AD Protocol "{class}"\uC5D0 \uC0AC\uC6A9\uB418\uB294 \uD615\uC2DD \uBCC0\uC218 "{variable}"\uC740(\uB294) \uACF5\uBCC0(covariant)\uC774\uC5B4\uC57C \uD569\uB2C8\uB2E4.',
        protocolVarianceInvariant: '\uC81C\uB124\uB9AD Protocol "{class}"\uC5D0 \uC0AC\uC6A9\uB418\uB294 \uD615\uC2DD \uBCC0\uC218 "{variable}"\uC740(\uB294) \uACE0\uC815\uB418\uC5B4\uC57C \uD569\uB2C8\uB2E4.',
        pyrightCommentInvalidDiagnosticBoolValue: 'Pyright \uC8FC\uC11D \uC9C0\uC2DC\uBB38 \uB4A4\uC5D0\uB294 "="\uC640 true \uB610\uB294 false \uAC12\uC774 \uC640\uC57C \uD569\uB2C8\uB2E4.',
        pyrightCommentInvalidDiagnosticSeverityValue: 'Pyright \uC8FC\uC11D \uC9C0\uC2DC\uBB38 \uB4A4\uC5D0\uB294 "="\uC640 true, false, error, warning, information \uB610\uB294 none \uAC12\uC774 \uC640\uC57C \uD569\uB2C8\uB2E4.',
        pyrightCommentMissingDirective: "Pyright \uBA54\uBAA8 \uB4A4\uC5D0\uB294 \uC9C0\uC2DC\uBB38(basic \uB610\uB294 strict) \uB610\uB294 \uC9C4\uB2E8 \uADDC\uCE59\uC774 \uC788\uC5B4\uC57C \uD569\uB2C8\uB2E4.",
        pyrightCommentNotOnOwnLine: "\uD30C\uC77C \uC218\uC900 \uC124\uC815\uC744 \uC81C\uC5B4\uD558\uB294 \uB370 \uC0AC\uC6A9\uB418\uB294Pyright \uC8FC\uC11D\uC740 \uACE0\uC720\uC758 \uC904\uC5D0 \uD45C\uC2DC\uB418\uC5B4\uC57C \uD569\uB2C8\uB2E4.",
        pyrightCommentUnknownDiagnosticRule: '"{rule}"\uC740(\uB294) pyright \uC8FC\uC11D\uC5D0 \uB300\uD55C \uC54C \uC218 \uC5C6\uB294 \uC9C4\uB2E8 \uADDC\uCE59\uC785\uB2C8\uB2E4.',
        pyrightCommentUnknownDiagnosticSeverityValue: '"{value}"\uC774(\uAC00) pyright \uC8FC\uC11D\uC5D0 \uB300\uD574 \uC798\uBABB\uB41C \uAC12\uC785\uB2C8\uB2E4. true, false, error, warning, information \uB610\uB294 none\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.',
        pyrightCommentUnknownDirective: '"{directive}" is an unknown directive for pyright comment; expected "strict", "standard", or "basic"',
        readOnlyArgCount: "\u2018ReadOnly\u2018 \uB4A4\uC5D0\uB294 \uB2E8\uC77C \uD615\uC2DD \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        readOnlyNotInTypedDict: '\uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C\uB294 "ReadOnly"\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        recursiveDefinition: "\u2018{name}\u2019 \uD615\uC2DD\uC774 \uC2A4\uC2A4\uB85C\uB97C \uCC38\uC870\uD558\uBBC0\uB85C \uD655\uC778\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        relativeImportNotAllowed: '\uC0C1\uB300 \uAC00\uC838\uC624\uAE30\uB294 "import .a" \uC591\uC2DD\uACFC \uD568\uAED8 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4. \uB300\uC2E0 "from . import a"\uC744(\uB97C) \uC0AC\uC6A9\uD569\uB2C8\uB2E4.',
        requiredArgCount: "\u2018Required\u2019 \uB4A4\uC5D0 \uB2E8\uC77C \uD615\uC2DD \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        requiredNotInTypedDict: '\uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C\uB294 "Required"\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        returnInAsyncGenerator: "\uAC12\uC774 \uC788\uB294 Return \uBB38\uC740 async \uC0DD\uC131\uAE30\uC5D0\uC11C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        returnInExceptionGroup: '"except*" \uBE14\uB85D\uC5D0\uB294 "return"\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4',
        returnMissing: '\uC120\uC5B8\uB41C \uBC18\uD658 \uD615\uC2DD\uC774 "{returnType}"\uC778 \uD568\uC218\uB294 \uBAA8\uB4E0 \uCF54\uB4DC \uACBD\uB85C\uC5D0\uC11C \uAC12\uC744 \uBC18\uD658\uD574\uC57C \uD569\uB2C8\uB2E4.',
        returnOutsideFunction: "\u2018return\u2019\uC740 \uD568\uC218 \uB0B4\uC5D0\uC11C\uB9CC \uC0AC\uC6A9\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4.",
        returnTypeContravariant: "\uBC18\uACF5\uBCC0 \uC720\uD615 \uBCC0\uC218\uB294 \uBC18\uD658 \uD615\uC2DD\uC5D0 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        returnTypeMismatch: '\uD615\uC2DD "{exprType}"\uC744 \uD615\uC2DD "{returnType}"\uC5D0 \uBC18\uD658\uD558\uB3C4\uB85D \uD560\uB2F9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        returnTypePartiallyUnknown: '\uBC18\uD658 \uD615\uC2DD "{returnType}"\uC744(\uB97C) \uBD80\uBD84\uC801\uC73C\uB85C \uC54C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        returnTypeUnknown: "\uBC18\uD658 \uC720\uD615\uC744 \uC54C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        revealLocalsArgs: "\u2018reveal_locals\u2019 \uD638\uCD9C\uC740 \uC778\uC218\uAC00 \uD544\uC694\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        revealLocalsNone: "\uC774 \uBC94\uC704\uC5D0 locals\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.",
        revealTypeArgs: '"reveal_type" \uD638\uCD9C\uC5D0\uB294 \uB2E8\uC77C \uC704\uCE58 \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.',
        revealTypeExpectedTextArg: "\u2018reveal_type\u2019 \uD568\uC218\uC758 \u2018expected_text\u2019 \uC778\uC218\uB294 str \uB9AC\uD130\uB7F4 \uAC12\uC774\uC5B4\uC57C \uD569\uB2C8\uB2E4.",
        revealTypeExpectedTextMismatch: '\uD14D\uC2A4\uD2B8 \uD615\uC2DD\uC774 \uC77C\uCE58\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4. "{expected}"\uC774(\uAC00) \uD544\uC694\uD558\uC9C0\uB9CC "{received}"\uC744(\uB97C) \uBC1B\uC558\uC2B5\uB2C8\uB2E4.',
        revealTypeExpectedTypeMismatch: "\uD14D\uC2A4\uD2B8 \uD615\uC2DD\uC774 \uC77C\uCE58\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4. \u2018{expected}\u2019\uC774(\uAC00) \uD544\uC694\uD558\uC9C0\uB9CC \u2018{received}\u2019\uC744(\uB97C) \uBC1B\uC558\uC2B5\uB2C8\uB2E4.",
        selfTypeContext: '\uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C\uB294 "Self"\uAC00 \uC798\uBABB\uB418\uC5C8\uC2B5\uB2C8\uB2E4.',
        selfTypeMetaclass: '\uBA54\uD0C0\uD074\uB798\uC2A4("type"\uC758 \uC11C\uBE0C\uD074\uB798\uC2A4) \uB0B4\uC5D0\uC11C "Self"\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        selfTypeWithTypedSelfOrCls: `"Self"\uB294 "Self" \uC774\uC678\uC758 \uD615\uC2DD \uC8FC\uC11D\uC774 \uC788\uB294 'self' \uB610\uB294 'cls' \uB9E4\uAC1C \uBCC0\uC218\uAC00 \uC788\uB294 \uD568\uC218\uC5D0\uC11C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.`,
        sentinelBadName: "The first argument to Sentinel must be a string literal",
        sentinelNameMismatch: "Sentinel must be assigned to a variable with the same name",
        sentinelParamCount: "Sentinel requires one positional argument",
        setterGetterTypeMismatch: "Property setter \uAC12 \uD615\uC2DD\uC744 getter \uBC18\uD658 \uD615\uC2DD\uC5D0 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        singleOverload: '"{name}"\uC774(\uAC00) \uC624\uBC84\uB85C\uB4DC\uB85C \uD45C\uC2DC\uB418\uC5C8\uC9C0\uB9CC \uCD94\uAC00 \uC624\uBC84\uB85C\uB4DC\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.',
        slotsAttributeError: "__slots__\uC5D0\uC11C \u2018{name}\u2019\uC774(\uAC00) \uC9C0\uC815\uB418\uC9C0 \uC54A\uC558\uC2B5\uB2C8\uB2E4.",
        slotsClassVarConflict: "\u2018{name}\u2018\uC774(\uAC00) __slots__\uC5D0 \uC120\uC5B8\uB41C instance \uBCC0\uC218\uC640 \uCDA9\uB3CC\uD569\uB2C8\uB2E4.",
        starPatternInAsPattern: '\uBCC4 \uBB34\uB2AC\uB294 "as" \uB300\uC0C1\uACFC \uD568\uAED8 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        starPatternInOrPattern: "\uBCC4 \uBB34\uB2AC\uB294 \uB2E4\uB978 \uD328\uD134 \uB0B4\uC5D0\uC11C ORed\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        starStarWildcardNotAllowed: '**\uB294 \uC640\uC77C\uB4DC\uCE74\uB4DC "_"\uC640 \uD568\uAED8 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        staticClsSelfParam: '\uC815\uC801 \uBA54\uC11C\uB4DC\uB294 "self" \uB610\uB294 "cls" \uB9E4\uAC1C \uBCC0\uC218\uB97C \uC0AC\uC6A9\uD558\uBA74 \uC548 \uB429\uB2C8\uB2E4.',
        stringNonAsciiBytes: "ASCII\uAC00 \uC544\uB2CC \uBB38\uC790\uB294 \uBC14\uC774\uD2B8 \uBB38\uC790\uC5F4 \uB9AC\uD130\uB7F4\uC5D0 \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        stringNotSubscriptable: "\uD615\uC2DD \uC2DD\uC5D0\uC11C\uB294 \uBB38\uC790\uC5F4 \uC2DD\uC744 \uCCA8\uC790\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4. \uC804\uCCB4 \uC2DD\uC744 \uB530\uC634\uD45C\uB85C \uBB36\uC2B5\uB2C8\uB2E4.",
        stringUnsupportedEscape: "\uBB38\uC790\uC5F4 \uB9AC\uD130\uB7F4\uC5D0 \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uB294 \uC774\uC2A4\uCF00\uC774\uD504 \uC2DC\uD000\uC2A4\uAC00 \uC788\uC2B5\uB2C8\uB2E4.",
        stringUnterminated: "\uBB38\uC790\uC5F4 \uB9AC\uD130\uB7F4\uC774 \uC885\uB8CC\uB418\uC9C0 \uC54A\uC558\uC2B5\uB2C8\uB2E4.",
        stubFileMissing: '"{importName}"\uC5D0 \uB300\uD55C stub \uD30C\uC77C\uC744 \uCC3E\uC744 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        stubUsesGetAttr: '\uD615\uC2DD stub \uD30C\uC77C\uC774 \uBD88\uC644\uC804\uD569\uB2C8\uB2E4. "__getattr__"\uB294 \uBAA8\uB4C8\uC5D0 \uB300\uD55C \uD615\uC2DD \uC624\uB958\uB97C \uBAA8\uD638\uD558\uAC8C \uD569\uB2C8\uB2E4.',
        sublistParamsIncompatible: "Sublist \uB9E4\uAC1C \uBCC0\uC218\uB294 Python 3.x\uC5D0\uC11C \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        superCallArgCount: "\u2018super\u2019 \uD638\uCD9C\uC5D0\uB294 \uC778\uC218\uAC00 2\uAC1C \uC774\uD558\uC5EC\uC57C \uD569\uB2C8\uB2E4.",
        superCallFirstArg: '"super" \uD638\uCD9C\uC5D0 \uB300\uD55C \uCCAB \uBC88\uC9F8 \uC778\uC218\uB85C \uD074\uB798\uC2A4 \uD615\uC2DD\uC774 \uD544\uC694\uD558\uC9C0\uB9CC "{type}"\uC744(\uB97C) \uBC1B\uC558\uC2B5\uB2C8\uB2E4.',
        superCallSecondArg: '"super" \uD638\uCD9C\uC5D0 \uB300\uD55C \uB450 \uBC88\uC9F8 \uC778\uC218\uB294 "{type}"\uC5D0\uC11C \uD30C\uC0DD\uB41C \uAC1C\uCCB4 \uB610\uB294 \uD074\uB798\uC2A4\uC5EC\uC57C \uD569\uB2C8\uB2E4.',
        superCallZeroArgForm: '"super" \uD638\uCD9C\uC758 \uC778\uC218\uAC00 0\uC778 \uD615\uC2DD\uC740 \uBA54\uC11C\uB4DC \uB0B4\uC5D0\uC11C\uB9CC \uC720\uD6A8\uD569\uB2C8\uB2E4.',
        superCallZeroArgFormStaticMethod: '"super" \uD638\uCD9C\uC758 \uC778\uC218\uAC00 0\uC778 \uD615\uC2DD\uC740 \uC815\uC801 \uBA54\uC11C\uB4DC \uB0B4\uC5D0\uC11C \uC720\uD6A8\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        symbolIsPossiblyUnbound: '"{name}"\uC740(\uB294) \uBC14\uC778\uB529\uB418\uC9C0 \uC54A\uC740 \uAC83\uC77C \uC218 \uC788\uC2B5\uB2C8\uB2E4.',
        symbolIsUnbound: '"{name}"\uC758 \uBC14\uC778\uB529\uC774 \uD574\uC81C\uB418\uC5C8\uC2B5\uB2C8\uB2E4.',
        symbolIsUndefined: '"{name}"\uC774(\uAC00) \uC815\uC758\uB418\uC9C0 \uC54A\uC558\uC2B5\uB2C8\uB2E4.',
        symbolOverridden: '"{name}"\uC774(\uAC00) \uD074\uB798\uC2A4 "{className}"\uC5D0\uC11C \uB3D9\uC77C\uD55C \uC774\uB984\uC758 \uAE30\uD638\uB97C \uC7AC\uC815\uC758\uD569\uB2C8\uB2E4.',
        templateStringBytes: "Template string literals (t-strings) cannot be binary",
        templateStringIllegal: "Template string literals (t-strings) require Python 3.14 or newer",
        templateStringUnicode: "Template string literals (t-strings) cannot be unicode",
        ternaryNotAllowed: "\uD615\uC2DD \uC2DD\uC5D0\uB294 3\uD56D \uC2DD\uC774 \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        totalOrderingMissingMethod: '\uD074\uB798\uC2A4\uB294 total_ordering\uC744 \uC0AC\uC6A9\uD558\uB824\uBA74 "__lt__", "__le__", "__gt__" \uB610\uB294 "__ge__" \uC911 \uD558\uB098\uB97C \uC815\uC758\uD574\uC57C \uD569\uB2C8\uB2E4.',
        trailingCommaInFromImport: "\uC8FC\uBCC0 \uAD04\uD638 \uC5C6\uC774\uB294 \uD6C4\uD589 \uC27C\uD45C\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        tryWithoutExcept: "try \uBB38\uC5D0\uB294 except \uB610\uB294 finally \uC808\uC774 \uD558\uB098 \uC774\uC0C1 \uC788\uC5B4\uC57C \uD569\uB2C8\uB2E4.",
        tupleAssignmentMismatch: "\uD615\uC2DD\uC774 \u201C{type}\u201C\uC778 \uC2DD\uC744 \uB300\uC0C1 tuple\uC5D0 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        tupleInAnnotation: "\uD615\uC2DD \uC2DD\uC5D0\uB294 tuple \uC2DD\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        tupleIndexOutOfRange: "{index} \uC778\uB371\uC2A4\uAC00 {type} \uD615\uC2DD\uC758 \uBC94\uC704\uB97C \uBC97\uC5B4\uB0AC\uC2B5\uB2C8\uB2E4.",
        typeAliasIllegalExpressionForm: "\uD615\uC2DD \uBCC4\uCE6D \uC815\uC758\uC5D0 \uB300\uD55C \uC2DD \uC591\uC2DD\uC774 \uC798\uBABB\uB418\uC5C8\uC2B5\uB2C8\uB2E4.",
        typeAliasIsRecursiveDirect: "\uD615\uC2DD \uBCC4\uCE6D \u2018{name}\u2019\uC758 \uC815\uC758\uC5D0\uC11C \uC2A4\uC2A4\uB85C\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        typeAliasNotInModuleOrClass: "TypeAlias\uB294 \uBAA8\uB4C8 \uB610\uB294 \uD074\uB798\uC2A4 \uBC94\uC704 \uB0B4\uC5D0\uC11C\uB9CC \uC815\uC758\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4.",
        typeAliasRedeclared: '"{name}"\uC740(\uB294) TypeAlias\uB85C \uC120\uC5B8\uB418\uBA70 \uD55C \uBC88\uB9CC \uD560\uB2F9\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4.',
        typeAliasStatementBadScope: "type \uBB38\uC740 \uBAA8\uB4C8 \uB610\uB294 \uD074\uB798\uC2A4 \uBC94\uC704 \uB0B4\uC5D0\uC11C\uB9CC \uC0AC\uC6A9\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4.",
        typeAliasStatementIllegal: "\uD615\uC2DD \uBCC4\uCE6D \uBB38\uC5D0\uB294 Python 3.12 \uC774\uC0C1\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        typeAliasTypeBadScope: "\uD615\uC2DD \uBCC4\uCE6D\uC740 \uBAA8\uB4C8 \uB610\uB294 \uD074\uB798\uC2A4 \uBC94\uC704 \uB0B4\uC5D0\uC11C\uB9CC \uC815\uC758\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4.",
        typeAliasTypeBaseClass: '"type" \uBB38\uC5D0 \uC815\uC758\uB41C \uD615\uC2DD \uBCC4\uCE6D\uC740 \uAE30\uBCF8 \uD074\uB798\uC2A4\uB85C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        typeAliasTypeMustBeAssigned: "TypeAliasType\uC740 \uD615\uC2DD \uBCC4\uCE6D\uACFC \uC774\uB984\uC774 \uAC19\uC740 \uBCC0\uC218\uC5D0 \uD560\uB2F9\uD574\uC57C \uD569\uB2C8\uB2E4.",
        typeAliasTypeNameArg: "TypeAliasType\uC758 \uCCAB \uBC88\uC9F8 \uC778\uC218\uB294 \uD615\uC2DD \uBCC4\uCE6D\uC758 \uC774\uB984\uC744 \uB098\uD0C0\uB0B4\uB294 \uBB38\uC790\uC5F4 \uB9AC\uD130\uB7F4\uC774\uC5B4\uC57C \uD569\uB2C8\uB2E4.",
        typeAliasTypeNameMismatch: "\uD615\uC2DD \uBCC4\uCE6D\uC758 \uC774\uB984\uC740 \uD560\uB2F9\uB41C \uBCC0\uC218\uC758 \uC774\uB984\uACFC \uC77C\uCE58\uD574\uC57C \uD569\uB2C8\uB2E4.",
        typeAliasTypeParamInvalid: "\uD615\uC2DD \uB9E4\uAC1C \uBCC0\uC218 \uBAA9\uB85D\uC740 TypeVar, TypeVarTuple \uB610\uB294 ParamSpec\uB9CC \uD3EC\uD568\uD558\uB294 tuple\uC774\uC5B4\uC57C \uD569\uB2C8\uB2E4.",
        typeAnnotationCall: "\uD615\uC2DD \uC2DD\uC5D0\uB294 \uD638\uCD9C \uC2DD\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        typeAnnotationVariable: "\uD615\uC2DD \uC2DD\uC5D0\uB294 \uBCC0\uC218\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        typeAnnotationWithCallable: '"type"\uC5D0 \uB300\uD55C \uD615\uC2DD \uC778\uC218\uB294 \uD074\uB798\uC2A4\uC5EC\uC57C \uD569\uB2C8\uB2E4. \uCF5C\uB7EC\uBE14\uC740 \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        typeArgListExpected: "ParamSpec, \uC904\uC784\uD45C \uB610\uB294 \uD615\uC2DD\uC758 list\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        typeArgListNotAllowed: "\uC774 \uD615\uC2DD \uC778\uC218\uC5D0\uB294 list \uC2DD\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        typeArgsExpectingNone: '\uD074\uB798\uC2A4 "{name}"\uC5D0 \uD615\uC2DD \uC778\uC218\uAC00 \uD544\uC694\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        typeArgsMismatchOne: "\uD558\uB098\uC758 \uD615\uC2DD \uC778\uC218\uAC00 \uD544\uC694\uD558\uC9C0\uB9CC {received}\uC744(\uB97C) \uBC1B\uC558\uC2B5\uB2C8\uB2E4.",
        typeArgsMissingForAlias: '\uC81C\uB124\uB9AD \uD615\uC2DD \uBCC4\uCE6D "{name}"\uC5D0 \uB300\uD55C \uD615\uC2DD \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.',
        typeArgsMissingForClass: "\u2018{name}\u2019 \uC81C\uB124\uB9AD \uD074\uB798\uC2A4\uC5D0 \uB300\uD55C \uD615\uC2DD \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        typeArgsTooFew: '"{name}"\uC5D0 \uB300\uD574 \uC81C\uACF5\uB41C \uD615\uC2DD \uC778\uC218\uAC00 \uB108\uBB34 \uC801\uC2B5\uB2C8\uB2E4. {expected}\uC774(\uAC00) \uD544\uC694\uD558\uC9C0\uB9CC {received}\uC744(\uB97C) \uBC1B\uC558\uC2B5\uB2C8\uB2E4.',
        typeArgsTooMany: "\u2018{name}\u2019\uC5D0 \uB300\uD55C \uD615\uC2DD \uC778\uC218\uAC00 \uB108\uBB34 \uB9CE\uC2B5\uB2C8\uB2E4. {expected}\uC774(\uAC00) \uD544\uC694\uD558\uC9C0\uB9CC {received}\uC744(\uB97C) \uBC1B\uC558\uC2B5\uB2C8\uB2E4.",
        typeAssignmentMismatch: '\uD615\uC2DD "{sourceType}"\uC744 \uC120\uC5B8\uB41C \uD615\uC2DD "{destType}"\uC5D0 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        typeAssignmentMismatchWildcard: '\uAC00\uC838\uC624\uAE30 \uAE30\uD638 "{name}"\uC5D0 \uC120\uC5B8\uB41C \uD615\uC2DD "{destType}"\uC5D0 \uD560\uB2F9\uD560 \uC218 \uC5C6\uB294 "{sourceType}" \uD615\uC2DD\uC774 \uC788\uC2B5\uB2C8\uB2E4.',
        typeCallNotAllowed: "type() \uD638\uCD9C\uC740 \uD615\uC2DD \uC2DD\uC5D0 \uC0AC\uC6A9\uD558\uBA74 \uC548 \uB429\uB2C8\uB2E4.",
        typeCheckOnly: '"{name}"\uC774(\uAC00) @type_check_only\uB85C \uD45C\uC2DC\uB418\uC5B4 \uC788\uC73C\uBBC0\uB85C \uD615\uC2DD \uC8FC\uC11D\uC5D0\uC11C\uB9CC \uC0AC\uC6A9\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4.',
        typeCommentDeprecated: "type \uBA54\uBAA8\uB294 \uB354 \uC774\uC0C1 \uC0AC\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4. \uB300\uC2E0 type \uC8FC\uC11D \uC0AC\uC6A9",
        typeExpectedClass: '\uD074\uB798\uC2A4\uAC00 \uD544\uC694\uD558\uC9C0\uB9CC "{type}"\uC774(\uAC00) \uC218\uC2E0\uB428',
        typeFormArgs: '"TypeForm"\uC740 \uB2E8\uC77C \uC704\uCE58 \uC778\uC218\uB97C \uD5C8\uC6A9\uD569\uB2C8\uB2E4.',
        typeGuardArgCount: '"TypeGuard" \uB610\uB294 "TypeIs" \uB4A4\uC5D0 \uB2E8\uC77C \uD615\uC2DD \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.',
        typeGuardParamCount: "\uC0AC\uC6A9\uC790 \uC815\uC758 type guard \uD568\uC218 \uBC0F \uBA54\uC11C\uB4DC\uC5D0\uB294 \uD558\uB098 \uC774\uC0C1\uC758 \uC785\uB825 \uB9E4\uAC1C \uBCC0\uC218\uAC00 \uC788\uC5B4\uC57C \uD569\uB2C8\uB2E4.",
        typeIsReturnType: 'TypeIs\uC758 \uBC18\uD658 \uD615\uC2DD("{returnType}")\uC774 \uAC12 \uB9E4\uAC1C \uBCC0\uC218 \uD615\uC2DD("{type}")\uACFC \uC77C\uCE58\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        typeNotAwaitable: "\u201C{type}\u201C\uC740(\uB294) awaitable\uC774 \uC544\uB2D9\uB2C8\uB2E4.",
        typeNotIntantiable: '"{type}"\uC744(\uB97C) \uC778\uC2A4\uD134\uC2A4\uD654\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        typeNotIterable: '"{type}" \uBC18\uBCF5\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        typeNotSpecializable: "\u2018{type}\u2019 \uD615\uC2DD\uC744 \uD2B9\uC218\uD654\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        typeNotSubscriptable: '"{type}" \uD615\uC2DD\uC758 \uAC1C\uCCB4\uB97C \uCCA8\uC790\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        typeNotSupportBinaryOperator: "\u2018{operator}\u2019 \uC5F0\uC0B0\uC790\uB294 \u2018{leftType}\u2019 \uBC0F \u2018{rightType}\u2019 \uD615\uC2DD\uC5D0 \uB300\uD574 \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        typeNotSupportBinaryOperatorBidirectional: "\uC608\uC0C1 \uD615\uC2DD\uC774 \u2018{expectedType}\u2019\uC778 \uACBD\uC6B0 \u2018{leftType}\u2019 \uBC0F \u2018{rightType}\u2019 \uD615\uC2DD\uC5D0 \uB300\uD574 \u2018{operator}\u2019 \uC5F0\uC0B0\uC790\uAC00 \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        typeNotSupportUnaryOperator: "\u2018{type}\u2019\u2018\uC5D0 \uB300\uD574 \u2019{operator}\u2018 \uC5F0\uC0B0\uC790\uAC00 \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        typeNotSupportUnaryOperatorBidirectional: '\uC608\uC0C1 \uD615\uC2DD\uC774 "{expectedType}" \uACBD\uC6B0 \uD615\uC2DD "{type}"\uC5D0 \uB300\uD574 \uC5F0\uC0B0\uC790 "{operator}"\uC774(\uAC00) \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        typeNotUsableWith: '"{type}" \uD615\uC2DD\uC758 \uAC1C\uCCB4\uB294 {method}\uC744(\uB97C) \uC62C\uBC14\uB974\uAC8C \uAD6C\uD604\uD558\uC9C0 \uC54A\uC73C\uBBC0\uB85C "with"\uC640 \uD568\uAED8 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        typeNotUsableWithAsync: '"{type}" \uD615\uC2DD\uC758 \uAC1C\uCCB4\uB294 {method}\uC744(\uB97C) \uC62C\uBC14\uB974\uAC8C \uAD6C\uD604\uD558\uC9C0 \uC54A\uC73C\uBBC0\uB85C "async with"\uC640 \uD568\uAED8 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        typeParameterBoundNotAllowed: "\uBC14\uC6B4\uB4DC \uB610\uB294 \uC81C\uC57D \uC870\uAC74\uC740 \uAC00\uBCC0 \uC778\uC790 \uD615\uC2DD \uB9E4\uAC1C \uBCC0\uC218 \uB610\uB294 ParamSpec\uC640 \uD568\uAED8 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        typeParameterConstraintTuple: "\uD615\uC2DD \uB9E4\uAC1C \uBCC0\uC218 \uC81C\uC57D \uC870\uAC74\uC740 \uB450 \uAC1C \uC774\uC0C1\uC758 \uD615\uC2DD \uD29C\uD50C\uC774\uC5B4\uC57C \uD569\uB2C8\uB2E4.",
        typeParameterExistingTypeParameter: '\uD615\uC2DD \uB9E4\uAC1C \uBCC0\uC218 "{name}"\uC774(\uAC00) \uC774\uBBF8 \uC0AC\uC6A9 \uC911\uC785\uB2C8\uB2E4.',
        typeParameterNotDeclared: '\uD615\uC2DD \uB9E4\uAC1C \uBCC0\uC218 "{name}"\uC774(\uAC00) "{container}"\uC758 \uD615\uC2DD \uB9E4\uAC1C \uBCC0\uC218 \uBAA9\uB85D\uC5D0 \uD3EC\uD568\uB418\uC5B4 \uC788\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        typeParametersMissing: "\uD558\uB098 \uC774\uC0C1\uC758 \uD615\uC2DD \uB9E4\uAC1C \uBCC0\uC218\uB97C \uC9C0\uC815\uD574\uC57C \uD569\uB2C8\uB2E4.",
        typePartiallyUnknown: '"{name}"\uC758 \uD615\uC2DD\uC744 \uBD80\uBD84\uC801\uC73C\uB85C \uC54C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        typeUnknown: '"{name}" \uC720\uD615\uC744 \uC54C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        typeVarAssignedName: 'TypeVar\uC744 "{name}"\uC774\uB77C\uB294 \uBCC0\uC218\uC5D0 \uD560\uB2F9\uD574\uC57C \uD569\uB2C8\uB2E4.',
        typeVarAssignmentMismatch: "\u2018{type}\u2019 \uD615\uC2DD\uC744 \u2018{name}\u2019 \uD615\uC2DD \uBCC0\uC218\uC5D0 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        typeVarBoundAndConstrained: "TypeVar\uB294 \uBC14\uC778\uB529\uB418\uACE0 \uC81C\uD55C\uB420 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        typeVarBoundGeneric: "TypeVar \uBC14\uC778\uB529 \uD615\uC2DD\uC740 \uC81C\uB124\uB9AD\uC77C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        typeVarConstraintGeneric: "TypeVar \uC81C\uC57D \uC870\uAC74 \uD615\uC2DD\uC740 \uC81C\uB124\uB9AD\uC77C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        typeVarDefaultBoundMismatch: "TypeVar \uAE30\uBCF8 \uD615\uC2DD\uC740 \uBC14\uC778\uB529\uB41C \uD615\uC2DD\uC758 \uD558\uC704 \uD615\uC2DD\uC774\uC5B4\uC57C \uD569\uB2C8\uB2E4.",
        typeVarDefaultConstraintMismatch: "TypeVar \uAE30\uBCF8 \uD615\uC2DD\uC740 \uC81C\uC57D\uC774 \uC788\uB294 \uD615\uC2DD \uC911 \uD558\uB098\uC5EC\uC57C \uD569\uB2C8\uB2E4.",
        typeVarDefaultIllegal: "\uD615\uC2DD \uBCC0\uC218 \uAE30\uBCF8 \uD615\uC2DD\uC740 Python 3.13 \uC774\uC0C1\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        typeVarDefaultInvalidTypeVar: '\uD615\uC2DD \uB9E4\uAC1C \uBCC0\uC218 "{name}"\uC5D0 \uBC94\uC704\uB97C \uBC97\uC5B4\uB09C \uD558\uB098 \uC774\uC0C1\uC758 \uD615\uC2DD \uBCC0\uC218\uB97C \uCC38\uC870\uD558\uB294 \uAE30\uBCF8 \uD615\uC2DD\uC774 \uC788\uC2B5\uB2C8\uB2E4.',
        typeVarFirstArg: "TypeVar\uC758 \uC774\uB984\uC774 \uCCAB \uBC88\uC9F8 \uC778\uC218\uB85C \uD544\uC694\uD569\uB2C8\uB2E4.",
        typeVarInvalidForMemberVariable: '\uD2B9\uC131 \uD615\uC2DD\uC740 \uB85C\uCEEC \uBA54\uC11C\uB4DC\uB85C \uBC94\uC704\uAC00 \uC9C0\uC815\uB41C "{name}" \uD615\uC2DD \uBCC0\uC218\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC74C',
        typeVarNoMember: 'TypeVar "{type}"\uC5D0 \uD2B9\uC131 "{name}"\uC774(\uAC00) \uC5C6\uC74C',
        typeVarNotSubscriptable: 'TypeVar "{type}"\uC744(\uB97C) \uCCA8\uC790\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        typeVarNotUsedByOuterScope: '\uD615\uC2DD \uBCC0\uC218 "{name}"\uC740(\uB294) \uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C \uC758\uBBF8\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.',
        typeVarPossiblyUnsolvable: "\uD638\uCD9C\uC790\uAC00 \u2018{param}\u2019 \uB9E4\uAC1C \uBCC0\uC218\uC5D0 \uB300\uD55C \uC778\uC218\uB97C \uC81C\uACF5\uD558\uC9C0 \uC54A\uC73C\uBA74 \u2018{name}\u2019 \uD615\uC2DD \uBCC0\uC218\uAC00 \uD655\uC778\uB418\uC9C0 \uC54A\uC744 \uC218 \uC788\uC2B5\uB2C8\uB2E4.",
        typeVarSingleConstraint: "TypeVar\uC5D0\uB294 \uB450 \uAC1C \uC774\uC0C1\uC758 \uC81C\uD55C\uB41C \uD615\uC2DD\uC774 \uC788\uC5B4\uC57C \uD569\uB2C8\uB2E4.",
        typeVarTupleConstraints: "TypeVarTuple\uC5D0\uB294 \uAC12 \uC81C\uC57D \uC870\uAC74\uC774 \uC788\uC744 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        typeVarTupleContext: "TypeVarTuple\uC740 \uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        typeVarTupleDefaultNotUnpacked: "TypeVarTuple \uAE30\uBCF8 \uD615\uC2DD\uC740 \uC555\uCD95\uC744 \uD47C tuple \uB610\uB294 TypeVarTuple\uC774\uC5B4\uC57C \uD569\uB2C8\uB2E4.",
        typeVarTupleMustBeUnpacked: "TypeVarTuple \uAC12\uC5D0\uB294 \uC555\uCD95 \uD480\uAE30 \uC5F0\uC0B0\uC790\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        typeVarTupleUnknownParam: '"{name}"\uC740(\uB294) TypeVarTuple\uC5D0 \uB300\uD55C \uC54C \uC218 \uC5C6\uB294 \uB9E4\uAC1C \uBCC0\uC218\uC785\uB2C8\uB2E4.',
        typeVarUnknownParam: "\u2018{name}\u2019\uC740(\uB294) TypeVar\uC5D0 \uB300\uD55C \uC54C \uC218 \uC5C6\uB294 \uB9E4\uAC1C \uBCC0\uC218\uC785\uB2C8\uB2E4.",
        typeVarUsedByOuterScope: "TypeVar \u2018{name}\u2019\uC740(\uB294) \uC678\uBD80 \uBC94\uC704\uC5D0\uC11C \uC774\uBBF8 \uC0AC\uC6A9 \uC911\uC785\uB2C8\uB2E4.",
        typeVarUsedOnlyOnce: 'TypeVar "{name}"\uC774(\uAC00) \uC81C\uB124\uB9AD \uD568\uC218 \uC2DC\uADF8\uB2C8\uCC98\uC5D0 \uD55C \uBC88\uB9CC \uB098\uD0C0\uB0A9\uB2C8\uB2E4.',
        typeVarVariance: "TypeVar\uB294 \uACF5\uBCC0\uC774\uBA74\uC11C \uBC18\uACF5\uBCC0\uC77C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        typeVarWithDefaultFollowsVariadic: 'TypeVar "{typeVarName}"\uC5D0 \uAE30\uBCF8\uAC12\uC774 \uC788\uC73C\uBA70 TypeVarTuple "{variadicName}"\uC744(\uB97C) \uB530\uB97C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        typeVarWithoutDefault: "\u2018{name}\u2019\uC740 \uAE30\uBCF8 \uD615\uC2DD\uC774 \uC5C6\uC73C\uBBC0\uB85C \uD615\uC2DD \uB9E4\uAC1C \uBCC0\uC218 \uBAA9\uB85D\uC5D0\uC11C \u2018{other}\u2019 \uB4A4\uC5D0 \uB098\uD0C0\uB0A0 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        typeVarsNotInGenericOrProtocol: "Generic[] \uB610\uB294 Protocol[]\uC5D0\uB294 \uBAA8\uB4E0 \uD615\uC2DD \uBCC0\uC218\uAC00 \uD3EC\uD568\uB418\uC5B4\uC57C \uD569\uB2C8\uB2E4.",
        typedDictAccess: "TypedDict\uC758 \uD56D\uBAA9\uC5D0 \uC561\uC138\uC2A4\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        typedDictAssignedName: 'TypedDict\uB97C "{name}"\uC774\uB77C\uB294 \uBCC0\uC218\uC5D0 \uD560\uB2F9\uD574\uC57C \uD569\uB2C8\uB2E4.',
        typedDictBadVar: "TypedDict \uD074\uB798\uC2A4\uB294 \uD615\uC2DD \uC8FC\uC11D\uB9CC \uD3EC\uD568\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4.",
        typedDictBaseClass: "TypedDict \uD074\uB798\uC2A4\uC758 \uBAA8\uB4E0 \uAE30\uBCF8 \uD074\uB798\uC2A4\uB3C4 TypedDict \uD074\uB798\uC2A4\uC5EC\uC57C \uD569\uB2C8\uB2E4.",
        typedDictBoolParam: '"{name}" \uB9E4\uAC1C \uBCC0\uC218\uC5D0 True \uB610\uB294 False \uAC12\uC774 \uC788\uC5B4\uC57C \uD569\uB2C8\uB2E4.',
        typedDictClosedExtras: '\uAE30\uBCF8 \uD074\uB798\uC2A4 "{name}" \uCD94\uAC00 \uD56D\uBAA9\uC758 \uC720\uD615\uC744 "{type}" \uD615\uC2DD\uC73C\uB85C \uC81C\uD55C\uD558\uB294 TypedDict.',
        typedDictClosedFalseNonOpenBase: 'Base class "{name}" is not an open TypedDict; closed=False is not allowed',
        typedDictClosedNoExtras: '\uAE30\uBCF8 \uD074\uB798\uC2A4 "{name}"\uC740(\uB294) closed TypedDict\uC785\uB2C8\uB2E4. \uCD94\uAC00 \uD56D\uBAA9\uC740 \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        typedDictDelete: "TypedDict\uC5D0\uC11C \uD56D\uBAA9\uC744 \uC0AD\uC81C\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        typedDictEmptyName: "TypedDict \uB0B4\uC758 \uC774\uB984\uC740 \uBE44\uC6CC \uB458 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        typedDictEntryName: "\uC0AC\uC804 \uD56D\uBAA9 \uC774\uB984\uC5D0 \uD544\uC694\uD55C \uBB38\uC790\uC5F4 \uB9AC\uD130\uB7F4",
        typedDictEntryUnique: "\uC0AC\uC804 \uB0B4\uC758 \uC774\uB984\uC740 \uACE0\uC720\uD574\uC57C \uD569\uB2C8\uB2E4.",
        typedDictExtraArgs: "\uCD94\uAC00 TypedDict \uC778\uC218\uAC00 \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uC74C",
        typedDictExtraItemsClosed: 'TypedDict "closed" \uB610\uB294 "extra_items" \uC911 \uD558\uB098\uB9CC \uC0AC\uC6A9\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4.',
        typedDictFieldNotRequiredRedefinition: 'TypedDict \uD56D\uBAA9 "{name}"\uC740(\uB294) NotRequired\uB85C \uC7AC\uC815\uC758\uB420 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        typedDictFieldReadOnlyRedefinition: 'TypedDict \uD56D\uBAA9 "{name}"\uC740(\uB294) ReadOnly\uB85C \uC7AC\uC815\uC758\uB420 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        typedDictFieldRequiredRedefinition: 'TypedDict \uD56D\uBAA9 "{name}"\uC740(\uB294) Required\uB85C \uC7AC\uC815\uC758\uB420 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        typedDictFirstArg: "TypedDict \uD074\uB798\uC2A4 \uC774\uB984\uC774 \uCCAB \uBC88\uC9F8 \uC778\uC218\uB85C \uD544\uC694\uD569\uB2C8\uB2E4.",
        typedDictInClassPattern: "TypedDict \uD074\uB798\uC2A4\uB294 \uD074\uB798\uC2A4 \uD328\uD134\uC5D0\uC11C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        typedDictInitsubclassParameter: 'TypedDict\uB294 __init_subclass__ \uB9E4\uAC1C \uBCC0\uC218 "{name}"\uC744(\uB97C) \uC9C0\uC6D0\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        typedDictNotAllowed: '\uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C\uB294 "TypedDict"\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        typedDictSecondArgDict: "\uB450 \uBC88\uC9F8 \uB9E4\uAC1C \uBCC0\uC218\uB85C dict \uB610\uB294 \uD0A4\uC6CC\uB4DC \uB9E4\uAC1C \uBCC0\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        typedDictSecondArgDictEntry: "\uB2E8\uC21C \uC0AC\uC804 \uD56D\uBAA9\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        typedDictSet: "TypedDict\uC5D0\uC11C \uD56D\uBAA9\uC744 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        unaccessedClass: '\uD074\uB798\uC2A4 "{name}"\uC5D0 \uC561\uC138\uC2A4\uD558\uC9C0 \uC54A\uC558\uC2B5\uB2C8\uB2E4.',
        unaccessedFunction: '\uD568\uC218 "{name}"\uC5D0 \uC561\uC138\uC2A4\uD558\uC9C0 \uC54A\uC558\uC2B5\uB2C8\uB2E4.',
        unaccessedImport: '\uAC00\uC838\uC624\uAE30 "{name}"\uC5D0 \uC561\uC138\uC2A4\uD558\uC9C0 \uC54A\uC558\uC2B5\uB2C8\uB2E4.',
        unaccessedSymbol: '"{name}"\uC5D0 \uC561\uC138\uC2A4\uD558\uC9C0 \uC54A\uC558\uC2B5\uB2C8\uB2E4.',
        unaccessedVariable: '\uBCC0\uC218 "{name}"\uC5D0 \uC561\uC138\uC2A4\uD558\uC9C0 \uC54A\uC558\uC2B5\uB2C8\uB2E4.',
        unannotatedFunctionSkipped: "\uC8FC\uC11D\uC774 \uC5C6\uC73C\uBBC0\uB85C \u2018{name}\u2019 \uD568\uC218 \uBD84\uC11D\uC744 \uAC74\uB108\uB701\uB2C8\uB2E4.",
        unaryOperationNotAllowed: "\uB2E8\uD56D \uC5F0\uC0B0\uC790\uB294 \uD615\uC2DD \uC2DD\uC5D0 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        unexpectedAsyncToken: '"async"\uB97C \uB530\uB974\uB824\uBA74 "def", "with" \uB610\uB294 "for"\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.',
        unexpectedEof: "Unexpected EOF",
        unexpectedExprToken: "\uC2DD \uB05D\uC5D0 \uC608\uAE30\uCE58 \uC54A\uC740 \uD1A0\uD070\uC774 \uC788\uC2B5\uB2C8\uB2E4.",
        unexpectedIndent: "\uC608\uAE30\uCE58 \uC54A\uC740 \uB4E4\uC5EC\uC4F0\uAE30",
        unexpectedUnindent: "\uB4E4\uC5EC\uC4F0\uAE30\uAC00 \uD544\uC694 \uC5C6\uC74C",
        unhashableDictKey: "\uC0AC\uC804 \uD0A4\uB294 \uD574\uC2DC \uAC00\uB2A5\uD574\uC57C \uD569\uB2C8\uB2E4.",
        unhashableSetEntry: "Set \uD56D\uBAA9\uC740 \uD574\uC2DC\uAC00 \uAC00\uB2A5\uD574\uC57C \uD569\uB2C8\uB2E4.",
        uninitializedAbstractVariables: '\uCD94\uC0C1 \uAE30\uBCF8 \uD074\uB798\uC2A4\uC5D0 \uC815\uC758\uB41C \uBCC0\uC218\uAC00 final \uD074\uB798\uC2A4 "{classType}"\uC5D0\uC11C \uCD08\uAE30\uD654\uB418\uC9C0 \uC54A\uC558\uC2B5\uB2C8\uB2E4.',
        uninitializedInstanceVariable: '\uC778\uC2A4\uD134\uC2A4 \uBCC0\uC218 "{name}"\uC774(\uAC00) \uD074\uB798\uC2A4 \uBCF8\uBB38 \uB610\uB294 __init__ \uBA54\uC11C\uB4DC\uC5D0\uC11C \uCD08\uAE30\uD654\uB418\uC9C0 \uC54A\uC558\uC2B5\uB2C8\uB2E4.',
        unionForwardReferenceNotAllowed: "Union \uAD6C\uBB38\uC740 \uBB38\uC790\uC5F4 \uD53C\uC5F0\uC0B0\uC790\uC5D0\uC11C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4. \uC804\uCCB4 \uC2DD \uC8FC\uC704\uC5D0 \uB530\uC634\uD45C \uC0AC\uC6A9",
        unionSyntaxIllegal: "\uACF5\uC6A9 \uAD6C\uC870\uCCB4\uC5D0 \uB300\uD55C \uB300\uCCB4 \uAD6C\uBB38\uC5D0\uB294 Python 3.10 \uC774\uC0C1\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        unionTypeArgCount: "Union\uC5D0\uB294 \uB458 \uC774\uC0C1\uC758 \uD615\uC2DD \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        unionUnpackedTuple: "Union\uC740 \uC555\uCD95\uC744 \uD47C tuple\uC744 \uD3EC\uD568\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        unionUnpackedTypeVarTuple: "Union\uC740 \uC555\uCD95\uC744 \uD47C TypeVarTuple\uC744 \uD3EC\uD568\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        unnecessaryCast: '\uBD88\uD544\uC694\uD55C "cast" \uD638\uCD9C\uC785\uB2C8\uB2E4. \uD615\uC2DD\uC774 \uC774\uBBF8 \u201C{type}\u201C\uC785\uB2C8\uB2E4.',
        unnecessaryIsInstanceAlways: '\uBD88\uD544\uC694\uD55C isinstance \uD638\uCD9C\uC785\uB2C8\uB2E4. "{testType}"\uC740(\uB294) \uD56D\uC0C1 "{classType}"\uC758 \uC778\uC2A4\uD134\uC2A4\uC785\uB2C8\uB2E4.',
        unnecessaryIsInstanceNever: '\uBD88\uD544\uC694\uD55C isinstance \uD638\uCD9C\uC785\uB2C8\uB2E4. "{testType}"\uC740(\uB294) \uD56D\uC0C1 "{classType}"\uC758 \uC778\uC2A4\uD134\uC2A4\uC785\uB2C8\uB2E4.',
        unnecessaryIsSubclassAlways: "\uBD88\uD544\uC694\uD55C issubclass \uD638\uCD9C\uC785\uB2C8\uB2E4. \u2019{testType}\u2018\uC740(\uB294) \uD56D\uC0C1 \u2019{classType}\u2018\uC758 \uD558\uC704 \uD074\uB798\uC2A4\uC785\uB2C8\uB2E4.",
        unnecessaryIsSubclassNever: "\uBD88\uD544\uC694\uD55C issubclass \uD638\uCD9C\uC785\uB2C8\uB2E4. \u2019{testType}\u2018\uC740(\uB294) \uD56D\uC0C1 \u2019{classType}\u2018\uC758 \uD558\uC704 \uD074\uB798\uC2A4\uC785\uB2C8\uB2E4.",
        unnecessaryPyrightIgnore: '\uBD88\uD544\uC694\uD55C "# pyright: ignore" \uBA54\uBAA8\uC785\uB2C8\uB2E4.',
        unnecessaryPyrightIgnoreRule: '\uBD88\uD544\uC694\uD55C "# pyright: ignore" \uADDC\uCE59: "{name}"',
        unnecessaryTypeIgnore: '\uBD88\uD544\uC694\uD55C "# type: ignore" \uBA54\uBAA8\uC785\uB2C8\uB2E4.',
        unpackArgCount: '"Unpack" \uB4A4\uC5D0\uB294 \uB2E8\uC77C \uD615\uC2DD \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.',
        unpackExpectedTypeVarTuple: "Unpack\uC5D0 \uB300\uD55C \uD615\uC2DD \uC778\uC218\uB85C TypeVarTuple \uB610\uB294 tuple\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        unpackExpectedTypedDict: "Unpack\uC744 \uC704\uD574\uC11C\uB294 TypedDict \uD615\uC2DD \uC778\uC218\uAC00 \uD544\uC694\uD569\uB2C8\uB2E4.",
        unpackIllegalInComprehension: "\uC555\uCD95 \uD480\uAE30 \uC791\uC5C5\uC740 \uC774\uD574\uC5D0\uC11C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        unpackInAnnotation: "\uD615\uC2DD \uC2DD\uC5D0\uB294 Unpack \uC5F0\uC0B0\uC790\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        unpackInDict: "\uC0AC\uC804\uC5D0\uC11C \uC555\uCD95 \uD480\uAE30 \uC791\uC5C5\uC774 \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC74C",
        unpackInSet: "set \uB0B4\uC5D0\uC11C\uB294 \uC555\uCD95 \uD480\uAE30 \uC5F0\uC0B0\uC790\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        unpackNotAllowed: "\uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C\uB294 Unpack\uC774 \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        unpackOperatorNotAllowed: "\uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C\uB294 \uC555\uCD95 \uD480\uAE30 \uC791\uC5C5\uC774 \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        unpackTuplesIllegal: "Python 3.8 \uC774\uC804\uC758 \uD29C\uD50C\uC5D0\uC11C\uB294 \uC555\uCD95 \uD480\uAE30 \uC791\uC5C5\uC774 \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        unpackedArgInTypeArgument: "\uC555\uCD95\uC744 \uD47C \uC778\uC218\uB294 \uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC74C",
        unpackedArgWithVariadicParam: "\uC555\uCD95\uC744 \uD47C \uC778\uC218\uB294 TypeVarTuple \uB9E4\uAC1C \uBCC0\uC218\uC5D0 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        unpackedDictArgumentNotMapping: '** \uB4A4\uC758 \uC778\uC218 \uC2DD\uC740 "str" \uD0A4 \uD615\uC2DD\uC758 \uB9E4\uD551\uC774\uC5B4\uC57C \uD569\uB2C8\uB2E4.',
        unpackedDictSubscriptIllegal: "\uC544\uB798 \uCCA8\uC790\uC5D0\uC11C \uC0AC\uC804 \uC555\uCD95 \uD480\uAE30 \uC5F0\uC0B0\uC790\uB294 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        unpackedSubscriptIllegal: "\uC544\uB798 \uCCA8\uC790\uC758 \uC555\uCD95 \uD480\uAE30 \uC5F0\uC0B0\uC790\uC5D0\uB294 Python 3.11 \uC774\uC0C1\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.",
        unpackedTypeVarTupleExpected: "\uC555\uCD95 \uD574\uC81C\uB41C TypeVarTuple\uC774 \uD544\uC694\uD569\uB2C8\uB2E4. Unpack[{name1}] \uB610\uB294 *{name2} \uC0AC\uC6A9",
        unpackedTypedDictArgument: "\uC555\uCD95\uB418\uC9C0 \uC54A\uC740 TypedDict \uC778\uC218\uB97C \uB9E4\uAC1C \uBCC0\uC218\uC640 \uC77C\uCE58\uC2DC\uD0AC \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        unreachableCodeCondition: "Code is not analyzed because condition is statically evaluated as false",
        unreachableCodeStructure: "Code is structurally unreachable",
        unreachableCodeType: "\uD615\uC2DD \uBD84\uC11D\uC744 \uD1B5\uD574 \uCF54\uB4DC\uC5D0 \uC5F0\uACB0\uD560 \uC218 \uC5C6\uC74C\uC744 \uB098\uD0C0\uB0C5\uB2C8\uB2E4.",
        unreachableExcept: "\uC608\uC678\uAC00 \uC774\uBBF8 \uCC98\uB9AC\uB418\uC5C8\uC73C\uBBC0\uB85C Except \uC808\uC5D0 \uC5F0\uACB0\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        unsupportedDunderAllOperation: '"__all__"\uC5D0 \uB300\uD55C \uC791\uC5C5\uC774 \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uC73C\uBBC0\uB85C \uB0B4\uBCF4\uB0B8 \uAE30\uD638 \uBAA9\uB85D\uC774 \uC798\uBABB\uB418\uC5C8\uC744 \uC218 \uC788\uC2B5\uB2C8\uB2E4.',
        unusedCallResult: "\uD638\uCD9C \uC2DD\uC758 \uACB0\uACFC\uAC00 \u2018{type}\u2019 \uD615\uC2DD\uC774\uBBC0\uB85C \uC0AC\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4. \uC758\uB3C4\uC801\uC778 \uACBD\uC6B0 \uBCC0\uC218 \u2018_\u2019\uC5D0 \uD560\uB2F9\uD558\uC138\uC694.",
        unusedCoroutine: 'async \uD568\uC218 \uD638\uCD9C\uC758 \uACB0\uACFC\uAC00 \uC0AC\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4. "await"\uB97C \uC0AC\uC6A9\uD558\uAC70\uB098 \uBCC0\uC218\uC5D0 \uACB0\uACFC \uD560\uB2F9',
        unusedExpression: "\uC2DD \uAC12\uC740 \uC0AC\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        varAnnotationIllegal: "\uBCC0\uC218\uC5D0 \uB300\uD55C type \uC8FC\uC11D\uC5D0\uB294 Python 3.6 \uC774\uC0C1\uC774 \uD544\uC694\uD569\uB2C8\uB2E4. \uC774\uC804 \uBC84\uC804\uACFC\uC758 \uD638\uD658\uC131\uC744 \uC704\uD574 type \uBA54\uBAA8 \uC0AC\uC6A9",
        variableFinalOverride: '\uBCC0\uC218 "{name}"\uC774(\uAC00) Final\uB85C \uD45C\uC2DC\uB418\uACE0 "{className}" \uD074\uB798\uC2A4\uC5D0\uC11C \uC774\uB984\uC774 \uAC19\uC740 \uBE44-Final \uBCC0\uC218\uB97C \uC7AC\uC815\uC758\uD569\uB2C8\uB2E4.',
        variadicTypeArgsTooMany: "\uD615\uC2DD \uC778\uC218 \uBAA9\uB85D\uC5D0\uB294 \uC555\uCD95\uC744 \uD480\uACE0 \uC788\uB294 TypeVarTuple \uB610\uB294 tuple\uC774 \uD558\uB098\uB9CC \uC788\uC744 \uC218 \uC788\uC2B5\uB2C8\uB2E4.",
        variadicTypeParamTooManyAlias: "\uD615\uC2DD \uBCC4\uCE6D\uC5D0\uB294 TypeVarTuple \uD615\uC2DD \uB9E4\uAC1C \uBCC0\uC218\uAC00 \uCD5C\uB300 \uD558\uB098\uB9CC \uC788\uC744 \uC218 \uC788\uC9C0\uB9CC \uC5EC\uB7EC ({names})\uAC00 \uC218\uC2E0\uB418\uC5C8\uC2B5\uB2C8\uB2E4.",
        variadicTypeParamTooManyClass: "\uC81C\uB124\uB9AD \uD074\uB798\uC2A4\uC5D0\uB294 TypeVarTuple \uD615\uC2DD \uB9E4\uAC1C \uBCC0\uC218\uAC00 \uD558\uB098\uB9CC \uC788\uC744 \uC218 \uC788\uC9C0\uB9CC \uC5EC\uB7EC ({names})\uC744(\uB97C) \uBC1B\uC558\uC2B5\uB2C8\uB2E4.",
        walrusIllegal: '\uC5F0\uC0B0\uC790 ":="\uC5D0\uB294 Python 3.8 \uC774\uC0C1\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.',
        walrusNotAllowed: '\uC8FC\uBCC0 \uAD04\uD638 \uC5C6\uC774\uB294 \uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C ":=" \uC5F0\uC0B0\uC790\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        wildcardInFunction: "\uD074\uB798\uC2A4 \uB610\uB294 \uD568\uC218 \uB0B4\uC5D0\uC11C \uC640\uC77C\uB4DC\uCE74\uB4DC import\uAC00 \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC74C",
        wildcardLibraryImport: "\uB77C\uC774\uBE0C\uB7EC\uB9AC\uC5D0\uC11C \uC640\uC77C\uB4DC\uCE74\uB4DC import\uAC00 \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        wildcardPatternTypePartiallyUnknown: "\uC640\uC77C\uB4DC\uCE74\uB4DC \uD328\uD134\uC73C\uB85C \uCEA1\uCC98\uB41C \uD615\uC2DD\uC744 \uBD80\uBD84\uC801\uC73C\uB85C \uC54C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        wildcardPatternTypeUnknown: "\uC640\uC77C\uB4DC\uCE74\uB4DC \uD328\uD134\uC73C\uB85C \uCEA1\uCC98\uB41C \uD615\uC2DD\uC744 \uBD80\uBD84\uC801\uC73C\uB85C \uC54C \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        yieldFromIllegal: '"yield from"\uC744 \uC0AC\uC6A9\uD558\uB824\uBA74 Python 3.3 \uC774\uC0C1\uC774 \uD544\uC694\uD569\uB2C8\uB2E4.',
        yieldFromOutsideAsync: 'async \uD568\uC218\uC5D0\uC11C\uB294 "yield from"\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        yieldOutsideFunction: "\uD568\uC218 \uB610\uB294 \uB78C\uB2E4 \uC678\uBD80\uC5D0\uC11C\uB294 \u2018yield\u2019\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        yieldWithinComprehension: 'comprehension \uB0B4\uC5D0\uC11C\uB294 "yield"\uB97C \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        zeroCaseStatementsFound: "Match \uBB38\uC5D0\uB294 case \uBB38\uC774 \uD558\uB098 \uC774\uC0C1 \uD3EC\uD568\uB418\uC5B4\uC57C \uD569\uB2C8\uB2E4.",
        zeroLengthTupleNotAllowed: "\uAE38\uC774\uAC00 0\uC778 tuple\uC740 \uC774 \uCEE8\uD14D\uC2A4\uD2B8\uC5D0\uC11C \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4."
      },
      DiagnosticAddendum: {
        annotatedNotAllowed: '"Annotated" \uD2B9\uC218 \uC591\uC2DD\uC740 \uC778\uC2A4\uD134\uC2A4 \uBC0F \uD074\uB798\uC2A4 \uAC80\uC0AC\uC640 \uD568\uAED8 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        argParam: '\uC778\uC218\uAC00 "{paramName}" \uB9E4\uAC1C \uBCC0\uC218\uC5D0 \uD574\uB2F9\uD569\uB2C8\uB2E4.',
        argParamFunction: '\uC778\uC218\uAC00 "{functionName}" \uD568\uC218\uC758 "{paramName}" \uB9E4\uAC1C \uBCC0\uC218\uC5D0 \uD574\uB2F9\uD569\uB2C8\uB2E4.',
        argsParamMissing: "\u2018*{paramName}\u2019 \uB9E4\uAC1C \uBCC0\uC218\uC5D0 \uD574\uB2F9\uD558\uB294 \uB9E4\uAC1C \uBCC0\uC218\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.",
        argsPositionOnly: "\uC704\uCE58 \uC804\uC6A9 \uB9E4\uAC1C \uBCC0\uC218\uAC00 \uC77C\uCE58\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4. {expected}\uC774)(\uAC00) \uD544\uC694\uD558\uC9C0\uB9CC {received}\uC744(\uB97C) \uBC1B\uC558\uC2B5\uB2C8\uB2E4.",
        argumentType: '\uC778\uC218 \uD615\uC2DD\uC774 "{type}"\uC785\uB2C8\uB2E4.',
        argumentTypes: "\uC778\uC218 \uD615\uC2DD: ({types})",
        assignToNone: '\uD615\uC2DD\uC744 "None"\uC5D0 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        asyncHelp: "\u2018async with\u2019\uB97C \uC0AC\uC6A9\uD558\uC2DC\uACA0\uC2B5\uB2C8\uAE4C?",
        baseClassIncompatible: '\uAE30\uBCF8 \uD074\uB798\uC2A4 "{baseClass}"\uC740(\uB294) "{type}" \uC720\uD615\uACFC \uD638\uD658\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        baseClassIncompatibleSubclass: '\uAE30\uBCF8 \uD074\uB798\uC2A4 "{baseClass}"\uC740(\uB294) "{type}" \uC720\uD615\uACFC \uD638\uD658\uB418\uC9C0 \uC54A\uB294 "{subclass}"\uC5D0\uC11C \uD30C\uC0DD\uB429\uB2C8\uB2E4.',
        baseClassOverriddenType: '\uAE30\uBCF8 \uD074\uB798\uC2A4 "{baseClass}"\uC774(\uAC00) \uC7AC\uC815\uC758\uB41C "{type}" \uD615\uC2DD\uC744 \uC81C\uACF5\uD569\uB2C8\uB2E4.',
        baseClassOverridesType: "\u2018{baseClass}\u2019 \uAE30\uBCF8 \uD074\uB798\uC2A4\uAC00 \u2018{type}\u2019 \uD615\uC2DD\uC744 \uC7AC\uC815\uC758\uD569\uB2C8\uB2E4.",
        bytesTypePromotions: 'disableBytesTypePromotions\uB97C false\uB85C \uC124\uC815\uD558\uC5EC "bytearray" \uBC0F "memoryview"\uC5D0 \uB300\uD55C \uD615\uC2DD \uC2B9\uACA9 \uB3D9\uC791\uC744 \uC0AC\uC6A9\uD558\uB3C4\uB85D \uC124\uC815\uD569\uB2C8\uB2E4.',
        conditionalRequiresBool: '"{operandType}" \uD615\uC2DD\uC5D0 \uB300\uD55C \uBA54\uC11C\uB4DC __bool__\uC5D0\uC11C "bool" \uB300\uC2E0 "{boolReturnType}" \uD615\uC2DD\uC744 \uBC18\uD658\uD569\uB2C8\uB2E4.',
        dataClassFieldLocation: "\uD544\uB4DC \uC120\uC5B8",
        dataClassFrozen: '"{name}"\uC774(\uAC00) \uACE0\uC815\uB418\uC5B4 \uC788\uC2B5\uB2C8\uB2E4.',
        dataProtocolUnsupported: '"{name}"\uC740(\uB294) \uB370\uC774\uD130 \uD504\uB85C\uD1A0\uCF5C\uC785\uB2C8\uB2E4.',
        descriptorAccessBindingFailed: '\uC124\uBA85\uC790 \uD074\uB798\uC2A4 "{className}"\uC5D0 \uB300\uD55C \uBA54\uC11C\uB4DC "{name}"\uC744(\uB97C) \uBC14\uC778\uB529\uD558\uC9C0 \uBABB\uD588\uC2B5\uB2C8\uB2E4.',
        descriptorAccessCallFailed: '\uC124\uBA85\uC790 \uD074\uB798\uC2A4 "{className}"\uC5D0 \uB300\uD55C \uBA54\uC11C\uB4DC "{name}"\uC744(\uB97C) \uD638\uCD9C\uD558\uC9C0 \uBABB\uD588\uC2B5\uB2C8\uB2E4.',
        finalMethod: "Final \uBA54\uC11C\uB4DC",
        functionParamDefaultMissing: "\u2018{name}\u2019 \uB9E4\uAC1C \uBCC0\uC218\uC5D0 \uAE30\uBCF8 \uC778\uC218\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.",
        functionParamName: '\uB9E4\uAC1C \uBCC0\uC218 \uC774\uB984 \uBD88\uC77C\uCE58: "{destName}" \uBC0F "{srcName}"',
        functionParamPositionOnly: '\uC704\uCE58 \uC804\uC6A9 \uB9E4\uAC1C \uBCC0\uC218\uAC00 \uC77C\uCE58\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4. \uB9E4\uAC1C \uBCC0\uC218 "{name}"\uC740(\uB294) \uC704\uCE58 \uC804\uC6A9\uC774 \uC544\uB2D9\uB2C8\uB2E4.',
        functionReturnTypeMismatch: "\u2018{sourceType}\u2019 \uD568\uC218 \uBC18\uD658 \uD615\uC2DD\uC740 \u2018{destType}\u2019 \uD615\uC2DD\uACFC \uD638\uD658\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        functionTooFewParams: "\uD568\uC218\uAC00 \uB108\uBB34 \uC801\uC740 \uC704\uCE58 \uB9E4\uAC1C \uBCC0\uC218\uB97C \uD5C8\uC6A9\uD569\uB2C8\uB2E4. {expected}\uC774(\uAC00) \uD544\uC694\uD558\uC9C0\uB9CC {received}\uC744(\uB97C) \uBC1B\uC558\uC2B5\uB2C8\uB2E4.",
        functionTooManyParams: "\uD568\uC218\uAC00 \uB108\uBB34 \uB9CE\uC740 \uC704\uCE58 \uB9E4\uAC1C \uBCC0\uC218\uB97C \uD5C8\uC6A9\uD569\uB2C8\uB2E4. {expected}\uC774(\uAC00) \uD544\uC694\uD558\uC9C0\uB9CC {received}\uC744(\uB97C) \uBC1B\uC558\uC2B5\uB2C8\uB2E4.",
        genericClassNotAllowed: "\uC778\uC2A4\uD134\uC2A4 \uB610\uB294 \uD074\uB798\uC2A4 \uAC80\uC0AC\uC5D0 \uD615\uC2DD \uC778\uC218\uAC00 \uD5C8\uC6A9\uB418\uC9C0 \uC54A\uB294 \uC81C\uB124\uB9AD \uD615\uC2DD",
        incompatibleDeleter: "Property deleter \uBA54\uC11C\uB4DC\uAC00 \uD638\uD658\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        incompatibleGetter: "Property getter \uBA54\uC11C\uB4DC\uAC00 \uD638\uD658\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        incompatibleSetter: "Property setter \uBA54\uC11C\uB4DC\uAC00 \uD638\uD658\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        initMethodLocation: '__init__ \uBA54\uC11C\uB4DC\uAC00 "{type}" \uD074\uB798\uC2A4\uC5D0 \uC815\uC758\uB418\uC5B4 \uC788\uC2B5\uB2C8\uB2E4.',
        initMethodSignature: '__init__\uC758 \uC11C\uBA85\uC740 "{type}"\uC785\uB2C8\uB2E4.',
        initSubclassLocation: '__init_subclass__ \uBA54\uC11C\uB4DC\uB294 "{name}" \uD074\uB798\uC2A4\uC5D0 \uC815\uC758\uB418\uC5B4 \uC788\uC74C',
        invariantSuggestionDict: '\uAC12 \uD615\uC2DD\uC5D0\uC11C \uACF5\uBCC0(covariant)\uC778 "dict"\uC5D0\uC11C "Mapping"(\uB9E4\uD551)\uC73C\uB85C \uC804\uD658\uD558\uB294 \uAC83\uC774 \uC88B\uC2B5\uB2C8\uB2E4.',
        invariantSuggestionList: '\uACF5\uBCC0(covariant)\uC778 "list"\uC5D0\uC11C "Sequence"\uB85C \uC804\uD658\uD558\uB294 \uAC83\uC774 \uC88B\uC2B5\uB2C8\uB2E4.',
        invariantSuggestionSet: '\uACF5\uBCC0(covariant)\uC778 "set"\uC5D0\uC11C "Container"\uB85C \uC804\uD658\uD558\uB294 \uAC83\uC774 \uC88B\uC2B5\uB2C8\uB2E4.',
        isinstanceClassNotSupported: '"{type}"\uC740(\uB294) \uC778\uC2A4\uD134\uC2A4 \uBC0F \uD074\uB798\uC2A4 \uAC80\uC0AC\uC5D0 \uC9C0\uC6D0\uB418\uC9C0 \uC54A\uC74C',
        keyNotRequired: "\u2018{name}\u2019\uC740(\uB294) \u2018{type}\u2019\uC5D0\uC11C \uD544\uC218 \uD0A4\uAC00 \uC544\uB2C8\uBBC0\uB85C \uC561\uC138\uC2A4\uB85C \uC778\uD574 \uB7F0\uD0C0\uC784 \uC608\uC678\uAC00 \uBC1C\uC0DD\uD560 \uC218 \uC788\uC2B5\uB2C8\uB2E4.",
        keyReadOnly: '"{name}"\uC740(\uB294) "{type}"\uC758 \uC77D\uAE30 \uC804\uC6A9 \uD0A4\uC785\uB2C8\uB2E4.',
        keyRequiredDeleted: '"{name}"\uC740(\uB294) \uD544\uC218 \uD0A4\uC774\uBBC0\uB85C \uC0AD\uC81C\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        keyUndefined: '"{name}"\uC774 "{type}"\uC5D0 \uC815\uC758\uB41C \uD0A4\uAC00 \uC544\uB2D9\uB2C8\uB2E4.',
        kwargsParamMissing: "\u2018**{paramName}\u2019 \uB9E4\uAC1C \uBCC0\uC218\uC5D0 \uD574\uB2F9\uD558\uB294 \uB9E4\uAC1C \uBCC0\uC218\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.",
        listAssignmentMismatch: '"{type}" \uD615\uC2DD\uC774 \uB300\uC0C1 \uBAA9\uB85D\uACFC \uD638\uD658\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        literalAssignmentMismatch: '"{sourceType}"\uC740 \uD615\uC2DD "{destType}"\uC5D0 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        literalNotAllowed: '"Literal" \uD2B9\uC218 \uC591\uC2DD\uC740 \uC778\uC2A4\uD134\uC2A4 \uBC0F \uD074\uB798\uC2A4 \uAC80\uC0AC\uC640 \uD568\uAED8 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4',
        matchIsNotExhaustiveHint: '\uC804\uCCB4 \uCC98\uB9AC\uAC00 \uC758\uB3C4\uB418\uC9C0 \uC54A\uC740 \uACBD\uC6B0 "case _: pass"\uB97C \uCD94\uAC00\uD569\uB2C8\uB2E4.',
        matchIsNotExhaustiveType: '\uCC98\uB9AC\uB418\uC9C0 \uC54A\uC740 \uD615\uC2DD: "{type}"',
        memberAssignment: '"{type}" \uD615\uC2DD\uC758 \uC2DD\uC744 "{classType}" \uD074\uB798\uC2A4\uC758 "{name}" \uD2B9\uC131\uC5D0 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC74C',
        memberIsAbstract: '"{type}.{name}"\uC774(\uAC00) \uAD6C\uD604\uB418\uC9C0 \uC54A\uC558\uC2B5\uB2C8\uB2E4.',
        memberIsAbstractMore: "{count}\uAC1C \uB354...",
        memberIsClassVarInProtocol: '"{name}"\uC740(\uB294) \uD504\uB85C\uD1A0\uCF5C\uC5D0\uC11C ClassVar\uB85C \uC815\uC758\uB429\uB2C8\uB2E4.',
        memberIsInitVar: '"{name}"\uC740(\uB294) init-only \uD544\uB4DC\uC784',
        memberIsInvariant: '"{name}"\uC740(\uB294) \uBCC0\uACBD \uAC00\uB2A5\uD558\uBBC0\uB85C \uACE0\uC815\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        memberIsNotClassVarInClass: '"{name}"\uC740(\uB294) \uD504\uB85C\uD1A0\uCF5C\uACFC \uD638\uD658\uB418\uB824\uBA74 ClassVar\uB85C \uC815\uC758\uD574\uC57C \uD569\uB2C8\uB2E4.',
        memberIsNotClassVarInProtocol: '"{name}"\uC774(\uAC00) \uD504\uB85C\uD1A0\uCF5C\uC5D0\uC11C ClassVar\uB85C \uC815\uC758\uB418\uC9C0 \uC54A\uC558\uC2B5\uB2C8\uB2E4.',
        memberIsNotReadOnlyInProtocol: '"{name}"(\uC774)\uAC00 \uD504\uB85C\uD1A0\uCF5C\uC5D0\uC11C \uC77D\uAE30 \uC804\uC6A9\uC774 \uC544\uB2D9\uB2C8\uB2E4.',
        memberIsReadOnlyInProtocol: '"{name}"\uC740(\uB294) \uD504\uB85C\uD1A0\uCF5C\uC5D0\uC11C \uC77D\uAE30 \uC804\uC6A9\uC785\uB2C8\uB2E4.',
        memberIsWritableInProtocol: '"{name}"\uC740(\uB294) \uD504\uB85C\uD1A0\uCF5C\uC5D0\uC11C \uC4F8 \uC218 \uC788\uC2B5\uB2C8\uB2E4.',
        memberSetClassVar: '"{name}" \uD2B9\uC131\uC740 ClassVar\uC774\uBBC0\uB85C \uD074\uB798\uC2A4 \uC778\uC2A4\uD134\uC2A4\uB97C \uD1B5\uD574 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC74C',
        memberTypeMismatch: '"{name}"\uC740(\uB294) \uD638\uD658\uB418\uC9C0 \uC54A\uB294 \uD615\uC2DD\uC785\uB2C8\uB2E4.',
        memberUnknown: '\uD2B9\uC131 "{name}" \uC54C \uC218 \uC5C6\uC74C',
        metaclassConflict: '\uBA54\uD0C0\uD074\uB798\uC2A4 "{metaclass1}"\uC774(\uAC00) "{metaclass2}"\uACFC(\uC640) \uCDA9\uB3CC\uD569\uB2C8\uB2E4.',
        missingDeleter: "Property deleter \uBA54\uC11C\uB4DC\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.",
        missingGetter: "Property getter \uBA54\uC11C\uB4DC\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.",
        missingSetter: "Property setter \uBA54\uC11C\uB4DC\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.",
        namedParamMissingInDest: '"{name}" \uCD94\uAC00 \uB9E4\uAC1C \uBCC0\uC218',
        namedParamMissingInSource: '"{name}" \uD0A4\uC6CC\uB4DC \uB9E4\uAC1C \uBCC0\uC218 \uB204\uB77D',
        namedParamTypeMismatch: '"{sourceType}" \uD615\uC2DD\uC758 \uD0A4\uC6CC\uB4DC \uB9E4\uAC1C \uBCC0\uC218 "{name}"\uC774(\uAC00) "{destType}" \uD615\uC2DD\uACFC \uD638\uD658\uB418\uC9C0 \uC54A\uC74C',
        namedTupleNotAllowed: "\uC778\uC2A4\uD134\uC2A4 \uB610\uB294 \uD074\uB798\uC2A4 \uAC80\uC0AC\uC5D0\uB294 NamedTuple\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        newMethodLocation: '__new__ \uBA54\uC11C\uB4DC\uAC00 "{type}" \uD074\uB798\uC2A4\uC5D0 \uC815\uC758\uB418\uC5B4 \uC788\uC2B5\uB2C8\uB2E4.',
        newMethodSignature: '__new__ \uC758 \uC11C\uBA85\uC740 "{type}"\uC785\uB2C8\uB2E4.',
        newTypeClassNotAllowed: "Type created with NewType cannot be used with instance and class checks",
        noOverloadAssignable: '"{type}" \uD615\uC2DD\uACFC \uC77C\uCE58\uD558\uB294 \uC624\uBC84\uB85C\uB4DC\uB41C \uD568\uC218\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.',
        noneNotAllowed: "\uC778\uC2A4\uD134\uC2A4 \uB610\uB294 \uD074\uB798\uC2A4 \uAC80\uC0AC\uC5D0\uB294 None\uC744 \uC0AC\uC6A9\uD560 \uC218 \uC5C6\uC74C",
        orPatternMissingName: "\uB204\uB77D\uB41C \uC774\uB984: {name}",
        overloadIndex: "\uC624\uBC84\uB85C\uB4DC {index}\uC774(\uAC00) \uAC00\uC7A5 \uAC00\uAE4C\uC6B4 \uC77C\uCE58 \uD56D\uBAA9\uC785\uB2C8\uB2E4.",
        overloadNotAssignable: '"{name}"\uC758 \uC624\uBC84\uB85C\uB4DC\uB97C \uD558\uB098 \uC774\uC0C1 \uD560\uB2F9\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.',
        overloadSignature: "\uC624\uBC84\uB85C\uB4DC \uC11C\uBA85\uC740 \uC5EC\uAE30\uC5D0 \uC815\uC758\uB418\uC5B4 \uC788\uC2B5\uB2C8\uB2E4.",
        overriddenMethod: "\uC7AC\uC815\uC758\uB41C \uBA54\uC11C\uB4DC",
        overriddenSymbol: "\uC7AC\uC815\uC758\uB41C \uAE30\uD638",
        overrideInvariantMismatch: '"{overrideType}" \uC7AC\uC815\uC758 \uD615\uC2DD\uC774 "{baseType}" \uAE30\uBCF8 \uD615\uC2DD\uACFC \uAC19\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        overrideIsInvariant: "\uBCC0\uC218\uB97C \uBCC0\uACBD\uD560 \uC218 \uC788\uC73C\uBBC0\uB85C \uD574\uB2F9 \uD615\uC2DD\uC740 \uACE0\uC815\uB429\uB2C8\uB2E4.",
        overrideNoOverloadMatches: "\uC7AC\uC815\uC758\uC758 \uC624\uBC84\uB85C\uB4DC \uC11C\uBA85\uC774 \uAE30\uBCF8 \uBA54\uC11C\uB4DC\uC640 \uD638\uD658\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        overrideNotClassMethod: "\uAE30\uBCF8 \uBA54\uC11C\uB4DC\uAC00 classmethod\uB85C \uC120\uC5B8\uB418\uC5C8\uC9C0\uB9CC \uC7AC\uC815\uC758\uB294 \uADF8\uB807\uC9C0 \uC54A\uC740 \uACBD\uC6B0",
        overrideNotInstanceMethod: "\uAE30\uBCF8 \uBA54\uC11C\uB4DC\uAC00 instance \uBA54\uC11C\uB4DC\uB85C \uC120\uC5B8\uB418\uC5C8\uC9C0\uB9CC \uC7AC\uC815\uC758\uAC00",
        overrideNotStaticMethod: "\uAE30\uBCF8 \uBA54\uC11C\uB4DC\uAC00 staticmethod\uB85C \uC120\uC5B8\uB418\uC5C8\uC9C0\uB9CC \uC7AC\uC815\uC758\uB294 \uADF8\uB807\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        overrideOverloadNoMatch: "\uC7AC\uC815\uC758\uB294 \uAE30\uBCF8 \uBA54\uC11C\uB4DC\uC758 \uBAA8\uB4E0 \uC624\uBC84\uB85C\uB4DC\uB97C \uCC98\uB9AC\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.",
        overrideOverloadOrder: "\uC7AC\uC815\uC758 \uBA54\uC11C\uB4DC\uC5D0 \uB300\uD55C \uC624\uBC84\uB85C\uB4DC\uB294 \uAE30\uBCF8 \uBA54\uC11C\uB4DC\uC640 \uB3D9\uC77C\uD55C \uC21C\uC11C\uC5EC\uC57C \uD569\uB2C8\uB2E4.",
        overrideParamKeywordNoDefault: "\u2018{name}\u2019 \uD0A4\uC6CC\uB4DC \uB9E4\uAC1C \uBCC0\uC218\uAC00 \uBD88\uC77C\uCE58\uD569\uB2C8\uB2E4. \uAE30\uBCF8 \uB9E4\uAC1C \uBCC0\uC218\uC5D0 \uAE30\uBCF8 \uC778\uC218 \uAC12\uC774 \uC788\uC2B5\uB2C8\uB2E4. \uC7AC\uC815\uC758 \uB9E4\uAC1C \uBCC0\uC218\uC5D0\uB294 \uC5C6\uC2B5\uB2C8\uB2E4.",
        overrideParamKeywordType: "\u2018{name}\u2019 \uD0A4\uC6CC\uB4DC \uB9E4\uAC1C \uBCC0\uC218 \uD615\uC2DD\uC774 \uC77C\uCE58\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4. \uAE30\uBCF8 \uB9E4\uAC1C \uBCC0\uC218\uB294 \uD615\uC2DD\uC774 \u2018{baseType}\u2019, \uC7AC\uC815\uC758 \uB9E4\uAC1C \uBCC0\uC218\uB294 \uD615\uC2DD\uC774 \u2018{overrideType}\u2019\uC785\uB2C8\uB2E4.",
        overrideParamName: "{index} \uB9E4\uAC1C \uBCC0\uC218 \uC774\uB984\uC774 \uC77C\uCE58\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4. \uAE30\uBCF8 \uB9E4\uAC1C \uBCC0\uC218\uB294 \uC774\uB984\uC774 \u2018{baseName}\u2019\uC785\uB2C8\uB2E4. \uC7AC\uC815\uC758 \uB9E4\uAC1C \uBCC0\uC218\uB294 \uC774\uB984\uC774 \u2018{overrideName}\u2019\uC785\uB2C8\uB2E4.",
        overrideParamNameExtra: '\uAE30\uBCF8\uC5D0 \uB9E4\uAC1C \uBCC0\uC218 "{name}"\uC774(\uAC00) \uC5C6\uC2B5\uB2C8\uB2E4.',
        overrideParamNameMissing: "\uC7AC\uC815\uC758\uC5D0 \u2018{name}\u2019 \uB9E4\uAC1C \uBCC0\uC218\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.",
        overrideParamNamePositionOnly: '\uB9E4\uAC1C \uBCC0\uC218 {index} \uBD88\uC77C\uCE58: \uAE30\uBCF8 \uB9E4\uAC1C \uBCC0\uC218 "{baseName}"\uC740(\uB294) \uD0A4\uC6CC\uB4DC \uB9E4\uAC1C \uBCC0\uC218\uC774\uBA70 \uC7AC\uC815\uC758 \uB9E4\uAC1C \uBCC0\uC218\uB294 \uC704\uCE58 \uC804\uC6A9\uC784',
        overrideParamNoDefault: "{index} \uB9E4\uAC1C \uBCC0\uC218\uAC00 \uBD88\uC77C\uCE58\uD569\uB2C8\uB2E4. \uAE30\uBCF8 \uB9E4\uAC1C \uBCC0\uC218\uC5D0 \uAE30\uBCF8 \uC778\uC218 \uAC12\uC774 \uC788\uC2B5\uB2C8\uB2E4. \uC7AC\uC815\uC758 \uB9E4\uAC1C \uBCC0\uC218\uC5D0\uB294 \uC5C6\uC2B5\uB2C8\uB2E4.",
        overrideParamType: "\u2018{index}\u2019 \uB9E4\uAC1C \uBCC0\uC218 \uD615\uC2DD\uC774 \uC77C\uCE58\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4. \uAE30\uBCF8 \uB9E4\uAC1C \uBCC0\uC218\uB294 \uD615\uC2DD\uC774 \u2018{baseType}\u2019, \uC7AC\uC815\uC758 \uB9E4\uAC1C \uBCC0\uC218\uB294 \uD615\uC2DD\uC774 \u2018{overrideType}\u2019\uC785\uB2C8\uB2E4.",
        overridePositionalParamCount: "\uC704\uCE58 \uB9E4\uAC1C \uBCC0\uC218 \uAC1C\uC218\uAC00 \uC77C\uCE58\uD558\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4. \uAE30\uBCF8 \uBA54\uC11C\uB4DC\uC5D0 {baseCount}\uAC1C\uAC00 \uC788\uC9C0\uB9CC \uC7AC\uC815\uC758\uC5D0\uB294 {overrideCount}\uAC1C\uAC00 \uC788\uC2B5\uB2C8\uB2E4.",
        overrideReturnType: '\uBC18\uD658 \uD615\uC2DD \uBD88\uC77C\uCE58: \uAE30\uBCF8 \uBA54\uC11C\uB4DC\uB294 "{baseType}" \uD615\uC2DD\uC744 \uBC18\uD658\uD558\uACE0 \uC7AC\uC815\uC758\uB294 "{overrideType}" \uD615\uC2DD\uC744 \uBC18\uD658\uD569\uB2C8\uB2E4.',
        overrideType: '\uAE30\uBCF8 \uD074\uB798\uC2A4\uB294 \uD615\uC2DD\uC744 "{type}"\uC73C\uB85C \uC815\uC758\uD569\uB2C8\uB2E4.',
        paramAssignment: '\uB9E4\uAC1C \uBCC0\uC218 {index}: "{sourceType}" \uD615\uC2DD\uC774 "{destType}" \uD615\uC2DD\uACFC \uD638\uD658\uB418\uC9C0 \uC54A\uC74C',
        paramSpecMissingInOverride: "\uC7AC\uC815\uC758 \uBA54\uC11C\uB4DC\uC5D0 ParamSpec \uB9E4\uAC1C \uBCC0\uC218\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.",
        paramType: '\uB9E4\uAC1C \uBCC0\uC218 \uD615\uC2DD\uC740 "{paramType}"\uC785\uB2C8\uB2E4.',
        privateImportFromPyTypedSource: '\uB300\uC2E0 "{module}"\uC5D0\uC11C \uAC00\uC838\uC624\uAE30',
        propertyAccessFromProtocolClass: "\uD504\uB85C\uD1A0\uCF5C \uD074\uB798\uC2A4 \uB0B4\uC5D0 \uC815\uC758\uB41C \uC18D\uC131\uC740 \uD074\uB798\uC2A4 \uBCC0\uC218\uB85C \uC561\uC138\uC2A4\uD560 \uC218 \uC5C6\uC2B5\uB2C8\uB2E4.",
        propertyMethodIncompatible: 'Property \uBA54\uC11C\uB4DC "{name}"\uC774(\uAC00) \uD638\uD658\uB418\uC9C0 \uC54A\uC2B5\uB2C8\uB2E4.',
        propertyMethodMissing: "Property \uBA54\uC11C\uB4DC \u201C{name}\u201D\uC5D0 \uC7AC\uC815\uC758\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.",
        propertyMissingDeleter: '"{name}" property\uC5D0 \uC815\uC758\uB41C deleter\uAC00 \uC5C6\uC2B5\uB2C8\uB2E4.',
        propertyMissi