"use strict";
global.__starttime = Date.now();
global.__isMain = require.main === module;
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name2 in all)
    __defProp(target, name2, { get: all[name2], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// node_modules/ansi-styles/index.js
var require_ansi_styles = __commonJS({
  "node_modules/ansi-styles/index.js"(exports2, module2) {
    "use strict";
    var ANSI_BACKGROUND_OFFSET = 10;
    var wrapAnsi256 = (offset = 0) => (code) => `\x1B[${38 + offset};5;${code}m`;
    var wrapAnsi16m = (offset = 0) => (red, green, blue2) => `\x1B[${38 + offset};2;${red};${green};${blue2}m`;
    function assembleStyles() {
      const codes = /* @__PURE__ */ new Map();
      const styles3 = {
        modifier: {
          reset: [0, 0],
          // 21 isn't widely supported and 22 does the same thing
          bold: [1, 22],
          dim: [2, 22],
          italic: [3, 23],
          underline: [4, 24],
          overline: [53, 55],
          inverse: [7, 27],
          hidden: [8, 28],
          strikethrough: [9, 29]
        },
        color: {
          black: [30, 39],
          red: [31, 39],
          green: [32, 39],
          yellow: [33, 39],
          blue: [34, 39],
          magenta: [35, 39],
          cyan: [36, 39],
          white: [37, 39],
          // Bright color
          blackBright: [90, 39],
          redBright: [91, 39],
          greenBright: [92, 39],
          yellowBright: [93, 39],
          blueBright: [94, 39],
          magentaBright: [95, 39],
          cyanBright: [96, 39],
          whiteBright: [97, 39]
        },
        bgColor: {
          bgBlack: [40, 49],
          bgRed: [41, 49],
          bgGreen: [42, 49],
          bgYellow: [43, 49],
          bgBlue: [44, 49],
          bgMagenta: [45, 49],
          bgCyan: [46, 49],
          bgWhite: [47, 49],
          // Bright color
          bgBlackBright: [100, 49],
          bgRedBright: [101, 49],
          bgGreenBright: [102, 49],
          bgYellowBright: [103, 49],
          bgBlueBright: [104, 49],
          bgMagentaBright: [105, 49],
          bgCyanBright: [106, 49],
          bgWhiteBright: [107, 49]
        }
      };
      styles3.color.gray = styles3.color.blackBright;
      styles3.bgColor.bgGray = styles3.bgColor.bgBlackBright;
      styles3.color.grey = styles3.color.blackBright;
      styles3.bgColor.bgGrey = styles3.bgColor.bgBlackBright;
      for (const [groupName2, group] of Object.entries(styles3)) {
        for (const [styleName, style] of Object.entries(group)) {
          styles3[styleName] = {
            open: `\x1B[${style[0]}m`,
            close: `\x1B[${style[1]}m`
          };
          group[styleName] = styles3[styleName];
          codes.set(style[0], style[1]);
        }
        Object.defineProperty(styles3, groupName2, {
          value: group,
          enumerable: false
        });
      }
      Object.defineProperty(styles3, "codes", {
        value: codes,
        enumerable: false
      });
      styles3.color.close = "\x1B[39m";
      styles3.bgColor.close = "\x1B[49m";
      styles3.color.ansi256 = wrapAnsi256();
      styles3.color.ansi16m = wrapAnsi16m();
      styles3.bgColor.ansi256 = wrapAnsi256(ANSI_BACKGROUND_OFFSET);
      styles3.bgColor.ansi16m = wrapAnsi16m(ANSI_BACKGROUND_OFFSET);
      Object.defineProperties(styles3, {
        rgbToAnsi256: {
          value: (red, green, blue2) => {
            if (red === green && green === blue2) {
              if (red < 8) {
                return 16;
              }
              if (red > 248) {
                return 231;
              }
              return Math.round((red - 8) / 247 * 24) + 232;
            }
            return 16 + 36 * Math.round(red / 255 * 5) + 6 * Math.round(green / 255 * 5) + Math.round(blue2 / 255 * 5);
          },
          enumerable: false
        },
        hexToRgb: {
          value: (hex) => {
            const matches = /(?<colorString>[a-f\d]{6}|[a-f\d]{3})/i.exec(hex.toString(16));
            if (!matches) {
              return [0, 0, 0];
            }
            let { colorString } = matches.groups;
            if (colorString.length === 3) {
              colorString = colorString.split("").map((character) => character + character).join("");
            }
            const integer2 = Number.parseInt(colorString, 16);
            return [
              integer2 >> 16 & 255,
              integer2 >> 8 & 255,
              integer2 & 255
            ];
          },
          enumerable: false
        },
        hexToAnsi256: {
          value: (hex) => styles3.rgbToAnsi256(...styles3.hexToRgb(hex)),
          enumerable: false
        }
      });
      return styles3;
    }
    Object.defineProperty(module2, "exports", {
      enumerable: true,
      get: assembleStyles
    });
  }
});

// node_modules/debounce/index.js
var require_debounce = __commonJS({
  "node_modules/debounce/index.js"(exports2, module2) {
    function debounce3(func2, wait2, immediate) {
      var timeout2, args, context, timestamp, result;
      if (null == wait2) wait2 = 100;
      function later() {
        var last = Date.now() - timestamp;
        if (last < wait2 && last >= 0) {
          timeout2 = setTimeout(later, wait2 - last);
        } else {
          timeout2 = null;
          if (!immediate) {
            result = func2.apply(context, args);
            context = args = null;
          }
        }
      }
      ;
      var debounced = function() {
        context = this;
        args = arguments;
        timestamp = Date.now();
        var callNow = immediate && !timeout2;
        if (!timeout2) timeout2 = setTimeout(later, wait2);
        if (callNow) {
          result = func2.apply(context, args);
          context = args = null;
        }
        return result;
      };
      debounced.clear = function() {
        if (timeout2) {
          clearTimeout(timeout2);
          timeout2 = null;
        }
      };
      debounced.flush = function() {
        if (timeout2) {
          result = func2.apply(context, args);
          context = args = null;
          clearTimeout(timeout2);
          timeout2 = null;
        }
      };
      return debounced;
    }
    debounce3.debounce = debounce3;
    module2.exports = debounce3;
  }
});

// node_modules/balanced-match/index.js
var require_balanced_match = __commonJS({
  "node_modules/balanced-match/index.js"(exports2, module2) {
    "use strict";
    module2.exports = balanced;
    function balanced(a, b, str) {
      if (a instanceof RegExp) a = maybeMatch(a, str);
      if (b instanceof RegExp) b = maybeMatch(b, str);
      var r = range(a, b, str);
      return r && {
        start: r[0],
        end: r[1],
        pre: str.slice(0, r[0]),
        body: str.slice(r[0] + a.length, r[1]),
        post: str.slice(r[1] + b.length)
      };
    }
    function maybeMatch(reg, str) {
      var m = str.match(reg);
      return m ? m[0] : null;
    }
    balanced.range = range;
    function range(a, b, str) {
      var begs, beg, left, right, result;
      var ai = str.indexOf(a);
      var bi = str.indexOf(b, ai + 1);
      var i = ai;
      if (ai >= 0 && bi > 0) {
        if (a === b) {
          return [ai, bi];
        }
        begs = [];
        left = str.length;
        while (i >= 0 && !result) {
          if (i == ai) {
            begs.push(i);
            ai = str.indexOf(a, i + 1);
          } else if (begs.length == 1) {
            result = [begs.pop(), bi];
          } else {
            beg = begs.pop();
            if (beg < left) {
              left = beg;
              right = bi;
            }
            bi = str.indexOf(b, i + 1);
          }
          i = ai < bi && ai >= 0 ? ai : bi;
        }
        if (begs.length) {
          result = [left, right];
        }
      }
      return result;
    }
  }
});

// node_modules/brace-expansion/index.js
var require_brace_expansion = __commonJS({
  "node_modules/brace-expansion/index.js"(exports2, module2) {
    var balanced = require_balanced_match();
    module2.exports = expandTop;
    var escSlash = "\0SLASH" + Math.random() + "\0";
    var escOpen = "\0OPEN" + Math.random() + "\0";
    var escClose = "\0CLOSE" + Math.random() + "\0";
    var escComma = "\0COMMA" + Math.random() + "\0";
    var escPeriod = "\0PERIOD" + Math.random() + "\0";
    function numeric(str) {
      return parseInt(str, 10) == str ? parseInt(str, 10) : str.charCodeAt(0);
    }
    function escapeBraces(str) {
      return str.split("\\\\").join(escSlash).split("\\{").join(escOpen).split("\\}").join(escClose).split("\\,").join(escComma).split("\\.").join(escPeriod);
    }
    function unescapeBraces(str) {
      return str.split(escSlash).join("\\").split(escOpen).join("{").split(escClose).join("}").split(escComma).join(",").split(escPeriod).join(".");
    }
    function parseCommaParts(str) {
      if (!str)
        return [""];
      var parts = [];
      var m = balanced("{", "}", str);
      if (!m)
        return str.split(",");
      var pre = m.pre;
      var body = m.body;
      var post = m.post;
      var p = pre.split(",");
      p[p.length - 1] += "{" + body + "}";
      var postParts = parseCommaParts(post);
      if (post.length) {
        p[p.length - 1] += postParts.shift();
        p.push.apply(p, postParts);
      }
      parts.push.apply(parts, p);
      return parts;
    }
    function expandTop(str) {
      if (!str)
        return [];
      if (str.substr(0, 2) === "{}") {
        str = "\\{\\}" + str.substr(2);
      }
      return expand2(escapeBraces(str), true).map(unescapeBraces);
    }
    function embrace(str) {
      return "{" + str + "}";
    }
    function isPadded(el) {
      return /^-?0\d/.test(el);
    }
    function lte(i, y) {
      return i <= y;
    }
    function gte(i, y) {
      return i >= y;
    }
    function expand2(str, isTop) {
      var expansions = [];
      var m = balanced("{", "}", str);
      if (!m) return [str];
      var pre = m.pre;
      var post = m.post.length ? expand2(m.post, false) : [""];
      if (/\$$/.test(m.pre)) {
        for (var k = 0; k < post.length; k++) {
          var expansion = pre + "{" + m.body + "}" + post[k];
          expansions.push(expansion);
        }
      } else {
        var isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m.body);
        var isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m.body);
        var isSequence = isNumericSequence || isAlphaSequence;
        var isOptions = m.body.indexOf(",") >= 0;
        if (!isSequence && !isOptions) {
          if (m.post.match(/,(?!,).*\}/)) {
            str = m.pre + "{" + m.body + escClose + m.post;
            return expand2(str);
          }
          return [str];
        }
        var n;
        if (isSequence) {
          n = m.body.split(/\.\./);
        } else {
          n = parseCommaParts(m.body);
          if (n.length === 1) {
            n = expand2(n[0], false).map(embrace);
            if (n.length === 1) {
              return post.map(function(p) {
                return m.pre + n[0] + p;
              });
            }
          }
        }
        var N;
        if (isSequence) {
          var x = numeric(n[0]);
          var y = numeric(n[1]);
          var width = Math.max(n[0].length, n[1].length);
          var incr = n.length == 3 ? Math.abs(numeric(n[2])) : 1;
          var test = lte;
          var reverse = y < x;
          if (reverse) {
            incr *= -1;
            test = gte;
          }
          var pad2 = n.some(isPadded);
          N = [];
          for (var i = x; test(i, y); i += incr) {
            var c;
            if (isAlphaSequence) {
              c = String.fromCharCode(i);
              if (c === "\\")
                c = "";
            } else {
              c = String(i);
              if (pad2) {
                var need = width - c.length;
                if (need > 0) {
                  var z = new Array(need + 1).join("0");
                  if (i < 0)
                    c = "-" + z + c.slice(1);
                  else
                    c = z + c;
                }
              }
            }
            N.push(c);
          }
        } else {
          N = [];
          for (var j = 0; j < n.length; j++) {
            N.push.apply(N, expand2(n[j], false));
          }
        }
        for (var j = 0; j < N.length; j++) {
          for (var k = 0; k < post.length; k++) {
            var expansion = pre + N[j] + post[k];
            if (!isTop || isSequence || expansion)
              expansions.push(expansion);
          }
        }
      }
      return expansions;
    }
  }
});

// node_modules/minimatch/dist/commonjs/assert-valid-pattern.js
var require_assert_valid_pattern = __commonJS({
  "node_modules/minimatch/dist/commonjs/assert-valid-pattern.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.assertValidPattern = void 0;
    var MAX_PATTERN_LENGTH = 1024 * 64;
    var assertValidPattern = (pattern) => {
      if (typeof pattern !== "string") {
        throw new TypeError("invalid pattern");
      }
      if (pattern.length > MAX_PATTERN_LENGTH) {
        throw new TypeError("pattern is too long");
      }
    };
    exports2.assertValidPattern = assertValidPattern;
  }
});

// node_modules/minimatch/dist/commonjs/brace-expressions.js
var require_brace_expressions = __commonJS({
  "node_modules/minimatch/dist/commonjs/brace-expressions.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.parseClass = void 0;
    var posixClasses = {
      "[:alnum:]": ["\\p{L}\\p{Nl}\\p{Nd}", true],
      "[:alpha:]": ["\\p{L}\\p{Nl}", true],
      "[:ascii:]": ["\\x00-\\x7f", false],
      "[:blank:]": ["\\p{Zs}\\t", true],
      "[:cntrl:]": ["\\p{Cc}", true],
      "[:digit:]": ["\\p{Nd}", true],
      "[:graph:]": ["\\p{Z}\\p{C}", true, true],
      "[:lower:]": ["\\p{Ll}", true],
      "[:print:]": ["\\p{C}", true],
      "[:punct:]": ["\\p{P}", true],
      "[:space:]": ["\\p{Z}\\t\\r\\n\\v\\f", true],
      "[:upper:]": ["\\p{Lu}", true],
      "[:word:]": ["\\p{L}\\p{Nl}\\p{Nd}\\p{Pc}", true],
      "[:xdigit:]": ["A-Fa-f0-9", false]
    };
    var braceEscape = (s) => s.replace(/[[\]\\-]/g, "\\$&");
    var regexpEscape = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    var rangesToString = (ranges) => ranges.join("");
    var parseClass = (glob2, position) => {
      const pos = position;
      if (glob2.charAt(pos) !== "[") {
        throw new Error("not in a brace expression");
      }
      const ranges = [];
      const negs = [];
      let i = pos + 1;
      let sawStart = false;
      let uflag = false;
      let escaping = false;
      let negate = false;
      let endPos = pos;
      let rangeStart = "";
      WHILE: while (i < glob2.length) {
        const c = glob2.charAt(i);
        if ((c === "!" || c === "^") && i === pos + 1) {
          negate = true;
          i++;
          continue;
        }
        if (c === "]" && sawStart && !escaping) {
          endPos = i + 1;
          break;
        }
        sawStart = true;
        if (c === "\\") {
          if (!escaping) {
            escaping = true;
            i++;
            continue;
          }
        }
        if (c === "[" && !escaping) {
          for (const [cls, [unip, u, neg]] of Object.entries(posixClasses)) {
            if (glob2.startsWith(cls, i)) {
              if (rangeStart) {
                return ["$.", false, glob2.length - pos, true];
              }
              i += cls.length;
              if (neg)
                negs.push(unip);
              else
                ranges.push(unip);
              uflag = uflag || u;
              continue WHILE;
            }
          }
        }
        escaping = false;
        if (rangeStart) {
          if (c > rangeStart) {
            ranges.push(braceEscape(rangeStart) + "-" + braceEscape(c));
          } else if (c === rangeStart) {
            ranges.push(braceEscape(c));
          }
          rangeStart = "";
          i++;
          continue;
        }
        if (glob2.startsWith("-]", i + 1)) {
          ranges.push(braceEscape(c + "-"));
          i += 2;
          continue;
        }
        if (glob2.startsWith("-", i + 1)) {
          rangeStart = c;
          i += 2;
          continue;
        }
        ranges.push(braceEscape(c));
        i++;
      }
      if (endPos < i) {
        return ["", false, 0, false];
      }
      if (!ranges.length && !negs.length) {
        return ["$.", false, glob2.length - pos, true];
      }
      if (negs.length === 0 && ranges.length === 1 && /^\\?.$/.test(ranges[0]) && !negate) {
        const r = ranges[0].length === 2 ? ranges[0].slice(-1) : ranges[0];
        return [regexpEscape(r), false, endPos - pos, false];
      }
      const sranges = "[" + (negate ? "^" : "") + rangesToString(ranges) + "]";
      const snegs = "[" + (negate ? "" : "^") + rangesToString(negs) + "]";
      const comb = ranges.length && negs.length ? "(" + sranges + "|" + snegs + ")" : ranges.length ? sranges : snegs;
      return [comb, uflag, endPos - pos, true];
    };
    exports2.parseClass = parseClass;
  }
});

// node_modules/minimatch/dist/commonjs/unescape.js
var require_unescape = __commonJS({
  "node_modules/minimatch/dist/commonjs/unescape.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.unescape = void 0;
    var unescape3 = (s, { windowsPathsNoEscape = false } = {}) => {
      return windowsPathsNoEscape ? s.replace(/\[([^\/\\])\]/g, "$1") : s.replace(/((?!\\).|^)\[([^\/\\])\]/g, "$1$2").replace(/\\([^\/])/g, "$1");
    };
    exports2.unescape = unescape3;
  }
});

// node_modules/minimatch/dist/commonjs/ast.js
var require_ast = __commonJS({
  "node_modules/minimatch/dist/commonjs/ast.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.AST = void 0;
    var brace_expressions_js_1 = require_brace_expressions();
    var unescape_js_1 = require_unescape();
    var types = /* @__PURE__ */ new Set(["!", "?", "+", "*", "@"]);
    var isExtglobType = (c) => types.has(c);
    var startNoTraversal = "(?!(?:^|/)\\.\\.?(?:$|/))";
    var startNoDot = "(?!\\.)";
    var addPatternStart = /* @__PURE__ */ new Set(["[", "."]);
    var justDots = /* @__PURE__ */ new Set(["..", "."]);
    var reSpecials = new Set("().*{}+?[]^$\\!");
    var regExpEscape = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    var qmark = "[^/]";
    var star = qmark + "*?";
    var starNoEmpty = qmark + "+?";
    var AST = class _AST {
      type;
      #root;
      #hasMagic;
      #uflag = false;
      #parts = [];
      #parent;
      #parentIndex;
      #negs;
      #filledNegs = false;
      #options;
      #toString;
      // set to true if it's an extglob with no children
      // (which really means one child of '')
      #emptyExt = false;
      constructor(type, parent, options2 = {}) {
        this.type = type;
        if (type)
          this.#hasMagic = true;
        this.#parent = parent;
        this.#root = this.#parent ? this.#parent.#root : this;
        this.#options = this.#root === this ? options2 : this.#root.#options;
        this.#negs = this.#root === this ? [] : this.#root.#negs;
        if (type === "!" && !this.#root.#filledNegs)
          this.#negs.push(this);
        this.#parentIndex = this.#parent ? this.#parent.#parts.length : 0;
      }
      get hasMagic() {
        if (this.#hasMagic !== void 0)
          return this.#hasMagic;
        for (const p of this.#parts) {
          if (typeof p === "string")
            continue;
          if (p.type || p.hasMagic)
            return this.#hasMagic = true;
        }
        return this.#hasMagic;
      }
      // reconstructs the pattern
      toString() {
        if (this.#toString !== void 0)
          return this.#toString;
        if (!this.type) {
          return this.#toString = this.#parts.map((p) => String(p)).join("");
        } else {
          return this.#toString = this.type + "(" + this.#parts.map((p) => String(p)).join("|") + ")";
        }
      }
      #fillNegs() {
        if (this !== this.#root)
          throw new Error("should only call on root");
        if (this.#filledNegs)
          return this;
        this.toString();
        this.#filledNegs = true;
        let n;
        while (n = this.#negs.pop()) {
          if (n.type !== "!")
            continue;
          let p = n;
          let pp = p.#parent;
          while (pp) {
            for (let i = p.#parentIndex + 1; !pp.type && i < pp.#parts.length; i++) {
              for (const part of n.#parts) {
                if (typeof part === "string") {
                  throw new Error("string part in extglob AST??");
                }
                part.copyIn(pp.#parts[i]);
              }
            }
            p = pp;
            pp = p.#parent;
          }
        }
        return this;
      }
      push(...parts) {
        for (const p of parts) {
          if (p === "")
            continue;
          if (typeof p !== "string" && !(p instanceof _AST && p.#parent === this)) {
            throw new Error("invalid part: " + p);
          }
          this.#parts.push(p);
        }
      }
      toJSON() {
        const ret = this.type === null ? this.#parts.slice().map((p) => typeof p === "string" ? p : p.toJSON()) : [this.type, ...this.#parts.map((p) => p.toJSON())];
        if (this.isStart() && !this.type)
          ret.unshift([]);
        if (this.isEnd() && (this === this.#root || this.#root.#filledNegs && this.#parent?.type === "!")) {
          ret.push({});
        }
        return ret;
      }
      isStart() {
        if (this.#root === this)
          return true;
        if (!this.#parent?.isStart())
          return false;
        if (this.#parentIndex === 0)
          return true;
        const p = this.#parent;
        for (let i = 0; i < this.#parentIndex; i++) {
          const pp = p.#parts[i];
          if (!(pp instanceof _AST && pp.type === "!")) {
            return false;
          }
        }
        return true;
      }
      isEnd() {
        if (this.#root === this)
          return true;
        if (this.#parent?.type === "!")
          return true;
        if (!this.#parent?.isEnd())
          return false;
        if (!this.type)
          return this.#parent?.isEnd();
        const pl = this.#parent ? this.#parent.#parts.length : 0;
        return this.#parentIndex === pl - 1;
      }
      copyIn(part) {
        if (typeof part === "string")
          this.push(part);
        else
          this.push(part.clone(this));
      }
      clone(parent) {
        const c = new _AST(this.type, parent);
        for (const p of this.#parts) {
          c.copyIn(p);
        }
        return c;
      }
      static #parseAST(str, ast, pos, opt) {
        let escaping = false;
        let inBrace = false;
        let braceStart = -1;
        let braceNeg = false;
        if (ast.type === null) {
          let i2 = pos;
          let acc2 = "";
          while (i2 < str.length) {
            const c = str.charAt(i2++);
            if (escaping || c === "\\") {
              escaping = !escaping;
              acc2 += c;
              continue;
            }
            if (inBrace) {
              if (i2 === braceStart + 1) {
                if (c === "^" || c === "!") {
                  braceNeg = true;
                }
              } else if (c === "]" && !(i2 === braceStart + 2 && braceNeg)) {
                inBrace = false;
              }
              acc2 += c;
              continue;
            } else if (c === "[") {
              inBrace = true;
              braceStart = i2;
              braceNeg = false;
              acc2 += c;
              continue;
            }
            if (!opt.noext && isExtglobType(c) && str.charAt(i2) === "(") {
              ast.push(acc2);
              acc2 = "";
              const ext = new _AST(c, ast);
              i2 = _AST.#parseAST(str, ext, i2, opt);
              ast.push(ext);
              continue;
            }
            acc2 += c;
          }
          ast.push(acc2);
          return i2;
        }
        let i = pos + 1;
        let part = new _AST(null, ast);
        const parts = [];
        let acc = "";
        while (i < str.length) {
          const c = str.charAt(i++);
          if (escaping || c === "\\") {
            escaping = !escaping;
            acc += c;
            continue;
          }
          if (inBrace) {
            if (i === braceStart + 1) {
              if (c === "^" || c === "!") {
                braceNeg = true;
              }
            } else if (c === "]" && !(i === braceStart + 2 && braceNeg)) {
              inBrace = false;
            }
            acc += c;
            continue;
          } else if (c === "[") {
            inBrace = true;
            braceStart = i;
            braceNeg = false;
            acc += c;
            continue;
          }
          if (isExtglobType(c) && str.charAt(i) === "(") {
            part.push(acc);
            acc = "";
            const ext = new _AST(c, part);
            part.push(ext);
            i = _AST.#parseAST(str, ext, i, opt);
            continue;
          }
          if (c === "|") {
            part.push(acc);
            acc = "";
            parts.push(part);
            part = new _AST(null, ast);
            continue;
          }
          if (c === ")") {
            if (acc === "" && ast.#parts.length === 0) {
              ast.#emptyExt = true;
            }
            part.push(acc);
            acc = "";
            ast.push(...parts, part);
            return i;
          }
          acc += c;
        }
        ast.type = null;
        ast.#hasMagic = void 0;
        ast.#parts = [str.substring(pos - 1)];
        return i;
      }
      static fromGlob(pattern, options2 = {}) {
        const ast = new _AST(null, void 0, options2);
        _AST.#parseAST(pattern, ast, 0, options2);
        return ast;
      }
      // returns the regular expression if there's magic, or the unescaped
      // string if not.
      toMMPattern() {
        if (this !== this.#root)
          return this.#root.toMMPattern();
        const glob2 = this.toString();
        const [re, body, hasMagic, uflag] = this.toRegExpSource();
        const anyMagic = hasMagic || this.#hasMagic || this.#options.nocase && !this.#options.nocaseMagicOnly && glob2.toUpperCase() !== glob2.toLowerCase();
        if (!anyMagic) {
          return body;
        }
        const flags = (this.#options.nocase ? "i" : "") + (uflag ? "u" : "");
        return Object.assign(new RegExp(`^${re}$`, flags), {
          _src: re,
          _glob: glob2
        });
      }
      get options() {
        return this.#options;
      }
      // returns the string match, the regexp source, whether there's magic
      // in the regexp (so a regular expression is required) and whether or
      // not the uflag is needed for the regular expression (for posix classes)
      // TODO: instead of injecting the start/end at this point, just return
      // the BODY of the regexp, along with the start/end portions suitable
      // for binding the start/end in either a joined full-path makeRe context
      // (where we bind to (^|/), or a standalone matchPart context (where
      // we bind to ^, and not /).  Otherwise slashes get duped!
      //
      // In part-matching mode, the start is:
      // - if not isStart: nothing
      // - if traversal possible, but not allowed: ^(?!\.\.?$)
      // - if dots allowed or not possible: ^
      // - if dots possible and not allowed: ^(?!\.)
      // end is:
      // - if not isEnd(): nothing
      // - else: $
      //
      // In full-path matching mode, we put the slash at the START of the
      // pattern, so start is:
      // - if first pattern: same as part-matching mode
      // - if not isStart(): nothing
      // - if traversal possible, but not allowed: /(?!\.\.?(?:$|/))
      // - if dots allowed or not possible: /
      // - if dots possible and not allowed: /(?!\.)
      // end is:
      // - if last pattern, same as part-matching mode
      // - else nothing
      //
      // Always put the (?:$|/) on negated tails, though, because that has to be
      // there to bind the end of the negated pattern portion, and it's easier to
      // just stick it in now rather than try to inject it later in the middle of
      // the pattern.
      //
      // We can just always return the same end, and leave it up to the caller
      // to know whether it's going to be used joined or in parts.
      // And, if the start is adjusted slightly, can do the same there:
      // - if not isStart: nothing
      // - if traversal possible, but not allowed: (?:/|^)(?!\.\.?$)
      // - if dots allowed or not possible: (?:/|^)
      // - if dots possible and not allowed: (?:/|^)(?!\.)
      //
      // But it's better to have a simpler binding without a conditional, for
      // performance, so probably better to return both start options.
      //
      // Then the caller just ignores the end if it's not the first pattern,
      // and the start always gets applied.
      //
      // But that's always going to be $ if it's the ending pattern, or nothing,
      // so the caller can just attach $ at the end of the pattern when building.
      //
      // So the todo is:
      // - better detect what kind of start is needed
      // - return both flavors of starting pattern
      // - attach $ at the end of the pattern when creating the actual RegExp
      //
      // Ah, but wait, no, that all only applies to the root when the first pattern
      // is not an extglob. If the first pattern IS an extglob, then we need all
      // that dot prevention biz to live in the extglob portions, because eg
      // +(*|.x*) can match .xy but not .yx.
      //
      // So, return the two flavors if it's #root and the first child is not an
      // AST, otherwise leave it to the child AST to handle it, and there,
      // use the (?:^|/) style of start binding.
      //
      // Even simplified further:
      // - Since the start for a join is eg /(?!\.) and the start for a part
      // is ^(?!\.), we can just prepend (?!\.) to the pattern (either root
      // or start or whatever) and prepend ^ or / at the Regexp construction.
      toRegExpSource(allowDot) {
        const dot = allowDot ?? !!this.#options.dot;
        if (this.#root === this)
          this.#fillNegs();
        if (!this.type) {
          const noEmpty = this.isStart() && this.isEnd();
          const src = this.#parts.map((p) => {
            const [re, _, hasMagic, uflag] = typeof p === "string" ? _AST.#parseGlob(p, this.#hasMagic, noEmpty) : p.toRegExpSource(allowDot);
            this.#hasMagic = this.#hasMagic || hasMagic;
            this.#uflag = this.#uflag || uflag;
            return re;
          }).join("");
          let start2 = "";
          if (this.isStart()) {
            if (typeof this.#parts[0] === "string") {
              const dotTravAllowed = this.#parts.length === 1 && justDots.has(this.#parts[0]);
              if (!dotTravAllowed) {
                const aps = addPatternStart;
                const needNoTrav = (
                  // dots are allowed, and the pattern starts with [ or .
                  dot && aps.has(src.charAt(0)) || // the pattern starts with \., and then [ or .
                  src.startsWith("\\.") && aps.has(src.charAt(2)) || // the pattern starts with \.\., and then [ or .
                  src.startsWith("\\.\\.") && aps.has(src.charAt(4))
                );
                const needNoDot = !dot && !allowDot && aps.has(src.charAt(0));
                start2 = needNoTrav ? startNoTraversal : needNoDot ? startNoDot : "";
              }
            }
          }
          let end = "";
          if (this.isEnd() && this.#root.#filledNegs && this.#parent?.type === "!") {
            end = "(?:$|\\/)";
          }
          const final2 = start2 + src + end;
          return [
            final2,
            (0, unescape_js_1.unescape)(src),
            this.#hasMagic = !!this.#hasMagic,
            this.#uflag
          ];
        }
        const repeated = this.type === "*" || this.type === "+";
        const start = this.type === "!" ? "(?:(?!(?:" : "(?:";
        let body = this.#partsToRegExp(dot);
        if (this.isStart() && this.isEnd() && !body && this.type !== "!") {
          const s = this.toString();
          this.#parts = [s];
          this.type = null;
          this.#hasMagic = void 0;
          return [s, (0, unescape_js_1.unescape)(this.toString()), false, false];
        }
        let bodyDotAllowed = !repeated || allowDot || dot || !startNoDot ? "" : this.#partsToRegExp(true);
        if (bodyDotAllowed === body) {
          bodyDotAllowed = "";
        }
        if (bodyDotAllowed) {
          body = `(?:${body})(?:${bodyDotAllowed})*?`;
        }
        let final = "";
        if (this.type === "!" && this.#emptyExt) {
          final = (this.isStart() && !dot ? startNoDot : "") + starNoEmpty;
        } else {
          const close = this.type === "!" ? (
            // !() must match something,but !(x) can match ''
            "))" + (this.isStart() && !dot && !allowDot ? startNoDot : "") + star + ")"
          ) : this.type === "@" ? ")" : this.type === "?" ? ")?" : this.type === "+" && bodyDotAllowed ? ")" : this.type === "*" && bodyDotAllowed ? `)?` : `)${this.type}`;
          final = start + body + close;
        }
        return [
          final,
          (0, unescape_js_1.unescape)(body),
          this.#hasMagic = !!this.#hasMagic,
          this.#uflag
        ];
      }
      #partsToRegExp(dot) {
        return this.#parts.map((p) => {
          if (typeof p === "string") {
            throw new Error("string type in extglob ast??");
          }
          const [re, _, _hasMagic, uflag] = p.toRegExpSource(dot);
          this.#uflag = this.#uflag || uflag;
          return re;
        }).filter((p) => !(this.isStart() && this.isEnd()) || !!p).join("|");
      }
      static #parseGlob(glob2, hasMagic, noEmpty = false) {
        let escaping = false;
        let re = "";
        let uflag = false;
        for (let i = 0; i < glob2.length; i++) {
          const c = glob2.charAt(i);
          if (escaping) {
            escaping = false;
            re += (reSpecials.has(c) ? "\\" : "") + c;
            continue;
          }
          if (c === "\\") {
            if (i === glob2.length - 1) {
              re += "\\\\";
            } else {
              escaping = true;
            }
            continue;
          }
          if (c === "[") {
            const [src, needUflag, consumed, magic] = (0, brace_expressions_js_1.parseClass)(glob2, i);
            if (consumed) {
              re += src;
              uflag = uflag || needUflag;
              i += consumed - 1;
              hasMagic = hasMagic || magic;
              continue;
            }
          }
          if (c === "*") {
            if (noEmpty && glob2 === "*")
              re += starNoEmpty;
            else
              re += star;
            hasMagic = true;
            continue;
          }
          if (c === "?") {
            re += qmark;
            hasMagic = true;
            continue;
          }
          re += regExpEscape(c);
        }
        return [re, (0, unescape_js_1.unescape)(glob2), !!hasMagic, uflag];
      }
    };
    exports2.AST = AST;
  }
});

// node_modules/minimatch/dist/commonjs/escape.js
var require_escape = __commonJS({
  "node_modules/minimatch/dist/commonjs/escape.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.escape = void 0;
    var escape2 = (s, { windowsPathsNoEscape = false } = {}) => {
      return windowsPathsNoEscape ? s.replace(/[?*()[\]]/g, "[$&]") : s.replace(/[?*()[\]\\]/g, "\\$&");
    };
    exports2.escape = escape2;
  }
});

// node_modules/minimatch/dist/commonjs/index.js
var require_commonjs = __commonJS({
  "node_modules/minimatch/dist/commonjs/index.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.unescape = exports2.escape = exports2.AST = exports2.Minimatch = exports2.match = exports2.makeRe = exports2.braceExpand = exports2.defaults = exports2.filter = exports2.GLOBSTAR = exports2.sep = exports2.minimatch = void 0;
    var brace_expansion_1 = __importDefault(require_brace_expansion());
    var assert_valid_pattern_js_1 = require_assert_valid_pattern();
    var ast_js_1 = require_ast();
    var escape_js_1 = require_escape();
    var unescape_js_1 = require_unescape();
    var minimatch2 = (p, pattern, options2 = {}) => {
      (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
      if (!options2.nocomment && pattern.charAt(0) === "#") {
        return false;
      }
      return new Minimatch(pattern, options2).match(p);
    };
    exports2.minimatch = minimatch2;
    var starDotExtRE = /^\*+([^+@!?\*\[\(]*)$/;
    var starDotExtTest = (ext2) => (f) => !f.startsWith(".") && f.endsWith(ext2);
    var starDotExtTestDot = (ext2) => (f) => f.endsWith(ext2);
    var starDotExtTestNocase = (ext2) => {
      ext2 = ext2.toLowerCase();
      return (f) => !f.startsWith(".") && f.toLowerCase().endsWith(ext2);
    };
    var starDotExtTestNocaseDot = (ext2) => {
      ext2 = ext2.toLowerCase();
      return (f) => f.toLowerCase().endsWith(ext2);
    };
    var starDotStarRE = /^\*+\.\*+$/;
    var starDotStarTest = (f) => !f.startsWith(".") && f.includes(".");
    var starDotStarTestDot = (f) => f !== "." && f !== ".." && f.includes(".");
    var dotStarRE = /^\.\*+$/;
    var dotStarTest = (f) => f !== "." && f !== ".." && f.startsWith(".");
    var starRE = /^\*+$/;
    var starTest = (f) => f.length !== 0 && !f.startsWith(".");
    var starTestDot = (f) => f.length !== 0 && f !== "." && f !== "..";
    var qmarksRE = /^\?+([^+@!?\*\[\(]*)?$/;
    var qmarksTestNocase = ([$0, ext2 = ""]) => {
      const noext = qmarksTestNoExt([$0]);
      if (!ext2)
        return noext;
      ext2 = ext2.toLowerCase();
      return (f) => noext(f) && f.toLowerCase().endsWith(ext2);
    };
    var qmarksTestNocaseDot = ([$0, ext2 = ""]) => {
      const noext = qmarksTestNoExtDot([$0]);
      if (!ext2)
        return noext;
      ext2 = ext2.toLowerCase();
      return (f) => noext(f) && f.toLowerCase().endsWith(ext2);
    };
    var qmarksTestDot = ([$0, ext2 = ""]) => {
      const noext = qmarksTestNoExtDot([$0]);
      return !ext2 ? noext : (f) => noext(f) && f.endsWith(ext2);
    };
    var qmarksTest = ([$0, ext2 = ""]) => {
      const noext = qmarksTestNoExt([$0]);
      return !ext2 ? noext : (f) => noext(f) && f.endsWith(ext2);
    };
    var qmarksTestNoExt = ([$0]) => {
      const len = $0.length;
      return (f) => f.length === len && !f.startsWith(".");
    };
    var qmarksTestNoExtDot = ([$0]) => {
      const len = $0.length;
      return (f) => f.length === len && f !== "." && f !== "..";
    };
    var defaultPlatform = typeof process === "object" && process ? typeof process.env === "object" && process.env && process.env.__MINIMATCH_TESTING_PLATFORM__ || process.platform : "posix";
    var path2 = {
      win32: { sep: "\\" },
      posix: { sep: "/" }
    };
    exports2.sep = defaultPlatform === "win32" ? path2.win32.sep : path2.posix.sep;
    exports2.minimatch.sep = exports2.sep;
    exports2.GLOBSTAR = Symbol("globstar **");
    exports2.minimatch.GLOBSTAR = exports2.GLOBSTAR;
    var qmark = "[^/]";
    var star = qmark + "*?";
    var twoStarDot = "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?";
    var twoStarNoDot = "(?:(?!(?:\\/|^)\\.).)*?";
    var filter2 = (pattern, options2 = {}) => (p) => (0, exports2.minimatch)(p, pattern, options2);
    exports2.filter = filter2;
    exports2.minimatch.filter = exports2.filter;
    var ext = (a, b = {}) => Object.assign({}, a, b);
    var defaults = (def) => {
      if (!def || typeof def !== "object" || !Object.keys(def).length) {
        return exports2.minimatch;
      }
      const orig = exports2.minimatch;
      const m = (p, pattern, options2 = {}) => orig(p, pattern, ext(def, options2));
      return Object.assign(m, {
        Minimatch: class Minimatch extends orig.Minimatch {
          constructor(pattern, options2 = {}) {
            super(pattern, ext(def, options2));
          }
          static defaults(options2) {
            return orig.defaults(ext(def, options2)).Minimatch;
          }
        },
        AST: class AST extends orig.AST {
          /* c8 ignore start */
          constructor(type, parent, options2 = {}) {
            super(type, parent, ext(def, options2));
          }
          /* c8 ignore stop */
          static fromGlob(pattern, options2 = {}) {
            return orig.AST.fromGlob(pattern, ext(def, options2));
          }
        },
        unescape: (s, options2 = {}) => orig.unescape(s, ext(def, options2)),
        escape: (s, options2 = {}) => orig.escape(s, ext(def, options2)),
        filter: (pattern, options2 = {}) => orig.filter(pattern, ext(def, options2)),
        defaults: (options2) => orig.defaults(ext(def, options2)),
        makeRe: (pattern, options2 = {}) => orig.makeRe(pattern, ext(def, options2)),
        braceExpand: (pattern, options2 = {}) => orig.braceExpand(pattern, ext(def, options2)),
        match: (list2, pattern, options2 = {}) => orig.match(list2, pattern, ext(def, options2)),
        sep: orig.sep,
        GLOBSTAR: exports2.GLOBSTAR
      });
    };
    exports2.defaults = defaults;
    exports2.minimatch.defaults = exports2.defaults;
    var braceExpand = (pattern, options2 = {}) => {
      (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
      if (options2.nobrace || !/\{(?:(?!\{).)*\}/.test(pattern)) {
        return [pattern];
      }
      return (0, brace_expansion_1.default)(pattern);
    };
    exports2.braceExpand = braceExpand;
    exports2.minimatch.braceExpand = exports2.braceExpand;
    var makeRe = (pattern, options2 = {}) => new Minimatch(pattern, options2).makeRe();
    exports2.makeRe = makeRe;
    exports2.minimatch.makeRe = exports2.makeRe;
    var match = (list2, pattern, options2 = {}) => {
      const mm = new Minimatch(pattern, options2);
      list2 = list2.filter((f) => mm.match(f));
      if (mm.options.nonull && !list2.length) {
        list2.push(pattern);
      }
      return list2;
    };
    exports2.match = match;
    exports2.minimatch.match = exports2.match;
    var globMagic = /[?*]|[+@!]\(.*?\)|\[|\]/;
    var regExpEscape = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    var Minimatch = class {
      options;
      set;
      pattern;
      windowsPathsNoEscape;
      nonegate;
      negate;
      comment;
      empty;
      preserveMultipleSlashes;
      partial;
      globSet;
      globParts;
      nocase;
      isWindows;
      platform;
      windowsNoMagicRoot;
      regexp;
      constructor(pattern, options2 = {}) {
        (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
        options2 = options2 || {};
        this.options = options2;
        this.pattern = pattern;
        this.platform = options2.platform || defaultPlatform;
        this.isWindows = this.platform === "win32";
        this.windowsPathsNoEscape = !!options2.windowsPathsNoEscape || options2.allowWindowsEscape === false;
        if (this.windowsPathsNoEscape) {
          this.pattern = this.pattern.replace(/\\/g, "/");
        }
        this.preserveMultipleSlashes = !!options2.preserveMultipleSlashes;
        this.regexp = null;
        this.negate = false;
        this.nonegate = !!options2.nonegate;
        this.comment = false;
        this.empty = false;
        this.partial = !!options2.partial;
        this.nocase = !!this.options.nocase;
        this.windowsNoMagicRoot = options2.windowsNoMagicRoot !== void 0 ? options2.windowsNoMagicRoot : !!(this.isWindows && this.nocase);
        this.globSet = [];
        this.globParts = [];
        this.set = [];
        this.make();
      }
      hasMagic() {
        if (this.options.magicalBraces && this.set.length > 1) {
          return true;
        }
        for (const pattern of this.set) {
          for (const part of pattern) {
            if (typeof part !== "string")
              return true;
          }
        }
        return false;
      }
      debug(..._) {
      }
      make() {
        const pattern = this.pattern;
        const options2 = this.options;
        if (!options2.nocomment && pattern.charAt(0) === "#") {
          this.comment = true;
          return;
        }
        if (!pattern) {
          this.empty = true;
          return;
        }
        this.parseNegate();
        this.globSet = [...new Set(this.braceExpand())];
        if (options2.debug) {
          this.debug = (...args) => console.error(...args);
        }
        this.debug(this.pattern, this.globSet);
        const rawGlobParts = this.globSet.map((s) => this.slashSplit(s));
        this.globParts = this.preprocess(rawGlobParts);
        this.debug(this.pattern, this.globParts);
        let set = this.globParts.map((s, _, __) => {
          if (this.isWindows && this.windowsNoMagicRoot) {
            const isUNC = s[0] === "" && s[1] === "" && (s[2] === "?" || !globMagic.test(s[2])) && !globMagic.test(s[3]);
            const isDrive = /^[a-z]:/i.test(s[0]);
            if (isUNC) {
              return [...s.slice(0, 4), ...s.slice(4).map((ss) => this.parse(ss))];
            } else if (isDrive) {
              return [s[0], ...s.slice(1).map((ss) => this.parse(ss))];
            }
          }
          return s.map((ss) => this.parse(ss));
        });
        this.debug(this.pattern, set);
        this.set = set.filter((s) => s.indexOf(false) === -1);
        if (this.isWindows) {
          for (let i = 0; i < this.set.length; i++) {
            const p = this.set[i];
            if (p[0] === "" && p[1] === "" && this.globParts[i][2] === "?" && typeof p[3] === "string" && /^[a-z]:$/i.test(p[3])) {
              p[2] = "?";
            }
          }
        }
        this.debug(this.pattern, this.set);
      }
      // various transforms to equivalent pattern sets that are
      // faster to process in a filesystem walk.  The goal is to
      // eliminate what we can, and push all ** patterns as far
      // to the right as possible, even if it increases the number
      // of patterns that we have to process.
      preprocess(globParts) {
        if (this.options.noglobstar) {
          for (let i = 0; i < globParts.length; i++) {
            for (let j = 0; j < globParts[i].length; j++) {
              if (globParts[i][j] === "**") {
                globParts[i][j] = "*";
              }
            }
          }
        }
        const { optimizationLevel = 1 } = this.options;
        if (optimizationLevel >= 2) {
          globParts = this.firstPhasePreProcess(globParts);
          globParts = this.secondPhasePreProcess(globParts);
        } else if (optimizationLevel >= 1) {
          globParts = this.levelOneOptimize(globParts);
        } else {
          globParts = this.adjascentGlobstarOptimize(globParts);
        }
        return globParts;
      }
      // just get rid of adjascent ** portions
      adjascentGlobstarOptimize(globParts) {
        return globParts.map((parts) => {
          let gs = -1;
          while (-1 !== (gs = parts.indexOf("**", gs + 1))) {
            let i = gs;
            while (parts[i + 1] === "**") {
              i++;
            }
            if (i !== gs) {
              parts.splice(gs, i - gs);
            }
          }
          return parts;
        });
      }
      // get rid of adjascent ** and resolve .. portions
      levelOneOptimize(globParts) {
        return globParts.map((parts) => {
          parts = parts.reduce((set, part) => {
            const prev = set[set.length - 1];
            if (part === "**" && prev === "**") {
              return set;
            }
            if (part === "..") {
              if (prev && prev !== ".." && prev !== "." && prev !== "**") {
                set.pop();
                return set;
              }
            }
            set.push(part);
            return set;
          }, []);
          return parts.length === 0 ? [""] : parts;
        });
      }
      levelTwoFileOptimize(parts) {
        if (!Array.isArray(parts)) {
          parts = this.slashSplit(parts);
        }
        let didSomething = false;
        do {
          didSomething = false;
          if (!this.preserveMultipleSlashes) {
            for (let i = 1; i < parts.length - 1; i++) {
              const p = parts[i];
              if (i === 1 && p === "" && parts[0] === "")
                continue;
              if (p === "." || p === "") {
                didSomething = true;
                parts.splice(i, 1);
                i--;
              }
            }
            if (parts[0] === "." && parts.length === 2 && (parts[1] === "." || parts[1] === "")) {
              didSomething = true;
              parts.pop();
            }
          }
          let dd = 0;
          while (-1 !== (dd = parts.indexOf("..", dd + 1))) {
            const p = parts[dd - 1];
            if (p && p !== "." && p !== ".." && p !== "**") {
              didSomething = true;
              parts.splice(dd - 1, 2);
              dd -= 2;
            }
          }
        } while (didSomething);
        return parts.length === 0 ? [""] : parts;
      }
      // First phase: single-pattern processing
      // <pre> is 1 or more portions
      // <rest> is 1 or more portions
      // <p> is any portion other than ., .., '', or **
      // <e> is . or ''
      //
      // **/.. is *brutal* for filesystem walking performance, because
      // it effectively resets the recursive walk each time it occurs,
      // and ** cannot be reduced out by a .. pattern part like a regexp
      // or most strings (other than .., ., and '') can be.
      //
      // <pre>/**/../<p>/<p>/<rest> -> {<pre>/../<p>/<p>/<rest>,<pre>/**/<p>/<p>/<rest>}
      // <pre>/<e>/<rest> -> <pre>/<rest>
      // <pre>/<p>/../<rest> -> <pre>/<rest>
      // **/**/<rest> -> **/<rest>
      //
      // **/*/<rest> -> */**/<rest> <== not valid because ** doesn't follow
      // this WOULD be allowed if ** did follow symlinks, or * didn't
      firstPhasePreProcess(globParts) {
        let didSomething = false;
        do {
          didSomething = false;
          for (let parts of globParts) {
            let gs = -1;
            while (-1 !== (gs = parts.indexOf("**", gs + 1))) {
              let gss = gs;
              while (parts[gss + 1] === "**") {
                gss++;
              }
              if (gss > gs) {
                parts.splice(gs + 1, gss - gs);
              }
              let next = parts[gs + 1];
              const p = parts[gs + 2];
              const p2 = parts[gs + 3];
              if (next !== "..")
                continue;
              if (!p || p === "." || p === ".." || !p2 || p2 === "." || p2 === "..") {
                continue;
              }
              didSomething = true;
              parts.splice(gs, 1);
              const other = parts.slice(0);
              other[gs] = "**";
              globParts.push(other);
              gs--;
            }
            if (!this.preserveMultipleSlashes) {
              for (let i = 1; i < parts.length - 1; i++) {
                const p = parts[i];
                if (i === 1 && p === "" && parts[0] === "")
                  continue;
                if (p === "." || p === "") {
                  didSomething = true;
                  parts.splice(i, 1);
                  i--;
                }
              }
              if (parts[0] === "." && parts.length === 2 && (parts[1] === "." || parts[1] === "")) {
                didSomething = true;
                parts.pop();
              }
            }
            let dd = 0;
            while (-1 !== (dd = parts.indexOf("..", dd + 1))) {
              const p = parts[dd - 1];
              if (p && p !== "." && p !== ".." && p !== "**") {
                didSomething = true;
                const needDot = dd === 1 && parts[dd + 1] === "**";
                const splin = needDot ? ["."] : [];
                parts.splice(dd - 1, 2, ...splin);
                if (parts.length === 0)
                  parts.push("");
                dd -= 2;
              }
            }
          }
        } while (didSomething);
        return globParts;
      }
      // second phase: multi-pattern dedupes
      // {<pre>/*/<rest>,<pre>/<p>/<rest>} -> <pre>/*/<rest>
      // {<pre>/<rest>,<pre>/<rest>} -> <pre>/<rest>
      // {<pre>/**/<rest>,<pre>/<rest>} -> <pre>/**/<rest>
      //
      // {<pre>/**/<rest>,<pre>/**/<p>/<rest>} -> <pre>/**/<rest>
      // ^-- not valid because ** doens't follow symlinks
      secondPhasePreProcess(globParts) {
        for (let i = 0; i < globParts.length - 1; i++) {
          for (let j = i + 1; j < globParts.length; j++) {
            const matched = this.partsMatch(globParts[i], globParts[j], !this.preserveMultipleSlashes);
            if (matched) {
              globParts[i] = [];
              globParts[j] = matched;
              break;
            }
          }
        }
        return globParts.filter((gs) => gs.length);
      }
      partsMatch(a, b, emptyGSMatch = false) {
        let ai = 0;
        let bi = 0;
        let result = [];
        let which2 = "";
        while (ai < a.length && bi < b.length) {
          if (a[ai] === b[bi]) {
            result.push(which2 === "b" ? b[bi] : a[ai]);
            ai++;
            bi++;
          } else if (emptyGSMatch && a[ai] === "**" && b[bi] === a[ai + 1]) {
            result.push(a[ai]);
            ai++;
          } else if (emptyGSMatch && b[bi] === "**" && a[ai] === b[bi + 1]) {
            result.push(b[bi]);
            bi++;
          } else if (a[ai] === "*" && b[bi] && (this.options.dot || !b[bi].startsWith(".")) && b[bi] !== "**") {
            if (which2 === "b")
              return false;
            which2 = "a";
            result.push(a[ai]);
            ai++;
            bi++;
          } else if (b[bi] === "*" && a[ai] && (this.options.dot || !a[ai].startsWith(".")) && a[ai] !== "**") {
            if (which2 === "a")
              return false;
            which2 = "b";
            result.push(b[bi]);
            ai++;
            bi++;
          } else {
            return false;
          }
        }
        return a.length === b.length && result;
      }
      parseNegate() {
        if (this.nonegate)
          return;
        const pattern = this.pattern;
        let negate = false;
        let negateOffset = 0;
        for (let i = 0; i < pattern.length && pattern.charAt(i) === "!"; i++) {
          negate = !negate;
          negateOffset++;
        }
        if (negateOffset)
          this.pattern = pattern.slice(negateOffset);
        this.negate = negate;
      }
      // set partial to true to test if, for example,
      // "/a/b" matches the start of "/*/b/*/d"
      // Partial means, if you run out of file before you run
      // out of pattern, then that's fine, as long as all
      // the parts match.
      matchOne(file, pattern, partial = false) {
        const options2 = this.options;
        if (this.isWindows) {
          const fileDrive = typeof file[0] === "string" && /^[a-z]:$/i.test(file[0]);
          const fileUNC = !fileDrive && file[0] === "" && file[1] === "" && file[2] === "?" && /^[a-z]:$/i.test(file[3]);
          const patternDrive = typeof pattern[0] === "string" && /^[a-z]:$/i.test(pattern[0]);
          const patternUNC = !patternDrive && pattern[0] === "" && pattern[1] === "" && pattern[2] === "?" && typeof pattern[3] === "string" && /^[a-z]:$/i.test(pattern[3]);
          const fdi = fileUNC ? 3 : fileDrive ? 0 : void 0;
          const pdi = patternUNC ? 3 : patternDrive ? 0 : void 0;
          if (typeof fdi === "number" && typeof pdi === "number") {
            const [fd, pd] = [file[fdi], pattern[pdi]];
            if (fd.toLowerCase() === pd.toLowerCase()) {
              pattern[pdi] = fd;
              if (pdi > fdi) {
                pattern = pattern.slice(pdi);
              } else if (fdi > pdi) {
                file = file.slice(fdi);
              }
            }
          }
        }
        const { optimizationLevel = 1 } = this.options;
        if (optimizationLevel >= 2) {
          file = this.levelTwoFileOptimize(file);
        }
        this.debug("matchOne", this, { file, pattern });
        this.debug("matchOne", file.length, pattern.length);
        for (var fi = 0, pi = 0, fl = file.length, pl = pattern.length; fi < fl && pi < pl; fi++, pi++) {
          this.debug("matchOne loop");
          var p = pattern[pi];
          var f = file[fi];
          this.debug(pattern, p, f);
          if (p === false) {
            return false;
          }
          if (p === exports2.GLOBSTAR) {
            this.debug("GLOBSTAR", [pattern, p, f]);
            var fr = fi;
            var pr = pi + 1;
            if (pr === pl) {
              this.debug("** at the end");
              for (; fi < fl; fi++) {
                if (file[fi] === "." || file[fi] === ".." || !options2.dot && file[fi].charAt(0) === ".")
                  return false;
              }
              return true;
            }
            while (fr < fl) {
              var swallowee = file[fr];
              this.debug("\nglobstar while", file, fr, pattern, pr, swallowee);
              if (this.matchOne(file.slice(fr), pattern.slice(pr), partial)) {
                this.debug("globstar found match!", fr, fl, swallowee);
                return true;
              } else {
                if (swallowee === "." || swallowee === ".." || !options2.dot && swallowee.charAt(0) === ".") {
                  this.debug("dot detected!", file, fr, pattern, pr);
                  break;
                }
                this.debug("globstar swallow a segment, and continue");
                fr++;
              }
            }
            if (partial) {
              this.debug("\n>>> no match, partial?", file, fr, pattern, pr);
              if (fr === fl) {
                return true;
              }
            }
            return false;
          }
          let hit;
          if (typeof p === "string") {
            hit = f === p;
            this.debug("string match", p, f, hit);
          } else {
            hit = p.test(f);
            this.debug("pattern match", p, f, hit);
          }
          if (!hit)
            return false;
        }
        if (fi === fl && pi === pl) {
          return true;
        } else if (fi === fl) {
          return partial;
        } else if (pi === pl) {
          return fi === fl - 1 && file[fi] === "";
        } else {
          throw new Error("wtf?");
        }
      }
      braceExpand() {
        return (0, exports2.braceExpand)(this.pattern, this.options);
      }
      parse(pattern) {
        (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
        const options2 = this.options;
        if (pattern === "**")
          return exports2.GLOBSTAR;
        if (pattern === "")
          return "";
        let m;
        let fastTest = null;
        if (m = pattern.match(starRE)) {
          fastTest = options2.dot ? starTestDot : starTest;
        } else if (m = pattern.match(starDotExtRE)) {
          fastTest = (options2.nocase ? options2.dot ? starDotExtTestNocaseDot : starDotExtTestNocase : options2.dot ? starDotExtTestDot : starDotExtTest)(m[1]);
        } else if (m = pattern.match(qmarksRE)) {
          fastTest = (options2.nocase ? options2.dot ? qmarksTestNocaseDot : qmarksTestNocase : options2.dot ? qmarksTestDot : qmarksTest)(m);
        } else if (m = pattern.match(starDotStarRE)) {
          fastTest = options2.dot ? starDotStarTestDot : starDotStarTest;
        } else if (m = pattern.match(dotStarRE)) {
          fastTest = dotStarTest;
        }
        const re = ast_js_1.AST.fromGlob(pattern, this.options).toMMPattern();
        if (fastTest && typeof re === "object") {
          Reflect.defineProperty(re, "test", { value: fastTest });
        }
        return re;
      }
      makeRe() {
        if (this.regexp || this.regexp === false)
          return this.regexp;
        const set = this.set;
        if (!set.length) {
          this.regexp = false;
          return this.regexp;
        }
        const options2 = this.options;
        const twoStar = options2.noglobstar ? star : options2.dot ? twoStarDot : twoStarNoDot;
        const flags = new Set(options2.nocase ? ["i"] : []);
        let re = set.map((pattern) => {
          const pp = pattern.map((p) => {
            if (p instanceof RegExp) {
              for (const f of p.flags.split(""))
                flags.add(f);
            }
            return typeof p === "string" ? regExpEscape(p) : p === exports2.GLOBSTAR ? exports2.GLOBSTAR : p._src;
          });
          pp.forEach((p, i) => {
            const next = pp[i + 1];
            const prev = pp[i - 1];
            if (p !== exports2.GLOBSTAR || prev === exports2.GLOBSTAR) {
              return;
            }
            if (prev === void 0) {
              if (next !== void 0 && next !== exports2.GLOBSTAR) {
                pp[i + 1] = "(?:\\/|" + twoStar + "\\/)?" + next;
              } else {
                pp[i] = twoStar;
              }
            } else if (next === void 0) {
              pp[i - 1] = prev + "(?:\\/|" + twoStar + ")?";
            } else if (next !== exports2.GLOBSTAR) {
              pp[i - 1] = prev + "(?:\\/|\\/" + twoStar + "\\/)" + next;
              pp[i + 1] = exports2.GLOBSTAR;
            }
          });
          return pp.filter((p) => p !== exports2.GLOBSTAR).join("/");
        }).join("|");
        const [open, close] = set.length > 1 ? ["(?:", ")"] : ["", ""];
        re = "^" + open + re + close + "$";
        if (this.negate)
          re = "^(?!" + re + ").+$";
        try {
          this.regexp = new RegExp(re, [...flags].join(""));
        } catch (ex) {
          this.regexp = false;
        }
        return this.regexp;
      }
      slashSplit(p) {
        if (this.preserveMultipleSlashes) {
          return p.split("/");
        } else if (this.isWindows && /^\/\/[^\/]+/.test(p)) {
          return ["", ...p.split(/\/+/)];
        } else {
          return p.split(/\/+/);
        }
      }
      match(f, partial = this.partial) {
        this.debug("match", f, this.pattern);
        if (this.comment) {
          return false;
        }
        if (this.empty) {
          return f === "";
        }
        if (f === "/" && partial) {
          return true;
        }
        const options2 = this.options;
        if (this.isWindows) {
          f = f.split("\\").join("/");
        }
        const ff = this.slashSplit(f);
        this.debug(this.pattern, "split", ff);
        const set = this.set;
        this.debug(this.pattern, "set", set);
        let filename = ff[ff.length - 1];
        if (!filename) {
          for (let i = ff.length - 2; !filename && i >= 0; i--) {
            filename = ff[i];
          }
        }
        for (let i = 0; i < set.length; i++) {
          const pattern = set[i];
          let file = ff;
          if (options2.matchBase && pattern.length === 1) {
            file = [filename];
          }
          const hit = this.matchOne(file, pattern, partial);
          if (hit) {
            if (options2.flipNegate) {
              return true;
            }
            return !this.negate;
          }
        }
        if (options2.flipNegate) {
          return false;
        }
        return this.negate;
      }
      static defaults(def) {
        return exports2.minimatch.defaults(def).Minimatch;
      }
    };
    exports2.Minimatch = Minimatch;
    var ast_js_2 = require_ast();
    Object.defineProperty(exports2, "AST", { enumerable: true, get: function() {
      return ast_js_2.AST;
    } });
    var escape_js_2 = require_escape();
    Object.defineProperty(exports2, "escape", { enumerable: true, get: function() {
      return escape_js_2.escape;
    } });
    var unescape_js_2 = require_unescape();
    Object.defineProperty(exports2, "unescape", { enumerable: true, get: function() {
      return unescape_js_2.unescape;
    } });
    exports2.minimatch.AST = ast_js_1.AST;
    exports2.minimatch.Minimatch = Minimatch;
    exports2.minimatch.escape = escape_js_1.escape;
    exports2.minimatch.unescape = unescape_js_1.unescape;
  }
});

// node_modules/lru-cache/dist/commonjs/index.js
var require_commonjs2 = __commonJS({
  "node_modules/lru-cache/dist/commonjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.LRUCache = void 0;
    var perf = typeof performance === "object" && performance && typeof performance.now === "function" ? performance : Date;
    var warned = /* @__PURE__ */ new Set();
    var PROCESS = typeof process === "object" && !!process ? process : {};
    var emitWarning = (msg, type, code, fn) => {
      typeof PROCESS.emitWarning === "function" ? PROCESS.emitWarning(msg, type, code, fn) : console.error(`[${code}] ${type}: ${msg}`);
    };
    var AC = globalThis.AbortController;
    var AS = globalThis.AbortSignal;
    if (typeof AC === "undefined") {
      AS = class AbortSignal {
        onabort;
        _onabort = [];
        reason;
        aborted = false;
        addEventListener(_, fn) {
          this._onabort.push(fn);
        }
      };
      AC = class AbortController {
        constructor() {
          warnACPolyfill();
        }
        signal = new AS();
        abort(reason) {
          if (this.signal.aborted)
            return;
          this.signal.reason = reason;
          this.signal.aborted = true;
          for (const fn of this.signal._onabort) {
            fn(reason);
          }
          this.signal.onabort?.(reason);
        }
      };
      let printACPolyfillWarning = PROCESS.env?.LRU_CACHE_IGNORE_AC_WARNING !== "1";
      const warnACPolyfill = () => {
        if (!printACPolyfillWarning)
          return;
        printACPolyfillWarning = false;
        emitWarning("AbortController is not defined. If using lru-cache in node 14, load an AbortController polyfill from the `node-abort-controller` package. A minimal polyfill is provided for use by LRUCache.fetch(), but it should not be relied upon in other contexts (eg, passing it to other APIs that use AbortController/AbortSignal might have undesirable effects). You may disable this with LRU_CACHE_IGNORE_AC_WARNING=1 in the env.", "NO_ABORT_CONTROLLER", "ENOTSUP", warnACPolyfill);
      };
    }
    var shouldWarn = (code) => !warned.has(code);
    var TYPE = Symbol("type");
    var isPosInt = (n) => n && n === Math.floor(n) && n > 0 && isFinite(n);
    var getUintArray = (max) => !isPosInt(max) ? null : max <= Math.pow(2, 8) ? Uint8Array : max <= Math.pow(2, 16) ? Uint16Array : max <= Math.pow(2, 32) ? Uint32Array : max <= Number.MAX_SAFE_INTEGER ? ZeroArray : null;
    var ZeroArray = class extends Array {
      constructor(size) {
        super(size);
        this.fill(0);
      }
    };
    var Stack = class _Stack {
      heap;
      length;
      // private constructor
      static #constructing = false;
      static create(max) {
        const HeapCls = getUintArray(max);
        if (!HeapCls)
          return [];
        _Stack.#constructing = true;
        const s = new _Stack(max, HeapCls);
        _Stack.#constructing = false;
        return s;
      }
      constructor(max, HeapCls) {
        if (!_Stack.#constructing) {
          throw new TypeError("instantiate Stack using Stack.create(n)");
        }
        this.heap = new HeapCls(max);
        this.length = 0;
      }
      push(n) {
        this.heap[this.length++] = n;
      }
      pop() {
        return this.heap[--this.length];
      }
    };
    var LRUCache2 = class _LRUCache {
      // options that cannot be changed without disaster
      #max;
      #maxSize;
      #dispose;
      #disposeAfter;
      #fetchMethod;
      #memoMethod;
      /**
       * {@link LRUCache.OptionsBase.ttl}
       */
      ttl;
      /**
       * {@link LRUCache.OptionsBase.ttlResolution}
       */
      ttlResolution;
      /**
       * {@link LRUCache.OptionsBase.ttlAutopurge}
       */
      ttlAutopurge;
      /**
       * {@link LRUCache.OptionsBase.updateAgeOnGet}
       */
      updateAgeOnGet;
      /**
       * {@link LRUCache.OptionsBase.updateAgeOnHas}
       */
      updateAgeOnHas;
      /**
       * {@link LRUCache.OptionsBase.allowStale}
       */
      allowStale;
      /**
       * {@link LRUCache.OptionsBase.noDisposeOnSet}
       */
      noDisposeOnSet;
      /**
       * {@link LRUCache.OptionsBase.noUpdateTTL}
       */
      noUpdateTTL;
      /**
       * {@link LRUCache.OptionsBase.maxEntrySize}
       */
      maxEntrySize;
      /**
       * {@link LRUCache.OptionsBase.sizeCalculation}
       */
      sizeCalculation;
      /**
       * {@link LRUCache.OptionsBase.noDeleteOnFetchRejection}
       */
      noDeleteOnFetchRejection;
      /**
       * {@link LRUCache.OptionsBase.noDeleteOnStaleGet}
       */
      noDeleteOnStaleGet;
      /**
       * {@link LRUCache.OptionsBase.allowStaleOnFetchAbort}
       */
      allowStaleOnFetchAbort;
      /**
       * {@link LRUCache.OptionsBase.allowStaleOnFetchRejection}
       */
      allowStaleOnFetchRejection;
      /**
       * {@link LRUCache.OptionsBase.ignoreFetchAbort}
       */
      ignoreFetchAbort;
      // computed properties
      #size;
      #calculatedSize;
      #keyMap;
      #keyList;
      #valList;
      #next;
      #prev;
      #head;
      #tail;
      #free;
      #disposed;
      #sizes;
      #starts;
      #ttls;
      #hasDispose;
      #hasFetchMethod;
      #hasDisposeAfter;
      /**
       * Do not call this method unless you need to inspect the
       * inner workings of the cache.  If anything returned by this
       * object is modified in any way, strange breakage may occur.
       *
       * These fields are private for a reason!
       *
       * @internal
       */
      static unsafeExposeInternals(c) {
        return {
          // properties
          starts: c.#starts,
          ttls: c.#ttls,
          sizes: c.#sizes,
          keyMap: c.#keyMap,
          keyList: c.#keyList,
          valList: c.#valList,
          next: c.#next,
          prev: c.#prev,
          get head() {
            return c.#head;
          },
          get tail() {
            return c.#tail;
          },
          free: c.#free,
          // methods
          isBackgroundFetch: (p) => c.#isBackgroundFetch(p),
          backgroundFetch: (k, index, options2, context) => c.#backgroundFetch(k, index, options2, context),
          moveToTail: (index) => c.#moveToTail(index),
          indexes: (options2) => c.#indexes(options2),
          rindexes: (options2) => c.#rindexes(options2),
          isStale: (index) => c.#isStale(index)
        };
      }
      // Protected read-only members
      /**
       * {@link LRUCache.OptionsBase.max} (read-only)
       */
      get max() {
        return this.#max;
      }
      /**
       * {@link LRUCache.OptionsBase.maxSize} (read-only)
       */
      get maxSize() {
        return this.#maxSize;
      }
      /**
       * The total computed size of items in the cache (read-only)
       */
      get calculatedSize() {
        return this.#calculatedSize;
      }
      /**
       * The number of items stored in the cache (read-only)
       */
      get size() {
        return this.#size;
      }
      /**
       * {@link LRUCache.OptionsBase.fetchMethod} (read-only)
       */
      get fetchMethod() {
        return this.#fetchMethod;
      }
      get memoMethod() {
        return this.#memoMethod;
      }
      /**
       * {@link LRUCache.OptionsBase.dispose} (read-only)
       */
      get dispose() {
        return this.#dispose;
      }
      /**
       * {@link LRUCache.OptionsBase.disposeAfter} (read-only)
       */
      get disposeAfter() {
        return this.#disposeAfter;
      }
      constructor(options2) {
        const { max = 0, ttl, ttlResolution = 1, ttlAutopurge, updateAgeOnGet, updateAgeOnHas, allowStale, dispose, disposeAfter, noDisposeOnSet, noUpdateTTL, maxSize = 0, maxEntrySize = 0, sizeCalculation, fetchMethod, memoMethod, noDeleteOnFetchRejection, noDeleteOnStaleGet, allowStaleOnFetchRejection, allowStaleOnFetchAbort, ignoreFetchAbort } = options2;
        if (max !== 0 && !isPosInt(max)) {
          throw new TypeError("max option must be a nonnegative integer");
        }
        const UintArray = max ? getUintArray(max) : Array;
        if (!UintArray) {
          throw new Error("invalid max value: " + max);
        }
        this.#max = max;
        this.#maxSize = maxSize;
        this.maxEntrySize = maxEntrySize || this.#maxSize;
        this.sizeCalculation = sizeCalculation;
        if (this.sizeCalculation) {
          if (!this.#maxSize && !this.maxEntrySize) {
            throw new TypeError("cannot set sizeCalculation without setting maxSize or maxEntrySize");
          }
          if (typeof this.sizeCalculation !== "function") {
            throw new TypeError("sizeCalculation set to non-function");
          }
        }
        if (memoMethod !== void 0 && typeof memoMethod !== "function") {
          throw new TypeError("memoMethod must be a function if defined");
        }
        this.#memoMethod = memoMethod;
        if (fetchMethod !== void 0 && typeof fetchMethod !== "function") {
          throw new TypeError("fetchMethod must be a function if specified");
        }
        this.#fetchMethod = fetchMethod;
        this.#hasFetchMethod = !!fetchMethod;
        this.#keyMap = /* @__PURE__ */ new Map();
        this.#keyList = new Array(max).fill(void 0);
        this.#valList = new Array(max).fill(void 0);
        this.#next = new UintArray(max);
        this.#prev = new UintArray(max);
        this.#head = 0;
        this.#tail = 0;
        this.#free = Stack.create(max);
        this.#size = 0;
        this.#calculatedSize = 0;
        if (typeof dispose === "function") {
          this.#dispose = dispose;
        }
        if (typeof disposeAfter === "function") {
          this.#disposeAfter = disposeAfter;
          this.#disposed = [];
        } else {
          this.#disposeAfter = void 0;
          this.#disposed = void 0;
        }
        this.#hasDispose = !!this.#dispose;
        this.#hasDisposeAfter = !!this.#disposeAfter;
        this.noDisposeOnSet = !!noDisposeOnSet;
        this.noUpdateTTL = !!noUpdateTTL;
        this.noDeleteOnFetchRejection = !!noDeleteOnFetchRejection;
        this.allowStaleOnFetchRejection = !!allowStaleOnFetchRejection;
        this.allowStaleOnFetchAbort = !!allowStaleOnFetchAbort;
        this.ignoreFetchAbort = !!ignoreFetchAbort;
        if (this.maxEntrySize !== 0) {
          if (this.#maxSize !== 0) {
            if (!isPosInt(this.#maxSize)) {
              throw new TypeError("maxSize must be a positive integer if specified");
            }
          }
          if (!isPosInt(this.maxEntrySize)) {
            throw new TypeError("maxEntrySize must be a positive integer if specified");
          }
          this.#initializeSizeTracking();
        }
        this.allowStale = !!allowStale;
        this.noDeleteOnStaleGet = !!noDeleteOnStaleGet;
        this.updateAgeOnGet = !!updateAgeOnGet;
        this.updateAgeOnHas = !!updateAgeOnHas;
        this.ttlResolution = isPosInt(ttlResolution) || ttlResolution === 0 ? ttlResolution : 1;
        this.ttlAutopurge = !!ttlAutopurge;
        this.ttl = ttl || 0;
        if (this.ttl) {
          if (!isPosInt(this.ttl)) {
            throw new TypeError("ttl must be a positive integer if specified");
          }
          this.#initializeTTLTracking();
        }
        if (this.#max === 0 && this.ttl === 0 && this.#maxSize === 0) {
          throw new TypeError("At least one of max, maxSize, or ttl is required");
        }
        if (!this.ttlAutopurge && !this.#max && !this.#maxSize) {
          const code = "LRU_CACHE_UNBOUNDED";
          if (shouldWarn(code)) {
            warned.add(code);
            const msg = "TTL caching without ttlAutopurge, max, or maxSize can result in unbounded memory consumption.";
            emitWarning(msg, "UnboundedCacheWarning", code, _LRUCache);
          }
        }
      }
      /**
       * Return the number of ms left in the item's TTL. If item is not in cache,
       * returns `0`. Returns `Infinity` if item is in cache without a defined TTL.
       */
      getRemainingTTL(key) {
        return this.#keyMap.has(key) ? Infinity : 0;
      }
      #initializeTTLTracking() {
        const ttls = new ZeroArray(this.#max);
        const starts = new ZeroArray(this.#max);
        this.#ttls = ttls;
        this.#starts = starts;
        this.#setItemTTL = (index, ttl, start = perf.now()) => {
          starts[index] = ttl !== 0 ? start : 0;
          ttls[index] = ttl;
          if (ttl !== 0 && this.ttlAutopurge) {
            const t = setTimeout(() => {
              if (this.#isStale(index)) {
                this.#delete(this.#keyList[index], "expire");
              }
            }, ttl + 1);
            if (t.unref) {
              t.unref();
            }
          }
        };
        this.#updateItemAge = (index) => {
          starts[index] = ttls[index] !== 0 ? perf.now() : 0;
        };
        this.#statusTTL = (status, index) => {
          if (ttls[index]) {
            const ttl = ttls[index];
            const start = starts[index];
            if (!ttl || !start)
              return;
            status.ttl = ttl;
            status.start = start;
            status.now = cachedNow || getNow();
            const age = status.now - start;
            status.remainingTTL = ttl - age;
          }
        };
        let cachedNow = 0;
        const getNow = () => {
          const n = perf.now();
          if (this.ttlResolution > 0) {
            cachedNow = n;
            const t = setTimeout(() => cachedNow = 0, this.ttlResolution);
            if (t.unref) {
              t.unref();
            }
          }
          return n;
        };
        this.getRemainingTTL = (key) => {
          const index = this.#keyMap.get(key);
          if (index === void 0) {
            return 0;
          }
          const ttl = ttls[index];
          const start = starts[index];
          if (!ttl || !start) {
            return Infinity;
          }
          const age = (cachedNow || getNow()) - start;
          return ttl - age;
        };
        this.#isStale = (index) => {
          const s = starts[index];
          const t = ttls[index];
          return !!t && !!s && (cachedNow || getNow()) - s > t;
        };
      }
      // conditionally set private methods related to TTL
      #updateItemAge = () => {
      };
      #statusTTL = () => {
      };
      #setItemTTL = () => {
      };
      /* c8 ignore stop */
      #isStale = () => false;
      #initializeSizeTracking() {
        const sizes = new ZeroArray(this.#max);
        this.#calculatedSize = 0;
        this.#sizes = sizes;
        this.#removeItemSize = (index) => {
          this.#calculatedSize -= sizes[index];
          sizes[index] = 0;
        };
        this.#requireSize = (k, v, size, sizeCalculation) => {
          if (this.#isBackgroundFetch(v)) {
            return 0;
          }
          if (!isPosInt(size)) {
            if (sizeCalculation) {
              if (typeof sizeCalculation !== "function") {
                throw new TypeError("sizeCalculation must be a function");
              }
              size = sizeCalculation(v, k);
              if (!isPosInt(size)) {
                throw new TypeError("sizeCalculation return invalid (expect positive integer)");
              }
            } else {
              throw new TypeError("invalid size value (must be positive integer). When maxSize or maxEntrySize is used, sizeCalculation or size must be set.");
            }
          }
          return size;
        };
        this.#addItemSize = (index, size, status) => {
          sizes[index] = size;
          if (this.#maxSize) {
            const maxSize = this.#maxSize - sizes[index];
            while (this.#calculatedSize > maxSize) {
              this.#evict(true);
            }
          }
          this.#calculatedSize += sizes[index];
          if (status) {
            status.entrySize = size;
            status.totalCalculatedSize = this.#calculatedSize;
          }
        };
      }
      #removeItemSize = (_i) => {
      };
      #addItemSize = (_i, _s, _st) => {
      };
      #requireSize = (_k, _v, size, sizeCalculation) => {
        if (size || sizeCalculation) {
          throw new TypeError("cannot set size without setting maxSize or maxEntrySize on cache");
        }
        return 0;
      };
      *#indexes({ allowStale = this.allowStale } = {}) {
        if (this.#size) {
          for (let i = this.#tail; true; ) {
            if (!this.#isValidIndex(i)) {
              break;
            }
            if (allowStale || !this.#isStale(i)) {
              yield i;
            }
            if (i === this.#head) {
              break;
            } else {
              i = this.#prev[i];
            }
          }
        }
      }
      *#rindexes({ allowStale = this.allowStale } = {}) {
        if (this.#size) {
          for (let i = this.#head; true; ) {
            if (!this.#isValidIndex(i)) {
              break;
            }
            if (allowStale || !this.#isStale(i)) {
              yield i;
            }
            if (i === this.#tail) {
              break;
            } else {
              i = this.#next[i];
            }
          }
        }
      }
      #isValidIndex(index) {
        return index !== void 0 && this.#keyMap.get(this.#keyList[index]) === index;
      }
      /**
       * Return a generator yielding `[key, value]` pairs,
       * in order from most recently used to least recently used.
       */
      *entries() {
        for (const i of this.#indexes()) {
          if (this.#valList[i] !== void 0 && this.#keyList[i] !== void 0 && !this.#isBackgroundFetch(this.#valList[i])) {
            yield [this.#keyList[i], this.#valList[i]];
          }
        }
      }
      /**
       * Inverse order version of {@link LRUCache.entries}
       *
       * Return a generator yielding `[key, value]` pairs,
       * in order from least recently used to most recently used.
       */
      *rentries() {
        for (const i of this.#rindexes()) {
          if (this.#valList[i] !== void 0 && this.#keyList[i] !== void 0 && !this.#isBackgroundFetch(this.#valList[i])) {
            yield [this.#keyList[i], this.#valList[i]];
          }
        }
      }
      /**
       * Return a generator yielding the keys in the cache,
       * in order from most recently used to least recently used.
       */
      *keys() {
        for (const i of this.#indexes()) {
          const k = this.#keyList[i];
          if (k !== void 0 && !this.#isBackgroundFetch(this.#valList[i])) {
            yield k;
          }
        }
      }
      /**
       * Inverse order version of {@link LRUCache.keys}
       *
       * Return a generator yielding the keys in the cache,
       * in order from least recently used to most recently used.
       */
      *rkeys() {
        for (const i of this.#rindexes()) {
          const k = this.#keyList[i];
          if (k !== void 0 && !this.#isBackgroundFetch(this.#valList[i])) {
            yield k;
          }
        }
      }
      /**
       * Return a generator yielding the values in the cache,
       * in order from most recently used to least recently used.
       */
      *values() {
        for (const i of this.#indexes()) {
          const v = this.#valList[i];
          if (v !== void 0 && !this.#isBackgroundFetch(this.#valList[i])) {
            yield this.#valList[i];
          }
        }
      }
      /**
       * Inverse order version of {@link LRUCache.values}
       *
       * Return a generator yielding the values in the cache,
       * in order from least recently used to most recently used.
       */
      *rvalues() {
        for (const i of this.#rindexes()) {
          const v = this.#valList[i];
          if (v !== void 0 && !this.#isBackgroundFetch(this.#valList[i])) {
            yield this.#valList[i];
          }
        }
      }
      /**
       * Iterating over the cache itself yields the same results as
       * {@link LRUCache.entries}
       */
      [Symbol.iterator]() {
        return this.entries();
      }
      /**
       * A String value that is used in the creation of the default string
       * description of an object. Called by the built-in method
       * `Object.prototype.toString`.
       */
      [Symbol.toStringTag] = "LRUCache";
      /**
       * Find a value for which the supplied fn method returns a truthy value,
       * similar to `Array.find()`. fn is called as `fn(value, key, cache)`.
       */
      find(fn, getOptions = {}) {
        for (const i of this.#indexes()) {
          const v = this.#valList[i];
          const value = this.#isBackgroundFetch(v) ? v.__staleWhileFetching : v;
          if (value === void 0)
            continue;
          if (fn(value, this.#keyList[i], this)) {
            return this.get(this.#keyList[i], getOptions);
          }
        }
      }
      /**
       * Call the supplied function on each item in the cache, in order from most
       * recently used to least recently used.
       *
       * `fn` is called as `fn(value, key, cache)`.
       *
       * If `thisp` is provided, function will be called in the `this`-context of
       * the provided object, or the cache if no `thisp` object is provided.
       *
       * Does not update age or recenty of use, or iterate over stale values.
       */
      forEach(fn, thisp = this) {
        for (const i of this.#indexes()) {
          const v = this.#valList[i];
          const value = this.#isBackgroundFetch(v) ? v.__staleWhileFetching : v;
          if (value === void 0)
            continue;
          fn.call(thisp, value, this.#keyList[i], this);
        }
      }
      /**
       * The same as {@link LRUCache.forEach} but items are iterated over in
       * reverse order.  (ie, less recently used items are iterated over first.)
       */
      rforEach(fn, thisp = this) {
        for (const i of this.#rindexes()) {
          const v = this.#valList[i];
          const value = this.#isBackgroundFetch(v) ? v.__staleWhileFetching : v;
          if (value === void 0)
            continue;
          fn.call(thisp, value, this.#keyList[i], this);
        }
      }
      /**
       * Delete any stale entries. Returns true if anything was removed,
       * false otherwise.
       */
      purgeStale() {
        let deleted = false;
        for (const i of this.#rindexes({ allowStale: true })) {
          if (this.#isStale(i)) {
            this.#delete(this.#keyList[i], "expire");
            deleted = true;
          }
        }
        return deleted;
      }
      /**
       * Get the extended info about a given entry, to get its value, size, and
       * TTL info simultaneously. Returns `undefined` if the key is not present.
       *
       * Unlike {@link LRUCache#dump}, which is designed to be portable and survive
       * serialization, the `start` value is always the current timestamp, and the
       * `ttl` is a calculated remaining time to live (negative if expired).
       *
       * Always returns stale values, if their info is found in the cache, so be
       * sure to check for expirations (ie, a negative {@link LRUCache.Entry#ttl})
       * if relevant.
       */
      info(key) {
        const i = this.#keyMap.get(key);
        if (i === void 0)
          return void 0;
        const v = this.#valList[i];
        const value = this.#isBackgroundFetch(v) ? v.__staleWhileFetching : v;
        if (value === void 0)
          return void 0;
        const entry = { value };
        if (this.#ttls && this.#starts) {
          const ttl = this.#ttls[i];
          const start = this.#starts[i];
          if (ttl && start) {
            const remain = ttl - (perf.now() - start);
            entry.ttl = remain;
            entry.start = Date.now();
          }
        }
        if (this.#sizes) {
          entry.size = this.#sizes[i];
        }
        return entry;
      }
      /**
       * Return an array of [key, {@link LRUCache.Entry}] tuples which can be
       * passed to {@link LRLUCache#load}.
       *
       * The `start` fields are calculated relative to a portable `Date.now()`
       * timestamp, even if `performance.now()` is available.
       *
       * Stale entries are always included in the `dump`, even if
       * {@link LRUCache.OptionsBase.allowStale} is false.
       *
       * Note: this returns an actual array, not a generator, so it can be more
       * easily passed around.
       */
      dump() {
        const arr = [];
        for (const i of this.#indexes({ allowStale: true })) {
          const key = this.#keyList[i];
          const v = this.#valList[i];
          const value = this.#isBackgroundFetch(v) ? v.__staleWhileFetching : v;
          if (value === void 0 || key === void 0)
            continue;
          const entry = { value };
          if (this.#ttls && this.#starts) {
            entry.ttl = this.#ttls[i];
            const age = perf.now() - this.#starts[i];
            entry.start = Math.floor(Date.now() - age);
          }
          if (this.#sizes) {
            entry.size = this.#sizes[i];
          }
          arr.unshift([key, entry]);
        }
        return arr;
      }
      /**
       * Reset the cache and load in the items in entries in the order listed.
       *
       * The shape of the resulting cache may be different if the same options are
       * not used in both caches.
       *
       * The `start` fields are assumed to be calculated relative to a portable
       * `Date.now()` timestamp, even if `performance.now()` is available.
       */
      load(arr) {
        this.clear();
        for (const [key, entry] of arr) {
          if (entry.start) {
            const age = Date.now() - entry.start;
            entry.start = perf.now() - age;
          }
          this.set(key, entry.value, entry);
        }
      }
      /**
       * Add a value to the cache.
       *
       * Note: if `undefined` is specified as a value, this is an alias for
       * {@link LRUCache#delete}
       *
       * Fields on the {@link LRUCache.SetOptions} options param will override
       * their corresponding values in the constructor options for the scope
       * of this single `set()` operation.
       *
       * If `start` is provided, then that will set the effective start
       * time for the TTL calculation. Note that this must be a previous
       * value of `performance.now()` if supported, or a previous value of
       * `Date.now()` if not.
       *
       * Options object may also include `size`, which will prevent
       * calling the `sizeCalculation` function and just use the specified
       * number if it is a positive integer, and `noDisposeOnSet` which
       * will prevent calling a `dispose` function in the case of
       * overwrites.
       *
       * If the `size` (or return value of `sizeCalculation`) for a given
       * entry is greater than `maxEntrySize`, then the item will not be
       * added to the cache.
       *
       * Will update the recency of the entry.
       *
       * If the value is `undefined`, then this is an alias for
       * `cache.delete(key)`. `undefined` is never stored in the cache.
       */
      set(k, v, setOptions2 = {}) {
        if (v === void 0) {
          this.delete(k);
          return this;
        }
        const { ttl = this.ttl, start, noDisposeOnSet = this.noDisposeOnSet, sizeCalculation = this.sizeCalculation, status } = setOptions2;
        let { noUpdateTTL = this.noUpdateTTL } = setOptions2;
        const size = this.#requireSize(k, v, setOptions2.size || 0, sizeCalculation);
        if (this.maxEntrySize && size > this.maxEntrySize) {
          if (status) {
            status.set = "miss";
            status.maxEntrySizeExceeded = true;
          }
          this.#delete(k, "set");
          return this;
        }
        let index = this.#size === 0 ? void 0 : this.#keyMap.get(k);
        if (index === void 0) {
          index = this.#size === 0 ? this.#tail : this.#free.length !== 0 ? this.#free.pop() : this.#size === this.#max ? this.#evict(false) : this.#size;
          this.#keyList[index] = k;
          this.#valList[index] = v;
          this.#keyMap.set(k, index);
          this.#next[this.#tail] = index;
          this.#prev[index] = this.#tail;
          this.#tail = index;
          this.#size++;
          this.#addItemSize(index, size, status);
          if (status)
            status.set = "add";
          noUpdateTTL = false;
        } else {
          this.#moveToTail(index);
          const oldVal = this.#valList[index];
          if (v !== oldVal) {
            if (this.#hasFetchMethod && this.#isBackgroundFetch(oldVal)) {
              oldVal.__abortController.abort(new Error("replaced"));
              const { __staleWhileFetching: s } = oldVal;
              if (s !== void 0 && !noDisposeOnSet) {
                if (this.#hasDispose) {
                  this.#dispose?.(s, k, "set");
                }
                if (this.#hasDisposeAfter) {
                  this.#disposed?.push([s, k, "set"]);
                }
              }
            } else if (!noDisposeOnSet) {
              if (this.#hasDispose) {
                this.#dispose?.(oldVal, k, "set");
              }
              if (this.#hasDisposeAfter) {
                this.#disposed?.push([oldVal, k, "set"]);
              }
            }
            this.#removeItemSize(index);
            this.#addItemSize(index, size, status);
            this.#valList[index] = v;
            if (status) {
              status.set = "replace";
              const oldValue = oldVal && this.#isBackgroundFetch(oldVal) ? oldVal.__staleWhileFetching : oldVal;
              if (oldValue !== void 0)
                status.oldValue = oldValue;
            }
          } else if (status) {
            status.set = "update";
          }
        }
        if (ttl !== 0 && !this.#ttls) {
          this.#initializeTTLTracking();
        }
        if (this.#ttls) {
          if (!noUpdateTTL) {
            this.#setItemTTL(index, ttl, start);
          }
          if (status)
            this.#statusTTL(status, index);
        }
        if (!noDisposeOnSet && this.#hasDisposeAfter && this.#disposed) {
          const dt = this.#disposed;
          let task;
          while (task = dt?.shift()) {
            this.#disposeAfter?.(...task);
          }
        }
        return this;
      }
      /**
       * Evict the least recently used item, returning its value or
       * `undefined` if cache is empty.
       */
      pop() {
        try {
          while (this.#size) {
            const val = this.#valList[this.#head];
            this.#evict(true);
            if (this.#isBackgroundFetch(val)) {
              if (val.__staleWhileFetching) {
                return val.__staleWhileFetching;
              }
            } else if (val !== void 0) {
              return val;
            }
          }
        } finally {
          if (this.#hasDisposeAfter && this.#disposed) {
            const dt = this.#disposed;
            let task;
            while (task = dt?.shift()) {
              this.#disposeAfter?.(...task);
            }
          }
        }
      }
      #evict(free) {
        const head = this.#head;
        const k = this.#keyList[head];
        const v = this.#valList[head];
        if (this.#hasFetchMethod && this.#isBackgroundFetch(v)) {
          v.__abortController.abort(new Error("evicted"));
        } else if (this.#hasDispose || this.#hasDisposeAfter) {
          if (this.#hasDispose) {
            this.#dispose?.(v, k, "evict");
          }
          if (this.#hasDisposeAfter) {
            this.#disposed?.push([v, k, "evict"]);
          }
        }
        this.#removeItemSize(head);
        if (free) {
          this.#keyList[head] = void 0;
          this.#valList[head] = void 0;
          this.#free.push(head);
        }
        if (this.#size === 1) {
          this.#head = this.#tail = 0;
          this.#free.length = 0;
        } else {
          this.#head = this.#next[head];
        }
        this.#keyMap.delete(k);
        this.#size--;
        return head;
      }
      /**
       * Check if a key is in the cache, without updating the recency of use.
       * Will return false if the item is stale, even though it is technically
       * in the cache.
       *
       * Check if a key is in the cache, without updating the recency of
       * use. Age is updated if {@link LRUCache.OptionsBase.updateAgeOnHas} is set
       * to `true` in either the options or the constructor.
       *
       * Will return `false` if the item is stale, even though it is technically in
       * the cache. The difference can be determined (if it matters) by using a
       * `status` argument, and inspecting the `has` field.
       *
       * Will not update item age unless
       * {@link LRUCache.OptionsBase.updateAgeOnHas} is set.
       */
      has(k, hasOptions = {}) {
        const { updateAgeOnHas = this.updateAgeOnHas, status } = hasOptions;
        const index = this.#keyMap.get(k);
        if (index !== void 0) {
          const v = this.#valList[index];
          if (this.#isBackgroundFetch(v) && v.__staleWhileFetching === void 0) {
            return false;
          }
          if (!this.#isStale(index)) {
            if (updateAgeOnHas) {
              this.#updateItemAge(index);
            }
            if (status) {
              status.has = "hit";
              this.#statusTTL(status, index);
            }
            return true;
          } else if (status) {
            status.has = "stale";
            this.#statusTTL(status, index);
          }
        } else if (status) {
          status.has = "miss";
        }
        return false;
      }
      /**
       * Like {@link LRUCache#get} but doesn't update recency or delete stale
       * items.
       *
       * Returns `undefined` if the item is stale, unless
       * {@link LRUCache.OptionsBase.allowStale} is set.
       */
      peek(k, peekOptions = {}) {
        const { allowStale = this.allowStale } = peekOptions;
        const index = this.#keyMap.get(k);
        if (index === void 0 || !allowStale && this.#isStale(index)) {
          return;
        }
        const v = this.#valList[index];
        return this.#isBackgroundFetch(v) ? v.__staleWhileFetching : v;
      }
      #backgroundFetch(k, index, options2, context) {
        const v = index === void 0 ? void 0 : this.#valList[index];
        if (this.#isBackgroundFetch(v)) {
          return v;
        }
        const ac = new AC();
        const { signal } = options2;
        signal?.addEventListener("abort", () => ac.abort(signal.reason), {
          signal: ac.signal
        });
        const fetchOpts = {
          signal: ac.signal,
          options: options2,
          context
        };
        const cb = (v2, updateCache = false) => {
          const { aborted } = ac.signal;
          const ignoreAbort = options2.ignoreFetchAbort && v2 !== void 0;
          if (options2.status) {
            if (aborted && !updateCache) {
              options2.status.fetchAborted = true;
              options2.status.fetchError = ac.signal.reason;
              if (ignoreAbort)
                options2.status.fetchAbortIgnored = true;
            } else {
              options2.status.fetchResolved = true;
            }
          }
          if (aborted && !ignoreAbort && !updateCache) {
            return fetchFail(ac.signal.reason);
          }
          const bf2 = p;
          if (this.#valList[index] === p) {
            if (v2 === void 0) {
              if (bf2.__staleWhileFetching) {
                this.#valList[index] = bf2.__staleWhileFetching;
              } else {
                this.#delete(k, "fetch");
              }
            } else {
              if (options2.status)
                options2.status.fetchUpdated = true;
              this.set(k, v2, fetchOpts.options);
            }
          }
          return v2;
        };
        const eb = (er) => {
          if (options2.status) {
            options2.status.fetchRejected = true;
            options2.status.fetchError = er;
          }
          return fetchFail(er);
        };
        const fetchFail = (er) => {
          const { aborted } = ac.signal;
          const allowStaleAborted = aborted && options2.allowStaleOnFetchAbort;
          const allowStale = allowStaleAborted || options2.allowStaleOnFetchRejection;
          const noDelete = allowStale || options2.noDeleteOnFetchRejection;
          const bf2 = p;
          if (this.#valList[index] === p) {
            const del = !noDelete || bf2.__staleWhileFetching === void 0;
            if (del) {
              this.#delete(k, "fetch");
            } else if (!allowStaleAborted) {
              this.#valList[index] = bf2.__staleWhileFetching;
            }
          }
          if (allowStale) {
            if (options2.status && bf2.__staleWhileFetching !== void 0) {
              options2.status.returnedStale = true;
            }
            return bf2.__staleWhileFetching;
          } else if (bf2.__returned === bf2) {
            throw er;
          }
        };
        const pcall = (res, rej) => {
          const fmp = this.#fetchMethod?.(k, v, fetchOpts);
          if (fmp && fmp instanceof Promise) {
            fmp.then((v2) => res(v2 === void 0 ? void 0 : v2), rej);
          }
          ac.signal.addEventListener("abort", () => {
            if (!options2.ignoreFetchAbort || options2.allowStaleOnFetchAbort) {
              res(void 0);
              if (options2.allowStaleOnFetchAbort) {
                res = (v2) => cb(v2, true);
              }
            }
          });
        };
        if (options2.status)
          options2.status.fetchDispatched = true;
        const p = new Promise(pcall).then(cb, eb);
        const bf = Object.assign(p, {
          __abortController: ac,
          __staleWhileFetching: v,
          __returned: void 0
        });
        if (index === void 0) {
          this.set(k, bf, { ...fetchOpts.options, status: void 0 });
          index = this.#keyMap.get(k);
        } else {
          this.#valList[index] = bf;
        }
        return bf;
      }
      #isBackgroundFetch(p) {
        if (!this.#hasFetchMethod)
          return false;
        const b = p;
        return !!b && b instanceof Promise && b.hasOwnProperty("__staleWhileFetching") && b.__abortController instanceof AC;
      }
      async fetch(k, fetchOptions = {}) {
        const {
          // get options
          allowStale = this.allowStale,
          updateAgeOnGet = this.updateAgeOnGet,
          noDeleteOnStaleGet = this.noDeleteOnStaleGet,
          // set options
          ttl = this.ttl,
          noDisposeOnSet = this.noDisposeOnSet,
          size = 0,
          sizeCalculation = this.sizeCalculation,
          noUpdateTTL = this.noUpdateTTL,
          // fetch exclusive options
          noDeleteOnFetchRejection = this.noDeleteOnFetchRejection,
          allowStaleOnFetchRejection = this.allowStaleOnFetchRejection,
          ignoreFetchAbort = this.ignoreFetchAbort,
          allowStaleOnFetchAbort = this.allowStaleOnFetchAbort,
          context,
          forceRefresh = false,
          status,
          signal
        } = fetchOptions;
        if (!this.#hasFetchMethod) {
          if (status)
            status.fetch = "get";
          return this.get(k, {
            allowStale,
            updateAgeOnGet,
            noDeleteOnStaleGet,
            status
          });
        }
        const options2 = {
          allowStale,
          updateAgeOnGet,
          noDeleteOnStaleGet,
          ttl,
          noDisposeOnSet,
          size,
          sizeCalculation,
          noUpdateTTL,
          noDeleteOnFetchRejection,
          allowStaleOnFetchRejection,
          allowStaleOnFetchAbort,
          ignoreFetchAbort,
          status,
          signal
        };
        let index = this.#keyMap.get(k);
        if (index === void 0) {
          if (status)
            status.fetch = "miss";
          const p = this.#backgroundFetch(k, index, options2, context);
          return p.__returned = p;
        } else {
          const v = this.#valList[index];
          if (this.#isBackgroundFetch(v)) {
            const stale = allowStale && v.__staleWhileFetching !== void 0;
            if (status) {
              status.fetch = "inflight";
              if (stale)
                status.returnedStale = true;
            }
            return stale ? v.__staleWhileFetching : v.__returned = v;
          }
          const isStale = this.#isStale(index);
          if (!forceRefresh && !isStale) {
            if (status)
              status.fetch = "hit";
            this.#moveToTail(index);
            if (updateAgeOnGet) {
              this.#updateItemAge(index);
            }
            if (status)
              this.#statusTTL(status, index);
            return v;
          }
          const p = this.#backgroundFetch(k, index, options2, context);
          const hasStale = p.__staleWhileFetching !== void 0;
          const staleVal = hasStale && allowStale;
          if (status) {
            status.fetch = isStale ? "stale" : "refresh";
            if (staleVal && isStale)
              status.returnedStale = true;
          }
          return staleVal ? p.__staleWhileFetching : p.__returned = p;
        }
      }
      async forceFetch(k, fetchOptions = {}) {
        const v = await this.fetch(k, fetchOptions);
        if (v === void 0)
          throw new Error("fetch() returned undefined");
        return v;
      }
      memo(k, memoOptions = {}) {
        const memoMethod = this.#memoMethod;
        if (!memoMethod) {
          throw new Error("no memoMethod provided to constructor");
        }
        const { context, forceRefresh, ...options2 } = memoOptions;
        const v = this.get(k, options2);
        if (!forceRefresh && v !== void 0)
          return v;
        const vv = memoMethod(k, v, {
          options: options2,
          context
        });
        this.set(k, vv, options2);
        return vv;
      }
      /**
       * Return a value from the cache. Will update the recency of the cache
       * entry found.
       *
       * If the key is not found, get() will return `undefined`.
       */
      get(k, getOptions = {}) {
        const { allowStale = this.allowStale, updateAgeOnGet = this.updateAgeOnGet, noDeleteOnStaleGet = this.noDeleteOnStaleGet, status } = getOptions;
        const index = this.#keyMap.get(k);
        if (index !== void 0) {
          const value = this.#valList[index];
          const fetching = this.#isBackgroundFetch(value);
          if (status)
            this.#statusTTL(status, index);
          if (this.#isStale(index)) {
            if (status)
              status.get = "stale";
            if (!fetching) {
              if (!noDeleteOnStaleGet) {
                this.#delete(k, "expire");
              }
              if (status && allowStale)
                status.returnedStale = true;
              return allowStale ? value : void 0;
            } else {
              if (status && allowStale && value.__staleWhileFetching !== void 0) {
                status.returnedStale = true;
              }
              return allowStale ? value.__staleWhileFetching : void 0;
            }
          } else {
            if (status)
              status.get = "hit";
            if (fetching) {
              return value.__staleWhileFetching;
            }
            this.#moveToTail(index);
            if (updateAgeOnGet) {
              this.#updateItemAge(index);
            }
            return value;
          }
        } else if (status) {
          status.get = "miss";
        }
      }
      #connect(p, n) {
        this.#prev[n] = p;
        this.#next[p] = n;
      }
      #moveToTail(index) {
        if (index !== this.#tail) {
          if (index === this.#head) {
            this.#head = this.#next[index];
          } else {
            this.#connect(this.#prev[index], this.#next[index]);
          }
          this.#connect(this.#tail, index);
          this.#tail = index;
        }
      }
      /**
       * Deletes a key out of the cache.
       *
       * Returns true if the key was deleted, false otherwise.
       */
      delete(k) {
        return this.#delete(k, "delete");
      }
      #delete(k, reason) {
        let deleted = false;
        if (this.#size !== 0) {
          const index = this.#keyMap.get(k);
          if (index !== void 0) {
            deleted = true;
            if (this.#size === 1) {
              this.#clear(reason);
            } else {
              this.#removeItemSize(index);
              const v = this.#valList[index];
              if (this.#isBackgroundFetch(v)) {
                v.__abortController.abort(new Error("deleted"));
              } else if (this.#hasDispose || this.#hasDisposeAfter) {
                if (this.#hasDispose) {
                  this.#dispose?.(v, k, reason);
                }
                if (this.#hasDisposeAfter) {
                  this.#disposed?.push([v, k, reason]);
                }
              }
              this.#keyMap.delete(k);
              this.#keyList[index] = void 0;
              this.#valList[index] = void 0;
              if (index === this.#tail) {
                this.#tail = this.#prev[index];
              } else if (index === this.#head) {
                this.#head = this.#next[index];
              } else {
                const pi = this.#prev[index];
                this.#next[pi] = this.#next[index];
                const ni = this.#next[index];
                this.#prev[ni] = this.#prev[index];
              }
              this.#size--;
              this.#free.push(index);
            }
          }
        }
        if (this.#hasDisposeAfter && this.#disposed?.length) {
          const dt = this.#disposed;
          let task;
          while (task = dt?.shift()) {
            this.#disposeAfter?.(...task);
          }
        }
        return deleted;
      }
      /**
       * Clear the cache entirely, throwing away all values.
       */
      clear() {
        return this.#clear("delete");
      }
      #clear(reason) {
        for (const index of this.#rindexes({ allowStale: true })) {
          const v = this.#valList[index];
          if (this.#isBackgroundFetch(v)) {
            v.__abortController.abort(new Error("deleted"));
          } else {
            const k = this.#keyList[index];
            if (this.#hasDispose) {
              this.#dispose?.(v, k, reason);
            }
            if (this.#hasDisposeAfter) {
              this.#disposed?.push([v, k, reason]);
            }
          }
        }
        this.#keyMap.clear();
        this.#valList.fill(void 0);
        this.#keyList.fill(void 0);
        if (this.#ttls && this.#starts) {
          this.#ttls.fill(0);
          this.#starts.fill(0);
        }
        if (this.#sizes) {
          this.#sizes.fill(0);
        }
        this.#head = 0;
        this.#tail = 0;
        this.#free.length = 0;
        this.#calculatedSize = 0;
        this.#size = 0;
        if (this.#hasDisposeAfter && this.#disposed) {
          const dt = this.#disposed;
          let task;
          while (task = dt?.shift()) {
            this.#disposeAfter?.(...task);
          }
        }
      }
    };
    exports2.LRUCache = LRUCache2;
  }
});

// node_modules/path-scurry/node_modules/minipass/dist/commonjs/index.js
var require_commonjs3 = __commonJS({
  "node_modules/path-scurry/node_modules/minipass/dist/commonjs/index.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Minipass = exports2.isWritable = exports2.isReadable = exports2.isStream = void 0;
    var proc = typeof process === "object" && process ? process : {
      stdout: null,
      stderr: null
    };
    var node_events_1 = require("node:events");
    var node_stream_1 = __importDefault(require("node:stream"));
    var node_string_decoder_1 = require("node:string_decoder");
    var isStream = (s) => !!s && typeof s === "object" && (s instanceof Minipass || s instanceof node_stream_1.default || (0, exports2.isReadable)(s) || (0, exports2.isWritable)(s));
    exports2.isStream = isStream;
    var isReadable = (s) => !!s && typeof s === "object" && s instanceof node_events_1.EventEmitter && typeof s.pipe === "function" && // node core Writable streams have a pipe() method, but it throws
    s.pipe !== node_stream_1.default.Writable.prototype.pipe;
    exports2.isReadable = isReadable;
    var isWritable = (s) => !!s && typeof s === "object" && s instanceof node_events_1.EventEmitter && typeof s.write === "function" && typeof s.end === "function";
    exports2.isWritable = isWritable;
    var EOF = Symbol("EOF");
    var MAYBE_EMIT_END = Symbol("maybeEmitEnd");
    var EMITTED_END = Symbol("emittedEnd");
    var EMITTING_END = Symbol("emittingEnd");
    var EMITTED_ERROR = Symbol("emittedError");
    var CLOSED = Symbol("closed");
    var READ = Symbol("read");
    var FLUSH = Symbol("flush");
    var FLUSHCHUNK = Symbol("flushChunk");
    var ENCODING = Symbol("encoding");
    var DECODER = Symbol("decoder");
    var FLOWING = Symbol("flowing");
    var PAUSED = Symbol("paused");
    var RESUME = Symbol("resume");
    var BUFFER = Symbol("buffer");
    var PIPES = Symbol("pipes");
    var BUFFERLENGTH = Symbol("bufferLength");
    var BUFFERPUSH = Symbol("bufferPush");
    var BUFFERSHIFT = Symbol("bufferShift");
    var OBJECTMODE = Symbol("objectMode");
    var DESTROYED = Symbol("destroyed");
    var ERROR = Symbol("error");
    var EMITDATA = Symbol("emitData");
    var EMITEND = Symbol("emitEnd");
    var EMITEND2 = Symbol("emitEnd2");
    var ASYNC = Symbol("async");
    var ABORT = Symbol("abort");
    var ABORTED = Symbol("aborted");
    var SIGNAL = Symbol("signal");
    var DATALISTENERS = Symbol("dataListeners");
    var DISCARDED = Symbol("discarded");
    var defer = (fn) => Promise.resolve().then(fn);
    var nodefer = (fn) => fn();
    var isEndish = (ev) => ev === "end" || ev === "finish" || ev === "prefinish";
    var isArrayBufferLike = (b) => b instanceof ArrayBuffer || !!b && typeof b === "object" && b.constructor && b.constructor.name === "ArrayBuffer" && b.byteLength >= 0;
    var isArrayBufferView = (b) => !Buffer.isBuffer(b) && ArrayBuffer.isView(b);
    var Pipe = class {
      src;
      dest;
      opts;
      ondrain;
      constructor(src, dest, opts) {
        this.src = src;
        this.dest = dest;
        this.opts = opts;
        this.ondrain = () => src[RESUME]();
        this.dest.on("drain", this.ondrain);
      }
      unpipe() {
        this.dest.removeListener("drain", this.ondrain);
      }
      // only here for the prototype
      /* c8 ignore start */
      proxyErrors(_er) {
      }
      /* c8 ignore stop */
      end() {
        this.unpipe();
        if (this.opts.end)
          this.dest.end();
      }
    };
    var PipeProxyErrors = class extends Pipe {
      unpipe() {
        this.src.removeListener("error", this.proxyErrors);
        super.unpipe();
      }
      constructor(src, dest, opts) {
        super(src, dest, opts);
        this.proxyErrors = (er) => dest.emit("error", er);
        src.on("error", this.proxyErrors);
      }
    };
    var isObjectModeOptions = (o) => !!o.objectMode;
    var isEncodingOptions = (o) => !o.objectMode && !!o.encoding && o.encoding !== "buffer";
    var Minipass = class extends node_events_1.EventEmitter {
      [FLOWING] = false;
      [PAUSED] = false;
      [PIPES] = [];
      [BUFFER] = [];
      [OBJECTMODE];
      [ENCODING];
      [ASYNC];
      [DECODER];
      [EOF] = false;
      [EMITTED_END] = false;
      [EMITTING_END] = false;
      [CLOSED] = false;
      [EMITTED_ERROR] = null;
      [BUFFERLENGTH] = 0;
      [DESTROYED] = false;
      [SIGNAL];
      [ABORTED] = false;
      [DATALISTENERS] = 0;
      [DISCARDED] = false;
      /**
       * true if the stream can be written
       */
      writable = true;
      /**
       * true if the stream can be read
       */
      readable = true;
      /**
       * If `RType` is Buffer, then options do not need to be provided.
       * Otherwise, an options object must be provided to specify either
       * {@link Minipass.SharedOptions.objectMode} or
       * {@link Minipass.SharedOptions.encoding}, as appropriate.
       */
      constructor(...args) {
        const options2 = args[0] || {};
        super();
        if (options2.objectMode && typeof options2.encoding === "string") {
          throw new TypeError("Encoding and objectMode may not be used together");
        }
        if (isObjectModeOptions(options2)) {
          this[OBJECTMODE] = true;
          this[ENCODING] = null;
        } else if (isEncodingOptions(options2)) {
          this[ENCODING] = options2.encoding;
          this[OBJECTMODE] = false;
        } else {
          this[OBJECTMODE] = false;
          this[ENCODING] = null;
        }
        this[ASYNC] = !!options2.async;
        this[DECODER] = this[ENCODING] ? new node_string_decoder_1.StringDecoder(this[ENCODING]) : null;
        if (options2 && options2.debugExposeBuffer === true) {
          Object.defineProperty(this, "buffer", { get: () => this[BUFFER] });
        }
        if (options2 && options2.debugExposePipes === true) {
          Object.defineProperty(this, "pipes", { get: () => this[PIPES] });
        }
        const { signal } = options2;
        if (signal) {
          this[SIGNAL] = signal;
          if (signal.aborted) {
            this[ABORT]();
          } else {
            signal.addEventListener("abort", () => this[ABORT]());
          }
        }
      }
      /**
       * The amount of data stored in the buffer waiting to be read.
       *
       * For Buffer strings, this will be the total byte length.
       * For string encoding streams, this will be the string character length,
       * according to JavaScript's `string.length` logic.
       * For objectMode streams, this is a count of the items waiting to be
       * emitted.
       */
      get bufferLength() {
        return this[BUFFERLENGTH];
      }
      /**
       * The `BufferEncoding` currently in use, or `null`
       */
      get encoding() {
        return this[ENCODING];
      }
      /**
       * @deprecated - This is a read only property
       */
      set encoding(_enc) {
        throw new Error("Encoding must be set at instantiation time");
      }
      /**
       * @deprecated - Encoding may only be set at instantiation time
       */
      setEncoding(_enc) {
        throw new Error("Encoding must be set at instantiation time");
      }
      /**
       * True if this is an objectMode stream
       */
      get objectMode() {
        return this[OBJECTMODE];
      }
      /**
       * @deprecated - This is a read-only property
       */
      set objectMode(_om) {
        throw new Error("objectMode must be set at instantiation time");
      }
      /**
       * true if this is an async stream
       */
      get ["async"]() {
        return this[ASYNC];
      }
      /**
       * Set to true to make this stream async.
       *
       * Once set, it cannot be unset, as this would potentially cause incorrect
       * behavior.  Ie, a sync stream can be made async, but an async stream
       * cannot be safely made sync.
       */
      set ["async"](a) {
        this[ASYNC] = this[ASYNC] || !!a;
      }
      // drop everything and get out of the flow completely
      [ABORT]() {
        this[ABORTED] = true;
        this.emit("abort", this[SIGNAL]?.reason);
        this.destroy(this[SIGNAL]?.reason);
      }
      /**
       * True if the stream has been aborted.
       */
      get aborted() {
        return this[ABORTED];
      }
      /**
       * No-op setter. Stream aborted status is set via the AbortSignal provided
       * in the constructor options.
       */
      set aborted(_) {
      }
      write(chunk, encoding2, cb) {
        if (this[ABORTED])
          return false;
        if (this[EOF])
          throw new Error("write after end");
        if (this[DESTROYED]) {
          this.emit("error", Object.assign(new Error("Cannot call write after a stream was destroyed"), { code: "ERR_STREAM_DESTROYED" }));
          return true;
        }
        if (typeof encoding2 === "function") {
          cb = encoding2;
          encoding2 = "utf8";
        }
        if (!encoding2)
          encoding2 = "utf8";
        const fn = this[ASYNC] ? defer : nodefer;
        if (!this[OBJECTMODE] && !Buffer.isBuffer(chunk)) {
          if (isArrayBufferView(chunk)) {
            chunk = Buffer.from(chunk.buffer, chunk.byteOffset, chunk.byteLength);
          } else if (isArrayBufferLike(chunk)) {
            chunk = Buffer.from(chunk);
          } else if (typeof chunk !== "string") {
            throw new Error("Non-contiguous data written to non-objectMode stream");
          }
        }
        if (this[OBJECTMODE]) {
          if (this[FLOWING] && this[BUFFERLENGTH] !== 0)
            this[FLUSH](true);
          if (this[FLOWING])
            this.emit("data", chunk);
          else
            this[BUFFERPUSH](chunk);
          if (this[BUFFERLENGTH] !== 0)
            this.emit("readable");
          if (cb)
            fn(cb);
          return this[FLOWING];
        }
        if (!chunk.length) {
          if (this[BUFFERLENGTH] !== 0)
            this.emit("readable");
          if (cb)
            fn(cb);
          return this[FLOWING];
        }
        if (typeof chunk === "string" && // unless it is a string already ready for us to use
        !(encoding2 === this[ENCODING] && !this[DECODER]?.lastNeed)) {
          chunk = Buffer.from(chunk, encoding2);
        }
        if (Buffer.isBuffer(chunk) && this[ENCODING]) {
          chunk = this[DECODER].write(chunk);
        }
        if (this[FLOWING] && this[BUFFERLENGTH] !== 0)
          this[FLUSH](true);
        if (this[FLOWING])
          this.emit("data", chunk);
        else
          this[BUFFERPUSH](chunk);
        if (this[BUFFERLENGTH] !== 0)
          this.emit("readable");
        if (cb)
          fn(cb);
        return this[FLOWING];
      }
      /**
       * Low-level explicit read method.
       *
       * In objectMode, the argument is ignored, and one item is returned if
       * available.
       *
       * `n` is the number of bytes (or in the case of encoding streams,
       * characters) to consume. If `n` is not provided, then the entire buffer
       * is returned, or `null` is returned if no data is available.
       *
       * If `n` is greater that the amount of data in the internal buffer,
       * then `null` is returned.
       */
      read(n) {
        if (this[DESTROYED])
          return null;
        this[DISCARDED] = false;
        if (this[BUFFERLENGTH] === 0 || n === 0 || n && n > this[BUFFERLENGTH]) {
          this[MAYBE_EMIT_END]();
          return null;
        }
        if (this[OBJECTMODE])
          n = null;
        if (this[BUFFER].length > 1 && !this[OBJECTMODE]) {
          this[BUFFER] = [
            this[ENCODING] ? this[BUFFER].join("") : Buffer.concat(this[BUFFER], this[BUFFERLENGTH])
          ];
        }
        const ret = this[READ](n || null, this[BUFFER][0]);
        this[MAYBE_EMIT_END]();
        return ret;
      }
      [READ](n, chunk) {
        if (this[OBJECTMODE])
          this[BUFFERSHIFT]();
        else {
          const c = chunk;
          if (n === c.length || n === null)
            this[BUFFERSHIFT]();
          else if (typeof c === "string") {
            this[BUFFER][0] = c.slice(n);
            chunk = c.slice(0, n);
            this[BUFFERLENGTH] -= n;
          } else {
            this[BUFFER][0] = c.subarray(n);
            chunk = c.subarray(0, n);
            this[BUFFERLENGTH] -= n;
          }
        }
        this.emit("data", chunk);
        if (!this[BUFFER].length && !this[EOF])
          this.emit("drain");
        return chunk;
      }
      end(chunk, encoding2, cb) {
        if (typeof chunk === "function") {
          cb = chunk;
          chunk = void 0;
        }
        if (typeof encoding2 === "function") {
          cb = encoding2;
          encoding2 = "utf8";
        }
        if (chunk !== void 0)
          this.write(chunk, encoding2);
        if (cb)
          this.once("end", cb);
        this[EOF] = true;
        this.writable = false;
        if (this[FLOWING] || !this[PAUSED])
          this[MAYBE_EMIT_END]();
        return this;
      }
      // don't let the internal resume be overwritten
      [RESUME]() {
        if (this[DESTROYED])
          return;
        if (!this[DATALISTENERS] && !this[PIPES].length) {
          this[DISCARDED] = true;
        }
        this[PAUSED] = false;
        this[FLOWING] = true;
        this.emit("resume");
        if (this[BUFFER].length)
          this[FLUSH]();
        else if (this[EOF])
          this[MAYBE_EMIT_END]();
        else
          this.emit("drain");
      }
      /**
       * Resume the stream if it is currently in a paused state
       *
       * If called when there are no pipe destinations or `data` event listeners,
       * this will place the stream in a "discarded" state, where all data will
       * be thrown away. The discarded state is removed if a pipe destination or
       * data handler is added, if pause() is called, or if any synchronous or
       * asynchronous iteration is started.
       */
      resume() {
        return this[RESUME]();
      }
      /**
       * Pause the stream
       */
      pause() {
        this[FLOWING] = false;
        this[PAUSED] = true;
        this[DISCARDED] = false;
      }
      /**
       * true if the stream has been forcibly destroyed
       */
      get destroyed() {
        return this[DESTROYED];
      }
      /**
       * true if the stream is currently in a flowing state, meaning that
       * any writes will be immediately emitted.
       */
      get flowing() {
        return this[FLOWING];
      }
      /**
       * true if the stream is currently in a paused state
       */
      get paused() {
        return this[PAUSED];
      }
      [BUFFERPUSH](chunk) {
        if (this[OBJECTMODE])
          this[BUFFERLENGTH] += 1;
        else
          this[BUFFERLENGTH] += chunk.length;
        this[BUFFER].push(chunk);
      }
      [BUFFERSHIFT]() {
        if (this[OBJECTMODE])
          this[BUFFERLENGTH] -= 1;
        else
          this[BUFFERLENGTH] -= this[BUFFER][0].length;
        return this[BUFFER].shift();
      }
      [FLUSH](noDrain = false) {
        do {
        } while (this[FLUSHCHUNK](this[BUFFERSHIFT]()) && this[BUFFER].length);
        if (!noDrain && !this[BUFFER].length && !this[EOF])
          this.emit("drain");
      }
      [FLUSHCHUNK](chunk) {
        this.emit("data", chunk);
        return this[FLOWING];
      }
      /**
       * Pipe all data emitted by this stream into the destination provided.
       *
       * Triggers the flow of data.
       */
      pipe(dest, opts) {
        if (this[DESTROYED])
          return dest;
        this[DISCARDED] = false;
        const ended = this[EMITTED_END];
        opts = opts || {};
        if (dest === proc.stdout || dest === proc.stderr)
          opts.end = false;
        else
          opts.end = opts.end !== false;
        opts.proxyErrors = !!opts.proxyErrors;
        if (ended) {
          if (opts.end)
            dest.end();
        } else {
          this[PIPES].push(!opts.proxyErrors ? new Pipe(this, dest, opts) : new PipeProxyErrors(this, dest, opts));
          if (this[ASYNC])
            defer(() => this[RESUME]());
          else
            this[RESUME]();
        }
        return dest;
      }
      /**
       * Fully unhook a piped destination stream.
       *
       * If the destination stream was the only consumer of this stream (ie,
       * there are no other piped destinations or `'data'` event listeners)
       * then the flow of data will stop until there is another consumer or
       * {@link Minipass#resume} is explicitly called.
       */
      unpipe(dest) {
        const p = this[PIPES].find((p2) => p2.dest === dest);
        if (p) {
          if (this[PIPES].length === 1) {
            if (this[FLOWING] && this[DATALISTENERS] === 0) {
              this[FLOWING] = false;
            }
            this[PIPES] = [];
          } else
            this[PIPES].splice(this[PIPES].indexOf(p), 1);
          p.unpipe();
        }
      }
      /**
       * Alias for {@link Minipass#on}
       */
      addListener(ev, handler) {
        return this.on(ev, handler);
      }
      /**
       * Mostly identical to `EventEmitter.on`, with the following
       * behavior differences to prevent data loss and unnecessary hangs:
       *
       * - Adding a 'data' event handler will trigger the flow of data
       *
       * - Adding a 'readable' event handler when there is data waiting to be read
       *   will cause 'readable' to be emitted immediately.
       *
       * - Adding an 'endish' event handler ('end', 'finish', etc.) which has
       *   already passed will cause the event to be emitted immediately and all
       *   handlers removed.
       *
       * - Adding an 'error' event handler after an error has been emitted will
       *   cause the event to be re-emitted immediately with the error previously
       *   raised.
       */
      on(ev, handler) {
        const ret = super.on(ev, handler);
        if (ev === "data") {
          this[DISCARDED] = false;
          this[DATALISTENERS]++;
          if (!this[PIPES].length && !this[FLOWING]) {
            this[RESUME]();
          }
        } else if (ev === "readable" && this[BUFFERLENGTH] !== 0) {
          super.emit("readable");
        } else if (isEndish(ev) && this[EMITTED_END]) {
          super.emit(ev);
          this.removeAllListeners(ev);
        } else if (ev === "error" && this[EMITTED_ERROR]) {
          const h = handler;
          if (this[ASYNC])
            defer(() => h.call(this, this[EMITTED_ERROR]));
          else
            h.call(this, this[EMITTED_ERROR]);
        }
        return ret;
      }
      /**
       * Alias for {@link Minipass#off}
       */
      removeListener(ev, handler) {
        return this.off(ev, handler);
      }
      /**
       * Mostly identical to `EventEmitter.off`
       *
       * If a 'data' event handler is removed, and it was the last consumer
       * (ie, there are no pipe destinations or other 'data' event listeners),
       * then the flow of data will stop until there is another consumer or
       * {@link Minipass#resume} is explicitly called.
       */
      off(ev, handler) {
        const ret = super.off(ev, handler);
        if (ev === "data") {
          this[DATALISTENERS] = this.listeners("data").length;
          if (this[DATALISTENERS] === 0 && !this[DISCARDED] && !this[PIPES].length) {
            this[FLOWING] = false;
          }
        }
        return ret;
      }
      /**
       * Mostly identical to `EventEmitter.removeAllListeners`
       *
       * If all 'data' event handlers are removed, and they were the last consumer
       * (ie, there are no pipe destinations), then the flow of data will stop
       * until there is another consumer or {@link Minipass#resume} is explicitly
       * called.
       */
      removeAllListeners(ev) {
        const ret = super.removeAllListeners(ev);
        if (ev === "data" || ev === void 0) {
          this[DATALISTENERS] = 0;
          if (!this[DISCARDED] && !this[PIPES].length) {
            this[FLOWING] = false;
          }
        }
        return ret;
      }
      /**
       * true if the 'end' event has been emitted
       */
      get emittedEnd() {
        return this[EMITTED_END];
      }
      [MAYBE_EMIT_END]() {
        if (!this[EMITTING_END] && !this[EMITTED_END] && !this[DESTROYED] && this[BUFFER].length === 0 && this[EOF]) {
          this[EMITTING_END] = true;
          this.emit("end");
          this.emit("prefinish");
          this.emit("finish");
          if (this[CLOSED])
            this.emit("close");
          this[EMITTING_END] = false;
        }
      }
      /**
       * Mostly identical to `EventEmitter.emit`, with the following
       * behavior differences to prevent data loss and unnecessary hangs:
       *
       * If the stream has been destroyed, and the event is something other
       * than 'close' or 'error', then `false` is returned and no handlers
       * are called.
       *
       * If the event is 'end', and has already been emitted, then the event
       * is ignored. If the stream is in a paused or non-flowing state, then
       * the event will be deferred until data flow resumes. If the stream is
       * async, then handlers will be called on the next tick rather than
       * immediately.
       *
       * If the event is 'close', and 'end' has not yet been emitted, then
       * the event will be deferred until after 'end' is emitted.
       *
       * If the event is 'error', and an AbortSignal was provided for the stream,
       * and there are no listeners, then the event is ignored, matching the
       * behavior of node core streams in the presense of an AbortSignal.
       *
       * If the event is 'finish' or 'prefinish', then all listeners will be
       * removed after emitting the event, to prevent double-firing.
       */
      emit(ev, ...args) {
        const data = args[0];
        if (ev !== "error" && ev !== "close" && ev !== DESTROYED && this[DESTROYED]) {
          return false;
        } else if (ev === "data") {
          return !this[OBJECTMODE] && !data ? false : this[ASYNC] ? (defer(() => this[EMITDATA](data)), true) : this[EMITDATA](data);
        } else if (ev === "end") {
          return this[EMITEND]();
        } else if (ev === "close") {
          this[CLOSED] = true;
          if (!this[EMITTED_END] && !this[DESTROYED])
            return false;
          const ret2 = super.emit("close");
          this.removeAllListeners("close");
          return ret2;
        } else if (ev === "error") {
          this[EMITTED_ERROR] = data;
          super.emit(ERROR, data);
          const ret2 = !this[SIGNAL] || this.listeners("error").length ? super.emit("error", data) : false;
          this[MAYBE_EMIT_END]();
          return ret2;
        } else if (ev === "resume") {
          const ret2 = super.emit("resume");
          this[MAYBE_EMIT_END]();
          return ret2;
        } else if (ev === "finish" || ev === "prefinish") {
          const ret2 = super.emit(ev);
          this.removeAllListeners(ev);
          return ret2;
        }
        const ret = super.emit(ev, ...args);
        this[MAYBE_EMIT_END]();
        return ret;
      }
      [EMITDATA](data) {
        for (const p of this[PIPES]) {
          if (p.dest.write(data) === false)
            this.pause();
        }
        const ret = this[DISCARDED] ? false : super.emit("data", data);
        this[MAYBE_EMIT_END]();
        return ret;
      }
      [EMITEND]() {
        if (this[EMITTED_END])
          return false;
        this[EMITTED_END] = true;
        this.readable = false;
        return this[ASYNC] ? (defer(() => this[EMITEND2]()), true) : this[EMITEND2]();
      }
      [EMITEND2]() {
        if (this[DECODER]) {
          const data = this[DECODER].end();
          if (data) {
            for (const p of this[PIPES]) {
              p.dest.write(data);
            }
            if (!this[DISCARDED])
              super.emit("data", data);
          }
        }
        for (const p of this[PIPES]) {
          p.end();
        }
        const ret = super.emit("end");
        this.removeAllListeners("end");
        return ret;
      }
      /**
       * Return a Promise that resolves to an array of all emitted data once
       * the stream ends.
       */
      async collect() {
        const buf = Object.assign([], {
          dataLength: 0
        });
        if (!this[OBJECTMODE])
          buf.dataLength = 0;
        const p = this.promise();
        this.on("data", (c) => {
          buf.push(c);
          if (!this[OBJECTMODE])
            buf.dataLength += c.length;
        });
        await p;
        return buf;
      }
      /**
       * Return a Promise that resolves to the concatenation of all emitted data
       * once the stream ends.
       *
       * Not allowed on objectMode streams.
       */
      async concat() {
        if (this[OBJECTMODE]) {
          throw new Error("cannot concat in objectMode");
        }
        const buf = await this.collect();
        return this[ENCODING] ? buf.join("") : Buffer.concat(buf, buf.dataLength);
      }
      /**
       * Return a void Promise that resolves once the stream ends.
       */
      async promise() {
        return new Promise((resolve, reject) => {
          this.on(DESTROYED, () => reject(new Error("stream destroyed")));
          this.on("error", (er) => reject(er));
          this.on("end", () => resolve());
        });
      }
      /**
       * Asynchronous `for await of` iteration.
       *
       * This will continue emitting all chunks until the stream terminates.
       */
      [Symbol.asyncIterator]() {
        this[DISCARDED] = false;
        let stopped = false;
        const stop = async () => {
          this.pause();
          stopped = true;
          return { value: void 0, done: true };
        };
        const next = () => {
          if (stopped)
            return stop();
          const res = this.read();
          if (res !== null)
            return Promise.resolve({ done: false, value: res });
          if (this[EOF])
            return stop();
          let resolve;
          let reject;
          const onerr = (er) => {
            this.off("data", ondata);
            this.off("end", onend);
            this.off(DESTROYED, ondestroy);
            stop();
            reject(er);
          };
          const ondata = (value) => {
            this.off("error", onerr);
            this.off("end", onend);
            this.off(DESTROYED, ondestroy);
            this.pause();
            resolve({ value, done: !!this[EOF] });
          };
          const onend = () => {
            this.off("error", onerr);
            this.off("data", ondata);
            this.off(DESTROYED, ondestroy);
            stop();
            resolve({ done: true, value: void 0 });
          };
          const ondestroy = () => onerr(new Error("stream destroyed"));
          return new Promise((res2, rej) => {
            reject = rej;
            resolve = res2;
            this.once(DESTROYED, ondestroy);
            this.once("error", onerr);
            this.once("end", onend);
            this.once("data", ondata);
          });
        };
        return {
          next,
          throw: stop,
          return: stop,
          [Symbol.asyncIterator]() {
            return this;
          }
        };
      }
      /**
       * Synchronous `for of` iteration.
       *
       * The iteration will terminate when the internal buffer runs out, even
       * if the stream has not yet terminated.
       */
      [Symbol.iterator]() {
        this[DISCARDED] = false;
        let stopped = false;
        const stop = () => {
          this.pause();
          this.off(ERROR, stop);
          this.off(DESTROYED, stop);
          this.off("end", stop);
          stopped = true;
          return { done: true, value: void 0 };
        };
        const next = () => {
          if (stopped)
            return stop();
          const value = this.read();
          return value === null ? stop() : { done: false, value };
        };
        this.once("end", stop);
        this.once(ERROR, stop);
        this.once(DESTROYED, stop);
        return {
          next,
          throw: stop,
          return: stop,
          [Symbol.iterator]() {
            return this;
          }
        };
      }
      /**
       * Destroy a stream, preventing it from being used for any further purpose.
       *
       * If the stream has a `close()` method, then it will be called on
       * destruction.
       *
       * After destruction, any attempt to write data, read data, or emit most
       * events will be ignored.
       *
       * If an error argument is provided, then it will be emitted in an
       * 'error' event.
       */
      destroy(er) {
        if (this[DESTROYED]) {
          if (er)
            this.emit("error", er);
          else
            this.emit(DESTROYED);
          return this;
        }
        this[DESTROYED] = true;
        this[DISCARDED] = true;
        this[BUFFER].length = 0;
        this[BUFFERLENGTH] = 0;
        const wc = this;
        if (typeof wc.close === "function" && !this[CLOSED])
          wc.close();
        if (er)
          this.emit("error", er);
        else
          this.emit(DESTROYED);
        return this;
      }
      /**
       * Alias for {@link isStream}
       *
       * Former export location, maintained for backwards compatibility.
       *
       * @deprecated
       */
      static get isStream() {
        return exports2.isStream;
      }
    };
    exports2.Minipass = Minipass;
  }
});

// node_modules/path-scurry/dist/commonjs/index.js
var require_commonjs4 = __commonJS({
  "node_modules/path-scurry/dist/commonjs/index.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.PathScurry = exports2.Path = exports2.PathScurryDarwin = exports2.PathScurryPosix = exports2.PathScurryWin32 = exports2.PathScurryBase = exports2.PathPosix = exports2.PathWin32 = exports2.PathBase = exports2.ChildrenCache = exports2.ResolveCache = void 0;
    var lru_cache_1 = require_commonjs2();
    var node_path_1 = require("node:path");
    var node_url_1 = require("node:url");
    var fs_1 = require("fs");
    var actualFS = __importStar(require("node:fs"));
    var realpathSync = fs_1.realpathSync.native;
    var promises_1 = require("node:fs/promises");
    var minipass_1 = require_commonjs3();
    var defaultFS = {
      lstatSync: fs_1.lstatSync,
      readdir: fs_1.readdir,
      readdirSync: fs_1.readdirSync,
      readlinkSync: fs_1.readlinkSync,
      realpathSync,
      promises: {
        lstat: promises_1.lstat,
        readdir: promises_1.readdir,
        readlink: promises_1.readlink,
        realpath: promises_1.realpath
      }
    };
    var fsFromOption = (fsOption) => !fsOption || fsOption === defaultFS || fsOption === actualFS ? defaultFS : {
      ...defaultFS,
      ...fsOption,
      promises: {
        ...defaultFS.promises,
        ...fsOption.promises || {}
      }
    };
    var uncDriveRegexp = /^\\\\\?\\([a-z]:)\\?$/i;
    var uncToDrive = (rootPath) => rootPath.replace(/\//g, "\\").replace(uncDriveRegexp, "$1\\");
    var eitherSep = /[\\\/]/;
    var UNKNOWN = 0;
    var IFIFO = 1;
    var IFCHR = 2;
    var IFDIR = 4;
    var IFBLK = 6;
    var IFREG = 8;
    var IFLNK = 10;
    var IFSOCK = 12;
    var IFMT = 15;
    var IFMT_UNKNOWN = ~IFMT;
    var READDIR_CALLED = 16;
    var LSTAT_CALLED = 32;
    var ENOTDIR = 64;
    var ENOENT = 128;
    var ENOREADLINK = 256;
    var ENOREALPATH = 512;
    var ENOCHILD = ENOTDIR | ENOENT | ENOREALPATH;
    var TYPEMASK = 1023;
    var entToType = (s) => s.isFile() ? IFREG : s.isDirectory() ? IFDIR : s.isSymbolicLink() ? IFLNK : s.isCharacterDevice() ? IFCHR : s.isBlockDevice() ? IFBLK : s.isSocket() ? IFSOCK : s.isFIFO() ? IFIFO : UNKNOWN;
    var normalizeCache = /* @__PURE__ */ new Map();
    var normalize = (s) => {
      const c = normalizeCache.get(s);
      if (c)
        return c;
      const n = s.normalize("NFKD");
      normalizeCache.set(s, n);
      return n;
    };
    var normalizeNocaseCache = /* @__PURE__ */ new Map();
    var normalizeNocase = (s) => {
      const c = normalizeNocaseCache.get(s);
      if (c)
        return c;
      const n = normalize(s.toLowerCase());
      normalizeNocaseCache.set(s, n);
      return n;
    };
    var ResolveCache = class extends lru_cache_1.LRUCache {
      constructor() {
        super({ max: 256 });
      }
    };
    exports2.ResolveCache = ResolveCache;
    var ChildrenCache = class extends lru_cache_1.LRUCache {
      constructor(maxSize = 16 * 1024) {
        super({
          maxSize,
          // parent + children
          sizeCalculation: (a) => a.length + 1
        });
      }
    };
    exports2.ChildrenCache = ChildrenCache;
    var setAsCwd = Symbol("PathScurry setAsCwd");
    var PathBase = class {
      /**
       * the basename of this path
       *
       * **Important**: *always* test the path name against any test string
       * usingthe {@link isNamed} method, and not by directly comparing this
       * string. Otherwise, unicode path strings that the system sees as identical
       * will not be properly treated as the same path, leading to incorrect
       * behavior and possible security issues.
       */
      name;
      /**
       * the Path entry corresponding to the path root.
       *
       * @internal
       */
      root;
      /**
       * All roots found within the current PathScurry family
       *
       * @internal
       */
      roots;
      /**
       * a reference to the parent path, or undefined in the case of root entries
       *
       * @internal
       */
      parent;
      /**
       * boolean indicating whether paths are compared case-insensitively
       * @internal
       */
      nocase;
      /**
       * boolean indicating that this path is the current working directory
       * of the PathScurry collection that contains it.
       */
      isCWD = false;
      // potential default fs override
      #fs;
      // Stats fields
      #dev;
      get dev() {
        return this.#dev;
      }
      #mode;
      get mode() {
        return this.#mode;
      }
      #nlink;
      get nlink() {
        return this.#nlink;
      }
      #uid;
      get uid() {
        return this.#uid;
      }
      #gid;
      get gid() {
        return this.#gid;
      }
      #rdev;
      get rdev() {
        return this.#rdev;
      }
      #blksize;
      get blksize() {
        return this.#blksize;
      }
      #ino;
      get ino() {
        return this.#ino;
      }
      #size;
      get size() {
        return this.#size;
      }
      #blocks;
      get blocks() {
        return this.#blocks;
      }
      #atimeMs;
      get atimeMs() {
        return this.#atimeMs;
      }
      #mtimeMs;
      get mtimeMs() {
        return this.#mtimeMs;
      }
      #ctimeMs;
      get ctimeMs() {
        return this.#ctimeMs;
      }
      #birthtimeMs;
      get birthtimeMs() {
        return this.#birthtimeMs;
      }
      #atime;
      get atime() {
        return this.#atime;
      }
      #mtime;
      get mtime() {
        return this.#mtime;
      }
      #ctime;
      get ctime() {
        return this.#ctime;
      }
      #birthtime;
      get birthtime() {
        return this.#birthtime;
      }
      #matchName;
      #depth;
      #fullpath;
      #fullpathPosix;
      #relative;
      #relativePosix;
      #type;
      #children;
      #linkTarget;
      #realpath;
      /**
       * This property is for compatibility with the Dirent class as of
       * Node v20, where Dirent['parentPath'] refers to the path of the
       * directory that was passed to readdir. For root entries, it's the path
       * to the entry itself.
       */
      get parentPath() {
        return (this.parent || this).fullpath();
      }
      /**
       * Deprecated alias for Dirent['parentPath'] Somewhat counterintuitively,
       * this property refers to the *parent* path, not the path object itself.
       */
      get path() {
        return this.parentPath;
      }
      /**
       * Do not create new Path objects directly.  They should always be accessed
       * via the PathScurry class or other methods on the Path class.
       *
       * @internal
       */
      constructor(name2, type = UNKNOWN, root, roots, nocase, children, opts) {
        this.name = name2;
        this.#matchName = nocase ? normalizeNocase(name2) : normalize(name2);
        this.#type = type & TYPEMASK;
        this.nocase = nocase;
        this.roots = roots;
        this.root = root || this;
        this.#children = children;
        this.#fullpath = opts.fullpath;
        this.#relative = opts.relative;
        this.#relativePosix = opts.relativePosix;
        this.parent = opts.parent;
        if (this.parent) {
          this.#fs = this.parent.#fs;
        } else {
          this.#fs = fsFromOption(opts.fs);
        }
      }
      /**
       * Returns the depth of the Path object from its root.
       *
       * For example, a path at `/foo/bar` would have a depth of 2.
       */
      depth() {
        if (this.#depth !== void 0)
          return this.#depth;
        if (!this.parent)
          return this.#depth = 0;
        return this.#depth = this.parent.depth() + 1;
      }
      /**
       * @internal
       */
      childrenCache() {
        return this.#children;
      }
      /**
       * Get the Path object referenced by the string path, resolved from this Path
       */
      resolve(path2) {
        if (!path2) {
          return this;
        }
        const rootPath = this.getRootString(path2);
        const dir = path2.substring(rootPath.length);
        const dirParts = dir.split(this.splitSep);
        const result = rootPath ? this.getRoot(rootPath).#resolveParts(dirParts) : this.#resolveParts(dirParts);
        return result;
      }
      #resolveParts(dirParts) {
        let p = this;
        for (const part of dirParts) {
          p = p.child(part);
        }
        return p;
      }
      /**
       * Returns the cached children Path objects, if still available.  If they
       * have fallen out of the cache, then returns an empty array, and resets the
       * READDIR_CALLED bit, so that future calls to readdir() will require an fs
       * lookup.
       *
       * @internal
       */
      children() {
        const cached = this.#children.get(this);
        if (cached) {
          return cached;
        }
        const children = Object.assign([], { provisional: 0 });
        this.#children.set(this, children);
        this.#type &= ~READDIR_CALLED;
        return children;
      }
      /**
       * Resolves a path portion and returns or creates the child Path.
       *
       * Returns `this` if pathPart is `''` or `'.'`, or `parent` if pathPart is
       * `'..'`.
       *
       * This should not be called directly.  If `pathPart` contains any path
       * separators, it will lead to unsafe undefined behavior.
       *
       * Use `Path.resolve()` instead.
       *
       * @internal
       */
      child(pathPart, opts) {
        if (pathPart === "" || pathPart === ".") {
          return this;
        }
        if (pathPart === "..") {
          return this.parent || this;
        }
        const children = this.children();
        const name2 = this.nocase ? normalizeNocase(pathPart) : normalize(pathPart);
        for (const p of children) {
          if (p.#matchName === name2) {
            return p;
          }
        }
        const s = this.parent ? this.sep : "";
        const fullpath = this.#fullpath ? this.#fullpath + s + pathPart : void 0;
        const pchild = this.newChild(pathPart, UNKNOWN, {
          ...opts,
          parent: this,
          fullpath
        });
        if (!this.canReaddir()) {
          pchild.#type |= ENOENT;
        }
        children.push(pchild);
        return pchild;
      }
      /**
       * The relative path from the cwd. If it does not share an ancestor with
       * the cwd, then this ends up being equivalent to the fullpath()
       */
      relative() {
        if (this.isCWD)
          return "";
        if (this.#relative !== void 0) {
          return this.#relative;
        }
        const name2 = this.name;
        const p = this.parent;
        if (!p) {
          return this.#relative = this.name;
        }
        const pv = p.relative();
        return pv + (!pv || !p.parent ? "" : this.sep) + name2;
      }
      /**
       * The relative path from the cwd, using / as the path separator.
       * If it does not share an ancestor with
       * the cwd, then this ends up being equivalent to the fullpathPosix()
       * On posix systems, this is identical to relative().
       */
      relativePosix() {
        if (this.sep === "/")
          return this.relative();
        if (this.isCWD)
          return "";
        if (this.#relativePosix !== void 0)
          return this.#relativePosix;
        const name2 = this.name;
        const p = this.parent;
        if (!p) {
          return this.#relativePosix = this.fullpathPosix();
        }
        const pv = p.relativePosix();
        return pv + (!pv || !p.parent ? "" : "/") + name2;
      }
      /**
       * The fully resolved path string for this Path entry
       */
      fullpath() {
        if (this.#fullpath !== void 0) {
          return this.#fullpath;
        }
        const name2 = this.name;
        const p = this.parent;
        if (!p) {
          return this.#fullpath = this.name;
        }
        const pv = p.fullpath();
        const fp = pv + (!p.parent ? "" : this.sep) + name2;
        return this.#fullpath = fp;
      }
      /**
       * On platforms other than windows, this is identical to fullpath.
       *
       * On windows, this is overridden to return the forward-slash form of the
       * full UNC path.
       */
      fullpathPosix() {
        if (this.#fullpathPosix !== void 0)
          return this.#fullpathPosix;
        if (this.sep === "/")
          return this.#fullpathPosix = this.fullpath();
        if (!this.parent) {
          const p2 = this.fullpath().replace(/\\/g, "/");
          if (/^[a-z]:\//i.test(p2)) {
            return this.#fullpathPosix = `//?/${p2}`;
          } else {
            return this.#fullpathPosix = p2;
          }
        }
        const p = this.parent;
        const pfpp = p.fullpathPosix();
        const fpp = pfpp + (!pfpp || !p.parent ? "" : "/") + this.name;
        return this.#fullpathPosix = fpp;
      }
      /**
       * Is the Path of an unknown type?
       *
       * Note that we might know *something* about it if there has been a previous
       * filesystem operation, for example that it does not exist, or is not a
       * link, or whether it has child entries.
       */
      isUnknown() {
        return (this.#type & IFMT) === UNKNOWN;
      }
      isType(type) {
        return this[`is${type}`]();
      }
      getType() {
        return this.isUnknown() ? "Unknown" : this.isDirectory() ? "Directory" : this.isFile() ? "File" : this.isSymbolicLink() ? "SymbolicLink" : this.isFIFO() ? "FIFO" : this.isCharacterDevice() ? "CharacterDevice" : this.isBlockDevice() ? "BlockDevice" : (
          /* c8 ignore start */
          this.isSocket() ? "Socket" : "Unknown"
        );
      }
      /**
       * Is the Path a regular file?
       */
      isFile() {
        return (this.#type & IFMT) === IFREG;
      }
      /**
       * Is the Path a directory?
       */
      isDirectory() {
        return (this.#type & IFMT) === IFDIR;
      }
      /**
       * Is the path a character device?
       */
      isCharacterDevice() {
        return (this.#type & IFMT) === IFCHR;
      }
      /**
       * Is the path a block device?
       */
      isBlockDevice() {
        return (this.#type & IFMT) === IFBLK;
      }
      /**
       * Is the path a FIFO pipe?
       */
      isFIFO() {
        return (this.#type & IFMT) === IFIFO;
      }
      /**
       * Is the path a socket?
       */
      isSocket() {
        return (this.#type & IFMT) === IFSOCK;
      }
      /**
       * Is the path a symbolic link?
       */
      isSymbolicLink() {
        return (this.#type & IFLNK) === IFLNK;
      }
      /**
       * Return the entry if it has been subject of a successful lstat, or
       * undefined otherwise.
       *
       * Does not read the filesystem, so an undefined result *could* simply
       * mean that we haven't called lstat on it.
       */
      lstatCached() {
        return this.#type & LSTAT_CALLED ? this : void 0;
      }
      /**
       * Return the cached link target if the entry has been the subject of a
       * successful readlink, or undefined otherwise.
       *
       * Does not read the filesystem, so an undefined result *could* just mean we
       * don't have any cached data. Only use it if you are very sure that a
       * readlink() has been called at some point.
       */
      readlinkCached() {
        return this.#linkTarget;
      }
      /**
       * Returns the cached realpath target if the entry has been the subject
       * of a successful realpath, or undefined otherwise.
       *
       * Does not read the filesystem, so an undefined result *could* just mean we
       * don't have any cached data. Only use it if you are very sure that a
       * realpath() has been called at some point.
       */
      realpathCached() {
        return this.#realpath;
      }
      /**
       * Returns the cached child Path entries array if the entry has been the
       * subject of a successful readdir(), or [] otherwise.
       *
       * Does not read the filesystem, so an empty array *could* just mean we
       * don't have any cached data. Only use it if you are very sure that a
       * readdir() has been called recently enough to still be valid.
       */
      readdirCached() {
        const children = this.children();
        return children.slice(0, children.provisional);
      }
      /**
       * Return true if it's worth trying to readlink.  Ie, we don't (yet) have
       * any indication that readlink will definitely fail.
       *
       * Returns false if the path is known to not be a symlink, if a previous
       * readlink failed, or if the entry does not exist.
       */
      canReadlink() {
        if (this.#linkTarget)
          return true;
        if (!this.parent)
          return false;
        const ifmt = this.#type & IFMT;
        return !(ifmt !== UNKNOWN && ifmt !== IFLNK || this.#type & ENOREADLINK || this.#type & ENOENT);
      }
      /**
       * Return true if readdir has previously been successfully called on this
       * path, indicating that cachedReaddir() is likely valid.
       */
      calledReaddir() {
        return !!(this.#type & READDIR_CALLED);
      }
      /**
       * Returns true if the path is known to not exist. That is, a previous lstat
       * or readdir failed to verify its existence when that would have been
       * expected, or a parent entry was marked either enoent or enotdir.
       */
      isENOENT() {
        return !!(this.#type & ENOENT);
      }
      /**
       * Return true if the path is a match for the given path name.  This handles
       * case sensitivity and unicode normalization.
       *
       * Note: even on case-sensitive systems, it is **not** safe to test the
       * equality of the `.name` property to determine whether a given pathname
       * matches, due to unicode normalization mismatches.
       *
       * Always use this method instead of testing the `path.name` property
       * directly.
       */
      isNamed(n) {
        return !this.nocase ? this.#matchName === normalize(n) : this.#matchName === normalizeNocase(n);
      }
      /**
       * Return the Path object corresponding to the target of a symbolic link.
       *
       * If the Path is not a symbolic link, or if the readlink call fails for any
       * reason, `undefined` is returned.
       *
       * Result is cached, and thus may be outdated if the filesystem is mutated.
       */
      async readlink() {
        const target = this.#linkTarget;
        if (target) {
          return target;
        }
        if (!this.canReadlink()) {
          return void 0;
        }
        if (!this.parent) {
          return void 0;
        }
        try {
          const read = await this.#fs.promises.readlink(this.fullpath());
          const linkTarget = (await this.parent.realpath())?.resolve(read);
          if (linkTarget) {
            return this.#linkTarget = linkTarget;
          }
        } catch (er) {
          this.#readlinkFail(er.code);
          return void 0;
        }
      }
      /**
       * Synchronous {@link PathBase.readlink}
       */
      readlinkSync() {
        const target = this.#linkTarget;
        if (target) {
          return target;
        }
        if (!this.canReadlink()) {
          return void 0;
        }
        if (!this.parent) {
          return void 0;
        }
        try {
          const read = this.#fs.readlinkSync(this.fullpath());
          const linkTarget = this.parent.realpathSync()?.resolve(read);
          if (linkTarget) {
            return this.#linkTarget = linkTarget;
          }
        } catch (er) {
          this.#readlinkFail(er.code);
          return void 0;
        }
      }
      #readdirSuccess(children) {
        this.#type |= READDIR_CALLED;
        for (let p = children.provisional; p < children.length; p++) {
          const c = children[p];
          if (c)
            c.#markENOENT();
        }
      }
      #markENOENT() {
        if (this.#type & ENOENT)
          return;
        this.#type = (this.#type | ENOENT) & IFMT_UNKNOWN;
        this.#markChildrenENOENT();
      }
      #markChildrenENOENT() {
        const children = this.children();
        children.provisional = 0;
        for (const p of children) {
          p.#markENOENT();
        }
      }
      #markENOREALPATH() {
        this.#type |= ENOREALPATH;
        this.#markENOTDIR();
      }
      // save the information when we know the entry is not a dir
      #markENOTDIR() {
        if (this.#type & ENOTDIR)
          return;
        let t = this.#type;
        if ((t & IFMT) === IFDIR)
          t &= IFMT_UNKNOWN;
        this.#type = t | ENOTDIR;
        this.#markChildrenENOENT();
      }
      #readdirFail(code = "") {
        if (code === "ENOTDIR" || code === "EPERM") {
          this.#markENOTDIR();
        } else if (code === "ENOENT") {
          this.#markENOENT();
        } else {
          this.children().provisional = 0;
        }
      }
      #lstatFail(code = "") {
        if (code === "ENOTDIR") {
          const p = this.parent;
          p.#markENOTDIR();
        } else if (code === "ENOENT") {
          this.#markENOENT();
        }
      }
      #readlinkFail(code = "") {
        let ter = this.#type;
        ter |= ENOREADLINK;
        if (code === "ENOENT")
          ter |= ENOENT;
        if (code === "EINVAL" || code === "UNKNOWN") {
          ter &= IFMT_UNKNOWN;
        }
        this.#type = ter;
        if (code === "ENOTDIR" && this.parent) {
          this.parent.#markENOTDIR();
        }
      }
      #readdirAddChild(e, c) {
        return this.#readdirMaybePromoteChild(e, c) || this.#readdirAddNewChild(e, c);
      }
      #readdirAddNewChild(e, c) {
        const type = entToType(e);
        const child = this.newChild(e.name, type, { parent: this });
        const ifmt = child.#type & IFMT;
        if (ifmt !== IFDIR && ifmt !== IFLNK && ifmt !== UNKNOWN) {
          child.#type |= ENOTDIR;
        }
        c.unshift(child);
        c.provisional++;
        return child;
      }
      #readdirMaybePromoteChild(e, c) {
        for (let p = c.provisional; p < c.length; p++) {
          const pchild = c[p];
          const name2 = this.nocase ? normalizeNocase(e.name) : normalize(e.name);
          if (name2 !== pchild.#matchName) {
            continue;
          }
          return this.#readdirPromoteChild(e, pchild, p, c);
        }
      }
      #readdirPromoteChild(e, p, index, c) {
        const v = p.name;
        p.#type = p.#type & IFMT_UNKNOWN | entToType(e);
        if (v !== e.name)
          p.name = e.name;
        if (index !== c.provisional) {
          if (index === c.length - 1)
            c.pop();
          else
            c.splice(index, 1);
          c.unshift(p);
        }
        c.provisional++;
        return p;
      }
      /**
       * Call lstat() on this Path, and update all known information that can be
       * determined.
       *
       * Note that unlike `fs.lstat()`, the returned value does not contain some
       * information, such as `mode`, `dev`, `nlink`, and `ino`.  If that
       * information is required, you will need to call `fs.lstat` yourself.
       *
       * If the Path refers to a nonexistent file, or if the lstat call fails for
       * any reason, `undefined` is returned.  Otherwise the updated Path object is
       * returned.
       *
       * Results are cached, and thus may be out of date if the filesystem is
       * mutated.
       */
      async lstat() {
        if ((this.#type & ENOENT) === 0) {
          try {
            this.#applyStat(await this.#fs.promises.lstat(this.fullpath()));
            return this;
          } catch (er) {
            this.#lstatFail(er.code);
          }
        }
      }
      /**
       * synchronous {@link PathBase.lstat}
       */
      lstatSync() {
        if ((this.#type & ENOENT) === 0) {
          try {
            this.#applyStat(this.#fs.lstatSync(this.fullpath()));
            return this;
          } catch (er) {
            this.#lstatFail(er.code);
          }
        }
      }
      #applyStat(st) {
        const { atime, atimeMs, birthtime, birthtimeMs, blksize, blocks, ctime, ctimeMs, dev, gid, ino, mode, mtime, mtimeMs, nlink, rdev, size, uid } = st;
        this.#atime = atime;
        this.#atimeMs = atimeMs;
        this.#birthtime = birthtime;
        this.#birthtimeMs = birthtimeMs;
        this.#blksize = blksize;
        this.#blocks = blocks;
        this.#ctime = ctime;
        this.#ctimeMs = ctimeMs;
        this.#dev = dev;
        this.#gid = gid;
        this.#ino = ino;
        this.#mode = mode;
        this.#mtime = mtime;
        this.#mtimeMs = mtimeMs;
        this.#nlink = nlink;
        this.#rdev = rdev;
        this.#size = size;
        this.#uid = uid;
        const ifmt = entToType(st);
        this.#type = this.#type & IFMT_UNKNOWN | ifmt | LSTAT_CALLED;
        if (ifmt !== UNKNOWN && ifmt !== IFDIR && ifmt !== IFLNK) {
          this.#type |= ENOTDIR;
        }
      }
      #onReaddirCB = [];
      #readdirCBInFlight = false;
      #callOnReaddirCB(children) {
        this.#readdirCBInFlight = false;
        const cbs = this.#onReaddirCB.slice();
        this.#onReaddirCB.length = 0;
        cbs.forEach((cb) => cb(null, children));
      }
      /**
       * Standard node-style callback interface to get list of directory entries.
       *
       * If the Path cannot or does not contain any children, then an empty array
       * is returned.
       *
       * Results are cached, and thus may be out of date if the filesystem is
       * mutated.
       *
       * @param cb The callback called with (er, entries).  Note that the `er`
       * param is somewhat extraneous, as all readdir() errors are handled and
       * simply result in an empty set of entries being returned.
       * @param allowZalgo Boolean indicating that immediately known results should
       * *not* be deferred with `queueMicrotask`. Defaults to `false`. Release
       * zalgo at your peril, the dark pony lord is devious and unforgiving.
       */
      readdirCB(cb, allowZalgo = false) {
        if (!this.canReaddir()) {
          if (allowZalgo)
            cb(null, []);
          else
            queueMicrotask(() => cb(null, []));
          return;
        }
        const children = this.children();
        if (this.calledReaddir()) {
          const c = children.slice(0, children.provisional);
          if (allowZalgo)
            cb(null, c);
          else
            queueMicrotask(() => cb(null, c));
          return;
        }
        this.#onReaddirCB.push(cb);
        if (this.#readdirCBInFlight) {
          return;
        }
        this.#readdirCBInFlight = true;
        const fullpath = this.fullpath();
        this.#fs.readdir(fullpath, { withFileTypes: true }, (er, entries) => {
          if (er) {
            this.#readdirFail(er.code);
            children.provisional = 0;
          } else {
            for (const e of entries) {
              this.#readdirAddChild(e, children);
            }
            this.#readdirSuccess(children);
          }
          this.#callOnReaddirCB(children.slice(0, children.provisional));
          return;
        });
      }
      #asyncReaddirInFlight;
      /**
       * Return an array of known child entries.
       *
       * If the Path cannot or does not contain any children, then an empty array
       * is returned.
       *
       * Results are cached, and thus may be out of date if the filesystem is
       * mutated.
       */
      async readdir() {
        if (!this.canReaddir()) {
          return [];
        }
        const children = this.children();
        if (this.calledReaddir()) {
          return children.slice(0, children.provisional);
        }
        const fullpath = this.fullpath();
        if (this.#asyncReaddirInFlight) {
          await this.#asyncReaddirInFlight;
        } else {
          let resolve = () => {
          };
          this.#asyncReaddirInFlight = new Promise((res) => resolve = res);
          try {
            for (const e of await this.#fs.promises.readdir(fullpath, {
              withFileTypes: true
            })) {
              this.#readdirAddChild(e, children);
            }
            this.#readdirSuccess(children);
          } catch (er) {
            this.#readdirFail(er.code);
            children.provisional = 0;
          }
          this.#asyncReaddirInFlight = void 0;
          resolve();
        }
        return children.slice(0, children.provisional);
      }
      /**
       * synchronous {@link PathBase.readdir}
       */
      readdirSync() {
        if (!this.canReaddir()) {
          return [];
        }
        const children = this.children();
        if (this.calledReaddir()) {
          return children.slice(0, children.provisional);
        }
        const fullpath = this.fullpath();
        try {
          for (const e of this.#fs.readdirSync(fullpath, {
            withFileTypes: true
          })) {
            this.#readdirAddChild(e, children);
          }
          this.#readdirSuccess(children);
        } catch (er) {
          this.#readdirFail(er.code);
          children.provisional = 0;
        }
        return children.slice(0, children.provisional);
      }
      canReaddir() {
        if (this.#type & ENOCHILD)
          return false;
        const ifmt = IFMT & this.#type;
        if (!(ifmt === UNKNOWN || ifmt === IFDIR || ifmt === IFLNK)) {
          return false;
        }
        return true;
      }
      shouldWalk(dirs, walkFilter) {
        return (this.#type & IFDIR) === IFDIR && !(this.#type & ENOCHILD) && !dirs.has(this) && (!walkFilter || walkFilter(this));
      }
      /**
       * Return the Path object corresponding to path as resolved
       * by realpath(3).
       *
       * If the realpath call fails for any reason, `undefined` is returned.
       *
       * Result is cached, and thus may be outdated if the filesystem is mutated.
       * On success, returns a Path object.
       */
      async realpath() {
        if (this.#realpath)
          return this.#realpath;
        if ((ENOREALPATH | ENOREADLINK | ENOENT) & this.#type)
          return void 0;
        try {
          const rp = await this.#fs.promises.realpath(this.fullpath());
          return this.#realpath = this.resolve(rp);
        } catch (_) {
          this.#markENOREALPATH();
        }
      }
      /**
       * Synchronous {@link realpath}
       */
      realpathSync() {
        if (this.#realpath)
          return this.#realpath;
        if ((ENOREALPATH | ENOREADLINK | ENOENT) & this.#type)
          return void 0;
        try {
          const rp = this.#fs.realpathSync(this.fullpath());
          return this.#realpath = this.resolve(rp);
        } catch (_) {
          this.#markENOREALPATH();
        }
      }
      /**
       * Internal method to mark this Path object as the scurry cwd,
       * called by {@link PathScurry#chdir}
       *
       * @internal
       */
      [setAsCwd](oldCwd) {
        if (oldCwd === this)
          return;
        oldCwd.isCWD = false;
        this.isCWD = true;
        const changed = /* @__PURE__ */ new Set([]);
        let rp = [];
        let p = this;
        while (p && p.parent) {
          changed.add(p);
          p.#relative = rp.join(this.sep);
          p.#relativePosix = rp.join("/");
          p = p.parent;
          rp.push("..");
        }
        p = oldCwd;
        while (p && p.parent && !changed.has(p)) {
          p.#relative = void 0;
          p.#relativePosix = void 0;
          p = p.parent;
        }
      }
    };
    exports2.PathBase = PathBase;
    var PathWin32 = class _PathWin32 extends PathBase {
      /**
       * Separator for generating path strings.
       */
      sep = "\\";
      /**
       * Separator for parsing path strings.
       */
      splitSep = eitherSep;
      /**
       * Do not create new Path objects directly.  They should always be accessed
       * via the PathScurry class or other methods on the Path class.
       *
       * @internal
       */
      constructor(name2, type = UNKNOWN, root, roots, nocase, children, opts) {
        super(name2, type, root, roots, nocase, children, opts);
      }
      /**
       * @internal
       */
      newChild(name2, type = UNKNOWN, opts = {}) {
        return new _PathWin32(name2, type, this.root, this.roots, this.nocase, this.childrenCache(), opts);
      }
      /**
       * @internal
       */
      getRootString(path2) {
        return node_path_1.win32.parse(path2).root;
      }
      /**
       * @internal
       */
      getRoot(rootPath) {
        rootPath = uncToDrive(rootPath.toUpperCase());
        if (rootPath === this.root.name) {
          return this.root;
        }
        for (const [compare2, root] of Object.entries(this.roots)) {
          if (this.sameRoot(rootPath, compare2)) {
            return this.roots[rootPath] = root;
          }
        }
        return this.roots[rootPath] = new PathScurryWin32(rootPath, this).root;
      }
      /**
       * @internal
       */
      sameRoot(rootPath, compare2 = this.root.name) {
        rootPath = rootPath.toUpperCase().replace(/\//g, "\\").replace(uncDriveRegexp, "$1\\");
        return rootPath === compare2;
      }
    };
    exports2.PathWin32 = PathWin32;
    var PathPosix = class _PathPosix extends PathBase {
      /**
       * separator for parsing path strings
       */
      splitSep = "/";
      /**
       * separator for generating path strings
       */
      sep = "/";
      /**
       * Do not create new Path objects directly.  They should always be accessed
       * via the PathScurry class or other methods on the Path class.
       *
       * @internal
       */
      constructor(name2, type = UNKNOWN, root, roots, nocase, children, opts) {
        super(name2, type, root, roots, nocase, children, opts);
      }
      /**
       * @internal
       */
      getRootString(path2) {
        return path2.startsWith("/") ? "/" : "";
      }
      /**
       * @internal
       */
      getRoot(_rootPath) {
        return this.root;
      }
      /**
       * @internal
       */
      newChild(name2, type = UNKNOWN, opts = {}) {
        return new _PathPosix(name2, type, this.root, this.roots, this.nocase, this.childrenCache(), opts);
      }
    };
    exports2.PathPosix = PathPosix;
    var PathScurryBase = class {
      /**
       * The root Path entry for the current working directory of this Scurry
       */
      root;
      /**
       * The string path for the root of this Scurry's current working directory
       */
      rootPath;
      /**
       * A collection of all roots encountered, referenced by rootPath
       */
      roots;
      /**
       * The Path entry corresponding to this PathScurry's current working directory.
       */
      cwd;
      #resolveCache;
      #resolvePosixCache;
      #children;
      /**
       * Perform path comparisons case-insensitively.
       *
       * Defaults true on Darwin and Windows systems, false elsewhere.
       */
      nocase;
      #fs;
      /**
       * This class should not be instantiated directly.
       *
       * Use PathScurryWin32, PathScurryDarwin, PathScurryPosix, or PathScurry
       *
       * @internal
       */
      constructor(cwd2 = process.cwd(), pathImpl, sep, { nocase, childrenCacheSize = 16 * 1024, fs: fs2 = defaultFS } = {}) {
        this.#fs = fsFromOption(fs2);
        if (cwd2 instanceof URL || cwd2.startsWith("file://")) {
          cwd2 = (0, node_url_1.fileURLToPath)(cwd2);
        }
        const cwdPath = pathImpl.resolve(cwd2);
        this.roots = /* @__PURE__ */ Object.create(null);
        this.rootPath = this.parseRootPath(cwdPath);
        this.#resolveCache = new ResolveCache();
        this.#resolvePosixCache = new ResolveCache();
        this.#children = new ChildrenCache(childrenCacheSize);
        const split = cwdPath.substring(this.rootPath.length).split(sep);
        if (split.length === 1 && !split[0]) {
          split.pop();
        }
        if (nocase === void 0) {
          throw new TypeError("must provide nocase setting to PathScurryBase ctor");
        }
        this.nocase = nocase;
        this.root = this.newRoot(this.#fs);
        this.roots[this.rootPath] = this.root;
        let prev = this.root;
        let len = split.length - 1;
        const joinSep = pathImpl.sep;
        let abs = this.rootPath;
        let sawFirst = false;
        for (const part of split) {
          const l = len--;
          prev = prev.child(part, {
            relative: new Array(l).fill("..").join(joinSep),
            relativePosix: new Array(l).fill("..").join("/"),
            fullpath: abs += (sawFirst ? "" : joinSep) + part
          });
          sawFirst = true;
        }
        this.cwd = prev;
      }
      /**
       * Get the depth of a provided path, string, or the cwd
       */
      depth(path2 = this.cwd) {
        if (typeof path2 === "string") {
          path2 = this.cwd.resolve(path2);
        }
        return path2.depth();
      }
      /**
       * Return the cache of child entries.  Exposed so subclasses can create
       * child Path objects in a platform-specific way.
       *
       * @internal
       */
      childrenCache() {
        return this.#children;
      }
      /**
       * Resolve one or more path strings to a resolved string
       *
       * Same interface as require('path').resolve.
       *
       * Much faster than path.resolve() when called multiple times for the same
       * path, because the resolved Path objects are cached.  Much slower
       * otherwise.
       */
      resolve(...paths) {
        let r = "";
        for (let i = paths.length - 1; i >= 0; i--) {
          const p = paths[i];
          if (!p || p === ".")
            continue;
          r = r ? `${p}/${r}` : p;
          if (this.isAbsolute(p)) {
            break;
          }
        }
        const cached = this.#resolveCache.get(r);
        if (cached !== void 0) {
          return cached;
        }
        const result = this.cwd.resolve(r).fullpath();
        this.#resolveCache.set(r, result);
        return result;
      }
      /**
       * Resolve one or more path strings to a resolved string, returning
       * the posix path.  Identical to .resolve() on posix systems, but on
       * windows will return a forward-slash separated UNC path.
       *
       * Same interface as require('path').resolve.
       *
       * Much faster than path.resolve() when called multiple times for the same
       * path, because the resolved Path objects are cached.  Much slower
       * otherwise.
       */
      resolvePosix(...paths) {
        let r = "";
        for (let i = paths.length - 1; i >= 0; i--) {
          const p = paths[i];
          if (!p || p === ".")
            continue;
          r = r ? `${p}/${r}` : p;
          if (this.isAbsolute(p)) {
            break;
          }
        }
        const cached = this.#resolvePosixCache.get(r);
        if (cached !== void 0) {
          return cached;
        }
        const result = this.cwd.resolve(r).fullpathPosix();
        this.#resolvePosixCache.set(r, result);
        return result;
      }
      /**
       * find the relative path from the cwd to the supplied path string or entry
       */
      relative(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.relative();
      }
      /**
       * find the relative path from the cwd to the supplied path string or
       * entry, using / as the path delimiter, even on Windows.
       */
      relativePosix(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.relativePosix();
      }
      /**
       * Return the basename for the provided string or Path object
       */
      basename(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.name;
      }
      /**
       * Return the dirname for the provided string or Path object
       */
      dirname(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return (entry.parent || entry).fullpath();
      }
      async readdir(entry = this.cwd, opts = {
        withFileTypes: true
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes } = opts;
        if (!entry.canReaddir()) {
          return [];
        } else {
          const p = await entry.readdir();
          return withFileTypes ? p : p.map((e) => e.name);
        }
      }
      readdirSync(entry = this.cwd, opts = {
        withFileTypes: true
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true } = opts;
        if (!entry.canReaddir()) {
          return [];
        } else if (withFileTypes) {
          return entry.readdirSync();
        } else {
          return entry.readdirSync().map((e) => e.name);
        }
      }
      /**
       * Call lstat() on the string or Path object, and update all known
       * information that can be determined.
       *
       * Note that unlike `fs.lstat()`, the returned value does not contain some
       * information, such as `mode`, `dev`, `nlink`, and `ino`.  If that
       * information is required, you will need to call `fs.lstat` yourself.
       *
       * If the Path refers to a nonexistent file, or if the lstat call fails for
       * any reason, `undefined` is returned.  Otherwise the updated Path object is
       * returned.
       *
       * Results are cached, and thus may be out of date if the filesystem is
       * mutated.
       */
      async lstat(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.lstat();
      }
      /**
       * synchronous {@link PathScurryBase.lstat}
       */
      lstatSync(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.lstatSync();
      }
      async readlink(entry = this.cwd, { withFileTypes } = {
        withFileTypes: false
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          withFileTypes = entry.withFileTypes;
          entry = this.cwd;
        }
        const e = await entry.readlink();
        return withFileTypes ? e : e?.fullpath();
      }
      readlinkSync(entry = this.cwd, { withFileTypes } = {
        withFileTypes: false
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          withFileTypes = entry.withFileTypes;
          entry = this.cwd;
        }
        const e = entry.readlinkSync();
        return withFileTypes ? e : e?.fullpath();
      }
      async realpath(entry = this.cwd, { withFileTypes } = {
        withFileTypes: false
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          withFileTypes = entry.withFileTypes;
          entry = this.cwd;
        }
        const e = await entry.realpath();
        return withFileTypes ? e : e?.fullpath();
      }
      realpathSync(entry = this.cwd, { withFileTypes } = {
        withFileTypes: false
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          withFileTypes = entry.withFileTypes;
          entry = this.cwd;
        }
        const e = entry.realpathSync();
        return withFileTypes ? e : e?.fullpath();
      }
      async walk(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter: filter2, walkFilter } = opts;
        const results = [];
        if (!filter2 || filter2(entry)) {
          results.push(withFileTypes ? entry : entry.fullpath());
        }
        const dirs = /* @__PURE__ */ new Set();
        const walk2 = (dir, cb) => {
          dirs.add(dir);
          dir.readdirCB((er, entries) => {
            if (er) {
              return cb(er);
            }
            let len = entries.length;
            if (!len)
              return cb();
            const next = () => {
              if (--len === 0) {
                cb();
              }
            };
            for (const e of entries) {
              if (!filter2 || filter2(e)) {
                results.push(withFileTypes ? e : e.fullpath());
              }
              if (follow && e.isSymbolicLink()) {
                e.realpath().then((r) => r?.isUnknown() ? r.lstat() : r).then((r) => r?.shouldWalk(dirs, walkFilter) ? walk2(r, next) : next());
              } else {
                if (e.shouldWalk(dirs, walkFilter)) {
                  walk2(e, next);
                } else {
                  next();
                }
              }
            }
          }, true);
        };
        const start = entry;
        return new Promise((res, rej) => {
          walk2(start, (er) => {
            if (er)
              return rej(er);
            res(results);
          });
        });
      }
      walkSync(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter: filter2, walkFilter } = opts;
        const results = [];
        if (!filter2 || filter2(entry)) {
          results.push(withFileTypes ? entry : entry.fullpath());
        }
        const dirs = /* @__PURE__ */ new Set([entry]);
        for (const dir of dirs) {
          const entries = dir.readdirSync();
          for (const e of entries) {
            if (!filter2 || filter2(e)) {
              results.push(withFileTypes ? e : e.fullpath());
            }
            let r = e;
            if (e.isSymbolicLink()) {
              if (!(follow && (r = e.realpathSync())))
                continue;
              if (r.isUnknown())
                r.lstatSync();
            }
            if (r.shouldWalk(dirs, walkFilter)) {
              dirs.add(r);
            }
          }
        }
        return results;
      }
      /**
       * Support for `for await`
       *
       * Alias for {@link PathScurryBase.iterate}
       *
       * Note: As of Node 19, this is very slow, compared to other methods of
       * walking.  Consider using {@link PathScurryBase.stream} if memory overhead
       * and backpressure are concerns, or {@link PathScurryBase.walk} if not.
       */
      [Symbol.asyncIterator]() {
        return this.iterate();
      }
      iterate(entry = this.cwd, options2 = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          options2 = entry;
          entry = this.cwd;
        }
        return this.stream(entry, options2)[Symbol.asyncIterator]();
      }
      /**
       * Iterating over a PathScurry performs a synchronous walk.
       *
       * Alias for {@link PathScurryBase.iterateSync}
       */
      [Symbol.iterator]() {
        return this.iterateSync();
      }
      *iterateSync(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter: filter2, walkFilter } = opts;
        if (!filter2 || filter2(entry)) {
          yield withFileTypes ? entry : entry.fullpath();
        }
        const dirs = /* @__PURE__ */ new Set([entry]);
        for (const dir of dirs) {
          const entries = dir.readdirSync();
          for (const e of entries) {
            if (!filter2 || filter2(e)) {
              yield withFileTypes ? e : e.fullpath();
            }
            let r = e;
            if (e.isSymbolicLink()) {
              if (!(follow && (r = e.realpathSync())))
                continue;
              if (r.isUnknown())
                r.lstatSync();
            }
            if (r.shouldWalk(dirs, walkFilter)) {
              dirs.add(r);
            }
          }
        }
      }
      stream(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter: filter2, walkFilter } = opts;
        const results = new minipass_1.Minipass({ objectMode: true });
        if (!filter2 || filter2(entry)) {
          results.write(withFileTypes ? entry : entry.fullpath());
        }
        const dirs = /* @__PURE__ */ new Set();
        const queue = [entry];
        let processing = 0;
        const process2 = () => {
          let paused = false;
          while (!paused) {
            const dir = queue.shift();
            if (!dir) {
              if (processing === 0)
                results.end();
              return;
            }
            processing++;
            dirs.add(dir);
            const onReaddir = (er, entries, didRealpaths = false) => {
              if (er)
                return results.emit("error", er);
              if (follow && !didRealpaths) {
                const promises = [];
                for (const e of entries) {
                  if (e.isSymbolicLink()) {
                    promises.push(e.realpath().then((r) => r?.isUnknown() ? r.lstat() : r));
                  }
                }
                if (promises.length) {
                  Promise.all(promises).then(() => onReaddir(null, entries, true));
                  return;
                }
              }
              for (const e of entries) {
                if (e && (!filter2 || filter2(e))) {
                  if (!results.write(withFileTypes ? e : e.fullpath())) {
                    paused = true;
                  }
                }
              }
              processing--;
              for (const e of entries) {
                const r = e.realpathCached() || e;
                if (r.shouldWalk(dirs, walkFilter)) {
                  queue.push(r);
                }
              }
              if (paused && !results.flowing) {
                results.once("drain", process2);
              } else if (!sync) {
                process2();
              }
            };
            let sync = true;
            dir.readdirCB(onReaddir, true);
            sync = false;
          }
        };
        process2();
        return results;
      }
      streamSync(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter: filter2, walkFilter } = opts;
        const results = new minipass_1.Minipass({ objectMode: true });
        const dirs = /* @__PURE__ */ new Set();
        if (!filter2 || filter2(entry)) {
          results.write(withFileTypes ? entry : entry.fullpath());
        }
        const queue = [entry];
        let processing = 0;
        const process2 = () => {
          let paused = false;
          while (!paused) {
            const dir = queue.shift();
            if (!dir) {
              if (processing === 0)
                results.end();
              return;
            }
            processing++;
            dirs.add(dir);
            const entries = dir.readdirSync();
            for (const e of entries) {
              if (!filter2 || filter2(e)) {
                if (!results.write(withFileTypes ? e : e.fullpath())) {
                  paused = true;
                }
              }
            }
            processing--;
            for (const e of entries) {
              let r = e;
              if (e.isSymbolicLink()) {
                if (!(follow && (r = e.realpathSync())))
                  continue;
                if (r.isUnknown())
                  r.lstatSync();
              }
              if (r.shouldWalk(dirs, walkFilter)) {
                queue.push(r);
              }
            }
          }
          if (paused && !results.flowing)
            results.once("drain", process2);
        };
        process2();
        return results;
      }
      chdir(path2 = this.cwd) {
        const oldCwd = this.cwd;
        this.cwd = typeof path2 === "string" ? this.cwd.resolve(path2) : path2;
        this.cwd[setAsCwd](oldCwd);
      }
    };
    exports2.PathScurryBase = PathScurryBase;
    var PathScurryWin32 = class extends PathScurryBase {
      /**
       * separator for generating path strings
       */
      sep = "\\";
      constructor(cwd2 = process.cwd(), opts = {}) {
        const { nocase = true } = opts;
        super(cwd2, node_path_1.win32, "\\", { ...opts, nocase });
        this.nocase = nocase;
        for (let p = this.cwd; p; p = p.parent) {
          p.nocase = this.nocase;
        }
      }
      /**
       * @internal
       */
      parseRootPath(dir) {
        return node_path_1.win32.parse(dir).root.toUpperCase();
      }
      /**
       * @internal
       */
      newRoot(fs2) {
        return new PathWin32(this.rootPath, IFDIR, void 0, this.roots, this.nocase, this.childrenCache(), { fs: fs2 });
      }
      /**
       * Return true if the provided path string is an absolute path
       */
      isAbsolute(p) {
        return p.startsWith("/") || p.startsWith("\\") || /^[a-z]:(\/|\\)/i.test(p);
      }
    };
    exports2.PathScurryWin32 = PathScurryWin32;
    var PathScurryPosix = class extends PathScurryBase {
      /**
       * separator for generating path strings
       */
      sep = "/";
      constructor(cwd2 = process.cwd(), opts = {}) {
        const { nocase = false } = opts;
        super(cwd2, node_path_1.posix, "/", { ...opts, nocase });
        this.nocase = nocase;
      }
      /**
       * @internal
       */
      parseRootPath(_dir) {
        return "/";
      }
      /**
       * @internal
       */
      newRoot(fs2) {
        return new PathPosix(this.rootPath, IFDIR, void 0, this.roots, this.nocase, this.childrenCache(), { fs: fs2 });
      }
      /**
       * Return true if the provided path string is an absolute path
       */
      isAbsolute(p) {
        return p.startsWith("/");
      }
    };
    exports2.PathScurryPosix = PathScurryPosix;
    var PathScurryDarwin = class extends PathScurryPosix {
      constructor(cwd2 = process.cwd(), opts = {}) {
        const { nocase = true } = opts;
        super(cwd2, { ...opts, nocase });
      }
    };
    exports2.PathScurryDarwin = PathScurryDarwin;
    exports2.Path = process.platform === "win32" ? PathWin32 : PathPosix;
    exports2.PathScurry = process.platform === "win32" ? PathScurryWin32 : process.platform === "darwin" ? PathScurryDarwin : PathScurryPosix;
  }
});

// node_modules/glob/dist/commonjs/pattern.js
var require_pattern = __commonJS({
  "node_modules/glob/dist/commonjs/pattern.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Pattern = void 0;
    var minimatch_1 = require_commonjs();
    var isPatternList = (pl) => pl.length >= 1;
    var isGlobList = (gl) => gl.length >= 1;
    var Pattern = class _Pattern {
      #patternList;
      #globList;
      #index;
      length;
      #platform;
      #rest;
      #globString;
      #isDrive;
      #isUNC;
      #isAbsolute;
      #followGlobstar = true;
      constructor(patternList, globList, index, platform2) {
        if (!isPatternList(patternList)) {
          throw new TypeError("empty pattern list");
        }
        if (!isGlobList(globList)) {
          throw new TypeError("empty glob list");
        }
        if (globList.length !== patternList.length) {
          throw new TypeError("mismatched pattern list and glob list lengths");
        }
        this.length = patternList.length;
        if (index < 0 || index >= this.length) {
          throw new TypeError("index out of range");
        }
        this.#patternList = patternList;
        this.#globList = globList;
        this.#index = index;
        this.#platform = platform2;
        if (this.#index === 0) {
          if (this.isUNC()) {
            const [p0, p1, p2, p3, ...prest] = this.#patternList;
            const [g0, g1, g2, g3, ...grest] = this.#globList;
            if (prest[0] === "") {
              prest.shift();
              grest.shift();
            }
            const p = [p0, p1, p2, p3, ""].join("/");
            const g = [g0, g1, g2, g3, ""].join("/");
            this.#patternList = [p, ...prest];
            this.#globList = [g, ...grest];
            this.length = this.#patternList.length;
          } else if (this.isDrive() || this.isAbsolute()) {
            const [p1, ...prest] = this.#patternList;
            const [g1, ...grest] = this.#globList;
            if (prest[0] === "") {
              prest.shift();
              grest.shift();
            }
            const p = p1 + "/";
            const g = g1 + "/";
            this.#patternList = [p, ...prest];
            this.#globList = [g, ...grest];
            this.length = this.#patternList.length;
          }
        }
      }
      /**
       * The first entry in the parsed list of patterns
       */
      pattern() {
        return this.#patternList[this.#index];
      }
      /**
       * true of if pattern() returns a string
       */
      isString() {
        return typeof this.#patternList[this.#index] === "string";
      }
      /**
       * true of if pattern() returns GLOBSTAR
       */
      isGlobstar() {
        return this.#patternList[this.#index] === minimatch_1.GLOBSTAR;
      }
      /**
       * true if pattern() returns a regexp
       */
      isRegExp() {
        return this.#patternList[this.#index] instanceof RegExp;
      }
      /**
       * The /-joined set of glob parts that make up this pattern
       */
      globString() {
        return this.#globString = this.#globString || (this.#index === 0 ? this.isAbsolute() ? this.#globList[0] + this.#globList.slice(1).join("/") : this.#globList.join("/") : this.#globList.slice(this.#index).join("/"));
      }
      /**
       * true if there are more pattern parts after this one
       */
      hasMore() {
        return this.length > this.#index + 1;
      }
      /**
       * The rest of the pattern after this part, or null if this is the end
       */
      rest() {
        if (this.#rest !== void 0)
          return this.#rest;
        if (!this.hasMore())
          return this.#rest = null;
        this.#rest = new _Pattern(this.#patternList, this.#globList, this.#index + 1, this.#platform);
        this.#rest.#isAbsolute = this.#isAbsolute;
        this.#rest.#isUNC = this.#isUNC;
        this.#rest.#isDrive = this.#isDrive;
        return this.#rest;
      }
      /**
       * true if the pattern represents a //unc/path/ on windows
       */
      isUNC() {
        const pl = this.#patternList;
        return this.#isUNC !== void 0 ? this.#isUNC : this.#isUNC = this.#platform === "win32" && this.#index === 0 && pl[0] === "" && pl[1] === "" && typeof pl[2] === "string" && !!pl[2] && typeof pl[3] === "string" && !!pl[3];
      }
      // pattern like C:/...
      // split = ['C:', ...]
      // XXX: would be nice to handle patterns like `c:*` to test the cwd
      // in c: for *, but I don't know of a way to even figure out what that
      // cwd is without actually chdir'ing into it?
      /**
       * True if the pattern starts with a drive letter on Windows
       */
      isDrive() {
        const pl = this.#patternList;
        return this.#isDrive !== void 0 ? this.#isDrive : this.#isDrive = this.#platform === "win32" && this.#index === 0 && this.length > 1 && typeof pl[0] === "string" && /^[a-z]:$/i.test(pl[0]);
      }
      // pattern = '/' or '/...' or '/x/...'
      // split = ['', ''] or ['', ...] or ['', 'x', ...]
      // Drive and UNC both considered absolute on windows
      /**
       * True if the pattern is rooted on an absolute path
       */
      isAbsolute() {
        const pl = this.#patternList;
        return this.#isAbsolute !== void 0 ? this.#isAbsolute : this.#isAbsolute = pl[0] === "" && pl.length > 1 || this.isDrive() || this.isUNC();
      }
      /**
       * consume the root of the pattern, and return it
       */
      root() {
        const p = this.#patternList[0];
        return typeof p === "string" && this.isAbsolute() && this.#index === 0 ? p : "";
      }
      /**
       * Check to see if the current globstar pattern is allowed to follow
       * a symbolic link.
       */
      checkFollowGlobstar() {
        return !(this.#index === 0 || !this.isGlobstar() || !this.#followGlobstar);
      }
      /**
       * Mark that the current globstar pattern is following a symbolic link
       */
      markFollowGlobstar() {
        if (this.#index === 0 || !this.isGlobstar() || !this.#followGlobstar)
          return false;
        this.#followGlobstar = false;
        return true;
      }
    };
    exports2.Pattern = Pattern;
  }
});

// node_modules/glob/node_modules/minipass/dist/commonjs/index.js
var require_commonjs5 = __commonJS({
  "node_modules/glob/node_modules/minipass/dist/commonjs/index.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Minipass = exports2.isWritable = exports2.isReadable = exports2.isStream = void 0;
    var proc = typeof process === "object" && process ? process : {
      stdout: null,
      stderr: null
    };
    var node_events_1 = require("node:events");
    var node_stream_1 = __importDefault(require("node:stream"));
    var node_string_decoder_1 = require("node:string_decoder");
    var isStream = (s) => !!s && typeof s === "object" && (s instanceof Minipass || s instanceof node_stream_1.default || (0, exports2.isReadable)(s) || (0, exports2.isWritable)(s));
    exports2.isStream = isStream;
    var isReadable = (s) => !!s && typeof s === "object" && s instanceof node_events_1.EventEmitter && typeof s.pipe === "function" && // node core Writable streams have a pipe() method, but it throws
    s.pipe !== node_stream_1.default.Writable.prototype.pipe;
    exports2.isReadable = isReadable;
    var isWritable = (s) => !!s && typeof s === "object" && s instanceof node_events_1.EventEmitter && typeof s.write === "function" && typeof s.end === "function";
    exports2.isWritable = isWritable;
    var EOF = Symbol("EOF");
    var MAYBE_EMIT_END = Symbol("maybeEmitEnd");
    var EMITTED_END = Symbol("emittedEnd");
    var EMITTING_END = Symbol("emittingEnd");
    var EMITTED_ERROR = Symbol("emittedError");
    var CLOSED = Symbol("closed");
    var READ = Symbol("read");
    var FLUSH = Symbol("flush");
    var FLUSHCHUNK = Symbol("flushChunk");
    var ENCODING = Symbol("encoding");
    var DECODER = Symbol("decoder");
    var FLOWING = Symbol("flowing");
    var PAUSED = Symbol("paused");
    var RESUME = Symbol("resume");
    var BUFFER = Symbol("buffer");
    var PIPES = Symbol("pipes");
    var BUFFERLENGTH = Symbol("bufferLength");
    var BUFFERPUSH = Symbol("bufferPush");
    var BUFFERSHIFT = Symbol("bufferShift");
    var OBJECTMODE = Symbol("objectMode");
    var DESTROYED = Symbol("destroyed");
    var ERROR = Symbol("error");
    var EMITDATA = Symbol("emitData");
    var EMITEND = Symbol("emitEnd");
    var EMITEND2 = Symbol("emitEnd2");
    var ASYNC = Symbol("async");
    var ABORT = Symbol("abort");
    var ABORTED = Symbol("aborted");
    var SIGNAL = Symbol("signal");
    var DATALISTENERS = Symbol("dataListeners");
    var DISCARDED = Symbol("discarded");
    var defer = (fn) => Promise.resolve().then(fn);
    var nodefer = (fn) => fn();
    var isEndish = (ev) => ev === "end" || ev === "finish" || ev === "prefinish";
    var isArrayBufferLike = (b) => b instanceof ArrayBuffer || !!b && typeof b === "object" && b.constructor && b.constructor.name === "ArrayBuffer" && b.byteLength >= 0;
    var isArrayBufferView = (b) => !Buffer.isBuffer(b) && ArrayBuffer.isView(b);
    var Pipe = class {
      src;
      dest;
      opts;
      ondrain;
      constructor(src, dest, opts) {
        this.src = src;
        this.dest = dest;
        this.opts = opts;
        this.ondrain = () => src[RESUME]();
        this.dest.on("drain", this.ondrain);
      }
      unpipe() {
        this.dest.removeListener("drain", this.ondrain);
      }
      // only here for the prototype
      /* c8 ignore start */
      proxyErrors(_er) {
      }
      /* c8 ignore stop */
      end() {
        this.unpipe();
        if (this.opts.end)
          this.dest.end();
      }
    };
    var PipeProxyErrors = class extends Pipe {
      unpipe() {
        this.src.removeListener("error", this.proxyErrors);
        super.unpipe();
      }
      constructor(src, dest, opts) {
        super(src, dest, opts);
        this.proxyErrors = (er) => dest.emit("error", er);
        src.on("error", this.proxyErrors);
      }
    };
    var isObjectModeOptions = (o) => !!o.objectMode;
    var isEncodingOptions = (o) => !o.objectMode && !!o.encoding && o.encoding !== "buffer";
    var Minipass = class extends node_events_1.EventEmitter {
      [FLOWING] = false;
      [PAUSED] = false;
      [PIPES] = [];
      [BUFFER] = [];
      [OBJECTMODE];
      [ENCODING];
      [ASYNC];
      [DECODER];
      [EOF] = false;
      [EMITTED_END] = false;
      [EMITTING_END] = false;
      [CLOSED] = false;
      [EMITTED_ERROR] = null;
      [BUFFERLENGTH] = 0;
      [DESTROYED] = false;
      [SIGNAL];
      [ABORTED] = false;
      [DATALISTENERS] = 0;
      [DISCARDED] = false;
      /**
       * true if the stream can be written
       */
      writable = true;
      /**
       * true if the stream can be read
       */
      readable = true;
      /**
       * If `RType` is Buffer, then options do not need to be provided.
       * Otherwise, an options object must be provided to specify either
       * {@link Minipass.SharedOptions.objectMode} or
       * {@link Minipass.SharedOptions.encoding}, as appropriate.
       */
      constructor(...args) {
        const options2 = args[0] || {};
        super();
        if (options2.objectMode && typeof options2.encoding === "string") {
          throw new TypeError("Encoding and objectMode may not be used together");
        }
        if (isObjectModeOptions(options2)) {
          this[OBJECTMODE] = true;
          this[ENCODING] = null;
        } else if (isEncodingOptions(options2)) {
          this[ENCODING] = options2.encoding;
          this[OBJECTMODE] = false;
        } else {
          this[OBJECTMODE] = false;
          this[ENCODING] = null;
        }
        this[ASYNC] = !!options2.async;
        this[DECODER] = this[ENCODING] ? new node_string_decoder_1.StringDecoder(this[ENCODING]) : null;
        if (options2 && options2.debugExposeBuffer === true) {
          Object.defineProperty(this, "buffer", { get: () => this[BUFFER] });
        }
        if (options2 && options2.debugExposePipes === true) {
          Object.defineProperty(this, "pipes", { get: () => this[PIPES] });
        }
        const { signal } = options2;
        if (signal) {
          this[SIGNAL] = signal;
          if (signal.aborted) {
            this[ABORT]();
          } else {
            signal.addEventListener("abort", () => this[ABORT]());
          }
        }
      }
      /**
       * The amount of data stored in the buffer waiting to be read.
       *
       * For Buffer strings, this will be the total byte length.
       * For string encoding streams, this will be the string character length,
       * according to JavaScript's `string.length` logic.
       * For objectMode streams, this is a count of the items waiting to be
       * emitted.
       */
      get bufferLength() {
        return this[BUFFERLENGTH];
      }
      /**
       * The `BufferEncoding` currently in use, or `null`
       */
      get encoding() {
        return this[ENCODING];
      }
      /**
       * @deprecated - This is a read only property
       */
      set encoding(_enc) {
        throw new Error("Encoding must be set at instantiation time");
      }
      /**
       * @deprecated - Encoding may only be set at instantiation time
       */
      setEncoding(_enc) {
        throw new Error("Encoding must be set at instantiation time");
      }
      /**
       * True if this is an objectMode stream
       */
      get objectMode() {
        return this[OBJECTMODE];
      }
      /**
       * @deprecated - This is a read-only property
       */
      set objectMode(_om) {
        throw new Error("objectMode must be set at instantiation time");
      }
      /**
       * true if this is an async stream
       */
      get ["async"]() {
        return this[ASYNC];
      }
      /**
       * Set to true to make this stream async.
       *
       * Once set, it cannot be unset, as this would potentially cause incorrect
       * behavior.  Ie, a sync stream can be made async, but an async stream
       * cannot be safely made sync.
       */
      set ["async"](a) {
        this[ASYNC] = this[ASYNC] || !!a;
      }
      // drop everything and get out of the flow completely
      [ABORT]() {
        this[ABORTED] = true;
        this.emit("abort", this[SIGNAL]?.reason);
        this.destroy(this[SIGNAL]?.reason);
      }
      /**
       * True if the stream has been aborted.
       */
      get aborted() {
        return this[ABORTED];
      }
      /**
       * No-op setter. Stream aborted status is set via the AbortSignal provided
       * in the constructor options.
       */
      set aborted(_) {
      }
      write(chunk, encoding2, cb) {
        if (this[ABORTED])
          return false;
        if (this[EOF])
          throw new Error("write after end");
        if (this[DESTROYED]) {
          this.emit("error", Object.assign(new Error("Cannot call write after a stream was destroyed"), { code: "ERR_STREAM_DESTROYED" }));
          return true;
        }
        if (typeof encoding2 === "function") {
          cb = encoding2;
          encoding2 = "utf8";
        }
        if (!encoding2)
          encoding2 = "utf8";
        const fn = this[ASYNC] ? defer : nodefer;
        if (!this[OBJECTMODE] && !Buffer.isBuffer(chunk)) {
          if (isArrayBufferView(chunk)) {
            chunk = Buffer.from(chunk.buffer, chunk.byteOffset, chunk.byteLength);
          } else if (isArrayBufferLike(chunk)) {
            chunk = Buffer.from(chunk);
          } else if (typeof chunk !== "string") {
            throw new Error("Non-contiguous data written to non-objectMode stream");
          }
        }
        if (this[OBJECTMODE]) {
          if (this[FLOWING] && this[BUFFERLENGTH] !== 0)
            this[FLUSH](true);
          if (this[FLOWING])
            this.emit("data", chunk);
          else
            this[BUFFERPUSH](chunk);
          if (this[BUFFERLENGTH] !== 0)
            this.emit("readable");
          if (cb)
            fn(cb);
          return this[FLOWING];
        }
        if (!chunk.length) {
          if (this[BUFFERLENGTH] !== 0)
            this.emit("readable");
          if (cb)
            fn(cb);
          return this[FLOWING];
        }
        if (typeof chunk === "string" && // unless it is a string already ready for us to use
        !(encoding2 === this[ENCODING] && !this[DECODER]?.lastNeed)) {
          chunk = Buffer.from(chunk, encoding2);
        }
        if (Buffer.isBuffer(chunk) && this[ENCODING]) {
          chunk = this[DECODER].write(chunk);
        }
        if (this[FLOWING] && this[BUFFERLENGTH] !== 0)
          this[FLUSH](true);
        if (this[FLOWING])
          this.emit("data", chunk);
        else
          this[BUFFERPUSH](chunk);
        if (this[BUFFERLENGTH] !== 0)
          this.emit("readable");
        if (cb)
          fn(cb);
        return this[FLOWING];
      }
      /**
       * Low-level explicit read method.
       *
       * In objectMode, the argument is ignored, and one item is returned if
       * available.
       *
       * `n` is the number of bytes (or in the case of encoding streams,
       * characters) to consume. If `n` is not provided, then the entire buffer
       * is returned, or `null` is returned if no data is available.
       *
       * If `n` is greater that the amount of data in the internal buffer,
       * then `null` is returned.
       */
      read(n) {
        if (this[DESTROYED])
          return null;
        this[DISCARDED] = false;
        if (this[BUFFERLENGTH] === 0 || n === 0 || n && n > this[BUFFERLENGTH]) {
          this[MAYBE_EMIT_END]();
          return null;
        }
        if (this[OBJECTMODE])
          n = null;
        if (this[BUFFER].length > 1 && !this[OBJECTMODE]) {
          this[BUFFER] = [
            this[ENCODING] ? this[BUFFER].join("") : Buffer.concat(this[BUFFER], this[BUFFERLENGTH])
          ];
        }
        const ret = this[READ](n || null, this[BUFFER][0]);
        this[MAYBE_EMIT_END]();
        return ret;
      }
      [READ](n, chunk) {
        if (this[OBJECTMODE])
          this[BUFFERSHIFT]();
        else {
          const c = chunk;
          if (n === c.length || n === null)
            this[BUFFERSHIFT]();
          else if (typeof c === "string") {
            this[BUFFER][0] = c.slice(n);
            chunk = c.slice(0, n);
            this[BUFFERLENGTH] -= n;
          } else {
            this[BUFFER][0] = c.subarray(n);
            chunk = c.subarray(0, n);
            this[BUFFERLENGTH] -= n;
          }
        }
        this.emit("data", chunk);
        if (!this[BUFFER].length && !this[EOF])
          this.emit("drain");
        return chunk;
      }
      end(chunk, encoding2, cb) {
        if (typeof chunk === "function") {
          cb = chunk;
          chunk = void 0;
        }
        if (typeof encoding2 === "function") {
          cb = encoding2;
          encoding2 = "utf8";
        }
        if (chunk !== void 0)
          this.write(chunk, encoding2);
        if (cb)
          this.once("end", cb);
        this[EOF] = true;
        this.writable = false;
        if (this[FLOWING] || !this[PAUSED])
          this[MAYBE_EMIT_END]();
        return this;
      }
      // don't let the internal resume be overwritten
      [RESUME]() {
        if (this[DESTROYED])
          return;
        if (!this[DATALISTENERS] && !this[PIPES].length) {
          this[DISCARDED] = true;
        }
        this[PAUSED] = false;
        this[FLOWING] = true;
        this.emit("resume");
        if (this[BUFFER].length)
          this[FLUSH]();
        else if (this[EOF])
          this[MAYBE_EMIT_END]();
        else
          this.emit("drain");
      }
      /**
       * Resume the stream if it is currently in a paused state
       *
       * If called when there are no pipe destinations or `data` event listeners,
       * this will place the stream in a "discarded" state, where all data will
       * be thrown away. The discarded state is removed if a pipe destination or
       * data handler is added, if pause() is called, or if any synchronous or
       * asynchronous iteration is started.
       */
      resume() {
        return this[RESUME]();
      }
      /**
       * Pause the stream
       */
      pause() {
        this[FLOWING] = false;
        this[PAUSED] = true;
        this[DISCARDED] = false;
      }
      /**
       * true if the stream has been forcibly destroyed
       */
      get destroyed() {
        return this[DESTROYED];
      }
      /**
       * true if the stream is currently in a flowing state, meaning that
       * any writes will be immediately emitted.
       */
      get flowing() {
        return this[FLOWING];
      }
      /**
       * true if the stream is currently in a paused state
       */
      get paused() {
        return this[PAUSED];
      }
      [BUFFERPUSH](chunk) {
        if (this[OBJECTMODE])
          this[BUFFERLENGTH] += 1;
        else
          this[BUFFERLENGTH] += chunk.length;
        this[BUFFER].push(chunk);
      }
      [BUFFERSHIFT]() {
        if (this[OBJECTMODE])
          this[BUFFERLENGTH] -= 1;
        else
          this[BUFFERLENGTH] -= this[BUFFER][0].length;
        return this[BUFFER].shift();
      }
      [FLUSH](noDrain = false) {
        do {
        } while (this[FLUSHCHUNK](this[BUFFERSHIFT]()) && this[BUFFER].length);
        if (!noDrain && !this[BUFFER].length && !this[EOF])
          this.emit("drain");
      }
      [FLUSHCHUNK](chunk) {
        this.emit("data", chunk);
        return this[FLOWING];
      }
      /**
       * Pipe all data emitted by this stream into the destination provided.
       *
       * Triggers the flow of data.
       */
      pipe(dest, opts) {
        if (this[DESTROYED])
          return dest;
        this[DISCARDED] = false;
        const ended = this[EMITTED_END];
        opts = opts || {};
        if (dest === proc.stdout || dest === proc.stderr)
          opts.end = false;
        else
          opts.end = opts.end !== false;
        opts.proxyErrors = !!opts.proxyErrors;
        if (ended) {
          if (opts.end)
            dest.end();
        } else {
          this[PIPES].push(!opts.proxyErrors ? new Pipe(this, dest, opts) : new PipeProxyErrors(this, dest, opts));
          if (this[ASYNC])
            defer(() => this[RESUME]());
          else
            this[RESUME]();
        }
        return dest;
      }
      /**
       * Fully unhook a piped destination stream.
       *
       * If the destination stream was the only consumer of this stream (ie,
       * there are no other piped destinations or `'data'` event listeners)
       * then the flow of data will stop until there is another consumer or
       * {@link Minipass#resume} is explicitly called.
       */
      unpipe(dest) {
        const p = this[PIPES].find((p2) => p2.dest === dest);
        if (p) {
          if (this[PIPES].length === 1) {
            if (this[FLOWING] && this[DATALISTENERS] === 0) {
              this[FLOWING] = false;
            }
            this[PIPES] = [];
          } else
            this[PIPES].splice(this[PIPES].indexOf(p), 1);
          p.unpipe();
        }
      }
      /**
       * Alias for {@link Minipass#on}
       */
      addListener(ev, handler) {
        return this.on(ev, handler);
      }
      /**
       * Mostly identical to `EventEmitter.on`, with the following
       * behavior differences to prevent data loss and unnecessary hangs:
       *
       * - Adding a 'data' event handler will trigger the flow of data
       *
       * - Adding a 'readable' event handler when there is data waiting to be read
       *   will cause 'readable' to be emitted immediately.
       *
       * - Adding an 'endish' event handler ('end', 'finish', etc.) which has
       *   already passed will cause the event to be emitted immediately and all
       *   handlers removed.
       *
       * - Adding an 'error' event handler after an error has been emitted will
       *   cause the event to be re-emitted immediately with the error previously
       *   raised.
       */
      on(ev, handler) {
        const ret = super.on(ev, handler);
        if (ev === "data") {
          this[DISCARDED] = false;
          this[DATALISTENERS]++;
          if (!this[PIPES].length && !this[FLOWING]) {
            this[RESUME]();
          }
        } else if (ev === "readable" && this[BUFFERLENGTH] !== 0) {
          super.emit("readable");
        } else if (isEndish(ev) && this[EMITTED_END]) {
          super.emit(ev);
          this.removeAllListeners(ev);
        } else if (ev === "error" && this[EMITTED_ERROR]) {
          const h = handler;
          if (this[ASYNC])
            defer(() => h.call(this, this[EMITTED_ERROR]));
          else
            h.call(this, this[EMITTED_ERROR]);
        }
        return ret;
      }
      /**
       * Alias for {@link Minipass#off}
       */
      removeListener(ev, handler) {
        return this.off(ev, handler);
      }
      /**
       * Mostly identical to `EventEmitter.off`
       *
       * If a 'data' event handler is removed, and it was the last consumer
       * (ie, there are no pipe destinations or other 'data' event listeners),
       * then the flow of data will stop until there is another consumer or
       * {@link Minipass#resume} is explicitly called.
       */
      off(ev, handler) {
        const ret = super.off(ev, handler);
        if (ev === "data") {
          this[DATALISTENERS] = this.listeners("data").length;
          if (this[DATALISTENERS] === 0 && !this[DISCARDED] && !this[PIPES].length) {
            this[FLOWING] = false;
          }
        }
        return ret;
      }
      /**
       * Mostly identical to `EventEmitter.removeAllListeners`
       *
       * If all 'data' event handlers are removed, and they were the last consumer
       * (ie, there are no pipe destinations), then the flow of data will stop
       * until there is another consumer or {@link Minipass#resume} is explicitly
       * called.
       */
      removeAllListeners(ev) {
        const ret = super.removeAllListeners(ev);
        if (ev === "data" || ev === void 0) {
          this[DATALISTENERS] = 0;
          if (!this[DISCARDED] && !this[PIPES].length) {
            this[FLOWING] = false;
          }
        }
        return ret;
      }
      /**
       * true if the 'end' event has been emitted
       */
      get emittedEnd() {
        return this[EMITTED_END];
      }
      [MAYBE_EMIT_END]() {
        if (!this[EMITTING_END] && !this[EMITTED_END] && !this[DESTROYED] && this[BUFFER].length === 0 && this[EOF]) {
          this[EMITTING_END] = true;
          this.emit("end");
          this.emit("prefinish");
          this.emit("finish");
          if (this[CLOSED])
            this.emit("close");
          this[EMITTING_END] = false;
        }
      }
      /**
       * Mostly identical to `EventEmitter.emit`, with the following
       * behavior differences to prevent data loss and unnecessary hangs:
       *
       * If the stream has been destroyed, and the event is something other
       * than 'close' or 'error', then `false` is returned and no handlers
       * are called.
       *
       * If the event is 'end', and has already been emitted, then the event
       * is ignored. If the stream is in a paused or non-flowing state, then
       * the event will be deferred until data flow resumes. If the stream is
       * async, then handlers will be called on the next tick rather than
       * immediately.
       *
       * If the event is 'close', and 'end' has not yet been emitted, then
       * the event will be deferred until after 'end' is emitted.
       *
       * If the event is 'error', and an AbortSignal was provided for the stream,
       * and there are no listeners, then the event is ignored, matching the
       * behavior of node core streams in the presense of an AbortSignal.
       *
       * If the event is 'finish' or 'prefinish', then all listeners will be
       * removed after emitting the event, to prevent double-firing.
       */
      emit(ev, ...args) {
        const data = args[0];
        if (ev !== "error" && ev !== "close" && ev !== DESTROYED && this[DESTROYED]) {
          return false;
        } else if (ev === "data") {
          return !this[OBJECTMODE] && !data ? false : this[ASYNC] ? (defer(() => this[EMITDATA](data)), true) : this[EMITDATA](data);
        } else if (ev === "end") {
          return this[EMITEND]();
        } else if (ev === "close") {
          this[CLOSED] = true;
          if (!this[EMITTED_END] && !this[DESTROYED])
            return false;
          const ret2 = super.emit("close");
          this.removeAllListeners("close");
          return ret2;
        } else if (ev === "error") {
          this[EMITTED_ERROR] = data;
          super.emit(ERROR, data);
          const ret2 = !this[SIGNAL] || this.listeners("error").length ? super.emit("error", data) : false;
          this[MAYBE_EMIT_END]();
          return ret2;
        } else if (ev === "resume") {
          const ret2 = super.emit("resume");
          this[MAYBE_EMIT_END]();
          return ret2;
        } else if (ev === "finish" || ev === "prefinish") {
          const ret2 = super.emit(ev);
          this.removeAllListeners(ev);
          return ret2;
        }
        const ret = super.emit(ev, ...args);
        this[MAYBE_EMIT_END]();
        return ret;
      }
      [EMITDATA](data) {
        for (const p of this[PIPES]) {
          if (p.dest.write(data) === false)
            this.pause();
        }
        const ret = this[DISCARDED] ? false : super.emit("data", data);
        this[MAYBE_EMIT_END]();
        return ret;
      }
      [EMITEND]() {
        if (this[EMITTED_END])
          return false;
        this[EMITTED_END] = true;
        this.readable = false;
        return this[ASYNC] ? (defer(() => this[EMITEND2]()), true) : this[EMITEND2]();
      }
      [EMITEND2]() {
        if (this[DECODER]) {
          const data = this[DECODER].end();
          if (data) {
            for (const p of this[PIPES]) {
              p.dest.write(data);
            }
            if (!this[DISCARDED])
              super.emit("data", data);
          }
        }
        for (const p of this[PIPES]) {
          p.end();
        }
        const ret = super.emit("end");
        this.removeAllListeners("end");
        return ret;
      }
      /**
       * Return a Promise that resolves to an array of all emitted data once
       * the stream ends.
       */
      async collect() {
        const buf = Object.assign([], {
          dataLength: 0
        });
        if (!this[OBJECTMODE])
          buf.dataLength = 0;
        const p = this.promise();
        this.on("data", (c) => {
          buf.push(c);
          if (!this[OBJECTMODE])
            buf.dataLength += c.length;
        });
        await p;
        return buf;
      }
      /**
       * Return a Promise that resolves to the concatenation of all emitted data
       * once the stream ends.
       *
       * Not allowed on objectMode streams.
       */
      async concat() {
        if (this[OBJECTMODE]) {
          throw new Error("cannot concat in objectMode");
        }
        const buf = await this.collect();
        return this[ENCODING] ? buf.join("") : Buffer.concat(buf, buf.dataLength);
      }
      /**
       * Return a void Promise that resolves once the stream ends.
       */
      async promise() {
        return new Promise((resolve, reject) => {
          this.on(DESTROYED, () => reject(new Error("stream destroyed")));
          this.on("error", (er) => reject(er));
          this.on("end", () => resolve());
        });
      }
      /**
       * Asynchronous `for await of` iteration.
       *
       * This will continue emitting all chunks until the stream terminates.
       */
      [Symbol.asyncIterator]() {
        this[DISCARDED] = false;
        let stopped = false;
        const stop = async () => {
          this.pause();
          stopped = true;
          return { value: void 0, done: true };
        };
        const next = () => {
          if (stopped)
            return stop();
          const res = this.read();
          if (res !== null)
            return Promise.resolve({ done: false, value: res });
          if (this[EOF])
            return stop();
          let resolve;
          let reject;
          const onerr = (er) => {
            this.off("data", ondata);
            this.off("end", onend);
            this.off(DESTROYED, ondestroy);
            stop();
            reject(er);
          };
          const ondata = (value) => {
            this.off("error", onerr);
            this.off("end", onend);
            this.off(DESTROYED, ondestroy);
            this.pause();
            resolve({ value, done: !!this[EOF] });
          };
          const onend = () => {
            this.off("error", onerr);
            this.off("data", ondata);
            this.off(DESTROYED, ondestroy);
            stop();
            resolve({ done: true, value: void 0 });
          };
          const ondestroy = () => onerr(new Error("stream destroyed"));
          return new Promise((res2, rej) => {
            reject = rej;
            resolve = res2;
            this.once(DESTROYED, ondestroy);
            this.once("error", onerr);
            this.once("end", onend);
            this.once("data", ondata);
          });
        };
        return {
          next,
          throw: stop,
          return: stop,
          [Symbol.asyncIterator]() {
            return this;
          }
        };
      }
      /**
       * Synchronous `for of` iteration.
       *
       * The iteration will terminate when the internal buffer runs out, even
       * if the stream has not yet terminated.
       */
      [Symbol.iterator]() {
        this[DISCARDED] = false;
        let stopped = false;
        const stop = () => {
          this.pause();
          this.off(ERROR, stop);
          this.off(DESTROYED, stop);
          this.off("end", stop);
          stopped = true;
          return { done: true, value: void 0 };
        };
        const next = () => {
          if (stopped)
            return stop();
          const value = this.read();
          return value === null ? stop() : { done: false, value };
        };
        this.once("end", stop);
        this.once(ERROR, stop);
        this.once(DESTROYED, stop);
        return {
          next,
          throw: stop,
          return: stop,
          [Symbol.iterator]() {
            return this;
          }
        };
      }
      /**
       * Destroy a stream, preventing it from being used for any further purpose.
       *
       * If the stream has a `close()` method, then it will be called on
       * destruction.
       *
       * After destruction, any attempt to write data, read data, or emit most
       * events will be ignored.
       *
       * If an error argument is provided, then it will be emitted in an
       * 'error' event.
       */
      destroy(er) {
        if (this[DESTROYED]) {
          if (er)
            this.emit("error", er);
          else
            this.emit(DESTROYED);
          return this;
        }
        this[DESTROYED] = true;
        this[DISCARDED] = true;
        this[BUFFER].length = 0;
        this[BUFFERLENGTH] = 0;
        const wc = this;
        if (typeof wc.close === "function" && !this[CLOSED])
          wc.close();
        if (er)
          this.emit("error", er);
        else
          this.emit(DESTROYED);
        return this;
      }
      /**
       * Alias for {@link isStream}
       *
       * Former export location, maintained for backwards compatibility.
       *
       * @deprecated
       */
      static get isStream() {
        return exports2.isStream;
      }
    };
    exports2.Minipass = Minipass;
  }
});

// node_modules/glob/dist/commonjs/ignore.js
var require_ignore = __commonJS({
  "node_modules/glob/dist/commonjs/ignore.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Ignore = void 0;
    var minimatch_1 = require_commonjs();
    var pattern_js_1 = require_pattern();
    var defaultPlatform = typeof process === "object" && process && typeof process.platform === "string" ? process.platform : "linux";
    var Ignore = class {
      relative;
      relativeChildren;
      absolute;
      absoluteChildren;
      platform;
      mmopts;
      constructor(ignored, { nobrace, nocase, noext, noglobstar, platform: platform2 = defaultPlatform }) {
        this.relative = [];
        this.absolute = [];
        this.relativeChildren = [];
        this.absoluteChildren = [];
        this.platform = platform2;
        this.mmopts = {
          dot: true,
          nobrace,
          nocase,
          noext,
          noglobstar,
          optimizationLevel: 2,
          platform: platform2,
          nocomment: true,
          nonegate: true
        };
        for (const ign of ignored)
          this.add(ign);
      }
      add(ign) {
        const mm = new minimatch_1.Minimatch(ign, this.mmopts);
        for (let i = 0; i < mm.set.length; i++) {
          const parsed = mm.set[i];
          const globParts = mm.globParts[i];
          if (!parsed || !globParts) {
            throw new Error("invalid pattern object");
          }
          while (parsed[0] === "." && globParts[0] === ".") {
            parsed.shift();
            globParts.shift();
          }
          const p = new pattern_js_1.Pattern(parsed, globParts, 0, this.platform);
          const m = new minimatch_1.Minimatch(p.globString(), this.mmopts);
          const children = globParts[globParts.length - 1] === "**";
          const absolute = p.isAbsolute();
          if (absolute)
            this.absolute.push(m);
          else
            this.relative.push(m);
          if (children) {
            if (absolute)
              this.absoluteChildren.push(m);
            else
              this.relativeChildren.push(m);
          }
        }
      }
      ignored(p) {
        const fullpath = p.fullpath();
        const fullpaths = `${fullpath}/`;
        const relative = p.relative() || ".";
        const relatives = `${relative}/`;
        for (const m of this.relative) {
          if (m.match(relative) || m.match(relatives))
            return true;
        }
        for (const m of this.absolute) {
          if (m.match(fullpath) || m.match(fullpaths))
            return true;
        }
        return false;
      }
      childrenIgnored(p) {
        const fullpath = p.fullpath() + "/";
        const relative = (p.relative() || ".") + "/";
        for (const m of this.relativeChildren) {
          if (m.match(relative))
            return true;
        }
        for (const m of this.absoluteChildren) {
          if (m.match(fullpath))
            return true;
        }
        return false;
      }
    };
    exports2.Ignore = Ignore;
  }
});

// node_modules/glob/dist/commonjs/processor.js
var require_processor = __commonJS({
  "node_modules/glob/dist/commonjs/processor.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Processor = exports2.SubWalks = exports2.MatchRecord = exports2.HasWalkedCache = void 0;
    var minimatch_1 = require_commonjs();
    var HasWalkedCache = class _HasWalkedCache {
      store;
      constructor(store = /* @__PURE__ */ new Map()) {
        this.store = store;
      }
      copy() {
        return new _HasWalkedCache(new Map(this.store));
      }
      hasWalked(target, pattern) {
        return this.store.get(target.fullpath())?.has(pattern.globString());
      }
      storeWalked(target, pattern) {
        const fullpath = target.fullpath();
        const cached = this.store.get(fullpath);
        if (cached)
          cached.add(pattern.globString());
        else
          this.store.set(fullpath, /* @__PURE__ */ new Set([pattern.globString()]));
      }
    };
    exports2.HasWalkedCache = HasWalkedCache;
    var MatchRecord = class {
      store = /* @__PURE__ */ new Map();
      add(target, absolute, ifDir) {
        const n = (absolute ? 2 : 0) | (ifDir ? 1 : 0);
        const current = this.store.get(target);
        this.store.set(target, current === void 0 ? n : n & current);
      }
      // match, absolute, ifdir
      entries() {
        return [...this.store.entries()].map(([path2, n]) => [
          path2,
          !!(n & 2),
          !!(n & 1)
        ]);
      }
    };
    exports2.MatchRecord = MatchRecord;
    var SubWalks = class {
      store = /* @__PURE__ */ new Map();
      add(target, pattern) {
        if (!target.canReaddir()) {
          return;
        }
        const subs = this.store.get(target);
        if (subs) {
          if (!subs.find((p) => p.globString() === pattern.globString())) {
            subs.push(pattern);
          }
        } else
          this.store.set(target, [pattern]);
      }
      get(target) {
        const subs = this.store.get(target);
        if (!subs) {
          throw new Error("attempting to walk unknown path");
        }
        return subs;
      }
      entries() {
        return this.keys().map((k) => [k, this.store.get(k)]);
      }
      keys() {
        return [...this.store.keys()].filter((t) => t.canReaddir());
      }
    };
    exports2.SubWalks = SubWalks;
    var Processor = class _Processor {
      hasWalkedCache;
      matches = new MatchRecord();
      subwalks = new SubWalks();
      patterns;
      follow;
      dot;
      opts;
      constructor(opts, hasWalkedCache) {
        this.opts = opts;
        this.follow = !!opts.follow;
        this.dot = !!opts.dot;
        this.hasWalkedCache = hasWalkedCache ? hasWalkedCache.copy() : new HasWalkedCache();
      }
      processPatterns(target, patterns) {
        this.patterns = patterns;
        const processingSet = patterns.map((p) => [target, p]);
        for (let [t, pattern] of processingSet) {
          this.hasWalkedCache.storeWalked(t, pattern);
          const root = pattern.root();
          const absolute = pattern.isAbsolute() && this.opts.absolute !== false;
          if (root) {
            t = t.resolve(root === "/" && this.opts.root !== void 0 ? this.opts.root : root);
            const rest2 = pattern.rest();
            if (!rest2) {
              this.matches.add(t, true, false);
              continue;
            } else {
              pattern = rest2;
            }
          }
          if (t.isENOENT())
            continue;
          let p;
          let rest;
          let changed = false;
          while (typeof (p = pattern.pattern()) === "string" && (rest = pattern.rest())) {
            const c = t.resolve(p);
            t = c;
            pattern = rest;
            changed = true;
          }
          p = pattern.pattern();
          rest = pattern.rest();
          if (changed) {
            if (this.hasWalkedCache.hasWalked(t, pattern))
              continue;
            this.hasWalkedCache.storeWalked(t, pattern);
          }
          if (typeof p === "string") {
            const ifDir = p === ".." || p === "" || p === ".";
            this.matches.add(t.resolve(p), absolute, ifDir);
            continue;
          } else if (p === minimatch_1.GLOBSTAR) {
            if (!t.isSymbolicLink() || this.follow || pattern.checkFollowGlobstar()) {
              this.subwalks.add(t, pattern);
            }
            const rp = rest?.pattern();
            const rrest = rest?.rest();
            if (!rest || (rp === "" || rp === ".") && !rrest) {
              this.matches.add(t, absolute, rp === "" || rp === ".");
            } else {
              if (rp === "..") {
                const tp = t.parent || t;
                if (!rrest)
                  this.matches.add(tp, absolute, true);
                else if (!this.hasWalkedCache.hasWalked(tp, rrest)) {
                  this.subwalks.add(tp, rrest);
                }
              }
            }
          } else if (p instanceof RegExp) {
            this.subwalks.add(t, pattern);
          }
        }
        return this;
      }
      subwalkTargets() {
        return this.subwalks.keys();
      }
      child() {
        return new _Processor(this.opts, this.hasWalkedCache);
      }
      // return a new Processor containing the subwalks for each
      // child entry, and a set of matches, and
      // a hasWalkedCache that's a copy of this one
      // then we're going to call
      filterEntries(parent, entries) {
        const patterns = this.subwalks.get(parent);
        const results = this.child();
        for (const e of entries) {
          for (const pattern of patterns) {
            const absolute = pattern.isAbsolute();
            const p = pattern.pattern();
            const rest = pattern.rest();
            if (p === minimatch_1.GLOBSTAR) {
              results.testGlobstar(e, pattern, rest, absolute);
            } else if (p instanceof RegExp) {
              results.testRegExp(e, p, rest, absolute);
            } else {
              results.testString(e, p, rest, absolute);
            }
          }
        }
        return results;
      }
      testGlobstar(e, pattern, rest, absolute) {
        if (this.dot || !e.name.startsWith(".")) {
          if (!pattern.hasMore()) {
            this.matches.add(e, absolute, false);
          }
          if (e.canReaddir()) {
            if (this.follow || !e.isSymbolicLink()) {
              this.subwalks.add(e, pattern);
            } else if (e.isSymbolicLink()) {
              if (rest && pattern.checkFollowGlobstar()) {
                this.subwalks.add(e, rest);
              } else if (pattern.markFollowGlobstar()) {
                this.subwalks.add(e, pattern);
              }
            }
          }
        }
        if (rest) {
          const rp = rest.pattern();
          if (typeof rp === "string" && // dots and empty were handled already
          rp !== ".." && rp !== "" && rp !== ".") {
            this.testString(e, rp, rest.rest(), absolute);
          } else if (rp === "..") {
            const ep = e.parent || e;
            this.subwalks.add(ep, rest);
          } else if (rp instanceof RegExp) {
            this.testRegExp(e, rp, rest.rest(), absolute);
          }
        }
      }
      testRegExp(e, p, rest, absolute) {
        if (!p.test(e.name))
          return;
        if (!rest) {
          this.matches.add(e, absolute, false);
        } else {
          this.subwalks.add(e, rest);
        }
      }
      testString(e, p, rest, absolute) {
        if (!e.isNamed(p))
          return;
        if (!rest) {
          this.matches.add(e, absolute, false);
        } else {
          this.subwalks.add(e, rest);
        }
      }
    };
    exports2.Processor = Processor;
  }
});

// node_modules/glob/dist/commonjs/walker.js
var require_walker = __commonJS({
  "node_modules/glob/dist/commonjs/walker.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.GlobStream = exports2.GlobWalker = exports2.GlobUtil = void 0;
    var minipass_1 = require_commonjs5();
    var ignore_js_1 = require_ignore();
    var processor_js_1 = require_processor();
    var makeIgnore = (ignore, opts) => typeof ignore === "string" ? new ignore_js_1.Ignore([ignore], opts) : Array.isArray(ignore) ? new ignore_js_1.Ignore(ignore, opts) : ignore;
    var GlobUtil = class {
      path;
      patterns;
      opts;
      seen = /* @__PURE__ */ new Set();
      paused = false;
      aborted = false;
      #onResume = [];
      #ignore;
      #sep;
      signal;
      maxDepth;
      includeChildMatches;
      constructor(patterns, path2, opts) {
        this.patterns = patterns;
        this.path = path2;
        this.opts = opts;
        this.#sep = !opts.posix && opts.platform === "win32" ? "\\" : "/";
        this.includeChildMatches = opts.includeChildMatches !== false;
        if (opts.ignore || !this.includeChildMatches) {
          this.#ignore = makeIgnore(opts.ignore ?? [], opts);
          if (!this.includeChildMatches && typeof this.#ignore.add !== "function") {
            const m = "cannot ignore child matches, ignore lacks add() method.";
            throw new Error(m);
          }
        }
        this.maxDepth = opts.maxDepth || Infinity;
        if (opts.signal) {
          this.signal = opts.signal;
          this.signal.addEventListener("abort", () => {
            this.#onResume.length = 0;
          });
        }
      }
      #ignored(path2) {
        return this.seen.has(path2) || !!this.#ignore?.ignored?.(path2);
      }
      #childrenIgnored(path2) {
        return !!this.#ignore?.childrenIgnored?.(path2);
      }
      // backpressure mechanism
      pause() {
        this.paused = true;
      }
      resume() {
        if (this.signal?.aborted)
          return;
        this.paused = false;
        let fn = void 0;
        while (!this.paused && (fn = this.#onResume.shift())) {
          fn();
        }
      }
      onResume(fn) {
        if (this.signal?.aborted)
          return;
        if (!this.paused) {
          fn();
        } else {
          this.#onResume.push(fn);
        }
      }
      // do the requisite realpath/stat checking, and return the path
      // to add or undefined to filter it out.
      async matchCheck(e, ifDir) {
        if (ifDir && this.opts.nodir)
          return void 0;
        let rpc;
        if (this.opts.realpath) {
          rpc = e.realpathCached() || await e.realpath();
          if (!rpc)
            return void 0;
          e = rpc;
        }
        const needStat = e.isUnknown() || this.opts.stat;
        const s = needStat ? await e.lstat() : e;
        if (this.opts.follow && this.opts.nodir && s?.isSymbolicLink()) {
          const target = await s.realpath();
          if (target && (target.isUnknown() || this.opts.stat)) {
            await target.lstat();
          }
        }
        return this.matchCheckTest(s, ifDir);
      }
      matchCheckTest(e, ifDir) {
        return e && (this.maxDepth === Infinity || e.depth() <= this.maxDepth) && (!ifDir || e.canReaddir()) && (!this.opts.nodir || !e.isDirectory()) && (!this.opts.nodir || !this.opts.follow || !e.isSymbolicLink() || !e.realpathCached()?.isDirectory()) && !this.#ignored(e) ? e : void 0;
      }
      matchCheckSync(e, ifDir) {
        if (ifDir && this.opts.nodir)
          return void 0;
        let rpc;
        if (this.opts.realpath) {
          rpc = e.realpathCached() || e.realpathSync();
          if (!rpc)
            return void 0;
          e = rpc;
        }
        const needStat = e.isUnknown() || this.opts.stat;
        const s = needStat ? e.lstatSync() : e;
        if (this.opts.follow && this.opts.nodir && s?.isSymbolicLink()) {
          const target = s.realpathSync();
          if (target && (target?.isUnknown() || this.opts.stat)) {
            target.lstatSync();
          }
        }
        return this.matchCheckTest(s, ifDir);
      }
      matchFinish(e, absolute) {
        if (this.#ignored(e))
          return;
        if (!this.includeChildMatches && this.#ignore?.add) {
          const ign = `${e.relativePosix()}/**`;
          this.#ignore.add(ign);
        }
        const abs = this.opts.absolute === void 0 ? absolute : this.opts.absolute;
        this.seen.add(e);
        const mark = this.opts.mark && e.isDirectory() ? this.#sep : "";
        if (this.opts.withFileTypes) {
          this.matchEmit(e);
        } else if (abs) {
          const abs2 = this.opts.posix ? e.fullpathPosix() : e.fullpath();
          this.matchEmit(abs2 + mark);
        } else {
          const rel = this.opts.posix ? e.relativePosix() : e.relative();
          const pre = this.opts.dotRelative && !rel.startsWith(".." + this.#sep) ? "." + this.#sep : "";
          this.matchEmit(!rel ? "." + mark : pre + rel + mark);
        }
      }
      async match(e, absolute, ifDir) {
        const p = await this.matchCheck(e, ifDir);
        if (p)
          this.matchFinish(p, absolute);
      }
      matchSync(e, absolute, ifDir) {
        const p = this.matchCheckSync(e, ifDir);
        if (p)
          this.matchFinish(p, absolute);
      }
      walkCB(target, patterns, cb) {
        if (this.signal?.aborted)
          cb();
        this.walkCB2(target, patterns, new processor_js_1.Processor(this.opts), cb);
      }
      walkCB2(target, patterns, processor, cb) {
        if (this.#childrenIgnored(target))
          return cb();
        if (this.signal?.aborted)
          cb();
        if (this.paused) {
          this.onResume(() => this.walkCB2(target, patterns, processor, cb));
          return;
        }
        processor.processPatterns(target, patterns);
        let tasks = 1;
        const next = () => {
          if (--tasks === 0)
            cb();
        };
        for (const [m, absolute, ifDir] of processor.matches.entries()) {
          if (this.#ignored(m))
            continue;
          tasks++;
          this.match(m, absolute, ifDir).then(() => next());
        }
        for (const t of processor.subwalkTargets()) {
          if (this.maxDepth !== Infinity && t.depth() >= this.maxDepth) {
            continue;
          }
          tasks++;
          const childrenCached = t.readdirCached();
          if (t.calledReaddir())
            this.walkCB3(t, childrenCached, processor, next);
          else {
            t.readdirCB((_, entries) => this.walkCB3(t, entries, processor, next), true);
          }
        }
        next();
      }
      walkCB3(target, entries, processor, cb) {
        processor = processor.filterEntries(target, entries);
        let tasks = 1;
        const next = () => {
          if (--tasks === 0)
            cb();
        };
        for (const [m, absolute, ifDir] of processor.matches.entries()) {
          if (this.#ignored(m))
            continue;
          tasks++;
          this.match(m, absolute, ifDir).then(() => next());
        }
        for (const [target2, patterns] of processor.subwalks.entries()) {
          tasks++;
          this.walkCB2(target2, patterns, processor.child(), next);
        }
        next();
      }
      walkCBSync(target, patterns, cb) {
        if (this.signal?.aborted)
          cb();
        this.walkCB2Sync(target, patterns, new processor_js_1.Processor(this.opts), cb);
      }
      walkCB2Sync(target, patterns, processor, cb) {
        if (this.#childrenIgnored(target))
          return cb();
        if (this.signal?.aborted)
          cb();
        if (this.paused) {
          this.onResume(() => this.walkCB2Sync(target, patterns, processor, cb));
          return;
        }
        processor.processPatterns(target, patterns);
        let tasks = 1;
        const next = () => {
          if (--tasks === 0)
            cb();
        };
        for (const [m, absolute, ifDir] of processor.matches.entries()) {
          if (this.#ignored(m))
            continue;
          this.matchSync(m, absolute, ifDir);
        }
        for (const t of processor.subwalkTargets()) {
          if (this.maxDepth !== Infinity && t.depth() >= this.maxDepth) {
            continue;
          }
          tasks++;
          const children = t.readdirSync();
          this.walkCB3Sync(t, children, processor, next);
        }
        next();
      }
      walkCB3Sync(target, entries, processor, cb) {
        processor = processor.filterEntries(target, entries);
        let tasks = 1;
        const next = () => {
          if (--tasks === 0)
            cb();
        };
        for (const [m, absolute, ifDir] of processor.matches.entries()) {
          if (this.#ignored(m))
            continue;
          this.matchSync(m, absolute, ifDir);
        }
        for (const [target2, patterns] of processor.subwalks.entries()) {
          tasks++;
          this.walkCB2Sync(target2, patterns, processor.child(), next);
        }
        next();
      }
    };
    exports2.GlobUtil = GlobUtil;
    var GlobWalker = class extends GlobUtil {
      matches = /* @__PURE__ */ new Set();
      constructor(patterns, path2, opts) {
        super(patterns, path2, opts);
      }
      matchEmit(e) {
        this.matches.add(e);
      }
      async walk() {
        if (this.signal?.aborted)
          throw this.signal.reason;
        if (this.path.isUnknown()) {
          await this.path.lstat();
        }
        await new Promise((res, rej) => {
          this.walkCB(this.path, this.patterns, () => {
            if (this.signal?.aborted) {
              rej(this.signal.reason);
            } else {
              res(this.matches);
            }
          });
        });
        return this.matches;
      }
      walkSync() {
        if (this.signal?.aborted)
          throw this.signal.reason;
        if (this.path.isUnknown()) {
          this.path.lstatSync();
        }
        this.walkCBSync(this.path, this.patterns, () => {
          if (this.signal?.aborted)
            throw this.signal.reason;
        });
        return this.matches;
      }
    };
    exports2.GlobWalker = GlobWalker;
    var GlobStream = class extends GlobUtil {
      results;
      constructor(patterns, path2, opts) {
        super(patterns, path2, opts);
        this.results = new minipass_1.Minipass({
          signal: this.signal,
          objectMode: true
        });
        this.results.on("drain", () => this.resume());
        this.results.on("resume", () => this.resume());
      }
      matchEmit(e) {
        this.results.write(e);
        if (!this.results.flowing)
          this.pause();
      }
      stream() {
        const target = this.path;
        if (target.isUnknown()) {
          target.lstat().then(() => {
            this.walkCB(target, this.patterns, () => this.results.end());
          });
        } else {
          this.walkCB(target, this.patterns, () => this.results.end());
        }
        return this.results;
      }
      streamSync() {
        if (this.path.isUnknown()) {
          this.path.lstatSync();
        }
        this.walkCBSync(this.path, this.patterns, () => this.results.end());
        return this.results;
      }
    };
    exports2.GlobStream = GlobStream;
  }
});

// node_modules/glob/dist/commonjs/glob.js
var require_glob = __commonJS({
  "node_modules/glob/dist/commonjs/glob.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Glob = void 0;
    var minimatch_1 = require_commonjs();
    var node_url_1 = require("node:url");
    var path_scurry_1 = require_commonjs4();
    var pattern_js_1 = require_pattern();
    var walker_js_1 = require_walker();
    var defaultPlatform = typeof process === "object" && process && typeof process.platform === "string" ? process.platform : "linux";
    var Glob = class {
      absolute;
      cwd;
      root;
      dot;
      dotRelative;
      follow;
      ignore;
      magicalBraces;
      mark;
      matchBase;
      maxDepth;
      nobrace;
      nocase;
      nodir;
      noext;
      noglobstar;
      pattern;
      platform;
      realpath;
      scurry;
      stat;
      signal;
      windowsPathsNoEscape;
      withFileTypes;
      includeChildMatches;
      /**
       * The options provided to the constructor.
       */
      opts;
      /**
       * An array of parsed immutable {@link Pattern} objects.
       */
      patterns;
      /**
       * All options are stored as properties on the `Glob` object.
       *
       * See {@link GlobOptions} for full options descriptions.
       *
       * Note that a previous `Glob` object can be passed as the
       * `GlobOptions` to another `Glob` instantiation to re-use settings
       * and caches with a new pattern.
       *
       * Traversal functions can be called multiple times to run the walk
       * again.
       */
      constructor(pattern, opts) {
        if (!opts)
          throw new TypeError("glob options required");
        this.withFileTypes = !!opts.withFileTypes;
        this.signal = opts.signal;
        this.follow = !!opts.follow;
        this.dot = !!opts.dot;
        this.dotRelative = !!opts.dotRelative;
        this.nodir = !!opts.nodir;
        this.mark = !!opts.mark;
        if (!opts.cwd) {
          this.cwd = "";
        } else if (opts.cwd instanceof URL || opts.cwd.startsWith("file://")) {
          opts.cwd = (0, node_url_1.fileURLToPath)(opts.cwd);
        }
        this.cwd = opts.cwd || "";
        this.root = opts.root;
        this.magicalBraces = !!opts.magicalBraces;
        this.nobrace = !!opts.nobrace;
        this.noext = !!opts.noext;
        this.realpath = !!opts.realpath;
        this.absolute = opts.absolute;
        this.includeChildMatches = opts.includeChildMatches !== false;
        this.noglobstar = !!opts.noglobstar;
        this.matchBase = !!opts.matchBase;
        this.maxDepth = typeof opts.maxDepth === "number" ? opts.maxDepth : Infinity;
        this.stat = !!opts.stat;
        this.ignore = opts.ignore;
        if (this.withFileTypes && this.absolute !== void 0) {
          throw new Error("cannot set absolute and withFileTypes:true");
        }
        if (typeof pattern === "string") {
          pattern = [pattern];
        }
        this.windowsPathsNoEscape = !!opts.windowsPathsNoEscape || opts.allowWindowsEscape === false;
        if (this.windowsPathsNoEscape) {
          pattern = pattern.map((p) => p.replace(/\\/g, "/"));
        }
        if (this.matchBase) {
          if (opts.noglobstar) {
            throw new TypeError("base matching requires globstar");
          }
          pattern = pattern.map((p) => p.includes("/") ? p : `./**/${p}`);
        }
        this.pattern = pattern;
        this.platform = opts.platform || defaultPlatform;
        this.opts = { ...opts, platform: this.platform };
        if (opts.scurry) {
          this.scurry = opts.scurry;
          if (opts.nocase !== void 0 && opts.nocase !== opts.scurry.nocase) {
            throw new Error("nocase option contradicts provided scurry option");
          }
        } else {
          const Scurry = opts.platform === "win32" ? path_scurry_1.PathScurryWin32 : opts.platform === "darwin" ? path_scurry_1.PathScurryDarwin : opts.platform ? path_scurry_1.PathScurryPosix : path_scurry_1.PathScurry;
          this.scurry = new Scurry(this.cwd, {
            nocase: opts.nocase,
            fs: opts.fs
          });
        }
        this.nocase = this.scurry.nocase;
        const nocaseMagicOnly = this.platform === "darwin" || this.platform === "win32";
        const mmo = {
          // default nocase based on platform
          ...opts,
          dot: this.dot,
          matchBase: this.matchBase,
          nobrace: this.nobrace,
          nocase: this.nocase,
          nocaseMagicOnly,
          nocomment: true,
          noext: this.noext,
          nonegate: true,
          optimizationLevel: 2,
          platform: this.platform,
          windowsPathsNoEscape: this.windowsPathsNoEscape,
          debug: !!this.opts.debug
        };
        const mms = this.pattern.map((p) => new minimatch_1.Minimatch(p, mmo));
        const [matchSet, globParts] = mms.reduce((set, m) => {
          set[0].push(...m.set);
          set[1].push(...m.globParts);
          return set;
        }, [[], []]);
        this.patterns = matchSet.map((set, i) => {
          const g = globParts[i];
          if (!g)
            throw new Error("invalid pattern object");
          return new pattern_js_1.Pattern(set, g, 0, this.platform);
        });
      }
      async walk() {
        return [
          ...await new walker_js_1.GlobWalker(this.patterns, this.scurry.cwd, {
            ...this.opts,
            maxDepth: this.maxDepth !== Infinity ? this.maxDepth + this.scurry.cwd.depth() : Infinity,
            platform: this.platform,
            nocase: this.nocase,
            includeChildMatches: this.includeChildMatches
          }).walk()
        ];
      }
      walkSync() {
        return [
          ...new walker_js_1.GlobWalker(this.patterns, this.scurry.cwd, {
            ...this.opts,
            maxDepth: this.maxDepth !== Infinity ? this.maxDepth + this.scurry.cwd.depth() : Infinity,
            platform: this.platform,
            nocase: this.nocase,
            includeChildMatches: this.includeChildMatches
          }).walkSync()
        ];
      }
      stream() {
        return new walker_js_1.GlobStream(this.patterns, this.scurry.cwd, {
          ...this.opts,
          maxDepth: this.maxDepth !== Infinity ? this.maxDepth + this.scurry.cwd.depth() : Infinity,
          platform: this.platform,
          nocase: this.nocase,
          includeChildMatches: this.includeChildMatches
        }).stream();
      }
      streamSync() {
        return new walker_js_1.GlobStream(this.patterns, this.scurry.cwd, {
          ...this.opts,
          maxDepth: this.maxDepth !== Infinity ? this.maxDepth + this.scurry.cwd.depth() : Infinity,
          platform: this.platform,
          nocase: this.nocase,
          includeChildMatches: this.includeChildMatches
        }).streamSync();
      }
      /**
       * Default sync iteration function. Returns a Generator that
       * iterates over the results.
       */
      iterateSync() {
        return this.streamSync()[Symbol.iterator]();
      }
      [Symbol.iterator]() {
        return this.iterateSync();
      }
      /**
       * Default async iteration function. Returns an AsyncGenerator that
       * iterates over the results.
       */
      iterate() {
        return this.stream()[Symbol.asyncIterator]();
      }
      [Symbol.asyncIterator]() {
        return this.iterate();
      }
    };
    exports2.Glob = Glob;
  }
});

// node_modules/glob/dist/commonjs/has-magic.js
var require_has_magic = __commonJS({
  "node_modules/glob/dist/commonjs/has-magic.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.hasMagic = void 0;
    var minimatch_1 = require_commonjs();
    var hasMagic = (pattern, options2 = {}) => {
      if (!Array.isArray(pattern)) {
        pattern = [pattern];
      }
      for (const p of pattern) {
        if (new minimatch_1.Minimatch(p, options2).hasMagic())
          return true;
      }
      return false;
    };
    exports2.hasMagic = hasMagic;
  }
});

// node_modules/glob/dist/commonjs/index.js
var require_commonjs6 = __commonJS({
  "node_modules/glob/dist/commonjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.glob = exports2.sync = exports2.iterate = exports2.iterateSync = exports2.stream = exports2.streamSync = exports2.Ignore = exports2.hasMagic = exports2.Glob = exports2.unescape = exports2.escape = void 0;
    exports2.globStreamSync = globStreamSync;
    exports2.globStream = globStream;
    exports2.globSync = globSync;
    exports2.globIterateSync = globIterateSync;
    exports2.globIterate = globIterate;
    var minimatch_1 = require_commonjs();
    var glob_js_1 = require_glob();
    var has_magic_js_1 = require_has_magic();
    var minimatch_2 = require_commonjs();
    Object.defineProperty(exports2, "escape", { enumerable: true, get: function() {
      return minimatch_2.escape;
    } });
    Object.defineProperty(exports2, "unescape", { enumerable: true, get: function() {
      return minimatch_2.unescape;
    } });
    var glob_js_2 = require_glob();
    Object.defineProperty(exports2, "Glob", { enumerable: true, get: function() {
      return glob_js_2.Glob;
    } });
    var has_magic_js_2 = require_has_magic();
    Object.defineProperty(exports2, "hasMagic", { enumerable: true, get: function() {
      return has_magic_js_2.hasMagic;
    } });
    var ignore_js_1 = require_ignore();
    Object.defineProperty(exports2, "Ignore", { enumerable: true, get: function() {
      return ignore_js_1.Ignore;
    } });
    function globStreamSync(pattern, options2 = {}) {
      return new glob_js_1.Glob(pattern, options2).streamSync();
    }
    function globStream(pattern, options2 = {}) {
      return new glob_js_1.Glob(pattern, options2).stream();
    }
    function globSync(pattern, options2 = {}) {
      return new glob_js_1.Glob(pattern, options2).walkSync();
    }
    async function glob_(pattern, options2 = {}) {
      return new glob_js_1.Glob(pattern, options2).walk();
    }
    function globIterateSync(pattern, options2 = {}) {
      return new glob_js_1.Glob(pattern, options2).iterateSync();
    }
    function globIterate(pattern, options2 = {}) {
      return new glob_js_1.Glob(pattern, options2).iterate();
    }
    exports2.streamSync = globStreamSync;
    exports2.stream = Object.assign(globStream, { sync: globStreamSync });
    exports2.iterateSync = globIterateSync;
    exports2.iterate = Object.assign(globIterate, {
      sync: globIterateSync
    });
    exports2.sync = Object.assign(globSync, {
      stream: globStreamSync,
      iterate: globIterateSync
    });
    exports2.glob = Object.assign(glob_, {
      glob: glob_,
      globSync,
      sync: exports2.sync,
      globStream,
      stream: exports2.stream,
      globStreamSync,
      streamSync: exports2.streamSync,
      globIterate,
      iterate: exports2.iterate,
      globIterateSync,
      iterateSync: exports2.iterateSync,
      Glob: glob_js_1.Glob,
      hasMagic: has_magic_js_1.hasMagic,
      escape: minimatch_1.escape,
      unescape: minimatch_1.unescape
    });
    exports2.glob.glob = exports2.glob;
  }
});

// node_modules/isexe/dist/cjs/posix.js
var require_posix = __commonJS({
  "node_modules/isexe/dist/cjs/posix.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.sync = exports2.isexe = void 0;
    var fs_1 = require("fs");
    var promises_1 = require("fs/promises");
    var isexe = async (path2, options2 = {}) => {
      const { ignoreErrors = false } = options2;
      try {
        return checkStat(await (0, promises_1.stat)(path2), options2);
      } catch (e) {
        const er = e;
        if (ignoreErrors || er.code === "EACCES")
          return false;
        throw er;
      }
    };
    exports2.isexe = isexe;
    var sync = (path2, options2 = {}) => {
      const { ignoreErrors = false } = options2;
      try {
        return checkStat((0, fs_1.statSync)(path2), options2);
      } catch (e) {
        const er = e;
        if (ignoreErrors || er.code === "EACCES")
          return false;
        throw er;
      }
    };
    exports2.sync = sync;
    var checkStat = (stat, options2) => stat.isFile() && checkMode(stat, options2);
    var checkMode = (stat, options2) => {
      const myUid = options2.uid ?? process.getuid?.();
      const myGroups = options2.groups ?? process.getgroups?.() ?? [];
      const myGid = options2.gid ?? process.getgid?.() ?? myGroups[0];
      if (myUid === void 0 || myGid === void 0) {
        throw new Error("cannot get uid or gid");
      }
      const groups = /* @__PURE__ */ new Set([myGid, ...myGroups]);
      const mod = stat.mode;
      const uid = stat.uid;
      const gid = stat.gid;
      const u = parseInt("100", 8);
      const g = parseInt("010", 8);
      const o = parseInt("001", 8);
      const ug = u | g;
      return !!(mod & o || mod & g && groups.has(gid) || mod & u && uid === myUid || mod & ug && myUid === 0);
    };
  }
});

// node_modules/isexe/dist/cjs/win32.js
var require_win32 = __commonJS({
  "node_modules/isexe/dist/cjs/win32.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.sync = exports2.isexe = void 0;
    var fs_1 = require("fs");
    var promises_1 = require("fs/promises");
    var isexe = async (path2, options2 = {}) => {
      const { ignoreErrors = false } = options2;
      try {
        return checkStat(await (0, promises_1.stat)(path2), path2, options2);
      } catch (e) {
        const er = e;
        if (ignoreErrors || er.code === "EACCES")
          return false;
        throw er;
      }
    };
    exports2.isexe = isexe;
    var sync = (path2, options2 = {}) => {
      const { ignoreErrors = false } = options2;
      try {
        return checkStat((0, fs_1.statSync)(path2), path2, options2);
      } catch (e) {
        const er = e;
        if (ignoreErrors || er.code === "EACCES")
          return false;
        throw er;
      }
    };
    exports2.sync = sync;
    var checkPathExt = (path2, options2) => {
      const { pathExt = process.env.PATHEXT || "" } = options2;
      const peSplit = pathExt.split(";");
      if (peSplit.indexOf("") !== -1) {
        return true;
      }
      for (let i = 0; i < peSplit.length; i++) {
        const p = peSplit[i].toLowerCase();
        const ext = path2.substring(path2.length - p.length).toLowerCase();
        if (p && ext === p) {
          return true;
        }
      }
      return false;
    };
    var checkStat = (stat, path2, options2) => stat.isFile() && checkPathExt(path2, options2);
  }
});

// node_modules/isexe/dist/cjs/options.js
var require_options = __commonJS({
  "node_modules/isexe/dist/cjs/options.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// node_modules/isexe/dist/cjs/index.js
var require_cjs = __commonJS({
  "node_modules/isexe/dist/cjs/index.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    }) : (function(o, m, k, k2) {
      if (k2 === void 0) k2 = k;
      o[k2] = m[k];
    }));
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? (function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule) return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p)) __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.sync = exports2.isexe = exports2.posix = exports2.win32 = void 0;
    var posix = __importStar(require_posix());
    exports2.posix = posix;
    var win32 = __importStar(require_win32());
    exports2.win32 = win32;
    __exportStar(require_options(), exports2);
    var platform2 = process.env._ISEXE_TEST_PLATFORM_ || process.platform;
    var impl = platform2 === "win32" ? win32 : posix;
    exports2.isexe = impl.isexe;
    exports2.sync = impl.sync;
  }
});

// node_modules/which/lib/index.js
var require_lib = __commonJS({
  "node_modules/which/lib/index.js"(exports2, module2) {
    var { isexe, sync: isexeSync } = require_cjs();
    var { join, delimiter, sep, posix } = require("path");
    var isWindows2 = process.platform === "win32";
    var rSlash = new RegExp(`[${posix.sep}${sep === posix.sep ? "" : sep}]`.replace(/(\\)/g, "\\$1"));
    var rRel = new RegExp(`^\\.${rSlash.source}`);
    var getNotFoundError = (cmd) => Object.assign(new Error(`not found: ${cmd}`), { code: "ENOENT" });
    var getPathInfo = (cmd, {
      path: optPath = process.env.PATH,
      pathExt: optPathExt = process.env.PATHEXT,
      delimiter: optDelimiter = delimiter
    }) => {
      const pathEnv = cmd.match(rSlash) ? [""] : [
        // windows always checks the cwd first
        ...isWindows2 ? [process.cwd()] : [],
        ...(optPath || /* istanbul ignore next: very unusual */
        "").split(optDelimiter)
      ];
      if (isWindows2) {
        const pathExtExe = optPathExt || [".EXE", ".CMD", ".BAT", ".COM"].join(optDelimiter);
        const pathExt = pathExtExe.split(optDelimiter).flatMap((item) => [item, item.toLowerCase()]);
        if (cmd.includes(".") && pathExt[0] !== "") {
          pathExt.unshift("");
        }
        return { pathEnv, pathExt, pathExtExe };
      }
      return { pathEnv, pathExt: [""] };
    };
    var getPathPart = (raw, cmd) => {
      const pathPart = /^".*"$/.test(raw) ? raw.slice(1, -1) : raw;
      const prefix = !pathPart && rRel.test(cmd) ? cmd.slice(0, 2) : "";
      return prefix + join(pathPart, cmd);
    };
    var which2 = async (cmd, opt = {}) => {
      const { pathEnv, pathExt, pathExtExe } = getPathInfo(cmd, opt);
      const found = [];
      for (const envPart of pathEnv) {
        const p = getPathPart(envPart, cmd);
        for (const ext of pathExt) {
          const withExt = p + ext;
          const is = await isexe(withExt, { pathExt: pathExtExe, ignoreErrors: true });
          if (is) {
            if (!opt.all) {
              return withExt;
            }
            found.push(withExt);
          }
        }
      }
      if (opt.all && found.length) {
        return found;
      }
      if (opt.nothrow) {
        return null;
      }
      throw getNotFoundError(cmd);
    };
    var whichSync = (cmd, opt = {}) => {
      const { pathEnv, pathExt, pathExtExe } = getPathInfo(cmd, opt);
      const found = [];
      for (const pathEnvPart of pathEnv) {
        const p = getPathPart(pathEnvPart, cmd);
        for (const ext of pathExt) {
          const withExt = p + ext;
          const is = isexeSync(withExt, { pathExt: pathExtExe, ignoreErrors: true });
          if (is) {
            if (!opt.all) {
              return withExt;
            }
            found.push(withExt);
          }
        }
      }
      if (opt.all && found.length) {
        return found;
      }
      if (opt.nothrow) {
        return null;
      }
      throw getNotFoundError(cmd);
    };
    module2.exports = which2;
    which2.sync = whichSync;
  }
});

// node_modules/semver/internal/constants.js
var require_constants = __commonJS({
  "node_modules/semver/internal/constants.js"(exports2, module2) {
    "use strict";
    var SEMVER_SPEC_VERSION = "2.0.0";
    var MAX_LENGTH = 256;
    var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || /* istanbul ignore next */
    9007199254740991;
    var MAX_SAFE_COMPONENT_LENGTH = 16;
    var MAX_SAFE_BUILD_LENGTH = MAX_LENGTH - 6;
    var RELEASE_TYPES = [
      "major",
      "premajor",
      "minor",
      "preminor",
      "patch",
      "prepatch",
      "prerelease"
    ];
    module2.exports = {
      MAX_LENGTH,
      MAX_SAFE_COMPONENT_LENGTH,
      MAX_SAFE_BUILD_LENGTH,
      MAX_SAFE_INTEGER,
      RELEASE_TYPES,
      SEMVER_SPEC_VERSION,
      FLAG_INCLUDE_PRERELEASE: 1,
      FLAG_LOOSE: 2
    };
  }
});

// node_modules/semver/internal/debug.js
var require_debug = __commonJS({
  "node_modules/semver/internal/debug.js"(exports2, module2) {
    "use strict";
    var debug = typeof process === "object" && process.env && process.env.NODE_DEBUG && /\bsemver\b/i.test(process.env.NODE_DEBUG) ? (...args) => console.error("SEMVER", ...args) : () => {
    };
    module2.exports = debug;
  }
});

// node_modules/semver/internal/re.js
var require_re = __commonJS({
  "node_modules/semver/internal/re.js"(exports2, module2) {
    "use strict";
    var {
      MAX_SAFE_COMPONENT_LENGTH,
      MAX_SAFE_BUILD_LENGTH,
      MAX_LENGTH
    } = require_constants();
    var debug = require_debug();
    exports2 = module2.exports = {};
    var re = exports2.re = [];
    var safeRe = exports2.safeRe = [];
    var src = exports2.src = [];
    var safeSrc = exports2.safeSrc = [];
    var t = exports2.t = {};
    var R = 0;
    var LETTERDASHNUMBER = "[a-zA-Z0-9-]";
    var safeRegexReplacements = [
      ["\\s", 1],
      ["\\d", MAX_LENGTH],
      [LETTERDASHNUMBER, MAX_SAFE_BUILD_LENGTH]
    ];
    var makeSafeRegex = (value) => {
      for (const [token, max] of safeRegexReplacements) {
        value = value.split(`${token}*`).join(`${token}{0,${max}}`).split(`${token}+`).join(`${token}{1,${max}}`);
      }
      return value;
    };
    var createToken = (name2, value, isGlobal) => {
      const safe = makeSafeRegex(value);
      const index = R++;
      debug(name2, index, value);
      t[name2] = index;
      src[index] = value;
      safeSrc[index] = safe;
      re[index] = new RegExp(value, isGlobal ? "g" : void 0);
      safeRe[index] = new RegExp(safe, isGlobal ? "g" : void 0);
    };
    createToken("NUMERICIDENTIFIER", "0|[1-9]\\d*");
    createToken("NUMERICIDENTIFIERLOOSE", "\\d+");
    createToken("NONNUMERICIDENTIFIER", `\\d*[a-zA-Z-]${LETTERDASHNUMBER}*`);
    createToken("MAINVERSION", `(${src[t.NUMERICIDENTIFIER]})\\.(${src[t.NUMERICIDENTIFIER]})\\.(${src[t.NUMERICIDENTIFIER]})`);
    createToken("MAINVERSIONLOOSE", `(${src[t.NUMERICIDENTIFIERLOOSE]})\\.(${src[t.NUMERICIDENTIFIERLOOSE]})\\.(${src[t.NUMERICIDENTIFIERLOOSE]})`);
    createToken("PRERELEASEIDENTIFIER", `(?:${src[t.NONNUMERICIDENTIFIER]}|${src[t.NUMERICIDENTIFIER]})`);
    createToken("PRERELEASEIDENTIFIERLOOSE", `(?:${src[t.NONNUMERICIDENTIFIER]}|${src[t.NUMERICIDENTIFIERLOOSE]})`);
    createToken("PRERELEASE", `(?:-(${src[t.PRERELEASEIDENTIFIER]}(?:\\.${src[t.PRERELEASEIDENTIFIER]})*))`);
    createToken("PRERELEASELOOSE", `(?:-?(${src[t.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${src[t.PRERELEASEIDENTIFIERLOOSE]})*))`);
    createToken("BUILDIDENTIFIER", `${LETTERDASHNUMBER}+`);
    createToken("BUILD", `(?:\\+(${src[t.BUILDIDENTIFIER]}(?:\\.${src[t.BUILDIDENTIFIER]})*))`);
    createToken("FULLPLAIN", `v?${src[t.MAINVERSION]}${src[t.PRERELEASE]}?${src[t.BUILD]}?`);
    createToken("FULL", `^${src[t.FULLPLAIN]}$`);
    createToken("LOOSEPLAIN", `[v=\\s]*${src[t.MAINVERSIONLOOSE]}${src[t.PRERELEASELOOSE]}?${src[t.BUILD]}?`);
    createToken("LOOSE", `^${src[t.LOOSEPLAIN]}$`);
    createToken("GTLT", "((?:<|>)?=?)");
    createToken("XRANGEIDENTIFIERLOOSE", `${src[t.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`);
    createToken("XRANGEIDENTIFIER", `${src[t.NUMERICIDENTIFIER]}|x|X|\\*`);
    createToken("XRANGEPLAIN", `[v=\\s]*(${src[t.XRANGEIDENTIFIER]})(?:\\.(${src[t.XRANGEIDENTIFIER]})(?:\\.(${src[t.XRANGEIDENTIFIER]})(?:${src[t.PRERELEASE]})?${src[t.BUILD]}?)?)?`);
    createToken("XRANGEPLAINLOOSE", `[v=\\s]*(${src[t.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})(?:${src[t.PRERELEASELOOSE]})?${src[t.BUILD]}?)?)?`);
    createToken("XRANGE", `^${src[t.GTLT]}\\s*${src[t.XRANGEPLAIN]}$`);
    createToken("XRANGELOOSE", `^${src[t.GTLT]}\\s*${src[t.XRANGEPLAINLOOSE]}$`);
    createToken("COERCEPLAIN", `${"(^|[^\\d])(\\d{1,"}${MAX_SAFE_COMPONENT_LENGTH}})(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?`);
    createToken("COERCE", `${src[t.COERCEPLAIN]}(?:$|[^\\d])`);
    createToken("COERCEFULL", src[t.COERCEPLAIN] + `(?:${src[t.PRERELEASE]})?(?:${src[t.BUILD]})?(?:$|[^\\d])`);
    createToken("COERCERTL", src[t.COERCE], true);
    createToken("COERCERTLFULL", src[t.COERCEFULL], true);
    createToken("LONETILDE", "(?:~>?)");
    createToken("TILDETRIM", `(\\s*)${src[t.LONETILDE]}\\s+`, true);
    exports2.tildeTrimReplace = "$1~";
    createToken("TILDE", `^${src[t.LONETILDE]}${src[t.XRANGEPLAIN]}$`);
    createToken("TILDELOOSE", `^${src[t.LONETILDE]}${src[t.XRANGEPLAINLOOSE]}$`);
    createToken("LONECARET", "(?:\\^)");
    createToken("CARETTRIM", `(\\s*)${src[t.LONECARET]}\\s+`, true);
    exports2.caretTrimReplace = "$1^";
    createToken("CARET", `^${src[t.LONECARET]}${src[t.XRANGEPLAIN]}$`);
    createToken("CARETLOOSE", `^${src[t.LONECARET]}${src[t.XRANGEPLAINLOOSE]}$`);
    createToken("COMPARATORLOOSE", `^${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]})$|^$`);
    createToken("COMPARATOR", `^${src[t.GTLT]}\\s*(${src[t.FULLPLAIN]})$|^$`);
    createToken("COMPARATORTRIM", `(\\s*)${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]}|${src[t.XRANGEPLAIN]})`, true);
    exports2.comparatorTrimReplace = "$1$2$3";
    createToken("HYPHENRANGE", `^\\s*(${src[t.XRANGEPLAIN]})\\s+-\\s+(${src[t.XRANGEPLAIN]})\\s*$`);
    createToken("HYPHENRANGELOOSE", `^\\s*(${src[t.XRANGEPLAINLOOSE]})\\s+-\\s+(${src[t.XRANGEPLAINLOOSE]})\\s*$`);
    createToken("STAR", "(<|>)?=?\\s*\\*");
    createToken("GTE0", "^\\s*>=\\s*0\\.0\\.0\\s*$");
    createToken("GTE0PRE", "^\\s*>=\\s*0\\.0\\.0-0\\s*$");
  }
});

// node_modules/semver/internal/parse-options.js
var require_parse_options = __commonJS({
  "node_modules/semver/internal/parse-options.js"(exports2, module2) {
    "use strict";
    var looseOption = Object.freeze({ loose: true });
    var emptyOpts = Object.freeze({});
    var parseOptions = (options2) => {
      if (!options2) {
        return emptyOpts;
      }
      if (typeof options2 !== "object") {
        return looseOption;
      }
      return options2;
    };
    module2.exports = parseOptions;
  }
});

// node_modules/semver/internal/identifiers.js
var require_identifiers = __commonJS({
  "node_modules/semver/internal/identifiers.js"(exports2, module2) {
    "use strict";
    var numeric = /^[0-9]+$/;
    var compareIdentifiers = (a, b) => {
      if (typeof a === "number" && typeof b === "number") {
        return a === b ? 0 : a < b ? -1 : 1;
      }
      const anum = numeric.test(a);
      const bnum = numeric.test(b);
      if (anum && bnum) {
        a = +a;
        b = +b;
      }
      return a === b ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a < b ? -1 : 1;
    };
    var rcompareIdentifiers = (a, b) => compareIdentifiers(b, a);
    module2.exports = {
      compareIdentifiers,
      rcompareIdentifiers
    };
  }
});

// node_modules/semver/classes/semver.js
var require_semver = __commonJS({
  "node_modules/semver/classes/semver.js"(exports2, module2) {
    "use strict";
    var debug = require_debug();
    var { MAX_LENGTH, MAX_SAFE_INTEGER } = require_constants();
    var { safeRe: re, t } = require_re();
    var parseOptions = require_parse_options();
    var { compareIdentifiers } = require_identifiers();
    var SemVer = class _SemVer {
      constructor(version2, options2) {
        options2 = parseOptions(options2);
        if (version2 instanceof _SemVer) {
          if (version2.loose === !!options2.loose && version2.includePrerelease === !!options2.includePrerelease) {
            return version2;
          } else {
            version2 = version2.version;
          }
        } else if (typeof version2 !== "string") {
          throw new TypeError(`Invalid version. Must be a string. Got type "${typeof version2}".`);
        }
        if (version2.length > MAX_LENGTH) {
          throw new TypeError(
            `version is longer than ${MAX_LENGTH} characters`
          );
        }
        debug("SemVer", version2, options2);
        this.options = options2;
        this.loose = !!options2.loose;
        this.includePrerelease = !!options2.includePrerelease;
        const m = version2.trim().match(options2.loose ? re[t.LOOSE] : re[t.FULL]);
        if (!m) {
          throw new TypeError(`Invalid Version: ${version2}`);
        }
        this.raw = version2;
        this.major = +m[1];
        this.minor = +m[2];
        this.patch = +m[3];
        if (this.major > MAX_SAFE_INTEGER || this.major < 0) {
          throw new TypeError("Invalid major version");
        }
        if (this.minor > MAX_SAFE_INTEGER || this.minor < 0) {
          throw new TypeError("Invalid minor version");
        }
        if (this.patch > MAX_SAFE_INTEGER || this.patch < 0) {
          throw new TypeError("Invalid patch version");
        }
        if (!m[4]) {
          this.prerelease = [];
        } else {
          this.prerelease = m[4].split(".").map((id2) => {
            if (/^[0-9]+$/.test(id2)) {
              const num = +id2;
              if (num >= 0 && num < MAX_SAFE_INTEGER) {
                return num;
              }
            }
            return id2;
          });
        }
        this.build = m[5] ? m[5].split(".") : [];
        this.format();
      }
      format() {
        this.version = `${this.major}.${this.minor}.${this.patch}`;
        if (this.prerelease.length) {
          this.version += `-${this.prerelease.join(".")}`;
        }
        return this.version;
      }
      toString() {
        return this.version;
      }
      compare(other) {
        debug("SemVer.compare", this.version, this.options, other);
        if (!(other instanceof _SemVer)) {
          if (typeof other === "string" && other === this.version) {
            return 0;
          }
          other = new _SemVer(other, this.options);
        }
        if (other.version === this.version) {
          return 0;
        }
        return this.compareMain(other) || this.comparePre(other);
      }
      compareMain(other) {
        if (!(other instanceof _SemVer)) {
          other = new _SemVer(other, this.options);
        }
        if (this.major < other.major) {
          return -1;
        }
        if (this.major > other.major) {
          return 1;
        }
        if (this.minor < other.minor) {
          return -1;
        }
        if (this.minor > other.minor) {
          return 1;
        }
        if (this.patch < other.patch) {
          return -1;
        }
        if (this.patch > other.patch) {
          return 1;
        }
        return 0;
      }
      comparePre(other) {
        if (!(other instanceof _SemVer)) {
          other = new _SemVer(other, this.options);
        }
        if (this.prerelease.length && !other.prerelease.length) {
          return -1;
        } else if (!this.prerelease.length && other.prerelease.length) {
          return 1;
        } else if (!this.prerelease.length && !other.prerelease.length) {
          return 0;
        }
        let i = 0;
        do {
          const a = this.prerelease[i];
          const b = other.prerelease[i];
          debug("prerelease compare", i, a, b);
          if (a === void 0 && b === void 0) {
            return 0;
          } else if (b === void 0) {
            return 1;
          } else if (a === void 0) {
            return -1;
          } else if (a === b) {
            continue;
          } else {
            return compareIdentifiers(a, b);
          }
        } while (++i);
      }
      compareBuild(other) {
        if (!(other instanceof _SemVer)) {
          other = new _SemVer(other, this.options);
        }
        let i = 0;
        do {
          const a = this.build[i];
          const b = other.build[i];
          debug("build compare", i, a, b);
          if (a === void 0 && b === void 0) {
            return 0;
          } else if (b === void 0) {
            return 1;
          } else if (a === void 0) {
            return -1;
          } else if (a === b) {
            continue;
          } else {
            return compareIdentifiers(a, b);
          }
        } while (++i);
      }
      // preminor will bump the version up to the next minor release, and immediately
      // down to pre-release. premajor and prepatch work the same way.
      inc(release, identifier, identifierBase) {
        if (release.startsWith("pre")) {
          if (!identifier && identifierBase === false) {
            throw new Error("invalid increment argument: identifier is empty");
          }
          if (identifier) {
            const match = `-${identifier}`.match(this.options.loose ? re[t.PRERELEASELOOSE] : re[t.PRERELEASE]);
            if (!match || match[1] !== identifier) {
              throw new Error(`invalid identifier: ${identifier}`);
            }
          }
        }
        switch (release) {
          case "premajor":
            this.prerelease.length = 0;
            this.patch = 0;
            this.minor = 0;
            this.major++;
            this.inc("pre", identifier, identifierBase);
            break;
          case "preminor":
            this.prerelease.length = 0;
            this.patch = 0;
            this.minor++;
            this.inc("pre", identifier, identifierBase);
            break;
          case "prepatch":
            this.prerelease.length = 0;
            this.inc("patch", identifier, identifierBase);
            this.inc("pre", identifier, identifierBase);
            break;
          // If the input is a non-prerelease version, this acts the same as
          // prepatch.
          case "prerelease":
            if (this.prerelease.length === 0) {
              this.inc("patch", identifier, identifierBase);
            }
            this.inc("pre", identifier, identifierBase);
            break;
          case "release":
            if (this.prerelease.length === 0) {
              throw new Error(`version ${this.raw} is not a prerelease`);
            }
            this.prerelease.length = 0;
            break;
          case "major":
            if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
              this.major++;
            }
            this.minor = 0;
            this.patch = 0;
            this.prerelease = [];
            break;
          case "minor":
            if (this.patch !== 0 || this.prerelease.length === 0) {
              this.minor++;
            }
            this.patch = 0;
            this.prerelease = [];
            break;
          case "patch":
            if (this.prerelease.length === 0) {
              this.patch++;
            }
            this.prerelease = [];
            break;
          // This probably shouldn't be used publicly.
          // 1.0.0 'pre' would become 1.0.0-0 which is the wrong direction.
          case "pre": {
            const base = Number(identifierBase) ? 1 : 0;
            if (this.prerelease.length === 0) {
              this.prerelease = [base];
            } else {
              let i = this.prerelease.length;
              while (--i >= 0) {
                if (typeof this.prerelease[i] === "number") {
                  this.prerelease[i]++;
                  i = -2;
                }
              }
              if (i === -1) {
                if (identifier === this.prerelease.join(".") && identifierBase === false) {
                  throw new Error("invalid increment argument: identifier already exists");
                }
                this.prerelease.push(base);
              }
            }
            if (identifier) {
              let prerelease = [identifier, base];
              if (identifierBase === false) {
                prerelease = [identifier];
              }
              if (compareIdentifiers(this.prerelease[0], identifier) === 0) {
                if (isNaN(this.prerelease[1])) {
                  this.prerelease = prerelease;
                }
              } else {
                this.prerelease = prerelease;
              }
            }
            break;
          }
          default:
            throw new Error(`invalid increment argument: ${release}`);
        }
        this.raw = this.format();
        if (this.build.length) {
          this.raw += `+${this.build.join(".")}`;
        }
        return this;
      }
    };
    module2.exports = SemVer;
  }
});

// node_modules/semver/functions/parse.js
var require_parse = __commonJS({
  "node_modules/semver/functions/parse.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var parse3 = (version2, options2, throwErrors = false) => {
      if (version2 instanceof SemVer) {
        return version2;
      }
      try {
        return new SemVer(version2, options2);
      } catch (er) {
        if (!throwErrors) {
          return null;
        }
        throw er;
      }
    };
    module2.exports = parse3;
  }
});

// node_modules/semver/functions/valid.js
var require_valid = __commonJS({
  "node_modules/semver/functions/valid.js"(exports2, module2) {
    "use strict";
    var parse3 = require_parse();
    var valid = (version2, options2) => {
      const v = parse3(version2, options2);
      return v ? v.version : null;
    };
    module2.exports = valid;
  }
});

// node_modules/semver/functions/clean.js
var require_clean = __commonJS({
  "node_modules/semver/functions/clean.js"(exports2, module2) {
    "use strict";
    var parse3 = require_parse();
    var clean = (version2, options2) => {
      const s = parse3(version2.trim().replace(/^[=v]+/, ""), options2);
      return s ? s.version : null;
    };
    module2.exports = clean;
  }
});

// node_modules/semver/functions/inc.js
var require_inc = __commonJS({
  "node_modules/semver/functions/inc.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var inc = (version2, release, options2, identifier, identifierBase) => {
      if (typeof options2 === "string") {
        identifierBase = identifier;
        identifier = options2;
        options2 = void 0;
      }
      try {
        return new SemVer(
          version2 instanceof SemVer ? version2.version : version2,
          options2
        ).inc(release, identifier, identifierBase).version;
      } catch (er) {
        return null;
      }
    };
    module2.exports = inc;
  }
});

// node_modules/semver/functions/diff.js
var require_diff = __commonJS({
  "node_modules/semver/functions/diff.js"(exports2, module2) {
    "use strict";
    var parse3 = require_parse();
    var diff = (version1, version2) => {
      const v12 = parse3(version1, null, true);
      const v2 = parse3(version2, null, true);
      const comparison = v12.compare(v2);
      if (comparison === 0) {
        return null;
      }
      const v1Higher = comparison > 0;
      const highVersion = v1Higher ? v12 : v2;
      const lowVersion = v1Higher ? v2 : v12;
      const highHasPre = !!highVersion.prerelease.length;
      const lowHasPre = !!lowVersion.prerelease.length;
      if (lowHasPre && !highHasPre) {
        if (!lowVersion.patch && !lowVersion.minor) {
          return "major";
        }
        if (lowVersion.compareMain(highVersion) === 0) {
          if (lowVersion.minor && !lowVersion.patch) {
            return "minor";
          }
          return "patch";
        }
      }
      const prefix = highHasPre ? "pre" : "";
      if (v12.major !== v2.major) {
        return prefix + "major";
      }
      if (v12.minor !== v2.minor) {
        return prefix + "minor";
      }
      if (v12.patch !== v2.patch) {
        return prefix + "patch";
      }
      return "prerelease";
    };
    module2.exports = diff;
  }
});

// node_modules/semver/functions/major.js
var require_major = __commonJS({
  "node_modules/semver/functions/major.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var major = (a, loose) => new SemVer(a, loose).major;
    module2.exports = major;
  }
});

// node_modules/semver/functions/minor.js
var require_minor = __commonJS({
  "node_modules/semver/functions/minor.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var minor = (a, loose) => new SemVer(a, loose).minor;
    module2.exports = minor;
  }
});

// node_modules/semver/functions/patch.js
var require_patch = __commonJS({
  "node_modules/semver/functions/patch.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var patch = (a, loose) => new SemVer(a, loose).patch;
    module2.exports = patch;
  }
});

// node_modules/semver/functions/prerelease.js
var require_prerelease = __commonJS({
  "node_modules/semver/functions/prerelease.js"(exports2, module2) {
    "use strict";
    var parse3 = require_parse();
    var prerelease = (version2, options2) => {
      const parsed = parse3(version2, options2);
      return parsed && parsed.prerelease.length ? parsed.prerelease : null;
    };
    module2.exports = prerelease;
  }
});

// node_modules/semver/functions/compare.js
var require_compare = __commonJS({
  "node_modules/semver/functions/compare.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var compare2 = (a, b, loose) => new SemVer(a, loose).compare(new SemVer(b, loose));
    module2.exports = compare2;
  }
});

// node_modules/semver/functions/rcompare.js
var require_rcompare = __commonJS({
  "node_modules/semver/functions/rcompare.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var rcompare = (a, b, loose) => compare2(b, a, loose);
    module2.exports = rcompare;
  }
});

// node_modules/semver/functions/compare-loose.js
var require_compare_loose = __commonJS({
  "node_modules/semver/functions/compare-loose.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var compareLoose = (a, b) => compare2(a, b, true);
    module2.exports = compareLoose;
  }
});

// node_modules/semver/functions/compare-build.js
var require_compare_build = __commonJS({
  "node_modules/semver/functions/compare-build.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var compareBuild = (a, b, loose) => {
      const versionA = new SemVer(a, loose);
      const versionB = new SemVer(b, loose);
      return versionA.compare(versionB) || versionA.compareBuild(versionB);
    };
    module2.exports = compareBuild;
  }
});

// node_modules/semver/functions/sort.js
var require_sort = __commonJS({
  "node_modules/semver/functions/sort.js"(exports2, module2) {
    "use strict";
    var compareBuild = require_compare_build();
    var sort = (list2, loose) => list2.sort((a, b) => compareBuild(a, b, loose));
    module2.exports = sort;
  }
});

// node_modules/semver/functions/rsort.js
var require_rsort = __commonJS({
  "node_modules/semver/functions/rsort.js"(exports2, module2) {
    "use strict";
    var compareBuild = require_compare_build();
    var rsort = (list2, loose) => list2.sort((a, b) => compareBuild(b, a, loose));
    module2.exports = rsort;
  }
});

// node_modules/semver/functions/gt.js
var require_gt = __commonJS({
  "node_modules/semver/functions/gt.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var gt = (a, b, loose) => compare2(a, b, loose) > 0;
    module2.exports = gt;
  }
});

// node_modules/semver/functions/lt.js
var require_lt = __commonJS({
  "node_modules/semver/functions/lt.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var lt = (a, b, loose) => compare2(a, b, loose) < 0;
    module2.exports = lt;
  }
});

// node_modules/semver/functions/eq.js
var require_eq = __commonJS({
  "node_modules/semver/functions/eq.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var eq = (a, b, loose) => compare2(a, b, loose) === 0;
    module2.exports = eq;
  }
});

// node_modules/semver/functions/neq.js
var require_neq = __commonJS({
  "node_modules/semver/functions/neq.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var neq = (a, b, loose) => compare2(a, b, loose) !== 0;
    module2.exports = neq;
  }
});

// node_modules/semver/functions/gte.js
var require_gte = __commonJS({
  "node_modules/semver/functions/gte.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var gte = (a, b, loose) => compare2(a, b, loose) >= 0;
    module2.exports = gte;
  }
});

// node_modules/semver/functions/lte.js
var require_lte = __commonJS({
  "node_modules/semver/functions/lte.js"(exports2, module2) {
    "use strict";
    var compare2 = require_compare();
    var lte = (a, b, loose) => compare2(a, b, loose) <= 0;
    module2.exports = lte;
  }
});

// node_modules/semver/functions/cmp.js
var require_cmp = __commonJS({
  "node_modules/semver/functions/cmp.js"(exports2, module2) {
    "use strict";
    var eq = require_eq();
    var neq = require_neq();
    var gt = require_gt();
    var gte = require_gte();
    var lt = require_lt();
    var lte = require_lte();
    var cmp = (a, op, b, loose) => {
      switch (op) {
        case "===":
          if (typeof a === "object") {
            a = a.version;
          }
          if (typeof b === "object") {
            b = b.version;
          }
          return a === b;
        case "!==":
          if (typeof a === "object") {
            a = a.version;
          }
          if (typeof b === "object") {
            b = b.version;
          }
          return a !== b;
        case "":
        case "=":
        case "==":
          return eq(a, b, loose);
        case "!=":
          return neq(a, b, loose);
        case ">":
          return gt(a, b, loose);
        case ">=":
          return gte(a, b, loose);
        case "<":
          return lt(a, b, loose);
        case "<=":
          return lte(a, b, loose);
        default:
          throw new TypeError(`Invalid operator: ${op}`);
      }
    };
    module2.exports = cmp;
  }
});

// node_modules/semver/functions/coerce.js
var require_coerce = __commonJS({
  "node_modules/semver/functions/coerce.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var parse3 = require_parse();
    var { safeRe: re, t } = require_re();
    var coerce = (version2, options2) => {
      if (version2 instanceof SemVer) {
        return version2;
      }
      if (typeof version2 === "number") {
        version2 = String(version2);
      }
      if (typeof version2 !== "string") {
        return null;
      }
      options2 = options2 || {};
      let match = null;
      if (!options2.rtl) {
        match = version2.match(options2.includePrerelease ? re[t.COERCEFULL] : re[t.COERCE]);
      } else {
        const coerceRtlRegex = options2.includePrerelease ? re[t.COERCERTLFULL] : re[t.COERCERTL];
        let next;
        while ((next = coerceRtlRegex.exec(version2)) && (!match || match.index + match[0].length !== version2.length)) {
          if (!match || next.index + next[0].length !== match.index + match[0].length) {
            match = next;
          }
          coerceRtlRegex.lastIndex = next.index + next[1].length + next[2].length;
        }
        coerceRtlRegex.lastIndex = -1;
      }
      if (match === null) {
        return null;
      }
      const major = match[2];
      const minor = match[3] || "0";
      const patch = match[4] || "0";
      const prerelease = options2.includePrerelease && match[5] ? `-${match[5]}` : "";
      const build = options2.includePrerelease && match[6] ? `+${match[6]}` : "";
      return parse3(`${major}.${minor}.${patch}${prerelease}${build}`, options2);
    };
    module2.exports = coerce;
  }
});

// node_modules/semver/internal/lrucache.js
var require_lrucache = __commonJS({
  "node_modules/semver/internal/lrucache.js"(exports2, module2) {
    "use strict";
    var LRUCache2 = class {
      constructor() {
        this.max = 1e3;
        this.map = /* @__PURE__ */ new Map();
      }
      get(key) {
        const value = this.map.get(key);
        if (value === void 0) {
          return void 0;
        } else {
          this.map.delete(key);
          this.map.set(key, value);
          return value;
        }
      }
      delete(key) {
        return this.map.delete(key);
      }
      set(key, value) {
        const deleted = this.delete(key);
        if (!deleted && value !== void 0) {
          if (this.map.size >= this.max) {
            const firstKey = this.map.keys().next().value;
            this.delete(firstKey);
          }
          this.map.set(key, value);
        }
        return this;
      }
    };
    module2.exports = LRUCache2;
  }
});

// node_modules/semver/classes/range.js
var require_range = __commonJS({
  "node_modules/semver/classes/range.js"(exports2, module2) {
    "use strict";
    var SPACE_CHARACTERS = /\s+/g;
    var Range11 = class _Range {
      constructor(range, options2) {
        options2 = parseOptions(options2);
        if (range instanceof _Range) {
          if (range.loose === !!options2.loose && range.includePrerelease === !!options2.includePrerelease) {
            return range;
          } else {
            return new _Range(range.raw, options2);
          }
        }
        if (range instanceof Comparator) {
          this.raw = range.value;
          this.set = [[range]];
          this.formatted = void 0;
          return this;
        }
        this.options = options2;
        this.loose = !!options2.loose;
        this.includePrerelease = !!options2.includePrerelease;
        this.raw = range.trim().replace(SPACE_CHARACTERS, " ");
        this.set = this.raw.split("||").map((r) => this.parseRange(r.trim())).filter((c) => c.length);
        if (!this.set.length) {
          throw new TypeError(`Invalid SemVer Range: ${this.raw}`);
        }
        if (this.set.length > 1) {
          const first = this.set[0];
          this.set = this.set.filter((c) => !isNullSet(c[0]));
          if (this.set.length === 0) {
            this.set = [first];
          } else if (this.set.length > 1) {
            for (const c of this.set) {
              if (c.length === 1 && isAny(c[0])) {
                this.set = [c];
                break;
              }
            }
          }
        }
        this.formatted = void 0;
      }
      get range() {
        if (this.formatted === void 0) {
          this.formatted = "";
          for (let i = 0; i < this.set.length; i++) {
            if (i > 0) {
              this.formatted += "||";
            }
            const comps = this.set[i];
            for (let k = 0; k < comps.length; k++) {
              if (k > 0) {
                this.formatted += " ";
              }
              this.formatted += comps[k].toString().trim();
            }
          }
        }
        return this.formatted;
      }
      format() {
        return this.range;
      }
      toString() {
        return this.range;
      }
      parseRange(range) {
        const memoOpts = (this.options.includePrerelease && FLAG_INCLUDE_PRERELEASE) | (this.options.loose && FLAG_LOOSE);
        const memoKey = memoOpts + ":" + range;
        const cached = cache.get(memoKey);
        if (cached) {
          return cached;
        }
        const loose = this.options.loose;
        const hr = loose ? re[t.HYPHENRANGELOOSE] : re[t.HYPHENRANGE];
        range = range.replace(hr, hyphenReplace(this.options.includePrerelease));
        debug("hyphen replace", range);
        range = range.replace(re[t.COMPARATORTRIM], comparatorTrimReplace);
        debug("comparator trim", range);
        range = range.replace(re[t.TILDETRIM], tildeTrimReplace);
        debug("tilde trim", range);
        range = range.replace(re[t.CARETTRIM], caretTrimReplace);
        debug("caret trim", range);
        let rangeList = range.split(" ").map((comp) => parseComparator(comp, this.options)).join(" ").split(/\s+/).map((comp) => replaceGTE0(comp, this.options));
        if (loose) {
          rangeList = rangeList.filter((comp) => {
            debug("loose invalid filter", comp, this.options);
            return !!comp.match(re[t.COMPARATORLOOSE]);
          });
        }
        debug("range list", rangeList);
        const rangeMap = /* @__PURE__ */ new Map();
        const comparators = rangeList.map((comp) => new Comparator(comp, this.options));
        for (const comp of comparators) {
          if (isNullSet(comp)) {
            return [comp];
          }
          rangeMap.set(comp.value, comp);
        }
        if (rangeMap.size > 1 && rangeMap.has("")) {
          rangeMap.delete("");
        }
        const result = [...rangeMap.values()];
        cache.set(memoKey, result);
        return result;
      }
      intersects(range, options2) {
        if (!(range instanceof _Range)) {
          throw new TypeError("a Range is required");
        }
        return this.set.some((thisComparators) => {
          return isSatisfiable(thisComparators, options2) && range.set.some((rangeComparators) => {
            return isSatisfiable(rangeComparators, options2) && thisComparators.every((thisComparator) => {
              return rangeComparators.every((rangeComparator) => {
                return thisComparator.intersects(rangeComparator, options2);
              });
            });
          });
        });
      }
      // if ANY of the sets match ALL of its comparators, then pass
      test(version2) {
        if (!version2) {
          return false;
        }
        if (typeof version2 === "string") {
          try {
            version2 = new SemVer(version2, this.options);
          } catch (er) {
            return false;
          }
        }
        for (let i = 0; i < this.set.length; i++) {
          if (testSet(this.set[i], version2, this.options)) {
            return true;
          }
        }
        return false;
      }
    };
    module2.exports = Range11;
    var LRU = require_lrucache();
    var cache = new LRU();
    var parseOptions = require_parse_options();
    var Comparator = require_comparator();
    var debug = require_debug();
    var SemVer = require_semver();
    var {
      safeRe: re,
      t,
      comparatorTrimReplace,
      tildeTrimReplace,
      caretTrimReplace
    } = require_re();
    var { FLAG_INCLUDE_PRERELEASE, FLAG_LOOSE } = require_constants();
    var isNullSet = (c) => c.value === "<0.0.0-0";
    var isAny = (c) => c.value === "";
    var isSatisfiable = (comparators, options2) => {
      let result = true;
      const remainingComparators = comparators.slice();
      let testComparator = remainingComparators.pop();
      while (result && remainingComparators.length) {
        result = remainingComparators.every((otherComparator) => {
          return testComparator.intersects(otherComparator, options2);
        });
        testComparator = remainingComparators.pop();
      }
      return result;
    };
    var parseComparator = (comp, options2) => {
      comp = comp.replace(re[t.BUILD], "");
      debug("comp", comp, options2);
      comp = replaceCarets(comp, options2);
      debug("caret", comp);
      comp = replaceTildes(comp, options2);
      debug("tildes", comp);
      comp = replaceXRanges(comp, options2);
      debug("xrange", comp);
      comp = replaceStars(comp, options2);
      debug("stars", comp);
      return comp;
    };
    var isX = (id2) => !id2 || id2.toLowerCase() === "x" || id2 === "*";
    var replaceTildes = (comp, options2) => {
      return comp.trim().split(/\s+/).map((c) => replaceTilde(c, options2)).join(" ");
    };
    var replaceTilde = (comp, options2) => {
      const r = options2.loose ? re[t.TILDELOOSE] : re[t.TILDE];
      return comp.replace(r, (_, M, m, p, pr) => {
        debug("tilde", comp, _, M, m, p, pr);
        let ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m)) {
          ret = `>=${M}.0.0 <${+M + 1}.0.0-0`;
        } else if (isX(p)) {
          ret = `>=${M}.${m}.0 <${M}.${+m + 1}.0-0`;
        } else if (pr) {
          debug("replaceTilde pr", pr);
          ret = `>=${M}.${m}.${p}-${pr} <${M}.${+m + 1}.0-0`;
        } else {
          ret = `>=${M}.${m}.${p} <${M}.${+m + 1}.0-0`;
        }
        debug("tilde return", ret);
        return ret;
      });
    };
    var replaceCarets = (comp, options2) => {
      return comp.trim().split(/\s+/).map((c) => replaceCaret(c, options2)).join(" ");
    };
    var replaceCaret = (comp, options2) => {
      debug("caret", comp, options2);
      const r = options2.loose ? re[t.CARETLOOSE] : re[t.CARET];
      const z = options2.includePrerelease ? "-0" : "";
      return comp.replace(r, (_, M, m, p, pr) => {
        debug("caret", comp, _, M, m, p, pr);
        let ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m)) {
          ret = `>=${M}.0.0${z} <${+M + 1}.0.0-0`;
        } else if (isX(p)) {
          if (M === "0") {
            ret = `>=${M}.${m}.0${z} <${M}.${+m + 1}.0-0`;
          } else {
            ret = `>=${M}.${m}.0${z} <${+M + 1}.0.0-0`;
          }
        } else if (pr) {
          debug("replaceCaret pr", pr);
          if (M === "0") {
            if (m === "0") {
              ret = `>=${M}.${m}.${p}-${pr} <${M}.${m}.${+p + 1}-0`;
            } else {
              ret = `>=${M}.${m}.${p}-${pr} <${M}.${+m + 1}.0-0`;
            }
          } else {
            ret = `>=${M}.${m}.${p}-${pr} <${+M + 1}.0.0-0`;
          }
        } else {
          debug("no pr");
          if (M === "0") {
            if (m === "0") {
              ret = `>=${M}.${m}.${p}${z} <${M}.${m}.${+p + 1}-0`;
            } else {
              ret = `>=${M}.${m}.${p}${z} <${M}.${+m + 1}.0-0`;
            }
          } else {
            ret = `>=${M}.${m}.${p} <${+M + 1}.0.0-0`;
          }
        }
        debug("caret return", ret);
        return ret;
      });
    };
    var replaceXRanges = (comp, options2) => {
      debug("replaceXRanges", comp, options2);
      return comp.split(/\s+/).map((c) => replaceXRange(c, options2)).join(" ");
    };
    var replaceXRange = (comp, options2) => {
      comp = comp.trim();
      const r = options2.loose ? re[t.XRANGELOOSE] : re[t.XRANGE];
      return comp.replace(r, (ret, gtlt, M, m, p, pr) => {
        debug("xRange", comp, ret, gtlt, M, m, p, pr);
        const xM = isX(M);
        const xm = xM || isX(m);
        const xp = xm || isX(p);
        const anyX = xp;
        if (gtlt === "=" && anyX) {
          gtlt = "";
        }
        pr = options2.includePrerelease ? "-0" : "";
        if (xM) {
          if (gtlt === ">" || gtlt === "<") {
            ret = "<0.0.0-0";
          } else {
            ret = "*";
          }
        } else if (gtlt && anyX) {
          if (xm) {
            m = 0;
          }
          p = 0;
          if (gtlt === ">") {
            gtlt = ">=";
            if (xm) {
              M = +M + 1;
              m = 0;
              p = 0;
            } else {
              m = +m + 1;
              p = 0;
            }
          } else if (gtlt === "<=") {
            gtlt = "<";
            if (xm) {
              M = +M + 1;
            } else {
              m = +m + 1;
            }
          }
          if (gtlt === "<") {
            pr = "-0";
          }
          ret = `${gtlt + M}.${m}.${p}${pr}`;
        } else if (xm) {
          ret = `>=${M}.0.0${pr} <${+M + 1}.0.0-0`;
        } else if (xp) {
          ret = `>=${M}.${m}.0${pr} <${M}.${+m + 1}.0-0`;
        }
        debug("xRange return", ret);
        return ret;
      });
    };
    var replaceStars = (comp, options2) => {
      debug("replaceStars", comp, options2);
      return comp.trim().replace(re[t.STAR], "");
    };
    var replaceGTE0 = (comp, options2) => {
      debug("replaceGTE0", comp, options2);
      return comp.trim().replace(re[options2.includePrerelease ? t.GTE0PRE : t.GTE0], "");
    };
    var hyphenReplace = (incPr) => ($0, from, fM, fm, fp, fpr, fb, to, tM, tm, tp, tpr) => {
      if (isX(fM)) {
        from = "";
      } else if (isX(fm)) {
        from = `>=${fM}.0.0${incPr ? "-0" : ""}`;
      } else if (isX(fp)) {
        from = `>=${fM}.${fm}.0${incPr ? "-0" : ""}`;
      } else if (fpr) {
        from = `>=${from}`;
      } else {
        from = `>=${from}${incPr ? "-0" : ""}`;
      }
      if (isX(tM)) {
        to = "";
      } else if (isX(tm)) {
        to = `<${+tM + 1}.0.0-0`;
      } else if (isX(tp)) {
        to = `<${tM}.${+tm + 1}.0-0`;
      } else if (tpr) {
        to = `<=${tM}.${tm}.${tp}-${tpr}`;
      } else if (incPr) {
        to = `<${tM}.${tm}.${+tp + 1}-0`;
      } else {
        to = `<=${to}`;
      }
      return `${from} ${to}`.trim();
    };
    var testSet = (set, version2, options2) => {
      for (let i = 0; i < set.length; i++) {
        if (!set[i].test(version2)) {
          return false;
        }
      }
      if (version2.prerelease.length && !options2.includePrerelease) {
        for (let i = 0; i < set.length; i++) {
          debug(set[i].semver);
          if (set[i].semver === Comparator.ANY) {
            continue;
          }
          if (set[i].semver.prerelease.length > 0) {
            const allowed = set[i].semver;
            if (allowed.major === version2.major && allowed.minor === version2.minor && allowed.patch === version2.patch) {
              return true;
            }
          }
        }
        return false;
      }
      return true;
    };
  }
});

// node_modules/semver/classes/comparator.js
var require_comparator = __commonJS({
  "node_modules/semver/classes/comparator.js"(exports2, module2) {
    "use strict";
    var ANY = Symbol("SemVer ANY");
    var Comparator = class _Comparator {
      static get ANY() {
        return ANY;
      }
      constructor(comp, options2) {
        options2 = parseOptions(options2);
        if (comp instanceof _Comparator) {
          if (comp.loose === !!options2.loose) {
            return comp;
          } else {
            comp = comp.value;
          }
        }
        comp = comp.trim().split(/\s+/).join(" ");
        debug("comparator", comp, options2);
        this.options = options2;
        this.loose = !!options2.loose;
        this.parse(comp);
        if (this.semver === ANY) {
          this.value = "";
        } else {
          this.value = this.operator + this.semver.version;
        }
        debug("comp", this);
      }
      parse(comp) {
        const r = this.options.loose ? re[t.COMPARATORLOOSE] : re[t.COMPARATOR];
        const m = comp.match(r);
        if (!m) {
          throw new TypeError(`Invalid comparator: ${comp}`);
        }
        this.operator = m[1] !== void 0 ? m[1] : "";
        if (this.operator === "=") {
          this.operator = "";
        }
        if (!m[2]) {
          this.semver = ANY;
        } else {
          this.semver = new SemVer(m[2], this.options.loose);
        }
      }
      toString() {
        return this.value;
      }
      test(version2) {
        debug("Comparator.test", version2, this.options.loose);
        if (this.semver === ANY || version2 === ANY) {
          return true;
        }
        if (typeof version2 === "string") {
          try {
            version2 = new SemVer(version2, this.options);
          } catch (er) {
            return false;
          }
        }
        return cmp(version2, this.operator, this.semver, this.options);
      }
      intersects(comp, options2) {
        if (!(comp instanceof _Comparator)) {
          throw new TypeError("a Comparator is required");
        }
        if (this.operator === "") {
          if (this.value === "") {
            return true;
          }
          return new Range11(comp.value, options2).test(this.value);
        } else if (comp.operator === "") {
          if (comp.value === "") {
            return true;
          }
          return new Range11(this.value, options2).test(comp.semver);
        }
        options2 = parseOptions(options2);
        if (options2.includePrerelease && (this.value === "<0.0.0-0" || comp.value === "<0.0.0-0")) {
          return false;
        }
        if (!options2.includePrerelease && (this.value.startsWith("<0.0.0") || comp.value.startsWith("<0.0.0"))) {
          return false;
        }
        if (this.operator.startsWith(">") && comp.operator.startsWith(">")) {
          return true;
        }
        if (this.operator.startsWith("<") && comp.operator.startsWith("<")) {
          return true;
        }
        if (this.semver.version === comp.semver.version && this.operator.includes("=") && comp.operator.includes("=")) {
          return true;
        }
        if (cmp(this.semver, "<", comp.semver, options2) && this.operator.startsWith(">") && comp.operator.startsWith("<")) {
          return true;
        }
        if (cmp(this.semver, ">", comp.semver, options2) && this.operator.startsWith("<") && comp.operator.startsWith(">")) {
          return true;
        }
        return false;
      }
    };
    module2.exports = Comparator;
    var parseOptions = require_parse_options();
    var { safeRe: re, t } = require_re();
    var cmp = require_cmp();
    var debug = require_debug();
    var SemVer = require_semver();
    var Range11 = require_range();
  }
});

// node_modules/semver/functions/satisfies.js
var require_satisfies = __commonJS({
  "node_modules/semver/functions/satisfies.js"(exports2, module2) {
    "use strict";
    var Range11 = require_range();
    var satisfies = (version2, range, options2) => {
      try {
        range = new Range11(range, options2);
      } catch (er) {
        return false;
      }
      return range.test(version2);
    };
    module2.exports = satisfies;
  }
});

// node_modules/semver/ranges/to-comparators.js
var require_to_comparators = __commonJS({
  "node_modules/semver/ranges/to-comparators.js"(exports2, module2) {
    "use strict";
    var Range11 = require_range();
    var toComparators = (range, options2) => new Range11(range, options2).set.map((comp) => comp.map((c) => c.value).join(" ").trim().split(" "));
    module2.exports = toComparators;
  }
});

// node_modules/semver/ranges/max-satisfying.js
var require_max_satisfying = __commonJS({
  "node_modules/semver/ranges/max-satisfying.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var Range11 = require_range();
    var maxSatisfying = (versions, range, options2) => {
      let max = null;
      let maxSV = null;
      let rangeObj = null;
      try {
        rangeObj = new Range11(range, options2);
      } catch (er) {
        return null;
      }
      versions.forEach((v) => {
        if (rangeObj.test(v)) {
          if (!max || maxSV.compare(v) === -1) {
            max = v;
            maxSV = new SemVer(max, options2);
          }
        }
      });
      return max;
    };
    module2.exports = maxSatisfying;
  }
});

// node_modules/semver/ranges/min-satisfying.js
var require_min_satisfying = __commonJS({
  "node_modules/semver/ranges/min-satisfying.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var Range11 = require_range();
    var minSatisfying = (versions, range, options2) => {
      let min = null;
      let minSV = null;
      let rangeObj = null;
      try {
        rangeObj = new Range11(range, options2);
      } catch (er) {
        return null;
      }
      versions.forEach((v) => {
        if (rangeObj.test(v)) {
          if (!min || minSV.compare(v) === 1) {
            min = v;
            minSV = new SemVer(min, options2);
          }
        }
      });
      return min;
    };
    module2.exports = minSatisfying;
  }
});

// node_modules/semver/ranges/min-version.js
var require_min_version = __commonJS({
  "node_modules/semver/ranges/min-version.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var Range11 = require_range();
    var gt = require_gt();
    var minVersion = (range, loose) => {
      range = new Range11(range, loose);
      let minver = new SemVer("0.0.0");
      if (range.test(minver)) {
        return minver;
      }
      minver = new SemVer("0.0.0-0");
      if (range.test(minver)) {
        return minver;
      }
      minver = null;
      for (let i = 0; i < range.set.length; ++i) {
        const comparators = range.set[i];
        let setMin = null;
        comparators.forEach((comparator) => {
          const compver = new SemVer(comparator.semver.version);
          switch (comparator.operator) {
            case ">":
              if (compver.prerelease.length === 0) {
                compver.patch++;
              } else {
                compver.prerelease.push(0);
              }
              compver.raw = compver.format();
            /* fallthrough */
            case "":
            case ">=":
              if (!setMin || gt(compver, setMin)) {
                setMin = compver;
              }
              break;
            case "<":
            case "<=":
              break;
            /* istanbul ignore next */
            default:
              throw new Error(`Unexpected operation: ${comparator.operator}`);
          }
        });
        if (setMin && (!minver || gt(minver, setMin))) {
          minver = setMin;
        }
      }
      if (minver && range.test(minver)) {
        return minver;
      }
      return null;
    };
    module2.exports = minVersion;
  }
});

// node_modules/semver/ranges/valid.js
var require_valid2 = __commonJS({
  "node_modules/semver/ranges/valid.js"(exports2, module2) {
    "use strict";
    var Range11 = require_range();
    var validRange = (range, options2) => {
      try {
        return new Range11(range, options2).range || "*";
      } catch (er) {
        return null;
      }
    };
    module2.exports = validRange;
  }
});

// node_modules/semver/ranges/outside.js
var require_outside = __commonJS({
  "node_modules/semver/ranges/outside.js"(exports2, module2) {
    "use strict";
    var SemVer = require_semver();
    var Comparator = require_comparator();
    var { ANY } = Comparator;
    var Range11 = require_range();
    var satisfies = require_satisfies();
    var gt = require_gt();
    var lt = require_lt();
    var lte = require_lte();
    var gte = require_gte();
    var outside = (version2, range, hilo, options2) => {
      version2 = new SemVer(version2, options2);
      range = new Range11(range, options2);
      let gtfn, ltefn, ltfn, comp, ecomp;
      switch (hilo) {
        case ">":
          gtfn = gt;
          ltefn = lte;
          ltfn = lt;
          comp = ">";
          ecomp = ">=";
          break;
        case "<":
          gtfn = lt;
          ltefn = gte;
          ltfn = gt;
          comp = "<";
          ecomp = "<=";
          break;
        default:
          throw new TypeError('Must provide a hilo val of "<" or ">"');
      }
      if (satisfies(version2, range, options2)) {
        return false;
      }
      for (let i = 0; i < range.set.length; ++i) {
        const comparators = range.set[i];
        let high = null;
        let low = null;
        comparators.forEach((comparator) => {
          if (comparator.semver === ANY) {
            comparator = new Comparator(">=0.0.0");
          }
          high = high || comparator;
          low = low || comparator;
          if (gtfn(comparator.semver, high.semver, options2)) {
            high = comparator;
          } else if (ltfn(comparator.semver, low.semver, options2)) {
            low = comparator;
          }
        });
        if (high.operator === comp || high.operator === ecomp) {
          return false;
        }
        if ((!low.operator || low.operator === comp) && ltefn(version2, low.semver)) {
          return false;
        } else if (low.operator === ecomp && ltfn(version2, low.semver)) {
          return false;
        }
      }
      return true;
    };
    module2.exports = outside;
  }
});

// node_modules/semver/ranges/gtr.js
var require_gtr = __commonJS({
  "node_modules/semver/ranges/gtr.js"(exports2, module2) {
    "use strict";
    var outside = require_outside();
    var gtr = (version2, range, options2) => outside(version2, range, ">", options2);
    module2.exports = gtr;
  }
});

// node_modules/semver/ranges/ltr.js
var require_ltr = __commonJS({
  "node_modules/semver/ranges/ltr.js"(exports2, module2) {
    "use strict";
    var outside = require_outside();
    var ltr = (version2, range, options2) => outside(version2, range, "<", options2);
    module2.exports = ltr;
  }
});

// node_modules/semver/ranges/intersects.js
var require_intersects = __commonJS({
  "node_modules/semver/ranges/intersects.js"(exports2, module2) {
    "use strict";
    var Range11 = require_range();
    var intersects = (r1, r2, options2) => {
      r1 = new Range11(r1, options2);
      r2 = new Range11(r2, options2);
      return r1.intersects(r2, options2);
    };
    module2.exports = intersects;
  }
});

// node_modules/semver/ranges/simplify.js
var require_simplify = __commonJS({
  "node_modules/semver/ranges/simplify.js"(exports2, module2) {
    "use strict";
    var satisfies = require_satisfies();
    var compare2 = require_compare();
    module2.exports = (versions, range, options2) => {
      const set = [];
      let first = null;
      let prev = null;
      const v = versions.sort((a, b) => compare2(a, b, options2));
      for (const version2 of v) {
        const included = satisfies(version2, range, options2);
        if (included) {
          prev = version2;
          if (!first) {
            first = version2;
          }
        } else {
          if (prev) {
            set.push([first, prev]);
          }
          prev = null;
          first = null;
        }
      }
      if (first) {
        set.push([first, null]);
      }
      const ranges = [];
      for (const [min, max] of set) {
        if (min === max) {
          ranges.push(min);
        } else if (!max && min === v[0]) {
          ranges.push("*");
        } else if (!max) {
          ranges.push(`>=${min}`);
        } else if (min === v[0]) {
          ranges.push(`<=${max}`);
        } else {
          ranges.push(`${min} - ${max}`);
        }
      }
      const simplified = ranges.join(" || ");
      const original = typeof range.raw === "string" ? range.raw : String(range);
      return simplified.length < original.length ? simplified : range;
    };
  }
});

// node_modules/semver/ranges/subset.js
var require_subset = __commonJS({
  "node_modules/semver/ranges/subset.js"(exports2, module2) {
    "use strict";
    var Range11 = require_range();
    var Comparator = require_comparator();
    var { ANY } = Comparator;
    var satisfies = require_satisfies();
    var compare2 = require_compare();
    var subset = (sub, dom, options2 = {}) => {
      if (sub === dom) {
        return true;
      }
      sub = new Range11(sub, options2);
      dom = new Range11(dom, options2);
      let sawNonNull = false;
      OUTER: for (const simpleSub of sub.set) {
        for (const simpleDom of dom.set) {
          const isSub = simpleSubset(simpleSub, simpleDom, options2);
          sawNonNull = sawNonNull || isSub !== null;
          if (isSub) {
            continue OUTER;
          }
        }
        if (sawNonNull) {
          return false;
        }
      }
      return true;
    };
    var minimumVersionWithPreRelease = [new Comparator(">=0.0.0-0")];
    var minimumVersion = [new Comparator(">=0.0.0")];
    var simpleSubset = (sub, dom, options2) => {
      if (sub === dom) {
        return true;
      }
      if (sub.length === 1 && sub[0].semver === ANY) {
        if (dom.length === 1 && dom[0].semver === ANY) {
          return true;
        } else if (options2.includePrerelease) {
          sub = minimumVersionWithPreRelease;
        } else {
          sub = minimumVersion;
        }
      }
      if (dom.length === 1 && dom[0].semver === ANY) {
        if (options2.includePrerelease) {
          return true;
        } else {
          dom = minimumVersion;
        }
      }
      const eqSet = /* @__PURE__ */ new Set();
      let gt, lt;
      for (const c of sub) {
        if (c.operator === ">" || c.operator === ">=") {
          gt = higherGT(gt, c, options2);
        } else if (c.operator === "<" || c.operator === "<=") {
          lt = lowerLT(lt, c, options2);
        } else {
          eqSet.add(c.semver);
        }
      }
      if (eqSet.size > 1) {
        return null;
      }
      let gtltComp;
      if (gt && lt) {
        gtltComp = compare2(gt.semver, lt.semver, options2);
        if (gtltComp > 0) {
          return null;
        } else if (gtltComp === 0 && (gt.operator !== ">=" || lt.operator !== "<=")) {
          return null;
        }
      }
      for (const eq of eqSet) {
        if (gt && !satisfies(eq, String(gt), options2)) {
          return null;
        }
        if (lt && !satisfies(eq, String(lt), options2)) {
          return null;
        }
        for (const c of dom) {
          if (!satisfies(eq, String(c), options2)) {
            return false;
          }
        }
        return true;
      }
      let higher, lower;
      let hasDomLT, hasDomGT;
      let needDomLTPre = lt && !options2.includePrerelease && lt.semver.prerelease.length ? lt.semver : false;
      let needDomGTPre = gt && !options2.includePrerelease && gt.semver.prerelease.length ? gt.semver : false;
      if (needDomLTPre && needDomLTPre.prerelease.length === 1 && lt.operator === "<" && needDomLTPre.prerelease[0] === 0) {
        needDomLTPre = false;
      }
      for (const c of dom) {
        hasDomGT = hasDomGT || c.operator === ">" || c.operator === ">=";
        hasDomLT = hasDomLT || c.operator === "<" || c.operator === "<=";
        if (gt) {
          if (needDomGTPre) {
            if (c.semver.prerelease && c.semver.prerelease.length && c.semver.major === needDomGTPre.major && c.semver.minor === needDomGTPre.minor && c.semver.patch === needDomGTPre.patch) {
              needDomGTPre = false;
            }
          }
          if (c.operator === ">" || c.operator === ">=") {
            higher = higherGT(gt, c, options2);
            if (higher === c && higher !== gt) {
              return false;
            }
          } else if (gt.operator === ">=" && !satisfies(gt.semver, String(c), options2)) {
            return false;
          }
        }
        if (lt) {
          if (needDomLTPre) {
            if (c.semver.prerelease && c.semver.prerelease.length && c.semver.major === needDomLTPre.major && c.semver.minor === needDomLTPre.minor && c.semver.patch === needDomLTPre.patch) {
              needDomLTPre = false;
            }
          }
          if (c.operator === "<" || c.operator === "<=") {
            lower = lowerLT(lt, c, options2);
            if (lower === c && lower !== lt) {
              return false;
            }
          } else if (lt.operator === "<=" && !satisfies(lt.semver, String(c), options2)) {
            return false;
          }
        }
        if (!c.operator && (lt || gt) && gtltComp !== 0) {
          return false;
        }
      }
      if (gt && hasDomLT && !lt && gtltComp !== 0) {
        return false;
      }
      if (lt && hasDomGT && !gt && gtltComp !== 0) {
        return false;
      }
      if (needDomGTPre || needDomLTPre) {
        return false;
      }
      return true;
    };
    var higherGT = (a, b, options2) => {
      if (!a) {
        return b;
      }
      const comp = compare2(a.semver, b.semver, options2);
      return comp > 0 ? a : comp < 0 ? b : b.operator === ">" && a.operator === ">=" ? b : a;
    };
    var lowerLT = (a, b, options2) => {
      if (!a) {
        return b;
      }
      const comp = compare2(a.semver, b.semver, options2);
      return comp < 0 ? a : comp > 0 ? b : b.operator === "<" && a.operator === "<=" ? b : a;
    };
    module2.exports = subset;
  }
});

// node_modules/semver/index.js
var require_semver2 = __commonJS({
  "node_modules/semver/index.js"(exports2, module2) {
    "use strict";
    var internalRe = require_re();
    var constants = require_constants();
    var SemVer = require_semver();
    var identifiers = require_identifiers();
    var parse3 = require_parse();
    var valid = require_valid();
    var clean = require_clean();
    var inc = require_inc();
    var diff = require_diff();
    var major = require_major();
    var minor = require_minor();
    var patch = require_patch();
    var prerelease = require_prerelease();
    var compare2 = require_compare();
    var rcompare = require_rcompare();
    var compareLoose = require_compare_loose();
    var compareBuild = require_compare_build();
    var sort = require_sort();
    var rsort = require_rsort();
    var gt = require_gt();
    var lt = require_lt();
    var eq = require_eq();
    var neq = require_neq();
    var gte = require_gte();
    var lte = require_lte();
    var cmp = require_cmp();
    var coerce = require_coerce();
    var Comparator = require_comparator();
    var Range11 = require_range();
    var satisfies = require_satisfies();
    var toComparators = require_to_comparators();
    var maxSatisfying = require_max_satisfying();
    var minSatisfying = require_min_satisfying();
    var minVersion = require_min_version();
    var validRange = require_valid2();
    var outside = require_outside();
    var gtr = require_gtr();
    var ltr = require_ltr();
    var intersects = require_intersects();
    var simplifyRange = require_simplify();
    var subset = require_subset();
    module2.exports = {
      parse: parse3,
      valid,
      clean,
      inc,
      diff,
      major,
      minor,
      patch,
      prerelease,
      compare: compare2,
      rcompare,
      compareLoose,
      compareBuild,
      sort,
      rsort,
      gt,
      lt,
      eq,
      neq,
      gte,
      lte,
      cmp,
      coerce,
      Comparator,
      Range: Range11,
      satisfies,
      toComparators,
      maxSatisfying,
      minSatisfying,
      minVersion,
      validRange,
      outside,
      gtr,
      ltr,
      intersects,
      simplifyRange,
      subset,
      SemVer,
      re: internalRe.re,
      src: internalRe.src,
      tokens: internalRe.t,
      SEMVER_SPEC_VERSION: constants.SEMVER_SPEC_VERSION,
      RELEASE_TYPES: constants.RELEASE_TYPES,
      compareIdentifiers: identifiers.compareIdentifiers,
      rcompareIdentifiers: identifiers.rcompareIdentifiers
    };
  }
});

// node_modules/ansi-regex/index.js
var require_ansi_regex = __commonJS({
  "node_modules/ansi-regex/index.js"(exports2, module2) {
    "use strict";
    module2.exports = ({ onlyFirst = false } = {}) => {
      const pattern = [
        "[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]+)*|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)",
        "(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))"
      ].join("|");
      return new RegExp(pattern, onlyFirst ? void 0 : "g");
    };
  }
});

// node_modules/strip-ansi/index.js
var require_strip_ansi = __commonJS({
  "node_modules/strip-ansi/index.js"(exports2, module2) {
    "use strict";
    var ansiRegex = require_ansi_regex();
    module2.exports = (string2) => typeof string2 === "string" ? string2.replace(ansiRegex(), "") : string2;
  }
});

// node_modules/fast-diff/diff.js
var require_diff2 = __commonJS({
  "node_modules/fast-diff/diff.js"(exports2, module2) {
    var DIFF_DELETE = -1;
    var DIFF_INSERT = 1;
    var DIFF_EQUAL = 0;
    function diff_main(text1, text2, cursor_pos, cleanup, _fix_unicode) {
      if (text1 === text2) {
        if (text1) {
          return [[DIFF_EQUAL, text1]];
        }
        return [];
      }
      if (cursor_pos != null) {
        var editdiff = find_cursor_edit_diff(text1, text2, cursor_pos);
        if (editdiff) {
          return editdiff;
        }
      }
      var commonlength = diff_commonPrefix(text1, text2);
      var commonprefix = text1.substring(0, commonlength);
      text1 = text1.substring(commonlength);
      text2 = text2.substring(commonlength);
      commonlength = diff_commonSuffix(text1, text2);
      var commonsuffix = text1.substring(text1.length - commonlength);
      text1 = text1.substring(0, text1.length - commonlength);
      text2 = text2.substring(0, text2.length - commonlength);
      var diffs = diff_compute_(text1, text2);
      if (commonprefix) {
        diffs.unshift([DIFF_EQUAL, commonprefix]);
      }
      if (commonsuffix) {
        diffs.push([DIFF_EQUAL, commonsuffix]);
      }
      diff_cleanupMerge(diffs, _fix_unicode);
      if (cleanup) {
        diff_cleanupSemantic(diffs);
      }
      return diffs;
    }
    function diff_compute_(text1, text2) {
      var diffs;
      if (!text1) {
        return [[DIFF_INSERT, text2]];
      }
      if (!text2) {
        return [[DIFF_DELETE, text1]];
      }
      var longtext = text1.length > text2.length ? text1 : text2;
      var shorttext = text1.length > text2.length ? text2 : text1;
      var i = longtext.indexOf(shorttext);
      if (i !== -1) {
        diffs = [
          [DIFF_INSERT, longtext.substring(0, i)],
          [DIFF_EQUAL, shorttext],
          [DIFF_INSERT, longtext.substring(i + shorttext.length)]
        ];
        if (text1.length > text2.length) {
          diffs[0][0] = diffs[2][0] = DIFF_DELETE;
        }
        return diffs;
      }
      if (shorttext.length === 1) {
        return [
          [DIFF_DELETE, text1],
          [DIFF_INSERT, text2]
        ];
      }
      var hm = diff_halfMatch_(text1, text2);
      if (hm) {
        var text1_a = hm[0];
        var text1_b = hm[1];
        var text2_a = hm[2];
        var text2_b = hm[3];
        var mid_common = hm[4];
        var diffs_a = diff_main(text1_a, text2_a);
        var diffs_b = diff_main(text1_b, text2_b);
        return diffs_a.concat([[DIFF_EQUAL, mid_common]], diffs_b);
      }
      return diff_bisect_(text1, text2);
    }
    function diff_bisect_(text1, text2) {
      var text1_length = text1.length;
      var text2_length = text2.length;
      var max_d = Math.ceil((text1_length + text2_length) / 2);
      var v_offset = max_d;
      var v_length = 2 * max_d;
      var v12 = new Array(v_length);
      var v2 = new Array(v_length);
      for (var x = 0; x < v_length; x++) {
        v12[x] = -1;
        v2[x] = -1;
      }
      v12[v_offset + 1] = 0;
      v2[v_offset + 1] = 0;
      var delta = text1_length - text2_length;
      var front = delta % 2 !== 0;
      var k1start = 0;
      var k1end = 0;
      var k2start = 0;
      var k2end = 0;
      for (var d = 0; d < max_d; d++) {
        for (var k1 = -d + k1start; k1 <= d - k1end; k1 += 2) {
          var k1_offset = v_offset + k1;
          var x1;
          if (k1 === -d || k1 !== d && v12[k1_offset - 1] < v12[k1_offset + 1]) {
            x1 = v12[k1_offset + 1];
          } else {
            x1 = v12[k1_offset - 1] + 1;
          }
          var y1 = x1 - k1;
          while (x1 < text1_length && y1 < text2_length && text1.charAt(x1) === text2.charAt(y1)) {
            x1++;
            y1++;
          }
          v12[k1_offset] = x1;
          if (x1 > text1_length) {
            k1end += 2;
          } else if (y1 > text2_length) {
            k1start += 2;
          } else if (front) {
            var k2_offset = v_offset + delta - k1;
            if (k2_offset >= 0 && k2_offset < v_length && v2[k2_offset] !== -1) {
              var x2 = text1_length - v2[k2_offset];
              if (x1 >= x2) {
                return diff_bisectSplit_(text1, text2, x1, y1);
              }
            }
          }
        }
        for (var k2 = -d + k2start; k2 <= d - k2end; k2 += 2) {
          var k2_offset = v_offset + k2;
          var x2;
          if (k2 === -d || k2 !== d && v2[k2_offset - 1] < v2[k2_offset + 1]) {
            x2 = v2[k2_offset + 1];
          } else {
            x2 = v2[k2_offset - 1] + 1;
          }
          var y2 = x2 - k2;
          while (x2 < text1_length && y2 < text2_length && text1.charAt(text1_length - x2 - 1) === text2.charAt(text2_length - y2 - 1)) {
            x2++;
            y2++;
          }
          v2[k2_offset] = x2;
          if (x2 > text1_length) {
            k2end += 2;
          } else if (y2 > text2_length) {
            k2start += 2;
          } else if (!front) {
            var k1_offset = v_offset + delta - k2;
            if (k1_offset >= 0 && k1_offset < v_length && v12[k1_offset] !== -1) {
              var x1 = v12[k1_offset];
              var y1 = v_offset + x1 - k1_offset;
              x2 = text1_length - x2;
              if (x1 >= x2) {
                return diff_bisectSplit_(text1, text2, x1, y1);
              }
            }
          }
        }
      }
      return [
        [DIFF_DELETE, text1],
        [DIFF_INSERT, text2]
      ];
    }
    function diff_bisectSplit_(text1, text2, x, y) {
      var text1a = text1.substring(0, x);
      var text2a = text2.substring(0, y);
      var text1b = text1.substring(x);
      var text2b = text2.substring(y);
      var diffs = diff_main(text1a, text2a);
      var diffsb = diff_main(text1b, text2b);
      return diffs.concat(diffsb);
    }
    function diff_commonPrefix(text1, text2) {
      if (!text1 || !text2 || text1.charAt(0) !== text2.charAt(0)) {
        return 0;
      }
      var pointermin = 0;
      var pointermax = Math.min(text1.length, text2.length);
      var pointermid = pointermax;
      var pointerstart = 0;
      while (pointermin < pointermid) {
        if (text1.substring(pointerstart, pointermid) == text2.substring(pointerstart, pointermid)) {
          pointermin = pointermid;
          pointerstart = pointermin;
        } else {
          pointermax = pointermid;
        }
        pointermid = Math.floor((pointermax - pointermin) / 2 + pointermin);
      }
      if (is_surrogate_pair_start(text1.charCodeAt(pointermid - 1))) {
        pointermid--;
      }
      return pointermid;
    }
    function diff_commonOverlap_(text1, text2) {
      var text1_length = text1.length;
      var text2_length = text2.length;
      if (text1_length == 0 || text2_length == 0) {
        return 0;
      }
      if (text1_length > text2_length) {
        text1 = text1.substring(text1_length - text2_length);
      } else if (text1_length < text2_length) {
        text2 = text2.substring(0, text1_length);
      }
      var text_length = Math.min(text1_length, text2_length);
      if (text1 == text2) {
        return text_length;
      }
      var best = 0;
      var length = 1;
      while (true) {
        var pattern = text1.substring(text_length - length);
        var found = text2.indexOf(pattern);
        if (found == -1) {
          return best;
        }
        length += found;
        if (found == 0 || text1.substring(text_length - length) == text2.substring(0, length)) {
          best = length;
          length++;
        }
      }
    }
    function diff_commonSuffix(text1, text2) {
      if (!text1 || !text2 || text1.slice(-1) !== text2.slice(-1)) {
        return 0;
      }
      var pointermin = 0;
      var pointermax = Math.min(text1.length, text2.length);
      var pointermid = pointermax;
      var pointerend = 0;
      while (pointermin < pointermid) {
        if (text1.substring(text1.length - pointermid, text1.length - pointerend) == text2.substring(text2.length - pointermid, text2.length - pointerend)) {
          pointermin = pointermid;
          pointerend = pointermin;
        } else {
          pointermax = pointermid;
        }
        pointermid = Math.floor((pointermax - pointermin) / 2 + pointermin);
      }
      if (is_surrogate_pair_end(text1.charCodeAt(text1.length - pointermid))) {
        pointermid--;
      }
      return pointermid;
    }
    function diff_halfMatch_(text1, text2) {
      var longtext = text1.length > text2.length ? text1 : text2;
      var shorttext = text1.length > text2.length ? text2 : text1;
      if (longtext.length < 4 || shorttext.length * 2 < longtext.length) {
        return null;
      }
      function diff_halfMatchI_(longtext2, shorttext2, i) {
        var seed = longtext2.substring(i, i + Math.floor(longtext2.length / 4));
        var j = -1;
        var best_common = "";
        var best_longtext_a, best_longtext_b, best_shorttext_a, best_shorttext_b;
        while ((j = shorttext2.indexOf(seed, j + 1)) !== -1) {
          var prefixLength = diff_commonPrefix(
            longtext2.substring(i),
            shorttext2.substring(j)
          );
          var suffixLength = diff_commonSuffix(
            longtext2.substring(0, i),
            shorttext2.substring(0, j)
          );
          if (best_common.length < suffixLength + prefixLength) {
            best_common = shorttext2.substring(j - suffixLength, j) + shorttext2.substring(j, j + prefixLength);
            best_longtext_a = longtext2.substring(0, i - suffixLength);
            best_longtext_b = longtext2.substring(i + prefixLength);
            best_shorttext_a = shorttext2.substring(0, j - suffixLength);
            best_shorttext_b = shorttext2.substring(j + prefixLength);
          }
        }
        if (best_common.length * 2 >= longtext2.length) {
          return [
            best_longtext_a,
            best_longtext_b,
            best_shorttext_a,
            best_shorttext_b,
            best_common
          ];
        } else {
          return null;
        }
      }
      var hm1 = diff_halfMatchI_(
        longtext,
        shorttext,
        Math.ceil(longtext.length / 4)
      );
      var hm2 = diff_halfMatchI_(
        longtext,
        shorttext,
        Math.ceil(longtext.length / 2)
      );
      var hm;
      if (!hm1 && !hm2) {
        return null;
      } else if (!hm2) {
        hm = hm1;
      } else if (!hm1) {
        hm = hm2;
      } else {
        hm = hm1[4].length > hm2[4].length ? hm1 : hm2;
      }
      var text1_a, text1_b, text2_a, text2_b;
      if (text1.length > text2.length) {
        text1_a = hm[0];
        text1_b = hm[1];
        text2_a = hm[2];
        text2_b = hm[3];
      } else {
        text2_a = hm[0];
        text2_b = hm[1];
        text1_a = hm[2];
        text1_b = hm[3];
      }
      var mid_common = hm[4];
      return [text1_a, text1_b, text2_a, text2_b, mid_common];
    }
    function diff_cleanupSemantic(diffs) {
      var changes = false;
      var equalities = [];
      var equalitiesLength = 0;
      var lastequality = null;
      var pointer = 0;
      var length_insertions1 = 0;
      var length_deletions1 = 0;
      var length_insertions2 = 0;
      var length_deletions2 = 0;
      while (pointer < diffs.length) {
        if (diffs[pointer][0] == DIFF_EQUAL) {
          equalities[equalitiesLength++] = pointer;
          length_insertions1 = length_insertions2;
          length_deletions1 = length_deletions2;
          length_insertions2 = 0;
          length_deletions2 = 0;
          lastequality = diffs[pointer][1];
        } else {
          if (diffs[pointer][0] == DIFF_INSERT) {
            length_insertions2 += diffs[pointer][1].length;
          } else {
            length_deletions2 += diffs[pointer][1].length;
          }
          if (lastequality && lastequality.length <= Math.max(length_insertions1, length_deletions1) && lastequality.length <= Math.max(length_insertions2, length_deletions2)) {
            diffs.splice(equalities[equalitiesLength - 1], 0, [
              DIFF_DELETE,
              lastequality
            ]);
            diffs[equalities[equalitiesLength - 1] + 1][0] = DIFF_INSERT;
            equalitiesLength--;
            equalitiesLength--;
            pointer = equalitiesLength > 0 ? equalities[equalitiesLength - 1] : -1;
            length_insertions1 = 0;
            length_deletions1 = 0;
            length_insertions2 = 0;
            length_deletions2 = 0;
            lastequality = null;
            changes = true;
          }
        }
        pointer++;
      }
      if (changes) {
        diff_cleanupMerge(diffs);
      }
      diff_cleanupSemanticLossless(diffs);
      pointer = 1;
      while (pointer < diffs.length) {
        if (diffs[pointer - 1][0] == DIFF_DELETE && diffs[pointer][0] == DIFF_INSERT) {
          var deletion = diffs[pointer - 1][1];
          var insertion = diffs[pointer][1];
          var overlap_length1 = diff_commonOverlap_(deletion, insertion);
          var overlap_length2 = diff_commonOverlap_(insertion, deletion);
          if (overlap_length1 >= overlap_length2) {
            if (overlap_length1 >= deletion.length / 2 || overlap_length1 >= insertion.length / 2) {
              diffs.splice(pointer, 0, [
                DIFF_EQUAL,
                insertion.substring(0, overlap_length1)
              ]);
              diffs[pointer - 1][1] = deletion.substring(
                0,
                deletion.length - overlap_length1
              );
              diffs[pointer + 1][1] = insertion.substring(overlap_length1);
              pointer++;
            }
          } else {
            if (overlap_length2 >= deletion.length / 2 || overlap_length2 >= insertion.length / 2) {
              diffs.splice(pointer, 0, [
                DIFF_EQUAL,
                deletion.substring(0, overlap_length2)
              ]);
              diffs[pointer - 1][0] = DIFF_INSERT;
              diffs[pointer - 1][1] = insertion.substring(
                0,
                insertion.length - overlap_length2
              );
              diffs[pointer + 1][0] = DIFF_DELETE;
              diffs[pointer + 1][1] = deletion.substring(overlap_length2);
              pointer++;
            }
          }
          pointer++;
        }
        pointer++;
      }
    }
    var nonAlphaNumericRegex_ = /[^a-zA-Z0-9]/;
    var whitespaceRegex_ = /\s/;
    var linebreakRegex_ = /[\r\n]/;
    var blanklineEndRegex_ = /\n\r?\n$/;
    var blanklineStartRegex_ = /^\r?\n\r?\n/;
    function diff_cleanupSemanticLossless(diffs) {
      function diff_cleanupSemanticScore_(one, two) {
        if (!one || !two) {
          return 6;
        }
        var char1 = one.charAt(one.length - 1);
        var char2 = two.charAt(0);
        var nonAlphaNumeric1 = char1.match(nonAlphaNumericRegex_);
        var nonAlphaNumeric2 = char2.match(nonAlphaNumericRegex_);
        var whitespace1 = nonAlphaNumeric1 && char1.match(whitespaceRegex_);
        var whitespace2 = nonAlphaNumeric2 && char2.match(whitespaceRegex_);
        var lineBreak1 = whitespace1 && char1.match(linebreakRegex_);
        var lineBreak2 = whitespace2 && char2.match(linebreakRegex_);
        var blankLine1 = lineBreak1 && one.match(blanklineEndRegex_);
        var blankLine2 = lineBreak2 && two.match(blanklineStartRegex_);
        if (blankLine1 || blankLine2) {
          return 5;
        } else if (lineBreak1 || lineBreak2) {
          return 4;
        } else if (nonAlphaNumeric1 && !whitespace1 && whitespace2) {
          return 3;
        } else if (whitespace1 || whitespace2) {
          return 2;
        } else if (nonAlphaNumeric1 || nonAlphaNumeric2) {
          return 1;
        }
        return 0;
      }
      var pointer = 1;
      while (pointer < diffs.length - 1) {
        if (diffs[pointer - 1][0] == DIFF_EQUAL && diffs[pointer + 1][0] == DIFF_EQUAL) {
          var equality1 = diffs[pointer - 1][1];
          var edit2 = diffs[pointer][1];
          var equality2 = diffs[pointer + 1][1];
          var commonOffset = diff_commonSuffix(equality1, edit2);
          if (commonOffset) {
            var commonString = edit2.substring(edit2.length - commonOffset);
            equality1 = equality1.substring(0, equality1.length - commonOffset);
            edit2 = commonString + edit2.substring(0, edit2.length - commonOffset);
            equality2 = commonString + equality2;
          }
          var bestEquality1 = equality1;
          var bestEdit = edit2;
          var bestEquality2 = equality2;
          var bestScore = diff_cleanupSemanticScore_(equality1, edit2) + diff_cleanupSemanticScore_(edit2, equality2);
          while (edit2.charAt(0) === equality2.charAt(0)) {
            equality1 += edit2.charAt(0);
            edit2 = edit2.substring(1) + equality2.charAt(0);
            equality2 = equality2.substring(1);
            var score3 = diff_cleanupSemanticScore_(equality1, edit2) + diff_cleanupSemanticScore_(edit2, equality2);
            if (score3 >= bestScore) {
              bestScore = score3;
              bestEquality1 = equality1;
              bestEdit = edit2;
              bestEquality2 = equality2;
            }
          }
          if (diffs[pointer - 1][1] != bestEquality1) {
            if (bestEquality1) {
              diffs[pointer - 1][1] = bestEquality1;
            } else {
              diffs.splice(pointer - 1, 1);
              pointer--;
            }
            diffs[pointer][1] = bestEdit;
            if (bestEquality2) {
              diffs[pointer + 1][1] = bestEquality2;
            } else {
              diffs.splice(pointer + 1, 1);
              pointer--;
            }
          }
        }
        pointer++;
      }
    }
    function diff_cleanupMerge(diffs, fix_unicode) {
      diffs.push([DIFF_EQUAL, ""]);
      var pointer = 0;
      var count_delete = 0;
      var count_insert = 0;
      var text_delete = "";
      var text_insert = "";
      var commonlength;
      while (pointer < diffs.length) {
        if (pointer < diffs.length - 1 && !diffs[pointer][1]) {
          diffs.splice(pointer, 1);
          continue;
        }
        switch (diffs[pointer][0]) {
          case DIFF_INSERT:
            count_insert++;
            text_insert += diffs[pointer][1];
            pointer++;
            break;
          case DIFF_DELETE:
            count_delete++;
            text_delete += diffs[pointer][1];
            pointer++;
            break;
          case DIFF_EQUAL:
            var previous_equality = pointer - count_insert - count_delete - 1;
            if (fix_unicode) {
              if (previous_equality >= 0 && ends_with_pair_start(diffs[previous_equality][1])) {
                var stray = diffs[previous_equality][1].slice(-1);
                diffs[previous_equality][1] = diffs[previous_equality][1].slice(
                  0,
                  -1
                );
                text_delete = stray + text_delete;
                text_insert = stray + text_insert;
                if (!diffs[previous_equality][1]) {
                  diffs.splice(previous_equality, 1);
                  pointer--;
                  var k = previous_equality - 1;
                  if (diffs[k] && diffs[k][0] === DIFF_INSERT) {
                    count_insert++;
                    text_insert = diffs[k][1] + text_insert;
                    k--;
                  }
                  if (diffs[k] && diffs[k][0] === DIFF_DELETE) {
                    count_delete++;
                    text_delete = diffs[k][1] + text_delete;
                    k--;
                  }
                  previous_equality = k;
                }
              }
              if (starts_with_pair_end(diffs[pointer][1])) {
                var stray = diffs[pointer][1].charAt(0);
                diffs[pointer][1] = diffs[pointer][1].slice(1);
                text_delete += stray;
                text_insert += stray;
              }
            }
            if (pointer < diffs.length - 1 && !diffs[pointer][1]) {
              diffs.splice(pointer, 1);
              break;
            }
            if (text_delete.length > 0 || text_insert.length > 0) {
              if (text_delete.length > 0 && text_insert.length > 0) {
                commonlength = diff_commonPrefix(text_insert, text_delete);
                if (commonlength !== 0) {
                  if (previous_equality >= 0) {
                    diffs[previous_equality][1] += text_insert.substring(
                      0,
                      commonlength
                    );
                  } else {
                    diffs.splice(0, 0, [
                      DIFF_EQUAL,
                      text_insert.substring(0, commonlength)
                    ]);
                    pointer++;
                  }
                  text_insert = text_insert.substring(commonlength);
                  text_delete = text_delete.substring(commonlength);
                }
                commonlength = diff_commonSuffix(text_insert, text_delete);
                if (commonlength !== 0) {
                  diffs[pointer][1] = text_insert.substring(text_insert.length - commonlength) + diffs[pointer][1];
                  text_insert = text_insert.substring(
                    0,
                    text_insert.length - commonlength
                  );
                  text_delete = text_delete.substring(
                    0,
                    text_delete.length - commonlength
                  );
                }
              }
              var n = count_insert + count_delete;
              if (text_delete.length === 0 && text_insert.length === 0) {
                diffs.splice(pointer - n, n);
                pointer = pointer - n;
              } else if (text_delete.length === 0) {
                diffs.splice(pointer - n, n, [DIFF_INSERT, text_insert]);
                pointer = pointer - n + 1;
              } else if (text_insert.length === 0) {
                diffs.splice(pointer - n, n, [DIFF_DELETE, text_delete]);
                pointer = pointer - n + 1;
              } else {
                diffs.splice(
                  pointer - n,
                  n,
                  [DIFF_DELETE, text_delete],
                  [DIFF_INSERT, text_insert]
                );
                pointer = pointer - n + 2;
              }
            }
            if (pointer !== 0 && diffs[pointer - 1][0] === DIFF_EQUAL) {
              diffs[pointer - 1][1] += diffs[pointer][1];
              diffs.splice(pointer, 1);
            } else {
              pointer++;
            }
            count_insert = 0;
            count_delete = 0;
            text_delete = "";
            text_insert = "";
            break;
        }
      }
      if (diffs[diffs.length - 1][1] === "") {
        diffs.pop();
      }
      var changes = false;
      pointer = 1;
      while (pointer < diffs.length - 1) {
        if (diffs[pointer - 1][0] === DIFF_EQUAL && diffs[pointer + 1][0] === DIFF_EQUAL) {
          if (diffs[pointer][1].substring(
            diffs[pointer][1].length - diffs[pointer - 1][1].length
          ) === diffs[pointer - 1][1]) {
            diffs[pointer][1] = diffs[pointer - 1][1] + diffs[pointer][1].substring(
              0,
              diffs[pointer][1].length - diffs[pointer - 1][1].length
            );
            diffs[pointer + 1][1] = diffs[pointer - 1][1] + diffs[pointer + 1][1];
            diffs.splice(pointer - 1, 1);
            changes = true;
          } else if (diffs[pointer][1].substring(0, diffs[pointer + 1][1].length) == diffs[pointer + 1][1]) {
            diffs[pointer - 1][1] += diffs[pointer + 1][1];
            diffs[pointer][1] = diffs[pointer][1].substring(diffs[pointer + 1][1].length) + diffs[pointer + 1][1];
            diffs.splice(pointer + 1, 1);
            changes = true;
          }
        }
        pointer++;
      }
      if (changes) {
        diff_cleanupMerge(diffs, fix_unicode);
      }
    }
    function is_surrogate_pair_start(charCode) {
      return charCode >= 55296 && charCode <= 56319;
    }
    function is_surrogate_pair_end(charCode) {
      return charCode >= 56320 && charCode <= 57343;
    }
    function starts_with_pair_end(str) {
      return is_surrogate_pair_end(str.charCodeAt(0));
    }
    function ends_with_pair_start(str) {
      return is_surrogate_pair_start(str.charCodeAt(str.length - 1));
    }
    function remove_empty_tuples(tuples) {
      var ret = [];
      for (var i = 0; i < tuples.length; i++) {
        if (tuples[i][1].length > 0) {
          ret.push(tuples[i]);
        }
      }
      return ret;
    }
    function make_edit_splice(before, oldMiddle, newMiddle, after) {
      if (ends_with_pair_start(before) || starts_with_pair_end(after)) {
        return null;
      }
      return remove_empty_tuples([
        [DIFF_EQUAL, before],
        [DIFF_DELETE, oldMiddle],
        [DIFF_INSERT, newMiddle],
        [DIFF_EQUAL, after]
      ]);
    }
    function find_cursor_edit_diff(oldText, newText, cursor_pos) {
      var oldRange = typeof cursor_pos === "number" ? { index: cursor_pos, length: 0 } : cursor_pos.oldRange;
      var newRange = typeof cursor_pos === "number" ? null : cursor_pos.newRange;
      var oldLength = oldText.length;
      var newLength = newText.length;
      if (oldRange.length === 0 && (newRange === null || newRange.length === 0)) {
        var oldCursor = oldRange.index;
        var oldBefore = oldText.slice(0, oldCursor);
        var oldAfter = oldText.slice(oldCursor);
        var maybeNewCursor = newRange ? newRange.index : null;
        editBefore: {
          var newCursor = oldCursor + newLength - oldLength;
          if (maybeNewCursor !== null && maybeNewCursor !== newCursor) {
            break editBefore;
          }
          if (newCursor < 0 || newCursor > newLength) {
            break editBefore;
          }
          var newBefore = newText.slice(0, newCursor);
          var newAfter = newText.slice(newCursor);
          if (newAfter !== oldAfter) {
            break editBefore;
          }
          var prefixLength = Math.min(oldCursor, newCursor);
          var oldPrefix = oldBefore.slice(0, prefixLength);
          var newPrefix = newBefore.slice(0, prefixLength);
          if (oldPrefix !== newPrefix) {
            break editBefore;
          }
          var oldMiddle = oldBefore.slice(prefixLength);
          var newMiddle = newBefore.slice(prefixLength);
          return make_edit_splice(oldPrefix, oldMiddle, newMiddle, oldAfter);
        }
        editAfter: {
          if (maybeNewCursor !== null && maybeNewCursor !== oldCursor) {
            break editAfter;
          }
          var cursor = oldCursor;
          var newBefore = newText.slice(0, cursor);
          var newAfter = newText.slice(cursor);
          if (newBefore !== oldBefore) {
            break editAfter;
          }
          var suffixLength = Math.min(oldLength - cursor, newLength - cursor);
          var oldSuffix = oldAfter.slice(oldAfter.length - suffixLength);
          var newSuffix = newAfter.slice(newAfter.length - suffixLength);
          if (oldSuffix !== newSuffix) {
            break editAfter;
          }
          var oldMiddle = oldAfter.slice(0, oldAfter.length - suffixLength);
          var newMiddle = newAfter.slice(0, newAfter.length - suffixLength);
          return make_edit_splice(oldBefore, oldMiddle, newMiddle, oldSuffix);
        }
      }
      if (oldRange.length > 0 && newRange && newRange.length === 0) {
        replaceRange: {
          var oldPrefix = oldText.slice(0, oldRange.index);
          var oldSuffix = oldText.slice(oldRange.index + oldRange.length);
          var prefixLength = oldPrefix.length;
          var suffixLength = oldSuffix.length;
          if (newLength < prefixLength + suffixLength) {
            break replaceRange;
          }
          var newPrefix = newText.slice(0, prefixLength);
          var newSuffix = newText.slice(newLength - suffixLength);
          if (oldPrefix !== newPrefix || oldSuffix !== newSuffix) {
            break replaceRange;
          }
          var oldMiddle = oldText.slice(prefixLength, oldLength - suffixLength);
          var newMiddle = newText.slice(prefixLength, newLength - suffixLength);
          return make_edit_splice(oldPrefix, oldMiddle, newMiddle, oldSuffix);
        }
      }
      return null;
    }
    function diff(text1, text2, cursor_pos, cleanup) {
      return diff_main(text1, text2, cursor_pos, cleanup, true);
    }
    diff.INSERT = DIFF_INSERT;
    diff.DELETE = DIFF_DELETE;
    diff.EQUAL = DIFF_EQUAL;
    module2.exports = diff;
  }
});

// node_modules/unidecode/data/x00.js
var require_x00 = __commonJS({
  "node_modules/unidecode/data/x00.js"(exports2, module2) {
    module2.exports = [
      //  BLOCK U+0000
      "\\x00",
      "\\x01",
      "\\x02",
      "\\x03",
      "\\x04",
      "\\x05",
      "\\x06",
      "\\x07",
      "\\x08",
      "\\x09",
      "\\x0a",
      "\\x0b",
      "\\x0c",
      "\\x0d",
      "\\x0e",
      "\\x0f",
      // ^00      ^01       ^02       ^03       ^04       ^05       ^06       ^07       ^08       ^09       ^0a       ^0b       ^0c       ^0d       ^0e       ^0f       
      "\\x10",
      "\\x11",
      "\\x12",
      "\\x13",
      "\\x14",
      "\\x15",
      "\\x16",
      "\\x17",
      "\\x18",
      "\\x19",
      "\\x1a",
      "\\x1b",
      "\\x1c",
      "\\x1d",
      "\\x1e",
      "\\x1f",
      // ^10      ^11       ^12       ^13       ^14       ^15       ^16       ^17       ^18       ^19       ^1a       ^1b       ^1c       ^1d       ^1e       ^1f       
      " ",
      "!",
      '"',
      "#",
      "\\$",
      "%",
      "&",
      "'",
      "(",
      ")",
      "*",
      "+",
      ",",
      "-",
      ".",
      "/",
      // ^20  ^21    ^22    ^23    ^24     ^25    ^26    ^27    ^28    ^29    ^2a    ^2b    ^2c ^2d  ^2e    ^2f    ^30    
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      ":",
      ";",
      "<",
      "=",
      ">",
      "?",
      // ^30  ^31  ^32  ^33  ^34  ^35  ^36  ^37  ^38  ^39  ^3a    ^3b    ^3c    ^3d    ^3e    ^3f    
      "\\@",
      "A",
      "B",
      "C",
      "D",
      "E",
      "F",
      "G",
      "H",
      "I",
      "J",
      "K",
      "L",
      "M",
      "N",
      "O",
      // ^40    ^41  ^42  ^43  ^44  ^45  ^46  ^47  ^48  ^49  ^4a  ^4b  ^4c  ^4d  ^4e  ^4f  
      "P",
      "Q",
      "R",
      "S",
      "T",
      "U",
      "V",
      "W",
      "X",
      "Y",
      "Z",
      "[",
      "\\\\",
      "]",
      "^",
      "_",
      // ^50  ^51  ^52  ^53  ^54  ^55  ^56  ^57  ^58  ^59  ^5a  ^5b    ^5c     ^5d    ^5e    ^5f    
      "`",
      "a",
      "b",
      "c",
      "d",
      "e",
      "f",
      "g",
      "h",
      "i",
      "j",
      "k",
      "l",
      "m",
      "n",
      "o",
      // ^60   ^61  ^62  ^63  ^64  ^65  ^66  ^67  ^68  ^69  ^6a  ^6b  ^6c  ^6d  ^6e  ^6f  
      "p",
      "q",
      "r",
      "s",
      "t",
      "u",
      "v",
      "w",
      "x",
      "y",
      "z",
      "\\{",
      "|",
      "\\}",
      "~",
      "\\x7f",
      // ^70  ^71  ^72  ^73  ^74  ^75  ^76  ^77  ^78  ^79  ^7a  ^7b     ^7c    ^7d     ^7e    ^7f       
      // ======================================================================
      //  Strictly speaking, these are the Unicode values:
      //  "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
      //  ^80 ^81 ^82 ^83 ^84 ^85 ^86 ^87 ^88 ^89 ^8a ^8b ^8c ^8d ^8e ^8f  
      //  "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
      //  ^90 ^91 ^92 ^93 ^94 ^95 ^96 ^97 ^98 ^99 ^9a ^9b ^9c ^9d ^9e ^9f  
      // 
      //  But I've decided to tolerate Win-1252 input:
      "EUR",
      "",
      ",",
      "f",
      ",,",
      "...",
      "+",
      "++",
      "^",
      "%0",
      "S",
      "<",
      "OE",
      "",
      "Z",
      "",
      "",
      "'",
      "'",
      '"',
      '"',
      "*",
      "-",
      "--",
      "~",
      "tm",
      "s",
      ">",
      "oe",
      "",
      "z",
      "Y",
      //  See: https://en.wikipedia.org/wiki/Latin-1_Supplement_%28Unicode_block%29
      // ======================================================================
      //  And now, back to Latin-1 = Unicode values...
      " ",
      "!",
      "C/",
      "PS",
      "\\$?",
      "Y=",
      "|",
      "SS",
      '"',
      "(c)",
      "a",
      "<<",
      "!",
      "",
      "(r)",
      "-",
      // ^a0  ^a1    ^a2     ^a3   ^a4      ^a5     ^a6    ^a7   ^a8    ^a9      ^aa  ^ab     ^ac   ^ad  ^ae      ^af    
      "deg",
      "+-",
      "2",
      "3",
      "'",
      "u",
      "P",
      "*",
      ",",
      "1",
      "o",
      ">>",
      "1/4",
      "1/2",
      "3/4",
      "?",
      // ^b0   ^b1     ^b2  ^b3  ^b4    ^b5  ^b6  ^b7    ^b8 ^b9  ^ba  ^bb  ^bc     ^bd      ^be      ^bf      ^c0    
      "A",
      "A",
      "A",
      "A",
      "A",
      "A",
      "AE",
      "C",
      "E",
      "E",
      "E",
      "E",
      "I",
      "I",
      "I",
      "I",
      // ^c0  ^c1  ^c2  ^c3  ^c4  ^c5  ^c6   ^c7  ^c8  ^c9  ^ca  ^cb  ^cc  ^cd  ^ce  ^cf  
      "D",
      "N",
      "O",
      "O",
      "O",
      "O",
      "O",
      "x",
      "O",
      "U",
      "U",
      "U",
      "U",
      "Y",
      "Th",
      "ss",
      // ^d0  ^d1  ^d2  ^d3  ^d4  ^d5  ^d6  ^d7  ^d8  ^d9  ^da  ^db  ^dc  ^dd  ^de   ^df   
      "a",
      "a",
      "a",
      "a",
      "a",
      "a",
      "ae",
      "c",
      "e",
      "e",
      "e",
      "e",
      "i",
      "i",
      "i",
      "i",
      // ^e0  ^e1  ^e2  ^e3  ^e4  ^e5  ^e6   ^e7  ^e8  ^e9  ^ea  ^eb  ^ec  ^ed  ^ee  ^ef  
      "d",
      "n",
      "o",
      "o",
      "o",
      "o",
      "o",
      "/",
      "o",
      "u",
      "u",
      "u",
      "u",
      "y",
      "th",
      "y"
      // ^f0  ^f1  ^f2  ^f3  ^f4  ^f5  ^f6  ^f7    ^f8  ^f9  ^fa  ^fb  ^fc  ^fd  ^fe   ^ff  
    ];
  }
});

// node_modules/unidecode/data/x01.js
var require_x01 = __commonJS({
  "node_modules/unidecode/data/x01.js"(exports2, module2) {
    module2.exports = [
      "A",
      "a",
      "A",
      "a",
      "A",
      "a",
      "C",
      "c",
      "C",
      "c",
      "C",
      "c",
      "C",
      "c",
      "D",
      "d",
      "D",
      "d",
      "E",
      "e",
      "E",
      "e",
      "E",
      "e",
      "E",
      "e",
      "E",
      "e",
      "G",
      "g",
      "G",
      "g",
      "G",
      "g",
      "G",
      "g",
      "H",
      "h",
      "H",
      "h",
      "I",
      "i",
      "I",
      "i",
      "I",
      "i",
      "I",
      "i",
      "I",
      "i",
      "IJ",
      "ij",
      "J",
      "j",
      "K",
      "k",
      "k",
      "L",
      "l",
      "L",
      "l",
      "L",
      "l",
      "L",
      "l",
      "L",
      "l",
      "N",
      "n",
      "N",
      "n",
      "N",
      "n",
      "'n",
      "ng",
      "NG",
      "O",
      "o",
      "O",
      "o",
      "O",
      "o",
      "OE",
      "oe",
      "R",
      "r",
      "R",
      "r",
      "R",
      "r",
      "S",
      "s",
      "S",
      "s",
      "S",
      "s",
      "S",
      "s",
      "T",
      "t",
      "T",
      "t",
      "T",
      "t",
      "U",
      "u",
      "U",
      "u",
      "U",
      "u",
      "U",
      "u",
      "U",
      "u",
      "U",
      "u",
      "W",
      "w",
      "Y",
      "y",
      "Y",
      "Z",
      "z",
      "Z",
      "z",
      "Z",
      "z",
      "s",
      "b",
      "B",
      "B",
      "b",
      "6",
      "6",
      "O",
      "C",
      "c",
      "D",
      "D",
      "D",
      "d",
      "d",
      "3",
      "\\@",
      "E",
      "F",
      "f",
      "G",
      "G",
      "hv",
      "I",
      "I",
      "K",
      "k",
      "l",
      "l",
      "W",
      "N",
      "n",
      "O",
      "O",
      "o",
      "OI",
      "oi",
      "P",
      "p",
      "YR",
      "2",
      "2",
      "SH",
      "sh",
      "t",
      "T",
      "t",
      "T",
      "U",
      "u",
      "Y",
      "V",
      "Y",
      "y",
      "Z",
      "z",
      "ZH",
      "ZH",
      "zh",
      "zh",
      "2",
      "5",
      "5",
      "ts",
      "w",
      "|",
      "||",
      "|=",
      "!",
      "DZ",
      "Dz",
      "dz",
      "LJ",
      "Lj",
      "lj",
      "NJ",
      "Nj",
      "nj",
      "A",
      "a",
      "I",
      "i",
      "O",
      "o",
      "U",
      "u",
      "U",
      "u",
      "U",
      "u",
      "U",
      "u",
      "U",
      "u",
      "\\@",
      "A",
      "a",
      "A",
      "a",
      "AE",
      "ae",
      "G",
      "g",
      "G",
      "g",
      "K",
      "k",
      "O",
      "o",
      "O",
      "o",
      "ZH",
      "zh",
      "j",
      "DZ",
      "Dz",
      "dz",
      "G",
      "g",
      "HV",
      "W",
      "N",
      "n",
      "A",
      "a",
      "AE",
      "ae",
      "O",
      "o"
    ];
  }
});

// node_modules/unidecode/data/x02.js
var require_x02 = __commonJS({
  "node_modules/unidecode/data/x02.js"(exports2, module2) {
    module2.exports = [
      "A",
      "a",
      "A",
      "a",
      "E",
      "e",
      "E",
      "e",
      "I",
      "i",
      "I",
      "i",
      "O",
      "o",
      "O",
      "o",
      "R",
      "r",
      "R",
      "r",
      "U",
      "u",
      "U",
      "u",
      "S",
      "s",
      "T",
      "t",
      "Y",
      "y",
      "H",
      "h",
      "N",
      "d",
      "OU",
      "ou",
      "Z",
      "z",
      "A",
      "a",
      "E",
      "e",
      "O",
      "o",
      "O",
      "o",
      "O",
      "o",
      "O",
      "o",
      "Y",
      "y",
      "l",
      //  0x34
      "n",
      //  0x35
      "t",
      //  0x36
      "j",
      //  0x37
      "db",
      //  0x38
      "qp",
      //  0x39
      "A",
      //  0x3a
      "C",
      //  0x3b
      "c",
      //  0x3c
      "L",
      //  0x3d
      "T",
      //  0x3e
      "s",
      //  0x3f
      "z",
      //  0x40
      "[?]",
      "[?]",
      "B",
      //  0x43
      "U",
      //  0x44
      "^",
      //  0x45
      "E",
      //  0x46
      "e",
      //  0x47
      "J",
      //  0x48
      "j",
      //  0x49
      "q",
      //  0x4a
      "q",
      //  0x4b
      "R",
      //  0x4c
      "r",
      //  0x4d
      "Y",
      //  0x4e
      "y",
      //  0x4f
      "a",
      "a",
      "a",
      "b",
      "o",
      "c",
      "d",
      "d",
      "e",
      "\\@",
      "\\@",
      "e",
      "e",
      "e",
      "e",
      "j",
      "g",
      "g",
      "g",
      "g",
      "u",
      "Y",
      "h",
      "h",
      "i",
      "i",
      "I",
      "l",
      "l",
      "l",
      "lZ",
      "W",
      "W",
      "m",
      "n",
      "n",
      "n",
      "o",
      "OE",
      "O",
      "F",
      "r",
      "r",
      "r",
      "r",
      "r",
      "r",
      "r",
      "R",
      "R",
      "s",
      "S",
      "j",
      "S",
      "S",
      "t",
      "t",
      "u",
      "U",
      "v",
      "^",
      "w",
      "y",
      "Y",
      "z",
      "z",
      "Z",
      "Z",
      "?",
      "?",
      "?",
      "C",
      "\\@",
      "B",
      "E",
      "G",
      "H",
      "j",
      "k",
      "L",
      "q",
      "?",
      "?",
      "dz",
      "dZ",
      "dz",
      "ts",
      "tS",
      "tC",
      "fN",
      "ls",
      "lz",
      "WW",
      "]]",
      "h",
      "h",
      "h",
      "h",
      "j",
      "r",
      "r",
      "r",
      "r",
      "w",
      "y",
      "'",
      '"',
      "`",
      "'",
      "`",
      "`",
      "'",
      "?",
      "?",
      "<",
      ">",
      "^",
      "V",
      "^",
      "V",
      "'",
      "-",
      "/",
      "\\\\",
      ",",
      "_",
      "\\\\",
      "/",
      ":",
      ".",
      "`",
      "'",
      "^",
      "V",
      "+",
      "-",
      "V",
      ".",
      "\\@",
      ",",
      "~",
      '"',
      "R",
      "X",
      "G",
      "l",
      "s",
      "x",
      "?",
      //  U+2e5 ...
      //  ˥   ˦    ˧    ˨     ˩   ˪    ˫
      "5",
      "4",
      "3",
      "2",
      "1",
      "/",
      "\\",
      "V",
      "=",
      '"',
      "V",
      //  ˬ  02EF	MODIFIER LETTER LOW DOWN ARROWHEAD
      //  ...and also 16 UPA modifiers:
      //  ˰ ˱ ˲ ˳ ˴ ˵ ˶ ˷ ˸ ˹ ˺ ˻ ˼ ˽ ˾ ˿
      "^",
      //  02F0	MODIFIER LETTER LOW UP ARROWHEAD
      "<",
      //  02F1	MODIFIER LETTER LOW LEFT ARROWHEAD
      ">",
      //  02F2	MODIFIER LETTER LOW RIGHT ARROWHEAD
      "o",
      //  02F3	MODIFIER LETTER LOW RING
      "`",
      //  02F4	MODIFIER LETTER MIDDLE GRAVE ACCENT
      "``",
      //  02F5	MODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENT
      "//",
      //  02F6	MODIFIER LETTER MIDDLE DOUBLE ACUTE ACCENT
      "~",
      //  02F7	MODIFIER LETTER LOW TILDE
      ":",
      //  02F8	MODIFIER LETTER RAISED COLON
      "[-",
      //  02F9	MODIFIER LETTER BEGIN HIGH TONE
      "-]",
      //  02FA	MODIFIER LETTER END HIGH TONE
      "[_",
      //  02FB	MODIFIER LETTER BEGIN LOW TONE
      "_]",
      //  02FC	MODIFIER LETTER END LOW TONE
      "_",
      //  02FD	MODIFIER LETTER SHELF
      "_",
      //  02FE	MODIFIER LETTER OPEN SHELF
      "<"
      //  02FF	MODIFIER LETTER LOW LEFT ARROW
    ];
  }
});

// node_modules/unidecode/data/x03.js
var require_x03 = __commonJS({
  "node_modules/unidecode/data/x03.js"(exports2, module2) {
    module2.exports = [
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "",
      "",
      "",
      // '[?]', '[?]', '[?]', '[?]', '[?]', '[?]', '[?]', '[?]', '[?]', '[?]', '[?]', '[?]', '[?]',
      "a",
      //  0x63
      "e",
      //  0x64
      "i",
      //  0x65
      "o",
      //  0x66
      "u",
      //  0x67
      "c",
      //  0x68
      "d",
      //  0x69
      "h",
      //  0x6a
      "m",
      //  0x6b
      "r",
      //  0x6c
      "t",
      //  0x6d
      "v",
      //  0x6e
      "x",
      //  0x6f
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "'",
      ",",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "",
      "[?]",
      "[?]",
      "[?]",
      "?",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "",
      "",
      "A",
      ";",
      "E",
      "E",
      "I",
      "[?]",
      "O",
      "[?]",
      "U",
      "O",
      "I",
      "A",
      "B",
      "G",
      "D",
      "E",
      "Z",
      "E",
      "Th",
      "I",
      "K",
      "L",
      "M",
      "N",
      "Ks",
      "O",
      "P",
      "R",
      "[?]",
      "S",
      "T",
      "U",
      "Ph",
      "Kh",
      "Ps",
      "O",
      "I",
      "U",
      "a",
      "e",
      "e",
      "i",
      "u",
      "a",
      "b",
      "g",
      "d",
      "e",
      "z",
      "e",
      "th",
      "i",
      "k",
      "l",
      "m",
      "n",
      "x",
      "o",
      "p",
      "r",
      "s",
      "s",
      "t",
      "u",
      "ph",
      "kh",
      "ps",
      "o",
      "i",
      "u",
      "o",
      "u",
      "o",
      "[?]",
      "b",
      "th",
      "U",
      "U",
      "U",
      "ph",
      "p",
      "&",
      "[?]",
      "[?]",
      "St",
      "st",
      "W",
      "w",
      "Q",
      "q",
      "Sp",
      "sp",
      "Sh",
      "sh",
      "F",
      "f",
      "Kh",
      "kh",
      "H",
      "h",
      "G",
      "g",
      "CH",
      "ch",
      "Ti",
      "ti",
      // 03F0:
      //  ϰ ϱ ϲ ϳ  
      "k",
      "r",
      "c",
      "j",
      //  ϴ ϵ ϶ Ϸ 
      "TH",
      "e",
      "e",
      "Sh",
      //  ϸ Ϲ Ϻ ϻ
      "sh",
      "s",
      "[?]",
      "[?]",
      //  ϼ Ͻ Ͼ Ͽ
      "r/",
      "S",
      "S.",
      "S."
    ];
  }
});

// node_modules/unidecode/data/x04.js
var require_x04 = __commonJS({
  "node_modules/unidecode/data/x04.js"(exports2, module2) {
    module2.exports = [
      "Ie",
      "Io",
      "Dj",
      "Gj",
      "E",
      "Dz",
      "I",
      "Yi",
      "J",
      "Lj",
      "Nj",
      "Tsh",
      "Kj",
      "I",
      "U",
      "Dzh",
      "A",
      "B",
      "V",
      "G",
      "D",
      "E",
      "Zh",
      "Z",
      "I",
      "I",
      "K",
      "L",
      "M",
      "N",
      "O",
      "P",
      "R",
      "S",
      "T",
      "U",
      "F",
      "Kh",
      "Ts",
      "Ch",
      "Sh",
      "Shch",
      "",
      "Y",
      "'",
      "E",
      "Iu",
      "Ia",
      "a",
      "b",
      "v",
      "g",
      "d",
      "e",
      "zh",
      "z",
      "i",
      "i",
      "k",
      "l",
      "m",
      "n",
      "o",
      "p",
      "r",
      "s",
      "t",
      "u",
      "f",
      "kh",
      "ts",
      "ch",
      "sh",
      "shch",
      "",
      "y",
      "'",
      "e",
      "iu",
      "ia",
      "ie",
      "io",
      "dj",
      "gj",
      "ie",
      "dz",
      "i",
      "yi",
      "j",
      "lj",
      "nj",
      "tsh",
      "kj",
      "i",
      "u",
      "dzh",
      "O",
      "o",
      "E",
      "e",
      "Ie",
      "ie",
      "E",
      "e",
      "Ie",
      "ie",
      "O",
      "o",
      "Io",
      "io",
      "Ks",
      "ks",
      "Ps",
      "ps",
      "F",
      "f",
      "Y",
      "y",
      "Y",
      "y",
      "u",
      "u",
      "O",
      "o",
      "O",
      "o",
      "Ot",
      "ot",
      "Q",
      "q",
      "*1000*",
      "",
      "",
      "",
      "",
      "[?]",
      "*100.000*",
      "*1.000.000*",
      "[?]",
      "[?]",
      '"',
      '"',
      "R'",
      "r'",
      "G'",
      "g'",
      "G'",
      "g'",
      "G'",
      "g'",
      "Zh'",
      "zh'",
      "Z'",
      "z'",
      "K'",
      "k'",
      "K'",
      "k'",
      "K'",
      "k'",
      "K'",
      "k'",
      "N'",
      "n'",
      "Ng",
      "ng",
      "P'",
      "p'",
      "Kh",
      "kh",
      "S'",
      "s'",
      "T'",
      "t'",
      "U",
      "u",
      "U'",
      "u'",
      "Kh'",
      "kh'",
      "Tts",
      "tts",
      "Ch'",
      "ch'",
      "Ch'",
      "ch'",
      "H",
      "h",
      "Ch",
      "ch",
      "Ch'",
      "ch'",
      "`",
      "Zh",
      "zh",
      "K'",
      "k'",
      "[?]",
      "[?]",
      "N'",
      "n'",
      "[?]",
      "[?]",
      "Ch",
      "ch",
      "[?]",
      "[?]",
      "[?]",
      "a",
      "a",
      "A",
      "a",
      "Ae",
      "ae",
      "Ie",
      "ie",
      "\\@",
      "\\@",
      "\\@",
      "\\@",
      "Zh",
      "zh",
      "Z",
      "z",
      "Dz",
      "dz",
      "I",
      "i",
      "I",
      "i",
      "O",
      "o",
      "O",
      "o",
      "O",
      "o",
      "E",
      "e",
      "U",
      "u",
      "U",
      "u",
      "U",
      "u",
      "Ch",
      "ch",
      "[?]",
      "[?]",
      "Y",
      "y",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x05.js
var require_x05 = __commonJS({
  "node_modules/unidecode/data/x05.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "A",
      "B",
      "G",
      "D",
      "E",
      "Z",
      "E",
      "E",
      "T`",
      "Zh",
      "I",
      "L",
      "Kh",
      "Ts",
      "K",
      "H",
      "Dz",
      "Gh",
      "Ch",
      "M",
      "Y",
      "N",
      "Sh",
      "O",
      "Ch`",
      "P",
      "J",
      "Rh",
      "S",
      "V",
      "T",
      "R",
      "Ts`",
      "W",
      "P`",
      "K`",
      "O",
      "F",
      "[?]",
      "[?]",
      "<",
      "'",
      "/",
      "!",
      ",",
      "?",
      ".",
      "[?]",
      "a",
      "b",
      "g",
      "d",
      "e",
      "z",
      "e",
      "e",
      "t`",
      "zh",
      "i",
      "l",
      "kh",
      "ts",
      "k",
      "h",
      "dz",
      "gh",
      "ch",
      "m",
      "y",
      "n",
      "sh",
      "o",
      "ch`",
      "p",
      "j",
      "rh",
      "s",
      "v",
      "t",
      "r",
      "ts`",
      "w",
      "p`",
      "k`",
      "o",
      "f",
      "ew",
      "[?]",
      ".",
      "-",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "[?]",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "\\@",
      "e",
      "a",
      "o",
      "i",
      "e",
      "e",
      "a",
      "a",
      "o",
      "[?]",
      "u",
      "'",
      "",
      "",
      "",
      //  u+05c0:
      "|",
      "",
      "",
      ":",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "",
      "b",
      "g",
      "d",
      "h",
      "v",
      "z",
      "kh",
      "t",
      "y",
      "k",
      "k",
      "l",
      "m",
      "m",
      "n",
      "n",
      "s",
      "`",
      "p",
      "p",
      "ts",
      "ts",
      "q",
      "r",
      "sh",
      "t",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "V",
      "oy",
      "i",
      "'",
      '"',
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x06.js
var require_x06 = __commonJS({
  "node_modules/unidecode/data/x06.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      ",",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      ";",
      "[?]",
      "[?]",
      "[?]",
      "?",
      "[?]",
      "",
      "a",
      "'",
      "w'",
      "",
      "y'",
      "",
      "b",
      "\\@",
      "t",
      "th",
      "j",
      "H",
      "kh",
      "d",
      "dh",
      "r",
      "z",
      "s",
      "sh",
      "S",
      "D",
      "T",
      "Z",
      "`",
      "G",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "",
      "f",
      "q",
      "k",
      "l",
      "m",
      "n",
      "h",
      "w",
      "~",
      "y",
      "an",
      "un",
      "in",
      "a",
      "u",
      "i",
      "W",
      "",
      "",
      "'",
      "'",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      "%",
      ".",
      ",",
      "*",
      "[?]",
      "[?]",
      "",
      "'",
      "'",
      "'",
      "",
      "'",
      "'w",
      "'u",
      "'y",
      "tt",
      "tth",
      "b",
      "t",
      "T",
      "p",
      "th",
      "bh",
      "'h",
      "H",
      "ny",
      "dy",
      "H",
      "ch",
      "cch",
      "dd",
      "D",
      "D",
      "Dt",
      "dh",
      "ddh",
      "d",
      "D",
      "D",
      "rr",
      "R",
      "R",
      "R",
      "R",
      "R",
      "R",
      "j",
      "R",
      "S",
      "S",
      "S",
      "S",
      "S",
      "T",
      "GH",
      "F",
      "F",
      "F",
      "v",
      "f",
      "ph",
      "Q",
      "Q",
      "kh",
      "k",
      "K",
      "K",
      "ng",
      "K",
      "g",
      "G",
      "N",
      "G",
      "G",
      "G",
      "L",
      "L",
      "L",
      "L",
      "N",
      "N",
      "N",
      "N",
      "N",
      "h",
      "Ch",
      "hy",
      "h",
      "H",
      "\\@",
      "W",
      "oe",
      "oe",
      "u",
      "yu",
      "yu",
      "W",
      "v",
      "y",
      "Y",
      "Y",
      "W",
      "",
      "",
      "y",
      "y'",
      ".",
      "ae",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "\\@",
      "#",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "^",
      "",
      "",
      "",
      "",
      "[?]",
      "[?]",
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      "Sh",
      "D",
      "Gh",
      "&",
      "+m",
      "h"
    ];
  }
});

// node_modules/unidecode/data/x07.js
var require_x07 = __commonJS({
  "node_modules/unidecode/data/x07.js"(exports2, module2) {
    module2.exports = [
      "//",
      "/",
      ",",
      "!",
      "!",
      "-",
      ",",
      ",",
      ";",
      "?",
      "~",
      "\\{",
      "\\}",
      "*",
      "[?]",
      "",
      "'",
      "",
      "b",
      "g",
      "g",
      "d",
      "d",
      "h",
      "w",
      "z",
      "H",
      "t",
      "t",
      "y",
      "yh",
      "k",
      "l",
      "m",
      "n",
      "s",
      "s",
      "`",
      "p",
      "p",
      "S",
      "q",
      "r",
      "sh",
      "t",
      "[?]",
      "[?]",
      "[?]",
      "a",
      "a",
      "a",
      "A",
      "A",
      "A",
      "e",
      "e",
      "e",
      "E",
      "i",
      "i",
      "u",
      "u",
      "u",
      "o",
      "",
      "`",
      "'",
      "",
      "",
      "X",
      "Q",
      "\\@",
      "\\@",
      "|",
      "+",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "h",
      "sh",
      "n",
      "r",
      "b",
      "L",
      "k",
      "'",
      "v",
      "m",
      "f",
      "dh",
      "th",
      "l",
      "g",
      "ny",
      "s",
      "d",
      "z",
      "t",
      "y",
      "p",
      "j",
      "ch",
      "tt",
      "hh",
      "kh",
      "th",
      "z",
      "sh",
      "s",
      "d",
      "t",
      "z",
      "`",
      "gh",
      "q",
      "w",
      "a",
      "aa",
      "i",
      "ee",
      "u",
      "oo",
      "e",
      "ey",
      "o",
      "oa",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x09.js
var require_x09 = __commonJS({
  "node_modules/unidecode/data/x09.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "N",
      "N",
      "H",
      "[?]",
      "a",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "R",
      "L",
      "eN",
      "e",
      "e",
      "ai",
      "oN",
      "o",
      "o",
      "au",
      "k",
      "kh",
      "g",
      "gh",
      "ng",
      "c",
      "ch",
      "j",
      "jh",
      "ny",
      "tt",
      "tth",
      "dd",
      "ddh",
      "nn",
      "t",
      "th",
      "d",
      "dh",
      "n",
      "nnn",
      "p",
      "ph",
      "b",
      "bh",
      "m",
      "y",
      "r",
      "rr",
      "l",
      "l",
      "lll",
      "v",
      "sh",
      "ss",
      "s",
      "h",
      "[?]",
      "[?]",
      "'",
      "'",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "R",
      "RR",
      "eN",
      "e",
      "e",
      "ai",
      "oN",
      "o",
      "o",
      "au",
      "",
      "[?]",
      "[?]",
      "AUM",
      "'",
      "'",
      "`",
      "'",
      "[?]",
      "[?]",
      "[?]",
      "q",
      "khh",
      "ghh",
      "z",
      "dddh",
      "rh",
      "f",
      "yy",
      "RR",
      "LL",
      "L",
      "LL",
      " / ",
      " // ",
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      ".",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "N",
      "N",
      "H",
      "[?]",
      "a",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "R",
      "RR",
      "[?]",
      "[?]",
      "e",
      "ai",
      "[?]",
      "[?]",
      "o",
      "au",
      "k",
      "kh",
      "g",
      "gh",
      "ng",
      "c",
      "ch",
      "j",
      "jh",
      "ny",
      "tt",
      "tth",
      "dd",
      "ddh",
      "nn",
      "t",
      "th",
      "d",
      "dh",
      "n",
      "[?]",
      "p",
      "ph",
      "b",
      "bh",
      "m",
      "y",
      "r",
      "[?]",
      "l",
      "[?]",
      "[?]",
      "[?]",
      "sh",
      "ss",
      "s",
      "h",
      "[?]",
      "[?]",
      "'",
      "[?]",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "R",
      "RR",
      "[?]",
      "[?]",
      "e",
      "ai",
      "[?]",
      "[?]",
      "o",
      "au",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "+",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "rr",
      "rh",
      "[?]",
      "yy",
      "RR",
      "LL",
      "L",
      "LL",
      "[?]",
      "[?]",
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      "r'",
      "r`",
      "Rs",
      "Rs",
      "1/",
      "2/",
      "3/",
      "4/",
      " 1 - 1/",
      "/16",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x0a.js
var require_x0a = __commonJS({
  "node_modules/unidecode/data/x0a.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "[?]",
      "N",
      "[?]",
      "[?]",
      "a",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "ee",
      "ai",
      "[?]",
      "[?]",
      "oo",
      "au",
      "k",
      "kh",
      "g",
      "gh",
      "ng",
      "c",
      "ch",
      "j",
      "jh",
      "ny",
      "tt",
      "tth",
      "dd",
      "ddh",
      "nn",
      "t",
      "th",
      "d",
      "dh",
      "n",
      "[?]",
      "p",
      "ph",
      "b",
      "bb",
      "m",
      "y",
      "r",
      "[?]",
      "l",
      "ll",
      "[?]",
      "v",
      "sh",
      "[?]",
      "s",
      "h",
      "[?]",
      "[?]",
      "'",
      "[?]",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "ee",
      "ai",
      "[?]",
      "[?]",
      "oo",
      "au",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "khh",
      "ghh",
      "z",
      "rr",
      "[?]",
      "f",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      "N",
      "H",
      "",
      "",
      "G.E.O.",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "N",
      "N",
      "H",
      "[?]",
      "a",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "R",
      "[?]",
      "eN",
      "[?]",
      "e",
      "ai",
      "oN",
      "[?]",
      "o",
      "au",
      "k",
      "kh",
      "g",
      "gh",
      "ng",
      "c",
      "ch",
      "j",
      "jh",
      "ny",
      "tt",
      "tth",
      "dd",
      "ddh",
      "nn",
      "t",
      "th",
      "d",
      "dh",
      "n",
      "[?]",
      "p",
      "ph",
      "b",
      "bh",
      "m",
      "ya",
      "r",
      "[?]",
      "l",
      "ll",
      "[?]",
      "v",
      "sh",
      "ss",
      "s",
      "h",
      "[?]",
      "[?]",
      "'",
      "'",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "R",
      "RR",
      "eN",
      "[?]",
      "e",
      "ai",
      "oN",
      "[?]",
      "o",
      "au",
      "",
      "[?]",
      "[?]",
      "AUM",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "RR",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      ".",
      "R",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "zh",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x0b.js
var require_x0b = __commonJS({
  "node_modules/unidecode/data/x0b.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "N",
      "N",
      "H",
      "[?]",
      "a",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "R",
      "L",
      "[?]",
      "[?]",
      "e",
      "ai",
      "[?]",
      "[?]",
      "o",
      "au",
      "k",
      "kh",
      "g",
      "gh",
      "ng",
      "c",
      "ch",
      "j",
      "jh",
      "ny",
      "tt",
      "tth",
      "dd",
      "ddh",
      "nn",
      "t",
      "th",
      "d",
      "dh",
      "n",
      "[?]",
      "p",
      "ph",
      "b",
      "bh",
      "m",
      "y",
      "r",
      "[?]",
      "l",
      "ll",
      "[?]",
      "",
      "sh",
      "ss",
      "s",
      "h",
      "[?]",
      "[?]",
      "'",
      "'",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "R",
      "[?]",
      "[?]",
      "[?]",
      "e",
      "ai",
      "[?]",
      "[?]",
      "o",
      "au",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "+",
      "+",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "rr",
      "rh",
      "[?]",
      "yy",
      "RR",
      "LL",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "N",
      "H",
      "[?]",
      "a",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "[?]",
      "[?]",
      "[?]",
      "e",
      "ee",
      "ai",
      "[?]",
      "o",
      "oo",
      "au",
      "k",
      "[?]",
      "[?]",
      "[?]",
      "ng",
      "c",
      "[?]",
      "j",
      "[?]",
      "ny",
      "tt",
      "[?]",
      "[?]",
      "[?]",
      "nn",
      "t",
      "[?]",
      "[?]",
      "[?]",
      "n",
      "nnn",
      "p",
      "[?]",
      "[?]",
      "[?]",
      "m",
      "y",
      "r",
      "rr",
      "l",
      "ll",
      "lll",
      "v",
      "[?]",
      "ss",
      "s",
      "h",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "[?]",
      "[?]",
      "[?]",
      "e",
      "ee",
      "ai",
      "[?]",
      "o",
      "oo",
      "au",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "+",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      "+10+",
      "+100+",
      "+1000+",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x0c.js
var require_x0c = __commonJS({
  "node_modules/unidecode/data/x0c.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "N",
      "N",
      "H",
      "[?]",
      "a",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "R",
      "L",
      "[?]",
      "e",
      "ee",
      "ai",
      "[?]",
      "o",
      "oo",
      "au",
      "k",
      "kh",
      "g",
      "gh",
      "ng",
      "c",
      "ch",
      "j",
      "jh",
      "ny",
      "tt",
      "tth",
      "dd",
      "ddh",
      "nn",
      "t",
      "th",
      "d",
      "dh",
      "n",
      "[?]",
      "p",
      "ph",
      "b",
      "bh",
      "m",
      "y",
      "r",
      "rr",
      "l",
      "ll",
      "[?]",
      "v",
      "sh",
      "ss",
      "s",
      "h",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "R",
      "RR",
      "[?]",
      "e",
      "ee",
      "ai",
      "[?]",
      "o",
      "oo",
      "au",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "+",
      "+",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "RR",
      "LL",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "N",
      "H",
      "[?]",
      "a",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "R",
      "L",
      "[?]",
      "e",
      "ee",
      "ai",
      "[?]",
      "o",
      "oo",
      "au",
      "k",
      "kh",
      "g",
      "gh",
      "ng",
      "c",
      "ch",
      "j",
      "jh",
      "ny",
      "tt",
      "tth",
      "dd",
      "ddh",
      "nn",
      "t",
      "th",
      "d",
      "dh",
      "n",
      "[?]",
      "p",
      "ph",
      "b",
      "bh",
      "m",
      "y",
      "r",
      "rr",
      "l",
      "ll",
      "[?]",
      "v",
      "sh",
      "ss",
      "s",
      "h",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "R",
      "RR",
      "[?]",
      "e",
      "ee",
      "ai",
      "[?]",
      "o",
      "oo",
      "au",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "+",
      "+",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "lll",
      "[?]",
      "RR",
      "LL",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x0d.js
var require_x0d = __commonJS({
  "node_modules/unidecode/data/x0d.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "[?]",
      "N",
      "H",
      "[?]",
      "a",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "R",
      "L",
      "[?]",
      "e",
      "ee",
      "ai",
      "[?]",
      "o",
      "oo",
      "au",
      "k",
      "kh",
      "g",
      "gh",
      "ng",
      "c",
      "ch",
      "j",
      "jh",
      "ny",
      "tt",
      "tth",
      "dd",
      "ddh",
      "nn",
      "t",
      "th",
      "d",
      "dh",
      "n",
      "[?]",
      "p",
      "ph",
      "b",
      "bh",
      "m",
      "y",
      "r",
      "rr",
      "l",
      "ll",
      "lll",
      "v",
      "sh",
      "ss",
      "s",
      "h",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "R",
      "[?]",
      "[?]",
      "e",
      "ee",
      "ai",
      "",
      "o",
      "oo",
      "au",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "+",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "RR",
      "LL",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "N",
      "H",
      "[?]",
      "a",
      "aa",
      "ae",
      "aae",
      "i",
      "ii",
      "u",
      "uu",
      "R",
      "RR",
      "L",
      "LL",
      "e",
      "ee",
      "ai",
      "o",
      "oo",
      "au",
      "[?]",
      "[?]",
      "[?]",
      "k",
      "kh",
      "g",
      "gh",
      "ng",
      "nng",
      "c",
      "ch",
      "j",
      "jh",
      "ny",
      "jny",
      "nyj",
      "tt",
      "tth",
      "dd",
      "ddh",
      "nn",
      "nndd",
      "t",
      "th",
      "d",
      "dh",
      "n",
      "[?]",
      "nd",
      "p",
      "ph",
      "b",
      "bh",
      "m",
      "mb",
      "y",
      "r",
      "[?]",
      "l",
      "[?]",
      "[?]",
      "v",
      "sh",
      "ss",
      "s",
      "h",
      "ll",
      "f",
      "[?]",
      "[?]",
      "[?]",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "aa",
      "ae",
      "aae",
      "i",
      "ii",
      "u",
      "[?]",
      "uu",
      "[?]",
      "R",
      "e",
      "ee",
      "ai",
      "o",
      "oo",
      "au",
      "L",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "RR",
      "LL",
      " . ",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x0e.js
var require_x0e = __commonJS({
  "node_modules/unidecode/data/x0e.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "k",
      "kh",
      "kh",
      "kh",
      "kh",
      "kh",
      "ng",
      "cch",
      "ch",
      "ch",
      "ch",
      "ch",
      "y",
      "d",
      "t",
      "th",
      "th",
      "th",
      "n",
      "d",
      "t",
      "th",
      "th",
      "th",
      "n",
      "b",
      "p",
      "ph",
      "f",
      "ph",
      "f",
      "ph",
      "m",
      "y",
      "r",
      "R",
      "l",
      "L",
      "w",
      "s",
      "s",
      "s",
      "h",
      "l",
      "`",
      "h",
      "~",
      "a",
      "a",
      "aa",
      "am",
      "i",
      "ii",
      "ue",
      "uue",
      "u",
      "uu",
      "'",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "Bh.",
      "e",
      "ae",
      "o",
      "ai",
      "ai",
      "ao",
      "+",
      "",
      "",
      "",
      "",
      "",
      "",
      "M",
      "",
      " * ",
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      " // ",
      " /// ",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "k",
      "kh",
      "[?]",
      "kh",
      "[?]",
      "[?]",
      "ng",
      "ch",
      "[?]",
      "s",
      "[?]",
      "[?]",
      "ny",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "d",
      "h",
      "th",
      "th",
      "[?]",
      "n",
      "b",
      "p",
      "ph",
      "f",
      "ph",
      "f",
      "[?]",
      "m",
      "y",
      "r",
      "[?]",
      "l",
      "[?]",
      "w",
      "[?]",
      "[?]",
      "s",
      "h",
      "[?]",
      "`",
      "",
      "~",
      "a",
      "",
      "aa",
      "am",
      "i",
      "ii",
      "y",
      "yy",
      "u",
      "uu",
      "[?]",
      "o",
      "l",
      "ny",
      "[?]",
      "[?]",
      "e",
      "ei",
      "o",
      "ay",
      "ai",
      "[?]",
      "+",
      "[?]",
      "",
      "",
      "",
      "",
      "",
      "M",
      "[?]",
      "[?]",
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      "[?]",
      "[?]",
      "hn",
      "hm",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x0f.js
var require_x0f = __commonJS({
  "node_modules/unidecode/data/x0f.js"(exports2, module2) {
    module2.exports = [
      "AUM",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      " // ",
      " * ",
      "",
      "-",
      " / ",
      " / ",
      " // ",
      " -/ ",
      " +/ ",
      " X/ ",
      " /XX/ ",
      " /X/ ",
      ", ",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      ".5",
      "1.5",
      "2.5",
      "3.5",
      "4.5",
      "5.5",
      "6.5",
      "7.5",
      "8.5",
      "-.5",
      "+",
      "*",
      "^",
      "_",
      "",
      "~",
      "[?]",
      "]",
      "[[",
      "]]",
      "",
      "",
      "k",
      "kh",
      "g",
      "gh",
      "ng",
      "c",
      "ch",
      "j",
      "[?]",
      "ny",
      "tt",
      "tth",
      "dd",
      "ddh",
      "nn",
      "t",
      "th",
      "d",
      "dh",
      "n",
      "p",
      "ph",
      "b",
      "bh",
      "m",
      "ts",
      "tsh",
      "dz",
      "dzh",
      "w",
      "zh",
      "z",
      "'",
      "y",
      "r",
      "l",
      "sh",
      "ssh",
      "s",
      "h",
      "a",
      "kss",
      "r",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "R",
      "RR",
      "L",
      "LL",
      "e",
      "ee",
      "o",
      "oo",
      "M",
      "H",
      "i",
      "ii",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "k",
      "kh",
      "g",
      "gh",
      "ng",
      "c",
      "ch",
      "j",
      "[?]",
      "ny",
      "tt",
      "tth",
      "dd",
      "ddh",
      "nn",
      "t",
      "th",
      "d",
      "dh",
      "n",
      "p",
      "ph",
      "b",
      "bh",
      "m",
      "ts",
      "tsh",
      "dz",
      "dzh",
      "w",
      "zh",
      "z",
      "'",
      "y",
      "r",
      "l",
      "sh",
      "ss",
      "s",
      "h",
      "a",
      "kss",
      "w",
      "y",
      "r",
      "[?]",
      "X",
      " :X: ",
      " /O/ ",
      " /o/ ",
      " \\\\o\\\\ ",
      " (O) ",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "[?]",
      "[?]",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x10.js
var require_x10 = __commonJS({
  "node_modules/unidecode/data/x10.js"(exports2, module2) {
    module2.exports = [
      "k",
      "kh",
      "g",
      "gh",
      "ng",
      "c",
      "ch",
      "j",
      "jh",
      "ny",
      "nny",
      "tt",
      "tth",
      "dd",
      "ddh",
      "nn",
      "tt",
      "th",
      "d",
      "dh",
      "n",
      "p",
      "ph",
      "b",
      "bh",
      "m",
      "y",
      "r",
      "l",
      "w",
      "s",
      "h",
      "ll",
      "a",
      "[?]",
      "i",
      "ii",
      "u",
      "uu",
      "e",
      "[?]",
      "o",
      "au",
      "[?]",
      "aa",
      "i",
      "ii",
      "u",
      "uu",
      "e",
      "ai",
      "[?]",
      "[?]",
      "[?]",
      "N",
      "'",
      ":",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      " / ",
      " // ",
      "n*",
      "r*",
      "l*",
      "e*",
      "sh",
      "ss",
      "R",
      "RR",
      "L",
      "LL",
      "R",
      "RR",
      "L",
      "LL",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "A",
      "B",
      "G",
      "D",
      "E",
      "V",
      "Z",
      "T`",
      "I",
      "K",
      "L",
      "M",
      "N",
      "O",
      "P",
      "Zh",
      "R",
      "S",
      "T",
      "U",
      "P`",
      "K`",
      "G'",
      "Q",
      "Sh",
      "Ch`",
      "C`",
      "Z'",
      "C",
      "Ch",
      "X",
      "J",
      "H",
      "E",
      "Y",
      "W",
      "Xh",
      "OE",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "a",
      "b",
      "g",
      "d",
      "e",
      "v",
      "z",
      "t`",
      "i",
      "k",
      "l",
      "m",
      "n",
      "o",
      "p",
      "zh",
      "r",
      "s",
      "t",
      "u",
      "p`",
      "k`",
      "g'",
      "q",
      "sh",
      "ch`",
      "c`",
      "z'",
      "c",
      "ch",
      "x",
      "j",
      "h",
      "e",
      "y",
      "w",
      "xh",
      "oe",
      "f",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      " // ",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x11.js
var require_x11 = __commonJS({
  "node_modules/unidecode/data/x11.js"(exports2, module2) {
    module2.exports = [
      "g",
      "gg",
      "n",
      "d",
      "dd",
      "r",
      "m",
      "b",
      "bb",
      "s",
      "ss",
      "",
      "j",
      "jj",
      "c",
      "k",
      "t",
      "p",
      "h",
      "ng",
      "nn",
      "nd",
      "nb",
      "dg",
      "rn",
      "rr",
      "rh",
      "rN",
      "mb",
      "mN",
      "bg",
      "bn",
      "",
      "bs",
      "bsg",
      "bst",
      "bsb",
      "bss",
      "bsj",
      "bj",
      "bc",
      "bt",
      "bp",
      "bN",
      "bbN",
      "sg",
      "sn",
      "sd",
      "sr",
      "sm",
      "sb",
      "sbg",
      "sss",
      "s",
      "sj",
      "sc",
      "sk",
      "st",
      "sp",
      "sh",
      "",
      "",
      "",
      "",
      "Z",
      "g",
      "d",
      "m",
      "b",
      "s",
      "Z",
      "",
      "j",
      "c",
      "t",
      "p",
      "N",
      "j",
      "",
      "",
      "",
      "",
      "ck",
      "ch",
      "",
      "",
      "pb",
      "pN",
      "hh",
      "Q",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "",
      "",
      "a",
      "ae",
      "ya",
      "yae",
      "eo",
      "e",
      "yeo",
      "ye",
      "o",
      "wa",
      "wae",
      "oe",
      "yo",
      "u",
      "weo",
      "we",
      "wi",
      "yu",
      "eu",
      "yi",
      "i",
      "a-o",
      "a-u",
      "ya-o",
      "ya-yo",
      "eo-o",
      "eo-u",
      "eo-eu",
      "yeo-o",
      "yeo-u",
      "o-eo",
      "o-e",
      "o-ye",
      "o-o",
      "o-u",
      "yo-ya",
      "yo-yae",
      "yo-yeo",
      "yo-o",
      "yo-i",
      "u-a",
      "u-ae",
      "u-eo-eu",
      "u-ye",
      "u-u",
      "yu-a",
      "yu-eo",
      "yu-e",
      "yu-yeo",
      "yu-ye",
      "yu-u",
      "yu-i",
      "eu-u",
      "eu-eu",
      "yi-u",
      "i-a",
      "i-ya",
      "i-o",
      "i-u",
      "i-eu",
      "i-U",
      "U",
      "U-eo",
      "U-u",
      "U-i",
      "UU",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "g",
      "gg",
      "gs",
      "n",
      "nj",
      "nh",
      "d",
      "l",
      "lg",
      "lm",
      "lb",
      "ls",
      "lt",
      "lp",
      "lh",
      "m",
      "b",
      "bs",
      "s",
      "ss",
      "ng",
      "j",
      "c",
      "k",
      "t",
      "p",
      "h",
      "gl",
      "gsg",
      "ng",
      "nd",
      "ns",
      "nZ",
      "nt",
      "dg",
      "tl",
      "lgs",
      "ln",
      "ld",
      "lth",
      "ll",
      "lmg",
      "lms",
      "lbs",
      "lbh",
      "rNp",
      "lss",
      "lZ",
      "lk",
      "lQ",
      "mg",
      "ml",
      "mb",
      "ms",
      "mss",
      "mZ",
      "mc",
      "mh",
      "mN",
      "bl",
      "bp",
      "ph",
      "pN",
      "sg",
      "sd",
      "sl",
      "sb",
      "Z",
      "g",
      "ss",
      "",
      "kh",
      "N",
      "Ns",
      "NZ",
      "pb",
      "pN",
      "hn",
      "hl",
      "hm",
      "hb",
      "Q",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x12.js
var require_x12 = __commonJS({
  "node_modules/unidecode/data/x12.js"(exports2, module2) {
    module2.exports = [
      "ha",
      "hu",
      "hi",
      "haa",
      "hee",
      "he",
      "ho",
      "[?]",
      "la",
      "lu",
      "li",
      "laa",
      "lee",
      "le",
      "lo",
      "lwa",
      "hha",
      "hhu",
      "hhi",
      "hhaa",
      "hhee",
      "hhe",
      "hho",
      "hhwa",
      "ma",
      "mu",
      "mi",
      "maa",
      "mee",
      "me",
      "mo",
      "mwa",
      "sza",
      "szu",
      "szi",
      "szaa",
      "szee",
      "sze",
      "szo",
      "szwa",
      "ra",
      "ru",
      "ri",
      "raa",
      "ree",
      "re",
      "ro",
      "rwa",
      "sa",
      "su",
      "si",
      "saa",
      "see",
      "se",
      "so",
      "swa",
      "sha",
      "shu",
      "shi",
      "shaa",
      "shee",
      "she",
      "sho",
      "shwa",
      "qa",
      "qu",
      "qi",
      "qaa",
      "qee",
      "qe",
      "qo",
      "[?]",
      "qwa",
      "[?]",
      "qwi",
      "qwaa",
      "qwee",
      "qwe",
      "[?]",
      "[?]",
      "qha",
      "qhu",
      "qhi",
      "qhaa",
      "qhee",
      "qhe",
      "qho",
      "[?]",
      "qhwa",
      "[?]",
      "qhwi",
      "qhwaa",
      "qhwee",
      "qhwe",
      "[?]",
      "[?]",
      "ba",
      "bu",
      "bi",
      "baa",
      "bee",
      "be",
      "bo",
      "bwa",
      "va",
      "vu",
      "vi",
      "vaa",
      "vee",
      "ve",
      "vo",
      "vwa",
      "ta",
      "tu",
      "ti",
      "taa",
      "tee",
      "te",
      "to",
      "twa",
      "ca",
      "cu",
      "ci",
      "caa",
      "cee",
      "ce",
      "co",
      "cwa",
      "xa",
      "xu",
      "xi",
      "xaa",
      "xee",
      "xe",
      "xo",
      "[?]",
      "xwa",
      "[?]",
      "xwi",
      "xwaa",
      "xwee",
      "xwe",
      "[?]",
      "[?]",
      "na",
      "nu",
      "ni",
      "naa",
      "nee",
      "ne",
      "no",
      "nwa",
      "nya",
      "nyu",
      "nyi",
      "nyaa",
      "nyee",
      "nye",
      "nyo",
      "nywa",
      "'a",
      "'u",
      "[?]",
      "'aa",
      "'ee",
      "'e",
      "'o",
      "'wa",
      "ka",
      "ku",
      "ki",
      "kaa",
      "kee",
      "ke",
      "ko",
      "[?]",
      "kwa",
      "[?]",
      "kwi",
      "kwaa",
      "kwee",
      "kwe",
      "[?]",
      "[?]",
      "kxa",
      "kxu",
      "kxi",
      "kxaa",
      "kxee",
      "kxe",
      "kxo",
      "[?]",
      "kxwa",
      "[?]",
      "kxwi",
      "kxwaa",
      "kxwee",
      "kxwe",
      "[?]",
      "[?]",
      "wa",
      "wu",
      "wi",
      "waa",
      "wee",
      "we",
      "wo",
      "[?]",
      "`a",
      "`u",
      "`i",
      "`aa",
      "`ee",
      "`e",
      "`o",
      "[?]",
      "za",
      "zu",
      "zi",
      "zaa",
      "zee",
      "ze",
      "zo",
      "zwa",
      "zha",
      "zhu",
      "zhi",
      "zhaa",
      "zhee",
      "zhe",
      "zho",
      "zhwa",
      "ya",
      "yu",
      "yi",
      "yaa",
      "yee",
      "ye",
      "yo",
      "[?]",
      "da",
      "du",
      "di",
      "daa",
      "dee",
      "de",
      "do",
      "dwa",
      "dda",
      "ddu",
      "ddi",
      "ddaa",
      "ddee",
      "dde",
      "ddo",
      "ddwa"
    ];
  }
});

// node_modules/unidecode/data/x13.js
var require_x13 = __commonJS({
  "node_modules/unidecode/data/x13.js"(exports2, module2) {
    module2.exports = [
      "ja",
      "ju",
      "ji",
      "jaa",
      "jee",
      "je",
      "jo",
      "jwa",
      "ga",
      "gu",
      "gi",
      "gaa",
      "gee",
      "ge",
      "go",
      "[?]",
      "gwa",
      "[?]",
      "gwi",
      "gwaa",
      "gwee",
      "gwe",
      "[?]",
      "[?]",
      "gga",
      "ggu",
      "ggi",
      "ggaa",
      "ggee",
      "gge",
      "ggo",
      "[?]",
      "tha",
      "thu",
      "thi",
      "thaa",
      "thee",
      "the",
      "tho",
      "thwa",
      "cha",
      "chu",
      "chi",
      "chaa",
      "chee",
      "che",
      "cho",
      "chwa",
      "pha",
      "phu",
      "phi",
      "phaa",
      "phee",
      "phe",
      "pho",
      "phwa",
      "tsa",
      "tsu",
      "tsi",
      "tsaa",
      "tsee",
      "tse",
      "tso",
      "tswa",
      "tza",
      "tzu",
      "tzi",
      "tzaa",
      "tzee",
      "tze",
      "tzo",
      "[?]",
      "fa",
      "fu",
      "fi",
      "faa",
      "fee",
      "fe",
      "fo",
      "fwa",
      "pa",
      "pu",
      "pi",
      "paa",
      "pee",
      "pe",
      "po",
      "pwa",
      "rya",
      "mya",
      "fya",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      " ",
      ".",
      ",",
      ";",
      ":",
      ":: ",
      "?",
      "//",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      "10+",
      "20+",
      "30+",
      "40+",
      "50+",
      "60+",
      "70+",
      "80+",
      "90+",
      "100+",
      "10,000+",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "a",
      "e",
      "i",
      "o",
      "u",
      "v",
      "ga",
      "ka",
      "ge",
      "gi",
      "go",
      "gu",
      "gv",
      "ha",
      "he",
      "hi",
      "ho",
      "hu",
      "hv",
      "la",
      "le",
      "li",
      "lo",
      "lu",
      "lv",
      "ma",
      "me",
      "mi",
      "mo",
      "mu",
      "na",
      "hna",
      "nah",
      "ne",
      "ni",
      "no",
      "nu",
      "nv",
      "qua",
      "que",
      "qui",
      "quo",
      "quu",
      "quv",
      "sa",
      "s",
      "se",
      "si",
      "so",
      "su",
      "sv",
      "da",
      "ta",
      "de",
      "te",
      "di",
      "ti",
      "do",
      "du",
      "dv",
      "dla",
      "tla",
      "tle",
      "tli",
      "tlo",
      "tlu",
      "tlv",
      "tsa",
      "tse",
      "tsi",
      "tso",
      "tsu",
      "tsv",
      "wa",
      "we",
      "wi",
      "wo",
      "wu",
      "wv",
      "ya",
      "ye",
      "yi",
      "yo",
      "yu",
      "yv",
      "MV",
      "[?]",
      "[?]",
      "ye",
      "yi",
      "yo",
      "yu",
      "yv",
      "mv",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x14.js
var require_x14 = __commonJS({
  "node_modules/unidecode/data/x14.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "e",
      "aai",
      "i",
      "ii",
      "o",
      "oo",
      "oo",
      "ee",
      "i",
      "a",
      "aa",
      "we",
      "we",
      "wi",
      "wi",
      "wii",
      "wii",
      "wo",
      "wo",
      "woo",
      "woo",
      "woo",
      "wa",
      "wa",
      "waa",
      "waa",
      "waa",
      "ai",
      "w",
      "'",
      "t",
      "k",
      "sh",
      "s",
      "n",
      "w",
      "n",
      "[?]",
      "w",
      "c",
      "?",
      "l",
      "en",
      "in",
      "on",
      "an",
      "pe",
      "paai",
      "pi",
      "pii",
      "po",
      "poo",
      "poo",
      "hee",
      "hi",
      "pa",
      "paa",
      "pwe",
      "pwe",
      "pwi",
      "pwi",
      "pwii",
      "pwii",
      "pwo",
      "pwo",
      "pwoo",
      "pwoo",
      "pwa",
      "pwa",
      "pwaa",
      "pwaa",
      "pwaa",
      "p",
      "p",
      "h",
      "te",
      "taai",
      "ti",
      "tii",
      "to",
      "too",
      "too",
      "dee",
      "di",
      "ta",
      "taa",
      "twe",
      "twe",
      "twi",
      "twi",
      "twii",
      "twii",
      "two",
      "two",
      "twoo",
      "twoo",
      "twa",
      "twa",
      "twaa",
      "twaa",
      "twaa",
      "t",
      "tte",
      "tti",
      "tto",
      "tta",
      "ke",
      "kaai",
      "ki",
      "kii",
      "ko",
      "koo",
      "koo",
      "ka",
      "kaa",
      "kwe",
      "kwe",
      "kwi",
      "kwi",
      "kwii",
      "kwii",
      "kwo",
      "kwo",
      "kwoo",
      "kwoo",
      "kwa",
      "kwa",
      "kwaa",
      "kwaa",
      "kwaa",
      "k",
      "kw",
      "keh",
      "kih",
      "koh",
      "kah",
      "ce",
      "caai",
      "ci",
      "cii",
      "co",
      "coo",
      "coo",
      "ca",
      "caa",
      "cwe",
      "cwe",
      "cwi",
      "cwi",
      "cwii",
      "cwii",
      "cwo",
      "cwo",
      "cwoo",
      "cwoo",
      "cwa",
      "cwa",
      "cwaa",
      "cwaa",
      "cwaa",
      "c",
      "th",
      "me",
      "maai",
      "mi",
      "mii",
      "mo",
      "moo",
      "moo",
      "ma",
      "maa",
      "mwe",
      "mwe",
      "mwi",
      "mwi",
      "mwii",
      "mwii",
      "mwo",
      "mwo",
      "mwoo",
      "mwoo",
      "mwa",
      "mwa",
      "mwaa",
      "mwaa",
      "mwaa",
      "m",
      "m",
      "mh",
      "m",
      "m",
      "ne",
      "naai",
      "ni",
      "nii",
      "no",
      "noo",
      "noo",
      "na",
      "naa",
      "nwe",
      "nwe",
      "nwa",
      "nwa",
      "nwaa",
      "nwaa",
      "nwaa",
      "n",
      "ng",
      "nh",
      "le",
      "laai",
      "li",
      "lii",
      "lo",
      "loo",
      "loo",
      "la",
      "laa",
      "lwe",
      "lwe",
      "lwi",
      "lwi",
      "lwii",
      "lwii",
      "lwo",
      "lwo",
      "lwoo",
      "lwoo",
      "lwa",
      "lwa",
      "lwaa",
      "lwaa",
      "l",
      "l",
      "l",
      "se",
      "saai",
      "si",
      "sii",
      "so",
      "soo",
      "soo",
      "sa",
      "saa",
      "swe",
      "swe",
      "swi",
      "swi",
      "swii",
      "swii",
      "swo",
      "swo",
      "swoo",
      "swoo"
    ];
  }
});

// node_modules/unidecode/data/x15.js
var require_x15 = __commonJS({
  "node_modules/unidecode/data/x15.js"(exports2, module2) {
    module2.exports = [
      "swa",
      "swa",
      "swaa",
      "swaa",
      "swaa",
      "s",
      "s",
      "sw",
      "s",
      "sk",
      "skw",
      "sW",
      "spwa",
      "stwa",
      "skwa",
      "scwa",
      "she",
      "shi",
      "shii",
      "sho",
      "shoo",
      "sha",
      "shaa",
      "shwe",
      "shwe",
      "shwi",
      "shwi",
      "shwii",
      "shwii",
      "shwo",
      "shwo",
      "shwoo",
      "shwoo",
      "shwa",
      "shwa",
      "shwaa",
      "shwaa",
      "sh",
      "ye",
      "yaai",
      "yi",
      "yii",
      "yo",
      "yoo",
      "yoo",
      "ya",
      "yaa",
      "ywe",
      "ywe",
      "ywi",
      "ywi",
      "ywii",
      "ywii",
      "ywo",
      "ywo",
      "ywoo",
      "ywoo",
      "ywa",
      "ywa",
      "ywaa",
      "ywaa",
      "ywaa",
      "y",
      "y",
      "y",
      "yi",
      "re",
      "re",
      "le",
      "raai",
      "ri",
      "rii",
      "ro",
      "roo",
      "lo",
      "ra",
      "raa",
      "la",
      "rwaa",
      "rwaa",
      "r",
      "r",
      "r",
      "fe",
      "faai",
      "fi",
      "fii",
      "fo",
      "foo",
      "fa",
      "faa",
      "fwaa",
      "fwaa",
      "f",
      "the",
      "the",
      "thi",
      "thi",
      "thii",
      "thii",
      "tho",
      "thoo",
      "tha",
      "thaa",
      "thwaa",
      "thwaa",
      "th",
      "tthe",
      "tthi",
      "ttho",
      "ttha",
      "tth",
      "tye",
      "tyi",
      "tyo",
      "tya",
      "he",
      "hi",
      "hii",
      "ho",
      "hoo",
      "ha",
      "haa",
      "h",
      "h",
      "hk",
      "qaai",
      "qi",
      "qii",
      "qo",
      "qoo",
      "qa",
      "qaa",
      "q",
      "tlhe",
      "tlhi",
      "tlho",
      "tlha",
      "re",
      "ri",
      "ro",
      "ra",
      "ngaai",
      "ngi",
      "ngii",
      "ngo",
      "ngoo",
      "nga",
      "ngaa",
      "ng",
      "nng",
      "she",
      "shi",
      "sho",
      "sha",
      "the",
      "thi",
      "tho",
      "tha",
      "th",
      "lhi",
      "lhii",
      "lho",
      "lhoo",
      "lha",
      "lhaa",
      "lh",
      "the",
      "thi",
      "thii",
      "tho",
      "thoo",
      "tha",
      "thaa",
      "th",
      "b",
      "e",
      "i",
      "o",
      "a",
      "we",
      "wi",
      "wo",
      "wa",
      "ne",
      "ni",
      "no",
      "na",
      "ke",
      "ki",
      "ko",
      "ka",
      "he",
      "hi",
      "ho",
      "ha",
      "ghu",
      "gho",
      "ghe",
      "ghee",
      "ghi",
      "gha",
      "ru",
      "ro",
      "re",
      "ree",
      "ri",
      "ra",
      "wu",
      "wo",
      "we",
      "wee",
      "wi",
      "wa",
      "hwu",
      "hwo",
      "hwe",
      "hwee",
      "hwi",
      "hwa",
      "thu",
      "tho",
      "the",
      "thee",
      "thi",
      "tha",
      "ttu",
      "tto",
      "tte",
      "ttee",
      "tti",
      "tta",
      "pu",
      "po",
      "pe",
      "pee",
      "pi",
      "pa",
      "p",
      "gu",
      "go",
      "ge",
      "gee",
      "gi",
      "ga",
      "khu",
      "kho",
      "khe",
      "khee",
      "khi",
      "kha",
      "kku",
      "kko",
      "kke",
      "kkee",
      "kki"
    ];
  }
});

// node_modules/unidecode/data/x16.js
var require_x16 = __commonJS({
  "node_modules/unidecode/data/x16.js"(exports2, module2) {
    module2.exports = [
      "kka",
      "kk",
      "nu",
      "no",
      "ne",
      "nee",
      "ni",
      "na",
      "mu",
      "mo",
      "me",
      "mee",
      "mi",
      "ma",
      "yu",
      "yo",
      "ye",
      "yee",
      "yi",
      "ya",
      "ju",
      "ju",
      "jo",
      "je",
      "jee",
      "ji",
      "ji",
      "ja",
      "jju",
      "jjo",
      "jje",
      "jjee",
      "jji",
      "jja",
      "lu",
      "lo",
      "le",
      "lee",
      "li",
      "la",
      "dlu",
      "dlo",
      "dle",
      "dlee",
      "dli",
      "dla",
      "lhu",
      "lho",
      "lhe",
      "lhee",
      "lhi",
      "lha",
      "tlhu",
      "tlho",
      "tlhe",
      "tlhee",
      "tlhi",
      "tlha",
      "tlu",
      "tlo",
      "tle",
      "tlee",
      "tli",
      "tla",
      "zu",
      "zo",
      "ze",
      "zee",
      "zi",
      "za",
      "z",
      "z",
      "dzu",
      "dzo",
      "dze",
      "dzee",
      "dzi",
      "dza",
      "su",
      "so",
      "se",
      "see",
      "si",
      "sa",
      "shu",
      "sho",
      "she",
      "shee",
      "shi",
      "sha",
      "sh",
      "tsu",
      "tso",
      "tse",
      "tsee",
      "tsi",
      "tsa",
      "chu",
      "cho",
      "che",
      "chee",
      "chi",
      "cha",
      "ttsu",
      "ttso",
      "ttse",
      "ttsee",
      "ttsi",
      "ttsa",
      "X",
      ".",
      "qai",
      "ngai",
      "nngi",
      "nngii",
      "nngo",
      "nngoo",
      "nnga",
      "nngaa",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      " ",
      "b",
      "l",
      "f",
      "s",
      "n",
      "h",
      "d",
      "t",
      "c",
      "q",
      "m",
      "g",
      "ng",
      "z",
      "r",
      "a",
      "o",
      "u",
      "e",
      "i",
      "ch",
      "th",
      "ph",
      "p",
      "x",
      "p",
      "<",
      ">",
      "[?]",
      "[?]",
      "[?]",
      "f",
      "v",
      "u",
      "yr",
      "y",
      "w",
      "th",
      "th",
      "a",
      "o",
      "ac",
      "ae",
      "o",
      "o",
      "o",
      "oe",
      "on",
      "r",
      "k",
      "c",
      "k",
      "g",
      "ng",
      "g",
      "g",
      "w",
      "h",
      "h",
      "h",
      "h",
      "n",
      "n",
      "n",
      "i",
      "e",
      "j",
      "g",
      "ae",
      "a",
      "eo",
      "p",
      "z",
      "s",
      "s",
      "s",
      "c",
      "z",
      "t",
      "t",
      "d",
      "b",
      "b",
      "p",
      "p",
      "e",
      "m",
      "m",
      "m",
      "l",
      "l",
      "ng",
      "ng",
      "d",
      "o",
      "ear",
      "ior",
      "qu",
      "qu",
      "qu",
      "s",
      "yr",
      "yr",
      "yr",
      "q",
      "x",
      ".",
      ":",
      "+",
      "17",
      "18",
      "19",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x17.js
var require_x17 = __commonJS({
  "node_modules/unidecode/data/x17.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "k",
      "kh",
      "g",
      "gh",
      "ng",
      "c",
      "ch",
      "j",
      "jh",
      "ny",
      "t",
      "tth",
      "d",
      "ddh",
      "nn",
      "t",
      "th",
      "d",
      "dh",
      "n",
      "p",
      "ph",
      "b",
      "bh",
      "m",
      "y",
      "r",
      "l",
      "v",
      "sh",
      "ss",
      "s",
      "h",
      "l",
      "q",
      "a",
      "aa",
      "i",
      "ii",
      "u",
      "uk",
      "uu",
      "uuv",
      "ry",
      "ryy",
      "ly",
      "lyy",
      "e",
      "ai",
      "oo",
      "oo",
      "au",
      "a",
      "aa",
      "aa",
      "i",
      "ii",
      "y",
      "yy",
      "u",
      "uu",
      "ua",
      "oe",
      "ya",
      "ie",
      "e",
      "ae",
      "ai",
      "oo",
      "au",
      "M",
      "H",
      "a`",
      "",
      "",
      "",
      "r",
      "",
      "!",
      "",
      "",
      "",
      "",
      "",
      ".",
      " // ",
      ":",
      "+",
      "++",
      " * ",
      " /// ",
      "KR",
      "'",
      "[?]",
      "[?]",
      "[?]",
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x18.js
var require_x18 = __commonJS({
  "node_modules/unidecode/data/x18.js"(exports2, module2) {
    module2.exports = [
      " \\@ ",
      " ... ",
      ", ",
      ". ",
      ": ",
      " // ",
      "",
      "-",
      ", ",
      ". ",
      "",
      "",
      "",
      "",
      "",
      "[?]",
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "a",
      "e",
      "i",
      "o",
      "u",
      "O",
      "U",
      "ee",
      "n",
      "ng",
      "b",
      "p",
      "q",
      "g",
      "m",
      "l",
      "s",
      "sh",
      "t",
      "d",
      "ch",
      "j",
      "y",
      "r",
      "w",
      "f",
      "k",
      "kha",
      "ts",
      "z",
      "h",
      "zr",
      "lh",
      "zh",
      "ch",
      "-",
      "e",
      "i",
      "o",
      "u",
      "O",
      "U",
      "ng",
      "b",
      "p",
      "q",
      "g",
      "m",
      "t",
      "d",
      "ch",
      "j",
      "ts",
      "y",
      "w",
      "k",
      "g",
      "h",
      "jy",
      "ny",
      "dz",
      "e",
      "i",
      "iy",
      "U",
      "u",
      "ng",
      "k",
      "g",
      "h",
      "p",
      "sh",
      "t",
      "d",
      "j",
      "f",
      "g",
      "h",
      "ts",
      "z",
      "r",
      "ch",
      "zh",
      "i",
      "k",
      "r",
      "f",
      "zh",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "H",
      "X",
      "W",
      "M",
      " 3 ",
      " 333 ",
      "a",
      "i",
      "k",
      "ng",
      "c",
      "tt",
      "tth",
      "dd",
      "nn",
      "t",
      "d",
      "p",
      "ph",
      "ss",
      "zh",
      "z",
      "a",
      "t",
      "zh",
      "gh",
      "ng",
      "c",
      "jh",
      "tta",
      "ddh",
      "t",
      "dh",
      "ss",
      "cy",
      "zh",
      "z",
      "u",
      "y",
      "bh",
      "'",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x19.js
var require_x19 = __commonJS({
  "node_modules/unidecode/data/x19.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x1a.js
var require_x1a = __commonJS({
  "node_modules/unidecode/data/x1a.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x1b.js
var require_x1b = __commonJS({
  "node_modules/unidecode/data/x1b.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x1c.js
var require_x1c = __commonJS({
  "node_modules/unidecode/data/x1c.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x1d.js
var require_x1d = __commonJS({
  "node_modules/unidecode/data/x1d.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x1e.js
var require_x1e = __commonJS({
  "node_modules/unidecode/data/x1e.js"(exports2, module2) {
    module2.exports = [
      "A",
      "a",
      "B",
      "b",
      "B",
      "b",
      "B",
      "b",
      "C",
      "c",
      "D",
      "d",
      "D",
      "d",
      "D",
      "d",
      "D",
      "d",
      "D",
      "d",
      "E",
      "e",
      "E",
      "e",
      "E",
      "e",
      "E",
      "e",
      "E",
      "e",
      "F",
      "f",
      "G",
      "g",
      "H",
      "h",
      "H",
      "h",
      "H",
      "h",
      "H",
      "h",
      "H",
      "h",
      "I",
      "i",
      "I",
      "i",
      "K",
      "k",
      "K",
      "k",
      "K",
      "k",
      "L",
      "l",
      "L",
      "l",
      "L",
      "l",
      "L",
      "l",
      "M",
      "m",
      "M",
      "m",
      "M",
      "m",
      "N",
      "n",
      "N",
      "n",
      "N",
      "n",
      "N",
      "n",
      "O",
      "o",
      "O",
      "o",
      "O",
      "o",
      "O",
      "o",
      "P",
      "p",
      "P",
      "p",
      "R",
      "r",
      "R",
      "r",
      "R",
      "r",
      "R",
      "r",
      "S",
      "s",
      "S",
      "s",
      "S",
      "s",
      "S",
      "s",
      "S",
      "s",
      "T",
      "t",
      "T",
      "t",
      "T",
      "t",
      "T",
      "t",
      "U",
      "u",
      "U",
      "u",
      "U",
      "u",
      "U",
      "u",
      "U",
      "u",
      "V",
      "v",
      "V",
      "v",
      "W",
      "w",
      "W",
      "w",
      "W",
      "w",
      "W",
      "w",
      "W",
      "w",
      "X",
      "x",
      "X",
      "x",
      "Y",
      "y",
      "Z",
      "z",
      "Z",
      "z",
      "Z",
      "z",
      "h",
      "t",
      "w",
      "y",
      "a",
      "s",
      "s",
      "s",
      "Ss",
      "d",
      "A",
      "a",
      "A",
      "a",
      "A",
      "a",
      "A",
      "a",
      "A",
      "a",
      "A",
      "a",
      "A",
      "a",
      "A",
      "a",
      "A",
      "a",
      "A",
      "a",
      "A",
      "a",
      "A",
      "a",
      "E",
      "e",
      "E",
      "e",
      "E",
      "e",
      "E",
      "e",
      "E",
      "e",
      "E",
      "e",
      "E",
      "e",
      "E",
      "e",
      "I",
      "i",
      "I",
      "i",
      "O",
      "o",
      "O",
      "o",
      "O",
      "o",
      "O",
      "o",
      "O",
      "o",
      "O",
      "o",
      "O",
      "o",
      "O",
      "o",
      "O",
      "o",
      "O",
      "o",
      "O",
      "o",
      "O",
      "o",
      "U",
      "u",
      "U",
      "u",
      "U",
      "u",
      "U",
      "u",
      "U",
      "u",
      "U",
      "u",
      //  0x1EF_:
      "U",
      // 1EF0	LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
      // 	: 01AF 0323
      "u",
      // 1EF1	LATIN SMALL LETTER U WITH HORN AND DOT BELOW
      // 	: 01B0 0323
      // @		Latin general extensions
      "Y",
      // 1EF2	LATIN CAPITAL LETTER Y WITH GRAVE
      // 	: 0059 0300
      "y",
      // 1EF3	LATIN SMALL LETTER Y WITH GRAVE
      // 	* Welsh
      // 	: 0079 0300
      "Y",
      // 1EF4	LATIN CAPITAL LETTER Y WITH DOT BELOW
      // 	: 0059 0323
      "y",
      // 1EF5	LATIN SMALL LETTER Y WITH DOT BELOW
      // 	: 0079 0323
      "Y",
      // 1EF6	LATIN CAPITAL LETTER Y WITH HOOK ABOVE
      // 	: 0059 0309
      "y",
      // 1EF7	LATIN SMALL LETTER Y WITH HOOK ABOVE
      // 	: 0079 0309
      "Y",
      // 1EF8	LATIN CAPITAL LETTER Y WITH TILDE
      // 	: 0059 0303
      "y",
      // 1EF9	LATIN SMALL LETTER Y WITH TILDE
      // 	: 0079 0303
      // @		Medievalist additions
      "LL",
      // 1EFA	LATIN CAPITAL LETTER MIDDLE-WELSH LL
      "ll",
      // 1EFB	LATIN SMALL LETTER MIDDLE-WELSH LL
      "V",
      // 1EFC	LATIN CAPITAL LETTER MIDDLE-WELSH V
      "v",
      // 1EFD	LATIN SMALL LETTER MIDDLE-WELSH V
      "Y",
      // 1EFE	LATIN CAPITAL LETTER Y WITH LOOP
      "y"
      // 1EFF	LATIN SMALL LETTER Y WITH LOOP
    ];
  }
});

// node_modules/unidecode/data/x1f.js
var require_x1f = __commonJS({
  "node_modules/unidecode/data/x1f.js"(exports2, module2) {
    module2.exports = [
      "a",
      "a",
      "a",
      "a",
      "a",
      "a",
      "a",
      "a",
      "A",
      "A",
      "A",
      "A",
      "A",
      "A",
      "A",
      "A",
      "e",
      "e",
      "e",
      "e",
      "e",
      "e",
      "[?]",
      "[?]",
      "E",
      "E",
      "E",
      "E",
      "E",
      "E",
      "[?]",
      "[?]",
      "e",
      "e",
      "e",
      "e",
      "e",
      "e",
      "e",
      "e",
      "E",
      "E",
      "E",
      "E",
      "E",
      "E",
      "E",
      "E",
      "i",
      "i",
      "i",
      "i",
      "i",
      "i",
      "i",
      "i",
      "I",
      "I",
      "I",
      "I",
      "I",
      "I",
      "I",
      "I",
      "o",
      "o",
      "o",
      "o",
      "o",
      "o",
      "[?]",
      "[?]",
      "O",
      "O",
      "O",
      "O",
      "O",
      "O",
      "[?]",
      "[?]",
      "u",
      "u",
      "u",
      "u",
      "u",
      "u",
      "u",
      "u",
      "[?]",
      "U",
      "[?]",
      "U",
      "[?]",
      "U",
      "[?]",
      "U",
      "o",
      "o",
      "o",
      "o",
      "o",
      "o",
      "o",
      "o",
      "O",
      "O",
      "O",
      "O",
      "O",
      "O",
      "O",
      "O",
      "a",
      "a",
      "e",
      "e",
      "e",
      "e",
      "i",
      "i",
      "o",
      "o",
      "u",
      "u",
      "o",
      "o",
      "[?]",
      "[?]",
      "a",
      "a",
      "a",
      "a",
      "a",
      "a",
      "a",
      "a",
      "A",
      "A",
      "A",
      "A",
      "A",
      "A",
      "A",
      "A",
      "e",
      "e",
      "e",
      "e",
      "e",
      "e",
      "e",
      "e",
      "E",
      "E",
      "E",
      "E",
      "E",
      "E",
      "E",
      "E",
      "o",
      "o",
      "o",
      "o",
      "o",
      "o",
      "o",
      "o",
      "O",
      "O",
      "O",
      "O",
      "O",
      "O",
      "O",
      "O",
      "a",
      "a",
      "a",
      "a",
      "a",
      "[?]",
      "a",
      "a",
      "A",
      "A",
      "A",
      "A",
      "A",
      "'",
      "i",
      "'",
      "~",
      '"~',
      "e",
      "e",
      "e",
      "[?]",
      "e",
      "e",
      "E",
      "E",
      "E",
      "E",
      "E",
      "'`",
      "''",
      "'~",
      "i",
      "i",
      "i",
      "i",
      "[?]",
      "[?]",
      "i",
      "i",
      "I",
      "I",
      "I",
      "I",
      "[?]",
      "`'",
      "`'",
      "`~",
      "u",
      "u",
      "u",
      "u",
      "R",
      "R",
      "u",
      "u",
      "U",
      "U",
      "U",
      "U",
      "R",
      '"`',
      `"'`,
      "`",
      "[?]",
      "[?]",
      "o",
      "o",
      "o",
      "[?]",
      "o",
      "o",
      "O",
      "O",
      "O",
      "O",
      "O",
      "'",
      "`",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x20.js
var require_x20 = __commonJS({
  "node_modules/unidecode/data/x20.js"(exports2, module2) {
    module2.exports = [
      " ",
      " ",
      " ",
      " ",
      " ",
      " ",
      " ",
      " ",
      " ",
      " ",
      " ",
      " ",
      "",
      "",
      "",
      "",
      "-",
      "-",
      "-",
      "-",
      "--",
      "--",
      "||",
      "_",
      "'",
      "'",
      ",",
      "'",
      '"',
      '"',
      ",,",
      '"',
      "+",
      "++",
      "*",
      "*>",
      ".",
      "..",
      "...",
      ".",
      "\\n",
      "\\n\\n",
      "",
      "",
      "",
      "",
      "",
      " ",
      "%0",
      "%00",
      "'",
      "''",
      "'''",
      "`",
      "``",
      "```",
      "^",
      "<",
      ">",
      "*",
      "!!",
      "!?",
      "-",
      "_",
      "-",
      "^",
      "***",
      "--",
      "/",
      "-[",
      "]-",
      "[?]",
      "?!",
      "!?",
      "7",
      "PP",
      "(]",
      "[)",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "",
      "",
      "",
      "",
      "",
      "",
      "0",
      "",
      "",
      "",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      "+",
      "-",
      "=",
      "(",
      ")",
      "n",
      "0",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      "+",
      "-",
      "=",
      "(",
      ")",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "ECU",
      "CL",
      "Cr",
      "FF",
      "L",
      "mil",
      "N",
      "Pts",
      "Rs",
      "W",
      "NS",
      "D",
      "EUR",
      "K",
      "T",
      "Dr",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x21.js
var require_x21 = __commonJS({
  "node_modules/unidecode/data/x21.js"(exports2, module2) {
    module2.exports = [
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "tm",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      " 1/3 ",
      " 2/3 ",
      " 1/5 ",
      " 2/5 ",
      " 3/5 ",
      " 4/5 ",
      " 1/6 ",
      " 5/6 ",
      " 1/8 ",
      " 3/8 ",
      " 5/8 ",
      " 7/8 ",
      " 1/",
      "I",
      "II",
      "III",
      "IV",
      "V",
      "VI",
      "VII",
      "VIII",
      "IX",
      "X",
      "XI",
      "XII",
      "L",
      "C",
      "D",
      "M",
      "i",
      "ii",
      "iii",
      "iv",
      "v",
      "vi",
      "vii",
      "viii",
      "ix",
      "x",
      "xi",
      "xii",
      "l",
      "c",
      "d",
      "m",
      "(D",
      "D)",
      "((|))",
      ")",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "-",
      "|",
      "-",
      "|",
      "-",
      "|",
      "\\\\",
      "/",
      "\\\\",
      "/",
      "-",
      "-",
      "~",
      "~",
      "-",
      "|",
      "-",
      "|",
      "-",
      "-",
      "-",
      "|",
      "-",
      "|",
      "|",
      "-",
      "-",
      "-",
      "-",
      "-",
      "-",
      "|",
      "|",
      "|",
      "|",
      "|",
      "|",
      "|",
      "^",
      "V",
      "\\\\",
      "=",
      "V",
      "^",
      "-",
      "-",
      "|",
      "|",
      "-",
      "-",
      "|",
      "|",
      "=",
      "|",
      "=",
      "=",
      "|",
      "=",
      "|",
      "=",
      "=",
      "=",
      "=",
      "=",
      "=",
      "|",
      "=",
      "|",
      "=",
      "|",
      "\\\\",
      "/",
      "\\\\",
      "/",
      "=",
      "=",
      "~",
      "~",
      "|",
      "|",
      "-",
      "|",
      "-",
      "|",
      "-",
      "-",
      "-",
      "|",
      "-",
      "|",
      "|",
      "|",
      "|",
      "|",
      "|",
      "|",
      "-",
      "\\\\",
      "\\\\",
      "|",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x22.js
var require_x22 = __commonJS({
  "node_modules/unidecode/data/x22.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x23.js
var require_x23 = __commonJS({
  "node_modules/unidecode/data/x23.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x24.js
var require_x24 = __commonJS({
  "node_modules/unidecode/data/x24.js"(exports2, module2) {
    module2.exports = [
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x25.js
var require_x25 = __commonJS({
  "node_modules/unidecode/data/x25.js"(exports2, module2) {
    module2.exports = [
      "-",
      "-",
      "|",
      "|",
      "-",
      "-",
      "|",
      "|",
      "-",
      "-",
      "|",
      "|",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "-",
      "-",
      "|",
      "|",
      "-",
      "|",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "+",
      "/",
      "\\\\",
      "X",
      "-",
      "|",
      "-",
      "|",
      "-",
      "|",
      "-",
      "|",
      "-",
      "|",
      "-",
      "|",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "-",
      "|",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "#",
      "^",
      "^",
      "^",
      "^",
      ">",
      ">",
      ">",
      ">",
      ">",
      ">",
      "V",
      "V",
      "V",
      "V",
      "<",
      "<",
      "<",
      "<",
      "<",
      "<",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "*",
      "#",
      "#",
      "#",
      "#",
      "#",
      "^",
      "^",
      "^",
      "O",
      "#",
      "#",
      "#",
      "#",
      "O",
      "O",
      "O",
      "O",
      "/",
      "\\",
      "\\",
      "#",
      "#",
      "#",
      "#",
      "/"
    ];
  }
});

// node_modules/unidecode/data/x26.js
var require_x26 = __commonJS({
  "node_modules/unidecode/data/x26.js"(exports2, module2) {
    module2.exports = [
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x27.js
var require_x27 = __commonJS({
  "node_modules/unidecode/data/x27.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "[?]",
      "[?]",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "[?]",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x28.js
var require_x28 = __commonJS({
  "node_modules/unidecode/data/x28.js"(exports2, module2) {
    module2.exports = [
      " ",
      "a",
      "1",
      "b",
      "'",
      "k",
      "2",
      "l",
      "\\@",
      "c",
      "i",
      "f",
      "/",
      "m",
      "s",
      "p",
      '"',
      "e",
      "3",
      "h",
      "9",
      "o",
      "6",
      "r",
      "^",
      "d",
      "j",
      "g",
      ">",
      "n",
      "t",
      "q",
      ",",
      "*",
      "5",
      "<",
      "-",
      "u",
      "8",
      "v",
      ".",
      "%",
      "[",
      "\\$",
      "+",
      "x",
      "!",
      "&",
      ";",
      ":",
      "4",
      "\\\\",
      "0",
      "z",
      "7",
      "(",
      "_",
      "?",
      "w",
      "]",
      "#",
      "y",
      ")",
      "=",
      "[d7]",
      "[d17]",
      "[d27]",
      "[d127]",
      "[d37]",
      "[d137]",
      "[d237]",
      "[d1237]",
      "[d47]",
      "[d147]",
      "[d247]",
      "[d1247]",
      "[d347]",
      "[d1347]",
      "[d2347]",
      "[d12347]",
      "[d57]",
      "[d157]",
      "[d257]",
      "[d1257]",
      "[d357]",
      "[d1357]",
      "[d2357]",
      "[d12357]",
      "[d457]",
      "[d1457]",
      "[d2457]",
      "[d12457]",
      "[d3457]",
      "[d13457]",
      "[d23457]",
      "[d123457]",
      "[d67]",
      "[d167]",
      "[d267]",
      "[d1267]",
      "[d367]",
      "[d1367]",
      "[d2367]",
      "[d12367]",
      "[d467]",
      "[d1467]",
      "[d2467]",
      "[d12467]",
      "[d3467]",
      "[d13467]",
      "[d23467]",
      "[d123467]",
      "[d567]",
      "[d1567]",
      "[d2567]",
      "[d12567]",
      "[d3567]",
      "[d13567]",
      "[d23567]",
      "[d123567]",
      "[d4567]",
      "[d14567]",
      "[d24567]",
      "[d124567]",
      "[d34567]",
      "[d134567]",
      "[d234567]",
      "[d1234567]",
      "[d8]",
      "[d18]",
      "[d28]",
      "[d128]",
      "[d38]",
      "[d138]",
      "[d238]",
      "[d1238]",
      "[d48]",
      "[d148]",
      "[d248]",
      "[d1248]",
      "[d348]",
      "[d1348]",
      "[d2348]",
      "[d12348]",
      "[d58]",
      "[d158]",
      "[d258]",
      "[d1258]",
      "[d358]",
      "[d1358]",
      "[d2358]",
      "[d12358]",
      "[d458]",
      "[d1458]",
      "[d2458]",
      "[d12458]",
      "[d3458]",
      "[d13458]",
      "[d23458]",
      "[d123458]",
      "[d68]",
      "[d168]",
      "[d268]",
      "[d1268]",
      "[d368]",
      "[d1368]",
      "[d2368]",
      "[d12368]",
      "[d468]",
      "[d1468]",
      "[d2468]",
      "[d12468]",
      "[d3468]",
      "[d13468]",
      "[d23468]",
      "[d123468]",
      "[d568]",
      "[d1568]",
      "[d2568]",
      "[d12568]",
      "[d3568]",
      "[d13568]",
      "[d23568]",
      "[d123568]",
      "[d4568]",
      "[d14568]",
      "[d24568]",
      "[d124568]",
      "[d34568]",
      "[d134568]",
      "[d234568]",
      "[d1234568]",
      "[d78]",
      "[d178]",
      "[d278]",
      "[d1278]",
      "[d378]",
      "[d1378]",
      "[d2378]",
      "[d12378]",
      "[d478]",
      "[d1478]",
      "[d2478]",
      "[d12478]",
      "[d3478]",
      "[d13478]",
      "[d23478]",
      "[d123478]",
      "[d578]",
      "[d1578]",
      "[d2578]",
      "[d12578]",
      "[d3578]",
      "[d13578]",
      "[d23578]",
      "[d123578]",
      "[d4578]",
      "[d14578]",
      "[d24578]",
      "[d124578]",
      "[d34578]",
      "[d134578]",
      "[d234578]",
      "[d1234578]",
      "[d678]",
      "[d1678]",
      "[d2678]",
      "[d12678]",
      "[d3678]",
      "[d13678]",
      "[d23678]",
      "[d123678]",
      "[d4678]",
      "[d14678]",
      "[d24678]",
      "[d124678]",
      "[d34678]",
      "[d134678]",
      "[d234678]",
      "[d1234678]",
      "[d5678]",
      "[d15678]",
      "[d25678]",
      "[d125678]",
      "[d35678]",
      "[d135678]",
      "[d235678]",
      "[d1235678]",
      "[d45678]",
      "[d145678]",
      "[d245678]",
      "[d1245678]",
      "[d345678]",
      "[d1345678]",
      "[d2345678]",
      "[d12345678]"
    ];
  }
});

// node_modules/unidecode/data/x2e.js
var require_x2e = __commonJS({
  "node_modules/unidecode/data/x2e.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?]",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x2f.js
var require_x2f = __commonJS({
  "node_modules/unidecode/data/x2f.js"(exports2, module2) {
    module2.exports = [
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x30.js
var require_x30 = __commonJS({
  "node_modules/unidecode/data/x30.js"(exports2, module2) {
    module2.exports = [
      " ",
      ", ",
      ". ",
      '"',
      "[JIS]",
      '"',
      "/",
      "0",
      "<",
      "> ",
      "<<",
      ">> ",
      "[",
      "] ",
      "\\{",
      "\\} ",
      "[(",
      ")] ",
      "\\@",
      "X ",
      "[",
      "] ",
      "[[",
      "]] ",
      "((",
      ")) ",
      "[[",
      "]] ",
      "~ ",
      "``",
      "''",
      ",,",
      "\\@",
      "1",
      "2",
      "3",
      "4",
      "5",
      "6",
      "7",
      "8",
      "9",
      "",
      "",
      "",
      "",
      "",
      "",
      "~",
      "+",
      "+",
      "+",
      "+",
      "",
      "\\@",
      " // ",
      "+10+",
      "+20+",
      "+30+",
      "[?]",
      "[?]",
      "[?]",
      "",
      "",
      "[?]",
      "a",
      "a",
      "i",
      "i",
      "u",
      "u",
      "e",
      "e",
      "o",
      "o",
      "ka",
      "ga",
      "ki",
      "gi",
      "ku",
      "gu",
      "ke",
      "ge",
      "ko",
      "go",
      "sa",
      "za",
      "si",
      "zi",
      "su",
      "zu",
      "se",
      "ze",
      "so",
      "zo",
      "ta",
      "da",
      "ti",
      "di",
      "tu",
      "tu",
      "du",
      "te",
      "de",
      "to",
      "do",
      "na",
      "ni",
      "nu",
      "ne",
      "no",
      "ha",
      "ba",
      "pa",
      "hi",
      "bi",
      "pi",
      "hu",
      "bu",
      "pu",
      "he",
      "be",
      "pe",
      "ho",
      "bo",
      "po",
      "ma",
      "mi",
      "mu",
      "me",
      "mo",
      "ya",
      "ya",
      "yu",
      "yu",
      "yo",
      "yo",
      "ra",
      "ri",
      "ru",
      "re",
      "ro",
      "wa",
      "wa",
      "wi",
      "we",
      "wo",
      "n",
      "vu",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "",
      "",
      "",
      "",
      '"',
      '"',
      "[?]",
      "[?]",
      "a",
      "a",
      "i",
      "i",
      "u",
      "u",
      "e",
      "e",
      "o",
      "o",
      "ka",
      "ga",
      "ki",
      "gi",
      "ku",
      "gu",
      "ke",
      "ge",
      "ko",
      "go",
      "sa",
      "za",
      "si",
      "zi",
      "su",
      "zu",
      "se",
      "ze",
      "so",
      "zo",
      "ta",
      "da",
      "ti",
      "di",
      "tu",
      "tu",
      "du",
      "te",
      "de",
      "to",
      "do",
      "na",
      "ni",
      "nu",
      "ne",
      "no",
      "ha",
      "ba",
      "pa",
      "hi",
      "bi",
      "pi",
      "hu",
      "bu",
      "pu",
      "he",
      "be",
      "pe",
      "ho",
      "bo",
      "po",
      "ma",
      "mi",
      "mu",
      "me",
      "mo",
      "ya",
      "ya",
      "yu",
      "yu",
      "yo",
      "yo",
      "ra",
      "ri",
      "ru",
      "re",
      "ro",
      "wa",
      "wa",
      "wi",
      "we",
      "wo",
      "n",
      "vu",
      "ka",
      "ke",
      "va",
      "vi",
      "ve",
      "vo",
      "",
      "",
      '"',
      '"',
      "koto"
    ];
  }
});

// node_modules/unidecode/data/x31.js
var require_x31 = __commonJS({
  "node_modules/unidecode/data/x31.js"(exports2, module2) {
    module2.exports = [
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "B",
      "P",
      "M",
      "F",
      "D",
      "T",
      "N",
      "L",
      "G",
      "K",
      "H",
      "J",
      "Q",
      "X",
      "ZH",
      "CH",
      "SH",
      "R",
      "Z",
      "C",
      "S",
      "A",
      "O",
      "E",
      "EH",
      "AI",
      "EI",
      "AU",
      "OU",
      "AN",
      "EN",
      "ANG",
      "ENG",
      "ER",
      "I",
      "U",
      "IU",
      "V",
      "NG",
      "GN",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "g",
      "gg",
      "gs",
      "n",
      "nj",
      "nh",
      "d",
      "dd",
      "r",
      "lg",
      "lm",
      "lb",
      "ls",
      "lt",
      "lp",
      "rh",
      "m",
      "b",
      "bb",
      "bs",
      "s",
      "ss",
      "",
      "j",
      "jj",
      "c",
      "k",
      "t",
      "p",
      "h",
      "a",
      "ae",
      "ya",
      "yae",
      "eo",
      "e",
      "yeo",
      "ye",
      "o",
      "wa",
      "wae",
      "oe",
      "yo",
      "u",
      "weo",
      "we",
      "wi",
      "yu",
      "eu",
      "yi",
      "i",
      "",
      "nn",
      "nd",
      "ns",
      "nZ",
      "lgs",
      "ld",
      "lbs",
      "lZ",
      "lQ",
      "mb",
      "ms",
      "mZ",
      "mN",
      "bg",
      "",
      "bsg",
      "bst",
      "bj",
      "bt",
      "bN",
      "bbN",
      "sg",
      "sn",
      "sd",
      "sb",
      "sj",
      "Z",
      "",
      "N",
      "Ns",
      "NZ",
      "pN",
      "hh",
      "Q",
      "yo-ya",
      "yo-yae",
      "yo-i",
      "yu-yeo",
      "yu-ye",
      "yu-i",
      "U",
      "U-i",
      "[?]",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "",
      "BU",
      "ZI",
      "JI",
      "GU",
      "EE",
      "ENN",
      "OO",
      "ONN",
      "IR",
      "ANN",
      "INN",
      "UNN",
      "IM",
      "NGG",
      "AINN",
      "AUNN",
      "AM",
      "OM",
      "ONG",
      "INNN",
      "P",
      "T",
      "K",
      "H",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x32.js
var require_x32 = __commonJS({
  "node_modules/unidecode/data/x32.js"(exports2, module2) {
    module2.exports = [
      "(g)",
      "(n)",
      "(d)",
      "(r)",
      "(m)",
      "(b)",
      "(s)",
      "()",
      "(j)",
      "(c)",
      "(k)",
      "(t)",
      "(p)",
      "(h)",
      "(ga)",
      "(na)",
      "(da)",
      "(ra)",
      "(ma)",
      "(ba)",
      "(sa)",
      "(a)",
      "(ja)",
      "(ca)",
      "(ka)",
      "(ta)",
      "(pa)",
      "(ha)",
      "(ju)",
      "[?]",
      "[?]",
      "[?]",
      "(1) ",
      "(2) ",
      "(3) ",
      "(4) ",
      "(5) ",
      "(6) ",
      "(7) ",
      "(8) ",
      "(9) ",
      "(10) ",
      "(Yue) ",
      "(Huo) ",
      "(Shui) ",
      "(Mu) ",
      "(Jin) ",
      "(Tu) ",
      "(Ri) ",
      "(Zhu) ",
      "(You) ",
      "(She) ",
      "(Ming) ",
      "(Te) ",
      "(Cai) ",
      "(Zhu) ",
      "(Lao) ",
      "(Dai) ",
      "(Hu) ",
      "(Xue) ",
      "(Jian) ",
      "(Qi) ",
      "(Zi) ",
      "(Xie) ",
      "(Ji) ",
      "(Xiu) ",
      "<<",
      ">>",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "(g)",
      "(n)",
      "(d)",
      "(r)",
      "(m)",
      "(b)",
      "(s)",
      "()",
      "(j)",
      "(c)",
      "(k)",
      "(t)",
      "(p)",
      "(h)",
      "(ga)",
      "(na)",
      "(da)",
      "(ra)",
      "(ma)",
      "(ba)",
      "(sa)",
      "(a)",
      "(ja)",
      "(ca)",
      "(ka)",
      "(ta)",
      "(pa)",
      "(ha)",
      "[?]",
      "[?]",
      "[?]",
      "KIS ",
      "(1) ",
      "(2) ",
      "(3) ",
      "(4) ",
      "(5) ",
      "(6) ",
      "(7) ",
      "(8) ",
      "(9) ",
      "(10) ",
      "(Yue) ",
      "(Huo) ",
      "(Shui) ",
      "(Mu) ",
      "(Jin) ",
      "(Tu) ",
      "(Ri) ",
      "(Zhu) ",
      "(You) ",
      "(She) ",
      "(Ming) ",
      "(Te) ",
      "(Cai) ",
      "(Zhu) ",
      "(Lao) ",
      "(Mi) ",
      "(Nan) ",
      "(Nu) ",
      "(Shi) ",
      "(You) ",
      "(Yin) ",
      "(Zhu) ",
      "(Xiang) ",
      "(Xiu) ",
      "(Xie) ",
      "(Zheng) ",
      "(Shang) ",
      "(Zhong) ",
      "(Xia) ",
      "(Zuo) ",
      "(You) ",
      "(Yi) ",
      "(Zong) ",
      "(Xue) ",
      "(Jian) ",
      "(Qi) ",
      "(Zi) ",
      "(Xie) ",
      "(Ye) ",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "1M",
      "2M",
      "3M",
      "4M",
      "5M",
      "6M",
      "7M",
      "8M",
      "9M",
      "10M",
      "11M",
      "12M",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "a",
      "i",
      "u",
      "u",
      "o",
      "ka",
      "ki",
      "ku",
      "ke",
      "ko",
      "sa",
      "si",
      "su",
      "se",
      "so",
      "ta",
      "ti",
      "tu",
      "te",
      "to",
      "na",
      "ni",
      "nu",
      "ne",
      "no",
      "ha",
      "hi",
      "hu",
      "he",
      "ho",
      "ma",
      "mi",
      "mu",
      "me",
      "mo",
      "ya",
      "yu",
      "yo",
      "ra",
      "ri",
      "ru",
      "re",
      "ro",
      "wa",
      "wi",
      "we",
      "wo",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x33.js
var require_x33 = __commonJS({
  "node_modules/unidecode/data/x33.js"(exports2, module2) {
    module2.exports = [
      "apartment",
      "alpha",
      "ampere",
      "are",
      "inning",
      "inch",
      "won",
      "escudo",
      "acre",
      "ounce",
      "ohm",
      "kai-ri",
      "carat",
      "calorie",
      "gallon",
      "gamma",
      "giga",
      "guinea",
      "curie",
      "guilder",
      "kilo",
      "kilogram",
      "kilometer",
      "kilowatt",
      "gram",
      "gram ton",
      "cruzeiro",
      "krone",
      "case",
      "koruna",
      "co-op",
      "cycle",
      "centime",
      "shilling",
      "centi",
      "cent",
      "dozen",
      "desi",
      "dollar",
      "ton",
      "nano",
      "knot",
      "heights",
      "percent",
      "parts",
      "barrel",
      "piaster",
      "picul",
      "pico",
      "building",
      "farad",
      "feet",
      "bushel",
      "franc",
      "hectare",
      "peso",
      "pfennig",
      "hertz",
      "pence",
      "page",
      "beta",
      "point",
      "volt",
      "hon",
      "pound",
      "hall",
      "horn",
      "micro",
      "mile",
      "mach",
      "mark",
      "mansion",
      "micron",
      "milli",
      "millibar",
      "mega",
      "megaton",
      "meter",
      "yard",
      "yard",
      "yuan",
      "liter",
      "lira",
      "rupee",
      "ruble",
      "rem",
      "roentgen",
      "watt",
      "0h",
      "1h",
      "2h",
      "3h",
      "4h",
      "5h",
      "6h",
      "7h",
      "8h",
      "9h",
      "10h",
      "11h",
      "12h",
      "13h",
      "14h",
      "15h",
      "16h",
      "17h",
      "18h",
      "19h",
      "20h",
      "21h",
      "22h",
      "23h",
      "24h",
      "HPA",
      "da",
      "AU",
      "bar",
      "oV",
      "pc",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "Heisei",
      "Syouwa",
      "Taisyou",
      "Meiji",
      "Inc.",
      "pA",
      "nA",
      "microamp",
      "mA",
      "kA",
      "kB",
      "MB",
      "GB",
      "cal",
      "kcal",
      "pF",
      "nF",
      "microFarad",
      "microgram",
      "mg",
      "kg",
      "Hz",
      "kHz",
      "MHz",
      "GHz",
      "THz",
      "microliter",
      "ml",
      "dl",
      "kl",
      "fm",
      "nm",
      "micrometer",
      "mm",
      "cm",
      "km",
      "mm^2",
      "cm^2",
      "m^2",
      "km^2",
      "mm^4",
      "cm^3",
      "m^3",
      "km^3",
      "m/s",
      "m/s^2",
      "Pa",
      "kPa",
      "MPa",
      "GPa",
      "rad",
      "rad/s",
      "rad/s^2",
      "ps",
      "ns",
      "microsecond",
      "ms",
      "pV",
      "nV",
      "microvolt",
      "mV",
      "kV",
      "MV",
      "pW",
      "nW",
      "microwatt",
      "mW",
      "kW",
      "MW",
      "kOhm",
      "MOhm",
      "a.m.",
      "Bq",
      "cc",
      "cd",
      "C/kg",
      "Co.",
      "dB",
      "Gy",
      "ha",
      "HP",
      "in",
      "K.K.",
      "KM",
      "kt",
      "lm",
      "ln",
      "log",
      "lx",
      "mb",
      "mil",
      "mol",
      "pH",
      "p.m.",
      "PPM",
      "PR",
      "sr",
      "Sv",
      "Wb",
      "[?]",
      "[?]",
      "1d",
      "2d",
      "3d",
      "4d",
      "5d",
      "6d",
      "7d",
      "8d",
      "9d",
      "10d",
      "11d",
      "12d",
      "13d",
      "14d",
      "15d",
      "16d",
      "17d",
      "18d",
      "19d",
      "20d",
      "21d",
      "22d",
      "23d",
      "24d",
      "25d",
      "26d",
      "27d",
      "28d",
      "29d",
      "30d",
      "31d",
      "gal"
    ];
  }
});

// node_modules/unidecode/data/x4d.js
var require_x4d = __commonJS({
  "node_modules/unidecode/data/x4d.js"(exports2, module2) {
    module2.exports = [
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/x4e.js
var require_x4e = __commonJS({
  "node_modules/unidecode/data/x4e.js"(exports2, module2) {
    module2.exports = [
      "Yi ",
      "Ding ",
      "Kao ",
      "Qi ",
      "Shang ",
      "Xia ",
      "[?] ",
      "Mo ",
      "Zhang ",
      "San ",
      "Shang ",
      "Xia ",
      "Ji ",
      "Bu ",
      "Yu ",
      "Mian ",
      "Gai ",
      "Chou ",
      "Chou ",
      "Zhuan ",
      "Qie ",
      "Pi ",
      "Shi ",
      "Shi ",
      "Qiu ",
      "Bing ",
      "Ye ",
      "Cong ",
      "Dong ",
      "Si ",
      "Cheng ",
      "Diu ",
      "Qiu ",
      "Liang ",
      "Diu ",
      "You ",
      "Liang ",
      "Yan ",
      "Bing ",
      "Sang ",
      "Gun ",
      "Jiu ",
      "Ge ",
      "Ya ",
      "Qiang ",
      "Zhong ",
      "Ji ",
      "Jie ",
      "Feng ",
      "Guan ",
      "Chuan ",
      "Chan ",
      "Lin ",
      "Zhuo ",
      "Zhu ",
      "Ha ",
      "Wan ",
      "Dan ",
      "Wei ",
      "Zhu ",
      "Jing ",
      "Li ",
      "Ju ",
      "Pie ",
      "Fu ",
      "Yi ",
      "Yi ",
      "Nai ",
      "Shime ",
      "Jiu ",
      "Jiu ",
      "Zhe ",
      "Yao ",
      "Yi ",
      "[?] ",
      "Zhi ",
      "Wu ",
      "Zha ",
      "Hu ",
      "Fa ",
      "Le ",
      "Zhong ",
      "Ping ",
      "Pang ",
      "Qiao ",
      "Hu ",
      "Guai ",
      "Cheng ",
      "Cheng ",
      "Yi ",
      "Yin ",
      "[?] ",
      "Mie ",
      "Jiu ",
      "Qi ",
      "Ye ",
      "Xi ",
      "Xiang ",
      "Gai ",
      "Diu ",
      "Hal ",
      "[?] ",
      "Shu ",
      "Twul ",
      "Shi ",
      "Ji ",
      "Nang ",
      "Jia ",
      "Kel ",
      "Shi ",
      "[?] ",
      "Ol ",
      "Mai ",
      "Luan ",
      "Cal ",
      "Ru ",
      "Xue ",
      "Yan ",
      "Fu ",
      "Sha ",
      "Na ",
      "Gan ",
      "Sol ",
      "El ",
      "Cwul ",
      "[?] ",
      "Gan ",
      "Chi ",
      "Gui ",
      "Gan ",
      "Luan ",
      "Lin ",
      "Yi ",
      "Jue ",
      "Liao ",
      "Ma ",
      "Yu ",
      "Zheng ",
      "Shi ",
      "Shi ",
      "Er ",
      "Chu ",
      "Yu ",
      "Yu ",
      "Yu ",
      "Yun ",
      "Hu ",
      "Qi ",
      "Wu ",
      "Jing ",
      "Si ",
      "Sui ",
      "Gen ",
      "Gen ",
      "Ya ",
      "Xie ",
      "Ya ",
      "Qi ",
      "Ya ",
      "Ji ",
      "Tou ",
      "Wang ",
      "Kang ",
      "Ta ",
      "Jiao ",
      "Hai ",
      "Yi ",
      "Chan ",
      "Heng ",
      "Mu ",
      "[?] ",
      "Xiang ",
      "Jing ",
      "Ting ",
      "Liang ",
      "Xiang ",
      "Jing ",
      "Ye ",
      "Qin ",
      "Bo ",
      "You ",
      "Xie ",
      "Dan ",
      "Lian ",
      "Duo ",
      "Wei ",
      "Ren ",
      "Ren ",
      "Ji ",
      "La ",
      "Wang ",
      "Yi ",
      "Shi ",
      "Ren ",
      "Le ",
      "Ding ",
      "Ze ",
      "Jin ",
      "Pu ",
      "Chou ",
      "Ba ",
      "Zhang ",
      "Jin ",
      "Jie ",
      "Bing ",
      "Reng ",
      "Cong ",
      "Fo ",
      "San ",
      "Lun ",
      "Sya ",
      "Cang ",
      "Zi ",
      "Shi ",
      "Ta ",
      "Zhang ",
      "Fu ",
      "Xian ",
      "Xian ",
      "Tuo ",
      "Hong ",
      "Tong ",
      "Ren ",
      "Qian ",
      "Gan ",
      "Yi ",
      "Di ",
      "Dai ",
      "Ling ",
      "Yi ",
      "Chao ",
      "Chang ",
      "Sa ",
      "[?] ",
      "Yi ",
      "Mu ",
      "Men ",
      "Ren ",
      "Jia ",
      "Chao ",
      "Yang ",
      "Qian ",
      "Zhong ",
      "Pi ",
      "Wan ",
      "Wu ",
      "Jian ",
      "Jie ",
      "Yao ",
      "Feng ",
      "Cang ",
      "Ren ",
      "Wang ",
      "Fen ",
      "Di ",
      "Fang "
    ];
  }
});

// node_modules/unidecode/data/x4f.js
var require_x4f = __commonJS({
  "node_modules/unidecode/data/x4f.js"(exports2, module2) {
    module2.exports = [
      "Zhong ",
      "Qi ",
      "Pei ",
      "Yu ",
      "Diao ",
      "Dun ",
      "Wen ",
      "Yi ",
      "Xin ",
      "Kang ",
      "Yi ",
      "Ji ",
      "Ai ",
      "Wu ",
      "Ji ",
      "Fu ",
      "Fa ",
      "Xiu ",
      "Jin ",
      "Bei ",
      "Dan ",
      "Fu ",
      "Tang ",
      "Zhong ",
      "You ",
      "Huo ",
      "Hui ",
      "Yu ",
      "Cui ",
      "Chuan ",
      "San ",
      "Wei ",
      "Chuan ",
      "Che ",
      "Ya ",
      "Xian ",
      "Shang ",
      "Chang ",
      "Lun ",
      "Cang ",
      "Xun ",
      "Xin ",
      "Wei ",
      "Zhu ",
      "[?] ",
      "Xuan ",
      "Nu ",
      "Bo ",
      "Gu ",
      "Ni ",
      "Ni ",
      "Xie ",
      "Ban ",
      "Xu ",
      "Ling ",
      "Zhou ",
      "Shen ",
      "Qu ",
      "Si ",
      "Beng ",
      "Si ",
      "Jia ",
      "Pi ",
      "Yi ",
      "Si ",
      "Ai ",
      "Zheng ",
      "Dian ",
      "Han ",
      "Mai ",
      "Dan ",
      "Zhu ",
      "Bu ",
      "Qu ",
      "Bi ",
      "Shao ",
      "Ci ",
      "Wei ",
      "Di ",
      "Zhu ",
      "Zuo ",
      "You ",
      "Yang ",
      "Ti ",
      "Zhan ",
      "He ",
      "Bi ",
      "Tuo ",
      "She ",
      "Yu ",
      "Yi ",
      "Fo ",
      "Zuo ",
      "Kou ",
      "Ning ",
      "Tong ",
      "Ni ",
      "Xuan ",
      "Qu ",
      "Yong ",
      "Wa ",
      "Qian ",
      "[?] ",
      "Ka ",
      "[?] ",
      "Pei ",
      "Huai ",
      "He ",
      "Lao ",
      "Xiang ",
      "Ge ",
      "Yang ",
      "Bai ",
      "Fa ",
      "Ming ",
      "Jia ",
      "Er ",
      "Bing ",
      "Ji ",
      "Hen ",
      "Huo ",
      "Gui ",
      "Quan ",
      "Tiao ",
      "Jiao ",
      "Ci ",
      "Yi ",
      "Shi ",
      "Xing ",
      "Shen ",
      "Tuo ",
      "Kan ",
      "Zhi ",
      "Gai ",
      "Lai ",
      "Yi ",
      "Chi ",
      "Kua ",
      "Guang ",
      "Li ",
      "Yin ",
      "Shi ",
      "Mi ",
      "Zhu ",
      "Xu ",
      "You ",
      "An ",
      "Lu ",
      "Mou ",
      "Er ",
      "Lun ",
      "Tong ",
      "Cha ",
      "Chi ",
      "Xun ",
      "Gong ",
      "Zhou ",
      "Yi ",
      "Ru ",
      "Jian ",
      "Xia ",
      "Jia ",
      "Zai ",
      "Lu ",
      "Ko ",
      "Jiao ",
      "Zhen ",
      "Ce ",
      "Qiao ",
      "Kuai ",
      "Chai ",
      "Ning ",
      "Nong ",
      "Jin ",
      "Wu ",
      "Hou ",
      "Jiong ",
      "Cheng ",
      "Zhen ",
      "Zuo ",
      "Chou ",
      "Qin ",
      "Lu ",
      "Ju ",
      "Shu ",
      "Ting ",
      "Shen ",
      "Tuo ",
      "Bo ",
      "Nan ",
      "Hao ",
      "Bian ",
      "Tui ",
      "Yu ",
      "Xi ",
      "Cu ",
      "E ",
      "Qiu ",
      "Xu ",
      "Kuang ",
      "Ku ",
      "Wu ",
      "Jun ",
      "Yi ",
      "Fu ",
      "Lang ",
      "Zu ",
      "Qiao ",
      "Li ",
      "Yong ",
      "Hun ",
      "Jing ",
      "Xian ",
      "San ",
      "Pai ",
      "Su ",
      "Fu ",
      "Xi ",
      "Li ",
      "Fu ",
      "Ping ",
      "Bao ",
      "Yu ",
      "Si ",
      "Xia ",
      "Xin ",
      "Xiu ",
      "Yu ",
      "Ti ",
      "Che ",
      "Chou ",
      "[?] ",
      "Yan ",
      "Lia ",
      "Li ",
      "Lai ",
      "[?] ",
      "Jian ",
      "Xiu ",
      "Fu ",
      "He ",
      "Ju ",
      "Xiao ",
      "Pai ",
      "Jian ",
      "Biao ",
      "Chu ",
      "Fei ",
      "Feng ",
      "Ya ",
      "An ",
      "Bei ",
      "Yu ",
      "Xin ",
      "Bi ",
      "Jian "
    ];
  }
});

// node_modules/unidecode/data/x50.js
var require_x50 = __commonJS({
  "node_modules/unidecode/data/x50.js"(exports2, module2) {
    module2.exports = [
      "Chang ",
      "Chi ",
      "Bing ",
      "Zan ",
      "Yao ",
      "Cui ",
      "Lia ",
      "Wan ",
      "Lai ",
      "Cang ",
      "Zong ",
      "Ge ",
      "Guan ",
      "Bei ",
      "Tian ",
      "Shu ",
      "Shu ",
      "Men ",
      "Dao ",
      "Tan ",
      "Jue ",
      "Chui ",
      "Xing ",
      "Peng ",
      "Tang ",
      "Hou ",
      "Yi ",
      "Qi ",
      "Ti ",
      "Gan ",
      "Jing ",
      "Jie ",
      "Sui ",
      "Chang ",
      "Jie ",
      "Fang ",
      "Zhi ",
      "Kong ",
      "Juan ",
      "Zong ",
      "Ju ",
      "Qian ",
      "Ni ",
      "Lun ",
      "Zhuo ",
      "Wei ",
      "Luo ",
      "Song ",
      "Leng ",
      "Hun ",
      "Dong ",
      "Zi ",
      "Ben ",
      "Wu ",
      "Ju ",
      "Nai ",
      "Cai ",
      "Jian ",
      "Zhai ",
      "Ye ",
      "Zhi ",
      "Sha ",
      "Qing ",
      "[?] ",
      "Ying ",
      "Cheng ",
      "Jian ",
      "Yan ",
      "Nuan ",
      "Zhong ",
      "Chun ",
      "Jia ",
      "Jie ",
      "Wei ",
      "Yu ",
      "Bing ",
      "Ruo ",
      "Ti ",
      "Wei ",
      "Pian ",
      "Yan ",
      "Feng ",
      "Tang ",
      "Wo ",
      "E ",
      "Xie ",
      "Che ",
      "Sheng ",
      "Kan ",
      "Di ",
      "Zuo ",
      "Cha ",
      "Ting ",
      "Bei ",
      "Ye ",
      "Huang ",
      "Yao ",
      "Zhan ",
      "Chou ",
      "Yan ",
      "You ",
      "Jian ",
      "Xu ",
      "Zha ",
      "Ci ",
      "Fu ",
      "Bi ",
      "Zhi ",
      "Zong ",
      "Mian ",
      "Ji ",
      "Yi ",
      "Xie ",
      "Xun ",
      "Si ",
      "Duan ",
      "Ce ",
      "Zhen ",
      "Ou ",
      "Tou ",
      "Tou ",
      "Bei ",
      "Za ",
      "Lu ",
      "Jie ",
      "Wei ",
      "Fen ",
      "Chang ",
      "Gui ",
      "Sou ",
      "Zhi ",
      "Su ",
      "Xia ",
      "Fu ",
      "Yuan ",
      "Rong ",
      "Li ",
      "Ru ",
      "Yun ",
      "Gou ",
      "Ma ",
      "Bang ",
      "Dian ",
      "Tang ",
      "Hao ",
      "Jie ",
      "Xi ",
      "Shan ",
      "Qian ",
      "Jue ",
      "Cang ",
      "Chu ",
      "San ",
      "Bei ",
      "Xiao ",
      "Yong ",
      "Yao ",
      "Tan ",
      "Suo ",
      "Yang ",
      "Fa ",
      "Bing ",
      "Jia ",
      "Dai ",
      "Zai ",
      "Tang ",
      "[?] ",
      "Bin ",
      "Chu ",
      "Nuo ",
      "Can ",
      "Lei ",
      "Cui ",
      "Yong ",
      "Zao ",
      "Zong ",
      "Peng ",
      "Song ",
      "Ao ",
      "Chuan ",
      "Yu ",
      "Zhai ",
      "Cou ",
      "Shang ",
      "Qiang ",
      "Jing ",
      "Chi ",
      "Sha ",
      "Han ",
      "Zhang ",
      "Qing ",
      "Yan ",
      "Di ",
      "Xi ",
      "Lu ",
      "Bei ",
      "Piao ",
      "Jin ",
      "Lian ",
      "Lu ",
      "Man ",
      "Qian ",
      "Xian ",
      "Tan ",
      "Ying ",
      "Dong ",
      "Zhuan ",
      "Xiang ",
      "Shan ",
      "Qiao ",
      "Jiong ",
      "Tui ",
      "Zun ",
      "Pu ",
      "Xi ",
      "Lao ",
      "Chang ",
      "Guang ",
      "Liao ",
      "Qi ",
      "Deng ",
      "Chan ",
      "Wei ",
      "Ji ",
      "Fan ",
      "Hui ",
      "Chuan ",
      "Jian ",
      "Dan ",
      "Jiao ",
      "Jiu ",
      "Seng ",
      "Fen ",
      "Xian ",
      "Jue ",
      "E ",
      "Jiao ",
      "Jian ",
      "Tong ",
      "Lin ",
      "Bo ",
      "Gu ",
      "[?] ",
      "Su ",
      "Xian ",
      "Jiang ",
      "Min ",
      "Ye ",
      "Jin ",
      "Jia ",
      "Qiao ",
      "Pi ",
      "Feng ",
      "Zhou ",
      "Ai ",
      "Sai "
    ];
  }
});

// node_modules/unidecode/data/x51.js
var require_x51 = __commonJS({
  "node_modules/unidecode/data/x51.js"(exports2, module2) {
    module2.exports = [
      "Yi ",
      "Jun ",
      "Nong ",
      "Chan ",
      "Yi ",
      "Dang ",
      "Jing ",
      "Xuan ",
      "Kuai ",
      "Jian ",
      "Chu ",
      "Dan ",
      "Jiao ",
      "Sha ",
      "Zai ",
      "[?] ",
      "Bin ",
      "An ",
      "Ru ",
      "Tai ",
      "Chou ",
      "Chai ",
      "Lan ",
      "Ni ",
      "Jin ",
      "Qian ",
      "Meng ",
      "Wu ",
      "Ning ",
      "Qiong ",
      "Ni ",
      "Chang ",
      "Lie ",
      "Lei ",
      "Lu ",
      "Kuang ",
      "Bao ",
      "Du ",
      "Biao ",
      "Zan ",
      "Zhi ",
      "Si ",
      "You ",
      "Hao ",
      "Chen ",
      "Chen ",
      "Li ",
      "Teng ",
      "Wei ",
      "Long ",
      "Chu ",
      "Chan ",
      "Rang ",
      "Shu ",
      "Hui ",
      "Li ",
      "Luo ",
      "Zan ",
      "Nuo ",
      "Tang ",
      "Yan ",
      "Lei ",
      "Nang ",
      "Er ",
      "Wu ",
      "Yun ",
      "Zan ",
      "Yuan ",
      "Xiong ",
      "Chong ",
      "Zhao ",
      "Xiong ",
      "Xian ",
      "Guang ",
      "Dui ",
      "Ke ",
      "Dui ",
      "Mian ",
      "Tu ",
      "Chang ",
      "Er ",
      "Dui ",
      "Er ",
      "Xin ",
      "Tu ",
      "Si ",
      "Yan ",
      "Yan ",
      "Shi ",
      "Shi ",
      "Dang ",
      "Qian ",
      "Dou ",
      "Fen ",
      "Mao ",
      "Shen ",
      "Dou ",
      "Bai ",
      "Jing ",
      "Li ",
      "Huang ",
      "Ru ",
      "Wang ",
      "Nei ",
      "Quan ",
      "Liang ",
      "Yu ",
      "Ba ",
      "Gong ",
      "Liu ",
      "Xi ",
      "[?] ",
      "Lan ",
      "Gong ",
      "Tian ",
      "Guan ",
      "Xing ",
      "Bing ",
      "Qi ",
      "Ju ",
      "Dian ",
      "Zi ",
      "Ppwun ",
      "Yang ",
      "Jian ",
      "Shou ",
      "Ji ",
      "Yi ",
      "Ji ",
      "Chan ",
      "Jiong ",
      "Mao ",
      "Ran ",
      "Nei ",
      "Yuan ",
      "Mao ",
      "Gang ",
      "Ran ",
      "Ce ",
      "Jiong ",
      "Ce ",
      "Zai ",
      "Gua ",
      "Jiong ",
      "Mao ",
      "Zhou ",
      "Mou ",
      "Gou ",
      "Xu ",
      "Mian ",
      "Mi ",
      "Rong ",
      "Yin ",
      "Xie ",
      "Kan ",
      "Jun ",
      "Nong ",
      "Yi ",
      "Mi ",
      "Shi ",
      "Guan ",
      "Meng ",
      "Zhong ",
      "Ju ",
      "Yuan ",
      "Ming ",
      "Kou ",
      "Lam ",
      "Fu ",
      "Xie ",
      "Mi ",
      "Bing ",
      "Dong ",
      "Tai ",
      "Gang ",
      "Feng ",
      "Bing ",
      "Hu ",
      "Chong ",
      "Jue ",
      "Hu ",
      "Kuang ",
      "Ye ",
      "Leng ",
      "Pan ",
      "Fu ",
      "Min ",
      "Dong ",
      "Xian ",
      "Lie ",
      "Xia ",
      "Jian ",
      "Jing ",
      "Shu ",
      "Mei ",
      "Tu ",
      "Qi ",
      "Gu ",
      "Zhun ",
      "Song ",
      "Jing ",
      "Liang ",
      "Qing ",
      "Diao ",
      "Ling ",
      "Dong ",
      "Gan ",
      "Jian ",
      "Yin ",
      "Cou ",
      "Yi ",
      "Li ",
      "Cang ",
      "Ming ",
      "Zhuen ",
      "Cui ",
      "Si ",
      "Duo ",
      "Jin ",
      "Lin ",
      "Lin ",
      "Ning ",
      "Xi ",
      "Du ",
      "Ji ",
      "Fan ",
      "Fan ",
      "Fan ",
      "Feng ",
      "Ju ",
      "Chu ",
      "Tako ",
      "Feng ",
      "Mok ",
      "Ci ",
      "Fu ",
      "Feng ",
      "Ping ",
      "Feng ",
      "Kai ",
      "Huang ",
      "Kai ",
      "Gan ",
      "Deng ",
      "Ping ",
      "Qu ",
      "Xiong ",
      "Kuai ",
      "Tu ",
      "Ao ",
      "Chu ",
      "Ji ",
      "Dang ",
      "Han ",
      "Han ",
      "Zao "
    ];
  }
});

// node_modules/unidecode/data/x52.js
var require_x52 = __commonJS({
  "node_modules/unidecode/data/x52.js"(exports2, module2) {
    module2.exports = [
      "Dao ",
      "Diao ",
      "Dao ",
      "Ren ",
      "Ren ",
      "Chuang ",
      "Fen ",
      "Qie ",
      "Yi ",
      "Ji ",
      "Kan ",
      "Qian ",
      "Cun ",
      "Chu ",
      "Wen ",
      "Ji ",
      "Dan ",
      "Xing ",
      "Hua ",
      "Wan ",
      "Jue ",
      "Li ",
      "Yue ",
      "Lie ",
      "Liu ",
      "Ze ",
      "Gang ",
      "Chuang ",
      "Fu ",
      "Chu ",
      "Qu ",
      "Ju ",
      "Shan ",
      "Min ",
      "Ling ",
      "Zhong ",
      "Pan ",
      "Bie ",
      "Jie ",
      "Jie ",
      "Bao ",
      "Li ",
      "Shan ",
      "Bie ",
      "Chan ",
      "Jing ",
      "Gua ",
      "Gen ",
      "Dao ",
      "Chuang ",
      "Kui ",
      "Ku ",
      "Duo ",
      "Er ",
      "Zhi ",
      "Shua ",
      "Quan ",
      "Cha ",
      "Ci ",
      "Ke ",
      "Jie ",
      "Gui ",
      "Ci ",
      "Gui ",
      "Kai ",
      "Duo ",
      "Ji ",
      "Ti ",
      "Jing ",
      "Lou ",
      "Gen ",
      "Ze ",
      "Yuan ",
      "Cuo ",
      "Xue ",
      "Ke ",
      "La ",
      "Qian ",
      "Cha ",
      "Chuang ",
      "Gua ",
      "Jian ",
      "Cuo ",
      "Li ",
      "Ti ",
      "Fei ",
      "Pou ",
      "Chan ",
      "Qi ",
      "Chuang ",
      "Zi ",
      "Gang ",
      "Wan ",
      "Bo ",
      "Ji ",
      "Duo ",
      "Qing ",
      "Yan ",
      "Zhuo ",
      "Jian ",
      "Ji ",
      "Bo ",
      "Yan ",
      "Ju ",
      "Huo ",
      "Sheng ",
      "Jian ",
      "Duo ",
      "Duan ",
      "Wu ",
      "Gua ",
      "Fu ",
      "Sheng ",
      "Jian ",
      "Ge ",
      "Zha ",
      "Kai ",
      "Chuang ",
      "Juan ",
      "Chan ",
      "Tuan ",
      "Lu ",
      "Li ",
      "Fou ",
      "Shan ",
      "Piao ",
      "Kou ",
      "Jiao ",
      "Gua ",
      "Qiao ",
      "Jue ",
      "Hua ",
      "Zha ",
      "Zhuo ",
      "Lian ",
      "Ju ",
      "Pi ",
      "Liu ",
      "Gui ",
      "Jiao ",
      "Gui ",
      "Jian ",
      "Jian ",
      "Tang ",
      "Huo ",
      "Ji ",
      "Jian ",
      "Yi ",
      "Jian ",
      "Zhi ",
      "Chan ",
      "Cuan ",
      "Mo ",
      "Li ",
      "Zhu ",
      "Li ",
      "Ya ",
      "Quan ",
      "Ban ",
      "Gong ",
      "Jia ",
      "Wu ",
      "Mai ",
      "Lie ",
      "Jin ",
      "Keng ",
      "Xie ",
      "Zhi ",
      "Dong ",
      "Zhu ",
      "Nu ",
      "Jie ",
      "Qu ",
      "Shao ",
      "Yi ",
      "Zhu ",
      "Miao ",
      "Li ",
      "Jing ",
      "Lao ",
      "Lao ",
      "Juan ",
      "Kou ",
      "Yang ",
      "Wa ",
      "Xiao ",
      "Mou ",
      "Kuang ",
      "Jie ",
      "Lie ",
      "He ",
      "Shi ",
      "Ke ",
      "Jing ",
      "Hao ",
      "Bo ",
      "Min ",
      "Chi ",
      "Lang ",
      "Yong ",
      "Yong ",
      "Mian ",
      "Ke ",
      "Xun ",
      "Juan ",
      "Qing ",
      "Lu ",
      "Pou ",
      "Meng ",
      "Lai ",
      "Le ",
      "Kai ",
      "Mian ",
      "Dong ",
      "Xu ",
      "Xu ",
      "Kan ",
      "Wu ",
      "Yi ",
      "Xun ",
      "Weng ",
      "Sheng ",
      "Lao ",
      "Mu ",
      "Lu ",
      "Piao ",
      "Shi ",
      "Ji ",
      "Qin ",
      "Qiang ",
      "Jiao ",
      "Quan ",
      "Yang ",
      "Yi ",
      "Jue ",
      "Fan ",
      "Juan ",
      "Tong ",
      "Ju ",
      "Dan ",
      "Xie ",
      "Mai ",
      "Xun ",
      "Xun ",
      "Lu ",
      "Li ",
      "Che ",
      "Rang ",
      "Quan ",
      "Bao ",
      "Shao ",
      "Yun ",
      "Jiu ",
      "Bao ",
      "Gou ",
      "Wu "
    ];
  }
});

// node_modules/unidecode/data/x53.js
var require_x53 = __commonJS({
  "node_modules/unidecode/data/x53.js"(exports2, module2) {
    module2.exports = [
      "Yun ",
      "Mwun ",
      "Nay ",
      "Gai ",
      "Gai ",
      "Bao ",
      "Cong ",
      "[?] ",
      "Xiong ",
      "Peng ",
      "Ju ",
      "Tao ",
      "Ge ",
      "Pu ",
      "An ",
      "Pao ",
      "Fu ",
      "Gong ",
      "Da ",
      "Jiu ",
      "Qiong ",
      "Bi ",
      "Hua ",
      "Bei ",
      "Nao ",
      "Chi ",
      "Fang ",
      "Jiu ",
      "Yi ",
      "Za ",
      "Jiang ",
      "Kang ",
      "Jiang ",
      "Kuang ",
      "Hu ",
      "Xia ",
      "Qu ",
      "Bian ",
      "Gui ",
      "Qie ",
      "Zang ",
      "Kuang ",
      "Fei ",
      "Hu ",
      "Tou ",
      "Gui ",
      "Gui ",
      "Hui ",
      "Dan ",
      "Gui ",
      "Lian ",
      "Lian ",
      "Suan ",
      "Du ",
      "Jiu ",
      "Qu ",
      "Xi ",
      "Pi ",
      "Qu ",
      "Yi ",
      "Qia ",
      "Yan ",
      "Bian ",
      "Ni ",
      "Qu ",
      "Shi ",
      "Xin ",
      "Qian ",
      "Nian ",
      "Sa ",
      "Zu ",
      "Sheng ",
      "Wu ",
      "Hui ",
      "Ban ",
      "Shi ",
      "Xi ",
      "Wan ",
      "Hua ",
      "Xie ",
      "Wan ",
      "Bei ",
      "Zu ",
      "Zhuo ",
      "Xie ",
      "Dan ",
      "Mai ",
      "Nan ",
      "Dan ",
      "Ji ",
      "Bo ",
      "Shuai ",
      "Bu ",
      "Kuang ",
      "Bian ",
      "Bu ",
      "Zhan ",
      "Qia ",
      "Lu ",
      "You ",
      "Lu ",
      "Xi ",
      "Gua ",
      "Wo ",
      "Xie ",
      "Jie ",
      "Jie ",
      "Wei ",
      "Ang ",
      "Qiong ",
      "Zhi ",
      "Mao ",
      "Yin ",
      "Wei ",
      "Shao ",
      "Ji ",
      "Que ",
      "Luan ",
      "Shi ",
      "Juan ",
      "Xie ",
      "Xu ",
      "Jin ",
      "Que ",
      "Wu ",
      "Ji ",
      "E ",
      "Qing ",
      "Xi ",
      "[?] ",
      "Han ",
      "Zhan ",
      "E ",
      "Ting ",
      "Li ",
      "Zhe ",
      "Han ",
      "Li ",
      "Ya ",
      "Ya ",
      "Yan ",
      "She ",
      "Zhi ",
      "Zha ",
      "Pang ",
      "[?] ",
      "He ",
      "Ya ",
      "Zhi ",
      "Ce ",
      "Pang ",
      "Ti ",
      "Li ",
      "She ",
      "Hou ",
      "Ting ",
      "Zui ",
      "Cuo ",
      "Fei ",
      "Yuan ",
      "Ce ",
      "Yuan ",
      "Xiang ",
      "Yan ",
      "Li ",
      "Jue ",
      "Sha ",
      "Dian ",
      "Chu ",
      "Jiu ",
      "Qin ",
      "Ao ",
      "Gui ",
      "Yan ",
      "Si ",
      "Li ",
      "Chang ",
      "Lan ",
      "Li ",
      "Yan ",
      "Yan ",
      "Yuan ",
      "Si ",
      "Gong ",
      "Lin ",
      "Qiu ",
      "Qu ",
      "Qu ",
      "Uk ",
      "Lei ",
      "Du ",
      "Xian ",
      "Zhuan ",
      "San ",
      "Can ",
      "Can ",
      "Can ",
      "Can ",
      "Ai ",
      "Dai ",
      "You ",
      "Cha ",
      "Ji ",
      "You ",
      "Shuang ",
      "Fan ",
      "Shou ",
      "Guai ",
      "Ba ",
      "Fa ",
      "Ruo ",
      "Shi ",
      "Shu ",
      "Zhuo ",
      "Qu ",
      "Shou ",
      "Bian ",
      "Xu ",
      "Jia ",
      "Pan ",
      "Sou ",
      "Gao ",
      "Wei ",
      "Sou ",
      "Die ",
      "Rui ",
      "Cong ",
      "Kou ",
      "Gu ",
      "Ju ",
      "Ling ",
      "Gua ",
      "Tao ",
      "Kou ",
      "Zhi ",
      "Jiao ",
      "Zhao ",
      "Ba ",
      "Ding ",
      "Ke ",
      "Tai ",
      "Chi ",
      "Shi ",
      "You ",
      "Qiu ",
      "Po ",
      "Xie ",
      "Hao ",
      "Si ",
      "Tan ",
      "Chi ",
      "Le ",
      "Diao ",
      "Ji ",
      "[?] ",
      "Hong "
    ];
  }
});

// node_modules/unidecode/data/x54.js
var require_x54 = __commonJS({
  "node_modules/unidecode/data/x54.js"(exports2, module2) {
    module2.exports = [
      "Mie ",
      "Xu ",
      "Mang ",
      "Chi ",
      "Ge ",
      "Xuan ",
      "Yao ",
      "Zi ",
      "He ",
      "Ji ",
      "Diao ",
      "Cun ",
      "Tong ",
      "Ming ",
      "Hou ",
      "Li ",
      "Tu ",
      "Xiang ",
      "Zha ",
      "Xia ",
      "Ye ",
      "Lu ",
      "A ",
      "Ma ",
      "Ou ",
      "Xue ",
      "Yi ",
      "Jun ",
      "Chou ",
      "Lin ",
      "Tun ",
      "Yin ",
      "Fei ",
      "Bi ",
      "Qin ",
      "Qin ",
      "Jie ",
      "Bu ",
      "Fou ",
      "Ba ",
      "Dun ",
      "Fen ",
      "E ",
      "Han ",
      "Ting ",
      "Hang ",
      "Shun ",
      "Qi ",
      "Hong ",
      "Zhi ",
      "Shen ",
      "Wu ",
      "Wu ",
      "Chao ",
      "Ne ",
      "Xue ",
      "Xi ",
      "Chui ",
      "Dou ",
      "Wen ",
      "Hou ",
      "Ou ",
      "Wu ",
      "Gao ",
      "Ya ",
      "Jun ",
      "Lu ",
      "E ",
      "Ge ",
      "Mei ",
      "Ai ",
      "Qi ",
      "Cheng ",
      "Wu ",
      "Gao ",
      "Fu ",
      "Jiao ",
      "Hong ",
      "Chi ",
      "Sheng ",
      "Ne ",
      "Tun ",
      "Fu ",
      "Yi ",
      "Dai ",
      "Ou ",
      "Li ",
      "Bai ",
      "Yuan ",
      "Kuai ",
      "[?] ",
      "Qiang ",
      "Wu ",
      "E ",
      "Shi ",
      "Quan ",
      "Pen ",
      "Wen ",
      "Ni ",
      "M ",
      "Ling ",
      "Ran ",
      "You ",
      "Di ",
      "Zhou ",
      "Shi ",
      "Zhou ",
      "Tie ",
      "Xi ",
      "Yi ",
      "Qi ",
      "Ping ",
      "Zi ",
      "Gu ",
      "Zi ",
      "Wei ",
      "Xu ",
      "He ",
      "Nao ",
      "Xia ",
      "Pei ",
      "Yi ",
      "Xiao ",
      "Shen ",
      "Hu ",
      "Ming ",
      "Da ",
      "Qu ",
      "Ju ",
      "Gem ",
      "Za ",
      "Tuo ",
      "Duo ",
      "Pou ",
      "Pao ",
      "Bi ",
      "Fu ",
      "Yang ",
      "He ",
      "Zha ",
      "He ",
      "Hai ",
      "Jiu ",
      "Yong ",
      "Fu ",
      "Que ",
      "Zhou ",
      "Wa ",
      "Ka ",
      "Gu ",
      "Ka ",
      "Zuo ",
      "Bu ",
      "Long ",
      "Dong ",
      "Ning ",
      "Tha ",
      "Si ",
      "Xian ",
      "Huo ",
      "Qi ",
      "Er ",
      "E ",
      "Guang ",
      "Zha ",
      "Xi ",
      "Yi ",
      "Lie ",
      "Zi ",
      "Mie ",
      "Mi ",
      "Zhi ",
      "Yao ",
      "Ji ",
      "Zhou ",
      "Ge ",
      "Shuai ",
      "Zan ",
      "Xiao ",
      "Ke ",
      "Hui ",
      "Kua ",
      "Huai ",
      "Tao ",
      "Xian ",
      "E ",
      "Xuan ",
      "Xiu ",
      "Wai ",
      "Yan ",
      "Lao ",
      "Yi ",
      "Ai ",
      "Pin ",
      "Shen ",
      "Tong ",
      "Hong ",
      "Xiong ",
      "Chi ",
      "Wa ",
      "Ha ",
      "Zai ",
      "Yu ",
      "Di ",
      "Pai ",
      "Xiang ",
      "Ai ",
      "Hen ",
      "Kuang ",
      "Ya ",
      "Da ",
      "Xiao ",
      "Bi ",
      "Yue ",
      "[?] ",
      "Hua ",
      "Sasou ",
      "Kuai ",
      "Duo ",
      "[?] ",
      "Ji ",
      "Nong ",
      "Mou ",
      "Yo ",
      "Hao ",
      "Yuan ",
      "Long ",
      "Pou ",
      "Mang ",
      "Ge ",
      "E ",
      "Chi ",
      "Shao ",
      "Li ",
      "Na ",
      "Zu ",
      "He ",
      "Ku ",
      "Xiao ",
      "Xian ",
      "Lao ",
      "Bo ",
      "Zhe ",
      "Zha ",
      "Liang ",
      "Ba ",
      "Mie ",
      "Le ",
      "Sui ",
      "Fou ",
      "Bu ",
      "Han ",
      "Heng ",
      "Geng ",
      "Shuo ",
      "Ge "
    ];
  }
});

// node_modules/unidecode/data/x55.js
var require_x55 = __commonJS({
  "node_modules/unidecode/data/x55.js"(exports2, module2) {
    module2.exports = [
      "You ",
      "Yan ",
      "Gu ",
      "Gu ",
      "Bai ",
      "Han ",
      "Suo ",
      "Chun ",
      "Yi ",
      "Ai ",
      "Jia ",
      "Tu ",
      "Xian ",
      "Huan ",
      "Li ",
      "Xi ",
      "Tang ",
      "Zuo ",
      "Qiu ",
      "Che ",
      "Wu ",
      "Zao ",
      "Ya ",
      "Dou ",
      "Qi ",
      "Di ",
      "Qin ",
      "Ma ",
      "Mal ",
      "Hong ",
      "Dou ",
      "Kes ",
      "Lao ",
      "Liang ",
      "Suo ",
      "Zao ",
      "Huan ",
      "Lang ",
      "Sha ",
      "Ji ",
      "Zuo ",
      "Wo ",
      "Feng ",
      "Yin ",
      "Hu ",
      "Qi ",
      "Shou ",
      "Wei ",
      "Shua ",
      "Chang ",
      "Er ",
      "Li ",
      "Qiang ",
      "An ",
      "Jie ",
      "Yo ",
      "Nian ",
      "Yu ",
      "Tian ",
      "Lai ",
      "Sha ",
      "Xi ",
      "Tuo ",
      "Hu ",
      "Ai ",
      "Zhou ",
      "Nou ",
      "Ken ",
      "Zhuo ",
      "Zhuo ",
      "Shang ",
      "Di ",
      "Heng ",
      "Lan ",
      "A ",
      "Xiao ",
      "Xiang ",
      "Tun ",
      "Wu ",
      "Wen ",
      "Cui ",
      "Sha ",
      "Hu ",
      "Qi ",
      "Qi ",
      "Tao ",
      "Dan ",
      "Dan ",
      "Ye ",
      "Zi ",
      "Bi ",
      "Cui ",
      "Chuo ",
      "He ",
      "Ya ",
      "Qi ",
      "Zhe ",
      "Pei ",
      "Liang ",
      "Xian ",
      "Pi ",
      "Sha ",
      "La ",
      "Ze ",
      "Qing ",
      "Gua ",
      "Pa ",
      "Zhe ",
      "Se ",
      "Zhuan ",
      "Nie ",
      "Guo ",
      "Luo ",
      "Yan ",
      "Di ",
      "Quan ",
      "Tan ",
      "Bo ",
      "Ding ",
      "Lang ",
      "Xiao ",
      "[?] ",
      "Tang ",
      "Chi ",
      "Ti ",
      "An ",
      "Jiu ",
      "Dan ",
      "Ke ",
      "Yong ",
      "Wei ",
      "Nan ",
      "Shan ",
      "Yu ",
      "Zhe ",
      "La ",
      "Jie ",
      "Hou ",
      "Han ",
      "Die ",
      "Zhou ",
      "Chai ",
      "Wai ",
      "Re ",
      "Yu ",
      "Yin ",
      "Zan ",
      "Yao ",
      "Wo ",
      "Mian ",
      "Hu ",
      "Yun ",
      "Chuan ",
      "Hui ",
      "Huan ",
      "Huan ",
      "Xi ",
      "He ",
      "Ji ",
      "Kui ",
      "Zhong ",
      "Wei ",
      "Sha ",
      "Xu ",
      "Huang ",
      "Du ",
      "Nie ",
      "Xuan ",
      "Liang ",
      "Yu ",
      "Sang ",
      "Chi ",
      "Qiao ",
      "Yan ",
      "Dan ",
      "Pen ",
      "Can ",
      "Li ",
      "Yo ",
      "Zha ",
      "Wei ",
      "Miao ",
      "Ying ",
      "Pen ",
      "Phos ",
      "Kui ",
      "Xi ",
      "Yu ",
      "Jie ",
      "Lou ",
      "Ku ",
      "Sao ",
      "Huo ",
      "Ti ",
      "Yao ",
      "He ",
      "A ",
      "Xiu ",
      "Qiang ",
      "Se ",
      "Yong ",
      "Su ",
      "Hong ",
      "Xie ",
      "Yi ",
      "Suo ",
      "Ma ",
      "Cha ",
      "Hai ",
      "Ke ",
      "Ta ",
      "Sang ",
      "Tian ",
      "Ru ",
      "Sou ",
      "Wa ",
      "Ji ",
      "Pang ",
      "Wu ",
      "Xian ",
      "Shi ",
      "Ge ",
      "Zi ",
      "Jie ",
      "Luo ",
      "Weng ",
      "Wa ",
      "Si ",
      "Chi ",
      "Hao ",
      "Suo ",
      "Jia ",
      "Hai ",
      "Suo ",
      "Qin ",
      "Nie ",
      "He ",
      "Cis ",
      "Sai ",
      "Ng ",
      "Ge ",
      "Na ",
      "Dia ",
      "Ai ",
      "[?] ",
      "Tong ",
      "Bi ",
      "Ao ",
      "Ao ",
      "Lian ",
      "Cui ",
      "Zhe ",
      "Mo ",
      "Sou ",
      "Sou ",
      "Tan "
    ];
  }
});

// node_modules/unidecode/data/x56.js
var require_x56 = __commonJS({
  "node_modules/unidecode/data/x56.js"(exports2, module2) {
    module2.exports = [
      "Di ",
      "Qi ",
      "Jiao ",
      "Chong ",
      "Jiao ",
      "Kai ",
      "Tan ",
      "San ",
      "Cao ",
      "Jia ",
      "Ai ",
      "Xiao ",
      "Piao ",
      "Lou ",
      "Ga ",
      "Gu ",
      "Xiao ",
      "Hu ",
      "Hui ",
      "Guo ",
      "Ou ",
      "Xian ",
      "Ze ",
      "Chang ",
      "Xu ",
      "Po ",
      "De ",
      "Ma ",
      "Ma ",
      "Hu ",
      "Lei ",
      "Du ",
      "Ga ",
      "Tang ",
      "Ye ",
      "Beng ",
      "Ying ",
      "Saai ",
      "Jiao ",
      "Mi ",
      "Xiao ",
      "Hua ",
      "Mai ",
      "Ran ",
      "Zuo ",
      "Peng ",
      "Lao ",
      "Xiao ",
      "Ji ",
      "Zhu ",
      "Chao ",
      "Kui ",
      "Zui ",
      "Xiao ",
      "Si ",
      "Hao ",
      "Fu ",
      "Liao ",
      "Qiao ",
      "Xi ",
      "Xiu ",
      "Tan ",
      "Tan ",
      "Mo ",
      "Xun ",
      "E ",
      "Zun ",
      "Fan ",
      "Chi ",
      "Hui ",
      "Zan ",
      "Chuang ",
      "Cu ",
      "Dan ",
      "Yu ",
      "Tun ",
      "Cheng ",
      "Jiao ",
      "Ye ",
      "Xi ",
      "Qi ",
      "Hao ",
      "Lian ",
      "Xu ",
      "Deng ",
      "Hui ",
      "Yin ",
      "Pu ",
      "Jue ",
      "Qin ",
      "Xun ",
      "Nie ",
      "Lu ",
      "Si ",
      "Yan ",
      "Ying ",
      "Da ",
      "Dan ",
      "Yu ",
      "Zhou ",
      "Jin ",
      "Nong ",
      "Yue ",
      "Hui ",
      "Qi ",
      "E ",
      "Zao ",
      "Yi ",
      "Shi ",
      "Jiao ",
      "Yuan ",
      "Ai ",
      "Yong ",
      "Jue ",
      "Kuai ",
      "Yu ",
      "Pen ",
      "Dao ",
      "Ge ",
      "Xin ",
      "Dun ",
      "Dang ",
      "Sin ",
      "Sai ",
      "Pi ",
      "Pi ",
      "Yin ",
      "Zui ",
      "Ning ",
      "Di ",
      "Lan ",
      "Ta ",
      "Huo ",
      "Ru ",
      "Hao ",
      "Xia ",
      "Ya ",
      "Duo ",
      "Xi ",
      "Chou ",
      "Ji ",
      "Jin ",
      "Hao ",
      "Ti ",
      "Chang ",
      "[?] ",
      "[?] ",
      "Ca ",
      "Ti ",
      "Lu ",
      "Hui ",
      "Bo ",
      "You ",
      "Nie ",
      "Yin ",
      "Hu ",
      "Mo ",
      "Huang ",
      "Zhe ",
      "Li ",
      "Liu ",
      "Haai ",
      "Nang ",
      "Xiao ",
      "Mo ",
      "Yan ",
      "Li ",
      "Lu ",
      "Long ",
      "Fu ",
      "Dan ",
      "Chen ",
      "Pin ",
      "Pi ",
      "Xiang ",
      "Huo ",
      "Mo ",
      "Xi ",
      "Duo ",
      "Ku ",
      "Yan ",
      "Chan ",
      "Ying ",
      "Rang ",
      "Dian ",
      "La ",
      "Ta ",
      "Xiao ",
      "Jiao ",
      "Chuo ",
      "Huan ",
      "Huo ",
      "Zhuan ",
      "Nie ",
      "Xiao ",
      "Ca ",
      "Li ",
      "Chan ",
      "Chai ",
      "Li ",
      "Yi ",
      "Luo ",
      "Nang ",
      "Zan ",
      "Su ",
      "Xi ",
      "So ",
      "Jian ",
      "Za ",
      "Zhu ",
      "Lan ",
      "Nie ",
      "Nang ",
      "[?] ",
      "[?] ",
      "Wei ",
      "Hui ",
      "Yin ",
      "Qiu ",
      "Si ",
      "Nin ",
      "Jian ",
      "Hui ",
      "Xin ",
      "Yin ",
      "Nan ",
      "Tuan ",
      "Tuan ",
      "Dun ",
      "Kang ",
      "Yuan ",
      "Jiong ",
      "Pian ",
      "Yun ",
      "Cong ",
      "Hu ",
      "Hui ",
      "Yuan ",
      "You ",
      "Guo ",
      "Kun ",
      "Cong ",
      "Wei ",
      "Tu ",
      "Wei ",
      "Lun ",
      "Guo ",
      "Qun ",
      "Ri ",
      "Ling ",
      "Gu ",
      "Guo ",
      "Tai ",
      "Guo ",
      "Tu ",
      "You "
    ];
  }
});

// node_modules/unidecode/data/x57.js
var require_x57 = __commonJS({
  "node_modules/unidecode/data/x57.js"(exports2, module2) {
    module2.exports = [
      "Guo ",
      "Yin ",
      "Hun ",
      "Pu ",
      "Yu ",
      "Han ",
      "Yuan ",
      "Lun ",
      "Quan ",
      "Yu ",
      "Qing ",
      "Guo ",
      "Chuan ",
      "Wei ",
      "Yuan ",
      "Quan ",
      "Ku ",
      "Fu ",
      "Yuan ",
      "Yuan ",
      "E ",
      "Tu ",
      "Tu ",
      "Tu ",
      "Tuan ",
      "Lue ",
      "Hui ",
      "Yi ",
      "Yuan ",
      "Luan ",
      "Luan ",
      "Tu ",
      "Ya ",
      "Tu ",
      "Ting ",
      "Sheng ",
      "Pu ",
      "Lu ",
      "Iri ",
      "Ya ",
      "Zai ",
      "Wei ",
      "Ge ",
      "Yu ",
      "Wu ",
      "Gui ",
      "Pi ",
      "Yi ",
      "Di ",
      "Qian ",
      "Qian ",
      "Zhen ",
      "Zhuo ",
      "Dang ",
      "Qia ",
      "Akutsu ",
      "Yama ",
      "Kuang ",
      "Chang ",
      "Qi ",
      "Nie ",
      "Mo ",
      "Ji ",
      "Jia ",
      "Zhi ",
      "Zhi ",
      "Ban ",
      "Xun ",
      "Tou ",
      "Qin ",
      "Fen ",
      "Jun ",
      "Keng ",
      "Tun ",
      "Fang ",
      "Fen ",
      "Ben ",
      "Tan ",
      "Kan ",
      "Pi ",
      "Zuo ",
      "Keng ",
      "Bi ",
      "Xing ",
      "Di ",
      "Jing ",
      "Ji ",
      "Kuai ",
      "Di ",
      "Jing ",
      "Jian ",
      "Tan ",
      "Li ",
      "Ba ",
      "Wu ",
      "Fen ",
      "Zhui ",
      "Po ",
      "Pan ",
      "Tang ",
      "Kun ",
      "Qu ",
      "Tan ",
      "Zhi ",
      "Tuo ",
      "Gan ",
      "Ping ",
      "Dian ",
      "Gua ",
      "Ni ",
      "Tai ",
      "Pi ",
      "Jiong ",
      "Yang ",
      "Fo ",
      "Ao ",
      "Liu ",
      "Qiu ",
      "Mu ",
      "Ke ",
      "Gou ",
      "Xue ",
      "Ba ",
      "Chi ",
      "Che ",
      "Ling ",
      "Zhu ",
      "Fu ",
      "Hu ",
      "Zhi ",
      "Chui ",
      "La ",
      "Long ",
      "Long ",
      "Lu ",
      "Ao ",
      "Tay ",
      "Pao ",
      "[?] ",
      "Xing ",
      "Dong ",
      "Ji ",
      "Ke ",
      "Lu ",
      "Ci ",
      "Chi ",
      "Lei ",
      "Gai ",
      "Yin ",
      "Hou ",
      "Dui ",
      "Zhao ",
      "Fu ",
      "Guang ",
      "Yao ",
      "Duo ",
      "Duo ",
      "Gui ",
      "Cha ",
      "Yang ",
      "Yin ",
      "Fa ",
      "Gou ",
      "Yuan ",
      "Die ",
      "Xie ",
      "Ken ",
      "Jiong ",
      "Shou ",
      "E ",
      "Ha ",
      "Dian ",
      "Hong ",
      "Wu ",
      "Kua ",
      "[?] ",
      "Tao ",
      "Dang ",
      "Kai ",
      "Gake ",
      "Nao ",
      "An ",
      "Xing ",
      "Xian ",
      "Huan ",
      "Bang ",
      "Pei ",
      "Ba ",
      "Yi ",
      "Yin ",
      "Han ",
      "Xu ",
      "Chui ",
      "Cen ",
      "Geng ",
      "Ai ",
      "Peng ",
      "Fang ",
      "Que ",
      "Yong ",
      "Xun ",
      "Jia ",
      "Di ",
      "Mai ",
      "Lang ",
      "Xuan ",
      "Cheng ",
      "Yan ",
      "Jin ",
      "Zhe ",
      "Lei ",
      "Lie ",
      "Bu ",
      "Cheng ",
      "Gomi ",
      "Bu ",
      "Shi ",
      "Xun ",
      "Guo ",
      "Jiong ",
      "Ye ",
      "Nian ",
      "Di ",
      "Yu ",
      "Bu ",
      "Ya ",
      "Juan ",
      "Sui ",
      "Pi ",
      "Cheng ",
      "Wan ",
      "Ju ",
      "Lun ",
      "Zheng ",
      "Kong ",
      "Chong ",
      "Dong ",
      "Dai ",
      "Tan ",
      "An ",
      "Cai ",
      "Shu ",
      "Beng ",
      "Kan ",
      "Zhi ",
      "Duo ",
      "Yi ",
      "Zhi ",
      "Yi ",
      "Pei ",
      "Ji ",
      "Zhun ",
      "Qi ",
      "Sao ",
      "Ju ",
      "Ni "
    ];
  }
});

// node_modules/unidecode/data/x58.js
var require_x58 = __commonJS({
  "node_modules/unidecode/data/x58.js"(exports2, module2) {
    module2.exports = [
      "Ku ",
      "Ke ",
      "Tang ",
      "Kun ",
      "Ni ",
      "Jian ",
      "Dui ",
      "Jin ",
      "Gang ",
      "Yu ",
      "E ",
      "Peng ",
      "Gu ",
      "Tu ",
      "Leng ",
      "[?] ",
      "Ya ",
      "Qian ",
      "[?] ",
      "An ",
      "[?] ",
      "Duo ",
      "Nao ",
      "Tu ",
      "Cheng ",
      "Yin ",
      "Hun ",
      "Bi ",
      "Lian ",
      "Guo ",
      "Die ",
      "Zhuan ",
      "Hou ",
      "Bao ",
      "Bao ",
      "Yu ",
      "Di ",
      "Mao ",
      "Jie ",
      "Ruan ",
      "E ",
      "Geng ",
      "Kan ",
      "Zong ",
      "Yu ",
      "Huang ",
      "E ",
      "Yao ",
      "Yan ",
      "Bao ",
      "Ji ",
      "Mei ",
      "Chang ",
      "Du ",
      "Tuo ",
      "Yin ",
      "Feng ",
      "Zhong ",
      "Jie ",
      "Zhen ",
      "Feng ",
      "Gang ",
      "Chuan ",
      "Jian ",
      "Pyeng ",
      "Toride ",
      "Xiang ",
      "Huang ",
      "Leng ",
      "Duan ",
      "[?] ",
      "Xuan ",
      "Ji ",
      "Ji ",
      "Kuai ",
      "Ying ",
      "Ta ",
      "Cheng ",
      "Yong ",
      "Kai ",
      "Su ",
      "Su ",
      "Shi ",
      "Mi ",
      "Ta ",
      "Weng ",
      "Cheng ",
      "Tu ",
      "Tang ",
      "Que ",
      "Zhong ",
      "Li ",
      "Peng ",
      "Bang ",
      "Sai ",
      "Zang ",
      "Dui ",
      "Tian ",
      "Wu ",
      "Cheng ",
      "Xun ",
      "Ge ",
      "Zhen ",
      "Ai ",
      "Gong ",
      "Yan ",
      "Kan ",
      "Tian ",
      "Yuan ",
      "Wen ",
      "Xie ",
      "Liu ",
      "Ama ",
      "Lang ",
      "Chang ",
      "Peng ",
      "Beng ",
      "Chen ",
      "Cu ",
      "Lu ",
      "Ou ",
      "Qian ",
      "Mei ",
      "Mo ",
      "Zhuan ",
      "Shuang ",
      "Shu ",
      "Lou ",
      "Chi ",
      "Man ",
      "Biao ",
      "Jing ",
      "Qi ",
      "Shu ",
      "Di ",
      "Zhang ",
      "Kan ",
      "Yong ",
      "Dian ",
      "Chen ",
      "Zhi ",
      "Xi ",
      "Guo ",
      "Qiang ",
      "Jin ",
      "Di ",
      "Shang ",
      "Mu ",
      "Cui ",
      "Yan ",
      "Ta ",
      "Zeng ",
      "Qi ",
      "Qiang ",
      "Liang ",
      "[?] ",
      "Zhui ",
      "Qiao ",
      "Zeng ",
      "Xu ",
      "Shan ",
      "Shan ",
      "Ba ",
      "Pu ",
      "Kuai ",
      "Dong ",
      "Fan ",
      "Que ",
      "Mo ",
      "Dun ",
      "Dun ",
      "Dun ",
      "Di ",
      "Sheng ",
      "Duo ",
      "Duo ",
      "Tan ",
      "Deng ",
      "Wu ",
      "Fen ",
      "Huang ",
      "Tan ",
      "Da ",
      "Ye ",
      "Sho ",
      "Mama ",
      "Yu ",
      "Qiang ",
      "Ji ",
      "Qiao ",
      "Ken ",
      "Yi ",
      "Pi ",
      "Bi ",
      "Dian ",
      "Jiang ",
      "Ye ",
      "Yong ",
      "Bo ",
      "Tan ",
      "Lan ",
      "Ju ",
      "Huai ",
      "Dang ",
      "Rang ",
      "Qian ",
      "Xun ",
      "Lan ",
      "Xi ",
      "He ",
      "Ai ",
      "Ya ",
      "Dao ",
      "Hao ",
      "Ruan ",
      "Mama ",
      "Lei ",
      "Kuang ",
      "Lu ",
      "Yan ",
      "Tan ",
      "Wei ",
      "Huai ",
      "Long ",
      "Long ",
      "Rui ",
      "Li ",
      "Lin ",
      "Rang ",
      "Ten ",
      "Xun ",
      "Yan ",
      "Lei ",
      "Ba ",
      "[?] ",
      "Shi ",
      "Ren ",
      "[?] ",
      "Zhuang ",
      "Zhuang ",
      "Sheng ",
      "Yi ",
      "Mai ",
      "Ke ",
      "Zhu ",
      "Zhuang ",
      "Hu ",
      "Hu ",
      "Kun ",
      "Yi ",
      "Hu ",
      "Xu ",
      "Kun ",
      "Shou ",
      "Mang ",
      "Zun "
    ];
  }
});

// node_modules/unidecode/data/x59.js
var require_x59 = __commonJS({
  "node_modules/unidecode/data/x59.js"(exports2, module2) {
    module2.exports = [
      "Shou ",
      "Yi ",
      "Zhi ",
      "Gu ",
      "Chu ",
      "Jiang ",
      "Feng ",
      "Bei ",
      "Cay ",
      "Bian ",
      "Sui ",
      "Qun ",
      "Ling ",
      "Fu ",
      "Zuo ",
      "Xia ",
      "Xiong ",
      "[?] ",
      "Nao ",
      "Xia ",
      "Kui ",
      "Xi ",
      "Wai ",
      "Yuan ",
      "Mao ",
      "Su ",
      "Duo ",
      "Duo ",
      "Ye ",
      "Qing ",
      "Uys ",
      "Gou ",
      "Gou ",
      "Qi ",
      "Meng ",
      "Meng ",
      "Yin ",
      "Huo ",
      "Chen ",
      "Da ",
      "Ze ",
      "Tian ",
      "Tai ",
      "Fu ",
      "Guai ",
      "Yao ",
      "Yang ",
      "Hang ",
      "Gao ",
      "Shi ",
      "Ben ",
      "Tai ",
      "Tou ",
      "Yan ",
      "Bi ",
      "Yi ",
      "Kua ",
      "Jia ",
      "Duo ",
      "Kwu ",
      "Kuang ",
      "Yun ",
      "Jia ",
      "Pa ",
      "En ",
      "Lian ",
      "Huan ",
      "Di ",
      "Yan ",
      "Pao ",
      "Quan ",
      "Qi ",
      "Nai ",
      "Feng ",
      "Xie ",
      "Fen ",
      "Dian ",
      "[?] ",
      "Kui ",
      "Zou ",
      "Huan ",
      "Qi ",
      "Kai ",
      "Zha ",
      "Ben ",
      "Yi ",
      "Jiang ",
      "Tao ",
      "Zang ",
      "Ben ",
      "Xi ",
      "Xiang ",
      "Fei ",
      "Diao ",
      "Xun ",
      "Keng ",
      "Dian ",
      "Ao ",
      "She ",
      "Weng ",
      "Pan ",
      "Ao ",
      "Wu ",
      "Ao ",
      "Jiang ",
      "Lian ",
      "Duo ",
      "Yun ",
      "Jiang ",
      "Shi ",
      "Fen ",
      "Huo ",
      "Bi ",
      "Lian ",
      "Duo ",
      "Nu ",
      "Nu ",
      "Ding ",
      "Nai ",
      "Qian ",
      "Jian ",
      "Ta ",
      "Jiu ",
      "Nan ",
      "Cha ",
      "Hao ",
      "Xian ",
      "Fan ",
      "Ji ",
      "Shuo ",
      "Ru ",
      "Fei ",
      "Wang ",
      "Hong ",
      "Zhuang ",
      "Fu ",
      "Ma ",
      "Dan ",
      "Ren ",
      "Fu ",
      "Jing ",
      "Yan ",
      "Xie ",
      "Wen ",
      "Zhong ",
      "Pa ",
      "Du ",
      "Ji ",
      "Keng ",
      "Zhong ",
      "Yao ",
      "Jin ",
      "Yun ",
      "Miao ",
      "Pei ",
      "Shi ",
      "Yue ",
      "Zhuang ",
      "Niu ",
      "Yan ",
      "Na ",
      "Xin ",
      "Fen ",
      "Bi ",
      "Yu ",
      "Tuo ",
      "Feng ",
      "Yuan ",
      "Fang ",
      "Wu ",
      "Yu ",
      "Gui ",
      "Du ",
      "Ba ",
      "Ni ",
      "Zhou ",
      "Zhuo ",
      "Zhao ",
      "Da ",
      "Nai ",
      "Yuan ",
      "Tou ",
      "Xuan ",
      "Zhi ",
      "E ",
      "Mei ",
      "Mo ",
      "Qi ",
      "Bi ",
      "Shen ",
      "Qie ",
      "E ",
      "He ",
      "Xu ",
      "Fa ",
      "Zheng ",
      "Min ",
      "Ban ",
      "Mu ",
      "Fu ",
      "Ling ",
      "Zi ",
      "Zi ",
      "Shi ",
      "Ran ",
      "Shan ",
      "Yang ",
      "Man ",
      "Jie ",
      "Gu ",
      "Si ",
      "Xing ",
      "Wei ",
      "Zi ",
      "Ju ",
      "Shan ",
      "Pin ",
      "Ren ",
      "Yao ",
      "Tong ",
      "Jiang ",
      "Shu ",
      "Ji ",
      "Gai ",
      "Shang ",
      "Kuo ",
      "Juan ",
      "Jiao ",
      "Gou ",
      "Mu ",
      "Jian ",
      "Jian ",
      "Yi ",
      "Nian ",
      "Zhi ",
      "Ji ",
      "Ji ",
      "Xian ",
      "Heng ",
      "Guang ",
      "Jun ",
      "Kua ",
      "Yan ",
      "Ming ",
      "Lie ",
      "Pei ",
      "Yan ",
      "You ",
      "Yan ",
      "Cha ",
      "Shen ",
      "Yin ",
      "Chi ",
      "Gui ",
      "Quan ",
      "Zi "
    ];
  }
});

// node_modules/unidecode/data/x5a.js
var require_x5a = __commonJS({
  "node_modules/unidecode/data/x5a.js"(exports2, module2) {
    module2.exports = [
      "Song ",
      "Wei ",
      "Hong ",
      "Wa ",
      "Lou ",
      "Ya ",
      "Rao ",
      "Jiao ",
      "Luan ",
      "Ping ",
      "Xian ",
      "Shao ",
      "Li ",
      "Cheng ",
      "Xiao ",
      "Mang ",
      "Fu ",
      "Suo ",
      "Wu ",
      "Wei ",
      "Ke ",
      "Lai ",
      "Chuo ",
      "Ding ",
      "Niang ",
      "Xing ",
      "Nan ",
      "Yu ",
      "Nuo ",
      "Pei ",
      "Nei ",
      "Juan ",
      "Shen ",
      "Zhi ",
      "Han ",
      "Di ",
      "Zhuang ",
      "E ",
      "Pin ",
      "Tui ",
      "Han ",
      "Mian ",
      "Wu ",
      "Yan ",
      "Wu ",
      "Xi ",
      "Yan ",
      "Yu ",
      "Si ",
      "Yu ",
      "Wa ",
      "[?] ",
      "Xian ",
      "Ju ",
      "Qu ",
      "Shui ",
      "Qi ",
      "Xian ",
      "Zhui ",
      "Dong ",
      "Chang ",
      "Lu ",
      "Ai ",
      "E ",
      "E ",
      "Lou ",
      "Mian ",
      "Cong ",
      "Pou ",
      "Ju ",
      "Po ",
      "Cai ",
      "Ding ",
      "Wan ",
      "Biao ",
      "Xiao ",
      "Shu ",
      "Qi ",
      "Hui ",
      "Fu ",
      "E ",
      "Wo ",
      "Tan ",
      "Fei ",
      "Wei ",
      "Jie ",
      "Tian ",
      "Ni ",
      "Quan ",
      "Jing ",
      "Hun ",
      "Jing ",
      "Qian ",
      "Dian ",
      "Xing ",
      "Hu ",
      "Wa ",
      "Lai ",
      "Bi ",
      "Yin ",
      "Chou ",
      "Chuo ",
      "Fu ",
      "Jing ",
      "Lun ",
      "Yan ",
      "Lan ",
      "Kun ",
      "Yin ",
      "Ya ",
      "Ju ",
      "Li ",
      "Dian ",
      "Xian ",
      "Hwa ",
      "Hua ",
      "Ying ",
      "Chan ",
      "Shen ",
      "Ting ",
      "Dang ",
      "Yao ",
      "Wu ",
      "Nan ",
      "Ruo ",
      "Jia ",
      "Tou ",
      "Xu ",
      "Yu ",
      "Wei ",
      "Ti ",
      "Rou ",
      "Mei ",
      "Dan ",
      "Ruan ",
      "Qin ",
      "Hui ",
      "Wu ",
      "Qian ",
      "Chun ",
      "Mao ",
      "Fu ",
      "Jie ",
      "Duan ",
      "Xi ",
      "Zhong ",
      "Mei ",
      "Huang ",
      "Mian ",
      "An ",
      "Ying ",
      "Xuan ",
      "Jie ",
      "Wei ",
      "Mei ",
      "Yuan ",
      "Zhen ",
      "Qiu ",
      "Ti ",
      "Xie ",
      "Tuo ",
      "Lian ",
      "Mao ",
      "Ran ",
      "Si ",
      "Pian ",
      "Wei ",
      "Wa ",
      "Jiu ",
      "Hu ",
      "Ao ",
      "[?] ",
      "Bou ",
      "Xu ",
      "Tou ",
      "Gui ",
      "Zou ",
      "Yao ",
      "Pi ",
      "Xi ",
      "Yuan ",
      "Ying ",
      "Rong ",
      "Ru ",
      "Chi ",
      "Liu ",
      "Mei ",
      "Pan ",
      "Ao ",
      "Ma ",
      "Gou ",
      "Kui ",
      "Qin ",
      "Jia ",
      "Sao ",
      "Zhen ",
      "Yuan ",
      "Cha ",
      "Yong ",
      "Ming ",
      "Ying ",
      "Ji ",
      "Su ",
      "Niao ",
      "Xian ",
      "Tao ",
      "Pang ",
      "Lang ",
      "Nao ",
      "Bao ",
      "Ai ",
      "Pi ",
      "Pin ",
      "Yi ",
      "Piao ",
      "Yu ",
      "Lei ",
      "Xuan ",
      "Man ",
      "Yi ",
      "Zhang ",
      "Kang ",
      "Yong ",
      "Ni ",
      "Li ",
      "Di ",
      "Gui ",
      "Yan ",
      "Jin ",
      "Zhuan ",
      "Chang ",
      "Ce ",
      "Han ",
      "Nen ",
      "Lao ",
      "Mo ",
      "Zhe ",
      "Hu ",
      "Hu ",
      "Ao ",
      "Nen ",
      "Qiang ",
      "Ma ",
      "Pie ",
      "Gu ",
      "Wu ",
      "Jiao ",
      "Tuo ",
      "Zhan ",
      "Mao ",
      "Xian ",
      "Xian ",
      "Mo ",
      "Liao ",
      "Lian ",
      "Hua "
    ];
  }
});

// node_modules/unidecode/data/x5b.js
var require_x5b = __commonJS({
  "node_modules/unidecode/data/x5b.js"(exports2, module2) {
    module2.exports = [
      "Gui ",
      "Deng ",
      "Zhi ",
      "Xu ",
      "Yi ",
      "Hua ",
      "Xi ",
      "Hui ",
      "Rao ",
      "Xi ",
      "Yan ",
      "Chan ",
      "Jiao ",
      "Mei ",
      "Fan ",
      "Fan ",
      "Xian ",
      "Yi ",
      "Wei ",
      "Jiao ",
      "Fu ",
      "Shi ",
      "Bi ",
      "Shan ",
      "Sui ",
      "Qiang ",
      "Lian ",
      "Huan ",
      "Xin ",
      "Niao ",
      "Dong ",
      "Yi ",
      "Can ",
      "Ai ",
      "Niang ",
      "Neng ",
      "Ma ",
      "Tiao ",
      "Chou ",
      "Jin ",
      "Ci ",
      "Yu ",
      "Pin ",
      "Yong ",
      "Xu ",
      "Nai ",
      "Yan ",
      "Tai ",
      "Ying ",
      "Can ",
      "Niao ",
      "Wo ",
      "Ying ",
      "Mian ",
      "Kaka ",
      "Ma ",
      "Shen ",
      "Xing ",
      "Ni ",
      "Du ",
      "Liu ",
      "Yuan ",
      "Lan ",
      "Yan ",
      "Shuang ",
      "Ling ",
      "Jiao ",
      "Niang ",
      "Lan ",
      "Xian ",
      "Ying ",
      "Shuang ",
      "Shuai ",
      "Quan ",
      "Mi ",
      "Li ",
      "Luan ",
      "Yan ",
      "Zhu ",
      "Lan ",
      "Zi ",
      "Jie ",
      "Jue ",
      "Jue ",
      "Kong ",
      "Yun ",
      "Zi ",
      "Zi ",
      "Cun ",
      "Sun ",
      "Fu ",
      "Bei ",
      "Zi ",
      "Xiao ",
      "Xin ",
      "Meng ",
      "Si ",
      "Tai ",
      "Bao ",
      "Ji ",
      "Gu ",
      "Nu ",
      "Xue ",
      "[?] ",
      "Zhuan ",
      "Hai ",
      "Luan ",
      "Sun ",
      "Huai ",
      "Mie ",
      "Cong ",
      "Qian ",
      "Shu ",
      "Chan ",
      "Ya ",
      "Zi ",
      "Ni ",
      "Fu ",
      "Zi ",
      "Li ",
      "Xue ",
      "Bo ",
      "Ru ",
      "Lai ",
      "Nie ",
      "Nie ",
      "Ying ",
      "Luan ",
      "Mian ",
      "Zhu ",
      "Rong ",
      "Ta ",
      "Gui ",
      "Zhai ",
      "Qiong ",
      "Yu ",
      "Shou ",
      "An ",
      "Tu ",
      "Song ",
      "Wan ",
      "Rou ",
      "Yao ",
      "Hong ",
      "Yi ",
      "Jing ",
      "Zhun ",
      "Mi ",
      "Zhu ",
      "Dang ",
      "Hong ",
      "Zong ",
      "Guan ",
      "Zhou ",
      "Ding ",
      "Wan ",
      "Yi ",
      "Bao ",
      "Shi ",
      "Shi ",
      "Chong ",
      "Shen ",
      "Ke ",
      "Xuan ",
      "Shi ",
      "You ",
      "Huan ",
      "Yi ",
      "Tiao ",
      "Shi ",
      "Xian ",
      "Gong ",
      "Cheng ",
      "Qun ",
      "Gong ",
      "Xiao ",
      "Zai ",
      "Zha ",
      "Bao ",
      "Hai ",
      "Yan ",
      "Xiao ",
      "Jia ",
      "Shen ",
      "Chen ",
      "Rong ",
      "Huang ",
      "Mi ",
      "Kou ",
      "Kuan ",
      "Bin ",
      "Su ",
      "Cai ",
      "Zan ",
      "Ji ",
      "Yuan ",
      "Ji ",
      "Yin ",
      "Mi ",
      "Kou ",
      "Qing ",
      "Que ",
      "Zhen ",
      "Jian ",
      "Fu ",
      "Ning ",
      "Bing ",
      "Huan ",
      "Mei ",
      "Qin ",
      "Han ",
      "Yu ",
      "Shi ",
      "Ning ",
      "Qin ",
      "Ning ",
      "Zhi ",
      "Yu ",
      "Bao ",
      "Kuan ",
      "Ning ",
      "Qin ",
      "Mo ",
      "Cha ",
      "Ju ",
      "Gua ",
      "Qin ",
      "Hu ",
      "Wu ",
      "Liao ",
      "Shi ",
      "Zhu ",
      "Zhai ",
      "Shen ",
      "Wei ",
      "Xie ",
      "Kuan ",
      "Hui ",
      "Liao ",
      "Jun ",
      "Huan ",
      "Yi ",
      "Yi ",
      "Bao ",
      "Qin ",
      "Chong ",
      "Bao ",
      "Feng ",
      "Cun ",
      "Dui ",
      "Si ",
      "Xun ",
      "Dao ",
      "Lu ",
      "Dui ",
      "Shou "
    ];
  }
});

// node_modules/unidecode/data/x5c.js
var require_x5c = __commonJS({
  "node_modules/unidecode/data/x5c.js"(exports2, module2) {
    module2.exports = [
      "Po ",
      "Feng ",
      "Zhuan ",
      "Fu ",
      "She ",
      "Ke ",
      "Jiang ",
      "Jiang ",
      "Zhuan ",
      "Wei ",
      "Zun ",
      "Xun ",
      "Shu ",
      "Dui ",
      "Dao ",
      "Xiao ",
      "Ji ",
      "Shao ",
      "Er ",
      "Er ",
      "Er ",
      "Ga ",
      "Jian ",
      "Shu ",
      "Chen ",
      "Shang ",
      "Shang ",
      "Mo ",
      "Ga ",
      "Chang ",
      "Liao ",
      "Xian ",
      "Xian ",
      "[?] ",
      "Wang ",
      "Wang ",
      "You ",
      "Liao ",
      "Liao ",
      "Yao ",
      "Mang ",
      "Wang ",
      "Wang ",
      "Wang ",
      "Ga ",
      "Yao ",
      "Duo ",
      "Kui ",
      "Zhong ",
      "Jiu ",
      "Gan ",
      "Gu ",
      "Gan ",
      "Tui ",
      "Gan ",
      "Gan ",
      "Shi ",
      "Yin ",
      "Chi ",
      "Kao ",
      "Ni ",
      "Jin ",
      "Wei ",
      "Niao ",
      "Ju ",
      "Pi ",
      "Ceng ",
      "Xi ",
      "Bi ",
      "Ju ",
      "Jie ",
      "Tian ",
      "Qu ",
      "Ti ",
      "Jie ",
      "Wu ",
      "Diao ",
      "Shi ",
      "Shi ",
      "Ping ",
      "Ji ",
      "Xie ",
      "Chen ",
      "Xi ",
      "Ni ",
      "Zhan ",
      "Xi ",
      "[?] ",
      "Man ",
      "E ",
      "Lou ",
      "Ping ",
      "Ti ",
      "Fei ",
      "Shu ",
      "Xie ",
      "Tu ",
      "Lu ",
      "Lu ",
      "Xi ",
      "Ceng ",
      "Lu ",
      "Ju ",
      "Xie ",
      "Ju ",
      "Jue ",
      "Liao ",
      "Jue ",
      "Shu ",
      "Xi ",
      "Che ",
      "Tun ",
      "Ni ",
      "Shan ",
      "[?] ",
      "Xian ",
      "Li ",
      "Xue ",
      "Nata ",
      "[?] ",
      "Long ",
      "Yi ",
      "Qi ",
      "Ren ",
      "Wu ",
      "Han ",
      "Shen ",
      "Yu ",
      "Chu ",
      "Sui ",
      "Qi ",
      "[?] ",
      "Yue ",
      "Ban ",
      "Yao ",
      "Ang ",
      "Ya ",
      "Wu ",
      "Jie ",
      "E ",
      "Ji ",
      "Qian ",
      "Fen ",
      "Yuan ",
      "Qi ",
      "Cen ",
      "Qian ",
      "Qi ",
      "Cha ",
      "Jie ",
      "Qu ",
      "Gang ",
      "Xian ",
      "Ao ",
      "Lan ",
      "Dao ",
      "Ba ",
      "Zuo ",
      "Zuo ",
      "Yang ",
      "Ju ",
      "Gang ",
      "Ke ",
      "Gou ",
      "Xue ",
      "Bei ",
      "Li ",
      "Tiao ",
      "Ju ",
      "Yan ",
      "Fu ",
      "Xiu ",
      "Jia ",
      "Ling ",
      "Tuo ",
      "Pei ",
      "You ",
      "Dai ",
      "Kuang ",
      "Yue ",
      "Qu ",
      "Hu ",
      "Po ",
      "Min ",
      "An ",
      "Tiao ",
      "Ling ",
      "Chi ",
      "Yuri ",
      "Dong ",
      "Cem ",
      "Kui ",
      "Xiu ",
      "Mao ",
      "Tong ",
      "Xue ",
      "Yi ",
      "Kura ",
      "He ",
      "Ke ",
      "Luo ",
      "E ",
      "Fu ",
      "Xun ",
      "Die ",
      "Lu ",
      "An ",
      "Er ",
      "Gai ",
      "Quan ",
      "Tong ",
      "Yi ",
      "Mu ",
      "Shi ",
      "An ",
      "Wei ",
      "Hu ",
      "Zhi ",
      "Mi ",
      "Li ",
      "Ji ",
      "Tong ",
      "Wei ",
      "You ",
      "Sang ",
      "Xia ",
      "Li ",
      "Yao ",
      "Jiao ",
      "Zheng ",
      "Luan ",
      "Jiao ",
      "E ",
      "E ",
      "Yu ",
      "Ye ",
      "Bu ",
      "Qiao ",
      "Qun ",
      "Feng ",
      "Feng ",
      "Nao ",
      "Li ",
      "You ",
      "Xian ",
      "Hong ",
      "Dao ",
      "Shen ",
      "Cheng ",
      "Tu ",
      "Geng ",
      "Jun ",
      "Hao ",
      "Xia ",
      "Yin ",
      "Yu "
    ];
  }
});

// node_modules/unidecode/data/x5d.js
var require_x5d = __commonJS({
  "node_modules/unidecode/data/x5d.js"(exports2, module2) {
    module2.exports = [
      "Lang ",
      "Kan ",
      "Lao ",
      "Lai ",
      "Xian ",
      "Que ",
      "Kong ",
      "Chong ",
      "Chong ",
      "Ta ",
      "Lin ",
      "Hua ",
      "Ju ",
      "Lai ",
      "Qi ",
      "Min ",
      "Kun ",
      "Kun ",
      "Zu ",
      "Gu ",
      "Cui ",
      "Ya ",
      "Ya ",
      "Gang ",
      "Lun ",
      "Lun ",
      "Leng ",
      "Jue ",
      "Duo ",
      "Zheng ",
      "Guo ",
      "Yin ",
      "Dong ",
      "Han ",
      "Zheng ",
      "Wei ",
      "Yao ",
      "Pi ",
      "Yan ",
      "Song ",
      "Jie ",
      "Beng ",
      "Zu ",
      "Jue ",
      "Dong ",
      "Zhan ",
      "Gu ",
      "Yin ",
      "[?] ",
      "Ze ",
      "Huang ",
      "Yu ",
      "Wei ",
      "Yang ",
      "Feng ",
      "Qiu ",
      "Dun ",
      "Ti ",
      "Yi ",
      "Zhi ",
      "Shi ",
      "Zai ",
      "Yao ",
      "E ",
      "Zhu ",
      "Kan ",
      "Lu ",
      "Yan ",
      "Mei ",
      "Gan ",
      "Ji ",
      "Ji ",
      "Huan ",
      "Ting ",
      "Sheng ",
      "Mei ",
      "Qian ",
      "Wu ",
      "Yu ",
      "Zong ",
      "Lan ",
      "Jue ",
      "Yan ",
      "Yan ",
      "Wei ",
      "Zong ",
      "Cha ",
      "Sui ",
      "Rong ",
      "Yamashina ",
      "Qin ",
      "Yu ",
      "Kewashii ",
      "Lou ",
      "Tu ",
      "Dui ",
      "Xi ",
      "Weng ",
      "Cang ",
      "Dang ",
      "Hong ",
      "Jie ",
      "Ai ",
      "Liu ",
      "Wu ",
      "Song ",
      "Qiao ",
      "Zi ",
      "Wei ",
      "Beng ",
      "Dian ",
      "Cuo ",
      "Qian ",
      "Yong ",
      "Nie ",
      "Cuo ",
      "Ji ",
      "[?] ",
      "Tao ",
      "Song ",
      "Zong ",
      "Jiang ",
      "Liao ",
      "Kang ",
      "Chan ",
      "Die ",
      "Cen ",
      "Ding ",
      "Tu ",
      "Lou ",
      "Zhang ",
      "Zhan ",
      "Zhan ",
      "Ao ",
      "Cao ",
      "Qu ",
      "Qiang ",
      "Zui ",
      "Zui ",
      "Dao ",
      "Dao ",
      "Xi ",
      "Yu ",
      "Bo ",
      "Long ",
      "Xiang ",
      "Ceng ",
      "Bo ",
      "Qin ",
      "Jiao ",
      "Yan ",
      "Lao ",
      "Zhan ",
      "Lin ",
      "Liao ",
      "Liao ",
      "Jin ",
      "Deng ",
      "Duo ",
      "Zun ",
      "Jiao ",
      "Gui ",
      "Yao ",
      "Qiao ",
      "Yao ",
      "Jue ",
      "Zhan ",
      "Yi ",
      "Xue ",
      "Nao ",
      "Ye ",
      "Ye ",
      "Yi ",
      "E ",
      "Xian ",
      "Ji ",
      "Xie ",
      "Ke ",
      "Xi ",
      "Di ",
      "Ao ",
      "Zui ",
      "[?] ",
      "Ni ",
      "Rong ",
      "Dao ",
      "Ling ",
      "Za ",
      "Yu ",
      "Yue ",
      "Yin ",
      "[?] ",
      "Jie ",
      "Li ",
      "Sui ",
      "Long ",
      "Long ",
      "Dian ",
      "Ying ",
      "Xi ",
      "Ju ",
      "Chan ",
      "Ying ",
      "Kui ",
      "Yan ",
      "Wei ",
      "Nao ",
      "Quan ",
      "Chao ",
      "Cuan ",
      "Luan ",
      "Dian ",
      "Dian ",
      "[?] ",
      "Yan ",
      "Yan ",
      "Yan ",
      "Nao ",
      "Yan ",
      "Chuan ",
      "Gui ",
      "Chuan ",
      "Zhou ",
      "Huang ",
      "Jing ",
      "Xun ",
      "Chao ",
      "Chao ",
      "Lie ",
      "Gong ",
      "Zuo ",
      "Qiao ",
      "Ju ",
      "Gong ",
      "Kek ",
      "Wu ",
      "Pwu ",
      "Pwu ",
      "Chai ",
      "Qiu ",
      "Qiu ",
      "Ji ",
      "Yi ",
      "Si ",
      "Ba ",
      "Zhi ",
      "Zhao ",
      "Xiang ",
      "Yi ",
      "Jin ",
      "Xun ",
      "Juan ",
      "Phas ",
      "Xun ",
      "Jin ",
      "Fu "
    ];
  }
});

// node_modules/unidecode/data/x5e.js
var require_x5e = __commonJS({
  "node_modules/unidecode/data/x5e.js"(exports2, module2) {
    module2.exports = [
      "Za ",
      "Bi ",
      "Shi ",
      "Bu ",
      "Ding ",
      "Shuai ",
      "Fan ",
      "Nie ",
      "Shi ",
      "Fen ",
      "Pa ",
      "Zhi ",
      "Xi ",
      "Hu ",
      "Dan ",
      "Wei ",
      "Zhang ",
      "Tang ",
      "Dai ",
      "Ma ",
      "Pei ",
      "Pa ",
      "Tie ",
      "Fu ",
      "Lian ",
      "Zhi ",
      "Zhou ",
      "Bo ",
      "Zhi ",
      "Di ",
      "Mo ",
      "Yi ",
      "Yi ",
      "Ping ",
      "Qia ",
      "Juan ",
      "Ru ",
      "Shuai ",
      "Dai ",
      "Zheng ",
      "Shui ",
      "Qiao ",
      "Zhen ",
      "Shi ",
      "Qun ",
      "Xi ",
      "Bang ",
      "Dai ",
      "Gui ",
      "Chou ",
      "Ping ",
      "Zhang ",
      "Sha ",
      "Wan ",
      "Dai ",
      "Wei ",
      "Chang ",
      "Sha ",
      "Qi ",
      "Ze ",
      "Guo ",
      "Mao ",
      "Du ",
      "Hou ",
      "Zheng ",
      "Xu ",
      "Mi ",
      "Wei ",
      "Wo ",
      "Fu ",
      "Yi ",
      "Bang ",
      "Ping ",
      "Tazuna ",
      "Gong ",
      "Pan ",
      "Huang ",
      "Dao ",
      "Mi ",
      "Jia ",
      "Teng ",
      "Hui ",
      "Zhong ",
      "Shan ",
      "Man ",
      "Mu ",
      "Biao ",
      "Guo ",
      "Ze ",
      "Mu ",
      "Bang ",
      "Zhang ",
      "Jiong ",
      "Chan ",
      "Fu ",
      "Zhi ",
      "Hu ",
      "Fan ",
      "Chuang ",
      "Bi ",
      "Hei ",
      "[?] ",
      "Mi ",
      "Qiao ",
      "Chan ",
      "Fen ",
      "Meng ",
      "Bang ",
      "Chou ",
      "Mie ",
      "Chu ",
      "Jie ",
      "Xian ",
      "Lan ",
      "Gan ",
      "Ping ",
      "Nian ",
      "Qian ",
      "Bing ",
      "Bing ",
      "Xing ",
      "Gan ",
      "Yao ",
      "Huan ",
      "You ",
      "You ",
      "Ji ",
      "Yan ",
      "Pi ",
      "Ting ",
      "Ze ",
      "Guang ",
      "Zhuang ",
      "Mo ",
      "Qing ",
      "Bi ",
      "Qin ",
      "Dun ",
      "Chuang ",
      "Gui ",
      "Ya ",
      "Bai ",
      "Jie ",
      "Xu ",
      "Lu ",
      "Wu ",
      "[?] ",
      "Ku ",
      "Ying ",
      "Di ",
      "Pao ",
      "Dian ",
      "Ya ",
      "Miao ",
      "Geng ",
      "Ci ",
      "Fu ",
      "Tong ",
      "Pang ",
      "Fei ",
      "Xiang ",
      "Yi ",
      "Zhi ",
      "Tiao ",
      "Zhi ",
      "Xiu ",
      "Du ",
      "Zuo ",
      "Xiao ",
      "Tu ",
      "Gui ",
      "Ku ",
      "Pang ",
      "Ting ",
      "You ",
      "Bu ",
      "Ding ",
      "Cheng ",
      "Lai ",
      "Bei ",
      "Ji ",
      "An ",
      "Shu ",
      "Kang ",
      "Yong ",
      "Tuo ",
      "Song ",
      "Shu ",
      "Qing ",
      "Yu ",
      "Yu ",
      "Miao ",
      "Sou ",
      "Ce ",
      "Xiang ",
      "Fei ",
      "Jiu ",
      "He ",
      "Hui ",
      "Liu ",
      "Sha ",
      "Lian ",
      "Lang ",
      "Sou ",
      "Jian ",
      "Pou ",
      "Qing ",
      "Jiu ",
      "Jiu ",
      "Qin ",
      "Ao ",
      "Kuo ",
      "Lou ",
      "Yin ",
      "Liao ",
      "Dai ",
      "Lu ",
      "Yi ",
      "Chu ",
      "Chan ",
      "Tu ",
      "Si ",
      "Xin ",
      "Miao ",
      "Chang ",
      "Wu ",
      "Fei ",
      "Guang ",
      "Koc ",
      "Kuai ",
      "Bi ",
      "Qiang ",
      "Xie ",
      "Lin ",
      "Lin ",
      "Liao ",
      "Lu ",
      "[?] ",
      "Ying ",
      "Xian ",
      "Ting ",
      "Yong ",
      "Li ",
      "Ting ",
      "Yin ",
      "Xun ",
      "Yan ",
      "Ting ",
      "Di ",
      "Po ",
      "Jian ",
      "Hui ",
      "Nai ",
      "Hui ",
      "Gong ",
      "Nian "
    ];
  }
});

// node_modules/unidecode/data/x5f.js
var require_x5f = __commonJS({
  "node_modules/unidecode/data/x5f.js"(exports2, module2) {
    module2.exports = [
      "Kai ",
      "Bian ",
      "Yi ",
      "Qi ",
      "Nong ",
      "Fen ",
      "Ju ",
      "Yan ",
      "Yi ",
      "Zang ",
      "Bi ",
      "Yi ",
      "Yi ",
      "Er ",
      "San ",
      "Shi ",
      "Er ",
      "Shi ",
      "Shi ",
      "Gong ",
      "Diao ",
      "Yin ",
      "Hu ",
      "Fu ",
      "Hong ",
      "Wu ",
      "Tui ",
      "Chi ",
      "Jiang ",
      "Ba ",
      "Shen ",
      "Di ",
      "Zhang ",
      "Jue ",
      "Tao ",
      "Fu ",
      "Di ",
      "Mi ",
      "Xian ",
      "Hu ",
      "Chao ",
      "Nu ",
      "Jing ",
      "Zhen ",
      "Yi ",
      "Mi ",
      "Quan ",
      "Wan ",
      "Shao ",
      "Ruo ",
      "Xuan ",
      "Jing ",
      "Dun ",
      "Zhang ",
      "Jiang ",
      "Qiang ",
      "Peng ",
      "Dan ",
      "Qiang ",
      "Bi ",
      "Bi ",
      "She ",
      "Dan ",
      "Jian ",
      "Gou ",
      "Sei ",
      "Fa ",
      "Bi ",
      "Kou ",
      "Nagi ",
      "Bie ",
      "Xiao ",
      "Dan ",
      "Kuo ",
      "Qiang ",
      "Hong ",
      "Mi ",
      "Kuo ",
      "Wan ",
      "Jue ",
      "Ji ",
      "Ji ",
      "Gui ",
      "Dang ",
      "Lu ",
      "Lu ",
      "Tuan ",
      "Hui ",
      "Zhi ",
      "Hui ",
      "Hui ",
      "Yi ",
      "Yi ",
      "Yi ",
      "Yi ",
      "Huo ",
      "Huo ",
      "Shan ",
      "Xing ",
      "Wen ",
      "Tong ",
      "Yan ",
      "Yan ",
      "Yu ",
      "Chi ",
      "Cai ",
      "Biao ",
      "Diao ",
      "Bin ",
      "Peng ",
      "Yong ",
      "Piao ",
      "Zhang ",
      "Ying ",
      "Chi ",
      "Chi ",
      "Zhuo ",
      "Tuo ",
      "Ji ",
      "Pang ",
      "Zhong ",
      "Yi ",
      "Wang ",
      "Che ",
      "Bi ",
      "Chi ",
      "Ling ",
      "Fu ",
      "Wang ",
      "Zheng ",
      "Cu ",
      "Wang ",
      "Jing ",
      "Dai ",
      "Xi ",
      "Xun ",
      "Hen ",
      "Yang ",
      "Huai ",
      "Lu ",
      "Hou ",
      "Wa ",
      "Cheng ",
      "Zhi ",
      "Xu ",
      "Jing ",
      "Tu ",
      "Cong ",
      "[?] ",
      "Lai ",
      "Cong ",
      "De ",
      "Pai ",
      "Xi ",
      "[?] ",
      "Qi ",
      "Chang ",
      "Zhi ",
      "Cong ",
      "Zhou ",
      "Lai ",
      "Yu ",
      "Xie ",
      "Jie ",
      "Jian ",
      "Chi ",
      "Jia ",
      "Bian ",
      "Huang ",
      "Fu ",
      "Xun ",
      "Wei ",
      "Pang ",
      "Yao ",
      "Wei ",
      "Xi ",
      "Zheng ",
      "Piao ",
      "Chi ",
      "De ",
      "Zheng ",
      "Zheng ",
      "Bie ",
      "De ",
      "Chong ",
      "Che ",
      "Jiao ",
      "Wei ",
      "Jiao ",
      "Hui ",
      "Mei ",
      "Long ",
      "Xiang ",
      "Bao ",
      "Qu ",
      "Xin ",
      "Shu ",
      "Bi ",
      "Yi ",
      "Le ",
      "Ren ",
      "Dao ",
      "Ding ",
      "Gai ",
      "Ji ",
      "Ren ",
      "Ren ",
      "Chan ",
      "Tan ",
      "Te ",
      "Te ",
      "Gan ",
      "Qi ",
      "Shi ",
      "Cun ",
      "Zhi ",
      "Wang ",
      "Mang ",
      "Xi ",
      "Fan ",
      "Ying ",
      "Tian ",
      "Min ",
      "Min ",
      "Zhong ",
      "Chong ",
      "Wu ",
      "Ji ",
      "Wu ",
      "Xi ",
      "Ye ",
      "You ",
      "Wan ",
      "Cong ",
      "Zhong ",
      "Kuai ",
      "Yu ",
      "Bian ",
      "Zhi ",
      "Qi ",
      "Cui ",
      "Chen ",
      "Tai ",
      "Tun ",
      "Qian ",
      "Nian ",
      "Hun ",
      "Xiong ",
      "Niu ",
      "Wang ",
      "Xian ",
      "Xin ",
      "Kang ",
      "Hu ",
      "Kai ",
      "Fen "
    ];
  }
});

// node_modules/unidecode/data/x60.js
var require_x60 = __commonJS({
  "node_modules/unidecode/data/x60.js"(exports2, module2) {
    module2.exports = [
      "Huai ",
      "Tai ",
      "Song ",
      "Wu ",
      "Ou ",
      "Chang ",
      "Chuang ",
      "Ju ",
      "Yi ",
      "Bao ",
      "Chao ",
      "Min ",
      "Pei ",
      "Zuo ",
      "Zen ",
      "Yang ",
      "Kou ",
      "Ban ",
      "Nu ",
      "Nao ",
      "Zheng ",
      "Pa ",
      "Bu ",
      "Tie ",
      "Gu ",
      "Hu ",
      "Ju ",
      "Da ",
      "Lian ",
      "Si ",
      "Chou ",
      "Di ",
      "Dai ",
      "Yi ",
      "Tu ",
      "You ",
      "Fu ",
      "Ji ",
      "Peng ",
      "Xing ",
      "Yuan ",
      "Ni ",
      "Guai ",
      "Fu ",
      "Xi ",
      "Bi ",
      "You ",
      "Qie ",
      "Xuan ",
      "Cong ",
      "Bing ",
      "Huang ",
      "Xu ",
      "Chu ",
      "Pi ",
      "Xi ",
      "Xi ",
      "Tan ",
      "Koraeru ",
      "Zong ",
      "Dui ",
      "[?] ",
      "Ki ",
      "Yi ",
      "Chi ",
      "Ren ",
      "Xun ",
      "Shi ",
      "Xi ",
      "Lao ",
      "Heng ",
      "Kuang ",
      "Mu ",
      "Zhi ",
      "Xie ",
      "Lian ",
      "Tiao ",
      "Huang ",
      "Die ",
      "Hao ",
      "Kong ",
      "Gui ",
      "Heng ",
      "Xi ",
      "Xiao ",
      "Shu ",
      "S ",
      "Kua ",
      "Qiu ",
      "Yang ",
      "Hui ",
      "Hui ",
      "Chi ",
      "Jia ",
      "Yi ",
      "Xiong ",
      "Guai ",
      "Lin ",
      "Hui ",
      "Zi ",
      "Xu ",
      "Chi ",
      "Xiang ",
      "Nu ",
      "Hen ",
      "En ",
      "Ke ",
      "Tong ",
      "Tian ",
      "Gong ",
      "Quan ",
      "Xi ",
      "Qia ",
      "Yue ",
      "Peng ",
      "Ken ",
      "De ",
      "Hui ",
      "E ",
      "Kyuu ",
      "Tong ",
      "Yan ",
      "Kai ",
      "Ce ",
      "Nao ",
      "Yun ",
      "Mang ",
      "Yong ",
      "Yong ",
      "Yuan ",
      "Pi ",
      "Kun ",
      "Qiao ",
      "Yue ",
      "Yu ",
      "Yu ",
      "Jie ",
      "Xi ",
      "Zhe ",
      "Lin ",
      "Ti ",
      "Han ",
      "Hao ",
      "Qie ",
      "Ti ",
      "Bu ",
      "Yi ",
      "Qian ",
      "Hui ",
      "Xi ",
      "Bei ",
      "Man ",
      "Yi ",
      "Heng ",
      "Song ",
      "Quan ",
      "Cheng ",
      "Hui ",
      "Wu ",
      "Wu ",
      "You ",
      "Li ",
      "Liang ",
      "Huan ",
      "Cong ",
      "Yi ",
      "Yue ",
      "Li ",
      "Nin ",
      "Nao ",
      "E ",
      "Que ",
      "Xuan ",
      "Qian ",
      "Wu ",
      "Min ",
      "Cong ",
      "Fei ",
      "Bei ",
      "Duo ",
      "Cui ",
      "Chang ",
      "Men ",
      "Li ",
      "Ji ",
      "Guan ",
      "Guan ",
      "Xing ",
      "Dao ",
      "Qi ",
      "Kong ",
      "Tian ",
      "Lun ",
      "Xi ",
      "Kan ",
      "Kun ",
      "Ni ",
      "Qing ",
      "Chou ",
      "Dun ",
      "Guo ",
      "Chan ",
      "Liang ",
      "Wan ",
      "Yuan ",
      "Jin ",
      "Ji ",
      "Lin ",
      "Yu ",
      "Huo ",
      "He ",
      "Quan ",
      "Tan ",
      "Ti ",
      "Ti ",
      "Nie ",
      "Wang ",
      "Chuo ",
      "Bu ",
      "Hun ",
      "Xi ",
      "Tang ",
      "Xin ",
      "Wei ",
      "Hui ",
      "E ",
      "Rui ",
      "Zong ",
      "Jian ",
      "Yong ",
      "Dian ",
      "Ju ",
      "Can ",
      "Cheng ",
      "De ",
      "Bei ",
      "Qie ",
      "Can ",
      "Dan ",
      "Guan ",
      "Duo ",
      "Nao ",
      "Yun ",
      "Xiang ",
      "Zhui ",
      "Die ",
      "Huang ",
      "Chun ",
      "Qiong ",
      "Re ",
      "Xing ",
      "Ce ",
      "Bian ",
      "Hun ",
      "Zong ",
      "Ti "
    ];
  }
});

// node_modules/unidecode/data/x61.js
var require_x61 = __commonJS({
  "node_modules/unidecode/data/x61.js"(exports2, module2) {
    module2.exports = [
      "Qiao ",
      "Chou ",
      "Bei ",
      "Xuan ",
      "Wei ",
      "Ge ",
      "Qian ",
      "Wei ",
      "Yu ",
      "Yu ",
      "Bi ",
      "Xuan ",
      "Huan ",
      "Min ",
      "Bi ",
      "Yi ",
      "Mian ",
      "Yong ",
      "Kai ",
      "Dang ",
      "Yin ",
      "E ",
      "Chen ",
      "Mou ",
      "Ke ",
      "Ke ",
      "Yu ",
      "Ai ",
      "Qie ",
      "Yan ",
      "Nuo ",
      "Gan ",
      "Yun ",
      "Zong ",
      "Sai ",
      "Leng ",
      "Fen ",
      "[?] ",
      "Kui ",
      "Kui ",
      "Que ",
      "Gong ",
      "Yun ",
      "Su ",
      "Su ",
      "Qi ",
      "Yao ",
      "Song ",
      "Huang ",
      "Ji ",
      "Gu ",
      "Ju ",
      "Chuang ",
      "Ni ",
      "Xie ",
      "Kai ",
      "Zheng ",
      "Yong ",
      "Cao ",
      "Sun ",
      "Shen ",
      "Bo ",
      "Kai ",
      "Yuan ",
      "Xie ",
      "Hun ",
      "Yong ",
      "Yang ",
      "Li ",
      "Sao ",
      "Tao ",
      "Yin ",
      "Ci ",
      "Xu ",
      "Qian ",
      "Tai ",
      "Huang ",
      "Yun ",
      "Shen ",
      "Ming ",
      "[?] ",
      "She ",
      "Cong ",
      "Piao ",
      "Mo ",
      "Mu ",
      "Guo ",
      "Chi ",
      "Can ",
      "Can ",
      "Can ",
      "Cui ",
      "Min ",
      "Te ",
      "Zhang ",
      "Tong ",
      "Ao ",
      "Shuang ",
      "Man ",
      "Guan ",
      "Que ",
      "Zao ",
      "Jiu ",
      "Hui ",
      "Kai ",
      "Lian ",
      "Ou ",
      "Song ",
      "Jin ",
      "Yin ",
      "Lu ",
      "Shang ",
      "Wei ",
      "Tuan ",
      "Man ",
      "Qian ",
      "She ",
      "Yong ",
      "Qing ",
      "Kang ",
      "Di ",
      "Zhi ",
      "Lou ",
      "Juan ",
      "Qi ",
      "Qi ",
      "Yu ",
      "Ping ",
      "Liao ",
      "Cong ",
      "You ",
      "Chong ",
      "Zhi ",
      "Tong ",
      "Cheng ",
      "Qi ",
      "Qu ",
      "Peng ",
      "Bei ",
      "Bie ",
      "Chun ",
      "Jiao ",
      "Zeng ",
      "Chi ",
      "Lian ",
      "Ping ",
      "Kui ",
      "Hui ",
      "Qiao ",
      "Cheng ",
      "Yin ",
      "Yin ",
      "Xi ",
      "Xi ",
      "Dan ",
      "Tan ",
      "Duo ",
      "Dui ",
      "Dui ",
      "Su ",
      "Jue ",
      "Ce ",
      "Xiao ",
      "Fan ",
      "Fen ",
      "Lao ",
      "Lao ",
      "Chong ",
      "Han ",
      "Qi ",
      "Xian ",
      "Min ",
      "Jing ",
      "Liao ",
      "Wu ",
      "Can ",
      "Jue ",
      "Cu ",
      "Xian ",
      "Tan ",
      "Sheng ",
      "Pi ",
      "Yi ",
      "Chu ",
      "Xian ",
      "Nao ",
      "Dan ",
      "Tan ",
      "Jing ",
      "Song ",
      "Han ",
      "Jiao ",
      "Wai ",
      "Huan ",
      "Dong ",
      "Qin ",
      "Qin ",
      "Qu ",
      "Cao ",
      "Ken ",
      "Xie ",
      "Ying ",
      "Ao ",
      "Mao ",
      "Yi ",
      "Lin ",
      "Se ",
      "Jun ",
      "Huai ",
      "Men ",
      "Lan ",
      "Ai ",
      "Lin ",
      "Yan ",
      "Gua ",
      "Xia ",
      "Chi ",
      "Yu ",
      "Yin ",
      "Dai ",
      "Meng ",
      "Ai ",
      "Meng ",
      "Dui ",
      "Qi ",
      "Mo ",
      "Lan ",
      "Men ",
      "Chou ",
      "Zhi ",
      "Nuo ",
      "Nuo ",
      "Yan ",
      "Yang ",
      "Bo ",
      "Zhi ",
      "Kuang ",
      "Kuang ",
      "You ",
      "Fu ",
      "Liu ",
      "Mie ",
      "Cheng ",
      "[?] ",
      "Chan ",
      "Meng ",
      "Lan ",
      "Huai ",
      "Xuan ",
      "Rang ",
      "Chan ",
      "Ji ",
      "Ju ",
      "Huan ",
      "She ",
      "Yi "
    ];
  }
});

// node_modules/unidecode/data/x62.js
var require_x62 = __commonJS({
  "node_modules/unidecode/data/x62.js"(exports2, module2) {
    module2.exports = [
      "Lian ",
      "Nan ",
      "Mi ",
      "Tang ",
      "Jue ",
      "Gang ",
      "Gang ",
      "Gang ",
      "Ge ",
      "Yue ",
      "Wu ",
      "Jian ",
      "Xu ",
      "Shu ",
      "Rong ",
      "Xi ",
      "Cheng ",
      "Wo ",
      "Jie ",
      "Ge ",
      "Jian ",
      "Qiang ",
      "Huo ",
      "Qiang ",
      "Zhan ",
      "Dong ",
      "Qi ",
      "Jia ",
      "Die ",
      "Zei ",
      "Jia ",
      "Ji ",
      "Shi ",
      "Kan ",
      "Ji ",
      "Kui ",
      "Gai ",
      "Deng ",
      "Zhan ",
      "Chuang ",
      "Ge ",
      "Jian ",
      "Jie ",
      "Yu ",
      "Jian ",
      "Yan ",
      "Lu ",
      "Xi ",
      "Zhan ",
      "Xi ",
      "Xi ",
      "Chuo ",
      "Dai ",
      "Qu ",
      "Hu ",
      "Hu ",
      "Hu ",
      "E ",
      "Shi ",
      "Li ",
      "Mao ",
      "Hu ",
      "Li ",
      "Fang ",
      "Suo ",
      "Bian ",
      "Dian ",
      "Jiong ",
      "Shang ",
      "Yi ",
      "Yi ",
      "Shan ",
      "Hu ",
      "Fei ",
      "Yan ",
      "Shou ",
      "T ",
      "Cai ",
      "Zha ",
      "Qiu ",
      "Le ",
      "Bu ",
      "Ba ",
      "Da ",
      "Reng ",
      "Fu ",
      "Hameru ",
      "Zai ",
      "Tuo ",
      "Zhang ",
      "Diao ",
      "Kang ",
      "Yu ",
      "Ku ",
      "Han ",
      "Shen ",
      "Cha ",
      "Yi ",
      "Gu ",
      "Kou ",
      "Wu ",
      "Tuo ",
      "Qian ",
      "Zhi ",
      "Ren ",
      "Kuo ",
      "Men ",
      "Sao ",
      "Yang ",
      "Niu ",
      "Ban ",
      "Che ",
      "Rao ",
      "Xi ",
      "Qian ",
      "Ban ",
      "Jia ",
      "Yu ",
      "Fu ",
      "Ao ",
      "Xi ",
      "Pi ",
      "Zhi ",
      "Zi ",
      "E ",
      "Dun ",
      "Zhao ",
      "Cheng ",
      "Ji ",
      "Yan ",
      "Kuang ",
      "Bian ",
      "Chao ",
      "Ju ",
      "Wen ",
      "Hu ",
      "Yue ",
      "Jue ",
      "Ba ",
      "Qin ",
      "Zhen ",
      "Zheng ",
      "Yun ",
      "Wan ",
      "Nu ",
      "Yi ",
      "Shu ",
      "Zhua ",
      "Pou ",
      "Tou ",
      "Dou ",
      "Kang ",
      "Zhe ",
      "Pou ",
      "Fu ",
      "Pao ",
      "Ba ",
      "Ao ",
      "Ze ",
      "Tuan ",
      "Kou ",
      "Lun ",
      "Qiang ",
      "[?] ",
      "Hu ",
      "Bao ",
      "Bing ",
      "Zhi ",
      "Peng ",
      "Tan ",
      "Pu ",
      "Pi ",
      "Tai ",
      "Yao ",
      "Zhen ",
      "Zha ",
      "Yang ",
      "Bao ",
      "He ",
      "Ni ",
      "Yi ",
      "Di ",
      "Chi ",
      "Pi ",
      "Za ",
      "Mo ",
      "Mo ",
      "Shen ",
      "Ya ",
      "Chou ",
      "Qu ",
      "Min ",
      "Chu ",
      "Jia ",
      "Fu ",
      "Zhan ",
      "Zhu ",
      "Dan ",
      "Chai ",
      "Mu ",
      "Nian ",
      "La ",
      "Fu ",
      "Pao ",
      "Ban ",
      "Pai ",
      "Ling ",
      "Na ",
      "Guai ",
      "Qian ",
      "Ju ",
      "Tuo ",
      "Ba ",
      "Tuo ",
      "Tuo ",
      "Ao ",
      "Ju ",
      "Zhuo ",
      "Pan ",
      "Zhao ",
      "Bai ",
      "Bai ",
      "Di ",
      "Ni ",
      "Ju ",
      "Kuo ",
      "Long ",
      "Jian ",
      "[?] ",
      "Yong ",
      "Lan ",
      "Ning ",
      "Bo ",
      "Ze ",
      "Qian ",
      "Hen ",
      "Gua ",
      "Shi ",
      "Jie ",
      "Zheng ",
      "Nin ",
      "Gong ",
      "Gong ",
      "Quan ",
      "Shuan ",
      "Cun ",
      "Zan ",
      "Kao ",
      "Chi ",
      "Xie ",
      "Ce ",
      "Hui ",
      "Pin ",
      "Zhuai ",
      "Shi ",
      "Na "
    ];
  }
});

// node_modules/unidecode/data/x63.js
var require_x63 = __commonJS({
  "node_modules/unidecode/data/x63.js"(exports2, module2) {
    module2.exports = [
      "Bo ",
      "Chi ",
      "Gua ",
      "Zhi ",
      "Kuo ",
      "Duo ",
      "Duo ",
      "Zhi ",
      "Qie ",
      "An ",
      "Nong ",
      "Zhen ",
      "Ge ",
      "Jiao ",
      "Ku ",
      "Dong ",
      "Ru ",
      "Tiao ",
      "Lie ",
      "Zha ",
      "Lu ",
      "Die ",
      "Wa ",
      "Jue ",
      "Mushiru ",
      "Ju ",
      "Zhi ",
      "Luan ",
      "Ya ",
      "Zhua ",
      "Ta ",
      "Xie ",
      "Nao ",
      "Dang ",
      "Jiao ",
      "Zheng ",
      "Ji ",
      "Hui ",
      "Xun ",
      "Ku ",
      "Ai ",
      "Tuo ",
      "Nuo ",
      "Cuo ",
      "Bo ",
      "Geng ",
      "Ti ",
      "Zhen ",
      "Cheng ",
      "Suo ",
      "Suo ",
      "Keng ",
      "Mei ",
      "Long ",
      "Ju ",
      "Peng ",
      "Jian ",
      "Yi ",
      "Ting ",
      "Shan ",
      "Nuo ",
      "Wan ",
      "Xie ",
      "Cha ",
      "Feng ",
      "Jiao ",
      "Wu ",
      "Jun ",
      "Jiu ",
      "Tong ",
      "Kun ",
      "Huo ",
      "Tu ",
      "Zhuo ",
      "Pou ",
      "Le ",
      "Ba ",
      "Han ",
      "Shao ",
      "Nie ",
      "Juan ",
      "Ze ",
      "Song ",
      "Ye ",
      "Jue ",
      "Bu ",
      "Huan ",
      "Bu ",
      "Zun ",
      "Yi ",
      "Zhai ",
      "Lu ",
      "Sou ",
      "Tuo ",
      "Lao ",
      "Sun ",
      "Bang ",
      "Jian ",
      "Huan ",
      "Dao ",
      "[?] ",
      "Wan ",
      "Qin ",
      "Peng ",
      "She ",
      "Lie ",
      "Min ",
      "Men ",
      "Fu ",
      "Bai ",
      "Ju ",
      "Dao ",
      "Wo ",
      "Ai ",
      "Juan ",
      "Yue ",
      "Zong ",
      "Chen ",
      "Chui ",
      "Jie ",
      "Tu ",
      "Ben ",
      "Na ",
      "Nian ",
      "Nuo ",
      "Zu ",
      "Wo ",
      "Xi ",
      "Xian ",
      "Cheng ",
      "Dian ",
      "Sao ",
      "Lun ",
      "Qing ",
      "Gang ",
      "Duo ",
      "Shou ",
      "Diao ",
      "Pou ",
      "Di ",
      "Zhang ",
      "Gun ",
      "Ji ",
      "Tao ",
      "Qia ",
      "Qi ",
      "Pai ",
      "Shu ",
      "Qian ",
      "Ling ",
      "Yi ",
      "Ya ",
      "Jue ",
      "Zheng ",
      "Liang ",
      "Gua ",
      "Yi ",
      "Huo ",
      "Shan ",
      "Zheng ",
      "Lue ",
      "Cai ",
      "Tan ",
      "Che ",
      "Bing ",
      "Jie ",
      "Ti ",
      "Kong ",
      "Tui ",
      "Yan ",
      "Cuo ",
      "Zou ",
      "Ju ",
      "Tian ",
      "Qian ",
      "Ken ",
      "Bai ",
      "Shou ",
      "Jie ",
      "Lu ",
      "Guo ",
      "Haba ",
      "[?] ",
      "Zhi ",
      "Dan ",
      "Mang ",
      "Xian ",
      "Sao ",
      "Guan ",
      "Peng ",
      "Yuan ",
      "Nuo ",
      "Jian ",
      "Zhen ",
      "Jiu ",
      "Jian ",
      "Yu ",
      "Yan ",
      "Kui ",
      "Nan ",
      "Hong ",
      "Rou ",
      "Pi ",
      "Wei ",
      "Sai ",
      "Zou ",
      "Xuan ",
      "Miao ",
      "Ti ",
      "Nie ",
      "Cha ",
      "Shi ",
      "Zong ",
      "Zhen ",
      "Yi ",
      "Shun ",
      "Heng ",
      "Bian ",
      "Yang ",
      "Huan ",
      "Yan ",
      "Zuan ",
      "An ",
      "Xu ",
      "Ya ",
      "Wo ",
      "Ke ",
      "Chuai ",
      "Ji ",
      "Ti ",
      "La ",
      "La ",
      "Cheng ",
      "Kai ",
      "Jiu ",
      "Jiu ",
      "Tu ",
      "Jie ",
      "Hui ",
      "Geng ",
      "Chong ",
      "Shuo ",
      "She ",
      "Xie ",
      "Yuan ",
      "Qian ",
      "Ye ",
      "Cha ",
      "Zha ",
      "Bei ",
      "Yao ",
      "[?] ",
      "[?] ",
      "Lan ",
      "Wen ",
      "Qin "
    ];
  }
});

// node_modules/unidecode/data/x64.js
var require_x64 = __commonJS({
  "node_modules/unidecode/data/x64.js"(exports2, module2) {
    module2.exports = [
      "Chan ",
      "Ge ",
      "Lou ",
      "Zong ",
      "Geng ",
      "Jiao ",
      "Gou ",
      "Qin ",
      "Yong ",
      "Que ",
      "Chou ",
      "Chi ",
      "Zhan ",
      "Sun ",
      "Sun ",
      "Bo ",
      "Chu ",
      "Rong ",
      "Beng ",
      "Cuo ",
      "Sao ",
      "Ke ",
      "Yao ",
      "Dao ",
      "Zhi ",
      "Nu ",
      "Xie ",
      "Jian ",
      "Sou ",
      "Qiu ",
      "Gao ",
      "Xian ",
      "Shuo ",
      "Sang ",
      "Jin ",
      "Mie ",
      "E ",
      "Chui ",
      "Nuo ",
      "Shan ",
      "Ta ",
      "Jie ",
      "Tang ",
      "Pan ",
      "Ban ",
      "Da ",
      "Li ",
      "Tao ",
      "Hu ",
      "Zhi ",
      "Wa ",
      "Xia ",
      "Qian ",
      "Wen ",
      "Qiang ",
      "Tian ",
      "Zhen ",
      "E ",
      "Xi ",
      "Nuo ",
      "Quan ",
      "Cha ",
      "Zha ",
      "Ge ",
      "Wu ",
      "En ",
      "She ",
      "Kang ",
      "She ",
      "Shu ",
      "Bai ",
      "Yao ",
      "Bin ",
      "Sou ",
      "Tan ",
      "Sa ",
      "Chan ",
      "Suo ",
      "Liao ",
      "Chong ",
      "Chuang ",
      "Guo ",
      "Bing ",
      "Feng ",
      "Shuai ",
      "Di ",
      "Qi ",
      "Sou ",
      "Zhai ",
      "Lian ",
      "Tang ",
      "Chi ",
      "Guan ",
      "Lu ",
      "Luo ",
      "Lou ",
      "Zong ",
      "Gai ",
      "Hu ",
      "Zha ",
      "Chuang ",
      "Tang ",
      "Hua ",
      "Cui ",
      "Nai ",
      "Mo ",
      "Jiang ",
      "Gui ",
      "Ying ",
      "Zhi ",
      "Ao ",
      "Zhi ",
      "Nie ",
      "Man ",
      "Shan ",
      "Kou ",
      "Shu ",
      "Suo ",
      "Tuan ",
      "Jiao ",
      "Mo ",
      "Mo ",
      "Zhe ",
      "Xian ",
      "Keng ",
      "Piao ",
      "Jiang ",
      "Yin ",
      "Gou ",
      "Qian ",
      "Lue ",
      "Ji ",
      "Ying ",
      "Jue ",
      "Pie ",
      "Pie ",
      "Lao ",
      "Dun ",
      "Xian ",
      "Ruan ",
      "Kui ",
      "Zan ",
      "Yi ",
      "Xun ",
      "Cheng ",
      "Cheng ",
      "Sa ",
      "Nao ",
      "Heng ",
      "Si ",
      "Qian ",
      "Huang ",
      "Da ",
      "Zun ",
      "Nian ",
      "Lin ",
      "Zheng ",
      "Hui ",
      "Zhuang ",
      "Jiao ",
      "Ji ",
      "Cao ",
      "Dan ",
      "Dan ",
      "Che ",
      "Bo ",
      "Che ",
      "Jue ",
      "Xiao ",
      "Liao ",
      "Ben ",
      "Fu ",
      "Qiao ",
      "Bo ",
      "Cuo ",
      "Zhuo ",
      "Zhuan ",
      "Tuo ",
      "Pu ",
      "Qin ",
      "Dun ",
      "Nian ",
      "[?] ",
      "Xie ",
      "Lu ",
      "Jiao ",
      "Cuan ",
      "Ta ",
      "Han ",
      "Qiao ",
      "Zhua ",
      "Jian ",
      "Gan ",
      "Yong ",
      "Lei ",
      "Kuo ",
      "Lu ",
      "Shan ",
      "Zhuo ",
      "Ze ",
      "Pu ",
      "Chuo ",
      "Ji ",
      "Dang ",
      "Suo ",
      "Cao ",
      "Qing ",
      "Jing ",
      "Huan ",
      "Jie ",
      "Qin ",
      "Kuai ",
      "Dan ",
      "Xi ",
      "Ge ",
      "Pi ",
      "Bo ",
      "Ao ",
      "Ju ",
      "Ye ",
      "[?] ",
      "Mang ",
      "Sou ",
      "Mi ",
      "Ji ",
      "Tai ",
      "Zhuo ",
      "Dao ",
      "Xing ",
      "Lan ",
      "Ca ",
      "Ju ",
      "Ye ",
      "Ru ",
      "Ye ",
      "Ye ",
      "Ni ",
      "Hu ",
      "Ji ",
      "Bin ",
      "Ning ",
      "Ge ",
      "Zhi ",
      "Jie ",
      "Kuo ",
      "Mo ",
      "Jian ",
      "Xie ",
      "Lie ",
      "Tan ",
      "Bai ",
      "Sou ",
      "Lu ",
      "Lue ",
      "Rao ",
      "Zhi "
    ];
  }
});

// node_modules/unidecode/data/x65.js
var require_x65 = __commonJS({
  "node_modules/unidecode/data/x65.js"(exports2, module2) {
    module2.exports = [
      "Pan ",
      "Yang ",
      "Lei ",
      "Sa ",
      "Shu ",
      "Zan ",
      "Nian ",
      "Xian ",
      "Jun ",
      "Huo ",
      "Li ",
      "La ",
      "Han ",
      "Ying ",
      "Lu ",
      "Long ",
      "Qian ",
      "Qian ",
      "Zan ",
      "Qian ",
      "Lan ",
      "San ",
      "Ying ",
      "Mei ",
      "Rang ",
      "Chan ",
      "[?] ",
      "Cuan ",
      "Xi ",
      "She ",
      "Luo ",
      "Jun ",
      "Mi ",
      "Li ",
      "Zan ",
      "Luan ",
      "Tan ",
      "Zuan ",
      "Li ",
      "Dian ",
      "Wa ",
      "Dang ",
      "Jiao ",
      "Jue ",
      "Lan ",
      "Li ",
      "Nang ",
      "Zhi ",
      "Gui ",
      "Gui ",
      "Qi ",
      "Xin ",
      "Pu ",
      "Sui ",
      "Shou ",
      "Kao ",
      "You ",
      "Gai ",
      "Yi ",
      "Gong ",
      "Gan ",
      "Ban ",
      "Fang ",
      "Zheng ",
      "Bo ",
      "Dian ",
      "Kou ",
      "Min ",
      "Wu ",
      "Gu ",
      "He ",
      "Ce ",
      "Xiao ",
      "Mi ",
      "Chu ",
      "Ge ",
      "Di ",
      "Xu ",
      "Jiao ",
      "Min ",
      "Chen ",
      "Jiu ",
      "Zhen ",
      "Duo ",
      "Yu ",
      "Chi ",
      "Ao ",
      "Bai ",
      "Xu ",
      "Jiao ",
      "Duo ",
      "Lian ",
      "Nie ",
      "Bi ",
      "Chang ",
      "Dian ",
      "Duo ",
      "Yi ",
      "Gan ",
      "San ",
      "Ke ",
      "Yan ",
      "Dun ",
      "Qi ",
      "Dou ",
      "Xiao ",
      "Duo ",
      "Jiao ",
      "Jing ",
      "Yang ",
      "Xia ",
      "Min ",
      "Shu ",
      "Ai ",
      "Qiao ",
      "Ai ",
      "Zheng ",
      "Di ",
      "Zhen ",
      "Fu ",
      "Shu ",
      "Liao ",
      "Qu ",
      "Xiong ",
      "Xi ",
      "Jiao ",
      "Sen ",
      "Jiao ",
      "Zhuo ",
      "Yi ",
      "Lian ",
      "Bi ",
      "Li ",
      "Xiao ",
      "Xiao ",
      "Wen ",
      "Xue ",
      "Qi ",
      "Qi ",
      "Zhai ",
      "Bin ",
      "Jue ",
      "Zhai ",
      "[?] ",
      "Fei ",
      "Ban ",
      "Ban ",
      "Lan ",
      "Yu ",
      "Lan ",
      "Wei ",
      "Dou ",
      "Sheng ",
      "Liao ",
      "Jia ",
      "Hu ",
      "Xie ",
      "Jia ",
      "Yu ",
      "Zhen ",
      "Jiao ",
      "Wo ",
      "Tou ",
      "Chu ",
      "Jin ",
      "Chi ",
      "Yin ",
      "Fu ",
      "Qiang ",
      "Zhan ",
      "Qu ",
      "Zhuo ",
      "Zhan ",
      "Duan ",
      "Zhuo ",
      "Si ",
      "Xin ",
      "Zhuo ",
      "Zhuo ",
      "Qin ",
      "Lin ",
      "Zhuo ",
      "Chu ",
      "Duan ",
      "Zhu ",
      "Fang ",
      "Xie ",
      "Hang ",
      "Yu ",
      "Shi ",
      "Pei ",
      "You ",
      "Mye ",
      "Pang ",
      "Qi ",
      "Zhan ",
      "Mao ",
      "Lu ",
      "Pei ",
      "Pi ",
      "Liu ",
      "Fu ",
      "Fang ",
      "Xuan ",
      "Jing ",
      "Jing ",
      "Ni ",
      "Zu ",
      "Zhao ",
      "Yi ",
      "Liu ",
      "Shao ",
      "Jian ",
      "Es ",
      "Yi ",
      "Qi ",
      "Zhi ",
      "Fan ",
      "Piao ",
      "Fan ",
      "Zhan ",
      "Guai ",
      "Sui ",
      "Yu ",
      "Wu ",
      "Ji ",
      "Ji ",
      "Ji ",
      "Huo ",
      "Ri ",
      "Dan ",
      "Jiu ",
      "Zhi ",
      "Zao ",
      "Xie ",
      "Tiao ",
      "Xun ",
      "Xu ",
      "Xu ",
      "Xu ",
      "Gan ",
      "Han ",
      "Tai ",
      "Di ",
      "Xu ",
      "Chan ",
      "Shi ",
      "Kuang ",
      "Yang ",
      "Shi ",
      "Wang ",
      "Min ",
      "Min ",
      "Tun ",
      "Chun ",
      "Wu "
    ];
  }
});

// node_modules/unidecode/data/x66.js
var require_x66 = __commonJS({
  "node_modules/unidecode/data/x66.js"(exports2, module2) {
    module2.exports = [
      "Yun ",
      "Bei ",
      "Ang ",
      "Ze ",
      "Ban ",
      "Jie ",
      "Kun ",
      "Sheng ",
      "Hu ",
      "Fang ",
      "Hao ",
      "Gui ",
      "Chang ",
      "Xuan ",
      "Ming ",
      "Hun ",
      "Fen ",
      "Qin ",
      "Hu ",
      "Yi ",
      "Xi ",
      "Xin ",
      "Yan ",
      "Ze ",
      "Fang ",
      "Tan ",
      "Shen ",
      "Ju ",
      "Yang ",
      "Zan ",
      "Bing ",
      "Xing ",
      "Ying ",
      "Xuan ",
      "Pei ",
      "Zhen ",
      "Ling ",
      "Chun ",
      "Hao ",
      "Mei ",
      "Zuo ",
      "Mo ",
      "Bian ",
      "Xu ",
      "Hun ",
      "Zhao ",
      "Zong ",
      "Shi ",
      "Shi ",
      "Yu ",
      "Fei ",
      "Die ",
      "Mao ",
      "Ni ",
      "Chang ",
      "Wen ",
      "Dong ",
      "Ai ",
      "Bing ",
      "Ang ",
      "Zhou ",
      "Long ",
      "Xian ",
      "Kuang ",
      "Tiao ",
      "Chao ",
      "Shi ",
      "Huang ",
      "Huang ",
      "Xuan ",
      "Kui ",
      "Xu ",
      "Jiao ",
      "Jin ",
      "Zhi ",
      "Jin ",
      "Shang ",
      "Tong ",
      "Hong ",
      "Yan ",
      "Gai ",
      "Xiang ",
      "Shai ",
      "Xiao ",
      "Ye ",
      "Yun ",
      "Hui ",
      "Han ",
      "Han ",
      "Jun ",
      "Wan ",
      "Xian ",
      "Kun ",
      "Zhou ",
      "Xi ",
      "Cheng ",
      "Sheng ",
      "Bu ",
      "Zhe ",
      "Zhe ",
      "Wu ",
      "Han ",
      "Hui ",
      "Hao ",
      "Chen ",
      "Wan ",
      "Tian ",
      "Zhuo ",
      "Zui ",
      "Zhou ",
      "Pu ",
      "Jing ",
      "Xi ",
      "Shan ",
      "Yi ",
      "Xi ",
      "Qing ",
      "Qi ",
      "Jing ",
      "Gui ",
      "Zhen ",
      "Yi ",
      "Zhi ",
      "An ",
      "Wan ",
      "Lin ",
      "Liang ",
      "Chang ",
      "Wang ",
      "Xiao ",
      "Zan ",
      "Hi ",
      "Xuan ",
      "Xuan ",
      "Yi ",
      "Xia ",
      "Yun ",
      "Hui ",
      "Fu ",
      "Min ",
      "Kui ",
      "He ",
      "Ying ",
      "Du ",
      "Wei ",
      "Shu ",
      "Qing ",
      "Mao ",
      "Nan ",
      "Jian ",
      "Nuan ",
      "An ",
      "Yang ",
      "Chun ",
      "Yao ",
      "Suo ",
      "Jin ",
      "Ming ",
      "Jiao ",
      "Kai ",
      "Gao ",
      "Weng ",
      "Chang ",
      "Qi ",
      "Hao ",
      "Yan ",
      "Li ",
      "Ai ",
      "Ji ",
      "Gui ",
      "Men ",
      "Zan ",
      "Xie ",
      "Hao ",
      "Mu ",
      "Mo ",
      "Cong ",
      "Ni ",
      "Zhang ",
      "Hui ",
      "Bao ",
      "Han ",
      "Xuan ",
      "Chuan ",
      "Liao ",
      "Xian ",
      "Dan ",
      "Jing ",
      "Pie ",
      "Lin ",
      "Tun ",
      "Xi ",
      "Yi ",
      "Ji ",
      "Huang ",
      "Tai ",
      "Ye ",
      "Ye ",
      "Li ",
      "Tan ",
      "Tong ",
      "Xiao ",
      "Fei ",
      "Qin ",
      "Zhao ",
      "Hao ",
      "Yi ",
      "Xiang ",
      "Xing ",
      "Sen ",
      "Jiao ",
      "Bao ",
      "Jing ",
      "Yian ",
      "Ai ",
      "Ye ",
      "Ru ",
      "Shu ",
      "Meng ",
      "Xun ",
      "Yao ",
      "Pu ",
      "Li ",
      "Chen ",
      "Kuang ",
      "Die ",
      "[?] ",
      "Yan ",
      "Huo ",
      "Lu ",
      "Xi ",
      "Rong ",
      "Long ",
      "Nang ",
      "Luo ",
      "Luan ",
      "Shai ",
      "Tang ",
      "Yan ",
      "Chu ",
      "Yue ",
      "Yue ",
      "Qu ",
      "Yi ",
      "Geng ",
      "Ye ",
      "Hu ",
      "He ",
      "Shu ",
      "Cao ",
      "Cao ",
      "Noboru ",
      "Man ",
      "Ceng ",
      "Ceng ",
      "Ti "
    ];
  }
});

// node_modules/unidecode/data/x67.js
var require_x67 = __commonJS({
  "node_modules/unidecode/data/x67.js"(exports2, module2) {
    module2.exports = [
      "Zui ",
      "Can ",
      "Xu ",
      "Hui ",
      "Yin ",
      "Qie ",
      "Fen ",
      "Pi ",
      "Yue ",
      "You ",
      "Ruan ",
      "Peng ",
      "Ban ",
      "Fu ",
      "Ling ",
      "Fei ",
      "Qu ",
      "[?] ",
      "Nu ",
      "Tiao ",
      "Shuo ",
      "Zhen ",
      "Lang ",
      "Lang ",
      "Juan ",
      "Ming ",
      "Huang ",
      "Wang ",
      "Tun ",
      "Zhao ",
      "Ji ",
      "Qi ",
      "Ying ",
      "Zong ",
      "Wang ",
      "Tong ",
      "Lang ",
      "[?] ",
      "Meng ",
      "Long ",
      "Mu ",
      "Deng ",
      "Wei ",
      "Mo ",
      "Ben ",
      "Zha ",
      "Zhu ",
      "Zhu ",
      "[?] ",
      "Zhu ",
      "Ren ",
      "Ba ",
      "Po ",
      "Duo ",
      "Duo ",
      "Dao ",
      "Li ",
      "Qiu ",
      "Ji ",
      "Jiu ",
      "Bi ",
      "Xiu ",
      "Ting ",
      "Ci ",
      "Sha ",
      "Eburi ",
      "Za ",
      "Quan ",
      "Qian ",
      "Yu ",
      "Gan ",
      "Wu ",
      "Cha ",
      "Shan ",
      "Xun ",
      "Fan ",
      "Wu ",
      "Zi ",
      "Li ",
      "Xing ",
      "Cai ",
      "Cun ",
      "Ren ",
      "Shao ",
      "Tuo ",
      "Di ",
      "Zhang ",
      "Mang ",
      "Chi ",
      "Yi ",
      "Gu ",
      "Gong ",
      "Du ",
      "Yi ",
      "Qi ",
      "Shu ",
      "Gang ",
      "Tiao ",
      "Moku ",
      "Soma ",
      "Tochi ",
      "Lai ",
      "Sugi ",
      "Mang ",
      "Yang ",
      "Ma ",
      "Miao ",
      "Si ",
      "Yuan ",
      "Hang ",
      "Fei ",
      "Bei ",
      "Jie ",
      "Dong ",
      "Gao ",
      "Yao ",
      "Xian ",
      "Chu ",
      "Qun ",
      "Pa ",
      "Shu ",
      "Hua ",
      "Xin ",
      "Chou ",
      "Zhu ",
      "Chou ",
      "Song ",
      "Ban ",
      "Song ",
      "Ji ",
      "Yue ",
      "Jin ",
      "Gou ",
      "Ji ",
      "Mao ",
      "Pi ",
      "Bi ",
      "Wang ",
      "Ang ",
      "Fang ",
      "Fen ",
      "Yi ",
      "Fu ",
      "Nan ",
      "Xi ",
      "Hu ",
      "Ya ",
      "Dou ",
      "Xun ",
      "Zhen ",
      "Yao ",
      "Lin ",
      "Rui ",
      "E ",
      "Mei ",
      "Zhao ",
      "Guo ",
      "Zhi ",
      "Cong ",
      "Yun ",
      "Waku ",
      "Dou ",
      "Shu ",
      "Zao ",
      "[?] ",
      "Li ",
      "Haze ",
      "Jian ",
      "Cheng ",
      "Matsu ",
      "Qiang ",
      "Feng ",
      "Nan ",
      "Xiao ",
      "Xian ",
      "Ku ",
      "Ping ",
      "Yi ",
      "Xi ",
      "Zhi ",
      "Guai ",
      "Xiao ",
      "Jia ",
      "Jia ",
      "Gou ",
      "Fu ",
      "Mo ",
      "Yi ",
      "Ye ",
      "Ye ",
      "Shi ",
      "Nie ",
      "Bi ",
      "Duo ",
      "Yi ",
      "Ling ",
      "Bing ",
      "Ni ",
      "La ",
      "He ",
      "Pan ",
      "Fan ",
      "Zhong ",
      "Dai ",
      "Ci ",
      "Yang ",
      "Fu ",
      "Bo ",
      "Mou ",
      "Gan ",
      "Qi ",
      "Ran ",
      "Rou ",
      "Mao ",
      "Zhao ",
      "Song ",
      "Zhe ",
      "Xia ",
      "You ",
      "Shen ",
      "Ju ",
      "Tuo ",
      "Zuo ",
      "Nan ",
      "Ning ",
      "Yong ",
      "Di ",
      "Zhi ",
      "Zha ",
      "Cha ",
      "Dan ",
      "Gu ",
      "Pu ",
      "Jiu ",
      "Ao ",
      "Fu ",
      "Jian ",
      "Bo ",
      "Duo ",
      "Ke ",
      "Nai ",
      "Zhu ",
      "Bi ",
      "Liu ",
      "Chai ",
      "Zha ",
      "Si ",
      "Zhu ",
      "Pei ",
      "Shi ",
      "Guai ",
      "Cha ",
      "Yao ",
      "Jue ",
      "Jiu ",
      "Shi "
    ];
  }
});

// node_modules/unidecode/data/x68.js
var require_x68 = __commonJS({
  "node_modules/unidecode/data/x68.js"(exports2, module2) {
    module2.exports = [
      "Zhi ",
      "Liu ",
      "Mei ",
      "Hoy ",
      "Rong ",
      "Zha ",
      "[?] ",
      "Biao ",
      "Zhan ",
      "Jie ",
      "Long ",
      "Dong ",
      "Lu ",
      "Sayng ",
      "Li ",
      "Lan ",
      "Yong ",
      "Shu ",
      "Xun ",
      "Shuan ",
      "Qi ",
      "Zhen ",
      "Qi ",
      "Li ",
      "Yi ",
      "Xiang ",
      "Zhen ",
      "Li ",
      "Su ",
      "Gua ",
      "Kan ",
      "Bing ",
      "Ren ",
      "Xiao ",
      "Bo ",
      "Ren ",
      "Bing ",
      "Zi ",
      "Chou ",
      "Yi ",
      "Jie ",
      "Xu ",
      "Zhu ",
      "Jian ",
      "Zui ",
      "Er ",
      "Er ",
      "You ",
      "Fa ",
      "Gong ",
      "Kao ",
      "Lao ",
      "Zhan ",
      "Li ",
      "Yin ",
      "Yang ",
      "He ",
      "Gen ",
      "Zhi ",
      "Chi ",
      "Ge ",
      "Zai ",
      "Luan ",
      "Fu ",
      "Jie ",
      "Hang ",
      "Gui ",
      "Tao ",
      "Guang ",
      "Wei ",
      "Kuang ",
      "Ru ",
      "An ",
      "An ",
      "Juan ",
      "Yi ",
      "Zhuo ",
      "Ku ",
      "Zhi ",
      "Qiong ",
      "Tong ",
      "Sang ",
      "Sang ",
      "Huan ",
      "Jie ",
      "Jiu ",
      "Xue ",
      "Duo ",
      "Zhui ",
      "Yu ",
      "Zan ",
      "Kasei ",
      "Ying ",
      "Masu ",
      "[?] ",
      "Zhan ",
      "Ya ",
      "Nao ",
      "Zhen ",
      "Dang ",
      "Qi ",
      "Qiao ",
      "Hua ",
      "Kuai ",
      "Jiang ",
      "Zhuang ",
      "Xun ",
      "Suo ",
      "Sha ",
      "Zhen ",
      "Bei ",
      "Ting ",
      "Gua ",
      "Jing ",
      "Bo ",
      "Ben ",
      "Fu ",
      "Rui ",
      "Tong ",
      "Jue ",
      "Xi ",
      "Lang ",
      "Liu ",
      "Feng ",
      "Qi ",
      "Wen ",
      "Jun ",
      "Gan ",
      "Cu ",
      "Liang ",
      "Qiu ",
      "Ting ",
      "You ",
      "Mei ",
      "Bang ",
      "Long ",
      "Peng ",
      "Zhuang ",
      "Di ",
      "Xuan ",
      "Tu ",
      "Zao ",
      "Ao ",
      "Gu ",
      "Bi ",
      "Di ",
      "Han ",
      "Zi ",
      "Zhi ",
      "Ren ",
      "Bei ",
      "Geng ",
      "Jian ",
      "Huan ",
      "Wan ",
      "Nuo ",
      "Jia ",
      "Tiao ",
      "Ji ",
      "Xiao ",
      "Lu ",
      "Huan ",
      "Shao ",
      "Cen ",
      "Fen ",
      "Song ",
      "Meng ",
      "Wu ",
      "Li ",
      "Li ",
      "Dou ",
      "Cen ",
      "Ying ",
      "Suo ",
      "Ju ",
      "Ti ",
      "Jie ",
      "Kun ",
      "Zhuo ",
      "Shu ",
      "Chan ",
      "Fan ",
      "Wei ",
      "Jing ",
      "Li ",
      "Bing ",
      "Fumoto ",
      "Shikimi ",
      "Tao ",
      "Zhi ",
      "Lai ",
      "Lian ",
      "Jian ",
      "Zhuo ",
      "Ling ",
      "Li ",
      "Qi ",
      "Bing ",
      "Zhun ",
      "Cong ",
      "Qian ",
      "Mian ",
      "Qi ",
      "Qi ",
      "Cai ",
      "Gun ",
      "Chan ",
      "Te ",
      "Fei ",
      "Pai ",
      "Bang ",
      "Pou ",
      "Hun ",
      "Zong ",
      "Cheng ",
      "Zao ",
      "Ji ",
      "Li ",
      "Peng ",
      "Yu ",
      "Yu ",
      "Gu ",
      "Hun ",
      "Dong ",
      "Tang ",
      "Gang ",
      "Wang ",
      "Di ",
      "Xi ",
      "Fan ",
      "Cheng ",
      "Zhan ",
      "Qi ",
      "Yuan ",
      "Yan ",
      "Yu ",
      "Quan ",
      "Yi ",
      "Sen ",
      "Ren ",
      "Chui ",
      "Leng ",
      "Qi ",
      "Zhuo ",
      "Fu ",
      "Ke ",
      "Lai ",
      "Zou ",
      "Zou ",
      "Zhuo ",
      "Guan ",
      "Fen ",
      "Fen ",
      "Chen ",
      "Qiong ",
      "Nie "
    ];
  }
});

// node_modules/unidecode/data/x69.js
var require_x69 = __commonJS({
  "node_modules/unidecode/data/x69.js"(exports2, module2) {
    module2.exports = [
      "Wan ",
      "Guo ",
      "Lu ",
      "Hao ",
      "Jie ",
      "Yi ",
      "Chou ",
      "Ju ",
      "Ju ",
      "Cheng ",
      "Zuo ",
      "Liang ",
      "Qiang ",
      "Zhi ",
      "Zhui ",
      "Ya ",
      "Ju ",
      "Bei ",
      "Jiao ",
      "Zhuo ",
      "Zi ",
      "Bin ",
      "Peng ",
      "Ding ",
      "Chu ",
      "Chang ",
      "Kunugi ",
      "Momiji ",
      "Jian ",
      "Gui ",
      "Xi ",
      "Du ",
      "Qian ",
      "Kunugi ",
      "Soko ",
      "Shide ",
      "Luo ",
      "Zhi ",
      "Ken ",
      "Myeng ",
      "Tafu ",
      "[?] ",
      "Peng ",
      "Zhan ",
      "[?] ",
      "Tuo ",
      "Sen ",
      "Duo ",
      "Ye ",
      "Fou ",
      "Wei ",
      "Wei ",
      "Duan ",
      "Jia ",
      "Zong ",
      "Jian ",
      "Yi ",
      "Shen ",
      "Xi ",
      "Yan ",
      "Yan ",
      "Chuan ",
      "Zhan ",
      "Chun ",
      "Yu ",
      "He ",
      "Zha ",
      "Wo ",
      "Pian ",
      "Bi ",
      "Yao ",
      "Huo ",
      "Xu ",
      "Ruo ",
      "Yang ",
      "La ",
      "Yan ",
      "Ben ",
      "Hun ",
      "Kui ",
      "Jie ",
      "Kui ",
      "Si ",
      "Feng ",
      "Xie ",
      "Tuo ",
      "Zhi ",
      "Jian ",
      "Mu ",
      "Mao ",
      "Chu ",
      "Hu ",
      "Hu ",
      "Lian ",
      "Leng ",
      "Ting ",
      "Nan ",
      "Yu ",
      "You ",
      "Mei ",
      "Song ",
      "Xuan ",
      "Xuan ",
      "Ying ",
      "Zhen ",
      "Pian ",
      "Ye ",
      "Ji ",
      "Jie ",
      "Ye ",
      "Chu ",
      "Shun ",
      "Yu ",
      "Cou ",
      "Wei ",
      "Mei ",
      "Di ",
      "Ji ",
      "Jie ",
      "Kai ",
      "Qiu ",
      "Ying ",
      "Rou ",
      "Heng ",
      "Lou ",
      "Le ",
      "Hazou ",
      "Katsura ",
      "Pin ",
      "Muro ",
      "Gai ",
      "Tan ",
      "Lan ",
      "Yun ",
      "Yu ",
      "Chen ",
      "Lu ",
      "Ju ",
      "Sakaki ",
      "[?] ",
      "Pi ",
      "Xie ",
      "Jia ",
      "Yi ",
      "Zhan ",
      "Fu ",
      "Nai ",
      "Mi ",
      "Lang ",
      "Rong ",
      "Gu ",
      "Jian ",
      "Ju ",
      "Ta ",
      "Yao ",
      "Zhen ",
      "Bang ",
      "Sha ",
      "Yuan ",
      "Zi ",
      "Ming ",
      "Su ",
      "Jia ",
      "Yao ",
      "Jie ",
      "Huang ",
      "Gan ",
      "Fei ",
      "Zha ",
      "Qian ",
      "Ma ",
      "Sun ",
      "Yuan ",
      "Xie ",
      "Rong ",
      "Shi ",
      "Zhi ",
      "Cui ",
      "Yun ",
      "Ting ",
      "Liu ",
      "Rong ",
      "Tang ",
      "Que ",
      "Zhai ",
      "Si ",
      "Sheng ",
      "Ta ",
      "Ke ",
      "Xi ",
      "Gu ",
      "Qi ",
      "Kao ",
      "Gao ",
      "Sun ",
      "Pan ",
      "Tao ",
      "Ge ",
      "Xun ",
      "Dian ",
      "Nou ",
      "Ji ",
      "Shuo ",
      "Gou ",
      "Chui ",
      "Qiang ",
      "Cha ",
      "Qian ",
      "Huai ",
      "Mei ",
      "Xu ",
      "Gang ",
      "Gao ",
      "Zhuo ",
      "Tuo ",
      "Hashi ",
      "Yang ",
      "Dian ",
      "Jia ",
      "Jian ",
      "Zui ",
      "Kashi ",
      "Ori ",
      "Bin ",
      "Zhu ",
      "[?] ",
      "Xi ",
      "Qi ",
      "Lian ",
      "Hui ",
      "Yong ",
      "Qian ",
      "Guo ",
      "Gai ",
      "Gai ",
      "Tuan ",
      "Hua ",
      "Cu ",
      "Sen ",
      "Cui ",
      "Beng ",
      "You ",
      "Hu ",
      "Jiang ",
      "Hu ",
      "Huan ",
      "Kui ",
      "Yi ",
      "Nie ",
      "Gao ",
      "Kang ",
      "Gui ",
      "Gui ",
      "Cao ",
      "Man ",
      "Jin "
    ];
  }
});

// node_modules/unidecode/data/x6a.js
var require_x6a = __commonJS({
  "node_modules/unidecode/data/x6a.js"(exports2, module2) {
    module2.exports = [
      "Di ",
      "Zhuang ",
      "Le ",
      "Lang ",
      "Chen ",
      "Cong ",
      "Li ",
      "Xiu ",
      "Qing ",
      "Shuang ",
      "Fan ",
      "Tong ",
      "Guan ",
      "Ji ",
      "Suo ",
      "Lei ",
      "Lu ",
      "Liang ",
      "Mi ",
      "Lou ",
      "Chao ",
      "Su ",
      "Ke ",
      "Shu ",
      "Tang ",
      "Biao ",
      "Lu ",
      "Jiu ",
      "Shu ",
      "Zha ",
      "Shu ",
      "Zhang ",
      "Men ",
      "Mo ",
      "Niao ",
      "Yang ",
      "Tiao ",
      "Peng ",
      "Zhu ",
      "Sha ",
      "Xi ",
      "Quan ",
      "Heng ",
      "Jian ",
      "Cong ",
      "[?] ",
      "Hokuso ",
      "Qiang ",
      "Tara ",
      "Ying ",
      "Er ",
      "Xin ",
      "Zhi ",
      "Qiao ",
      "Zui ",
      "Cong ",
      "Pu ",
      "Shu ",
      "Hua ",
      "Kui ",
      "Zhen ",
      "Zun ",
      "Yue ",
      "Zhan ",
      "Xi ",
      "Xun ",
      "Dian ",
      "Fa ",
      "Gan ",
      "Mo ",
      "Wu ",
      "Qiao ",
      "Nao ",
      "Lin ",
      "Liu ",
      "Qiao ",
      "Xian ",
      "Run ",
      "Fan ",
      "Zhan ",
      "Tuo ",
      "Lao ",
      "Yun ",
      "Shun ",
      "Tui ",
      "Cheng ",
      "Tang ",
      "Meng ",
      "Ju ",
      "Cheng ",
      "Su ",
      "Jue ",
      "Jue ",
      "Tan ",
      "Hui ",
      "Ji ",
      "Nuo ",
      "Xiang ",
      "Tuo ",
      "Ning ",
      "Rui ",
      "Zhu ",
      "Chuang ",
      "Zeng ",
      "Fen ",
      "Qiong ",
      "Ran ",
      "Heng ",
      "Cen ",
      "Gu ",
      "Liu ",
      "Lao ",
      "Gao ",
      "Chu ",
      "Zusa ",
      "Nude ",
      "Ca ",
      "San ",
      "Ji ",
      "Dou ",
      "Shou ",
      "Lu ",
      "[?] ",
      "[?] ",
      "Yuan ",
      "Ta ",
      "Shu ",
      "Jiang ",
      "Tan ",
      "Lin ",
      "Nong ",
      "Yin ",
      "Xi ",
      "Sui ",
      "Shan ",
      "Zui ",
      "Xuan ",
      "Cheng ",
      "Gan ",
      "Ju ",
      "Zui ",
      "Yi ",
      "Qin ",
      "Pu ",
      "Yan ",
      "Lei ",
      "Feng ",
      "Hui ",
      "Dang ",
      "Ji ",
      "Sui ",
      "Bo ",
      "Bi ",
      "Ding ",
      "Chu ",
      "Zhua ",
      "Kuai ",
      "Ji ",
      "Jie ",
      "Jia ",
      "Qing ",
      "Zhe ",
      "Jian ",
      "Qiang ",
      "Dao ",
      "Yi ",
      "Biao ",
      "Song ",
      "She ",
      "Lin ",
      "Kunugi ",
      "Cha ",
      "Meng ",
      "Yin ",
      "Tao ",
      "Tai ",
      "Mian ",
      "Qi ",
      "Toan ",
      "Bin ",
      "Huo ",
      "Ji ",
      "Qian ",
      "Mi ",
      "Ning ",
      "Yi ",
      "Gao ",
      "Jian ",
      "Yin ",
      "Er ",
      "Qing ",
      "Yan ",
      "Qi ",
      "Mi ",
      "Zhao ",
      "Gui ",
      "Chun ",
      "Ji ",
      "Kui ",
      "Po ",
      "Deng ",
      "Chu ",
      "[?] ",
      "Mian ",
      "You ",
      "Zhi ",
      "Guang ",
      "Qian ",
      "Lei ",
      "Lei ",
      "Sa ",
      "Lu ",
      "Li ",
      "Cuan ",
      "Lu ",
      "Mie ",
      "Hui ",
      "Ou ",
      "Lu ",
      "Jie ",
      "Gao ",
      "Du ",
      "Yuan ",
      "Li ",
      "Fei ",
      "Zhuo ",
      "Sou ",
      "Lian ",
      "Tamo ",
      "Chu ",
      "[?] ",
      "Zhu ",
      "Lu ",
      "Yan ",
      "Li ",
      "Zhu ",
      "Chen ",
      "Jie ",
      "E ",
      "Su ",
      "Huai ",
      "Nie ",
      "Yu ",
      "Long ",
      "Lai ",
      "[?] ",
      "Xian ",
      "Kwi ",
      "Ju ",
      "Xiao ",
      "Ling ",
      "Ying ",
      "Jian ",
      "Yin ",
      "You ",
      "Ying "
    ];
  }
});

// node_modules/unidecode/data/x6b.js
var require_x6b = __commonJS({
  "node_modules/unidecode/data/x6b.js"(exports2, module2) {
    module2.exports = [
      "Xiang ",
      "Nong ",
      "Bo ",
      "Chan ",
      "Lan ",
      "Ju ",
      "Shuang ",
      "She ",
      "Wei ",
      "Cong ",
      "Quan ",
      "Qu ",
      "Cang ",
      "[?] ",
      "Yu ",
      "Luo ",
      "Li ",
      "Zan ",
      "Luan ",
      "Dang ",
      "Jue ",
      "Em ",
      "Lan ",
      "Lan ",
      "Zhu ",
      "Lei ",
      "Li ",
      "Ba ",
      "Nang ",
      "Yu ",
      "Ling ",
      "Tsuki ",
      "Qian ",
      "Ci ",
      "Huan ",
      "Xin ",
      "Yu ",
      "Yu ",
      "Qian ",
      "Ou ",
      "Xu ",
      "Chao ",
      "Chu ",
      "Chi ",
      "Kai ",
      "Yi ",
      "Jue ",
      "Xi ",
      "Xu ",
      "Xia ",
      "Yu ",
      "Kuai ",
      "Lang ",
      "Kuan ",
      "Shuo ",
      "Xi ",
      "Ai ",
      "Yi ",
      "Qi ",
      "Hu ",
      "Chi ",
      "Qin ",
      "Kuan ",
      "Kan ",
      "Kuan ",
      "Kan ",
      "Chuan ",
      "Sha ",
      "Gua ",
      "Yin ",
      "Xin ",
      "Xie ",
      "Yu ",
      "Qian ",
      "Xiao ",
      "Yi ",
      "Ge ",
      "Wu ",
      "Tan ",
      "Jin ",
      "Ou ",
      "Hu ",
      "Ti ",
      "Huan ",
      "Xu ",
      "Pen ",
      "Xi ",
      "Xiao ",
      "Xu ",
      "Xi ",
      "Sen ",
      "Lian ",
      "Chu ",
      "Yi ",
      "Kan ",
      "Yu ",
      "Chuo ",
      "Huan ",
      "Zhi ",
      "Zheng ",
      "Ci ",
      "Bu ",
      "Wu ",
      "Qi ",
      "Bu ",
      "Bu ",
      "Wai ",
      "Ju ",
      "Qian ",
      "Chi ",
      "Se ",
      "Chi ",
      "Se ",
      "Zhong ",
      "Sui ",
      "Sui ",
      "Li ",
      "Cuo ",
      "Yu ",
      "Li ",
      "Gui ",
      "Dai ",
      "Dai ",
      "Si ",
      "Jian ",
      "Zhe ",
      "Mo ",
      "Mo ",
      "Yao ",
      "Mo ",
      "Cu ",
      "Yang ",
      "Tian ",
      "Sheng ",
      "Dai ",
      "Shang ",
      "Xu ",
      "Xun ",
      "Shu ",
      "Can ",
      "Jue ",
      "Piao ",
      "Qia ",
      "Qiu ",
      "Su ",
      "Qing ",
      "Yun ",
      "Lian ",
      "Yi ",
      "Fou ",
      "Zhi ",
      "Ye ",
      "Can ",
      "Hun ",
      "Dan ",
      "Ji ",
      "Ye ",
      "Zhen ",
      "Yun ",
      "Wen ",
      "Chou ",
      "Bin ",
      "Ti ",
      "Jin ",
      "Shang ",
      "Yin ",
      "Diao ",
      "Cu ",
      "Hui ",
      "Cuan ",
      "Yi ",
      "Dan ",
      "Du ",
      "Jiang ",
      "Lian ",
      "Bin ",
      "Du ",
      "Tsukusu ",
      "Jian ",
      "Shu ",
      "Ou ",
      "Duan ",
      "Zhu ",
      "Yin ",
      "Qing ",
      "Yi ",
      "Sha ",
      "Que ",
      "Ke ",
      "Yao ",
      "Jun ",
      "Dian ",
      "Hui ",
      "Hui ",
      "Gu ",
      "Que ",
      "Ji ",
      "Yi ",
      "Ou ",
      "Hui ",
      "Duan ",
      "Yi ",
      "Xiao ",
      "Wu ",
      "Guan ",
      "Mu ",
      "Mei ",
      "Mei ",
      "Ai ",
      "Zuo ",
      "Du ",
      "Yu ",
      "Bi ",
      "Bi ",
      "Bi ",
      "Pi ",
      "Pi ",
      "Bi ",
      "Chan ",
      "Mao ",
      "[?] ",
      "[?] ",
      "Pu ",
      "Mushiru ",
      "Jia ",
      "Zhan ",
      "Sai ",
      "Mu ",
      "Tuo ",
      "Xun ",
      "Er ",
      "Rong ",
      "Xian ",
      "Ju ",
      "Mu ",
      "Hao ",
      "Qiu ",
      "Dou ",
      "Mushiru ",
      "Tan ",
      "Pei ",
      "Ju ",
      "Duo ",
      "Cui ",
      "Bi ",
      "San ",
      "[?] ",
      "Mao ",
      "Sui ",
      "Yu ",
      "Yu ",
      "Tuo ",
      "He ",
      "Jian ",
      "Ta ",
      "San "
    ];
  }
});

// node_modules/unidecode/data/x6c.js
var require_x6c = __commonJS({
  "node_modules/unidecode/data/x6c.js"(exports2, module2) {
    module2.exports = [
      "Lu ",
      "Mu ",
      "Li ",
      "Tong ",
      "Rong ",
      "Chang ",
      "Pu ",
      "Luo ",
      "Zhan ",
      "Sao ",
      "Zhan ",
      "Meng ",
      "Luo ",
      "Qu ",
      "Die ",
      "Shi ",
      "Di ",
      "Min ",
      "Jue ",
      "Mang ",
      "Qi ",
      "Pie ",
      "Nai ",
      "Qi ",
      "Dao ",
      "Xian ",
      "Chuan ",
      "Fen ",
      "Ri ",
      "Nei ",
      "[?] ",
      "Fu ",
      "Shen ",
      "Dong ",
      "Qing ",
      "Qi ",
      "Yin ",
      "Xi ",
      "Hai ",
      "Yang ",
      "An ",
      "Ya ",
      "Ke ",
      "Qing ",
      "Ya ",
      "Dong ",
      "Dan ",
      "Lu ",
      "Qing ",
      "Yang ",
      "Yun ",
      "Yun ",
      "Shui ",
      "San ",
      "Zheng ",
      "Bing ",
      "Yong ",
      "Dang ",
      "Shitamizu ",
      "Le ",
      "Ni ",
      "Tun ",
      "Fan ",
      "Gui ",
      "Ting ",
      "Zhi ",
      "Qiu ",
      "Bin ",
      "Ze ",
      "Mian ",
      "Cuan ",
      "Hui ",
      "Diao ",
      "Yi ",
      "Cha ",
      "Zhuo ",
      "Chuan ",
      "Wan ",
      "Fan ",
      "Dai ",
      "Xi ",
      "Tuo ",
      "Mang ",
      "Qiu ",
      "Qi ",
      "Shan ",
      "Pai ",
      "Han ",
      "Qian ",
      "Wu ",
      "Wu ",
      "Xun ",
      "Si ",
      "Ru ",
      "Gong ",
      "Jiang ",
      "Chi ",
      "Wu ",
      "Tsuchi ",
      "[?] ",
      "Tang ",
      "Zhi ",
      "Chi ",
      "Qian ",
      "Mi ",
      "Yu ",
      "Wang ",
      "Qing ",
      "Jing ",
      "Rui ",
      "Jun ",
      "Hong ",
      "Tai ",
      "Quan ",
      "Ji ",
      "Bian ",
      "Bian ",
      "Gan ",
      "Wen ",
      "Zhong ",
      "Fang ",
      "Xiong ",
      "Jue ",
      "Hang ",
      "Niou ",
      "Qi ",
      "Fen ",
      "Xu ",
      "Xu ",
      "Qin ",
      "Yi ",
      "Wo ",
      "Yun ",
      "Yuan ",
      "Hang ",
      "Yan ",
      "Chen ",
      "Chen ",
      "Dan ",
      "You ",
      "Dun ",
      "Hu ",
      "Huo ",
      "Qie ",
      "Mu ",
      "Rou ",
      "Mei ",
      "Ta ",
      "Mian ",
      "Wu ",
      "Chong ",
      "Tian ",
      "Bi ",
      "Sha ",
      "Zhi ",
      "Pei ",
      "Pan ",
      "Zhui ",
      "Za ",
      "Gou ",
      "Liu ",
      "Mei ",
      "Ze ",
      "Feng ",
      "Ou ",
      "Li ",
      "Lun ",
      "Cang ",
      "Feng ",
      "Wei ",
      "Hu ",
      "Mo ",
      "Mei ",
      "Shu ",
      "Ju ",
      "Zan ",
      "Tuo ",
      "Tuo ",
      "Tuo ",
      "He ",
      "Li ",
      "Mi ",
      "Yi ",
      "Fa ",
      "Fei ",
      "You ",
      "Tian ",
      "Zhi ",
      "Zhao ",
      "Gu ",
      "Zhan ",
      "Yan ",
      "Si ",
      "Kuang ",
      "Jiong ",
      "Ju ",
      "Xie ",
      "Qiu ",
      "Yi ",
      "Jia ",
      "Zhong ",
      "Quan ",
      "Bo ",
      "Hui ",
      "Mi ",
      "Ben ",
      "Zhuo ",
      "Chu ",
      "Le ",
      "You ",
      "Gu ",
      "Hong ",
      "Gan ",
      "Fa ",
      "Mao ",
      "Si ",
      "Hu ",
      "Ping ",
      "Ci ",
      "Fan ",
      "Chi ",
      "Su ",
      "Ning ",
      "Cheng ",
      "Ling ",
      "Pao ",
      "Bo ",
      "Qi ",
      "Si ",
      "Ni ",
      "Ju ",
      "Yue ",
      "Zhu ",
      "Sheng ",
      "Lei ",
      "Xuan ",
      "Xue ",
      "Fu ",
      "Pan ",
      "Min ",
      "Tai ",
      "Yang ",
      "Ji ",
      "Yong ",
      "Guan ",
      "Beng ",
      "Xue ",
      "Long ",
      "Lu ",
      "[?] ",
      "Bo ",
      "Xie ",
      "Po ",
      "Ze ",
      "Jing ",
      "Yin "
    ];
  }
});

// node_modules/unidecode/data/x6d.js
var require_x6d = __commonJS({
  "node_modules/unidecode/data/x6d.js"(exports2, module2) {
    module2.exports = [
      "Zhou ",
      "Ji ",
      "Yi ",
      "Hui ",
      "Hui ",
      "Zui ",
      "Cheng ",
      "Yin ",
      "Wei ",
      "Hou ",
      "Jian ",
      "Yang ",
      "Lie ",
      "Si ",
      "Ji ",
      "Er ",
      "Xing ",
      "Fu ",
      "Sa ",
      "Suo ",
      "Zhi ",
      "Yin ",
      "Wu ",
      "Xi ",
      "Kao ",
      "Zhu ",
      "Jiang ",
      "Luo ",
      "[?] ",
      "An ",
      "Dong ",
      "Yi ",
      "Mou ",
      "Lei ",
      "Yi ",
      "Mi ",
      "Quan ",
      "Jin ",
      "Mo ",
      "Wei ",
      "Xiao ",
      "Xie ",
      "Hong ",
      "Xu ",
      "Shuo ",
      "Kuang ",
      "Tao ",
      "Qie ",
      "Ju ",
      "Er ",
      "Zhou ",
      "Ru ",
      "Ping ",
      "Xun ",
      "Xiong ",
      "Zhi ",
      "Guang ",
      "Huan ",
      "Ming ",
      "Huo ",
      "Wa ",
      "Qia ",
      "Pai ",
      "Wu ",
      "Qu ",
      "Liu ",
      "Yi ",
      "Jia ",
      "Jing ",
      "Qian ",
      "Jiang ",
      "Jiao ",
      "Cheng ",
      "Shi ",
      "Zhuo ",
      "Ce ",
      "Pal ",
      "Kuai ",
      "Ji ",
      "Liu ",
      "Chan ",
      "Hun ",
      "Hu ",
      "Nong ",
      "Xun ",
      "Jin ",
      "Lie ",
      "Qiu ",
      "Wei ",
      "Zhe ",
      "Jun ",
      "Han ",
      "Bang ",
      "Mang ",
      "Zhuo ",
      "You ",
      "Xi ",
      "Bo ",
      "Dou ",
      "Wan ",
      "Hong ",
      "Yi ",
      "Pu ",
      "Ying ",
      "Lan ",
      "Hao ",
      "Lang ",
      "Han ",
      "Li ",
      "Geng ",
      "Fu ",
      "Wu ",
      "Lian ",
      "Chun ",
      "Feng ",
      "Yi ",
      "Yu ",
      "Tong ",
      "Lao ",
      "Hai ",
      "Jin ",
      "Jia ",
      "Chong ",
      "Weng ",
      "Mei ",
      "Sui ",
      "Cheng ",
      "Pei ",
      "Xian ",
      "Shen ",
      "Tu ",
      "Kun ",
      "Pin ",
      "Nie ",
      "Han ",
      "Jing ",
      "Xiao ",
      "She ",
      "Nian ",
      "Tu ",
      "Yong ",
      "Xiao ",
      "Xian ",
      "Ting ",
      "E ",
      "Su ",
      "Tun ",
      "Juan ",
      "Cen ",
      "Ti ",
      "Li ",
      "Shui ",
      "Si ",
      "Lei ",
      "Shui ",
      "Tao ",
      "Du ",
      "Lao ",
      "Lai ",
      "Lian ",
      "Wei ",
      "Wo ",
      "Yun ",
      "Huan ",
      "Di ",
      "[?] ",
      "Run ",
      "Jian ",
      "Zhang ",
      "Se ",
      "Fu ",
      "Guan ",
      "Xing ",
      "Shou ",
      "Shuan ",
      "Ya ",
      "Chuo ",
      "Zhang ",
      "Ye ",
      "Kong ",
      "Wo ",
      "Han ",
      "Tuo ",
      "Dong ",
      "He ",
      "Wo ",
      "Ju ",
      "Gan ",
      "Liang ",
      "Hun ",
      "Ta ",
      "Zhuo ",
      "Dian ",
      "Qie ",
      "De ",
      "Juan ",
      "Zi ",
      "Xi ",
      "Yao ",
      "Qi ",
      "Gu ",
      "Guo ",
      "Han ",
      "Lin ",
      "Tang ",
      "Zhou ",
      "Peng ",
      "Hao ",
      "Chang ",
      "Shu ",
      "Qi ",
      "Fang ",
      "Chi ",
      "Lu ",
      "Nao ",
      "Ju ",
      "Tao ",
      "Cong ",
      "Lei ",
      "Zhi ",
      "Peng ",
      "Fei ",
      "Song ",
      "Tian ",
      "Pi ",
      "Dan ",
      "Yu ",
      "Ni ",
      "Yu ",
      "Lu ",
      "Gan ",
      "Mi ",
      "Jing ",
      "Ling ",
      "Lun ",
      "Yin ",
      "Cui ",
      "Qu ",
      "Huai ",
      "Yu ",
      "Nian ",
      "Shen ",
      "Piao ",
      "Chun ",
      "Wa ",
      "Yuan ",
      "Lai ",
      "Hun ",
      "Qing ",
      "Yan ",
      "Qian ",
      "Tian ",
      "Miao ",
      "Zhi ",
      "Yin ",
      "Mi "
    ];
  }
});

// node_modules/unidecode/data/x6e.js
var require_x6e = __commonJS({
  "node_modules/unidecode/data/x6e.js"(exports2, module2) {
    module2.exports = [
      "Ben ",
      "Yuan ",
      "Wen ",
      "Re ",
      "Fei ",
      "Qing ",
      "Yuan ",
      "Ke ",
      "Ji ",
      "She ",
      "Yuan ",
      "Shibui ",
      "Lu ",
      "Zi ",
      "Du ",
      "[?] ",
      "Jian ",
      "Min ",
      "Pi ",
      "Tani ",
      "Yu ",
      "Yuan ",
      "Shen ",
      "Shen ",
      "Rou ",
      "Huan ",
      "Zhu ",
      "Jian ",
      "Nuan ",
      "Yu ",
      "Qiu ",
      "Ting ",
      "Qu ",
      "Du ",
      "Feng ",
      "Zha ",
      "Bo ",
      "Wo ",
      "Wo ",
      "Di ",
      "Wei ",
      "Wen ",
      "Ru ",
      "Xie ",
      "Ce ",
      "Wei ",
      "Ge ",
      "Gang ",
      "Yan ",
      "Hong ",
      "Xuan ",
      "Mi ",
      "Ke ",
      "Mao ",
      "Ying ",
      "Yan ",
      "You ",
      "Hong ",
      "Miao ",
      "Xing ",
      "Mei ",
      "Zai ",
      "Hun ",
      "Nai ",
      "Kui ",
      "Shi ",
      "E ",
      "Pai ",
      "Mei ",
      "Lian ",
      "Qi ",
      "Qi ",
      "Mei ",
      "Tian ",
      "Cou ",
      "Wei ",
      "Can ",
      "Tuan ",
      "Mian ",
      "Hui ",
      "Mo ",
      "Xu ",
      "Ji ",
      "Pen ",
      "Jian ",
      "Jian ",
      "Hu ",
      "Feng ",
      "Xiang ",
      "Yi ",
      "Yin ",
      "Zhan ",
      "Shi ",
      "Jie ",
      "Cheng ",
      "Huang ",
      "Tan ",
      "Yu ",
      "Bi ",
      "Min ",
      "Shi ",
      "Tu ",
      "Sheng ",
      "Yong ",
      "Qu ",
      "Zhong ",
      "Suei ",
      "Jiu ",
      "Jiao ",
      "Qiou ",
      "Yin ",
      "Tang ",
      "Long ",
      "Huo ",
      "Yuan ",
      "Nan ",
      "Ban ",
      "You ",
      "Quan ",
      "Chui ",
      "Liang ",
      "Chan ",
      "Yan ",
      "Chun ",
      "Nie ",
      "Zi ",
      "Wan ",
      "Shi ",
      "Man ",
      "Ying ",
      "Ratsu ",
      "Kui ",
      "[?] ",
      "Jian ",
      "Xu ",
      "Lu ",
      "Gui ",
      "Gai ",
      "[?] ",
      "[?] ",
      "Po ",
      "Jin ",
      "Gui ",
      "Tang ",
      "Yuan ",
      "Suo ",
      "Yuan ",
      "Lian ",
      "Yao ",
      "Meng ",
      "Zhun ",
      "Sheng ",
      "Ke ",
      "Tai ",
      "Da ",
      "Wa ",
      "Liu ",
      "Gou ",
      "Sao ",
      "Ming ",
      "Zha ",
      "Shi ",
      "Yi ",
      "Lun ",
      "Ma ",
      "Pu ",
      "Wei ",
      "Li ",
      "Cai ",
      "Wu ",
      "Xi ",
      "Wen ",
      "Qiang ",
      "Ze ",
      "Shi ",
      "Su ",
      "Yi ",
      "Zhen ",
      "Sou ",
      "Yun ",
      "Xiu ",
      "Yin ",
      "Rong ",
      "Hun ",
      "Su ",
      "Su ",
      "Ni ",
      "Ta ",
      "Shi ",
      "Ru ",
      "Wei ",
      "Pan ",
      "Chu ",
      "Chu ",
      "Pang ",
      "Weng ",
      "Cang ",
      "Mie ",
      "He ",
      "Dian ",
      "Hao ",
      "Huang ",
      "Xi ",
      "Zi ",
      "Di ",
      "Zhi ",
      "Ying ",
      "Fu ",
      "Jie ",
      "Hua ",
      "Ge ",
      "Zi ",
      "Tao ",
      "Teng ",
      "Sui ",
      "Bi ",
      "Jiao ",
      "Hui ",
      "Gun ",
      "Yin ",
      "Gao ",
      "Long ",
      "Zhi ",
      "Yan ",
      "She ",
      "Man ",
      "Ying ",
      "Chun ",
      "Lu ",
      "Lan ",
      "Luan ",
      "[?] ",
      "Bin ",
      "Tan ",
      "Yu ",
      "Sou ",
      "Hu ",
      "Bi ",
      "Biao ",
      "Zhi ",
      "Jiang ",
      "Kou ",
      "Shen ",
      "Shang ",
      "Di ",
      "Mi ",
      "Ao ",
      "Lu ",
      "Hu ",
      "Hu ",
      "You ",
      "Chan ",
      "Fan ",
      "Yong ",
      "Gun ",
      "Man "
    ];
  }
});

// node_modules/unidecode/data/x6f.js
var require_x6f = __commonJS({
  "node_modules/unidecode/data/x6f.js"(exports2, module2) {
    module2.exports = [
      "Qing ",
      "Yu ",
      "Piao ",
      "Ji ",
      "Ya ",
      "Jiao ",
      "Qi ",
      "Xi ",
      "Ji ",
      "Lu ",
      "Lu ",
      "Long ",
      "Jin ",
      "Guo ",
      "Cong ",
      "Lou ",
      "Zhi ",
      "Gai ",
      "Qiang ",
      "Li ",
      "Yan ",
      "Cao ",
      "Jiao ",
      "Cong ",
      "Qun ",
      "Tuan ",
      "Ou ",
      "Teng ",
      "Ye ",
      "Xi ",
      "Mi ",
      "Tang ",
      "Mo ",
      "Shang ",
      "Han ",
      "Lian ",
      "Lan ",
      "Wa ",
      "Li ",
      "Qian ",
      "Feng ",
      "Xuan ",
      "Yi ",
      "Man ",
      "Zi ",
      "Mang ",
      "Kang ",
      "Lei ",
      "Peng ",
      "Shu ",
      "Zhang ",
      "Zhang ",
      "Chong ",
      "Xu ",
      "Huan ",
      "Kuo ",
      "Jian ",
      "Yan ",
      "Chuang ",
      "Liao ",
      "Cui ",
      "Ti ",
      "Yang ",
      "Jiang ",
      "Cong ",
      "Ying ",
      "Hong ",
      "Xun ",
      "Shu ",
      "Guan ",
      "Ying ",
      "Xiao ",
      "[?] ",
      "[?] ",
      "Xu ",
      "Lian ",
      "Zhi ",
      "Wei ",
      "Pi ",
      "Jue ",
      "Jiao ",
      "Po ",
      "Dang ",
      "Hui ",
      "Jie ",
      "Wu ",
      "Pa ",
      "Ji ",
      "Pan ",
      "Gui ",
      "Xiao ",
      "Qian ",
      "Qian ",
      "Xi ",
      "Lu ",
      "Xi ",
      "Xuan ",
      "Dun ",
      "Huang ",
      "Min ",
      "Run ",
      "Su ",
      "Liao ",
      "Zhen ",
      "Zhong ",
      "Yi ",
      "Di ",
      "Wan ",
      "Dan ",
      "Tan ",
      "Chao ",
      "Xun ",
      "Kui ",
      "Yie ",
      "Shao ",
      "Tu ",
      "Zhu ",
      "San ",
      "Hei ",
      "Bi ",
      "Shan ",
      "Chan ",
      "Chan ",
      "Shu ",
      "Tong ",
      "Pu ",
      "Lin ",
      "Wei ",
      "Se ",
      "Se ",
      "Cheng ",
      "Jiong ",
      "Cheng ",
      "Hua ",
      "Jiao ",
      "Lao ",
      "Che ",
      "Gan ",
      "Cun ",
      "Heng ",
      "Si ",
      "Shu ",
      "Peng ",
      "Han ",
      "Yun ",
      "Liu ",
      "Hong ",
      "Fu ",
      "Hao ",
      "He ",
      "Xian ",
      "Jian ",
      "Shan ",
      "Xi ",
      "Oki ",
      "[?] ",
      "Lan ",
      "[?] ",
      "Yu ",
      "Lin ",
      "Min ",
      "Zao ",
      "Dang ",
      "Wan ",
      "Ze ",
      "Xie ",
      "Yu ",
      "Li ",
      "Shi ",
      "Xue ",
      "Ling ",
      "Man ",
      "Zi ",
      "Yong ",
      "Kuai ",
      "Can ",
      "Lian ",
      "Dian ",
      "Ye ",
      "Ao ",
      "Huan ",
      "Zhen ",
      "Chan ",
      "Man ",
      "Dan ",
      "Dan ",
      "Yi ",
      "Sui ",
      "Pi ",
      "Ju ",
      "Ta ",
      "Qin ",
      "Ji ",
      "Zhuo ",
      "Lian ",
      "Nong ",
      "Guo ",
      "Jin ",
      "Fen ",
      "Se ",
      "Ji ",
      "Sui ",
      "Hui ",
      "Chu ",
      "Ta ",
      "Song ",
      "Ding ",
      "[?] ",
      "Zhu ",
      "Lai ",
      "Bin ",
      "Lian ",
      "Mi ",
      "Shi ",
      "Shu ",
      "Mi ",
      "Ning ",
      "Ying ",
      "Ying ",
      "Meng ",
      "Jin ",
      "Qi ",
      "Pi ",
      "Ji ",
      "Hao ",
      "Ru ",
      "Zui ",
      "Wo ",
      "Tao ",
      "Yin ",
      "Yin ",
      "Dui ",
      "Ci ",
      "Huo ",
      "Jing ",
      "Lan ",
      "Jun ",
      "Ai ",
      "Pu ",
      "Zhuo ",
      "Wei ",
      "Bin ",
      "Gu ",
      "Qian ",
      "Xing ",
      "Hama ",
      "Kuo ",
      "Fei ",
      "[?] ",
      "Boku ",
      "Jian ",
      "Wei ",
      "Luo ",
      "Zan ",
      "Lu ",
      "Li "
    ];
  }
});

// node_modules/unidecode/data/x70.js
var require_x70 = __commonJS({
  "node_modules/unidecode/data/x70.js"(exports2, module2) {
    module2.exports = [
      "You ",
      "Yang ",
      "Lu ",
      "Si ",
      "Jie ",
      "Ying ",
      "Du ",
      "Wang ",
      "Hui ",
      "Xie ",
      "Pan ",
      "Shen ",
      "Biao ",
      "Chan ",
      "Mo ",
      "Liu ",
      "Jian ",
      "Pu ",
      "Se ",
      "Cheng ",
      "Gu ",
      "Bin ",
      "Huo ",
      "Xian ",
      "Lu ",
      "Qin ",
      "Han ",
      "Ying ",
      "Yong ",
      "Li ",
      "Jing ",
      "Xiao ",
      "Ying ",
      "Sui ",
      "Wei ",
      "Xie ",
      "Huai ",
      "Hao ",
      "Zhu ",
      "Long ",
      "Lai ",
      "Dui ",
      "Fan ",
      "Hu ",
      "Lai ",
      "[?] ",
      "[?] ",
      "Ying ",
      "Mi ",
      "Ji ",
      "Lian ",
      "Jian ",
      "Ying ",
      "Fen ",
      "Lin ",
      "Yi ",
      "Jian ",
      "Yue ",
      "Chan ",
      "Dai ",
      "Rang ",
      "Jian ",
      "Lan ",
      "Fan ",
      "Shuang ",
      "Yuan ",
      "Zhuo ",
      "Feng ",
      "She ",
      "Lei ",
      "Lan ",
      "Cong ",
      "Qu ",
      "Yong ",
      "Qian ",
      "Fa ",
      "Guan ",
      "Que ",
      "Yan ",
      "Hao ",
      "Hyeng ",
      "Sa ",
      "Zan ",
      "Luan ",
      "Yan ",
      "Li ",
      "Mi ",
      "Shan ",
      "Tan ",
      "Dang ",
      "Jiao ",
      "Chan ",
      "[?] ",
      "Hao ",
      "Ba ",
      "Zhu ",
      "Lan ",
      "Lan ",
      "Nang ",
      "Wan ",
      "Luan ",
      "Xun ",
      "Xian ",
      "Yan ",
      "Gan ",
      "Yan ",
      "Yu ",
      "Huo ",
      "Si ",
      "Mie ",
      "Guang ",
      "Deng ",
      "Hui ",
      "Xiao ",
      "Xiao ",
      "Hu ",
      "Hong ",
      "Ling ",
      "Zao ",
      "Zhuan ",
      "Jiu ",
      "Zha ",
      "Xie ",
      "Chi ",
      "Zhuo ",
      "Zai ",
      "Zai ",
      "Can ",
      "Yang ",
      "Qi ",
      "Zhong ",
      "Fen ",
      "Niu ",
      "Jiong ",
      "Wen ",
      "Po ",
      "Yi ",
      "Lu ",
      "Chui ",
      "Pi ",
      "Kai ",
      "Pan ",
      "Yan ",
      "Kai ",
      "Pang ",
      "Mu ",
      "Chao ",
      "Liao ",
      "Gui ",
      "Kang ",
      "Tun ",
      "Guang ",
      "Xin ",
      "Zhi ",
      "Guang ",
      "Guang ",
      "Wei ",
      "Qiang ",
      "[?] ",
      "Da ",
      "Xia ",
      "Zheng ",
      "Zhu ",
      "Ke ",
      "Zhao ",
      "Fu ",
      "Ba ",
      "Duo ",
      "Duo ",
      "Ling ",
      "Zhuo ",
      "Xuan ",
      "Ju ",
      "Tan ",
      "Pao ",
      "Jiong ",
      "Pao ",
      "Tai ",
      "Tai ",
      "Bing ",
      "Yang ",
      "Tong ",
      "Han ",
      "Zhu ",
      "Zha ",
      "Dian ",
      "Wei ",
      "Shi ",
      "Lian ",
      "Chi ",
      "Huang ",
      "[?] ",
      "Hu ",
      "Shuo ",
      "Lan ",
      "Jing ",
      "Jiao ",
      "Xu ",
      "Xing ",
      "Quan ",
      "Lie ",
      "Huan ",
      "Yang ",
      "Xiao ",
      "Xiu ",
      "Xian ",
      "Yin ",
      "Wu ",
      "Zhou ",
      "Yao ",
      "Shi ",
      "Wei ",
      "Tong ",
      "Xue ",
      "Zai ",
      "Kai ",
      "Hong ",
      "Luo ",
      "Xia ",
      "Zhu ",
      "Xuan ",
      "Zheng ",
      "Po ",
      "Yan ",
      "Hui ",
      "Guang ",
      "Zhe ",
      "Hui ",
      "Kao ",
      "[?] ",
      "Fan ",
      "Shao ",
      "Ye ",
      "Hui ",
      "[?] ",
      "Tang ",
      "Jin ",
      "Re ",
      "[?] ",
      "Xi ",
      "Fu ",
      "Jiong ",
      "Che ",
      "Pu ",
      "Jing ",
      "Zhuo ",
      "Ting ",
      "Wan ",
      "Hai ",
      "Peng ",
      "Lang ",
      "Shan ",
      "Hu ",
      "Feng ",
      "Chi ",
      "Rong "
    ];
  }
});

// node_modules/unidecode/data/x71.js
var require_x71 = __commonJS({
  "node_modules/unidecode/data/x71.js"(exports2, module2) {
    module2.exports = [
      "Hu ",
      "Xi ",
      "Shu ",
      "He ",
      "Xun ",
      "Ku ",
      "Jue ",
      "Xiao ",
      "Xi ",
      "Yan ",
      "Han ",
      "Zhuang ",
      "Jun ",
      "Di ",
      "Xie ",
      "Ji ",
      "Wu ",
      "[?] ",
      "[?] ",
      "Han ",
      "Yan ",
      "Huan ",
      "Men ",
      "Ju ",
      "Chou ",
      "Bei ",
      "Fen ",
      "Lin ",
      "Kun ",
      "Hun ",
      "Tun ",
      "Xi ",
      "Cui ",
      "Wu ",
      "Hong ",
      "Ju ",
      "Fu ",
      "Wo ",
      "Jiao ",
      "Cong ",
      "Feng ",
      "Ping ",
      "Qiong ",
      "Ruo ",
      "Xi ",
      "Qiong ",
      "Xin ",
      "Zhuo ",
      "Yan ",
      "Yan ",
      "Yi ",
      "Jue ",
      "Yu ",
      "Gang ",
      "Ran ",
      "Pi ",
      "Gu ",
      "[?] ",
      "Sheng ",
      "Chang ",
      "Shao ",
      "[?] ",
      "[?] ",
      "[?] ",
      "[?] ",
      "Chen ",
      "He ",
      "Kui ",
      "Zhong ",
      "Duan ",
      "Xia ",
      "Hui ",
      "Feng ",
      "Lian ",
      "Xuan ",
      "Xing ",
      "Huang ",
      "Jiao ",
      "Jian ",
      "Bi ",
      "Ying ",
      "Zhu ",
      "Wei ",
      "Tuan ",
      "Tian ",
      "Xi ",
      "Nuan ",
      "Nuan ",
      "Chan ",
      "Yan ",
      "Jiong ",
      "Jiong ",
      "Yu ",
      "Mei ",
      "Sha ",
      "Wei ",
      "Ye ",
      "Xin ",
      "Qiong ",
      "Rou ",
      "Mei ",
      "Huan ",
      "Xu ",
      "Zhao ",
      "Wei ",
      "Fan ",
      "Qiu ",
      "Sui ",
      "Yang ",
      "Lie ",
      "Zhu ",
      "Jie ",
      "Gao ",
      "Gua ",
      "Bao ",
      "Hu ",
      "Yun ",
      "Xia ",
      "[?] ",
      "[?] ",
      "Bian ",
      "Gou ",
      "Tui ",
      "Tang ",
      "Chao ",
      "Shan ",
      "N ",
      "Bo ",
      "Huang ",
      "Xie ",
      "Xi ",
      "Wu ",
      "Xi ",
      "Yun ",
      "He ",
      "He ",
      "Xi ",
      "Yun ",
      "Xiong ",
      "Nai ",
      "Shan ",
      "Qiong ",
      "Yao ",
      "Xun ",
      "Mi ",
      "Lian ",
      "Ying ",
      "Wen ",
      "Rong ",
      "Oozutsu ",
      "[?] ",
      "Qiang ",
      "Liu ",
      "Xi ",
      "Bi ",
      "Biao ",
      "Zong ",
      "Lu ",
      "Jian ",
      "Shou ",
      "Yi ",
      "Lou ",
      "Feng ",
      "Sui ",
      "Yi ",
      "Tong ",
      "Jue ",
      "Zong ",
      "Yun ",
      "Hu ",
      "Yi ",
      "Zhi ",
      "Ao ",
      "Wei ",
      "Liao ",
      "Han ",
      "Ou ",
      "Re ",
      "Jiong ",
      "Man ",
      "[?] ",
      "Shang ",
      "Cuan ",
      "Zeng ",
      "Jian ",
      "Xi ",
      "Xi ",
      "Xi ",
      "Yi ",
      "Xiao ",
      "Chi ",
      "Huang ",
      "Chan ",
      "Ye ",
      "Qian ",
      "Ran ",
      "Yan ",
      "Xian ",
      "Qiao ",
      "Zun ",
      "Deng ",
      "Dun ",
      "Shen ",
      "Jiao ",
      "Fen ",
      "Si ",
      "Liao ",
      "Yu ",
      "Lin ",
      "Tong ",
      "Shao ",
      "Fen ",
      "Fan ",
      "Yan ",
      "Xun ",
      "Lan ",
      "Mei ",
      "Tang ",
      "Yi ",
      "Jing ",
      "Men ",
      "[?] ",
      "[?] ",
      "Ying ",
      "Yu ",
      "Yi ",
      "Xue ",
      "Lan ",
      "Tai ",
      "Zao ",
      "Can ",
      "Sui ",
      "Xi ",
      "Que ",
      "Cong ",
      "Lian ",
      "Hui ",
      "Zhu ",
      "Xie ",
      "Ling ",
      "Wei ",
      "Yi ",
      "Xie ",
      "Zhao ",
      "Hui ",
      "Tatsu ",
      "Nung ",
      "Lan ",
      "Ru ",
      "Xian ",
      "Kao ",
      "Xun ",
      "Jin ",
      "Chou ",
      "Chou ",
      "Yao "
    ];
  }
});

// node_modules/unidecode/data/x72.js
var require_x72 = __commonJS({
  "node_modules/unidecode/data/x72.js"(exports2, module2) {
    module2.exports = [
      "He ",
      "Lan ",
      "Biao ",
      "Rong ",
      "Li ",
      "Mo ",
      "Bao ",
      "Ruo ",
      "Lu ",
      "La ",
      "Ao ",
      "Xun ",
      "Kuang ",
      "Shuo ",
      "[?] ",
      "Li ",
      "Lu ",
      "Jue ",
      "Liao ",
      "Yan ",
      "Xi ",
      "Xie ",
      "Long ",
      "Ye ",
      "[?] ",
      "Rang ",
      "Yue ",
      "Lan ",
      "Cong ",
      "Jue ",
      "Tong ",
      "Guan ",
      "[?] ",
      "Che ",
      "Mi ",
      "Tang ",
      "Lan ",
      "Zhu ",
      "[?] ",
      "Ling ",
      "Cuan ",
      "Yu ",
      "Zhua ",
      "Tsumekanmuri ",
      "Pa ",
      "Zheng ",
      "Pao ",
      "Cheng ",
      "Yuan ",
      "Ai ",
      "Wei ",
      "[?] ",
      "Jue ",
      "Jue ",
      "Fu ",
      "Ye ",
      "Ba ",
      "Die ",
      "Ye ",
      "Yao ",
      "Zu ",
      "Shuang ",
      "Er ",
      "Qiang ",
      "Chuang ",
      "Ge ",
      "Zang ",
      "Die ",
      "Qiang ",
      "Yong ",
      "Qiang ",
      "Pian ",
      "Ban ",
      "Pan ",
      "Shao ",
      "Jian ",
      "Pai ",
      "Du ",
      "Chuang ",
      "Tou ",
      "Zha ",
      "Bian ",
      "Die ",
      "Bang ",
      "Bo ",
      "Chuang ",
      "You ",
      "[?] ",
      "Du ",
      "Ya ",
      "Cheng ",
      "Niu ",
      "Ushihen ",
      "Pin ",
      "Jiu ",
      "Mou ",
      "Tuo ",
      "Mu ",
      "Lao ",
      "Ren ",
      "Mang ",
      "Fang ",
      "Mao ",
      "Mu ",
      "Gang ",
      "Wu ",
      "Yan ",
      "Ge ",
      "Bei ",
      "Si ",
      "Jian ",
      "Gu ",
      "You ",
      "Ge ",
      "Sheng ",
      "Mu ",
      "Di ",
      "Qian ",
      "Quan ",
      "Quan ",
      "Zi ",
      "Te ",
      "Xi ",
      "Mang ",
      "Keng ",
      "Qian ",
      "Wu ",
      "Gu ",
      "Xi ",
      "Li ",
      "Li ",
      "Pou ",
      "Ji ",
      "Gang ",
      "Zhi ",
      "Ben ",
      "Quan ",
      "Run ",
      "Du ",
      "Ju ",
      "Jia ",
      "Jian ",
      "Feng ",
      "Pian ",
      "Ke ",
      "Ju ",
      "Kao ",
      "Chu ",
      "Xi ",
      "Bei ",
      "Luo ",
      "Jie ",
      "Ma ",
      "San ",
      "Wei ",
      "Li ",
      "Dun ",
      "Tong ",
      "[?] ",
      "Jiang ",
      "Ikenie ",
      "Li ",
      "Du ",
      "Lie ",
      "Pi ",
      "Piao ",
      "Bao ",
      "Xi ",
      "Chou ",
      "Wei ",
      "Kui ",
      "Chou ",
      "Quan ",
      "Fan ",
      "Ba ",
      "Fan ",
      "Qiu ",
      "Ji ",
      "Cai ",
      "Chuo ",
      "An ",
      "Jie ",
      "Zhuang ",
      "Guang ",
      "Ma ",
      "You ",
      "Kang ",
      "Bo ",
      "Hou ",
      "Ya ",
      "Yin ",
      "Huan ",
      "Zhuang ",
      "Yun ",
      "Kuang ",
      "Niu ",
      "Di ",
      "Qing ",
      "Zhong ",
      "Mu ",
      "Bei ",
      "Pi ",
      "Ju ",
      "Ni ",
      "Sheng ",
      "Pao ",
      "Xia ",
      "Tuo ",
      "Hu ",
      "Ling ",
      "Fei ",
      "Pi ",
      "Ni ",
      "Ao ",
      "You ",
      "Gou ",
      "Yue ",
      "Ju ",
      "Dan ",
      "Po ",
      "Gu ",
      "Xian ",
      "Ning ",
      "Huan ",
      "Hen ",
      "Jiao ",
      "He ",
      "Zhao ",
      "Ji ",
      "Xun ",
      "Shan ",
      "Ta ",
      "Rong ",
      "Shou ",
      "Tong ",
      "Lao ",
      "Du ",
      "Xia ",
      "Shi ",
      "Hua ",
      "Zheng ",
      "Yu ",
      "Sun ",
      "Yu ",
      "Bi ",
      "Mang ",
      "Xi ",
      "Juan ",
      "Li ",
      "Xia ",
      "Yin ",
      "Suan ",
      "Lang ",
      "Bei ",
      "Zhi ",
      "Yan "
    ];
  }
});

// node_modules/unidecode/data/x73.js
var require_x73 = __commonJS({
  "node_modules/unidecode/data/x73.js"(exports2, module2) {
    module2.exports = [
      "Sha ",
      "Li ",
      "Han ",
      "Xian ",
      "Jing ",
      "Pai ",
      "Fei ",
      "Yao ",
      "Ba ",
      "Qi ",
      "Ni ",
      "Biao ",
      "Yin ",
      "Lai ",
      "Xi ",
      "Jian ",
      "Qiang ",
      "Kun ",
      "Yan ",
      "Guo ",
      "Zong ",
      "Mi ",
      "Chang ",
      "Yi ",
      "Zhi ",
      "Zheng ",
      "Ya ",
      "Meng ",
      "Cai ",
      "Cu ",
      "She ",
      "Kari ",
      "Cen ",
      "Luo ",
      "Hu ",
      "Zong ",
      "Ji ",
      "Wei ",
      "Feng ",
      "Wo ",
      "Yuan ",
      "Xing ",
      "Zhu ",
      "Mao ",
      "Wei ",
      "Yuan ",
      "Xian ",
      "Tuan ",
      "Ya ",
      "Nao ",
      "Xie ",
      "Jia ",
      "Hou ",
      "Bian ",
      "You ",
      "You ",
      "Mei ",
      "Zha ",
      "Yao ",
      "Sun ",
      "Bo ",
      "Ming ",
      "Hua ",
      "Yuan ",
      "Sou ",
      "Ma ",
      "Yuan ",
      "Dai ",
      "Yu ",
      "Shi ",
      "Hao ",
      "[?] ",
      "Yi ",
      "Zhen ",
      "Chuang ",
      "Hao ",
      "Man ",
      "Jing ",
      "Jiang ",
      "Mu ",
      "Zhang ",
      "Chan ",
      "Ao ",
      "Ao ",
      "Hao ",
      "Cui ",
      "Fen ",
      "Jue ",
      "Bi ",
      "Bi ",
      "Huang ",
      "Pu ",
      "Lin ",
      "Yu ",
      "Tong ",
      "Yao ",
      "Liao ",
      "Shuo ",
      "Xiao ",
      "Swu ",
      "Ton ",
      "Xi ",
      "Ge ",
      "Juan ",
      "Du ",
      "Hui ",
      "Kuai ",
      "Xian ",
      "Xie ",
      "Ta ",
      "Xian ",
      "Xun ",
      "Ning ",
      "Pin ",
      "Huo ",
      "Nou ",
      "Meng ",
      "Lie ",
      "Nao ",
      "Guang ",
      "Shou ",
      "Lu ",
      "Ta ",
      "Xian ",
      "Mi ",
      "Rang ",
      "Huan ",
      "Nao ",
      "Luo ",
      "Xian ",
      "Qi ",
      "Jue ",
      "Xuan ",
      "Miao ",
      "Zi ",
      "Lu ",
      "Lu ",
      "Yu ",
      "Su ",
      "Wang ",
      "Qiu ",
      "Ga ",
      "Ding ",
      "Le ",
      "Ba ",
      "Ji ",
      "Hong ",
      "Di ",
      "Quan ",
      "Gan ",
      "Jiu ",
      "Yu ",
      "Ji ",
      "Yu ",
      "Yang ",
      "Ma ",
      "Gong ",
      "Wu ",
      "Fu ",
      "Wen ",
      "Jie ",
      "Ya ",
      "Fen ",
      "Bian ",
      "Beng ",
      "Yue ",
      "Jue ",
      "Yun ",
      "Jue ",
      "Wan ",
      "Jian ",
      "Mei ",
      "Dan ",
      "Pi ",
      "Wei ",
      "Huan ",
      "Xian ",
      "Qiang ",
      "Ling ",
      "Dai ",
      "Yi ",
      "An ",
      "Ping ",
      "Dian ",
      "Fu ",
      "Xuan ",
      "Xi ",
      "Bo ",
      "Ci ",
      "Gou ",
      "Jia ",
      "Shao ",
      "Po ",
      "Ci ",
      "Ke ",
      "Ran ",
      "Sheng ",
      "Shen ",
      "Yi ",
      "Zu ",
      "Jia ",
      "Min ",
      "Shan ",
      "Liu ",
      "Bi ",
      "Zhen ",
      "Zhen ",
      "Jue ",
      "Fa ",
      "Long ",
      "Jin ",
      "Jiao ",
      "Jian ",
      "Li ",
      "Guang ",
      "Xian ",
      "Zhou ",
      "Gong ",
      "Yan ",
      "Xiu ",
      "Yang ",
      "Xu ",
      "Luo ",
      "Su ",
      "Zhu ",
      "Qin ",
      "Ken ",
      "Xun ",
      "Bao ",
      "Er ",
      "Xiang ",
      "Yao ",
      "Xia ",
      "Heng ",
      "Gui ",
      "Chong ",
      "Xu ",
      "Ban ",
      "Pei ",
      "[?] ",
      "Dang ",
      "Ei ",
      "Hun ",
      "Wen ",
      "E ",
      "Cheng ",
      "Ti ",
      "Wu ",
      "Wu ",
      "Cheng ",
      "Jun ",
      "Mei ",
      "Bei ",
      "Ting ",
      "Xian ",
      "Chuo "
    ];
  }
});

// node_modules/unidecode/data/x74.js
var require_x74 = __commonJS({
  "node_modules/unidecode/data/x74.js"(exports2, module2) {
    module2.exports = [
      "Han ",
      "Xuan ",
      "Yan ",
      "Qiu ",
      "Quan ",
      "Lang ",
      "Li ",
      "Xiu ",
      "Fu ",
      "Liu ",
      "Ye ",
      "Xi ",
      "Ling ",
      "Li ",
      "Jin ",
      "Lian ",
      "Suo ",
      "Chiisai ",
      "[?] ",
      "Wan ",
      "Dian ",
      "Pin ",
      "Zhan ",
      "Cui ",
      "Min ",
      "Yu ",
      "Ju ",
      "Chen ",
      "Lai ",
      "Wen ",
      "Sheng ",
      "Wei ",
      "Dian ",
      "Chu ",
      "Zhuo ",
      "Pei ",
      "Cheng ",
      "Hu ",
      "Qi ",
      "E ",
      "Kun ",
      "Chang ",
      "Qi ",
      "Beng ",
      "Wan ",
      "Lu ",
      "Cong ",
      "Guan ",
      "Yan ",
      "Diao ",
      "Bei ",
      "Lin ",
      "Qin ",
      "Pi ",
      "Pa ",
      "Que ",
      "Zhuo ",
      "Qin ",
      "Fa ",
      "[?] ",
      "Qiong ",
      "Du ",
      "Jie ",
      "Hun ",
      "Yu ",
      "Mao ",
      "Mei ",
      "Chun ",
      "Xuan ",
      "Ti ",
      "Xing ",
      "Dai ",
      "Rou ",
      "Min ",
      "Zhen ",
      "Wei ",
      "Ruan ",
      "Huan ",
      "Jie ",
      "Chuan ",
      "Jian ",
      "Zhuan ",
      "Yang ",
      "Lian ",
      "Quan ",
      "Xia ",
      "Duan ",
      "Yuan ",
      "Ye ",
      "Nao ",
      "Hu ",
      "Ying ",
      "Yu ",
      "Huang ",
      "Rui ",
      "Se ",
      "Liu ",
      "Shi ",
      "Rong ",
      "Suo ",
      "Yao ",
      "Wen ",
      "Wu ",
      "Jin ",
      "Jin ",
      "Ying ",
      "Ma ",
      "Tao ",
      "Liu ",
      "Tang ",
      "Li ",
      "Lang ",
      "Gui ",
      "Zhen ",
      "Qiang ",
      "Cuo ",
      "Jue ",
      "Zhao ",
      "Yao ",
      "Ai ",
      "Bin ",
      "Tu ",
      "Chang ",
      "Kun ",
      "Zhuan ",
      "Cong ",
      "Jin ",
      "Yi ",
      "Cui ",
      "Cong ",
      "Qi ",
      "Li ",
      "Ying ",
      "Suo ",
      "Qiu ",
      "Xuan ",
      "Ao ",
      "Lian ",
      "Man ",
      "Zhang ",
      "Yin ",
      "[?] ",
      "Ying ",
      "Zhi ",
      "Lu ",
      "Wu ",
      "Deng ",
      "Xiou ",
      "Zeng ",
      "Xun ",
      "Qu ",
      "Dang ",
      "Lin ",
      "Liao ",
      "Qiong ",
      "Su ",
      "Huang ",
      "Gui ",
      "Pu ",
      "Jing ",
      "Fan ",
      "Jin ",
      "Liu ",
      "Ji ",
      "[?] ",
      "Jing ",
      "Ai ",
      "Bi ",
      "Can ",
      "Qu ",
      "Zao ",
      "Dang ",
      "Jiao ",
      "Gun ",
      "Tan ",
      "Hui ",
      "Huan ",
      "Se ",
      "Sui ",
      "Tian ",
      "[?] ",
      "Yu ",
      "Jin ",
      "Lu ",
      "Bin ",
      "Shou ",
      "Wen ",
      "Zui ",
      "Lan ",
      "Xi ",
      "Ji ",
      "Xuan ",
      "Ruan ",
      "Huo ",
      "Gai ",
      "Lei ",
      "Du ",
      "Li ",
      "Zhi ",
      "Rou ",
      "Li ",
      "Zan ",
      "Qiong ",
      "Zhe ",
      "Gui ",
      "Sui ",
      "La ",
      "Long ",
      "Lu ",
      "Li ",
      "Zan ",
      "Lan ",
      "Ying ",
      "Mi ",
      "Xiang ",
      "Xi ",
      "Guan ",
      "Dao ",
      "Zan ",
      "Huan ",
      "Gua ",
      "Bo ",
      "Die ",
      "Bao ",
      "Hu ",
      "Zhi ",
      "Piao ",
      "Ban ",
      "Rang ",
      "Li ",
      "Wa ",
      "Dekaguramu ",
      "Jiang ",
      "Qian ",
      "Fan ",
      "Pen ",
      "Fang ",
      "Dan ",
      "Weng ",
      "Ou ",
      "Deshiguramu ",
      "Miriguramu ",
      "Thon ",
      "Hu ",
      "Ling ",
      "Yi ",
      "Ping ",
      "Ci ",
      "Hekutogura ",
      "Juan ",
      "Chang ",
      "Chi ",
      "Sarake ",
      "Dang ",
      "Meng ",
      "Pou "
    ];
  }
});

// node_modules/unidecode/data/x75.js
var require_x75 = __commonJS({
  "node_modules/unidecode/data/x75.js"(exports2, module2) {
    module2.exports = [
      "Zhui ",
      "Ping ",
      "Bian ",
      "Zhou ",
      "Zhen ",
      "Senchigura ",
      "Ci ",
      "Ying ",
      "Qi ",
      "Xian ",
      "Lou ",
      "Di ",
      "Ou ",
      "Meng ",
      "Zhuan ",
      "Peng ",
      "Lin ",
      "Zeng ",
      "Wu ",
      "Pi ",
      "Dan ",
      "Weng ",
      "Ying ",
      "Yan ",
      "Gan ",
      "Dai ",
      "Shen ",
      "Tian ",
      "Tian ",
      "Han ",
      "Chang ",
      "Sheng ",
      "Qing ",
      "Sheng ",
      "Chan ",
      "Chan ",
      "Rui ",
      "Sheng ",
      "Su ",
      "Sen ",
      "Yong ",
      "Shuai ",
      "Lu ",
      "Fu ",
      "Yong ",
      "Beng ",
      "Feng ",
      "Ning ",
      "Tian ",
      "You ",
      "Jia ",
      "Shen ",
      "Zha ",
      "Dian ",
      "Fu ",
      "Nan ",
      "Dian ",
      "Ping ",
      "Ting ",
      "Hua ",
      "Ting ",
      "Quan ",
      "Zi ",
      "Meng ",
      "Bi ",
      "Qi ",
      "Liu ",
      "Xun ",
      "Liu ",
      "Chang ",
      "Mu ",
      "Yun ",
      "Fan ",
      "Fu ",
      "Geng ",
      "Tian ",
      "Jie ",
      "Jie ",
      "Quan ",
      "Wei ",
      "Fu ",
      "Tian ",
      "Mu ",
      "Tap ",
      "Pan ",
      "Jiang ",
      "Wa ",
      "Da ",
      "Nan ",
      "Liu ",
      "Ben ",
      "Zhen ",
      "Chu ",
      "Mu ",
      "Mu ",
      "Ce ",
      "Cen ",
      "Gai ",
      "Bi ",
      "Da ",
      "Zhi ",
      "Lue ",
      "Qi ",
      "Lue ",
      "Pan ",
      "Kesa ",
      "Fan ",
      "Hua ",
      "Yu ",
      "Yu ",
      "Mu ",
      "Jun ",
      "Yi ",
      "Liu ",
      "Yu ",
      "Die ",
      "Chou ",
      "Hua ",
      "Dang ",
      "Chuo ",
      "Ji ",
      "Wan ",
      "Jiang ",
      "Sheng ",
      "Chang ",
      "Tuan ",
      "Lei ",
      "Ji ",
      "Cha ",
      "Liu ",
      "Tatamu ",
      "Tuan ",
      "Lin ",
      "Jiang ",
      "Jiang ",
      "Chou ",
      "Bo ",
      "Die ",
      "Die ",
      "Pi ",
      "Nie ",
      "Dan ",
      "Shu ",
      "Shu ",
      "Zhi ",
      "Yi ",
      "Chuang ",
      "Nai ",
      "Ding ",
      "Bi ",
      "Jie ",
      "Liao ",
      "Gong ",
      "Ge ",
      "Jiu ",
      "Zhou ",
      "Xia ",
      "Shan ",
      "Xu ",
      "Nue ",
      "Li ",
      "Yang ",
      "Chen ",
      "You ",
      "Ba ",
      "Jie ",
      "Jue ",
      "Zhi ",
      "Xia ",
      "Cui ",
      "Bi ",
      "Yi ",
      "Li ",
      "Zong ",
      "Chuang ",
      "Feng ",
      "Zhu ",
      "Pao ",
      "Pi ",
      "Gan ",
      "Ke ",
      "Ci ",
      "Xie ",
      "Qi ",
      "Dan ",
      "Zhen ",
      "Fa ",
      "Zhi ",
      "Teng ",
      "Ju ",
      "Ji ",
      "Fei ",
      "Qu ",
      "Dian ",
      "Jia ",
      "Xian ",
      "Cha ",
      "Bing ",
      "Ni ",
      "Zheng ",
      "Yong ",
      "Jing ",
      "Quan ",
      "Chong ",
      "Tong ",
      "Yi ",
      "Kai ",
      "Wei ",
      "Hui ",
      "Duo ",
      "Yang ",
      "Chi ",
      "Zhi ",
      "Hen ",
      "Ya ",
      "Mei ",
      "Dou ",
      "Jing ",
      "Xiao ",
      "Tong ",
      "Tu ",
      "Mang ",
      "Pi ",
      "Xiao ",
      "Suan ",
      "Pu ",
      "Li ",
      "Zhi ",
      "Cuo ",
      "Duo ",
      "Wu ",
      "Sha ",
      "Lao ",
      "Shou ",
      "Huan ",
      "Xian ",
      "Yi ",
      "Peng ",
      "Zhang ",
      "Guan ",
      "Tan ",
      "Fei ",
      "Ma ",
      "Lin ",
      "Chi ",
      "Ji ",
      "Dian ",
      "An ",
      "Chi ",
      "Bi ",
      "Bei ",
      "Min ",
      "Gu ",
      "Dui ",
      "E ",
      "Wei "
    ];
  }
});

// node_modules/unidecode/data/x76.js
var require_x76 = __commonJS({
  "node_modules/unidecode/data/x76.js"(exports2, module2) {
    module2.exports = [
      "Yu ",
      "Cui ",
      "Ya ",
      "Zhu ",
      "Cu ",
      "Dan ",
      "Shen ",
      "Zhung ",
      "Ji ",
      "Yu ",
      "Hou ",
      "Feng ",
      "La ",
      "Yang ",
      "Shen ",
      "Tu ",
      "Yu ",
      "Gua ",
      "Wen ",
      "Huan ",
      "Ku ",
      "Jia ",
      "Yin ",
      "Yi ",
      "Lu ",
      "Sao ",
      "Jue ",
      "Chi ",
      "Xi ",
      "Guan ",
      "Yi ",
      "Wen ",
      "Ji ",
      "Chuang ",
      "Ban ",
      "Lei ",
      "Liu ",
      "Chai ",
      "Shou ",
      "Nue ",
      "Dian ",
      "Da ",
      "Pie ",
      "Tan ",
      "Zhang ",
      "Biao ",
      "Shen ",
      "Cu ",
      "Luo ",
      "Yi ",
      "Zong ",
      "Chou ",
      "Zhang ",
      "Zhai ",
      "Sou ",
      "Suo ",
      "Que ",
      "Diao ",
      "Lou ",
      "Lu ",
      "Mo ",
      "Jin ",
      "Yin ",
      "Ying ",
      "Huang ",
      "Fu ",
      "Liao ",
      "Long ",
      "Qiao ",
      "Liu ",
      "Lao ",
      "Xian ",
      "Fei ",
      "Dan ",
      "Yin ",
      "He ",
      "Yan ",
      "Ban ",
      "Xian ",
      "Guan ",
      "Guai ",
      "Nong ",
      "Yu ",
      "Wei ",
      "Yi ",
      "Yong ",
      "Pi ",
      "Lei ",
      "Li ",
      "Shu ",
      "Dan ",
      "Lin ",
      "Dian ",
      "Lin ",
      "Lai ",
      "Pie ",
      "Ji ",
      "Chi ",
      "Yang ",
      "Xian ",
      "Jie ",
      "Zheng ",
      "[?] ",
      "Li ",
      "Huo ",
      "Lai ",
      "Shaku ",
      "Dian ",
      "Xian ",
      "Ying ",
      "Yin ",
      "Qu ",
      "Yong ",
      "Tan ",
      "Dian ",
      "Luo ",
      "Luan ",
      "Luan ",
      "Bo ",
      "[?] ",
      "Gui ",
      "Po ",
      "Fa ",
      "Deng ",
      "Fa ",
      "Bai ",
      "Bai ",
      "Qie ",
      "Bi ",
      "Zao ",
      "Zao ",
      "Mao ",
      "De ",
      "Pa ",
      "Jie ",
      "Huang ",
      "Gui ",
      "Ci ",
      "Ling ",
      "Gao ",
      "Mo ",
      "Ji ",
      "Jiao ",
      "Peng ",
      "Gao ",
      "Ai ",
      "E ",
      "Hao ",
      "Han ",
      "Bi ",
      "Wan ",
      "Chou ",
      "Qian ",
      "Xi ",
      "Ai ",
      "Jiong ",
      "Hao ",
      "Huang ",
      "Hao ",
      "Ze ",
      "Cui ",
      "Hao ",
      "Xiao ",
      "Ye ",
      "Po ",
      "Hao ",
      "Jiao ",
      "Ai ",
      "Xing ",
      "Huang ",
      "Li ",
      "Piao ",
      "He ",
      "Jiao ",
      "Pi ",
      "Gan ",
      "Pao ",
      "Zhou ",
      "Jun ",
      "Qiu ",
      "Cun ",
      "Que ",
      "Zha ",
      "Gu ",
      "Jun ",
      "Jun ",
      "Zhou ",
      "Zha ",
      "Gu ",
      "Zhan ",
      "Du ",
      "Min ",
      "Qi ",
      "Ying ",
      "Yu ",
      "Bei ",
      "Zhao ",
      "Zhong ",
      "Pen ",
      "He ",
      "Ying ",
      "He ",
      "Yi ",
      "Bo ",
      "Wan ",
      "He ",
      "Ang ",
      "Zhan ",
      "Yan ",
      "Jian ",
      "He ",
      "Yu ",
      "Kui ",
      "Fan ",
      "Gai ",
      "Dao ",
      "Pan ",
      "Fu ",
      "Qiu ",
      "Sheng ",
      "Dao ",
      "Lu ",
      "Zhan ",
      "Meng ",
      "Li ",
      "Jin ",
      "Xu ",
      "Jian ",
      "Pan ",
      "Guan ",
      "An ",
      "Lu ",
      "Shu ",
      "Zhou ",
      "Dang ",
      "An ",
      "Gu ",
      "Li ",
      "Mu ",
      "Cheng ",
      "Gan ",
      "Xu ",
      "Mang ",
      "Mang ",
      "Zhi ",
      "Qi ",
      "Ruan ",
      "Tian ",
      "Xiang ",
      "Dun ",
      "Xin ",
      "Xi ",
      "Pan ",
      "Feng ",
      "Dun ",
      "Min "
    ];
  }
});

// node_modules/unidecode/data/x77.js
var require_x77 = __commonJS({
  "node_modules/unidecode/data/x77.js"(exports2, module2) {
    module2.exports = [
      "Ming ",
      "Sheng ",
      "Shi ",
      "Yun ",
      "Mian ",
      "Pan ",
      "Fang ",
      "Miao ",
      "Dan ",
      "Mei ",
      "Mao ",
      "Kan ",
      "Xian ",
      "Ou ",
      "Shi ",
      "Yang ",
      "Zheng ",
      "Yao ",
      "Shen ",
      "Huo ",
      "Da ",
      "Zhen ",
      "Kuang ",
      "Ju ",
      "Shen ",
      "Chi ",
      "Sheng ",
      "Mei ",
      "Mo ",
      "Zhu ",
      "Zhen ",
      "Zhen ",
      "Mian ",
      "Di ",
      "Yuan ",
      "Die ",
      "Yi ",
      "Zi ",
      "Zi ",
      "Chao ",
      "Zha ",
      "Xuan ",
      "Bing ",
      "Mi ",
      "Long ",
      "Sui ",
      "Dong ",
      "Mi ",
      "Die ",
      "Yi ",
      "Er ",
      "Ming ",
      "Xuan ",
      "Chi ",
      "Kuang ",
      "Juan ",
      "Mou ",
      "Zhen ",
      "Tiao ",
      "Yang ",
      "Yan ",
      "Mo ",
      "Zhong ",
      "Mai ",
      "Zhao ",
      "Zheng ",
      "Mei ",
      "Jun ",
      "Shao ",
      "Han ",
      "Huan ",
      "Di ",
      "Cheng ",
      "Cuo ",
      "Juan ",
      "E ",
      "Wan ",
      "Xian ",
      "Xi ",
      "Kun ",
      "Lai ",
      "Jian ",
      "Shan ",
      "Tian ",
      "Hun ",
      "Wan ",
      "Ling ",
      "Shi ",
      "Qiong ",
      "Lie ",
      "Yai ",
      "Jing ",
      "Zheng ",
      "Li ",
      "Lai ",
      "Sui ",
      "Juan ",
      "Shui ",
      "Sui ",
      "Du ",
      "Bi ",
      "Bi ",
      "Mu ",
      "Hun ",
      "Ni ",
      "Lu ",
      "Yi ",
      "Jie ",
      "Cai ",
      "Zhou ",
      "Yu ",
      "Hun ",
      "Ma ",
      "Xia ",
      "Xing ",
      "Xi ",
      "Gun ",
      "Cai ",
      "Chun ",
      "Jian ",
      "Mei ",
      "Du ",
      "Hou ",
      "Xuan ",
      "Ti ",
      "Kui ",
      "Gao ",
      "Rui ",
      "Mou ",
      "Xu ",
      "Fa ",
      "Wen ",
      "Miao ",
      "Chou ",
      "Kui ",
      "Mi ",
      "Weng ",
      "Kou ",
      "Dang ",
      "Chen ",
      "Ke ",
      "Sou ",
      "Xia ",
      "Qiong ",
      "Mao ",
      "Ming ",
      "Man ",
      "Shui ",
      "Ze ",
      "Zhang ",
      "Yi ",
      "Diao ",
      "Ou ",
      "Mo ",
      "Shun ",
      "Cong ",
      "Lou ",
      "Chi ",
      "Man ",
      "Piao ",
      "Cheng ",
      "Ji ",
      "Meng ",
      "[?] ",
      "Run ",
      "Pie ",
      "Xi ",
      "Qiao ",
      "Pu ",
      "Zhu ",
      "Deng ",
      "Shen ",
      "Shun ",
      "Liao ",
      "Che ",
      "Xian ",
      "Kan ",
      "Ye ",
      "Xu ",
      "Tong ",
      "Mou ",
      "Lin ",
      "Kui ",
      "Xian ",
      "Ye ",
      "Ai ",
      "Hui ",
      "Zhan ",
      "Jian ",
      "Gu ",
      "Zhao ",
      "Qu ",
      "Wei ",
      "Chou ",
      "Sao ",
      "Ning ",
      "Xun ",
      "Yao ",
      "Huo ",
      "Meng ",
      "Mian ",
      "Bin ",
      "Mian ",
      "Li ",
      "Kuang ",
      "Jue ",
      "Xuan ",
      "Mian ",
      "Huo ",
      "Lu ",
      "Meng ",
      "Long ",
      "Guan ",
      "Man ",
      "Xi ",
      "Chu ",
      "Tang ",
      "Kan ",
      "Zhu ",
      "Mao ",
      "Jin ",
      "Lin ",
      "Yu ",
      "Shuo ",
      "Ce ",
      "Jue ",
      "Shi ",
      "Yi ",
      "Shen ",
      "Zhi ",
      "Hou ",
      "Shen ",
      "Ying ",
      "Ju ",
      "Zhou ",
      "Jiao ",
      "Cuo ",
      "Duan ",
      "Ai ",
      "Jiao ",
      "Zeng ",
      "Huo ",
      "Bai ",
      "Shi ",
      "Ding ",
      "Qi ",
      "Ji ",
      "Zi ",
      "Gan ",
      "Wu ",
      "Tuo ",
      "Ku ",
      "Qiang ",
      "Xi ",
      "Fan ",
      "Kuang "
    ];
  }
});

// node_modules/unidecode/data/x78.js
var require_x78 = __commonJS({
  "node_modules/unidecode/data/x78.js"(exports2, module2) {
    module2.exports = [
      "Dang ",
      "Ma ",
      "Sha ",
      "Dan ",
      "Jue ",
      "Li ",
      "Fu ",
      "Min ",
      "Nuo ",
      "Huo ",
      "Kang ",
      "Zhi ",
      "Qi ",
      "Kan ",
      "Jie ",
      "Fen ",
      "E ",
      "Ya ",
      "Pi ",
      "Zhe ",
      "Yan ",
      "Sui ",
      "Zhuan ",
      "Che ",
      "Dun ",
      "Pan ",
      "Yan ",
      "[?] ",
      "Feng ",
      "Fa ",
      "Mo ",
      "Zha ",
      "Qu ",
      "Yu ",
      "Luo ",
      "Tuo ",
      "Tuo ",
      "Di ",
      "Zhai ",
      "Zhen ",
      "Ai ",
      "Fei ",
      "Mu ",
      "Zhu ",
      "Li ",
      "Bian ",
      "Nu ",
      "Ping ",
      "Peng ",
      "Ling ",
      "Pao ",
      "Le ",
      "Po ",
      "Bo ",
      "Po ",
      "Shen ",
      "Za ",
      "Nuo ",
      "Li ",
      "Long ",
      "Tong ",
      "[?] ",
      "Li ",
      "Aragane ",
      "Chu ",
      "Keng ",
      "Quan ",
      "Zhu ",
      "Kuang ",
      "Huo ",
      "E ",
      "Nao ",
      "Jia ",
      "Lu ",
      "Wei ",
      "Ai ",
      "Luo ",
      "Ken ",
      "Xing ",
      "Yan ",
      "Tong ",
      "Peng ",
      "Xi ",
      "[?] ",
      "Hong ",
      "Shuo ",
      "Xia ",
      "Qiao ",
      "[?] ",
      "Wei ",
      "Qiao ",
      "[?] ",
      "Keng ",
      "Xiao ",
      "Que ",
      "Chan ",
      "Lang ",
      "Hong ",
      "Yu ",
      "Xiao ",
      "Xia ",
      "Mang ",
      "Long ",
      "Iong ",
      "Che ",
      "Che ",
      "E ",
      "Liu ",
      "Ying ",
      "Mang ",
      "Que ",
      "Yan ",
      "Sha ",
      "Kun ",
      "Yu ",
      "[?] ",
      "Kaki ",
      "Lu ",
      "Chen ",
      "Jian ",
      "Nue ",
      "Song ",
      "Zhuo ",
      "Keng ",
      "Peng ",
      "Yan ",
      "Zhui ",
      "Kong ",
      "Ceng ",
      "Qi ",
      "Zong ",
      "Qing ",
      "Lin ",
      "Jun ",
      "Bo ",
      "Ding ",
      "Min ",
      "Diao ",
      "Jian ",
      "He ",
      "Lu ",
      "Ai ",
      "Sui ",
      "Que ",
      "Ling ",
      "Bei ",
      "Yin ",
      "Dui ",
      "Wu ",
      "Qi ",
      "Lun ",
      "Wan ",
      "Dian ",
      "Gang ",
      "Pei ",
      "Qi ",
      "Chen ",
      "Ruan ",
      "Yan ",
      "Die ",
      "Ding ",
      "Du ",
      "Tuo ",
      "Jie ",
      "Ying ",
      "Bian ",
      "Ke ",
      "Bi ",
      "Wei ",
      "Shuo ",
      "Zhen ",
      "Duan ",
      "Xia ",
      "Dang ",
      "Ti ",
      "Nao ",
      "Peng ",
      "Jian ",
      "Di ",
      "Tan ",
      "Cha ",
      "Seki ",
      "Qi ",
      "[?] ",
      "Feng ",
      "Xuan ",
      "Que ",
      "Que ",
      "Ma ",
      "Gong ",
      "Nian ",
      "Su ",
      "E ",
      "Ci ",
      "Liu ",
      "Si ",
      "Tang ",
      "Bang ",
      "Hua ",
      "Pi ",
      "Wei ",
      "Sang ",
      "Lei ",
      "Cuo ",
      "Zhen ",
      "Xia ",
      "Qi ",
      "Lian ",
      "Pan ",
      "Wei ",
      "Yun ",
      "Dui ",
      "Zhe ",
      "Ke ",
      "La ",
      "[?] ",
      "Qing ",
      "Gun ",
      "Zhuan ",
      "Chan ",
      "Qi ",
      "Ao ",
      "Peng ",
      "Lu ",
      "Lu ",
      "Kan ",
      "Qiang ",
      "Chen ",
      "Yin ",
      "Lei ",
      "Biao ",
      "Qi ",
      "Mo ",
      "Qi ",
      "Cui ",
      "Zong ",
      "Qing ",
      "Chuo ",
      "[?] ",
      "Ji ",
      "Shan ",
      "Lao ",
      "Qu ",
      "Zeng ",
      "Deng ",
      "Jian ",
      "Xi ",
      "Lin ",
      "Ding ",
      "Dian ",
      "Huang ",
      "Pan ",
      "Za ",
      "Qiao ",
      "Di ",
      "Li "
    ];
  }
});

// node_modules/unidecode/data/x79.js
var require_x79 = __commonJS({
  "node_modules/unidecode/data/x79.js"(exports2, module2) {
    module2.exports = [
      "Tani ",
      "Jiao ",
      "[?] ",
      "Zhang ",
      "Qiao ",
      "Dun ",
      "Xian ",
      "Yu ",
      "Zhui ",
      "He ",
      "Huo ",
      "Zhai ",
      "Lei ",
      "Ke ",
      "Chu ",
      "Ji ",
      "Que ",
      "Dang ",
      "Yi ",
      "Jiang ",
      "Pi ",
      "Pi ",
      "Yu ",
      "Pin ",
      "Qi ",
      "Ai ",
      "Kai ",
      "Jian ",
      "Yu ",
      "Ruan ",
      "Meng ",
      "Pao ",
      "Ci ",
      "[?] ",
      "[?] ",
      "Mie ",
      "Ca ",
      "Xian ",
      "Kuang ",
      "Lei ",
      "Lei ",
      "Zhi ",
      "Li ",
      "Li ",
      "Fan ",
      "Que ",
      "Pao ",
      "Ying ",
      "Li ",
      "Long ",
      "Long ",
      "Mo ",
      "Bo ",
      "Shuang ",
      "Guan ",
      "Lan ",
      "Zan ",
      "Yan ",
      "Shi ",
      "Shi ",
      "Li ",
      "Reng ",
      "She ",
      "Yue ",
      "Si ",
      "Qi ",
      "Ta ",
      "Ma ",
      "Xie ",
      "Xian ",
      "Xian ",
      "Zhi ",
      "Qi ",
      "Zhi ",
      "Beng ",
      "Dui ",
      "Zhong ",
      "[?] ",
      "Yi ",
      "Shi ",
      "You ",
      "Zhi ",
      "Tiao ",
      "Fu ",
      "Fu ",
      "Mi ",
      "Zu ",
      "Zhi ",
      "Suan ",
      "Mei ",
      "Zuo ",
      "Qu ",
      "Hu ",
      "Zhu ",
      "Shen ",
      "Sui ",
      "Ci ",
      "Chai ",
      "Mi ",
      "Lu ",
      "Yu ",
      "Xiang ",
      "Wu ",
      "Tiao ",
      "Piao ",
      "Zhu ",
      "Gui ",
      "Xia ",
      "Zhi ",
      "Ji ",
      "Gao ",
      "Zhen ",
      "Gao ",
      "Shui ",
      "Jin ",
      "Chen ",
      "Gai ",
      "Kun ",
      "Di ",
      "Dao ",
      "Huo ",
      "Tao ",
      "Qi ",
      "Gu ",
      "Guan ",
      "Zui ",
      "Ling ",
      "Lu ",
      "Bing ",
      "Jin ",
      "Dao ",
      "Zhi ",
      "Lu ",
      "Shan ",
      "Bei ",
      "Zhe ",
      "Hui ",
      "You ",
      "Xi ",
      "Yin ",
      "Zi ",
      "Huo ",
      "Zhen ",
      "Fu ",
      "Yuan ",
      "Wu ",
      "Xian ",
      "Yang ",
      "Ti ",
      "Yi ",
      "Mei ",
      "Si ",
      "Di ",
      "[?] ",
      "Zhuo ",
      "Zhen ",
      "Yong ",
      "Ji ",
      "Gao ",
      "Tang ",
      "Si ",
      "Ma ",
      "Ta ",
      "[?] ",
      "Xuan ",
      "Qi ",
      "Yu ",
      "Xi ",
      "Ji ",
      "Si ",
      "Chan ",
      "Tan ",
      "Kuai ",
      "Sui ",
      "Li ",
      "Nong ",
      "Ni ",
      "Dao ",
      "Li ",
      "Rang ",
      "Yue ",
      "Ti ",
      "Zan ",
      "Lei ",
      "Rou ",
      "Yu ",
      "Yu ",
      "Chi ",
      "Xie ",
      "Qin ",
      "He ",
      "Tu ",
      "Xiu ",
      "Si ",
      "Ren ",
      "Tu ",
      "Zi ",
      "Cha ",
      "Gan ",
      "Yi ",
      "Xian ",
      "Bing ",
      "Nian ",
      "Qiu ",
      "Qiu ",
      "Chong ",
      "Fen ",
      "Hao ",
      "Yun ",
      "Ke ",
      "Miao ",
      "Zhi ",
      "Geng ",
      "Bi ",
      "Zhi ",
      "Yu ",
      "Mi ",
      "Ku ",
      "Ban ",
      "Pi ",
      "Ni ",
      "Li ",
      "You ",
      "Zu ",
      "Pi ",
      "Ba ",
      "Ling ",
      "Mo ",
      "Cheng ",
      "Nian ",
      "Qin ",
      "Yang ",
      "Zuo ",
      "Zhi ",
      "Zhi ",
      "Shu ",
      "Ju ",
      "Zi ",
      "Huo ",
      "Ji ",
      "Cheng ",
      "Tong ",
      "Zhi ",
      "Huo ",
      "He ",
      "Yin ",
      "Zi ",
      "Zhi ",
      "Jie ",
      "Ren ",
      "Du ",
      "Yi ",
      "Zhu ",
      "Hui ",
      "Nong ",
      "Fu "
    ];
  }
});

// node_modules/unidecode/data/x7a.js
var require_x7a = __commonJS({
  "node_modules/unidecode/data/x7a.js"(exports2, module2) {
    module2.exports = [
      "Xi ",
      "Kao ",
      "Lang ",
      "Fu ",
      "Ze ",
      "Shui ",
      "Lu ",
      "Kun ",
      "Gan ",
      "Geng ",
      "Ti ",
      "Cheng ",
      "Tu ",
      "Shao ",
      "Shui ",
      "Ya ",
      "Lun ",
      "Lu ",
      "Gu ",
      "Zuo ",
      "Ren ",
      "Zhun ",
      "Bang ",
      "Bai ",
      "Ji ",
      "Zhi ",
      "Zhi ",
      "Kun ",
      "Leng ",
      "Peng ",
      "Ke ",
      "Bing ",
      "Chou ",
      "Zu ",
      "Yu ",
      "Su ",
      "Lue ",
      "[?] ",
      "Yi ",
      "Xi ",
      "Bian ",
      "Ji ",
      "Fu ",
      "Bi ",
      "Nuo ",
      "Jie ",
      "Zhong ",
      "Zong ",
      "Xu ",
      "Cheng ",
      "Dao ",
      "Wen ",
      "Lian ",
      "Zi ",
      "Yu ",
      "Ji ",
      "Xu ",
      "Zhen ",
      "Zhi ",
      "Dao ",
      "Jia ",
      "Ji ",
      "Gao ",
      "Gao ",
      "Gu ",
      "Rong ",
      "Sui ",
      "You ",
      "Ji ",
      "Kang ",
      "Mu ",
      "Shan ",
      "Men ",
      "Zhi ",
      "Ji ",
      "Lu ",
      "Su ",
      "Ji ",
      "Ying ",
      "Wen ",
      "Qiu ",
      "Se ",
      "[?] ",
      "Yi ",
      "Huang ",
      "Qie ",
      "Ji ",
      "Sui ",
      "Xiao ",
      "Pu ",
      "Jiao ",
      "Zhuo ",
      "Tong ",
      "Sai ",
      "Lu ",
      "Sui ",
      "Nong ",
      "Se ",
      "Hui ",
      "Rang ",
      "Nuo ",
      "Yu ",
      "Bin ",
      "Ji ",
      "Tui ",
      "Wen ",
      "Cheng ",
      "Huo ",
      "Gong ",
      "Lu ",
      "Biao ",
      "[?] ",
      "Rang ",
      "Zhuo ",
      "Li ",
      "Zan ",
      "Xue ",
      "Wa ",
      "Jiu ",
      "Qiong ",
      "Xi ",
      "Qiong ",
      "Kong ",
      "Yu ",
      "Sen ",
      "Jing ",
      "Yao ",
      "Chuan ",
      "Zhun ",
      "Tu ",
      "Lao ",
      "Qie ",
      "Zhai ",
      "Yao ",
      "Bian ",
      "Bao ",
      "Yao ",
      "Bing ",
      "Wa ",
      "Zhu ",
      "Jiao ",
      "Qiao ",
      "Diao ",
      "Wu ",
      "Gui ",
      "Yao ",
      "Zhi ",
      "Chuang ",
      "Yao ",
      "Tiao ",
      "Jiao ",
      "Chuang ",
      "Jiong ",
      "Xiao ",
      "Cheng ",
      "Kou ",
      "Cuan ",
      "Wo ",
      "Dan ",
      "Ku ",
      "Ke ",
      "Zhui ",
      "Xu ",
      "Su ",
      "Guan ",
      "Kui ",
      "Dou ",
      "[?] ",
      "Yin ",
      "Wo ",
      "Wa ",
      "Ya ",
      "Yu ",
      "Ju ",
      "Qiong ",
      "Yao ",
      "Yao ",
      "Tiao ",
      "Chao ",
      "Yu ",
      "Tian ",
      "Diao ",
      "Ju ",
      "Liao ",
      "Xi ",
      "Wu ",
      "Kui ",
      "Chuang ",
      "Zhao ",
      "[?] ",
      "Kuan ",
      "Long ",
      "Cheng ",
      "Cui ",
      "Piao ",
      "Zao ",
      "Cuan ",
      "Qiao ",
      "Qiong ",
      "Dou ",
      "Zao ",
      "Long ",
      "Qie ",
      "Li ",
      "Chu ",
      "Shi ",
      "Fou ",
      "Qian ",
      "Chu ",
      "Hong ",
      "Qi ",
      "Qian ",
      "Gong ",
      "Shi ",
      "Shu ",
      "Miao ",
      "Ju ",
      "Zhan ",
      "Zhu ",
      "Ling ",
      "Long ",
      "Bing ",
      "Jing ",
      "Jing ",
      "Zhang ",
      "Yi ",
      "Si ",
      "Jun ",
      "Hong ",
      "Tong ",
      "Song ",
      "Jing ",
      "Diao ",
      "Yi ",
      "Shu ",
      "Jing ",
      "Qu ",
      "Jie ",
      "Ping ",
      "Duan ",
      "Shao ",
      "Zhuan ",
      "Ceng ",
      "Deng ",
      "Cui ",
      "Huai ",
      "Jing ",
      "Kan ",
      "Jing ",
      "Zhu ",
      "Zhu ",
      "Le ",
      "Peng ",
      "Yu ",
      "Chi ",
      "Gan "
    ];
  }
});

// node_modules/unidecode/data/x7b.js
var require_x7b = __commonJS({
  "node_modules/unidecode/data/x7b.js"(exports2, module2) {
    module2.exports = [
      "Mang ",
      "Zhu ",
      "Utsubo ",
      "Du ",
      "Ji ",
      "Xiao ",
      "Ba ",
      "Suan ",
      "Ji ",
      "Zhen ",
      "Zhao ",
      "Sun ",
      "Ya ",
      "Zhui ",
      "Yuan ",
      "Hu ",
      "Gang ",
      "Xiao ",
      "Cen ",
      "Pi ",
      "Bi ",
      "Jian ",
      "Yi ",
      "Dong ",
      "Shan ",
      "Sheng ",
      "Xia ",
      "Di ",
      "Zhu ",
      "Na ",
      "Chi ",
      "Gu ",
      "Li ",
      "Qie ",
      "Min ",
      "Bao ",
      "Tiao ",
      "Si ",
      "Fu ",
      "Ce ",
      "Ben ",
      "Pei ",
      "Da ",
      "Zi ",
      "Di ",
      "Ling ",
      "Ze ",
      "Nu ",
      "Fu ",
      "Gou ",
      "Fan ",
      "Jia ",
      "Ge ",
      "Fan ",
      "Shi ",
      "Mao ",
      "Po ",
      "Sey ",
      "Jian ",
      "Qiong ",
      "Long ",
      "Souke ",
      "Bian ",
      "Luo ",
      "Gui ",
      "Qu ",
      "Chi ",
      "Yin ",
      "Yao ",
      "Xian ",
      "Bi ",
      "Qiong ",
      "Gua ",
      "Deng ",
      "Jiao ",
      "Jin ",
      "Quan ",
      "Sun ",
      "Ru ",
      "Fa ",
      "Kuang ",
      "Zhu ",
      "Tong ",
      "Ji ",
      "Da ",
      "Xing ",
      "Ce ",
      "Zhong ",
      "Kou ",
      "Lai ",
      "Bi ",
      "Shai ",
      "Dang ",
      "Zheng ",
      "Ce ",
      "Fu ",
      "Yun ",
      "Tu ",
      "Pa ",
      "Li ",
      "Lang ",
      "Ju ",
      "Guan ",
      "Jian ",
      "Han ",
      "Tong ",
      "Xia ",
      "Zhi ",
      "Cheng ",
      "Suan ",
      "Shi ",
      "Zhu ",
      "Zuo ",
      "Xiao ",
      "Shao ",
      "Ting ",
      "Ce ",
      "Yan ",
      "Gao ",
      "Kuai ",
      "Gan ",
      "Chou ",
      "Kago ",
      "Gang ",
      "Yun ",
      "O ",
      "Qian ",
      "Xiao ",
      "Jian ",
      "Pu ",
      "Lai ",
      "Zou ",
      "Bi ",
      "Bi ",
      "Bi ",
      "Ge ",
      "Chi ",
      "Guai ",
      "Yu ",
      "Jian ",
      "Zhao ",
      "Gu ",
      "Chi ",
      "Zheng ",
      "Jing ",
      "Sha ",
      "Zhou ",
      "Lu ",
      "Bo ",
      "Ji ",
      "Lin ",
      "Suan ",
      "Jun ",
      "Fu ",
      "Zha ",
      "Gu ",
      "Kong ",
      "Qian ",
      "Quan ",
      "Jun ",
      "Chui ",
      "Guan ",
      "Yuan ",
      "Ce ",
      "Ju ",
      "Bo ",
      "Ze ",
      "Qie ",
      "Tuo ",
      "Luo ",
      "Dan ",
      "Xiao ",
      "Ruo ",
      "Jian ",
      "Xuan ",
      "Bian ",
      "Sun ",
      "Xiang ",
      "Xian ",
      "Ping ",
      "Zhen ",
      "Sheng ",
      "Hu ",
      "Shi ",
      "Zhu ",
      "Yue ",
      "Chun ",
      "Lu ",
      "Wu ",
      "Dong ",
      "Xiao ",
      "Ji ",
      "Jie ",
      "Huang ",
      "Xing ",
      "Mei ",
      "Fan ",
      "Chui ",
      "Zhuan ",
      "Pian ",
      "Feng ",
      "Zhu ",
      "Hong ",
      "Qie ",
      "Hou ",
      "Qiu ",
      "Miao ",
      "Qian ",
      "[?] ",
      "Kui ",
      "Sik ",
      "Lou ",
      "Yun ",
      "He ",
      "Tang ",
      "Yue ",
      "Chou ",
      "Gao ",
      "Fei ",
      "Ruo ",
      "Zheng ",
      "Gou ",
      "Nie ",
      "Qian ",
      "Xiao ",
      "Cuan ",
      "Gong ",
      "Pang ",
      "Du ",
      "Li ",
      "Bi ",
      "Zhuo ",
      "Chu ",
      "Shai ",
      "Chi ",
      "Zhu ",
      "Qiang ",
      "Long ",
      "Lan ",
      "Jian ",
      "Bu ",
      "Li ",
      "Hui ",
      "Bi ",
      "Di ",
      "Cong ",
      "Yan ",
      "Peng ",
      "Sen ",
      "Zhuan ",
      "Pai ",
      "Piao ",
      "Dou ",
      "Yu ",
      "Mie ",
      "Zhuan "
    ];
  }
});

// node_modules/unidecode/data/x7c.js
var require_x7c = __commonJS({
  "node_modules/unidecode/data/x7c.js"(exports2, module2) {
    module2.exports = [
      "Ze ",
      "Xi ",
      "Guo ",
      "Yi ",
      "Hu ",
      "Chan ",
      "Kou ",
      "Cu ",
      "Ping ",
      "Chou ",
      "Ji ",
      "Gui ",
      "Su ",
      "Lou ",
      "Zha ",
      "Lu ",
      "Nian ",
      "Suo ",
      "Cuan ",
      "Sasara ",
      "Suo ",
      "Le ",
      "Duan ",
      "Yana ",
      "Xiao ",
      "Bo ",
      "Mi ",
      "Si ",
      "Dang ",
      "Liao ",
      "Dan ",
      "Dian ",
      "Fu ",
      "Jian ",
      "Min ",
      "Kui ",
      "Dai ",
      "Qiao ",
      "Deng ",
      "Huang ",
      "Sun ",
      "Lao ",
      "Zan ",
      "Xiao ",
      "Du ",
      "Shi ",
      "Zan ",
      "[?] ",
      "Pai ",
      "Hata ",
      "Pai ",
      "Gan ",
      "Ju ",
      "Du ",
      "Lu ",
      "Yan ",
      "Bo ",
      "Dang ",
      "Sai ",
      "Ke ",
      "Long ",
      "Qian ",
      "Lian ",
      "Bo ",
      "Zhou ",
      "Lai ",
      "[?] ",
      "Lan ",
      "Kui ",
      "Yu ",
      "Yue ",
      "Hao ",
      "Zhen ",
      "Tai ",
      "Ti ",
      "Mi ",
      "Chou ",
      "Ji ",
      "[?] ",
      "Hata ",
      "Teng ",
      "Zhuan ",
      "Zhou ",
      "Fan ",
      "Sou ",
      "Zhou ",
      "Kuji ",
      "Zhuo ",
      "Teng ",
      "Lu ",
      "Lu ",
      "Jian ",
      "Tuo ",
      "Ying ",
      "Yu ",
      "Lai ",
      "Long ",
      "Shinshi ",
      "Lian ",
      "Lan ",
      "Qian ",
      "Yue ",
      "Zhong ",
      "Qu ",
      "Lian ",
      "Bian ",
      "Duan ",
      "Zuan ",
      "Li ",
      "Si ",
      "Luo ",
      "Ying ",
      "Yue ",
      "Zhuo ",
      "Xu ",
      "Mi ",
      "Di ",
      "Fan ",
      "Shen ",
      "Zhe ",
      "Shen ",
      "Nu ",
      "Xie ",
      "Lei ",
      "Xian ",
      "Zi ",
      "Ni ",
      "Cun ",
      "[?] ",
      "Qian ",
      "Kume ",
      "Bi ",
      "Ban ",
      "Wu ",
      "Sha ",
      "Kang ",
      "Rou ",
      "Fen ",
      "Bi ",
      "Cui ",
      "[?] ",
      "Li ",
      "Chi ",
      "Nukamiso ",
      "Ro ",
      "Ba ",
      "Li ",
      "Gan ",
      "Ju ",
      "Po ",
      "Mo ",
      "Cu ",
      "Nian ",
      "Zhou ",
      "Li ",
      "Su ",
      "Tiao ",
      "Li ",
      "Qi ",
      "Su ",
      "Hong ",
      "Tong ",
      "Zi ",
      "Ce ",
      "Yue ",
      "Zhou ",
      "Lin ",
      "Zhuang ",
      "Bai ",
      "[?] ",
      "Fen ",
      "Ji ",
      "[?] ",
      "Sukumo ",
      "Liang ",
      "Xian ",
      "Fu ",
      "Liang ",
      "Can ",
      "Geng ",
      "Li ",
      "Yue ",
      "Lu ",
      "Ju ",
      "Qi ",
      "Cui ",
      "Bai ",
      "Zhang ",
      "Lin ",
      "Zong ",
      "Jing ",
      "Guo ",
      "Kouji ",
      "San ",
      "San ",
      "Tang ",
      "Bian ",
      "Rou ",
      "Mian ",
      "Hou ",
      "Xu ",
      "Zong ",
      "Hu ",
      "Jian ",
      "Zan ",
      "Ci ",
      "Li ",
      "Xie ",
      "Fu ",
      "Ni ",
      "Bei ",
      "Gu ",
      "Xiu ",
      "Gao ",
      "Tang ",
      "Qiu ",
      "Sukumo ",
      "Cao ",
      "Zhuang ",
      "Tang ",
      "Mi ",
      "San ",
      "Fen ",
      "Zao ",
      "Kang ",
      "Jiang ",
      "Mo ",
      "San ",
      "San ",
      "Nuo ",
      "Xi ",
      "Liang ",
      "Jiang ",
      "Kuai ",
      "Bo ",
      "Huan ",
      "[?] ",
      "Zong ",
      "Xian ",
      "Nuo ",
      "Tuan ",
      "Nie ",
      "Li ",
      "Zuo ",
      "Di ",
      "Nie ",
      "Tiao ",
      "Lan ",
      "Mi ",
      "Jiao ",
      "Jiu ",
      "Xi ",
      "Gong ",
      "Zheng ",
      "Jiu ",
      "You "
    ];
  }
});

// node_modules/unidecode/data/x7d.js
var require_x7d = __commonJS({
  "node_modules/unidecode/data/x7d.js"(exports2, module2) {
    module2.exports = [
      "Ji ",
      "Cha ",
      "Zhou ",
      "Xun ",
      "Yue ",
      "Hong ",
      "Yu ",
      "He ",
      "Wan ",
      "Ren ",
      "Wen ",
      "Wen ",
      "Qiu ",
      "Na ",
      "Zi ",
      "Tou ",
      "Niu ",
      "Fou ",
      "Jie ",
      "Shu ",
      "Chun ",
      "Pi ",
      "Yin ",
      "Sha ",
      "Hong ",
      "Zhi ",
      "Ji ",
      "Fen ",
      "Yun ",
      "Ren ",
      "Dan ",
      "Jin ",
      "Su ",
      "Fang ",
      "Suo ",
      "Cui ",
      "Jiu ",
      "Zha ",
      "Kinu ",
      "Jin ",
      "Fu ",
      "Zhi ",
      "Ci ",
      "Zi ",
      "Chou ",
      "Hong ",
      "Zha ",
      "Lei ",
      "Xi ",
      "Fu ",
      "Xie ",
      "Shen ",
      "Bei ",
      "Zhu ",
      "Qu ",
      "Ling ",
      "Zhu ",
      "Shao ",
      "Gan ",
      "Yang ",
      "Fu ",
      "Tuo ",
      "Zhen ",
      "Dai ",
      "Zhuo ",
      "Shi ",
      "Zhong ",
      "Xian ",
      "Zu ",
      "Jiong ",
      "Ban ",
      "Ju ",
      "Mo ",
      "Shu ",
      "Zui ",
      "Wata ",
      "Jing ",
      "Ren ",
      "Heng ",
      "Xie ",
      "Jie ",
      "Zhu ",
      "Chou ",
      "Gua ",
      "Bai ",
      "Jue ",
      "Kuang ",
      "Hu ",
      "Ci ",
      "Geng ",
      "Geng ",
      "Tao ",
      "Xie ",
      "Ku ",
      "Jiao ",
      "Quan ",
      "Gai ",
      "Luo ",
      "Xuan ",
      "Bing ",
      "Xian ",
      "Fu ",
      "Gei ",
      "Tong ",
      "Rong ",
      "Tiao ",
      "Yin ",
      "Lei ",
      "Xie ",
      "Quan ",
      "Xu ",
      "Lun ",
      "Die ",
      "Tong ",
      "Si ",
      "Jiang ",
      "Xiang ",
      "Hui ",
      "Jue ",
      "Zhi ",
      "Jian ",
      "Juan ",
      "Chi ",
      "Mian ",
      "Zhen ",
      "Lu ",
      "Cheng ",
      "Qiu ",
      "Shu ",
      "Bang ",
      "Tong ",
      "Xiao ",
      "Wan ",
      "Qin ",
      "Geng ",
      "Xiu ",
      "Ti ",
      "Xiu ",
      "Xie ",
      "Hong ",
      "Xi ",
      "Fu ",
      "Ting ",
      "Sui ",
      "Dui ",
      "Kun ",
      "Fu ",
      "Jing ",
      "Hu ",
      "Zhi ",
      "Yan ",
      "Jiong ",
      "Feng ",
      "Ji ",
      "Sok ",
      "Kase ",
      "Zong ",
      "Lin ",
      "Duo ",
      "Li ",
      "Lu ",
      "Liang ",
      "Chou ",
      "Quan ",
      "Shao ",
      "Qi ",
      "Qi ",
      "Zhun ",
      "Qi ",
      "Wan ",
      "Qian ",
      "Xian ",
      "Shou ",
      "Wei ",
      "Qi ",
      "Tao ",
      "Wan ",
      "Gang ",
      "Wang ",
      "Beng ",
      "Zhui ",
      "Cai ",
      "Guo ",
      "Cui ",
      "Lun ",
      "Liu ",
      "Qi ",
      "Zhan ",
      "Bei ",
      "Chuo ",
      "Ling ",
      "Mian ",
      "Qi ",
      "Qie ",
      "Tan ",
      "Zong ",
      "Gun ",
      "Zou ",
      "Yi ",
      "Zi ",
      "Xing ",
      "Liang ",
      "Jin ",
      "Fei ",
      "Rui ",
      "Min ",
      "Yu ",
      "Zong ",
      "Fan ",
      "Lu ",
      "Xu ",
      "Yingl ",
      "Zhang ",
      "Kasuri ",
      "Xu ",
      "Xiang ",
      "Jian ",
      "Ke ",
      "Xian ",
      "Ruan ",
      "Mian ",
      "Qi ",
      "Duan ",
      "Zhong ",
      "Di ",
      "Min ",
      "Miao ",
      "Yuan ",
      "Xie ",
      "Bao ",
      "Si ",
      "Qiu ",
      "Bian ",
      "Huan ",
      "Geng ",
      "Cong ",
      "Mian ",
      "Wei ",
      "Fu ",
      "Wei ",
      "Yu ",
      "Gou ",
      "Miao ",
      "Xie ",
      "Lian ",
      "Zong ",
      "Bian ",
      "Yun ",
      "Yin ",
      "Ti ",
      "Gua ",
      "Zhi ",
      "Yun ",
      "Cheng ",
      "Chan ",
      "Dai "
    ];
  }
});

// node_modules/unidecode/data/x7e.js
var require_x7e = __commonJS({
  "node_modules/unidecode/data/x7e.js"(exports2, module2) {
    module2.exports = [
      "Xia ",
      "Yuan ",
      "Zong ",
      "Xu ",
      "Nawa ",
      "Odoshi ",
      "Geng ",
      "Sen ",
      "Ying ",
      "Jin ",
      "Yi ",
      "Zhui ",
      "Ni ",
      "Bang ",
      "Gu ",
      "Pan ",
      "Zhou ",
      "Jian ",
      "Cuo ",
      "Quan ",
      "Shuang ",
      "Yun ",
      "Xia ",
      "Shuai ",
      "Xi ",
      "Rong ",
      "Tao ",
      "Fu ",
      "Yun ",
      "Zhen ",
      "Gao ",
      "Ru ",
      "Hu ",
      "Zai ",
      "Teng ",
      "Xian ",
      "Su ",
      "Zhen ",
      "Zong ",
      "Tao ",
      "Horo ",
      "Cai ",
      "Bi ",
      "Feng ",
      "Cu ",
      "Li ",
      "Suo ",
      "Yin ",
      "Xi ",
      "Zong ",
      "Lei ",
      "Zhuan ",
      "Qian ",
      "Man ",
      "Zhi ",
      "Lu ",
      "Mo ",
      "Piao ",
      "Lian ",
      "Mi ",
      "Xuan ",
      "Zong ",
      "Ji ",
      "Shan ",
      "Sui ",
      "Fan ",
      "Shuai ",
      "Beng ",
      "Yi ",
      "Sao ",
      "Mou ",
      "Zhou ",
      "Qiang ",
      "Hun ",
      "Sem ",
      "Xi ",
      "Jung ",
      "Xiu ",
      "Ran ",
      "Xuan ",
      "Hui ",
      "Qiao ",
      "Zeng ",
      "Zuo ",
      "Zhi ",
      "Shan ",
      "San ",
      "Lin ",
      "Yu ",
      "Fan ",
      "Liao ",
      "Chuo ",
      "Zun ",
      "Jian ",
      "Rao ",
      "Chan ",
      "Rui ",
      "Xiu ",
      "Hui ",
      "Hua ",
      "Zuan ",
      "Xi ",
      "Qiang ",
      "Un ",
      "Da ",
      "Sheng ",
      "Hui ",
      "Xi ",
      "Se ",
      "Jian ",
      "Jiang ",
      "Huan ",
      "Zao ",
      "Cong ",
      "Jie ",
      "Jiao ",
      "Bo ",
      "Chan ",
      "Yi ",
      "Nao ",
      "Sui ",
      "Yi ",
      "Shai ",
      "Xu ",
      "Ji ",
      "Bin ",
      "Qian ",
      "Lan ",
      "Pu ",
      "Xun ",
      "Zuan ",
      "Qi ",
      "Peng ",
      "Li ",
      "Mo ",
      "Lei ",
      "Xie ",
      "Zuan ",
      "Kuang ",
      "You ",
      "Xu ",
      "Lei ",
      "Xian ",
      "Chan ",
      "Kou ",
      "Lu ",
      "Chan ",
      "Ying ",
      "Cai ",
      "Xiang ",
      "Xian ",
      "Zui ",
      "Zuan ",
      "Luo ",
      "Xi ",
      "Dao ",
      "Lan ",
      "Lei ",
      "Lian ",
      "Si ",
      "Jiu ",
      "Yu ",
      "Hong ",
      "Zhou ",
      "Xian ",
      "He ",
      "Yue ",
      "Ji ",
      "Wan ",
      "Kuang ",
      "Ji ",
      "Ren ",
      "Wei ",
      "Yun ",
      "Hong ",
      "Chun ",
      "Pi ",
      "Sha ",
      "Gang ",
      "Na ",
      "Ren ",
      "Zong ",
      "Lun ",
      "Fen ",
      "Zhi ",
      "Wen ",
      "Fang ",
      "Zhu ",
      "Yin ",
      "Niu ",
      "Shu ",
      "Xian ",
      "Gan ",
      "Xie ",
      "Fu ",
      "Lian ",
      "Zu ",
      "Shen ",
      "Xi ",
      "Zhi ",
      "Zhong ",
      "Zhou ",
      "Ban ",
      "Fu ",
      "Zhuo ",
      "Shao ",
      "Yi ",
      "Jing ",
      "Dai ",
      "Bang ",
      "Rong ",
      "Jie ",
      "Ku ",
      "Rao ",
      "Die ",
      "Heng ",
      "Hui ",
      "Gei ",
      "Xuan ",
      "Jiang ",
      "Luo ",
      "Jue ",
      "Jiao ",
      "Tong ",
      "Geng ",
      "Xiao ",
      "Juan ",
      "Xiu ",
      "Xi ",
      "Sui ",
      "Tao ",
      "Ji ",
      "Ti ",
      "Ji ",
      "Xu ",
      "Ling ",
      "[?] ",
      "Xu ",
      "Qi ",
      "Fei ",
      "Chuo ",
      "Zhang ",
      "Gun ",
      "Sheng ",
      "Wei ",
      "Mian ",
      "Shou ",
      "Beng ",
      "Chou ",
      "Tao ",
      "Liu ",
      "Quan ",
      "Zong ",
      "Zhan ",
      "Wan ",
      "Lu "
    ];
  }
});

// node_modules/unidecode/data/x7f.js
var require_x7f = __commonJS({
  "node_modules/unidecode/data/x7f.js"(exports2, module2) {
    module2.exports = [
      "Zhui ",
      "Zi ",
      "Ke ",
      "Xiang ",
      "Jian ",
      "Mian ",
      "Lan ",
      "Ti ",
      "Miao ",
      "Qi ",
      "Yun ",
      "Hui ",
      "Si ",
      "Duo ",
      "Duan ",
      "Bian ",
      "Xian ",
      "Gou ",
      "Zhui ",
      "Huan ",
      "Di ",
      "Lu ",
      "Bian ",
      "Min ",
      "Yuan ",
      "Jin ",
      "Fu ",
      "Ru ",
      "Zhen ",
      "Feng ",
      "Shuai ",
      "Gao ",
      "Chan ",
      "Li ",
      "Yi ",
      "Jian ",
      "Bin ",
      "Piao ",
      "Man ",
      "Lei ",
      "Ying ",
      "Suo ",
      "Mou ",
      "Sao ",
      "Xie ",
      "Liao ",
      "Shan ",
      "Zeng ",
      "Jiang ",
      "Qian ",
      "Zao ",
      "Huan ",
      "Jiao ",
      "Zuan ",
      "Fou ",
      "Xie ",
      "Gang ",
      "Fou ",
      "Que ",
      "Fou ",
      "Kaakeru ",
      "Bo ",
      "Ping ",
      "Hou ",
      "[?] ",
      "Gang ",
      "Ying ",
      "Ying ",
      "Qing ",
      "Xia ",
      "Guan ",
      "Zun ",
      "Tan ",
      "Chang ",
      "Qi ",
      "Weng ",
      "Ying ",
      "Lei ",
      "Tan ",
      "Lu ",
      "Guan ",
      "Wang ",
      "Wang ",
      "Gang ",
      "Wang ",
      "Han ",
      "[?] ",
      "Luo ",
      "Fu ",
      "Mi ",
      "Fa ",
      "Gu ",
      "Zhu ",
      "Ju ",
      "Mao ",
      "Gu ",
      "Min ",
      "Gang ",
      "Ba ",
      "Gua ",
      "Ti ",
      "Juan ",
      "Fu ",
      "Lin ",
      "Yan ",
      "Zhao ",
      "Zui ",
      "Gua ",
      "Zhuo ",
      "Yu ",
      "Zhi ",
      "An ",
      "Fa ",
      "Nan ",
      "Shu ",
      "Si ",
      "Pi ",
      "Ma ",
      "Liu ",
      "Ba ",
      "Fa ",
      "Li ",
      "Chao ",
      "Wei ",
      "Bi ",
      "Ji ",
      "Zeng ",
      "Tong ",
      "Liu ",
      "Ji ",
      "Juan ",
      "Mi ",
      "Zhao ",
      "Luo ",
      "Pi ",
      "Ji ",
      "Ji ",
      "Luan ",
      "Yang ",
      "Mie ",
      "Qiang ",
      "Ta ",
      "Mei ",
      "Yang ",
      "You ",
      "You ",
      "Fen ",
      "Ba ",
      "Gao ",
      "Yang ",
      "Gu ",
      "Qiang ",
      "Zang ",
      "Gao ",
      "Ling ",
      "Yi ",
      "Zhu ",
      "Di ",
      "Xiu ",
      "Qian ",
      "Yi ",
      "Xian ",
      "Rong ",
      "Qun ",
      "Qun ",
      "Qian ",
      "Huan ",
      "Zui ",
      "Xian ",
      "Yi ",
      "Yashinau ",
      "Qiang ",
      "Xian ",
      "Yu ",
      "Geng ",
      "Jie ",
      "Tang ",
      "Yuan ",
      "Xi ",
      "Fan ",
      "Shan ",
      "Fen ",
      "Shan ",
      "Lian ",
      "Lei ",
      "Geng ",
      "Nou ",
      "Qiang ",
      "Chan ",
      "Yu ",
      "Gong ",
      "Yi ",
      "Chong ",
      "Weng ",
      "Fen ",
      "Hong ",
      "Chi ",
      "Chi ",
      "Cui ",
      "Fu ",
      "Xia ",
      "Pen ",
      "Yi ",
      "La ",
      "Yi ",
      "Pi ",
      "Ling ",
      "Liu ",
      "Zhi ",
      "Qu ",
      "Xi ",
      "Xie ",
      "Xiang ",
      "Xi ",
      "Xi ",
      "Qi ",
      "Qiao ",
      "Hui ",
      "Hui ",
      "Xiao ",
      "Se ",
      "Hong ",
      "Jiang ",
      "Di ",
      "Cui ",
      "Fei ",
      "Tao ",
      "Sha ",
      "Chi ",
      "Zhu ",
      "Jian ",
      "Xuan ",
      "Shi ",
      "Pian ",
      "Zong ",
      "Wan ",
      "Hui ",
      "Hou ",
      "He ",
      "He ",
      "Han ",
      "Ao ",
      "Piao ",
      "Yi ",
      "Lian ",
      "Qu ",
      "[?] ",
      "Lin ",
      "Pen ",
      "Qiao ",
      "Ao ",
      "Fan ",
      "Yi ",
      "Hui ",
      "Xuan ",
      "Dao "
    ];
  }
});

// node_modules/unidecode/data/x80.js
var require_x80 = __commonJS({
  "node_modules/unidecode/data/x80.js"(exports2, module2) {
    module2.exports = [
      "Yao ",
      "Lao ",
      "[?] ",
      "Kao ",
      "Mao ",
      "Zhe ",
      "Qi ",
      "Gou ",
      "Gou ",
      "Gou ",
      "Die ",
      "Die ",
      "Er ",
      "Shua ",
      "Ruan ",
      "Er ",
      "Nai ",
      "Zhuan ",
      "Lei ",
      "Ting ",
      "Zi ",
      "Geng ",
      "Chao ",
      "Hao ",
      "Yun ",
      "Pa ",
      "Pi ",
      "Chi ",
      "Si ",
      "Chu ",
      "Jia ",
      "Ju ",
      "He ",
      "Chu ",
      "Lao ",
      "Lun ",
      "Ji ",
      "Tang ",
      "Ou ",
      "Lou ",
      "Nou ",
      "Gou ",
      "Pang ",
      "Ze ",
      "Lou ",
      "Ji ",
      "Lao ",
      "Huo ",
      "You ",
      "Mo ",
      "Huai ",
      "Er ",
      "Zhe ",
      "Ting ",
      "Ye ",
      "Da ",
      "Song ",
      "Qin ",
      "Yun ",
      "Chi ",
      "Dan ",
      "Dan ",
      "Hong ",
      "Geng ",
      "Zhi ",
      "[?] ",
      "Nie ",
      "Dan ",
      "Zhen ",
      "Che ",
      "Ling ",
      "Zheng ",
      "You ",
      "Wa ",
      "Liao ",
      "Long ",
      "Zhi ",
      "Ning ",
      "Tiao ",
      "Er ",
      "Ya ",
      "Die ",
      "Gua ",
      "[?] ",
      "Lian ",
      "Hao ",
      "Sheng ",
      "Lie ",
      "Pin ",
      "Jing ",
      "Ju ",
      "Bi ",
      "Di ",
      "Guo ",
      "Wen ",
      "Xu ",
      "Ping ",
      "Cong ",
      "Shikato ",
      "[?] ",
      "Ting ",
      "Yu ",
      "Cong ",
      "Kui ",
      "Tsuraneru ",
      "Kui ",
      "Cong ",
      "Lian ",
      "Weng ",
      "Kui ",
      "Lian ",
      "Lian ",
      "Cong ",
      "Ao ",
      "Sheng ",
      "Song ",
      "Ting ",
      "Kui ",
      "Nie ",
      "Zhi ",
      "Dan ",
      "Ning ",
      "Qie ",
      "Ji ",
      "Ting ",
      "Ting ",
      "Long ",
      "Yu ",
      "Yu ",
      "Zhao ",
      "Si ",
      "Su ",
      "Yi ",
      "Su ",
      "Si ",
      "Zhao ",
      "Zhao ",
      "Rou ",
      "Yi ",
      "Le ",
      "Ji ",
      "Qiu ",
      "Ken ",
      "Cao ",
      "Ge ",
      "Di ",
      "Huan ",
      "Huang ",
      "Yi ",
      "Ren ",
      "Xiao ",
      "Ru ",
      "Zhou ",
      "Yuan ",
      "Du ",
      "Gang ",
      "Rong ",
      "Gan ",
      "Cha ",
      "Wo ",
      "Chang ",
      "Gu ",
      "Zhi ",
      "Han ",
      "Fu ",
      "Fei ",
      "Fen ",
      "Pei ",
      "Pang ",
      "Jian ",
      "Fang ",
      "Zhun ",
      "You ",
      "Na ",
      "Hang ",
      "Ken ",
      "Ran ",
      "Gong ",
      "Yu ",
      "Wen ",
      "Yao ",
      "Jin ",
      "Pi ",
      "Qian ",
      "Xi ",
      "Xi ",
      "Fei ",
      "Ken ",
      "Jing ",
      "Tai ",
      "Shen ",
      "Zhong ",
      "Zhang ",
      "Xie ",
      "Shen ",
      "Wei ",
      "Zhou ",
      "Die ",
      "Dan ",
      "Fei ",
      "Ba ",
      "Bo ",
      "Qu ",
      "Tian ",
      "Bei ",
      "Gua ",
      "Tai ",
      "Zi ",
      "Ku ",
      "Zhi ",
      "Ni ",
      "Ping ",
      "Zi ",
      "Fu ",
      "Pang ",
      "Zhen ",
      "Xian ",
      "Zuo ",
      "Pei ",
      "Jia ",
      "Sheng ",
      "Zhi ",
      "Bao ",
      "Mu ",
      "Qu ",
      "Hu ",
      "Ke ",
      "Yi ",
      "Yin ",
      "Xu ",
      "Yang ",
      "Long ",
      "Dong ",
      "Ka ",
      "Lu ",
      "Jing ",
      "Nu ",
      "Yan ",
      "Pang ",
      "Kua ",
      "Yi ",
      "Guang ",
      "Gai ",
      "Ge ",
      "Dong ",
      "Zhi ",
      "Xiao ",
      "Xiong ",
      "Xiong ",
      "Er ",
      "E ",
      "Xing ",
      "Pian ",
      "Neng ",
      "Zi ",
      "Gui "
    ];
  }
});

// node_modules/unidecode/data/x81.js
var require_x81 = __commonJS({
  "node_modules/unidecode/data/x81.js"(exports2, module2) {
    module2.exports = [
      "Cheng ",
      "Tiao ",
      "Zhi ",
      "Cui ",
      "Mei ",
      "Xie ",
      "Cui ",
      "Xie ",
      "Mo ",
      "Mai ",
      "Ji ",
      "Obiyaakasu ",
      "[?] ",
      "Kuai ",
      "Sa ",
      "Zang ",
      "Qi ",
      "Nao ",
      "Mi ",
      "Nong ",
      "Luan ",
      "Wan ",
      "Bo ",
      "Wen ",
      "Guan ",
      "Qiu ",
      "Jiao ",
      "Jing ",
      "Rou ",
      "Heng ",
      "Cuo ",
      "Lie ",
      "Shan ",
      "Ting ",
      "Mei ",
      "Chun ",
      "Shen ",
      "Xie ",
      "De ",
      "Zui ",
      "Cu ",
      "Xiu ",
      "Xin ",
      "Tuo ",
      "Pao ",
      "Cheng ",
      "Nei ",
      "Fu ",
      "Dou ",
      "Tuo ",
      "Niao ",
      "Noy ",
      "Pi ",
      "Gu ",
      "Gua ",
      "Li ",
      "Lian ",
      "Zhang ",
      "Cui ",
      "Jie ",
      "Liang ",
      "Zhou ",
      "Pi ",
      "Biao ",
      "Lun ",
      "Pian ",
      "Guo ",
      "Kui ",
      "Chui ",
      "Dan ",
      "Tian ",
      "Nei ",
      "Jing ",
      "Jie ",
      "La ",
      "Yi ",
      "An ",
      "Ren ",
      "Shen ",
      "Chuo ",
      "Fu ",
      "Fu ",
      "Ju ",
      "Fei ",
      "Qiang ",
      "Wan ",
      "Dong ",
      "Pi ",
      "Guo ",
      "Zong ",
      "Ding ",
      "Wu ",
      "Mei ",
      "Ruan ",
      "Zhuan ",
      "Zhi ",
      "Cou ",
      "Gua ",
      "Ou ",
      "Di ",
      "An ",
      "Xing ",
      "Nao ",
      "Yu ",
      "Chuan ",
      "Nan ",
      "Yun ",
      "Zhong ",
      "Rou ",
      "E ",
      "Sai ",
      "Tu ",
      "Yao ",
      "Jian ",
      "Wei ",
      "Jiao ",
      "Yu ",
      "Jia ",
      "Duan ",
      "Bi ",
      "Chang ",
      "Fu ",
      "Xian ",
      "Ni ",
      "Mian ",
      "Wa ",
      "Teng ",
      "Tui ",
      "Bang ",
      "Qian ",
      "Lu ",
      "Wa ",
      "Sou ",
      "Tang ",
      "Su ",
      "Zhui ",
      "Ge ",
      "Yi ",
      "Bo ",
      "Liao ",
      "Ji ",
      "Pi ",
      "Xie ",
      "Gao ",
      "Lu ",
      "Bin ",
      "Ou ",
      "Chang ",
      "Lu ",
      "Guo ",
      "Pang ",
      "Chuai ",
      "Piao ",
      "Jiang ",
      "Fu ",
      "Tang ",
      "Mo ",
      "Xi ",
      "Zhuan ",
      "Lu ",
      "Jiao ",
      "Ying ",
      "Lu ",
      "Zhi ",
      "Tara ",
      "Chun ",
      "Lian ",
      "Tong ",
      "Peng ",
      "Ni ",
      "Zha ",
      "Liao ",
      "Cui ",
      "Gui ",
      "Xiao ",
      "Teng ",
      "Fan ",
      "Zhi ",
      "Jiao ",
      "Shan ",
      "Wu ",
      "Cui ",
      "Run ",
      "Xiang ",
      "Sui ",
      "Fen ",
      "Ying ",
      "Tan ",
      "Zhua ",
      "Dan ",
      "Kuai ",
      "Nong ",
      "Tun ",
      "Lian ",
      "Bi ",
      "Yong ",
      "Jue ",
      "Chu ",
      "Yi ",
      "Juan ",
      "La ",
      "Lian ",
      "Sao ",
      "Tun ",
      "Gu ",
      "Qi ",
      "Cui ",
      "Bin ",
      "Xun ",
      "Ru ",
      "Huo ",
      "Zang ",
      "Xian ",
      "Biao ",
      "Xing ",
      "Kuan ",
      "La ",
      "Yan ",
      "Lu ",
      "Huo ",
      "Zang ",
      "Luo ",
      "Qu ",
      "Zang ",
      "Luan ",
      "Ni ",
      "Zang ",
      "Chen ",
      "Qian ",
      "Wo ",
      "Guang ",
      "Zang ",
      "Lin ",
      "Guang ",
      "Zi ",
      "Jiao ",
      "Nie ",
      "Chou ",
      "Ji ",
      "Gao ",
      "Chou ",
      "Mian ",
      "Nie ",
      "Zhi ",
      "Zhi ",
      "Ge ",
      "Jian ",
      "Die ",
      "Zhi ",
      "Xiu ",
      "Tai ",
      "Zhen ",
      "Jiu ",
      "Xian ",
      "Yu ",
      "Cha "
    ];
  }
});

// node_modules/unidecode/data/x82.js
var require_x82 = __commonJS({
  "node_modules/unidecode/data/x82.js"(exports2, module2) {
    module2.exports = [
      "Yao ",
      "Yu ",
      "Chong ",
      "Xi ",
      "Xi ",
      "Jiu ",
      "Yu ",
      "Yu ",
      "Xing ",
      "Ju ",
      "Jiu ",
      "Xin ",
      "She ",
      "She ",
      "Yadoru ",
      "Jiu ",
      "Shi ",
      "Tan ",
      "Shu ",
      "Shi ",
      "Tian ",
      "Dan ",
      "Pu ",
      "Pu ",
      "Guan ",
      "Hua ",
      "Tan ",
      "Chuan ",
      "Shun ",
      "Xia ",
      "Wu ",
      "Zhou ",
      "Dao ",
      "Gang ",
      "Shan ",
      "Yi ",
      "[?] ",
      "Pa ",
      "Tai ",
      "Fan ",
      "Ban ",
      "Chuan ",
      "Hang ",
      "Fang ",
      "Ban ",
      "Que ",
      "Hesaki ",
      "Zhong ",
      "Jian ",
      "Cang ",
      "Ling ",
      "Zhu ",
      "Ze ",
      "Duo ",
      "Bo ",
      "Xian ",
      "Ge ",
      "Chuan ",
      "Jia ",
      "Lu ",
      "Hong ",
      "Pang ",
      "Xi ",
      "[?] ",
      "Fu ",
      "Zao ",
      "Feng ",
      "Li ",
      "Shao ",
      "Yu ",
      "Lang ",
      "Ting ",
      "[?] ",
      "Wei ",
      "Bo ",
      "Meng ",
      "Nian ",
      "Ju ",
      "Huang ",
      "Shou ",
      "Zong ",
      "Bian ",
      "Mao ",
      "Die ",
      "[?] ",
      "Bang ",
      "Cha ",
      "Yi ",
      "Sao ",
      "Cang ",
      "Cao ",
      "Lou ",
      "Dai ",
      "Sori ",
      "Yao ",
      "Tong ",
      "Yofune ",
      "Dang ",
      "Tan ",
      "Lu ",
      "Yi ",
      "Jie ",
      "Jian ",
      "Huo ",
      "Meng ",
      "Qi ",
      "Lu ",
      "Lu ",
      "Chan ",
      "Shuang ",
      "Gen ",
      "Liang ",
      "Jian ",
      "Jian ",
      "Se ",
      "Yan ",
      "Fu ",
      "Ping ",
      "Yan ",
      "Yan ",
      "Cao ",
      "Cao ",
      "Yi ",
      "Le ",
      "Ting ",
      "Qiu ",
      "Ai ",
      "Nai ",
      "Tiao ",
      "Jiao ",
      "Jie ",
      "Peng ",
      "Wan ",
      "Yi ",
      "Chai ",
      "Mian ",
      "Mie ",
      "Gan ",
      "Qian ",
      "Yu ",
      "Yu ",
      "Shuo ",
      "Qiong ",
      "Tu ",
      "Xia ",
      "Qi ",
      "Mang ",
      "Zi ",
      "Hui ",
      "Sui ",
      "Zhi ",
      "Xiang ",
      "Bi ",
      "Fu ",
      "Tun ",
      "Wei ",
      "Wu ",
      "Zhi ",
      "Qi ",
      "Shan ",
      "Wen ",
      "Qian ",
      "Ren ",
      "Fou ",
      "Kou ",
      "Jie ",
      "Lu ",
      "Xu ",
      "Ji ",
      "Qin ",
      "Qi ",
      "Yuan ",
      "Fen ",
      "Ba ",
      "Rui ",
      "Xin ",
      "Ji ",
      "Hua ",
      "Hua ",
      "Fang ",
      "Wu ",
      "Jue ",
      "Gou ",
      "Zhi ",
      "Yun ",
      "Qin ",
      "Ao ",
      "Chu ",
      "Mao ",
      "Ya ",
      "Fei ",
      "Reng ",
      "Hang ",
      "Cong ",
      "Yin ",
      "You ",
      "Bian ",
      "Yi ",
      "Susa ",
      "Wei ",
      "Li ",
      "Pi ",
      "E ",
      "Xian ",
      "Chang ",
      "Cang ",
      "Meng ",
      "Su ",
      "Yi ",
      "Yuan ",
      "Ran ",
      "Ling ",
      "Tai ",
      "Tiao ",
      "Di ",
      "Miao ",
      "Qiong ",
      "Li ",
      "Yong ",
      "Ke ",
      "Mu ",
      "Pei ",
      "Bao ",
      "Gou ",
      "Min ",
      "Yi ",
      "Yi ",
      "Ju ",
      "Pi ",
      "Ruo ",
      "Ku ",
      "Zhu ",
      "Ni ",
      "Bo ",
      "Bing ",
      "Shan ",
      "Qiu ",
      "Yao ",
      "Xian ",
      "Ben ",
      "Hong ",
      "Ying ",
      "Zha ",
      "Dong ",
      "Ju ",
      "Die ",
      "Nie ",
      "Gan ",
      "Hu ",
      "Ping ",
      "Mei ",
      "Fu ",
      "Sheng ",
      "Gu ",
      "Bi ",
      "Wei "
    ];
  }
});

// node_modules/unidecode/data/x83.js
var require_x83 = __commonJS({
  "node_modules/unidecode/data/x83.js"(exports2, module2) {
    module2.exports = [
      "Fu ",
      "Zhuo ",
      "Mao ",
      "Fan ",
      "Qie ",
      "Mao ",
      "Mao ",
      "Ba ",
      "Zi ",
      "Mo ",
      "Zi ",
      "Di ",
      "Chi ",
      "Ji ",
      "Jing ",
      "Long ",
      "[?] ",
      "Niao ",
      "[?] ",
      "Xue ",
      "Ying ",
      "Qiong ",
      "Ge ",
      "Ming ",
      "Li ",
      "Rong ",
      "Yin ",
      "Gen ",
      "Qian ",
      "Chai ",
      "Chen ",
      "Yu ",
      "Xiu ",
      "Zi ",
      "Lie ",
      "Wu ",
      "Ji ",
      "Kui ",
      "Ce ",
      "Chong ",
      "Ci ",
      "Gou ",
      "Guang ",
      "Mang ",
      "Chi ",
      "Jiao ",
      "Jiao ",
      "Fu ",
      "Yu ",
      "Zhu ",
      "Zi ",
      "Jiang ",
      "Hui ",
      "Yin ",
      "Cha ",
      "Fa ",
      "Rong ",
      "Ru ",
      "Chong ",
      "Mang ",
      "Tong ",
      "Zhong ",
      "[?] ",
      "Zhu ",
      "Xun ",
      "Huan ",
      "Kua ",
      "Quan ",
      "Gai ",
      "Da ",
      "Jing ",
      "Xing ",
      "Quan ",
      "Cao ",
      "Jing ",
      "Er ",
      "An ",
      "Shou ",
      "Chi ",
      "Ren ",
      "Jian ",
      "Ti ",
      "Huang ",
      "Ping ",
      "Li ",
      "Jin ",
      "Lao ",
      "Shu ",
      "Zhuang ",
      "Da ",
      "Jia ",
      "Rao ",
      "Bi ",
      "Ze ",
      "Qiao ",
      "Hui ",
      "Qi ",
      "Dang ",
      "[?] ",
      "Rong ",
      "Hun ",
      "Ying ",
      "Luo ",
      "Ying ",
      "Xun ",
      "Jin ",
      "Sun ",
      "Yin ",
      "Mai ",
      "Hong ",
      "Zhou ",
      "Yao ",
      "Du ",
      "Wei ",
      "Chu ",
      "Dou ",
      "Fu ",
      "Ren ",
      "Yin ",
      "He ",
      "Bi ",
      "Bu ",
      "Yun ",
      "Di ",
      "Tu ",
      "Sui ",
      "Sui ",
      "Cheng ",
      "Chen ",
      "Wu ",
      "Bie ",
      "Xi ",
      "Geng ",
      "Li ",
      "Fu ",
      "Zhu ",
      "Mo ",
      "Li ",
      "Zhuang ",
      "Ji ",
      "Duo ",
      "Qiu ",
      "Sha ",
      "Suo ",
      "Chen ",
      "Feng ",
      "Ju ",
      "Mei ",
      "Meng ",
      "Xing ",
      "Jing ",
      "Che ",
      "Xin ",
      "Jun ",
      "Yan ",
      "Ting ",
      "Diao ",
      "Cuo ",
      "Wan ",
      "Han ",
      "You ",
      "Cuo ",
      "Jia ",
      "Wang ",
      "You ",
      "Niu ",
      "Shao ",
      "Xian ",
      "Lang ",
      "Fu ",
      "E ",
      "Mo ",
      "Wen ",
      "Jie ",
      "Nan ",
      "Mu ",
      "Kan ",
      "Lai ",
      "Lian ",
      "Shi ",
      "Wo ",
      "Usagi ",
      "Lian ",
      "Huo ",
      "You ",
      "Ying ",
      "Ying ",
      "Nuc ",
      "Chun ",
      "Mang ",
      "Mang ",
      "Ci ",
      "Wan ",
      "Jing ",
      "Di ",
      "Qu ",
      "Dong ",
      "Jian ",
      "Zou ",
      "Gu ",
      "La ",
      "Lu ",
      "Ju ",
      "Wei ",
      "Jun ",
      "Nie ",
      "Kun ",
      "He ",
      "Pu ",
      "Zi ",
      "Gao ",
      "Guo ",
      "Fu ",
      "Lun ",
      "Chang ",
      "Chou ",
      "Song ",
      "Chui ",
      "Zhan ",
      "Men ",
      "Cai ",
      "Ba ",
      "Li ",
      "Tu ",
      "Bo ",
      "Han ",
      "Bao ",
      "Qin ",
      "Juan ",
      "Xi ",
      "Qin ",
      "Di ",
      "Jie ",
      "Pu ",
      "Dang ",
      "Jin ",
      "Zhao ",
      "Tai ",
      "Geng ",
      "Hua ",
      "Gu ",
      "Ling ",
      "Fei ",
      "Jin ",
      "An ",
      "Wang ",
      "Beng ",
      "Zhou ",
      "Yan ",
      "Ju ",
      "Jian ",
      "Lin ",
      "Tan ",
      "Shu ",
      "Tian ",
      "Dao "
    ];
  }
});

// node_modules/unidecode/data/x84.js
var require_x84 = __commonJS({
  "node_modules/unidecode/data/x84.js"(exports2, module2) {
    module2.exports = [
      "Hu ",
      "Qi ",
      "He ",
      "Cui ",
      "Tao ",
      "Chun ",
      "Bei ",
      "Chang ",
      "Huan ",
      "Fei ",
      "Lai ",
      "Qi ",
      "Meng ",
      "Ping ",
      "Wei ",
      "Dan ",
      "Sha ",
      "Huan ",
      "Yan ",
      "Yi ",
      "Tiao ",
      "Qi ",
      "Wan ",
      "Ce ",
      "Nai ",
      "Kutabireru ",
      "Tuo ",
      "Jiu ",
      "Tie ",
      "Luo ",
      "[?] ",
      "[?] ",
      "Meng ",
      "[?] ",
      "Yaji ",
      "[?] ",
      "Ying ",
      "Ying ",
      "Ying ",
      "Xiao ",
      "Sa ",
      "Qiu ",
      "Ke ",
      "Xiang ",
      "Wan ",
      "Yu ",
      "Yu ",
      "Fu ",
      "Lian ",
      "Xuan ",
      "Yuan ",
      "Nan ",
      "Ze ",
      "Wo ",
      "Chun ",
      "Xiao ",
      "Yu ",
      "Pian ",
      "Mao ",
      "An ",
      "E ",
      "Luo ",
      "Ying ",
      "Huo ",
      "Gua ",
      "Jiang ",
      "Mian ",
      "Zuo ",
      "Zuo ",
      "Ju ",
      "Bao ",
      "Rou ",
      "Xi ",
      "Xie ",
      "An ",
      "Qu ",
      "Jian ",
      "Fu ",
      "Lu ",
      "Jing ",
      "Pen ",
      "Feng ",
      "Hong ",
      "Hong ",
      "Hou ",
      "Yan ",
      "Tu ",
      "Zhu ",
      "Zi ",
      "Xiang ",
      "Shen ",
      "Ge ",
      "Jie ",
      "Jing ",
      "Mi ",
      "Huang ",
      "Shen ",
      "Pu ",
      "Gai ",
      "Dong ",
      "Zhou ",
      "Qian ",
      "Wei ",
      "Bo ",
      "Wei ",
      "Pa ",
      "Ji ",
      "Hu ",
      "Zang ",
      "Jia ",
      "Duan ",
      "Yao ",
      "Jun ",
      "Cong ",
      "Quan ",
      "Wei ",
      "Xian ",
      "Kui ",
      "Ting ",
      "Hun ",
      "Xi ",
      "Shi ",
      "Qi ",
      "Lan ",
      "Zong ",
      "Yao ",
      "Yuan ",
      "Mei ",
      "Yun ",
      "Shu ",
      "Di ",
      "Zhuan ",
      "Guan ",
      "Sukumo ",
      "Xue ",
      "Chan ",
      "Kai ",
      "Kui ",
      "[?] ",
      "Jiang ",
      "Lou ",
      "Wei ",
      "Pai ",
      "[?] ",
      "Sou ",
      "Yin ",
      "Shi ",
      "Chun ",
      "Shi ",
      "Yun ",
      "Zhen ",
      "Lang ",
      "Nu ",
      "Meng ",
      "He ",
      "Que ",
      "Suan ",
      "Yuan ",
      "Li ",
      "Ju ",
      "Xi ",
      "Pang ",
      "Chu ",
      "Xu ",
      "Tu ",
      "Liu ",
      "Wo ",
      "Zhen ",
      "Qian ",
      "Zu ",
      "Po ",
      "Cuo ",
      "Yuan ",
      "Chu ",
      "Yu ",
      "Kuai ",
      "Pan ",
      "Pu ",
      "Pu ",
      "Na ",
      "Shuo ",
      "Xi ",
      "Fen ",
      "Yun ",
      "Zheng ",
      "Jian ",
      "Ji ",
      "Ruo ",
      "Cang ",
      "En ",
      "Mi ",
      "Hao ",
      "Sun ",
      "Zhen ",
      "Ming ",
      "Sou ",
      "Xu ",
      "Liu ",
      "Xi ",
      "Gu ",
      "Lang ",
      "Rong ",
      "Weng ",
      "Gai ",
      "Cuo ",
      "Shi ",
      "Tang ",
      "Luo ",
      "Ru ",
      "Suo ",
      "Xian ",
      "Bei ",
      "Yao ",
      "Gui ",
      "Bi ",
      "Zong ",
      "Gun ",
      "Za ",
      "Xiu ",
      "Ce ",
      "Hai ",
      "Lan ",
      "[?] ",
      "Ji ",
      "Li ",
      "Can ",
      "Lang ",
      "Yu ",
      "[?] ",
      "Ying ",
      "Mo ",
      "Diao ",
      "Tiao ",
      "Mao ",
      "Tong ",
      "Zhu ",
      "Peng ",
      "An ",
      "Lian ",
      "Cong ",
      "Xi ",
      "Ping ",
      "Qiu ",
      "Jin ",
      "Chun ",
      "Jie ",
      "Wei ",
      "Tui ",
      "Cao ",
      "Yu ",
      "Yi ",
      "Ji ",
      "Liao ",
      "Bi ",
      "Lu ",
      "Su "
    ];
  }
});

// node_modules/unidecode/data/x85.js
var require_x85 = __commonJS({
  "node_modules/unidecode/data/x85.js"(exports2, module2) {
    module2.exports = [
      "Bu ",
      "Zhang ",
      "Luo ",
      "Jiang ",
      "Man ",
      "Yan ",
      "Ling ",
      "Ji ",
      "Piao ",
      "Gun ",
      "Han ",
      "Di ",
      "Su ",
      "Lu ",
      "She ",
      "Shang ",
      "Di ",
      "Mie ",
      "Xun ",
      "Man ",
      "Bo ",
      "Di ",
      "Cuo ",
      "Zhe ",
      "Sen ",
      "Xuan ",
      "Wei ",
      "Hu ",
      "Ao ",
      "Mi ",
      "Lou ",
      "Cu ",
      "Zhong ",
      "Cai ",
      "Po ",
      "Jiang ",
      "Mi ",
      "Cong ",
      "Niao ",
      "Hui ",
      "Jun ",
      "Yin ",
      "Jian ",
      "Yan ",
      "Shu ",
      "Yin ",
      "Kui ",
      "Chen ",
      "Hu ",
      "Sha ",
      "Kou ",
      "Qian ",
      "Ma ",
      "Zang ",
      "Sonoko ",
      "Qiang ",
      "Dou ",
      "Lian ",
      "Lin ",
      "Kou ",
      "Ai ",
      "Bi ",
      "Li ",
      "Wei ",
      "Ji ",
      "Xun ",
      "Sheng ",
      "Fan ",
      "Meng ",
      "Ou ",
      "Chan ",
      "Dian ",
      "Xun ",
      "Jiao ",
      "Rui ",
      "Rui ",
      "Lei ",
      "Yu ",
      "Qiao ",
      "Chu ",
      "Hua ",
      "Jian ",
      "Mai ",
      "Yun ",
      "Bao ",
      "You ",
      "Qu ",
      "Lu ",
      "Rao ",
      "Hui ",
      "E ",
      "Teng ",
      "Fei ",
      "Jue ",
      "Zui ",
      "Fa ",
      "Ru ",
      "Fen ",
      "Kui ",
      "Shun ",
      "Rui ",
      "Ya ",
      "Xu ",
      "Fu ",
      "Jue ",
      "Dang ",
      "Wu ",
      "Tong ",
      "Si ",
      "Xiao ",
      "Xi ",
      "Long ",
      "Yun ",
      "[?] ",
      "Qi ",
      "Jian ",
      "Yun ",
      "Sun ",
      "Ling ",
      "Yu ",
      "Xia ",
      "Yong ",
      "Ji ",
      "Hong ",
      "Si ",
      "Nong ",
      "Lei ",
      "Xuan ",
      "Yun ",
      "Yu ",
      "Xi ",
      "Hao ",
      "Bo ",
      "Hao ",
      "Ai ",
      "Wei ",
      "Hui ",
      "Wei ",
      "Ji ",
      "Ci ",
      "Xiang ",
      "Luan ",
      "Mie ",
      "Yi ",
      "Leng ",
      "Jiang ",
      "Can ",
      "Shen ",
      "Qiang ",
      "Lian ",
      "Ke ",
      "Yuan ",
      "Da ",
      "Ti ",
      "Tang ",
      "Xie ",
      "Bi ",
      "Zhan ",
      "Sun ",
      "Lian ",
      "Fan ",
      "Ding ",
      "Jie ",
      "Gu ",
      "Xie ",
      "Shu ",
      "Jian ",
      "Kao ",
      "Hong ",
      "Sa ",
      "Xin ",
      "Xun ",
      "Yao ",
      "Hie ",
      "Sou ",
      "Shu ",
      "Xun ",
      "Dui ",
      "Pin ",
      "Wei ",
      "Neng ",
      "Chou ",
      "Mai ",
      "Ru ",
      "Piao ",
      "Tai ",
      "Qi ",
      "Zao ",
      "Chen ",
      "Zhen ",
      "Er ",
      "Ni ",
      "Ying ",
      "Gao ",
      "Cong ",
      "Xiao ",
      "Qi ",
      "Fa ",
      "Jian ",
      "Xu ",
      "Kui ",
      "Jie ",
      "Bian ",
      "Diao ",
      "Mi ",
      "Lan ",
      "Jin ",
      "Cang ",
      "Miao ",
      "Qiong ",
      "Qie ",
      "Xian ",
      "[?] ",
      "Ou ",
      "Xian ",
      "Su ",
      "Lu ",
      "Yi ",
      "Xu ",
      "Xie ",
      "Li ",
      "Yi ",
      "La ",
      "Lei ",
      "Xiao ",
      "Di ",
      "Zhi ",
      "Bei ",
      "Teng ",
      "Yao ",
      "Mo ",
      "Huan ",
      "Piao ",
      "Fan ",
      "Sou ",
      "Tan ",
      "Tui ",
      "Qiong ",
      "Qiao ",
      "Wei ",
      "Liu ",
      "Hui ",
      "[?] ",
      "Gao ",
      "Yun ",
      "[?] ",
      "Li ",
      "Shu ",
      "Chu ",
      "Ai ",
      "Lin ",
      "Zao ",
      "Xuan ",
      "Chen ",
      "Lai ",
      "Huo "
    ];
  }
});

// node_modules/unidecode/data/x86.js
var require_x86 = __commonJS({
  "node_modules/unidecode/data/x86.js"(exports2, module2) {
    module2.exports = [
      "Tuo ",
      "Wu ",
      "Rui ",
      "Rui ",
      "Qi ",
      "Heng ",
      "Lu ",
      "Su ",
      "Tui ",
      "Mang ",
      "Yun ",
      "Pin ",
      "Yu ",
      "Xun ",
      "Ji ",
      "Jiong ",
      "Xian ",
      "Mo ",
      "Hagi ",
      "Su ",
      "Jiong ",
      "[?] ",
      "Nie ",
      "Bo ",
      "Rang ",
      "Yi ",
      "Xian ",
      "Yu ",
      "Ju ",
      "Lian ",
      "Lian ",
      "Yin ",
      "Qiang ",
      "Ying ",
      "Long ",
      "Tong ",
      "Wei ",
      "Yue ",
      "Ling ",
      "Qu ",
      "Yao ",
      "Fan ",
      "Mi ",
      "Lan ",
      "Kui ",
      "Lan ",
      "Ji ",
      "Dang ",
      "Katsura ",
      "Lei ",
      "Lei ",
      "Hua ",
      "Feng ",
      "Zhi ",
      "Wei ",
      "Kui ",
      "Zhan ",
      "Huai ",
      "Li ",
      "Ji ",
      "Mi ",
      "Lei ",
      "Huai ",
      "Luo ",
      "Ji ",
      "Kui ",
      "Lu ",
      "Jian ",
      "San ",
      "[?] ",
      "Lei ",
      "Quan ",
      "Xiao ",
      "Yi ",
      "Luan ",
      "Men ",
      "Bie ",
      "Hu ",
      "Hu ",
      "Lu ",
      "Nue ",
      "Lu ",
      "Si ",
      "Xiao ",
      "Qian ",
      "Chu ",
      "Hu ",
      "Xu ",
      "Cuo ",
      "Fu ",
      "Xu ",
      "Xu ",
      "Lu ",
      "Hu ",
      "Yu ",
      "Hao ",
      "Jiao ",
      "Ju ",
      "Guo ",
      "Bao ",
      "Yan ",
      "Zhan ",
      "Zhan ",
      "Kui ",
      "Ban ",
      "Xi ",
      "Shu ",
      "Chong ",
      "Qiu ",
      "Diao ",
      "Ji ",
      "Qiu ",
      "Cheng ",
      "Shi ",
      "[?] ",
      "Di ",
      "Zhe ",
      "She ",
      "Yu ",
      "Gan ",
      "Zi ",
      "Hong ",
      "Hui ",
      "Meng ",
      "Ge ",
      "Sui ",
      "Xia ",
      "Chai ",
      "Shi ",
      "Yi ",
      "Ma ",
      "Xiang ",
      "Fang ",
      "E ",
      "Pa ",
      "Chi ",
      "Qian ",
      "Wen ",
      "Wen ",
      "Rui ",
      "Bang ",
      "Bi ",
      "Yue ",
      "Yue ",
      "Jun ",
      "Qi ",
      "Ran ",
      "Yin ",
      "Qi ",
      "Tian ",
      "Yuan ",
      "Jue ",
      "Hui ",
      "Qin ",
      "Qi ",
      "Zhong ",
      "Ya ",
      "Ci ",
      "Mu ",
      "Wang ",
      "Fen ",
      "Fen ",
      "Hang ",
      "Gong ",
      "Zao ",
      "Fu ",
      "Ran ",
      "Jie ",
      "Fu ",
      "Chi ",
      "Dou ",
      "Piao ",
      "Xian ",
      "Ni ",
      "Te ",
      "Qiu ",
      "You ",
      "Zha ",
      "Ping ",
      "Chi ",
      "You ",
      "He ",
      "Han ",
      "Ju ",
      "Li ",
      "Fu ",
      "Ran ",
      "Zha ",
      "Gou ",
      "Pi ",
      "Bo ",
      "Xian ",
      "Zhu ",
      "Diao ",
      "Bie ",
      "Bing ",
      "Gu ",
      "Ran ",
      "Qu ",
      "She ",
      "Tie ",
      "Ling ",
      "Gu ",
      "Dan ",
      "Gu ",
      "Ying ",
      "Li ",
      "Cheng ",
      "Qu ",
      "Mou ",
      "Ge ",
      "Ci ",
      "Hui ",
      "Hui ",
      "Mang ",
      "Fu ",
      "Yang ",
      "Wa ",
      "Lie ",
      "Zhu ",
      "Yi ",
      "Xian ",
      "Kuo ",
      "Jiao ",
      "Li ",
      "Yi ",
      "Ping ",
      "Ji ",
      "Ha ",
      "She ",
      "Yi ",
      "Wang ",
      "Mo ",
      "Qiong ",
      "Qie ",
      "Gui ",
      "Gong ",
      "Zhi ",
      "Man ",
      "Ebi ",
      "Zhi ",
      "Jia ",
      "Rao ",
      "Si ",
      "Qi ",
      "Xing ",
      "Lie ",
      "Qiu ",
      "Shao ",
      "Yong ",
      "Jia ",
      "Shui ",
      "Che ",
      "Bai ",
      "E ",
      "Han "
    ];
  }
});

// node_modules/unidecode/data/x87.js
var require_x87 = __commonJS({
  "node_modules/unidecode/data/x87.js"(exports2, module2) {
    module2.exports = [
      "Shu ",
      "Xuan ",
      "Feng ",
      "Shen ",
      "Zhen ",
      "Fu ",
      "Xian ",
      "Zhe ",
      "Wu ",
      "Fu ",
      "Li ",
      "Lang ",
      "Bi ",
      "Chu ",
      "Yuan ",
      "You ",
      "Jie ",
      "Dan ",
      "Yan ",
      "Ting ",
      "Dian ",
      "Shui ",
      "Hui ",
      "Gua ",
      "Zhi ",
      "Song ",
      "Fei ",
      "Ju ",
      "Mi ",
      "Qi ",
      "Qi ",
      "Yu ",
      "Jun ",
      "Zha ",
      "Meng ",
      "Qiang ",
      "Si ",
      "Xi ",
      "Lun ",
      "Li ",
      "Die ",
      "Tiao ",
      "Tao ",
      "Kun ",
      "Gan ",
      "Han ",
      "Yu ",
      "Bang ",
      "Fei ",
      "Pi ",
      "Wei ",
      "Dun ",
      "Yi ",
      "Yuan ",
      "Su ",
      "Quan ",
      "Qian ",
      "Rui ",
      "Ni ",
      "Qing ",
      "Wei ",
      "Liang ",
      "Guo ",
      "Wan ",
      "Dong ",
      "E ",
      "Ban ",
      "Di ",
      "Wang ",
      "Can ",
      "Yang ",
      "Ying ",
      "Guo ",
      "Chan ",
      "[?] ",
      "La ",
      "Ke ",
      "Ji ",
      "He ",
      "Ting ",
      "Mai ",
      "Xu ",
      "Mian ",
      "Yu ",
      "Jie ",
      "Shi ",
      "Xuan ",
      "Huang ",
      "Yan ",
      "Bian ",
      "Rou ",
      "Wei ",
      "Fu ",
      "Yuan ",
      "Mei ",
      "Wei ",
      "Fu ",
      "Ruan ",
      "Xie ",
      "You ",
      "Qiu ",
      "Mao ",
      "Xia ",
      "Ying ",
      "Shi ",
      "Chong ",
      "Tang ",
      "Zhu ",
      "Zong ",
      "Ti ",
      "Fu ",
      "Yuan ",
      "Hui ",
      "Meng ",
      "La ",
      "Du ",
      "Hu ",
      "Qiu ",
      "Die ",
      "Li ",
      "Gua ",
      "Yun ",
      "Ju ",
      "Nan ",
      "Lou ",
      "Qun ",
      "Rong ",
      "Ying ",
      "Jiang ",
      "[?] ",
      "Lang ",
      "Pang ",
      "Si ",
      "Xi ",
      "Ci ",
      "Xi ",
      "Yuan ",
      "Weng ",
      "Lian ",
      "Sou ",
      "Ban ",
      "Rong ",
      "Rong ",
      "Ji ",
      "Wu ",
      "Qiu ",
      "Han ",
      "Qin ",
      "Yi ",
      "Bi ",
      "Hua ",
      "Tang ",
      "Yi ",
      "Du ",
      "Nai ",
      "He ",
      "Hu ",
      "Hui ",
      "Ma ",
      "Ming ",
      "Yi ",
      "Wen ",
      "Ying ",
      "Teng ",
      "Yu ",
      "Cang ",
      "So ",
      "Ebi ",
      "Man ",
      "[?] ",
      "Shang ",
      "Zhe ",
      "Cao ",
      "Chi ",
      "Di ",
      "Ao ",
      "Lu ",
      "Wei ",
      "Zhi ",
      "Tang ",
      "Chen ",
      "Piao ",
      "Qu ",
      "Pi ",
      "Yu ",
      "Jian ",
      "Luo ",
      "Lou ",
      "Qin ",
      "Zhong ",
      "Yin ",
      "Jiang ",
      "Shuai ",
      "Wen ",
      "Jiao ",
      "Wan ",
      "Zhi ",
      "Zhe ",
      "Ma ",
      "Ma ",
      "Guo ",
      "Liu ",
      "Mao ",
      "Xi ",
      "Cong ",
      "Li ",
      "Man ",
      "Xiao ",
      "Kamakiri ",
      "Zhang ",
      "Mang ",
      "Xiang ",
      "Mo ",
      "Zui ",
      "Si ",
      "Qiu ",
      "Te ",
      "Zhi ",
      "Peng ",
      "Peng ",
      "Jiao ",
      "Qu ",
      "Bie ",
      "Liao ",
      "Pan ",
      "Gui ",
      "Xi ",
      "Ji ",
      "Zhuan ",
      "Huang ",
      "Fei ",
      "Lao ",
      "Jue ",
      "Jue ",
      "Hui ",
      "Yin ",
      "Chan ",
      "Jiao ",
      "Shan ",
      "Rao ",
      "Xiao ",
      "Mou ",
      "Chong ",
      "Xun ",
      "Si ",
      "[?] ",
      "Cheng ",
      "Dang ",
      "Li ",
      "Xie ",
      "Shan ",
      "Yi ",
      "Jing ",
      "Da ",
      "Chan ",
      "Qi "
    ];
  }
});

// node_modules/unidecode/data/x88.js
var require_x88 = __commonJS({
  "node_modules/unidecode/data/x88.js"(exports2, module2) {
    module2.exports = [
      "Ci ",
      "Xiang ",
      "She ",
      "Luo ",
      "Qin ",
      "Ying ",
      "Chai ",
      "Li ",
      "Ze ",
      "Xuan ",
      "Lian ",
      "Zhu ",
      "Ze ",
      "Xie ",
      "Mang ",
      "Xie ",
      "Qi ",
      "Rong ",
      "Jian ",
      "Meng ",
      "Hao ",
      "Ruan ",
      "Huo ",
      "Zhuo ",
      "Jie ",
      "Bin ",
      "He ",
      "Mie ",
      "Fan ",
      "Lei ",
      "Jie ",
      "La ",
      "Mi ",
      "Li ",
      "Chun ",
      "Li ",
      "Qiu ",
      "Nie ",
      "Lu ",
      "Du ",
      "Xiao ",
      "Zhu ",
      "Long ",
      "Li ",
      "Long ",
      "Feng ",
      "Ye ",
      "Beng ",
      "Shang ",
      "Gu ",
      "Juan ",
      "Ying ",
      "[?] ",
      "Xi ",
      "Can ",
      "Qu ",
      "Quan ",
      "Du ",
      "Can ",
      "Man ",
      "Jue ",
      "Jie ",
      "Zhu ",
      "Zha ",
      "Xie ",
      "Huang ",
      "Niu ",
      "Pei ",
      "Nu ",
      "Xin ",
      "Zhong ",
      "Mo ",
      "Er ",
      "Ke ",
      "Mie ",
      "Xi ",
      "Xing ",
      "Yan ",
      "Kan ",
      "Yuan ",
      "[?] ",
      "Ling ",
      "Xuan ",
      "Shu ",
      "Xian ",
      "Tong ",
      "Long ",
      "Jie ",
      "Xian ",
      "Ya ",
      "Hu ",
      "Wei ",
      "Dao ",
      "Chong ",
      "Wei ",
      "Dao ",
      "Zhun ",
      "Heng ",
      "Qu ",
      "Yi ",
      "Yi ",
      "Bu ",
      "Gan ",
      "Yu ",
      "Biao ",
      "Cha ",
      "Yi ",
      "Shan ",
      "Chen ",
      "Fu ",
      "Gun ",
      "Fen ",
      "Shuai ",
      "Jie ",
      "Na ",
      "Zhong ",
      "Dan ",
      "Ri ",
      "Zhong ",
      "Zhong ",
      "Xie ",
      "Qi ",
      "Xie ",
      "Ran ",
      "Zhi ",
      "Ren ",
      "Qin ",
      "Jin ",
      "Jun ",
      "Yuan ",
      "Mei ",
      "Chai ",
      "Ao ",
      "Niao ",
      "Hui ",
      "Ran ",
      "Jia ",
      "Tuo ",
      "Ling ",
      "Dai ",
      "Bao ",
      "Pao ",
      "Yao ",
      "Zuo ",
      "Bi ",
      "Shao ",
      "Tan ",
      "Ju ",
      "He ",
      "Shu ",
      "Xiu ",
      "Zhen ",
      "Yi ",
      "Pa ",
      "Bo ",
      "Di ",
      "Wa ",
      "Fu ",
      "Gun ",
      "Zhi ",
      "Zhi ",
      "Ran ",
      "Pan ",
      "Yi ",
      "Mao ",
      "Tuo ",
      "Na ",
      "Kou ",
      "Xian ",
      "Chan ",
      "Qu ",
      "Bei ",
      "Gun ",
      "Xi ",
      "Ne ",
      "Bo ",
      "Horo ",
      "Fu ",
      "Yi ",
      "Chi ",
      "Ku ",
      "Ren ",
      "Jiang ",
      "Jia ",
      "Cun ",
      "Mo ",
      "Jie ",
      "Er ",
      "Luo ",
      "Ru ",
      "Zhu ",
      "Gui ",
      "Yin ",
      "Cai ",
      "Lie ",
      "Kamishimo ",
      "Yuki ",
      "Zhuang ",
      "Dang ",
      "[?] ",
      "Kun ",
      "Ken ",
      "Niao ",
      "Shu ",
      "Jia ",
      "Kun ",
      "Cheng ",
      "Li ",
      "Juan ",
      "Shen ",
      "Pou ",
      "Ge ",
      "Yi ",
      "Yu ",
      "Zhen ",
      "Liu ",
      "Qiu ",
      "Qun ",
      "Ji ",
      "Yi ",
      "Bu ",
      "Zhuang ",
      "Shui ",
      "Sha ",
      "Qun ",
      "Li ",
      "Lian ",
      "Lian ",
      "Ku ",
      "Jian ",
      "Fou ",
      "Chan ",
      "Bi ",
      "Gun ",
      "Tao ",
      "Yuan ",
      "Ling ",
      "Chi ",
      "Chang ",
      "Chou ",
      "Duo ",
      "Biao ",
      "Liang ",
      "Chang ",
      "Pei ",
      "Pei ",
      "Fei ",
      "Yuan ",
      "Luo ",
      "Guo ",
      "Yan ",
      "Du ",
      "Xi ",
      "Zhi ",
      "Ju ",
      "Qi "
    ];
  }
});

// node_modules/unidecode/data/x89.js
var require_x89 = __commonJS({
  "node_modules/unidecode/data/x89.js"(exports2, module2) {
    module2.exports = [
      "Ji ",
      "Zhi ",
      "Gua ",
      "Ken ",
      "Che ",
      "Ti ",
      "Ti ",
      "Fu ",
      "Chong ",
      "Xie ",
      "Bian ",
      "Die ",
      "Kun ",
      "Duan ",
      "Xiu ",
      "Xiu ",
      "He ",
      "Yuan ",
      "Bao ",
      "Bao ",
      "Fu ",
      "Yu ",
      "Tuan ",
      "Yan ",
      "Hui ",
      "Bei ",
      "Chu ",
      "Lu ",
      "Ena ",
      "Hitoe ",
      "Yun ",
      "Da ",
      "Gou ",
      "Da ",
      "Huai ",
      "Rong ",
      "Yuan ",
      "Ru ",
      "Nai ",
      "Jiong ",
      "Suo ",
      "Ban ",
      "Tun ",
      "Chi ",
      "Sang ",
      "Niao ",
      "Ying ",
      "Jie ",
      "Qian ",
      "Huai ",
      "Ku ",
      "Lian ",
      "Bao ",
      "Li ",
      "Zhe ",
      "Shi ",
      "Lu ",
      "Yi ",
      "Die ",
      "Xie ",
      "Xian ",
      "Wei ",
      "Biao ",
      "Cao ",
      "Ji ",
      "Jiang ",
      "Sen ",
      "Bao ",
      "Xiang ",
      "Chihaya ",
      "Pu ",
      "Jian ",
      "Zhuan ",
      "Jian ",
      "Zui ",
      "Ji ",
      "Dan ",
      "Za ",
      "Fan ",
      "Bo ",
      "Xiang ",
      "Xin ",
      "Bie ",
      "Rao ",
      "Man ",
      "Lan ",
      "Ao ",
      "Duo ",
      "Gui ",
      "Cao ",
      "Sui ",
      "Nong ",
      "Chan ",
      "Lian ",
      "Bi ",
      "Jin ",
      "Dang ",
      "Shu ",
      "Tan ",
      "Bi ",
      "Lan ",
      "Pu ",
      "Ru ",
      "Zhi ",
      "[?] ",
      "Shu ",
      "Wa ",
      "Shi ",
      "Bai ",
      "Xie ",
      "Bo ",
      "Chen ",
      "Lai ",
      "Long ",
      "Xi ",
      "Xian ",
      "Lan ",
      "Zhe ",
      "Dai ",
      "Tasuki ",
      "Zan ",
      "Shi ",
      "Jian ",
      "Pan ",
      "Yi ",
      "Ran ",
      "Ya ",
      "Xi ",
      "Xi ",
      "Yao ",
      "Feng ",
      "Tan ",
      "[?] ",
      "Biao ",
      "Fu ",
      "Ba ",
      "He ",
      "Ji ",
      "Ji ",
      "Jian ",
      "Guan ",
      "Bian ",
      "Yan ",
      "Gui ",
      "Jue ",
      "Pian ",
      "Mao ",
      "Mi ",
      "Mi ",
      "Mie ",
      "Shi ",
      "Si ",
      "Zhan ",
      "Luo ",
      "Jue ",
      "Mi ",
      "Tiao ",
      "Lian ",
      "Yao ",
      "Zhi ",
      "Jun ",
      "Xi ",
      "Shan ",
      "Wei ",
      "Xi ",
      "Tian ",
      "Yu ",
      "Lan ",
      "E ",
      "Du ",
      "Qin ",
      "Pang ",
      "Ji ",
      "Ming ",
      "Ying ",
      "Gou ",
      "Qu ",
      "Zhan ",
      "Jin ",
      "Guan ",
      "Deng ",
      "Jian ",
      "Luo ",
      "Qu ",
      "Jian ",
      "Wei ",
      "Jue ",
      "Qu ",
      "Luo ",
      "Lan ",
      "Shen ",
      "Di ",
      "Guan ",
      "Jian ",
      "Guan ",
      "Yan ",
      "Gui ",
      "Mi ",
      "Shi ",
      "Zhan ",
      "Lan ",
      "Jue ",
      "Ji ",
      "Xi ",
      "Di ",
      "Tian ",
      "Yu ",
      "Gou ",
      "Jin ",
      "Qu ",
      "Jiao ",
      "Jiu ",
      "Jin ",
      "Cu ",
      "Jue ",
      "Zhi ",
      "Chao ",
      "Ji ",
      "Gu ",
      "Dan ",
      "Zui ",
      "Di ",
      "Shang ",
      "Hua ",
      "Quan ",
      "Ge ",
      "Chi ",
      "Jie ",
      "Gui ",
      "Gong ",
      "Hong ",
      "Jie ",
      "Hun ",
      "Qiu ",
      "Xing ",
      "Su ",
      "Ni ",
      "Ji ",
      "Lu ",
      "Zhi ",
      "Zha ",
      "Bi ",
      "Xing ",
      "Hu ",
      "Shang ",
      "Gong ",
      "Zhi ",
      "Xue ",
      "Chu ",
      "Xi ",
      "Yi ",
      "Lu ",
      "Jue ",
      "Xi ",
      "Yan ",
      "Xi "
    ];
  }
});

// node_modules/unidecode/data/x8a.js
var require_x8a = __commonJS({
  "node_modules/unidecode/data/x8a.js"(exports2, module2) {
    module2.exports = [
      "Yan ",
      "Yan ",
      "Ding ",
      "Fu ",
      "Qiu ",
      "Qiu ",
      "Jiao ",
      "Hong ",
      "Ji ",
      "Fan ",
      "Xun ",
      "Diao ",
      "Hong ",
      "Cha ",
      "Tao ",
      "Xu ",
      "Jie ",
      "Yi ",
      "Ren ",
      "Xun ",
      "Yin ",
      "Shan ",
      "Qi ",
      "Tuo ",
      "Ji ",
      "Xun ",
      "Yin ",
      "E ",
      "Fen ",
      "Ya ",
      "Yao ",
      "Song ",
      "Shen ",
      "Yin ",
      "Xin ",
      "Jue ",
      "Xiao ",
      "Ne ",
      "Chen ",
      "You ",
      "Zhi ",
      "Xiong ",
      "Fang ",
      "Xin ",
      "Chao ",
      "She ",
      "Xian ",
      "Sha ",
      "Tun ",
      "Xu ",
      "Yi ",
      "Yi ",
      "Su ",
      "Chi ",
      "He ",
      "Shen ",
      "He ",
      "Xu ",
      "Zhen ",
      "Zhu ",
      "Zheng ",
      "Gou ",
      "Zi ",
      "Zi ",
      "Zhan ",
      "Gu ",
      "Fu ",
      "Quan ",
      "Die ",
      "Ling ",
      "Di ",
      "Yang ",
      "Li ",
      "Nao ",
      "Pan ",
      "Zhou ",
      "Gan ",
      "Yi ",
      "Ju ",
      "Ao ",
      "Zha ",
      "Tuo ",
      "Yi ",
      "Qu ",
      "Zhao ",
      "Ping ",
      "Bi ",
      "Xiong ",
      "Qu ",
      "Ba ",
      "Da ",
      "Zu ",
      "Tao ",
      "Zhu ",
      "Ci ",
      "Zhe ",
      "Yong ",
      "Xu ",
      "Xun ",
      "Yi ",
      "Huang ",
      "He ",
      "Shi ",
      "Cha ",
      "Jiao ",
      "Shi ",
      "Hen ",
      "Cha ",
      "Gou ",
      "Gui ",
      "Quan ",
      "Hui ",
      "Jie ",
      "Hua ",
      "Gai ",
      "Xiang ",
      "Wei ",
      "Shen ",
      "Chou ",
      "Tong ",
      "Mi ",
      "Zhan ",
      "Ming ",
      "E ",
      "Hui ",
      "Yan ",
      "Xiong ",
      "Gua ",
      "Er ",
      "Beng ",
      "Tiao ",
      "Chi ",
      "Lei ",
      "Zhu ",
      "Kuang ",
      "Kua ",
      "Wu ",
      "Yu ",
      "Teng ",
      "Ji ",
      "Zhi ",
      "Ren ",
      "Su ",
      "Lang ",
      "E ",
      "Kuang ",
      "E ",
      "Shi ",
      "Ting ",
      "Dan ",
      "Bo ",
      "Chan ",
      "You ",
      "Heng ",
      "Qiao ",
      "Qin ",
      "Shua ",
      "An ",
      "Yu ",
      "Xiao ",
      "Cheng ",
      "Jie ",
      "Xian ",
      "Wu ",
      "Wu ",
      "Gao ",
      "Song ",
      "Pu ",
      "Hui ",
      "Jing ",
      "Shuo ",
      "Zhen ",
      "Shuo ",
      "Du ",
      "Yasashi ",
      "Chang ",
      "Shui ",
      "Jie ",
      "Ke ",
      "Qu ",
      "Cong ",
      "Xiao ",
      "Sui ",
      "Wang ",
      "Xuan ",
      "Fei ",
      "Chi ",
      "Ta ",
      "Yi ",
      "Na ",
      "Yin ",
      "Diao ",
      "Pi ",
      "Chuo ",
      "Chan ",
      "Chen ",
      "Zhun ",
      "Ji ",
      "Qi ",
      "Tan ",
      "Zhui ",
      "Wei ",
      "Ju ",
      "Qing ",
      "Jian ",
      "Zheng ",
      "Ze ",
      "Zou ",
      "Qian ",
      "Zhuo ",
      "Liang ",
      "Jian ",
      "Zhu ",
      "Hao ",
      "Lun ",
      "Shen ",
      "Biao ",
      "Huai ",
      "Pian ",
      "Yu ",
      "Die ",
      "Xu ",
      "Pian ",
      "Shi ",
      "Xuan ",
      "Shi ",
      "Hun ",
      "Hua ",
      "E ",
      "Zhong ",
      "Di ",
      "Xie ",
      "Fu ",
      "Pu ",
      "Ting ",
      "Jian ",
      "Qi ",
      "Yu ",
      "Zi ",
      "Chuan ",
      "Xi ",
      "Hui ",
      "Yin ",
      "An ",
      "Xian ",
      "Nan ",
      "Chen ",
      "Feng ",
      "Zhu ",
      "Yang ",
      "Yan ",
      "Heng ",
      "Xuan ",
      "Ge ",
      "Nuo ",
      "Qi "
    ];
  }
});

// node_modules/unidecode/data/x8b.js
var require_x8b = __commonJS({
  "node_modules/unidecode/data/x8b.js"(exports2, module2) {
    module2.exports = [
      "Mou ",
      "Ye ",
      "Wei ",
      "[?] ",
      "Teng ",
      "Zou ",
      "Shan ",
      "Jian ",
      "Bo ",
      "Ku ",
      "Huang ",
      "Huo ",
      "Ge ",
      "Ying ",
      "Mi ",
      "Xiao ",
      "Mi ",
      "Xi ",
      "Qiang ",
      "Chen ",
      "Nue ",
      "Ti ",
      "Su ",
      "Bang ",
      "Chi ",
      "Qian ",
      "Shi ",
      "Jiang ",
      "Yuan ",
      "Xie ",
      "Xue ",
      "Tao ",
      "Yao ",
      "Yao ",
      "[?] ",
      "Yu ",
      "Biao ",
      "Cong ",
      "Qing ",
      "Li ",
      "Mo ",
      "Mo ",
      "Shang ",
      "Zhe ",
      "Miu ",
      "Jian ",
      "Ze ",
      "Jie ",
      "Lian ",
      "Lou ",
      "Can ",
      "Ou ",
      "Guan ",
      "Xi ",
      "Zhuo ",
      "Ao ",
      "Ao ",
      "Jin ",
      "Zhe ",
      "Yi ",
      "Hu ",
      "Jiang ",
      "Man ",
      "Chao ",
      "Han ",
      "Hua ",
      "Chan ",
      "Xu ",
      "Zeng ",
      "Se ",
      "Xi ",
      "She ",
      "Dui ",
      "Zheng ",
      "Nao ",
      "Lan ",
      "E ",
      "Ying ",
      "Jue ",
      "Ji ",
      "Zun ",
      "Jiao ",
      "Bo ",
      "Hui ",
      "Zhuan ",
      "Mu ",
      "Zen ",
      "Zha ",
      "Shi ",
      "Qiao ",
      "Tan ",
      "Zen ",
      "Pu ",
      "Sheng ",
      "Xuan ",
      "Zao ",
      "Tan ",
      "Dang ",
      "Sui ",
      "Qian ",
      "Ji ",
      "Jiao ",
      "Jing ",
      "Lian ",
      "Nou ",
      "Yi ",
      "Ai ",
      "Zhan ",
      "Pi ",
      "Hui ",
      "Hua ",
      "Yi ",
      "Yi ",
      "Shan ",
      "Rang ",
      "Nou ",
      "Qian ",
      "Zhui ",
      "Ta ",
      "Hu ",
      "Zhou ",
      "Hao ",
      "Ye ",
      "Ying ",
      "Jian ",
      "Yu ",
      "Jian ",
      "Hui ",
      "Du ",
      "Zhe ",
      "Xuan ",
      "Zan ",
      "Lei ",
      "Shen ",
      "Wei ",
      "Chan ",
      "Li ",
      "Yi ",
      "Bian ",
      "Zhe ",
      "Yan ",
      "E ",
      "Chou ",
      "Wei ",
      "Chou ",
      "Yao ",
      "Chan ",
      "Rang ",
      "Yin ",
      "Lan ",
      "Chen ",
      "Huo ",
      "Zhe ",
      "Huan ",
      "Zan ",
      "Yi ",
      "Dang ",
      "Zhan ",
      "Yan ",
      "Du ",
      "Yan ",
      "Ji ",
      "Ding ",
      "Fu ",
      "Ren ",
      "Ji ",
      "Jie ",
      "Hong ",
      "Tao ",
      "Rang ",
      "Shan ",
      "Qi ",
      "Tuo ",
      "Xun ",
      "Yi ",
      "Xun ",
      "Ji ",
      "Ren ",
      "Jiang ",
      "Hui ",
      "Ou ",
      "Ju ",
      "Ya ",
      "Ne ",
      "Xu ",
      "E ",
      "Lun ",
      "Xiong ",
      "Song ",
      "Feng ",
      "She ",
      "Fang ",
      "Jue ",
      "Zheng ",
      "Gu ",
      "He ",
      "Ping ",
      "Zu ",
      "Shi ",
      "Xiong ",
      "Zha ",
      "Su ",
      "Zhen ",
      "Di ",
      "Zou ",
      "Ci ",
      "Qu ",
      "Zhao ",
      "Bi ",
      "Yi ",
      "Yi ",
      "Kuang ",
      "Lei ",
      "Shi ",
      "Gua ",
      "Shi ",
      "Jie ",
      "Hui ",
      "Cheng ",
      "Zhu ",
      "Shen ",
      "Hua ",
      "Dan ",
      "Gou ",
      "Quan ",
      "Gui ",
      "Xun ",
      "Yi ",
      "Zheng ",
      "Gai ",
      "Xiang ",
      "Cha ",
      "Hun ",
      "Xu ",
      "Zhou ",
      "Jie ",
      "Wu ",
      "Yu ",
      "Qiao ",
      "Wu ",
      "Gao ",
      "You ",
      "Hui ",
      "Kuang ",
      "Shuo ",
      "Song ",
      "Ai ",
      "Qing ",
      "Zhu ",
      "Zou ",
      "Nuo ",
      "Du ",
      "Zhuo ",
      "Fei ",
      "Ke ",
      "Wei "
    ];
  }
});

// node_modules/unidecode/data/x8c.js
var require_x8c = __commonJS({
  "node_modules/unidecode/data/x8c.js"(exports2, module2) {
    module2.exports = [
      "Yu ",
      "Shui ",
      "Shen ",
      "Diao ",
      "Chan ",
      "Liang ",
      "Zhun ",
      "Sui ",
      "Tan ",
      "Shen ",
      "Yi ",
      "Mou ",
      "Chen ",
      "Die ",
      "Huang ",
      "Jian ",
      "Xie ",
      "Nue ",
      "Ye ",
      "Wei ",
      "E ",
      "Yu ",
      "Xuan ",
      "Chan ",
      "Zi ",
      "An ",
      "Yan ",
      "Di ",
      "Mi ",
      "Pian ",
      "Xu ",
      "Mo ",
      "Dang ",
      "Su ",
      "Xie ",
      "Yao ",
      "Bang ",
      "Shi ",
      "Qian ",
      "Mi ",
      "Jin ",
      "Man ",
      "Zhe ",
      "Jian ",
      "Miu ",
      "Tan ",
      "Zen ",
      "Qiao ",
      "Lan ",
      "Pu ",
      "Jue ",
      "Yan ",
      "Qian ",
      "Zhan ",
      "Chen ",
      "Gu ",
      "Qian ",
      "Hong ",
      "Xia ",
      "Jue ",
      "Hong ",
      "Han ",
      "Hong ",
      "Xi ",
      "Xi ",
      "Huo ",
      "Liao ",
      "Han ",
      "Du ",
      "Long ",
      "Dou ",
      "Jiang ",
      "Qi ",
      "Shi ",
      "Li ",
      "Deng ",
      "Wan ",
      "Bi ",
      "Shu ",
      "Xian ",
      "Feng ",
      "Zhi ",
      "Zhi ",
      "Yan ",
      "Yan ",
      "Shi ",
      "Chu ",
      "Hui ",
      "Tun ",
      "Yi ",
      "Tun ",
      "Yi ",
      "Jian ",
      "Ba ",
      "Hou ",
      "E ",
      "Cu ",
      "Xiang ",
      "Huan ",
      "Jian ",
      "Ken ",
      "Gai ",
      "Qu ",
      "Fu ",
      "Xi ",
      "Bin ",
      "Hao ",
      "Yu ",
      "Zhu ",
      "Jia ",
      "[?] ",
      "Xi ",
      "Bo ",
      "Wen ",
      "Huan ",
      "Bin ",
      "Di ",
      "Zong ",
      "Fen ",
      "Yi ",
      "Zhi ",
      "Bao ",
      "Chai ",
      "Han ",
      "Pi ",
      "Na ",
      "Pi ",
      "Gou ",
      "Na ",
      "You ",
      "Diao ",
      "Mo ",
      "Si ",
      "Xiu ",
      "Huan ",
      "Kun ",
      "He ",
      "He ",
      "Mo ",
      "Han ",
      "Mao ",
      "Li ",
      "Ni ",
      "Bi ",
      "Yu ",
      "Jia ",
      "Tuan ",
      "Mao ",
      "Pi ",
      "Xi ",
      "E ",
      "Ju ",
      "Mo ",
      "Chu ",
      "Tan ",
      "Huan ",
      "Jue ",
      "Bei ",
      "Zhen ",
      "Yuan ",
      "Fu ",
      "Cai ",
      "Gong ",
      "Te ",
      "Yi ",
      "Hang ",
      "Wan ",
      "Pin ",
      "Huo ",
      "Fan ",
      "Tan ",
      "Guan ",
      "Ze ",
      "Zhi ",
      "Er ",
      "Zhu ",
      "Shi ",
      "Bi ",
      "Zi ",
      "Er ",
      "Gui ",
      "Pian ",
      "Bian ",
      "Mai ",
      "Dai ",
      "Sheng ",
      "Kuang ",
      "Fei ",
      "Tie ",
      "Yi ",
      "Chi ",
      "Mao ",
      "He ",
      "Bi ",
      "Lu ",
      "Ren ",
      "Hui ",
      "Gai ",
      "Pian ",
      "Zi ",
      "Jia ",
      "Xu ",
      "Zei ",
      "Jiao ",
      "Gai ",
      "Zang ",
      "Jian ",
      "Ying ",
      "Xun ",
      "Zhen ",
      "She ",
      "Bin ",
      "Bin ",
      "Qiu ",
      "She ",
      "Chuan ",
      "Zang ",
      "Zhou ",
      "Lai ",
      "Zan ",
      "Si ",
      "Chen ",
      "Shang ",
      "Tian ",
      "Pei ",
      "Geng ",
      "Xian ",
      "Mai ",
      "Jian ",
      "Sui ",
      "Fu ",
      "Tan ",
      "Cong ",
      "Cong ",
      "Zhi ",
      "Ji ",
      "Zhang ",
      "Du ",
      "Jin ",
      "Xiong ",
      "Shun ",
      "Yun ",
      "Bao ",
      "Zai ",
      "Lai ",
      "Feng ",
      "Cang ",
      "Ji ",
      "Sheng ",
      "Ai ",
      "Zhuan ",
      "Fu ",
      "Gou ",
      "Sai ",
      "Ze ",
      "Liao "
    ];
  }
});

// node_modules/unidecode/data/x8d.js
var require_x8d = __commonJS({
  "node_modules/unidecode/data/x8d.js"(exports2, module2) {
    module2.exports = [
      "Wei ",
      "Bai ",
      "Chen ",
      "Zhuan ",
      "Zhi ",
      "Zhui ",
      "Biao ",
      "Yun ",
      "Zeng ",
      "Tan ",
      "Zan ",
      "Yan ",
      "[?] ",
      "Shan ",
      "Wan ",
      "Ying ",
      "Jin ",
      "Gan ",
      "Xian ",
      "Zang ",
      "Bi ",
      "Du ",
      "Shu ",
      "Yan ",
      "[?] ",
      "Xuan ",
      "Long ",
      "Gan ",
      "Zang ",
      "Bei ",
      "Zhen ",
      "Fu ",
      "Yuan ",
      "Gong ",
      "Cai ",
      "Ze ",
      "Xian ",
      "Bai ",
      "Zhang ",
      "Huo ",
      "Zhi ",
      "Fan ",
      "Tan ",
      "Pin ",
      "Bian ",
      "Gou ",
      "Zhu ",
      "Guan ",
      "Er ",
      "Jian ",
      "Bi ",
      "Shi ",
      "Tie ",
      "Gui ",
      "Kuang ",
      "Dai ",
      "Mao ",
      "Fei ",
      "He ",
      "Yi ",
      "Zei ",
      "Zhi ",
      "Jia ",
      "Hui ",
      "Zi ",
      "Ren ",
      "Lu ",
      "Zang ",
      "Zi ",
      "Gai ",
      "Jin ",
      "Qiu ",
      "Zhen ",
      "Lai ",
      "She ",
      "Fu ",
      "Du ",
      "Ji ",
      "Shu ",
      "Shang ",
      "Si ",
      "Bi ",
      "Zhou ",
      "Geng ",
      "Pei ",
      "Tan ",
      "Lai ",
      "Feng ",
      "Zhui ",
      "Fu ",
      "Zhuan ",
      "Sai ",
      "Ze ",
      "Yan ",
      "Zan ",
      "Yun ",
      "Zeng ",
      "Shan ",
      "Ying ",
      "Gan ",
      "Chi ",
      "Xi ",
      "She ",
      "Nan ",
      "Xiong ",
      "Xi ",
      "Cheng ",
      "He ",
      "Cheng ",
      "Zhe ",
      "Xia ",
      "Tang ",
      "Zou ",
      "Zou ",
      "Li ",
      "Jiu ",
      "Fu ",
      "Zhao ",
      "Gan ",
      "Qi ",
      "Shan ",
      "Qiong ",
      "Qin ",
      "Xian ",
      "Ci ",
      "Jue ",
      "Qin ",
      "Chi ",
      "Ci ",
      "Chen ",
      "Chen ",
      "Die ",
      "Ju ",
      "Chao ",
      "Di ",
      "Se ",
      "Zhan ",
      "Zhu ",
      "Yue ",
      "Qu ",
      "Jie ",
      "Chi ",
      "Chu ",
      "Gua ",
      "Xue ",
      "Ci ",
      "Tiao ",
      "Duo ",
      "Lie ",
      "Gan ",
      "Suo ",
      "Cu ",
      "Xi ",
      "Zhao ",
      "Su ",
      "Yin ",
      "Ju ",
      "Jian ",
      "Que ",
      "Tang ",
      "Chuo ",
      "Cui ",
      "Lu ",
      "Qu ",
      "Dang ",
      "Qiu ",
      "Zi ",
      "Ti ",
      "Qu ",
      "Chi ",
      "Huang ",
      "Qiao ",
      "Qiao ",
      "Yao ",
      "Zao ",
      "Ti ",
      "[?] ",
      "Zan ",
      "Zan ",
      "Zu ",
      "Pa ",
      "Bao ",
      "Ku ",
      "Ke ",
      "Dun ",
      "Jue ",
      "Fu ",
      "Chen ",
      "Jian ",
      "Fang ",
      "Zhi ",
      "Sa ",
      "Yue ",
      "Pa ",
      "Qi ",
      "Yue ",
      "Qiang ",
      "Tuo ",
      "Tai ",
      "Yi ",
      "Nian ",
      "Ling ",
      "Mei ",
      "Ba ",
      "Die ",
      "Ku ",
      "Tuo ",
      "Jia ",
      "Ci ",
      "Pao ",
      "Qia ",
      "Zhu ",
      "Ju ",
      "Die ",
      "Zhi ",
      "Fu ",
      "Pan ",
      "Ju ",
      "Shan ",
      "Bo ",
      "Ni ",
      "Ju ",
      "Li ",
      "Gen ",
      "Yi ",
      "Ji ",
      "Dai ",
      "Xian ",
      "Jiao ",
      "Duo ",
      "Zhu ",
      "Zhuan ",
      "Kua ",
      "Zhuai ",
      "Gui ",
      "Qiong ",
      "Kui ",
      "Xiang ",
      "Chi ",
      "Lu ",
      "Beng ",
      "Zhi ",
      "Jia ",
      "Tiao ",
      "Cai ",
      "Jian ",
      "Ta ",
      "Qiao ",
      "Bi ",
      "Xian ",
      "Duo ",
      "Ji ",
      "Ju ",
      "Ji ",
      "Shu ",
      "Tu "
    ];
  }
});

// node_modules/unidecode/data/x8e.js
var require_x8e = __commonJS({
  "node_modules/unidecode/data/x8e.js"(exports2, module2) {
    module2.exports = [
      "Chu ",
      "Jing ",
      "Nie ",
      "Xiao ",
      "Bo ",
      "Chi ",
      "Qun ",
      "Mou ",
      "Shu ",
      "Lang ",
      "Yong ",
      "Jiao ",
      "Chou ",
      "Qiao ",
      "[?] ",
      "Ta ",
      "Jian ",
      "Qi ",
      "Wo ",
      "Wei ",
      "Zhuo ",
      "Jie ",
      "Ji ",
      "Nie ",
      "Ju ",
      "Ju ",
      "Lun ",
      "Lu ",
      "Leng ",
      "Huai ",
      "Ju ",
      "Chi ",
      "Wan ",
      "Quan ",
      "Ti ",
      "Bo ",
      "Zu ",
      "Qie ",
      "Ji ",
      "Cu ",
      "Zong ",
      "Cai ",
      "Zong ",
      "Peng ",
      "Zhi ",
      "Zheng ",
      "Dian ",
      "Zhi ",
      "Yu ",
      "Duo ",
      "Dun ",
      "Chun ",
      "Yong ",
      "Zhong ",
      "Di ",
      "Zhe ",
      "Chen ",
      "Chuai ",
      "Jian ",
      "Gua ",
      "Tang ",
      "Ju ",
      "Fu ",
      "Zu ",
      "Die ",
      "Pian ",
      "Rou ",
      "Nuo ",
      "Ti ",
      "Cha ",
      "Tui ",
      "Jian ",
      "Dao ",
      "Cuo ",
      "Xi ",
      "Ta ",
      "Qiang ",
      "Zhan ",
      "Dian ",
      "Ti ",
      "Ji ",
      "Nie ",
      "Man ",
      "Liu ",
      "Zhan ",
      "Bi ",
      "Chong ",
      "Lu ",
      "Liao ",
      "Cu ",
      "Tang ",
      "Dai ",
      "Suo ",
      "Xi ",
      "Kui ",
      "Ji ",
      "Zhi ",
      "Qiang ",
      "Di ",
      "Man ",
      "Zong ",
      "Lian ",
      "Beng ",
      "Zao ",
      "Nian ",
      "Bie ",
      "Tui ",
      "Ju ",
      "Deng ",
      "Ceng ",
      "Xian ",
      "Fan ",
      "Chu ",
      "Zhong ",
      "Dun ",
      "Bo ",
      "Cu ",
      "Zu ",
      "Jue ",
      "Jue ",
      "Lin ",
      "Ta ",
      "Qiao ",
      "Qiao ",
      "Pu ",
      "Liao ",
      "Dun ",
      "Cuan ",
      "Kuang ",
      "Zao ",
      "Ta ",
      "Bi ",
      "Bi ",
      "Zhu ",
      "Ju ",
      "Chu ",
      "Qiao ",
      "Dun ",
      "Chou ",
      "Ji ",
      "Wu ",
      "Yue ",
      "Nian ",
      "Lin ",
      "Lie ",
      "Zhi ",
      "Li ",
      "Zhi ",
      "Chan ",
      "Chu ",
      "Duan ",
      "Wei ",
      "Long ",
      "Lin ",
      "Xian ",
      "Wei ",
      "Zuan ",
      "Lan ",
      "Xie ",
      "Rang ",
      "Xie ",
      "Nie ",
      "Ta ",
      "Qu ",
      "Jie ",
      "Cuan ",
      "Zuan ",
      "Xi ",
      "Kui ",
      "Jue ",
      "Lin ",
      "Shen ",
      "Gong ",
      "Dan ",
      "Segare ",
      "Qu ",
      "Ti ",
      "Duo ",
      "Duo ",
      "Gong ",
      "Lang ",
      "Nerau ",
      "Luo ",
      "Ai ",
      "Ji ",
      "Ju ",
      "Tang ",
      "Utsuke ",
      "[?] ",
      "Yan ",
      "Shitsuke ",
      "Kang ",
      "Qu ",
      "Lou ",
      "Lao ",
      "Tuo ",
      "Zhi ",
      "Yagate ",
      "Ti ",
      "Dao ",
      "Yagate ",
      "Yu ",
      "Che ",
      "Ya ",
      "Gui ",
      "Jun ",
      "Wei ",
      "Yue ",
      "Xin ",
      "Di ",
      "Xuan ",
      "Fan ",
      "Ren ",
      "Shan ",
      "Qiang ",
      "Shu ",
      "Tun ",
      "Chen ",
      "Dai ",
      "E ",
      "Na ",
      "Qi ",
      "Mao ",
      "Ruan ",
      "Ren ",
      "Fan ",
      "Zhuan ",
      "Hong ",
      "Hu ",
      "Qu ",
      "Huang ",
      "Di ",
      "Ling ",
      "Dai ",
      "Ao ",
      "Zhen ",
      "Fan ",
      "Kuang ",
      "Ang ",
      "Peng ",
      "Bei ",
      "Gu ",
      "Ku ",
      "Pao ",
      "Zhu ",
      "Rong ",
      "E ",
      "Ba ",
      "Zhou ",
      "Zhi ",
      "Yao ",
      "Ke ",
      "Yi ",
      "Qing ",
      "Shi ",
      "Ping "
    ];
  }
});

// node_modules/unidecode/data/x8f.js
var require_x8f = __commonJS({
  "node_modules/unidecode/data/x8f.js"(exports2, module2) {
    module2.exports = [
      "Er ",
      "Qiong ",
      "Ju ",
      "Jiao ",
      "Guang ",
      "Lu ",
      "Kai ",
      "Quan ",
      "Zhou ",
      "Zai ",
      "Zhi ",
      "She ",
      "Liang ",
      "Yu ",
      "Shao ",
      "You ",
      "Huan ",
      "Yun ",
      "Zhe ",
      "Wan ",
      "Fu ",
      "Qing ",
      "Zhou ",
      "Ni ",
      "Ling ",
      "Zhe ",
      "Zhan ",
      "Liang ",
      "Zi ",
      "Hui ",
      "Wang ",
      "Chuo ",
      "Guo ",
      "Kan ",
      "Yi ",
      "Peng ",
      "Qian ",
      "Gun ",
      "Nian ",
      "Pian ",
      "Guan ",
      "Bei ",
      "Lun ",
      "Pai ",
      "Liang ",
      "Ruan ",
      "Rou ",
      "Ji ",
      "Yang ",
      "Xian ",
      "Chuan ",
      "Cou ",
      "Qun ",
      "Ge ",
      "You ",
      "Hong ",
      "Shu ",
      "Fu ",
      "Zi ",
      "Fu ",
      "Wen ",
      "Ben ",
      "Zhan ",
      "Yu ",
      "Wen ",
      "Tao ",
      "Gu ",
      "Zhen ",
      "Xia ",
      "Yuan ",
      "Lu ",
      "Jiu ",
      "Chao ",
      "Zhuan ",
      "Wei ",
      "Hun ",
      "Sori ",
      "Che ",
      "Jiao ",
      "Zhan ",
      "Pu ",
      "Lao ",
      "Fen ",
      "Fan ",
      "Lin ",
      "Ge ",
      "Se ",
      "Kan ",
      "Huan ",
      "Yi ",
      "Ji ",
      "Dui ",
      "Er ",
      "Yu ",
      "Xian ",
      "Hong ",
      "Lei ",
      "Pei ",
      "Li ",
      "Li ",
      "Lu ",
      "Lin ",
      "Che ",
      "Ya ",
      "Gui ",
      "Xuan ",
      "Di ",
      "Ren ",
      "Zhuan ",
      "E ",
      "Lun ",
      "Ruan ",
      "Hong ",
      "Ku ",
      "Ke ",
      "Lu ",
      "Zhou ",
      "Zhi ",
      "Yi ",
      "Hu ",
      "Zhen ",
      "Li ",
      "Yao ",
      "Qing ",
      "Shi ",
      "Zai ",
      "Zhi ",
      "Jiao ",
      "Zhou ",
      "Quan ",
      "Lu ",
      "Jiao ",
      "Zhe ",
      "Fu ",
      "Liang ",
      "Nian ",
      "Bei ",
      "Hui ",
      "Gun ",
      "Wang ",
      "Liang ",
      "Chuo ",
      "Zi ",
      "Cou ",
      "Fu ",
      "Ji ",
      "Wen ",
      "Shu ",
      "Pei ",
      "Yuan ",
      "Xia ",
      "Zhan ",
      "Lu ",
      "Che ",
      "Lin ",
      "Xin ",
      "Gu ",
      "Ci ",
      "Ci ",
      "Pi ",
      "Zui ",
      "Bian ",
      "La ",
      "La ",
      "Ci ",
      "Xue ",
      "Ban ",
      "Bian ",
      "Bian ",
      "Bian ",
      "[?] ",
      "Bian ",
      "Ban ",
      "Ci ",
      "Bian ",
      "Bian ",
      "Chen ",
      "Ru ",
      "Nong ",
      "Nong ",
      "Zhen ",
      "Chuo ",
      "Chuo ",
      "Suberu ",
      "Reng ",
      "Bian ",
      "Bian ",
      "Sip ",
      "Ip ",
      "Liao ",
      "Da ",
      "Chan ",
      "Gan ",
      "Qian ",
      "Yu ",
      "Yu ",
      "Qi ",
      "Xun ",
      "Yi ",
      "Guo ",
      "Mai ",
      "Qi ",
      "Za ",
      "Wang ",
      "Jia ",
      "Zhun ",
      "Ying ",
      "Ti ",
      "Yun ",
      "Jin ",
      "Hang ",
      "Ya ",
      "Fan ",
      "Wu ",
      "Da ",
      "E ",
      "Huan ",
      "Zhe ",
      "Totemo ",
      "Jin ",
      "Yuan ",
      "Wei ",
      "Lian ",
      "Chi ",
      "Che ",
      "Ni ",
      "Tiao ",
      "Zhi ",
      "Yi ",
      "Jiong ",
      "Jia ",
      "Chen ",
      "Dai ",
      "Er ",
      "Di ",
      "Po ",
      "Wang ",
      "Die ",
      "Ze ",
      "Tao ",
      "Shu ",
      "Tuo ",
      "Kep ",
      "Jing ",
      "Hui ",
      "Tong ",
      "You ",
      "Mi ",
      "Beng ",
      "Ji ",
      "Nai ",
      "Yi ",
      "Jie ",
      "Zhui ",
      "Lie ",
      "Xun "
    ];
  }
});

// node_modules/unidecode/data/x90.js
var require_x90 = __commonJS({
  "node_modules/unidecode/data/x90.js"(exports2, module2) {
    module2.exports = [
      "Tui ",
      "Song ",
      "Gua ",
      "Tao ",
      "Pang ",
      "Hou ",
      "Ni ",
      "Dun ",
      "Jiong ",
      "Xuan ",
      "Xun ",
      "Bu ",
      "You ",
      "Xiao ",
      "Qiu ",
      "Tou ",
      "Zhu ",
      "Qiu ",
      "Di ",
      "Di ",
      "Tu ",
      "Jing ",
      "Ti ",
      "Dou ",
      "Yi ",
      "Zhe ",
      "Tong ",
      "Guang ",
      "Wu ",
      "Shi ",
      "Cheng ",
      "Su ",
      "Zao ",
      "Qun ",
      "Feng ",
      "Lian ",
      "Suo ",
      "Hui ",
      "Li ",
      "Sako ",
      "Lai ",
      "Ben ",
      "Cuo ",
      "Jue ",
      "Beng ",
      "Huan ",
      "Dai ",
      "Lu ",
      "You ",
      "Zhou ",
      "Jin ",
      "Yu ",
      "Chuo ",
      "Kui ",
      "Wei ",
      "Ti ",
      "Yi ",
      "Da ",
      "Yuan ",
      "Luo ",
      "Bi ",
      "Nuo ",
      "Yu ",
      "Dang ",
      "Sui ",
      "Dun ",
      "Sui ",
      "Yan ",
      "Chuan ",
      "Chi ",
      "Ti ",
      "Yu ",
      "Shi ",
      "Zhen ",
      "You ",
      "Yun ",
      "E ",
      "Bian ",
      "Guo ",
      "E ",
      "Xia ",
      "Huang ",
      "Qiu ",
      "Dao ",
      "Da ",
      "Wei ",
      "Appare ",
      "Yi ",
      "Gou ",
      "Yao ",
      "Chu ",
      "Liu ",
      "Xun ",
      "Ta ",
      "Di ",
      "Chi ",
      "Yuan ",
      "Su ",
      "Ta ",
      "Qian ",
      "[?] ",
      "Yao ",
      "Guan ",
      "Zhang ",
      "Ao ",
      "Shi ",
      "Ce ",
      "Chi ",
      "Su ",
      "Zao ",
      "Zhe ",
      "Dun ",
      "Di ",
      "Lou ",
      "Chi ",
      "Cuo ",
      "Lin ",
      "Zun ",
      "Rao ",
      "Qian ",
      "Xuan ",
      "Yu ",
      "Yi ",
      "Wu ",
      "Liao ",
      "Ju ",
      "Shi ",
      "Bi ",
      "Yao ",
      "Mai ",
      "Xie ",
      "Sui ",
      "Huan ",
      "Zhan ",
      "Teng ",
      "Er ",
      "Miao ",
      "Bian ",
      "Bian ",
      "La ",
      "Li ",
      "Yuan ",
      "Yao ",
      "Luo ",
      "Li ",
      "Yi ",
      "Ting ",
      "Deng ",
      "Qi ",
      "Yong ",
      "Shan ",
      "Han ",
      "Yu ",
      "Mang ",
      "Ru ",
      "Qiong ",
      "[?] ",
      "Kuang ",
      "Fu ",
      "Kang ",
      "Bin ",
      "Fang ",
      "Xing ",
      "Na ",
      "Xin ",
      "Shen ",
      "Bang ",
      "Yuan ",
      "Cun ",
      "Huo ",
      "Xie ",
      "Bang ",
      "Wu ",
      "Ju ",
      "You ",
      "Han ",
      "Tai ",
      "Qiu ",
      "Bi ",
      "Pei ",
      "Bing ",
      "Shao ",
      "Bei ",
      "Wa ",
      "Di ",
      "Zou ",
      "Ye ",
      "Lin ",
      "Kuang ",
      "Gui ",
      "Zhu ",
      "Shi ",
      "Ku ",
      "Yu ",
      "Gai ",
      "Ge ",
      "Xi ",
      "Zhi ",
      "Ji ",
      "Xun ",
      "Hou ",
      "Xing ",
      "Jiao ",
      "Xi ",
      "Gui ",
      "Nuo ",
      "Lang ",
      "Jia ",
      "Kuai ",
      "Zheng ",
      "Otoko ",
      "Yun ",
      "Yan ",
      "Cheng ",
      "Dou ",
      "Chi ",
      "Lu ",
      "Fu ",
      "Wu ",
      "Fu ",
      "Gao ",
      "Hao ",
      "Lang ",
      "Jia ",
      "Geng ",
      "Jun ",
      "Ying ",
      "Bo ",
      "Xi ",
      "Bei ",
      "Li ",
      "Yun ",
      "Bu ",
      "Xiao ",
      "Qi ",
      "Pi ",
      "Qing ",
      "Guo ",
      "Zhou ",
      "Tan ",
      "Zou ",
      "Ping ",
      "Lai ",
      "Ni ",
      "Chen ",
      "You ",
      "Bu ",
      "Xiang ",
      "Dan ",
      "Ju ",
      "Yong ",
      "Qiao ",
      "Yi ",
      "Du ",
      "Yan ",
      "Mei "
    ];
  }
});

// node_modules/unidecode/data/x91.js
var require_x91 = __commonJS({
  "node_modules/unidecode/data/x91.js"(exports2, module2) {
    module2.exports = [
      "Ruo ",
      "Bei ",
      "E ",
      "Yu ",
      "Juan ",
      "Yu ",
      "Yun ",
      "Hou ",
      "Kui ",
      "Xiang ",
      "Xiang ",
      "Sou ",
      "Tang ",
      "Ming ",
      "Xi ",
      "Ru ",
      "Chu ",
      "Zi ",
      "Zou ",
      "Ju ",
      "Wu ",
      "Xiang ",
      "Yun ",
      "Hao ",
      "Yong ",
      "Bi ",
      "Mo ",
      "Chao ",
      "Fu ",
      "Liao ",
      "Yin ",
      "Zhuan ",
      "Hu ",
      "Qiao ",
      "Yan ",
      "Zhang ",
      "Fan ",
      "Qiao ",
      "Xu ",
      "Deng ",
      "Bi ",
      "Xin ",
      "Bi ",
      "Ceng ",
      "Wei ",
      "Zheng ",
      "Mao ",
      "Shan ",
      "Lin ",
      "Po ",
      "Dan ",
      "Meng ",
      "Ye ",
      "Cao ",
      "Kuai ",
      "Feng ",
      "Meng ",
      "Zou ",
      "Kuang ",
      "Lian ",
      "Zan ",
      "Chan ",
      "You ",
      "Qi ",
      "Yan ",
      "Chan ",
      "Zan ",
      "Ling ",
      "Huan ",
      "Xi ",
      "Feng ",
      "Zan ",
      "Li ",
      "You ",
      "Ding ",
      "Qiu ",
      "Zhuo ",
      "Pei ",
      "Zhou ",
      "Yi ",
      "Hang ",
      "Yu ",
      "Jiu ",
      "Yan ",
      "Zui ",
      "Mao ",
      "Dan ",
      "Xu ",
      "Tou ",
      "Zhen ",
      "Fen ",
      "Sakenomoto ",
      "[?] ",
      "Yun ",
      "Tai ",
      "Tian ",
      "Qia ",
      "Tuo ",
      "Zuo ",
      "Han ",
      "Gu ",
      "Su ",
      "Po ",
      "Chou ",
      "Zai ",
      "Ming ",
      "Luo ",
      "Chuo ",
      "Chou ",
      "You ",
      "Tong ",
      "Zhi ",
      "Xian ",
      "Jiang ",
      "Cheng ",
      "Yin ",
      "Tu ",
      "Xiao ",
      "Mei ",
      "Ku ",
      "Suan ",
      "Lei ",
      "Pu ",
      "Zui ",
      "Hai ",
      "Yan ",
      "Xi ",
      "Niang ",
      "Wei ",
      "Lu ",
      "Lan ",
      "Yan ",
      "Tao ",
      "Pei ",
      "Zhan ",
      "Chun ",
      "Tan ",
      "Zui ",
      "Chuo ",
      "Cu ",
      "Kun ",
      "Ti ",
      "Mian ",
      "Du ",
      "Hu ",
      "Xu ",
      "Xing ",
      "Tan ",
      "Jiu ",
      "Chun ",
      "Yun ",
      "Po ",
      "Ke ",
      "Sou ",
      "Mi ",
      "Quan ",
      "Chou ",
      "Cuo ",
      "Yun ",
      "Yong ",
      "Ang ",
      "Zha ",
      "Hai ",
      "Tang ",
      "Jiang ",
      "Piao ",
      "Shan ",
      "Yu ",
      "Li ",
      "Zao ",
      "Lao ",
      "Yi ",
      "Jiang ",
      "Pu ",
      "Jiao ",
      "Xi ",
      "Tan ",
      "Po ",
      "Nong ",
      "Yi ",
      "Li ",
      "Ju ",
      "Jiao ",
      "Yi ",
      "Niang ",
      "Ru ",
      "Xun ",
      "Chou ",
      "Yan ",
      "Ling ",
      "Mi ",
      "Mi ",
      "Niang ",
      "Xin ",
      "Jiao ",
      "Xi ",
      "Mi ",
      "Yan ",
      "Bian ",
      "Cai ",
      "Shi ",
      "You ",
      "Shi ",
      "Shi ",
      "Li ",
      "Zhong ",
      "Ye ",
      "Liang ",
      "Li ",
      "Jin ",
      "Jin ",
      "Qiu ",
      "Yi ",
      "Diao ",
      "Dao ",
      "Zhao ",
      "Ding ",
      "Po ",
      "Qiu ",
      "He ",
      "Fu ",
      "Zhen ",
      "Zhi ",
      "Ba ",
      "Luan ",
      "Fu ",
      "Nai ",
      "Diao ",
      "Shan ",
      "Qiao ",
      "Kou ",
      "Chuan ",
      "Zi ",
      "Fan ",
      "Yu ",
      "Hua ",
      "Han ",
      "Gong ",
      "Qi ",
      "Mang ",
      "Ri ",
      "Di ",
      "Si ",
      "Xi ",
      "Yi ",
      "Chai ",
      "Shi ",
      "Tu ",
      "Xi ",
      "Nu ",
      "Qian ",
      "Ishiyumi ",
      "Jian ",
      "Pi ",
      "Ye ",
      "Yin "
    ];
  }
});

// node_modules/unidecode/data/x92.js
var require_x92 = __commonJS({
  "node_modules/unidecode/data/x92.js"(exports2, module2) {
    module2.exports = [
      "Ba ",
      "Fang ",
      "Chen ",
      "Xing ",
      "Tou ",
      "Yue ",
      "Yan ",
      "Fu ",
      "Pi ",
      "Na ",
      "Xin ",
      "E ",
      "Jue ",
      "Dun ",
      "Gou ",
      "Yin ",
      "Qian ",
      "Ban ",
      "Ji ",
      "Ren ",
      "Chao ",
      "Niu ",
      "Fen ",
      "Yun ",
      "Ji ",
      "Qin ",
      "Pi ",
      "Guo ",
      "Hong ",
      "Yin ",
      "Jun ",
      "Shi ",
      "Yi ",
      "Zhong ",
      "Nie ",
      "Gai ",
      "Ri ",
      "Huo ",
      "Tai ",
      "Kang ",
      "Habaki ",
      "Irori ",
      "Ngaak ",
      "[?] ",
      "Duo ",
      "Zi ",
      "Ni ",
      "Tu ",
      "Shi ",
      "Min ",
      "Gu ",
      "E ",
      "Ling ",
      "Bing ",
      "Yi ",
      "Gu ",
      "Ba ",
      "Pi ",
      "Yu ",
      "Si ",
      "Zuo ",
      "Bu ",
      "You ",
      "Dian ",
      "Jia ",
      "Zhen ",
      "Shi ",
      "Shi ",
      "Tie ",
      "Ju ",
      "Zhan ",
      "Shi ",
      "She ",
      "Xuan ",
      "Zhao ",
      "Bao ",
      "He ",
      "Bi ",
      "Sheng ",
      "Chu ",
      "Shi ",
      "Bo ",
      "Zhu ",
      "Chi ",
      "Za ",
      "Po ",
      "Tong ",
      "Qian ",
      "Fu ",
      "Zhai ",
      "Liu ",
      "Qian ",
      "Fu ",
      "Li ",
      "Yue ",
      "Pi ",
      "Yang ",
      "Ban ",
      "Bo ",
      "Jie ",
      "Gou ",
      "Shu ",
      "Zheng ",
      "Mu ",
      "Ni ",
      "Nie ",
      "Di ",
      "Jia ",
      "Mu ",
      "Dan ",
      "Shen ",
      "Yi ",
      "Si ",
      "Kuang ",
      "Ka ",
      "Bei ",
      "Jian ",
      "Tong ",
      "Xing ",
      "Hong ",
      "Jiao ",
      "Chi ",
      "Er ",
      "Ge ",
      "Bing ",
      "Shi ",
      "Mou ",
      "Jia ",
      "Yin ",
      "Jun ",
      "Zhou ",
      "Chong ",
      "Shang ",
      "Tong ",
      "Mo ",
      "Lei ",
      "Ji ",
      "Yu ",
      "Xu ",
      "Ren ",
      "Zun ",
      "Zhi ",
      "Qiong ",
      "Shan ",
      "Chi ",
      "Xian ",
      "Xing ",
      "Quan ",
      "Pi ",
      "Tie ",
      "Zhu ",
      "Hou ",
      "Ming ",
      "Kua ",
      "Yao ",
      "Xian ",
      "Xian ",
      "Xiu ",
      "Jun ",
      "Cha ",
      "Lao ",
      "Ji ",
      "Pi ",
      "Ru ",
      "Mi ",
      "Yi ",
      "Yin ",
      "Guang ",
      "An ",
      "Diou ",
      "You ",
      "Se ",
      "Kao ",
      "Qian ",
      "Luan ",
      "Kasugai ",
      "Ai ",
      "Diao ",
      "Han ",
      "Rui ",
      "Shi ",
      "Keng ",
      "Qiu ",
      "Xiao ",
      "Zhe ",
      "Xiu ",
      "Zang ",
      "Ti ",
      "Cuo ",
      "Gua ",
      "Gong ",
      "Zhong ",
      "Dou ",
      "Lu ",
      "Mei ",
      "Lang ",
      "Wan ",
      "Xin ",
      "Yun ",
      "Bei ",
      "Wu ",
      "Su ",
      "Yu ",
      "Chan ",
      "Ting ",
      "Bo ",
      "Han ",
      "Jia ",
      "Hong ",
      "Cuan ",
      "Feng ",
      "Chan ",
      "Wan ",
      "Zhi ",
      "Si ",
      "Xuan ",
      "Wu ",
      "Wu ",
      "Tiao ",
      "Gong ",
      "Zhuo ",
      "Lue ",
      "Xing ",
      "Qian ",
      "Shen ",
      "Han ",
      "Lue ",
      "Xie ",
      "Chu ",
      "Zheng ",
      "Ju ",
      "Xian ",
      "Tie ",
      "Mang ",
      "Pu ",
      "Li ",
      "Pan ",
      "Rui ",
      "Cheng ",
      "Gao ",
      "Li ",
      "Te ",
      "Pyeng ",
      "Zhu ",
      "[?] ",
      "Tu ",
      "Liu ",
      "Zui ",
      "Ju ",
      "Chang ",
      "Yuan ",
      "Jian ",
      "Gang ",
      "Diao ",
      "Tao ",
      "Chang "
    ];
  }
});

// node_modules/unidecode/data/x93.js
var require_x93 = __commonJS({
  "node_modules/unidecode/data/x93.js"(exports2, module2) {
    module2.exports = [
      "Lun ",
      "Kua ",
      "Ling ",
      "Bei ",
      "Lu ",
      "Li ",
      "Qiang ",
      "Pou ",
      "Juan ",
      "Min ",
      "Zui ",
      "Peng ",
      "An ",
      "Pi ",
      "Xian ",
      "Ya ",
      "Zhui ",
      "Lei ",
      "A ",
      "Kong ",
      "Ta ",
      "Kun ",
      "Du ",
      "Wei ",
      "Chui ",
      "Zi ",
      "Zheng ",
      "Ben ",
      "Nie ",
      "Cong ",
      "Qun ",
      "Tan ",
      "Ding ",
      "Qi ",
      "Qian ",
      "Zhuo ",
      "Qi ",
      "Yu ",
      "Jin ",
      "Guan ",
      "Mao ",
      "Chang ",
      "Tian ",
      "Xi ",
      "Lian ",
      "Tao ",
      "Gu ",
      "Cuo ",
      "Shu ",
      "Zhen ",
      "Lu ",
      "Meng ",
      "Lu ",
      "Hua ",
      "Biao ",
      "Ga ",
      "Lai ",
      "Ken ",
      "Kazari ",
      "Bu ",
      "Nai ",
      "Wan ",
      "Zan ",
      "[?] ",
      "De ",
      "Xian ",
      "[?] ",
      "Huo ",
      "Liang ",
      "[?] ",
      "Men ",
      "Kai ",
      "Ying ",
      "Di ",
      "Lian ",
      "Guo ",
      "Xian ",
      "Du ",
      "Tu ",
      "Wei ",
      "Cong ",
      "Fu ",
      "Rou ",
      "Ji ",
      "E ",
      "Rou ",
      "Chen ",
      "Ti ",
      "Zha ",
      "Hong ",
      "Yang ",
      "Duan ",
      "Xia ",
      "Yu ",
      "Keng ",
      "Xing ",
      "Huang ",
      "Wei ",
      "Fu ",
      "Zhao ",
      "Cha ",
      "Qie ",
      "She ",
      "Hong ",
      "Kui ",
      "Tian ",
      "Mou ",
      "Qiao ",
      "Qiao ",
      "Hou ",
      "Tou ",
      "Cong ",
      "Huan ",
      "Ye ",
      "Min ",
      "Jian ",
      "Duan ",
      "Jian ",
      "Song ",
      "Kui ",
      "Hu ",
      "Xuan ",
      "Duo ",
      "Jie ",
      "Zhen ",
      "Bian ",
      "Zhong ",
      "Zi ",
      "Xiu ",
      "Ye ",
      "Mei ",
      "Pai ",
      "Ai ",
      "Jie ",
      "[?] ",
      "Mei ",
      "Chuo ",
      "Ta ",
      "Bang ",
      "Xia ",
      "Lian ",
      "Suo ",
      "Xi ",
      "Liu ",
      "Zu ",
      "Ye ",
      "Nou ",
      "Weng ",
      "Rong ",
      "Tang ",
      "Suo ",
      "Qiang ",
      "Ge ",
      "Shuo ",
      "Chui ",
      "Bo ",
      "Pan ",
      "Sa ",
      "Bi ",
      "Sang ",
      "Gang ",
      "Zi ",
      "Wu ",
      "Ying ",
      "Huang ",
      "Tiao ",
      "Liu ",
      "Kai ",
      "Sun ",
      "Sha ",
      "Sou ",
      "Wan ",
      "Hao ",
      "Zhen ",
      "Zhen ",
      "Luo ",
      "Yi ",
      "Yuan ",
      "Tang ",
      "Nie ",
      "Xi ",
      "Jia ",
      "Ge ",
      "Ma ",
      "Juan ",
      "Kasugai ",
      "Habaki ",
      "Suo ",
      "[?] ",
      "[?] ",
      "[?] ",
      "Na ",
      "Lu ",
      "Suo ",
      "Ou ",
      "Zu ",
      "Tuan ",
      "Xiu ",
      "Guan ",
      "Xuan ",
      "Lian ",
      "Shou ",
      "Ao ",
      "Man ",
      "Mo ",
      "Luo ",
      "Bi ",
      "Wei ",
      "Liu ",
      "Di ",
      "Qiao ",
      "Cong ",
      "Yi ",
      "Lu ",
      "Ao ",
      "Keng ",
      "Qiang ",
      "Cui ",
      "Qi ",
      "Chang ",
      "Tang ",
      "Man ",
      "Yong ",
      "Chan ",
      "Feng ",
      "Jing ",
      "Biao ",
      "Shu ",
      "Lou ",
      "Xiu ",
      "Cong ",
      "Long ",
      "Zan ",
      "Jian ",
      "Cao ",
      "Li ",
      "Xia ",
      "Xi ",
      "Kang ",
      "[?] ",
      "Beng ",
      "[?] ",
      "[?] ",
      "Zheng ",
      "Lu ",
      "Hua ",
      "Ji ",
      "Pu ",
      "Hui ",
      "Qiang ",
      "Po ",
      "Lin ",
      "Suo ",
      "Xiu ",
      "San ",
      "Cheng "
    ];
  }
});

// node_modules/unidecode/data/x94.js
var require_x94 = __commonJS({
  "node_modules/unidecode/data/x94.js"(exports2, module2) {
    module2.exports = [
      "Kui ",
      "Si ",
      "Liu ",
      "Nao ",
      "Heng ",
      "Pie ",
      "Sui ",
      "Fan ",
      "Qiao ",
      "Quan ",
      "Yang ",
      "Tang ",
      "Xiang ",
      "Jue ",
      "Jiao ",
      "Zun ",
      "Liao ",
      "Jie ",
      "Lao ",
      "Dui ",
      "Tan ",
      "Zan ",
      "Ji ",
      "Jian ",
      "Zhong ",
      "Deng ",
      "Ya ",
      "Ying ",
      "Dui ",
      "Jue ",
      "Nou ",
      "Ti ",
      "Pu ",
      "Tie ",
      "[?] ",
      "[?] ",
      "Ding ",
      "Shan ",
      "Kai ",
      "Jian ",
      "Fei ",
      "Sui ",
      "Lu ",
      "Juan ",
      "Hui ",
      "Yu ",
      "Lian ",
      "Zhuo ",
      "Qiao ",
      "Qian ",
      "Zhuo ",
      "Lei ",
      "Bi ",
      "Tie ",
      "Huan ",
      "Ye ",
      "Duo ",
      "Guo ",
      "Dang ",
      "Ju ",
      "Fen ",
      "Da ",
      "Bei ",
      "Yi ",
      "Ai ",
      "Zong ",
      "Xun ",
      "Diao ",
      "Zhu ",
      "Heng ",
      "Zhui ",
      "Ji ",
      "Nie ",
      "Ta ",
      "Huo ",
      "Qing ",
      "Bin ",
      "Ying ",
      "Kui ",
      "Ning ",
      "Xu ",
      "Jian ",
      "Jian ",
      "Yari ",
      "Cha ",
      "Zhi ",
      "Mie ",
      "Li ",
      "Lei ",
      "Ji ",
      "Zuan ",
      "Kuang ",
      "Shang ",
      "Peng ",
      "La ",
      "Du ",
      "Shuo ",
      "Chuo ",
      "Lu ",
      "Biao ",
      "Bao ",
      "Lu ",
      "[?] ",
      "[?] ",
      "Long ",
      "E ",
      "Lu ",
      "Xin ",
      "Jian ",
      "Lan ",
      "Bo ",
      "Jian ",
      "Yao ",
      "Chan ",
      "Xiang ",
      "Jian ",
      "Xi ",
      "Guan ",
      "Cang ",
      "Nie ",
      "Lei ",
      "Cuan ",
      "Qu ",
      "Pan ",
      "Luo ",
      "Zuan ",
      "Luan ",
      "Zao ",
      "Nie ",
      "Jue ",
      "Tang ",
      "Shu ",
      "Lan ",
      "Jin ",
      "Qiu ",
      "Yi ",
      "Zhen ",
      "Ding ",
      "Zhao ",
      "Po ",
      "Diao ",
      "Tu ",
      "Qian ",
      "Chuan ",
      "Shan ",
      "Ji ",
      "Fan ",
      "Diao ",
      "Men ",
      "Nu ",
      "Xi ",
      "Chai ",
      "Xing ",
      "Gai ",
      "Bu ",
      "Tai ",
      "Ju ",
      "Dun ",
      "Chao ",
      "Zhong ",
      "Na ",
      "Bei ",
      "Gang ",
      "Ban ",
      "Qian ",
      "Yao ",
      "Qin ",
      "Jun ",
      "Wu ",
      "Gou ",
      "Kang ",
      "Fang ",
      "Huo ",
      "Tou ",
      "Niu ",
      "Ba ",
      "Yu ",
      "Qian ",
      "Zheng ",
      "Qian ",
      "Gu ",
      "Bo ",
      "E ",
      "Po ",
      "Bu ",
      "Ba ",
      "Yue ",
      "Zuan ",
      "Mu ",
      "Dan ",
      "Jia ",
      "Dian ",
      "You ",
      "Tie ",
      "Bo ",
      "Ling ",
      "Shuo ",
      "Qian ",
      "Liu ",
      "Bao ",
      "Shi ",
      "Xuan ",
      "She ",
      "Bi ",
      "Ni ",
      "Pi ",
      "Duo ",
      "Xing ",
      "Kao ",
      "Lao ",
      "Er ",
      "Mang ",
      "Ya ",
      "You ",
      "Cheng ",
      "Jia ",
      "Ye ",
      "Nao ",
      "Zhi ",
      "Dang ",
      "Tong ",
      "Lu ",
      "Diao ",
      "Yin ",
      "Kai ",
      "Zha ",
      "Zhu ",
      "Xian ",
      "Ting ",
      "Diu ",
      "Xian ",
      "Hua ",
      "Quan ",
      "Sha ",
      "Jia ",
      "Yao ",
      "Ge ",
      "Ming ",
      "Zheng ",
      "Se ",
      "Jiao ",
      "Yi ",
      "Chan ",
      "Chong ",
      "Tang ",
      "An ",
      "Yin ",
      "Ru ",
      "Zhu ",
      "Lao ",
      "Pu ",
      "Wu ",
      "Lai ",
      "Te ",
      "Lian ",
      "Keng "
    ];
  }
});

// node_modules/unidecode/data/x95.js
var require_x95 = __commonJS({
  "node_modules/unidecode/data/x95.js"(exports2, module2) {
    module2.exports = [
      "Xiao ",
      "Suo ",
      "Li ",
      "Zheng ",
      "Chu ",
      "Guo ",
      "Gao ",
      "Tie ",
      "Xiu ",
      "Cuo ",
      "Lue ",
      "Feng ",
      "Xin ",
      "Liu ",
      "Kai ",
      "Jian ",
      "Rui ",
      "Ti ",
      "Lang ",
      "Qian ",
      "Ju ",
      "A ",
      "Qiang ",
      "Duo ",
      "Tian ",
      "Cuo ",
      "Mao ",
      "Ben ",
      "Qi ",
      "De ",
      "Kua ",
      "Kun ",
      "Chang ",
      "Xi ",
      "Gu ",
      "Luo ",
      "Chui ",
      "Zhui ",
      "Jin ",
      "Zhi ",
      "Xian ",
      "Juan ",
      "Huo ",
      "Pou ",
      "Tan ",
      "Ding ",
      "Jian ",
      "Ju ",
      "Meng ",
      "Zi ",
      "Qie ",
      "Ying ",
      "Kai ",
      "Qiang ",
      "Song ",
      "E ",
      "Cha ",
      "Qiao ",
      "Zhong ",
      "Duan ",
      "Sou ",
      "Huang ",
      "Huan ",
      "Ai ",
      "Du ",
      "Mei ",
      "Lou ",
      "Zi ",
      "Fei ",
      "Mei ",
      "Mo ",
      "Zhen ",
      "Bo ",
      "Ge ",
      "Nie ",
      "Tang ",
      "Juan ",
      "Nie ",
      "Na ",
      "Liu ",
      "Hao ",
      "Bang ",
      "Yi ",
      "Jia ",
      "Bin ",
      "Rong ",
      "Biao ",
      "Tang ",
      "Man ",
      "Luo ",
      "Beng ",
      "Yong ",
      "Jing ",
      "Di ",
      "Zu ",
      "Xuan ",
      "Liu ",
      "Tan ",
      "Jue ",
      "Liao ",
      "Pu ",
      "Lu ",
      "Dui ",
      "Lan ",
      "Pu ",
      "Cuan ",
      "Qiang ",
      "Deng ",
      "Huo ",
      "Lei ",
      "Huan ",
      "Zhuo ",
      "Lian ",
      "Yi ",
      "Cha ",
      "Biao ",
      "La ",
      "Chan ",
      "Xiang ",
      "Chang ",
      "Chang ",
      "Jiu ",
      "Ao ",
      "Die ",
      "Qu ",
      "Liao ",
      "Mi ",
      "Chang ",
      "Men ",
      "Ma ",
      "Shuan ",
      "Shan ",
      "Huo ",
      "Men ",
      "Yan ",
      "Bi ",
      "Han ",
      "Bi ",
      "San ",
      "Kai ",
      "Kang ",
      "Beng ",
      "Hong ",
      "Run ",
      "San ",
      "Xian ",
      "Xian ",
      "Jian ",
      "Min ",
      "Xia ",
      "Yuru ",
      "Dou ",
      "Zha ",
      "Nao ",
      "Jian ",
      "Peng ",
      "Xia ",
      "Ling ",
      "Bian ",
      "Bi ",
      "Run ",
      "He ",
      "Guan ",
      "Ge ",
      "Ge ",
      "Fa ",
      "Chu ",
      "Hong ",
      "Gui ",
      "Min ",
      "Se ",
      "Kun ",
      "Lang ",
      "Lu ",
      "Ting ",
      "Sha ",
      "Ju ",
      "Yue ",
      "Yue ",
      "Chan ",
      "Qu ",
      "Lin ",
      "Chang ",
      "Shai ",
      "Kun ",
      "Yan ",
      "Min ",
      "Yan ",
      "E ",
      "Hun ",
      "Yu ",
      "Wen ",
      "Xiang ",
      "Bao ",
      "Xiang ",
      "Qu ",
      "Yao ",
      "Wen ",
      "Ban ",
      "An ",
      "Wei ",
      "Yin ",
      "Kuo ",
      "Que ",
      "Lan ",
      "Du ",
      "[?] ",
      "Phwung ",
      "Tian ",
      "Nie ",
      "Ta ",
      "Kai ",
      "He ",
      "Que ",
      "Chuang ",
      "Guan ",
      "Dou ",
      "Qi ",
      "Kui ",
      "Tang ",
      "Guan ",
      "Piao ",
      "Kan ",
      "Xi ",
      "Hui ",
      "Chan ",
      "Pi ",
      "Dang ",
      "Huan ",
      "Ta ",
      "Wen ",
      "[?] ",
      "Men ",
      "Shuan ",
      "Shan ",
      "Yan ",
      "Han ",
      "Bi ",
      "Wen ",
      "Chuang ",
      "Run ",
      "Wei ",
      "Xian ",
      "Hong ",
      "Jian ",
      "Min ",
      "Kang ",
      "Men ",
      "Zha ",
      "Nao ",
      "Gui ",
      "Wen ",
      "Ta ",
      "Min ",
      "Lu ",
      "Kai "
    ];
  }
});

// node_modules/unidecode/data/x96.js
var require_x96 = __commonJS({
  "node_modules/unidecode/data/x96.js"(exports2, module2) {
    module2.exports = [
      "Fa ",
      "Ge ",
      "He ",
      "Kun ",
      "Jiu ",
      "Yue ",
      "Lang ",
      "Du ",
      "Yu ",
      "Yan ",
      "Chang ",
      "Xi ",
      "Wen ",
      "Hun ",
      "Yan ",
      "E ",
      "Chan ",
      "Lan ",
      "Qu ",
      "Hui ",
      "Kuo ",
      "Que ",
      "Ge ",
      "Tian ",
      "Ta ",
      "Que ",
      "Kan ",
      "Huan ",
      "Fu ",
      "Fu ",
      "Le ",
      "Dui ",
      "Xin ",
      "Qian ",
      "Wu ",
      "Yi ",
      "Tuo ",
      "Yin ",
      "Yang ",
      "Dou ",
      "E ",
      "Sheng ",
      "Ban ",
      "Pei ",
      "Keng ",
      "Yun ",
      "Ruan ",
      "Zhi ",
      "Pi ",
      "Jing ",
      "Fang ",
      "Yang ",
      "Yin ",
      "Zhen ",
      "Jie ",
      "Cheng ",
      "E ",
      "Qu ",
      "Di ",
      "Zu ",
      "Zuo ",
      "Dian ",
      "Ling ",
      "A ",
      "Tuo ",
      "Tuo ",
      "Po ",
      "Bing ",
      "Fu ",
      "Ji ",
      "Lu ",
      "Long ",
      "Chen ",
      "Xing ",
      "Duo ",
      "Lou ",
      "Mo ",
      "Jiang ",
      "Shu ",
      "Duo ",
      "Xian ",
      "Er ",
      "Gui ",
      "Yu ",
      "Gai ",
      "Shan ",
      "Xun ",
      "Qiao ",
      "Xing ",
      "Chun ",
      "Fu ",
      "Bi ",
      "Xia ",
      "Shan ",
      "Sheng ",
      "Zhi ",
      "Pu ",
      "Dou ",
      "Yuan ",
      "Zhen ",
      "Chu ",
      "Xian ",
      "Tou ",
      "Nie ",
      "Yun ",
      "Xian ",
      "Pei ",
      "Pei ",
      "Zou ",
      "Yi ",
      "Dui ",
      "Lun ",
      "Yin ",
      "Ju ",
      "Chui ",
      "Chen ",
      "Pi ",
      "Ling ",
      "Tao ",
      "Xian ",
      "Lu ",
      "Sheng ",
      "Xian ",
      "Yin ",
      "Zhu ",
      "Yang ",
      "Reng ",
      "Shan ",
      "Chong ",
      "Yan ",
      "Yin ",
      "Yu ",
      "Ti ",
      "Yu ",
      "Long ",
      "Wei ",
      "Wei ",
      "Nie ",
      "Dui ",
      "Sui ",
      "An ",
      "Huang ",
      "Jie ",
      "Sui ",
      "Yin ",
      "Gai ",
      "Yan ",
      "Hui ",
      "Ge ",
      "Yun ",
      "Wu ",
      "Wei ",
      "Ai ",
      "Xi ",
      "Tang ",
      "Ji ",
      "Zhang ",
      "Dao ",
      "Ao ",
      "Xi ",
      "Yin ",
      "[?] ",
      "Rao ",
      "Lin ",
      "Tui ",
      "Deng ",
      "Pi ",
      "Sui ",
      "Sui ",
      "Yu ",
      "Xian ",
      "Fen ",
      "Ni ",
      "Er ",
      "Ji ",
      "Dao ",
      "Xi ",
      "Yin ",
      "E ",
      "Hui ",
      "Long ",
      "Xi ",
      "Li ",
      "Li ",
      "Li ",
      "Zhui ",
      "He ",
      "Zhi ",
      "Zhun ",
      "Jun ",
      "Nan ",
      "Yi ",
      "Que ",
      "Yan ",
      "Qian ",
      "Ya ",
      "Xiong ",
      "Ya ",
      "Ji ",
      "Gu ",
      "Huan ",
      "Zhi ",
      "Gou ",
      "Jun ",
      "Ci ",
      "Yong ",
      "Ju ",
      "Chu ",
      "Hu ",
      "Za ",
      "Luo ",
      "Yu ",
      "Chou ",
      "Diao ",
      "Sui ",
      "Han ",
      "Huo ",
      "Shuang ",
      "Guan ",
      "Chu ",
      "Za ",
      "Yong ",
      "Ji ",
      "Xi ",
      "Chou ",
      "Liu ",
      "Li ",
      "Nan ",
      "Xue ",
      "Za ",
      "Ji ",
      "Ji ",
      "Yu ",
      "Yu ",
      "Xue ",
      "Na ",
      "Fou ",
      "Se ",
      "Mu ",
      "Wen ",
      "Fen ",
      "Pang ",
      "Yun ",
      "Li ",
      "Li ",
      "Ang ",
      "Ling ",
      "Lei ",
      "An ",
      "Bao ",
      "Meng ",
      "Dian ",
      "Dang ",
      "Xing ",
      "Wu ",
      "Zhao "
    ];
  }
});

// node_modules/unidecode/data/x97.js
var require_x97 = __commonJS({
  "node_modules/unidecode/data/x97.js"(exports2, module2) {
    module2.exports = [
      "Xu ",
      "Ji ",
      "Mu ",
      "Chen ",
      "Xiao ",
      "Zha ",
      "Ting ",
      "Zhen ",
      "Pei ",
      "Mei ",
      "Ling ",
      "Qi ",
      "Chou ",
      "Huo ",
      "Sha ",
      "Fei ",
      "Weng ",
      "Zhan ",
      "Yin ",
      "Ni ",
      "Chou ",
      "Tun ",
      "Lin ",
      "[?] ",
      "Dong ",
      "Ying ",
      "Wu ",
      "Ling ",
      "Shuang ",
      "Ling ",
      "Xia ",
      "Hong ",
      "Yin ",
      "Mo ",
      "Mai ",
      "Yun ",
      "Liu ",
      "Meng ",
      "Bin ",
      "Wu ",
      "Wei ",
      "Huo ",
      "Yin ",
      "Xi ",
      "Yi ",
      "Ai ",
      "Dan ",
      "Deng ",
      "Xian ",
      "Yu ",
      "Lu ",
      "Long ",
      "Dai ",
      "Ji ",
      "Pang ",
      "Yang ",
      "Ba ",
      "Pi ",
      "Wei ",
      "[?] ",
      "Xi ",
      "Ji ",
      "Mai ",
      "Meng ",
      "Meng ",
      "Lei ",
      "Li ",
      "Huo ",
      "Ai ",
      "Fei ",
      "Dai ",
      "Long ",
      "Ling ",
      "Ai ",
      "Feng ",
      "Li ",
      "Bao ",
      "[?] ",
      "He ",
      "He ",
      "Bing ",
      "Qing ",
      "Qing ",
      "Jing ",
      "Tian ",
      "Zhen ",
      "Jing ",
      "Cheng ",
      "Qing ",
      "Jing ",
      "Jing ",
      "Dian ",
      "Jing ",
      "Tian ",
      "Fei ",
      "Fei ",
      "Kao ",
      "Mi ",
      "Mian ",
      "Mian ",
      "Pao ",
      "Ye ",
      "Tian ",
      "Hui ",
      "Ye ",
      "Ge ",
      "Ding ",
      "Cha ",
      "Jian ",
      "Ren ",
      "Di ",
      "Du ",
      "Wu ",
      "Ren ",
      "Qin ",
      "Jin ",
      "Xue ",
      "Niu ",
      "Ba ",
      "Yin ",
      "Sa ",
      "Na ",
      "Mo ",
      "Zu ",
      "Da ",
      "Ban ",
      "Yi ",
      "Yao ",
      "Tao ",
      "Tuo ",
      "Jia ",
      "Hong ",
      "Pao ",
      "Yang ",
      "Tomo ",
      "Yin ",
      "Jia ",
      "Tao ",
      "Ji ",
      "Xie ",
      "An ",
      "An ",
      "Hen ",
      "Gong ",
      "Kohaze ",
      "Da ",
      "Qiao ",
      "Ting ",
      "Wan ",
      "Ying ",
      "Sui ",
      "Tiao ",
      "Qiao ",
      "Xuan ",
      "Kong ",
      "Beng ",
      "Ta ",
      "Zhang ",
      "Bing ",
      "Kuo ",
      "Ju ",
      "La ",
      "Xie ",
      "Rou ",
      "Bang ",
      "Yi ",
      "Qiu ",
      "Qiu ",
      "He ",
      "Xiao ",
      "Mu ",
      "Ju ",
      "Jian ",
      "Bian ",
      "Di ",
      "Jian ",
      "On ",
      "Tao ",
      "Gou ",
      "Ta ",
      "Bei ",
      "Xie ",
      "Pan ",
      "Ge ",
      "Bi ",
      "Kuo ",
      "Tang ",
      "Lou ",
      "Gui ",
      "Qiao ",
      "Xue ",
      "Ji ",
      "Jian ",
      "Jiang ",
      "Chan ",
      "Da ",
      "Huo ",
      "Xian ",
      "Qian ",
      "Du ",
      "Wa ",
      "Jian ",
      "Lan ",
      "Wei ",
      "Ren ",
      "Fu ",
      "Mei ",
      "Juan ",
      "Ge ",
      "Wei ",
      "Qiao ",
      "Han ",
      "Chang ",
      "[?] ",
      "Rou ",
      "Xun ",
      "She ",
      "Wei ",
      "Ge ",
      "Bei ",
      "Tao ",
      "Gou ",
      "Yun ",
      "[?] ",
      "Bi ",
      "Wei ",
      "Hui ",
      "Du ",
      "Wa ",
      "Du ",
      "Wei ",
      "Ren ",
      "Fu ",
      "Han ",
      "Wei ",
      "Yun ",
      "Tao ",
      "Jiu ",
      "Jiu ",
      "Xian ",
      "Xie ",
      "Xian ",
      "Ji ",
      "Yin ",
      "Za ",
      "Yun ",
      "Shao ",
      "Le ",
      "Peng ",
      "Heng ",
      "Ying ",
      "Yun ",
      "Peng ",
      "Yin ",
      "Yin ",
      "Xiang "
    ];
  }
});

// node_modules/unidecode/data/x98.js
var require_x98 = __commonJS({
  "node_modules/unidecode/data/x98.js"(exports2, module2) {
    module2.exports = [
      "Hu ",
      "Ye ",
      "Ding ",
      "Qing ",
      "Pan ",
      "Xiang ",
      "Shun ",
      "Han ",
      "Xu ",
      "Yi ",
      "Xu ",
      "Gu ",
      "Song ",
      "Kui ",
      "Qi ",
      "Hang ",
      "Yu ",
      "Wan ",
      "Ban ",
      "Dun ",
      "Di ",
      "Dan ",
      "Pan ",
      "Po ",
      "Ling ",
      "Ce ",
      "Jing ",
      "Lei ",
      "He ",
      "Qiao ",
      "E ",
      "E ",
      "Wei ",
      "Jie ",
      "Gua ",
      "Shen ",
      "Yi ",
      "Shen ",
      "Hai ",
      "Dui ",
      "Pian ",
      "Ping ",
      "Lei ",
      "Fu ",
      "Jia ",
      "Tou ",
      "Hui ",
      "Kui ",
      "Jia ",
      "Le ",
      "Tian ",
      "Cheng ",
      "Ying ",
      "Jun ",
      "Hu ",
      "Han ",
      "Jing ",
      "Tui ",
      "Tui ",
      "Pin ",
      "Lai ",
      "Tui ",
      "Zi ",
      "Zi ",
      "Chui ",
      "Ding ",
      "Lai ",
      "Yan ",
      "Han ",
      "Jian ",
      "Ke ",
      "Cui ",
      "Jiong ",
      "Qin ",
      "Yi ",
      "Sai ",
      "Ti ",
      "E ",
      "E ",
      "Yan ",
      "Hun ",
      "Kan ",
      "Yong ",
      "Zhuan ",
      "Yan ",
      "Xian ",
      "Xin ",
      "Yi ",
      "Yuan ",
      "Sang ",
      "Dian ",
      "Dian ",
      "Jiang ",
      "Ku ",
      "Lei ",
      "Liao ",
      "Piao ",
      "Yi ",
      "Man ",
      "Qi ",
      "Rao ",
      "Hao ",
      "Qiao ",
      "Gu ",
      "Xun ",
      "Qian ",
      "Hui ",
      "Zhan ",
      "Ru ",
      "Hong ",
      "Bin ",
      "Xian ",
      "Pin ",
      "Lu ",
      "Lan ",
      "Nie ",
      "Quan ",
      "Ye ",
      "Ding ",
      "Qing ",
      "Han ",
      "Xiang ",
      "Shun ",
      "Xu ",
      "Xu ",
      "Wan ",
      "Gu ",
      "Dun ",
      "Qi ",
      "Ban ",
      "Song ",
      "Hang ",
      "Yu ",
      "Lu ",
      "Ling ",
      "Po ",
      "Jing ",
      "Jie ",
      "Jia ",
      "Tian ",
      "Han ",
      "Ying ",
      "Jiong ",
      "Hai ",
      "Yi ",
      "Pin ",
      "Hui ",
      "Tui ",
      "Han ",
      "Ying ",
      "Ying ",
      "Ke ",
      "Ti ",
      "Yong ",
      "E ",
      "Zhuan ",
      "Yan ",
      "E ",
      "Nie ",
      "Man ",
      "Dian ",
      "Sang ",
      "Hao ",
      "Lei ",
      "Zhan ",
      "Ru ",
      "Pin ",
      "Quan ",
      "Feng ",
      "Biao ",
      "Oroshi ",
      "Fu ",
      "Xia ",
      "Zhan ",
      "Biao ",
      "Sa ",
      "Ba ",
      "Tai ",
      "Lie ",
      "Gua ",
      "Xuan ",
      "Shao ",
      "Ju ",
      "Bi ",
      "Si ",
      "Wei ",
      "Yang ",
      "Yao ",
      "Sou ",
      "Kai ",
      "Sao ",
      "Fan ",
      "Liu ",
      "Xi ",
      "Liao ",
      "Piao ",
      "Piao ",
      "Liu ",
      "Biao ",
      "Biao ",
      "Biao ",
      "Liao ",
      "[?] ",
      "Se ",
      "Feng ",
      "Biao ",
      "Feng ",
      "Yang ",
      "Zhan ",
      "Biao ",
      "Sa ",
      "Ju ",
      "Si ",
      "Sou ",
      "Yao ",
      "Liu ",
      "Piao ",
      "Biao ",
      "Biao ",
      "Fei ",
      "Fan ",
      "Fei ",
      "Fei ",
      "Shi ",
      "Shi ",
      "Can ",
      "Ji ",
      "Ding ",
      "Si ",
      "Tuo ",
      "Zhan ",
      "Sun ",
      "Xiang ",
      "Tun ",
      "Ren ",
      "Yu ",
      "Juan ",
      "Chi ",
      "Yin ",
      "Fan ",
      "Fan ",
      "Sun ",
      "Yin ",
      "Zhu ",
      "Yi ",
      "Zhai ",
      "Bi ",
      "Jie ",
      "Tao ",
      "Liu ",
      "Ci ",
      "Tie ",
      "Si ",
      "Bao ",
      "Shi ",
      "Duo "
    ];
  }
});

// node_modules/unidecode/data/x99.js
var require_x99 = __commonJS({
  "node_modules/unidecode/data/x99.js"(exports2, module2) {
    module2.exports = [
      "Hai ",
      "Ren ",
      "Tian ",
      "Jiao ",
      "Jia ",
      "Bing ",
      "Yao ",
      "Tong ",
      "Ci ",
      "Xiang ",
      "Yang ",
      "Yang ",
      "Er ",
      "Yan ",
      "Le ",
      "Yi ",
      "Can ",
      "Bo ",
      "Nei ",
      "E ",
      "Bu ",
      "Jun ",
      "Dou ",
      "Su ",
      "Yu ",
      "Shi ",
      "Yao ",
      "Hun ",
      "Guo ",
      "Shi ",
      "Jian ",
      "Zhui ",
      "Bing ",
      "Xian ",
      "Bu ",
      "Ye ",
      "Tan ",
      "Fei ",
      "Zhang ",
      "Wei ",
      "Guan ",
      "E ",
      "Nuan ",
      "Hun ",
      "Hu ",
      "Huang ",
      "Tie ",
      "Hui ",
      "Jian ",
      "Hou ",
      "He ",
      "Xing ",
      "Fen ",
      "Wei ",
      "Gu ",
      "Cha ",
      "Song ",
      "Tang ",
      "Bo ",
      "Gao ",
      "Xi ",
      "Kui ",
      "Liu ",
      "Sou ",
      "Tao ",
      "Ye ",
      "Yun ",
      "Mo ",
      "Tang ",
      "Man ",
      "Bi ",
      "Yu ",
      "Xiu ",
      "Jin ",
      "San ",
      "Kui ",
      "Zhuan ",
      "Shan ",
      "Chi ",
      "Dan ",
      "Yi ",
      "Ji ",
      "Rao ",
      "Cheng ",
      "Yong ",
      "Tao ",
      "Hui ",
      "Xiang ",
      "Zhan ",
      "Fen ",
      "Hai ",
      "Meng ",
      "Yan ",
      "Mo ",
      "Chan ",
      "Xiang ",
      "Luo ",
      "Zuan ",
      "Nang ",
      "Shi ",
      "Ding ",
      "Ji ",
      "Tuo ",
      "Xing ",
      "Tun ",
      "Xi ",
      "Ren ",
      "Yu ",
      "Chi ",
      "Fan ",
      "Yin ",
      "Jian ",
      "Shi ",
      "Bao ",
      "Si ",
      "Duo ",
      "Yi ",
      "Er ",
      "Rao ",
      "Xiang ",
      "Jia ",
      "Le ",
      "Jiao ",
      "Yi ",
      "Bing ",
      "Bo ",
      "Dou ",
      "E ",
      "Yu ",
      "Nei ",
      "Jun ",
      "Guo ",
      "Hun ",
      "Xian ",
      "Guan ",
      "Cha ",
      "Kui ",
      "Gu ",
      "Sou ",
      "Chan ",
      "Ye ",
      "Mo ",
      "Bo ",
      "Liu ",
      "Xiu ",
      "Jin ",
      "Man ",
      "San ",
      "Zhuan ",
      "Nang ",
      "Shou ",
      "Kui ",
      "Guo ",
      "Xiang ",
      "Fen ",
      "Ba ",
      "Ni ",
      "Bi ",
      "Bo ",
      "Tu ",
      "Han ",
      "Fei ",
      "Jian ",
      "An ",
      "Ai ",
      "Fu ",
      "Xian ",
      "Wen ",
      "Xin ",
      "Fen ",
      "Bin ",
      "Xing ",
      "Ma ",
      "Yu ",
      "Feng ",
      "Han ",
      "Di ",
      "Tuo ",
      "Tuo ",
      "Chi ",
      "Xun ",
      "Zhu ",
      "Zhi ",
      "Pei ",
      "Xin ",
      "Ri ",
      "Sa ",
      "Yin ",
      "Wen ",
      "Zhi ",
      "Dan ",
      "Lu ",
      "You ",
      "Bo ",
      "Bao ",
      "Kuai ",
      "Tuo ",
      "Yi ",
      "Qu ",
      "[?] ",
      "Qu ",
      "Jiong ",
      "Bo ",
      "Zhao ",
      "Yuan ",
      "Peng ",
      "Zhou ",
      "Ju ",
      "Zhu ",
      "Nu ",
      "Ju ",
      "Pi ",
      "Zang ",
      "Jia ",
      "Ling ",
      "Zhen ",
      "Tai ",
      "Fu ",
      "Yang ",
      "Shi ",
      "Bi ",
      "Tuo ",
      "Tuo ",
      "Si ",
      "Liu ",
      "Ma ",
      "Pian ",
      "Tao ",
      "Zhi ",
      "Rong ",
      "Teng ",
      "Dong ",
      "Xun ",
      "Quan ",
      "Shen ",
      "Jiong ",
      "Er ",
      "Hai ",
      "Bo ",
      "Zhu ",
      "Yin ",
      "Luo ",
      "Shuu ",
      "Dan ",
      "Xie ",
      "Liu ",
      "Ju ",
      "Song ",
      "Qin ",
      "Mang ",
      "Liang ",
      "Han ",
      "Tu ",
      "Xuan ",
      "Tui ",
      "Jun "
    ];
  }
});

// node_modules/unidecode/data/x9a.js
var require_x9a = __commonJS({
  "node_modules/unidecode/data/x9a.js"(exports2, module2) {
    module2.exports = [
      "E ",
      "Cheng ",
      "Xin ",
      "Ai ",
      "Lu ",
      "Zhui ",
      "Zhou ",
      "She ",
      "Pian ",
      "Kun ",
      "Tao ",
      "Lai ",
      "Zong ",
      "Ke ",
      "Qi ",
      "Qi ",
      "Yan ",
      "Fei ",
      "Sao ",
      "Yan ",
      "Jie ",
      "Yao ",
      "Wu ",
      "Pian ",
      "Cong ",
      "Pian ",
      "Qian ",
      "Fei ",
      "Huang ",
      "Jian ",
      "Huo ",
      "Yu ",
      "Ti ",
      "Quan ",
      "Xia ",
      "Zong ",
      "Kui ",
      "Rou ",
      "Si ",
      "Gua ",
      "Tuo ",
      "Kui ",
      "Sou ",
      "Qian ",
      "Cheng ",
      "Zhi ",
      "Liu ",
      "Pang ",
      "Teng ",
      "Xi ",
      "Cao ",
      "Du ",
      "Yan ",
      "Yuan ",
      "Zou ",
      "Sao ",
      "Shan ",
      "Li ",
      "Zhi ",
      "Shuang ",
      "Lu ",
      "Xi ",
      "Luo ",
      "Zhang ",
      "Mo ",
      "Ao ",
      "Can ",
      "Piao ",
      "Cong ",
      "Qu ",
      "Bi ",
      "Zhi ",
      "Yu ",
      "Xu ",
      "Hua ",
      "Bo ",
      "Su ",
      "Xiao ",
      "Lin ",
      "Chan ",
      "Dun ",
      "Liu ",
      "Tuo ",
      "Zeng ",
      "Tan ",
      "Jiao ",
      "Tie ",
      "Yan ",
      "Luo ",
      "Zhan ",
      "Jing ",
      "Yi ",
      "Ye ",
      "Tuo ",
      "Bin ",
      "Zou ",
      "Yan ",
      "Peng ",
      "Lu ",
      "Teng ",
      "Xiang ",
      "Ji ",
      "Shuang ",
      "Ju ",
      "Xi ",
      "Huan ",
      "Li ",
      "Biao ",
      "Ma ",
      "Yu ",
      "Tuo ",
      "Xun ",
      "Chi ",
      "Qu ",
      "Ri ",
      "Bo ",
      "Lu ",
      "Zang ",
      "Shi ",
      "Si ",
      "Fu ",
      "Ju ",
      "Zou ",
      "Zhu ",
      "Tuo ",
      "Nu ",
      "Jia ",
      "Yi ",
      "Tai ",
      "Xiao ",
      "Ma ",
      "Yin ",
      "Jiao ",
      "Hua ",
      "Luo ",
      "Hai ",
      "Pian ",
      "Biao ",
      "Li ",
      "Cheng ",
      "Yan ",
      "Xin ",
      "Qin ",
      "Jun ",
      "Qi ",
      "Qi ",
      "Ke ",
      "Zhui ",
      "Zong ",
      "Su ",
      "Can ",
      "Pian ",
      "Zhi ",
      "Kui ",
      "Sao ",
      "Wu ",
      "Ao ",
      "Liu ",
      "Qian ",
      "Shan ",
      "Piao ",
      "Luo ",
      "Cong ",
      "Chan ",
      "Zou ",
      "Ji ",
      "Shuang ",
      "Xiang ",
      "Gu ",
      "Wei ",
      "Wei ",
      "Wei ",
      "Yu ",
      "Gan ",
      "Yi ",
      "Ang ",
      "Tou ",
      "Xie ",
      "Bao ",
      "Bi ",
      "Chi ",
      "Ti ",
      "Di ",
      "Ku ",
      "Hai ",
      "Qiao ",
      "Gou ",
      "Kua ",
      "Ge ",
      "Tui ",
      "Geng ",
      "Pian ",
      "Bi ",
      "Ke ",
      "Ka ",
      "Yu ",
      "Sui ",
      "Lou ",
      "Bo ",
      "Xiao ",
      "Pang ",
      "Bo ",
      "Ci ",
      "Kuan ",
      "Bin ",
      "Mo ",
      "Liao ",
      "Lou ",
      "Nao ",
      "Du ",
      "Zang ",
      "Sui ",
      "Ti ",
      "Bin ",
      "Kuan ",
      "Lu ",
      "Gao ",
      "Gao ",
      "Qiao ",
      "Kao ",
      "Qiao ",
      "Lao ",
      "Zao ",
      "Biao ",
      "Kun ",
      "Kun ",
      "Ti ",
      "Fang ",
      "Xiu ",
      "Ran ",
      "Mao ",
      "Dan ",
      "Kun ",
      "Bin ",
      "Fa ",
      "Tiao ",
      "Peng ",
      "Zi ",
      "Fa ",
      "Ran ",
      "Ti ",
      "Pao ",
      "Pi ",
      "Mao ",
      "Fu ",
      "Er ",
      "Rong ",
      "Qu ",
      "Gong ",
      "Xiu ",
      "Gua ",
      "Ji ",
      "Peng ",
      "Zhua ",
      "Shao ",
      "Sha "
    ];
  }
});

// node_modules/unidecode/data/x9b.js
var require_x9b = __commonJS({
  "node_modules/unidecode/data/x9b.js"(exports2, module2) {
    module2.exports = [
      "Ti ",
      "Li ",
      "Bin ",
      "Zong ",
      "Ti ",
      "Peng ",
      "Song ",
      "Zheng ",
      "Quan ",
      "Zong ",
      "Shun ",
      "Jian ",
      "Duo ",
      "Hu ",
      "La ",
      "Jiu ",
      "Qi ",
      "Lian ",
      "Zhen ",
      "Bin ",
      "Peng ",
      "Mo ",
      "San ",
      "Man ",
      "Man ",
      "Seng ",
      "Xu ",
      "Lie ",
      "Qian ",
      "Qian ",
      "Nong ",
      "Huan ",
      "Kuai ",
      "Ning ",
      "Bin ",
      "Lie ",
      "Rang ",
      "Dou ",
      "Dou ",
      "Nao ",
      "Hong ",
      "Xi ",
      "Dou ",
      "Han ",
      "Dou ",
      "Dou ",
      "Jiu ",
      "Chang ",
      "Yu ",
      "Yu ",
      "Li ",
      "Juan ",
      "Fu ",
      "Qian ",
      "Gui ",
      "Zong ",
      "Liu ",
      "Gui ",
      "Shang ",
      "Yu ",
      "Gui ",
      "Mei ",
      "Ji ",
      "Qi ",
      "Jie ",
      "Kui ",
      "Hun ",
      "Ba ",
      "Po ",
      "Mei ",
      "Xu ",
      "Yan ",
      "Xiao ",
      "Liang ",
      "Yu ",
      "Tui ",
      "Qi ",
      "Wang ",
      "Liang ",
      "Wei ",
      "Jian ",
      "Chi ",
      "Piao ",
      "Bi ",
      "Mo ",
      "Ji ",
      "Xu ",
      "Chou ",
      "Yan ",
      "Zhan ",
      "Yu ",
      "Dao ",
      "Ren ",
      "Ji ",
      "Eri ",
      "Gong ",
      "Tuo ",
      "Diao ",
      "Ji ",
      "Xu ",
      "E ",
      "E ",
      "Sha ",
      "Hang ",
      "Tun ",
      "Mo ",
      "Jie ",
      "Shen ",
      "Fan ",
      "Yuan ",
      "Bi ",
      "Lu ",
      "Wen ",
      "Hu ",
      "Lu ",
      "Za ",
      "Fang ",
      "Fen ",
      "Na ",
      "You ",
      "Namazu ",
      "Todo ",
      "He ",
      "Xia ",
      "Qu ",
      "Han ",
      "Pi ",
      "Ling ",
      "Tuo ",
      "Bo ",
      "Qiu ",
      "Ping ",
      "Fu ",
      "Bi ",
      "Ji ",
      "Wei ",
      "Ju ",
      "Diao ",
      "Bo ",
      "You ",
      "Gun ",
      "Pi ",
      "Nian ",
      "Xing ",
      "Tai ",
      "Bao ",
      "Fu ",
      "Zha ",
      "Ju ",
      "Gu ",
      "Kajika ",
      "Tong ",
      "[?] ",
      "Ta ",
      "Jie ",
      "Shu ",
      "Hou ",
      "Xiang ",
      "Er ",
      "An ",
      "Wei ",
      "Tiao ",
      "Zhu ",
      "Yin ",
      "Lie ",
      "Luo ",
      "Tong ",
      "Yi ",
      "Qi ",
      "Bing ",
      "Wei ",
      "Jiao ",
      "Bu ",
      "Gui ",
      "Xian ",
      "Ge ",
      "Hui ",
      "Bora ",
      "Mate ",
      "Kao ",
      "Gori ",
      "Duo ",
      "Jun ",
      "Ti ",
      "Man ",
      "Xiao ",
      "Za ",
      "Sha ",
      "Qin ",
      "Yu ",
      "Nei ",
      "Zhe ",
      "Gun ",
      "Geng ",
      "Su ",
      "Wu ",
      "Qiu ",
      "Ting ",
      "Fu ",
      "Wan ",
      "You ",
      "Li ",
      "Sha ",
      "Sha ",
      "Gao ",
      "Meng ",
      "Ugui ",
      "Asari ",
      "Subashiri ",
      "Kazunoko ",
      "Yong ",
      "Ni ",
      "Zi ",
      "Qi ",
      "Qing ",
      "Xiang ",
      "Nei ",
      "Chun ",
      "Ji ",
      "Diao ",
      "Qie ",
      "Gu ",
      "Zhou ",
      "Dong ",
      "Lai ",
      "Fei ",
      "Ni ",
      "Yi ",
      "Kun ",
      "Lu ",
      "Jiu ",
      "Chang ",
      "Jing ",
      "Lun ",
      "Ling ",
      "Zou ",
      "Li ",
      "Meng ",
      "Zong ",
      "Zhi ",
      "Nian ",
      "Shachi ",
      "Dojou ",
      "Sukesou ",
      "Shi ",
      "Shen ",
      "Hun ",
      "Shi ",
      "Hou ",
      "Xing ",
      "Zhu ",
      "La ",
      "Zong ",
      "Ji ",
      "Bian ",
      "Bian "
    ];
  }
});

// node_modules/unidecode/data/x9c.js
var require_x9c = __commonJS({
  "node_modules/unidecode/data/x9c.js"(exports2, module2) {
    module2.exports = [
      "Huan ",
      "Quan ",
      "Ze ",
      "Wei ",
      "Wei ",
      "Yu ",
      "Qun ",
      "Rou ",
      "Die ",
      "Huang ",
      "Lian ",
      "Yan ",
      "Qiu ",
      "Qiu ",
      "Jian ",
      "Bi ",
      "E ",
      "Yang ",
      "Fu ",
      "Sai ",
      "Jian ",
      "Xia ",
      "Tuo ",
      "Hu ",
      "Muroaji ",
      "Ruo ",
      "Haraka ",
      "Wen ",
      "Jian ",
      "Hao ",
      "Wu ",
      "Fang ",
      "Sao ",
      "Liu ",
      "Ma ",
      "Shi ",
      "Shi ",
      "Yin ",
      "Z ",
      "Teng ",
      "Ta ",
      "Yao ",
      "Ge ",
      "Rong ",
      "Qian ",
      "Qi ",
      "Wen ",
      "Ruo ",
      "Hatahata ",
      "Lian ",
      "Ao ",
      "Le ",
      "Hui ",
      "Min ",
      "Ji ",
      "Tiao ",
      "Qu ",
      "Jian ",
      "Sao ",
      "Man ",
      "Xi ",
      "Qiu ",
      "Biao ",
      "Ji ",
      "Ji ",
      "Zhu ",
      "Jiang ",
      "Qiu ",
      "Zhuan ",
      "Yong ",
      "Zhang ",
      "Kang ",
      "Xue ",
      "Bie ",
      "Jue ",
      "Qu ",
      "Xiang ",
      "Bo ",
      "Jiao ",
      "Xun ",
      "Su ",
      "Huang ",
      "Zun ",
      "Shan ",
      "Shan ",
      "Fan ",
      "Jue ",
      "Lin ",
      "Xun ",
      "Miao ",
      "Xi ",
      "Eso ",
      "Kyou ",
      "Fen ",
      "Guan ",
      "Hou ",
      "Kuai ",
      "Zei ",
      "Sao ",
      "Zhan ",
      "Gan ",
      "Gui ",
      "Sheng ",
      "Li ",
      "Chang ",
      "Hatahata ",
      "Shiira ",
      "Mutsu ",
      "Ru ",
      "Ji ",
      "Xu ",
      "Huo ",
      "Shiira ",
      "Li ",
      "Lie ",
      "Li ",
      "Mie ",
      "Zhen ",
      "Xiang ",
      "E ",
      "Lu ",
      "Guan ",
      "Li ",
      "Xian ",
      "Yu ",
      "Dao ",
      "Ji ",
      "You ",
      "Tun ",
      "Lu ",
      "Fang ",
      "Ba ",
      "He ",
      "Bo ",
      "Ping ",
      "Nian ",
      "Lu ",
      "You ",
      "Zha ",
      "Fu ",
      "Bo ",
      "Bao ",
      "Hou ",
      "Pi ",
      "Tai ",
      "Gui ",
      "Jie ",
      "Kao ",
      "Wei ",
      "Er ",
      "Tong ",
      "Ze ",
      "Hou ",
      "Kuai ",
      "Ji ",
      "Jiao ",
      "Xian ",
      "Za ",
      "Xiang ",
      "Xun ",
      "Geng ",
      "Li ",
      "Lian ",
      "Jian ",
      "Li ",
      "Shi ",
      "Tiao ",
      "Gun ",
      "Sha ",
      "Wan ",
      "Jun ",
      "Ji ",
      "Yong ",
      "Qing ",
      "Ling ",
      "Qi ",
      "Zou ",
      "Fei ",
      "Kun ",
      "Chang ",
      "Gu ",
      "Ni ",
      "Nian ",
      "Diao ",
      "Jing ",
      "Shen ",
      "Shi ",
      "Zi ",
      "Fen ",
      "Die ",
      "Bi ",
      "Chang ",
      "Shi ",
      "Wen ",
      "Wei ",
      "Sai ",
      "E ",
      "Qiu ",
      "Fu ",
      "Huang ",
      "Quan ",
      "Jiang ",
      "Bian ",
      "Sao ",
      "Ao ",
      "Qi ",
      "Ta ",
      "Yin ",
      "Yao ",
      "Fang ",
      "Jian ",
      "Le ",
      "Biao ",
      "Xue ",
      "Bie ",
      "Man ",
      "Min ",
      "Yong ",
      "Wei ",
      "Xi ",
      "Jue ",
      "Shan ",
      "Lin ",
      "Zun ",
      "Huo ",
      "Gan ",
      "Li ",
      "Zhan ",
      "Guan ",
      "Niao ",
      "Yi ",
      "Fu ",
      "Li ",
      "Jiu ",
      "Bu ",
      "Yan ",
      "Fu ",
      "Diao ",
      "Ji ",
      "Feng ",
      "Nio ",
      "Gan ",
      "Shi ",
      "Feng ",
      "Ming ",
      "Bao ",
      "Yuan ",
      "Zhi ",
      "Hu ",
      "Qin ",
      "Fu ",
      "Fen ",
      "Wen ",
      "Jian ",
      "Shi ",
      "Yu "
    ];
  }
});

// node_modules/unidecode/data/x9d.js
var require_x9d = __commonJS({
  "node_modules/unidecode/data/x9d.js"(exports2, module2) {
    module2.exports = [
      "Fou ",
      "Yiao ",
      "Jue ",
      "Jue ",
      "Pi ",
      "Huan ",
      "Zhen ",
      "Bao ",
      "Yan ",
      "Ya ",
      "Zheng ",
      "Fang ",
      "Feng ",
      "Wen ",
      "Ou ",
      "Te ",
      "Jia ",
      "Nu ",
      "Ling ",
      "Mie ",
      "Fu ",
      "Tuo ",
      "Wen ",
      "Li ",
      "Bian ",
      "Zhi ",
      "Ge ",
      "Yuan ",
      "Zi ",
      "Qu ",
      "Xiao ",
      "Zhi ",
      "Dan ",
      "Ju ",
      "You ",
      "Gu ",
      "Zhong ",
      "Yu ",
      "Yang ",
      "Rong ",
      "Ya ",
      "Tie ",
      "Yu ",
      "Shigi ",
      "Ying ",
      "Zhui ",
      "Wu ",
      "Er ",
      "Gua ",
      "Ai ",
      "Zhi ",
      "Yan ",
      "Heng ",
      "Jiao ",
      "Ji ",
      "Lie ",
      "Zhu ",
      "Ren ",
      "Yi ",
      "Hong ",
      "Luo ",
      "Ru ",
      "Mou ",
      "Ge ",
      "Ren ",
      "Jiao ",
      "Xiu ",
      "Zhou ",
      "Zhi ",
      "Luo ",
      "Chidori ",
      "Toki ",
      "Ten ",
      "Luan ",
      "Jia ",
      "Ji ",
      "Yu ",
      "Huan ",
      "Tuo ",
      "Bu ",
      "Wu ",
      "Juan ",
      "Yu ",
      "Bo ",
      "Xun ",
      "Xun ",
      "Bi ",
      "Xi ",
      "Jun ",
      "Ju ",
      "Tu ",
      "Jing ",
      "Ti ",
      "E ",
      "E ",
      "Kuang ",
      "Hu ",
      "Wu ",
      "Shen ",
      "Lai ",
      "Ikaruga ",
      "Kakesu ",
      "Lu ",
      "Ping ",
      "Shu ",
      "Fu ",
      "An ",
      "Zhao ",
      "Peng ",
      "Qin ",
      "Qian ",
      "Bei ",
      "Diao ",
      "Lu ",
      "Que ",
      "Jian ",
      "Ju ",
      "Tu ",
      "Ya ",
      "Yuan ",
      "Qi ",
      "Li ",
      "Ye ",
      "Zhui ",
      "Kong ",
      "Zhui ",
      "Kun ",
      "Sheng ",
      "Qi ",
      "Jing ",
      "Yi ",
      "Yi ",
      "Jing ",
      "Zi ",
      "Lai ",
      "Dong ",
      "Qi ",
      "Chun ",
      "Geng ",
      "Ju ",
      "Qu ",
      "Isuka ",
      "Kikuitadaki ",
      "Ji ",
      "Shu ",
      "[?] ",
      "Chi ",
      "Miao ",
      "Rou ",
      "An ",
      "Qiu ",
      "Ti ",
      "Hu ",
      "Ti ",
      "E ",
      "Jie ",
      "Mao ",
      "Fu ",
      "Chun ",
      "Tu ",
      "Yan ",
      "He ",
      "Yuan ",
      "Pian ",
      "Yun ",
      "Mei ",
      "Hu ",
      "Ying ",
      "Dun ",
      "Mu ",
      "Ju ",
      "Tsugumi ",
      "Cang ",
      "Fang ",
      "Gu ",
      "Ying ",
      "Yuan ",
      "Xuan ",
      "Weng ",
      "Shi ",
      "He ",
      "Chu ",
      "Tang ",
      "Xia ",
      "Ruo ",
      "Liu ",
      "Ji ",
      "Gu ",
      "Jian ",
      "Zhun ",
      "Han ",
      "Zi ",
      "Zi ",
      "Ni ",
      "Yao ",
      "Yan ",
      "Ji ",
      "Li ",
      "Tian ",
      "Kou ",
      "Ti ",
      "Ti ",
      "Ni ",
      "Tu ",
      "Ma ",
      "Jiao ",
      "Gao ",
      "Tian ",
      "Chen ",
      "Li ",
      "Zhuan ",
      "Zhe ",
      "Ao ",
      "Yao ",
      "Yi ",
      "Ou ",
      "Chi ",
      "Zhi ",
      "Liao ",
      "Rong ",
      "Lou ",
      "Bi ",
      "Shuang ",
      "Zhuo ",
      "Yu ",
      "Wu ",
      "Jue ",
      "Yin ",
      "Quan ",
      "Si ",
      "Jiao ",
      "Yi ",
      "Hua ",
      "Bi ",
      "Ying ",
      "Su ",
      "Huang ",
      "Fan ",
      "Jiao ",
      "Liao ",
      "Yan ",
      "Kao ",
      "Jiu ",
      "Xian ",
      "Xian ",
      "Tu ",
      "Mai ",
      "Zun ",
      "Yu ",
      "Ying ",
      "Lu ",
      "Tuan ",
      "Xian ",
      "Xue ",
      "Yi ",
      "Pi "
    ];
  }
});

// node_modules/unidecode/data/x9e.js
var require_x9e = __commonJS({
  "node_modules/unidecode/data/x9e.js"(exports2, module2) {
    module2.exports = [
      "Shu ",
      "Luo ",
      "Qi ",
      "Yi ",
      "Ji ",
      "Zhe ",
      "Yu ",
      "Zhan ",
      "Ye ",
      "Yang ",
      "Pi ",
      "Ning ",
      "Huo ",
      "Mi ",
      "Ying ",
      "Meng ",
      "Di ",
      "Yue ",
      "Yu ",
      "Lei ",
      "Bao ",
      "Lu ",
      "He ",
      "Long ",
      "Shuang ",
      "Yue ",
      "Ying ",
      "Guan ",
      "Qu ",
      "Li ",
      "Luan ",
      "Niao ",
      "Jiu ",
      "Ji ",
      "Yuan ",
      "Ming ",
      "Shi ",
      "Ou ",
      "Ya ",
      "Cang ",
      "Bao ",
      "Zhen ",
      "Gu ",
      "Dong ",
      "Lu ",
      "Ya ",
      "Xiao ",
      "Yang ",
      "Ling ",
      "Zhi ",
      "Qu ",
      "Yuan ",
      "Xue ",
      "Tuo ",
      "Si ",
      "Zhi ",
      "Er ",
      "Gua ",
      "Xiu ",
      "Heng ",
      "Zhou ",
      "Ge ",
      "Luan ",
      "Hong ",
      "Wu ",
      "Bo ",
      "Li ",
      "Juan ",
      "Hu ",
      "E ",
      "Yu ",
      "Xian ",
      "Ti ",
      "Wu ",
      "Que ",
      "Miao ",
      "An ",
      "Kun ",
      "Bei ",
      "Peng ",
      "Qian ",
      "Chun ",
      "Geng ",
      "Yuan ",
      "Su ",
      "Hu ",
      "He ",
      "E ",
      "Gu ",
      "Qiu ",
      "Zi ",
      "Mei ",
      "Mu ",
      "Ni ",
      "Yao ",
      "Weng ",
      "Liu ",
      "Ji ",
      "Ni ",
      "Jian ",
      "He ",
      "Yi ",
      "Ying ",
      "Zhe ",
      "Liao ",
      "Liao ",
      "Jiao ",
      "Jiu ",
      "Yu ",
      "Lu ",
      "Xuan ",
      "Zhan ",
      "Ying ",
      "Huo ",
      "Meng ",
      "Guan ",
      "Shuang ",
      "Lu ",
      "Jin ",
      "Ling ",
      "Jian ",
      "Xian ",
      "Cuo ",
      "Jian ",
      "Jian ",
      "Yan ",
      "Cuo ",
      "Lu ",
      "You ",
      "Cu ",
      "Ji ",
      "Biao ",
      "Cu ",
      "Biao ",
      "Zhu ",
      "Jun ",
      "Zhu ",
      "Jian ",
      "Mi ",
      "Mi ",
      "Wu ",
      "Liu ",
      "Chen ",
      "Jun ",
      "Lin ",
      "Ni ",
      "Qi ",
      "Lu ",
      "Jiu ",
      "Jun ",
      "Jing ",
      "Li ",
      "Xiang ",
      "Yan ",
      "Jia ",
      "Mi ",
      "Li ",
      "She ",
      "Zhang ",
      "Lin ",
      "Jing ",
      "Ji ",
      "Ling ",
      "Yan ",
      "Cu ",
      "Mai ",
      "Mai ",
      "Ge ",
      "Chao ",
      "Fu ",
      "Mian ",
      "Mian ",
      "Fu ",
      "Pao ",
      "Qu ",
      "Qu ",
      "Mou ",
      "Fu ",
      "Xian ",
      "Lai ",
      "Qu ",
      "Mian ",
      "[?] ",
      "Feng ",
      "Fu ",
      "Qu ",
      "Mian ",
      "Ma ",
      "Mo ",
      "Mo ",
      "Hui ",
      "Ma ",
      "Zou ",
      "Nen ",
      "Fen ",
      "Huang ",
      "Huang ",
      "Jin ",
      "Guang ",
      "Tian ",
      "Tou ",
      "Heng ",
      "Xi ",
      "Kuang ",
      "Heng ",
      "Shu ",
      "Li ",
      "Nian ",
      "Chi ",
      "Hei ",
      "Hei ",
      "Yi ",
      "Qian ",
      "Dan ",
      "Xi ",
      "Tuan ",
      "Mo ",
      "Mo ",
      "Qian ",
      "Dai ",
      "Chu ",
      "You ",
      "Dian ",
      "Yi ",
      "Xia ",
      "Yan ",
      "Qu ",
      "Mei ",
      "Yan ",
      "Jing ",
      "Yu ",
      "Li ",
      "Dang ",
      "Du ",
      "Can ",
      "Yin ",
      "An ",
      "Yan ",
      "Tan ",
      "An ",
      "Zhen ",
      "Dai ",
      "Can ",
      "Yi ",
      "Mei ",
      "Dan ",
      "Yan ",
      "Du ",
      "Lu ",
      "Zhi ",
      "Fen ",
      "Fu ",
      "Fu ",
      "Min ",
      "Min ",
      "Yuan "
    ];
  }
});

// node_modules/unidecode/data/x9f.js
var require_x9f = __commonJS({
  "node_modules/unidecode/data/x9f.js"(exports2, module2) {
    module2.exports = [
      "Cu ",
      "Qu ",
      "Chao ",
      "Wa ",
      "Zhu ",
      "Zhi ",
      "Mang ",
      "Ao ",
      "Bie ",
      "Tuo ",
      "Bi ",
      "Yuan ",
      "Chao ",
      "Tuo ",
      "Ding ",
      "Mi ",
      "Nai ",
      "Ding ",
      "Zi ",
      "Gu ",
      "Gu ",
      "Dong ",
      "Fen ",
      "Tao ",
      "Yuan ",
      "Pi ",
      "Chang ",
      "Gao ",
      "Qi ",
      "Yuan ",
      "Tang ",
      "Teng ",
      "Shu ",
      "Shu ",
      "Fen ",
      "Fei ",
      "Wen ",
      "Ba ",
      "Diao ",
      "Tuo ",
      "Tong ",
      "Qu ",
      "Sheng ",
      "Shi ",
      "You ",
      "Shi ",
      "Ting ",
      "Wu ",
      "Nian ",
      "Jing ",
      "Hun ",
      "Ju ",
      "Yan ",
      "Tu ",
      "Ti ",
      "Xi ",
      "Xian ",
      "Yan ",
      "Lei ",
      "Bi ",
      "Yao ",
      "Qiu ",
      "Han ",
      "Wu ",
      "Wu ",
      "Hou ",
      "Xi ",
      "Ge ",
      "Zha ",
      "Xiu ",
      "Weng ",
      "Zha ",
      "Nong ",
      "Nang ",
      "Qi ",
      "Zhai ",
      "Ji ",
      "Zi ",
      "Ji ",
      "Ji ",
      "Qi ",
      "Ji ",
      "Chi ",
      "Chen ",
      "Chen ",
      "He ",
      "Ya ",
      "Ken ",
      "Xie ",
      "Pao ",
      "Cuo ",
      "Shi ",
      "Zi ",
      "Chi ",
      "Nian ",
      "Ju ",
      "Tiao ",
      "Ling ",
      "Ling ",
      "Chu ",
      "Quan ",
      "Xie ",
      "Ken ",
      "Nie ",
      "Jiu ",
      "Yao ",
      "Chuo ",
      "Kun ",
      "Yu ",
      "Chu ",
      "Yi ",
      "Ni ",
      "Cuo ",
      "Zou ",
      "Qu ",
      "Nen ",
      "Xian ",
      "Ou ",
      "E ",
      "Wo ",
      "Yi ",
      "Chuo ",
      "Zou ",
      "Dian ",
      "Chu ",
      "Jin ",
      "Ya ",
      "Chi ",
      "Chen ",
      "He ",
      "Ken ",
      "Ju ",
      "Ling ",
      "Pao ",
      "Tiao ",
      "Zi ",
      "Ken ",
      "Yu ",
      "Chuo ",
      "Qu ",
      "Wo ",
      "Long ",
      "Pang ",
      "Gong ",
      "Pang ",
      "Yan ",
      "Long ",
      "Long ",
      "Gong ",
      "Kan ",
      "Ta ",
      "Ling ",
      "Ta ",
      "Long ",
      "Gong ",
      "Kan ",
      "Gui ",
      "Qiu ",
      "Bie ",
      "Gui ",
      "Yue ",
      "Chui ",
      "He ",
      "Jue ",
      "Xie ",
      "Yu ",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/xa0.js
var require_xa0 = __commonJS({
  "node_modules/unidecode/data/xa0.js"(exports2, module2) {
    module2.exports = [
      "it",
      "ix",
      "i",
      "ip",
      "iet",
      "iex",
      "ie",
      "iep",
      "at",
      "ax",
      "a",
      "ap",
      "uox",
      "uo",
      "uop",
      "ot",
      "ox",
      "o",
      "op",
      "ex",
      "e",
      "wu",
      "bit",
      "bix",
      "bi",
      "bip",
      "biet",
      "biex",
      "bie",
      "biep",
      "bat",
      "bax",
      "ba",
      "bap",
      "buox",
      "buo",
      "buop",
      "bot",
      "box",
      "bo",
      "bop",
      "bex",
      "be",
      "bep",
      "but",
      "bux",
      "bu",
      "bup",
      "burx",
      "bur",
      "byt",
      "byx",
      "by",
      "byp",
      "byrx",
      "byr",
      "pit",
      "pix",
      "pi",
      "pip",
      "piex",
      "pie",
      "piep",
      "pat",
      "pax",
      "pa",
      "pap",
      "puox",
      "puo",
      "puop",
      "pot",
      "pox",
      "po",
      "pop",
      "put",
      "pux",
      "pu",
      "pup",
      "purx",
      "pur",
      "pyt",
      "pyx",
      "py",
      "pyp",
      "pyrx",
      "pyr",
      "bbit",
      "bbix",
      "bbi",
      "bbip",
      "bbiet",
      "bbiex",
      "bbie",
      "bbiep",
      "bbat",
      "bbax",
      "bba",
      "bbap",
      "bbuox",
      "bbuo",
      "bbuop",
      "bbot",
      "bbox",
      "bbo",
      "bbop",
      "bbex",
      "bbe",
      "bbep",
      "bbut",
      "bbux",
      "bbu",
      "bbup",
      "bburx",
      "bbur",
      "bbyt",
      "bbyx",
      "bby",
      "bbyp",
      "nbit",
      "nbix",
      "nbi",
      "nbip",
      "nbiex",
      "nbie",
      "nbiep",
      "nbat",
      "nbax",
      "nba",
      "nbap",
      "nbot",
      "nbox",
      "nbo",
      "nbop",
      "nbut",
      "nbux",
      "nbu",
      "nbup",
      "nburx",
      "nbur",
      "nbyt",
      "nbyx",
      "nby",
      "nbyp",
      "nbyrx",
      "nbyr",
      "hmit",
      "hmix",
      "hmi",
      "hmip",
      "hmiex",
      "hmie",
      "hmiep",
      "hmat",
      "hmax",
      "hma",
      "hmap",
      "hmuox",
      "hmuo",
      "hmuop",
      "hmot",
      "hmox",
      "hmo",
      "hmop",
      "hmut",
      "hmux",
      "hmu",
      "hmup",
      "hmurx",
      "hmur",
      "hmyx",
      "hmy",
      "hmyp",
      "hmyrx",
      "hmyr",
      "mit",
      "mix",
      "mi",
      "mip",
      "miex",
      "mie",
      "miep",
      "mat",
      "max",
      "ma",
      "map",
      "muot",
      "muox",
      "muo",
      "muop",
      "mot",
      "mox",
      "mo",
      "mop",
      "mex",
      "me",
      "mut",
      "mux",
      "mu",
      "mup",
      "murx",
      "mur",
      "myt",
      "myx",
      "my",
      "myp",
      "fit",
      "fix",
      "fi",
      "fip",
      "fat",
      "fax",
      "fa",
      "fap",
      "fox",
      "fo",
      "fop",
      "fut",
      "fux",
      "fu",
      "fup",
      "furx",
      "fur",
      "fyt",
      "fyx",
      "fy",
      "fyp",
      "vit",
      "vix",
      "vi",
      "vip",
      "viet",
      "viex",
      "vie",
      "viep",
      "vat",
      "vax",
      "va",
      "vap",
      "vot",
      "vox",
      "vo",
      "vop",
      "vex",
      "vep",
      "vut",
      "vux",
      "vu",
      "vup",
      "vurx",
      "vur",
      "vyt",
      "vyx",
      "vy",
      "vyp",
      "vyrx",
      "vyr"
    ];
  }
});

// node_modules/unidecode/data/xa1.js
var require_xa1 = __commonJS({
  "node_modules/unidecode/data/xa1.js"(exports2, module2) {
    module2.exports = [
      "dit",
      "dix",
      "di",
      "dip",
      "diex",
      "die",
      "diep",
      "dat",
      "dax",
      "da",
      "dap",
      "duox",
      "duo",
      "dot",
      "dox",
      "do",
      "dop",
      "dex",
      "de",
      "dep",
      "dut",
      "dux",
      "du",
      "dup",
      "durx",
      "dur",
      "tit",
      "tix",
      "ti",
      "tip",
      "tiex",
      "tie",
      "tiep",
      "tat",
      "tax",
      "ta",
      "tap",
      "tuot",
      "tuox",
      "tuo",
      "tuop",
      "tot",
      "tox",
      "to",
      "top",
      "tex",
      "te",
      "tep",
      "tut",
      "tux",
      "tu",
      "tup",
      "turx",
      "tur",
      "ddit",
      "ddix",
      "ddi",
      "ddip",
      "ddiex",
      "ddie",
      "ddiep",
      "ddat",
      "ddax",
      "dda",
      "ddap",
      "dduox",
      "dduo",
      "dduop",
      "ddot",
      "ddox",
      "ddo",
      "ddop",
      "ddex",
      "dde",
      "ddep",
      "ddut",
      "ddux",
      "ddu",
      "ddup",
      "ddurx",
      "ddur",
      "ndit",
      "ndix",
      "ndi",
      "ndip",
      "ndiex",
      "ndie",
      "ndat",
      "ndax",
      "nda",
      "ndap",
      "ndot",
      "ndox",
      "ndo",
      "ndop",
      "ndex",
      "nde",
      "ndep",
      "ndut",
      "ndux",
      "ndu",
      "ndup",
      "ndurx",
      "ndur",
      "hnit",
      "hnix",
      "hni",
      "hnip",
      "hniet",
      "hniex",
      "hnie",
      "hniep",
      "hnat",
      "hnax",
      "hna",
      "hnap",
      "hnuox",
      "hnuo",
      "hnot",
      "hnox",
      "hnop",
      "hnex",
      "hne",
      "hnep",
      "hnut",
      "nit",
      "nix",
      "ni",
      "nip",
      "niex",
      "nie",
      "niep",
      "nax",
      "na",
      "nap",
      "nuox",
      "nuo",
      "nuop",
      "not",
      "nox",
      "no",
      "nop",
      "nex",
      "ne",
      "nep",
      "nut",
      "nux",
      "nu",
      "nup",
      "nurx",
      "nur",
      "hlit",
      "hlix",
      "hli",
      "hlip",
      "hliex",
      "hlie",
      "hliep",
      "hlat",
      "hlax",
      "hla",
      "hlap",
      "hluox",
      "hluo",
      "hluop",
      "hlox",
      "hlo",
      "hlop",
      "hlex",
      "hle",
      "hlep",
      "hlut",
      "hlux",
      "hlu",
      "hlup",
      "hlurx",
      "hlur",
      "hlyt",
      "hlyx",
      "hly",
      "hlyp",
      "hlyrx",
      "hlyr",
      "lit",
      "lix",
      "li",
      "lip",
      "liet",
      "liex",
      "lie",
      "liep",
      "lat",
      "lax",
      "la",
      "lap",
      "luot",
      "luox",
      "luo",
      "luop",
      "lot",
      "lox",
      "lo",
      "lop",
      "lex",
      "le",
      "lep",
      "lut",
      "lux",
      "lu",
      "lup",
      "lurx",
      "lur",
      "lyt",
      "lyx",
      "ly",
      "lyp",
      "lyrx",
      "lyr",
      "git",
      "gix",
      "gi",
      "gip",
      "giet",
      "giex",
      "gie",
      "giep",
      "gat",
      "gax",
      "ga",
      "gap",
      "guot",
      "guox",
      "guo",
      "guop",
      "got",
      "gox",
      "go",
      "gop",
      "get",
      "gex",
      "ge",
      "gep",
      "gut",
      "gux",
      "gu",
      "gup",
      "gurx",
      "gur",
      "kit",
      "kix",
      "ki",
      "kip",
      "kiex",
      "kie",
      "kiep",
      "kat"
    ];
  }
});

// node_modules/unidecode/data/xa2.js
var require_xa2 = __commonJS({
  "node_modules/unidecode/data/xa2.js"(exports2, module2) {
    module2.exports = [
      "kax",
      "ka",
      "kap",
      "kuox",
      "kuo",
      "kuop",
      "kot",
      "kox",
      "ko",
      "kop",
      "ket",
      "kex",
      "ke",
      "kep",
      "kut",
      "kux",
      "ku",
      "kup",
      "kurx",
      "kur",
      "ggit",
      "ggix",
      "ggi",
      "ggiex",
      "ggie",
      "ggiep",
      "ggat",
      "ggax",
      "gga",
      "ggap",
      "gguot",
      "gguox",
      "gguo",
      "gguop",
      "ggot",
      "ggox",
      "ggo",
      "ggop",
      "gget",
      "ggex",
      "gge",
      "ggep",
      "ggut",
      "ggux",
      "ggu",
      "ggup",
      "ggurx",
      "ggur",
      "mgiex",
      "mgie",
      "mgat",
      "mgax",
      "mga",
      "mgap",
      "mguox",
      "mguo",
      "mguop",
      "mgot",
      "mgox",
      "mgo",
      "mgop",
      "mgex",
      "mge",
      "mgep",
      "mgut",
      "mgux",
      "mgu",
      "mgup",
      "mgurx",
      "mgur",
      "hxit",
      "hxix",
      "hxi",
      "hxip",
      "hxiet",
      "hxiex",
      "hxie",
      "hxiep",
      "hxat",
      "hxax",
      "hxa",
      "hxap",
      "hxuot",
      "hxuox",
      "hxuo",
      "hxuop",
      "hxot",
      "hxox",
      "hxo",
      "hxop",
      "hxex",
      "hxe",
      "hxep",
      "ngiex",
      "ngie",
      "ngiep",
      "ngat",
      "ngax",
      "nga",
      "ngap",
      "nguot",
      "nguox",
      "nguo",
      "ngot",
      "ngox",
      "ngo",
      "ngop",
      "ngex",
      "nge",
      "ngep",
      "hit",
      "hiex",
      "hie",
      "hat",
      "hax",
      "ha",
      "hap",
      "huot",
      "huox",
      "huo",
      "huop",
      "hot",
      "hox",
      "ho",
      "hop",
      "hex",
      "he",
      "hep",
      "wat",
      "wax",
      "wa",
      "wap",
      "wuox",
      "wuo",
      "wuop",
      "wox",
      "wo",
      "wop",
      "wex",
      "we",
      "wep",
      "zit",
      "zix",
      "zi",
      "zip",
      "ziex",
      "zie",
      "ziep",
      "zat",
      "zax",
      "za",
      "zap",
      "zuox",
      "zuo",
      "zuop",
      "zot",
      "zox",
      "zo",
      "zop",
      "zex",
      "ze",
      "zep",
      "zut",
      "zux",
      "zu",
      "zup",
      "zurx",
      "zur",
      "zyt",
      "zyx",
      "zy",
      "zyp",
      "zyrx",
      "zyr",
      "cit",
      "cix",
      "ci",
      "cip",
      "ciet",
      "ciex",
      "cie",
      "ciep",
      "cat",
      "cax",
      "ca",
      "cap",
      "cuox",
      "cuo",
      "cuop",
      "cot",
      "cox",
      "co",
      "cop",
      "cex",
      "ce",
      "cep",
      "cut",
      "cux",
      "cu",
      "cup",
      "curx",
      "cur",
      "cyt",
      "cyx",
      "cy",
      "cyp",
      "cyrx",
      "cyr",
      "zzit",
      "zzix",
      "zzi",
      "zzip",
      "zziet",
      "zziex",
      "zzie",
      "zziep",
      "zzat",
      "zzax",
      "zza",
      "zzap",
      "zzox",
      "zzo",
      "zzop",
      "zzex",
      "zze",
      "zzep",
      "zzux",
      "zzu",
      "zzup",
      "zzurx",
      "zzur",
      "zzyt",
      "zzyx",
      "zzy",
      "zzyp",
      "zzyrx",
      "zzyr",
      "nzit",
      "nzix",
      "nzi",
      "nzip",
      "nziex",
      "nzie",
      "nziep",
      "nzat",
      "nzax",
      "nza",
      "nzap",
      "nzuox",
      "nzuo",
      "nzox",
      "nzop",
      "nzex",
      "nze",
      "nzux",
      "nzu"
    ];
  }
});

// node_modules/unidecode/data/xa3.js
var require_xa3 = __commonJS({
  "node_modules/unidecode/data/xa3.js"(exports2, module2) {
    module2.exports = [
      "nzup",
      "nzurx",
      "nzur",
      "nzyt",
      "nzyx",
      "nzy",
      "nzyp",
      "nzyrx",
      "nzyr",
      "sit",
      "six",
      "si",
      "sip",
      "siex",
      "sie",
      "siep",
      "sat",
      "sax",
      "sa",
      "sap",
      "suox",
      "suo",
      "suop",
      "sot",
      "sox",
      "so",
      "sop",
      "sex",
      "se",
      "sep",
      "sut",
      "sux",
      "su",
      "sup",
      "surx",
      "sur",
      "syt",
      "syx",
      "sy",
      "syp",
      "syrx",
      "syr",
      "ssit",
      "ssix",
      "ssi",
      "ssip",
      "ssiex",
      "ssie",
      "ssiep",
      "ssat",
      "ssax",
      "ssa",
      "ssap",
      "ssot",
      "ssox",
      "sso",
      "ssop",
      "ssex",
      "sse",
      "ssep",
      "ssut",
      "ssux",
      "ssu",
      "ssup",
      "ssyt",
      "ssyx",
      "ssy",
      "ssyp",
      "ssyrx",
      "ssyr",
      "zhat",
      "zhax",
      "zha",
      "zhap",
      "zhuox",
      "zhuo",
      "zhuop",
      "zhot",
      "zhox",
      "zho",
      "zhop",
      "zhet",
      "zhex",
      "zhe",
      "zhep",
      "zhut",
      "zhux",
      "zhu",
      "zhup",
      "zhurx",
      "zhur",
      "zhyt",
      "zhyx",
      "zhy",
      "zhyp",
      "zhyrx",
      "zhyr",
      "chat",
      "chax",
      "cha",
      "chap",
      "chuot",
      "chuox",
      "chuo",
      "chuop",
      "chot",
      "chox",
      "cho",
      "chop",
      "chet",
      "chex",
      "che",
      "chep",
      "chux",
      "chu",
      "chup",
      "churx",
      "chur",
      "chyt",
      "chyx",
      "chy",
      "chyp",
      "chyrx",
      "chyr",
      "rrax",
      "rra",
      "rruox",
      "rruo",
      "rrot",
      "rrox",
      "rro",
      "rrop",
      "rret",
      "rrex",
      "rre",
      "rrep",
      "rrut",
      "rrux",
      "rru",
      "rrup",
      "rrurx",
      "rrur",
      "rryt",
      "rryx",
      "rry",
      "rryp",
      "rryrx",
      "rryr",
      "nrat",
      "nrax",
      "nra",
      "nrap",
      "nrox",
      "nro",
      "nrop",
      "nret",
      "nrex",
      "nre",
      "nrep",
      "nrut",
      "nrux",
      "nru",
      "nrup",
      "nrurx",
      "nrur",
      "nryt",
      "nryx",
      "nry",
      "nryp",
      "nryrx",
      "nryr",
      "shat",
      "shax",
      "sha",
      "shap",
      "shuox",
      "shuo",
      "shuop",
      "shot",
      "shox",
      "sho",
      "shop",
      "shet",
      "shex",
      "she",
      "shep",
      "shut",
      "shux",
      "shu",
      "shup",
      "shurx",
      "shur",
      "shyt",
      "shyx",
      "shy",
      "shyp",
      "shyrx",
      "shyr",
      "rat",
      "rax",
      "ra",
      "rap",
      "ruox",
      "ruo",
      "ruop",
      "rot",
      "rox",
      "ro",
      "rop",
      "rex",
      "re",
      "rep",
      "rut",
      "rux",
      "ru",
      "rup",
      "rurx",
      "rur",
      "ryt",
      "ryx",
      "ry",
      "ryp",
      "ryrx",
      "ryr",
      "jit",
      "jix",
      "ji",
      "jip",
      "jiet",
      "jiex",
      "jie",
      "jiep",
      "juot",
      "juox",
      "juo",
      "juop",
      "jot",
      "jox",
      "jo",
      "jop",
      "jut",
      "jux",
      "ju",
      "jup",
      "jurx",
      "jur",
      "jyt",
      "jyx",
      "jy",
      "jyp",
      "jyrx",
      "jyr",
      "qit",
      "qix",
      "qi",
      "qip"
    ];
  }
});

// node_modules/unidecode/data/xa4.js
var require_xa4 = __commonJS({
  "node_modules/unidecode/data/xa4.js"(exports2, module2) {
    module2.exports = [
      "qiet",
      "qiex",
      "qie",
      "qiep",
      "quot",
      "quox",
      "quo",
      "quop",
      "qot",
      "qox",
      "qo",
      "qop",
      "qut",
      "qux",
      "qu",
      "qup",
      "qurx",
      "qur",
      "qyt",
      "qyx",
      "qy",
      "qyp",
      "qyrx",
      "qyr",
      "jjit",
      "jjix",
      "jji",
      "jjip",
      "jjiet",
      "jjiex",
      "jjie",
      "jjiep",
      "jjuox",
      "jjuo",
      "jjuop",
      "jjot",
      "jjox",
      "jjo",
      "jjop",
      "jjut",
      "jjux",
      "jju",
      "jjup",
      "jjurx",
      "jjur",
      "jjyt",
      "jjyx",
      "jjy",
      "jjyp",
      "njit",
      "njix",
      "nji",
      "njip",
      "njiet",
      "njiex",
      "njie",
      "njiep",
      "njuox",
      "njuo",
      "njot",
      "njox",
      "njo",
      "njop",
      "njux",
      "nju",
      "njup",
      "njurx",
      "njur",
      "njyt",
      "njyx",
      "njy",
      "njyp",
      "njyrx",
      "njyr",
      "nyit",
      "nyix",
      "nyi",
      "nyip",
      "nyiet",
      "nyiex",
      "nyie",
      "nyiep",
      "nyuox",
      "nyuo",
      "nyuop",
      "nyot",
      "nyox",
      "nyo",
      "nyop",
      "nyut",
      "nyux",
      "nyu",
      "nyup",
      "xit",
      "xix",
      "xi",
      "xip",
      "xiet",
      "xiex",
      "xie",
      "xiep",
      "xuox",
      "xuo",
      "xot",
      "xox",
      "xo",
      "xop",
      "xyt",
      "xyx",
      "xy",
      "xyp",
      "xyrx",
      "xyr",
      "yit",
      "yix",
      "yi",
      "yip",
      "yiet",
      "yiex",
      "yie",
      "yiep",
      "yuot",
      "yuox",
      "yuo",
      "yuop",
      "yot",
      "yox",
      "yo",
      "yop",
      "yut",
      "yux",
      "yu",
      "yup",
      "yurx",
      "yur",
      "yyt",
      "yyx",
      "yy",
      "yyp",
      "yyrx",
      "yyr",
      "[?]",
      "[?]",
      "[?]",
      "Qot",
      "Li",
      "Kit",
      "Nyip",
      "Cyp",
      "Ssi",
      "Ggop",
      "Gep",
      "Mi",
      "Hxit",
      "Lyr",
      "Bbut",
      "Mop",
      "Yo",
      "Put",
      "Hxuo",
      "Tat",
      "Ga",
      "[?]",
      "[?]",
      "Ddur",
      "Bur",
      "Gguo",
      "Nyop",
      "Tu",
      "Op",
      "Jjut",
      "Zot",
      "Pyt",
      "Hmo",
      "Yit",
      "Vur",
      "Shy",
      "Vep",
      "Za",
      "Jo",
      "[?]",
      "Jjy",
      "Got",
      "Jjie",
      "Wo",
      "Du",
      "Shur",
      "Lie",
      "Cy",
      "Cuop",
      "Cip",
      "Hxop",
      "Shat",
      "[?]",
      "Shop",
      "Che",
      "Zziet",
      "[?]",
      "Ke",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]",
      "[?]"
    ];
  }
});

// node_modules/unidecode/data/xac.js
var require_xac = __commonJS({
  "node_modules/unidecode/data/xac.js"(exports2, module2) {
    module2.exports = [
      "ga",
      "gag",
      "gagg",
      "gags",
      "gan",
      "ganj",
      "ganh",
      "gad",
      "gal",
      "galg",
      "galm",
      "galb",
      "gals",
      "galt",
      "galp",
      "galh",
      "gam",
      "gab",
      "gabs",
      "gas",
      "gass",
      "gang",
      "gaj",
      "gac",
      "gak",
      "gat",
      "gap",
      "gah",
      "gae",
      "gaeg",
      "gaegg",
      "gaegs",
      "gaen",
      "gaenj",
      "gaenh",
      "gaed",
      "gael",
      "gaelg",
      "gaelm",
      "gaelb",
      "gaels",
      "gaelt",
      "gaelp",
      "gaelh",
      "gaem",
      "gaeb",
      "gaebs",
      "gaes",
      "gaess",
      "gaeng",
      "gaej",
      "gaec",
      "gaek",
      "gaet",
      "gaep",
      "gaeh",
      "gya",
      "gyag",
      "gyagg",
      "gyags",
      "gyan",
      "gyanj",
      "gyanh",
      "gyad",
      "gyal",
      "gyalg",
      "gyalm",
      "gyalb",
      "gyals",
      "gyalt",
      "gyalp",
      "gyalh",
      "gyam",
      "gyab",
      "gyabs",
      "gyas",
      "gyass",
      "gyang",
      "gyaj",
      "gyac",
      "gyak",
      "gyat",
      "gyap",
      "gyah",
      "gyae",
      "gyaeg",
      "gyaegg",
      "gyaegs",
      "gyaen",
      "gyaenj",
      "gyaenh",
      "gyaed",
      "gyael",
      "gyaelg",
      "gyaelm",
      "gyaelb",
      "gyaels",
      "gyaelt",
      "gyaelp",
      "gyaelh",
      "gyaem",
      "gyaeb",
      "gyaebs",
      "gyaes",
      "gyaess",
      "gyaeng",
      "gyaej",
      "gyaec",
      "gyaek",
      "gyaet",
      "gyaep",
      "gyaeh",
      "geo",
      "geog",
      "geogg",
      "geogs",
      "geon",
      "geonj",
      "geonh",
      "geod",
      "geol",
      "geolg",
      "geolm",
      "geolb",
      "geols",
      "geolt",
      "geolp",
      "geolh",
      "geom",
      "geob",
      "geobs",
      "geos",
      "geoss",
      "geong",
      "geoj",
      "geoc",
      "geok",
      "geot",
      "geop",
      "geoh",
      "ge",
      "geg",
      "gegg",
      "gegs",
      "gen",
      "genj",
      "genh",
      "ged",
      "gel",
      "gelg",
      "gelm",
      "gelb",
      "gels",
      "gelt",
      "gelp",
      "gelh",
      "gem",
      "geb",
      "gebs",
      "ges",
      "gess",
      "geng",
      "gej",
      "gec",
      "gek",
      "get",
      "gep",
      "geh",
      "gyeo",
      "gyeog",
      "gyeogg",
      "gyeogs",
      "gyeon",
      "gyeonj",
      "gyeonh",
      "gyeod",
      "gyeol",
      "gyeolg",
      "gyeolm",
      "gyeolb",
      "gyeols",
      "gyeolt",
      "gyeolp",
      "gyeolh",
      "gyeom",
      "gyeob",
      "gyeobs",
      "gyeos",
      "gyeoss",
      "gyeong",
      "gyeoj",
      "gyeoc",
      "gyeok",
      "gyeot",
      "gyeop",
      "gyeoh",
      "gye",
      "gyeg",
      "gyegg",
      "gyegs",
      "gyen",
      "gyenj",
      "gyenh",
      "gyed",
      "gyel",
      "gyelg",
      "gyelm",
      "gyelb",
      "gyels",
      "gyelt",
      "gyelp",
      "gyelh",
      "gyem",
      "gyeb",
      "gyebs",
      "gyes",
      "gyess",
      "gyeng",
      "gyej",
      "gyec",
      "gyek",
      "gyet",
      "gyep",
      "gyeh",
      "go",
      "gog",
      "gogg",
      "gogs",
      "gon",
      "gonj",
      "gonh",
      "god",
      "gol",
      "golg",
      "golm",
      "golb",
      "gols",
      "golt",
      "golp",
      "golh",
      "gom",
      "gob",
      "gobs",
      "gos",
      "goss",
      "gong",
      "goj",
      "goc",
      "gok",
      "got",
      "gop",
      "goh",
      "gwa",
      "gwag",
      "gwagg",
      "gwags"
    ];
  }
});

// node_modules/unidecode/data/xad.js
var require_xad = __commonJS({
  "node_modules/unidecode/data/xad.js"(exports2, module2) {
    module2.exports = [
      "gwan",
      "gwanj",
      "gwanh",
      "gwad",
      "gwal",
      "gwalg",
      "gwalm",
      "gwalb",
      "gwals",
      "gwalt",
      "gwalp",
      "gwalh",
      "gwam",
      "gwab",
      "gwabs",
      "gwas",
      "gwass",
      "gwang",
      "gwaj",
      "gwac",
      "gwak",
      "gwat",
      "gwap",
      "gwah",
      "gwae",
      "gwaeg",
      "gwaegg",
      "gwaegs",
      "gwaen",
      "gwaenj",
      "gwaenh",
      "gwaed",
      "gwael",
      "gwaelg",
      "gwaelm",
      "gwaelb",
      "gwaels",
      "gwaelt",
      "gwaelp",
      "gwaelh",
      "gwaem",
      "gwaeb",
      "gwaebs",
      "gwaes",
      "gwaess",
      "gwaeng",
      "gwaej",
      "gwaec",
      "gwaek",
      "gwaet",
      "gwaep",
      "gwaeh",
      "goe",
      "goeg",
      "goegg",
      "goegs",
      "goen",
      "goenj",
      "goenh",
      "goed",
      "goel",
      "goelg",
      "goelm",
      "goelb",
      "goels",
      "goelt",
      "goelp",
      "goelh",
      "goem",
      "goeb",
      "goebs",
      "goes",
      "goess",
      "goeng",
      "goej",
      "goec",
      "goek",
      "goet",
      "goep",
      "goeh",
      "gyo",
      "gyog",
      "gyogg",
      "gyogs",
      "gyon",
      "gyonj",
      "gyonh",
      "gyod",
      "gyol",
      "gyolg",
      "gyolm",
      "gyolb",
      "gyols",
      "gyolt",
      "gyolp",
      "gyolh",
      "gyom",
      "gyob",
      "gyobs",
      "gyos",
      "gyoss",
      "gyong",
      "gyoj",
      "gyoc",
      "gyok",
      "gyot",
      "gyop",
      "gyoh",
      "gu",
      "gug",
      "gugg",
      "gugs",
      "gun",
      "gunj",
      "gunh",
      "gud",
      "gul",
      "gulg",
      "gulm",
      "gulb",
      "guls",
      "gult",
      "gulp",
      "gulh",
      "gum",
      "gub",
      "gubs",
      "gus",
      "guss",
      "gung",
      "guj",
      "guc",
      "guk",
      "gut",
      "gup",
      "guh",
      "gweo",
      "gweog",
      "gweogg",
      "gweogs",
      "gweon",
      "gweonj",
      "gweonh",
      "gweod",
      "gweol",
      "gweolg",
      "gweolm",
      "gweolb",
      "gweols",
      "gweolt",
      "gweolp",
      "gweolh",
      "gweom",
      "gweob",
      "gweobs",
      "gweos",
      "gweoss",
      "gweong",
      "gweoj",
      "gweoc",
      "gweok",
      "gweot",
      "gweop",
      "gweoh",
      "gwe",
      "gweg",
      "gwegg",
      "gwegs",
      "gwen",
      "gwenj",
      "gwenh",
      "gwed",
      "gwel",
      "gwelg",
      "gwelm",
      "gwelb",
      "gwels",
      "gwelt",
      "gwelp",
      "gwelh",
      "gwem",
      "gweb",
      "gwebs",
      "gwes",
      "gwess",
      "gweng",
      "gwej",
      "gwec",
      "gwek",
      "gwet",
      "gwep",
      "gweh",
      "gwi",
      "gwig",
      "gwigg",
      "gwigs",
      "gwin",
      "gwinj",
      "gwinh",
      "gwid",
      "gwil",
      "gwilg",
      "gwilm",
      "gwilb",
      "gwils",
      "gwilt",
      "gwilp",
      "gwilh",
      "gwim",
      "gwib",
      "gwibs",
      "gwis",
      "gwiss",
      "gwing",
      "gwij",
      "gwic",
      "gwik",
      "gwit",
      "gwip",
      "gwih",
      "gyu",
      "gyug",
      "gyugg",
      "gyugs",
      "gyun",
      "gyunj",
      "gyunh",
      "gyud",
      "gyul",
      "gyulg",
      "gyulm",
      "gyulb",
      "gyuls",
      "gyult",
      "gyulp",
      "gyulh",
      "gyum",
      "gyub",
      "gyubs",
      "gyus",
      "gyuss",
      "gyung",
      "gyuj",
      "gyuc",
      "gyuk",
      "gyut",
      "gyup",
      "gyuh",
      "geu",
      "geug",
      "geugg",
      "geugs",
      "geun",
      "geunj",
      "geunh",
      "geud"
    ];
  }
});

// node_modules/unidecode/data/xae.js
var require_xae = __commonJS({
  "node_modules/unidecode/data/xae.js"(exports2, module2) {
    module2.exports = [
      "geul",
      "geulg",
      "geulm",
      "geulb",
      "geuls",
      "geult",
      "geulp",
      "geulh",
      "geum",
      "geub",
      "geubs",
      "geus",
      "geuss",
      "geung",
      "geuj",
      "geuc",
      "geuk",
      "geut",
      "geup",
      "geuh",
      "gyi",
      "gyig",
      "gyigg",
      "gyigs",
      "gyin",
      "gyinj",
      "gyinh",
      "gyid",
      "gyil",
      "gyilg",
      "gyilm",
      "gyilb",
      "gyils",
      "gyilt",
      "gyilp",
      "gyilh",
      "gyim",
      "gyib",
      "gyibs",
      "gyis",
      "gyiss",
      "gying",
      "gyij",
      "gyic",
      "gyik",
      "gyit",
      "gyip",
      "gyih",
      "gi",
      "gig",
      "gigg",
      "gigs",
      "gin",
      "ginj",
      "ginh",
      "gid",
      "gil",
      "gilg",
      "gilm",
      "gilb",
      "gils",
      "gilt",
      "gilp",
      "gilh",
      "gim",
      "gib",
      "gibs",
      "gis",
      "giss",
      "ging",
      "gij",
      "gic",
      "gik",
      "git",
      "gip",
      "gih",
      "gga",
      "ggag",
      "ggagg",
      "ggags",
      "ggan",
      "gganj",
      "gganh",
      "ggad",
      "ggal",
      "ggalg",
      "ggalm",
      "ggalb",
      "ggals",
      "ggalt",
      "ggalp",
      "ggalh",
      "ggam",
      "ggab",
      "ggabs",
      "ggas",
      "ggass",
      "ggang",
      "ggaj",
      "ggac",
      "ggak",
      "ggat",
      "ggap",
      "ggah",
      "ggae",
      "ggaeg",
      "ggaegg",
      "ggaegs",
      "ggaen",
      "ggaenj",
      "ggaenh",
      "ggaed",
      "ggael",
      "ggaelg",
      "ggaelm",
      "ggaelb",
      "ggaels",
      "ggaelt",
      "ggaelp",
      "ggaelh",
      "ggaem",
      "ggaeb",
      "ggaebs",
      "ggaes",
      "ggaess",
      "ggaeng",
      "ggaej",
      "ggaec",
      "ggaek",
      "ggaet",
      "ggaep",
      "ggaeh",
      "ggya",
      "ggyag",
      "ggyagg",
      "ggyags",
      "ggyan",
      "ggyanj",
      "ggyanh",
      "ggyad",
      "ggyal",
      "ggyalg",
      "ggyalm",
      "ggyalb",
      "ggyals",
      "ggyalt",
      "ggyalp",
      "ggyalh",
      "ggyam",
      "ggyab",
      "ggyabs",
      "ggyas",
      "ggyass",
      "ggyang",
      "ggyaj",
      "ggyac",
      "ggyak",
      "ggyat",
      "ggyap",
      "ggyah",
      "ggyae",
      "ggyaeg",
      "ggyaegg",
      "ggyaegs",
      "ggyaen",
      "ggyaenj",
      "ggyaenh",
      "ggyaed",
      "ggyael",
      "ggyaelg",
      "ggyaelm",
      "ggyaelb",
      "ggyaels",
      "ggyaelt",
      "ggyaelp",
      "ggyaelh",
      "ggyaem",
      "ggyaeb",
      "ggyaebs",
      "ggyaes",
      "ggyaess",
      "ggyaeng",
      "ggyaej",
      "ggyaec",
      "ggyaek",
      "ggyaet",
      "ggyaep",
      "ggyaeh",
      "ggeo",
      "ggeog",
      "ggeogg",
      "ggeogs",
      "ggeon",
      "ggeonj",
      "ggeonh",
      "ggeod",
      "ggeol",
      "ggeolg",
      "ggeolm",
      "ggeolb",
      "ggeols",
      "ggeolt",
      "ggeolp",
      "ggeolh",
      "ggeom",
      "ggeob",
      "ggeobs",
      "ggeos",
      "ggeoss",
      "ggeong",
      "ggeoj",
      "ggeoc",
      "ggeok",
      "ggeot",
      "ggeop",
      "ggeoh",
      "gge",
      "ggeg",
      "ggegg",
      "ggegs",
      "ggen",
      "ggenj",
      "ggenh",
      "gged",
      "ggel",
      "ggelg",
      "ggelm",
      "ggelb",
      "ggels",
      "ggelt",
      "ggelp",
      "ggelh",
      "ggem",
      "ggeb",
      "ggebs",
      "gges",
      "ggess",
      "ggeng",
      "ggej",
      "ggec",
      "ggek",
      "gget",
      "ggep",
      "ggeh",
      "ggyeo",
      "ggyeog",
      "ggyeogg",
      "ggyeogs",
      "ggyeon",
      "ggyeonj",
      "ggyeonh",
      "ggyeod",
      "ggyeol",
      "ggyeolg",
      "ggyeolm",
      "ggyeolb"
    ];
  }
});

// node_modules/unidecode/data/xaf.js
var require_xaf = __commonJS({
  "node_modules/unidecode/data/xaf.js"(exports2, module2) {
    module2.exports = [
      "ggyeols",
      "ggyeolt",
      "ggyeolp",
      "ggyeolh",
      "ggyeom",
      "ggyeob",
      "ggyeobs",
      "ggyeos",
      "ggyeoss",
      "ggyeong",
      "ggyeoj",
      "ggyeoc",
      "ggyeok",
      "ggyeot",
      "ggyeop",
      "ggyeoh",
      "ggye",
      "ggyeg",
      "ggyegg",
      "ggyegs",
      "ggyen",
      "ggyenj",
      "ggyenh",
      "ggyed",
      "ggyel",
      "ggyelg",
      "ggyelm",
      "ggyelb",
      "ggyels",
      "ggyelt",
      "ggyelp",
      "ggyelh",
      "ggyem",
      "ggyeb",
      "ggyebs",
      "ggyes",
      "ggyess",
      "ggyeng",
      "ggyej",
      "ggyec",
      "ggyek",
      "ggyet",
      "ggyep",
      "ggyeh",
      "ggo",
      "ggog",
      "ggogg",
      "ggogs",
      "ggon",
      "ggonj",
      "ggonh",
      "ggod",
      "ggol",
      "ggolg",
      "ggolm",
      "ggolb",
      "ggols",
      "ggolt",
      "ggolp",
      "ggolh",
      "ggom",
      "ggob",
      "ggobs",
      "ggos",
      "ggoss",
      "ggong",
      "ggoj",
      "ggoc",
      "ggok",
      "ggot",
      "ggop",
      "ggoh",
      "ggwa",
      "ggwag",
      "ggwagg",
      "ggwags",
      "ggwan",
      "ggwanj",
      "ggwanh",
      "ggwad",
      "ggwal",
      "ggwalg",
      "ggwalm",
      "ggwalb",
      "ggwals",
      "ggwalt",
      "ggwalp",
      "ggwalh",
      "ggwam",
      "ggwab",
      "ggwabs",
      "ggwas",
      "ggwass",
      "ggwang",
      "ggwaj",
      "ggwac",
      "ggwak",
      "ggwat",
      "ggwap",
      "ggwah",
      "ggwae",
      "ggwaeg",
      "ggwaegg",
      "ggwaegs",
      "ggwaen",
      "ggwaenj",
      "ggwaenh",
      "ggwaed",
      "ggwael",
      "ggwaelg",
      "ggwaelm",
      "ggwaelb",
      "ggwaels",
      "ggwaelt",
      "ggwaelp",
      "ggwaelh",
      "ggwaem",
      "ggwaeb",
      "ggwaebs",
      "ggwaes",
      "ggwaess",
      "ggwaeng",
      "ggwaej",
      "ggwaec",
      "ggwaek",
      "ggwaet",
      "ggwaep",
      "ggwaeh",
      "ggoe",
      "ggoeg",
      "ggoegg",
      "ggoegs",
      "ggoen",
      "ggoenj",
      "ggoenh",
      "ggoed",
      "ggoel",
      "ggoelg",
      "ggoelm",
      "ggoelb",
      "ggoels",
      "ggoelt",
      "ggoelp",
      "ggoelh",
      "ggoem",
      "ggoeb",
      "ggoebs",
      "ggoes",
      "ggoess",
      "ggoeng",
      "ggoej",
      "ggoec",
      "ggoek",
      "ggoet",
      "ggoep",
      "ggoeh",
      "ggyo",
      "ggyog",
      "ggyogg",
      "ggyogs",
      "ggyon",
      "ggyonj",
      "ggyonh",
      "ggyod",
      "ggyol",
      "ggyolg",
      "ggyolm",
      "ggyolb",
      "ggyols",
      "ggyolt",
      "ggyolp",
      "ggyolh",
      "ggyom",
      "ggyob",
      "ggyobs",
      "ggyos",
      "ggyoss",
      "ggyong",
      "ggyoj",
      "ggyoc",
      "ggyok",
      "ggyot",
      "ggyop",
      "ggyoh",
      "ggu",
      "ggug",
      "ggugg",
      "ggugs",
      "ggun",
      "ggunj",
      "ggunh",
      "ggud",
      "ggul",
      "ggulg",
      "ggulm",
      "ggulb",
      "gguls",
      "ggult",
      "ggulp",
      "ggulh",
      "ggum",
      "ggub",
      "ggubs",
      "ggus",
      "gguss",
      "ggung",
      "gguj",
      "gguc",
      "gguk",
      "ggut",
      "ggup",
      "gguh",
      "ggweo",
      "ggweog",
      "ggweogg",
      "ggweogs",
      "ggweon",
      "ggweonj",
      "ggweonh",
      "ggweod",
      "ggweol",
      "ggweolg",
      "ggweolm",
      "ggweolb",
      "ggweols",
      "ggweolt",
      "ggweolp",
      "ggweolh",
      "ggweom",
      "ggweob",
      "ggweobs",
      "ggweos",
      "ggweoss",
      "ggweong",
      "ggweoj",
      "ggweoc",
      "ggweok",
      "ggweot",
      "ggweop",
      "ggweoh",
      "ggwe",
      "ggweg",
      "ggwegg",
      "ggwegs",
      "ggwen",
      "ggwenj",
      "ggwenh",
      "ggwed",
      "ggwel",
      "ggwelg",
      "ggwelm",
      "ggwelb",
      "ggwels",
      "ggwelt",
      "ggwelp",
      "ggwelh"
    ];
  }
});

// node_modules/unidecode/data/xb0.js
var require_xb0 = __commonJS({
  "node_modules/unidecode/data/xb0.js"(exports2, module2) {
    module2.exports = [
      "ggwem",
      "ggweb",
      "ggwebs",
      "ggwes",
      "ggwess",
      "ggweng",
      "ggwej",
      "ggwec",
      "ggwek",
      "ggwet",
      "ggwep",
      "ggweh",
      "ggwi",
      "ggwig",
      "ggwigg",
      "ggwigs",
      "ggwin",
      "ggwinj",
      "ggwinh",
      "ggwid",
      "ggwil",
      "ggwilg",
      "ggwilm",
      "ggwilb",
      "ggwils",
      "ggwilt",
      "ggwilp",
      "ggwilh",
      "ggwim",
      "ggwib",
      "ggwibs",
      "ggwis",
      "ggwiss",
      "ggwing",
      "ggwij",
      "ggwic",
      "ggwik",
      "ggwit",
      "ggwip",
      "ggwih",
      "ggyu",
      "ggyug",
      "ggyugg",
      "ggyugs",
      "ggyun",
      "ggyunj",
      "ggyunh",
      "ggyud",
      "ggyul",
      "ggyulg",
      "ggyulm",
      "ggyulb",
      "ggyuls",
      "ggyult",
      "ggyulp",
      "ggyulh",
      "ggyum",
      "ggyub",
      "ggyubs",
      "ggyus",
      "ggyuss",
      "ggyung",
      "ggyuj",
      "ggyuc",
      "ggyuk",
      "ggyut",
      "ggyup",
      "ggyuh",
      "ggeu",
      "ggeug",
      "ggeugg",
      "ggeugs",
      "ggeun",
      "ggeunj",
      "ggeunh",
      "ggeud",
      "ggeul",
      "ggeulg",
      "ggeulm",
      "ggeulb",
      "ggeuls",
      "ggeult",
      "ggeulp",
      "ggeulh",
      "ggeum",
      "ggeub",
      "ggeubs",
      "ggeus",
      "ggeuss",
      "ggeung",
      "ggeuj",
      "ggeuc",
      "ggeuk",
      "ggeut",
      "ggeup",
      "ggeuh",
      "ggyi",
      "ggyig",
      "ggyigg",
      "ggyigs",
      "ggyin",
      "ggyinj",
      "ggyinh",
      "ggyid",
      "ggyil",
      "ggyilg",
      "ggyilm",
      "ggyilb",
      "ggyils",
      "ggyilt",
      "ggyilp",
      "ggyilh",
      "ggyim",
      "ggyib",
      "ggyibs",
      "ggyis",
      "ggyiss",
      "ggying",
      "ggyij",
      "ggyic",
      "ggyik",
      "ggyit",
      "ggyip",
      "ggyih",
      "ggi",
      "ggig",
      "ggigg",
      "ggigs",
      "ggin",
      "gginj",
      "gginh",
      "ggid",
      "ggil",
      "ggilg",
      "ggilm",
      "ggilb",
      "ggils",
      "ggilt",
      "ggilp",
      "ggilh",
      "ggim",
      "ggib",
      "ggibs",
      "ggis",
      "ggiss",
      "gging",
      "ggij",
      "ggic",
      "ggik",
      "ggit",
      "ggip",
      "ggih",
      "na",
      "nag",
      "nagg",
      "nags",
      "nan",
      "nanj",
      "nanh",
      "nad",
      "nal",
      "nalg",
      "nalm",
      "nalb",
      "nals",
      "nalt",
      "nalp",
      "nalh",
      "nam",
      "nab",
      "nabs",
      "nas",
      "nass",
      "nang",
      "naj",
      "nac",
      "nak",
      "nat",
      "nap",
      "nah",
      "nae",
      "naeg",
      "naegg",
      "naegs",
      "naen",
      "naenj",
      "naenh",
      "naed",
      "nael",
      "naelg",
      "naelm",
      "naelb",
      "naels",
      "naelt",
      "naelp",
      "naelh",
      "naem",
      "naeb",
      "naebs",
      "naes",
      "naess",
      "naeng",
      "naej",
      "naec",
      "naek",
      "naet",
      "naep",
      "naeh",
      "nya",
      "nyag",
      "nyagg",
      "nyags",
      "nyan",
      "nyanj",
      "nyanh",
      "nyad",
      "nyal",
      "nyalg",
      "nyalm",
      "nyalb",
      "nyals",
      "nyalt",
      "nyalp",
      "nyalh",
      "nyam",
      "nyab",
      "nyabs",
      "nyas",
      "nyass",
      "nyang",
      "nyaj",
      "nyac",
      "nyak",
      "nyat",
      "nyap",
      "nyah",
      "nyae",
      "nyaeg",
      "nyaegg",
      "nyaegs",
      "nyaen",
      "nyaenj",
      "nyaenh",
      "nyaed",
      "nyael",
      "nyaelg",
      "nyaelm",
      "nyaelb",
      "nyaels",
      "nyaelt",
      "nyaelp",
      "nyaelh",
      "nyaem",
      "nyaeb",
      "nyaebs",
      "nyaes"
    ];
  }
});

// node_modules/unidecode/data/xb1.js
var require_xb1 = __commonJS({
  "node_modules/unidecode/data/xb1.js"(exports2, module2) {
    module2.exports = [
      "nyaess",
      "nyaeng",
      "nyaej",
      "nyaec",
      "nyaek",
      "nyaet",
      "nyaep",
      "nyaeh",
      "neo",
      "neog",
      "neogg",
      "neogs",
      "neon",
      "neonj",
      "neonh",
      "neod",
      "neol",
      "neolg",
      "neolm",
      "neolb",
      "neols",
      "neolt",
      "neolp",
      "neolh",
      "neom",
      "neob",
      "neobs",
      "neos",
      "neoss",
      "neong",
      "neoj",
      "neoc",
      "neok",
      "neot",
      "neop",
      "neoh",
      "ne",
      "neg",
      "negg",
      "negs",
      "nen",
      "nenj",
      "nenh",
      "ned",
      "nel",
      "nelg",
      "nelm",
      "nelb",
      "nels",
      "nelt",
      "nelp",
      "nelh",
      "nem",
      "neb",
      "nebs",
      "nes",
      "ness",
      "neng",
      "nej",
      "nec",
      "nek",
      "net",
      "nep",
      "neh",
      "nyeo",
      "nyeog",
      "nyeogg",
      "nyeogs",
      "nyeon",
      "nyeonj",
      "nyeonh",
      "nyeod",
      "nyeol",
      "nyeolg",
      "nyeolm",
      "nyeolb",
      "nyeols",
      "nyeolt",
      "nyeolp",
      "nyeolh",
      "nyeom",
      "nyeob",
      "nyeobs",
      "nyeos",
      "nyeoss",
      "nyeong",
      "nyeoj",
      "nyeoc",
      "nyeok",
      "nyeot",
      "nyeop",
      "nyeoh",
      "nye",
      "nyeg",
      "nyegg",
      "nyegs",
      "nyen",
      "nyenj",
      "nyenh",
      "nyed",
      "nyel",
      "nyelg",
      "nyelm",
      "nyelb",
      "nyels",
      "nyelt",
      "nyelp",
      "nyelh",
      "nyem",
      "nyeb",
      "nyebs",
      "nyes",
      "nyess",
      "nyeng",
      "nyej",
      "nyec",
      "nyek",
      "nyet",
      "nyep",
      "nyeh",
      "no",
      "nog",
      "nogg",
      "nogs",
      "non",
      "nonj",
      "nonh",
      "nod",
      "nol",
      "nolg",
      "nolm",
      "nolb",
      "nols",
      "nolt",
      "nolp",
      "nolh",
      "nom",
      "nob",
      "nobs",
      "nos",
      "noss",
      "nong",
      "noj",
      "noc",
      "nok",
      "not",
      "nop",
      "noh",
      "nwa",
      "nwag",
      "nwagg",
      "nwags",
      "nwan",
      "nwanj",
      "nwanh",
      "nwad",
      "nwal",
      "nwalg",
      "nwalm",
      "nwalb",
      "nwals",
      "nwalt",
      "nwalp",
      "nwalh",
      "nwam",
      "nwab",
      "nwabs",
      "nwas",
      "nwass",
      "nwang",
      "nwaj",
      "nwac",
      "nwak",
      "nwat",
      "nwap",
      "nwah",
      "nwae",
      "nwaeg",
      "nwaegg",
      "nwaegs",
      "nwaen",
      "nwaenj",
      "nwaenh",
      "nwaed",
      "nwael",
      "nwaelg",
      "nwaelm",
      "nwaelb",
      "nwaels",
      "nwaelt",
      "nwaelp",
      "nwaelh",
      "nwaem",
      "nwaeb",
      "nwaebs",
      "nwaes",
      "nwaess",
      "nwaeng",
      "nwaej",
      "nwaec",
      "nwaek",
      "nwaet",
      "nwaep",
      "nwaeh",
      "noe",
      "noeg",
      "noegg",
      "noegs",
      "noen",
      "noenj",
      "noenh",
      "noed",
      "noel",
      "noelg",
      "noelm",
      "noelb",
      "noels",
      "noelt",
      "noelp",
      "noelh",
      "noem",
      "noeb",
      "noebs",
      "noes",
      "noess",
      "noeng",
      "noej",
      "noec",
      "noek",
      "noet",
      "noep",
      "noeh",
      "nyo",
      "nyog",
      "nyogg",
      "nyogs",
      "nyon",
      "nyonj",
      "nyonh",
      "nyod",
      "nyol",
      "nyolg",
      "nyolm",
      "nyolb",
      "nyols",
      "nyolt",
      "nyolp",
      "nyolh",
      "nyom",
      "nyob",
      "nyobs",
      "nyos",
      "nyoss",
      "nyong",
      "nyoj",
      "nyoc"
    ];
  }
});

// node_modules/unidecode/data/xb2.js
var require_xb2 = __commonJS({
  "node_modules/unidecode/data/xb2.js"(exports2, module2) {
    module2.exports = [
      "nyok",
      "nyot",
      "nyop",
      "nyoh",
      "nu",
      "nug",
      "nugg",
      "nugs",
      "nun",
      "nunj",
      "nunh",
      "nud",
      "nul",
      "nulg",
      "nulm",
      "nulb",
      "nuls",
      "nult",
      "nulp",
      "nulh",
      "num",
      "nub",
      "nubs",
      "nus",
      "nuss",
      "nung",
      "nuj",
      "nuc",
      "nuk",
      "nut",
      "nup",
      "nuh",
      "nweo",
      "nweog",
      "nweogg",
      "nweogs",
      "nweon",
      "nweonj",
      "nweonh",
      "nweod",
      "nweol",
      "nweolg",
      "nweolm",
      "nweolb",
      "nweols",
      "nweolt",
      "nweolp",
      "nweolh",
      "nweom",
      "nweob",
      "nweobs",
      "nweos",
      "nweoss",
      "nweong",
      "nweoj",
      "nweoc",
      "nweok",
      "nweot",
      "nweop",
      "nweoh",
      "nwe",
      "nweg",
      "nwegg",
      "nwegs",
      "nwen",
      "nwenj",
      "nwenh",
      "nwed",
      "nwel",
      "nwelg",
      "nwelm",
      "nwelb",
      "nwels",
      "nwelt",
      "nwelp",
      "nwelh",
      "nwem",
      "nweb",
      "nwebs",
      "nwes",
      "nwess",
      "nweng",
      "nwej",
      "nwec",
      "nwek",
      "nwet",
      "nwep",
      "nweh",
      "nwi",
      "nwig",
      "nwigg",
      "nwigs",
      "nwin",
      "nwinj",
      "nwinh",
      "nwid",
      "nwil",
      "nwilg",
      "nwilm",
      "nwilb",
      "nwils",
      "nwilt",
      "nwilp",
      "nwilh",
      "nwim",
      "nwib",
      "nwibs",
      "nwis",
      "nwiss",
      "nwing",
      "nwij",
      "nwic",
      "nwik",
      "nwit",
      "nwip",
      "nwih",
      "nyu",
      "nyug",
      "nyugg",
      "nyugs",
      "nyun",
      "nyunj",
      "nyunh",
      "nyud",
      "nyul",
      "nyulg",
      "nyulm",
      "nyulb",
      "nyuls",
      "nyult",
      "nyulp",
      "nyulh",
      "nyum",
      "nyub",
      "nyubs",
      "nyus",
      "nyuss",
      "nyung",
      "nyuj",
      "nyuc",
      "nyuk",
      "nyut",
      "nyup",
      "nyuh",
      "neu",
      "neug",
      "neugg",
      "neugs",
      "neun",
      "neunj",
      "neunh",
      "neud",
      "neul",
      "neulg",
      "neulm",
      "neulb",
      "neuls",
      "neult",
      "neulp",
      "neulh",
      "neum",
      "neub",
      "neubs",
      "neus",
      "neuss",
      "neung",
      "neuj",
      "neuc",
      "neuk",
      "neut",
      "neup",
      "neuh",
      "nyi",
      "nyig",
      "nyigg",
      "nyigs",
      "nyin",
      "nyinj",
      "nyinh",
      "nyid",
      "nyil",
      "nyilg",
      "nyilm",
      "nyilb",
      "nyils",
      "nyilt",
      "nyilp",
      "nyilh",
      "nyim",
      "nyib",
      "nyibs",
      "nyis",
      "nyiss",
      "nying",
      "nyij",
      "nyic",
      "nyik",
      "nyit",
      "nyip",
      "nyih",
      "ni",
      "nig",
      "nigg",
      "nigs",
      "nin",
      "ninj",
      "ninh",
      "nid",
      "nil",
      "nilg",
      "nilm",
      "nilb",
      "nils",
      "nilt",
      "nilp",
      "nilh",
      "nim",
      "nib",
      "nibs",
      "nis",
      "niss",
      "ning",
      "nij",
      "nic",
      "nik",
      "nit",
      "nip",
      "nih",
      "da",
      "dag",
      "dagg",
      "dags",
      "dan",
      "danj",
      "danh",
      "dad",
      "dal",
      "dalg",
      "dalm",
      "dalb",
      "dals",
      "dalt",
      "dalp",
      "dalh",
      "dam",
      "dab",
      "dabs",
      "das",
      "dass",
      "dang",
      "daj",
      "dac",
      "dak",
      "dat",
      "dap",
      "dah"
    ];
  }
});

// node_modules/unidecode/data/xb3.js
var require_xb3 = __commonJS({
  "node_modules/unidecode/data/xb3.js"(exports2, module2) {
    module2.exports = [
      "dae",
      "daeg",
      "daegg",
      "daegs",
      "daen",
      "daenj",
      "daenh",
      "daed",
      "dael",
      "daelg",
      "daelm",
      "daelb",
      "daels",
      "daelt",
      "daelp",
      "daelh",
      "daem",
      "daeb",
      "daebs",
      "daes",
      "daess",
      "daeng",
      "daej",
      "daec",
      "daek",
      "daet",
      "daep",
      "daeh",
      "dya",
      "dyag",
      "dyagg",
      "dyags",
      "dyan",
      "dyanj",
      "dyanh",
      "dyad",
      "dyal",
      "dyalg",
      "dyalm",
      "dyalb",
      "dyals",
      "dyalt",
      "dyalp",
      "dyalh",
      "dyam",
      "dyab",
      "dyabs",
      "dyas",
      "dyass",
      "dyang",
      "dyaj",
      "dyac",
      "dyak",
      "dyat",
      "dyap",
      "dyah",
      "dyae",
      "dyaeg",
      "dyaegg",
      "dyaegs",
      "dyaen",
      "dyaenj",
      "dyaenh",
      "dyaed",
      "dyael",
      "dyaelg",
      "dyaelm",
      "dyaelb",
      "dyaels",
      "dyaelt",
      "dyaelp",
      "dyaelh",
      "dyaem",
      "dyaeb",
      "dyaebs",
      "dyaes",
      "dyaess",
      "dyaeng",
      "dyaej",
      "dyaec",
      "dyaek",
      "dyaet",
      "dyaep",
      "dyaeh",
      "deo",
      "deog",
      "deogg",
      "deogs",
      "deon",
      "deonj",
      "deonh",
      "deod",
      "deol",
      "deolg",
      "deolm",
      "deolb",
      "deols",
      "deolt",
      "deolp",
      "deolh",
      "deom",
      "deob",
      "deobs",
      "deos",
      "deoss",
      "deong",
      "deoj",
      "deoc",
      "deok",
      "deot",
      "deop",
      "deoh",
      "de",
      "deg",
      "degg",
      "degs",
      "den",
      "denj",
      "denh",
      "ded",
      "del",
      "delg",
      "delm",
      "delb",
      "dels",
      "delt",
      "delp",
      "delh",
      "dem",
      "deb",
      "debs",
      "des",
      "dess",
      "deng",
      "dej",
      "dec",
      "dek",
      "det",
      "dep",
      "deh",
      "dyeo",
      "dyeog",
      "dyeogg",
      "dyeogs",
      "dyeon",
      "dyeonj",
      "dyeonh",
      "dyeod",
      "dyeol",
      "dyeolg",
      "dyeolm",
      "dyeolb",
      "dyeols",
      "dyeolt",
      "dyeolp",
      "dyeolh",
      "dyeom",
      "dyeob",
      "dyeobs",
      "dyeos",
      "dyeoss",
      "dyeong",
      "dyeoj",
      "dyeoc",
      "dyeok",
      "dyeot",
      "dyeop",
      "dyeoh",
      "dye",
      "dyeg",
      "dyegg",
      "dyegs",
      "dyen",
      "dyenj",
      "dyenh",
      "dyed",
      "dyel",
      "dyelg",
      "dyelm",
      "dyelb",
      "dyels",
      "dyelt",
      "dyelp",
      "dyelh",
      "dyem",
      "dyeb",
      "dyebs",
      "dyes",
      "dyess",
      "dyeng",
      "dyej",
      "dyec",
      "dyek",
      "dyet",
      "dyep",
      "dyeh",
      "do",
      "dog",
      "dogg",
      "dogs",
      "don",
      "donj",
      "donh",
      "dod",
      "dol",
      "dolg",
      "dolm",
      "dolb",
      "dols",
      "dolt",
      "dolp",
      "dolh",
      "dom",
      "dob",
      "dobs",
      "dos",
      "doss",
      "dong",
      "doj",
      "doc",
      "dok",
      "dot",
      "dop",
      "doh",
      "dwa",
      "dwag",
      "dwagg",
      "dwags",
      "dwan",
      "dwanj",
      "dwanh",
      "dwad",
      "dwal",
      "dwalg",
      "dwalm",
      "dwalb",
      "dwals",
      "dwalt",
      "dwalp",
      "dwalh",
      "dwam",
      "dwab",
      "dwabs",
      "dwas",
      "dwass",
      "dwang",
      "dwaj",
      "dwac",
      "dwak",
      "dwat",
      "dwap",
      "dwah",
      "dwae",
      "dwaeg",
      "dwaegg",
      "dwaegs"
    ];
  }
});

// node_modules/unidecode/data/xb4.js
var require_xb4 = __commonJS({
  "node_modules/unidecode/data/xb4.js"(exports2, module2) {
    module2.exports = [
      "dwaen",
      "dwaenj",
      "dwaenh",
      "dwaed",
      "dwael",
      "dwaelg",
      "dwaelm",
      "dwaelb",
      "dwaels",
      "dwaelt",
      "dwaelp",
      "dwaelh",
      "dwaem",
      "dwaeb",
      "dwaebs",
      "dwaes",
      "dwaess",
      "dwaeng",
      "dwaej",
      "dwaec",
      "dwaek",
      "dwaet",
      "dwaep",
      "dwaeh",
      "doe",
      "doeg",
      "doegg",
      "doegs",
      "doen",
      "doenj",
      "doenh",
      "doed",
      "doel",
      "doelg",
      "doelm",
      "doelb",
      "doels",
      "doelt",
      "doelp",
      "doelh",
      "doem",
      "doeb",
      "doebs",
      "does",
      "doess",
      "doeng",
      "doej",
      "doec",
      "doek",
      "doet",
      "doep",
      "doeh",
      "dyo",
      "dyog",
      "dyogg",
      "dyogs",
      "dyon",
      "dyonj",
      "dyonh",
      "dyod",
      "dyol",
      "dyolg",
      "dyolm",
      "dyolb",
      "dyols",
      "dyolt",
      "dyolp",
      "dyolh",
      "dyom",
      "dyob",
      "dyobs",
      "dyos",
      "dyoss",
      "dyong",
      "dyoj",
      "dyoc",
      "dyok",
      "dyot",
      "dyop",
      "dyoh",
      "du",
      "dug",
      "dugg",
      "dugs",
      "dun",
      "dunj",
      "dunh",
      "dud",
      "dul",
      "dulg",
      "dulm",
      "dulb",
      "duls",
      "dult",
      "dulp",
      "dulh",
      "dum",
      "dub",
      "dubs",
      "dus",
      "duss",
      "dung",
      "duj",
      "duc",
      "duk",
      "dut",
      "dup",
      "duh",
      "dweo",
      "dweog",
      "dweogg",
      "dweogs",
      "dweon",
      "dweonj",
      "dweonh",
      "dweod",
      "dweol",
      "dweolg",
      "dweolm",
      "dweolb",
      "dweols",
      "dweolt",
      "dweolp",
      "dweolh",
      "dweom",
      "dweob",
      "dweobs",
      "dweos",
      "dweoss",
      "dweong",
      "dweoj",
      "dweoc",
      "dweok",
      "dweot",
      "dweop",
      "dweoh",
      "dwe",
      "dweg",
      "dwegg",
      "dwegs",
      "dwen",
      "dwenj",
      "dwenh",
      "dwed",
      "dwel",
      "dwelg",
      "dwelm",
      "dwelb",
      "dwels",
      "dwelt",
      "dwelp",
      "dwelh",
      "dwem",
      "dweb",
      "dwebs",
      "dwes",
      "dwess",
      "dweng",
      "dwej",
      "dwec",
      "dwek",
      "dwet",
      "dwep",
      "dweh",
      "dwi",
      "dwig",
      "dwigg",
      "dwigs",
      "dwin",
      "dwinj",
      "dwinh",
      "dwid",
      "dwil",
      "dwilg",
      "dwilm",
      "dwilb",
      "dwils",
      "dwilt",
      "dwilp",
      "dwilh",
      "dwim",
      "dwib",
      "dwibs",
      "dwis",
      "dwiss",
      "dwing",
      "dwij",
      "dwic",
      "dwik",
      "dwit",
      "dwip",
      "dwih",
      "dyu",
      "dyug",
      "dyugg",
      "dyugs",
      "dyun",
      "dyunj",
      "dyunh",
      "dyud",
      "dyul",
      "dyulg",
      "dyulm",
      "dyulb",
      "dyuls",
      "dyult",
      "dyulp",
      "dyulh",
      "dyum",
      "dyub",
      "dyubs",
      "dyus",
      "dyuss",
      "dyung",
      "dyuj",
      "dyuc",
      "dyuk",
      "dyut",
      "dyup",
      "dyuh",
      "deu",
      "deug",
      "deugg",
      "deugs",
      "deun",
      "deunj",
      "deunh",
      "deud",
      "deul",
      "deulg",
      "deulm",
      "deulb",
      "deuls",
      "deult",
      "deulp",
      "deulh",
      "deum",
      "deub",
      "deubs",
      "deus",
      "deuss",
      "deung",
      "deuj",
      "deuc",
      "deuk",
      "deut",
      "deup",
      "deuh",
      "dyi",
      "dyig",
      "dyigg",
      "dyigs",
      "dyin",
      "dyinj",
      "dyinh",
      "dyid"
    ];
  }
});

// node_modules/unidecode/data/xb5.js
var require_xb5 = __commonJS({
  "node_modules/unidecode/data/xb5.js"(exports2, module2) {
    module2.exports = [
      "dyil",
      "dyilg",
      "dyilm",
      "dyilb",
      "dyils",
      "dyilt",
      "dyilp",
      "dyilh",
      "dyim",
      "dyib",
      "dyibs",
      "dyis",
      "dyiss",
      "dying",
      "dyij",
      "dyic",
      "dyik",
      "dyit",
      "dyip",
      "dyih",
      "di",
      "dig",
      "digg",
      "digs",
      "din",
      "dinj",
      "dinh",
      "did",
      "dil",
      "dilg",
      "dilm",
      "dilb",
      "dils",
      "dilt",
      "dilp",
      "dilh",
      "dim",
      "dib",
      "dibs",
      "dis",
      "diss",
      "ding",
      "dij",
      "dic",
      "dik",
      "dit",
      "dip",
      "dih",
      "dda",
      "ddag",
      "ddagg",
      "ddags",
      "ddan",
      "ddanj",
      "ddanh",
      "ddad",
      "ddal",
      "ddalg",
      "ddalm",
      "ddalb",
      "ddals",
      "ddalt",
      "ddalp",
      "ddalh",
      "ddam",
      "ddab",
      "ddabs",
      "ddas",
      "ddass",
      "ddang",
      "ddaj",
      "ddac",
      "ddak",
      "ddat",
      "ddap",
      "ddah",
      "ddae",
      "ddaeg",
      "ddaegg",
      "ddaegs",
      "ddaen",
      "ddaenj",
      "ddaenh",
      "ddaed",
      "ddael",
      "ddaelg",
      "ddaelm",
      "ddaelb",
      "ddaels",
      "ddaelt",
      "ddaelp",
      "ddaelh",
      "ddaem",
      "ddaeb",
      "ddaebs",
      "ddaes",
      "ddaess",
      "ddaeng",
      "ddaej",
      "ddaec",
      "ddaek",
      "ddaet",
      "ddaep",
      "ddaeh",
      "ddya",
      "ddyag",
      "ddyagg",
      "ddyags",
      "ddyan",
      "ddyanj",
      "ddyanh",
      "ddyad",
      "ddyal",
      "ddyalg",
      "ddyalm",
      "ddyalb",
      "ddyals",
      "ddyalt",
      "ddyalp",
      "ddyalh",
      "ddyam",
      "ddyab",
      "ddyabs",
      "ddyas",
      "ddyass",
      "ddyang",
      "ddyaj",
      "ddyac",
      "ddyak",
      "ddyat",
      "ddyap",
      "ddyah",
      "ddyae",
      "ddyaeg",
      "ddyaegg",
      "ddyaegs",
      "ddyaen",
      "ddyaenj",
      "ddyaenh",
      "ddyaed",
      "ddyael",
      "ddyaelg",
      "ddyaelm",
      "ddyaelb",
      "ddyaels",
      "ddyaelt",
      "ddyaelp",
      "ddyaelh",
      "ddyaem",
      "ddyaeb",
      "ddyaebs",
      "ddyaes",
      "ddyaess",
      "ddyaeng",
      "ddyaej",
      "ddyaec",
      "ddyaek",
      "ddyaet",
      "ddyaep",
      "ddyaeh",
      "ddeo",
      "ddeog",
      "ddeogg",
      "ddeogs",
      "ddeon",
      "ddeonj",
      "ddeonh",
      "ddeod",
      "ddeol",
      "ddeolg",
      "ddeolm",
      "ddeolb",
      "ddeols",
      "ddeolt",
      "ddeolp",
      "ddeolh",
      "ddeom",
      "ddeob",
      "ddeobs",
      "ddeos",
      "ddeoss",
      "ddeong",
      "ddeoj",
      "ddeoc",
      "ddeok",
      "ddeot",
      "ddeop",
      "ddeoh",
      "dde",
      "ddeg",
      "ddegg",
      "ddegs",
      "dden",
      "ddenj",
      "ddenh",
      "dded",
      "ddel",
      "ddelg",
      "ddelm",
      "ddelb",
      "ddels",
      "ddelt",
      "ddelp",
      "ddelh",
      "ddem",
      "ddeb",
      "ddebs",
      "ddes",
      "ddess",
      "ddeng",
      "ddej",
      "ddec",
      "ddek",
      "ddet",
      "ddep",
      "ddeh",
      "ddyeo",
      "ddyeog",
      "ddyeogg",
      "ddyeogs",
      "ddyeon",
      "ddyeonj",
      "ddyeonh",
      "ddyeod",
      "ddyeol",
      "ddyeolg",
      "ddyeolm",
      "ddyeolb",
      "ddyeols",
      "ddyeolt",
      "ddyeolp",
      "ddyeolh",
      "ddyeom",
      "ddyeob",
      "ddyeobs",
      "ddyeos",
      "ddyeoss",
      "ddyeong",
      "ddyeoj",
      "ddyeoc",
      "ddyeok",
      "ddyeot",
      "ddyeop",
      "ddyeoh",
      "ddye",
      "ddyeg",
      "ddyegg",
      "ddyegs",
      "ddyen",
      "ddyenj",
      "ddyenh",
      "ddyed",
      "ddyel",
      "ddyelg",
      "ddyelm",
      "ddyelb"
    ];
  }
});

// node_modules/unidecode/data/xb6.js
var require_xb6 = __commonJS({
  "node_modules/unidecode/data/xb6.js"(exports2, module2) {
    module2.exports = [
      "ddyels",
      "ddyelt",
      "ddyelp",
      "ddyelh",
      "ddyem",
      "ddyeb",
      "ddyebs",
      "ddyes",
      "ddyess",
      "ddyeng",
      "ddyej",
      "ddyec",
      "ddyek",
      "ddyet",
      "ddyep",
      "ddyeh",
      "ddo",
      "ddog",
      "ddogg",
      "ddogs",
      "ddon",
      "ddonj",
      "ddonh",
      "ddod",
      "ddol",
      "ddolg",
      "ddolm",
      "ddolb",
      "ddols",
      "ddolt",
      "ddolp",
      "ddolh",
      "ddom",
      "ddob",
      "ddobs",
      "ddos",
      "ddoss",
      "ddong",
      "ddoj",
      "ddoc",
      "ddok",
      "ddot",
      "ddop",
      "ddoh",
      "ddwa",
      "ddwag",
      "ddwagg",
      "ddwags",
      "ddwan",
      "ddwanj",
      "ddwanh",
      "ddwad",
      "ddwal",
      "ddwalg",
      "ddwalm",
      "ddwalb",
      "ddwals",
      "ddwalt",
      "ddwalp",
      "ddwalh",
      "ddwam",
      "ddwab",
      "ddwabs",
      "ddwas",
      "ddwass",
      "ddwang",
      "ddwaj",
      "ddwac",
      "ddwak",
      "ddwat",
      "ddwap",
      "ddwah",
      "ddwae",
      "ddwaeg",
      "ddwaegg",
      "ddwaegs",
      "ddwaen",
      "ddwaenj",
      "ddwaenh",
      "ddwaed",
      "ddwael",
      "ddwaelg",
      "ddwaelm",
      "ddwaelb",
      "ddwaels",
      "ddwaelt",
      "ddwaelp",
      "ddwaelh",
      "ddwaem",
      "ddwaeb",
      "ddwaebs",
      "ddwaes",
      "ddwaess",
      "ddwaeng",
      "ddwaej",
      "ddwaec",
      "ddwaek",
      "ddwaet",
      "ddwaep",
      "ddwaeh",
      "ddoe",
      "ddoeg",
      "ddoegg",
      "ddoegs",
      "ddoen",
      "ddoenj",
      "ddoenh",
      "ddoed",
      "ddoel",
      "ddoelg",
      "ddoelm",
      "ddoelb",
      "ddoels",
      "ddoelt",
      "ddoelp",
      "ddoelh",
      "ddoem",
      "ddoeb",
      "ddoebs",
      "ddoes",
      "ddoess",
      "ddoeng",
      "ddoej",
      "ddoec",
      "ddoek",
      "ddoet",
      "ddoep",
      "ddoeh",
      "ddyo",
      "ddyog",
      "ddyogg",
      "ddyogs",
      "ddyon",
      "ddyonj",
      "ddyonh",
      "ddyod",
      "ddyol",
      "ddyolg",
      "ddyolm",
      "ddyolb",
      "ddyols",
      "ddyolt",
      "ddyolp",
      "ddyolh",
      "ddyom",
      "ddyob",
      "ddyobs",
      "ddyos",
      "ddyoss",
      "ddyong",
      "ddyoj",
      "ddyoc",
      "ddyok",
      "ddyot",
      "ddyop",
      "ddyoh",
      "ddu",
      "ddug",
      "ddugg",
      "ddugs",
      "ddun",
      "ddunj",
      "ddunh",
      "ddud",
      "ddul",
      "ddulg",
      "ddulm",
      "ddulb",
      "dduls",
      "ddult",
      "ddulp",
      "ddulh",
      "ddum",
      "ddub",
      "ddubs",
      "ddus",
      "dduss",
      "ddung",
      "dduj",
      "dduc",
      "dduk",
      "ddut",
      "ddup",
      "dduh",
      "ddweo",
      "ddweog",
      "ddweogg",
      "ddweogs",
      "ddweon",
      "ddweonj",
      "ddweonh",
      "ddweod",
      "ddweol",
      "ddweolg",
      "ddweolm",
      "ddweolb",
      "ddweols",
      "ddweolt",
      "ddweolp",
      "ddweolh",
      "ddweom",
      "ddweob",
      "ddweobs",
      "ddweos",
      "ddweoss",
      "ddweong",
      "ddweoj",
      "ddweoc",
      "ddweok",
      "ddweot",
      "ddweop",
      "ddweoh",
      "ddwe",
      "ddweg",
      "ddwegg",
      "ddwegs",
      "ddwen",
      "ddwenj",
      "ddwenh",
      "ddwed",
      "ddwel",
      "ddwelg",
      "ddwelm",
      "ddwelb",
      "ddwels",
      "ddwelt",
      "ddwelp",
      "ddwelh",
      "ddwem",
      "ddweb",
      "ddwebs",
      "ddwes",
      "ddwess",
      "ddweng",
      "ddwej",
      "ddwec",
      "ddwek",
      "ddwet",
      "ddwep",
      "ddweh",
      "ddwi",
      "ddwig",
      "ddwigg",
      "ddwigs",
      "ddwin",
      "ddwinj",
      "ddwinh",
      "ddwid",
      "ddwil",
      "ddwilg",
      "ddwilm",
      "ddwilb",
      "ddwils",
      "ddwilt",
      "ddwilp",
      "ddwilh"
    ];
  }
});

// node_modules/unidecode/data/xb7.js
var require_xb7 = __commonJS({
  "node_modules/unidecode/data/xb7.js"(exports2, module2) {
    module2.exports = [
      "ddwim",
      "ddwib",
      "ddwibs",
      "ddwis",
      "ddwiss",
      "ddwing",
      "ddwij",
      "ddwic",
      "ddwik",
      "ddwit",
      "ddwip",
      "ddwih",
      "ddyu",
      "ddyug",
      "ddyugg",
      "ddyugs",
      "ddyun",
      "ddyunj",
      "ddyunh",
      "ddyud",
      "ddyul",
      "ddyulg",
      "ddyulm",
      "ddyulb",
      "ddyuls",
      "ddyult",
      "ddyulp",
      "ddyulh",
      "ddyum",
      "ddyub",
      "ddyubs",
      "ddyus",
      "ddyuss",
      "ddyung",
      "ddyuj",
      "ddyuc",
      "ddyuk",
      "ddyut",
      "ddyup",
      "ddyuh",
      "ddeu",
      "ddeug",
      "ddeugg",
      "ddeugs",
      "ddeun",
      "ddeunj",
      "ddeunh",
      "ddeud",
      "ddeul",
      "ddeulg",
      "ddeulm",
      "ddeulb",
      "ddeuls",
      "ddeult",
      "ddeulp",
      "ddeulh",
      "ddeum",
      "ddeub",
      "ddeubs",
      "ddeus",
      "ddeuss",
      "ddeung",
      "ddeuj",
      "ddeuc",
      "ddeuk",
      "ddeut",
      "ddeup",
      "ddeuh",
      "ddyi",
      "ddyig",
      "ddyigg",
      "ddyigs",
      "ddyin",
      "ddyinj",
      "ddyinh",
      "ddyid",
      "ddyil",
      "ddyilg",
      "ddyilm",
      "ddyilb",
      "ddyils",
      "ddyilt",
      "ddyilp",
      "ddyilh",
      "ddyim",
      "ddyib",
      "ddyibs",
      "ddyis",
      "ddyiss",
      "ddying",
      "ddyij",
      "ddyic",
      "ddyik",
      "ddyit",
      "ddyip",
      "ddyih",
      "ddi",
      "ddig",
      "ddigg",
      "ddigs",
      "ddin",
      "ddinj",
      "ddinh",
      "ddid",
      "ddil",
      "ddilg",
      "ddilm",
      "ddilb",
      "ddils",
      "ddilt",
      "ddilp",
      "ddilh",
      "ddim",
      "ddib",
      "ddibs",
      "ddis",
      "ddiss",
      "dding",
      "ddij",
      "ddic",
      "ddik",
      "ddit",
      "ddip",
      "ddih",
      "ra",
      "rag",
      "ragg",
      "rags",
      "ran",
      "ranj",
      "ranh",
      "rad",
      "ral",
      "ralg",
      "ralm",
      "ralb",
      "rals",
      "ralt",
      "ralp",
      "ralh",
      "ram",
      "rab",
      "rabs",
      "ras",
      "rass",
      "rang",
      "raj",
      "rac",
      "rak",
      "rat",
      "rap",
      "rah",
      "rae",
      "raeg",
      "raegg",
      "raegs",
      "raen",
      "raenj",
      "raenh",
      "raed",
      "rael",
      "raelg",
      "raelm",
      "raelb",
      "raels",
      "raelt",
      "raelp",
      "raelh",
      "raem",
      "raeb",
      "raebs",
      "raes",
      "raess",
      "raeng",
      "raej",
      "raec",
      "raek",
      "raet",
      "raep",
      "raeh",
      "rya",
      "ryag",
      "ryagg",
      "ryags",
      "ryan",
      "ryanj",
      "ryanh",
      "ryad",
      "ryal",
      "ryalg",
      "ryalm",
      "ryalb",
      "ryals",
      "ryalt",
      "ryalp",
      "ryalh",
      "ryam",
      "ryab",
      "ryabs",
      "ryas",
      "ryass",
      "ryang",
      "ryaj",
      "ryac",
      "ryak",
      "ryat",
      "ryap",
      "ryah",
      "ryae",
      "ryaeg",
      "ryaegg",
      "ryaegs",
      "ryaen",
      "ryaenj",
      "ryaenh",
      "ryaed",
      "ryael",
      "ryaelg",
      "ryaelm",
      "ryaelb",
      "ryaels",
      "ryaelt",
      "ryaelp",
      "ryaelh",
      "ryaem",
      "ryaeb",
      "ryaebs",
      "ryaes",
      "ryaess",
      "ryaeng",
      "ryaej",
      "ryaec",
      "ryaek",
      "ryaet",
      "ryaep",
      "ryaeh",
      "reo",
      "reog",
      "reogg",
      "reogs",
      "reon",
      "reonj",
      "reonh",
      "reod",
      "reol",
      "reolg",
      "reolm",
      "reolb",
      "reols",
      "reolt",
      "reolp",
      "reolh",
      "reom",
      "reob",
      "reobs",
      "reos"
    ];
  }
});

// node_modules/unidecode/data/xb8.js
var require_xb8 = __commonJS({
  "node_modules/unidecode/data/xb8.js"(exports2, module2) {
    module2.exports = [
      "reoss",
      "reong",
      "reoj",
      "reoc",
      "reok",
      "reot",
      "reop",
      "reoh",
      "re",
      "reg",
      "regg",
      "regs",
      "ren",
      "renj",
      "renh",
      "red",
      "rel",
      "relg",
      "relm",
      "relb",
      "rels",
      "relt",
      "relp",
      "relh",
      "rem",
      "reb",
      "rebs",
      "res",
      "ress",
      "reng",
      "rej",
      "rec",
      "rek",
      "ret",
      "rep",
      "reh",
      "ryeo",
      "ryeog",
      "ryeogg",
      "ryeogs",
      "ryeon",
      "ryeonj",
      "ryeonh",
      "ryeod",
      "ryeol",
      "ryeolg",
      "ryeolm",
      "ryeolb",
      "ryeols",
      "ryeolt",
      "ryeolp",
      "ryeolh",
      "ryeom",
      "ryeob",
      "ryeobs",
      "ryeos",
      "ryeoss",
      "ryeong",
      "ryeoj",
      "ryeoc",
      "ryeok",
      "ryeot",
      "ryeop",
      "ryeoh",
      "rye",
      "ryeg",
      "ryegg",
      "ryegs",
      "ryen",
      "ryenj",
      "ryenh",
      "ryed",
      "ryel",
      "ryelg",
      "ryelm",
      "ryelb",
      "ryels",
      "ryelt",
      "ryelp",
      "ryelh",
      "ryem",
      "ryeb",
      "ryebs",
      "ryes",
      "ryess",
      "ryeng",
      "ryej",
      "ryec",
      "ryek",
      "ryet",
      "ryep",
      "ryeh",
      "ro",
      "rog",
      "rogg",
      "rogs",
      "ron",
      "ronj",
      "ronh",
      "rod",
      "rol",
      "rolg",
      "rolm",
      "rolb",
      "rols",
      "rolt",
      "rolp",
      "rolh",
      "rom",
      "rob",
      "robs",
      "ros",
      "ross",
      "rong",
      "roj",
      "roc",
      "rok",
      "rot",
      "rop",
      "roh",
      "rwa",
      "rwag",
      "rwagg",
      "rwags",
      "rwan",
      "rwanj",
      "rwanh",
      "rwad",
      "rwal",
      "rwalg",
      "rwalm",
      "rwalb",
      "rwals",
      "rwalt",
      "rwalp",
      "rwalh",
      "rwam",
      "rwab",
      "rwabs",
      "rwas",
      "rwass",
      "rwang",
      "rwaj",
      "rwac",
      "rwak",
      "rwat",
      "rwap",
      "rwah",
      "rwae",
      "rwaeg",
      "rwaegg",
      "rwaegs",
      "rwaen",
      "rwaenj",
      "rwaenh",
      "rwaed",
      "rwael",
      "rwaelg",
      "rwaelm",
      "rwaelb",
      "rwaels",
      "rwaelt",
      "rwaelp",
      "rwaelh",
      "rwaem",
      "rwaeb",
      "rwaebs",
      "rwaes",
      "rwaess",
      "rwaeng",
      "rwaej",
      "rwaec",
      "rwaek",
      "rwaet",
      "rwaep",
      "rwaeh",
      "roe",
      "roeg",
      "roegg",
      "roegs",
      "roen",
      "roenj",
      "roenh",
      "roed",
      "roel",
      "roelg",
      "roelm",
      "roelb",
      "roels",
      "roelt",
      "roelp",
      "roelh",
      "roem",
      "roeb",
      "roebs",
      "roes",
      "roess",
      "roeng",
      "roej",
      "roec",
      "roek",
      "roet",
      "roep",
      "roeh",
      "ryo",
      "ryog",
      "ryogg",
      "ryogs",
      "ryon",
      "ryonj",
      "ryonh",
      "ryod",
      "ryol",
      "ryolg",
      "ryolm",
      "ryolb",
      "ryols",
      "ryolt",
      "ryolp",
      "ryolh",
      "ryom",
      "ryob",
      "ryobs",
      "ryos",
      "ryoss",
      "ryong",
      "ryoj",
      "ryoc",
      "ryok",
      "ryot",
      "ryop",
      "ryoh",
      "ru",
      "rug",
      "rugg",
      "rugs",
      "run",
      "runj",
      "runh",
      "rud",
      "rul",
      "rulg",
      "rulm",
      "rulb",
      "ruls",
      "rult",
      "rulp",
      "rulh",
      "rum",
      "rub",
      "rubs",
      "rus",
      "russ",
      "rung",
      "ruj",
      "ruc"
    ];
  }
});

// node_modules/unidecode/data/xb9.js
var require_xb9 = __commonJS({
  "node_modules/unidecode/data/xb9.js"(exports2, module2) {
    module2.exports = [
      "ruk",
      "rut",
      "rup",
      "ruh",
      "rweo",
      "rweog",
      "rweogg",
      "rweogs",
      "rweon",
      "rweonj",
      "rweonh",
      "rweod",
      "rweol",
      "rweolg",
      "rweolm",
      "rweolb",
      "rweols",
      "rweolt",
      "rweolp",
      "rweolh",
      "rweom",
      "rweob",
      "rweobs",
      "rweos",
      "rweoss",
      "rweong",
      "rweoj",
      "rweoc",
      "rweok",
      "rweot",
      "rweop",
      "rweoh",
      "rwe",
      "rweg",
      "rwegg",
      "rwegs",
      "rwen",
      "rwenj",
      "rwenh",
      "rwed",
      "rwel",
      "rwelg",
      "rwelm",
      "rwelb",
      "rwels",
      "rwelt",
      "rwelp",
      "rwelh",
      "rwem",
      "rweb",
      "rwebs",
      "rwes",
      "rwess",
      "rweng",
      "rwej",
      "rwec",
      "rwek",
      "rwet",
      "rwep",
      "rweh",
      "rwi",
      "rwig",
      "rwigg",
      "rwigs",
      "rwin",
      "rwinj",
      "rwinh",
      "rwid",
      "rwil",
      "rwilg",
      "rwilm",
      "rwilb",
      "rwils",
      "rwilt",
      "rwilp",
      "rwilh",
      "rwim",
      "rwib",
      "rwibs",
      "rwis",
      "rwiss",
      "rwing",
      "rwij",
      "rwic",
      "rwik",
      "rwit",
      "rwip",
      "rwih",
      "ryu",
      "ryug",
      "ryugg",
      "ryugs",
      "ryun",
      "ryunj",
      "ryunh",
      "ryud",
      "ryul",
      "ryulg",
      "ryulm",
      "ryulb",
      "ryuls",
      "ryult",
      "ryulp",
      "ryulh",
      "ryum",
      "ryub",
      "ryubs",
      "ryus",
      "ryuss",
      "ryung",
      "ryuj",
      "ryuc",
      "ryuk",
      "ryut",
      "ryup",
      "ryuh",
      "reu",
      "reug",
      "reugg",
      "reugs",
      "reun",
      "reunj",
      "reunh",
      "reud",
      "reul",
      "reulg",
      "reulm",
      "reulb",
      "reuls",
      "reult",
      "reulp",
      "reulh",
      "reum",
      "reub",
      "reubs",
      "reus",
      "reuss",
      "reung",
      "reuj",
      "reuc",
      "reuk",
      "reut",
      "reup",
      "reuh",
      "ryi",
      "ryig",
      "ryigg",
      "ryigs",
      "ryin",
      "ryinj",
      "ryinh",
      "ryid",
      "ryil",
      "ryilg",
      "ryilm",
      "ryilb",
      "ryils",
      "ryilt",
      "ryilp",
      "ryilh",
      "ryim",
      "ryib",
      "ryibs",
      "ryis",
      "ryiss",
      "rying",
      "ryij",
      "ryic",
      "ryik",
      "ryit",
      "ryip",
      "ryih",
      "ri",
      "rig",
      "rigg",
      "rigs",
      "rin",
      "rinj",
      "rinh",
      "rid",
      "ril",
      "rilg",
      "rilm",
      "rilb",
      "rils",
      "rilt",
      "rilp",
      "rilh",
      "rim",
      "rib",
      "ribs",
      "ris",
      "riss",
      "ring",
      "rij",
      "ric",
      "rik",
      "rit",
      "rip",
      "rih",
      "ma",
      "mag",
      "magg",
      "mags",
      "man",
      "manj",
      "manh",
      "mad",
      "mal",
      "malg",
      "malm",
      "malb",
      "mals",
      "malt",
      "malp",
      "malh",
      "mam",
      "mab",
      "mabs",
      "mas",
      "mass",
      "mang",
      "maj",
      "mac",
      "mak",
      "mat",
      "map",
      "mah",
      "mae",
      "maeg",
      "maegg",
      "maegs",
      "maen",
      "maenj",
      "maenh",
      "maed",
      "mael",
      "maelg",
      "maelm",
      "maelb",
      "maels",
      "maelt",
      "maelp",
      "maelh",
      "maem",
      "maeb",
      "maebs",
      "maes",
      "maess",
      "maeng",
      "maej",
      "maec",
      "maek",
      "maet",
      "maep",
      "maeh"
    ];
  }
});

// node_modules/unidecode/data/xba.js
var require_xba = __commonJS({
  "node_modules/unidecode/data/xba.js"(exports2, module2) {
    module2.exports = [
      "mya",
      "myag",
      "myagg",
      "myags",
      "myan",
      "myanj",
      "myanh",
      "myad",
      "myal",
      "myalg",
      "myalm",
      "myalb",
      "myals",
      "myalt",
      "myalp",
      "myalh",
      "myam",
      "myab",
      "myabs",
      "myas",
      "myass",
      "myang",
      "myaj",
      "myac",
      "myak",
      "myat",
      "myap",
      "myah",
      "myae",
      "myaeg",
      "myaegg",
      "myaegs",
      "myaen",
      "myaenj",
      "myaenh",
      "myaed",
      "myael",
      "myaelg",
      "myaelm",
      "myaelb",
      "myaels",
      "myaelt",
      "myaelp",
      "myaelh",
      "myaem",
      "myaeb",
      "myaebs",
      "myaes",
      "myaess",
      "myaeng",
      "myaej",
      "myaec",
      "myaek",
      "myaet",
      "myaep",
      "myaeh",
      "meo",
      "meog",
      "meogg",
      "meogs",
      "meon",
      "meonj",
      "meonh",
      "meod",
      "meol",
      "meolg",
      "meolm",
      "meolb",
      "meols",
      "meolt",
      "meolp",
      "meolh",
      "meom",
      "meob",
      "meobs",
      "meos",
      "meoss",
      "meong",
      "meoj",
      "meoc",
      "meok",
      "meot",
      "meop",
      "meoh",
      "me",
      "meg",
      "megg",
      "megs",
      "men",
      "menj",
      "menh",
      "med",
      "mel",
      "melg",
      "melm",
      "melb",
      "mels",
      "melt",
      "melp",
      "melh",
      "mem",
      "meb",
      "mebs",
      "mes",
      "mess",
      "meng",
      "mej",
      "mec",
      "mek",
      "met",
      "mep",
      "meh",
      "myeo",
      "myeog",
      "myeogg",
      "myeogs",
      "myeon",
      "myeonj",
      "myeonh",
      "myeod",
      "myeol",
      "myeolg",
      "myeolm",
      "myeolb",
      "myeols",
      "myeolt",
      "myeolp",
      "myeolh",
      "myeom",
      "myeob",
      "myeobs",
      "myeos",
      "myeoss",
      "myeong",
      "myeoj",
      "myeoc",
      "myeok",
      "myeot",
      "myeop",
      "myeoh",
      "mye",
      "myeg",
      "myegg",
      "myegs",
      "myen",
      "myenj",
      "myenh",
      "myed",
      "myel",
      "myelg",
      "myelm",
      "myelb",
      "myels",
      "myelt",
      "myelp",
      "myelh",
      "myem",
      "myeb",
      "myebs",
      "myes",
      "myess",
      "myeng",
      "myej",
      "myec",
      "myek",
      "myet",
      "myep",
      "myeh",
      "mo",
      "mog",
      "mogg",
      "mogs",
      "mon",
      "monj",
      "monh",
      "mod",
      "mol",
      "molg",
      "molm",
      "molb",
      "mols",
      "molt",
      "molp",
      "molh",
      "mom",
      "mob",
      "mobs",
      "mos",
      "moss",
      "mong",
      "moj",
      "moc",
      "mok",
      "mot",
      "mop",
      "moh",
      "mwa",
      "mwag",
      "mwagg",
      "mwags",
      "mwan",
      "mwanj",
      "mwanh",
      "mwad",
      "mwal",
      "mwalg",
      "mwalm",
      "mwalb",
      "mwals",
      "mwalt",
      "mwalp",
      "mwalh",
      "mwam",
      "mwab",
      "mwabs",
      "mwas",
      "mwass",
      "mwang",
      "mwaj",
      "mwac",
      "mwak",
      "mwat",
      "mwap",
      "mwah",
      "mwae",
      "mwaeg",
      "mwaegg",
      "mwaegs",
      "mwaen",
      "mwaenj",
      "mwaenh",
      "mwaed",
      "mwael",
      "mwaelg",
      "mwaelm",
      "mwaelb",
      "mwaels",
      "mwaelt",
      "mwaelp",
      "mwaelh",
      "mwaem",
      "mwaeb",
      "mwaebs",
      "mwaes",
      "mwaess",
      "mwaeng",
      "mwaej",
      "mwaec",
      "mwaek",
      "mwaet",
      "mwaep",
      "mwaeh",
      "moe",
      "moeg",
      "moegg",
      "moegs"
    ];
  }
});

// node_modules/unidecode/data/xbb.js
var require_xbb = __commonJS({
  "node_modules/unidecode/data/xbb.js"(exports2, module2) {
    module2.exports = [
      "moen",
      "moenj",
      "moenh",
      "moed",
      "moel",
      "moelg",
      "moelm",
      "moelb",
      "moels",
      "moelt",
      "moelp",
      "moelh",
      "moem",
      "moeb",
      "moebs",
      "moes",
      "moess",
      "moeng",
      "moej",
      "moec",
      "moek",
      "moet",
      "moep",
      "moeh",
      "myo",
      "myog",
      "myogg",
      "myogs",
      "myon",
      "myonj",
      "myonh",
      "myod",
      "myol",
      "myolg",
      "myolm",
      "myolb",
      "myols",
      "myolt",
      "myolp",
      "myolh",
      "myom",
      "myob",
      "myobs",
      "myos",
      "myoss",
      "myong",
      "myoj",
      "myoc",
      "myok",
      "myot",
      "myop",
      "myoh",
      "mu",
      "mug",
      "mugg",
      "mugs",
      "mun",
      "munj",
      "munh",
      "mud",
      "mul",
      "mulg",
      "mulm",
      "mulb",
      "muls",
      "mult",
      "mulp",
      "mulh",
      "mum",
      "mub",
      "mubs",
      "mus",
      "muss",
      "mung",
      "muj",
      "muc",
      "muk",
      "mut",
      "mup",
      "muh",
      "mweo",
      "mweog",
      "mweogg",
      "mweogs",
      "mweon",
      "mweonj",
      "mweonh",
      "mweod",
      "mweol",
      "mweolg",
      "mweolm",
      "mweolb",
      "mweols",
      "mweolt",
      "mweolp",
      "mweolh",
      "mweom",
      "mweob",
      "mweobs",
      "mweos",
      "mweoss",
      "mweong",
      "mweoj",
      "mweoc",
      "mweok",
      "mweot",
      "mweop",
      "mweoh",
      "mwe",
      "mweg",
      "mwegg",
      "mwegs",
      "mwen",
      "mwenj",
      "mwenh",
      "mwed",
      "mwel",
      "mwelg",
      "mwelm",
      "mwelb",
      "mwels",
      "mwelt",
      "mwelp",
      "mwelh",
      "mwem",
      "mweb",
      "mwebs",
      "mwes",
      "mwess",
      "mweng",
      "mwej",
      "mwec",
      "mwek",
      "mwet",
      "mwep",
      "mweh",
      "mwi",
      "mwig",
      "mwigg",
      "mwigs",
      "mwin",
      "mwinj",
      "mwinh",
      "mwid",
      "mwil",
      "mwilg",
      "mwilm",
      "mwilb",
      "mwils",
      "mwilt",
      "mwilp",
      "mwilh",
      "mwim",
      "mwib",
      "mwibs",
      "mwis",
      "mwiss",
      "mwing",
      "mwij",
      "mwic",
      "mwik",
      "mwit",
      "mwip",
      "mwih",
      "myu",
      "myug",
      "myugg",
      "myugs",
      "myun",
      "myunj",
      "myunh",
      "myud",
      "myul",
      "myulg",
      "myulm",
      "myulb",
      "myuls",
      "myult",
      "myulp",
      "myulh",
      "myum",
      "myub",
      "myubs",
      "myus",
      "myuss",
      "myung",
      "myuj",
      "myuc",
      "myuk",
      "myut",
      "myup",
      "myuh",
      "meu",
      "meug",
      "meugg",
      "meugs",
      "meun",
      "meunj",
      "meunh",
      "meud",
      "meul",
      "meulg",
      "meulm",
      "meulb",
      "meuls",
      "meult",
      "meulp",
      "meulh",
      "meum",
      "meub",
      "meubs",
      "meus",
      "meuss",
      "meung",
      "meuj",
      "meuc",
      "meuk",
      "meut",
      "meup",
      "meuh",
      "myi",
      "myig",
      "myigg",
      "myigs",
      "myin",
      "myinj",
      "myinh",
      "myid",
      "myil",
      "myilg",
      "myilm",
      "myilb",
      "myils",
      "myilt",
      "myilp",
      "myilh",
      "myim",
      "myib",
      "myibs",
      "myis",
      "myiss",
      "mying",
      "myij",
      "myic",
      "myik",
      "myit",
      "myip",
      "myih",
      "mi",
      "mig",
      "migg",
      "migs",
      "min",
      "minj",
      "minh",
      "mid"
    ];
  }
});

// node_modules/unidecode/data/xbc.js
var require_xbc = __commonJS({
  "node_modules/unidecode/data/xbc.js"(exports2, module2) {
    module2.exports = [
      "mil",
      "milg",
      "milm",
      "milb",
      "mils",
      "milt",
      "milp",
      "milh",
      "mim",
      "mib",
      "mibs",
      "mis",
      "miss",
      "ming",
      "mij",
      "mic",
      "mik",
      "mit",
      "mip",
      "mih",
      "ba",
      "bag",
      "bagg",
      "bags",
      "ban",
      "banj",
      "banh",
      "bad",
      "bal",
      "balg",
      "balm",
      "balb",
      "bals",
      "balt",
      "balp",
      "balh",
      "bam",
      "bab",
      "babs",
      "bas",
      "bass",
      "bang",
      "baj",
      "bac",
      "bak",
      "bat",
      "bap",
      "bah",
      "bae",
      "baeg",
      "baegg",
      "baegs",
      "baen",
      "baenj",
      "baenh",
      "baed",
      "bael",
      "baelg",
      "baelm",
      "baelb",
      "baels",
      "baelt",
      "baelp",
      "baelh",
      "baem",
      "baeb",
      "baebs",
      "baes",
      "baess",
      "baeng",
      "baej",
      "baec",
      "baek",
      "baet",
      "baep",
      "baeh",
      "bya",
      "byag",
      "byagg",
      "byags",
      "byan",
      "byanj",
      "byanh",
      "byad",
      "byal",
      "byalg",
      "byalm",
      "byalb",
      "byals",
      "byalt",
      "byalp",
      "byalh",
      "byam",
      "byab",
      "byabs",
      "byas",
      "byass",
      "byang",
      "byaj",
      "byac",
      "byak",
      "byat",
      "byap",
      "byah",
      "byae",
      "byaeg",
      "byaegg",
      "byaegs",
      "byaen",
      "byaenj",
      "byaenh",
      "byaed",
      "byael",
      "byaelg",
      "byaelm",
      "byaelb",
      "byaels",
      "byaelt",
      "byaelp",
      "byaelh",
      "byaem",
      "byaeb",
      "byaebs",
      "byaes",
      "byaess",
      "byaeng",
      "byaej",
      "byaec",
      "byaek",
      "byaet",
      "byaep",
      "byaeh",
      "beo",
      "beog",
      "beogg",
      "beogs",
      "beon",
      "beonj",
      "beonh",
      "beod",
      "beol",
      "beolg",
      "beolm",
      "beolb",
      "beols",
      "beolt",
      "beolp",
      "beolh",
      "beom",
      "beob",
      "beobs",
      "beos",
      "beoss",
      "beong",
      "beoj",
      "beoc",
      "beok",
      "beot",
      "beop",
      "beoh",
      "be",
      "beg",
      "begg",
      "begs",
      "ben",
      "benj",
      "benh",
      "bed",
      "bel",
      "belg",
      "belm",
      "belb",
      "bels",
      "belt",
      "belp",
      "belh",
      "bem",
      "beb",
      "bebs",
      "bes",
      "bess",
      "beng",
      "bej",
      "bec",
      "bek",
      "bet",
      "bep",
      "beh",
      "byeo",
      "byeog",
      "byeogg",
      "byeogs",
      "byeon",
      "byeonj",
      "byeonh",
      "byeod",
      "byeol",
      "byeolg",
      "byeolm",
      "byeolb",
      "byeols",
      "byeolt",
      "byeolp",
      "byeolh",
      "byeom",
      "byeob",
      "byeobs",
      "byeos",
      "byeoss",
      "byeong",
      "byeoj",
      "byeoc",
      "byeok",
      "byeot",
      "byeop",
      "byeoh",
      "bye",
      "byeg",
      "byegg",
      "byegs",
      "byen",
      "byenj",
      "byenh",
      "byed",
      "byel",
      "byelg",
      "byelm",
      "byelb",
      "byels",
      "byelt",
      "byelp",
      "byelh",
      "byem",
      "byeb",
      "byebs",
      "byes",
      "byess",
      "byeng",
      "byej",
      "byec",
      "byek",
      "byet",
      "byep",
      "byeh",
      "bo",
      "bog",
      "bogg",
      "bogs",
      "bon",
      "bonj",
      "bonh",
      "bod",
      "bol",
      "bolg",
      "bolm",
      "bolb"
    ];
  }
});

// node_modules/unidecode/data/xbd.js
var require_xbd = __commonJS({
  "node_modules/unidecode/data/xbd.js"(exports2, module2) {
    module2.exports = [
      "bols",
      "bolt",
      "bolp",
      "bolh",
      "bom",
      "bob",
      "bobs",
      "bos",
      "boss",
      "bong",
      "boj",
      "boc",
      "bok",
      "bot",
      "bop",
      "boh",
      "bwa",
      "bwag",
      "bwagg",
      "bwags",
      "bwan",
      "bwanj",
      "bwanh",
      "bwad",
      "bwal",
      "bwalg",
      "bwalm",
      "bwalb",
      "bwals",
      "bwalt",
      "bwalp",
      "bwalh",
      "bwam",
      "bwab",
      "bwabs",
      "bwas",
      "bwass",
      "bwang",
      "bwaj",
      "bwac",
      "bwak",
      "bwat",
      "bwap",
      "bwah",
      "bwae",
      "bwaeg",
      "bwaegg",
      "bwaegs",
      "bwaen",
      "bwaenj",
      "bwaenh",
      "bwaed",
      "bwael",
      "bwaelg",
      "bwaelm",
      "bwaelb",
      "bwaels",
      "bwaelt",
      "bwaelp",
      "bwaelh",
      "bwaem",
      "bwaeb",
      "bwaebs",
      "bwaes",
      "bwaess",
      "bwaeng",
      "bwaej",
      "bwaec",
      "bwaek",
      "bwaet",
      "bwaep",
      "bwaeh",
      "boe",
      "boeg",
      "boegg",
      "boegs",
      "boen",
      "boenj",
      "boenh",
      "boed",
      "boel",
      "boelg",
      "boelm",
      "boelb",
      "boels",
      "boelt",
      "boelp",
      "boelh",
      "boem",
      "boeb",
      "boebs",
      "boes",
      "boess",
      "boeng",
      "boej",
      "boec",
      "boek",
      "boet",
      "boep",
      "boeh",
      "byo",
      "byog",
      "byogg",
      "byogs",
      "byon",
      "byonj",
      "byonh",
      "byod",
      "byol",
      "byolg",
      "byolm",
      "byolb",
      "byols",
      "byolt",
      "byolp",
      "byolh",
      "byom",
      "byob",
      "byobs",
      "byos",
      "byoss",
      "byong",
      "byoj",
      "byoc",
      "byok",
      "byot",
      "byop",
      "byoh",
      "bu",
      "bug",
      "bugg",
      "bugs",
      "bun",
      "bunj",
      "bunh",
      "bud",
      "bul",
      "bulg",
      "bulm",
      "bulb",
      "buls",
      "bult",
      "bulp",
      "bulh",
      "bum",
      "bub",
      "bubs",
      "bus",
      "buss",
      "bung",
      "buj",
      "buc",
      "buk",
      "but",
      "bup",
      "buh",
      "bweo",
      "bweog",
      "bweogg",
      "bweogs",
      "bweon",
      "bweonj",
      "bweonh",
      "bweod",
      "bweol",
      "bweolg",
      "bweolm",
      "bweolb",
      "bweols",
      "bweolt",
      "bweolp",
      "bweolh",
      "bweom",
      "bweob",
      "bweobs",
      "bweos",
      "bweoss",
      "bweong",
      "bweoj",
      "bweoc",
      "bweok",
      "bweot",
      "bweop",
      "bweoh",
      "bwe",
      "bweg",
      "bwegg",
      "bwegs",
      "bwen",
      "bwenj",
      "bwenh",
      "bwed",
      "bwel",
      "bwelg",
      "bwelm",
      "bwelb",
      "bwels",
      "bwelt",
      "bwelp",
      "bwelh",
      "bwem",
      "bweb",
      "bwebs",
      "bwes",
      "bwess",
      "bweng",
      "bwej",
      "bwec",
      "bwek",
      "bwet",
      "bwep",
      "bweh",
      "bwi",
      "bwig",
      "bwigg",
      "bwigs",
      "bwin",
      "bwinj",
      "bwinh",
      "bwid",
      "bwil",
      "bwilg",
      "bwilm",
      "bwilb",
      "bwils",
      "bwilt",
      "bwilp",
      "bwilh",
      "bwim",
      "bwib",
      "bwibs",
      "bwis",
      "bwiss",
      "bwing",
      "bwij",
      "bwic",
      "bwik",
      "bwit",
      "bwip",
      "bwih",
      "byu",
      "byug",
      "byugg",
      "byugs",
      "byun",
      "byunj",
      "byunh",
      "byud",
      "byul",
      "byulg",
      "byulm",
      "byulb",
      "byuls",
      "byult",
      "byulp",
      "byulh"
    ];
  }
});

// node_modules/unidecode/data/xbe.js
var require_xbe = __commonJS({
  "node_modules/unidecode/data/xbe.js"(exports2, module2) {
    module2.exports = [
      "byum",
      "byub",
      "byubs",
      "byus",
      "byuss",
      "byung",
      "byuj",
      "byuc",
      "byuk",
      "byut",
      "byup",
      "byuh",
      "beu",
      "beug",
      "beugg",
      "beugs",
      "beun",
      "beunj",
      "beunh",
      "beud",
      "beul",
      "beulg",
      "beulm",
      "beulb",
      "beuls",
      "beult",
      "beulp",
      "beulh",
      "beum",
      "beub",
      "beubs",
      "beus",
      "beuss",
      "beung",
      "beuj",
      "beuc",
      "beuk",
      "beut",
      "beup",
      "beuh",
      "byi",
      "byig",
      "byigg",
      "byigs",
      "byin",
      "byinj",
      "byinh",
      "byid",
      "byil",
      "byilg",
      "byilm",
      "byilb",
      "byils",
      "byilt",
      "byilp",
      "byilh",
      "byim",
      "byib",
      "byibs",
      "byis",
      "byiss",
      "bying",
      "byij",
      "byic",
      "byik",
      "byit",
      "byip",
      "byih",
      "bi",
      "big",
      "bigg",
      "bigs",
      "bin",
      "binj",
      "binh",
      "bid",
      "bil",
      "bilg",
      "bilm",
      "bilb",
      "bils",
      "bilt",
      "bilp",
      "bilh",
      "bim",
      "bib",
      "bibs",
      "bis",
      "biss",
      "bing",
      "bij",
      "bic",
      "bik",
      "bit",
      "bip",
      "bih",
      "bba",
      "bbag",
      "bbagg",
      "bbags",
      "bban",
      "bbanj",
      "bbanh",
      "bbad",
      "bbal",
      "bbalg",
      "bbalm",
      "bbalb",
      "bbals",
      "bbalt",
      "bbalp",
      "bbalh",
      "bbam",
      "bbab",
      "bbabs",
      "bbas",
      "bbass",
      "bbang",
      "bbaj",
      "bbac",
      "bbak",
      "bbat",
      "bbap",
      "bbah",
      "bbae",
      "bbaeg",
      "bbaegg",
      "bbaegs",
      "bbaen",
      "bbaenj",
      "bbaenh",
      "bbaed",
      "bbael",
      "bbaelg",
      "bbaelm",
      "bbaelb",
      "bbaels",
      "bbaelt",
      "bbaelp",
      "bbaelh",
      "bbaem",
      "bbaeb",
      "bbaebs",
      "bbaes",
      "bbaess",
      "bbaeng",
      "bbaej",
      "bbaec",
      "bbaek",
      "bbaet",
      "bbaep",
      "bbaeh",
      "bbya",
      "bbyag",
      "bbyagg",
      "bbyags",
      "bbyan",
      "bbyanj",
      "bbyanh",
      "bbyad",
      "bbyal",
      "bbyalg",
      "bbyalm",
      "bbyalb",
      "bbyals",
      "bbyalt",
      "bbyalp",
      "bbyalh",
      "bbyam",
      "bbyab",
      "bbyabs",
      "bbyas",
      "bbyass",
      "bbyang",
      "bbyaj",
      "bbyac",
      "bbyak",
      "bbyat",
      "bbyap",
      "bbyah",
      "bbyae",
      "bbyaeg",
      "bbyaegg",
      "bbyaegs",
      "bbyaen",
      "bbyaenj",
      "bbyaenh",
      "bbyaed",
      "bbyael",
      "bbyaelg",
      "bbyaelm",
      "bbyaelb",
      "bbyaels",
      "bbyaelt",
      "bbyaelp",
      "bbyaelh",
      "bbyaem",
      "bbyaeb",
      "bbyaebs",
      "bbyaes",
      "bbyaess",
      "bbyaeng",
      "bbyaej",
      "bbyaec",
      "bbyaek",
      "bbyaet",
      "bbyaep",
      "bbyaeh",
      "bbeo",
      "bbeog",
      "bbeogg",
      "bbeogs",
      "bbeon",
      "bbeonj",
      "bbeonh",
      "bbeod",
      "bbeol",
      "bbeolg",
      "bbeolm",
      "bbeolb",
      "bbeols",
      "bbeolt",
      "bbeolp",
      "bbeolh",
      "bbeom",
      "bbeob",
      "bbeobs",
      "bbeos",
      "bbeoss",
      "bbeong",
      "bbeoj",
      "bbeoc",
      "bbeok",
      "bbeot",
      "bbeop",
      "bbeoh",
      "bbe",
      "bbeg",
      "bbegg",
      "bbegs",
      "bben",
      "bbenj",
      "bbenh",
      "bbed",
      "bbel",
      "bbelg",
      "bbelm",
      "bbelb",
      "bbels",
      "bbelt",
      "bbelp",
      "bbelh",
      "bbem",
      "bbeb",
      "bbebs",
      "bbes"
    ];
  }
});

// node_modules/unidecode/data/xbf.js
var require_xbf = __commonJS({
  "node_modules/unidecode/data/xbf.js"(exports2, module2) {
    module2.exports = [
      "bbess",
      "bbeng",
      "bbej",
      "bbec",
      "bbek",
      "bbet",
      "bbep",
      "bbeh",
      "bbyeo",
      "bbyeog",
      "bbyeogg",
      "bbyeogs",
      "bbyeon",
      "bbyeonj",
      "bbyeonh",
      "bbyeod",
      "bbyeol",
      "bbyeolg",
      "bbyeolm",
      "bbyeolb",
      "bbyeols",
      "bbyeolt",
      "bbyeolp",
      "bbyeolh",
      "bbyeom",
      "bbyeob",
      "bbyeobs",
      "bbyeos",
      "bbyeoss",
      "bbyeong",
      "bbyeoj",
      "bbyeoc",
      "bbyeok",
      "bbyeot",
      "bbyeop",
      "bbyeoh",
      "bbye",
      "bbyeg",
      "bbyegg",
      "bbyegs",
      "bbyen",
      "bbyenj",
      "bbyenh",
      "bbyed",
      "bbyel",
      "bbyelg",
      "bbyelm",
      "bbyelb",
      "bbyels",
      "bbyelt",
      "bbyelp",
      "bbyelh",
      "bbyem",
      "bbyeb",
      "bbyebs",
      "bbyes",
      "bbyess",
      "bbyeng",
      "bbyej",
      "bbyec",
      "bbyek",
      "bbyet",
      "bbyep",
      "bbyeh",
      "bbo",
      "bbog",
      "bbogg",
      "bbogs",
      "bbon",
      "bbonj",
      "bbonh",
      "bbod",
      "bbol",
      "bbolg",
      "bbolm",
      "bbolb",
      "bbols",
      "bbolt",
      "bbolp",
      "bbolh",
      "bbom",
      "bbob",
      "bbobs",
      "bbos",
      "bboss",
      "bbong",
      "bboj",
      "bboc",
      "bbok",
      "bbot",
      "bbop",
      "bboh",
      "bbwa",
      "bbwag",
      "bbwagg",
      "bbwags",
      "bbwan",
      "bbwanj",
      "bbwanh",
      "bbwad",
      "bbwal",
      "bbwalg",
      "bbwalm",
      "bbwalb",
      "bbwals",
      "bbwalt",
      "bbwalp",
      "bbwalh",
      "bbwam",
      "bbwab",
      "bbwabs",
      "bbwas",
      "bbwass",
      "bbwang",
      "bbwaj",
      "bbwac",
      "bbwak",
      "bbwat",
      "bbwap",
      "bbwah",
      "bbwae",
      "bbwaeg",
      "bbwaegg",
      "bbwaegs",
      "bbwaen",
      "bbwaenj",
      "bbwaenh",
      "bbwaed",
      "bbwael",
      "bbwaelg",
      "bbwaelm",
      "bbwaelb",
      "bbwaels",
      "bbwaelt",
      "bbwaelp",
      "bbwaelh",
      "bbwaem",
      "bbwaeb",
      "bbwaebs",
      "bbwaes",
      "bbwaess",
      "bbwaeng",
      "bbwaej",
      "bbwaec",
      "bbwaek",
      "bbwaet",
      "bbwaep",
      "bbwaeh",
      "bboe",
      "bboeg",
      "bboegg",
      "bboegs",
      "bboen",
      "bboenj",
      "bboenh",
      "bboed",
      "bboel",
      "bboelg",
      "bboelm",
      "bboelb",
      "bboels",
      "bboelt",
      "bboelp",
      "bboelh",
      "bboem",
      "bboeb",
      "bboebs",
      "bboes",
      "bboess",
      "bboeng",
      "bboej",
      "bboec",
      "bboek",
      "bboet",
      "bboep",
      "bboeh",
      "bbyo",
      "bbyog",
      "bbyogg",
      "bbyogs",
      "bbyon",
      "bbyonj",
      "bbyonh",
      "bbyod",
      "bbyol",
      "bbyolg",
      "bbyolm",
      "bbyolb",
      "bbyols",
      "bbyolt",
      "bbyolp",
      "bbyolh",
      "bbyom",
      "bbyob",
      "bbyobs",
      "bbyos",
      "bbyoss",
      "bbyong",
      "bbyoj",
      "bbyoc",
      "bbyok",
      "bbyot",
      "bbyop",
      "bbyoh",
      "bbu",
      "bbug",
      "bbugg",
      "bbugs",
      "bbun",
      "bbunj",
      "bbunh",
      "bbud",
      "bbul",
      "bbulg",
      "bbulm",
      "bbulb",
      "bbuls",
      "bbult",
      "bbulp",
      "bbulh",
      "bbum",
      "bbub",
      "bbubs",
      "bbus",
      "bbuss",
      "bbung",
      "bbuj",
      "bbuc",
      "bbuk",
      "bbut",
      "bbup",
      "bbuh",
      "bbweo",
      "bbweog",
      "bbweogg",
      "bbweogs",
      "bbweon",
      "bbweonj",
      "bbweonh",
      "bbweod",
      "bbweol",
      "bbweolg",
      "bbweolm",
      "bbweolb",
      "bbweols",
      "bbweolt",
      "bbweolp",
      "bbweolh",
      "bbweom",
      "bbweob",
      "bbweobs",
      "bbweos",
      "bbweoss",
      "bbweong",
      "bbweoj",
      "bbweoc"
    ];
  }
});

// node_modules/unidecode/data/xc0.js
var require_xc0 = __commonJS({
  "node_modules/unidecode/data/xc0.js"(exports2, module2) {
    module2.exports = [
      "bbweok",
      "bbweot",
      "bbweop",
      "bbweoh",
      "bbwe",
      "bbweg",
      "bbwegg",
      "bbwegs",
      "bbwen",
      "bbwenj",
      "bbwenh",
      "bbwed",
      "bbwel",
      "bbwelg",
      "bbwelm",
      "bbwelb",
      "bbwels",
      "bbwelt",
      "bbwelp",
      "bbwelh",
      "bbwem",
      "bbweb",
      "bbwebs",
      "bbwes",
      "bbwess",
      "bbweng",
      "bbwej",
      "bbwec",
      "bbwek",
      "bbwet",
      "bbwep",
      "bbweh",
      "bbwi",
      "bbwig",
      "bbwigg",
      "bbwigs",
      "bbwin",
      "bbwinj",
      "bbwinh",
      "bbwid",
      "bbwil",
      "bbwilg",
      "bbwilm",
      "bbwilb",
      "bbwils",
      "bbwilt",
      "bbwilp",
      "bbwilh",
      "bbwim",
      "bbwib",
      "bbwibs",
      "bbwis",
      "bbwiss",
      "bbwing",
      "bbwij",
      "bbwic",
      "bbwik",
      "bbwit",
      "bbwip",
      "bbwih",
      "bbyu",
      "bbyug",
      "bbyugg",
      "bbyugs",
      "bbyun",
      "bbyunj",
      "bbyunh",
      "bbyud",
      "bbyul",
      "bbyulg",
      "bbyulm",
      "bbyulb",
      "bbyuls",
      "bbyult",
      "bbyulp",
      "bbyulh",
      "bbyum",
      "bbyub",
      "bbyubs",
      "bbyus",
      "bbyuss",
      "bbyung",
      "bbyuj",
      "bbyuc",
      "bbyuk",
      "bbyut",
      "bbyup",
      "bbyuh",
      "bbeu",
      "bbeug",
      "bbeugg",
      "bbeugs",
      "bbeun",
      "bbeunj",
      "bbeunh",
      "bbeud",
      "bbeul",
      "bbeulg",
      "bbeulm",
      "bbeulb",
      "bbeuls",
      "bbeult",
      "bbeulp",
      "bbeulh",
      "bbeum",
      "bbeub",
      "bbeubs",
      "bbeus",
      "bbeuss",
      "bbeung",
      "bbeuj",
      "bbeuc",
      "bbeuk",
      "bbeut",
      "bbeup",
      "bbeuh",
      "bbyi",
      "bbyig",
      "bbyigg",
      "bbyigs",
      "bbyin",
      "bbyinj",
      "bbyinh",
      "bbyid",
      "bbyil",
      "bbyilg",
      "bbyilm",
      "bbyilb",
      "bbyils",
      "bbyilt",
      "bbyilp",
      "bbyilh",
      "bbyim",
      "bbyib",
      "bbyibs",
      "bbyis",
      "bbyiss",
      "bbying",
      "bbyij",
      "bbyic",
      "bbyik",
      "bbyit",
      "bbyip",
      "bbyih",
      "bbi",
      "bbig",
      "bbigg",
      "bbigs",
      "bbin",
      "bbinj",
      "bbinh",
      "bbid",
      "bbil",
      "bbilg",
      "bbilm",
      "bbilb",
      "bbils",
      "bbilt",
      "bbilp",
      "bbilh",
      "bbim",
      "bbib",
      "bbibs",
      "bbis",
      "bbiss",
      "bbing",
      "bbij",
      "bbic",
      "bbik",
      "bbit",
      "bbip",
      "bbih",
      "sa",
      "sag",
      "sagg",
      "sags",
      "san",
      "sanj",
      "sanh",
      "sad",
      "sal",
      "salg",
      "salm",
      "salb",
      "sals",
      "salt",
      "salp",
      "salh",
      "sam",
      "sab",
      "sabs",
      "sas",
      "sass",
      "sang",
      "saj",
      "sac",
      "sak",
      "sat",
      "sap",
      "sah",
      "sae",
      "saeg",
      "saegg",
      "saegs",
      "saen",
      "saenj",
      "saenh",
      "saed",
      "sael",
      "saelg",
      "saelm",
      "saelb",
      "saels",
      "saelt",
      "saelp",
      "saelh",
      "saem",
      "saeb",
      "saebs",
      "saes",
      "saess",
      "saeng",
      "saej",
      "saec",
      "saek",
      "saet",
      "saep",
      "saeh",
      "sya",
      "syag",
      "syagg",
      "syags",
      "syan",
      "syanj",
      "syanh",
      "syad",
      "syal",
      "syalg",
      "syalm",
      "syalb",
      "syals",
      "syalt",
      "syalp",
      "syalh",
      "syam",
      "syab",
      "syabs",
      "syas",
      "syass",
      "syang",
      "syaj",
      "syac",
      "syak",
      "syat",
      "syap",
      "syah"
    ];
  }
});

// node_modules/unidecode/data/xc1.js
var require_xc1 = __commonJS({
  "node_modules/unidecode/data/xc1.js"(exports2, module2) {
    module2.exports = [
      "syae",
      "syaeg",
      "syaegg",
      "syaegs",
      "syaen",
      "syaenj",
      "syaenh",
      "syaed",
      "syael",
      "syaelg",
      "syaelm",
      "syaelb",
      "syaels",
      "syaelt",
      "syaelp",
      "syaelh",
      "syaem",
      "syaeb",
      "syaebs",
      "syaes",
      "syaess",
      "syaeng",
      "syaej",
      "syaec",
      "syaek",
      "syaet",
      "syaep",
      "syaeh",
      "seo",
      "seog",
      "seogg",
      "seogs",
      "seon",
      "seonj",
      "seonh",
      "seod",
      "seol",
      "seolg",
      "seolm",
      "seolb",
      "seols",
      "seolt",
      "seolp",
      "seolh",
      "seom",
      "seob",
      "seobs",
      "seos",
      "seoss",
      "seong",
      "seoj",
      "seoc",
      "seok",
      "seot",
      "seop",
      "seoh",
      "se",
      "seg",
      "segg",
      "segs",
      "sen",
      "senj",
      "senh",
      "sed",
      "sel",
      "selg",
      "selm",
      "selb",
      "sels",
      "selt",
      "selp",
      "selh",
      "sem",
      "seb",
      "sebs",
      "ses",
      "sess",
      "seng",
      "sej",
      "sec",
      "sek",
      "set",
      "sep",
      "seh",
      "syeo",
      "syeog",
      "syeogg",
      "syeogs",
      "syeon",
      "syeonj",
      "syeonh",
      "syeod",
      "syeol",
      "syeolg",
      "syeolm",
      "syeolb",
      "syeols",
      "syeolt",
      "syeolp",
      "syeolh",
      "syeom",
      "syeob",
      "syeobs",
      "syeos",
      "syeoss",
      "syeong",
      "syeoj",
      "syeoc",
      "syeok",
      "syeot",
      "syeop",
      "syeoh",
      "sye",
      "syeg",
      "syegg",
      "syegs",
      "syen",
      "syenj",
      "syenh",
      "syed",
      "syel",
      "syelg",
      "syelm",
      "syelb",
      "syels",
      "syelt",
      "syelp",
      "syelh",
      "syem",
      "syeb",
      "syebs",
      "syes",
      "syess",
      "syeng",
      "syej",
      "syec",
      "syek",
      "syet",
      "syep",
      "syeh",
      "so",
      "sog",
      "sogg",
      "sogs",
      "son",
      "sonj",
      "sonh",
      "sod",
      "sol",
      "solg",
      "solm",
      "solb",
      "sols",
      "solt",
      "solp",
      "solh",
      "som",
      "sob",
      "sobs",
      "sos",
      "soss",
      "song",
      "soj",
      "soc",
      "sok",
      "sot",
      "sop",
      "soh",
      "swa",
      "swag",
      "swagg",
      "swags",
      "swan",
      "swanj",
      "swanh",
      "swad",
      "swal",
      "swalg",
      "swalm",
      "swalb",
      "swals",
      "swalt",
      "swalp",
      "swalh",
      "swam",
      "swab",
      "swabs",
      "swas",
      "swass",
      "swang",
      "swaj",
      "swac",
      "swak",
      "swat",
      "swap",
      "swah",
      "swae",
      "swaeg",
      "swaegg",
      "swaegs",
      "swaen",
      "swaenj",
      "swaenh",
      "swaed",
      "swael",
      "swaelg",
      "swaelm",
      "swaelb",
      "swaels",
      "swaelt",
      "swaelp",
      "swaelh",
      "swaem",
      "swaeb",
      "swaebs",
      "swaes",
      "swaess",
      "swaeng",
      "swaej",
      "swaec",
      "swaek",
      "swaet",
      "swaep",
      "swaeh",
      "soe",
      "soeg",
      "soegg",
      "soegs",
      "soen",
      "soenj",
      "soenh",
      "soed",
      "soel",
      "soelg",
      "soelm",
      "soelb",
      "soels",
      "soelt",
      "soelp",
      "soelh",
      "soem",
      "soeb",
      "soebs",
      "soes",
      "soess",
      "soeng",
      "soej",
      "soec",
      "soek",
      "soet",
      "soep",
      "soeh",
      "syo",
      "syog",
      "syogg",
      "syogs"
    ];
  }
});

// node_modules/unidecode/data/xc2.js
var require_xc2 = __commonJS({
  "node_modules/unidecode/data/xc2.js"(exports2, module2) {
    module2.exports = [
      "syon",
      "syonj",
      "syonh",
      "syod",
      "syol",
      "syolg",
      "syolm",
      "syolb",
      "syols",
      "syolt",
      "syolp",
      "syolh",
      "syom",
      "syob",
      "syobs",
      "syos",
      "syoss",
      "syong",
      "syoj",
      "syoc",
      "syok",
      "syot",
      "syop",
      "syoh",
      "su",
      "sug",
      "sugg",
      "sugs",
      "sun",
      "sunj",
      "sunh",
      "sud",
      "sul",
      "sulg",
      "sulm",
      "sulb",
      "suls",
      "sult",
      "sulp",
      "sulh",
      "sum",
      "sub",
      "subs",
      "sus",
      "suss",
      "sung",
      "suj",
      "suc",
      "suk",
      "sut",
      "sup",
      "suh",
      "sweo",
      "sweog",
      "sweogg",
      "sweogs",
      "sweon",
      "sweonj",
      "sweonh",
      "sweod",
      "sweol",
      "sweolg",
      "sweolm",
      "sweolb",
      "sweols",
      "sweolt",
      "sweolp",
      "sweolh",
      "sweom",
      "sweob",
      "sweobs",
      "sweos",
      "sweoss",
      "sweong",
      "sweoj",
      "sweoc",
      "sweok",
      "sweot",
      "sweop",
      "sweoh",
      "swe",
      "sweg",
      "swegg",
      "swegs",
      "swen",
      "swenj",
      "swenh",
      "swed",
      "swel",
      "swelg",
      "swelm",
      "swelb",
      "swels",
      "swelt",
      "swelp",
      "swelh",
      "swem",
      "sweb",
      "swebs",
      "swes",
      "swess",
      "sweng",
      "swej",
      "swec",
      "swek",
      "swet",
      "swep",
      "sweh",
      "swi",
      "swig",
      "swigg",
      "swigs",
      "swin",
      "swinj",
      "swinh",
      "swid",
      "swil",
      "swilg",
      "swilm",
      "swilb",
      "swils",
      "swilt",
      "swilp",
      "swilh",
      "swim",
      "swib",
      "swibs",
      "swis",
      "swiss",
      "swing",
      "swij",
      "swic",
      "swik",
      "swit",
      "swip",
      "swih",
      "syu",
      "syug",
      "syugg",
      "syugs",
      "syun",
      "syunj",
      "syunh",
      "syud",
      "syul",
      "syulg",
      "syulm",
      "syulb",
      "syuls",
      "syult",
      "syulp",
      "syulh",
      "syum",
      "syub",
      "syubs",
      "syus",
      "syuss",
      "syung",
      "syuj",
      "syuc",
      "syuk",
      "syut",
      "syup",
      "syuh",
      "seu",
      "seug",
      "seugg",
      "seugs",
      "seun",
      "seunj",
      "seunh",
      "seud",
      "seul",
      "seulg",
      "seulm",
      "seulb",
      "seuls",
      "seult",
      "seulp",
      "seulh",
      "seum",
      "seub",
      "seubs",
      "seus",
      "seuss",
      "seung",
      "seuj",
      "seuc",
      "seuk",
      "seut",
      "seup",
      "seuh",
      "syi",
      "syig",
      "syigg",
      "syigs",
      "syin",
      "syinj",
      "syinh",
      "syid",
      "syil",
      "syilg",
      "syilm",
      "syilb",
      "syils",
      "syilt",
      "syilp",
      "syilh",
      "syim",
      "syib",
      "syibs",
      "syis",
      "syiss",
      "sying",
      "syij",
      "syic",
      "syik",
      "syit",
      "syip",
      "syih",
      "si",
      "sig",
      "sigg",
      "sigs",
      "sin",
      "sinj",
      "sinh",
      "sid",
      "sil",
      "silg",
      "silm",
      "silb",
      "sils",
      "silt",
      "silp",
      "silh",
      "sim",
      "sib",
      "sibs",
      "sis",
      "siss",
      "sing",
      "sij",
      "sic",
      "sik",
      "sit",
      "sip",
      "sih",
      "ssa",
      "ssag",
      "ssagg",
      "ssags",
      "ssan",
      "ssanj",
      "ssanh",
      "ssad"
    ];
  }
});

// node_modules/unidecode/data/xc3.js
var require_xc3 = __commonJS({
  "node_modules/unidecode/data/xc3.js"(exports2, module2) {
    module2.exports = [
      "ssal",
      "ssalg",
      "ssalm",
      "ssalb",
      "ssals",
      "ssalt",
      "ssalp",
      "ssalh",
      "ssam",
      "ssab",
      "ssabs",
      "ssas",
      "ssass",
      "ssang",
      "ssaj",
      "ssac",
      "ssak",
      "ssat",
      "ssap",
      "ssah",
      "ssae",
      "ssaeg",
      "ssaegg",
      "ssaegs",
      "ssaen",
      "ssaenj",
      "ssaenh",
      "ssaed",
      "ssael",
      "ssaelg",
      "ssaelm",
      "ssaelb",
      "ssaels",
      "ssaelt",
      "ssaelp",
      "ssaelh",
      "ssaem",
      "ssaeb",
      "ssaebs",
      "ssaes",
      "ssaess",
      "ssaeng",
      "ssaej",
      "ssaec",
      "ssaek",
      "ssaet",
      "ssaep",
      "ssaeh",
      "ssya",
      "ssyag",
      "ssyagg",
      "ssyags",
      "ssyan",
      "ssyanj",
      "ssyanh",
      "ssyad",
      "ssyal",
      "ssyalg",
      "ssyalm",
      "ssyalb",
      "ssyals",
      "ssyalt",
      "ssyalp",
      "ssyalh",
      "ssyam",
      "ssyab",
      "ssyabs",
      "ssyas",
      "ssyass",
      "ssyang",
      "ssyaj",
      "ssyac",
      "ssyak",
      "ssyat",
      "ssyap",
      "ssyah",
      "ssyae",
      "ssyaeg",
      "ssyaegg",
      "ssyaegs",
      "ssyaen",
      "ssyaenj",
      "ssyaenh",
      "ssyaed",
      "ssyael",
      "ssyaelg",
      "ssyaelm",
      "ssyaelb",
      "ssyaels",
      "ssyaelt",
      "ssyaelp",
      "ssyaelh",
      "ssyaem",
      "ssyaeb",
      "ssyaebs",
      "ssyaes",
      "ssyaess",
      "ssyaeng",
      "ssyaej",
      "ssyaec",
      "ssyaek",
      "ssyaet",
      "ssyaep",
      "ssyaeh",
      "sseo",
      "sseog",
      "sseogg",
      "sseogs",
      "sseon",
      "sseonj",
      "sseonh",
      "sseod",
      "sseol",
      "sseolg",
      "sseolm",
      "sseolb",
      "sseols",
      "sseolt",
      "sseolp",
      "sseolh",
      "sseom",
      "sseob",
      "sseobs",
      "sseos",
      "sseoss",
      "sseong",
      "sseoj",
      "sseoc",
      "sseok",
      "sseot",
      "sseop",
      "sseoh",
      "sse",
      "sseg",
      "ssegg",
      "ssegs",
      "ssen",
      "ssenj",
      "ssenh",
      "ssed",
      "ssel",
      "sselg",
      "sselm",
      "sselb",
      "ssels",
      "sselt",
      "sselp",
      "sselh",
      "ssem",
      "sseb",
      "ssebs",
      "sses",
      "ssess",
      "sseng",
      "ssej",
      "ssec",
      "ssek",
      "sset",
      "ssep",
      "sseh",
      "ssyeo",
      "ssyeog",
      "ssyeogg",
      "ssyeogs",
      "ssyeon",
      "ssyeonj",
      "ssyeonh",
      "ssyeod",
      "ssyeol",
      "ssyeolg",
      "ssyeolm",
      "ssyeolb",
      "ssyeols",
      "ssyeolt",
      "ssyeolp",
      "ssyeolh",
      "ssyeom",
      "ssyeob",
      "ssyeobs",
      "ssyeos",
      "ssyeoss",
      "ssyeong",
      "ssyeoj",
      "ssyeoc",
      "ssyeok",
      "ssyeot",
      "ssyeop",
      "ssyeoh",
      "ssye",
      "ssyeg",
      "ssyegg",
      "ssyegs",
      "ssyen",
      "ssyenj",
      "ssyenh",
      "ssyed",
      "ssyel",
      "ssyelg",
      "ssyelm",
      "ssyelb",
      "ssyels",
      "ssyelt",
      "ssyelp",
      "ssyelh",
      "ssyem",
      "ssyeb",
      "ssyebs",
      "ssyes",
      "ssyess",
      "ssyeng",
      "ssyej",
      "ssyec",
      "ssyek",
      "ssyet",
      "ssyep",
      "ssyeh",
      "sso",
      "ssog",
      "ssogg",
      "ssogs",
      "sson",
      "ssonj",
      "ssonh",
      "ssod",
      "ssol",
      "ssolg",
      "ssolm",
      "ssolb",
      "ssols",
      "ssolt",
      "ssolp",
      "ssolh",
      "ssom",
      "ssob",
      "ssobs",
      "ssos",
      "ssoss",
      "ssong",
      "ssoj",
      "ssoc",
      "ssok",
      "ssot",
      "ssop",
      "ssoh",
      "sswa",
      "sswag",
      "sswagg",
      "sswags",
      "sswan",
      "sswanj",
      "sswanh",
      "sswad",
      "sswal",
      "sswalg",
      "sswalm",
      "sswalb"
    ];
  }
});

// node_modules/unidecode/data/xc4.js
var require_xc4 = __commonJS({
  "node_modules/unidecode/data/xc4.js"(exports2, module2) {
    module2.exports = [
      "sswals",
      "sswalt",
      "sswalp",
      "sswalh",
      "sswam",
      "sswab",
      "sswabs",
      "sswas",
      "sswass",
      "sswang",
      "sswaj",
      "sswac",
      "sswak",
      "sswat",
      "sswap",
      "sswah",
      "sswae",
      "sswaeg",
      "sswaegg",
      "sswaegs",
      "sswaen",
      "sswaenj",
      "sswaenh",
      "sswaed",
      "sswael",
      "sswaelg",
      "sswaelm",
      "sswaelb",
      "sswaels",
      "sswaelt",
      "sswaelp",
      "sswaelh",
      "sswaem",
      "sswaeb",
      "sswaebs",
      "sswaes",
      "sswaess",
      "sswaeng",
      "sswaej",
      "sswaec",
      "sswaek",
      "sswaet",
      "sswaep",
      "sswaeh",
      "ssoe",
      "ssoeg",
      "ssoegg",
      "ssoegs",
      "ssoen",
      "ssoenj",
      "ssoenh",
      "ssoed",
      "ssoel",
      "ssoelg",
      "ssoelm",
      "ssoelb",
      "ssoels",
      "ssoelt",
      "ssoelp",
      "ssoelh",
      "ssoem",
      "ssoeb",
      "ssoebs",
      "ssoes",
      "ssoess",
      "ssoeng",
      "ssoej",
      "ssoec",
      "ssoek",
      "ssoet",
      "ssoep",
      "ssoeh",
      "ssyo",
      "ssyog",
      "ssyogg",
      "ssyogs",
      "ssyon",
      "ssyonj",
      "ssyonh",
      "ssyod",
      "ssyol",
      "ssyolg",
      "ssyolm",
      "ssyolb",
      "ssyols",
      "ssyolt",
      "ssyolp",
      "ssyolh",
      "ssyom",
      "ssyob",
      "ssyobs",
      "ssyos",
      "ssyoss",
      "ssyong",
      "ssyoj",
      "ssyoc",
      "ssyok",
      "ssyot",
      "ssyop",
      "ssyoh",
      "ssu",
      "ssug",
      "ssugg",
      "ssugs",
      "ssun",
      "ssunj",
      "ssunh",
      "ssud",
      "ssul",
      "ssulg",
      "ssulm",
      "ssulb",
      "ssuls",
      "ssult",
      "ssulp",
      "ssulh",
      "ssum",
      "ssub",
      "ssubs",
      "ssus",
      "ssuss",
      "ssung",
      "ssuj",
      "ssuc",
      "ssuk",
      "ssut",
      "ssup",
      "ssuh",
      "ssweo",
      "ssweog",
      "ssweogg",
      "ssweogs",
      "ssweon",
      "ssweonj",
      "ssweonh",
      "ssweod",
      "ssweol",
      "ssweolg",
      "ssweolm",
      "ssweolb",
      "ssweols",
      "ssweolt",
      "ssweolp",
      "ssweolh",
      "ssweom",
      "ssweob",
      "ssweobs",
      "ssweos",
      "ssweoss",
      "ssweong",
      "ssweoj",
      "ssweoc",
      "ssweok",
      "ssweot",
      "ssweop",
      "ssweoh",
      "sswe",
      "ssweg",
      "sswegg",
      "sswegs",
      "sswen",
      "sswenj",
      "sswenh",
      "sswed",
      "sswel",
      "sswelg",
      "sswelm",
      "sswelb",
      "sswels",
      "sswelt",
      "sswelp",
      "sswelh",
      "sswem",
      "ssweb",
      "sswebs",
      "sswes",
      "sswess",
      "ssweng",
      "sswej",
      "sswec",
      "sswek",
      "sswet",
      "sswep",
      "ssweh",
      "sswi",
      "sswig",
      "sswigg",
      "sswigs",
      "sswin",
      "sswinj",
      "sswinh",
      "sswid",
      "sswil",
      "sswilg",
      "sswilm",
      "sswilb",
      "sswils",
      "sswilt",
      "sswilp",
      "sswilh",
      "sswim",
      "sswib",
      "sswibs",
      "sswis",
      "sswiss",
      "sswing",
      "sswij",
      "sswic",
      "sswik",
      "sswit",
      "sswip",
      "sswih",
      "ssyu",
      "ssyug",
      "ssyugg",
      "ssyugs",
      "ssyun",
      "ssyunj",
      "ssyunh",
      "ssyud",
      "ssyul",
      "ssyulg",
      "ssyulm",
      "ssyulb",
      "ssyuls",
      "ssyult",
      "ssyulp",
      "ssyulh",
      "ssyum",
      "ssyub",
      "ssyubs",
      "ssyus",
      "ssyuss",
      "ssyung",
      "ssyuj",
      "ssyuc",
      "ssyuk",
      "ssyut",
      "ssyup",
      "ssyuh",
      "sseu",
      "sseug",
      "sseugg",
      "sseugs",
      "sseun",
      "sseunj",
      "sseunh",
      "sseud",
      "sseul",
      "sseulg",
      "sseulm",
      "sseulb",
      "sseuls",
      "sseult",
      "sseulp",
      "sseulh"
    ];
  }
});

// node_modules/unidecode/data/xc5.js
var require_xc5 = __commonJS({
  "node_modules/unidecode/data/xc5.js"(exports2, module2) {
    module2.exports = [
      "sseum",
      "sseub",
      "sseubs",
      "sseus",
      "sseuss",
      "sseung",
      "sseuj",
      "sseuc",
      "sseuk",
      "sseut",
      "sseup",
      "sseuh",
      "ssyi",
      "ssyig",
      "ssyigg",
      "ssyigs",
      "ssyin",
      "ssyinj",
      "ssyinh",
      "ssyid",
      "ssyil",
      "ssyilg",
      "ssyilm",
      "ssyilb",
      "ssyils",
      "ssyilt",
      "ssyilp",
      "ssyilh",
      "ssyim",
      "ssyib",
      "ssyibs",
      "ssyis",
      "ssyiss",
      "ssying",
      "ssyij",
      "ssyic",
      "ssyik",
      "ssyit",
      "ssyip",
      "ssyih",
      "ssi",
      "ssig",
      "ssigg",
      "ssigs",
      "ssin",
      "ssinj",
      "ssinh",
      "ssid",
      "ssil",
      "ssilg",
      "ssilm",
      "ssilb",
      "ssils",
      "ssilt",
      "ssilp",
      "ssilh",
      "ssim",
      "ssib",
      "ssibs",
      "ssis",
      "ssiss",
      "ssing",
      "ssij",
      "ssic",
      "ssik",
      "ssit",
      "ssip",
      "ssih",
      "a",
      "ag",
      "agg",
      "ags",
      "an",
      "anj",
      "anh",
      "ad",
      "al",
      "alg",
      "alm",
      "alb",
      "als",
      "alt",
      "alp",
      "alh",
      "am",
      "ab",
      "abs",
      "as",
      "ass",
      "ang",
      "aj",
      "ac",
      "ak",
      "at",
      "ap",
      "ah",
      "ae",
      "aeg",
      "aegg",
      "aegs",
      "aen",
      "aenj",
      "aenh",
      "aed",
      "ael",
      "aelg",
      "aelm",
      "aelb",
      "aels",
      "aelt",
      "aelp",
      "aelh",
      "aem",
      "aeb",
      "aebs",
      "aes",
      "aess",
      "aeng",
      "aej",
      "aec",
      "aek",
      "aet",
      "aep",
      "aeh",
      "ya",
      "yag",
      "yagg",
      "yags",
      "yan",
      "yanj",
      "yanh",
      "yad",
      "yal",
      "yalg",
      "yalm",
      "yalb",
      "yals",
      "yalt",
      "yalp",
      "yalh",
      "yam",
      "yab",
      "yabs",
      "yas",
      "yass",
      "yang",
      "yaj",
      "yac",
      "yak",
      "yat",
      "yap",
      "yah",
      "yae",
      "yaeg",
      "yaegg",
      "yaegs",
      "yaen",
      "yaenj",
      "yaenh",
      "yaed",
      "yael",
      "yaelg",
      "yaelm",
      "yaelb",
      "yaels",
      "yaelt",
      "yaelp",
      "yaelh",
      "yaem",
      "yaeb",
      "yaebs",
      "yaes",
      "yaess",
      "yaeng",
      "yaej",
      "yaec",
      "yaek",
      "yaet",
      "yaep",
      "yaeh",
      "eo",
      "eog",
      "eogg",
      "eogs",
      "eon",
      "eonj",
      "eonh",
      "eod",
      "eol",
      "eolg",
      "eolm",
      "eolb",
      "eols",
      "eolt",
      "eolp",
      "eolh",
      "eom",
      "eob",
      "eobs",
      "eos",
      "eoss",
      "eong",
      "eoj",
      "eoc",
      "eok",
      "eot",
      "eop",
      "eoh",
      "e",
      "eg",
      "egg",
      "egs",
      "en",
      "enj",
      "enh",
      "ed",
      "el",
      "elg",
      "elm",
      "elb",
      "els",
      "elt",
      "elp",
      "elh",
      "em",
      "eb",
      "ebs",
      "es",
      "ess",
      "eng",
      "ej",
      "ec",
      "ek",
      "et",
      "ep",
      "eh",
      "yeo",
      "yeog",
      "yeogg",
      "yeogs",
      "yeon",
      "yeonj",
      "yeonh",
      "yeod",
      "yeol",
      "yeolg",
      "yeolm",
      "yeolb",
      "yeols",
      "yeolt",
      "yeolp",
      "yeolh",
      "yeom",
      "yeob",
      "yeobs",
      "yeos"
    ];
  }
});

// node_modules/unidecode/data/xc6.js
var require_xc6 = __commonJS({
  "node_modules/unidecode/data/xc6.js"(exports2, module2) {
    module2.exports = [
      "yeoss",
      "yeong",
      "yeoj",
      "yeoc",
      "yeok",
      "yeot",
      "yeop",
      "yeoh",
      "ye",
      "yeg",
      "yegg",
      "yegs",
      "yen",
      "yenj",
      "yenh",
      "yed",
      "yel",
      "yelg",
      "yelm",
      "yelb",
      "yels",
      "yelt",
      "yelp",
      "yelh",
      "yem",
      "yeb",
      "yebs",
      "yes",
      "yess",
      "yeng",
      "yej",
      "yec",
      "yek",
      "yet",
      "yep",
      "yeh",
      "o",
      "og",
      "ogg",
      "ogs",
      "on",
      "onj",
      "onh",
      "od",
      "ol",
      "olg",
      "olm",
      "olb",
      "ols",
      "olt",
      "olp",
      "olh",
      "om",
      "ob",
      "obs",
      "os",
      "oss",
      "ong",
      "oj",
      "oc",
      "ok",
      "ot",
      "op",
      "oh",
      "wa",
      "wag",
      "wagg",
      "wags",
      "wan",
      "wanj",
      "wanh",
      "wad",
      "wal",
      "walg",
      "walm",
      "walb",
      "wals",
      "walt",
      "walp",
      "walh",
      "wam",
      "wab",
      "wabs",
      "was",
      "wass",
      "wang",
      "waj",
      "wac",
      "wak",
      "wat",
      "wap",
      "wah",
      "wae",
      "waeg",
      "waegg",
      "waegs",
      "waen",
      "waenj",
      "waenh",
      "waed",
      "wael",
      "waelg",
      "waelm",
      "waelb",
      "waels",
      "waelt",
      "waelp",
      "waelh",
      "waem",
      "waeb",
      "waebs",
      "waes",
      "waess",
      "waeng",
      "waej",
      "waec",
      "waek",
      "waet",
      "waep",
      "waeh",
      "oe",
      "oeg",
      "oegg",
      "oegs",
      "oen",
      "oenj",
      "oenh",
      "oed",
      "oel",
      "oelg",
      "oelm",
      "oelb",
      "oels",
      "oelt",
      "oelp",
      "oelh",
      "oem",
      "oeb",
      "oebs",
      "oes",
      "oess",
      "oeng",
      "oej",
      "oec",
      "oek",
      "oet",
      "oep",
      "oeh",
      "yo",
      "yog",
      "yogg",
      "yogs",
      "yon",
      "yonj",
      "yonh",
      "yod",
      "yol",
      "yolg",
      "yolm",
      "yolb",
      "yols",
      "yolt",
      "yolp",
      "yolh",
      "yom",
      "yob",
      "yobs",
      "yos",
      "yoss",
      "yong",
      "yoj",
      "yoc",
      "yok",
      "yot",
      "yop",
      "yoh",
      "u",
      "ug",
      "ugg",
      "ugs",
      "un",
      "unj",
      "unh",
      "ud",
      "ul",
      "ulg",
      "ulm",
      "ulb",
      "uls",
      "ult",
      "ulp",
      "ulh",
      "um",
      "ub",
      "ubs",
      "us",
      "uss",
      "ung",
      "uj",
      "uc",
      "uk",
      "ut",
      "up",
      "uh",
      "weo",
      "weog",
      "weogg",
      "weogs",
      "weon",
      "weonj",
      "weonh",
      "weod",
      "weol",
      "weolg",
      "weolm",
      "weolb",
      "weols",
      "weolt",
      "weolp",
      "weolh",
      "weom",
      "weob",
      "weobs",
      "weos",
      "weoss",
      "weong",
      "weoj",
      "weoc",
      "weok",
      "weot",
      "weop",
      "weoh",
      "we",
      "weg",
      "wegg",
      "wegs",
      "wen",
      "wenj",
      "wenh",
      "wed",
      "wel",
      "welg",
      "welm",
      "welb",
      "wels",
      "welt",
      "welp",
      "welh",
      "wem",
      "web",
      "webs",
      "wes",
      "wess",
      "weng",
      "wej",
      "wec"
    ];
  }
});

// node_modules/unidecode/data/xc7.js
var require_xc7 = __commonJS({
  "node_modules/unidecode/data/xc7.js"(exports2, module2) {
    module2.exports = [
      "wek",
      "wet",
      "wep",
      "weh",
      "wi",
      "wig",
      "wigg",
      "wigs",
      "win",
      "winj",
      "winh",
      "wid",
      "wil",
      "wilg",
      "wilm",
      "wilb",
      "wils",
      "wilt",
      "wilp",
      "wilh",
      "wim",
      "wib",
      "wibs",
      "wis",
      "wiss",
      "wing",
      "wij",
      "wic",
      "wik",
      "wit",
      "wip",
      "wih",
      "yu",
      "yug",
      "yugg",
      "yugs",
      "yun",
      "yunj",
      "yunh",
      "yud",
      "yul",
      "yulg",
      "yulm",
      "yulb",
      "yuls",
      "yult",
      "yulp",
      "yulh",
      "yum",
      "yub",
      "yubs",
      "yus",
      "yuss",
      "yung",
      "yuj",
      "yuc",
      "yuk",
      "yut",
      "yup",
      "yuh",
      "eu",
      "eug",
      "eugg",
      "eugs",
      "eun",
      "eunj",
      "eunh",
      "eud",
      "eul",
      "eulg",
      "eulm",
      "eulb",
      "euls",
      "eult",
      "eulp",
      "eulh",
      "eum",
      "eub",
      "eubs",
      "eus",
      "euss",
      "eung",
      "euj",
      "euc",
      "euk",
      "eut",
      "eup",
      "euh",
      "yi",
      "yig",
      "yigg",
      "yigs",
      "yin",
      "yinj",
      "yinh",
      "yid",
      "yil",
      "yilg",
      "yilm",
      "yilb",
      "yils",
      "yilt",
      "yilp",
      "yilh",
      "yim",
      "yib",
      "yibs",
      "yis",
      "yiss",
      "ying",
      "yij",
      "yic",
      "yik",
      "yit",
      "yip",
      "yih",
      "i",
      "ig",
      "igg",
      "igs",
      "in",
      "inj",
      "inh",
      "id",
      "il",
      "ilg",
      "ilm",
      "ilb",
      "ils",
      "ilt",
      "ilp",
      "ilh",
      "im",
      "ib",
      "ibs",
      "is",
      "iss",
      "ing",
      "ij",
      "ic",
      "ik",
      "it",
      "ip",
      "ih",
      "ja",
      "jag",
      "jagg",
      "jags",
      "jan",
      "janj",
      "janh",
      "jad",
      "jal",
      "jalg",
      "jalm",
      "jalb",
      "jals",
      "jalt",
      "jalp",
      "jalh",
      "jam",
      "jab",
      "jabs",
      "jas",
      "jass",
      "jang",
      "jaj",
      "jac",
      "jak",
      "jat",
      "jap",
      "jah",
      "jae",
      "jaeg",
      "jaegg",
      "jaegs",
      "jaen",
      "jaenj",
      "jaenh",
      "jaed",
      "jael",
      "jaelg",
      "jaelm",
      "jaelb",
      "jaels",
      "jaelt",
      "jaelp",
      "jaelh",
      "jaem",
      "jaeb",
      "jaebs",
      "jaes",
      "jaess",
      "jaeng",
      "jaej",
      "jaec",
      "jaek",
      "jaet",
      "jaep",
      "jaeh",
      "jya",
      "jyag",
      "jyagg",
      "jyags",
      "jyan",
      "jyanj",
      "jyanh",
      "jyad",
      "jyal",
      "jyalg",
      "jyalm",
      "jyalb",
      "jyals",
      "jyalt",
      "jyalp",
      "jyalh",
      "jyam",
      "jyab",
      "jyabs",
      "jyas",
      "jyass",
      "jyang",
      "jyaj",
      "jyac",
      "jyak",
      "jyat",
      "jyap",
      "jyah",
      "jyae",
      "jyaeg",
      "jyaegg",
      "jyaegs",
      "jyaen",
      "jyaenj",
      "jyaenh",
      "jyaed",
      "jyael",
      "jyaelg",
      "jyaelm",
      "jyaelb",
      "jyaels",
      "jyaelt",
      "jyaelp",
      "jyaelh",
      "jyaem",
      "jyaeb",
      "jyaebs",
      "jyaes",
      "jyaess",
      "jyaeng",
      "jyaej",
      "jyaec",
      "jyaek",
      "jyaet",
      "jyaep",
      "jyaeh"
    ];
  }
});

// node_modules/unidecode/data/xc8.js
var require_xc8 = __commonJS({
  "node_modules/unidecode/data/xc8.js"(exports2, module2) {
    module2.exports = [
      "jeo",
      "jeog",
      "jeogg",
      "jeogs",
      "jeon",
      "jeonj",
      "jeonh",
      "jeod",
      "jeol",
      "jeolg",
      "jeolm",
      "jeolb",
      "jeols",
      "jeolt",
      "jeolp",
      "jeolh",
      "jeom",
      "jeob",
      "jeobs",
      "jeos",
      "jeoss",
      "jeong",
      "jeoj",
      "jeoc",
      "jeok",
      "jeot",
      "jeop",
      "jeoh",
      "je",
      "jeg",
      "jegg",
      "jegs",
      "jen",
      "jenj",
      "jenh",
      "jed",
      "jel",
      "jelg",
      "jelm",
      "jelb",
      "jels",
      "jelt",
      "jelp",
      "jelh",
      "jem",
      "jeb",
      "jebs",
      "jes",
      "jess",
      "jeng",
      "jej",
      "jec",
      "jek",
      "jet",
      "jep",
      "jeh",
      "jyeo",
      "jyeog",
      "jyeogg",
      "jyeogs",
      "jyeon",
      "jyeonj",
      "jyeonh",
      "jyeod",
      "jyeol",
      "jyeolg",
      "jyeolm",
      "jyeolb",
      "jyeols",
      "jyeolt",
      "jyeolp",
      "jyeolh",
      "jyeom",
      "jyeob",
      "jyeobs",
      "jyeos",
      "jyeoss",
      "jyeong",
      "jyeoj",
      "jyeoc",
      "jyeok",
      "jyeot",
      "jyeop",
      "jyeoh",
      "jye",
      "jyeg",
      "jyegg",
      "jyegs",
      "jyen",
      "jyenj",
      "jyenh",
      "jyed",
      "jyel",
      "jyelg",
      "jyelm",
      "jyelb",
      "jyels",
      "jyelt",
      "jyelp",
      "jyelh",
      "jyem",
      "jyeb",
      "jyebs",
      "jyes",
      "jyess",
      "jyeng",
      "jyej",
      "jyec",
      "jyek",
      "jyet",
      "jyep",
      "jyeh",
      "jo",
      "jog",
      "jogg",
      "jogs",
      "jon",
      "jonj",
      "jonh",
      "jod",
      "jol",
      "jolg",
      "jolm",
      "jolb",
      "jols",
      "jolt",
      "jolp",
      "jolh",
      "jom",
      "job",
      "jobs",
      "jos",
      "joss",
      "jong",
      "joj",
      "joc",
      "jok",
      "jot",
      "jop",
      "joh",
      "jwa",
      "jwag",
      "jwagg",
      "jwags",
      "jwan",
      "jwanj",
      "jwanh",
      "jwad",
      "jwal",
      "jwalg",
      "jwalm",
      "jwalb",
      "jwals",
      "jwalt",
      "jwalp",
      "jwalh",
      "jwam",
      "jwab",
      "jwabs",
      "jwas",
      "jwass",
      "jwang",
      "jwaj",
      "jwac",
      "jwak",
      "jwat",
      "jwap",
      "jwah",
      "jwae",
      "jwaeg",
      "jwaegg",
      "jwaegs",
      "jwaen",
      "jwaenj",
      "jwaenh",
      "jwaed",
      "jwael",
      "jwaelg",
      "jwaelm",
      "jwaelb",
      "jwaels",
      "jwaelt",
      "jwaelp",
      "jwaelh",
      "jwaem",
      "jwaeb",
      "jwaebs",
      "jwaes",
      "jwaess",
      "jwaeng",
      "jwaej",
      "jwaec",
      "jwaek",
      "jwaet",
      "jwaep",
      "jwaeh",
      "joe",
      "joeg",
      "joegg",
      "joegs",
      "joen",
      "joenj",
      "joenh",
      "joed",
      "joel",
      "joelg",
      "joelm",
      "joelb",
      "joels",
      "joelt",
      "joelp",
      "joelh",
      "joem",
      "joeb",
      "joebs",
      "joes",
      "joess",
      "joeng",
      "joej",
      "joec",
      "joek",
      "joet",
      "joep",
      "joeh",
      "jyo",
      "jyog",
      "jyogg",
      "jyogs",
      "jyon",
      "jyonj",
      "jyonh",
      "jyod",
      "jyol",
      "jyolg",
      "jyolm",
      "jyolb",
      "jyols",
      "jyolt",
      "jyolp",
      "jyolh",
      "jyom",
      "jyob",
      "jyobs",
      "jyos",
      "jyoss",
      "jyong",
      "jyoj",
      "jyoc",
      "jyok",
      "jyot",
      "jyop",
      "jyoh",
      "ju",
      "jug",
      "jugg",
      "jugs"
    ];
  }
});

// node_modules/unidecode/data/xc9.js
var require_xc9 = __commonJS({
  "node_modules/unidecode/data/xc9.js"(exports2, module2) {
    module2.exports = [
      "jun",
      "junj",
      "junh",
      "jud",
      "jul",
      "julg",
      "julm",
      "julb",
      "juls",
      "jult",
      "julp",
      "julh",
      "jum",
      "jub",
      "jubs",
      "jus",
      "juss",
      "jung",
      "juj",
      "juc",
      "juk",
      "jut",
      "jup",
      "juh",
      "jweo",
      "jweog",
      "jweogg",
      "jweogs",
      "jweon",
      "jweonj",
      "jweonh",
      "jweod",
      "jweol",
      "jweolg",
      "jweolm",
      "jweolb",
      "jweols",
      "jweolt",
      "jweolp",
      "jweolh",
      "jweom",
      "jweob",
      "jweobs",
      "jweos",
      "jweoss",
      "jweong",
      "jweoj",
      "jweoc",
      "jweok",
      "jweot",
      "jweop",
      "jweoh",
      "jwe",
      "jweg",
      "jwegg",
      "jwegs",
      "jwen",
      "jwenj",
      "jwenh",
      "jwed",
      "jwel",
      "jwelg",
      "jwelm",
      "jwelb",
      "jwels",
      "jwelt",
      "jwelp",
      "jwelh",
      "jwem",
      "jweb",
      "jwebs",
      "jwes",
      "jwess",
      "jweng",
      "jwej",
      "jwec",
      "jwek",
      "jwet",
      "jwep",
      "jweh",
      "jwi",
      "jwig",
      "jwigg",
      "jwigs",
      "jwin",
      "jwinj",
      "jwinh",
      "jwid",
      "jwil",
      "jwilg",
      "jwilm",
      "jwilb",
      "jwils",
      "jwilt",
      "jwilp",
      "jwilh",
      "jwim",
      "jwib",
      "jwibs",
      "jwis",
      "jwiss",
      "jwing",
      "jwij",
      "jwic",
      "jwik",
      "jwit",
      "jwip",
      "jwih",
      "jyu",
      "jyug",
      "jyugg",
      "jyugs",
      "jyun",
      "jyunj",
      "jyunh",
      "jyud",
      "jyul",
      "jyulg",
      "jyulm",
      "jyulb",
      "jyuls",
      "jyult",
      "jyulp",
      "jyulh",
      "jyum",
      "jyub",
      "jyubs",
      "jyus",
      "jyuss",
      "jyung",
      "jyuj",
      "jyuc",
      "jyuk",
      "jyut",
      "jyup",
      "jyuh",
      "jeu",
      "jeug",
      "jeugg",
      "jeugs",
      "jeun",
      "jeunj",
      "jeunh",
      "jeud",
      "jeul",
      "jeulg",
      "jeulm",
      "jeulb",
      "jeuls",
      "jeult",
      "jeulp",
      "jeulh",
      "jeum",
      "jeub",
      "jeubs",
      "jeus",
      "jeuss",
      "jeung",
      "jeuj",
      "jeuc",
      "jeuk",
      "jeut",
      "jeup",
      "jeuh",
      "jyi",
      "jyig",
      "jyigg",
      "jyigs",
      "jyin",
      "jyinj",
      "jyinh",
      "jyid",
      "jyil",
      "jyilg",
      "jyilm",
      "jyilb",
      "jyils",
      "jyilt",
      "jyilp",
      "jyilh",
      "jyim",
      "jyib",
      "jyibs",
      "jyis",
      "jyiss",
      "jying",
      "jyij",
      "jyic",
      "jyik",
      "jyit",
      "jyip",
      "jyih",
      "ji",
      "jig",
      "jigg",
      "jigs",
      "jin",
      "jinj",
      "jinh",
      "jid",
      "jil",
      "jilg",
      "jilm",
      "jilb",
      "jils",
      "jilt",
      "jilp",
      "jilh",
      "jim",
      "jib",
      "jibs",
      "jis",
      "jiss",
      "jing",
      "jij",
      "jic",
      "jik",
      "jit",
      "jip",
      "jih",
      "jja",
      "jjag",
      "jjagg",
      "jjags",
      "jjan",
      "jjanj",
      "jjanh",
      "jjad",
      "jjal",
      "jjalg",
      "jjalm",
      "jjalb",
      "jjals",
      "jjalt",
      "jjalp",
      "jjalh",
      "jjam",
      "jjab",
      "jjabs",
      "jjas",
      "jjass",
      "jjang",
      "jjaj",
      "jjac",
      "jjak",
      "jjat",
      "jjap",
      "jjah",
      "jjae",
      "jjaeg",
      "jjaegg",
      "jjaegs",
      "jjaen",
      "jjaenj",
      "jjaenh",
      "jjaed"
    ];
  }
});

// node_modules/unidecode/data/xca.js
var require_xca = __commonJS({
  "node_modules/unidecode/data/xca.js"(exports2, module2) {
    module2.exports = [
      "jjael",
      "jjaelg",
      "jjaelm",
      "jjaelb",
      "jjaels",
      "jjaelt",
      "jjaelp",
      "jjaelh",
      "jjaem",
      "jjaeb",
      "jjaebs",
      "jjaes",
      "jjaess",
      "jjaeng",
      "jjaej",
      "jjaec",
      "jjaek",
      "jjaet",
      "jjaep",
      "jjaeh",
      "jjya",
      "jjyag",
      "jjyagg",
      "jjyags",
      "jjyan",
      "jjyanj",
      "jjyanh",
      "jjyad",
      "jjyal",
      "jjyalg",
      "jjyalm",
      "jjyalb",
      "jjyals",
      "jjyalt",
      "jjyalp",
      "jjyalh",
      "jjyam",
      "jjyab",
      "jjyabs",
      "jjyas",
      "jjyass",
      "jjyang",
      "jjyaj",
      "jjyac",
      "jjyak",
      "jjyat",
      "jjyap",
      "jjyah",
      "jjyae",
      "jjyaeg",
      "jjyaegg",
      "jjyaegs",
      "jjyaen",
      "jjyaenj",
      "jjyaenh",
      "jjyaed",
      "jjyael",
      "jjyaelg",
      "jjyaelm",
      "jjyaelb",
      "jjyaels",
      "jjyaelt",
      "jjyaelp",
      "jjyaelh",
      "jjyaem",
      "jjyaeb",
      "jjyaebs",
      "jjyaes",
      "jjyaess",
      "jjyaeng",
      "jjyaej",
      "jjyaec",
      "jjyaek",
      "jjyaet",
      "jjyaep",
      "jjyaeh",
      "jjeo",
      "jjeog",
      "jjeogg",
      "jjeogs",
      "jjeon",
      "jjeonj",
      "jjeonh",
      "jjeod",
      "jjeol",
      "jjeolg",
      "jjeolm",
      "jjeolb",
      "jjeols",
      "jjeolt",
      "jjeolp",
      "jjeolh",
      "jjeom",
      "jjeob",
      "jjeobs",
      "jjeos",
      "jjeoss",
      "jjeong",
      "jjeoj",
      "jjeoc",
      "jjeok",
      "jjeot",
      "jjeop",
      "jjeoh",
      "jje",
      "jjeg",
      "jjegg",
      "jjegs",
      "jjen",
      "jjenj",
      "jjenh",
      "jjed",
      "jjel",
      "jjelg",
      "jjelm",
      "jjelb",
      "jjels",
      "jjelt",
      "jjelp",
      "jjelh",
      "jjem",
      "jjeb",
      "jjebs",
      "jjes",
      "jjess",
      "jjeng",
      "jjej",
      "jjec",
      "jjek",
      "jjet",
      "jjep",
      "jjeh",
      "jjyeo",
      "jjyeog",
      "jjyeogg",
      "jjyeogs",
      "jjyeon",
      "jjyeonj",
      "jjyeonh",
      "jjyeod",
      "jjyeol",
      "jjyeolg",
      "jjyeolm",
      "jjyeolb",
      "jjyeols",
      "jjyeolt",
      "jjyeolp",
      "jjyeolh",
      "jjyeom",
      "jjyeob",
      "jjyeobs",
      "jjyeos",
      "jjyeoss",
      "jjyeong",
      "jjyeoj",
      "jjyeoc",
      "jjyeok",
      "jjyeot",
      "jjyeop",
      "jjyeoh",
      "jjye",
      "jjyeg",
      "jjyegg",
      "jjyegs",
      "jjyen",
      "jjyenj",
      "jjyenh",
      "jjyed",
      "jjyel",
      "jjyelg",
      "jjyelm",
      "jjyelb",
      "jjyels",
      "jjyelt",
      "jjyelp",
      "jjyelh",
      "jjyem",
      "jjyeb",
      "jjyebs",
      "jjyes",
      "jjyess",
      "jjyeng",
      "jjyej",
      "jjyec",
      "jjyek",
      "jjyet",
      "jjyep",
      "jjyeh",
      "jjo",
      "jjog",
      "jjogg",
      "jjogs",
      "jjon",
      "jjonj",
      "jjonh",
      "jjod",
      "jjol",
      "jjolg",
      "jjolm",
      "jjolb",
      "jjols",
      "jjolt",
      "jjolp",
      "jjolh",
      "jjom",
      "jjob",
      "jjobs",
      "jjos",
      "jjoss",
      "jjong",
      "jjoj",
      "jjoc",
      "jjok",
      "jjot",
      "jjop",
      "jjoh",
      "jjwa",
      "jjwag",
      "jjwagg",
      "jjwags",
      "jjwan",
      "jjwanj",
      "jjwanh",
      "jjwad",
      "jjwal",
      "jjwalg",
      "jjwalm",
      "jjwalb",
      "jjwals",
      "jjwalt",
      "jjwalp",
      "jjwalh",
      "jjwam",
      "jjwab",
      "jjwabs",
      "jjwas",
      "jjwass",
      "jjwang",
      "jjwaj",
      "jjwac",
      "jjwak",
      "jjwat",
      "jjwap",
      "jjwah",
      "jjwae",
      "jjwaeg",
      "jjwaegg",
      "jjwaegs",
      "jjwaen",
      "jjwaenj",
      "jjwaenh",
      "jjwaed",
      "jjwael",
      "jjwaelg",
      "jjwaelm",
      "jjwaelb"
    ];
  }
});

// node_modules/unidecode/data/xcb.js
var require_xcb = __commonJS({
  "node_modules/unidecode/data/xcb.js"(exports2, module2) {
    module2.exports = [
      "jjwaels",
      "jjwaelt",
      "jjwaelp",
      "jjwaelh",
      "jjwaem",
      "jjwaeb",
      "jjwaebs",
      "jjwaes",
      "jjwaess",
      "jjwaeng",
      "jjwaej",
      "jjwaec",
      "jjwaek",
      "jjwaet",
      "jjwaep",
      "jjwaeh",
      "jjoe",
      "jjoeg",
      "jjoegg",
      "jjoegs",
      "jjoen",
      "jjoenj",
      "jjoenh",
      "jjoed",
      "jjoel",
      "jjoelg",
      "jjoelm",
      "jjoelb",
      "jjoels",
      "jjoelt",
      "jjoelp",
      "jjoelh",
      "jjoem",
      "jjoeb",
      "jjoebs",
      "jjoes",
      "jjoess",
      "jjoeng",
      "jjoej",
      "jjoec",
      "jjoek",
      "jjoet",
      "jjoep",
      "jjoeh",
      "jjyo",
      "jjyog",
      "jjyogg",
      "jjyogs",
      "jjyon",
      "jjyonj",
      "jjyonh",
      "jjyod",
      "jjyol",
      "jjyolg",
      "jjyolm",
      "jjyolb",
      "jjyols",
      "jjyolt",
      "jjyolp",
      "jjyolh",
      "jjyom",
      "jjyob",
      "jjyobs",
      "jjyos",
      "jjyoss",
      "jjyong",
      "jjyoj",
      "jjyoc",
      "jjyok",
      "jjyot",
      "jjyop",
      "jjyoh",
      "jju",
      "jjug",
      "jjugg",
      "jjugs",
      "jjun",
      "jjunj",
      "jjunh",
      "jjud",
      "jjul",
      "jjulg",
      "jjulm",
      "jjulb",
      "jjuls",
      "jjult",
      "jjulp",
      "jjulh",
      "jjum",
      "jjub",
      "jjubs",
      "jjus",
      "jjuss",
      "jjung",
      "jjuj",
      "jjuc",
      "jjuk",
      "jjut",
      "jjup",
      "jjuh",
      "jjweo",
      "jjweog",
      "jjweogg",
      "jjweogs",
      "jjweon",
      "jjweonj",
      "jjweonh",
      "jjweod",
      "jjweol",
      "jjweolg",
      "jjweolm",
      "jjweolb",
      "jjweols",
      "jjweolt",
      "jjweolp",
      "jjweolh",
      "jjweom",
      "jjweob",
      "jjweobs",
      "jjweos",
      "jjweoss",
      "jjweong",
      "jjweoj",
      "jjweoc",
      "jjweok",
      "jjweot",
      "jjweop",
      "jjweoh",
      "jjwe",
      "jjweg",
      "jjwegg",
      "jjwegs",
      "jjwen",
      "jjwenj",
      "jjwenh",
      "jjwed",
      "jjwel",
      "jjwelg",
      "jjwelm",
      "jjwelb",
      "jjwels",
      "jjwelt",
      "jjwelp",
      "jjwelh",
      "jjwem",
      "jjweb",
      "jjwebs",
      "jjwes",
      "jjwess",
      "jjweng",
      "jjwej",
      "jjwec",
      "jjwek",
      "jjwet",
      "jjwep",
      "jjweh",
      "jjwi",
      "jjwig",
      "jjwigg",
      "jjwigs",
      "jjwin",
      "jjwinj",
      "jjwinh",
      "jjwid",
      "jjwil",
      "jjwilg",
      "jjwilm",
      "jjwilb",
      "jjwils",
      "jjwilt",
      "jjwilp",
      "jjwilh",
      "jjwim",
      "jjwib",
      "jjwibs",
      "jjwis",
      "jjwiss",
      "jjwing",
      "jjwij",
      "jjwic",
      "jjwik",
      "jjwit",
      "jjwip",
      "jjwih",
      "jjyu",
      "jjyug",
      "jjyugg",
      "jjyugs",
      "jjyun",
      "jjyunj",
      "jjyunh",
      "jjyud",
      "jjyul",
      "jjyulg",
      "jjyulm",
      "jjyulb",
      "jjyuls",
      "jjyult",
      "jjyulp",
      "jjyulh",
      "jjyum",
      "jjyub",
      "jjyubs",
      "jjyus",
      "jjyuss",
      "jjyung",
      "jjyuj",
      "jjyuc",
      "jjyuk",
      "jjyut",
      "jjyup",
      "jjyuh",
      "jjeu",
      "jjeug",
      "jjeugg",
      "jjeugs",
      "jjeun",
      "jjeunj",
      "jjeunh",
      "jjeud",
      "jjeul",
      "jjeulg",
      "jjeulm",
      "jjeulb",
      "jjeuls",
      "jjeult",
      "jjeulp",
      "jjeulh",
      "jjeum",
      "jjeub",
      "jjeubs",
      "jjeus",
      "jjeuss",
      "jjeung",
      "jjeuj",
      "jjeuc",
      "jjeuk",
      "jjeut",
      "jjeup",
      "jjeuh",
      "jjyi",
      "jjyig",
      "jjyigg",
      "jjyigs",
      "jjyin",
      "jjyinj",
      "jjyinh",
      "jjyid",
      "jjyil",
      "jjyilg",
      "jjyilm",
      "jjyilb",
      "jjyils",
      "jjyilt",
      "jjyilp",
      "jjyilh"
    ];
  }
});

// node_modules/unidecode/data/xcc.js
var require_xcc = __commonJS({
  "node_modules/unidecode/data/xcc.js"(exports2, module2) {
    module2.exports = [
      "jjyim",
      "jjyib",
      "jjyibs",
      "jjyis",
      "jjyiss",
      "jjying",
      "jjyij",
      "jjyic",
      "jjyik",
      "jjyit",
      "jjyip",
      "jjyih",
      "jji",
      "jjig",
      "jjigg",
      "jjigs",
      "jjin",
      "jjinj",
      "jjinh",
      "jjid",
      "jjil",
      "jjilg",
      "jjilm",
      "jjilb",
      "jjils",
      "jjilt",
      "jjilp",
      "jjilh",
      "jjim",
      "jjib",
      "jjibs",
      "jjis",
      "jjiss",
      "jjing",
      "jjij",
      "jjic",
      "jjik",
      "jjit",
      "jjip",
      "jjih",
      "ca",
      "cag",
      "cagg",
      "cags",
      "can",
      "canj",
      "canh",
      "cad",
      "cal",
      "calg",
      "calm",
      "calb",
      "cals",
      "calt",
      "calp",
      "calh",
      "cam",
      "cab",
      "cabs",
      "cas",
      "cass",
      "cang",
      "caj",
      "cac",
      "cak",
      "cat",
      "cap",
      "cah",
      "cae",
      "caeg",
      "caegg",
      "caegs",
      "caen",
      "caenj",
      "caenh",
      "caed",
      "cael",
      "caelg",
      "caelm",
      "caelb",
      "caels",
      "caelt",
      "caelp",
      "caelh",
      "caem",
      "caeb",
      "caebs",
      "caes",
      "caess",
      "caeng",
      "caej",
      "caec",
      "caek",
      "caet",
      "caep",
      "caeh",
      "cya",
      "cyag",
      "cyagg",
      "cyags",
      "cyan",
      "cyanj",
      "cyanh",
      "cyad",
      "cyal",
      "cyalg",
      "cyalm",
      "cyalb",
      "cyals",
      "cyalt",
      "cyalp",
      "cyalh",
      "cyam",
      "cyab",
      "cyabs",
      "cyas",
      "cyass",
      "cyang",
      "cyaj",
      "cyac",
      "cyak",
      "cyat",
      "cyap",
      "cyah",
      "cyae",
      "cyaeg",
      "cyaegg",
      "cyaegs",
      "cyaen",
      "cyaenj",
      "cyaenh",
      "cyaed",
      "cyael",
      "cyaelg",
      "cyaelm",
      "cyaelb",
      "cyaels",
      "cyaelt",
      "cyaelp",
      "cyaelh",
      "cyaem",
      "cyaeb",
      "cyaebs",
      "cyaes",
      "cyaess",
      "cyaeng",
      "cyaej",
      "cyaec",
      "cyaek",
      "cyaet",
      "cyaep",
      "cyaeh",
      "ceo",
      "ceog",
      "ceogg",
      "ceogs",
      "ceon",
      "ceonj",
      "ceonh",
      "ceod",
      "ceol",
      "ceolg",
      "ceolm",
      "ceolb",
      "ceols",
      "ceolt",
      "ceolp",
      "ceolh",
      "ceom",
      "ceob",
      "ceobs",
      "ceos",
      "ceoss",
      "ceong",
      "ceoj",
      "ceoc",
      "ceok",
      "ceot",
      "ceop",
      "ceoh",
      "ce",
      "ceg",
      "cegg",
      "cegs",
      "cen",
      "cenj",
      "cenh",
      "ced",
      "cel",
      "celg",
      "celm",
      "celb",
      "cels",
      "celt",
      "celp",
      "celh",
      "cem",
      "ceb",
      "cebs",
      "ces",
      "cess",
      "ceng",
      "cej",
      "cec",
      "cek",
      "cet",
      "cep",
      "ceh",
      "cyeo",
      "cyeog",
      "cyeogg",
      "cyeogs",
      "cyeon",
      "cyeonj",
      "cyeonh",
      "cyeod",
      "cyeol",
      "cyeolg",
      "cyeolm",
      "cyeolb",
      "cyeols",
      "cyeolt",
      "cyeolp",
      "cyeolh",
      "cyeom",
      "cyeob",
      "cyeobs",
      "cyeos",
      "cyeoss",
      "cyeong",
      "cyeoj",
      "cyeoc",
      "cyeok",
      "cyeot",
      "cyeop",
      "cyeoh",
      "cye",
      "cyeg",
      "cyegg",
      "cyegs",
      "cyen",
      "cyenj",
      "cyenh",
      "cyed",
      "cyel",
      "cyelg",
      "cyelm",
      "cyelb",
      "cyels",
      "cyelt",
      "cyelp",
      "cyelh",
      "cyem",
      "cyeb",
      "cyebs",
      "cyes"
    ];
  }
});

// node_modules/unidecode/data/xcd.js
var require_xcd = __commonJS({
  "node_modules/unidecode/data/xcd.js"(exports2, module2) {
    module2.exports = [
      "cyess",
      "cyeng",
      "cyej",
      "cyec",
      "cyek",
      "cyet",
      "cyep",
      "cyeh",
      "co",
      "cog",
      "cogg",
      "cogs",
      "con",
      "conj",
      "conh",
      "cod",
      "col",
      "colg",
      "colm",
      "colb",
      "cols",
      "colt",
      "colp",
      "colh",
      "com",
      "cob",
      "cobs",
      "cos",
      "coss",
      "cong",
      "coj",
      "coc",
      "cok",
      "cot",
      "cop",
      "coh",
      "cwa",
      "cwag",
      "cwagg",
      "cwags",
      "cwan",
      "cwanj",
      "cwanh",
      "cwad",
      "cwal",
      "cwalg",
      "cwalm",
      "cwalb",
      "cwals",
      "cwalt",
      "cwalp",
      "cwalh",
      "cwam",
      "cwab",
      "cwabs",
      "cwas",
      "cwass",
      "cwang",
      "cwaj",
      "cwac",
      "cwak",
      "cwat",
      "cwap",
      "cwah",
      "cwae",
      "cwaeg",
      "cwaegg",
      "cwaegs",
      "cwaen",
      "cwaenj",
      "cwaenh",
      "cwaed",
      "cwael",
      "cwaelg",
      "cwaelm",
      "cwaelb",
      "cwaels",
      "cwaelt",
      "cwaelp",
      "cwaelh",
      "cwaem",
      "cwaeb",
      "cwaebs",
      "cwaes",
      "cwaess",
      "cwaeng",
      "cwaej",
      "cwaec",
      "cwaek",
      "cwaet",
      "cwaep",
      "cwaeh",
      "coe",
      "coeg",
      "coegg",
      "coegs",
      "coen",
      "coenj",
      "coenh",
      "coed",
      "coel",
      "coelg",
      "coelm",
      "coelb",
      "coels",
      "coelt",
      "coelp",
      "coelh",
      "coem",
      "coeb",
      "coebs",
      "coes",
      "coess",
      "coeng",
      "coej",
      "coec",
      "coek",
      "coet",
      "coep",
      "coeh",
      "cyo",
      "cyog",
      "cyogg",
      "cyogs",
      "cyon",
      "cyonj",
      "cyonh",
      "cyod",
      "cyol",
      "cyolg",
      "cyolm",
      "cyolb",
      "cyols",
      "cyolt",
      "cyolp",
      "cyolh",
      "cyom",
      "cyob",
      "cyobs",
      "cyos",
      "cyoss",
      "cyong",
      "cyoj",
      "cyoc",
      "cyok",
      "cyot",
      "cyop",
      "cyoh",
      "cu",
      "cug",
      "cugg",
      "cugs",
      "cun",
      "cunj",
      "cunh",
      "cud",
      "cul",
      "culg",
      "culm",
      "culb",
      "culs",
      "cult",
      "culp",
      "culh",
      "cum",
      "cub",
      "cubs",
      "cus",
      "cuss",
      "cung",
      "cuj",
      "cuc",
      "cuk",
      "cut",
      "cup",
      "cuh",
      "cweo",
      "cweog",
      "cweogg",
      "cweogs",
      "cweon",
      "cweonj",
      "cweonh",
      "cweod",
      "cweol",
      "cweolg",
      "cweolm",
      "cweolb",
      "cweols",
      "cweolt",
      "cweolp",
      "cweolh",
      "cweom",
      "cweob",
      "cweobs",
      "cweos",
      "cweoss",
      "cweong",
      "cweoj",
      "cweoc",
      "cweok",
      "cweot",
      "cweop",
      "cweoh",
      "cwe",
      "cweg",
      "cwegg",
      "cwegs",
      "cwen",
      "cwenj",
      "cwenh",
      "cwed",
      "cwel",
      "cwelg",
      "cwelm",
      "cwelb",
      "cwels",
      "cwelt",
      "cwelp",
      "cwelh",
      "cwem",
      "cweb",
      "cwebs",
      "cwes",
      "cwess",
      "cweng",
      "cwej",
      "cwec",
      "cwek",
      "cwet",
      "cwep",
      "cweh",
      "cwi",
      "cwig",
      "cwigg",
      "cwigs",
      "cwin",
      "cwinj",
      "cwinh",
      "cwid",
      "cwil",
      "cwilg",
      "cwilm",
      "cwilb",
      "cwils",
      "cwilt",
      "cwilp",
      "cwilh",
      "cwim",
      "cwib",
      "cwibs",
      "cwis",
      "cwiss",
      "cwing",
      "cwij",
      "cwic"
    ];
  }
});

// node_modules/unidecode/data/xce.js
var require_xce = __commonJS({
  "node_modules/unidecode/data/xce.js"(exports2, module2) {
    module2.exports = [
      "cwik",
      "cwit",
      "cwip",
      "cwih",
      "cyu",
      "cyug",
      "cyugg",
      "cyugs",
      "cyun",
      "cyunj",
      "cyunh",
      "cyud",
      "cyul",
      "cyulg",
      "cyulm",
      "cyulb",
      "cyuls",
      "cyult",
      "cyulp",
      "cyulh",
      "cyum",
      "cyub",
      "cyubs",
      "cyus",
      "cyuss",
      "cyung",
      "cyuj",
      "cyuc",
      "cyuk",
      "cyut",
      "cyup",
      "cyuh",
      "ceu",
      "ceug",
      "ceugg",
      "ceugs",
      "ceun",
      "ceunj",
      "ceunh",
      "ceud",
      "ceul",
      "ceulg",
      "ceulm",
      "ceulb",
      "ceuls",
      "ceult",
      "ceulp",
      "ceulh",
      "ceum",
      "ceub",
      "ceubs",
      "ceus",
      "ceuss",
      "ceung",
      "ceuj",
      "ceuc",
      "ceuk",
      "ceut",
      "ceup",
      "ceuh",
      "cyi",
      "cyig",
      "cyigg",
      "cyigs",
      "cyin",
      "cyinj",
      "cyinh",
      "cyid",
      "cyil",
      "cyilg",
      "cyilm",
      "cyilb",
      "cyils",
      "cyilt",
      "cyilp",
      "cyilh",
      "cyim",
      "cyib",
      "cyibs",
      "cyis",
      "cyiss",
      "cying",
      "cyij",
      "cyic",
      "cyik",
      "cyit",
      "cyip",
      "cyih",
      "ci",
      "cig",
      "cigg",
      "cigs",
      "cin",
      "cinj",
      "cinh",
      "cid",
      "cil",
      "cilg",
      "cilm",
      "cilb",
      "cils",
      "cilt",
      "cilp",
      "cilh",
      "cim",
      "cib",
      "cibs",
      "cis",
      "ciss",
      "cing",
      "cij",
      "cic",
      "cik",
      "cit",
      "cip",
      "cih",
      "ka",
      "kag",
      "kagg",
      "kags",
      "kan",
      "kanj",
      "kanh",
      "kad",
      "kal",
      "kalg",
      "kalm",
      "kalb",
      "kals",
      "kalt",
      "kalp",
      "kalh",
      "kam",
      "kab",
      "kabs",
      "kas",
      "kass",
      "kang",
      "kaj",
      "kac",
      "kak",
      "kat",
      "kap",
      "kah",
      "kae",
      "kaeg",
      "kaegg",
      "kaegs",
      "kaen",
      "kaenj",
      "kaenh",
      "kaed",
      "kael",
      "kaelg",
      "kaelm",
      "kaelb",
      "kaels",
      "kaelt",
      "kaelp",
      "kaelh",
      "kaem",
      "kaeb",
      "kaebs",
      "kaes",
      "kaess",
      "kaeng",
      "kaej",
      "kaec",
      "kaek",
      "kaet",
      "kaep",
      "kaeh",
      "kya",
      "kyag",
      "kyagg",
      "kyags",
      "kyan",
      "kyanj",
      "kyanh",
      "kyad",
      "kyal",
      "kyalg",
      "kyalm",
      "kyalb",
      "kyals",
      "kyalt",
      "kyalp",
      "kyalh",
      "kyam",
      "kyab",
      "kyabs",
      "kyas",
      "kyass",
      "kyang",
      "kyaj",
      "kyac",
      "kyak",
      "kyat",
      "kyap",
      "kyah",
      "kyae",
      "kyaeg",
      "kyaegg",
      "kyaegs",
      "kyaen",
      "kyaenj",
      "kyaenh",
      "kyaed",
      "kyael",
      "kyaelg",
      "kyaelm",
      "kyaelb",
      "kyaels",
      "kyaelt",
      "kyaelp",
      "kyaelh",
      "kyaem",
      "kyaeb",
      "kyaebs",
      "kyaes",
      "kyaess",
      "kyaeng",
      "kyaej",
      "kyaec",
      "kyaek",
      "kyaet",
      "kyaep",
      "kyaeh",
      "keo",
      "keog",
      "keogg",
      "keogs",
      "keo