// SPDX-License-Identifier: GPL-3.0-or-later
// SPDX-FileCopyrightText: Andy Holmes <andrew.g.r.holmes@gmail.com>

#pragma once

G_BEGIN_DECLS

/**
 * VALENT_NETWORK_PROTOCOL_V7: (value 7)
 *
 * Version 7 of the KDE Connect protocol.
 *
 * Since: 1.0
 */
#define VALENT_NETWORK_PROTOCOL_V7  (7)

/**
 * VALENT_NETWORK_PROTOCOL_V8: (value 8)
 *
 * Version 8 of the KDE Connect protocol.
 *
 * Since: 1.0
 */
#define VALENT_NETWORK_PROTOCOL_V8  (8)

/**
 * VALENT_NETWORK_PROTOCOL_MIN: (value 7)
 *
 * The minimum supported KDE Connect protocol version.
 *
 * Since: 1.0
 */
#define VALENT_NETWORK_PROTOCOL_MIN VALENT_NETWORK_PROTOCOL_V7

/**
 * VALENT_NETWORK_PROTOCOL_MAX: (value 8)
 *
 * The maximum supported KDE Connect protocol version.
 *
 * Since: 1.0
 */
#define VALENT_NETWORK_PROTOCOL_MAX VALENT_NETWORK_PROTOCOL_V8

G_END_DECLS

