/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna.message;

import java.io.ByteArrayInputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.support.model.dlna.message.header.DLNAHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLNAHeaders
extends UpnpHeaders {
    private final Logger logger = LoggerFactory.getLogger(DLNAHeaders.class.getName());
    protected Map<DLNAHeader.Type, List<UpnpHeader<?>>> parsedDLNAHeaders;

    public DLNAHeaders() {
    }

    public DLNAHeaders(Map<String, List<String>> headers) {
        super(headers);
    }

    public DLNAHeaders(ByteArrayInputStream inputStream) {
        super(inputStream);
    }

    @Override
    protected void parseHeaders() {
        if (this.parsedHeaders == null) {
            super.parseHeaders();
        }
        this.parsedDLNAHeaders = new LinkedHashMap();
        this.logger.debug("Parsing all HTTP headers for known UPnP headers: {}", (Object)this.size());
        for (Map.Entry<String, List<String>> entry : this.entrySet()) {
            if (entry.getKey() == null) continue;
            DLNAHeader.Type type = DLNAHeader.Type.getByHttpName(entry.getKey());
            if (type == null) {
                this.logger.debug("Ignoring non-UPNP HTTP header: {}", (Object)entry.getKey());
                continue;
            }
            for (String value : entry.getValue()) {
                DLNAHeader<?> upnpHeader = DLNAHeader.newInstance(type, value);
                if (upnpHeader == null || upnpHeader.getValue() == null) {
                    this.logger.debug("Ignoring known but non-parsable header (value violates the UDA specification?) '{}': {}", (Object)type.getHttpName(), (Object)value);
                    continue;
                }
                this.addParsedValue(type, upnpHeader);
            }
        }
    }

    protected void addParsedValue(DLNAHeader.Type type, UpnpHeader<?> value) {
        this.logger.debug("Adding parsed header: {}", (Object)value);
        List list = this.parsedDLNAHeaders.computeIfAbsent(type, k -> new LinkedList());
        list.add(value);
    }

    @Override
    public List<String> put(String key, List<String> values) {
        this.parsedDLNAHeaders = null;
        return super.put(key, values);
    }

    @Override
    public void add(String key, String value) {
        this.parsedDLNAHeaders = null;
        super.add(key, value);
    }

    @Override
    public List<String> remove(Object key) {
        this.parsedDLNAHeaders = null;
        return super.remove(key);
    }

    @Override
    public void clear() {
        this.parsedDLNAHeaders = null;
        super.clear();
    }

    public boolean containsKey(DLNAHeader.Type type) {
        if (this.parsedDLNAHeaders == null) {
            this.parseHeaders();
        }
        return this.parsedDLNAHeaders.containsKey((Object)type);
    }

    public List<UpnpHeader<?>> get(DLNAHeader.Type type) {
        if (this.parsedDLNAHeaders == null) {
            this.parseHeaders();
        }
        return this.parsedDLNAHeaders.get((Object)type);
    }

    public void add(DLNAHeader.Type type, UpnpHeader<?> value) {
        super.add(type.getHttpName(), value.getString());
        if (this.parsedDLNAHeaders != null) {
            this.addParsedValue(type, value);
        }
    }

    public void remove(DLNAHeader.Type type) {
        super.remove(type.getHttpName());
        if (this.parsedDLNAHeaders != null) {
            this.parsedDLNAHeaders.remove((Object)type);
        }
    }

    public UpnpHeader<?>[] getAsArray(DLNAHeader.Type type) {
        if (this.parsedDLNAHeaders == null) {
            this.parseHeaders();
        }
        return this.parsedDLNAHeaders.get((Object)type) != null ? this.parsedDLNAHeaders.get((Object)type).toArray(new UpnpHeader[this.parsedDLNAHeaders.get((Object)type).size()]) : new UpnpHeader[]{};
    }

    public UpnpHeader<?> getFirstHeader(DLNAHeader.Type type) {
        return this.getAsArray(type).length > 0 ? this.getAsArray(type)[0] : null;
    }

    public <H extends UpnpHeader<?>> H getFirstHeader(DLNAHeader.Type type, Class<H> subtype) {
        UpnpHeader<?>[] headers;
        for (UpnpHeader<?> header : headers = this.getAsArray(type)) {
            if (!subtype.isAssignableFrom(header.getClass())) continue;
            return (H)header;
        }
        return null;
    }

    @Override
    public void log() {
        if (this.logger.isTraceEnabled()) {
            super.log();
            if (this.parsedDLNAHeaders != null && !this.parsedDLNAHeaders.isEmpty()) {
                this.logger.trace("########################## PARSED DLNA HEADERS ##########################");
                for (Map.Entry<DLNAHeader.Type, List<UpnpHeader<?>>> entry : this.parsedDLNAHeaders.entrySet()) {
                    this.logger.trace("=== TYPE: {}", (Object)entry.getKey());
                    for (UpnpHeader<?> upnpHeader : entry.getValue()) {
                        this.logger.trace("HEADER: {}", (Object)upnpHeader);
                    }
                }
            }
            this.logger.trace("####################################################################");
        }
    }
}

