/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrame;
import org.jaudiotagger.tag.id3.AbstractTagItem;
import org.jaudiotagger.tag.id3.ID3Tags;

public abstract class AbstractTagFrameBody
extends AbstractTagItem {
    private AbstractTagFrame header;
    protected List<AbstractDataType> objectList = new ArrayList<AbstractDataType>();

    public void createStructure() {
    }

    public final byte getTextEncoding() {
        AbstractDataType o = this.getObject("TextEncoding");
        if (o != null) {
            Long encoding = (Long)o.getValue();
            return encoding.byteValue();
        }
        return 0;
    }

    public final void setTextEncoding(byte textEncoding) {
        this.setObjectValue("TextEncoding", textEncoding);
    }

    protected AbstractTagFrameBody() {
        this.setupObjectList();
    }

    protected AbstractTagFrameBody(AbstractTagFrameBody copyObject) {
        for (int i = 0; i < copyObject.objectList.size(); ++i) {
            AbstractDataType newObject = (AbstractDataType)ID3Tags.copyObject(copyObject.objectList.get(i));
            newObject.setBody(this);
            this.objectList.add(newObject);
        }
    }

    public String getUserFriendlyValue() {
        return this.toString();
    }

    public String getBriefDescription() {
        String str = "";
        for (AbstractDataType object : this.objectList) {
            if (object.toString() == null || object.toString().length() <= 0) continue;
            str = str + object.getIdentifier() + "=\"" + object.toString() + "\"; ";
        }
        return str;
    }

    public final String getLongDescription() {
        String str = "";
        for (AbstractDataType object : this.objectList) {
            if (object.toString() == null || object.toString().length() <= 0) continue;
            str = str + object.getIdentifier() + " = " + object.toString() + "\n";
        }
        return str;
    }

    public final void setObjectValue(String identifier, Object value) {
        for (AbstractDataType object : this.objectList) {
            if (!object.getIdentifier().equals(identifier)) continue;
            object.setValue(value);
        }
    }

    public final Object getObjectValue(String identifier) {
        return this.getObject(identifier).getValue();
    }

    public final AbstractDataType getObject(String identifier) {
        for (AbstractDataType object : this.objectList) {
            if (!object.getIdentifier().equals(identifier)) continue;
            return object;
        }
        return null;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (AbstractDataType object : this.objectList) {
            size += object.getSize();
        }
        return size;
    }

    @Override
    public boolean isSubsetOf(Object obj) {
        if (!(obj instanceof AbstractTagFrameBody)) {
            return false;
        }
        List<AbstractDataType> superset = ((AbstractTagFrameBody)obj).objectList;
        for (AbstractDataType object : this.objectList) {
            if (object.getValue() == null || superset.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractTagFrameBody)) {
            return false;
        }
        AbstractTagFrameBody object = (AbstractTagFrameBody)obj;
        boolean check = this.objectList.equals(object.objectList) && super.equals(obj);
        return check;
    }

    public Iterator<? extends AbstractDataType> iterator() {
        return this.objectList.iterator();
    }

    public String toString() {
        return this.getBriefDescription();
    }

    protected abstract void setupObjectList();

    public AbstractTagFrame getHeader() {
        return this.header;
    }

    public void setHeader(AbstractTagFrame header) {
        this.header = header;
    }
}

