/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav.chunk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.Chunk;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.audio.wav.WavChunkType;
import org.jaudiotagger.audio.wav.chunk.WavInfoChunk;
import org.jaudiotagger.tag.wav.WavTag;

public class WavListChunk
extends Chunk {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.wav.chunk.WavListChunk");
    private boolean isValid = false;
    private WavTag tag;
    private String loggingName;

    public WavListChunk(String loggingName, ByteBuffer chunkData, ChunkHeader chunkHeader, WavTag tag) throws IOException {
        super(chunkData, chunkHeader);
        this.tag = tag;
        this.loggingName = loggingName;
    }

    @Override
    public boolean readChunk() throws IOException {
        boolean result = false;
        String subIdentifier = Utils.readFourBytesAsChars(this.chunkData);
        if (subIdentifier.equals(WavChunkType.INFO.getCode())) {
            WavInfoChunk chunk = new WavInfoChunk(this.tag, this.loggingName);
            result = chunk.readChunks(this.chunkData);
            this.tag.getInfoTag().setStartLocationInFile(this.chunkHeader.getStartLocationInFile());
            this.tag.getInfoTag().setEndLocationInFile(this.chunkHeader.getStartLocationInFile() + 8L + this.chunkHeader.getSize());
            this.tag.setExistingInfoTag(true);
        } else {
            logger.severe("LIST chunk does not contain INFO instead contains " + subIdentifier + " so skipping");
            result = true;
        }
        return result;
    }

    public String toString() {
        String out = "RIFF-WAVE Header:\n";
        out = out + "Is valid?: " + this.isValid;
        return out;
    }
}

