/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav.chunk;

import java.util.logging.Logger;
import org.jaudiotagger.audio.iff.ChunkSummary;
import org.jaudiotagger.audio.wav.WavChunkType;
import org.jaudiotagger.tag.wav.WavTag;

public class WavChunkSummary {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.wav.chunk");

    public static long getStartLocationOfFirstMetadataChunk(WavTag tag) {
        if (tag.getMetadataChunkSummaryList().size() > 0) {
            return tag.getMetadataChunkSummaryList().get(0).getFileStartLocation();
        }
        return -1L;
    }

    public static boolean isOnlyMetadataTagsAfterStartingMetadataTag(WavTag tag) {
        long startLocationOfMetadatTag = WavChunkSummary.getStartLocationOfFirstMetadataChunk(tag);
        if (startLocationOfMetadatTag == -1L) {
            logger.severe("Unable to find any metadata tags !");
            return false;
        }
        boolean firstMetadataTag = false;
        for (ChunkSummary cs : tag.getChunkSummaryList()) {
            if (firstMetadataTag) {
                if (cs.getChunkId().equals(WavChunkType.ID3.getCode()) || cs.getChunkId().equals(WavChunkType.ID3_UPPERCASE.getCode()) || cs.getChunkId().equals(WavChunkType.LIST.getCode()) || cs.getChunkId().equals(WavChunkType.INFO.getCode())) continue;
                return false;
            }
            if (cs.getFileStartLocation() != startLocationOfMetadatTag) continue;
            firstMetadataTag = true;
        }
        return firstMetadataTag;
    }

    public static ChunkSummary getChunkBeforeFirstMetadataTag(WavTag tag) {
        long startLocationOfMetadatTag = WavChunkSummary.getStartLocationOfFirstMetadataChunk(tag);
        for (int i = 0; i < tag.getChunkSummaryList().size(); ++i) {
            ChunkSummary cs = tag.getChunkSummaryList().get(i);
            if (cs.getFileStartLocation() != startLocationOfMetadatTag) continue;
            return tag.getChunkSummaryList().get(i - 1);
        }
        return null;
    }
}

