/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.audio.iff.IffHeaderChunk;
import org.jaudiotagger.audio.wav.WavChunkType;
import org.jaudiotagger.audio.wav.WavRIFFHeader;
import org.jaudiotagger.logging.Hex;

public class WavCleaner {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.wav");
    private Path path;
    private String loggingName;

    public WavCleaner(Path path) {
        this.path = path;
        this.loggingName = path.getFileName().toString();
    }

    public void clean() throws Exception {
        System.out.println("EndOfDataChunk:" + Hex.asHex(this.findEndOfDataChunk()));
    }

    private int findEndOfDataChunk() throws Exception {
        block16: {
            try (FileChannel fc = FileChannel.open(this.path, StandardOpenOption.WRITE, StandardOpenOption.READ);){
                if (!WavRIFFHeader.isValidHeader(this.loggingName, fc)) break block16;
                while (fc.position() < fc.size()) {
                    int endOfChunk = this.readChunk(fc);
                    if (endOfChunk <= 0) continue;
                    fc.truncate(fc.position());
                    int n = endOfChunk;
                    return n;
                }
            }
        }
        return 0;
    }

    private int readChunk(FileChannel fc) throws IOException, CannotReadException {
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.LITTLE_ENDIAN);
        if (!chunkHeader.readHeader(fc)) {
            return 0;
        }
        String id = chunkHeader.getID();
        logger.config(this.loggingName + " Reading Chunk:" + id + ":starting at:" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile()) + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
        WavChunkType chunkType = WavChunkType.get(id);
        if (chunkType != null) {
            switch (chunkType) {
                case DATA: {
                    fc.position(fc.position() + chunkHeader.getSize());
                    return (int)fc.position();
                }
            }
            logger.config(this.loggingName + " Skipping chunk bytes:" + chunkHeader.getSize());
            fc.position(fc.position() + chunkHeader.getSize());
        } else {
            if (chunkHeader.getSize() < 0L) {
                String msg = this.loggingName + " Not a valid header, unable to read a sensible size:Header" + chunkHeader.getID() + "Size:" + chunkHeader.getSize();
                logger.severe(msg);
                throw new CannotReadException(msg);
            }
            logger.severe(this.loggingName + " Skipping chunk bytes:" + chunkHeader.getSize() + " for" + chunkHeader.getID());
            fc.position(fc.position() + chunkHeader.getSize());
        }
        IffHeaderChunk.ensureOnEqualBoundary(fc, chunkHeader);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        Path path = Paths.get("E:\\MQ\\Schubert, F\\The Last Six Years, vol 4-Imogen Cooper", new String[0]);
        WavCleaner.recursiveDelete(path);
    }

    private static void recursiveDelete(Path path) throws Exception {
        for (File next : path.toFile().listFiles()) {
            if (next.isFile() && (next.getName().endsWith(".WAV") || next.getName().endsWith(".wav"))) {
                WavCleaner wc = new WavCleaner(next.toPath());
                wc.clean();
                continue;
            }
            if (!next.isDirectory()) continue;
            WavCleaner.recursiveDelete(next.toPath());
        }
    }
}

