/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.dff;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jaudiotagger.audio.dff.BaseChunk;
import org.jaudiotagger.audio.dff.DffChunkType;
import org.jaudiotagger.audio.generic.Utils;

public class FrteChunk
extends BaseChunk {
    private int numFrames;
    private Short rate;

    public FrteChunk(ByteBuffer dataBuffer) {
        super(dataBuffer);
    }

    @Override
    public void readDataChunch(FileChannel fc) throws IOException {
        super.readDataChunch(fc);
        ByteBuffer audioData = Utils.readFileDataIntoBufferLE(fc, 4);
        this.numFrames = Integer.reverseBytes(audioData.getInt());
        audioData = Utils.readFileDataIntoBufferLE(fc, 2);
        this.rate = Short.reverseBytes(audioData.getShort());
        this.skipToChunkEnd(fc);
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public Short getRate() {
        return this.rate;
    }

    public String toString() {
        return DffChunkType.FRTE.getCode();
    }
}

