/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.logging.Logger;
import org.jaudiotagger.audio.aiff.AiffTagReader;
import org.jaudiotagger.audio.aiff.chunk.AiffChunkSummary;
import org.jaudiotagger.audio.aiff.chunk.AiffChunkType;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.NoWritePermissionsException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.audio.iff.ChunkSummary;
import org.jaudiotagger.audio.iff.IffHeaderChunk;
import org.jaudiotagger.logging.Hex;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.aiff.AiffTag;

public class AiffTagWriter {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.aiff");

    private AiffTag getExistingMetadata(Path file) throws IOException, CannotWriteException {
        try {
            AiffTagReader im = new AiffTagReader(file.toString());
            return im.read(file);
        }
        catch (CannotReadException ex) {
            throw new CannotWriteException(file + " Failed to read file");
        }
    }

    private ChunkHeader seekToStartOfMetadata(FileChannel fc, AiffTag existingTag, String fileName) throws IOException, CannotWriteException {
        fc.position(existingTag.getStartLocationInFileOfId3Chunk());
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.BIG_ENDIAN);
        chunkHeader.readHeader(fc);
        fc.position(fc.position() - 8L);
        if (!AiffChunkType.TAG.getCode().equals(chunkHeader.getID())) {
            throw new CannotWriteException(fileName + ":Unable to find ID3 chunk at expected location:" + existingTag.getStartLocationInFileOfId3Chunk());
        }
        return chunkHeader;
    }

    private boolean isAtEndOfFileAllowingForPaddingByte(AiffTag existingTag, FileChannel fc) throws IOException {
        return existingTag.getID3Tag().getEndLocationInFile() >= fc.size() || Utils.isOddLength(existingTag.getID3Tag().getEndLocationInFile()) && existingTag.getID3Tag().getEndLocationInFile() + 1L == fc.size();
    }

    public void delete(Tag tag, Path file) throws CannotWriteException {
        try (FileChannel fc = FileChannel.open(file, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            logger.severe(file + ":Deleting tag from file");
            AiffTag existingTag = this.getExistingMetadata(file);
            if (existingTag.isExistingId3Tag() && existingTag.getID3Tag().getStartLocationInFile() != null) {
                ChunkHeader chunkHeader = this.seekToStartOfMetadata(fc, existingTag, file.toString());
                if (this.isAtEndOfFileAllowingForPaddingByte(existingTag, fc)) {
                    logger.config(file + ":Setting new length to:" + existingTag.getStartLocationInFileOfId3Chunk());
                    fc.truncate(existingTag.getStartLocationInFileOfId3Chunk());
                } else {
                    logger.config(file + ":Deleting tag chunk");
                    this.deleteTagChunk(fc, existingTag, chunkHeader, file.toString());
                }
                this.rewriteRiffHeaderSize(fc);
            }
            logger.config(file + ":Deleted tag from file");
        }
        catch (IOException ioe) {
            throw new CannotWriteException(file + ":" + ioe.getMessage());
        }
    }

    private void deleteTagChunk(FileChannel fc, AiffTag existingTag, ChunkHeader tagChunkHeader, String fileName) throws IOException {
        int lengthTagChunk = (int)tagChunkHeader.getSize() + 8;
        if (Utils.isOddLength(lengthTagChunk) && existingTag.getStartLocationInFileOfId3Chunk() + (long)lengthTagChunk < fc.size()) {
            ++lengthTagChunk;
        }
        long newLength = fc.size() - (long)lengthTagChunk;
        logger.config(fileName + ":Size of id3 chunk to delete is:" + Hex.asDecAndHex(lengthTagChunk) + ":Location:" + Hex.asDecAndHex(existingTag.getStartLocationInFileOfId3Chunk()));
        fc.position(existingTag.getStartLocationInFileOfId3Chunk() + (long)lengthTagChunk);
        logger.severe(fileName + ":Moved location to:" + Hex.asDecAndHex(newLength));
        this.deleteTagChunkUsingSmallByteBufferSegments(existingTag, fc, newLength, lengthTagChunk);
        logger.config(fileName + ":Setting new length to:" + Hex.asDecAndHex(newLength));
        fc.truncate(newLength);
    }

    private void deleteRemainderOfFile(FileChannel fc, AiffTag existingTag, String fileName) throws IOException {
        ChunkSummary precedingChunk = AiffChunkSummary.getChunkBeforeStartingMetadataTag(existingTag);
        if (!Utils.isOddLength(precedingChunk.getEndLocation())) {
            logger.config(fileName + ":Truncating corrupted ID3 tags from:" + (existingTag.getStartLocationInFileOfId3Chunk() - 1L));
            fc.truncate(existingTag.getStartLocationInFileOfId3Chunk() - 1L);
        } else {
            logger.config(fileName + ":Truncating corrupted ID3 tags from:" + existingTag.getStartLocationInFileOfId3Chunk());
            fc.truncate(existingTag.getStartLocationInFileOfId3Chunk());
        }
    }

    private void deleteTagChunkUsingSmallByteBufferSegments(AiffTag existingTag, FileChannel channel, long newLength, long lengthTagChunk) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect((int)TagOptionSingleton.getInstance().getWriteChunkSize());
        while (channel.read(buffer) >= 0 || buffer.position() != 0) {
            buffer.flip();
            long readPosition = channel.position();
            channel.position(readPosition - lengthTagChunk - (long)buffer.limit());
            channel.write(buffer);
            channel.position(readPosition);
            buffer.compact();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(Tag tag, Path file) throws CannotWriteException {
        logger.severe(file + ":Writing Aiff tag to file");
        AiffTag existingTag = null;
        try {
            existingTag = this.getExistingMetadata(file);
        }
        catch (IOException ioe) {
            throw new CannotWriteException(file + ":" + ioe.getMessage());
        }
        try (FileChannel fc = FileChannel.open(file, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            long formFileLength = existingTag.getFormSize() + 8L;
            long currentPos = fc.position();
            if (formFileLength < fc.size() && !existingTag.isLastChunkSizeExtendsPastFormSize()) {
                logger.warning(file + ":Extra Non Chunk Data after end of FORM data length:" + (fc.size() - formFileLength));
                fc.position(formFileLength);
                fc.truncate(formFileLength);
                fc.position(currentPos);
            }
            AiffTag aiffTag = (AiffTag)tag;
            ByteBuffer bb = this.convert(aiffTag, existingTag);
            if (existingTag.isExistingId3Tag() && existingTag.getID3Tag().getStartLocationInFile() != null) {
                if (!existingTag.isIncorrectlyAlignedTag()) {
                    ChunkHeader chunkHeader = this.seekToStartOfMetadata(fc, existingTag, file.toString());
                    logger.config(file + ":Current Space allocated:" + existingTag.getSizeOfID3TagOnly() + ":NewTagRequires:" + bb.limit());
                    if (this.isAtEndOfFileAllowingForPaddingByte(existingTag, fc)) {
                        this.writeDataToFile(fc, bb);
                    } else {
                        this.deleteTagChunk(fc, existingTag, chunkHeader, file.toString());
                        fc.position(fc.size());
                        this.writeExtraByteIfChunkOddSize(fc, fc.size());
                        this.writeDataToFile(fc, bb);
                    }
                } else {
                    if (!AiffChunkSummary.isOnlyMetadataTagsAfterStartingMetadataTag(existingTag)) throw new CannotWriteException(file + ":Metadata tags are corrupted and not at end of file so cannot be fixed");
                    this.deleteRemainderOfFile(fc, existingTag, file.toString());
                    fc.position(fc.size());
                    this.writeExtraByteIfChunkOddSize(fc, fc.size());
                    this.writeDataToFile(fc, bb);
                }
            } else {
                fc.position(fc.size());
                if (Utils.isOddLength(fc.size())) {
                    fc.write(ByteBuffer.allocateDirect(1));
                }
                this.writeDataToFile(fc, bb);
            }
            this.rewriteRiffHeaderSize(fc);
            return;
        }
        catch (AccessDeniedException ade) {
            throw new NoWritePermissionsException(file + ":" + ade.getMessage());
        }
        catch (IOException ioe) {
            throw new CannotWriteException(file + ":" + ioe.getMessage());
        }
    }

    private void rewriteRiffHeaderSize(FileChannel fc) throws IOException {
        fc.position(IffHeaderChunk.SIGNATURE_LENGTH);
        ByteBuffer bb = ByteBuffer.allocateDirect(IffHeaderChunk.SIZE_LENGTH);
        bb.order(ByteOrder.BIG_ENDIAN);
        int size = (int)fc.size() - 8;
        bb.putInt(size);
        bb.flip();
        fc.write(bb);
    }

    private void writeDataToFile(FileChannel fc, ByteBuffer bb) throws IOException {
        ChunkHeader ch = new ChunkHeader(ByteOrder.BIG_ENDIAN);
        ch.setID(AiffChunkType.TAG.getCode());
        ch.setSize(bb.limit());
        fc.write(ch.writeHeader());
        fc.write(bb);
        this.writeExtraByteIfChunkOddSize(fc, bb.limit());
    }

    private void writeExtraByteIfChunkOddSize(FileChannel fc, long size) throws IOException {
        if (Utils.isOddLength(size)) {
            fc.write(ByteBuffer.allocateDirect(1));
        }
    }

    public ByteBuffer convert(AiffTag tag, AiffTag existingTag) throws UnsupportedEncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            long existingTagSize = existingTag.getSizeOfID3TagOnly();
            if (existingTagSize > 0L && Utils.isOddLength(existingTagSize)) {
                ++existingTagSize;
            }
            tag.getID3Tag().write(baos, (int)existingTagSize);
            if (Utils.isOddLength(baos.toByteArray().length)) {
                int newSize = baos.toByteArray().length + 1;
                baos = new ByteArrayOutputStream();
                tag.getID3Tag().write(baos, newSize);
            }
            ByteBuffer buf = ByteBuffer.wrap(baos.toByteArray());
            buf.rewind();
            return buf;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

