/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.jaudiotagger.audio.SupportedFileFormat;
import org.jaudiotagger.audio.aiff.AiffAudioHeader;
import org.jaudiotagger.audio.aiff.AiffFileHeader;
import org.jaudiotagger.audio.aiff.AiffType;
import org.jaudiotagger.audio.aiff.chunk.AiffChunkReader;
import org.jaudiotagger.audio.aiff.chunk.AiffChunkType;
import org.jaudiotagger.audio.aiff.chunk.AnnotationChunk;
import org.jaudiotagger.audio.aiff.chunk.ApplicationChunk;
import org.jaudiotagger.audio.aiff.chunk.AuthorChunk;
import org.jaudiotagger.audio.aiff.chunk.CommentsChunk;
import org.jaudiotagger.audio.aiff.chunk.CommonChunk;
import org.jaudiotagger.audio.aiff.chunk.CopyrightChunk;
import org.jaudiotagger.audio.aiff.chunk.FormatVersionChunk;
import org.jaudiotagger.audio.aiff.chunk.NameChunk;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.Chunk;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.audio.iff.IffHeaderChunk;
import org.jaudiotagger.logging.Hex;

public class AiffInfoReader
extends AiffChunkReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.aiff");
    private String loggingName;

    public AiffInfoReader(String loggingName) {
        this.loggingName = loggingName;
    }

    protected GenericAudioHeader read(Path file) throws CannotReadException, IOException {
        try (FileChannel fc = FileChannel.open(file, new OpenOption[0]);){
            logger.config(this.loggingName + ":Reading AIFF file size:" + Hex.asDecAndHex(fc.size()));
            AiffAudioHeader info = new AiffAudioHeader();
            AiffFileHeader fileHeader = new AiffFileHeader(this.loggingName);
            long noOfBytes = fileHeader.readHeader(fc, info);
            while (fc.position() < noOfBytes + 8L && fc.position() < fc.size()) {
                boolean result = this.readChunk(fc, info);
                if (result) continue;
                logger.severe(file + ":UnableToReadProcessChunk");
                break;
            }
            if (info.getFileType() == AiffType.AIFC) {
                info.setFormat(SupportedFileFormat.AIF.getDisplayName());
            } else {
                info.setFormat(SupportedFileFormat.AIF.getDisplayName());
            }
            this.calculateBitRate(info);
            AiffAudioHeader aiffAudioHeader = info;
            return aiffAudioHeader;
        }
    }

    private void calculateBitRate(GenericAudioHeader info) throws CannotReadException {
        if (info.getAudioDataLength() != null) {
            info.setBitRate((int)Math.round((double)(info.getAudioDataLength() * (long)Utils.BITS_IN_BYTE_MULTIPLIER) / (info.getPreciseTrackLength() * (double)Utils.KILOBYTE_MULTIPLIER)));
        }
    }

    private boolean readChunk(FileChannel fc, AiffAudioHeader aiffAudioHeader) throws IOException, CannotReadException {
        ChunkHeader chunkHeader = new ChunkHeader(ByteOrder.BIG_ENDIAN);
        if (!chunkHeader.readHeader(fc)) {
            return false;
        }
        logger.config(this.loggingName + ":Reading Next Chunk:" + chunkHeader.getID() + ":starting at:" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile()) + ":sizeIncHeader:" + Hex.asDecAndHex(chunkHeader.getSize() + 8L) + ":ending at:" + Hex.asDecAndHex(chunkHeader.getStartLocationInFile() + chunkHeader.getSize() + 8L));
        Chunk chunk = this.createChunk(fc, chunkHeader, aiffAudioHeader);
        if (chunk != null) {
            if (!chunk.readChunk()) {
                logger.severe(this.loggingName + ":ChunkReadFail:" + chunkHeader.getID());
                return false;
            }
        } else {
            if (chunkHeader.getSize() <= 0L) {
                String msg = this.loggingName + ":Not a valid header, unable to read a sensible size:Header" + chunkHeader.getID() + "Size:" + chunkHeader.getSize();
                logger.severe(msg);
                throw new CannotReadException(msg);
            }
            fc.position(fc.position() + chunkHeader.getSize());
        }
        IffHeaderChunk.ensureOnEqualBoundary(fc, chunkHeader);
        return true;
    }

    private Chunk createChunk(FileChannel fc, ChunkHeader chunkHeader, AiffAudioHeader aiffAudioHeader) throws IOException {
        Chunk chunk;
        AiffChunkType chunkType = AiffChunkType.get(chunkHeader.getID());
        if (chunkType != null) {
            switch (chunkType) {
                case FORMAT_VERSION: {
                    chunk = new FormatVersionChunk(chunkHeader, this.readChunkDataIntoBuffer(fc, chunkHeader), aiffAudioHeader);
                    break;
                }
                case APPLICATION: {
                    chunk = new ApplicationChunk(chunkHeader, this.readChunkDataIntoBuffer(fc, chunkHeader), aiffAudioHeader);
                    break;
                }
                case COMMON: {
                    chunk = new CommonChunk(chunkHeader, this.readChunkDataIntoBuffer(fc, chunkHeader), aiffAudioHeader);
                    break;
                }
                case COMMENTS: {
                    chunk = new CommentsChunk(chunkHeader, this.readChunkDataIntoBuffer(fc, chunkHeader), aiffAudioHeader);
                    break;
                }
                case NAME: {
                    chunk = new NameChunk(chunkHeader, this.readChunkDataIntoBuffer(fc, chunkHeader), aiffAudioHeader);
                    break;
                }
                case AUTHOR: {
                    chunk = new AuthorChunk(chunkHeader, this.readChunkDataIntoBuffer(fc, chunkHeader), aiffAudioHeader);
                    break;
                }
                case COPYRIGHT: {
                    chunk = new CopyrightChunk(chunkHeader, this.readChunkDataIntoBuffer(fc, chunkHeader), aiffAudioHeader);
                    break;
                }
                case ANNOTATION: {
                    chunk = new AnnotationChunk(chunkHeader, this.readChunkDataIntoBuffer(fc, chunkHeader), aiffAudioHeader);
                    break;
                }
                case SOUND: {
                    aiffAudioHeader.setAudioDataLength(chunkHeader.getSize());
                    aiffAudioHeader.setAudioDataStartPosition(fc.position());
                    aiffAudioHeader.setAudioDataEndPosition(fc.position() + chunkHeader.getSize());
                    chunk = null;
                    break;
                }
                default: {
                    chunk = null;
                    break;
                }
            }
        } else {
            chunk = null;
        }
        return chunk;
    }
}

