/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.SupportedFileFormat;
import org.jaudiotagger.audio.aiff.AiffFileReader;
import org.jaudiotagger.audio.aiff.AiffFileWriter;
import org.jaudiotagger.audio.asf.AsfFileReader;
import org.jaudiotagger.audio.asf.AsfFileWriter;
import org.jaudiotagger.audio.dff.DffFileReader;
import org.jaudiotagger.audio.dsf.DsfFileReader;
import org.jaudiotagger.audio.dsf.DsfFileWriter;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.flac.FlacFileReader;
import org.jaudiotagger.audio.flac.FlacFileWriter;
import org.jaudiotagger.audio.generic.AudioFileModificationListener;
import org.jaudiotagger.audio.generic.AudioFileReader;
import org.jaudiotagger.audio.generic.AudioFileWriter;
import org.jaudiotagger.audio.generic.ModificationHandler;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3FileReader;
import org.jaudiotagger.audio.mp3.MP3FileWriter;
import org.jaudiotagger.audio.mp4.Mp4FileReader;
import org.jaudiotagger.audio.mp4.Mp4FileWriter;
import org.jaudiotagger.audio.ogg.OggFileReader;
import org.jaudiotagger.audio.ogg.OggFileWriter;
import org.jaudiotagger.audio.real.RealFileReader;
import org.jaudiotagger.audio.wav.WavFileReader;
import org.jaudiotagger.audio.wav.WavFileWriter;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.TagException;

public class AudioFileIO {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio");
    private static AudioFileIO defaultInstance;
    private final ModificationHandler modificationHandler;
    private Map<String, AudioFileReader> readers = new HashMap<String, AudioFileReader>();
    private Map<String, AudioFileWriter> writers = new HashMap<String, AudioFileWriter>();

    public static void delete(AudioFile f) throws CannotReadException, CannotWriteException {
        AudioFileIO.getDefaultAudioFileIO().deleteTag(f);
    }

    public static AudioFileIO getDefaultAudioFileIO() {
        if (defaultInstance == null) {
            defaultInstance = new AudioFileIO();
        }
        return defaultInstance;
    }

    public static AudioFile readAs(File f, String ext) throws CannotReadException, IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        return AudioFileIO.getDefaultAudioFileIO().readFileAs(f, ext);
    }

    public static AudioFile readMagic(File f) throws CannotReadException, IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        return AudioFileIO.getDefaultAudioFileIO().readFileMagic(f);
    }

    public static AudioFile read(File f) throws CannotReadException, IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        return AudioFileIO.getDefaultAudioFileIO().readFile(f);
    }

    public static void write(AudioFile f) throws CannotWriteException {
        AudioFileIO.getDefaultAudioFileIO().writeFile(f, null);
    }

    public static void writeAs(AudioFile f, String targetPath) throws CannotWriteException {
        if (targetPath == null || targetPath.isEmpty()) {
            throw new CannotWriteException("Not a valid target path: " + targetPath);
        }
        AudioFileIO.getDefaultAudioFileIO().writeFile(f, targetPath);
    }

    public AudioFileIO() {
        this.modificationHandler = new ModificationHandler();
        this.prepareReadersAndWriters();
    }

    public void addAudioFileModificationListener(AudioFileModificationListener listener) {
        this.modificationHandler.addAudioFileModificationListener(listener);
    }

    public void deleteTag(AudioFile f) throws CannotReadException, CannotWriteException {
        String ext = Utils.getExtension(f.getFile());
        AudioFileWriter afw = this.writers.get(ext);
        if (afw == null) {
            throw new CannotWriteException(ErrorMessage.NO_DELETER_FOR_THIS_FORMAT.getMsg(ext));
        }
        afw.delete(f);
    }

    private void prepareReadersAndWriters() {
        this.readers.put(SupportedFileFormat.OGG.getFilesuffix(), new OggFileReader());
        this.readers.put(SupportedFileFormat.OGA.getFilesuffix(), new OggFileReader());
        this.readers.put(SupportedFileFormat.FLAC.getFilesuffix(), new FlacFileReader());
        this.readers.put(SupportedFileFormat.MP3.getFilesuffix(), new MP3FileReader());
        this.readers.put(SupportedFileFormat.MP4.getFilesuffix(), new Mp4FileReader());
        this.readers.put(SupportedFileFormat.M4A.getFilesuffix(), new Mp4FileReader());
        this.readers.put(SupportedFileFormat.M4P.getFilesuffix(), new Mp4FileReader());
        this.readers.put(SupportedFileFormat.M4B.getFilesuffix(), new Mp4FileReader());
        this.readers.put(SupportedFileFormat.WAV.getFilesuffix(), new WavFileReader());
        this.readers.put(SupportedFileFormat.WMA.getFilesuffix(), new AsfFileReader());
        this.readers.put(SupportedFileFormat.AIF.getFilesuffix(), new AiffFileReader());
        this.readers.put(SupportedFileFormat.AIFC.getFilesuffix(), new AiffFileReader());
        this.readers.put(SupportedFileFormat.AIFF.getFilesuffix(), new AiffFileReader());
        this.readers.put(SupportedFileFormat.DSF.getFilesuffix(), new DsfFileReader());
        this.readers.put(SupportedFileFormat.DFF.getFilesuffix(), new DffFileReader());
        RealFileReader realReader = new RealFileReader();
        this.readers.put(SupportedFileFormat.RA.getFilesuffix(), realReader);
        this.readers.put(SupportedFileFormat.RM.getFilesuffix(), realReader);
        this.writers.put(SupportedFileFormat.OGG.getFilesuffix(), new OggFileWriter());
        this.writers.put(SupportedFileFormat.OGA.getFilesuffix(), new OggFileWriter());
        this.writers.put(SupportedFileFormat.FLAC.getFilesuffix(), new FlacFileWriter());
        this.writers.put(SupportedFileFormat.MP3.getFilesuffix(), new MP3FileWriter());
        this.writers.put(SupportedFileFormat.MP4.getFilesuffix(), new Mp4FileWriter());
        this.writers.put(SupportedFileFormat.M4A.getFilesuffix(), new Mp4FileWriter());
        this.writers.put(SupportedFileFormat.M4P.getFilesuffix(), new Mp4FileWriter());
        this.writers.put(SupportedFileFormat.M4B.getFilesuffix(), new Mp4FileWriter());
        this.writers.put(SupportedFileFormat.WAV.getFilesuffix(), new WavFileWriter());
        this.writers.put(SupportedFileFormat.WMA.getFilesuffix(), new AsfFileWriter());
        this.writers.put(SupportedFileFormat.AIF.getFilesuffix(), new AiffFileWriter());
        this.writers.put(SupportedFileFormat.AIFC.getFilesuffix(), new AiffFileWriter());
        this.writers.put(SupportedFileFormat.AIFF.getFilesuffix(), new AiffFileWriter());
        this.writers.put(SupportedFileFormat.DSF.getFilesuffix(), new DsfFileWriter());
        for (AudioFileWriter curr : this.writers.values()) {
            curr.setAudioFileModificationListener(this.modificationHandler);
        }
    }

    public AudioFile readFile(File f) throws CannotReadException, IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        String ext = Utils.getExtension(f);
        AudioFileReader afr = this.readers.get(ext);
        if (afr == null) {
            throw new CannotReadException(ErrorMessage.NO_READER_FOR_THIS_FORMAT.getMsg(ext));
        }
        AudioFile tempFile = afr.read(f);
        tempFile.setExt(ext);
        return tempFile;
    }

    public AudioFile readFileMagic(File f) throws CannotReadException, IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        String ext = Utils.getMagicExtension(f);
        AudioFileReader afr = this.readers.get(ext);
        if (afr == null) {
            throw new CannotReadException(ErrorMessage.NO_READER_FOR_THIS_FORMAT.getMsg(ext));
        }
        AudioFile tempFile = afr.read(f);
        tempFile.setExt(ext);
        return tempFile;
    }

    public AudioFile readFileAs(File f, String ext) throws CannotReadException, IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        AudioFileReader afr = this.readers.get(ext);
        if (afr == null) {
            throw new CannotReadException(ErrorMessage.NO_READER_FOR_THIS_FORMAT.getMsg(ext));
        }
        AudioFile tempFile = afr.read(f);
        tempFile.setExt(ext);
        return tempFile;
    }

    public void checkFileExists(File file) throws FileNotFoundException {
        logger.config("Reading file:path" + file.getPath() + ":abs:" + file.getAbsolutePath());
        if (!file.exists()) {
            logger.severe("Unable to find:" + file.getPath());
            throw new FileNotFoundException(ErrorMessage.UNABLE_TO_FIND_FILE.getMsg(file.getPath()));
        }
    }

    public void removeAudioFileModificationListener(AudioFileModificationListener listener) {
        this.modificationHandler.removeAudioFileModificationListener(listener);
    }

    public void writeFile(AudioFile f, String targetPath) throws CannotWriteException {
        AudioFileWriter afw;
        String ext = f.getExt();
        if (targetPath != null && !targetPath.isEmpty()) {
            File destination = new File(targetPath + "." + ext);
            try {
                Utils.copyThrowsOnException(f.getFile(), destination);
                f.setFile(destination);
            }
            catch (IOException e) {
                throw new CannotWriteException("Error While Copying" + e.getMessage());
            }
        }
        if ((afw = this.writers.get(ext)) == null) {
            throw new CannotWriteException(ErrorMessage.NO_WRITER_FOR_THIS_FORMAT.getMsg(ext));
        }
        afw.write(f);
    }
}

