/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.generator.FrameGenerator;
import org.eclipse.jetty.http2.generator.HeaderGenerator;
import org.eclipse.jetty.http2.hpack.HpackEncoder;
import org.eclipse.jetty.http2.hpack.HpackException;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class PushPromiseGenerator
extends FrameGenerator {
    private final HpackEncoder encoder;

    public PushPromiseGenerator(HeaderGenerator headerGenerator, HpackEncoder encoder) {
        super(headerGenerator);
        this.encoder = encoder;
    }

    @Override
    public int generate(RetainableByteBuffer.Mutable accumulator, Frame frame) throws HpackException {
        PushPromiseFrame pushPromiseFrame = (PushPromiseFrame)frame;
        return this.generatePushPromise(accumulator, pushPromiseFrame.getStreamId(), pushPromiseFrame.getPromisedStreamId(), pushPromiseFrame.getMetaData());
    }

    public int generatePushPromise(RetainableByteBuffer.Mutable accumulator, int streamId, int promisedStreamId, MetaData metaData) throws HpackException {
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        if (promisedStreamId < 0) {
            throw new IllegalArgumentException("Invalid promised stream id: " + promisedStreamId);
        }
        RetainableByteBuffer hpack = this.encode(this.encoder, metaData);
        ByteBuffer hpackByteBuffer = hpack.getByteBuffer();
        BufferUtil.flipToFlush(hpackByteBuffer, 0);
        int hpackLength = hpackByteBuffer.remaining();
        int promisedStreamIdLength = 4;
        int length = hpackLength + promisedStreamIdLength;
        int flags = 4;
        this.generateHeader(accumulator, FrameType.PUSH_PROMISE, length, flags, streamId);
        accumulator.putInt(promisedStreamId);
        accumulator.add(hpack);
        return 9 + length;
    }
}

