/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.websocket.jakarta.common.messages;

import jakarta.websocket.CloseReason;
import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import java.lang.invoke.WrongMethodTypeException;
import java.nio.ByteBuffer;
import java.util.List;
import org.eclipse.jetty.ee10.websocket.jakarta.common.decoders.RegisteredDecoder;
import org.eclipse.jetty.ee10.websocket.jakarta.common.messages.AbstractDecodedMessageSink;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.exception.CloseException;
import org.eclipse.jetty.websocket.core.messages.ByteBufferMessageSink;
import org.eclipse.jetty.websocket.core.messages.MessageSink;
import org.eclipse.jetty.websocket.core.util.MethodHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecodedBinaryMessageSink<T>
extends AbstractDecodedMessageSink.Basic<Decoder.Binary<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(DecodedBinaryMessageSink.class);

    public DecodedBinaryMessageSink(CoreSession session, MethodHolder methodHolder, List<RegisteredDecoder> decoders) {
        super(session, methodHolder, decoders);
    }

    @Override
    MessageSink newMessageSink(CoreSession coreSession) {
        MethodHolder methodHolder = args -> {
            if (args.length != 1) {
                throw new WrongMethodTypeException(String.format("Expected %s params but had %s", 1, args.length));
            }
            this.onWholeMessage((ByteBuffer)args[0]);
            return null;
        };
        return new ByteBufferMessageSink(coreSession, methodHolder, true);
    }

    public void onWholeMessage(ByteBuffer wholeMessage) {
        for (Decoder.Binary decoder : this._decoders) {
            if (!decoder.willDecode(wholeMessage)) continue;
            try {
                Object obj = decoder.decode(wholeMessage);
                this.invoke(obj);
                return;
            }
            catch (DecodeException e) {
                throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Unable to decode", e);
            }
        }
        LOG.warn("Message lost, willDecode() has returned false for all decoders in the decoder list.");
    }
}

