/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.webapp;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.eclipse.jetty.ee.webapp.WebAppClassLoader;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.FragmentConfiguration;
import org.eclipse.jetty.ee10.webapp.MetaInfConfiguration;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.ee10.webapp.WebXmlConfiguration;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.Resources;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebXmlConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(JettyWebXmlConfiguration.class);
    public static final String PROPERTY_WEB_INF_URI = "web-inf.uri";
    public static final String PROPERTY_WEB_INF = "web-inf";
    public static final String XML_CONFIGURATION = "org.eclipse.jetty.webapp.JettyWebXmlConfiguration";
    public static final String JETTY_WEB_XML = "jetty-web.xml";
    public static final String JETTY_EE10_WEB_XML = "jetty-ee10-web.xml";

    public JettyWebXmlConfiguration() {
        super(new AbstractConfiguration.Builder().addDependencies(WebXmlConfiguration.class, FragmentConfiguration.class, MetaInfConfiguration.class));
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        Resource webInf;
        Resource jetty;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring web-jetty.xml");
        }
        if (Resources.isReadableFile(jetty = this.resolveJettyWebXml(webInf = context.getWebInf()))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Configure: {}", (Object)jetty);
            }
            Object xmlAttr = context.getAttribute(XML_CONFIGURATION);
            context.removeAttribute(XML_CONFIGURATION);
            XmlConfiguration jetty_config = xmlAttr instanceof XmlConfiguration ? (XmlConfiguration)xmlAttr : new XmlConfiguration(jetty);
            this.setupXmlConfiguration(context, jetty_config, webInf);
            try {
                WebAppClassLoader.runWithHiddenClassAccess(() -> {
                    jetty_config.configure(context);
                    return null;
                });
            }
            catch (Exception e) {
                LOG.warn("Error applying {}", (Object)jetty);
                throw e;
            }
        }
    }

    private Resource resolveJettyWebXml(Resource webInf) {
        String xmlFile = JETTY_EE10_WEB_XML;
        try {
            if (webInf == null || !webInf.isDirectory()) {
                return null;
            }
            Resource jetty = webInf.resolve(xmlFile);
            if (!Resources.missing(jetty)) {
                return jetty;
            }
            xmlFile = JETTY_WEB_XML;
            jetty = webInf.resolve(xmlFile);
            if (!Resources.missing(jetty)) {
                return jetty;
            }
            return null;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error resolving WEB-INF/" + xmlFile, e);
            }
            return null;
        }
    }

    private void setupXmlConfiguration(WebAppContext context, XmlConfiguration jettyConfig, Resource webInf) throws IOException {
        jettyConfig.setJettyStandardIdsAndProperties(context.getServer(), null);
        Map<String, String> props = jettyConfig.getProperties();
        URI uri = webInf.getURI();
        if (uri == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to obtain unique URI for location of WEB-INF from {}", (Object)webInf.toString());
            }
            return;
        }
        props.put(PROPERTY_WEB_INF_URI, XmlConfiguration.normalizeURI(uri.toString()));
        props.put(PROPERTY_WEB_INF, webInf.toString());
    }
}

