/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.transport.internal;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.client.Connection;
import org.eclipse.jetty.client.Destination;
import org.eclipse.jetty.client.HttpUpgrader;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.internal.TunnelRequest;
import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpConnection;
import org.eclipse.jetty.client.transport.HttpConversation;
import org.eclipse.jetty.client.transport.HttpDestination;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpRequest;
import org.eclipse.jetty.client.transport.IConnection;
import org.eclipse.jetty.client.transport.SendFailure;
import org.eclipse.jetty.client.transport.internal.HttpChannelOverHTTP;
import org.eclipse.jetty.client.transport.internal.HttpReceiverOverHTTP;
import org.eclipse.jetty.client.transport.internal.ProtocolHttpUpgrader;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Attachable;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Sweeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectionOverHTTP
extends AbstractConnection
implements IConnection,
Connection.UpgradeFrom,
Sweeper.Sweepable,
Attachable,
Invocable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConnectionOverHTTP.class);
    private final Callback fillableCallback = new FillableCallback();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicInteger sweeps = new AtomicInteger();
    private final Promise<Connection> promise;
    private final Delegate delegate;
    private final HttpChannelOverHTTP channel;
    private final LongAdder bytesIn = new LongAdder();
    private final LongAdder bytesOut = new LongAdder();
    private final Invocable.InvocationType invocationType;
    private long idleTimeout;
    private boolean initialize;

    public HttpConnectionOverHTTP(EndPoint endPoint, Map<String, Object> context) {
        this(endPoint, HttpConnectionOverHTTP.destinationFrom(context), HttpConnectionOverHTTP.promiseFrom(context));
    }

    private static HttpDestination destinationFrom(Map<String, Object> context) {
        return (HttpDestination)context.get(Destination.CONTEXT_KEY);
    }

    private static Promise<Connection> promiseFrom(Map<String, Object> context) {
        return (Promise)context.get(Connection.PROMISE_CONTEXT_KEY);
    }

    public HttpConnectionOverHTTP(EndPoint endPoint, HttpDestination destination, Promise<Connection> promise) {
        super(endPoint, destination.getHttpClient().getExecutor());
        this.promise = promise;
        this.delegate = new Delegate(destination);
        this.channel = this.newHttpChannel();
        this.invocationType = destination.getHttpClient().getHttpClientTransport().getInvocationType();
    }

    protected HttpChannelOverHTTP newHttpChannel() {
        return new HttpChannelOverHTTP(this);
    }

    public HttpChannelOverHTTP getHttpChannel() {
        return this.channel;
    }

    public HttpDestination getHttpDestination() {
        return this.delegate.getHttpDestination();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.delegate.getLocalSocketAddress();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.delegate.getRemoteSocketAddress();
    }

    @Override
    public EndPoint.SslSessionData getSslSessionData() {
        return this.delegate.getSslSessionData();
    }

    @Override
    public long getBytesIn() {
        return this.bytesIn.longValue();
    }

    protected void addBytesIn(long bytesIn) {
        this.bytesIn.add(bytesIn);
    }

    @Override
    public long getBytesOut() {
        return this.bytesOut.longValue();
    }

    protected void addBytesOut(long bytesOut) {
        this.bytesOut.add(bytesOut);
    }

    @Override
    public long getMessagesIn() {
        return this.getHttpChannel().getMessagesIn();
    }

    @Override
    public long getMessagesOut() {
        return this.getHttpChannel().getMessagesOut();
    }

    @Override
    public void send(Request request, Response.CompleteListener listener) {
        this.delegate.send(request, listener);
    }

    @Override
    public SendFailure send(HttpExchange exchange) {
        return this.delegate.send(exchange);
    }

    public boolean isInitialize() {
        return this.initialize;
    }

    public void setInitialize(boolean initialize) {
        this.initialize = initialize;
    }

    @Override
    public Invocable.InvocationType getInvocationType() {
        return this.invocationType;
    }

    @Override
    public void fillInterested() {
        this.fillInterested(this.fillableCallback);
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.fillInterested();
        boolean initialize = this.isInitialize();
        if (initialize) {
            HttpDestination destination = this.getHttpDestination();
            Request request = destination.getHttpClient().newRequest(destination.getOrigin().asString()).method(HttpMethod.OPTIONS).path("*");
            this.send(request, result -> {
                if (result.isSucceeded()) {
                    this.promise.succeeded(this);
                } else {
                    this.promise.failed(result.getFailure());
                }
            });
        } else {
            this.promise.succeeded(this);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void setAttachment(Object obj) {
        this.delegate.setAttachment(obj);
    }

    @Override
    public Object getAttachment() {
        return this.delegate.getAttachment();
    }

    @Override
    public boolean onIdleExpired(TimeoutException timeout) {
        long idleTimeout = this.getEndPoint().getIdleTimeout();
        boolean close = this.onIdleTimeout(idleTimeout);
        if (close) {
            this.close(timeout);
        }
        return false;
    }

    protected boolean onIdleTimeout(long idleTimeout) {
        TimeoutException failure = new TimeoutException("Idle timeout " + idleTimeout + " ms");
        return this.delegate.onIdleTimeout(idleTimeout, failure);
    }

    @Override
    public void onFillable() {
        this.channel.receive();
    }

    @Override
    public ByteBuffer onUpgradeFrom() {
        HttpReceiverOverHTTP receiver = this.channel.getHttpReceiver();
        return receiver.onUpgradeFrom();
    }

    void onResponseHeaders(HttpExchange exchange) {
        HttpRequest request = exchange.getRequest();
        if (request instanceof TunnelRequest) {
            this.getEndPoint().setIdleTimeout(this.idleTimeout);
        }
    }

    public void release() {
        this.getEndPoint().setIdleTimeout(this.idleTimeout);
        this.getHttpDestination().release(this);
    }

    public void remove() {
        this.getHttpDestination().remove(this);
    }

    @Override
    public void close() {
        this.close(new AsynchronousCloseException());
    }

    protected void close(Throwable failure) {
        if (this.closed.compareAndSet(false, true)) {
            this.getHttpDestination().remove(this);
            this.abort(failure, Promise.noop());
            this.channel.destroy();
            this.delegate.destroy();
            this.getEndPoint().shutdownOutput();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Shutdown {}", (Object)this);
            }
            this.getEndPoint().close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closed {}", (Object)this);
            }
        }
    }

    protected void abort(Throwable failure, Promise<Boolean> promise) {
        HttpExchange exchange = this.channel.getHttpExchange();
        if (exchange != null) {
            Promise.completeWith(promise, exchange.getRequest().abort(failure));
        } else {
            promise.succeeded(false);
        }
    }

    @Override
    public boolean sweep() {
        if (!this.closed.get()) {
            return false;
        }
        return this.sweeps.incrementAndGet() > 3;
    }

    @Override
    public String toConnectionString() {
        return String.format("%s@%x(l:%s <-> r:%s,closed=%b)=>%s", TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getEndPoint().getLocalSocketAddress(), this.getEndPoint().getRemoteSocketAddress(), this.closed.get(), this.channel);
    }

    private class FillableCallback
    implements Callback {
        private FillableCallback() {
        }

        @Override
        public void succeeded() {
            HttpConnectionOverHTTP.this.onFillable();
        }

        @Override
        public void failed(Throwable x) {
            HttpConnectionOverHTTP.this.onFillInterestedFailed(x);
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return HttpConnectionOverHTTP.this.getInvocationType();
        }
    }

    private class Delegate
    extends HttpConnection {
        private Delegate(HttpDestination destination) {
            super(destination);
        }

        @Override
        protected Iterator<HttpChannel> getHttpChannels() {
            return Collections.singleton(HttpConnectionOverHTTP.this.channel).iterator();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return HttpConnectionOverHTTP.this.getEndPoint().getLocalSocketAddress();
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return HttpConnectionOverHTTP.this.getEndPoint().getRemoteSocketAddress();
        }

        @Override
        public EndPoint.SslSessionData getSslSessionData() {
            return HttpConnectionOverHTTP.this.getEndPoint().getSslSessionData();
        }

        @Override
        public SendFailure send(HttpExchange exchange) {
            HttpRequest request = exchange.getRequest();
            this.normalizeRequest(request);
            EndPoint endPoint = HttpConnectionOverHTTP.this.getEndPoint();
            HttpConnectionOverHTTP.this.idleTimeout = endPoint.getIdleTimeout();
            long requestIdleTimeout = request.getIdleTimeout();
            if (requestIdleTimeout >= 0L) {
                endPoint.setIdleTimeout(requestIdleTimeout);
            }
            return this.send(HttpConnectionOverHTTP.this.channel, exchange);
        }

        @Override
        protected void normalizeRequest(HttpRequest request) {
            HttpConversation conversation;
            HttpUpgrader upgrader;
            super.normalizeRequest(request);
            if (request instanceof TunnelRequest) {
                request.idleTimeout(2L * this.getHttpClient().getConnectTimeout(), TimeUnit.MILLISECONDS);
            }
            if ((upgrader = (HttpUpgrader)(conversation = request.getConversation()).getAttribute(HttpUpgrader.class.getName())) == null) {
                HttpUpgrader.Factory upgraderFactory = (HttpUpgrader.Factory)request.getAttributes().get(HttpUpgrader.Factory.class.getName());
                if (upgraderFactory != null) {
                    upgrader = upgraderFactory.newHttpUpgrader(HttpVersion.HTTP_1_1);
                    conversation.setAttribute(HttpUpgrader.class.getName(), upgrader);
                    upgrader.prepare(request);
                } else {
                    String protocol = request.getHeaders().get(HttpHeader.UPGRADE);
                    if (protocol != null) {
                        upgrader = new ProtocolHttpUpgrader(this.getHttpDestination(), protocol);
                        conversation.setAttribute(HttpUpgrader.class.getName(), upgrader);
                        upgrader.prepare(request);
                    }
                }
            }
        }

        @Override
        public void close() {
            HttpConnectionOverHTTP.this.close();
        }

        @Override
        public boolean isClosed() {
            return HttpConnectionOverHTTP.this.isClosed();
        }

        @Override
        public String toString() {
            return HttpConnectionOverHTTP.this.toString();
        }
    }
}

