/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public enum VideoClassification {
    MOVIE,
    SERIES,
    TV_PROGRAM,
    UNRELEASED;


    public String toString() {
        return switch (this) {
            case MOVIE -> "Movie";
            case SERIES -> "Series";
            case TV_PROGRAM -> "TV Program";
            case UNRELEASED -> "Unreleased/Home Made";
            default -> this.name();
        };
    }

    public static VideoClassification typeOf(String videoClassification) {
        if (StringUtils.isBlank(videoClassification)) {
            return null;
        }
        if ((videoClassification = videoClassification.toLowerCase(Locale.ROOT)).contains("serie") || videoClassification.contains("episode")) {
            return SERIES;
        }
        if (videoClassification.contains("movie") || videoClassification.contains("film")) {
            return MOVIE;
        }
        if (videoClassification.matches(".*\\btv\\b.*")) {
            return TV_PROGRAM;
        }
        if (videoClassification.contains("unreleased") || videoClassification.contains("private") || videoClassification.matches(".*home(?:\\s*|-)(?:made|video)")) {
            return UNRELEASED;
        }
        return null;
    }
}

