/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.util.Arrays;

public final class Version
implements Comparable<Version> {
    private static final int MAX_ELEMENTS = 4;
    private final int[] elements;

    public Version(String versionString) {
        if (versionString == null) {
            throw new NullPointerException("Version string can not be null");
        }
        this.elements = this.parse(versionString.split("\\.", 4));
    }

    private int[] parse(String[] elements) {
        int[] out = new int[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            try {
                out[i] = Integer.parseInt(elements[i]);
                continue;
            }
            catch (NumberFormatException e) {
                out[i] = 0;
            }
        }
        return out;
    }

    @Override
    public int compareTo(Version other) {
        int sign;
        int[] shorterElements;
        int[] longerElements;
        if (this.elements.length >= other.elements.length) {
            longerElements = this.elements;
            shorterElements = other.elements;
            sign = 1;
        } else {
            longerElements = other.elements;
            shorterElements = this.elements;
            sign = -1;
        }
        for (int i = 0; i < longerElements.length; ++i) {
            int val;
            int n = val = i < shorterElements.length ? shorterElements[i] : 0;
            if (longerElements[i] == val) continue;
            return (longerElements[i] - val) * sign;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (other instanceof Version) {
            Version version = (Version)other;
            return this.compareTo(version) == 0;
        }
        return false;
    }

    public boolean isLessThan(Version other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLessThanOrEqualTo(Version other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isGreaterThan(Version other) {
        return this.compareTo(other) > 0;
    }

    public boolean isGreaterThanOrEqualTo(Version other) {
        return this.compareTo(other) >= 0;
    }

    public int getMajor() {
        if (this.elements.length > 0) {
            return this.elements[0];
        }
        return 0;
    }

    public int getMinor() {
        if (this.elements.length > 1) {
            return this.elements[1];
        }
        return 0;
    }

    public int getRevision() {
        if (this.elements.length > 2) {
            return this.elements[2];
        }
        return 0;
    }

    public int getBuild() {
        if (this.elements.length > 3) {
            return this.elements[3];
        }
        return 0;
    }

    private int[] getCanonicalElements() {
        int[] canonicalElements;
        int canonicalElementsLength = 1;
        for (int i = this.elements.length - 1; i > 0; --i) {
            if (this.elements[i] == 0) continue;
            canonicalElementsLength = i + 1;
            break;
        }
        if (canonicalElementsLength == this.elements.length) {
            canonicalElements = this.elements;
        } else {
            canonicalElements = new int[canonicalElementsLength];
            System.arraycopy(this.elements, 0, canonicalElements, 0, canonicalElementsLength);
        }
        return canonicalElements;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getCanonicalElements());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.elements.length > 0) {
            buf.append(this.elements[0]);
        }
        for (int i = 1; i < this.elements.length; ++i) {
            buf.append('.').append(this.elements[i]);
        }
        return buf.toString();
    }
}

