/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import jakarta.annotation.Nullable;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.pms.PMS;
import net.pms.platform.PlatformUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessUtil.class);

    private ProcessUtil() {
    }

    public static int waitFor(Process p) {
        int exit = -1;
        try {
            exit = p.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return exit;
    }

    public static long getProcessId(@Nullable Process process) {
        if (process == null) {
            return 0L;
        }
        try {
            return process.pid();
        }
        catch (UnsupportedOperationException e) {
            return 0L;
        }
    }

    public static boolean isProcessIsAlive(@Nullable Process process) {
        if (process == null) {
            return false;
        }
        return process.isAlive();
    }

    public static void destroy(Process p) {
        if (p != null) {
            PlatformUtils.INSTANCE.destroyProcess(p);
        }
    }

    public static String getSystemPathName(File file) {
        if (file == null) {
            return null;
        }
        return ProcessUtil.getSystemPathName(file.getPath());
    }

    public static String getSystemPathName(String name) {
        return PlatformUtils.INSTANCE.getSystemPathName(name);
    }

    public static String run(int[] expectedExitCodes, String ... cmd) {
        try {
            StringBuilder output;
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.redirectErrorStream(true);
            Process p = pb.start();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String line;
                output = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    output.append(line).append("\n");
                }
            }
            p.waitFor();
            boolean expected = false;
            if (expectedExitCodes != null) {
                for (int expectedCode : expectedExitCodes) {
                    if (expectedCode != p.exitValue()) continue;
                    expected = true;
                    break;
                }
            }
            if (!expected) {
                LOGGER.debug("Warning: command {} returned {}", (Object)Arrays.toString(cmd), (Object)p.exitValue());
            }
            return output.toString();
        }
        catch (IOException e) {
            LOGGER.error("Error running command " + Arrays.toString(cmd), e);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        return "";
    }

    public static String run(String ... cmd) {
        int[] zeroExpected = new int[]{0};
        return ProcessUtil.run(zeroExpected, cmd);
    }

    public static String dbgWashCmds(String[] cmd) {
        StringBuilder sb = new StringBuilder();
        boolean prevHeader = false;
        for (String argument : cmd) {
            String modifiedArgument;
            if (!StringUtils.isNotBlank(argument)) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            if (prevHeader) {
                modifiedArgument = argument.replaceAll("Authorization: [^\n]+\n", "Authorization: ****\n");
                prevHeader = false;
            } else {
                if (argument.contains("headers")) {
                    prevHeader = true;
                }
                modifiedArgument = argument;
            }
            if (modifiedArgument.contains(" ")) {
                sb.append("\"").append(modifiedArgument).append("\"");
                continue;
            }
            sb.append(modifiedArgument);
        }
        return sb.toString();
    }

    public static void reboot() {
        ProcessUtil.reboot((List<String>)null, null, null, new String[0]);
    }

    public static void reboot(String ... umsoptions) {
        ProcessUtil.reboot(null, null, null, umsoptions);
    }

    public static void reboot(List<String> cmd, Map<String, String> env, String startdir, String ... umsOptions) {
        boolean hasOption = umsOptions.length > 0;
        List<String> reboot = PlatformUtils.INSTANCE.getRestartCommand(hasOption);
        if (hasOption) {
            reboot.addAll(Arrays.asList(umsOptions));
        }
        if (cmd == null) {
            cmd = reboot;
        } else {
            if (env == null) {
                env = new HashMap<String, String>();
            }
            env.put("RESTART_CMD", StringUtils.join(reboot, " "));
            env.put("RESTART_DIR", System.getProperty("user.dir"));
        }
        if (startdir == null) {
            startdir = System.getProperty("user.dir");
        }
        ProcessBuilder pb = new ProcessBuilder(cmd);
        if (env != null) {
            pb.environment().putAll(env);
        }
        pb.directory(new File(startdir));
        try {
            LOGGER.info("Starting: " + StringUtils.join(cmd, " "));
            LOGGER.info("In folder: " + String.valueOf(pb.directory()));
            PMS.shutdown();
            pb.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PMS.quit();
    }

    public static void shutDownComputer() {
        String[] shutdownCommand = PlatformUtils.INSTANCE.getShutdownCommand();
        if (shutdownCommand != null && shutdownCommand.length > 0) {
            try {
                Runtime.getRuntime().exec(shutdownCommand);
                System.exit(0);
            }
            catch (IOException e) {
                LOGGER.error("Error while shutting down computer: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

