/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Map;

public class Pair<K, V>
implements Map.Entry<K, V>,
Comparable<Pair<K, V>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final K first;
    protected final V second;

    public Pair(K first, V second) {
        this.first = first;
        this.second = second;
    }

    public K getFirst() {
        return this.first;
    }

    @Override
    public K getKey() {
        return this.first;
    }

    public K getLeft() {
        return this.first;
    }

    public V getSecond() {
        return this.second;
    }

    public V getLast() {
        return this.second;
    }

    @Override
    public V getValue() {
        return this.second;
    }

    public V getRight() {
        return this.second;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException("Pair is immutable");
    }

    @Override
    public int compareTo(Pair<K, V> o) {
        if (this.first == null) {
            if (o.first != null) {
                return 1;
            }
        } else if (o.first == null) {
            return -1;
        }
        if (!(this.first instanceof Comparable) || !(o.first instanceof Comparable)) {
            throw new UnsupportedOperationException("K must implement Comparable");
        }
        int result = ((Comparable)this.first).compareTo(o.first);
        if (result != 0) {
            return result;
        }
        if (this.second == null) {
            if (o.second != null) {
                return 1;
            }
        } else if (o.second == null) {
            return -1;
        }
        if (!(this.second instanceof Comparable) || !(o.second instanceof Comparable)) {
            throw new UnsupportedOperationException("V must implement Comparable");
        }
        return ((Comparable)this.second).compareTo(o.second);
    }

    @Override
    public int hashCode() {
        return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Map.Entry)) {
            return false;
        }
        Map.Entry other = (Map.Entry)obj;
        return Objects.equal(this.getKey(), other.getKey()) && Objects.equal(this.getValue(), other.getValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[");
        if (this.getFirst() == null) {
            sb.append("null");
        } else if (this.getFirst() instanceof CharSequence) {
            sb.append("\"").append(this.getFirst()).append("\"");
        } else {
            sb.append(this.getFirst());
        }
        sb.append(", ");
        if (this.getSecond() == null) {
            sb.append("null");
        } else if (this.getSecond() instanceof CharSequence) {
            sb.append("\"").append(this.getSecond()).append("\"");
        } else {
            sb.append(this.getSecond());
        }
        sb.append("]");
        return sb.toString();
    }
}

