/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.IOException;
import net.pms.util.FlowParserOutputStream;
import net.pms.util.PCMAudioOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IEC61937AudioOutputStream
extends FlowParserOutputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(IEC61937AudioOutputStream.class);
    private static final int[] BITS = new int[]{16, 16, 20, 20, 0, 24, 24};
    private static final int[] SAMPLE_RATES = new int[]{0, 8000, 16000, 32000, 0, 0, 11025, 22050, 44100, 0, 0, 12000, 24000, 48000, 96000, 192000};
    private final PCMAudioOutputStream out;
    private final boolean usepreamble;
    private boolean ac3 = false;
    private boolean dts = false;
    private boolean dtsHD = false;
    private int framesize;
    private int padding;
    private byte[] preamble;
    private byte[] dtshdpreamble;
    private int period;

    public IEC61937AudioOutputStream(PCMAudioOutputStream out) {
        super(out, 600000);
        this.out = out;
        out.swapOrderBits = 0;
        this.neededByteNumber = 5000;
        this.usepreamble = true;
    }

    @Override
    protected void afterChunkSend() throws IOException {
        this.padWithZeros(this.padding);
    }

    @Override
    protected void analyzeBuffer(byte[] data, int off, int len) {
        block29: {
            block32: {
                block31: {
                    block30: {
                        if (data[off + 0] != 100 || data[off + 1] != 88 || data[off + 2] != 32 || data[off + 3] != 37) break block30;
                        LOGGER.trace("DTS-HD stray frame, skipping this one...");
                        this.streamableByteNumber = ((data[off + 6] & 0xF) << 11) + ((data[off + 7] & 0xFF) << 3) + ((data[off + 8] & 0xF0) >> 5) + 1;
                        this.discard = true;
                        break block29;
                    }
                    if (data[off + 0] != 127 || data[off + 1] != -2 || data[off + 2] != -128 || data[off + 3] != 1) break block31;
                    this.discard = false;
                    this.dts = true;
                    this.streamableByteNumber = this.framesize;
                    if (this.framesize != 0 && !this.dtsHD) break block29;
                    int blocks = ((data[off + 4] & 1) << 6) + ((data[off + 5] & 0xFC) >> 2);
                    int sampleRate = SAMPLE_RATES[data[off + 8] >> 2 & 0xF];
                    this.framesize = ((data[off + 5] & 3) << 12) + ((data[off + 6] & 0xFF) << 4) + ((data[off + 7] & 0xF0) >> 4) + 1;
                    int framesizeSup = 0;
                    int dtsRate = 48000;
                    boolean skipDtsHd = true;
                    if (!skipDtsHd && off + this.framesize + 3 < data.length && data[off + this.framesize] == 100 && data[off + this.framesize + 1] == 88 && data[off + this.framesize + 2] == 32 && data[off + this.framesize + 3] == 37) {
                        this.dtsHD = true;
                        dtsRate = 192000;
                        framesizeSup = ((data[off + this.framesize + 6] & 0xF) << 11) + ((data[off + this.framesize + 7] & 0xFF) << 3) + ((data[off + this.framesize + 8] & 0xF0) >> 5) + 1;
                        this.framesize += framesizeSup;
                    }
                    int pcmWrappedFrameSize = ++blocks << 7;
                    if (this.usepreamble && this.preamble == null) {
                        int bitspersample = ((data[off + 11] & 1) << 2) + ((data[off + 12] & 0xFC) >> 6);
                        if (bitspersample < 7) {
                            LOGGER.trace("DTS bits per sample: " + BITS[bitspersample]);
                        }
                        this.preamble = new byte[8];
                        this.preamble[1] = 114;
                        this.preamble[0] = -8;
                        this.preamble[3] = 31;
                        this.preamble[2] = 78;
                        if (this.dtsHD) {
                            this.preamble[4] = 0;
                            this.preamble[5] = 17;
                        } else {
                            this.preamble[4] = 0;
                            switch (blocks) {
                                case 16: {
                                    this.preamble[5] = 11;
                                    break;
                                }
                                case 32: {
                                    this.preamble[5] = 12;
                                    break;
                                }
                                case 64: {
                                    this.preamble[5] = 13;
                                    break;
                                }
                            }
                        }
                        if (this.dtsHD) {
                            int subtype;
                            this.period = dtsRate * (blocks << 5) / sampleRate;
                            this.preamble[4] = subtype = (switch (this.period) {
                                case 512 -> 0;
                                case 1024 -> 1;
                                case 2048 -> 2;
                                case 4096 -> 3;
                                case 8192 -> 4;
                                case 16384 -> 5;
                                default -> 0;
                            });
                            this.dtshdpreamble = new byte[12];
                            this.dtshdpreamble[0] = 1;
                            this.dtshdpreamble[8] = -2;
                            this.dtshdpreamble[9] = -2;
                        }
                    }
                    if (this.out.sampleFrequency != dtsRate || this.out.nbchannels != 2 || this.out.bitsperSample != 16) {
                        this.out.nbchannels = 2;
                        this.out.sampleFrequency = dtsRate;
                        this.out.bitsperSample = 16;
                        this.out.init();
                    }
                    if (this.dtsHD) {
                        pcmWrappedFrameSize = this.period * 4;
                    }
                    if (this.framesize > pcmWrappedFrameSize) {
                        this.framesize -= framesizeSup;
                    }
                    this.streamableByteNumber = this.framesize;
                    if (this.dtshdpreamble != null) {
                        this.dtshdpreamble[11] = (byte)(this.framesize & 0xFF);
                        this.dtshdpreamble[10] = (byte)(this.framesize >> 8 & 0xFF);
                        this.framesize += this.dtshdpreamble.length;
                    }
                    if (this.preamble != null) {
                        int framesizeBits = this.framesize * 8;
                        this.preamble[7] = (byte)(framesizeBits & 0xFF);
                        this.preamble[6] = (byte)(framesizeBits >> 8 & 0xFF);
                    }
                    this.padding = pcmWrappedFrameSize - this.framesize - (this.preamble != null ? this.preamble.length : 0);
                    break block29;
                }
                if (data[off + 0] != 11 || data[off + 1] != 119) break block32;
                this.ac3 = true;
                this.discard = false;
                this.streamableByteNumber = this.framesize;
                if (this.framesize != 0) break block29;
                this.discard = true;
                byte a0 = data[off + 0];
                byte a1 = data[off + 1];
                LOGGER.debug("Looking for AC3 framesize");
                for (int i = 4; i < len - 4; ++i) {
                    if (data[off + i] != a0 || data[off + i + 1] != a1) continue;
                    this.streamableByteNumber = this.framesize = i;
                    int pcmWrappedFrameSize = 6144;
                    if (this.out != null) {
                        PCMAudioOutputStream pout = this.out;
                        pout.nbchannels = 2;
                        pout.sampleFrequency = 48000;
                        pout.bitsperSample = 16;
                        pout.init();
                    }
                    if (this.usepreamble) {
                        this.preamble = new byte[8];
                        this.padding = pcmWrappedFrameSize - this.framesize - this.preamble.length;
                        this.preamble[1] = 114;
                        this.preamble[0] = -8;
                        this.preamble[3] = 31;
                        this.preamble[2] = 78;
                        this.preamble[5] = 1;
                        this.preamble[4] = 0;
                        int framesizeBits = this.framesize * 8;
                        this.preamble[7] = (byte)(framesizeBits % 256);
                        this.preamble[6] = (byte)(framesizeBits / 256);
                    } else {
                        this.padding = pcmWrappedFrameSize - this.framesize;
                    }
                    LOGGER.debug("AC3 spdif framesize: " + this.framesize + " / padding: " + this.padding + " preamble[6]: " + this.preamble[6]);
                    this.discard = false;
                    break block29;
                }
                break block29;
            }
            for (int i = 3; i < 2020; ++i) {
                if ((data.length <= i || data[i - 3] != 127 || data[i - 2] != -2 || data[i - 1] != -128 || data[i] != 1) && (data.length <= i || data[i - 3] != 100 || data[i - 2] != 88 || data[i - 1] != 32 || data[i] != 37)) continue;
                this.discard = true;
                this.streamableByteNumber = i - 3;
                break;
            }
        }
    }

    @Override
    protected void beforeChunkSend() throws IOException {
        if (this.preamble != null) {
            this.writePayload(this.preamble);
        }
        if (this.dtshdpreamble != null) {
            this.writePayload(this.dtshdpreamble);
        }
    }

    public boolean isAc3() {
        return this.ac3;
    }

    public boolean isDts() {
        return this.dts;
    }

    public boolean isDtsHD() {
        return this.dtsHD;
    }
}

