/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.pms.Messages;
import net.pms.image.BufferedImageFilter;
import net.pms.image.NonGeometricBufferedImageOp;
import net.pms.media.MediaType;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullyPlayed {
    private static final Logger LOGGER = LoggerFactory.getLogger(FullyPlayed.class);
    private static final String THUMBNAIL_OVERLAY_RESOURCE_PATH = "/resources/images/store/fullyplayed-overlay.png";
    private static final Color THUMBNAIL_OVERLAY_BACKGROUND_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.5f);
    private static final int BLANK_IMAGE_RESOLUTION = 256;
    private static final BufferedImage THUMBNAIL_OVERLAY_IMAGE = FullyPlayed.getThumbnailOverlayImage();
    private static final FullyPlayerOverlayFilter OVERLAY_FILTER_INSTANCE = new FullyPlayerOverlayFilter(StoreResource.THUMBNAIL_HINTS);

    private FullyPlayed() {
    }

    public static BufferedImageFilter getOverlayFilter() {
        return OVERLAY_FILTER_INSTANCE;
    }

    public static String addFullyPlayedNamePrefix(String displayName, StoreResource resource) {
        StoreItem item;
        MediaType mediaType;
        if (resource.getMediaInfo() != null) {
            mediaType = resource.getMediaInfo().getMediaType();
        } else if (resource instanceof StoreItem && (item = (StoreItem)resource).getFormat() != null) {
            mediaType = switch (item.getFormat().getType()) {
                case 1 -> MediaType.AUDIO;
                case 2 -> MediaType.IMAGE;
                case 4 -> MediaType.VIDEO;
                default -> MediaType.UNKNOWN;
            };
        } else {
            mediaType = MediaType.UNKNOWN;
        }
        return switch (mediaType) {
            case MediaType.IMAGE -> String.format("[%s] %s", Messages.getString("Viewed"), displayName);
            case MediaType.VIDEO -> String.format("[%s] %s", Messages.getString("Watched"), displayName);
            default -> String.format("[%s] %s", Messages.getString("Played"), displayName);
        };
    }

    private static BufferedImage getThumbnailOverlayImage() {
        BufferedImage tmpThumbnailOverlayImage = null;
        try {
            tmpThumbnailOverlayImage = ImageIO.read(FullyPlayed.class.getResourceAsStream(THUMBNAIL_OVERLAY_RESOURCE_PATH));
        }
        catch (IOException e) {
            LOGGER.error("Error reading fully played overlay image \"{}\": {}", (Object)THUMBNAIL_OVERLAY_RESOURCE_PATH, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return tmpThumbnailOverlayImage;
    }

    public static class FullyPlayerOverlayFilter
    extends NonGeometricBufferedImageOp
    implements BufferedImageFilter {
        public FullyPlayerOverlayFilter(RenderingHints hints) {
            super(hints);
        }

        @Override
        public String getDescription() {
            return this.toString();
        }

        public String toString() {
            return "Fully played image overlay";
        }

        @Override
        public BufferedImage filter(BufferedImage source, BufferedImage destination) {
            return this.filter(source, destination, true).getBufferedImage();
        }

        @Override
        public BufferedImageFilter.BufferedImageFilterResult filter(BufferedImage source) {
            return this.filter(source, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BufferedImageFilter.BufferedImageFilterResult filter(BufferedImage source, BufferedImage destination, boolean modifySource) {
            if (THUMBNAIL_OVERLAY_IMAGE == null) {
                return new BufferedImageFilter.BufferedImageFilterResult(source, false, true);
            }
            boolean sameInstance = true;
            if (source == null) {
                source = new BufferedImage(256, 256, 5);
                sameInstance = false;
            }
            if (destination == null) {
                if (modifySource) {
                    destination = source;
                } else {
                    destination = this.createCompatibleDestImage(source, null);
                    sameInstance = false;
                }
            } else {
                sameInstance = source == destination;
            }
            int overlayResolution = (int)Math.round((double)Math.min(source.getWidth(), source.getHeight()) * 0.6);
            int overlayHorizontalPosition = (source.getWidth() - overlayResolution) / 2;
            int overlayVerticalPosition = (source.getHeight() - overlayResolution) / 2;
            Graphics2D g2d = destination.createGraphics();
            try {
                if (this.hints != null) {
                    g2d.setRenderingHints(this.hints);
                }
                if (source != destination) {
                    g2d.drawImage((Image)source, 0, 0, null);
                }
                g2d.setPaint(THUMBNAIL_OVERLAY_BACKGROUND_COLOR);
                g2d.fillRect(0, 0, source.getWidth(), source.getHeight());
                g2d.drawImage(THUMBNAIL_OVERLAY_IMAGE, overlayHorizontalPosition, overlayVerticalPosition, overlayResolution, overlayResolution, null);
            }
            finally {
                g2d.dispose();
            }
            return new BufferedImageFilter.BufferedImageFilterResult(destination, true, sameInstance);
        }
    }
}

