/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public abstract class FlowParserOutputStream
extends OutputStream {
    private final ByteBuffer buffer;
    private final OutputStream out;
    protected int neededByteNumber;
    protected int streamableByteNumber;
    protected boolean discard;
    protected int internalMark;
    protected int swapOrderBits;
    protected byte[] swapRemainingByte;
    private int count;
    private final byte[] zerobuffer;

    protected FlowParserOutputStream(OutputStream out, int maxbuffersize) {
        this.out = out;
        this.buffer = ByteBuffer.allocate(maxbuffersize);
        this.zerobuffer = new byte[15000];
        Arrays.fill(this.zerobuffer, (byte)0);
    }

    @Override
    public void write(int b) throws IOException {
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.swapOrderBits == 2) {
            int modulo;
            if (this.swapRemainingByte != null && this.swapRemainingByte.length == 1) {
                this.buffer.put(b[off]);
                this.buffer.put(this.swapRemainingByte[0]);
                ++off;
            }
            if ((modulo = Math.abs(len - off) % this.swapOrderBits) != 0) {
                this.swapRemainingByte = new byte[1];
                System.arraycopy(b, len -= modulo, this.swapRemainingByte, 0, modulo);
            }
            for (int i = off; i < len; i += 2) {
                byte temp = b[i];
                b[i] = b[i + 1];
                b[i + 1] = temp;
            }
        }
        this.buffer.put(b, off, len);
        int remains = this.buffer.position() - this.internalMark;
        while (remains > this.streamableByteNumber || remains > this.neededByteNumber) {
            if (this.streamableByteNumber == 0) {
                if (remains > this.neededByteNumber) {
                    ++this.count;
                    this.analyzeBuffer(this.buffer.array(), this.internalMark, this.neededByteNumber);
                    if (this.streamableByteNumber == 0) {
                        throw new IOException("Packet size cannot be Null !");
                    }
                    if (!this.discard) {
                        this.beforeChunkSend();
                    }
                } else {
                    this.buffer.position(this.internalMark);
                    this.buffer.compact();
                    this.buffer.position(remains);
                    this.internalMark = 0;
                    return;
                }
            }
            if (this.streamableByteNumber <= 0) continue;
            if (remains >= this.streamableByteNumber) {
                if (!this.discard) {
                    this.out.write(this.buffer.array(), this.internalMark, this.streamableByteNumber);
                }
                this.internalMark += this.streamableByteNumber;
                remains -= this.streamableByteNumber;
                this.streamableByteNumber = 0;
                if (!this.discard) {
                    this.afterChunkSend();
                }
                if (remains != 0) continue;
                this.buffer.position(0);
                this.internalMark = 0;
                continue;
            }
            if (!this.discard) {
                this.out.write(this.buffer.array(), this.internalMark, remains);
            }
            this.streamableByteNumber -= remains;
            this.buffer.position(0);
            this.internalMark = 0;
            remains = 0;
        }
    }

    protected void writePayload(byte[] payload) throws IOException {
        this.out.write(payload, 0, payload.length);
    }

    protected void padWithZeros(int numberOfZeros) throws IOException {
        if (numberOfZeros > 0) {
            this.out.write(this.zerobuffer, 0, numberOfZeros);
        }
    }

    protected abstract void analyzeBuffer(byte[] var1, int var2, int var3);

    protected abstract void beforeChunkSend() throws IOException;

    protected abstract void afterChunkSend() throws IOException;

    @Override
    public void close() throws IOException {
        try (OutputStream outputStream = this.out;){
            int finalPos = this.buffer.position();
            if (finalPos > 0 && this.streamableByteNumber > finalPos) {
                this.out.write(this.buffer.array(), 0, finalPos);
                this.padWithZeros(this.streamableByteNumber - finalPos);
            }
        }
    }
}

