/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import net.pms.util.FileWatcher;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredMgr {
    private static final Logger LOGGER = LoggerFactory.getLogger(CredMgr.class);
    private HashMap<MultiKey, ArrayList<Credential>> credentials = new HashMap();
    private HashMap<MultiKey, String> tags = new HashMap();
    private File credFile;
    public static final FileWatcher.Listener RELOADER = (filename, event, watch, isDir) -> {
        try {
            ((CredMgr)watch.getItem()).readFile();
        }
        catch (IOException e) {
            LOGGER.debug("Error during credfile init " + String.valueOf(e));
        }
    };

    public CredMgr(File f) {
        this.credFile = f;
        FileWatcher.add(new FileWatcher.Watch(f.getPath(), RELOADER, this));
        try {
            this.readFile();
        }
        catch (IOException e) {
            LOGGER.debug("Error during credfile init " + String.valueOf(e));
        }
    }

    private void readFile() throws IOException {
        this.credentials.clear();
        this.tags.clear();
        if (!this.credFile.exists()) {
            return;
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.credFile), StandardCharsets.UTF_8));){
            String str;
            while ((str = in.readLine()) != null) {
                String[] s;
                if (StringUtils.isEmpty(str = str.trim()) || str.startsWith("#") || (s = str.split("\\s*=\\s*", 2)).length < 2) continue;
                String[] s1 = s[0].split("\\.", 2);
                String[] s2 = s[1].split(",", 2);
                if (s2.length < 2) continue;
                String tag = "";
                if (s1.length > 1) {
                    tag = s1[1];
                    MultiKey<String> tkey = new MultiKey<String>(s1[0], s2[0]);
                    this.tags.put(tkey, tag);
                }
                MultiKey<String> key = new MultiKey<String>(s1[0], tag);
                Credential val = new Credential(s2[0], s2[1]);
                ArrayList<Credential> old = this.credentials.get(key);
                if (old == null) {
                    old = new ArrayList();
                }
                old.add(val);
                this.credentials.put(key, old);
            }
        }
    }

    private MultiKey createKey(String owner, String tag) {
        return new MultiKey<String>(owner, tag == null ? "" : tag);
    }

    public Credential getCred(String owner) {
        return this.getCred(owner, "");
    }

    public Credential getCred(String owner, String tag) {
        MultiKey key = this.createKey(owner, tag);
        ArrayList<Credential> list = this.credentials.get(key);
        return list == null ? null : list.get(0);
    }

    public String getTag(String owner, String username) {
        MultiKey<String> key = new MultiKey<String>(owner, username);
        return this.tags.get(key);
    }

    public boolean verify(String owner, String user, String pwd) {
        return this.verify(owner, "", user, pwd);
    }

    public boolean verify(String owner, String tag, String user, String pwd) {
        MultiKey key = this.createKey(owner, tag);
        ArrayList<Credential> list = this.credentials.get(key);
        if (list == null) {
            return false;
        }
        for (Credential c : list) {
            if (!user.equals(c.getUsername())) continue;
            return pwd.equals(c.getPassword());
        }
        return false;
    }

    public static class Credential {
        private final String username;
        private final String password;

        private Credential(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

