/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.traces;

import com.sun.jna.Platform;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.metal.MetalIconFactory;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.swing.components.CustomJButton;
import net.pms.util.DbgPacker;
import net.pms.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbgPackerComponent
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbgPacker.class);
    private final DbgPacker dbgPacker;
    private String zippedLogFile;
    private CustomJButton openZip;

    DbgPackerComponent(DbgPacker dbgPacker) {
        this.dbgPacker = dbgPacker;
    }

    public JComponent config() {
        this.dbgPacker.poll();
        JPanel top = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(0, 5, 0, 5);
        c.ipadx = 5;
        c.gridx = 0;
        c.gridy = 0;
        for (Map.Entry<File, Object> item : this.dbgPacker.getItems().entrySet()) {
            JCheckBox box;
            File file = item.getKey();
            boolean exists = file.exists();
            if (item.getValue() == null) {
                box = new JCheckBox(file.getName(), exists);
                item.setValue(box);
            } else {
                box = (JCheckBox)item.getValue();
            }
            if (!exists) {
                box.setSelected(false);
                box.setEnabled(false);
            }
            c.weightx = 1.0;
            top.add((Component)box, c);
            CustomJButton open = exists ? new CustomJButton(MetalIconFactory.getTreeLeafIcon()) : new CustomJButton("+");
            open.setActionCommand(file.getAbsolutePath());
            open.setToolTipText((String)(exists ? "" : Messages.getGuiString("Create") + " ") + file.getAbsolutePath());
            open.addActionListener(this);
            ++c.gridx;
            c.weightx = 0.0;
            top.add((Component)open, c);
            --c.gridx;
            ++c.gridy;
        }
        c.weightx = 2.0;
        CustomJButton debugPack = new CustomJButton(Messages.getGuiString("ZipSelectedFiles"));
        debugPack.setActionCommand("pack");
        debugPack.addActionListener(this);
        top.add((Component)debugPack, c);
        this.openZip = new CustomJButton(MetalIconFactory.getTreeFolderIcon());
        this.openZip.setActionCommand("showzip");
        this.openZip.setToolTipText(Messages.getGuiString("OpenZipLocation"));
        this.openZip.setEnabled(false);
        this.openZip.addActionListener(this);
        ++c.gridx;
        c.weightx = 0.0;
        top.add((Component)this.openZip, c);
        return top;
    }

    private boolean saveDialog() {
        JFileChooser fc = new JFileChooser(){
            private static final long serialVersionUID = -7279491708128801610L;

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                if (!f.isDirectory()) {
                    if (f.exists() && JOptionPane.showConfirmDialog(null, Messages.getGuiString("OverwriteExistingFile"), "Confirm", 0) != 0) {
                        return;
                    }
                    super.approveSelection();
                }
            }
        };
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String s = f.getName();
                return f.isDirectory() || s.endsWith(".zip") || s.endsWith(".ZIP");
            }

            @Override
            public String getDescription() {
                return "*.zip";
            }
        });
        this.zippedLogFile = PMS.getConfiguration().getDefaultZippedLogFileFolder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
        Date date = new Date();
        String fileName = "ums_dbg_" + dateFormat.format(date) + ".zip";
        this.zippedLogFile = FileUtil.appendPathSeparator(this.zippedLogFile) + fileName;
        fc.setSelectedFile(new File(this.zippedLogFile));
        if (fc.showSaveDialog(null) == 0) {
            this.zippedLogFile = fc.getSelectedFile().getPath();
            return true;
        }
        return false;
    }

    private void packDbg() {
        if (!this.saveDialog()) {
            return;
        }
        try {
            try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(this.zippedLogFile));){
                for (Map.Entry<File, Object> item : this.dbgPacker.getItems().entrySet()) {
                    if (item.getValue() == null || !((JCheckBox)item.getValue()).isSelected()) continue;
                    File file = item.getKey();
                    LOGGER.debug("Packing {}", (Object)file.getAbsolutePath());
                    DbgPacker.writeToZip(zos, file);
                }
            }
            this.openZip.setEnabled(true);
        }
        catch (Exception e) {
            LOGGER.debug("Error packing zip file: {}", (Object)e.getLocalizedMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block7: {
            String str = e.getActionCommand();
            if (str.equals("pack")) {
                this.packDbg();
            } else {
                File file;
                File file2 = file = str.equals("showzip") ? new File(this.zippedLogFile).getParentFile() : new File(str);
                if (file.exists()) {
                    try {
                        Desktop.getDesktop().open(file);
                    }
                    catch (IOException e2) {
                        LOGGER.warn("Failed to open default desktop application: {}", e2);
                        if (Platform.isWindows()) {
                            JOptionPane.showMessageDialog(null, Messages.getGuiString("CouldNotOpenExternalViewerPlease") + String.valueOf(e2), Messages.getGuiString("Error"), 0);
                            break block7;
                        }
                        JOptionPane.showMessageDialog(null, Messages.getGuiString("CouldNotOpenExternalViewer") + String.valueOf(e2), Messages.getGuiString("Error"), 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, String.format(Messages.getGuiString("CantOpenXDoesntExist"), file.getAbsolutePath()), null, 1);
                    this.reload((JComponent)e.getSource());
                }
            }
        }
    }

    private void reload(JComponent c) {
        LOGGER.debug("Reloading...");
        ((Window)c.getTopLevelAncestor()).dispose();
        JOptionPane.showOptionDialog(SwingUtilities.getWindowAncestor(this.openZip), this.config(), Messages.getGuiString("Options"), -1, -1, null, null, null);
    }
}

