/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.status;

import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.gui.EConnectionState;
import net.pms.renderers.Renderer;
import net.pms.swing.components.AnimatedIcon;
import net.pms.swing.components.CustomUIProgressBar;
import net.pms.swing.components.JAnimatedButton;
import net.pms.swing.components.SegmentedProgressBarUI;
import net.pms.swing.components.ServerBindMouseListener;
import net.pms.swing.components.WrapLayout;
import net.pms.swing.gui.FormLayoutUtil;
import net.pms.swing.gui.UmsFormBuilder;
import net.pms.swing.gui.tabs.status.RendererPanel;

public class StatusTab {
    private static final Color MEM_COLOR = new Color(119, 119, 119, 128);
    private static final Color DB_COLOR = new Color(75, 140, 181, 128);
    private static final Color BUF_COLOR = new Color(255, 128, 0, 128);
    private static final DecimalFormat FORMATTER = new DecimalFormat("#,###");
    private static final String ICON_STATUS_CONNECTING = "icon-status-connecting.svg";
    private static final String ICON_STATUS_CONNECTED = "icon-status-connected.svg";
    private static final String ICON_STATUS_DISCONNECTED = "icon-status-disconnected.svg";
    private static final String ICON_STATUS_WARNING = "icon-status-warning.svg";
    private final JAnimatedButton connectionStatus = new JAnimatedButton();
    private final AnimatedIcon searchingIcon;
    private final AnimatedIcon connectedIcon;
    private final AnimatedIcon disconnectedIcon;
    private final AnimatedIcon blockedIcon;
    private JPanel renderersPanel;
    private JComponent detectedMediaRenderersSeparator;
    private JLabel mediaServerLabel;
    private JLabel mediaServerBindLabel;
    private JLabel interfaceServerBindLabel;
    private JLabel memLabel;
    private SegmentedProgressBarUI memBarUI;
    private JLabel currentBitrate;
    private JLabel peakBitrate;
    private JLabel bitrateLabel;
    private JLabel currentBitrateLabel;
    private JLabel peakBitrateLabel;
    private EConnectionState connectionState = EConnectionState.UNKNOWN;

    public StatusTab() {
        this.searchingIcon = new AnimatedIcon((JComponent)this.connectionStatus, ICON_STATUS_CONNECTING);
        this.connectedIcon = new AnimatedIcon((JComponent)this.connectionStatus, ICON_STATUS_CONNECTED);
        this.disconnectedIcon = new AnimatedIcon((JComponent)this.connectionStatus, ICON_STATUS_DISCONNECTED);
        this.blockedIcon = new AnimatedIcon((JComponent)this.connectionStatus, ICON_STATUS_WARNING);
    }

    public void setConnectionState(EConnectionState connectionState) {
        if (connectionState == null) {
            throw new IllegalArgumentException("connectionState cannot be null");
        }
        if (!connectionState.equals((Object)this.connectionState)) {
            this.connectionState = connectionState;
            AnimatedIcon oldIcon = (AnimatedIcon)this.connectionStatus.getIcon();
            switch (connectionState) {
                case SEARCHING: {
                    this.connectionStatus.setToolTipText(Messages.getString("SearchingForRenderers"));
                    this.searchingIcon.restartArm();
                    if (oldIcon != null) {
                        oldIcon.setNextStage(new AnimatedIcon.AnimatedIconStage(AnimatedIcon.AnimatedIconType.DEFAULTICON, this.searchingIcon, false));
                        break;
                    }
                    this.connectionStatus.setIcon(this.searchingIcon);
                    break;
                }
                case CONNECTED: {
                    this.connectionStatus.setToolTipText(Messages.getString("Connected"));
                    this.connectedIcon.restartArm();
                    if (oldIcon != null) {
                        oldIcon.setNextStage(new AnimatedIcon.AnimatedIconStage(AnimatedIcon.AnimatedIconType.DEFAULTICON, this.connectedIcon, false));
                        break;
                    }
                    this.connectionStatus.setIcon(this.connectedIcon);
                    break;
                }
                case DISCONNECTED: {
                    this.connectionStatus.setToolTipText(Messages.getString("NoRenderersWereFound"));
                    this.disconnectedIcon.restartArm();
                    if (oldIcon != null) {
                        oldIcon.setNextStage(new AnimatedIcon.AnimatedIconStage(AnimatedIcon.AnimatedIconType.DEFAULTICON, this.disconnectedIcon, false));
                        break;
                    }
                    this.connectionStatus.setIcon(this.disconnectedIcon);
                    break;
                }
                case BLOCKED: {
                    this.connectionStatus.setToolTipText(Messages.getString("PortBlockedChangeIt"));
                    this.blockedIcon.reset();
                    if (oldIcon != null) {
                        oldIcon.setNextStage(new AnimatedIcon.AnimatedIconStage(AnimatedIcon.AnimatedIconType.DEFAULTICON, this.blockedIcon, false));
                        break;
                    }
                    this.connectionStatus.setIcon(this.blockedIcon);
                    break;
                }
                default: {
                    this.connectionStatus.setIcon(null);
                }
            }
        }
    }

    public JComponent build() {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(PMS.getLocale());
        String colSpec = FormLayoutUtil.getColSpec("pref, 30dlu, fill:pref:grow, 30dlu, pref", orientation);
        FormLayout layout = new FormLayout(colSpec, "p,9dlu,fill:p:grow,3dlu,p,10dlu,[10pt,p],1dlu,[30pt,p],3dlu,");
        UmsFormBuilder builder = UmsFormBuilder.create().layout(layout);
        builder.border(Paddings.DIALOG);
        builder.opaque(true);
        CellConstraints cc = new CellConstraints();
        this.detectedMediaRenderersSeparator = builder.createBoldedSeparator(Messages.getString("DetectedMediaRenderers"));
        builder.add(this.detectedMediaRenderersSeparator).at(FormLayoutUtil.flip(cc.xyw(1, 1, 5), colSpec, orientation));
        Color fgColor = new Color(68, 68, 68);
        this.renderersPanel = new JPanel(new WrapLayout(1, 20, 10));
        JScrollPane rsp = new JScrollPane(this.renderersPanel, 20, 31);
        rsp.setBorder(BorderFactory.createEmptyBorder());
        rsp.setPreferredSize(new Dimension(0, 260));
        rsp.getHorizontalScrollBar().setLocation(0, 250);
        builder.add(rsp).at(cc.xyw(1, 3, 5));
        builder.addSeparator(null, new Object[0]).at(FormLayoutUtil.flip(cc.xyw(1, 5, 5), colSpec, orientation));
        this.connectedIcon.start();
        this.searchingIcon.start();
        this.disconnectedIcon.start();
        this.connectionStatus.setFocusable(false);
        String conColSpec = "left:pref, 3dlu, right:pref:grow";
        UmsFormBuilder connectionBuilder = UmsFormBuilder.create().layout(new FormLayout(conColSpec, "p, 1dlu, p, 1dlu, p"));
        connectionBuilder.add(this.connectionStatus).at(FormLayoutUtil.flip(cc.xywh(1, 1, 1, 3, "center, fill"), conColSpec, orientation));
        this.setConnectionState(EConnectionState.SEARCHING);
        this.mediaServerLabel = new JLabel("<html><b>" + Messages.getString("Servers") + "</b></html>");
        this.mediaServerLabel.setForeground(fgColor);
        connectionBuilder.add(this.mediaServerLabel).at(FormLayoutUtil.flip(cc.xy(3, 1, "left, top"), conColSpec, orientation));
        this.mediaServerBindLabel = new JLabel("-");
        this.mediaServerBindLabel.setForeground(fgColor);
        this.mediaServerBindLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.mediaServerBindLabel.addMouseListener(new ServerBindMouseListener(this.mediaServerBindLabel));
        this.mediaServerBindLabel.setToolTipText(Messages.getString("MediaServerIpAddress"));
        connectionBuilder.add(this.mediaServerBindLabel).at(FormLayoutUtil.flip(cc.xy(3, 3, "left, top"), conColSpec, orientation));
        this.interfaceServerBindLabel = new JLabel("-");
        this.interfaceServerBindLabel.setForeground(fgColor);
        this.interfaceServerBindLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.interfaceServerBindLabel.addMouseListener(new ServerBindMouseListener(this.interfaceServerBindLabel));
        this.interfaceServerBindLabel.setToolTipText(Messages.getString("WebSettingsServerIpAddress"));
        connectionBuilder.add(this.interfaceServerBindLabel).at(FormLayoutUtil.flip(cc.xy(3, 5, "left, top"), conColSpec, orientation));
        builder.add(connectionBuilder.getPanel()).at(FormLayoutUtil.flip(cc.xywh(1, 7, 1, 3, "left, top"), colSpec, orientation));
        this.memBarUI = new SegmentedProgressBarUI(Color.white, Color.gray);
        this.memBarUI.setActiveLabel("{}", Color.white, 0);
        this.memBarUI.setActiveLabel("{}", Color.red, 90);
        this.memBarUI.addSegment("", MEM_COLOR);
        this.memBarUI.addSegment("", DB_COLOR);
        this.memBarUI.addSegment("", BUF_COLOR);
        this.memBarUI.setTickMarks(this.getTickMarks(), "{}");
        CustomUIProgressBar memoryProgressBar = new CustomUIProgressBar(0, 100, this.memBarUI);
        memoryProgressBar.setStringPainted(true);
        memoryProgressBar.setForeground(new Color(75, 140, 181));
        memoryProgressBar.setString(Messages.getString("Empty"));
        this.memLabel = new JLabel("<html><b>" + Messages.getString("MemoryUsage") + "</b> (" + Messages.getString("Mb") + ")</html>");
        this.memLabel.setForeground(fgColor);
        builder.add(this.memLabel).at(FormLayoutUtil.flip(cc.xy(3, 7), colSpec, orientation));
        builder.add(memoryProgressBar).at(FormLayoutUtil.flip(cc.xyw(3, 9, 1), colSpec, orientation));
        String bitColSpec = "left:pref, 3dlu, right:pref:grow";
        UmsFormBuilder bitrateBuilder = UmsFormBuilder.create().layout(new FormLayout(bitColSpec, "p, 1dlu, p, 1dlu, p"));
        this.bitrateLabel = new JLabel("<html><b>" + Messages.getString("Bitrate") + "</b> (" + Messages.getString("Mbs") + ")</html>");
        this.bitrateLabel.setForeground(fgColor);
        bitrateBuilder.add(this.bitrateLabel).at(FormLayoutUtil.flip(cc.xy(1, 1), bitColSpec, orientation));
        this.currentBitrateLabel = new JLabel(Messages.getString("Current"));
        this.currentBitrateLabel.setForeground(fgColor);
        bitrateBuilder.add(this.currentBitrateLabel).at(FormLayoutUtil.flip(cc.xy(1, 3), bitColSpec, orientation));
        this.currentBitrate = new JLabel("0");
        this.currentBitrate.setForeground(fgColor);
        bitrateBuilder.add(this.currentBitrate).at(FormLayoutUtil.flip(cc.xy(3, 3), bitColSpec, orientation));
        this.peakBitrateLabel = new JLabel(Messages.getString("Peak"));
        this.peakBitrateLabel.setForeground(fgColor);
        bitrateBuilder.add(this.peakBitrateLabel).at(FormLayoutUtil.flip(cc.xy(1, 5), bitColSpec, orientation));
        this.peakBitrate = new JLabel("0");
        this.peakBitrate.setForeground(fgColor);
        bitrateBuilder.add(this.peakBitrate).at(FormLayoutUtil.flip(cc.xy(3, 5), bitColSpec, orientation));
        builder.add(bitrateBuilder.getPanel()).at(FormLayoutUtil.flip(cc.xywh(5, 7, 1, 3, "left, top"), colSpec, orientation));
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(orientation);
        JScrollPane scrollPane = new JScrollPane(panel, 21, 30);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        return scrollPane;
    }

    public void setMediaServerBind(String bind) {
        SwingUtilities.invokeLater(() -> this.mediaServerBindLabel.setText(bind));
    }

    public void setInterfaceServerBind(String bind) {
        SwingUtilities.invokeLater(() -> this.interfaceServerBindLabel.setText(bind));
    }

    public void setCurrentBitrate(int sizeinMb) {
        this.currentBitrate.setText(FORMATTER.format(sizeinMb));
    }

    public void setPeakBitrate(int sizeinMb) {
        this.peakBitrate.setText(FORMATTER.format(sizeinMb));
    }

    public void addRenderer(Renderer renderer) {
        RendererPanel rendererPanel = new RendererPanel(renderer);
        rendererPanel.addTo(this.renderersPanel);
        renderer.addGuiListener(rendererPanel);
    }

    private int getTickMarks() {
        int mb = (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
        return mb < 1000 ? 100 : (mb < 2500 ? 250 : (mb < 5000 ? 500 : 1000));
    }

    public void setMemoryUsage(int maxMemory, int usedMemory, int dbCacheMemory, int bufferMemory) {
        SwingUtilities.invokeLater(() -> this.memBarUI.setValues(0, maxMemory, Math.max(0, usedMemory - dbCacheMemory - bufferMemory), dbCacheMemory, bufferMemory));
    }

    public void applyLanguage() {
        Component component;
        if (this.detectedMediaRenderersSeparator != null && this.detectedMediaRenderersSeparator.getComponentCount() > 0 && (component = this.detectedMediaRenderersSeparator.getComponent(0)) instanceof JLabel) {
            JLabel jlabel = (JLabel)component;
            jlabel.setText(Messages.getString("DetectedMediaRenderers"));
        }
        switch (this.connectionState) {
            case SEARCHING: {
                this.connectionStatus.setToolTipText(Messages.getString("SearchingForRenderers"));
                break;
            }
            case CONNECTED: {
                this.connectionStatus.setToolTipText(Messages.getString("Connected"));
                break;
            }
            case DISCONNECTED: {
                this.connectionStatus.setToolTipText(Messages.getString("NoRenderersWereFound"));
                break;
            }
            case BLOCKED: {
                this.connectionStatus.setToolTipText(Messages.getString("PortBlockedChangeIt"));
            }
        }
        this.mediaServerBindLabel.setToolTipText(Messages.getString("MediaServerIpAddress"));
        this.interfaceServerBindLabel.setToolTipText(Messages.getString("WebSettingsServerIpAddress"));
        this.mediaServerLabel.setText("<html><b>" + Messages.getString("Servers") + "</b></html>");
        this.memLabel.setText("<html><b>" + Messages.getString("MemoryUsage") + "</b> (" + Messages.getString("Mb") + ")</html>");
        this.bitrateLabel.setText("<html><b>" + Messages.getString("Bitrate") + "</b> (" + Messages.getString("Mbs") + ")</html>");
        this.currentBitrateLabel.setText(Messages.getString("Current"));
        this.peakBitrateLabel.setText(Messages.getString("Peak"));
    }
}

