/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.components;

import java.io.Serializable;
import javax.swing.AbstractSpinnerModel;
import javax.swing.SpinnerModel;

public class SpinnerIntModel
extends AbstractSpinnerModel
implements Serializable,
SpinnerModel {
    private static final long serialVersionUID = 2530845793726723137L;
    private int stepSize;
    private int value;
    private int minimum;
    private int maximum;

    public SpinnerIntModel(int value, int minimum, int maximum, int stepSize) {
        if (minimum > value || maximum < value) {
            throw new IllegalArgumentException("(minimum <= value <= maximum) is false");
        }
        this.value = value;
        this.minimum = minimum;
        this.maximum = maximum;
        this.stepSize = stepSize;
    }

    public SpinnerIntModel(int value, int minimum, int maximum) {
        this(value, minimum, maximum, 1);
    }

    public SpinnerIntModel(int value, int stepSize) {
        this(value, Integer.MIN_VALUE, Integer.MAX_VALUE, stepSize);
    }

    public SpinnerIntModel(int value) {
        this(value, Integer.MIN_VALUE, Integer.MAX_VALUE, 1);
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
        this.fireStateChanged();
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
        this.fireStateChanged();
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setStepSize(int stepSize) {
        if (stepSize != this.stepSize) {
            this.stepSize = stepSize;
            this.fireStateChanged();
        }
    }

    public int getStepSize() {
        return this.stepSize;
    }

    private int incrValue(int dir2) {
        int newValue = this.value + this.stepSize * dir2;
        if (dir2 > 0 && newValue == this.minimum + this.stepSize && this.minimum % this.stepSize != 0) {
            newValue = this.minimum / this.stepSize * this.stepSize + this.stepSize;
        } else if (dir2 < 0 && newValue == this.maximum - this.stepSize && this.maximum % this.stepSize != 0) {
            newValue = this.maximum / this.stepSize * this.stepSize;
        }
        return Math.min(Math.max(newValue, this.minimum), this.maximum);
    }

    @Override
    public Object getNextValue() {
        return this.incrValue(1);
    }

    @Override
    public Object getPreviousValue() {
        return this.incrValue(-1);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public int getIntValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof Integer)) {
            throw new IllegalArgumentException("value must be integer");
        }
        if ((Integer)value != this.value) {
            this.value = (Integer)value;
            this.fireStateChanged();
        }
    }

    public void setIntValue(int value) {
        if (value != this.value) {
            this.value = value;
            this.fireStateChanged();
        }
    }
}

