/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicProgressBarUI;
import org.apache.commons.lang3.StringUtils;

public class SegmentedProgressBarUI
extends BasicProgressBarUI
implements Serializable {
    Color fg;
    Color bg;
    private transient ArrayList<Segment> segments = new ArrayList();
    private transient ArrayList<Segment> mainLabel = new ArrayList();
    private int tickmarks;
    private String tickLabel;

    public SegmentedProgressBarUI() {
        this(null, null);
    }

    public SegmentedProgressBarUI(Color fg, Color bg) {
        this.fg = fg != null ? fg : super.getSelectionForeground();
        this.bg = bg != null ? bg : super.getSelectionBackground();
        this.tickmarks = 0;
        this.tickLabel = "{}";
    }

    public synchronized int addSegment(String label, Color c) {
        this.segments.add(new Segment(label, new Color(c.getRed(), c.getGreen(), c.getBlue(), 128)));
        return this.segments.size() - 1;
    }

    public synchronized void setActiveLabel(String label, Color c, int pct) {
        Segment s = new Segment(label, c);
        s.val = pct;
        this.mainLabel.add(s);
    }

    public synchronized void setTickMarks(int units, String label) {
        this.tickmarks = units;
        this.tickLabel = label;
    }

    public synchronized void setValues(int min, int max, int ... vals) {
        int total = 0;
        for (int i = 0; i < vals.length; ++i) {
            this.segments.get((int)i).val = vals[i];
            total += vals[i];
        }
        this.progressBar.setMinimum(min);
        this.progressBar.setMaximum(max);
        this.progressBar.setValue(total);
    }

    private int total() {
        int size = 0;
        for (Segment s : this.segments) {
            size += s.val;
        }
        return size;
    }

    @Override
    protected synchronized void paintDeterminate(Graphics g, JComponent c) {
        Insets b = this.progressBar.getInsets();
        int w = this.progressBar.getWidth() - (b.right + b.left);
        int h = this.progressBar.getHeight() - (b.top + b.bottom);
        if (w < 1 || h < 1) {
            return;
        }
        int max = this.progressBar.getMaximum();
        this.getAmountFull(b, w, h);
        float unit = (float)w / (float)max;
        int total = this.total();
        int x = b.left;
        Graphics2D g2 = (Graphics2D)g;
        if (this.tickmarks > 0) {
            g2.setStroke(new BasicStroke());
            g2.setColor(Color.gray);
            this.paintTicks(g, b.left, (int)(unit * (float)this.tickmarks), b.left + w);
        }
        g2.setStroke(new BasicStroke(h, 0, 2));
        for (Segment s : this.segments) {
            if (s.val <= 0) continue;
            int segmentWidth = (int)((float)s.val * unit);
            g2.setColor(s.color);
            g2.drawLine(x, h / 2 + b.top, x + segmentWidth, h / 2 + b.top);
            if (this.progressBar.isStringPainted() && StringUtils.isNotBlank(s.label)) {
                this.progressBar.setString(s.label);
                this.paintString(g, x, b.top, segmentWidth, h, segmentWidth, b);
            }
            x += segmentWidth;
        }
        if (this.progressBar.isStringPainted() && !this.mainLabel.isEmpty()) {
            Segment active = null;
            int pct = total * 100 / max;
            for (Segment s : this.mainLabel) {
                if (s.val > pct) continue;
                active = s;
            }
            if (active != null) {
                g2.setColor(active.color);
                String label = active.label.replace("{}", "" + total);
                int labelWidth = (int)g.getFontMetrics().getStringBounds(label, g).getWidth();
                g2.drawString(label, x - labelWidth - 2, g2.getFontMetrics().getAscent());
            }
        }
    }

    private void paintTicks(Graphics g, int x0, int step, int max) {
        int x;
        if (step < 1) {
            return;
        }
        int h = this.progressBar.getHeight();
        Font font = g.getFont();
        g.setFont(font.deriveFont(10.0f));
        for (x = x0 + step; x < max; x += step) {
            g.drawLine(x, h / 2, x, h);
            if (this.tickLabel == null) continue;
            String s = this.tickLabel.replace("{}", "" + (x - x0) / step * this.tickmarks);
            int w = (int)g.getFontMetrics().getStringBounds(s, g).getWidth();
            g.drawString(s, x - 3 - w, h - 3);
        }
        if (this.tickLabel != null && (max - x0) % step != 0) {
            int availableWidth = max - x + step;
            String s = "" + this.progressBar.getMaximum();
            int w = (int)g.getFontMetrics().getStringBounds(s, g).getWidth();
            if (availableWidth > w + 10) {
                g.drawString(s, max - 3 - w, h - 3);
            }
        }
        g.setFont(font);
    }

    @Override
    protected synchronized Color getSelectionForeground() {
        return this.fg;
    }

    @Override
    protected synchronized Color getSelectionBackground() {
        return this.bg;
    }

    static class Segment {
        String label;
        Color color;
        int val;

        Segment(String l, Color c) {
            this.label = l;
            this.color = c;
        }
    }
}

