/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.components;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import net.pms.swing.components.IllegalChildException;

public class SearchableMutableTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 8466944555448955118L;

    public SearchableMutableTreeNode(String nodeName) {
        super(nodeName);
    }

    public SearchableMutableTreeNode(String nodeName, boolean allowsChildren) {
        super(nodeName, allowsChildren);
    }

    protected SearchableMutableTreeNode findChild(String searchName, boolean recursive, boolean specialGroupRules) throws IllegalChildException {
        if (this.getChildCount() > 0) {
            SearchableMutableTreeNode currentChild;
            for (int i = 0; i < this.getChildCount(); ++i) {
                TreeNode currentTNChild = this.getChildAt(i);
                if (currentTNChild instanceof SearchableMutableTreeNode) {
                    currentChild = (SearchableMutableTreeNode)currentTNChild;
                    if (!currentChild.getNodeName().equalsIgnoreCase(searchName) && (!specialGroupRules || !searchName.equalsIgnoreCase(currentChild.getParent().getNodeName() + " " + currentChild.getNodeName()))) continue;
                    return currentChild;
                }
                throw new IllegalChildException("All children must be SearchMutableTreeNode or subclasses thereof");
            }
            if (recursive) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    SearchableMutableTreeNode result;
                    currentChild = (SearchableMutableTreeNode)this.getChildAt(i);
                    if (currentChild.isLeaf() || (result = currentChild.findChild(searchName, true, specialGroupRules)) == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    public SearchableMutableTreeNode findChild(String searchName) throws IllegalChildException {
        return this.findChild(searchName, false, false);
    }

    public SearchableMutableTreeNode findInBranch(String searchName, boolean specialGroupRules) throws IllegalChildException {
        return this.findChild(searchName, true, specialGroupRules);
    }

    public String getNodeName() {
        return (String)super.getUserObject();
    }

    @Override
    public SearchableMutableTreeNode getParent() {
        return (SearchableMutableTreeNode)this.parent;
    }
}

