/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.components;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictedFileSystemView
extends FileSystemView {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestrictedFileSystemView.class);
    private static final String NEW_FOLDER_STRING = UIManager.getString("FileChooser.other.newFolder");
    private File defaultDirectory;

    public RestrictedFileSystemView() {
        this(null);
    }

    public RestrictedFileSystemView(File defaultDirectory) {
        this.defaultDirectory = defaultDirectory;
    }

    @Override
    public boolean isRoot(File f) {
        File[] roots;
        if (f == null || !f.isAbsolute()) {
            return false;
        }
        for (File root : roots = this.getRoots()) {
            if (!root.equals(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean isTraversable(File f) {
        return f.isDirectory();
    }

    @Override
    public String getSystemDisplayName(File f) {
        String name = null;
        if (f != null) {
            name = this.isRoot(f) ? f.getAbsolutePath() : f.getName();
        }
        return name;
    }

    @Override
    public String getSystemTypeDescription(File f) {
        return null;
    }

    @Override
    public Icon getSystemIcon(File f) {
        if (f != null) {
            return UIManager.getIcon(f.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
        }
        return null;
    }

    @Override
    public boolean isParent(File folder, File file) {
        if (folder == null || file == null) {
            return false;
        }
        return folder.equals(file.getParentFile());
    }

    @Override
    public File getChild(File parent, String fileName) {
        return this.createFileObject(parent, fileName);
    }

    @Override
    public boolean isFileSystem(File f) {
        return true;
    }

    @Override
    public boolean isHiddenFile(File f) {
        return f.isHidden();
    }

    @Override
    public boolean isFileSystemRoot(File dir2) {
        return this.isRoot(dir2);
    }

    @Override
    public boolean isDrive(File dir2) {
        return false;
    }

    @Override
    public boolean isFloppyDrive(File dir2) {
        return false;
    }

    @Override
    public boolean isComputerNode(File dir2) {
        return false;
    }

    @Override
    public File[] getRoots() {
        return File.listRoots();
    }

    @Override
    public File getHomeDirectory() {
        return this.createFileObject(System.getProperty("user.home"));
    }

    @Override
    public File getDefaultDirectory() {
        if (this.defaultDirectory == null) {
            try {
                File tempFile = File.createTempFile("filesystemview", "restricted");
                tempFile.deleteOnExit();
                this.defaultDirectory = tempFile.getParentFile();
            }
            catch (IOException e) {
                LOGGER.debug("Caught exception", e);
            }
        }
        return this.defaultDirectory;
    }

    @Override
    public File createFileObject(File dir2, String filename) {
        if (dir2 == null) {
            return new File(filename);
        }
        return new File(dir2, filename);
    }

    @Override
    public File createFileObject(String path) {
        File f = new File(path);
        if (this.isFileSystemRoot(f)) {
            f = this.createFileSystemRoot(f);
        }
        return f;
    }

    @Override
    public File[] getFiles(File dir2, boolean useFileHiding) {
        ArrayList<File> files = new ArrayList<File>();
        File[] names = dir2.listFiles();
        int nameCount = names == null ? 0 : names.length;
        for (int i = 0; i < nameCount && !Thread.currentThread().isInterrupted(); ++i) {
            File f = names[i];
            if (useFileHiding && this.isHiddenFile(f)) continue;
            files.add(f);
        }
        return (File[])files.toArray(File[]::new);
    }

    @Override
    public File getParentDirectory(File dir2) {
        File psf;
        if (dir2 != null && dir2.exists() && (psf = dir2.getParentFile()) != null) {
            if (this.isFileSystem(psf)) {
                File ppsf;
                File f = psf;
                if (!(f.exists() || (ppsf = psf.getParentFile()) != null && this.isFileSystem(ppsf))) {
                    f = this.createFileSystemRoot(f);
                }
                return f;
            }
            return psf;
        }
        return null;
    }

    @Override
    protected File createFileSystemRoot(File f) {
        return new FileSystemRoot(f);
    }

    @Override
    public File createNewFolder(File containingDir) throws IOException {
        if (containingDir == null) {
            throw new IOException("Containing directory is null:");
        }
        File newFolder = this.createFileObject(containingDir, NEW_FOLDER_STRING);
        for (int i = 2; newFolder.exists() && i < 100; ++i) {
            newFolder = this.createFileObject(containingDir, MessageFormat.format(NEW_FOLDER_STRING, i));
        }
        if (newFolder.exists()) {
            throw new IOException("Directory already exists:" + newFolder.getAbsolutePath());
        }
        if (!newFolder.mkdirs()) {
            LOGGER.debug("Could not create directory \"" + newFolder.getAbsolutePath() + "\"");
        }
        return newFolder;
    }

    static class FileSystemRoot
    extends File {
        private static final long serialVersionUID = -807847319198119832L;

        public FileSystemRoot(File f) {
            super(f, "");
        }

        public FileSystemRoot(String s) {
            super(s);
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public String getName() {
            return this.getPath();
        }
    }
}

