/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.components;

import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.Timer;

public class MarqueeLabel
extends JLabel {
    private static final long serialVersionUID = 8600355251271220610L;
    private int speed;
    private int spacer;
    private int dir;
    private int maxWidth;
    private int interval = 33;
    private Timer timer = null;

    public MarqueeLabel(String text) {
        this(text, 9999, 30, -1, 10);
    }

    public MarqueeLabel(String text, int width) {
        this(text, width, 30, -1, 10);
    }

    public MarqueeLabel(String text, int width, int speed, int dir2, int spacer) {
        super(text);
        this.maxWidth = width;
        this.speed = speed;
        this.dir = dir2;
        this.spacer = spacer;
        this.setSize(this.getPreferredSize());
    }

    public void setMaxWidth(int width) {
        this.maxWidth = width;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int w = this.getWidth();
        if (w <= this.maxWidth) {
            super.paintComponent(g);
        } else {
            int offset = (int)(System.currentTimeMillis() / (long)this.speed % (long)(w += this.spacer));
            g.translate(this.dir * offset, 0);
            super.paintComponent(g);
            g.translate(-this.dir * w, 0);
            super.paintComponent(g);
            if (this.timer == null) {
                this.timer = new Timer(this.interval, e -> this.repaint());
                this.timer.start();
            }
        }
    }
}

