/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.components;

import javax.swing.event.ListDataEvent;
import net.pms.Messages;
import net.pms.swing.components.KeyedComboBoxModel;

public class KeyedStringComboBoxModel
extends KeyedComboBoxModel<String, String> {
    public KeyedStringComboBoxModel() {
    }

    public KeyedStringComboBoxModel(String[] keys, String[] values) {
        super(keys, values);
    }

    @Override
    public void setSelectedValue(String aValue) {
        if (aValue == null) {
            this.selectedItemIndex = -1;
            this.selectedItemKey = null;
            this.selectedItemValue = null;
        } else {
            int newSelectedIndex = this.findValueIndex(aValue);
            if (newSelectedIndex == -1) {
                newSelectedIndex = this.findKeyIndex(aValue);
                if (newSelectedIndex == -1) {
                    this.add(aValue, this.generateCustomValue(aValue));
                    this.selectedItemIndex = this.findKeyIndex(aValue);
                    this.selectedItemKey = this.getKeyAt(this.selectedItemIndex);
                    this.selectedItemValue = this.getValueAt(this.selectedItemIndex);
                } else {
                    this.selectedItemIndex = newSelectedIndex;
                    this.selectedItemKey = this.getKeyAt(this.selectedItemIndex);
                    this.selectedItemValue = this.getValueAt(this.selectedItemIndex);
                }
            } else {
                this.selectedItemIndex = newSelectedIndex;
                this.selectedItemKey = this.getKeyAt(this.selectedItemIndex);
                this.selectedItemValue = this.getValueAt(this.selectedItemIndex);
            }
        }
        this.fireListDataEvent(new ListDataEvent(this, 0, -1, -1));
    }

    @Override
    public void setSelectedKey(String aKey) {
        if (aKey == null) {
            this.selectedItemIndex = -1;
            this.selectedItemKey = null;
            this.selectedItemValue = null;
        } else {
            int newSelectedItem = this.findKeyIndex(aKey);
            if (newSelectedItem == -1) {
                this.add(aKey, this.generateCustomValue(aKey));
                this.selectedItemIndex = this.findKeyIndex(aKey);
                this.selectedItemKey = this.getKeyAt(this.selectedItemIndex);
                this.selectedItemValue = this.getValueAt(this.selectedItemIndex);
            } else {
                this.selectedItemIndex = newSelectedItem;
                this.selectedItemKey = this.getKeyAt(this.selectedItemIndex);
                this.selectedItemValue = this.getValueAt(this.selectedItemIndex);
            }
        }
        this.fireListDataEvent(new ListDataEvent(this, 0, -1, -1));
    }

    private String generateCustomValue(String key) {
        return String.format(Messages.getGuiString("CustomValueX"), key);
    }
}

