/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.components;

import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class KeyedComboBoxModel<K, V>
implements ComboBoxModel<V> {
    protected int selectedItemIndex;
    protected K selectedItemKey;
    protected V selectedItemValue;
    private ArrayList<ComboBoxItemPair> data = new ArrayList();
    private ArrayList<ListDataListener> listdatalistener = new ArrayList();
    private transient ListDataListener[] tempListeners;
    private boolean allowOtherValue;

    public KeyedComboBoxModel() {
    }

    public KeyedComboBoxModel(K[] keys, V[] values) {
        this();
        this.setData(keys, values);
    }

    public void setData(K[] keys, V[] values) {
        if (values.length != keys.length) {
            throw new IllegalArgumentException("Keys and values must have the same length.");
        }
        this.data.clear();
        this.data.ensureCapacity(keys.length);
        for (int i = 0; i < values.length; ++i) {
            this.add(keys[i], values[i]);
        }
        this.selectedItemIndex = -1;
        ListDataEvent evt = new ListDataEvent(this, 0, 0, this.data.size() - 1);
        this.fireListDataEvent(evt);
    }

    protected synchronized void fireListDataEvent(ListDataEvent event) {
        if (this.tempListeners == null) {
            this.tempListeners = (ListDataListener[])this.listdatalistener.toArray(ListDataListener[]::new);
        }
        for (ListDataListener listener : this.tempListeners) {
            if (listener == null || event == null) continue;
            listener.contentsChanged(event);
        }
    }

    @Override
    @Deprecated
    public Object getSelectedItem() {
        return this.selectedItemValue;
    }

    public K getSelectedKey() {
        return this.selectedItemKey;
    }

    public V getSelectedValue() {
        return this.selectedItemValue;
    }

    public void setSelectedKey(K aKey) {
        if (aKey == null) {
            this.selectedItemIndex = -1;
            this.selectedItemKey = null;
            this.selectedItemValue = null;
        } else {
            int newSelectedItem = this.findKeyIndex(aKey);
            if (newSelectedItem == -1) {
                this.selectedItemIndex = -1;
                this.selectedItemKey = null;
                this.selectedItemValue = null;
            } else {
                this.selectedItemIndex = newSelectedItem;
                this.selectedItemKey = this.getKeyAt(this.selectedItemIndex);
                this.selectedItemValue = this.getValueAt(this.selectedItemIndex);
            }
        }
        this.fireListDataEvent(new ListDataEvent(this, 0, -1, -1));
    }

    @Override
    @Deprecated
    public void setSelectedItem(Object anItem) {
        this.setSelectedValue(anItem);
    }

    public void setSelectedValue(V aValue) {
        if (aValue == null) {
            this.selectedItemIndex = -1;
            this.selectedItemKey = null;
            this.selectedItemValue = null;
        } else {
            int newSelectedIndex = this.findValueIndex(aValue);
            if (newSelectedIndex == -1) {
                if (this.isAllowOtherValue()) {
                    this.selectedItemIndex = -1;
                    this.selectedItemKey = null;
                    this.selectedItemValue = aValue;
                } else {
                    this.selectedItemIndex = -1;
                    this.selectedItemKey = null;
                    this.selectedItemValue = null;
                }
            } else {
                this.selectedItemIndex = newSelectedIndex;
                this.selectedItemKey = this.getKeyAt(this.selectedItemIndex);
                this.selectedItemValue = this.getValueAt(this.selectedItemIndex);
            }
        }
        this.fireListDataEvent(new ListDataEvent(this, 0, -1, -1));
    }

    private boolean isAllowOtherValue() {
        return this.allowOtherValue;
    }

    public void setAllowOtherValue(boolean allowOtherValue) {
        this.allowOtherValue = allowOtherValue;
    }

    @Override
    public synchronized void addListDataListener(ListDataListener listener) {
        this.listdatalistener.add(listener);
        this.tempListeners = null;
    }

    @Override
    @Deprecated
    public V getElementAt(int index) {
        if (index >= this.data.size()) {
            return null;
        }
        ComboBoxItemPair datacon = this.data.get(index);
        if (datacon == null) {
            return null;
        }
        return datacon.getValue();
    }

    public V getValueAt(int index) {
        if (index >= this.data.size()) {
            return null;
        }
        ComboBoxItemPair datacon = this.data.get(index);
        if (datacon == null) {
            return null;
        }
        return datacon.getValue();
    }

    public K getKeyAt(int index) {
        if (index >= this.data.size()) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        ComboBoxItemPair datacon = this.data.get(index);
        if (datacon == null) {
            return null;
        }
        return datacon.getKey();
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public synchronized void removeListDataListener(ListDataListener l) {
        this.listdatalistener.remove(l);
        this.tempListeners = null;
    }

    public int findKeyIndex(Object key) {
        if (key == null) {
            throw new NullPointerException("Search key can not be null");
        }
        for (int i = 0; i < this.data.size(); ++i) {
            ComboBoxItemPair datacon = this.data.get(i);
            if (!key.equals(datacon.getKey())) continue;
            return i;
        }
        return -1;
    }

    public int findValueIndex(Object value) {
        if (value == null) {
            throw new NullPointerException("Search value can not be null");
        }
        for (int i = 0; i < this.data.size(); ++i) {
            ComboBoxItemPair datacon = this.data.get(i);
            if (!value.equals(datacon.getValue())) continue;
            return i;
        }
        return -1;
    }

    public void removeDataElement(K key) {
        int idx = this.findKeyIndex(key);
        if (idx == -1) {
            return;
        }
        this.data.remove(idx);
        ListDataEvent evt = new ListDataEvent(this, 2, idx, idx);
        this.fireListDataEvent(evt);
    }

    public void add(K key, V value) {
        ComboBoxItemPair con = new ComboBoxItemPair(key, value);
        this.data.add(con);
        ListDataEvent evt = new ListDataEvent(this, 1, this.data.size() - 2, this.data.size() - 2);
        this.fireListDataEvent(evt);
    }

    public void clear() {
        int size = this.getSize();
        this.data.clear();
        ListDataEvent evt = new ListDataEvent(this, 2, 0, size - 1);
        this.fireListDataEvent(evt);
    }

    private class ComboBoxItemPair {
        private final K key;
        private V value;

        public ComboBoxItemPair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }
    }
}

