/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.components;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import net.pms.swing.components.AnimatedIcon;
import net.pms.swing.components.AnimatedIconCallback;
import net.pms.swing.gui.JavaGui;
import net.pms.util.FileUtil;

public class JImageButton
extends JButton
implements AnimatedIconCallback {
    private static final long serialVersionUID = 8120596501408171329L;

    public JImageButton(String text, String iconName) {
        super(text, null);
        this.setProperties();
        this.setIcons(iconName);
    }

    public JImageButton(String iconName) {
        this(null, iconName);
    }

    public JImageButton() {
        this(null, (String)null);
    }

    public JImageButton(String text, Icon icon) {
        super(text, icon);
        this.setProperties();
    }

    public JImageButton(Icon icon) {
        super(icon);
        this.setProperties();
    }

    private void setProperties() {
        this.setRequestFocusEnabled(false);
        this.setBorderPainted(false);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setContentAreaFilled(false);
        this.setOpaque(false);
    }

    protected Icon readIcon(String filename) {
        return JavaGui.readImageIcon(filename);
    }

    private void setIcons(String defaultIconName) {
        if (defaultIconName == null) {
            return;
        }
        Icon icon = this.readIcon(defaultIconName);
        if (icon == null) {
            this.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
            return;
        }
        this.setIcon(icon);
        icon = this.readIcon(FileUtil.appendToFileName(defaultIconName, "_pressed"));
        if (icon != null) {
            this.setPressedIcon(icon);
        }
        if ((icon = this.readIcon(FileUtil.appendToFileName(defaultIconName, "_disabled"))) != null) {
            this.setDisabledIcon(icon);
        }
        if ((icon = this.readIcon(FileUtil.appendToFileName(defaultIconName, "_mouseover"))) != null) {
            this.setRolloverIcon(icon);
        }
    }

    public void setIconName(String iconName) {
        this.setIcons(iconName);
    }

    @Override
    public void setNextIcon(AnimatedIcon.AnimatedIconStage stage) {
        switch (stage.iconType) {
            case PRESSEDICON: {
                this.setPressedIcon(stage.icon);
                break;
            }
            case DISABLEDICON: {
                this.setDisabledIcon(stage.icon);
                break;
            }
            case SELECTEDICON: {
                this.setSelectedIcon(stage.icon);
                break;
            }
            case DISABLEDSELECTEDICON: {
                this.setDisabledSelectedIcon(stage.icon);
                break;
            }
            case ROLLOVERICON: {
                this.setRolloverIcon(stage.icon);
                break;
            }
            case ROLLOVERSELECTEDICON: {
                this.setRolloverSelectedIcon(stage.icon);
                break;
            }
            default: {
                this.setIcon(stage.icon);
            }
        }
    }
}

