/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.components;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.Timer;
import net.pms.swing.components.AnimatedIconCallback;
import net.pms.swing.components.JAnimatedButton;
import net.pms.swing.gui.JavaGui;

public class AnimatedIcon
implements Icon,
ActionListener {
    public static final float TOP = 0.0f;
    public static final float LEFT = 0.0f;
    public static final float CENTER = 0.5f;
    public static final float BOTTOM = 1.0f;
    public static final float RIGHT = 1.0f;
    private JComponent component;
    private final ArrayList<AnimatedIconFrame> frames = new ArrayList();
    private boolean running = false;
    private boolean repeat = false;
    private AnimatedIconStage nextStage = null;
    private AnimatedIconStage permanentStage = null;
    private float alignmentX = 0.5f;
    private float alignmentY = 0.5f;
    private int iconX;
    private int iconY;
    private int maxIconWidth;
    private int maxIconHeight;
    private int currentFrameIndex;
    private Timer timer;
    private Random random;

    private AnimatedIcon(JComponent component, AnimatedIconStage nextStage, boolean repeat, List<AnimatedIconFrame> frames) {
        this.component = component;
        this.repeat = repeat;
        this.nextStage = nextStage;
        if (nextStage != null && nextStage.permanent) {
            this.permanentStage = nextStage;
        }
        this.timer = new Timer(frames.get((int)0).lengthMS, this);
        this.timer.setRepeats(false);
        this.setFrames(frames);
    }

    public AnimatedIcon(JComponent component, boolean repeat, List<AnimatedIconFrame> frames) {
        this(component, null, repeat, frames);
    }

    public AnimatedIcon(JComponent component, AnimatedIconStage nextStage, List<AnimatedIconFrame> frames) {
        this(component, nextStage, false, frames);
    }

    private AnimatedIcon(JComponent component, AnimatedIconStage nextStage, boolean repeat, AnimatedIconFrame ... frames) {
        this.component = component;
        this.repeat = repeat;
        this.nextStage = nextStage;
        if (nextStage != null && nextStage.permanent) {
            this.permanentStage = nextStage;
        }
        this.timer = new Timer(frames[0].lengthMS, this);
        this.timer.setRepeats(false);
        this.setFrames(frames);
    }

    public AnimatedIcon(JComponent component, boolean repeat, AnimatedIconFrame ... frames) {
        this(component, null, repeat, frames);
    }

    public AnimatedIcon(JComponent component, AnimatedIconStage nextStage, AnimatedIconFrame ... frames) {
        this(component, nextStage, false, frames);
    }

    public AnimatedIcon(JComponent component, Icon icon) {
        this(component, false, AnimatedIcon.buildAnimation(icon));
    }

    public AnimatedIcon(JComponent component, String resourceName) {
        this(component, false, AnimatedIcon.buildAnimation(resourceName));
    }

    private void setFrames(List<AnimatedIconFrame> frames) {
        if (frames == null) {
            throw new NullPointerException("Frames cannot be null");
        }
        this.frames.clear();
        this.frames.ensureCapacity(frames.size());
        for (AnimatedIconFrame frame : frames) {
            if (frame == null) {
                throw new NullPointerException("A frame cannot be null");
            }
            if (frame.icon == null) {
                throw new NullPointerException("An icon cannot be null");
            }
            if (frame.lengthMS < 0) {
                throw new IllegalArgumentException("Length can't be negative");
            }
            if (frame.minLengthMS < 0) {
                throw new IllegalArgumentException("Minimum length can't be negative");
            }
            this.frames.add(frame);
        }
        this.calculateIconDimensions();
        this.setCurrentFrameIndex(0, true);
    }

    private void setFrames(AnimatedIconFrame ... frames) {
        if (frames == null) {
            throw new NullPointerException("Frames cannot be null");
        }
        this.frames.clear();
        this.frames.ensureCapacity(frames.length);
        for (AnimatedIconFrame frame : frames) {
            if (frame == null) {
                throw new NullPointerException("A frame cannot be null");
            }
            if (frame.icon == null) {
                throw new NullPointerException("An icon cannot be null");
            }
            if (frame.lengthMS < 0) {
                throw new IllegalArgumentException("Length can't be negative");
            }
            if (frame.minLengthMS < 0) {
                throw new IllegalArgumentException("Minimum length can't be negative");
            }
            this.frames.add(frame);
        }
        this.calculateIconDimensions();
        this.setCurrentFrameIndex(0, true);
    }

    public void setNextStage(AnimatedIconStage nextStage) {
        this.nextStage = nextStage;
        if (nextStage != null && nextStage.permanent) {
            this.permanentStage = nextStage;
        }
        if (!this.timer.isRunning()) {
            this.timer.restart();
        }
    }

    private void calculateIconDimensions() {
        this.maxIconWidth = 0;
        this.maxIconHeight = 0;
        for (AnimatedIconFrame frame : this.frames) {
            this.maxIconWidth = Math.max(this.maxIconWidth, frame.icon.getIconWidth());
            this.maxIconHeight = Math.max(this.maxIconHeight, frame.icon.getIconHeight());
        }
    }

    public float getAlignmentX() {
        return this.alignmentX;
    }

    public void setAlignmentX(float alignmentX) {
        this.alignmentX = alignmentX > 1.0f ? 1.0f : (alignmentX < 0.0f ? 0.0f : alignmentX);
    }

    public float getAlignmentY() {
        return this.alignmentY;
    }

    public void setAlignmentY(float alignmentY) {
        this.alignmentY = alignmentY > 1.0f ? 1.0f : (alignmentY < 0.0f ? 0.0f : alignmentY);
    }

    private void setCurrentFrameIndex(int index, boolean paint) {
        this.currentFrameIndex = index;
        AnimatedIconFrame frame = this.frames.get(this.currentFrameIndex);
        if (frame.random) {
            if (this.random == null) {
                this.random = new Random();
            }
            this.timer.setInitialDelay(frame.minLengthMS + this.random.nextInt(frame.lengthMS - frame.minLengthMS + 1));
        } else {
            this.timer.setInitialDelay(frame.lengthMS);
        }
        if (this.running) {
            this.timer.restart();
        }
        if (paint) {
            this.component.repaint(this.iconX, this.iconY, this.maxIconWidth, this.maxIconHeight);
        }
    }

    public void restart() {
        this.setCurrentFrameIndex(0, true);
        this.start();
    }

    public void restartArm() {
        this.setCurrentFrameIndex(0, false);
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.running = false;
    }

    public void pause() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    public void resume() {
        if (this.running && !this.timer.isRunning()) {
            this.timer.restart();
        }
    }

    public void reset() {
        this.running = false;
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.setCurrentFrameIndex(0, true);
    }

    @Override
    public int getIconWidth() {
        return this.maxIconWidth;
    }

    @Override
    public int getIconHeight() {
        return this.maxIconHeight;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        JAnimatedButton jAnimatedButton;
        if (c instanceof JAnimatedButton && (jAnimatedButton = (JAnimatedButton)c).getCurrentIcon() != this) {
            if (jAnimatedButton.getCurrentIcon() != null) {
                jAnimatedButton.getCurrentIcon().pause();
            }
            jAnimatedButton.setCurrentIcon(this);
            this.resume();
        }
        if (c == this.component) {
            this.iconX = x;
            this.iconY = y;
        }
        Icon icon = this.frames.get((int)this.currentFrameIndex).icon;
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        int offsetX = AnimatedIcon.getOffset(width, icon.getIconWidth(), this.alignmentX);
        int offsetY = AnimatedIcon.getOffset(height, icon.getIconHeight(), this.alignmentY);
        icon.paintIcon(c, g, x + offsetX, y + offsetY);
    }

    private static int getOffset(int maxValue, int iconValue, float alignment) {
        float offset = (float)(maxValue - iconValue) * alignment;
        return Math.round(offset);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int nextFrameIndex = this.getNextFrameIndex(this.currentFrameIndex);
        if (nextFrameIndex < 0 || nextFrameIndex == this.currentFrameIndex) {
            this.pause();
            if (this.nextStage != null) {
                JComponent jComponent = this.component;
                if (jComponent instanceof AnimatedIconCallback) {
                    AnimatedIconCallback animatedIconCallback = (AnimatedIconCallback)((Object)jComponent);
                    animatedIconCallback.setNextIcon(this.nextStage);
                }
                this.nextStage = this.permanentStage;
            }
        } else {
            this.setCurrentFrameIndex(nextFrameIndex, true);
        }
    }

    private int getNextFrameIndex(int currentIndex) {
        if (this.repeat && this.nextStage == null) {
            return ++currentIndex % this.frames.size();
        }
        if (currentIndex >= this.frames.size() - 1) {
            return -1;
        }
        return ++currentIndex;
    }

    public static AnimatedIconFrame[] buildAnimation(String resourceNamePattern, int firstIdx, int lastIdx, boolean returnToFirst, int durationFirst, int durationLast, int duration) {
        AnimatedIconFrame[] result = new AnimatedIconFrame[returnToFirst ? 2 * (lastIdx - firstIdx) : lastIdx - firstIdx + 1];
        int idx = firstIdx;
        for (int i = 0; i <= lastIdx - firstIdx; ++i) {
            ImageIcon icon = JavaGui.readImageIcon(String.format(Locale.ROOT, resourceNamePattern, idx));
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Resource \"%s\" not found, please check your pattern (%s) and indices (%d-%d)!", String.format(resourceNamePattern, idx), resourceNamePattern, firstIdx, lastIdx));
            }
            if (idx > firstIdx && idx < lastIdx) {
                AnimatedIconFrame frame;
                result[i] = frame = new AnimatedIconFrame(icon, duration);
                if (returnToFirst) {
                    result[2 * (lastIdx - firstIdx) - i] = frame;
                }
            } else {
                result[i] = idx == firstIdx ? new AnimatedIconFrame(icon, durationFirst) : new AnimatedIconFrame(icon, durationLast);
            }
            ++idx;
        }
        return result;
    }

    public static AnimatedIconFrame[] buildAnimation(Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("icon cannot be null!");
        }
        return new AnimatedIconFrame[]{new AnimatedIconFrame(icon, 0)};
    }

    public static AnimatedIconFrame[] buildAnimation(String resourceName) {
        ImageIcon icon = JavaGui.readImageIcon(resourceName);
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Resource \"%s\" not found!", resourceName));
        }
        return AnimatedIcon.buildAnimation(icon);
    }

    public static class AnimatedIconStage {
        public final AnimatedIconType iconType;
        public final AnimatedIcon icon;
        public final boolean permanent;

        public AnimatedIconStage(AnimatedIconType iconType, AnimatedIcon icon, boolean permanent) {
            this.iconType = iconType;
            this.icon = icon;
            this.permanent = permanent;
        }
    }

    public static class AnimatedIconFrame {
        public final Icon icon;
        public final int lengthMS;
        public final int minLengthMS;
        public final boolean random;

        public AnimatedIconFrame(Icon icon, int lengthMS) {
            this.icon = icon;
            this.lengthMS = lengthMS;
            this.random = false;
            this.minLengthMS = 0;
        }

        public AnimatedIconFrame(Icon icon, int minLengthMS, int maxLengthMS) {
            this.icon = icon;
            this.minLengthMS = minLengthMS;
            this.lengthMS = maxLengthMS;
            this.random = true;
        }
    }

    public static enum AnimatedIconType {
        DEFAULTICON,
        PRESSEDICON,
        DISABLEDICON,
        SELECTEDICON,
        DISABLEDSELECTEDICON,
        ROLLOVERICON,
        ROLLOVERSELECTEDICON;

    }
}

