/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.pms.Messages;

public class ProfileChooser {
    private ProfileChooser() {
    }

    public static void display() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(2);
        fc.setDialogTitle(Messages.getGuiString("UniversalMediaServerProfileChooser"));
        fc.setFileFilter(new ProfileChooserFileFilter());
        int returnVal = fc.showDialog(null, Messages.getGuiString("Select"));
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            System.setProperty("ums.profile.path", file.getAbsolutePath());
        }
    }

    private static class ProfileChooserFileFilter
    extends FileFilter {
        private ProfileChooserFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".conf");
        }

        @Override
        public String getDescription() {
            return Messages.getGuiString("ProfileFileOrFolder");
        }
    }
}

