/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing;

import com.sun.jna.Platform;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import net.pms.Messages;
import net.pms.configuration.Build;
import net.pms.configuration.UmsConfiguration;
import net.pms.external.update.AutoUpdater;
import net.pms.platform.PlatformUtils;
import net.pms.util.FileUtil;

public class AutoUpdateDialog
extends JDialog {
    private static final long serialVersionUID = 3809427933990495309L;
    private static AutoUpdateDialog instance;
    private final AutoUpdater autoUpdater;
    private final JLabel stateLabel = new JLabel();
    private final JLabel changelogLinkLabel = new ChangelogLinkLabel();
    private final JButton patreonDownloadButton;
    private final JButton freeDownloadButton;
    private final JButton cancelButton = new CancelButton();
    private final JProgressBar downloadProgressBar = new JProgressBar();

    public static synchronized void showIfNecessary(Window parent, AutoUpdater autoUpdater, boolean isStartup) {
        if (autoUpdater.isUpdateAvailable() || !isStartup) {
            if (instance == null) {
                instance = new AutoUpdateDialog(parent, autoUpdater);
            }
            instance.setVisible(true);
        }
    }

    AutoUpdateDialog(Window parent, AutoUpdater autoUpdater) {
        super(parent, Messages.getGuiString("UniversalMediaServerAutoUpdate"));
        this.autoUpdater = autoUpdater;
        this.patreonDownloadButton = new PatreonDownloadButton(autoUpdater);
        this.freeDownloadButton = new FreeDownloadButton(autoUpdater);
        this.stateLabel.setText(this.getStateText());
        AutoUpdater.addChangeListener(e -> {
            if (SwingUtilities.isEventDispatchThread()) {
                throw new RuntimeException("Work is probably happening on event thread. Bad.");
            }
            this.update();
        });
        this.initComponents();
        this.setMinimumSize(new Dimension(0, 160));
        this.setLocationRelativeTo(parent);
        this.update();
    }

    private void update() {
        SwingUtilities.invokeLater(this::updateOnGuiThread);
    }

    private void updateOnGuiThread() {
        AutoUpdater.State state = this.autoUpdater.getState();
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Must be on event thread");
        }
        this.stateLabel.setText(this.getStateText());
        this.freeDownloadButton.setEnabled(state == AutoUpdater.State.UPDATE_AVAILABLE);
        this.cancelButton.setEnabled(state == AutoUpdater.State.DOWNLOAD_IN_PROGRESS || state == AutoUpdater.State.UPDATE_AVAILABLE);
        this.updateCancelButton(state);
        if (state == AutoUpdater.State.DOWNLOAD_IN_PROGRESS) {
            this.downloadProgressBar.setEnabled(true);
            this.downloadProgressBar.setValue(Long.valueOf(this.autoUpdater.getBytesDownloaded()).intValue());
            this.downloadProgressBar.setMaximum(Long.valueOf(this.autoUpdater.getTotalBytes()).intValue());
        } else {
            this.downloadProgressBar.setEnabled(false);
            this.downloadProgressBar.setValue(0);
            this.downloadProgressBar.setMaximum(Integer.MAX_VALUE);
        }
    }

    private void updateCancelButton(AutoUpdater.State state) {
        switch (state) {
            case UPDATE_AVAILABLE: 
            case NO_UPDATE_AVAILABLE: 
            case ERROR: {
                this.cancelButton.setText(Messages.getGuiString("Close"));
                this.cancelButton.setEnabled(true);
                this.cancelButton.setVisible(true);
                break;
            }
            case DOWNLOAD_IN_PROGRESS: {
                this.cancelButton.setText(Messages.getGuiString("Cancel"));
                this.cancelButton.setEnabled(true);
                this.cancelButton.setVisible(true);
                break;
            }
            default: {
                this.cancelButton.setEnabled(false);
                this.cancelButton.setVisible(false);
            }
        }
    }

    private String getStateText() {
        switch (this.autoUpdater.getState()) {
            case NOTHING_KNOWN: {
                return Messages.getGuiString("CheckForUpdatesNotStarted");
            }
            case DOWNLOAD_FINISHED: {
                return Messages.getGuiString("DownloadFinished");
            }
            case DOWNLOAD_IN_PROGRESS: {
                return Messages.getGuiString("DownloadInProgress");
            }
            case ERROR: {
                return this.getErrorStateText();
            }
            case NO_UPDATE_AVAILABLE: {
                return Messages.getGuiString("NoUpdateAvailable");
            }
            case POLLING_SERVER: {
                return Messages.getGuiString("ConnectingToServer");
            }
            case UPDATE_AVAILABLE: {
                Object permissionsReminder = "";
                File file = new File(UmsConfiguration.getProfileDirectory());
                try {
                    if (!FileUtil.getFilePermissions(file).isWritable()) {
                        permissionsReminder = Messages.getGuiString("ButCantWriteProfileFolder");
                        if (Platform.isWindows()) {
                            permissionsReminder = (String)permissionsReminder + "<br>" + Messages.getGuiString("TryRunningAsAdministrator");
                        }
                        this.cancelButton.setText(Messages.getGuiString("Close"));
                        this.freeDownloadButton.setEnabled(false);
                        this.freeDownloadButton.setVisible(false);
                    }
                }
                catch (FileNotFoundException e) {
                    permissionsReminder = "\n" + String.format(Messages.getGuiString("XNotFound"), file.getAbsolutePath());
                    this.cancelButton.setText(Messages.getGuiString("Close"));
                    this.freeDownloadButton.setEnabled(false);
                    this.freeDownloadButton.setVisible(false);
                }
                return "<html><p>" + String.format(Messages.getGuiString("VersionXIsAvailable"), this.autoUpdater.getLatestVersionPatreon()) + "</p>" + (String)permissionsReminder + "<p>" + Messages.getGuiString("BuildsReleasedPatreonFirst") + "</p></html>";
            }
        }
        return Messages.getGuiString("UnknownState");
    }

    private String getErrorStateText() {
        if (this.autoUpdater == null) {
            return Messages.getGuiString("AutoUpdate.9");
        }
        Throwable exception = this.autoUpdater.getErrorStateCause();
        if (exception == null) {
            return Messages.getGuiString("Error");
        }
        String message = exception.getMessage();
        if (message == null) {
            return Messages.getGuiString("Error");
        }
        return message;
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.patreonDownloadButton, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.freeDownloadButton, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, 100, -2)).addComponent(this.stateLabel).addComponent(this.changelogLinkLabel).addComponent(this.downloadProgressBar, -1, 446, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.freeDownloadButton, this.patreonDownloadButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.stateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.changelogLinkLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downloadProgressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.patreonDownloadButton).addComponent(this.freeDownloadButton).addComponent(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private class ChangelogLinkLabel
    extends JLabel {
        ChangelogLinkLabel() {
            super(Messages.getGuiString("ClickHereSeeChangesRelease"));
            this.setForeground(Color.BLUE.darker());
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    PlatformUtils.INSTANCE.browseURI(Build.getReleasesPageUrl());
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    ChangelogLinkLabel.this.setText(String.format("<html><a href=''>%s</a></html>", Messages.getGuiString("ClickHereSeeChangesRelease")));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ChangelogLinkLabel.this.setText(Messages.getGuiString("ClickHereSeeChangesRelease"));
                }
            });
        }
    }

    private class CancelButton
    extends JButton {
        CancelButton() {
            super(Messages.getGuiString("NotNow"));
            this.setEnabled(true);
            this.setRequestFocusEnabled(false);
            this.addActionListener(e -> {
                switch (AutoUpdateDialog.this.autoUpdater.getState()) {
                    case UPDATE_AVAILABLE: 
                    case NO_UPDATE_AVAILABLE: 
                    case ERROR: {
                        AutoUpdateDialog.this.setVisible(false);
                        break;
                    }
                    case DOWNLOAD_IN_PROGRESS: {
                        AutoUpdateDialog.this.autoUpdater.cancelDownload();
                        break;
                    }
                }
            });
        }
    }

    private class PatreonDownloadButton
    extends JButton {
        PatreonDownloadButton(final AutoUpdater autoUpdater) {
            super("Patreon: " + String.valueOf(autoUpdater.getLatestVersionPatreon()));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    PlatformUtils.INSTANCE.browseURI(autoUpdater.getPatreonDownloadUrl());
                    AutoUpdateDialog.this.setVisible(false);
                }
            });
        }
    }

    private class FreeDownloadButton
    extends JButton {
        FreeDownloadButton(AutoUpdater autoUpdater) {
            super(Messages.getGuiString("Free") + ": " + String.valueOf(autoUpdater.getLatestVersion()));
            this.setEnabled(false);
            this.setRequestFocusEnabled(false);
            this.addActionListener(e -> {
                autoUpdater.getUpdateFromNetwork();
                autoUpdater.runUpdateAndExit();
            });
        }
    }
}

