/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.pms.PMS;
import net.pms.encoders.TranscodingSettings;
import net.pms.formats.v2.SubtitleType;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.renderers.Renderer;
import net.pms.store.ResumeObj;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.store.item.RealFile;
import net.pms.store.item.SevenZipEntry;
import net.pms.store.item.WebStream;
import net.pms.store.item.ZippedEntry;
import net.pms.util.FileUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOList
extends ArrayList<StoreResource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOList.class);
    public static final int PERMANENT = 1;
    public static final int AUTOSAVE = 2;
    public static final int AUTOREMOVE = 4;
    private static final long serialVersionUID = 8042924548275374060L;
    private final Renderer renderer;
    private final int mode;
    private File file;

    public IOList(Renderer renderer, String uri, int mode) {
        this.renderer = renderer;
        this.mode = mode;
        if (!org.apache.commons.lang3.StringUtils.isBlank(uri)) {
            this.file = new File(uri);
            this.load(this.file);
        } else {
            this.file = null;
        }
    }

    @Override
    public boolean add(StoreResource d) {
        super.add(d);
        if (this.isMode(2)) {
            this.save();
        }
        return true;
    }

    @Override
    public StoreResource remove(int index) {
        StoreResource d = (StoreResource)super.remove(index);
        if (this.isMode(2)) {
            this.save();
        }
        return d;
    }

    public boolean isMode(int m) {
        return (this.mode & m) == m;
    }

    public File getFile() {
        return this.file;
    }

    public final void load(File f) {
        if (f.exists()) {
            this.file = f;
            this.clear();
            try {
                this.read(this, f);
            }
            catch (IOException e) {
                LOGGER.debug("Error loading resource list '{}': {}", (Object)f, (Object)e);
            }
            if (PMS.getConfiguration().getSortMethod(f) == 5) {
                Collections.shuffle(this);
            }
        }
    }

    public void save() {
        if (this.file != null) {
            this.save(this.file);
        }
    }

    public void save(File f) {
        if (!this.isEmpty()) {
            try {
                IOList.write(this, f);
            }
            catch (IOException e) {
                LOGGER.debug("Error saving resource list to '{}': {}", (Object)f, (Object)e);
            }
        } else if (f != null && f.exists()) {
            f.delete();
        }
    }

    public static void write(List<StoreResource> playlist, File f) throws IOException {
        Date now = new Date();
        try (FileWriter out = new FileWriter(f);){
            StringBuilder sb = new StringBuilder();
            sb.append("######\n");
            sb.append("## __UPS__\n");
            sb.append("## NOTE!!!!!\n");
            sb.append("## This file is auto generated\n");
            sb.append("## Edit with EXTREME care\n");
            sb.append("## Generated: ");
            sb.append(now.toString());
            sb.append("\n");
            for (StoreResource r : playlist) {
                String data = r.write();
                if (org.apache.commons.lang3.StringUtils.isEmpty(data) || sb.indexOf(data) != -1) continue;
                String id = "internal:" + r.getClass().getName();
                sb.append("master:").append(id).append(';');
                if (r instanceof StoreItem) {
                    MediaSubtitle sub;
                    StoreItem item = (StoreItem)r;
                    if (item.isTranscoded()) {
                        sb.append("trancoding:").append(item.getTranscodingSettings().getId()).append(';');
                    }
                    if (item.isResume()) {
                        sb.append("resume");
                        sb.append(item.getResume().getResumeFile().getAbsolutePath());
                        sb.append(';');
                    }
                    if (item.getMediaSubtitle() != null && (sub = item.getMediaSubtitle()).getLang() != null && (sub.isExternal() && sub.getExternalFile() != null || sub.isEmbedded() && sub.getId() != -1)) {
                        sb.append("sub");
                        sb.append(sub.getLang());
                        sb.append(',');
                        if (sub.isExternal()) {
                            sb.append("file:");
                            sb.append(sub.getExternalFile().getPath());
                        } else {
                            sb.append("id:");
                            sb.append("").append(sub.getId());
                        }
                        sb.append(';');
                    }
                }
                sb.append(data);
                sb.append("\n");
            }
            out.write(sb.toString());
            out.flush();
        }
    }

    private StoreItem parse(String clazz, String data) {
        boolean error = false;
        if (clazz.contains("RealFile")) {
            if (data.contains(">")) {
                String[] tmp = data.split(">");
                return new RealFile(this.renderer, new File(tmp[1]), tmp[0]);
            }
            error = true;
        }
        if (clazz.contains("SevenZipEntry")) {
            if (data.contains(">")) {
                String[] tmp = data.split(">");
                long len = Long.parseLong(tmp[2]);
                return new SevenZipEntry(this.renderer, new File(tmp[1]), tmp[0], len);
            }
            error = true;
        }
        if (clazz.contains("ZippedEntry")) {
            if (data.contains(">")) {
                String[] tmp = data.split(">");
                long len = Long.parseLong(tmp[2]);
                return new ZippedEntry(this.renderer, new File(tmp[1]), tmp[0], len);
            }
            error = true;
        }
        if (clazz.contains("WebStream")) {
            if (data.contains(">")) {
                int type;
                String[] tmp = data.split(">");
                try {
                    type = Integer.parseInt(tmp[3]);
                }
                catch (NumberFormatException e) {
                    type = 8;
                }
                return new WebStream(this.renderer, tmp[0], tmp[1], tmp[2], type, null);
            }
            error = true;
        }
        if (error) {
            LOGGER.debug("Error parsing playlist resource:");
            LOGGER.debug("clazz: " + clazz);
            LOGGER.debug("data:" + data);
        }
        return null;
    }

    public void read(List<StoreResource> playlist, File f) throws IOException {
        if (!f.exists()) {
            return;
        }
        try (BufferedReader in = new BufferedReader(new FileReader(f));){
            String str;
            while ((str = in.readLine()) != null) {
                ResumeObj r;
                int pos;
                if (StringUtils.isEmpty(str) || str.startsWith("#") || !(str = str.trim()).startsWith("master:") || (pos = (str = str.substring(7)).indexOf(59)) == -1) continue;
                String master = str.substring(0, pos);
                str = str.substring(pos + 1);
                pos = str.indexOf(59);
                String subData = null;
                String resData = null;
                StoreItem res = null;
                TranscodingSettings transcodingSettings = null;
                while (pos != -1) {
                    if (str.startsWith("trancoding:")) {
                        transcodingSettings = TranscodingSettings.getTranscodingSettings(str.substring(7, pos));
                    }
                    if (str.startsWith("resume")) {
                        resData = str.substring(6, pos);
                    }
                    if (str.startsWith("sub")) {
                        subData = str.substring(3, pos);
                    }
                    str = str.substring(pos + 1);
                    pos = str.indexOf(59);
                }
                LOGGER.debug("master is " + master + " str " + str);
                if (master.startsWith("internal:")) {
                    res = this.parse(master.substring(9), str);
                } else {
                    LOGGER.warn("Unknown master parents: {}", (Object)master);
                }
                if (res == null) continue;
                if (resData != null && !(r = new ResumeObj(new File(resData))).isDone()) {
                    r.read();
                    res.setResume(r);
                }
                res.setTranscodingSettings(transcodingSettings);
                if (subData != null) {
                    MediaSubtitle s = res.getMediaSubtitle();
                    if (s == null) {
                        s = new MediaSubtitle();
                        res.setMediaSubtitle(s);
                    }
                    String[] tmp = subData.split(",");
                    s.setLang(tmp[0]);
                    subData = tmp[1];
                    if (subData.startsWith("file:")) {
                        String sFile = subData.substring(5);
                        s.setExternalFile(new File(sFile));
                        SubtitleType t = SubtitleType.valueOfFileExtension(FileUtil.getExtension(sFile));
                        s.setType(t);
                    } else if (subData.startsWith("id:")) {
                        s.setId(Integer.parseInt(subData.substring(3)));
                    }
                }
                playlist.add(res);
            }
        }
    }
}

